unit UDVBHardware;
{*****************************************************************************
* WinSTB Generic DVB Driver API.                                             *
* Copyright (c) Epmak                                                        *
*                                                                            *
* Usage of this code have following rules:                                   *
* 1) Only OpenSource DVB-Viewers can use that API                            *
* 2) You can not use that API for creation of any kind of API-Wrapper that   *
*    may be used by closed source software.                                  *
* 3) There is no restrictions for DVB-Driver. It may be closed source or not.*
*****************************************************************************}

interface

uses Windows, SysUtils, Messages, UMDAPI, DirectShow9;

{g.290603#1...}
var   CurrentChannelISScrambled:boolean=FALSE;
{...g.290603#1}
{g.todo->move this to UTuner|CurrentChannelData-Record!!!}


{g.081203#1...}
const CDCBBuffer_Size:longint=512*188;       //if dyn: (Max_Packets+1)*Packet_Size
var      CDCBBuffer_Max_Packets:integer=256;    //if dyn: 512 max
const//      CDCBBuffer_Max_Packets:integer=1;
      BufferedScan:boolean=FALSE;

var   APP_THREAD_PRIORITY:integer;

//      CDCB_THREAD_PRIORITY:integer=THREAD_PRIORITY_IDLE;
//      CDCB_THREAD_PRIORITY:integer=THREAD_PRIORITY_LOWEST;
//      CDCB_THREAD_PRIORITY:integer=THREAD_PRIORITY_BELOW_NORMAL;
//      CDCB_THREAD_PRIORITY:integer=THREAD_PRIORITY_NORMAL;
//      CDCB_THREAD_PRIORITY:integer=THREAD_PRIORITY_ABOVE_NORMAL;
      CDCB_THREAD_PRIORITY:integer=THREAD_PRIORITY_HIGHEST;
//      CDCB_THREAD_PRIORITY:integer=THREAD_PRIORITY_ERROR_RETURN;
//      CDCB_THREAD_PRIORITY:integer=THREAD_PRIORITY_TIME_CRITICAL;

//      CDCB_SCAN_THREAD_PRIORITY:integer=THREAD_PRIORITY_IDLE;
//      CDCB_SCAN_THREAD_PRIORITY:integer=THREAD_PRIORITY_LOWEST;
//      CDCB_SCAN_THREAD_PRIORITY:integer=THREAD_PRIORITY_BELOW_NORMAL;
//      CDCB_SCAN_THREAD_PRIORITY:integer=THREAD_PRIORITY_NORMAL;
//      CDCB_SCAN_THREAD_PRIORITY:integer=THREAD_PRIORITY_ABOVE_NORMAL;
      CDCB_SCAN_THREAD_PRIORITY:integer=THREAD_PRIORITY_HIGHEST;
//      CDCB_SCAN_THREAD_PRIORITY:integer=THREAD_PRIORITY_ERROR_RETURN;
//      CDCB_SCAN_THREAD_PRIORITY:integer=THREAD_PRIORITY_TIME_CRITICAL;

{...g.081203#1}


const WINSTB_SOUND_ON=1;
      WINSTB_SOUND_OFF=0;

{g.081203#1...}
      WINSTB_FREQUENCY_LOCKED=1;
      WINSTB_FREQUENCY_NOT_LOCKED=0;
{...g.081203#1}

      WINSTB_HARDWARE_STARTED=1;
      WINSTB_HARDWARE_NOT_STARTED=0;

      WINSTB_PACKET_STYLE_SS1=1;
      WINSTB_PACKET_STYLE_RAW=0;

      WINSTB_HARDWARE_TVOUT_PRESENT=1;
      WINSTB_HARDWARE_TVOUT_NOT_PRESENT=0;

{g.081203#1...}
      WINSTB_WINDOW_WINDOWED=0;
{...g.081203#1}
      WINSTB_WINDOW_FULLSCREEN=1;
      WINSTB_WINDOW_MINIMIZED=2;

{g.081203#1...}
      WINSTB_RECORDING_STARTED=1;
      WINSTB_RECORDING_NOT_STARTED=0;
{...g.081203#1}

      WINSTB_SKIP_DIRECTSHOW_OUTPUT=1;
      WINSTB_PROCESS_DIRECTSHOW_OUTPUT=0;

{g.281203#1...}
      WINSTB_DS_HANDLED_BY_HARDWARE=2;
{...g.281203#1}
      WINSTB_DS_HANDLED_BY_DRIVER=1;
      WINSTB_DS_HANDLED_BY_WINSTB=0;


type  TMDAPIFilterProc=procedure(hFilter:DWORD;Len:Cardinal;Buf:PByteArray); cdecl;
      TMDPluginProcessMessageProc=function(var msg:TMessage):DWORD; stdcall;

      //Budget DVBCard API
      TFillDVBHardwareInfoProc=procedure(DVBHardware:PByte); stdcall;
      TDVBInitProc=function:DWORD; stdcall;
      TDVBExitProc=function:DWORD; stdcall;
      TAddFilterProc=function(wPID: WORD; FilterProc:TMDAPIFilterProc;Name:PChar=nil):DWORD; stdcall;
{d.310803#1...}
      TAddFilter2Proc=function(wPID:WORD;index:DWORD):DWORD; stdcall;
{...d.310803#1}
      TDelFilterProc=function(wHandle:DWORD):DWORD; stdcall;
      TGetSignalLevelAndQuality=function(Locked:PByte;Signal:PByte;Quality:PByte;AGC:PByte;SNR_SQE:PByte):DWORD; stdcall;  //1-Locked,0-Not locked
      TSetDISEQC=function(Source,Polarisation:PChar;Frequency,SymbolRate:DWORD):DWORD; stdcall;
      TSetChannel=function(prg:PProgramm82):DWORD; stdcall;
{d.310803#2...}
      TSetChannel2=function(VPID,APID,AC3,PMT,ECM,PCR:integer):DWORD; stdcall;
      TSetVideoLanChain=function(InPin:IPin):IPin;
      TInitVideoLanChain=procedure;
{...d.310803#2}
      TStartRecordingProc=function(FileName:PChar):DWORD; stdcall;
      TStopRecordingProc=function:DWORD; stdcall;
      TSendDataToDirectShow=procedure(buf:PAnsiChar;len_in:integer); cdecl;
      TStopDirectShow=procedure; cdecl;
      TGetMenu=function:PChar; stdcall;

      //Premium DVBCard API
      TProcessKeyByName=procedure(Key:PAnsiChar); cdecl;
      TSetVolumeProc=function(Volume:byte):DWORD; stdcall;
      TGetParameterProc=function(SectionName:PChar;ItemName:PChar;DefaultValue:PChar):PChar; stdcall;
      TSetAudioVolume=function(LeftVolume,RightVolume:byte):DWORD; stdcall;
      TSetMute=function(Mute:byte):DWORD; stdcall; //1-sound,0-no sound
      TInitVideoWindow=function:DWORD; stdcall;
      TShowHWWindow=function(FullScreen:byte;Width,Heigth:WORD):DWORD; stdcall;
      TCloseHWWindow=function:DWORD; stdcall;
      TMSGWMWINDOWPOSCHANGING=function(var Msg:TWMWINDOWPOSCHANGING):DWORD; stdcall;
      TMSGWinMove=function(var Msg:TWMMove;Width,Heigth:WORD):DWORD; stdcall;
      TMSGFormResize=function(Width,Heigth:WORD):DWORD; stdcall;

      //SS1-style Premium Card OSD suport
      TDVBOSDTTCreateWindow=function(windownr:BYTE;DisplayType:DWORD;width,height:DWORD):DWORD; stdcall;
      TDVBOSDTTDestroyWindow=function(windownr:BYTE):DWORD; stdcall;
      TDVBOSDTTResetBlend=function(windownr:BYTE):DWORD; stdcall;
      TDVBOSDTTSetColorBlend=function(windownr:BYTE):DWORD; stdcall;
      TDVBOSDTTSetWindowBlend=function(windownr,blending:BYTE):DWORD; stdcall;
      TDVBOSDTTSetBlend=function(windownr:BYTE;colordepth,index:DWORD;blending:BYTE):DWORD; stdcall;
      TDVBOSDTTSetColor=function(windownr:BYTE;colordepth:DWORD;index,colorHi,colorLo:WORD):DWORD; stdcall;
      TDVBOSDTTBringToTop=function(windownr:BYTE):DWORD; stdcall;
      TDVBOSDTTSetFont=function(windownr,fontsize:BYTE;colorFG,colorBG:WORD):DWORD; stdcall;
      TDVBOSDTTWriteText=function(windownr:BYTE;X,Y:WORD;length:BYTE;cText:pchar):DWORD; stdcall;
      TDVBOSDTTHideWindow=function(windownr:BYTE):DWORD; stdcall;
      TDVBOSDTTMoveWindowRel=function(windownr:BYTE;X,Y:WORD):DWORD; stdcall;
      TDVBOSDTTMoveWindowAbs=function(windownr:BYTE;X,Y:WORD):DWORD; stdcall;
      TDVBOSDTTSetWindowTrans=function(windownr:BYTE;trans:WORD):DWORD; stdcall;
      TDVBOSDTTDrawLine=function(windownr:BYTE;X,Y,dx,dy,colornr:WORD):DWORD; stdcall;
      TDVBOSDTTDrawBlock=function(windownr:BYTE;X,Y,dx,dy,colornr:WORD):DWORD; stdcall;

      TTempDVBEPG=function(Cmd:DWORD;EPGProc:Pointer;wSID:WORD=0;wNetID:WORD=0;dwBeginTime:DWORD=0;dwEndTime:DWORD=$FFFFFFFF):DWORD; stdcall;
      TTempDVBParams=function(TP_Info:Pointer;Options:DWORD):DWORD; stdcall;
      TTempDVBFilePlayback=function(FilePlayback:Pointer;FileName:PChar;Options:DWORD):DWORD; stdcall;
      TDVBFilePlayback=function(filename:PChar;Cmd:BYTE):DWORD; stdcall;


      TDVBHardware=packed record
        //Following fields are required for any DVBCard
        HeaderVersion:byte;
        Started:byte;                 //1-Started, 0-Not Started
        DVBPacketStyle:byte;          //0-Full Info, 1-SS1 style
        DVBPacketLegth:byte;          //188-Full packet, 184-SS1 style
        HardwareTVOutType:byte;       //0-Not present, 1-SS1 style
        FullScreen:byte;              //1-Fullscreen, 0-window
        RecordStarted:byte;           //0-Not started 1-Started
        SkipDS:byte;                  //0-Not skip DirectShow 1-otherwise
        InternalDSHandling:byte;      //0-DS Handled by UDSAPI 1-otherwise
        PacketCountInCallback:byte;   //5 for SS1, 1 - otherwise

        SoftVideoWindows:IVideoWindow;
        SoftVideoPanelHandle:HWND;
        SoftVideoWindowHandle:HWND;
        HardwareVideoWideoHandle:HWND;

        DVBInit:TDVBInitProc;
        DVBExit:TDVBExitProc;

        InitVideoWindow:TInitVideoWindow;

        AddFilter:TAddFilterProc;
        DelFilter:TDelFilterProc;

        SendDataToDirectShow:TSendDataToDirectShow;
        StopDirectShow:TStopDirectShow;

        StartRecording:TStartRecordingProc;
        StopRecording:TStopRecordingProc;

        SetDISEQC:TSetDISEQC;
        SetChannel:TSetChannel;

{d.310803#4...}
        AddFilter2:TAddFilter2Proc;
        SetChannel2:TSetChannel2;
        SetVideoLanChain:TSetVideoLanChain;
        InitVideoLanChain:TInitVideoLanChain;
        VideoLanNoOfChannels:integer;
{...d.310803#4}

        MDPluginProcessMessage:TMDPluginProcessMessageProc;

        GetSignalLevelAndQuality:TGetSignalLevelAndQuality;

        ProcessKeyByName:TProcessKeyByName;

        //Not required parameters
        PTPInfo:PByteArray;
        GetParameter:TGetParameterProc;
        GetMenu:TGetMenu;
        SetAudioVolume:TSetAudioVolume;
        SetMute:TSetMute;
        ShowHWWindow:TShowHWWindow;
        CloseHWWindow:TCloseHWWindow;
        MSGWMWINDOWPOSCHANGING:TMSGWMWINDOWPOSCHANGING;
        MSGWinMove:TMSGWinMove;
        MSGFormResize:TMSGFormResize;
        DVBOSDTTCreateWindow:TDVBOSDTTCreateWindow;
        DVBOSDTTDestroyWindow:TDVBOSDTTDestroyWindow;
        DVBOSDTTResetBlend:TDVBOSDTTResetBlend;
        DVBOSDTTSetColorBlend:TDVBOSDTTSetColorBlend;
        DVBOSDTTSetWindowBlend:TDVBOSDTTSetWindowBlend;
        DVBOSDTTSetBlend:TDVBOSDTTSetBlend;
        DVBOSDTTSetColor:TDVBOSDTTSetColor;
        DVBOSDTTBringToTop:TDVBOSDTTBringToTop;
        DVBOSDTTSetFont:TDVBOSDTTSetFont;
        DVBOSDTTWriteText:TDVBOSDTTWriteText;
        DVBOSDTTHideWindow:TDVBOSDTTHideWindow;
        DVBOSDTTMoveWindowRel:TDVBOSDTTMoveWindowRel;
        DVBOSDTTMoveWindowAbs:TDVBOSDTTMoveWindowAbs;
        DVBOSDTTSetWindowTrans:TDVBOSDTTSetWindowTrans;
        DVBOSDTTDrawLine:TDVBOSDTTDrawLine;
        DVBOSDTTDrawBlock:TDVBOSDTTDrawBlock;

//SS1-DVBCore to be removed:
    TempDVBEPG:TTempDVBEPG;
    TempDVBParams:TTempDVBParams;
    DVBFilePlayback:TDVBFilePlayback;
//

      end;
      PDVBHardware=^TDVBHardware;


implementation

end.
