{*********************************************************************************
 *                                                                               *
 * WinSTB                                                                        *
 *                                                                               *
 * Copyright (C) 2002-2003 Epmak & bisswanger                                    *
 *                                                                               *
 *                                                                               *
 * This program is free software; you can redistribute it and/or                 *
 * modify it under the terms of the GNU General Public License                   *
 * as published by the Free Software Foundation; either version 2                *
 * of the License, or (at your option) any later version.                        *
 *                                                                               *
 *                                                                               *
 * This program is distributed in the hope that it will be useful,               *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
 * GNU General Public License for more details.                                  *
 *                                                                               *
 *                                                                               *
 * You should have received a copy of the GNU General Public License             *
 * along with this program; if not, write to the Free Software                   *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.    *
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html                *
 *                                                                               *
 *                                                                               *
 * The author can be reached at WinSTB@hotmail.com                               *
 * Homepage: http://www.winstb.de                                                *
 *********************************************************************************}
unit UMDAPI;

interface

uses Windows, SysUtils;

const
// MD 8.2 Commands
  MDAPI_GET_TRANSPONDER       = $01020000;
  MDAPI_SET_TRANSPONDER       = $01020001;
  MDAPI_GET_PROGRAMM          = $01020010;
  MDAPI_SET_PROGRAMM          = $01020011;
  MDAPI_RESCAN_PROGRAMM       = $01020012;
  MDAPI_SAVE_PROGRAMM         = $01020013;
  MDAPI_GET_PROGRAMM_NUMMER   = $01020014;
  MDAPI_SET_PROGRAMM_NUMMER   = $01020015;
  MDAPI_START_FILTER          = $01020020;
  MDAPI_STOP_FILTER           = $01020021;
  MDAPI_SCAN_CURRENT_TP       = $01020030;
  MDAPI_SCAN_CURRENT_CAT      = $01020031;
  MDAPI_START_OSD             = $01020040;
  MDAPI_OSD_DRAWBLOCK         = $01020041;
  MDAPI_OSD_SETFONT           = $01020042;
  MDAPI_OSD_TEXT              = $01020043;
  MDAPI_SEND_OSD_KEY          = $01020044;
  MDAPI_STOP_OSD              = $01020049;
  MDAPI_DVB_COMMAND           = $01020060;
  MDAPI_GET_VERSION           = $01020100;
  MDAPI_GET_SIGNAL_INFO       = $01020061;

// ProgDVB commands
  PROGAPI_GET_SIGNAL_LEVEL    = $01022001;
  PROGAPI_SEND_DISEQC         = $01022002;
  PROGAPI_GET_CHANNEL_NAME    = $01022003;
  PROGAPI_SET_CHANNEL         = $01022004;
  PROGAPI_SET_TRANSPONDER     = $01022005;

// MD API 8.2
  MAX_CA_SYSTEMS=32;
  MAX_PID_IDS=32;

// WatchTVPro API
  WTVP_CHANNELS_COUNT			    = $01021000;
  WTVP_GET_VOLUME	     			  = $01021010;
  WTVP_SET_VOLUME				      = $01021011;
  WTVP_SEND_DISEQC			      = $01021015;
  WTVP_MOVE_OSD				        = $01021020;
  WTVP_READ_REGISTRY			    = $01021046;
  WTVP_WRITE_REGISTRY			    = $01021045;
  WTVP_GET_TIMERRECORD	 	    = $01021050;
  WTVP_SET_TIMERRECORD		    = $01021055;
  WTVP_SET_OSD_SURFACE		    = $01021065;
  WTVP_FILE_PLAYBACK			    = $01021070;
  WTVP_OSD_LOADBMP			      = $01021080;
  WTVP_SET_OSD_COLOR			    = $01021090;
  WTVP_OSD_OFF				        = $01021030;
  WTVP_OSD_ON					        = $01021035;

type
// MD API DataTypes
  TProgramNumberParam = record
    RealNumber: Integer;
    VirtNumber: Integer;
  end;
  PProgramNumberParam=^TProgramNumberParam;

  TStartFilterParam = record
    DLL_ID: Word;
    Filter_ID: Word;
    Pid: Word;
    Name: Array[0..32-1] of Byte;
    Irq_Call_Adresse: LongInt;
    Running_ID: Integer;
  end;
  PStartFilterParam=^TStartFilterParam;

  TTPCat = record
    TAG: Byte;
    DesLen: Byte;
    CA_ID: Word;
    EMM: Word;
    BufferLen: Word;
    Buffer: Array[0..64-1] of Byte;
  end;

  TTPCatio = record
    TPCatAnzahl: Integer;
    TPCat: Array[0..8-1] of TTPCAT;
  end;
  PCAT=^TTPCatio;

  TPIDFilters = record
    FilterName: Array[0..5-1] of Char;
    FilterId: Byte;
    PID: Word;
  end;

  TOSD_START = record
    DLL_Id:DWord;
    BitTiefe:byte;
    x1:DWord;
    y1:DWord;
    x2:DWord;
    y2:DWord;
		Input:DWord;
  end;
  POSD_START=^TOSD_START;

  TOSD_DRAW = record
	  x:Word;
	  y:Word;
	  Sizex:Word;
	  Sizey:Word;
    Color:Word;
  end;
  POSD_DRAW=^TOSD_DRAW;

  TOSD_SETFONT = record
	  Typ:Word;
	  Fg_Color:Word;
	  Bg_Color:Word;
  end;
  POSD_SETFONT=^TOSD_SETFONT;

  TOSD_SETTEXT = record
    x:Word;
    y:Word;
	  Zeile:Array[0..128-1] of byte;
  end;
  POSD_SETTEXT=^TOSD_SETTEXT;

  TOSD_MOVE=record
	  x:DWord;
	  y:DWord;
  end;
  POSD_MOVE=^TOSD_MOVE;

  TCA_System82 = record
    CA_Typ:Word;
    ECM:Word;
    EMM:Word;
    Provider_Id:DWord;
  end;

  TProgramm82 = record
    Name: Array[00..29] of char;
    Anbieter:Array[00..29] of char;
    Land:Array[00..29] of char;
    freq: DWord;
    Typ: Byte;
    volt: Byte;
    afc: Byte;
    diseqc: Byte;
    srate:Word;
    qam: Word;
    fec: Word;
    norm: Byte;
    tp_id: Word;
    Video_pid: Word;
    Audio_pid: Word;
    TeleText_pid:Word;
    PMT_pid:Word;
    PCR_pid:Word;
    ECM_PID:Word;
    SID_pid:Word;
    AC3_pid:Word;
    TVType: Byte;
    ServiceTyp: Byte;
    CA_ID: Byte;
    Temp_Audio:Word;
    Filteranzahl:Word;
    Filters: Array[00..(MAX_PID_IDS-1)] of TPIDFilters;
    CA_Anzahl:Word;
    CA_System82:array[0..(MAX_CA_SYSTEMS-1)] of TCA_System82;
    CA_Land:Array[0..5] of char;
    Merker:Byte;
    Link_TP:Word;
    Link_SID:Word;
    Dynamisch:Byte;
    Extern_Buffer:array[00..15] of char ;
  end;
  PProgramm82=^TProgramm82;

  TDVB_COMMAND = record
    Cmd_laenge: Word;
    Cmd_Buffer: Array[0..32-1] of Byte;
  end;
  PDVB_COMMAND=^TDVB_COMMAND;

  TSIGNAL_INFO = record
    SignalLevel: Integer;
    SignalError: Integer;
  end;
  PTSIGNAL_INFO=^TSIGNAL_INFO;
  
// MD API functions
  TMDAPIGetPluginName = procedure(Buf: PByteArray); cdecl;
  TMDAPIProcessPluginMenuCommandProc = procedure( MenuID:integer );cdecl;
  TMDAPIProcessChannelChange=procedure(prg: TProgramm82); cdecl;
  TMDAPIInitPluginProc = procedure(MDInstance: LongWord; MDWnd: HWND;
        Log_Set: Bool; DLL_ID: Integer; HotKey: PChar;  Vers: PChar;
        var ReturnValue: Integer); cdecl;
  TMDAPIExitPluginProc = procedure(MDInstance: LongWord; MDWnd: HWND;
        Log_Set: Bool); cdecl;
  TMDAPIProcessHotKeyProc=procedure; cdecl;
  TMDAPIFilterProc=procedure( hFilter: DWORD; Len: Cardinal; Buf: PByteArray); cdecl;
  TMDAPIFilterCloseProc = procedure(MDInstance: LongWord); cdecl;
  TMDAPIProcessRecPlayProc = procedure(Mode:Integer); cdecl;
// ProgDVB types
  TProgAPIGetChannelName=record
    dwSize:DWORD;
    dwSID:DWORD;
    dwTID:DWORD; // in (if =0 so curretnt TID)
    dwSatPosition:DWORD ; // in (if =0 so current SatPosition)
    ChannelName:array [0..32-1] of byte; //out
    ProviderName:array [0..32-1] of byte; //out
    ChannelCaption: array [0..128-1] of byte; //out
  end;
  PProgAPIGetChannelName=^TProgAPIGetChannelName;

  TProgAPIDiSEqCmd=packed record
    dwSize:DWORD;
    dwResult:DWORD;
    dwCmdLength:DWORD;
    Cmd:array[0..15] of byte;
  end;
  PProgAPIDiSEqCmd=^TProgAPIDiSEqCmd;

  TProgAPISignalState=record
    dwSize:DWORD;
    dwQuality:DWORD;
    dwLevel:DWORD;
  end;
  PProgAPISignalState=^TProgAPISignalState;


implementation

end.
