//////////////////////////////////////
// StreamReader API 2.71
// 
// Copyright (c) 2001,2002 by DVinGena
//////////////////////////////////////
//
// Usage:
//	call CheckForDVB
//	call StartDVB
//	then call other functions
//	If you call any function other than CheckForDVB() before StartDVB() they will return false.
//
// You have to care that DelFilter is called.
// Please use the functions in the proper order. Since there are no checks inside, it could esealy crash.
//
// You have to call the function is this order:
// CheckForDVB->StartDVB->SendDiSEqC->SetChannel->Set(Pid)Filter->DelFilter
// You can leave for example SenDiSEqC out, if you don't need it..
//
// Der folgende ifdef-Block zeigt die Standardlsung zur Erstellung von Makros, die das Exportieren 
// aus einer DLL vereinfachen. STREAMREADER_EXPORTS, dieses Symbol sollte fr kein Projekt definiert werden, das
// diese DLL verwendet. Auf diese Weise betrachtet jedes andere Projekt, dessen Quellcodedateien diese Datei 
// einbeziehen, STREAMREADER_API-Funktionen als aus einer DLL importiert.

#ifdef STREAMREADER_EXPORTS
#define STREAMREADER_API
#else
#define STREAMREADER_API __declspec(dllimport)
#endif

// Viterbi rate (DVB-S) indication
typedef enum VITERBIRATE_TYPE
{
	VR_AUTO  =  0,				// DVB-S: automtic detection of viterbi rate
	VR_1_2	 =  1,				// DVB-S: viterbi rate: 1/2
	VR_2_3	 =  2,				// DVB-S: viterbi rate: 2/3
	VR_3_4	 =  3,				// DVB-S: viterbi rate: 3/4
	VR_4_5	 =  4,				// DVB-S: viterbi rate: 4/5
	VR_5_6	 =  5,				// DVB-S: viterbi rate: 5/6
	VR_6_7	 =  6,				// DVB-S: viterbi rate: 6/7
	VR_7_8	 =  7,				// DVB-S: viterbi rate: 7/8
	VR_8_9	 =  8,				// DVB-S: viterbi rate: 8/9
}VITERBIRATE_TYPE;


// DiSEqC commands
#define DISEQC_HIGH_NIBLE	0xF0
#define DISEQC_LOW_BAND		0x00
#define DISEQC_HIGH_BAND	0x01
#define DISEQC_VERTICAL		0x00
#define DISEQC_HORIZONTAL	0x02
#define DISEQC_POSITION_A	0x00
#define DISEQC_POSITION_B	0x04
#define DISEQC_OPTION_A		0x00
#define DISEQC_OPTION_B		0x08

typedef void (__fastcall *FASTCALL_DVBCALLBACK)(BYTE*,int); //BYTE* data, int length
typedef void (__stdcall  *STDCALL_DVBCALLBACK)(BYTE*,int);
typedef void (__fastcall *FASTCALL_DVBCALLBACK_EX)(BYTE*,int,int); //BYTE* data, int length, int PID
typedef void (__stdcall  *STDCALL_DVBCALLBACK_EX)(BYTE*,int,int); //BYTE* data, int length, int PID

// Checks if the TechnoTrend or other compatible drivers based on the reference drivers are installed
// Return value:	true = supported driver found
//					false = no driver found
STREAMREADER_API BOOL CheckForDVB();


// Loads the TT-server by loading additional dll's and drivers. Then it sets up the DVB card
// Return value:	true = everything loaded & card is no ready to perform tasks
//					false = card could not be successfully initalized
STREAMREADER_API BOOL StartDVB();

// Shuts down the TT-DVB-Server regardless of how many other applications use the server!!!
// If you call this function, the server is gone..(you can restart it by calling StartDVB again)
//
// Return value:	true = the server was shut down
//					false = the server could not be shut down
STREAMREADER_API BOOL StopDVB();

// Send a DiSEqC Message to your satellite equipment
// Parameters:	DiSEqCTpye: Desired action
//							0: None, disable DiSEqC
//							1: Simple, send tone burst only
//							2: Version 1.0, multi, send DiSEqC-Sequence
//				data:	for DiSEqCType=0:
//							ignored, please pass NULL
//						for DiSEqCType=1:
//							for position A pass 0
//							for position B pass 1
//						for DiSEqCType=2:
//							compose data as followed:
//							data=DISEQC_HIGH_NIBLE
//							then combine data with an bitwise or ( | ) with one of each of the following constants
//							DISEQC_VERTICAL, DISEQC_HORIZONTAL
//							DISEQC_HIGH_BAND, DISEQC_LOW_BAND
//							DISEQC_POSITION_B, DISEQC_POSITION_A
//							DISEQC_OPTION_B, DISEQC_OPTION_A
//
// Return value:	true = everything was sent
//					false = the DiSEqC commands could not be sent
//
// Example: SendDiSEqC(2,DISEQC_HIGH_NIBBLE|DISEQC_VERTICAL|DISEQC_HIGH_BAND|DISEQC_POSITION_B|DISEQC_OPTION_A);
STREAMREADER_API BOOL SendDiSEqC(DWORD DiSEqCType,BYTE data);

// Sets the card's tuner to desired values. Sets a channel.
// Parameters:	freq: Desired frequency in kHz
//				symb: Symbolrate of channel in Symbols/sec
//				pol: 0 = horz, 1 = vert
//				fec: viterbi rate, look above for details. Use the numbers of "VITERBIRATE_TYPE"
//				lof1: first LNB local oscillator frequency in kHz. normally 9750000.
//				lof2: second LOF in kHz. normally 10600000.
//				lofsw: the frequency (in kHz) when to switch between the two lofs. normally 11700000. You have to pass valid values for lof1,lof2&lofsw although you might know what is used!
// 
// Return value:	true = channel selected, carrier found and locked. now you can set the filter
//					false = could not find a signal with the given parameters. Perhaps wrong numbers..
//
// Example: SetChannel(12669000,22000000,1,0,9750000,10600000,11700000);  that's "VIVA" on Astra
STREAMREADER_API BOOL SetChannel(DWORD freq, DWORD smyb, DWORD pol, DWORD fec, DWORD lof1, DWORD lof2, DWORD lofsw);


// Create a filter for a PID-Stream. The given Callback-function is called when new data has arrived.
// Parameters:	pid: create the filter for this pid
//				lpFunc: the address of your callback function
//				CallBackType:	0x01 = lpFunc points to a function that is declared as fastcall (first 2 params. are passed in registers)
//								0x02 = lpFunc points to a function that is declared as stdcall (params. via stack)
//								0x04 = lpFunc points to a function that is declared as cdecl
//						>>>> USE THIS PARAMETER WITH CAUTION ! If your function and this value doesn't match it could cause Bluescreens...<<<<
//				size:	how big the data packets passed to the callback function should be 
//						1: this is the smallest unit. It returns every single TS-Packet
//						2: this returns blocks of 4K Bytes (don't thrust in this value!!! can change...)
//				lpfilter_num: points to a DWORD that recieves the filter number. This value is used for all operations on this filter i.e. DelFiter
//
// Note:	the callback-function must look like this:
//
//			void __stdcall YourCallBack(BYTE *Buff, int len)    // or __fastcall if you need it
//			{
//				do your stuff here...;
//			}
//
//			when this function is called then there are len bytes at Buff
//
// Return value:	true = filter & socket successfully set, and lpFunc will be called on data arrival
//					false = either filter or socket could not be created
//
// Example: SetFilter(17,&YourCallBack,2,2,&filter_num);  the "&" is important, if you don't write it, it'll make you mad!
//         Sets a filter for pid 17 using YourCallBack-function which is stdcall and you want 4k-blocks
STREAMREADER_API BOOL SetFilter(WORD pid,void* lpFunc, DWORD CallBackType, DWORD size, DWORD *lpfilter_num);

//The same als SetFilter, with one exception: it uses a FASTCALL_DVBCALLBACK_EX
// works only on WDM
STREAMREADER_API BOOL SetFilterEx(WORD pid,void* lpFunc, DWORD CallBackType, DWORD size, DWORD *lpfilter_num);

// Creates a filter where you can specify the filter data. It it similar to SetFilter
// Parameters:	pid: create the filter fo this pid
//				FilterData: Data to filter, starting on the section headers
//				FilterMask: Mask to the filter data. Filter bit is valid where the corresponding mask bit is set to 1
//				FilterLength: Valid length of the filter data and mask
//				lpFunc: address of callback function. Refer to SetFilter for nearer description
//				lpfilter_num: points to a DWORD that recieves the filter number. This value is used for all operations on this filter i.e. DelFiter
//
// Note: use a __stdcall function
//
// Return value:	true = filter & socket successfully set, and lpFunc will be called on data arrival
//					false = either filter or socket could not be created
STREAMREADER_API BOOL SetBitFilter(WORD pid, BYTE* FilterData, BYTE* FilterMask, BYTE FilterLength,STDCALL_DVBCALLBACK lpFunc, DWORD *lpfilter_num);

// Creates a filter for the remote control
// Parameters:	IR_Type: currently only one type is supported
//						 0x01: for RC5 devices
//				DevAddr: Device address of the remote control
//						 (WORD)-1 = 0xFFFF :to receice all commands (independend from the remote controls device address).
//				lpFunc: address of your callback function. Refer to SetFilter for nearer description
//				lpfilter_num: points to a DWORD that recieves the filter number. This value is used for all operations on this filter i.e. DelFiter
//
// Return value:	true = filter & socket successfully set, and lpFunc will be called on data arrival
//					false = either filter or socket could not be created
// Example:		SetRemoteControl(1,(WORD)-1,&Callback,&filter_num);
STREAMREADER_API BOOL SetRemoteControl(DWORD IR_Type,WORD DevAddr, STDCALL_DVBCALLBACK lpFunc,DWORD * lpfilter_num);

// Stops the proccessing of any Filter
// Parameters:	filter_num: the filter's number you want to delete
//
// Return value:	true = filter & socket successfully set, and lpFunc will be called on data arrival
//					false = either filter or socket could not be created
STREAMREADER_API BOOL DelFilter(DWORD filter_num);