{******************************************************************************}
{ FileName............: StreamReaderDefines                                    }
{ Project.............:                                                        }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  StreamReader defines.                                                       }
{                                                                              }
{  Copyright (C) 2003-2006  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20060404 - Initial release                                           }
{******************************************************************************}
unit StreamReaderDefines;


interface
uses
  Windows;

type
  PByte = ^Byte;
  ByteArray = array[0..$FFFF] of Byte;
  PByteArray = ^ByteArray;
  
  TFastDvbCallbackEx = procedure(Data: Pointer; Length: Integer; Pid: Integer); register;
  TFastDvbCallback   = procedure(Data: Pointer; Length: Integer); register;
  TStdDvbCallback    = procedure(Data: Pointer; Length: Integer); stdcall;
  TStdDvbCallbackEx  = procedure(Data: Pointer; Length: Integer; Pid: Integer); stdcall;
  TCdeclDvbCallback  = procedure(Data: Pointer; Length: Integer); cdecl;

  // Note: Ordinals 1/2/4 should stay at same indexes because it is also used
  //       by calling functions
  TCallbackTypes = (cbFastEx, cbFast, cbStd, cbStdEx, cbCdecl);

  TCheckForDvb = function    : Boolean; cdecl;
  TDelFilter   = function    (Filter_num  : Dword): Boolean; cdecl;
  TSendDiSEqC  = function    (DiSEqCType  : Dword;           Data        : Byte): Boolean; cdecl;
  TSetBitFilter= function    (Pid         : Word;            FilterData  : PByteArray;
                              FilterMask  : PByteArray;      FilterLength: Byte;
                              LpFunc      : Pointer;         LpFilter_num: PDword): Boolean; cdecl;
  TSetChannel  = function    (Freq        : Dword;           Symb        : Dword;
                              Pol         : Dword;           Fec         : Dword;
                              Lof1        : Dword;           Lof2        : Dword;
                              LofSw       : Dword): Boolean; cdecl;
  TSetFilter   = function    (Pid         : Word;            LpFunc      : Pointer;
                              CallBackType: Dword;           Size        : Dword;
                              LpFilter_Num: PDword): Boolean; cdecl;
  TSetRemoteControl = function (IR_Type     : Dword;           DevAddr     : Word;
                              LpFunc      : Pointer;         LpFilter_num: PDword):Boolean; cdecl;
  TStartDVB    = function    : Boolean; cdecl;
  TStopDVB     = function    : Boolean; cdecl;
  TSetFilterEx = function    (Pid         : Word;            LpFunc      : Pointer;
                              CallBackType: Dword;           Size        : Dword;
                              LpFilter_Num: PDword): Boolean; cdecl;


implementation


end.
