
 {###### ####   ##############################################################
  ##  ###  ### ##       ,######  ##   ##   ######  ###        ###   ##      ##
  ##   ###  ####        ##       ##   ##  ##    ##  ##   #    ##    ##      ##
  ##    ##   ###        ######   #######  ##    ##  \## ### ##/     ##########
  ##    ##  #####         #####  #######  ##    ##   #########              ##
  ##   ##  ##  ###          ,##  ##   ##  ##    ##    ### ###              ###
  ###### ###    ####   #######   ##   ##   ######     ##   ##     ###########
      |                                                                  |
      | Borland Delphi 4,5,6,7 API for Direct Show                       |
      | DirectX 9.0 Win 98, Me, 2000, XP                                 |
      |                                                                  |
      | Portions created by Microsoft are                                |
      | Copyright (C) 1995-2002 Microsoft Corporation.                   |
      | All Rights Reserved.                                             |
      |                                                                  |
      | The original files are:                                          |
      |   comlite.h, errors.h, dv.h, strmif.h, mmstream.h, amstream.h,   |
      |   ddstream.h, austream.h, mpconfig.h, control.h, qnetwork.h,     |
      |   playlist.h, il21dec.h, amvideo.h, amaudio.h, vptype.h,         |
      |   vpconfig.h, vpnotify.h, mpegtype.h, dvdevcod.h, dvdmedia.h,    |
      |   bdatypes.h, activecf.h, vfwmsgs.h,(edevdefs.h, XPrtDefs.h),    |
      |   aviriff.h, evcode.h, uuids.h, ksuuids.h, DXVA.h,AMVA.h,        |
      |   videoacc.h, regbag.h, tuner.h, DXTrans.h, QEdit.h, mpeguids.h, |
      |   dshowasf.h, amparse.h, audevcod.h, atsmedia.h, MediaErr,       |
      |   MedParam.h, mediaobj.h, dmodshow.h, dmoreg.h, DMORt.h,         |
      |   dmoimpl.h, ks.h, ksproxy.h, ksmedia.h, dmksctrl.h, bdamedia.h, |
      |   BDATIF.idl, AMVPE.idl, Mixerocx.idl, Mpeg2Data.idl,            |
      |   Mpeg2Structs.idl, Mpeg2Bits.h, Mpeg2Error.h, EDevCtrl.h,       |
      |   sbe.idl, vmr9.idl, iwstdec.h                                   |
      |                                                                  |
      | The original Pascal code is: DirectShow9.pas,                    |
      |   released 01 Nov 2003.                                          |
      |                                                                  |
      | The initial developer of the Pascal code is Henri GOURVEST       |
      |   Email    : hgourvest@progdigy.com                              |
      |   WebSite  : http://www.progdigy.com                             |
      |                                                                  |
      | Portions created by Henri GOURVEST are                           |
      | Copyright (C) 2002 Henri GOURVEST.                               |
      |                                                                  |
      | Contributors: Ivo Steinmann                                      |
      |               Peter NEUMANN                                      |
      |               Alexey Barkovoy                                    |
      |               Wayne Sherman                                      |
      |               Peter J. Haas     <DSPack@pjh2.de>                 |
      |               Andriy Nevhasymyy <a.n@email.com>                  |
      |               Milenko Mitrovic  <dcoder@dsp-worx.de>             |
      |               Michael Andersen  <michael@mechdata.dk>            |
      |               Martin Offenwanger <coder@dsplayer.de              |
      |                                                                  |
      | Joint Endeavour of Delphi Innovators (Project JEDI)              |
      |                                                                  |
      | You may retrieve the latest version of this file here:           |
      |   http://www.progdigy.com                                        |
      |                                                                  |
      | The contents of this file are used with permission, subject to   |
      | the Mozilla Public License Version 1.1 (the "License"); you may  |
      | not use this file except in compliance with the License. You may |
      | obtain a copy of the License at                                  |
      | http://www.mozilla.org/MPL/MPL-1.1.html                          |
      |                                                                  |
      | Software distributed under the License is distributed on an      |
      | "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or   |
      | implied. See the License for the specific language governing     |
      | rights and limitations under the License.                        |
      |                                                                  |
      |******************************************************************}

{$I DirectX.inc}

// To Avoid mistakes with old VMR, comment
{$DEFINE ENABLEVMR7}

{$IFDEF DYNAMIC_LINK_ALL}
  {$DEFINE DIRECTSHOW9_DYNAMIC_LINK}
{$ENDIF}

unit DirectShow9;
{$HPPEMIT '#if(DIRECT3D_VERSION > 0x0700)'}
{$HPPEMIT 'typedef struct IDirect3D            *LPDIRECT3D;'}
{$HPPEMIT 'typedef struct IDirect3DDevice      *LPDIRECT3DDEVICE;'}
{$HPPEMIT 'typedef struct IDirect3D2           *LPDIRECT3D2;'}
{$HPPEMIT 'typedef struct IDirect3DDevice2     *LPDIRECT3DDEVICE2;'}
{$HPPEMIT 'typedef struct IDirect3DViewport    *LPDIRECT3DVIEWPORT;'}
{$HPPEMIT '#endif'}

{$HPPEMIT '#define __KS__'}
{$HPPEMIT '#define __STREAMS__'}
{$HPPEMIT '#include "comlite.h"'}
{$HPPEMIT '#include "errors.h"'}
{$HPPEMIT '#include "dv.h"'}
{$HPPEMIT '#include "strmif.h"'}
{$HPPEMIT '#include "mmstream.h"'}
{$HPPEMIT '#include "amstream.h"'}
{$HPPEMIT '#include "ddstream.h"'}
{$HPPEMIT '#include "austream.h"'}
{$HPPEMIT '#include "mpconfig.h"'}
{$HPPEMIT '#include "control.h"'}
{$HPPEMIT '#include "qnetwork.h"'}
{$HPPEMIT '#include "playlist.h"'}
{$HPPEMIT '#include "il21dec.h"'}
{$HPPEMIT '#include "amvideo.h"'}
{$HPPEMIT '#include "amaudio.h"'}
{$HPPEMIT '#include "vptype.h"'}
{$HPPEMIT '#include "vpconfig.h"'}
{$HPPEMIT '#include "vpnotify.h"'}
{$HPPEMIT '#include "mmreg.h"'}
{$HPPEMIT '#include "mpegtype.h"'}
{$HPPEMIT '#include "dvdevcod.h"'}
{$HPPEMIT '#include "dvdmedia.h"'}
{$HPPEMIT '#include "bdatypes.h"'}
{$HPPEMIT '#include "activecf.h"'}
{$HPPEMIT '#include "vfwmsgs.h"'}
{$HPPEMIT '#include "edevdefs.h"'}
{$HPPEMIT '#include "XPrtDefs.h"'}
{$HPPEMIT '#include "aviriff.h"'}
{$HPPEMIT '#include "evcode.h"'}
{$HPPEMIT '#include "DXVA.h"'}
{$HPPEMIT '#include "AMVA.h"'}
{$HPPEMIT '#include "videoacc.h"'}
{$HPPEMIT '#include "regbag.h"'}
{$HPPEMIT '#include "tuner.h"'}
{$HPPEMIT '#include "DXTrans.h"'}
{$HPPEMIT '#include "QEdit.h"'}
{$HPPEMIT '#include "dshowasf.h"'}
{$HPPEMIT '#include "amparse.h"'}
{$HPPEMIT '#include "audevcod.h"'}
{$HPPEMIT '#include "MediaErr.h"'}
{$HPPEMIT '#include "MedParam.h"'}
{$HPPEMIT '#include "mediaobj.h"'}
{$HPPEMIT '#include "dmodshow.h"'}
{$HPPEMIT '#include "dmoreg.h"'}
{$HPPEMIT '#include "DMORt.h"'}
{$HPPEMIT '#include "dmoimpl.h"'}
{$HPPEMIT '#include "uuids.h"'}
{$HPPEMIT '#include "ks.h"'}
{$HPPEMIT '#include "ksproxy.h"'}
{$HPPEMIT '#include "ksmedia.h"'}
{$HPPEMIT '#include "bdamedia.h"'}
{$HPPEMIT '#include "Bdatif.h"'}
{$HPPEMIT '#include "atsmedia.h"'}
{$HPPEMIT '#include "dmksctrl.h"'}
{$HPPEMIT '#include "Mixerocx.h"'}
{$HPPEMIT '#include "Mpeg2Data.h"'}
{$HPPEMIT '#include "Mpeg2Bits.h"'}
{$HPPEMIT '#include "Mpeg2Error.h"'}
{$HPPEMIT '#include "sbe.h"'}
{$HPPEMIT '#include "vmr9.h"'}
{$HPPEMIT '#include "iwstdec.h"'}

interface

uses
  Windows,
  ActiveX,
  DirectDraw,
  DirectSound,
  Direct3D9,
  MMSystem,
  SyncObjs,
  ComObj;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       comlite.h
 *
 ***************************************************************************)

function  QzInitialize(pvReserved: Pointer): HResult; stdcall;
{$EXTERNALSYM QzInitialize}
procedure QzUninitialize; stdcall;
{$EXTERNALSYM QzUninitialize}
procedure QzFreeUnusedLibraries; stdcall;
{$EXTERNALSYM QzFreeUnusedLibraries}

function  QzGetMalloc(dwMemContext: Longint; out malloc: IMalloc): HResult; stdcall;
{$EXTERNALSYM QzGetMalloc}
function  QzTaskMemAlloc(cb: Longint): Pointer; stdcall;
{$EXTERNALSYM QzTaskMemAlloc}
function  QzTaskMemRealloc(pv: Pointer; cb: Longint): Pointer; stdcall;
{$EXTERNALSYM QzTaskMemRealloc}
procedure QzTaskMemFree(pv: Pointer); stdcall;
{$EXTERNALSYM QzTaskMemFree}
function  QzCreateFilterObject(const clsid: TCLSID; unkOuter: IUnknown;
{$EXTERNALSYM QzCreateFilterObject}
  dwClsContext: Longint; const iid: TIID; out pv): HResult; stdcall;
function  QzCLSIDFromString(psz: POleStr; out clsid: TCLSID): HResult; stdcall;
{$EXTERNALSYM QzCLSIDFromString}
function  QzStringFromGUID2(const guid: TGUID; psz: POleStr; cbMax: Integer): Integer; stdcall;
{$EXTERNALSYM QzStringFromGUID2}


(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       errors.h
 *
 ***************************************************************************)

const
  VFW_FIRST_CODE     = $200;
  {$EXTERNALSYM VFW_FIRST_CODE}
  MAX_ERROR_TEXT_LEN = 160;
  {$EXTERNALSYM MAX_ERROR_TEXT_LEN}

  function AMGetErrorTextA(hr: HResult; pbuffer: PChar; MaxLen: DWORD): DWORD; stdcall;
  {$EXTERNALSYM AMGetErrorTextA}
  function AMGetErrorTextW(hr: HResult; pbuffer: PWideChar; MaxLen: DWORD): DWORD; stdcall;
  {$EXTERNALSYM AMGetErrorTextW}

  // [pjh, 2003-07-14] ANSI and UNICODE declaration exchange
  {$IFDEF UNICODE}
  function AMGetErrorText(hr: HResult; pbuffer: PWideChar; MaxLen: DWORD): DWORD; stdcall;
  {$ELSE}
  function AMGetErrorText(hr: HResult; pbuffer: PChar; MaxLen: DWORD): DWORD; stdcall;
  {$ENDIF}
  {$EXTERNALSYM AMGetErrorText}


(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       dv.h
 *
 ***************************************************************************)

const
  DV_DVSD_NTSC_FRAMESIZE  =      120000;
  {$EXTERNALSYM DV_DVSD_NTSC_FRAMESIZE}
  DV_DVSD_PAL_FRAMESIZE	  =      144000;
  {$EXTERNALSYM DV_DVSD_PAL_FRAMESIZE}

  DV_SMCHN       = $0000e000;
  {$EXTERNALSYM DV_SMCHN}
  DV_AUDIOMODE   = $00000f00;
  {$EXTERNALSYM DV_AUDIOMODE}
  DV_AUDIOSMP    = $38000000;
  {$EXTERNALSYM DV_AUDIOSMP}

  DV_AUDIOQU     = $07000000;
  {$EXTERNALSYM DV_AUDIOQU}
  DV_NTSCPAL	   = $00200000;
  {$EXTERNALSYM DV_NTSCPAL}
  DV_STYPE	     = $001f0000;
  {$EXTERNALSYM DV_STYPE}

  //There are NTSC or PAL DV camcorders
  DV_NTSC	 = 0;
  {$EXTERNALSYM DV_NTSC}
  DV_PAL	 = 1;
  {$EXTERNALSYM DV_PAL}

  //DV camcorder can output sd/hd/sl
  DV_SD          = $00;
  {$EXTERNALSYM DV_SD}
  DV_HD          = $01;
  {$EXTERNALSYM DV_HD}
  DV_SL          = $02;
  {$EXTERNALSYM DV_SL}

  //user can choice 12 bits or 16 bits audio from DV camcorder
  DV_CAP_AUD16Bits  =  $00;
  {$EXTERNALSYM DV_CAP_AUD16Bits}
  DV_CAP_AUD12Bits  =  $01;
  {$EXTERNALSYM DV_CAP_AUD12Bits}

  SIZE_DVINFO    = $20;
  {$EXTERNALSYM SIZE_DVINFO}

type
  Tag_DVAudInfo = record
    bAudStyle: array[0..1] of Byte;
    //LSB 6 bits for starting DIF sequence number
    //MSB 2 bits: 0 for mon. 1: stereo in one 5/6 DIF sequences, 2: stereo audio in both 5/6 DIF sequences
    //example: 0x00: mon, audio in first 5/6 DIF sequence
    //                 0x05: mon, audio in 2nd 5 DIF sequence
    //                 0x15: stereo, audio only in 2nd 5 DIF sequence
    //                 0x10: stereo, audio only in 1st 5/6 DIF sequence
    //                 0x20: stereo, left ch in 1st 5/6 DIF sequence, right ch in 2nd 5/6 DIF sequence
    //                 0x26: stereo, rightch in 1st 6 DIF sequence, left ch in 2nd 6 DIF sequence
    bAudQu: array[0..1] of Byte;            //qbits, only support 12, 16,

    bNumAudPin: Byte;                              //how many pin
    wAvgSamplesPerPinPerFrm: array[0..1] of WORD;  //samples size for one audio pin in one frame(which has 10 or 12 DIF sequence)
    wBlkMode : WORD;                               //45 for NTSC, 54 for PAL
    wDIFMode : WORD;                               //5  for NTSC, 6 for PAL
    wBlkDiv  : WORD;                               //15  for NTSC, 18 for PAL
  end;
  {$EXTERNALSYM Tag_DVAudInfo}
  DVAudInfo = Tag_DVAudInfo;
  {$EXTERNALSYM DVAudInfo}
  TDVAudInfo = Tag_DVAudInfo;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       strmif.h
 *
 ***************************************************************************)
const
  IID_IPin                            : TGUID = '{56A86891-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IPin}
  IID_IEnumPins                       : TGUID = '{56A86892-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IEnumPins}
  IID_IEnumMediaTypes                 : TGUID = '{89C31040-846B-11CE-97D3-00AA0055595A}';
  {$EXTERNALSYM IID_IEnumMediaTypes}
  IID_IFilterGraph                    : TGUID = '{56A8689F-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IFilterGraph}
  IID_IEnumFilters                    : TGUID = '{56A86893-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IEnumFilters}
  IID_IMediaFilter                    : TGUID = '{56A86899-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IMediaFilter}
  IID_IBaseFilter                     : TGUID = '{56A86895-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IBaseFilter}
  IID_IReferenceClock                 : TGUID = '{56A86897-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IReferenceClock}
  IID_IReferenceClock2                : TGUID = '{36B73885-C2C8-11CF-8B46-00805F6CEF60}';
  {$EXTERNALSYM IID_IReferenceClock2}
  IID_IMediaSample                    : TGUID = '{56A8689A-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IMediaSample}
  IID_IMediaSample2                   : TGUID = '{36B73884-C2C8-11CF-8B46-00805F6CEF60}';
  {$EXTERNALSYM IID_IMediaSample2}
  IID_IMemAllocator                   : TGUID = '{56A8689C-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IMemAllocator}
  IID_IMemInputPin                    : TGUID = '{56A8689D-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IMemInputPin}
  IID_IAMovieSetup                    : TGUID = '{A3D8CEC0-7E5A-11CF-BBC5-00805F6CEF20}'; // deprecated;
  {$EXTERNALSYM IID_IAMovieSetup}
  IID_IMediaSeeking                   : TGUID = '{36B73880-C2C8-11CF-8B46-00805F6CEF60}';
  {$EXTERNALSYM IID_IMediaSeeking}
  IID_IEnumRegFilters                 : TGUID = '{56A868A4-0AD4-11CE-B03A-0020AF0BA770}'; // deprecated;
  {$EXTERNALSYM IID_IEnumRegFilters}
  IID_IFilterMapper                   : TGUID = '{56A868A3-0AD4-11CE-B03A-0020AF0BA770}'; // deprecated;
  {$EXTERNALSYM IID_IFilterMapper}
  IID_IFilterMapper2                  : TGUID = '{B79BB0B0-33C1-11D1-ABE1-00A0C905F375}';
  {$EXTERNALSYM IID_IFilterMapper2}
  IID_IQualityControl                 : TGUID = '{56A868A5-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IQualityControl}
  IID_IOverlayNotify                  : TGUID = '{56A868A0-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IOverlayNotify}
  IID_IOverlay                        : TGUID = '{56A868A1-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IOverlay}
  IID_IMediaEventSink                 : TGUID = '{56A868A2-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IMediaEventSink}
  IID_IFileSourceFilter               : TGUID = '{56A868A6-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IFileSourceFilter}
  IID_IFileSinkFilter                 : TGUID = '{A2104830-7C70-11CF-8BCE-00AA00A3F1A6}';
  {$EXTERNALSYM IID_IFileSinkFilter}
  IID_IFileSinkFilter2                : TGUID = '{00855B90-CE1B-11D0-BD4F-00A0C911CE86}';
  {$EXTERNALSYM IID_IFileSinkFilter2}
  IID_IFileAsyncIO                    : TGUID = '{56A868A7-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IFileAsyncIO}
  IID_IGraphBuilder                   : TGUID = '{56A868A9-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IGraphBuilder}
  IID_ICaptureGraphBuilder            : TGUID = '{BF87B6E0-8C27-11D0-B3F0-00AA003761C5}'; // deprecated;
  {$EXTERNALSYM IID_ICaptureGraphBuilder}
  IID_IAMCopyCaptureFileProgress      : TGUID = '{670D1D20-A068-11D0-B3F0-00AA003761C5}';
  {$EXTERNALSYM IID_IAMCopyCaptureFileProgress}
  IID_IFilterGraph2                   : TGUID = '{36B73882-C2C8-11CF-8B46-00805F6CEF60}';
  {$EXTERNALSYM IID_IFilterGraph2}
  IID_IStreamBuilder                  : TGUID = '{56A868BF-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IStreamBuilder}
  IID_IAsyncReader                    : TGUID = '{56A868AA-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IAsyncReader}
  IID_IGraphVersion                   : TGUID = '{56A868AB-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IGraphVersion}
  IID_IResourceConsumer               : TGUID = '{56A868AD-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IResourceConsumer}
  IID_IResourceManager                : TGUID = '{56A868AC-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IResourceManager}
  IID_IDistributorNotify              : TGUID = '{56A868AF-0AD4-11CE-B03A-0020AF0BA770}';
  {$EXTERNALSYM IID_IDistributorNotify}
  IID_IAMStreamControl                : TGUID = '{36b73881-c2c8-11cf-8b46-00805f6cef60}';
  {$EXTERNALSYM IID_IAMStreamControl}
  IID_ISeekingPassThru                : TGUID = '{36B73883-C2C8-11CF-8B46-00805F6CEF60}';
  {$EXTERNALSYM IID_ISeekingPassThru}
  IID_IAMStreamConfig                 : TGUID = '{C6E13340-30AC-11d0-A18C-00A0C9118956}';
  {$EXTERNALSYM IID_IAMStreamConfig}
  IID_IConfigInterleaving             : TGUID = '{BEE3D220-157B-11d0-BD23-00A0C911CE86}';
  {$EXTERNALSYM IID_IConfigInterleaving}
  IID_IConfigAviMux                   : TGUID = '{5ACD6AA0-F482-11ce-8B67-00AA00A3F1A6}';
  {$EXTERNALSYM IID_IConfigAviMux}
  IID_IAMVideoCompression             : TGUID = '{C6E13343-30AC-11d0-A18C-00A0C9118956}';
  {$EXTERNALSYM IID_IAMVideoCompression}
  IID_IAMVfwCaptureDialogs            : TGUID = '{D8D715A0-6E5E-11D0-B3F0-00AA003761C5}';
  {$EXTERNALSYM IID_IAMVfwCaptureDialogs}
  IID_IAMVfwCompressDialogs           : TGUID = '{D8D715A3-6E5E-11D0-B3F0-00AA003761C5}';
  {$EXTERNALSYM IID_IAMVfwCompressDialogs}
  IID_IAMDroppedFrames                : TGUID = '{C6E13344-30AC-11d0-A18C-00A0C9118956}';
  {$EXTERNALSYM IID_IAMDroppedFrames}
  IID_IAMAudioInputMixer              : TGUID = '{54C39221-8380-11d0-B3F0-00AA003761C5}';
  {$EXTERNALSYM IID_IAMAudioInputMixer}
  IID_IAMAnalogVideoDecoder           : TGUID = '{C6E13350-30AC-11d0-A18C-00A0C9118956}';
  {$EXTERNALSYM IID_IAMAnalogVideoDecoder}
  IID_IAMVideoProcAmp                 : TGUID = '{C6E13360-30AC-11d0-A18C-00A0C9118956}';
  {$EXTERNALSYM IID_IAMVideoProcAmp}
  IID_IAMCameraControl                : TGUID = '{C6E13370-30AC-11d0-A18C-00A0C9118956}';
  {$EXTERNALSYM IID_IAMCameraControl}
  IID_IAMCrossbar                     : TGUID = '{C6E13380-30AC-11d0-A18C-00A0C9118956}';
  {$EXTERNALSYM IID_IAMCrossbar}
  IID_IAMTuner                        : TGUID = '{211A8761-03AC-11d1-8D13-00AA00BD8339}';
  {$EXTERNALSYM IID_IAMTuner}
  IID_IAMTunerNotification            : TGUID = '{211A8760-03AC-11d1-8D13-00AA00BD8339}';
  {$EXTERNALSYM IID_IAMTunerNotification}
  IID_IAMTVTuner                      : TGUID = '{211A8766-03AC-11d1-8D13-00AA00BD8339}';
  {$EXTERNALSYM IID_IAMTVTuner}
  IID_IBPCSatelliteTuner              : TGUID = '{211A8765-03AC-11d1-8D13-00AA00BD8339}';
  {$EXTERNALSYM IID_IBPCSatelliteTuner}
  IID_IAMTVAudio                      : TGUID = '{83EC1C30-23D1-11d1-99E6-00A0C9560266}';
  {$EXTERNALSYM IID_IAMTVAudio}
  IID_IAMTVAudioNotification          : TGUID = '{83EC1C33-23D1-11D1-99E6-00A0C9560266}';
  {$EXTERNALSYM IID_IAMTVAudioNotification}
  IID_IAMAnalogVideoEncoder           : TGUID = '{C6E133B0-30AC-11d0-A18C-00A0C9118956}'; // deprecated;
  {$EXTERNALSYM IID_IAMAnalogVideoEncoder}
  IID_IMediaPropertyBag               : TGUID = '{6025A880-C0D5-11D0-BD4E-00A0C911CE86}';
  {$EXTERNALSYM IID_IMediaPropertyBag}
  IID_IPersistMediaPropertyBag        : TGUID = '{5738E040-B67F-11d0-BD4D-00A0C911CE86}';
  {$EXTERNALSYM IID_IPersistMediaPropertyBag}
  IID_IAMPhysicalPinInfo              : TGUID = '{F938C991-3029-11CF-8C44-00AA006B6814}'; // deprecated;
  {$EXTERNALSYM IID_IAMPhysicalPinInfo}
  IID_IAMExtDevice                    : TGUID = '{B5730A90-1A2C-11CF-8C23-00AA006B6814}';
  {$EXTERNALSYM IID_IAMExtDevice}
  IID_IAMExtTransport                 : TGUID = '{A03CD5F0-3045-11CF-8C44-00AA006B6814}';
  {$EXTERNALSYM IID_IAMExtTransport}
  IID_IAMTimecodeReader               : TGUID = '{9B496CE1-811B-11CF-8C77-00AA006B6814}';
  {$EXTERNALSYM IID_IAMTimecodeReader}
  IID_IAMTimecodeGenerator            : TGUID = '{9B496CE0-811B-11CF-8C77-00AA006B6814}';
  {$EXTERNALSYM IID_IAMTimecodeGenerator}
  IID_IAMTimecodeDisplay              : TGUID = '{9B496CE2-811B-11CF-8C77-00AA006B6814}';
  {$EXTERNALSYM IID_IAMTimecodeDisplay}
  IID_IAMDevMemoryAllocator           : TGUID = '{C6545BF0-E76B-11D0-BD52-00A0C911CE86}'; // deprecated;
  {$EXTERNALSYM IID_IAMDevMemoryAllocator}
  IID_IAMDevMemoryControl             : TGUID = '{C6545BF1-E76B-11D0-BD52-00A0C911CE86}'; // deprecated;
  {$EXTERNALSYM IID_IAMDevMemoryControl}
  IID_IAMStreamSelect                 : TGUID = '{C1960960-17F5-11D1-ABE1-00A0C905F375}';
  {$EXTERNALSYM IID_IAMStreamSelect}
  IID_IAMovie                         : TGUID = '{359ACE10-7688-11CF-8B23-00805F6CEF60}';
  {$EXTERNALSYM IID_IAMovie}
  IID_ICreateDevEnum                  : TGUID = '{29840822-5B84-11D0-BD3B-00A0C911CE86}';
  {$EXTERNALSYM IID_ICreateDevEnum}
  IID_IDvdControl                     : TGUID = '{A70EFE61-E2A3-11D0-A9BE-00AA0061BE93}'; // deprecated;
  {$EXTERNALSYM IID_IDvdControl}
  IID_IDvdControl2                    : TGUID = '{33BC7430-EEC0-11D2-8201-00A0C9D74842}';
  {$EXTERNALSYM IID_IDvdControl2}
  IID_IDvdInfo                        : TGUID = '{A70EFE60-E2A3-11D0-A9BE-00AA0061BE93}'; // deprecated;
  {$EXTERNALSYM IID_IDvdInfo}
  IID_IDvdInfo2                       : TGUID = '{34151510-EEC0-11D2-8201-00A0C9D74842}';
  {$EXTERNALSYM IID_IDvdInfo2}
  IID_IDvdGraphBuilder                : TGUID = '{FCC152B6-F372-11d0-8E00-00C04FD7C08B}';
  {$EXTERNALSYM IID_IDvdGraphBuilder}
  IID_IDvdState                       : TGUID = '{86303d6d-1c4a-4087-ab42-f711167048ef}';
  {$EXTERNALSYM IID_IDvdState}
  IID_IDvdCmd                         : TGUID = '{5a4a97e4-94ee-4a55-9751-74b5643aa27d}';
  {$EXTERNALSYM IID_IDvdCmd}
  IID_IVideoFrameStep                 : TGUID = '{e46a9787-2b71-444d-a4b5-1fab7b708d6a}';
  {$EXTERNALSYM IID_IVideoFrameStep}
  IID_IFilterMapper3                  : TGUID = '{b79bb0b1-33c1-11d1-abe1-00a0c905f375}';
  {$EXTERNALSYM IID_IFilterMapper3}
  IID_IOverlayNotify2                 : TGUID = '{680EFA10-D535-11D1-87C8-00A0C9223196}';
  {$EXTERNALSYM IID_IOverlayNotify2}
  IID_ICaptureGraphBuilder2           : TGUID = '{93E5A4E0-2D50-11d2-ABFA-00A0C9C6E38D}';
  {$EXTERNALSYM IID_ICaptureGraphBuilder2}
  IID_IMemAllocatorCallbackTemp       : TGUID = '{379a0cf0-c1de-11d2-abf5-00a0c905f375}';
  {$EXTERNALSYM IID_IMemAllocatorCallbackTemp}
  IID_IMemAllocatorNotifyCallbackTemp : TGUID = '{92980b30-c1de-11d2-abf5-00a0c905f375}';
  {$EXTERNALSYM IID_IMemAllocatorNotifyCallbackTemp}
  IID_IAMVideoControl                 : TGUID = '{6a2e0670-28e4-11d0-a18c-00a0c9118956}';
  {$EXTERNALSYM IID_IAMVideoControl}

  IID_IKsPropertySet                  : TGUID = '{31EFAC30-515C-11d0-A9AA-00AA0061BE93}';
  {$EXTERNALSYM IID_IKsPropertySet}
  STATIC_IID_IKsPropertySet           : TGUID = '{31EFAC30-515C-11d0-A9AA-00AA0061BE93}';
  {$EXTERNALSYM STATIC_IID_IKsPropertySet}

  IID_IAMResourceControl              : TGUID = '{8389d2d0-77d7-11d1-abe6-00a0c905f375}';
  {$EXTERNALSYM IID_IAMResourceControl}
  IID_IAMClockAdjust                  : TGUID = '{4d5466b0-a49c-11d1-abe8-00a0c905f375}';
  {$EXTERNALSYM IID_IAMClockAdjust}
  IID_IAMFilterMiscFlags              : TGUID = '{2dd74950-a890-11d1-abe8-00a0c905f375}';
  {$EXTERNALSYM IID_IAMFilterMiscFlags}
  IID_IDrawVideoImage                 : TGUID = '{48efb120-ab49-11d2-aed2-00a0c995e8d5}';
  {$EXTERNALSYM IID_IDrawVideoImage}
  IID_IDecimateVideoImage             : TGUID = '{2e5ea3e0-e924-11d2-b6da-00a0c995e8df}';
  {$EXTERNALSYM IID_IDecimateVideoImage}
  IID_IAMVideoDecimationProperties    : TGUID = '{60d32930-13da-11d3-9ec6-c4fcaef5c7be}';
  {$EXTERNALSYM IID_IAMVideoDecimationProperties}
  IID_IAMLatency                      : TGUID = '{62EA93BA-EC62-11d2-B770-00C04FB6BD3D}';
  {$EXTERNALSYM IID_IAMLatency}
  IID_IAMPushSource                   : TGUID = '{F185FE76-E64E-11d2-B76E-00C04FB6BD3D}';
  {$EXTERNALSYM IID_IAMPushSource}
  IID_IAMDeviceRemoval                : TGUID = '{f90a6130-b658-11d2-ae49-0000f8754b99}';
  {$EXTERNALSYM IID_IAMDeviceRemoval}
  IID_IDVEnc                          : TGUID = '{d18e17a0-aacb-11d0-afb0-00aa00b67a42}';
  {$EXTERNALSYM IID_IDVEnc}
  IID_IIPDVDec                        : TGUID = '{b8e8bd60-0bfe-11d0-af91-00aa00b67a42}';
  {$EXTERNALSYM IID_IIPDVDec}
  IID_IDVRGB219                       : TGUID = '{58473A19-2BC8-4663-8012-25F81BABDDD1}'; // XP
  {$EXTERNALSYM IID_IDVRGB219}
  IID_IDVSplitter                     : TGUID = '{92a3a302-da7c-4a1f-ba7e-1802bb5d2d02}';
  {$EXTERNALSYM IID_IDVSplitter}
  IID_IAMAudioRendererStats           : TGUID = '{22320CB2-D41A-11d2-BF7C-D7CB9DF0BF93}';
  {$EXTERNALSYM IID_IAMAudioRendererStats}
  IID_IAMGraphStreams                 : TGUID = '{632105FA-072E-11d3-8AF9-00C04FB6BD3D}';
  {$EXTERNALSYM IID_IAMGraphStreams}
  IID_IAMOverlayFX                    : TGUID = '{62fae250-7e65-4460-bfc9-6398b322073c}';
  {$EXTERNALSYM IID_IAMOverlayFX}
  IID_IAMOpenProgress                 : TGUID = '{8E1C39A1-DE53-11cf-AA63-0080C744528D}';
  {$EXTERNALSYM IID_IAMOpenProgress}
  IID_IMpeg2Demultiplexer             : TGUID = '{436eee9c-264f-4242-90e1-4e330c107512}';
  {$EXTERNALSYM IID_IMpeg2Demultiplexer}
  IID_IEnumStreamIdMap                : TGUID = '{945C1566-6202-46fc-96C7-D87F289C6534}';
  {$EXTERNALSYM IID_IEnumStreamIdMap}
  IID_IMPEG2StreamIdMap               : TGUID = '{D0E04C47-25B8-4369-925A-362A01D95444}';
  {$EXTERNALSYM IID_IMPEG2StreamIdMap}
  IID_IRegisterServiceProvider        : TGUID = '{7B3A2F01-0751-48DD-B556-004785171C54}'; // XP
  {$EXTERNALSYM IID_IRegisterServiceProvider}
  IID_IAMDecoderCaps                  : TGUID = '{c0dff467-d499-4986-972b-e1d9090fa941}'; // XP
  {$EXTERNALSYM IID_IAMDecoderCaps}
  IID_IAMCertifiedOutputProtection    : TGUID = '{6FEDED3E-0FF1-4901-A2F1-43F7012C8515}';
  {$EXTERNALSYM IID_IAMCertifiedOutputProtection}
  IID_IAMClockSlave                   : TGUID = '{9FD52741-176D-4b36-8F51-CA8F933223BE}'; // XP
  {$EXTERNALSYM IID_IAMClockSlave}
  IID_IAMGraphBuilderCallback         : TGUID = '{4995f511-9ddb-4f12-bd3b-f04611807b79}'; // DX9
  {$EXTERNALSYM IID_IAMGraphBuilderCallback}
  IID_IAMFilterGraphCallback          : TGUID = '{56a868fd-0ad4-11ce-b0a3-0020af0ba770}'; // DX9
  {$EXTERNALSYM IID_IAMFilterGraphCallback}
  IID_ICodecAPI                       : TGUID = '{901db4c7-31ce-41a2-85dc-8fa0bf41b8da}'; // DX9
  {$EXTERNALSYM IID_ICodecAPI}
  IID_IEncoderAPI                     : TGUID = '{70423839-6ACC-4b23-B079-21DBF08156A5}'; // DX9
  {$EXTERNALSYM IID_IEncoderAPI}
  IID_IVideoEncoder                   : TGUID = '{02997C3B-8E1B-460e-9270-545E0DE9563E}'; // DX9
  {$EXTERNALSYM IID_IVideoEncoder}
  IID_IGetCapabilitiesKey             : TGUID = '{a8809222-07bb-48ea-951c-33158100625b}'; // DX9
  {$EXTERNALSYM IID_IGetCapabilitiesKey}
  IID_IDDrawExclModeVideo             : TGUID = '{153ACC21-D83B-11d1-82BF-00A0C9696C8F}';
  {$EXTERNALSYM IID_IDDrawExclModeVideo}
  IID_IDDrawExclModeVideoCallback     : TGUID = '{913c24a0-20ab-11d2-9038-00a0c9697298}';
  {$EXTERNALSYM IID_IDDrawExclModeVideoCallback}
  IID_IPinConnection                  : TGUID = '{4a9a62d3-27d4-403d-91e9-89f540e55534}';
  {$EXTERNALSYM IID_IPinConnection}
  IID_IPinFlowControl                 : TGUID = '{c56e9858-dbf3-4f6b-8119-384af2060deb}';
  {$EXTERNALSYM IID_IPinFlowControl}
  IID_IGraphConfig                    : TGUID = '{03A1EB8E-32BF-4245-8502-114D08A9CB88}';
  {$EXTERNALSYM IID_IGraphConfig}
  IID_IGraphConfigCallback            : TGUID = '{ade0fd60-d19d-11d2-abf6-00a0c905f375}';
  {$EXTERNALSYM IID_IGraphConfigCallback}
  IID_IFilterChain                    : TGUID = '{DCFBDCF6-0DC2-45f5-9AB2-7C330EA09C29}';
  {$EXTERNALSYM IID_IFilterChain}

  IID_IVMRImagePresenter              : TGUID = '{CE704FE7-E71E-41fb-BAA2-C4403E1182F5}'; // XP
  {$EXTERNALSYM IID_IVMRImagePresenter}
  IID_IVMRSurfaceAllocator            : TGUID = '{31ce832e-4484-458b-8cca-f4d7e3db0b52}'; // XP
  {$EXTERNALSYM IID_IVMRSurfaceAllocator}
  IID_IVMRSurfaceAllocatorNotify      : TGUID = '{aada05a8-5a4e-4729-af0b-cea27aed51e2}'; // XP
  {$EXTERNALSYM IID_IVMRSurfaceAllocatorNotify}
  IID_IVMRWindowlessControl           : TGUID = '{0eb1088c-4dcd-46f0-878f-39dae86a51b7}'; // XP
  {$EXTERNALSYM IID_IVMRWindowlessControl}
  IID_IVMRMixerControl                : TGUID = '{1c1a17b0-bed0-415d-974b-dc6696131599}'; // XP
  {$EXTERNALSYM IID_IVMRMixerControl}
  IID_IVMRMonitorConfig               : TGUID = '{9cf0b1b6-fbaa-4b7f-88cf-cf1f130a0dce}'; // XP
  {$EXTERNALSYM IID_IVMRMonitorConfig}
  IID_IVMRFilterConfig                : TGUID = '{9e5530c5-7034-48b4-bb46-0b8a6efc8e36}'; // XP
  {$EXTERNALSYM IID_IVMRFilterConfig}
  IID_IVMRMixerBitmap                 : TGUID = '{1E673275-0257-40aa-AF20-7C608D4A0428}'; // XP
  {$EXTERNALSYM IID_IVMRMixerBitmap}
  IID_IVMRImageCompositor             : TGUID = '{7a4fb5af-479f-4074-bb40-ce6722e43c82}'; // XP
  {$EXTERNALSYM IID_IVMRImageCompositor}
  IID_IVMRVideoStreamControl          : TGUID = '{058d1f11-2a54-4bef-bd54-df706626b727}'; // XP
  {$EXTERNALSYM IID_IVMRVideoStreamControl}
  IID_IVMRSurface                     : TGUID = '{a9849bbe-9ec8-4263-b764-62730f0d15d0}'; // XP
  {$EXTERNALSYM IID_IVMRSurface}
  IID_IVPManager                      : TGUID = '{aac18c18-e186-46d2-825d-a1f8dc8e395a}'; // XP
  {$EXTERNALSYM IID_IVPManager}
  IID_IVMRImagePresenterConfig        : TGUID = '{9f3a1c85-8555-49ba-935f-be5b5b29d178}'; // XP
  {$EXTERNALSYM IID_IVMRImagePresenterConfig}
  IID_IVMRImagePresenterExclModeConfig: TGUID = '{e6f7ce40-4673-44f1-8f77-5499d68cb4ea}'; // XP
  {$EXTERNALSYM IID_IVMRImagePresenterExclModeConfig}

  IID_IAMBufferNegotiation            : TGUID = '{56ED71A0-AF5F-11D0-B3F0-00AA003761C5}';
  {$EXTERNALSYM IID_IAMBufferNegotiation}

const
  CHARS_IN_GUID   = 39;
  {$EXTERNALSYM CHARS_IN_GUID}

  MAX_PIN_NAME    = 128;
  {$EXTERNALSYM MAX_PIN_NAME}
  MAX_FILTER_NAME = 128;
  {$EXTERNALSYM MAX_FILTER_NAME}

type
  PAMMediaType = ^TAMMediaType;
  _AMMediaType = record
    majortype            : TGUID;
    subtype              : TGUID;
    bFixedSizeSamples    : BOOL;
    bTemporalCompression : BOOL;
    lSampleSize          : ULONG;
    formattype           : TGUID;
    pUnk                 : IUnknown;
    cbFormat             : ULONG;
    pbFormat             : Pointer;
  end;
  {$EXTERNALSYM _AMMediaType}
  AM_MEDIA_TYPE = _AMMediaType;
  {$EXTERNALSYM AM_MEDIA_TYPE}
  TAMMediaType = _AMMediaType;

  _PinDirection = (
    PINDIR_INPUT,
    PINDIR_OUTPUT
  );
  {$EXTERNALSYM _PinDirection}
  PIN_DIRECTION = _PinDirection;
  {$EXTERNALSYM PIN_DIRECTION}
  TPinDirection = PIN_DIRECTION;

  REFERENCE_TIME = DirectSound.REFERENCE_TIME;
  {$EXTERNALSYM REFERENCE_TIME}
  TReferenceTime = DirectSound.TReferenceTime;
  PReferenceTime = DirectSound.PReferenceTime;

  REFTIME = double;
  {$EXTERNALSYM REFTIME}
  TRefTime = REFTIME;

  HSEMAPHORE = Longint;
  {$EXTERNALSYM HSEMAPHORE}

  PAllocatorProperties = ^TAllocatorProperties;
  _AllocatorProperties = record
    cBuffers: Longint;
    cbBuffer: Longint;
    cbAlign : Longint;
    cbPrefix: Longint;
  end;
  {$EXTERNALSYM _AllocatorProperties}
  ALLOCATOR_PROPERTIES = _AllocatorProperties;
  {$EXTERNALSYM ALLOCATOR_PROPERTIES}
  TAllocatorProperties = _AllocatorProperties;

  IBaseFilter = interface;

  _PinInfo = record
    pFilter: IBaseFilter;
    dir    : PIN_DIRECTION;
    achName: array[0..127] of WCHAR;
  end;
  {$EXTERNALSYM _PinInfo}
  PIN_INFO = _PinInfo;
  {$EXTERNALSYM PIN_INFO}
  TPinInfo = _PinInfo;

  IEnumMediaTypes = interface;

  {$HPPEMIT 'typedef System::DelphiInterface<IPin> _di_IPin;'}
  {$EXTERNALSYM IPin}
  IPin = interface(IUnknown)
    ['{56A86891-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IPin methods ***)
    function Connect(pReceivePin: IPin; const pmt: PAMMediaType): HResult; stdcall;
    function ReceiveConnection(pConnector: IPin; const pmt: TAMMediaType): HResult; stdcall;
    function Disconnect: HResult; stdcall;
    function ConnectedTo(out pPin: IPin): HResult; stdcall;
    function ConnectionMediaType(out pmt: TAMMediaType): HResult; stdcall;
    function QueryPinInfo(out pInfo: TPinInfo): HResult; stdcall;
    function QueryDirection(out pPinDir: TPinDirection): HResult; stdcall;
    function QueryId(out Id: LPWSTR): HResult; stdcall;
    function QueryAccept(const pmt: TAMMediaType): HResult; stdcall;
    function EnumMediaTypes(out ppEnum: IEnumMediaTypes): HResult; stdcall;
    function QueryInternalConnections(out apPin: IPin; var nPin: ULONG): HResult; stdcall;
    function EndOfStream: HResult; stdcall;
    function BeginFlush: HResult; stdcall;
    function EndFlush: HResult; stdcall;
    function NewSegment(tStart, tStop: TReferenceTime; dRate: double): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IEnumPins> _di_IEnumPins;'}
  {$EXTERNALSYM IEnumPins}
  IEnumPins = interface(IUnknown)
    ['{56A86892-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IEnumPins methods ***)
    function Next(cPins: ULONG; out ppPins: IPin; pcFetched: PULONG): HResult; stdcall;
    function Skip(cPins: ULONG): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out ppEnum: IEnumPins): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IEnumMediaTypes> _di_IEnumMediaTypes;'}
  {$EXTERNALSYM IEnumMediaTypes}
  IEnumMediaTypes = interface(IUnknown)
    ['{89C31040-846B-11CE-97D3-00AA0055595A}']
    (*** IEnumMediaTypes methods ***)
    function Next(cMediaTypes: ULONG; out ppMediaTypes: PAMMediaType;
      pcFetched: PULONG): HResult; stdcall;
    function Skip(cMediaTypes: ULONG): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out ppEnum: IEnumMediaTypes): HResult; stdcall;
  end;

  IEnumFilters = interface;

  {$HPPEMIT 'typedef System::DelphiInterface<IFilterGraph> _di_IFilterGraph;'}
  {$EXTERNALSYM IFilterGraph}
  IFilterGraph = interface(IUnknown)
    ['{56A8689F-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IFilterGraph methods ***)
    function AddFilter(pFilter: IBaseFilter; pName: PWideChar): HResult; stdcall;
    function RemoveFilter(pFilter: IBaseFilter): HResult; stdcall;
    function EnumFilters(out ppEnum: IEnumFilters): HResult; stdcall;
    function FindFilterByName(pName: PWideChar; out ppFilter: IBaseFilter): HResult; stdcall;
    function ConnectDirect(ppinOut, ppinIn: IPin; pmt: PAMMediaType): HResult; stdcall;
    function Reconnect(ppin: IPin): HResult; stdcall;
    function Disconnect(ppin: IPin): HResult; stdcall;
    function SetDefaultSyncSource: HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IEnumFilters> _di_IEnumFilters;'}
  {$EXTERNALSYM IEnumFilters}
  IEnumFilters = interface(IUnknown)
    ['{56A86893-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IEnumFilters methods ***)
    function Next(cFilters: ULONG; out ppFilter: IBaseFilter;
      pcFetched: PULONG): HResult; stdcall;
    function Skip(cFilters: ULONG): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out ppEnum: IEnumFilters): HResult; stdcall;
  end;

  _FilterState = (
    State_Stopped,
    State_Paused,
    State_Running
  );
  {$EXTERNALSYM _FilterState}
  FILTER_STATE = _FilterState;
  {$EXTERNALSYM FILTER_STATE}
  TFilterState = FILTER_STATE;

  {$NODEFINE IReferenceClock}
  IReferenceClock = DirectSound.IReferenceClock;

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaFilter> _di_IMediaFilter;'}
  {$EXTERNALSYM IMediaFilter}
  IMediaFilter = interface(IPersist)
    ['{56A86899-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IMediaFilter methods ***)
    function Stop: HResult; stdcall;
    function Pause: HResult; stdcall;
    function Run(tStart: TReferenceTime): HResult; stdcall;
    function GetState(dwMilliSecsTimeout: DWORD; out State: TFilterState): HResult; stdcall;
    function SetSyncSource(pClock: IReferenceClock): HResult; stdcall;
    function GetSyncSource(out pClock: IReferenceClock): HResult; stdcall;
  end;

  _FilterInfo = record
    achName : array[0..127] of WCHAR;
    pGraph  : IFilterGraph;
  end;
  {$EXTERNALSYM _FilterInfo}
  FILTER_INFO = _FilterInfo;
  {$EXTERNALSYM FILTER_INFO}
  TFilterInfo = _FilterInfo;

  {$HPPEMIT 'typedef System::DelphiInterface<IBaseFilter> _di_IBaseFilter;'}
  {$EXTERNALSYM IBaseFilter}
  IBaseFilter = interface(IMediaFilter)
    ['{56A86895-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IBaseFilter methods ***)
    function EnumPins(out ppEnum: IEnumPins): HResult; stdcall;
    function FindPin(Id: PWideChar; out ppPin: IPin): HResult; stdcall;
    function QueryFilterInfo(out pInfo: TFilterInfo): HResult; stdcall;
    function JoinFilterGraph(pGraph: IFilterGraph; pName: PWideChar): HResult; stdcall;
    function QueryVendorInfo(out pVendorInfo: PWideChar): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IReferenceClock2> _di_IReferenceClock2;'}
  {$EXTERNALSYM IReferenceClock2}
  IReferenceClock2 = interface(IReferenceClock)
    ['{36B73885-C2C8-11CF-8B46-00805F6CEF60}']
    (*** IReferenceClock2 methods ***)
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaSample> _di_IMediaSample;'}
  {$EXTERNALSYM IMediaSample}
  IMediaSample = interface(IUnknown)
    ['{56A8689A-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IMediaSample methods ***)
    function GetPointer(out ppBuffer: PBYTE): HResult; stdcall;
    function GetSize: Longint; stdcall;
    function GetTime(out pTimeStart, pTimeEnd: TReferenceTime): HResult; stdcall;
    function SetTime(pTimeStart, pTimeEnd: PReferenceTime): HResult; stdcall;
    function IsSyncPoint: HResult; stdcall;
    function SetSyncPoint(bIsSyncPoint: BOOL): HResult; stdcall;
    function IsPreroll: HResult; stdcall;
    function SetPreroll(bIsPreroll: BOOL): HResult; stdcall;
    function GetActualDataLength: Longint; stdcall;
    function SetActualDataLength(lLen: Longint): HResult; stdcall;
    function GetMediaType(out ppMediaType: PAMMediaType): HResult; stdcall;
    function SetMediaType(pMediaType: PAMMediaType): HResult; stdcall;
    function IsDiscontinuity: HResult; stdcall;
    function SetDiscontinuity(bDiscontinuity: BOOL): HResult; stdcall;
    function GetMediaTime(out pTimeStart, pTimeEnd: int64): HResult; stdcall;
    function SetMediaTime(pTimeStart, pTimeEnd: Pint64): HResult; stdcall;
  end;

const
  AM_SAMPLE_SPLICEPOINT         = $1;
  {$EXTERNALSYM AM_SAMPLE_SPLICEPOINT}
  AM_SAMPLE_PREROLL             = $2;
  {$EXTERNALSYM AM_SAMPLE_PREROLL}
  AM_SAMPLE_DATADISCONTINUITY   = $4;
  {$EXTERNALSYM AM_SAMPLE_DATADISCONTINUITY}
  AM_SAMPLE_TYPECHANGED         = $8;
  {$EXTERNALSYM AM_SAMPLE_TYPECHANGED}
  AM_SAMPLE_TIMEVALID           = $10;
  {$EXTERNALSYM AM_SAMPLE_TIMEVALID}
  AM_SAMPLE_TIMEDISCONTINUITY   = $40;
  {$EXTERNALSYM AM_SAMPLE_TIMEDISCONTINUITY}
  AM_SAMPLE_FLUSH_ON_PAUSE      = $80;
  {$EXTERNALSYM AM_SAMPLE_FLUSH_ON_PAUSE}
  AM_SAMPLE_STOPVALID           = $100;
  {$EXTERNALSYM AM_SAMPLE_STOPVALID}
  AM_SAMPLE_ENDOFSTREAM         = $200;
  {$EXTERNALSYM AM_SAMPLE_ENDOFSTREAM}
  AM_STREAM_MEDIA               = 0;
  {$EXTERNALSYM AM_STREAM_MEDIA}
  AM_STREAM_CONTROL             = 1;
  {$EXTERNALSYM AM_STREAM_CONTROL}

type
  PAMSample2Properties = ^TAMSample2Properties;
  tagAM_SAMPLE2_PROPERTIES = record
    cbData: DWORD;
    dwTypeSpecificFlags  : DWORD;
    dwSampleFlags        : DWORD;
    lActual              : Longint;
    tStart               : Reference_Time;
    tStop                : Reference_Time;
    dwStreamId           : DWORD;
    pMediaType           : PAMMediaType;
    pbBuffer             : Pointer;
    cbBuffer             : Longint;
  end;
  {$EXTERNALSYM tagAM_SAMPLE2_PROPERTIES}
  AM_SAMPLE2_PROPERTIES = tagAM_SAMPLE2_PROPERTIES;
  {$EXTERNALSYM AM_SAMPLE2_PROPERTIES}
  TAMSample2Properties = tagAM_SAMPLE2_PROPERTIES;
  
type
  {$HPPEMIT 'typedef System::DelphiInterface<IMediaSample2> _di_IMediaSample2;'}
  {$EXTERNALSYM IMediaSample2}
  IMediaSample2 = interface(IMediaSample)
    ['{36B73884-C2C8-11CF-8B46-00805F6CEF60}']
    (*** IMediaSample2 methods ***)
    function GetProperties(cbProperties: DWORD; out pbProperties): HResult; stdcall;
    function SetProperties(cbProperties: DWORD; const pbProperties): HResult; stdcall;
  end;

const
  AM_GBF_PREVFRAMESKIPPED = 1;
  {$EXTERNALSYM AM_GBF_PREVFRAMESKIPPED}
  AM_GBF_NOTASYNCPOINT    = 2;
  {$EXTERNALSYM AM_GBF_NOTASYNCPOINT}
  AM_GBF_NOWAIT           = 4;
  {$EXTERNALSYM AM_GBF_NOWAIT}
  AM_GBF_NODDSURFACELOCK  = 8;
  {$EXTERNALSYM AM_GBF_NODDSURFACELOCK}

type

  {$HPPEMIT 'typedef System::DelphiInterface<IMemAllocator> _di_IMemAllocator;'}
  {$EXTERNALSYM IMemAllocator}
  IMemAllocator = interface(IUnknown)
    ['{56A8689C-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IMemAllocator methods ***)
    function SetProperties(var pRequest: TAllocatorProperties;
        out pActual: TAllocatorProperties): HResult; stdcall;
    function GetProperties(out pProps: TAllocatorProperties): HResult; stdcall;
    function Commit: HResult; stdcall;
    function Decommit: HResult; stdcall;
    function GetBuffer(out ppBuffer: IMediaSample;
        pStartTime, pEndTime: PReferenceTime; dwFlags: DWORD): HResult; stdcall;
    function ReleaseBuffer(pBuffer: IMediaSample): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMemAllocatorNotifyCallbackTemp> _di_IMemAllocatorNotifyCallbackTemp;'}
  {$EXTERNALSYM IMemAllocatorNotifyCallbackTemp}
  IMemAllocatorNotifyCallbackTemp = interface(IUnknown)
    ['{92980b30-c1de-11d2-abf5-00a0c905f375}']
    (*** IMemAllocatorNotifyCallbackTemp methods ***)
    function NotifyRelease: HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMemAllocatorCallbackTemp> _di_IMemAllocatorCallbackTemp;'}
  {$EXTERNALSYM IMemAllocatorCallbackTemp}
  IMemAllocatorCallbackTemp = interface(IMemAllocator)
    ['{379a0cf0-c1de-11d2-abf5-00a0c905f375}']
    (*** IMemAllocatorCallbackTemp methods ***)
    function SetNotify(pNotify: IMemAllocatorNotifyCallbackTemp): HResult; stdcall;
    function GetFreeCount(out plBuffersFree: LongInt): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMemInputPin> _di_IMemInputPin;'}
  {$EXTERNALSYM IMemInputPin}
  IMemInputPin = interface(IUnknown)
    ['{56A8689D-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IMemInputPin methods ***)
    function GetAllocator(out ppAllocator: IMemAllocator): HResult; stdcall;
    function NotifyAllocator(pAllocator: IMemAllocator; bReadOnly: BOOL): HResult; stdcall;
    function GetAllocatorRequirements(out pProps: TAllocatorProperties): HResult; stdcall;
    function Receive(pSample: IMediaSample): HResult; stdcall;
    function ReceiveMultiple(var pSamples: IMediaSample; nSamples: Longint;
        out nSamplesProcessed: Longint): HResult; stdcall;
    function ReceiveCanBlock: HResult; stdcall;
  end;

  //Deprecated Interface
  {$HPPEMIT 'typedef System::DelphiInterface<IAMovieSetup> _di_IAMovieSetup;'}
  {$EXTERNALSYM IAMovieSetup}
  IAMovieSetup = interface(IUnknown)
    ['{A3D8CEC0-7E5A-11CF-BBC5-00805F6CEF20}']
    (*** IAMovieSetup methods ***)
    function Register: HResult; stdcall;
    function Unregister: HResult; stdcall;
  end;

const
  AM_SEEKING_NoPositioning          = 0;
  {$EXTERNALSYM AM_SEEKING_NoPositioning}
  AM_SEEKING_AbsolutePositioning    = $1;
  {$EXTERNALSYM AM_SEEKING_AbsolutePositioning}
  AM_SEEKING_RelativePositioning    = $2;
  {$EXTERNALSYM AM_SEEKING_RelativePositioning}
  AM_SEEKING_IncrementalPositioning = $3;
  {$EXTERNALSYM AM_SEEKING_IncrementalPositioning}
  AM_SEEKING_PositioningBitsMask    = $3;
  {$EXTERNALSYM AM_SEEKING_PositioningBitsMask}
  AM_SEEKING_SeekToKeyFrame         = $4;
  {$EXTERNALSYM AM_SEEKING_SeekToKeyFrame}
  AM_SEEKING_ReturnTime             = $8;
  {$EXTERNALSYM AM_SEEKING_ReturnTime}
  AM_SEEKING_Segment                = $10;
  {$EXTERNALSYM AM_SEEKING_Segment}
  AM_SEEKING_NoFlush                = $20;
  {$EXTERNALSYM AM_SEEKING_NoFlush}

  AM_SEEKING_CanSeekAbsolute        = $1;
  {$EXTERNALSYM AM_SEEKING_CanSeekAbsolute}
  AM_SEEKING_CanSeekForwards        = $2;
  {$EXTERNALSYM AM_SEEKING_CanSeekForwards}
  AM_SEEKING_CanSeekBackwards       = $4;
  {$EXTERNALSYM AM_SEEKING_CanSeekBackwards}
  AM_SEEKING_CanGetCurrentPos       = $8;
  {$EXTERNALSYM AM_SEEKING_CanGetCurrentPos}
  AM_SEEKING_CanGetStopPos          = $10;
  {$EXTERNALSYM AM_SEEKING_CanGetStopPos}
  AM_SEEKING_CanGetDuration         = $20;
  {$EXTERNALSYM AM_SEEKING_CanGetDuration}
  AM_SEEKING_CanPlayBackwards       = $40;
  {$EXTERNALSYM AM_SEEKING_CanPlayBackwards}
  AM_SEEKING_CanDoSegments          = $80;
  {$EXTERNALSYM AM_SEEKING_CanDoSegments}
  AM_SEEKING_Source                 = $100;
  {$EXTERNALSYM AM_SEEKING_Source}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IMediaSeeking> _di_IMediaSeeking;'}
  {$EXTERNALSYM IMediaSeeking}
  IMediaSeeking = interface(IUnknown)
    ['{36B73880-C2C8-11CF-8B46-00805F6CEF60}']
    (*** IMediaSeeking methods ***)
    function GetCapabilities(out pCapabilities: DWORD): HResult; stdcall;
    function CheckCapabilities(var pCapabilities: DWORD): HResult; stdcall;
    function IsFormatSupported(const pFormat: TGUID): HResult; stdcall;
    function QueryPreferredFormat(out pFormat: TGUID): HResult; stdcall;
    function GetTimeFormat(out pFormat: TGUID): HResult; stdcall;
    function IsUsingTimeFormat(const pFormat: TGUID): HResult; stdcall;
    function SetTimeFormat(const pFormat: TGUID): HResult; stdcall;
    function GetDuration(out pDuration: int64): HResult; stdcall;
    function GetStopPosition(out pStop: int64): HResult; stdcall;
    function GetCurrentPosition(out pCurrent: int64): HResult; stdcall;
    function ConvertTimeFormat(out pTarget: int64; pTargetFormat: PGUID;
               Source: int64; pSourceFormat: PGUID): HResult; stdcall;
    function SetPositions(var pCurrent: int64; dwCurrentFlags: DWORD;
               var pStop: int64; dwStopFlags: DWORD): HResult; stdcall;
    function GetPositions(out pCurrent, pStop: int64): HResult; stdcall;
    function GetAvailable(out pEarliest, pLatest: int64): HResult; stdcall;
    function SetRate(dRate: double): HResult; stdcall;
    function GetRate(out pdRate: double): HResult; stdcall;
    function GetPreroll(out pllPreroll: int64): HResult; stdcall;
  end;

const
  AM_MEDIAEVENT_NONOTIFY = $01;
  {$EXTERNALSYM AM_MEDIAEVENT_NONOTIFY}

type
  PRegFilter = ^TRegFilter;
  REGFILTER = record
    Clsid: TGUID;
    Name : LPWSTR;
  end;
  {$EXTERNALSYM REGFILTER}
  TRegFilter = REGFILTER;
  
  //Deprecated Interface
  {$HPPEMIT 'typedef System::DelphiInterface<IEnumRegFilters> _di_IEnumRegFilters;'}
  {$EXTERNALSYM IEnumRegFilters}
  IEnumRegFilters = interface(IUnknown)
    ['{56A868A4-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IEnumRegFilters methods ***)
    function Next(cFilters: ULONG; out apRegFilter: TRegFilter;
        out pcFetched: ULONG): HResult; stdcall;
    function Skip(cFilters: ULONG): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out ppEnum: IEnumRegFilters): HResult; stdcall;
  end;

const
  MERIT_PREFERRED       = $800000;
  {$EXTERNALSYM MERIT_PREFERRED}
  MERIT_NORMAL          = $600000;
  {$EXTERNALSYM MERIT_NORMAL}
  MERIT_UNLIKELY        = $400000;
  {$EXTERNALSYM MERIT_UNLIKELY}
  MERIT_DO_NOT_USE      = $200000;
  {$EXTERNALSYM MERIT_DO_NOT_USE}
  MERIT_SW_COMPRESSOR   = $100000;
  {$EXTERNALSYM MERIT_SW_COMPRESSOR}
  MERIT_HW_COMPRESSOR   = $100050;
  {$EXTERNALSYM MERIT_HW_COMPRESSOR}

type

  //Deprecated Interface
  {$HPPEMIT 'typedef System::DelphiInterface<IFilterMapper> _di_IFilterMapper;'}
  {$EXTERNALSYM IFilterMapper}
  IFilterMapper = interface(IUnknown)
    ['{56A868A3-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IFilterMapper methods ***)
    function RegisterFilter(clsid: TGUID; Name: LPCWSTR; dwMerit: DWORD):HResult; stdcall;
    function RegisterFilterInstance(clsid: TGUID; Name: LPCWSTR; out MRId: TGUID): HResult; stdcall;
    function RegisterPin(Filter: TGUID; Name: LPCWSTR;
      bRendered, bOutput, bZero, bMany: BOOL; ConnectsToFilter: TGUID;
      ConnectsToPin: PWideChar): HResult; stdcall;
    function RegisterPinType(clsFilter: TGUID; strName: LPCWSTR;
      clsMajorType, clsSubType: TGUID): HResult; stdcall;
    function UnregisterFilter(Filter: TGUID): HResult; stdcall;
    function UnregisterFilterInstance(MRId: TGUID): HResult; stdcall;
    function UnregisterPin(Filter: TGUID; Name: LPCWSTR): HResult; stdcall;
    function EnumMatchingFilters(out ppEnum: IEnumRegFilters; dwMerit: DWORD;
      bInputNeeded: BOOL; const clsInMaj, clsInSub: TGUID;
      bRender, bOututNeeded: BOOL; const clsOutMaj, clsOutSub: TGUID): HResult; stdcall;
  end;

  PRegPinTypes = ^TRegPinTypes;
  REGPINTYPES = record
    clsMajorType: PGUID;
    clsMinorType: PGUID;
  end;
  {$EXTERNALSYM REGPINTYPES}
  TRegPinTypes = REGPINTYPES;

  PRegFilterPins = ^TRegFilterPins;
  REGFILTERPINS = record
    strName          : PWideChar;
    bRendered        : BOOL;
    bOutput          : BOOL;
    bZero            : BOOL;
    bMany            : BOOL;
    oFilter          : PGUID;
    strConnectsToPin : PWideChar;
    nMediaTypes      : LongWord;
    lpMediaType      : PRegPinTypes;
  end;
  {$EXTERNALSYM REGFILTERPINS}
  TRegFilterPins = REGFILTERPINS;

  PRegPinMedium = ^TRegPinMedium;
  REGPINMEDIUM = record
    clsMedium: TGUID;
    dw1: DWORD;
    dw2: DWORD;
  end;
  {$EXTERNALSYM REGPINMEDIUM}
  TRegPinMedium = REGPINMEDIUM;

const
  REG_PINFLAG_B_ZERO     = $1;
  {$EXTERNALSYM REG_PINFLAG_B_ZERO}
  REG_PINFLAG_B_RENDERER = $2;
  {$EXTERNALSYM REG_PINFLAG_B_RENDERER}
  REG_PINFLAG_B_MANY     = $4;
  {$EXTERNALSYM REG_PINFLAG_B_MANY}
  REG_PINFLAG_B_OUTPUT   = $8;
  {$EXTERNALSYM REG_PINFLAG_B_OUTPUT}

type
  PRegFilterPins2 = ^TRegFilterPins2;
  REGFILTERPINS2 = record
    dwFlags        : DWORD;
    cInstances     : UINT;
    nMediaTypes    : UINT;
    lpMediaType    : PRegPinTypes;
    nMediums       : UINT;
    lpMedium       : PRegPinMedium;
    clsPinCategory : PGUID;
  end;
  {$EXTERNALSYM REGFILTERPINS2}
  TRegFilterPins2 = REGFILTERPINS2;

  PRegFilter2 = ^TRegFilter2;
  REGFILTER2 = record
    dwVersion: DWORD;
    dwMerit: DWORD;
    case Integer of
      0: (
        cPins: ULONG;
        rgPins: PRegFilterPins;
      );
      1: (
        cPins2: ULONG;
        rgPins2: PRegFilterPins2;
      );
  end;
  {$EXTERNALSYM REGFILTER2}
  TRegFilter2 = REGFILTER2;

  {$HPPEMIT 'typedef System::DelphiInterface<IFilterMapper2> _di_IFilterMapper2;'}
  {$EXTERNALSYM IFilterMapper2}
  IFilterMapper2 = interface(IUnknown)
    ['{B79BB0B0-33C1-11D1-ABE1-00A0C905F375}']
    (*** IFilterMapper2 methods ***)
    function CreateCategory(const clsidCategory: TGUID; dwCategoryMerit: DWORD;
        Description: PWideChar): HResult; stdcall;
    function UnregisterFilter(const pclsidCategory: TGUID;
        szInstance: PWideChar; const Filter: TGUID): HResult; stdcall;
    function RegisterFilter(const clsidFilter: TGUID; Name: PWideChar;
        ppMoniker: IMoniker; pclsidCategory: PGUID;
        szInstance: PWideChar; const prf2: TRegFilter2): HResult; stdcall;
    function EnumMatchingFilters(out ppEnum: IEnumMoniker; dwFlags: DWORD; bExactMatch: BOOL;
        dwMerit: DWORD; bInputNeeded: BOOL; cInputTypes: DWORD; pInputTypes: PGUID;
        pMedIn: PREGPINMEDIUM; pPinCategoryIn: PGUID; bRender, bOutputNeeded: BOOL;
        cOutputTypes: DWORD; pOutputTypes: PGUID; pMedOut: PRegPinMedium;
        pPinCategoryOut: PGUID): HResult; stdcall;
  end;

  tagQualityMessageType = (
    Famine,
    Flood
  );
  {$EXTERNALSYM tagQualityMessageType}
  QualityMessageType = tagQualityMessageType;
  {$EXTERNALSYM QualityMessageType}
  TQualityMessageType = QualityMessageType;

  PQuality = ^TQuality;
  tagQuality = record
    Typ        : QualityMessageType;
    Proportion : Longint;
    Late       : Reference_Time;
    TimeStamp  : Reference_Time;
  end;
  {$EXTERNALSYM tagQuality}
  Quality = tagQuality;
  {$EXTERNALSYM Quality}
  TQuality = tagQuality;

  {$HPPEMIT 'typedef System::DelphiInterface<IQualityControl> _di_IQualityControl;'}
  {$EXTERNALSYM IQualityControl}
  IQualityControl = interface(IUnknown)
    ['{56A868A5-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IQualityControl methods ***)
    function Notify(pSelf: IBaseFilter; q: TQuality): HResult; stdcall;
    function SetSink(piqc: IQualityControl): HResult; stdcall;
  end;

const
  CK_NOCOLORKEY = $0;
  {$EXTERNALSYM CK_NOCOLORKEY}
  CK_INDEX      = $1;
  {$EXTERNALSYM CK_INDEX}
  CK_RGB        = $2;
  {$EXTERNALSYM CK_RGB}

type
  PColorKey = ^TColorKey;
  tagCOLORKEY = record
    KeyType        : DWORD;
    PaletteIndex   : DWORD;
    LowColorValue  : COLORREF;
    HighColorValue : COLORREF;
  end;
  {$EXTERNALSYM tagCOLORKEY}
  COLORKEY = tagCOLORKEY;
  {$EXTERNALSYM COLORKEY}
  TColorKey = tagCOLORKEY;

const
  ADVISE_NONE       = 0;
  {$EXTERNALSYM ADVISE_NONE}
  ADVISE_CLIPPING   = $1;
  {$EXTERNALSYM ADVISE_CLIPPING}
  ADVISE_PALETTE    = $2;
  {$EXTERNALSYM ADVISE_PALETTE}
  ADVISE_COLORKEY   = $4;
  {$EXTERNALSYM ADVISE_COLORKEY}
  ADVISE_POSITION   = $8;
  {$EXTERNALSYM ADVISE_POSITION}

  ADVISE_ALL = ADVISE_CLIPPING or ADVISE_PALETTE or ADVISE_COLORKEY or ADVISE_POSITION;
  {$EXTERNALSYM ADVISE_ALL}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IOverlayNotify> _di_IOverlayNotify;'}
  {$EXTERNALSYM IOverlayNotify}
  IOverlayNotify = interface(IUnknown)
    ['{56A868A0-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IOverlayNotify methods ***)
    function OnPaletteChange(dwColors: DWORD; const pPalette: PPALETTEENTRY): HResult; stdcall;
    function OnClipChange(const pSourceRect, pDestinationRect: TRect;
        const pRgnData: TRgnData): HResult; stdcall;
    function OnColorKeyChange(const pColorKey: TColorKey): HResult; stdcall;
    function OnPositionChange(const pSourceRect, pDestinationRect: TRect): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IOverlayNotify2> _di_IOverlayNotify2;'}
  {$EXTERNALSYM IOverlayNotify2}
  IOverlayNotify2 = interface(IOverlayNotify)
    ['{680EFA10-D535-11D1-87C8-00A0C9223196}']
    (*** IOverlayNotify2 methods ***)
    function OnDisplayChange(var hMonitor: HMONITOR ): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IOverlay> _di_IOverlay;'}
  {$EXTERNALSYM IOverlay}
  IOverlay = interface(IUnknown)
    ['{56A868A1-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IOverlay methods ***)
    function GetPalette(out pdwColors: DWORD; out ppPalette: PPALETTEENTRY): HResult; stdcall;
    function SetPalette(dwColors: DWORD; var pPalette: PaletteEntry): HResult; stdcall;
    function GetDefaultColorKey(out pColorKey: TColorKey): HResult; stdcall;
    function GetColorKey(out pColorKey: TColorKey): HResult; stdcall;
    function SetColorKey(var pColorKey: TColorKey): HResult; stdcall;
    function GetWindowHandle(out pHwnd: HWND): HResult; stdcall;
    function GetClipList(out pSourceRect, pDestinationRect: TRect;
        out ppRgnData: PRgnData): HResult; stdcall;
    function GetVideoPosition(out pSourceRect, pDestinationRect: TRect): HResult; stdcall;
    function Advise(pOverlayNotify: IOverlayNotify; dwInterests: DWORD): HResult; stdcall;
    function Unadvise: HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaEventSink> _di_IMediaEventSink;'}
  {$EXTERNALSYM IMediaEventSink}
  IMediaEventSink = interface(IUnknown)
    ['{56A868A2-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IMediaEventSink methods ***)
    function Notify(EventCode, EventParam1, EventParam2: Longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IFileSourceFilter> _di_IFileSourceFilter;'}
  {$EXTERNALSYM IFileSourceFilter}
  IFileSourceFilter = interface(IUnknown)
    ['{56A868A6-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IFileSourceFilter methods ***)
    function Load(pszFileName: PWCHAR; const pmt: PAMMediaType): HResult; stdcall;
    function GetCurFile(out ppszFileName: PWideChar; pmt: PAMMediaType): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IFileSinkFilter> _di_IFileSinkFilter;'}
  {$EXTERNALSYM IFileSinkFilter}
  IFileSinkFilter = interface(IUnknown)
    ['{A2104830-7C70-11CF-8BCE-00AA00A3F1A6}']
    (*** IFileSinkFilter methods ***)
    function SetFileName(pszFileName: PWideChar; pmt: PAMMediaType): HResult; stdcall;
    function GetCurFile(out ppszFileName: PWideChar; pmt: PAMMediaType): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IFileSinkFilter2> _di_IFileSinkFilter2;'}
  {$EXTERNALSYM IFileSinkFilter2}
  IFileSinkFilter2 = interface(IFileSinkFilter)
    ['{00855B90-CE1B-11D0-BD4F-00A0C911CE86}']
    (*** IFileSinkFilter2 methods ***)
    function SetMode(dwFlags: DWORD): HResult; stdcall;
    function GetMode(out pdwFlags: DWORD): HResult; stdcall;
  end;

  AM_FILESINK_FLAGS = (
  {$IFNDEF COMPILER6_UP}
    AM_FILE_INVALID_0 {= 0},
    AM_FILE_OVERWRITE {= 1}
  {$ELSE}
    AM_FILE_OVERWRITE = 1
  {$ENDIF}
  );
  {$EXTERNALSYM AM_FILESINK_FLAGS}
  TAMFileSinkFlags = AM_FILESINK_FLAGS;


//  Very old !!!!!
//  PAsyncIOReq = ^TAsyncIOReq;
//  TAsyncIOReq = record
//    engine: array[0..3] of DWORD;
//    lpv: Pointer;
//    cb: DWORD;
//    dwError: DWORD;
//    cbDone: DWORD;
//    liPos: TLargeInteger;
//    hEvent: DWORD;
//    dwUser: DWORD;
//  end;

//  IFileAsyncIO = interface(IUnknown)
//    ['{56A868A7-0AD4-11CE-B03A-0020AF0BA770}']
//    function QueryAlignment(out pdwAlign: DWORD): HResult; stdcall;
//    function Read(const pReq: TAsyncIOReq): HResult; stdcall;
//    function Write(const pReq: TAsyncIOReq): HResult; stdcall;
//    function WaitForNext(out ppReq: PAsyncIOReq;
//        dwTimeout: DWORD): HResult; stdcall;
//    function WaitForSpecific(out pReq: TAsyncIOReq;
//        dwTimeout: DWORD): HResult; stdcall;
//    function DiscardPending: HResult; stdcall;
//    function Flush: HResult; stdcall;
//  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IGraphBuilder> _di_IGraphBuilder;'}
  {$EXTERNALSYM IGraphBuilder}
  IGraphBuilder = interface(IFilterGraph)
    ['{56A868A9-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IGraphBuilder methods ***)
    function Connect(ppinOut, ppinIn: IPin): HResult; stdcall;
    function Render(ppinOut: IPin): HResult; stdcall;
    function RenderFile(lpcwstrFile, lpcwstrPlayList: PWideChar): HResult; stdcall;
    function AddSourceFilter(lpcwstrFileName, lpcwstrFilterName: LPCWSTR;
        out ppFilter: IBaseFilter): HResult; stdcall;
    function SetLogFile(hFile: THandle): HResult; stdcall;
    function Abort: HResult; stdcall;
    function ShouldOperationContinue: HResult; stdcall;
  end;

  IAMCopyCaptureFileProgress = interface;

  //Deprecated Interface
  {$HPPEMIT 'typedef System::DelphiInterface<ICaptureGraphBuilder> _di_ICaptureGraphBuilder;'}
  {$EXTERNALSYM ICaptureGraphBuilder}
  ICaptureGraphBuilder = interface(IUnknown)
    ['{BF87B6E0-8C27-11D0-B3F0-00AA003761C5}']
    (*** ICaptureGraphBuilder methods ***)
    function SetFiltergraph(pfg: IGraphBuilder): HResult; stdcall;
    function GetFiltergraph(out ppfg: IGraphBuilder): HResult; stdcall;
    function SetOutputFileName(const pType: TGUID; lpstrFile: PWCHAR;
        out ppf: IBaseFilter; out ppSink: IFileSinkFilter): HResult; stdcall;
    function FindInterface(pCategory: PGUID; pf: IBaseFilter;
        const riid: TGUID; out ppint): HResult; stdcall;
    function RenderStream(pCategory: PGUID; pSource: IUnknown;
        pfCompressor, pfRenderer: IBaseFilter): HResult; stdcall;
    function ControlStream(pCategory: PGUID; pFilter: IBaseFilter;
        pstart, pstop: PReferenceTime; wStartCookie, wStopCookie: WORD): HResult; stdcall;
    function AllocCapFile(lpstr: PWCHAR; dwlSize: int64): HResult; stdcall;
    function CopyCaptureFile(lpwstrOld, lpwstrNew: PWCHAR; fAllowEscAbort: Integer;
        pCallback: IAMCopyCaptureFileProgress): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<ICaptureGraphBuilder2> _di_ICaptureGraphBuilder2;'}
  {$EXTERNALSYM ICaptureGraphBuilder2}
  ICaptureGraphBuilder2 = interface(IUnknown)
    ['{93E5A4E0-2D50-11d2-ABFA-00A0C9C6E38D}']
    (*** ICaptureGraphBuilder2 methods ***)
    function SetFiltergraph(pfg: IGraphBuilder): HResult; stdcall;
    function GetFiltergraph(out ppfg: IGraphBuilder): HResult; stdcall;
    function SetOutputFileName(const pType: TGUID; lpstrFile: PWCHAR; out ppf: IBaseFilter; out ppSink: IFileSinkFilter): HResult; stdcall;
    function FindInterface(pCategory, pType: PGUID; pf: IBaseFilter; const riid: TGUID; out ppint): HResult; stdcall;
    function RenderStream(pCategory, pType: PGUID; pSource: IUnknown; pfCompressor, pfRenderer: IBaseFilter): HResult; stdcall;
    function ControlStream(pCategory, pType: PGUID; pFilter: IBaseFilter; pstart, pstop: PReferenceTime; wStartCookie, wStopCookie: WORD ): HResult; stdcall;
    function AllocCapFile(lpstr: PWCHAR; dwlSize: int64): HResult; stdcall;
    function CopyCaptureFile(lpwstrOld, lpwstrNew: PWCHAR; fAllowEscAbort: Integer; pCallback: IAMCopyCaptureFileProgress): HResult; stdcall;
    function FindPin(pSource: IUnknown; pindir: TPINDIRECTION; const pCategory, pType: PGUID; fUnconnected: BOOL; num: integer; out ppPin: IPin): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMCopyCaptureFileProgress> _di_IAMCopyCaptureFileProgress;'}
  {$EXTERNALSYM IAMCopyCaptureFileProgress}
  IAMCopyCaptureFileProgress = interface(IUnknown)
    ['{670D1D20-A068-11D0-B3F0-00AA003761C5}']
    (*** IAMCopyCaptureFileProgress methods ***)
    function Progress(iProgress: Integer): HResult; stdcall;
  end;

const
  AM_RENDEREX_RENDERTOEXISTINGRENDERERS = $01;
  {$EXTERNALSYM AM_RENDEREX_RENDERTOEXISTINGRENDERERS}

type

  {$HPPEMIT 'typedef System::DelphiInterface<IFilterGraph2> _di_IFilterGraph2;'}
  {$EXTERNALSYM IFilterGraph2}
  IFilterGraph2 = interface(IGraphBuilder)
    ['{36B73882-C2C8-11CF-8B46-00805F6CEF60}']
    (*** IFilterGraph2 methods ***)
    function AddSourceFilterForMoniker(pMoniker: IMoniker; pCtx: IBindCtx;
        lpcwstrFilterName: LPCWSTR; out ppFilter: IBaseFilter): HResult; stdcall;
    function ReconnectEx(ppin: IPin; pmt: PAMMediaType): HResult; stdcall;
    // Render a pin without adding any new renderers (pvContext = nil)
    // not in the documentation ??
    function RenderEx(pPinOut: IPin; dwFlags: DWORD; pvContext: PDWORD): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IStreamBuilder> _di_IStreamBuilder;'}
  {$EXTERNALSYM IStreamBuilder}
  IStreamBuilder = interface(IUnknown)
    ['{56A868BF-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IStreamBuilder methods ***)
    function Render(ppinOut: IPin; pGraph: IGraphBuilder): HResult; stdcall;
    function Backout(ppinOut: IPin; pGraph: IGraphBuilder): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAsyncReader> _di_IAsyncReader;'}
  {$EXTERNALSYM IAsyncReader}
  IAsyncReader = interface(IUnknown)
    ['{56A868AA-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IAsyncReader methods ***)
    {nev: start}
    function RequestAllocator(pPreferred: IMemAllocator;
      pProps: PAllocatorProperties; out ppActual: IMemAllocator): HResult; stdcall;
    {nev: end}
    function Request(pSample: IMediaSample; dwUser: DWORD): HResult; stdcall;
    function WaitForNext(dwTimeout: DWORD; out ppSample: IMediaSample;
        out pdwUser: DWORD): HResult; stdcall;
    function SyncReadAligned(pSample: IMediaSample): HResult; stdcall;
    function SyncRead(llPosition: int64; lLength: Longint; pBuffer: Pbyte): HResult; stdcall;
    function Length(out pTotal, pAvailable: int64): HResult; stdcall;
    function BeginFlush: HResult; stdcall;
    function EndFlush: HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IGraphVersion> _di_IGraphVersion;'}
  {$EXTERNALSYM IGraphVersion}
  IGraphVersion = interface(IUnknown)
    ['{56A868AB-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IGraphVersion methods ***)
    function QueryVersion(var pVersion: Longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IResourceConsumer> _di_IResourceConsumer;'}
  {$EXTERNALSYM IResourceConsumer}
  IResourceConsumer = interface(IUnknown)
    ['{56A868AD-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IResourceConsumer methods ***)
    function AcquireResource(idResource: Longint): HResult; stdcall;
    function ReleaseResource(idResource: Longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IResourceManager> _di_IResourceManager;'}
  {$EXTERNALSYM IResourceManager}
  IResourceManager = interface(IUnknown)
    ['{56A868AC-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IResourceManager methods ***)
    function Register(pName: LPCWSTR; cResource: Longint;
        out plToken: Longint): HResult; stdcall;
    function RegisterGroup(pName: LPCWSTR; cResource: Longint;
        palTokens: PLongint; out plToken: Longint): HResult; stdcall;
    function RequestResource(idResource: Longint; pFocusObject: IUnknown;
        pConsumer: IResourceConsumer): HResult; stdcall;
    function NotifyAcquire(idResource: Longint; pConsumer: IResourceConsumer;
        hr: HResult): HResult; stdcall;
    function NotifyRelease(idResource: Longint; pConsumer: IResourceConsumer;
        bStillWant: BOOL): HResult; stdcall;
    function CancelRequest(idResource: Longint; pConsumer: IResourceConsumer): HResult; stdcall;
    function SetFocus(pFocusObject: IUnknown): HResult; stdcall;
    function ReleaseFocus(pFocusObject: IUnknown): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDistributorNotify> _di_IDistributorNotify;'}
  {$EXTERNALSYM IDistributorNotify}
  IDistributorNotify = interface(IUnknown)
    ['{56A868AF-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IDistributorNotify methods ***)
    function Stop: HResult; stdcall;
    function Pause: HResult; stdcall;
    function Run(tStart: TReferenceTime): HResult; stdcall;
    function SetSyncSource(pClock: IReferenceClock): HResult; stdcall;
    function NotifyGraphChange: HResult; stdcall;
  end;

  AM_STREAM_INFO_FLAGS =  {$IFDEF TYPE_IDENTITY}type {$ENDIF}DWord;
  {$EXTERNALSYM AM_STREAM_INFO_FLAGS}
  const
    AM_STREAM_INFO_START_DEFINED   = $1;
    {$EXTERNALSYM AM_STREAM_INFO_START_DEFINED}
    AM_STREAM_INFO_STOP_DEFINED    = $2;
    {$EXTERNALSYM AM_STREAM_INFO_STOP_DEFINED}
    AM_STREAM_INFO_DISCARDING      = $4;
    {$EXTERNALSYM AM_STREAM_INFO_DISCARDING}
    AM_STREAM_INFO_STOP_SEND_EXTRA = $10;
    {$EXTERNALSYM AM_STREAM_INFO_STOP_SEND_EXTRA}

type
  PAMStreamInfo = ^TAMStreamInfo;
  AM_STREAM_INFO = record
    tStart        : Reference_Time;
    tStop         : Reference_Time;
    dwStartCookie : DWORD;
    dwStopCookie  : DWORD;
    dwFlags       : DWORD;
  end;
  {$EXTERNALSYM AM_STREAM_INFO}
  TAMStreamInfo = AM_STREAM_INFO;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMStreamControl> _di_IAMStreamControl;'}
  {$EXTERNALSYM IAMStreamControl}
  IAMStreamControl = interface(IUnknown)
    ['{36b73881-c2c8-11cf-8b46-00805f6cef60}']
    (*** IAMStreamControl methods ***)
    function StartAt(ptStart: PReferenceTime; dwCookie: DWORD): HResult; stdcall;
    function StopAt(ptStop: PReferenceTime; bSendExtra: BOOL;
        dwCookie: DWORD): HResult; stdcall;
    function GetInfo(out pInfo: TAMStreamInfo): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<ISeekingPassThru> _di_ISeekingPassThru;'}
  {$EXTERNALSYM ISeekingPassThru}
  ISeekingPassThru = interface(IUnknown)
    ['{36B73883-C2C8-11CF-8B46-00805F6CEF60}']
    (*** ISeekingPassThru methods ***)
    function Init(bSupportRendering: BOOL; pPin: IPin): HResult; stdcall;
  end;

  PVideoStreamConfigCaps = ^TVideoStreamConfigCaps;
  _VIDEO_STREAM_CONFIG_CAPS = record
    guid: TGUID;
    VideoStandard      : ULONG;
    InputSize          : TSize;
    MinCroppingSize    : TSize;
    MaxCroppingSize    : TSize;
    CropGranularityX   : Integer;
    CropGranularityY   : Integer;
    CropAlignX         : Integer;
    CropAlignY         : Integer;
    MinOutputSize      : TSize;
    MaxOutputSize      : TSize;
    OutputGranularityX : Integer;
    OutputGranularityY : Integer;
    StretchTapsX       : Integer;
    StretchTapsY       : Integer;
    ShrinkTapsX        : Integer;
    ShrinkTapsY        : Integer;
    MinFrameInterval   : Int64;
    MaxFrameInterval   : Int64;
    MinBitsPerSecond   : Longint;
    MaxBitsPerSecond   : Longint;
  end;
  {$EXTERNALSYM _VIDEO_STREAM_CONFIG_CAPS}
  VIDEO_STREAM_CONFIG_CAPS = _VIDEO_STREAM_CONFIG_CAPS;
  {$EXTERNALSYM VIDEO_STREAM_CONFIG_CAPS}
  TVideoStreamConfigCaps = _VIDEO_STREAM_CONFIG_CAPS;

  PAudioStreamConfigCaps = ^TAudioStreamConfigCaps;
  _AUDIO_STREAM_CONFIG_CAPS = record
    guid: TGUID;
    MinimumChannels            : ULONG;
    MaximumChannels            : ULONG;
    ChannelsGranularity        : ULONG;
    MinimumBitsPerSample       : ULONG;
    MaximumBitsPerSample       : ULONG;
    BitsPerSampleGranularity   : ULONG;
    MinimumSampleFrequency     : ULONG;
    MaximumSampleFrequency     : ULONG;
    SampleFrequencyGranularity : ULONG;
  end;
  {$EXTERNALSYM _AUDIO_STREAM_CONFIG_CAPS}
  AUDIO_STREAM_CONFIG_CAPS = _AUDIO_STREAM_CONFIG_CAPS;
  {$EXTERNALSYM AUDIO_STREAM_CONFIG_CAPS}
  TAudioStreamConfigCaps = _AUDIO_STREAM_CONFIG_CAPS;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMStreamConfig> _di_IAMStreamConfig;'}
  {$EXTERNALSYM IAMStreamConfig}
  IAMStreamConfig = interface(IUnknown)
    ['{C6E13340-30AC-11d0-A18C-00A0C9118956}']
    (*** IAMStreamConfig methods ***)
    function SetFormat(const pmt: TAMMediaType): HResult; stdcall;
    function GetFormat(out ppmt: PAMMediaType): HResult; stdcall;
    function GetNumberOfCapabilities(out piCount, piSize: Integer): HResult; stdcall;
    function GetStreamCaps(iIndex: Integer; out ppmt: PAMMediaType;
      out pSCC): HResult; stdcall;
  end;

  InterleavingMode = (
    INTERLEAVE_NONE,
    INTERLEAVE_CAPTURE,
    INTERLEAVE_FULL,
    INTERLEAVE_NONE_BUFFERED
  );
  {$EXTERNALSYM InterleavingMode}
  TInterleavingMode = InterleavingMode;

  {$HPPEMIT 'typedef System::DelphiInterface<IConfigInterleaving> _di_IConfigInterleaving;'}
  {$EXTERNALSYM IConfigInterleaving}
  IConfigInterleaving = interface(IUnknown)
    ['{BEE3D220-157B-11d0-BD23-00A0C911CE86}']
    (*** IConfigInterleaving methods ***)
    function put_Mode(mode: TInterleavingMode): HResult; stdcall;
    function get_Mode(out pMode: TInterleavingMode): HResult; stdcall;
    function put_Interleaving(prtInterleave, prtPreroll: PReferenceTime): HResult; stdcall;
    function get_Interleaving(out prtInterleave, prtPreroll: TReferenceTime): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IConfigAviMux> _di_IConfigAviMux;'}
  {$EXTERNALSYM IConfigAviMux}
  IConfigAviMux = interface(IUnknown)
    ['{5ACD6AA0-F482-11ce-8B67-00AA00A3F1A6}']
    (*** IConfigAviMux methods ***)
    function SetMasterStream(iStream: Longint): HResult; stdcall;
    function GetMasterStream(out pStream: Longint): HResult; stdcall;
    function SetOutputCompatibilityIndex(fOldIndex: BOOL): HResult; stdcall;
    function GetOutputCompatibilityIndex(out pfOldIndex: BOOL): HResult; stdcall;
  end;

const
  CompressionCaps_CanQuality    = $1;
  {$EXTERNALSYM CompressionCaps_CanQuality}
  CompressionCaps_CanCrunch     = $2;
  {$EXTERNALSYM CompressionCaps_CanCrunch}
  CompressionCaps_CanKeyFrame   = $4;
  {$EXTERNALSYM CompressionCaps_CanKeyFrame}
  CompressionCaps_CanBFrame     = $8;
  {$EXTERNALSYM CompressionCaps_CanBFrame}
  CompressionCaps_CanWindow     = $10;
  {$EXTERNALSYM CompressionCaps_CanWindow}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMVideoCompression> _di_IAMVideoCompression;'}
  {$EXTERNALSYM IAMVideoCompression}
  IAMVideoCompression = interface(IUnknown)
    ['{C6E13343-30AC-11d0-A18C-00A0C9118956}']
    (*** IAMVideoCompression methods ***)
    function put_KeyFrameRate(KeyFrameRate: Longint): HResult; stdcall;
    function get_KeyFrameRate(out pKeyFrameRate: Longint): HResult; stdcall;
    function put_PFramesPerKeyFrame(PFramesPerKeyFrame: Longint): HResult; stdcall;
    function get_PFramesPerKeyFrame(out pPFramesPerKeyFrame: Longint): HResult; stdcall;
    function put_Quality(Quality: double): HResult; stdcall;
    function get_Quality(out pQuality: double): HResult; stdcall;
    function put_WindowSize(WindowSize: int64): HResult; stdcall;
    function get_WindowSize(out pWindowSize: int64): HResult; stdcall;
    function GetInfo(pszVersion: PWideChar; var pcbVersion: Integer;
        pszDescription: PWideChar; var pcbDescription: Integer;
        out pDefaultKeyFrameRate, pDefaultPFramesPerKey: Longint;
        out pDefaultQuality: double; out pCapabilities: Longint): HResult; stdcall;
    function OverrideKeyFrame(FrameNumber: Longint): HResult; stdcall;
    function OverrideFrameSize(FrameNumber, Size: Longint): HResult; stdcall;
  end;

const
  VfwCaptureDialog_Source  = $1;
  {$EXTERNALSYM VfwCaptureDialog_Source}
  VfwCaptureDialog_Format  = $2;
  {$EXTERNALSYM VfwCaptureDialog_Format}
  VfwCaptureDialog_Display = $4;
  {$EXTERNALSYM VfwCaptureDialog_Display}

  VfwCompressDialog_Config = $1;
  {$EXTERNALSYM VfwCompressDialog_Config}
  VfwCompressDialog_About  = $2;
  {$EXTERNALSYM VfwCompressDialog_About}

  VfwCompressDialog_QueryConfig = $4;
  {$EXTERNALSYM VfwCompressDialog_QueryConfig}
  VfwCompressDialog_QueryAbout  = $8;
  {$EXTERNALSYM VfwCompressDialog_QueryAbout}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMVfwCaptureDialogs> _di_IAMVfwCaptureDialogs;'}
  {$EXTERNALSYM IAMVfwCaptureDialogs}
  IAMVfwCaptureDialogs = interface(IUnknown)
    ['{D8D715A0-6E5E-11D0-B3F0-00AA003761C5}']
    (*** IAMVfwCaptureDialogs methods ***)
    function HasDialog(iDialog: Integer): HResult; stdcall;
    function ShowDialog(iDialog: Integer; hwnd: HWND): HResult; stdcall;
    function SendDriverMessage(iDialog: Integer; uMsg: Integer;
        dw1, dw2: Longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMVfwCompressDialogs> _di_IAMVfwCompressDialogs;'}
  {$EXTERNALSYM IAMVfwCompressDialogs}
  IAMVfwCompressDialogs = interface(IUnknown)
    ['{D8D715A3-6E5E-11D0-B3F0-00AA003761C5}']
    (*** IAMVfwCompressDialogs methods ***)
    function ShowDialog(iDialog: Integer; hwnd: HWND): HResult; stdcall;
    function GetState(out pState; var pcbState: Integer): HResult; stdcall;
    function SetState(var pState; cbState: Integer): HResult; stdcall;
    function SendDriverMessage(uMsg: Integer; dw1, dw2: Longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMDroppedFrames> _di_IAMDroppedFrames;'}
  {$EXTERNALSYM IAMDroppedFrames}
  IAMDroppedFrames = interface(IUnknown)
    ['{C6E13344-30AC-11d0-A18C-00A0C9118956}']
    (*** IAMDroppedFrames methods ***)
    function GetNumDropped(out plDropped: Longint): HResult; stdcall;
    function GetNumNotDropped(out plNotDropped: Longint): HResult; stdcall;
    function GetDroppedInfo(lSize: Longint; out plArray: Longint;
        out plNumCopied: Longint): HResult; stdcall;
    function GetAverageFrameSize(out plAverageSize: Longint): HResult; stdcall;
  end;

const
  AMF_AUTOMATICGAIN = -1;
  {$EXTERNALSYM AMF_AUTOMATICGAIN}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMAudioInputMixer> _di_IAMAudioInputMixer;'}
  {$EXTERNALSYM IAMAudioInputMixer}
  IAMAudioInputMixer = interface(IUnknown)
    ['{54C39221-8380-11d0-B3F0-00AA003761C5}']
    (*** IAMAudioInputMixer methods ***)
    function put_Enable(fEnable: BOOL): HResult; stdcall;
    function get_Enable(out pfEnable: BOOL): HResult; stdcall;
    function put_Mono(fMono: BOOL): HResult; stdcall;
    function get_Mono(out pfMono: BOOL): HResult; stdcall;
    function put_MixLevel(Level: double): HResult; stdcall;
    function get_MixLevel(out pLevel: double): HResult; stdcall;
    function put_Pan(Pan: double): HResult; stdcall;
    function get_Pan(out pPan: double): HResult; stdcall;
    function put_Loudness(fLoudness: BOOL): HResult; stdcall;
    function get_Loudness(out pfLoudness: BOOL): HResult; stdcall;
    function put_Treble(Treble: double): HResult; stdcall;
    function get_Treble(out pTreble: double): HResult; stdcall;
    function get_TrebleRange(out pRange: double): HResult; stdcall;
    function put_Bass(Bass: double): HResult; stdcall;
    function get_Bass(out pBass: double): HResult; stdcall;
    function get_BassRange(out pRange: double): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMBufferNegotiation> _di_IAMBufferNegotiation;'}
  {$EXTERNALSYM IAMBufferNegotiation}
  IAMBufferNegotiation = interface(IUnknown)
    ['{56ED71A0-AF5F-11D0-B3F0-00AA003761C5}']
    (*** IAMBufferNegotiation methods ***)
    function SuggestAllocatorProperties(const pprop: TAllocatorProperties): HResult; stdcall;
    function GetAllocatorProperties(var pprop: TAllocatorProperties): HResult; stdcall;
  end;

const
  AnalogVideo_None        = 0;
  {$EXTERNALSYM AnalogVideo_None}
  AnalogVideo_NTSC_M      = $1;
  {$EXTERNALSYM AnalogVideo_NTSC_M}
  AnalogVideo_NTSC_M_J    = $2;
  {$EXTERNALSYM AnalogVideo_NTSC_M_J}
  AnalogVideo_NTSC_433    = $4;
  {$EXTERNALSYM AnalogVideo_NTSC_433}
  AnalogVideo_PAL_B       = $10;
  {$EXTERNALSYM AnalogVideo_PAL_B}
  AnalogVideo_PAL_D       = $20;
  {$EXTERNALSYM AnalogVideo_PAL_D}
  AnalogVideo_PAL_G       = $40;
  {$EXTERNALSYM AnalogVideo_PAL_G}
  AnalogVideo_PAL_H       = $80;
  {$EXTERNALSYM AnalogVideo_PAL_H}
  AnalogVideo_PAL_I       = $100;
  {$EXTERNALSYM AnalogVideo_PAL_I}
  AnalogVideo_PAL_M       = $200;
  {$EXTERNALSYM AnalogVideo_PAL_M}
  AnalogVideo_PAL_N       = $400;
  {$EXTERNALSYM AnalogVideo_PAL_N}
  AnalogVideo_PAL_60      = $800;
  {$EXTERNALSYM AnalogVideo_PAL_60}
  AnalogVideo_SECAM_B     = $1000;
  {$EXTERNALSYM AnalogVideo_SECAM_B}
  AnalogVideo_SECAM_D     = $2000;
  {$EXTERNALSYM AnalogVideo_SECAM_D}
  AnalogVideo_SECAM_G     = $4000;
  {$EXTERNALSYM AnalogVideo_SECAM_G}
  AnalogVideo_SECAM_H     = $8000;
  {$EXTERNALSYM AnalogVideo_SECAM_H}
  AnalogVideo_SECAM_K     = $10000;
  {$EXTERNALSYM AnalogVideo_SECAM_K}
  AnalogVideo_SECAM_K1    = $20000;
  {$EXTERNALSYM AnalogVideo_SECAM_K1}
  AnalogVideo_SECAM_L     = $40000;
  {$EXTERNALSYM AnalogVideo_SECAM_L}
  AnalogVideo_SECAM_L1    = $80000;
  {$EXTERNALSYM AnalogVideo_SECAM_L1}

  AnalogVideo_NTSC_Mask   = $00000007;
  {$EXTERNALSYM AnalogVideo_NTSC_Mask}
  AnalogVideo_PAL_Mask    = $00000FF0;
  {$EXTERNALSYM AnalogVideo_PAL_Mask}
  AnalogVideo_SECAM_Mask  = $000FF000;
  {$EXTERNALSYM AnalogVideo_SECAM_Mask}

type
  tagTunerInputType =(
    TunerInputCable,
    TunerInputAntenna
  );
  {$EXTERNALSYM tagTunerInputType}
  TunerInputType = tagTunerInputType;
  {$EXTERNALSYM TunerInputType}
  TTunerInputType = TunerInputType;

  VideoCopyProtectionType = (
    VideoCopyProtectionMacrovisionBasic,
    VideoCopyProtectionMacrovisionCBI
  );
  {$EXTERNALSYM VideoCopyProtectionType}
  TVideoCopyProtectionType = VideoCopyProtectionType;

  TPhysicalConnectorType = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  const
    PhysConn_Video_Tuner	         = 1;
    {$EXTERNALSYM PhysConn_Video_Tuner}
    PhysConn_Video_Composite	     = PhysConn_Video_Tuner + 1;
    {$EXTERNALSYM PhysConn_Video_Composite}
    PhysConn_Video_SVideo	         = PhysConn_Video_Composite + 1;
    {$EXTERNALSYM PhysConn_Video_SVideo}
    PhysConn_Video_RGB	           = PhysConn_Video_SVideo + 1;
    {$EXTERNALSYM PhysConn_Video_RGB}
    PhysConn_Video_YRYBY	         = PhysConn_Video_RGB + 1;
    {$EXTERNALSYM PhysConn_Video_YRYBY}
    PhysConn_Video_SerialDigital	 = PhysConn_Video_YRYBY + 1;
    {$EXTERNALSYM PhysConn_Video_SerialDigital}
    PhysConn_Video_ParallelDigital = PhysConn_Video_SerialDigital + 1;
    {$EXTERNALSYM PhysConn_Video_ParallelDigital}
    PhysConn_Video_SCSI	           = PhysConn_Video_ParallelDigital + 1;
    {$EXTERNALSYM PhysConn_Video_SCSI}
    PhysConn_Video_AUX	           = PhysConn_Video_SCSI + 1;
    {$EXTERNALSYM PhysConn_Video_AUX}
    PhysConn_Video_1394	           = PhysConn_Video_AUX + 1;
    {$EXTERNALSYM PhysConn_Video_1394}
    PhysConn_Video_USB	           = PhysConn_Video_1394 + 1;
    {$EXTERNALSYM PhysConn_Video_USB}
    PhysConn_Video_VideoDecoder	   = PhysConn_Video_USB + 1;
    {$EXTERNALSYM PhysConn_Video_VideoDecoder}
    PhysConn_Video_VideoEncoder	   = PhysConn_Video_VideoDecoder + 1;
    {$EXTERNALSYM PhysConn_Video_VideoEncoder}
    PhysConn_Video_SCART	         = PhysConn_Video_VideoEncoder + 1;
    {$EXTERNALSYM PhysConn_Video_SCART}
    PhysConn_Video_Black	         = PhysConn_Video_SCART + 1;
    {$EXTERNALSYM PhysConn_Video_Black}
    PhysConn_Audio_Tuner	         = $1000;
    {$EXTERNALSYM PhysConn_Audio_Tuner}
    PhysConn_Audio_Line	           = PhysConn_Audio_Tuner + 1;
    {$EXTERNALSYM PhysConn_Audio_Line}
    PhysConn_Audio_Mic	           = PhysConn_Audio_Line + 1;
    {$EXTERNALSYM PhysConn_Audio_Mic}
    PhysConn_Audio_AESDigital	     = PhysConn_Audio_Mic + 1;
    {$EXTERNALSYM PhysConn_Audio_AESDigital}
    PhysConn_Audio_SPDIFDigital	   = PhysConn_Audio_AESDigital + 1;
    {$EXTERNALSYM PhysConn_Audio_SPDIFDigital}
    PhysConn_Audio_SCSI	           = PhysConn_Audio_SPDIFDigital + 1;
    {$EXTERNALSYM PhysConn_Audio_SCSI}
    PhysConn_Audio_AUX	           = PhysConn_Audio_SCSI + 1;
    {$EXTERNALSYM PhysConn_Audio_AUX}
    PhysConn_Audio_1394	           = PhysConn_Audio_AUX + 1;
    {$EXTERNALSYM PhysConn_Audio_1394}
    PhysConn_Audio_USB	           = PhysConn_Audio_1394 + 1;
    {$EXTERNALSYM PhysConn_Audio_USB}
    PhysConn_Audio_AudioDecoder	   = PhysConn_Audio_USB + 1;
    {$EXTERNALSYM PhysConn_Audio_AudioDecoder}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMAnalogVideoDecoder> _di_IAMAnalogVideoDecoder;'}
  {$EXTERNALSYM IAMAnalogVideoDecoder}
  IAMAnalogVideoDecoder = interface(IUnknown)
    ['{C6E13350-30AC-11d0-A18C-00A0C9118956}']
    (*** IAMAnalogVideoDecoder methods ***)
    function get_AvailableTVFormats(out lAnalogVideoStandard: Longint): HResult; stdcall;
    function put_TVFormat(lAnalogVideoStandard: Longint): HResult; stdcall;
    function get_TVFormat(out plAnalogVideoStandard: Longint): HResult; stdcall;
    function get_HorizontalLocked(out plLocked: Longint): HResult; stdcall;
    function put_VCRHorizontalLocking(lVCRHorizontalLocking: Longint): HResult; stdcall;
    function get_VCRHorizontalLocking(out plVCRHorizontalLocking: Longint): HResult; stdcall;
    function get_NumberOfLines(out plNumberOfLines: Longint): HResult; stdcall;
    function put_OutputEnable(lOutputEnable: LongBool): HResult; stdcall;
    function get_OutputEnable(out plOutputEnable: LongBool): HResult; stdcall;
  end;

  tagVideoProcAmpProperty = (
    VideoProcAmp_Brightness,
    VideoProcAmp_Contrast,
    VideoProcAmp_Hue,
    VideoProcAmp_Saturation,
    VideoProcAmp_Sharpness,
    VideoProcAmp_Gamma,
    VideoProcAmp_ColorEnable,
    VideoProcAmp_WhiteBalance,
    VideoProcAmp_BacklightCompensation,
    VideoProcAmp_Gain
  );
  {$EXTERNALSYM tagVideoProcAmpProperty}
  VideoProcAmpProperty = tagVideoProcAmpProperty;
  {$EXTERNALSYM VideoProcAmpProperty}
  TVideoProcAmpProperty = VideoProcAmpProperty;

  tagVideoProcAmpFlags = (
    {$IFNDEF COMPILER6_UP}
    VideoProcAmp_Flags_INVALID_0,
    VideoProcAmp_Flags_Manual,
    VideoProcAmp_Flags_Auto
    {$ELSE}
    VideoProcAmp_Flags_Manual = 1,
    VideoProcAmp_Flags_Auto
    {$ENDIF}
  );
  {$EXTERNALSYM tagVideoProcAmpFlags}
  VideoProcAmpFlags = tagVideoProcAmpFlags;
  {$EXTERNALSYM VideoProcAmpFlags}
  TVideoProcAmpFlags = VideoProcAmpFlags;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMVideoProcAmp> _di_IAMVideoProcAmp;'}
  {$EXTERNALSYM IAMVideoProcAmp}
  IAMVideoProcAmp = interface(IUnknown)
    ['{C6E13360-30AC-11d0-A18C-00A0C9118956}']
    (*** IAMVideoProcAmp methods ***)
    function GetRange(Property_:TVideoProcAmpProperty; out pMin, pMax, pSteppingDelta,
        pDefault: Longint; out pCapsFlags: TVideoProcAmpFlags): HResult; stdcall;
    function Set_(Property_: TVideoProcAmpProperty; lValue: Longint;
        Flags: TVideoProcAmpFlags): HResult; stdcall;
    function Get(Property_: TVideoProcAmpProperty; out lValue: Longint;
        out Flags: TVideoProcAmpFlags): HResult; stdcall;
  end;

  tagCameraControlProperty = (
    CameraControl_Pan,
    CameraControl_Tilt,
    CameraControl_Roll,
    CameraControl_Zoom,
    CameraControl_Exposure,
    CameraControl_Iris,
    CameraControl_Focus
  );
  {$EXTERNALSYM tagCameraControlProperty}
  CameraControlProperty = tagCameraControlProperty;
  {$EXTERNALSYM CameraControlProperty}
  TCameraControlProperty = CameraControlProperty;

  tagCameraControlFlags = (
  {$IFNDEF COMPILER6_UP}
    CameraControl_Flags_INVALID_0,
    CameraControl_Flags_Manual,
    CameraControl_Flags_Auto
  {$ELSE}
    CameraControl_Flags_Manual = 1,
    CameraControl_Flags_Auto
  {$ENDIF}
  );
  {$EXTERNALSYM tagCameraControlFlags}
  CameraControlFlags = tagCameraControlFlags;
  {$EXTERNALSYM CameraControlFlags}
  TCameraControlFlags = CameraControlFlags;


  {$HPPEMIT 'typedef System::DelphiInterface<IAMCameraControl> _di_IAMCameraControl;'}
  {$EXTERNALSYM IAMCameraControl}
  IAMCameraControl = interface(IUnknown)
    ['{C6E13370-30AC-11d0-A18C-00A0C9118956}']
    (*** IAMCameraControl methods ***)
    function GetRange(Property_: TCameraControlProperty;
        out pMin, pMax, pSteppingDelta, pDefault, pCapsFlags: Longint): HResult; stdcall;
    function Set_(Property_: TCameraControlProperty; lValue: Longint;
        Flags: TCameraControlFlags): HResult; stdcall;
    function Get(Property_: TCameraControlProperty; out lValue: Longint;
        out Flags: TCameraControlFlags): HResult; stdcall;
  end;

const
  VideoControlFlag_FlipHorizontal	       = $1;
  {$EXTERNALSYM VideoControlFlag_FlipHorizontal}
  VideoControlFlag_FlipVertical	         = $2;
  {$EXTERNALSYM VideoControlFlag_FlipVertical}
  VideoControlFlag_ExternalTriggerEnable = $4;
  {$EXTERNALSYM VideoControlFlag_ExternalTriggerEnable}
  VideoControlFlag_Trigger	             = $8;
  {$EXTERNALSYM VideoControlFlag_Trigger}

type  
  {$HPPEMIT 'typedef System::DelphiInterface<IAMVideoControl> _di_IAMVideoControl;'}
  {$EXTERNALSYM IAMVideoControl}
  IAMVideoControl = interface(IUnknown)
    ['{6a2e0670-28e4-11d0-a18c-00a0c9118956}']
    (*** IAMVideoControl methods ***)
    function GetCaps(pPin: IPin; out pCapsFlags: Longint): HResult; stdcall;
    function SetMode(pPin: IPin; Mode: Longint): HResult; stdcall;
    function GetMode(pPin: IPin; out Mode: Longint): HResult; stdcall;
    function GetCurrentActualFrameRate(pPin: IPin; out ActualFrameRate: Int64): HResult; stdcall;
    function GetMaxAvailableFrameRate(pPin: IPin; iIndex: Longint; Dimensions: TSize; out MaxAvailableFrameRate: Int64): HResult; stdcall;
    function GetFrameRateList(pPin: IPin; iIndex: Longint; Dimensions: TSize; out ListSize: Longint; out FrameRates: PInt64): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMCrossbar> _di_IAMCrossbar;'}
  {$EXTERNALSYM IAMCrossbar}
  IAMCrossbar = interface(IUnknown)
    ['{C6E13380-30AC-11d0-A18C-00A0C9118956}']
    (*** IAMCrossbar methods ***)
    function get_PinCounts(out OutputPinCount, InputPinCount: Longint): HResult; stdcall;
    function CanRoute(OutputPinIndex, InputPinIndex: Longint): HResult; stdcall;
    function Route(OutputPinIndex, InputPinIndex: Longint): HResult; stdcall;
    function get_IsRoutedTo(OutputPinIndex: Longint;
      out InputPinIndex: Longint): HResult; stdcall;
    function get_CrossbarPinInfo(IsInputPin: BOOL; PinIndex: Longint;
      out PinIndexRelated : longint; out PhysicalType: TPhysicalConnectorType): HResult; stdcall;
  end;

type
  {$IFNDEF COMPILER6_UP}
  tagAMTunerSubChannel = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  const
    AMTUNER_SUBCHAN_NO_TUNE	= -2;
    {$EXTERNALSYM AMTUNER_SUBCHAN_NO_TUNE}
    AMTUNER_SUBCHAN_DEFAULT	= -1;
    {$EXTERNALSYM AMTUNER_SUBCHAN_DEFAULT}
  {$ELSE}
  tagAMTunerSubChannel = (
   	AMTUNER_SUBCHAN_NO_TUNE	= -2,
	  AMTUNER_SUBCHAN_DEFAULT	= -1
  );
  {$ENDIF}
type
  {$EXTERNALSYM tagAMTunerSubChannel}
  AMTunerSubChannel = tagAMTunerSubChannel;
  {$EXTERNALSYM AMTunerSubChannel}
  TAMTunerSubChannel = AMTunerSubChannel;

type
  {$IFNDEF COMPILER6_UP}
  tagAMTunerSignalStrength = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  const
    AMTUNER_HASNOSIGNALSTRENGTH	= -1;
    {$EXTERNALSYM AMTUNER_HASNOSIGNALSTRENGTH}
	  AMTUNER_NOSIGNAL	          = 0;
    {$EXTERNALSYM AMTUNER_NOSIGNAL}
	  AMTUNER_SIGNALPRESENT	      = 1;
    {$EXTERNALSYM AMTUNER_SIGNALPRESENT}
  {$ELSE}
  tagAMTunerSignalStrength = (
    AMTUNER_HASNOSIGNALSTRENGTH	= -1,
	  AMTUNER_NOSIGNAL	          = 0,
	  AMTUNER_SIGNALPRESENT	      = 1
  );
  {$ENDIF}
type
  {$EXTERNALSYM tagAMTunerSignalStrength}
  AMTunerSignalStrength = tagAMTunerSignalStrength;
  {$EXTERNALSYM AMTunerSignalStrength}
  TAMTunerSignalStrength = AMTunerSignalStrength;

type
  {$IFNDEF COMPILER6_UP}
  tagAMTunerModeType = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  const
    AMTUNER_MODE_DEFAULT	= 0;
    {$EXTERNALSYM AMTUNER_MODE_DEFAULT}
	  AMTUNER_MODE_TV	      = 1;
    {$EXTERNALSYM AMTUNER_MODE_TV}
	  AMTUNER_MODE_FM_RADIO	= 2;
    {$EXTERNALSYM AMTUNER_MODE_FM_RADIO}
	  AMTUNER_MODE_AM_RADIO	= 4;
    {$EXTERNALSYM AMTUNER_MODE_AM_RADIO}
	  AMTUNER_MODE_DSS	    = 8;
    {$EXTERNALSYM AMTUNER_MODE_DSS}
  {$ELSE}
  tagAMTunerModeType = (
    AMTUNER_MODE_DEFAULT	= 0,
	  AMTUNER_MODE_TV	      = 1,
	  AMTUNER_MODE_FM_RADIO	= 2,
	  AMTUNER_MODE_AM_RADIO	= 4,
	  AMTUNER_MODE_DSS	    = 8
  );
  {$ENDIF}
type
  {$EXTERNALSYM tagAMTunerModeType}
  AMTunerModeType = tagAMTunerModeType;
  {$EXTERNALSYM AMTunerModeType}
  TAMTunerModeType = AMTunerModeType;

type
  tagAMTunerEventType = (
  {$IFNDEF COMPILER6_UP}
    AMTUNER_EVENT_INVALID_0,
    AMTUNER_EVENT_CHANGED
  {$ELSE}
    AMTUNER_EVENT_CHANGED = 1
  {$ENDIF}
  );
  {$EXTERNALSYM tagAMTunerEventType}
  AMTunerEventType = tagAMTunerEventType;
  {$EXTERNALSYM AMTunerEventType}
  TAMTunerEventType = AMTunerEventType;

  IAMTunerNotification = interface;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTuner> _di_IAMTuner;'}
  {$EXTERNALSYM IAMTuner}
  IAMTuner = interface(IUnknown)
    ['{211A8761-03AC-11d1-8D13-00AA00BD8339}']
    (*** IAMTuner methods ***)
    function put_Channel(lChannel, lVideoSubChannel, lAudioSubChannel: Longint): HResult; stdcall;
    function get_Channel(out lChannel, lVideoSubChannel, lAudioSubChannel: Longint): HResult; stdcall;
    function ChannelMinMax(out lChannelMin, lChannelMax: Longint): HResult; stdcall;
    function put_CountryCode(lCountryCode: Longint): HResult; stdcall;
    function get_CountryCode(out lCountryCode: Longint): HResult; stdcall;
    function put_TuningSpace(lTuningSpace: Longint): HResult; stdcall;
    function get_TuningSpace(out lTuningSpace: Longint): HResult; stdcall;
    function Logon(hCurrentUser: THandle): HResult; stdcall;
    function Logout: HResult; stdcall;
    function SignalPresent(out plSignalStrength: Longint): HResult; stdcall;
    function put_Mode(lMode: TAMTunerModeType): HResult; stdcall;
    function get_Mode(out plMode: TAMTunerModeType): HResult; stdcall;
    function GetAvailableModes(out plModes: Longint): HResult; stdcall;
    function RegisterNotificationCallBack(pNotify: IAMTunerNotification;
        lEvents: Longint): HResult; stdcall;
    function UnRegisterNotificationCallBack(pNotify: IAMTunerNotification): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTunerNotification> _di_IAMTunerNotification;'}
  {$EXTERNALSYM IAMTunerNotification}
  IAMTunerNotification = interface(IUnknown)
    ['{211A8760-03AC-11d1-8D13-00AA00BD8339}']
    (*** IAMTunerNotification methods ***)
    function OnEvent(Event: TAMTunerEventType): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTVTuner> _di_IAMTVTuner;'}
  {$EXTERNALSYM IAMTVTuner}
  IAMTVTuner = interface(IAMTuner)
    ['{211A8766-03AC-11d1-8D13-00AA00BD8339}']
    (*** IAMTVTuner methods ***)
    function get_AvailableTVFormats(out lAnalogVideoStandard: Longint): HResult; stdcall;
    function get_TVFormat(out plAnalogVideoStandard: Longint): HResult; stdcall;
    function AutoTune(lChannel: Longint; out plFoundSignal: Longint): HResult; stdcall;
    function StoreAutoTune: HResult; stdcall;
    function get_NumInputConnections(out plNumInputConnections: Longint): HResult; stdcall;
    function put_InputType(lIndex: Longint; InputType: TTunerInputType): HResult; stdcall;
    function get_InputType(lIndex: Longint; out InputType: TTunerInputType): HResult; stdcall;
    function put_ConnectInput(lIndex: Longint): HResult; stdcall;
    function get_ConnectInput(out plIndex: Longint): HResult; stdcall;
    function get_VideoFrequency(out lFreq: Longint): HResult; stdcall;
    function get_AudioFrequency(out lFreq: Longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IBPCSatelliteTuner> _di_IBPCSatelliteTuner;'}
  {$EXTERNALSYM IBPCSatelliteTuner}
  IBPCSatelliteTuner = interface(IAMTuner)
    ['{211A8765-03AC-11d1-8D13-00AA00BD8339}']
    (*** IBPCSatelliteTuner methods ***)
    function get_DefaultSubChannelTypes(out plDefaultVideoType, plDefaultAudioType: Longint): HResult; stdcall;
    function put_DefaultSubChannelTypes(lDefaultVideoType, lDefaultAudioType: Longint): HResult; stdcall;
    function IsTapingPermitted: HResult; stdcall;
  end;

  {$IFNDEF COMPILER6_UP}
  tagTVAudioMode = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  const
    AMTVAUDIO_MODE_MONO	  = $1;
    {$EXTERNALSYM AMTVAUDIO_MODE_MONO}
	  AMTVAUDIO_MODE_STEREO	= $2;
    {$EXTERNALSYM AMTVAUDIO_MODE_STEREO}
	  AMTVAUDIO_MODE_LANG_A	= $10;
    {$EXTERNALSYM AMTVAUDIO_MODE_LANG_A}
	  AMTVAUDIO_MODE_LANG_B	= $20;
    {$EXTERNALSYM AMTVAUDIO_MODE_LANG_B}
	  AMTVAUDIO_MODE_LANG_C	= $40;
    {$EXTERNALSYM AMTVAUDIO_MODE_LANG_C}
  {$ELSE}
  tagTVAudioMode = (
    AMTVAUDIO_MODE_MONO	  = $1,
	  AMTVAUDIO_MODE_STEREO	= $2,
	  AMTVAUDIO_MODE_LANG_A	= $10,
	  AMTVAUDIO_MODE_LANG_B	= $20,
	  AMTVAUDIO_MODE_LANG_C	= $40
  );
  {$ENDIF}
type
  {$EXTERNALSYM tagTVAudioMode}
  TVAudioMode = tagTVAudioMode;
  {$EXTERNALSYM TVAudioMode}
  TTVAudioMode = TVAudioMode;

type

  tagAMTVAudioEventType = (
  {$IFNDEF COMPILER6_UP}
    AMTVAUDIO_EVENT_INVALID_0,
    AMTVAUDIO_EVENT_CHANGED
  {$ELSE}
    AMTVAUDIO_EVENT_CHANGED	= 1
  {$ENDIF}
  );
  {$EXTERNALSYM tagAMTVAudioEventType}
  AMTVAudioEventType = tagAMTVAudioEventType;
  {$EXTERNALSYM AMTVAudioEventType}
  TAMTVAudioEventType = AMTVAudioEventType;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTVAudio> _di_IAMTVAudio;'}
  {$EXTERNALSYM IAMTVAudio}
  IAMTVAudio = interface(IUnknown)
    ['{83EC1C30-23D1-11d1-99E6-00A0C9560266}']
    (*** IAMTVAudio methods ***)
    function GetHardwareSupportedTVAudioModes(out plModes: Longint): HResult; stdcall;
    function GetAvailableTVAudioModes(out plModes: Longint): HResult; stdcall;
    function get_TVAudioMode(out plMode: Longint): HResult; stdcall;
    function put_TVAudioMode(lMode: Longint): HResult; stdcall;
    function RegisterNotificationCallBack(pNotify: IAMTunerNotification;
        lEvents: Longint): HResult; stdcall;
    function UnRegisterNotificationCallBack(pNotify: IAMTunerNotification): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTVAudioNotification> _di_IAMTVAudioNotification;'}
  {$EXTERNALSYM IAMTVAudioNotification}
  IAMTVAudioNotification = interface(IUnknown)
    ['{83EC1C33-23D1-11D1-99E6-00A0C9560266}']
    (*** IAMTVAudioNotification methods ***)
    function OnEvent(Event: TAMTVAudioEventType): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMAnalogVideoEncoder> _di_IAMAnalogVideoEncoder;'}
  {$EXTERNALSYM IAMAnalogVideoEncoder}
  IAMAnalogVideoEncoder = interface(IUnknown)
    ['{C6E133B0-30AC-11d0-A18C-00A0C9118956}']
    (*** IAMAnalogVideoEncoder methods ***)
    function get_AvailableTVFormats(out lAnalogVideoStandard: Longint): HResult; stdcall;
    function put_TVFormat(lAnalogVideoStandard: Longint): HResult; stdcall;
    function get_TVFormat(out plAnalogVideoStandard: Longint): HResult; stdcall;
    function put_CopyProtection(lVideoCopyProtection: Longint): HResult; stdcall;
    function get_CopyProtection(out lVideoCopyProtection: Longint): HResult; stdcall;
    function put_CCEnable(lCCEnable: LongBool): HResult; stdcall;
    function get_CCEnable(out lCCEnable: LongBool): HResult; stdcall;
  end ;

  AMPROPERTY_PIN = (
    AMPROPERTY_PIN_CATEGORY,
    AMPROPERTY_PIN_MEDIUM
  );
  {$EXTERNALSYM AMPROPERTY_PIN}
  TAMPropertyPin = AMPROPERTY_PIN;

const
  KSPROPERTY_SUPPORT_GET = 1;
  {$EXTERNALSYM KSPROPERTY_SUPPORT_GET}
  KSPROPERTY_SUPPORT_SET = 2;
  {$EXTERNALSYM KSPROPERTY_SUPPORT_SET}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IKsPropertySet> _di_IKsPropertySet;'}
  {$EXTERNALSYM IKsPropertySet}
  IKsPropertySet = interface(IUnknown)
    ['{31EFAC30-515C-11d0-A9AA-00AA0061BE93}']
    (*** IKsPropertySet methods ***)
    function Set_(const guidPropSet: TGUID; dwPropID: DWORD;
      pInstanceData: pointer; cbInstanceData: DWORD; pPropData: pointer; cbPropData: DWORD): HResult; stdcall;
    function Get(const guidPropSet: TGUID; dwPropID: DWORD;
      pInstanceData: pointer; cbInstanceData: DWORD; out pPropData ; cbPropData: DWORD;
      out pcbReturned: DWORD): HResult; stdcall;
    function QuerySupported(const guidPropSet: TGUID; dwPropID: TAMPropertyPin;
      out pTypeSupport: DWORD): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaPropertyBag> _di_IMediaPropertyBag;'}
  {$EXTERNALSYM IMediaPropertyBag}
  IMediaPropertyBag = interface(IPropertyBag)
    ['{6025A880-C0D5-11D0-BD4E-00A0C911CE86}']
    (*** IMediaPropertyBag methods ***)
    function EnumProperty(iProperty: ULONG; var pvarPropertyName,
        pvarPropertyValue: OleVariant): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IPersistMediaPropertyBag> _di_IPersistMediaPropertyBag;'}
  {$EXTERNALSYM IPersistMediaPropertyBag}
  IPersistMediaPropertyBag = interface(IPersist)
     ['{5738E040-B67F-11d0-BD4D-00A0C911CE86}']
     (*** IPersistMediaPropertyBag methods ***)
     function InitNew: HResult; stdcall;
     function Load(pPropBag: IMediaPropertyBag; pErrorLog: IErrorLog): HResult; stdcall;
     function Save(pPropBag: IMediaPropertyBag; fClearDirty, fSaveAllProperties: BOOL): HResult; stdcall;
  end;

  //Deprecated Interface
  {$HPPEMIT 'typedef System::DelphiInterface<IAMPhysicalPinInfo> _di_IAMPhysicalPinInfo;'}
  {$EXTERNALSYM IAMPhysicalPinInfo}
  IAMPhysicalPinInfo = interface(IUnknown)
    ['{F938C991-3029-11CF-8C44-00AA006B6814}']
    (*** IAMPhysicalPinInfo methods ***)
    function GetPhysicalType(out pType: Longint; out ppszType: PWideChar): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMExtDevice> _di_IAMExtDevice;'}
  {$EXTERNALSYM IAMExtDevice}
  IAMExtDevice = interface(IUnknown)
    ['{B5730A90-1A2C-11CF-8C23-00AA006B6814}']
    (*** IAMExtDevice methods ***)
    function GetCapability(Capability: Longint; out pValue: Longint; out pdblValue: double): HResult; stdcall;
    function get_ExternalDeviceID(out ppszData: PWideChar): HResult; stdcall;
    function get_ExternalDeviceVersion(out ppszData: PWideChar): HResult; stdcall;
    function put_DevicePower(PowerMode: Longint): HResult; stdcall;
    function get_DevicePower(out pPowerMode: Longint): HResult; stdcall;
    function Calibrate(hEvent: THandle; Mode: Longint; out pStatus: Longint): HResult; stdcall;
    function put_DevicePort(DevicePort: Longint): HResult; stdcall;
    function get_DevicePort(out pDevicePort: Longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMExtTransport> _di_IAMExtTransport;'}
  {$EXTERNALSYM IAMExtTransport}
  IAMExtTransport = interface(IUnknown)
    ['{A03CD5F0-3045-11CF-8C44-00AA006B6814}']
    (*** IAMExtTransport methods ***)
    function GetCapability(Capability: Longint; out pValue: Longint; out pdblValue: double): HResult; stdcall;
    function put_MediaState(State: Longint): HResult; stdcall;
    function get_MediaState(out pState: Longint): HResult; stdcall;
    function put_LocalControl(State: Longint): HResult; stdcall;
    function get_LocalControl(out pState: Longint): HResult; stdcall;
    function GetStatus(StatusItem: Longint; out pValue: Longint): HResult; stdcall;
    function GetTransportBasicParameters(Param: Longint; var pValue: Longint; ppszData: pointer): HResult; stdcall;
    function SetTransportBasicParameters(Param: Longint; Value: Longint; pszData: PWideChar): HResult; stdcall;
    function GetTransportVideoParameters(Param: Longint; out pValue: Longint): HResult; stdcall;
    function SetTransportVideoParameters(Param: Longint; Value: Longint): HResult; stdcall;
    function GetTransportAudioParameters(Param: Longint; out pValue: Longint): HResult; stdcall;
    function SetTransportAudioParameters(Param: Longint; Value: Longint): HResult; stdcall;
    function put_Mode(Mode: Longint): HResult; stdcall;
    function get_Mode(out pMode: Longint): HResult; stdcall;
    function put_Rate(dblRate: double): HResult; stdcall;
    function get_Rate(out pdblRate: double): HResult; stdcall;
    function GetChase(out pEnabled, pOffset: Longint; var phEvent: THandle): HResult; stdcall;
    function SetChase(Enable, Offset: Longint; hEvent: THandle): HResult; stdcall;
    function GetBump(out pSpeed, pDuration: Longint): HResult; stdcall;
    function SetBump(Speed, Duration: Longint): HResult; stdcall;
    function get_AntiClogControl(out pEnabled: Longint): HResult; stdcall;
    function put_AntiClogControl(Enable: Longint): HResult; stdcall;
    function GetEditPropertySet(EditID: Longint; out pState: Longint): HResult; stdcall;
    function SetEditPropertySet(var pEditID: Longint; State: Longint): HResult; stdcall;
    function GetEditProperty(EditID, Param: Longint; out pValue: Longint): HResult; stdcall;
    function SetEditProperty(EditID, Param, Value: Longint): HResult; stdcall;
    function get_EditStart(out pValue: Longint): HResult; stdcall;
    function put_EditStart(Value: Longint): HResult; stdcall;
  end;

  PTimeCode = ^TTimeCode;
  _timecode = record
    wFrameRate  : Word;
    wFrameFract : Word;
    dwFrames    : DWORD;
  end;
  {$EXTERNALSYM _timecode}
  TIMECODE = _timecode;
  {$EXTERNALSYM TIMECODE}
  TTimeCode = _timecode;

  PTimeCodeSample = ^TTimeCodeSample;
  tagTIMECODE_SAMPLE = record
    qwTick   : Int64;
    timecode : TIMECODE;
    dwUser   : DWORD;
    dwFlags  : DWORD;
  end;
  {$EXTERNALSYM tagTIMECODE_SAMPLE}
  TIMECODE_SAMPLE = tagTIMECODE_SAMPLE;
  {$EXTERNALSYM TIMECODE_SAMPLE}
  TTimeCodeSample = tagTIMECODE_SAMPLE;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimecodeReader> _di_IAMTimecodeReader;'}
  {$EXTERNALSYM IAMTimecodeReader}
  IAMTimecodeReader = interface(IUnknown)
    ['{9B496CE1-811B-11CF-8C77-00AA006B6814}']
    (*** IAMTimecodeReader methods ***)
    function GetTCRMode(Param: Longint; out pValue: Longint): HResult; stdcall;
    function SetTCRMode(Param: Longint; Value: Longint): HResult; stdcall;
    function put_VITCLine(Line: Longint): HResult; stdcall;
    function get_VITCLine(out pLine: Longint): HResult; stdcall;
    function GetTimecode(out pTimecodeSample: TTimeCodeSample): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimecodeGenerator> _di_IAMTimecodeGenerator;'}
  {$EXTERNALSYM IAMTimecodeGenerator}
  IAMTimecodeGenerator = interface(IUnknown)
    ['{9B496CE0-811B-11CF-8C77-00AA006B6814}']
    (*** IAMTimecodeGenerator methods ***)
    function GetTCGMode(Param: Longint; out pValue: Longint): HResult; stdcall;
    function SetTCGMode(Param: Longint; Value: Longint): HResult; stdcall;
    function put_VITCLine(Line: Longint): HResult; stdcall;
    function get_VITCLine(out Line: Longint): HResult; stdcall;
    function SetTimecode(var pTimecodeSample: TTimeCodeSample): HResult; stdcall;
    function GetTimecode(out pTimecodeSample: TTimeCodeSample): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimecodeDisplay> _di_IAMTimecodeDisplay;'}
  {$EXTERNALSYM IAMTimecodeDisplay}
  IAMTimecodeDisplay = interface(IUnknown)
    ['{9B496CE2-811B-11CF-8C77-00AA006B6814}']
    (*** IAMTimecodeDisplay methods ***)
    function GetTCDisplayEnable(out pState: Longint): HResult; stdcall;
    function SetTCDisplayEnable(State: Longint): HResult; stdcall;
    function GetTCDisplay(Param: Longint; out pValue: Longint): HResult; stdcall;
    function SetTCDisplay(Param, Value: Longint): HResult; stdcall;
  end;

  //Deprecated Interface
  {$HPPEMIT 'typedef System::DelphiInterface<IAMDevMemoryAllocator> _di_IAMDevMemoryAllocator;'}
  {$EXTERNALSYM IAMDevMemoryAllocator}
  IAMDevMemoryAllocator = interface(IUnknown)
    ['{C6545BF0-E76B-11D0-BD52-00A0C911CE86}']
    (*** IAMDevMemoryAllocator methods ***)
    function GetInfo(out pdwcbTotalFree, pdwcbLargestFree, pdwcbTotalMemory, pdwcbMinimumChunk: DWORD): HResult; stdcall;
    function CheckMemory(pBuffer: Pointer): HResult; stdcall;
    function Alloc(out ppBuffer: Pointer; var pdwcbBuffer: DWORD): HResult; stdcall;
    function Free(pBuffer: Pointer): HResult; stdcall;
    function GetDevMemoryObject(out ppUnkInnner: IUnknown; pUnkOuter: IUnknown): HResult; stdcall;
  end;

  //Deprecated Interface
  {$HPPEMIT 'typedef System::DelphiInterface<IAMDevMemoryControl> _di_IAMDevMemoryControl;'}
  {$EXTERNALSYM IAMDevMemoryControl}
  IAMDevMemoryControl = interface(IUnknown)
    ['{C6545BF1-E76B-11D0-BD52-00A0C911CE86}']
    (*** IAMDevMemoryControl methods ***)
    function QueryWriteSync: HResult; stdcall;
    function WriteSync: HResult; stdcall;
    function GetDevId(out pdwDevId: DWORD): HResult; stdcall;
  end;

const
  AMSTREAMSELECTINFO_ENABLED     = $1;
  {$EXTERNALSYM AMSTREAMSELECTINFO_ENABLED}
  AMSTREAMSELECTINFO_EXCLUSIVE   = $2;
  {$EXTERNALSYM AMSTREAMSELECTINFO_EXCLUSIVE}

  AMSTREAMSELECTENABLE_ENABLE    = $1;
  {$EXTERNALSYM AMSTREAMSELECTENABLE_ENABLE}
  AMSTREAMSELECTENABLE_ENABLEALL = $2;
  {$EXTERNALSYM AMSTREAMSELECTENABLE_ENABLEALL}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMStreamSelect> _di_IAMStreamSelect;'}
  {$EXTERNALSYM IAMStreamSelect}
  IAMStreamSelect = interface(IUnknown)
    ['{C1960960-17F5-11D1-ABE1-00A0C905F375}']
    (*** IAMStreamSelect methods ***)
    function Count(out pcStreams: DWORD): HResult; stdcall;
    function Info(lIndex: Longint; out ppmt: PAMMediaType;
        out pdwFlags: DWORD; out plcid: LCID; out pdwGroup: DWORD;
        out ppszName: PWCHAR; out ppObject: IUnknown; out ppUnk : IUnknown): HResult; stdcall;
    function Enable(lIndex: Longint; dwFlags: DWORD): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMResourceControl> _di_IAMResourceControl;'}
  {$EXTERNALSYM IAMResourceControl}
  IAMResourceControl = interface(IUnknown)
    ['{8389d2d0-77d7-11d1-abe6-00a0c905f375}']
    (*** IAMResourceControl methods ***)
    function Reserve(dwFlags: DWORD; var pvReserved: pointer): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMClockAdjust> _di_IAMClockAdjust;'}
  {$EXTERNALSYM IAMClockAdjust}
  IAMClockAdjust = interface(IUnknown)
    ['{4d5466b0-a49c-11d1-abe8-00a0c905f375}']
    (*** IAMClockAdjust methods ***)
    function SetClockDelta(rtDelta: TReferenceTime): HResult; stdcall;
  end;

const
  AM_FILTER_MISC_FLAGS_IS_RENDERER	= $1;
  {$EXTERNALSYM AM_FILTER_MISC_FLAGS_IS_RENDERER}
  AM_FILTER_MISC_FLAGS_IS_SOURCE	= $2;
  {$EXTERNALSYM AM_FILTER_MISC_FLAGS_IS_SOURCE}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMFilterMiscFlags> _di_IAMFilterMiscFlags;'}
  {$EXTERNALSYM IAMFilterMiscFlags}
  IAMFilterMiscFlags = interface(IUnknown)
    ['{2dd74950-a890-11d1-abe8-00a0c905f375}']
    (*** IAMFilterMiscFlags methods ***)
    function GetMiscFlags: ULONG; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDrawVideoImage> _di_IDrawVideoImage;'}
  {$EXTERNALSYM IDrawVideoImage}
  IDrawVideoImage = interface(IUnknown)
    ['{48efb120-ab49-11d2-aed2-00a0c995e8d5}']
    (*** IDrawVideoImage methods ***)
    function DrawVideoImageBegin: HResult; stdcall;
    function DrawVideoImageEnd: HResult; stdcall;
    function DrawVideoImageDraw(hdc: HDC; lprcSrc, lprcDst: PRECT): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDecimateVideoImage> _di_IDecimateVideoImage;'}
  {$EXTERNALSYM IDecimateVideoImage}
  IDecimateVideoImage = interface(IUnknown)
    ['{2e5ea3e0-e924-11d2-b6da-00a0c995e8df}']
    (*** IDecimateVideoImage methods ***)
    function SetDecimationImageSize(lWidth, lHeight: Longint):HResult; stdcall;
    function ResetDecimationImageSize: HResult; stdcall;
  end;

  _DECIMATION_USAGE = (
    DECIMATION_LEGACY,
    DECIMATION_USE_DECODER_ONLY,
    DECIMATION_USE_VIDEOPORT_ONLY,
    DECIMATION_USE_OVERLAY_ONLY,
    DECIMATION_DEFAULT
  );
  {$EXTERNALSYM _DECIMATION_USAGE}
  DECIMATION_USAGE = _DECIMATION_USAGE;
  {$EXTERNALSYM DECIMATION_USAGE}
  TDecimationUsage = DECIMATION_USAGE;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMVideoDecimationProperties> _di_IAMVideoDecimationProperties;'}
  {$EXTERNALSYM IAMVideoDecimationProperties}
  IAMVideoDecimationProperties = interface(IUnknown)
    ['{60d32930-13da-11d3-9ec6-c4fcaef5c7be}']
    (*** IAMVideoDecimationProperties methods ***)
    function QueryDecimationUsage(out lpUsage: TDecimationUsage):HResult; stdcall;
    function SetDecimationUsage(Usage: TDecimationUsage):HResult; stdcall;
  end;

const
  AM_PUSHSOURCECAPS_INTERNAL_RM	     = $1;
  {$EXTERNALSYM AM_PUSHSOURCECAPS_INTERNAL_RM}
  AM_PUSHSOURCECAPS_NOT_LIVE	       = $2;
  {$EXTERNALSYM AM_PUSHSOURCECAPS_NOT_LIVE}
  AM_PUSHSOURCECAPS_PRIVATE_CLOCK	   = $4;
  {$EXTERNALSYM AM_PUSHSOURCECAPS_PRIVATE_CLOCK}
  AM_PUSHSOURCEREQS_USE_STREAM_CLOCK = $10000;
  {$EXTERNALSYM AM_PUSHSOURCEREQS_USE_STREAM_CLOCK}
  AM_PUSHSOURCEREQS_USE_CLOCK_CHAIN = $20000;
  {$EXTERNALSYM AM_PUSHSOURCEREQS_USE_CLOCK_CHAIN}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMLatency> _di_IAMLatency;'}
  {$EXTERNALSYM IAMLatency}
  IAMLatency = interface(IUnknown)
    ['{62EA93BA-EC62-11d2-B770-00C04FB6BD3D}']
    (*** IAMLatency methods ***)
    function GetLatency(var prtLatency: TReferenceTime): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMPushSource> _di_IAMPushSource;'}
  {$EXTERNALSYM IAMPushSource}
  IAMPushSource = interface(IAMLatency)
    ['{F185FE76-E64E-11d2-B76E-00C04FB6BD3D}']
    (*** IAMPushSource methods ***)
    function GetPushSourceFlags(out pFlags: ULONG): HResult; stdcall;
    function SetPushSourceFlags(Flags: ULONG): HResult; stdcall;
    function SetStreamOffset(rtOffset: TReferenceTime): HResult; stdcall;
    function GetStreamOffset(out prtOffset: TReferenceTime): HResult; stdcall;
    function GetMaxStreamOffset(out prtMaxOffset: TReferenceTime): HResult; stdcall;
    function SetMaxStreamOffset(rtMaxOffset: TReferenceTime): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMDeviceRemoval> _di_IAMDeviceRemoval;'}
  {$EXTERNALSYM IAMDeviceRemoval}
  IAMDeviceRemoval = interface(IUnknown)
    ['{f90a6130-b658-11d2-ae49-0000f8754b99}']
    (*** IAMDeviceRemoval methods ***)
    function DeviceInfo(out pclsidInterfaceClass: TGUID;
             out pwszSymbolicLink: PWideChar): HResult; stdcall;
    function Reassociate: HResult; stdcall;
    function Disassociate: HResult; stdcall;
  end;

type
  PTDVInfo = ^TDVInfo;
  DVINFO = record
    //for 1st 5/6 DIF seq.
    dwDVAAuxSrc  : DWORD;
    dwDVAAuxCtl  : DWORD;
    //for 2nd  5/6 DIF seq.
    dwDVAAuxSrc1 : DWORD;
    dwDVAAuxCtl1 : DWORD;
    //for video information
    dwDVVAuxSrc  : DWORD;
    dwDVVAuxCtl  : DWORD;
    dwDVReserved: array[0..1] of DWORD;
  end;
  {$EXTERNALSYM DVINFO}
  TDVInfo = DVINFO;

const
  //DVENCODERRESOLUTION
  DVENCODERRESOLUTION_720x480	= 2012;
  {$EXTERNALSYM DVENCODERRESOLUTION_720x480}
	DVENCODERRESOLUTION_360x240	= 2013;
  {$EXTERNALSYM DVENCODERRESOLUTION_360x240}
	DVENCODERRESOLUTION_180x120	= 2014;
  {$EXTERNALSYM DVENCODERRESOLUTION_180x120}
	DVENCODERRESOLUTION_88x60 	= 2015;
  {$EXTERNALSYM DVENCODERRESOLUTION_88x60}

  //DVENCODERVIDEOFORMAT
  DVENCODERVIDEOFORMAT_NTSC	= 2000;
  {$EXTERNALSYM DVENCODERVIDEOFORMAT_NTSC}
	DVENCODERVIDEOFORMAT_PAL	= 2001;
  {$EXTERNALSYM DVENCODERVIDEOFORMAT_PAL}

  //DVENCODERFORMAT
  DVENCODERFORMAT_DVSD = 2007;
  {$EXTERNALSYM DVENCODERFORMAT_DVSD}
	DVENCODERFORMAT_DVHD = 2008;
  {$EXTERNALSYM DVENCODERFORMAT_DVHD}
	DVENCODERFORMAT_DVSL = 2009;
  {$EXTERNALSYM DVENCODERFORMAT_DVSL}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IDVEnc> _di_IDVEnc;'}
  {$EXTERNALSYM IDVEnc}
  IDVEnc = interface(IUnknown)
    ['{d18e17a0-aacb-11d0-afb0-00aa00b67a42}']
    (*** IDVEnc methods ***)
    function get_IFormatResolution(out VideoFormat, DVFormat, Resolution: integer;
             fDVInfo: ByteBool; out sDVInfo: TDVINFO): HResult; stdcall;
    function put_IFormatResolution(VideoFormat, DVFormat, Resolution: integer;
             fDVInfo: ByteBool; var sDVInfo: TDVINFO): HResult; stdcall;
  end;

const
  //DVDECODERRESOLUTION
 	DVDECODERRESOLUTION_720x480	= 1000;
  {$EXTERNALSYM DVDECODERRESOLUTION_720x480}
	DVDECODERRESOLUTION_360x240	= 1001;
  {$EXTERNALSYM DVDECODERRESOLUTION_360x240}
	DVDECODERRESOLUTION_180x120	= 1002;
  {$EXTERNALSYM DVDECODERRESOLUTION_180x120}
	DVDECODERRESOLUTION_88x60   = 1003;
  {$EXTERNALSYM DVDECODERRESOLUTION_88x60}

  //DVRESOLUTION
  DVRESOLUTION_FULL	   = 1000;
  {$EXTERNALSYM DVRESOLUTION_FULL}
	DVRESOLUTION_HALF	   = 1001;
  {$EXTERNALSYM DVRESOLUTION_HALF}
	DVRESOLUTION_QUARTER = 1002;
  {$EXTERNALSYM DVRESOLUTION_QUARTER}
	DVRESOLUTION_DC	     = 1003;
  {$EXTERNALSYM DVRESOLUTION_DC}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IIPDVDec> _di_IIPDVDec;'}
  {$EXTERNALSYM IIPDVDec}
  IIPDVDec = interface(IUnknown)
    ['{b8e8bd60-0bfe-11d0-af91-00aa00b67a42}']
    (*** IIPDVDec methods ***)
    function get_IPDisplay(out displayPix : integer): HResult; stdcall;
    function put_IPDisplay(displayPix: integer): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDVRGB219> _di_IDVRGB219;'}
  {$EXTERNALSYM IDVRGB219}
  IDVRGB219 = interface(IUnknown)
    ['{58473A19-2BC8-4663-8012-25F81BABDDD1}']
    (*** IDVRGB219 methods ***)
    function SetRGB219(bState: BOOL): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDVSplitter> _di_IDVSplitter;'}
  {$EXTERNALSYM IDVSplitter}
  IDVSplitter = interface(IUnknown)
    ['{92a3a302-da7c-4a1f-ba7e-1802bb5d2d02}']
    (*** IDVSplitter methods ***)
    function DiscardAlternateVideoFrames(nDiscard: integer): HResult; stdcall;
  end;

//_AM_AUDIO_RENDERER_STAT_PARAM
const
  AM_AUDREND_STAT_PARAM_BREAK_COUNT	           = 1;
  {$EXTERNALSYM AM_AUDREND_STAT_PARAM_BREAK_COUNT}
	AM_AUDREND_STAT_PARAM_SLAVE_MODE	           = AM_AUDREND_STAT_PARAM_BREAK_COUNT + 1;
  {$EXTERNALSYM AM_AUDREND_STAT_PARAM_SLAVE_MODE}
	AM_AUDREND_STAT_PARAM_SILENCE_DUR	           = AM_AUDREND_STAT_PARAM_SLAVE_MODE + 1;
  {$EXTERNALSYM AM_AUDREND_STAT_PARAM_SILENCE_DUR}
	AM_AUDREND_STAT_PARAM_LAST_BUFFER_DUR	       = AM_AUDREND_STAT_PARAM_SILENCE_DUR + 1;
  {$EXTERNALSYM AM_AUDREND_STAT_PARAM_LAST_BUFFER_DUR}
	AM_AUDREND_STAT_PARAM_DISCONTINUITIES	       = AM_AUDREND_STAT_PARAM_LAST_BUFFER_DUR + 1;
  {$EXTERNALSYM AM_AUDREND_STAT_PARAM_DISCONTINUITIES}
	AM_AUDREND_STAT_PARAM_SLAVE_RATE             = AM_AUDREND_STAT_PARAM_DISCONTINUITIES + 1;
  {$EXTERNALSYM AM_AUDREND_STAT_PARAM_SLAVE_RATE}
	AM_AUDREND_STAT_PARAM_SLAVE_DROPWRITE_DUR    = AM_AUDREND_STAT_PARAM_SLAVE_RATE + 1;
  {$EXTERNALSYM AM_AUDREND_STAT_PARAM_SLAVE_DROPWRITE_DUR}
	AM_AUDREND_STAT_PARAM_SLAVE_HIGHLOWERROR     = AM_AUDREND_STAT_PARAM_SLAVE_DROPWRITE_DUR + 1;
  {$EXTERNALSYM AM_AUDREND_STAT_PARAM_SLAVE_HIGHLOWERROR}
	AM_AUDREND_STAT_PARAM_SLAVE_LASTHIGHLOWERROR = AM_AUDREND_STAT_PARAM_SLAVE_HIGHLOWERROR + 1;
  {$EXTERNALSYM AM_AUDREND_STAT_PARAM_SLAVE_LASTHIGHLOWERROR}
	AM_AUDREND_STAT_PARAM_SLAVE_ACCUMERROR	     = AM_AUDREND_STAT_PARAM_SLAVE_LASTHIGHLOWERROR + 1;
  {$EXTERNALSYM AM_AUDREND_STAT_PARAM_SLAVE_ACCUMERROR}
	AM_AUDREND_STAT_PARAM_BUFFERFULLNESS	       = AM_AUDREND_STAT_PARAM_SLAVE_ACCUMERROR + 1;
  {$EXTERNALSYM AM_AUDREND_STAT_PARAM_BUFFERFULLNESS}
	AM_AUDREND_STAT_PARAM_JITTER	               = AM_AUDREND_STAT_PARAM_BUFFERFULLNESS + 1;
  {$EXTERNALSYM AM_AUDREND_STAT_PARAM_JITTER}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMAudioRendererStats> _di_IAMAudioRendererStats;'}
  {$EXTERNALSYM IAMAudioRendererStats}
  IAMAudioRendererStats = interface(IUnknown)
    ['{22320CB2-D41A-11d2-BF7C-D7CB9DF0BF93}']
    (*** IAMAudioRendererStats methods ***)
    function GetStatParam(dwParam: DWORD; out pdwParam1, pdwParam2: DWORD): HResult; stdcall;
  end;

//AM_INTF_SEARCH_FLAGS
const
  AM_INTF_SEARCH_INPUT_PIN	= $1;
  {$EXTERNALSYM AM_INTF_SEARCH_INPUT_PIN}
	AM_INTF_SEARCH_OUTPUT_PIN	= $2;
  {$EXTERNALSYM AM_INTF_SEARCH_OUTPUT_PIN}
	AM_INTF_SEARCH_FILTER	    = $4;
  {$EXTERNALSYM AM_INTF_SEARCH_FILTER}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMGraphStreams> _di_IAMGraphStreams;'}
  {$EXTERNALSYM IAMGraphStreams}
  IAMGraphStreams = interface(IUnknown)
    ['{632105FA-072E-11d3-8AF9-00C04FB6BD3D}']
    (*** IAMGraphStreams methods ***)
    function FindUpstreamInterface(pPin: IPin; const riid: TGUID; out ppvInterface;
             dwFlags: DWORD): HResult; stdcall;
    function SyncUsingStreamOffset(bUseStreamOffset: BOOL): HResult; stdcall;
    function SetMaxGraphLatency(rtMaxGraphLatency: TReferenceTime): HResult; stdcall;
  end;

//AMOVERLAYFX
const
  AMOVERFX_NOFX	           = 0;
  {$EXTERNALSYM AMOVERFX_NOFX}
	AMOVERFX_MIRRORLEFTRIGHT = $2;
  {$EXTERNALSYM AMOVERFX_MIRRORLEFTRIGHT}
	AMOVERFX_MIRRORUPDOWN	   = $4;
  {$EXTERNALSYM AMOVERFX_MIRRORUPDOWN}
	AMOVERFX_DEINTERLACE	   = $8;
  {$EXTERNALSYM AMOVERFX_DEINTERLACE}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMOverlayFX> _di_IAMOverlayFX;'}
  {$EXTERNALSYM IAMOverlayFX}
  IAMOverlayFX = interface(IUnknown)
    ['{62fae250-7e65-4460-bfc9-6398b322073c}']
    (*** IAMOverlayFX methods ***)
    function QueryOverlayFXCaps(out lpdwOverlayFXCaps: DWORD): HResult; stdcall;
    function SetOverlayFX(dwOverlayFX: DWORD): HResult; stdcall;
    function GetOverlayFX(out lpdwOverlayFX: DWORD): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMOpenProgress> _di_IAMOpenProgress;'}
  {$EXTERNALSYM IAMOpenProgress}
  IAMOpenProgress = interface(IUnknown)
    ['{8E1C39A1-DE53-11cf-AA63-0080C744528D}']
    (*** IAMOpenProgress methods ***)
    function QueryProgress(out pllTotal, pllCurrent: int64): HResult; stdcall;
    function AbortOperation: HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMpeg2Demultiplexer> _di_IMpeg2Demultiplexer;'}
  {$EXTERNALSYM IMpeg2Demultiplexer}
  IMpeg2Demultiplexer = interface(IUnknown)
    ['{436eee9c-264f-4242-90e1-4e330c107512}']
    (*** IMpeg2Demultiplexer methods ***)
    function CreateOutputPin(var pMediaType: TAMMediaType; pszPinName: PWideChar;
             out ppIPin: IPin): HResult; stdcall;
    function SetOutputPinMediaType(pszPinName: PWideChar; var pMediaType: TAMMediaType): HResult; stdcall;
    function DeleteOutputPin(pszPinName: PWideChar): HResult; stdcall;
  end;

const
  MPEG2_PROGRAM_STREAM_MAP           = $00000000;
  {$EXTERNALSYM MPEG2_PROGRAM_STREAM_MAP}
  MPEG2_PROGRAM_ELEMENTARY_STREAM    = $00000001;
  {$EXTERNALSYM MPEG2_PROGRAM_ELEMENTARY_STREAM}
  MPEG2_PROGRAM_DIRECTORY_PES_PACKET = $00000002;
  {$EXTERNALSYM MPEG2_PROGRAM_DIRECTORY_PES_PACKET}
  MPEG2_PROGRAM_PACK_HEADER          = $00000003;
  {$EXTERNALSYM MPEG2_PROGRAM_PACK_HEADER}
  MPEG2_PROGRAM_PES_STREAM           = $00000004;
  {$EXTERNALSYM MPEG2_PROGRAM_PES_STREAM}
  MPEG2_PROGRAM_SYSTEM_HEADER        = $00000005;
  {$EXTERNALSYM MPEG2_PROGRAM_SYSTEM_HEADER}
  SUBSTREAM_FILTER_VAL_NONE          = $10000000;
  {$EXTERNALSYM SUBSTREAM_FILTER_VAL_NONE}

type
  PStreamIDMap = ^TStreamIDMap;
  STREAM_ID_MAP = record
    stream_id             : ULONG;
    dwMediaSampleContent  : DWORD;
    ulSubstreamFilterValue: ULONG;
    iDataOffset           : integer;
    end;
  {$EXTERNALSYM STREAM_ID_MAP}
  TStreamIDMap = STREAM_ID_MAP;

  {$HPPEMIT 'typedef System::DelphiInterface<IEnumStreamIdMap> _di_IEnumStreamIdMap;'}
  {$EXTERNALSYM IEnumStreamIdMap}
  IEnumStreamIdMap = interface(IUnknown)
    ['{945C1566-6202-46fc-96C7-D87F289C6534}']
    (*** IEnumStreamIdMap methods ***)
    function Next(cRequest: ULONG; pStreamIdMap: PStreamIDMap;
             out pcReceived: ULONG): HResult; stdcall;
    function Skip(cRecords: ULONG): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out ppIEnumStreamIdMap: IEnumStreamIdMap): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMPEG2StreamIdMap> _di_IMPEG2StreamIdMap;'}
  {$EXTERNALSYM IMPEG2StreamIdMap}
  IMPEG2StreamIdMap = interface(IUnknown)
    ['{D0E04C47-25B8-4369-925A-362A01D95444}']
    (*** IMPEG2StreamIdMap methods ***)
    function MapStreamId(ulStreamId: ULONG; MediaSampleContent: DWORD;
             ulSubstreamFilterValue: ULONG; iDataOffset: integer): HResult; stdcall;
    function UnmapStreamId(culStreamId: ULONG; var pulStreamId: ULONG): HResult; stdcall;
    function EnumStreamIdMap(out ppIEnumStreamIdMap: IEnumStreamIdMap): HResult; stdcall;
  end;

  {$NODEFINE IAMovie} // deprecated
  IAMovie = interface(IFilterGraph)
    ['{359ACE10-7688-11CF-8B23-00805F6CEF60}']
    (*** IAMovie methods ***)
    function Connect(ppinOut, ppinIn: IPin): HResult; stdcall;
    function Render(ppinOut: IPin): HResult; stdcall;
    function Run: HResult; stdcall;
    function Pause: HResult; stdcall;
    function Stop: HResult; stdcall;
    function GetState(msTimeout: DWORD; out pfs: TFilterState): HResult; stdcall;
    function RenderFile(strFilename: PWideChar): HResult; stdcall;
    function AddSourceFilter(strFilename: PWideChar; out ppUnk: IBaseFilter): HResult; stdcall;
    function GetEventHandle(out hEvent: THandle): HResult; stdcall;
    function GetEvent(out lEventCode, lParam1, lParam2: Longint; msTimeout: DWORD): HResult; stdcall;
    function WaitForCompletion(msTimeout: DWORD; out pEvCode: Longint): HResult; stdcall;
    function CancelDefaultHandling(lEvCode: Longint): HResult; stdcall;
    function RestoreDefaultHandling(lEvCode: Longint): HResult; stdcall;
    function get_Duration(out plength: TRefTime): HResult; stdcall;
    function put_CurrentPosition(llTime: TRefTime): HResult; stdcall;
    function get_CurrentPosition(out pllTime: TRefTime): HResult; stdcall;
    function get_StopTime(out pllTime: TRefTime): HResult; stdcall;
    function put_StopTime(llTime: TRefTime): HResult; stdcall;
    function get_PrerollTime(out pllTime: TRefTime): HResult; stdcall;
    function put_PrerollTime(llTime: TRefTime): HResult; stdcall;
    function put_Rate(dRate: double): HResult; stdcall;
    function get_Rate(out pdRate: double): HResult; stdcall;
    function RemoveAllFilters: HResult; stdcall;
    function Play: HResult; stdcall;
    function PlayFile(strFilename: PWideChar): HResult; stdcall;
    function EnumFiltersByInterface(const riid: TGUID;
        out ppEnum: IEnumFilters): HResult; stdcall;
    function EnumPins(out ppEnum: IEnumPins): HResult; stdcall;
    function EnumPinsIn(out ppEnum: IEnumPins): HResult; stdcall;
    function EnumPinsOut(out ppEnum: IEnumPins): HResult; stdcall;
    function RenderAll: HResult; stdcall;
    function RenderNewFile(strFilename: PWideChar): HResult; stdcall;
    function FreeEventParams(lEvCode, lParam1, lParam2: Longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IRegisterServiceProvider> _di_IRegisterServiceProvider;'}
  {$EXTERNALSYM IRegisterServiceProvider}
  IRegisterServiceProvider = interface(IUnknown)
    ['{7B3A2F01-0751-48DD-B556-004785171C54}']
    (*** IRegisterServiceProvider methods ***)
    function RegisterService(const guidService: TGUID; pUnkObject: IUnknown): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMClockSlave> _di_IAMClockSlave;'}
  {$EXTERNALSYM IAMClockSlave}
  IAMClockSlave = interface(IUnknown)
    ['{9FD52741-176D-4b36-8F51-CA8F933223BE}']
    (*** IAMClockSlave methods ***)
    function SetErrorTolerance(dwTolerance: DWORD): HResult; stdcall;
    function GetErrorTolerance(out dwTolerance: DWORD): HResult; stdcall;
  end;

//---------------------------------------------------------------------
//
// IAMGraphBuilderCallback interface
//
// Interface which gives the app a chance to configure filters
// before a connection is attempted.
//
// If this interface is supported by the site passed in to the graph
// via IObjectWithSite::SetSite, the graph will call back with each
// filter it creates as part of the Render or Connect process. Does
// not call back for source filters. Filter may be discarded and not
// used in graph or may be connected and disconnected more than once
//
// The callback occurs with the graph lock held, so do not call into
// the graph again and do not wait on other threads calling into the
// graph.
//
//---------------------------------------------------------------------

  {$HPPEMIT 'typedef System::DelphiInterface<IAMGraphBuilderCallback> _di_IAMGraphBuilderCallback;'}
  {$EXTERNALSYM IAMGraphBuilderCallback}
  IAMGraphBuilderCallback = interface(IUnknown)
    ['{4995f511-9ddb-4f12-bd3b-f04611807b79}']
    (*** IAMGraphBuilderCallback methods ***)
    // graph builder selected a filter to create and attempt to
    // connect. failure indicates filter should be rejected.
    function SelectedFilter(pMon: IMoniker): HResult; stdcall;
    // app configures filter during this call. failure indicates
    // filter should be rejected.
    function CreatedFilter(pFil: IBaseFilter): HResult; stdcall;
  end;

// Note: Because this interface was not defined as a proper interface it is")
//       supported under C++ only. Methods aren't stdcall.")

  {$HPPEMIT 'typedef System::DelphiInterface<IAMFilterGraphCallback> _di_IAMFilterGraphCallback;'}
  {$EXTERNALSYM IAMFilterGraphCallback}
  IAMFilterGraphCallback = interface(IUnknown)
   ['{56a868fd-0ad4-11ce-b0a3-0020af0ba770}']
   (*** IAMFilterGraphCallback methods ***)
    // S_OK means rendering complete, S_FALSE means retry now.")
    // DCoder: thiscall fix. DON'T use ph1 and ph2, these are just placeholders
    // to get the real address of pPin !!!
    function UnableToRender(ph1, ph2: integer; pPin: IPin): HResult; // thiscall
  end;

//------------------------------------------------------------------------------
// File: EncAPI.idl
//
// Desc: Encoder (and future decoder) interface definitions.
//
// Copyright (c) 1992 - 2002, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

  CodecAPIEventData = record
    guid       : TGUID;
    dataLength : DWORD;
    reserved   : array[0..2] of DWORD;
    // data: array[0..dataLength-1] of Byte;
  end;
  {$EXTERNALSYM CodecAPIEventData}
  TCodecAPIEventData = CodecAPIEventData;

//  Applications can pass the CODECAPI_VIDEO_ENCODER to IsSupported to test for video encoders
//  Similarly, the GUIDs for audio encoders, video decoders, audio decoders and muxes can be
//  used to test for the codec classification
//
//  See uuids.h for a more detailed list.
  {$HPPEMIT 'typedef System::DelphiInterface<ICodecAPI> _di_ICodecAPI;'}
  {$EXTERNALSYM ICodecAPI}
  ICodecAPI = interface(IUnknown)
    ['{901db4c7-31ce-41a2-85dc-8fa0bf41b8da}']
    (*** ICodecAPI methods ***)
    // Query whether a given parameter is supported.
    function IsSupported(const Api: TGUID): HResult; stdcall;
    // Query whether a given parameter can be changed given the codec selection
    // and other parameter selections.
    function IsModifiable(const Api: TGUID): HResult; stdcall;
    // Returns the valid range of values that the parameter supports should
    // the parameter support a stepped range as opposed to a list of specific
    // values.  The support is [ValueMin .. ValueMax] by SteppingDelta.
    //
    // Ranged variant types must fall into one of the below types.  Each
    // parameter will, by definition, return a specific type.
    //
    // If the range has no stepping delta (any delta will do), the Stepping
    // delta will be empty (VT_EMPTY).
    function GetParameterRange(const Api: TGUID; out ValueMin, ValueMax,
      SteppingDelta: OleVariant): HResult; stdcall;
    // Returns the list of values supported by the given parameter as a
    // COM allocated array.  The total number of values will be placed in
    // the ValuesCount parameter and the Values array will contain the
    // individual values.  This array must be freed by the caller through
    // CoTaskMemFree().
    function GetParameterValues(const Api: TGUID; out Values: POleVariant;
      out ValuesCount: ULONG): HResult; stdcall;
    // Get the default value for a parameter, if one exists.  Otherwise,
    // an error will be returned.
    function GetDefaultValue(const Aoi: TGUID; out Value: OleVariant): HResult; stdcall;
    // Get the current value of a parameter.
    function GetValue(const Api: TGUID; out Value: OleVariant): HResult;
    // Set the current value of a parameter.
    function SetValue(const Api: TGUID; var Value: OleVariant): HResult; stdcall;
    // new methods beyond IEncoderAPI

    // Enable events to be reported for the given event GUID.  For DShow
    // events, the event is returned as
    //      (EC_CODECAPI_EVENT, lParam=userData, lParam2=CodecAPIEventData* Data)
    // where
    //      - the CodecAPIEventData is COM allocated memory and must be handled and freed
    //        by the application using CoTaskMemFree().
    //      - the userData is the same pointer passed to RegisterForEvent
    //
    // Each data block starts with the following structure:
    //      struct CodecAPIEventData
    //      {
    //          GUID guid;
    //          DWORD dataLength;
    //          DWORD reserved[3];     // pad to 16 byte alignment
    //          BYTE data[dataLength];
    //      }
    // The guid parameter identifies the event. The data associated with the event follows the
    // structure (represented by the variable length BYTE data[dataLength] array).
    //
    // If guid is equal to CODECAPI_CHANGELISTS, then data is an array of GUIDs that changed as
    // a result of setting the parameter, as follows:
    //      GUID    changedGuids[ header.dataLength / sizeof(GUID) ]
    //
    // The current array is limited, so a driver may send multiple messages if the array size is
    // exceeded.
    //
    function RegisterForEvent(const Api: TGUID; userData: Pointer): HResult; stdcall;
    // Disable event reporting for the given event GUID.
    function UnregisterForEvent(const Api: TGUID): HResult; stdcall;
    // SetAllDefaults
    function SetAllDefaults: HResult; stdcall;
    // Extended SetValue & SetAllDefaults:
    // Changes the current value of a parameter and returns back an alteration list
    //  The secondary arguments return back a list of other settings
    //  that changed as a result of the SetValue() call (for UI updates etc)
    //  The client must free the buffer.
    function SetValueWithNotify(const Api: TGUID; var Value: Olevariant;
        out ChangedParam: PGUID; out ChangedParamCount: ULONG): HResult; stdcall;
    function SetAllDefaultsWithNotify(out ChangedParam: PGUID;
      out ChangedParamCount: ULONG): HResult; stdcall;
    // Load the current settings from a stream
    function GetAllSettings(Stream: IStream): HResult; stdcall;
    // Save the current settings to a stream
    function SetAllSettings(Stream: IStream): HResult; stdcall;
    function SetAllSettingsWithNotify(Stream: IStream; out ChangedParam: PGUID;
      out ChangedParamCount: ULONG): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IGetCapabilitiesKey> _di_IGetCapabilitiesKey;'}
  {$EXTERNALSYM IGetCapabilitiesKey}
  IGetCapabilitiesKey = interface(IUnknown)
    ['{a8809222-07bb-48ea-951c-33158100625b}']
    (*** IGetCapabilitiesKey methods ***)
    function GetCapabilitiesKey(out pHKey: HKEY): HResult; stdcall;
  end;

// -----------------------------------------------------------------------------------------
// From this point on, this is retained for backwards compatiblity only
// Do not use this for future encoders
// -----------------------------------------------------------------------------------------
  {$HPPEMIT 'typedef System::DelphiInterface<IEncoderAPI> _di_IEncoderAPI;'}
  {$EXTERNALSYM IEncoderAPI}
  IEncoderAPI = interface(IUnknown)
    ['{70423839-6ACC-4b23-B079-21DBF08156A5}']
    (*** IEncoderAPI methods ***)
    function IsSupported(const Api: TGUID): HResult; stdcall;
    function IsAvailable(const Api: TGUID): HResult; stdcall;
    function GetParameterRange(const Api: TGUID; out ValueMin, ValueMax,
      SteppingDelta: OleVariant): HResult; stdcall;
    function GetParameterValues(const Api: TGUID; out Values: POleVariant;
      out ValuesCount: ULONG): HResult; stdcall;
    function GetDefaultValue (const Api: TGUID; out Value: OleVariant): HResult; stdcall;
    function GetValue(const Api: TGUID; out Value: OleVariant): HResult; stdcall;
    function SetValue(const Api: TGUID; var Value: OleVariant): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IVideoEncoder> _di_IVideoEncoder;'}
  {$EXTERNALSYM IVideoEncoder}
  IVideoEncoder = interface(IEncoderAPI)
    ['{02997C3B-8E1B-460e-9270-545E0DE9563E}']
    (*** IVideoEncoder methods ***)
  end;

//---------------------------------------------------------------------
//
// Old Encoder API Interfaces
//
//---------------------------------------------------------------------

  VIDEOENCODER_BITRATE_MODE = (
    // Bit rate used for encoding is constant
    ConstantBitRate,
    // Bit rate used for encoding is variable with the specified bitrate used
    // as a guaranteed average over a specified window.  The default window
    // size is considered to be 5 minutes.
    VariableBitRateAverage,
    // Bit rate used for encoding is variable with the specified bitrate used
    // as a peak rate over a specified window.  The default window size
    // is considered to be 500ms (classically one GOP).
    VariableBitRatePeak
  );
  {$EXTERNALSYM VIDEOENCODER_BITRATE_MODE}
  TVideoEncoderBitrateMode = VIDEOENCODER_BITRATE_MODE;
  
const
  AM_GETDECODERCAP_QUERY_VMR_SUPPORT  = $00000001;
  {$EXTERNALSYM AM_GETDECODERCAP_QUERY_VMR_SUPPORT}
  VMR_NOTSUPPORTED                    = $00000000;
  {$EXTERNALSYM VMR_NOTSUPPORTED}
  VMR_SUPPORTED                       = $00000001;
  {$EXTERNALSYM VMR_SUPPORTED}

  AM_QUERY_DECODER_VMR_SUPPORT        = $00000001;
  {$EXTERNALSYM AM_QUERY_DECODER_VMR_SUPPORT}
  AM_QUERY_DECODER_DXVA_1_SUPPORT     = $00000002;
  {$EXTERNALSYM AM_QUERY_DECODER_DXVA_1_SUPPORT}

  AM_QUERY_DECODER_DVD_SUPPORT        = $00000003;
  {$EXTERNALSYM AM_QUERY_DECODER_DVD_SUPPORT}
  AM_QUERY_DECODER_ATSC_SD_SUPPORT    = $00000004;
  {$EXTERNALSYM AM_QUERY_DECODER_ATSC_SD_SUPPORT}
  AM_QUERY_DECODER_ATSC_HD_SUPPORT    = $00000005;
  {$EXTERNALSYM AM_QUERY_DECODER_ATSC_HD_SUPPORT}
  AM_GETDECODERCAP_QUERY_VMR9_SUPPORT = $00000006;
  {$EXTERNALSYM AM_GETDECODERCAP_QUERY_VMR9_SUPPORT}

  DECODER_CAP_NOTSUPPORTED            = $00000000;
  {$EXTERNALSYM DECODER_CAP_NOTSUPPORTED}
  DECODER_CAP_SUPPORTED               = $00000001;
  {$EXTERNALSYM DECODER_CAP_SUPPORTED}

  CDEF_CLASS_DEFAULT          = $0001;
  {$EXTERNALSYM CDEF_CLASS_DEFAULT}
  CDEF_BYPASS_CLASS_MANAGER   = $0002;
  {$EXTERNALSYM CDEF_BYPASS_CLASS_MANAGER}
  //CDEF_CLASS_LEGACY           = $0004;
  CDEF_MERIT_ABOVE_DO_NOT_USE = $0008;
  {$EXTERNALSYM CDEF_MERIT_ABOVE_DO_NOT_USE}
  CDEF_DEVMON_CMGR_DEVICE     = $0010;
  {$EXTERNALSYM CDEF_DEVMON_CMGR_DEVICE}
  CDEF_DEVMON_DMO             = $0020;
  {$EXTERNALSYM CDEF_DEVMON_DMO}
  CDEF_DEVMON_PNP_DEVICE      = $0040;
  {$EXTERNALSYM CDEF_DEVMON_PNP_DEVICE}
  CDEF_DEVMON_FILTER          = $0080;
  {$EXTERNALSYM CDEF_DEVMON_FILTER}
  CDEF_DEVMON_SELECTIVE_MASK  = $00f0;
  {$EXTERNALSYM CDEF_DEVMON_SELECTIVE_MASK}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMDecoderCaps> _di_IAMDecoderCaps;'}
  {$EXTERNALSYM IAMDecoderCaps}
  IAMDecoderCaps = interface(IUnknown)
    ['{c0dff467-d499-4986-972b-e1d9090fa941}']
    (*** IAMDecoderCaps methods ***)
    function GetDecoderCaps(dwCapIndex: DWORD; out lpdwCap: DWORD): HResult; stdcall;
  end;

///////////////////////////////////////////////////////////////////////////////
//
// IAMCertifiedOutputProtection
//
///////////////////////////////////////////////////////////////////////////////

  PAMCOPPSignature = ^TAMCOPPSignature;
  AMCOPPSignature = packed record
    Signature: array[0..255] of byte;
  end;
  {$EXTERNALSYM AMCOPPSignature}
  TAMCOPPSignature = AMCOPPSignature;

  AMCOPPCommand = packed record
    macKDI: TGUID;             //   16 bytes
    guidCommandID: TGUID;      //   16 bytes
    dwSequence: DWORD;         //    4 bytes
    cbSizeData: DWORD;         //    4 bytes
    CommandData: array[0..4055] of byte;  // 4056 bytes (4056+4+4+16+16 = 4096)
  end;
  {$EXTERNALSYM AMCOPPCommand}
  TAMCOPPCommand = AMCOPPCommand;
  LPAMCOPPCommand = ^AMCOPPCommand;
  {$EXTERNALSYM LPAMCOPPCommand}
  PAMCOPPCommand = LPAMCOPPCommand;

  AMCOPPStatusInput = packed record
    rApp: TGUID;               //   16 bytes
    guidStatusRequestID: TGUID;//   16 bytes
    dwSequence: DWORD;         //    4 bytes
    cbSizeData: DWORD;         //    4 bytes
    StatusData: array[0..4055] of byte;   // 4056 bytes (4056+4+4+16+16 = 4096)
  end;
  {$EXTERNALSYM AMCOPPStatusInput}
  TAMCOPPStatusInput = AMCOPPStatusInput;
  LPAMCOPPStatusInput = ^AMCOPPStatusInput;
  {$EXTERNALSYM LPAMCOPPStatusInput}
  PAMCOPPStatusInput = LPAMCOPPStatusInput;

  AMCOPPStatusOutput = packed record
    macKDI: TGUID;             //   16 bytes
    cbSizeData: DWORD;         //    4 bytes
    COPPStatus: array[0..4075] of byte;   // 4076 bytes (4076+16+4 = 4096)
  end;
  {$EXTERNALSYM AMCOPPStatusOutput}
  TAMCOPPStatusOutput = AMCOPPStatusOutput;
  LPAMCOPPStatusOutput = ^AMCOPPStatusOutput;
  {$EXTERNALSYM LPAMCOPPStatusOutput}
  PAMCOPPStatusOutput = LPAMCOPPStatusOutput;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMCertifiedOutputProtection> _di_IAMCertifiedOutputProtection;'}
  {$EXTERNALSYM IAMCertifiedOutputProtection}
  IAMCertifiedOutputProtection = interface(IUnknown)
  ['{6FEDED3E-0FF1-4901-A2F1-43F7012C8515}']
    function KeyExchange(
        pRandom: PGUID;             // 128-bit random number generated by Graphics Driver
        var VarLenCertGH: PByte;    // Graphics Hardware certificate, memory released by CoTaskMemFree
        pdwLengthCertGH: PDWORD     // Length of Graphics Hardware certificate
    ): HRESULT; stdcall;

    // Concatenation of 128-bit random data security session key,
    // 128-bit random data integrity session key, 32-bit random
    // starting status sequence number and 32-bit random starting
    // command sequence number encrypted with the public key of
    // the graphic hardware. This value is 2048 bits long.
    function SessionSequenceStart(pSig: PAMCOPPSignature): HRESULT; stdcall;

    function ProtectionCommand(cmd: PAMCOPPCommand): HRESULT; stdcall; // Encrypted command

    function ProtectionStatus(
      pStatusInput: PAMCOPPStatusInput;  // Encrypted Status request
      pStatusOutput: PAMCOPPStatusOutput): HRESULT; stdcall;     // Encrypted Status results
  end;

////////////////////////////////////////////////////////////////////////////////

  {$HPPEMIT 'typedef System::DelphiInterface<ICreateDevEnum> _di_ICreateDevEnum;'}
  {$EXTERNALSYM ICreateDevEnum}
  ICreateDevEnum = interface(IUnknown)
    ['{29840822-5B84-11D0-BD3B-00A0C911CE86}']
    (*** ICreateDevEnum methods ***)
    function CreateClassEnumerator(const clsidDeviceClass: TGUID;
        out ppEnumMoniker: IEnumMoniker; dwFlags: DWORD): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IFilterMapper3> _di_IFilterMapper3;'}
  {$EXTERNALSYM IFilterMapper3}
  IFilterMapper3 = interface(IFilterMapper2)
    ['{b79bb0b1-33c1-11d1-abe1-00a0c905f375}']
    (*** IFilterMapper3 methods ***)
    function GetICreateDevEnum(out ppEnum: ICreateDevEnum): HResult; stdcall;
  end;

//replacement for DVD_TextStringType in GetDVDTextStringAsNative, GetDVDTextStringAsUnicode

{$IFNDEF COMPILER6_UP}
type
  DVD_TextStringType = {$IFDEF TYPE_IDENTITY}type {$ENDIF}LongWord;
const
  DVD_Struct_Volume      = $00000001;
  DVD_Struct_Title       = $00000002;
  DVD_Struct_ParentalID  = $00000003;
  DVD_Struct_PartOfTitle = $00000004;
  DVD_Struct_Cell        = $00000005;
  DVD_Stream_Audio       = $00000010;
  DVD_Stream_Subpicture  = $00000011;
  DVD_Stream_Angle       = $00000012;
  DVD_Channel_Audio      = $00000020;
  DVD_General_Name       = $00000030;
  DVD_General_Comments   = $00000031;
  DVD_Title_Series       = $00000038;
  DVD_Title_Movie        = $00000039;
  DVD_Title_Video        = $0000003A;
  DVD_Title_Album        = $0000003B;
  DVD_Title_Song         = $0000003C;
  DVD_Title_Other        = $0000003F;
  DVD_Title_Sub_Series   = $00000040;
  DVD_Title_Sub_Movie    = $00000041;
  DVD_Title_Sub_Video    = $00000042;
  DVD_Title_Sub_Album    = $00000043;
  DVD_Title_Sub_Song     = $00000044;
  DVD_Title_Sub_Other    = $00000047;
  DVD_Title_Orig_Series  = $00000048;
  DVD_Title_Orig_Movie   = $00000049;
  DVD_Title_Orig_Video   = $0000004A;
  DVD_Title_Orig_Album   = $0000004B;
  DVD_Title_Orig_Song    = $0000004C;
  DVD_Title_Orig_Other   = $0000004F;
  DVD_Other_Scene        = $00000050;
  DVD_Other_Cut          = $00000051;
  DVD_Other_Take         = $00000052;
{$ELSE}
type
  DVD_TextStringType = (
    DVD_Struct_Volume      = $00000001,
    DVD_Struct_Title       = $00000002,
    DVD_Struct_ParentalID  = $00000003,
    DVD_Struct_PartOfTitle = $00000004,
    DVD_Struct_Cell        = $00000005,
    DVD_Stream_Audio       = $00000010,
    DVD_Stream_Subpicture  = $00000011,
    DVD_Stream_Angle       = $00000012,
    DVD_Channel_Audio      = $00000020,
    DVD_General_Name       = $00000030,
    DVD_General_Comments   = $00000031,
    DVD_Title_Series       = $00000038,
    DVD_Title_Movie        = $00000039,
    DVD_Title_Video        = $0000003A,
    DVD_Title_Album        = $0000003B,
    DVD_Title_Song         = $0000003C,
    DVD_Title_Other        = $0000003F,
    DVD_Title_Sub_Series   = $00000040,
    DVD_Title_Sub_Movie    = $00000041,
    DVD_Title_Sub_Video    = $00000042,
    DVD_Title_Sub_Album    = $00000043,
    DVD_Title_Sub_Song     = $00000044,
    DVD_Title_Sub_Other    = $00000047,
    DVD_Title_Orig_Series  = $00000048,
    DVD_Title_Orig_Movie   = $00000049,
    DVD_Title_Orig_Video   = $0000004A,
    DVD_Title_Orig_Album   = $0000004B,
    DVD_Title_Orig_Song    = $0000004C,
    DVD_Title_Orig_Other   = $0000004F,
    DVD_Other_Scene        = $00000050,
    DVD_Other_Cut          = $00000051,
    DVD_Other_Take         = $00000052
  );
{$ENDIF}
{$EXTERNALSYM DVD_TextStringType}
type
  TDVDTextStringType = DVD_TextStringType;

  // For IDVDControl2.SetOption flags
  DVD_OPTION_FLAG = (
  {$IFNDEF COMPILER6_UP}
    DVD_Option_INVALID_0,
    DVD_ResetOnStop,
  {$ELSE}
    DVD_ResetOnStop               = 1,
  {$ENDIF}
    DVD_NotifyParentalLevelChange,
    DVD_HMSF_TimeCodeEvents,
    DVD_AudioDuringFFwdRew   // default FALSE (or by reg) // DirectX9 Specific
  );
  {$EXTERNALSYM DVD_OPTION_FLAG}
  TDVDOptionFlag = DVD_OPTION_FLAG;

  tagDVD_DOMAIN = (
  {$IFNDEF COMPILER6_UP}
    DVD_DOMAIN_INVALID_0,
    DVD_DOMAIN_FirstPlay,
  {$ELSE}
    DVD_DOMAIN_FirstPlay = 1,
  {$ENDIF}
    DVD_DOMAIN_VideoManagerMenu,
    DVD_DOMAIN_VideoTitleSetMenu,
    DVD_DOMAIN_Title,
    DVD_DOMAIN_Stop
  );
  {$EXTERNALSYM tagDVD_DOMAIN}
  DVD_DOMAIN = tagDVD_DOMAIN;
  {$EXTERNALSYM DVD_DOMAIN}
  TDVDDomain = DVD_DOMAIN;


  tagDVD_MENU_ID = (
  {$EXTERNALSYM tagDVD_MENU_ID}
  {$IFNDEF COMPILER6_UP}
    DVD_MENU_INVALID_0,
    DVD_MENU_INVALID_1,
    DVD_MENU_Title,
  {$ELSE}
    DVD_MENU_Title      = 2,
  {$ENDIF}
    DVD_MENU_Root,
    DVD_MENU_Subpicture,
    DVD_MENU_Audio,
    DVD_MENU_Angle,
    DVD_MENU_Chapter
  );
  DVD_MENU_ID = tagDVD_MENU_ID;
  {$EXTERNALSYM DVD_MENU_ID}
  TDVDMenuID = DVD_MENU_ID;

  tagDVD_DISC_SIDE = (
  {$IFNDEF COMPILER6_UP}
    DVD_SIDE_INVALID_0,
    DVD_SIDE_A,
    DVD_SIDE_B
  {$ELSE}
    DVD_SIDE_A = 1,
    DVD_SIDE_B = 2
  {$ENDIF}
  );
  {$EXTERNALSYM tagDVD_DISC_SIDE}
  DVD_DISC_SIDE = tagDVD_DISC_SIDE;
  {$EXTERNALSYM DVD_DISC_SIDE}
  TDVDDiscSide = DVD_DISC_SIDE;

  tagDVD_PREFERRED_DISPLAY_MODE = (
    DISPLAY_CONTENT_DEFAULT,
    DISPLAY_16x9,
    DISPLAY_4x3_PANSCAN_PREFERRED,
    DISPLAY_4x3_LETTERBOX_PREFERRED
  );
  {$EXTERNALSYM tagDVD_PREFERRED_DISPLAY_MODE}
  DVD_PREFERRED_DISPLAY_MODE = tagDVD_PREFERRED_DISPLAY_MODE;
  {$EXTERNALSYM DVD_PREFERRED_DISPLAY_MODE}
  TDVDPreferredDisplayMode = DVD_PREFERRED_DISPLAY_MODE;

  tagDVD_VIDEO_COMPRESSION = (
    DVD_VideoCompression_Other,
    DVD_VideoCompression_MPEG1,
    DVD_VideoCompression_MPEG22
  );
  {$EXTERNALSYM tagDVD_VIDEO_COMPRESSION}
  DVD_VIDEO_COMPRESSION = tagDVD_VIDEO_COMPRESSION;
  {$EXTERNALSYM DVD_VIDEO_COMPRESSION}
  TDVDVideoCompression = DVD_VIDEO_COMPRESSION;

  tagDVD_AUDIO_APPMODE = (
    DVD_AudioMode_None,
    DVD_AudioMode_Karaoke,
    DVD_AudioMode_Surround,
    DVD_AudioMode_Other
    );
  {$EXTERNALSYM tagDVD_AUDIO_APPMODE}
  DVD_AUDIO_APPMODE = tagDVD_AUDIO_APPMODE;
  {$EXTERNALSYM DVD_AUDIO_APPMODE}
  TDVDAudioAPPMode = DVD_AUDIO_APPMODE;

  tagDVD_AUDIO_FORMAT = (
    DVD_AudioFormat_AC3,
    DVD_AudioFormat_MPEG1,
    DVD_AudioFormat_MPEG1_DRC,
    DVD_AudioFormat_MPEG2,
    DVD_AudioFormat_MPEG2_DRC,
    DVD_AudioFormat_LPCM,
    DVD_AudioFormat_DTS,
    DVD_AudioFormat_SDDS,
    DVD_AudioFormat_Other
    );
  {$EXTERNALSYM tagDVD_AUDIO_FORMAT}
  DVD_AUDIO_FORMAT = tagDVD_AUDIO_FORMAT;
  {$EXTERNALSYM DVD_AUDIO_FORMAT}
  TDVDAudioFormat = DVD_AUDIO_FORMAT;


// DVD_KARAOKE_DOWNMIX
const
	DVD_Mix_0to0	= $1   ;
  {$EXTERNALSYM DVD_Mix_0to0}
	DVD_Mix_1to0	= $2   ;
  {$EXTERNALSYM DVD_Mix_1to0}
	DVD_Mix_2to0	= $4   ;
  {$EXTERNALSYM DVD_Mix_2to0}
	DVD_Mix_3to0	= $8   ;
  {$EXTERNALSYM DVD_Mix_3to0}
	DVD_Mix_4to0	= $10  ;
  {$EXTERNALSYM DVD_Mix_4to0}
	DVD_Mix_Lto0	= $20  ;
  {$EXTERNALSYM DVD_Mix_Lto0}
	DVD_Mix_Rto0	= $40  ;
  {$EXTERNALSYM DVD_Mix_Rto0}
	DVD_Mix_0to1	= $100 ;
  {$EXTERNALSYM DVD_Mix_0to1}
	DVD_Mix_1to1	= $200 ;
  {$EXTERNALSYM DVD_Mix_1to1}
	DVD_Mix_2to1	= $400 ;
  {$EXTERNALSYM DVD_Mix_2to1}
	DVD_Mix_3to1	= $800 ;
  {$EXTERNALSYM DVD_Mix_3to1}
	DVD_Mix_4to1	= $1000;
  {$EXTERNALSYM DVD_Mix_4to1}
	DVD_Mix_Lto1	= $2000;
  {$EXTERNALSYM DVD_Mix_Lto1}
	DVD_Mix_Rto1	= $4000;
  {$EXTERNALSYM DVD_Mix_Rto1}

type        
  tagDVD_AUDIO_LANG_EXT = (
    DVD_AUD_EXT_NotSpecified,
    DVD_AUD_EXT_Captions,
    DVD_AUD_EXT_VisuallyImpaired,
    DVD_AUD_EXT_DirectorComments1,
    DVD_AUD_EXT_DirectorComments2
    );
  {$EXTERNALSYM tagDVD_AUDIO_LANG_EXT}
  DVD_AUDIO_LANG_EXT = tagDVD_AUDIO_LANG_EXT;
  {$EXTERNALSYM DVD_AUDIO_LANG_EXT}
  TDVDAudioLangExt = DVD_AUDIO_LANG_EXT;

  tagDVD_SUBPICTURE_TYPE = (
    DVD_SPType_NotSpecified,
    DVD_SPType_Language,
    DVD_SPType_Other
    );
  {$EXTERNALSYM tagDVD_SUBPICTURE_TYPE}
  DVD_SUBPICTURE_TYPE = tagDVD_SUBPICTURE_TYPE;
  {$EXTERNALSYM DVD_SUBPICTURE_TYPE}
  TDVDSubpictureType = DVD_SUBPICTURE_TYPE;

  tagDVD_SUBPICTURE_CODING = (
    DVD_SPCoding_RunLength,
    DVD_SPCoding_Extended,
    DVD_SPCoding_Other
    );
  {$EXTERNALSYM tagDVD_SUBPICTURE_CODING}
  DVD_SUBPICTURE_CODING = tagDVD_SUBPICTURE_CODING;
  {$EXTERNALSYM DVD_SUBPICTURE_CODING}
  TDVDSubpictureCoding = DVD_SUBPICTURE_CODING;

  {$IFNDEF COMPILER6_UP}
  tagDVD_SUBPICTURE_LANG_EXT = {$IFDEF TYPE_IDENTITY}type {$ENDIF}LongWord;
  const
    DVD_SP_EXT_NotSpecified               = 0;
    DVD_SP_EXT_Caption_Normal	            = 1;
    DVD_SP_EXT_Caption_Big	              = 2;
    DVD_SP_EXT_Caption_Children	          = 3;
    DVD_SP_EXT_CC_Normal	                = 5;
    DVD_SP_EXT_CC_Big	                    = 6;
    DVD_SP_EXT_CC_Children	              = 7;
    DVD_SP_EXT_Forced	                    = 9;
    DVD_SP_EXT_DirectorComments_Normal	  = 13;
    DVD_SP_EXT_DirectorComments_Big	      = 14;
    DVD_SP_EXT_DirectorComments_Children	= 15;
  {$ELSE}
  tagDVD_SUBPICTURE_LANG_EXT = (
    DVD_SP_EXT_NotSpecified               = 0,
    DVD_SP_EXT_Caption_Normal	            = 1,
    DVD_SP_EXT_Caption_Big	              = 2,
    DVD_SP_EXT_Caption_Children	          = 3,
    DVD_SP_EXT_CC_Normal	                = 5,
    DVD_SP_EXT_CC_Big	                    = 6,
    DVD_SP_EXT_CC_Children	              = 7,
    DVD_SP_EXT_Forced	                    = 9,
    DVD_SP_EXT_DirectorComments_Normal	  = 13,
    DVD_SP_EXT_DirectorComments_Big	      = 14,
    DVD_SP_EXT_DirectorComments_Children	= 15
  );
  {$ENDIF}
type
  {$EXTERNALSYM tagDVD_SUBPICTURE_LANG_EXT}
  DVD_SUBPICTURE_LANG_EXT = tagDVD_SUBPICTURE_LANG_EXT;
  {$EXTERNALSYM DVD_SUBPICTURE_LANG_EXT}
  TDVDSubpictureLangExt = DVD_SUBPICTURE_LANG_EXT;

type
  tagDVD_KARAOKE_ASSIGNMENT = (
    DVD_Assignment_reserved0,
    DVD_Assignment_reserved1,
    DVD_Assignment_LR,
    DVD_Assignment_LRM,
    DVD_Assignment_LR1,
    DVD_Assignment_LRM1,
    DVD_Assignment_LR12,
    DVD_Assignment_LRM12
  );
  {$EXTERNALSYM tagDVD_KARAOKE_ASSIGNMENT}
  DVD_KARAOKE_ASSIGNMENT = tagDVD_KARAOKE_ASSIGNMENT;
  {$EXTERNALSYM DVD_KARAOKE_ASSIGNMENT}
  TDVDKaraokeAssignment = DVD_KARAOKE_ASSIGNMENT;

  DVD_RELATIVE_BUTTON = (
  {$IFNDEF COMPILER6_UP}
    DVD_Relative_INVALID_0,
    DVD_Relative_Upper,
    DVD_Relative_Lower,
    DVD_Relative_Left,
    DVD_Relative_Right
  {$ELSE}
    DVD_Relative_Upper = 1,
    DVD_Relative_Lower = 2,
    DVD_Relative_Left  = 3,
    DVD_Relative_Right = 4
  {$ENDIF}
  );
  {$EXTERNALSYM DVD_RELATIVE_BUTTON}
  TDVDRelativeButton = DVD_RELATIVE_BUTTON;

  DVD_REGISTER = {$IFDEF TYPE_IDENTITY}type {$ENDIF}Word;
  {$EXTERNALSYM DVD_REGISTER}
  GPRMArray = array[0..15] of DVD_REGISTER;
  {$EXTERNALSYM GPRMArray}

  SPRMArray = array[0..23] of DVD_REGISTER;
  {$EXTERNALSYM SPRMArray}
  TSPRMArray = SPRMArray;

  tagDVD_ATR = record
    ulCAT : ULONG;
    pbATRI: array[0..767] of Byte;
  end;
  {$EXTERNALSYM tagDVD_ATR}
  DVD_ATR = tagDVD_ATR;
  {$EXTERNALSYM DVD_ATR}
  TDVDAtr = tagDVD_ATR;

  DVD_VideoATR = array[0..1] of Byte;
  {$EXTERNALSYM DVD_VideoATR}
  DVD_AudioATR = array[0..7] of Byte;
  {$EXTERNALSYM DVD_AudioATR}
  DVD_SubpictureATR = array[0..5] of Byte;
  {$EXTERNALSYM DVD_SubpictureATR}

  (*** DVD_SubpictureATR methods ***)
  tagDVD_FRAMERATE = (
  {$IFNDEF COMPILER6_UP}
    DVD_FPS_INVALID_0,
    DVD_FPS_25,
    DVD_FPS_INVALID_2,
    DVD_FPS_30NonDrop
  {$ELSE}
    DVD_FPS_25        = 1,
    DVD_FPS_30NonDrop = 3
  {$ENDIF}
  );

  {$EXTERNALSYM tagDVD_FRAMERATE}
  DVD_FRAMERATE = tagDVD_FRAMERATE;
  {$EXTERNALSYM DVD_FRAMERATE}
  TDVDFramerate = DVD_FRAMERATE;


//typedef struct tagDVD_TIMECODE
//{
//   ULONG Hours1    :4; // Hours
//   ULONG Hours10  :4; // Tens of Hours
//
//   ULONG Minutes1  :4; // Minutes
//   ULONG Minutes10:4; // Tens of Minutes
//
//   ULONG Seconds1  :4; // Seconds
//   ULONG Seconds10:4; // Tens of Seconds
//
//   ULONG Frames1   :4; // Frames
//   ULONG Frames10 :2; // Tens of Frames
//
//   ULONG FrameRateCode: 2; // use DVD_FRAMERATE to indicate frames/sec and drop/non-drop
//} DVD_TIMECODE;

  tagDVD_TIMECODE = record
    Hours1    : byte;
    Hours10   : byte;
    Minutes1  : byte;
    Minutes10 : byte;
    Seconds1  : byte;
    Seconds10 : byte;
    Frames1   : byte;
    Frames10  : byte;
    FrameRateCode: byte;
  end;
  {$EXTERNALSYM tagDVD_TIMECODE}
  DVD_TIMECODE = tagDVD_TIMECODE;
  {$EXTERNALSYM DVD_TIMECODE}
  TDVDTimeCode = tagDVD_TIMECODE;

//DVD_TIMECODE_FLAGS
const
  DVD_TC_FLAG_25fps	        = $1;
  {$EXTERNALSYM DVD_TC_FLAG_25fps}
	DVD_TC_FLAG_30fps	        = $2;
  {$EXTERNALSYM DVD_TC_FLAG_30fps}
	DVD_TC_FLAG_DropFrame	    = $4;
  {$EXTERNALSYM DVD_TC_FLAG_DropFrame}
  DVD_TC_FLAG_Interpolated	= $8;
  {$EXTERNALSYM DVD_TC_FLAG_Interpolated}

type
  PDVDHMSFTimeCode = ^TDVDHMSFTimeCode;
  tagDVD_HMSF_TIMECODE = record
  {$EXTERNALSYM tagDVD_HMSF_TIMECODE}
    bHours   : BYTE;
    bMinutes : BYTE;
    bSeconds : BYTE;
    bFrames  : BYTE;
  end;
  DVD_HMSF_TIMECODE = tagDVD_HMSF_TIMECODE;
  {$EXTERNALSYM DVD_HMSF_TIMECODE}
  TDVDHMSFTimeCode = tagDVD_HMSF_TIMECODE;

  tagDVD_PLAYBACK_LOCATION2 = record
    TitleNum      : ULONG;
    ChapterNum    : ULONG;
    TimeCode      : DVD_HMSF_TIMECODE;
    TimeCodeFlags : ULONG;
  end;
  {$EXTERNALSYM tagDVD_PLAYBACK_LOCATION2}
  DVD_PLAYBACK_LOCATION2 = tagDVD_PLAYBACK_LOCATION2;
  {$EXTERNALSYM DVD_PLAYBACK_LOCATION2}
  TDVDPlayBackLocation2 = tagDVD_PLAYBACK_LOCATION2;

  tagDVD_PLAYBACK_LOCATION = record
    TitleNum   : ULONG;
    ChapterNum : ULONG;
    TimeCode   : ULONG;
  end;
  {$EXTERNALSYM tagDVD_PLAYBACK_LOCATION}
  DVD_PLAYBACK_LOCATION = tagDVD_PLAYBACK_LOCATION;
  {$EXTERNALSYM DVD_PLAYBACK_LOCATION}
  TDVDPlaybackLocation = tagDVD_PLAYBACK_LOCATION;

  VALID_UOP_SOMTHING_OR_OTHER = {$IFDEF TYPE_IDENTITY}type {$ENDIF} DWord;
  {$EXTERNALSYM VALID_UOP_SOMTHING_OR_OTHER}

VALID_UOP_FLAG  = {$IFDEF TYPE_IDENTITY}type {$ENDIF} DWord;
{$EXTERNALSYM VALID_UOP_FLAG}
  const
  UOP_FLAG_Play_Title_Or_AtTime	                  = $1;
  {$EXTERNALSYM UOP_FLAG_Play_Title_Or_AtTime}
  UOP_FLAG_Play_Chapter	                          = $2;
  {$EXTERNALSYM UOP_FLAG_Play_Chapter}
  UOP_FLAG_Play_Title	                            = $4;
  {$EXTERNALSYM UOP_FLAG_Play_Title}
  UOP_FLAG_Stop	                                  = $8;
  {$EXTERNALSYM UOP_FLAG_Stop}
  UOP_FLAG_ReturnFromSubMenu	                    = $10;
  {$EXTERNALSYM UOP_FLAG_ReturnFromSubMenu}
  UOP_FLAG_Play_Chapter_Or_AtTime	                = $20;
  {$EXTERNALSYM UOP_FLAG_Play_Chapter_Or_AtTime}
  UOP_FLAG_PlayPrev_Or_Replay_Chapter	            = $40;
  {$EXTERNALSYM UOP_FLAG_PlayPrev_Or_Replay_Chapter}
  UOP_FLAG_PlayNext_Chapter	                      = $80;
  {$EXTERNALSYM UOP_FLAG_PlayNext_Chapter}
  UOP_FLAG_Play_Forwards	                        = $100;
  {$EXTERNALSYM UOP_FLAG_Play_Forwards}
  UOP_FLAG_Play_Backwards	                        = $200;
  {$EXTERNALSYM UOP_FLAG_Play_Backwards}
  UOP_FLAG_ShowMenu_Title	                        = $400;
  {$EXTERNALSYM UOP_FLAG_ShowMenu_Title}
  UOP_FLAG_ShowMenu_Root	                        = $800;
  {$EXTERNALSYM UOP_FLAG_ShowMenu_Root}
  UOP_FLAG_ShowMenu_SubPic	                      = $1000;
  {$EXTERNALSYM UOP_FLAG_ShowMenu_SubPic}
  UOP_FLAG_ShowMenu_Audio	                        = $2000;
  {$EXTERNALSYM UOP_FLAG_ShowMenu_Audio}
  UOP_FLAG_ShowMenu_Angle	                        = $4000;
  {$EXTERNALSYM UOP_FLAG_ShowMenu_Angle}
  UOP_FLAG_ShowMenu_Chapter	                      = $8000;
  {$EXTERNALSYM UOP_FLAG_ShowMenu_Chapter}
  UOP_FLAG_Resume	                                = $10000;
  {$EXTERNALSYM UOP_FLAG_Resume}
  UOP_FLAG_Select_Or_Activate_Button	            = $20000;
  {$EXTERNALSYM UOP_FLAG_Select_Or_Activate_Button}
  UOP_FLAG_Still_Off	                            = $40000;
  {$EXTERNALSYM UOP_FLAG_Still_Off}
  UOP_FLAG_Pause_On	                              = $80000;
  {$EXTERNALSYM UOP_FLAG_Pause_On}
  UOP_FLAG_Select_Audio_Stream	                  = $100000;
  {$EXTERNALSYM UOP_FLAG_Select_Audio_Stream}
  UOP_FLAG_Select_SubPic_Stream	                  = $200000;
  {$EXTERNALSYM UOP_FLAG_Select_SubPic_Stream}
  UOP_FLAG_Select_Angle	                          = $400000;
  {$EXTERNALSYM UOP_FLAG_Select_Angle}
  UOP_FLAG_Select_Karaoke_Audio_Presentation_Mode	= $800000;
  {$EXTERNALSYM UOP_FLAG_Select_Karaoke_Audio_Presentation_Mode}
  UOP_FLAG_Select_Video_Mode_Preference	          = $1000000;
  {$EXTERNALSYM UOP_FLAG_Select_Video_Mode_Preference}

type
  DVD_TextCharSet = (
    DVD_CharSet_Unicode,
    DVD_CharSet_ISO646,
    DVD_CharSet_JIS_Roman_Kanji,
    DVD_CharSet_ISO8859_1,
    DVD_CharSet_ShiftJIS_Kanji_Roman_Katakana
  );
  {$EXTERNALSYM DVD_TextCharSet}
  TDVDTextCharSet = DVD_TextCharSet;

const
  DVD_TITLE_MENU           = $000;
  {$EXTERNALSYM DVD_TITLE_MENU}
  DVD_STREAM_DATA_CURRENT  = $800;
  {$EXTERNALSYM DVD_STREAM_DATA_CURRENT}
  DVD_STREAM_DATA_VMGM     = $400;
  {$EXTERNALSYM DVD_STREAM_DATA_VMGM}
  DVD_STREAM_DATA_VTSM     = $401;
  {$EXTERNALSYM DVD_STREAM_DATA_VTSM}
  DVD_DEFAULT_AUDIO_STREAM = $0f ;
  {$EXTERNALSYM DVD_DEFAULT_AUDIO_STREAM}

type
  tagDVD_DECODER_CAPS = record
    dwSize           : DWORD;
    dwAudioCaps      : DWORD;
    dFwdMaxRateVideo : double;
    dFwdMaxRateAudio : double;
    dFwdMaxRateSP    : double;
    dBwdMaxRateVideo : double;
    dBwdMaxRateAudio : double;
    dBwdMaxRateSP    : double;
    dwRes1           : DWORD;
    dwRes2           : DWORD;
    dwRes3           : DWORD;
    dwRes4           : DWORD;
  end;
  {$EXTERNALSYM tagDVD_DECODER_CAPS}
  DVD_DECODER_CAPS = tagDVD_DECODER_CAPS;
  {$EXTERNALSYM DVD_DECODER_CAPS}
  TDVDDecoderCaps = tagDVD_DECODER_CAPS;

const
  DVD_AUDIO_CAPS_AC3   = $00000001;
  {$EXTERNALSYM DVD_AUDIO_CAPS_AC3}
  DVD_AUDIO_CAPS_MPEG2 = $00000002;
  {$EXTERNALSYM DVD_AUDIO_CAPS_MPEG2}
  DVD_AUDIO_CAPS_LPCM  = $00000004;
  {$EXTERNALSYM DVD_AUDIO_CAPS_LPCM}
  DVD_AUDIO_CAPS_DTS   = $00000008;
  {$EXTERNALSYM DVD_AUDIO_CAPS_DTS}
  DVD_AUDIO_CAPS_SDDS  = $00000010;
  {$EXTERNALSYM DVD_AUDIO_CAPS_SDDS}

type
  tagDVD_VideoAttributes = record
    fPanscanPermitted    : BOOL;
    fLetterboxPermitted  : BOOL;
    ulAspectX            : ULONG;
    ulAspectY            : ULONG;
    ulFrameRate          : ULONG;
    ulFrameHeight        : ULONG;
    Compression          : DVD_VIDEO_COMPRESSION;
    fLine21Field1InGOP   : BOOL;
    fLine21Field2InGOP   : BOOL;
    ulSourceResolutionX  : ULONG;
    ulSourceResolutionY  : ULONG;
    fIsSourceLetterboxed : BOOL;
    fIsFilmMode          : BOOL;
  end;
  {$EXTERNALSYM tagDVD_VideoAttributes}
  DVD_VideoAttributes = tagDVD_VideoAttributes;
  {$EXTERNALSYM DVD_VideoAttributes}
  TDVDVideoAttributes = tagDVD_VideoAttributes;

  tagDVD_SubpictureAttributes = record
    Type_             : DVD_SUBPICTURE_TYPE ;
    CodingMode        : DVD_SUBPICTURE_CODING ;
    Language          : LCID ;
    LanguageExtension : DVD_SUBPICTURE_LANG_EXT ;
  end;
  {$EXTERNALSYM tagDVD_SubpictureAttributes}
  DVD_SubpictureAttributes = tagDVD_SubpictureAttributes;
  {$EXTERNALSYM DVD_SubpictureAttributes}
  TDVDSubpictureAttributes = tagDVD_SubpictureAttributes;

  tagDVD_TITLE_APPMODE = (
  {$IFNDEF COMPILER6_UP}
    DVD_AppMode_Not_Specified,
    DVD_AppMode_Karaoke,
    DVD_AppMode_INVALID_2,
    DVD_AppMode_Other
  {$ELSE}
    DVD_AppMode_Not_Specified = 0,
    DVD_AppMode_Karaoke       = 1,
    DVD_AppMode_Other         = 3
  {$ENDIF}
  );
  {$EXTERNALSYM tagDVD_TITLE_APPMODE}
  DVD_TITLE_APPMODE = tagDVD_TITLE_APPMODE;
  {$EXTERNALSYM DVD_TITLE_APPMODE}
  TDVDTitleAPPMode = DVD_TITLE_APPMODE;

  tagDVD_MUA_MixingInfo = record
    fMixTo0           : BOOL;
    fMixTo1           : BOOL;
    fMix0InPhase      : BOOL;
    fMix1InPhase      : BOOL;
    dwSpeakerPosition : DWORD;
  end;
  {$EXTERNALSYM tagDVD_MUA_MixingInfo}
  DVD_MUA_MixingInfo = tagDVD_MUA_MixingInfo;
  {$EXTERNALSYM DVD_MUA_MixingInfo}
  TDVDMUAMixingInfo = tagDVD_MUA_MixingInfo;

  tagDVD_MUA_Coeff = record
    log2_alpha : Double;
    log2_beta  : Double;
  end;
  {$EXTERNALSYM tagDVD_MUA_Coeff}
  DVD_MUA_Coeff = tagDVD_MUA_Coeff;
  {$EXTERNALSYM DVD_MUA_Coeff}
  TDVDMUACoeff = tagDVD_MUA_Coeff;

  tagDVD_MultichannelAudioAttributes = record
    Info  : array[0..7] of DVD_MUA_MixingInfo;
    Coeff : array[0..7] of DVD_MUA_Coeff;
  end;
  {$EXTERNALSYM tagDVD_MultichannelAudioAttributes}
  DVD_MultichannelAudioAttributes = tagDVD_MultichannelAudioAttributes;
  {$EXTERNALSYM DVD_MultichannelAudioAttributes}
  TDVDMultichannelAudioAttributes = tagDVD_MultichannelAudioAttributes;

// DVD_KARAOKE_CONTENTS
const
 	DVD_Karaoke_GuideVocal1	  = $1;
  {$EXTERNALSYM DVD_Karaoke_GuideVocal1}
	DVD_Karaoke_GuideVocal2	  = $2;
  {$EXTERNALSYM DVD_Karaoke_GuideVocal2}
	DVD_Karaoke_GuideMelody1	= $4;
  {$EXTERNALSYM DVD_Karaoke_GuideMelody1}
	DVD_Karaoke_GuideMelody2	= $8;
  {$EXTERNALSYM DVD_Karaoke_GuideMelody2}
	DVD_Karaoke_GuideMelodyA	= $10;
  {$EXTERNALSYM DVD_Karaoke_GuideMelodyA}
	DVD_Karaoke_GuideMelodyB	= $20;
  {$EXTERNALSYM DVD_Karaoke_GuideMelodyB}
	DVD_Karaoke_SoundEffectA	= $40;
  {$EXTERNALSYM DVD_Karaoke_SoundEffectA}
	DVD_Karaoke_SoundEffectB	= $80;
  {$EXTERNALSYM DVD_Karaoke_SoundEffectB}

type

  tagDVD_AudioAttributes = record
    AppMode              : DVD_AUDIO_APPMODE;
    AppModeData          : BYTE;
    AudioFormat          : DVD_AUDIO_FORMAT;
    Language             : LCID;
    LanguageExtension    : DVD_AUDIO_LANG_EXT;
    fHasMultichannelInfo : BOOL;
    dwFrequency          : DWORD;
    bQuantization        : BYTE;
    bNumberOfChannels    : BYTE;
    dwReserved           : array[0..1] of DWORD;
  end;
  {$EXTERNALSYM tagDVD_AudioAttributes}
  DVD_AudioAttributes = tagDVD_AudioAttributes;
  {$EXTERNALSYM DVD_AudioAttributes}
  TDVDAudioAttributes = tagDVD_AudioAttributes;

  tagDVD_TitleMainAttributes = record
    AppMode: DVD_TITLE_APPMODE ;
    VideoAttributes             : DVD_VideoAttributes;
    ulNumberOfAudioStreams      : ULONG ;
    AudioAttributes             : array[0..7] of DVD_AudioAttributes;
    MultichannelAudioAttributes : array[0..7] of DVD_MultichannelAudioAttributes;
    ulNumberOfSubpictureStreams : ULONG ;
    SubpictureAttributes        : array[0..31] of DVD_SubpictureAttributes;
  end;
  {$EXTERNALSYM tagDVD_TitleMainAttributes}
  DVD_TitleAttributes = tagDVD_TitleMainAttributes;
  {$EXTERNALSYM DVD_TitleAttributes}
  TDVDTitleAttributes = tagDVD_TitleMainAttributes;

  tagDVD_MenuAttributes = record
    fCompatibleRegion    : array[0..7] of BOOL;
    VideoAttributes      : DVD_VideoAttributes;
    fAudioPresent        : BOOL;
    AudioAttributes      : DVD_AudioAttributes;
    fSubpicturePresent   : BOOL;
    SubpictureAttributes : DVD_SubpictureAttributes;
  end;
  {$EXTERNALSYM tagDVD_MenuAttributes}
  DVD_MenuAttributes = tagDVD_MenuAttributes;
  {$EXTERNALSYM DVD_MenuAttributes}
  TDVDMenuAttributes = tagDVD_MenuAttributes;

  tagDVD_KaraokeAttributes = record
    bVersion                         : BYTE;
    fMasterOfCeremoniesInGuideVocal1 : BOOL;
    fDuet                            : BOOL;
    ChannelAssignment                : TDVDKaraokeAssignment;
    wChannelContents                 : array[0..7] of WORD;
  end;
  {$EXTERNALSYM tagDVD_KaraokeAttributes}
  DVD_KaraokeAttributes = tagDVD_KaraokeAttributes;
  {$EXTERNALSYM DVD_KaraokeAttributes}
  TDVDKaraokeAttributes = tagDVD_KaraokeAttributes;


const
  DVD_PARENTAL_LEVEL_8    = $8000;
  {$EXTERNALSYM DVD_PARENTAL_LEVEL_8}
  DVD_PARENTAL_LEVEL_7    = $4000;
  {$EXTERNALSYM DVD_PARENTAL_LEVEL_7}
  DVD_PARENTAL_LEVEL_6    = $2000;
  {$EXTERNALSYM DVD_PARENTAL_LEVEL_6}
  DVD_PARENTAL_LEVEL_5    = $1000;
  {$EXTERNALSYM DVD_PARENTAL_LEVEL_5}
  DVD_PARENTAL_LEVEL_4    = $0800;
  {$EXTERNALSYM DVD_PARENTAL_LEVEL_4}
  DVD_PARENTAL_LEVEL_3    = $0400;
  {$EXTERNALSYM DVD_PARENTAL_LEVEL_3}
  DVD_PARENTAL_LEVEL_2    = $0200;
  {$EXTERNALSYM DVD_PARENTAL_LEVEL_2}
  DVD_PARENTAL_LEVEL_1    = $0100;
  {$EXTERNALSYM DVD_PARENTAL_LEVEL_1}

type
  DVD_CMD_FLAGS = {$IFDEF TYPE_IDENTITY}type {$ENDIF} DWORD;
  {$EXTERNALSYM DVD_CMD_FLAGS}

const
  DVD_CMD_FLAG_None               = $00000000;
  {$EXTERNALSYM DVD_CMD_FLAG_None}
  DVD_CMD_FLAG_Flush              = $00000001;
  {$EXTERNALSYM DVD_CMD_FLAG_Flush}
  DVD_CMD_FLAG_SendEvents         = $00000002;
  {$EXTERNALSYM DVD_CMD_FLAG_SendEvents}
  DVD_CMD_FLAG_Block              = $00000004;
  {$EXTERNALSYM DVD_CMD_FLAG_Block}
  DVD_CMD_FLAG_StartWhenRendered  = $00000008;
  {$EXTERNALSYM DVD_CMD_FLAG_StartWhenRendered}
  DVD_CMD_FLAG_EndAfterRendered   = $00000010;
  {$EXTERNALSYM DVD_CMD_FLAG_EndAfterRendered}

type
  CountryCode = array[0..1] of BYTE;

  {$HPPEMIT 'typedef System::DelphiInterface<IDvdState> _di_IDvdState;'}
  {$EXTERNALSYM IDvdState}
  IDvdState = interface(IUnknown)
      ['{86303d6d-1c4a-4087-ab42-f711167048ef}']
      (*** IDvdState methods ***)
      function GetDiscID(out pullUniqueID: Double): HResult; stdcall;
      function GetParentalLevel(out pulParentalLevel: ULONG): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDvdCmd> _di_IDvdCmd;'}
  {$EXTERNALSYM IDvdCmd}
  IDvdCmd = interface(IUnknown)
      ['{5A4A97E4-94EE-4A55-9751-74B5643AA27D}']
      (*** IDvdCmd methods ***)
      function WaitForStart: HResult; stdcall;
      function WaitForEnd: HResult; stdcall;
  end;

  //Deprecated Interface
  {$HPPEMIT 'typedef System::DelphiInterface<IDvdControl> _di_IDvdControl;'}
  {$EXTERNALSYM IDvdControl}
  IDvdControl = interface(IUnknown)
    ['{A70EFE61-E2A3-11D0-A9BE-00AA0061BE93}']
    (*** IDvdControl methods ***)
    function TitlePlay(uiTitle: ULONG): HResult; stdcall;
    function ChapterPlay(uiTitle: ULONG; uiChapter: ULONG): HResult; stdcall;
    function TimePlay(uiTitle: ULONG; bcdTime: ULONG): HResult; stdcall;
    function StopForResume: HResult; stdcall;
    function GoUp: HResult; stdcall;
    function TimeSearch(bcdTime: ULONG): HResult; stdcall;
    function ChapterSearch(Chapter: ULONG): HResult; stdcall;
    function PrevPGSearch: HResult; stdcall;
    function TopPGSearch: HResult; stdcall;
    function NextPGSearch: HResult; stdcall;
    function ForwardScan(dwSpeed: double): HResult; stdcall;
    function BackwardScan(dwSpeed: double): HResult; stdcall;
    function MenuCall(MenuID: TDVDMenuID): HResult; stdcall;
    function Resume: HResult; stdcall;
    function UpperButtonSelect: HResult; stdcall;
    function LowerButtonSelect: HResult; stdcall;
    function LeftButtonSelect: HResult; stdcall;
    function RightButtonSelect: HResult; stdcall;
    function ButtonActivate: HResult; stdcall;
    function ButtonSelectAndActivate(uiButton: ULONG): HResult; stdcall;
    function StillOff: HResult; stdcall;
    function PauseOn: HResult; stdcall;
    function PauseOff: HResult; stdcall;
    function MenuLanguageSelect(Language: LCID): HResult; stdcall;
    function AudioStreamChange(nAudio: ULONG): HResult; stdcall;
    function SubpictureStreamChange(nSubPicture: ULONG; bDisplay: BOOL): HResult; stdcall;
    function AngleChange(ulAngle: ULONG): HResult; stdcall;
    function ParentalLevelSelect(ulParentalLevel: ULONG): HResult; stdcall;
    function ParentalCountrySelect(wCountry: Word): HResult; stdcall;
    function KaraokeAudioPresentationModeChange(ulMode: ULONG): HResult; stdcall;
    function VideoModePreferrence(ulPreferredDisplayMode: ULONG): HResult; stdcall;
    function SetRoot(pszPath: LPCWSTR): HResult; stdcall;
    function MouseActivate(point: TPoint): HResult; stdcall;
    function MouseSelect(point: TPoint): HResult; stdcall;
    function ChapterPlayAutoStop(ulTitle, ulChapter, ulChaptersToPlay: ULONG): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDvdControl2> _di_IDvdControl2;'}
  {$EXTERNALSYM IDvdControl2}
  IDvdControl2 = interface(IUnknown)
    ['{33BC7430-EEC0-11D2-8201-00A0C9D74842}']
    (*** IDvdControl2 methods ***)
    function PlayTitle(ulTitle, dwFlags: ULONG; var ppCmd: IDvdCmd): HResult; stdcall;
    function PlayChapterInTitle(ulTitle, ulChapter: ULONG; dwFlags: DWORD; var ppCmd: IDvdCmd): HResult; stdcall;
    function PlayAtTimeInTitle(ulTitle: ULONG; var pStartTime: TDVDHMSFTimeCode; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function Stop: HResult; stdcall;
    function ReturnFromSubmenu(dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayAtTime(pTime: PDVDHMSFTimeCode; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayChapter(ulChapter: ULONG; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayPrevChapter(dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function ReplayChapter(dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayNextChapter(dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayForwards(dSpeed: double; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayBackwards(dSpeed: double; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function ShowMenu(MenuID: TDVDMenuID; dwFlags: DVD_CMD_FLAGS;out ppCmd: IDvdCmd): HResult; stdcall;
    function Resume(dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SelectRelativeButton(buttonDir: TDVDRelativeButton): HResult; stdcall;
    function ActivateButton: HResult; stdcall;
    function SelectButton(ulButton: ULONG): HResult; stdcall;
    function SelectAndActivateButton(ulButton: ULONG): HResult; stdcall;
    function StillOff: HResult; stdcall;
    function Pause(bState: BOOL): HResult; stdcall;
    function SelectAudioStream(ulAudio: ULONG; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SelectSubpictureStream(ulSubPicture: ULONG; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SetSubpictureState(bState: BOOL; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SelectAngle(ulAngle: ULONG; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SelectParentalLevel(ulParentalLevel: ULONG): HResult; stdcall;
    function SelectParentalCountry(bCountry: CountryCode): HResult; stdcall;
    function SelectKaraokeAudioPresentationMode(ulMode: ULONG): HResult; stdcall;
    function SelectVideoModePreference(ulPreferredDisplayMode: ULONG): HResult; stdcall;
    function SetDVDDirectory(pszwPath: LPCWSTR): HResult; stdcall;
    function ActivateAtPosition(point: TPoint): HResult; stdcall;
    function SelectAtPosition(point : TPoint): HResult; stdcall;
    function PlayChaptersAutoStop(ulTitle, ulChapter, ulChaptersToPlay: ULONG; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function AcceptParentalLevelChange(bAccept: BOOL): HResult; stdcall;
    function SetOption(flag: TDVDOptionFlag; fState: BOOL): HResult; stdcall;
    function SetState(pState: IDvdState; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayPeriodInTitleAutoStop(ulTitle: ULONG; var pStartTime, pEndTime: TDVDHMSFTimeCode; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SetGPRM(ulIndex: ULONG; wValue: WORD; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SelectDefaultMenuLanguage(Language: LCID): HResult; stdcall;
    function SelectDefaultAudioLanguage(Language: LCID; audioExtension: TDVDAudioLangExt): HResult; stdcall;
    function SelectDefaultSubpictureLanguage(Language: LCID; subpictureExtension: TDVDSubpictureLangExt): HResult; stdcall;
  end;

  //Deprecated Interface
  {$HPPEMIT 'typedef System::DelphiInterface<IDvdInfo> _di_IDvdInfo;'}
  {$EXTERNALSYM IDvdInfo}
  IDvdInfo = interface(IUnknown)
    ['{A70EFE60-E2A3-11D0-A9BE-00AA0061BE93}']
    (*** IDvdInfo methods ***)
    function GetCurrentDomain(out pDomain: TDVDDomain): HResult; stdcall;
    function GetCurrentLocation(out pLocation: TDVDPlaybackLocation): HResult; stdcall;
    function GetTotalTitleTime(out pTotalTime: ULONG): HResult; stdcall;
    function GetCurrentButton(out pnButtonsAvailable, pnCurrentButton: ULONG): HResult; stdcall;
    function GetCurrentAngle(out pnAnglesAvailable, pnCurrentAngle: ULONG): HResult; stdcall;
    function GetCurrentAudio(out pnStreamsAvailable, pnCurrentStream: ULONG): HResult; stdcall;
    function GetCurrentSubpicture(out pnStreamsAvailable, pnCurrentStream: ULONG;
             out pIsDisabled: BOOL): HResult; stdcall;
    function GetCurrentUOPS(out pUOP: VALID_UOP_SOMTHING_OR_OTHER): HResult; stdcall;
    function GetAllSPRMs(var pRegisterArray: TSPRMArray): HResult; stdcall;
    function GetAllGPRMs(var pRegisterArray: GPRMArray): HResult; stdcall;
    function GetAudioLanguage(nStream: ULONG; out pLanguage: LCID): HResult; stdcall;
    function GetSubpictureLanguage(nStream: ULONG; out pLanguage: LCID): HResult; stdcall;
    function GetTitleAttributes(nTitle: ULONG; out pATR: TDVDAtr): HResult; stdcall;
    function GetVMGAttributes(out pATR: TDVDAtr): HResult; stdcall;
    function GetCurrentVideoAttributes(out pATR: DVD_VideoATR): HResult; stdcall;
    function GetCurrentAudioAttributes(out pATR: DVD_AudioATR): HResult; stdcall;
    function GetCurrentSubpictureAttributes(out pATR: DVD_SubpictureATR): HResult; stdcall;
    function GetCurrentVolumeInfo(out pNumOfVol, pThisVolNum: ULONG;
        out pSide: TDVDDiscSide; out pNumOfTitles: ULONG): HResult; stdcall;
    function GetDVDTextInfo(out pTextManager: Byte; cbBufSize: ULONG;
             out pcbActualSize: ULONG): HResult; stdcall;
    function GetPlayerParentalLevel(out pParentalLevel, pCountryCode: ULONG): HResult; stdcall;
    function GetNumberOfChapters(ulTitle: ULONG; out pNumberOfChapters: ULONG): HResult; stdcall;
    function GetTitleParentalLevels(ulTitle: ULONG; out pParentalLevels: ULONG): HResult; stdcall;
    function GetRoot(pRoot: PChar; cbBufSize: ULONG; out pcbActualSize: ULONG): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDvdInfo2> _di_IDvdInfo2;'}
  {$EXTERNALSYM IDvdInfo2}
  IDvdInfo2 = interface(IUnknown)
    ['{34151510-EEC0-11D2-8201-00A0C9D74842}']
    (*** IDvdInfo2 methods ***)
    function GetCurrentDomain(out pDomain: TDVDDomain): HResult; stdcall;
    function GetCurrentLocation(out pLocation: TDVDPlaybackLocation2): HResult; stdcall;
    function GetTotalTitleTime(out pTotalTime: TDVDHMSFTimeCode; out ulTimeCodeFlags: ULONG): HResult; stdcall;
    function GetCurrentButton(out pulButtonsAvailable, pulCurrentButton: ULONG): HResult; stdcall;
    function GetCurrentAngle(out pulAnglesAvailable, pulCurrentAngle: ULONG): HResult; stdcall;
    function GetCurrentAudio(out pulStreamsAvailable, pulCurrentStream: ULONG): HResult; stdcall;
    function GetCurrentSubpicture(out pulStreamsAvailable, pulCurrentStream: ULONG; out pbIsDisabled: BOOL): HResult; stdcall;
    function GetCurrentUOPS(out pulUOPs: ULONG): HResult; stdcall;
    function GetAllSPRMs(out pRegisterArray: TSPRMArray): HResult; stdcall;
    function GetAllGPRMs(out pRegisterArray: GPRMArray): HResult; stdcall;
    function GetAudioLanguage(ulStream: ULONG; out pLanguage: LCID): HResult; stdcall;
    function GetSubpictureLanguage(ulStream: ULONG; out pLanguage: LCID): HResult; stdcall;
    function GetTitleAttributes(ulTitle: ULONG; out pMenu: TDVDMenuAttributes; out pTitle: TDVDTitleAttributes): HResult; stdcall;
    function GetVMGAttributes(out pATR: TDVDMenuAttributes): HResult; stdcall;
    function GetCurrentVideoAttributes(out pATR: TDVDVideoAttributes): HResult; stdcall;
    function GetAudioAttributes(ulStream: ULONG; out pATR: TDVDAudioAttributes): HResult; stdcall;
    function GetKaraokeAttributes(ulStream: ULONG; out pAttributes: TDVDKaraokeAttributes): HResult; stdcall;
    function GetSubpictureAttributes(ulStream :ULONG; out pATR: TDVDSubpictureAttributes): HResult; stdcall;
    function GetDVDVolumeInfo(out pulNumOfVolumes, pulVolume: ULONG; out pSide: TDVDDiscSide; out pulNumOfTitles: ULONG): HResult; stdcall;
    function GetDVDTextNumberOfLanguages(out pulNumOfLangs: ULONG): HResult; stdcall;
    function GetDVDTextLanguageInfo(ulLangIndex: ULONG; out pulNumOfStrings: ULONG; out pLangCode: LCID; out pbCharacterSet: TDVDTextCharSet): HResult; stdcall;
    function GetDVDTextStringAsNative(ulLangIndex, ulStringIndex: ULONG; out pbBuffer; ulMaxBufferSize: ULONG; out pulActualSize: ULONG; out pType: TDVDTextStringType): HResult; stdcall;
    function GetDVDTextStringAsUnicode(ulLangIndex, ulStringIndex: ULONG; out pchwBuffer; ulMaxBufferSize: ULONG; out pulActualSize: ULONG; out pType: TDVDTextStringType): HResult; stdcall;
    function GetPlayerParentalLevel(out pulParentalLevel: ULONG; out pbCountryCode: CountryCode): HResult; stdcall;
    function GetNumberOfChapters(ulTitle: ULONG; out pulNumOfChapters: ULONG): HResult; stdcall;
    function GetTitleParentalLevels(ulTitle: ULONG; out pulParentalLevels: ULONG): HResult; stdcall;
    function GetDVDDirectory(out pszwPath; ulMaxSize: ULONG; out pulActualSize: ULONG): HResult; stdcall;
    function IsAudioStreamEnabled(ulStreamNum: ULONG; out pbEnabled: BOOL): HResult; stdcall;
    function GetDiscID(pszwPath: LPCWSTR; out pullDiscID: Int64): HResult; stdcall;
    function GetState(out pStateData: IDvdState): HResult; stdcall;
    function GetMenuLanguages(out pLanguages: LCID; ulMaxLanguages: ULONG; out pulActualLanguages: ULONG): HResult; stdcall;
    function GetButtonAtPosition(point: Tpoint;out pulButtonIndex: ULONG): HResult; stdcall;
    function GetCmdFromEvent(lParam1: integer; out pCmdObj: IDvdCmd): HResult; stdcall;
    function GetDefaultMenuLanguage(out pLanguage: LCID): HResult; stdcall;
    function GetDefaultAudioLanguage(out pLanguage: LCID; out pAudioExtension: TDVDAudioLangExt): HResult; stdcall;
    function GetDefaultSubpictureLanguage(out pLanguage: LCID; out pSubpictureExtension: TDVDSubpictureLangExt): HResult; stdcall;
    function GetDecoderCaps(out pCaps: TDVDDecoderCaps): HResult; stdcall;
    function GetButtonRect(ulButton: ULONG; out pRect: TRect): HResult; stdcall;
    function IsSubpictureStreamEnabled(ulStreamNum: ULONG; out pbEnabled: BOOL): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IVideoFrameStep> _di_IVideoFrameStep;'}
  {$EXTERNALSYM IVideoFrameStep}
  IVideoFrameStep = interface(IUnknown)
    ['{e46a9787-2b71-444d-a4b5-1fab7b708d6a}']
    (*** IVideoFrameStep methods ***)
    function Step(dwFrames: DWORD; pStepObject: IUnKnown): HResult; stdcall;
    function CanStep(bMultiple: longint; pStepObject: IUnknown): HResult; stdcall;
    function CancelStep: HResult; stdcall;
  end;



const
  AM_DVD_HWDEC_PREFER = $01;   // default
  {$EXTERNALSYM AM_DVD_HWDEC_PREFER}
  AM_DVD_HWDEC_ONLY   = $02;
  {$EXTERNALSYM AM_DVD_HWDEC_ONLY}
  AM_DVD_SWDEC_PREFER = $04;
  {$EXTERNALSYM AM_DVD_SWDEC_PREFER}
  AM_DVD_SWDEC_ONLY   = $08;
  {$EXTERNALSYM AM_DVD_SWDEC_ONLY}
  AM_DVD_NOVPE        = $100;
  {$EXTERNALSYM AM_DVD_NOVPE}
  // DirectX9 Specific
  AM_DVD_VMR9_ONLY    = $800;    // only use VMR9 (otherwise fail) for rendering
  {$EXTERNALSYM AM_DVD_VMR9_ONLY}

  AM_DVD_STREAM_VIDEO    = $1;
  {$EXTERNALSYM AM_DVD_STREAM_VIDEO}
  AM_DVD_STREAM_AUDIO    = $2;
  {$EXTERNALSYM AM_DVD_STREAM_AUDIO}
  AM_DVD_STREAM_SUBPIC   = $4;
  {$EXTERNALSYM AM_DVD_STREAM_SUBPIC}

type
  AM_DVD_RENDERSTATUS = record
    hrVPEStatus: HResult;
    bDvdVolInvalid: BOOL;
    bDvdVolUnknown: BOOL;
    bNoLine21In: BOOL;
    bNoLine21Out: BOOL;
    iNumStreams: Integer;
    iNumStreamsFailed: Integer;
    dwFailedStreamsFlag: DWORD;
  end;
  {$EXTERNALSYM AM_DVD_RENDERSTATUS}
  TAMDVDRenderStatus = AM_DVD_RENDERSTATUS;

  {$HPPEMIT 'typedef System::DelphiInterface<IDvdGraphBuilder> _di_IDvdGraphBuilder;'}
  {$EXTERNALSYM IDvdGraphBuilder}
  IDvdGraphBuilder = interface(IUnknown)
    ['{FCC152B6-F372-11d0-8E00-00C04FD7C08B}']
    (*** IDvdGraphBuilder methods ***)
    function GetFiltergraph(out ppGB: IGraphBuilder): HResult; stdcall;
    function GetDvdInterface(const riid: TGUID; out ppvIF): HResult; stdcall;
    function RenderDvdVideoVolume(lpcwszPathName: PWideChar; dwFlags: DWORD;
             out pStatus: TAMDVDRenderStatus): HResult; stdcall;
  end;

//_AM_OVERLAY_NOTIFY_FLAGS
const
  AM_OVERLAY_NOTIFY_VISIBLE_CHANGE = $1;
  {$EXTERNALSYM AM_OVERLAY_NOTIFY_VISIBLE_CHANGE}
	AM_OVERLAY_NOTIFY_SOURCE_CHANGE	 = $2;
  {$EXTERNALSYM AM_OVERLAY_NOTIFY_SOURCE_CHANGE}
	AM_OVERLAY_NOTIFY_DEST_CHANGE	   = $4;
  {$EXTERNALSYM AM_OVERLAY_NOTIFY_DEST_CHANGE}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IDDrawExclModeVideoCallback> _di_IDDrawExclModeVideoCallback;'}
  {$EXTERNALSYM IDDrawExclModeVideoCallback}
  IDDrawExclModeVideoCallback = interface(IUnknown)
    ['{913c24a0-20ab-11d2-9038-00a0c9697298}']
    (*** IDDrawExclModeVideoCallback methods ***)
    function OnUpdateOverlay(bBefore: BOOL; dwFlags: DWORD; bOldVisible: BOOL;
             var prcOldSrc, prcOldDest: TRECT; bNewVisible: BOOL; var prcNewSrc, prcNewDest: TRECT): HResult; stdcall;
    function OnUpdateColorKey(var pKey: TCOLORKEY; dwColor: DWORD): HResult; stdcall;
    function OnUpdateSize(dwWidth, dwHeight, dwARWidth, dwARHeight: DWORD): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDDrawExclModeVideo> _di_IDDrawExclModeVideo;'}
  {$EXTERNALSYM IDDrawExclModeVideo}
  IDDrawExclModeVideo = interface(IUnknown)
    ['{153ACC21-D83B-11d1-82BF-00A0C9696C8F}']
    (*** IDDrawExclModeVideo methods ***)
    function SetDDrawObject(pDDrawObject: IDirectDraw): HResult; stdcall;
    function GetDDrawObject(out ppDDrawObject: IDirectDraw; out pbUsingExternal: BOOL): HResult; stdcall;
    function SetDDrawSurface(pDDrawSurface: IDirectDrawSurface): HResult; stdcall;
    function GetDDrawSurface(out ppDDrawSurface: IDirectDrawSurface; out pbUsingExternal: BOOL): HResult; stdcall;
    function SetDrawParameters(prcSource, prcTarget: PRECT): HResult; stdcall;
    function GetNativeVideoProps(out pdwVideoWidth, pdwVideoHeight, pdwPictAspectRatioX,pdwPictAspectRatioY: DWORD): HResult; stdcall;
    function SetCallbackInterface(pCallback: IDDrawExclModeVideoCallback; dwFlags: DWORD): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IPinConnection> _di_IPinConnection;'}
  {$EXTERNALSYM IPinConnection}
  IPinConnection = interface(IUnknown)
    ['{4a9a62d3-27d4-403d-91e9-89f540e55534}']
    (*** IPinConnection methods ***)
    function DynamicQueryAccept(var pmt: TAMMediaType): HResult; stdcall;
    function NotifyEndOfStream(hNotifyEvent: THandle): HResult; stdcall;
    function IsEndPin: HResult; stdcall;
    function DynamicDisconnect: HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IPinFlowControl> _di_IPinFlowControl;'}
  {$EXTERNALSYM IPinFlowControl}
  IPinFlowControl = interface(IUnknown)
    ['{c56e9858-dbf3-4f6b-8119-384af2060deb}']
    (*** IPinFlowControl methods ***)
    function Block(dwBlockFlags: DWORD; hEvent: THandle): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IGraphConfigCallback> _di_IGraphConfigCallback;'}
  {$EXTERNALSYM IGraphConfigCallback}
  IGraphConfigCallback = interface(IUnknown)
    ['{ade0fd60-d19d-11d2-abf6-00a0c905f375}']
    (*** IGraphConfigCallback methods ***)
    function Reconfigure(var pvContext; dwFlags: DWORD): HResult; stdcall;
  end;

const
  //_AM_PIN_FLOW_CONTROL_BLOCK_FLAGS
  AM_PIN_FLOW_CONTROL_BLOCK	= $1;
  {$EXTERNALSYM AM_PIN_FLOW_CONTROL_BLOCK}

  //_AM_GRAPH_CONFIG_RECONNECT_FLAGS
  AM_GRAPH_CONFIG_RECONNECT_DIRECTCONNECT	          = $1;
  {$EXTERNALSYM AM_GRAPH_CONFIG_RECONNECT_DIRECTCONNECT}
	AM_GRAPH_CONFIG_RECONNECT_CACHE_REMOVED_FILTERS	  = $2;
  {$EXTERNALSYM AM_GRAPH_CONFIG_RECONNECT_CACHE_REMOVED_FILTERS}
	AM_GRAPH_CONFIG_RECONNECT_USE_ONLY_CACHED_FILTERS = $4;
  {$EXTERNALSYM AM_GRAPH_CONFIG_RECONNECT_USE_ONLY_CACHED_FILTERS}

  //_AM_FILTER_FLAGS
  AM_FILTER_FLAGS_REMOVABLE	= $1;
  {$EXTERNALSYM AM_FILTER_FLAGS_REMOVABLE}

  //_REM_FILTER_FLAGS
  REMFILTERF_LEAVECONNECTED	= $1;
  {$EXTERNALSYM REMFILTERF_LEAVECONNECTED}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IGraphConfig> _di_IGraphConfig;'}
  {$EXTERNALSYM IGraphConfig}
  IGraphConfig = interface(IUnknown)
    ['{03A1EB8E-32BF-4245-8502-114D08A9CB88}']
    (*** IGraphConfig methods ***)
    function Reconnect(pOutputPin, pInputPin: IPin; pmtFirstConnection: PAMMediaType;
             pUsingFilter: IBaseFilter; hAbortEvent: THandle; dwFlags: DWORD): HResult; stdcall;
    function Reconfigure(pCallback: IGraphConfigCallback; var pvContext;
             dwFlags: DWORD; hAbortEvent: THandle): HResult; stdcall;
    function AddFilterToCache(pFilter: IBaseFilter): HResult; stdcall;
    function EnumCacheFilter(out pEnum: IEnumFilters): HResult; stdcall;
    function RemoveFilterFromCache(pFilter: IBaseFilter): HResult; stdcall;
    function GetStartTime(out prtStart: TReferenceTime): HResult; stdcall;
    function PushThroughData(pOutputPin: IPin; pConnection: IPinConnection; hEventAbort: PHANDLE): HResult; stdcall;
    function SetFilterFlags(pFilter: IBaseFilter; dwFlags: DWORD): HResult; stdcall;
    function GetFilterFlags(pFilter: IBaseFilter; out pdwFlags: DWORD): HResult; stdcall;
    function RemoveFilterEx(pFilter: IBaseFilter; Flags: DWORD): HResult; stdcall;
  end;

// Filter Chain Definition
// 
//  Filter chains have the following properties:
// 
// - Each filter chain has one or more filters.
// 
// - Each filter in a filter chain has at most one connected input pin and one 
//   connected output pin.  For example, filters A, C, D, F, G, H, I, J and K
//   (see the diagram below) can be in a filter chain because each one has at 
//   most one connected input pin and one connected output pin.
// 
// - Any filter in a chain is reachable by any other filter in the chain.  
//   For example, in the filter chain F-G-H, F can reach H by following the F-
//   G connection to G and then following the G-H connection to H.  Filters F 
//   and J cannot be in the same filter chain because J is not reachable from 
//   F.  Anotherwords, there no sequence of connected filters between F and J.
//
// - The start filter is the only filter in the filter chain who's input 
//   pin is not connected to another filter in the chain.  For instance, F is 
//   the start filter in F-G-H because F's input pin is connected to E and E 
//   is not in the filter chain.  G's input pin is connected to F and H's is 
//   connected to G.  Both F and G are in the filter chain.
//
// - The end filter is the only filter in the filter chain who's output pin 
//   is not connected to another filter in the chain.  For example, in the 
//   filter chain J-K, K is the end filter because K's output pin is 
//   connected to L.  J's output pin is connected to K and K is in the J-K 
//   filter chain.
//
//
//            --->|---|    |---|--->                   
//                | C |--->| D |
// |---|    |---|--->|---|    |---|--->|---|    |---|    |---|    |---|
// | A |--->| B |                      | E |--->| F |--->| G |--->| H |
// |---|    |---|--->|---|------------>|---|    |---|    |---|    |---|
//                   | I |--->
//               --->|---|--->
// 
// |---|    |---|    |---|
// | J |--->| K |--->| L |
// |---|    |---|    |---|
// 
//              Example Filter Graph
// 
// 
// 
// IFilterChain Methods Documentation
// 
// HResult StartChain( [in] IBaseFilter *pStartFilter, [in] IBaseFilter *pEndFilter );
// 
//      StartChain() switches all the filters in the chain into the running state
// If one of the filters will not switch to the running state, then all the filters 
// in the chain are stopped.  This method can only be called if the filter graph is 
// running.
// 
// Parameters:
// - pStartFilter [in]
//      The first filter in the filter chain.  Note that this can be the same 
// filter as pEndFilter .
// 
// - pEndFilter [in]
//      The last filter in the filter chain.  Note that this can be the same 
// filter as pStartFilter.  If pEndFilter is NULL then the filter chain extends
// from pStartFilter to the last downstream filter which can be in a filter chain.
// For example, IFilterChain::StartChain( A, NULL ) would start filter A.   
// IFilterChain::StartChain( G, NULL ) would start filters G and H.  
// IFilterChain::StartChain( C, NULL ) would start filters C and D.  Finally, 
// IFilterChain::StartChain( E, NULL ) would fail because E cannot be in a 
// filter chain (see the Filter Chain Definition section for more information).
// 
// Return Value:
//      An HResult.  See the Direct Show SDK and COM SDK documentation for more 
// information on interpreting HRESULTs.
// 
// 
// 
// 
// HResult PauseChain( [in] IBaseFilter *pStartFilter, [in] IBaseFilter *pEndFilter );
// 
//      PauseChain() switches all the filters in a chain to the paused state.  If it cannot
// switch one of the filtres into the paused state, all the filters in the chain are
// stopped.  This method can only be called if the filter graph is paused.
// 
// Parameters:
// - pStartFilter [in]
//      The first filter in the filter chain.  Note that this can be the same 
//  filter as pEndFilter . 
// 
// - pEndFilter [in]
//      The last filter in the filter chain.  Note that this can be the same
// filter as pStartFilter.  If pEndFilter is NULL then the filter chain extends 
// from pStartFilter to the last downstream filter which can be in a filter chain.
// For example, IFilterChain::StopChain( A, NULL ) would stop filter A.   
// IFilterChain::StopChain( G, NULL ) would stop filters G and H.  
// IFilterChain::StopChain( C, NULL ) would stop filters C and D.  Finally, 
// IFilterChain::StopChain( E, NULL ) would fail because E cannot be in a filter 
// chain (see the Filter Chain Definition section for more information).
// 
// 
// Return Value:
//      An HResult.  See the Direct Show SDK and COM SDK documentation for more 
// information on interpreting HRESULTs.
// 
// 
// 
// HResult StopChain( [in] IBaseFilter *pStartFilter, [in] IBaseFilter *pEndFilter );
// 
//  StopChain() switches all the filters in chain to the stopped state.
//
// Parameters:
// - pStartFilter [in]
//      The first filter in the filter chain.  Note that this can be the same 
//  filter as pEndFilter . 
// 
// - pEndFilter [in]
//      The last filter in the filter chain.  Note that this can be the same 
// filter as pStartFilter.  If pEndFilter is NULL then the filter chain extends 
// from pStartFilter to the last downstream filter which can be in a filter chain.
// For example, IFilterChain::StopChain( A, NULL ) would stop filter A.   
// IFilterChain::StopChain( G, NULL ) would stop filters G and H.  
// IFilterChain::StopChain( C, NULL ) would stop filters C and D.  Finally,
// IFilterChain::StopChain( E, NULL ) would fail because E cannot be in a filter 
// chain (see the Filter Chain Definition section for more information).
// 
// 
// Return Value:
//      An HResult.  See the Direct Show SDK and COM SDK documentation for more 
// information on interpreting HRESULTs.
// 
// 
// 
// 
// 
// HResult RemoveChain( [in] IBaseFilter *pStartFilter, [in] IBaseFilter *pEndFilter );
// 
//      RemoveChain() removes every filter in a chain from the filter graph.  
// The filters can be removed while the graph is running.
// 
// Parameters:
// - pStartFilter [in]
//      The first filter in the filter chain.  Note that this can be the same 
// filter as pEndFilter .
// 
// - pEndFilter [in]
//      The last filter in the filter chain.  Note that this can be the same 
// filter as pStartFilter.  If pEndFilter is NULL then the filter chain 
// extends from pStartFilter to the last downstream filter which can be in a 
// filter chain.  For example, IFilterChain::RemoveChain( A, NULL ) would remove 
// filter A from the filter graph.   IFilterChain::RemoveChain( G, NULL ) would 
// remove filters G and H.  IFilterChain::RemoveChain( C, NULL ) would remove 
// filters C and D.  Finally, IFilterChain::RemoveChain( E, NULL ) would fail 
// because E cannot be in a filter chain (see the Filter Chain Definition
// section for more information).
// 
//
// Return Value:
//      An HResult.  See the Direct Show SDK and COM SDK documentation for more 
// information on interpreting HRESULTs.
// 
// 

  {$HPPEMIT 'typedef System::DelphiInterface<IFilterChain> _di_IFilterChain;'}
  {$EXTERNALSYM IFilterChain}
  IFilterChain = interface(IUnknown)
    ['{DCFBDCF6-0DC2-45f5-9AB2-7C330EA09C29}']
    (*** IFilterChain methods ***)
    function StartChain(pStartFilter, pEndFilter: IBaseFilter): HResult; stdcall;
    function PauseChain(pStartFilter, pEndFilter: IBaseFilter): HResult; stdcall;
    function StopChain(pStartFilter, pEndFilter: IBaseFilter): HResult; stdcall;
    function RemoveChain(pStartFilter, pEndFilter: IBaseFilter): HResult; stdcall;
  end;

///////////////////////////////////////////////////////////////////////////////
//
// Allocator Presenter interfaces
//
///////////////////////////////////////////////////////////////////////////////
{$IFDEF ENABLEVMR7}
//=====================================================================
//
// IVMRImagePresenter
//
//=====================================================================
type
  VMRPresentationFlags = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM VMRPresentationFlags}
  const
    VMRSample_SyncPoint        = $00000001;
    {$EXTERNALSYM VMRSample_SyncPoint}
    VMRSample_Preroll          = $00000002;
    {$EXTERNALSYM VMRSample_Preroll}
    VMRSample_Discontinuity    = $00000004;
    {$EXTERNALSYM VMRSample_Discontinuity}
    VMRSample_TimeValid        = $00000008;
    {$EXTERNALSYM VMRSample_TimeValid}
    VMRSample_SrcDstRectsValid = $00000010;
    {$EXTERNALSYM VMRSample_SrcDstRectsValid}


type
  PVMRPresentationInfo = ^TVMRPresentationInfo;
  tagVMRPRESENTATIONINFO = record
    dwFlags             : DWORD;
    lpSurf              : IDIRECTDRAWSURFACE7;
    rtStart             : TReferenceTime;
    rtEnd               : TReferenceTime;
    szAspectRatio       : TSIZE;
    rcSrc               : TRECT;
    rcDst               : TRECT;
    dwTypeSpecificFlags : DWORD;
    dwInterlaceFlags    : DWORD;
  end;
  {$EXTERNALSYM tagVMRPRESENTATIONINFO}
  VMRPRESENTATIONINFO = tagVMRPRESENTATIONINFO;
  {$EXTERNALSYM VMRPRESENTATIONINFO}
  TVMRPresentationInfo = tagVMRPRESENTATIONINFO;

  {$HPPEMIT 'typedef System::DelphiInterface<IVMRImagePresenter> _di_IVMRImagePresenter;'}
  {$EXTERNALSYM IVMRImagePresenter}
  IVMRImagePresenter = interface(IUnknown)
    ['{CE704FE7-E71E-41fb-BAA2-C4403E1182F5}']
    (*** IVMRImagePresenter methods ***)
    function StartPresenting(dwUserID: DWORD): HResult; stdcall;
    function StopPresenting(dwUserID: DWORD): HResult; stdcall;
    function PresentImage(dwUserID: DWORD; lpPresInfo: PVMRPRESENTATIONINFO): HResult; stdcall;
  end;
{$ENDIF}

{$IFDEF ENABLEVMR7}
//=====================================================================
//
// IVMRSurfaceAllocator
//
//=====================================================================

const
  AMAP_PIXELFORMAT_VALID  = $01;
  {$EXTERNALSYM AMAP_PIXELFORMAT_VALID}
  AMAP_3D_TARGET          = $02;
  {$EXTERNALSYM AMAP_3D_TARGET}
  AMAP_ALLOW_SYSMEM       = $04;
  {$EXTERNALSYM AMAP_ALLOW_SYSMEM}
  AMAP_FORCE_SYSMEM       = $08;
  {$EXTERNALSYM AMAP_FORCE_SYSMEM}
  AMAP_DIRECTED_FLIP      = $10;
  {$EXTERNALSYM AMAP_DIRECTED_FLIP}
  AMAP_NO_EXTRA_BUFFERS   = $20;
  {$EXTERNALSYM AMAP_NO_EXTRA_BUFFERS}

type
  PVMRAllocationInfo = ^TVMRAllocationInfo;
  tagVMRALLOCATIONINFO = record
    dwFlags          : DWORD;
    lpHdr            : PBITMAPINFOHEADER;
    lpPixFmt         : PDDPIXELFORMAT;
    szAspectRatio    : TSIZE;
    dwMinBuffers     : DWORD;
    dwMaxBuffers     : DWORD;
    dwInterlaceFlags : DWORD;
    szNativeSize     : TSIZE ;
  end;
  {$EXTERNALSYM tagVMRALLOCATIONINFO}
  VMRALLOCATIONINFO = tagVMRALLOCATIONINFO;
  {$EXTERNALSYM VMRALLOCATIONINFO}
  TVMRAllocationInfo = tagVMRALLOCATIONINFO;

  IVMRSurfaceAllocatorNotify = interface;
  {$HPPEMIT 'typedef System::DelphiInterface<IVMRSurfaceAllocator> _di_IVMRSurfaceAllocator;'}
  {$EXTERNALSYM IVMRSurfaceAllocator}
  IVMRSurfaceAllocator = interface(IUnknown)
    ['{31ce832e-4484-458b-8cca-f4d7e3db0b52}']
    (*** IVMRSurfaceAllocator methods ***)
    function AllocateSurface(dwUserID: DWORD; lpAllocInfo: PVMRALLOCATIONINFO;
      var lpdwActualBuffers: DWORD; out lplpSurface: IDIRECTDRAWSURFACE7): HResult; stdcall;
    function FreeSurface(dwID: DWORD): HResult; stdcall;
    function PrepareSurface(dwUserID: DWORD; lpSurface: IDIRECTDRAWSURFACE7;
      dwSurfaceFlags: DWORD): HResult; stdcall;
    function AdviseNotify(lpIVMRSurfAllocNotify: IVMRSurfaceAllocatorNotify): HResult; stdcall;
  end;
{$ENDIF}

{$IFDEF ENABLEVMR7}
//=====================================================================
//
// IVMRSurfaceAllocatorNotify
//
//=====================================================================

  {$HPPEMIT 'typedef System::DelphiInterface<IVMRSurfaceAllocatorNotify> _di_IVMRSurfaceAllocatorNotify;'}
  {$EXTERNALSYM IVMRSurfaceAllocatorNotify}
  IVMRSurfaceAllocatorNotify = interface(IUnknown)
    ['{aada05a8-5a4e-4729-af0b-cea27aed51e2}']
    (*** IVMRSurfaceAllocatorNotify methods ***)
    function AdviseSurfaceAllocator(dwUserID: DWORD; lpIVRMSurfaceAllocator: IVMRSurfaceAllocator): HResult; stdcall;
    function SetDDrawDevice(lpDDrawDevice: IDirectDraw7; hMonitor: HMONITOR): HResult; stdcall;
    function ChangeDDrawDevice(lpDDrawDevice: IDIRECTDRAW7; hMonitor: HMONITOR): HResult; stdcall;
    function RestoreDDrawSurfaces: HResult; stdcall;
    function NotifyEvent(EventCode: LongInt; Param1, Param2: LongInt): HResult; stdcall;
    function SetBorderColor(clrBorder: COLORREF): HResult; stdcall;
  end;
{$ENDIF}
///////////////////////////////////////////////////////////////////////////////
//
// Application control and configuration interfaces
//
///////////////////////////////////////////////////////////////////////////////

//=====================================================================
//
// IVMRWindowlessControl
//
//=====================================================================
  VMR_ASPECT_RATIO_MODE = (
    VMR_ARMODE_NONE,
    VMR_ARMODE_LETTER_BOX
  );
  {$EXTERNALSYM VMR_ASPECT_RATIO_MODE}
  TVMRAspectRatioMode = VMR_ASPECT_RATIO_MODE;

{$IFDEF ENABLEVMR7}

  {$HPPEMIT 'typedef System::DelphiInterface<IVMRWindowlessControl> _di_IVMRWindowlessControl;'}
  {$EXTERNALSYM IVMRWindowlessControl}
  IVMRWindowlessControl = interface(IUnknown)
    ['{0eb1088c-4dcd-46f0-878f-39dae86a51b7}']
    (*** IVMRWindowlessControl methods ***)
    //////////////////////////////////////////////////////////
    // Video size and position information
    //////////////////////////////////////////////////////////
    function GetNativeVideoSize(out lpWidth, lpHeight, lpARWidth, lpARHeight: LongInt): HResult; stdcall;
    function GetMinIdealVideoSize(out lpWidth, lpHeight: longint): HResult; stdcall;
    function GetMaxIdealVideoSize(out lpWidth, lpHeight: longint): HResult; stdcall;
    function SetVideoPosition(lpSRCRect, lpDSTRect: PRECT): HResult; stdcall;
    function GetVideoPosition(out lpSRCRect, lpDSTRect: TRECT): HResult; stdcall;
    function GetAspectRatioMode(out lpAspectRatioMode: DWORD): HResult; stdcall;
    function SetAspectRatioMode(AspectRatioMode: TVMRAspectRatioMode): HResult; stdcall;
    //////////////////////////////////////////////////////////
    // Display and clipping management
    //////////////////////////////////////////////////////////
    function SetVideoClippingWindow(hwnd: HWND): HResult; stdcall;
    function RepaintVideo(hwnd: HWND; hdc: HDC): HResult; stdcall;
    function DisplayModeChanged: HResult; stdcall;
    //////////////////////////////////////////////////////////
    // GetCurrentImage
    //
    // Returns the current image being displayed.  This images
    // is returned in the form of packed Windows DIB.
    //
    // GetCurrentImage can be called at any time, also
    // the caller is responsible for free the returned memory
    // by calling CoTaskMemFree.
    //
    // Excessive use of this function will degrade video
    // playback performed.
    //////////////////////////////////////////////////////////
    function GetCurrentImage(out lpDib): HResult; stdcall;
    //////////////////////////////////////////////////////////
    // Border Color control
    //
    // The border color is color used to fill any area of the
    // the destination rectangle that does not contain video.
    // It is typically used in two instances.  When the video
    // straddles two monitors and when the VMR is trying
    // to maintain the aspect ratio of the movies by letter
    // boxing the video to fit within the specified destination
    // rectangle. See SetAspectRatioMode above.
    //////////////////////////////////////////////////////////
    function SetBorderColor(Clr: COLORREF): HResult; stdcall;
    function GetBorderColor(out lpClr: COLORREF): HResult; stdcall;
    //////////////////////////////////////////////////////////
    // Color key control only meaningful when the VMR is using
    // and overlay
    //////////////////////////////////////////////////////////
    function SetColorKey(Clr: COLORREF): HResult; stdcall;
    function GetColorKey(out lpClr: COLORREF): HResult; stdcall;
  end;
{$ENDIF}
{$IFDEF ENABLEVMR7}
//=====================================================================
//
// IVMRMixerControl
//
//=====================================================================

//
//  Normalized relative rectangle
//  Coordinate ranges: x=[0...1) y=[0...1)
//  Where the output window goes from 0,0 (closed inclusive lower bound)
//  to 1,1 (open exclusive upper bound)
//

const
  MixerPref_NoDecimation	       = $1;
  {$EXTERNALSYM MixerPref_NoDecimation}
  MixerPref_DecimateOutput	     = $2;
  {$EXTERNALSYM MixerPref_DecimateOutput}
  MixerPref_ARAdjustXorY         = $4; // adjust the aspect ratio in x or y
  {$EXTERNALSYM MixerPref_ARAdjustXorY}
  MixerPref_DecimationReserved   = $8; // bits reserved for future use.
  {$EXTERNALSYM MixerPref_DecimationReserved}
  MixerPref_DecimateMask	       = $f;
  {$EXTERNALSYM MixerPref_DecimateMask}
  MixerPref_BiLinearFiltering	   = $10;
  {$EXTERNALSYM MixerPref_BiLinearFiltering}
  MixerPref_PointFiltering	     = $20;
  {$EXTERNALSYM MixerPref_PointFiltering}
  MixerPref_FilteringMask	       = $f0;
  {$EXTERNALSYM MixerPref_FilteringMask}
  MixerPref_RenderTargetRGB      = $00000100; // Uses D3D to perform mixing
  {$EXTERNALSYM MixerPref_RenderTargetRGB}
  MixerPref_RenderTargetYUV      = $00001000; // Uses DXVA to perform mixing
  {$EXTERNALSYM MixerPref_RenderTargetYUV}
  MixerPref_RenderTargetYUV420   = $00000200; // Deprecated render target
  {$EXTERNALSYM MixerPref_RenderTargetYUV420}
  MixerPref_RenderTargetYUV422   = $00000400; // Deprecated render target
  {$EXTERNALSYM MixerPref_RenderTargetYUV422}
  MixerPref_RenderTargetYUV444   = $00000800; // Deprecated render target
  {$EXTERNALSYM MixerPref_RenderTargetYUV444}
  MixerPref_RenderTargetReserved = $0000E000; // 3 bits reserved for future use.
  {$EXTERNALSYM MixerPref_RenderTargetReserved}
  MixerPref_RenderTargetMask	   = $ff00;
  {$EXTERNALSYM MixerPref_RenderTargetMask}

  //
  // Dynamic changes that can be performed when the VMR's mixer is
  // configured to use the YUV Render target (see MixerPref_RenderTargetYUV)
  // These preferences can be applied while the graph is running and take effect
  // when the next frame is composed by the mixer.
  //
  MixerPref_DynamicSwitchToBOB   = $00010000;
  {$EXTERNALSYM MixerPref_DynamicSwitchToBOB}
  MixerPref_DynamicDecimateBy2   = $00020000;
  {$EXTERNALSYM MixerPref_DynamicDecimateBy2}

  MixerPref_DynamicReserved      = $000C0000;
  {$EXTERNALSYM MixerPref_DynamicReserved}
  MixerPref_DynamicMask          = $000F0000;
  {$EXTERNALSYM MixerPref_DynamicMask}


type
  PNormalizedRect = ^TNormalizedRect;
  _NORMALIZEDRECT = record
    left   : Single;
    top    : Single;
    right  : Single;
    bottom : Single;
  end;
  {$EXTERNALSYM _NORMALIZEDRECT}
  NORMALIZEDRECT = _NORMALIZEDRECT;
  {$EXTERNALSYM NORMALIZEDRECT}
  TNormalizedRect = _NORMALIZEDRECT;

  {$HPPEMIT 'typedef System::DelphiInterface<IVMRMixerControl> _di_IVMRMixerControl;'}
  {$EXTERNALSYM IVMRMixerControl}
  IVMRMixerControl = interface(IUnknown)
    ['{1c1a17b0-bed0-415d-974b-dc6696131599}']
    (*** IVMRMixerControl methods ***)
    //Alpha = Source alpha premultication factor (global alpha for source)
    function SetAlpha(dwStreamID: DWORD; Alpha: single): HResult; stdcall;
    function GetAlpha(dwStreamID: DWORD; out pAlpha: single): HResult; stdcall;
    function SetZOrder(dwStreamID, dwZ: DWORD): HResult; stdcall;
    function GetZOrder(dwStreamID: DWORD; out pZ: DWORD): HResult; stdcall;
    function SetOutputRect(dwStreamID: DWORD; const pRect: TNORMALIZEDRECT): HResult; stdcall;
    function GetOutputRect(dwStreamID: DWORD; out pRect: TNORMALIZEDRECT): HResult; stdcall;
    function SetBackgroundClr(ClrBkg: COLORREF): HResult; stdcall;
    function GetBackgroundClr(out lpClrBkg: COLORREF): HResult; stdcall;
    function SetMixingPrefs(dwMixerPrefs: DWORD): HResult; stdcall;
    function GetMixingPrefs(pdwMixerPrefs: DWORD): HResult; stdcall;
  end;
{$ENDIF}

{$IFDEF ENABLEVMR7}
///////////////////////////////////////////////////////////////////////////////
//
// VMR Multimon configuration interface
//
///////////////////////////////////////////////////////////////////////////////
  tagVMRGUID = record
    pGUID : PGUID; // is NULL if the default DDraw device
    GUID  : TGUID; // otherwise points to this GUID
  end;
  {$EXTERNALSYM tagVMRGUID}
  VMRGUID = tagVMRGUID;
  {$EXTERNALSYM VMRGUID}
  TVMRGuid = tagVMRGUID;

  tagVMRMONITORINFO = record
    guid            : VMRGUID;
    rcMonitor       : TRECT;
    hMon            : HMONITOR;
    dwFlags         : DWORD;    // described in MONITORINFOEX, currently only MONITORINFOF_PRIMARY
    szDevice        : array[0..31] of wchar;
    szDescription   : array[0..255] of wchar;
    liDriverVersion : int64;
    dwVendorId      : DWORD;
    dwDeviceId      : DWORD;
    dwSubSysId      : DWORD;
    dwRevision      : DWORD;
  end;
  {$EXTERNALSYM tagVMRMONITORINFO}
  VMRMONITORINFO = tagVMRMONITORINFO;
  {$EXTERNALSYM VMRMONITORINFO}
  TVMRMonitorInfo = tagVMRMONITORINFO;

  {$HPPEMIT 'typedef System::DelphiInterface<IVMRMonitorConfig> _di_IVMRMonitorConfig;'}
  {$EXTERNALSYM IVMRMonitorConfig}
  IVMRMonitorConfig = interface(IUnknown)
    ['{9cf0b1b6-fbaa-4b7f-88cf-cf1f130a0dce}']
    (*** IVMRMonitorConfig methods ***)
    // Use this method on a Multi-Monitor system to specify to the
    // mixer filter which Direct Draw driver should be used when connecting
    // to an upstream decoder filter.
    function SetMonitor(const pGUID: TVMRGUID): HResult; stdcall;
    // Use this method to determine the direct draw object that will be used when
    // connecting the  mixer filter to an upstream decoder filter.
    function GetMonitor(out pGUID: TVMRGUID): HResult; stdcall;
    // Use this method on a multi-monitor system to specify to the
    //  mixer filter the default Direct Draw device to use when
    // connecting to an upstream filter.  The default direct draw device
    // can be overriden for a particular connection by SetMonitor method
    // described above.
    function SetDefaultMonitor(const pGUID: TVMRGUID): HResult; stdcall;
    // Use this method on a multi-monitor system to determine which
    // is the default direct draw device the overlay mixer filter
    // will  use when connecting to an upstream filter.
    function GetDefaultMonitor(out pGUID: TVMRGUID): HResult; stdcall;
    // Use this method to get a list of Direct Draw device GUIDs and thier
    // associated monitor information that the mixer can use when
    // connecting to an upstream decoder filter.  Passing down a NULL pInfo
    // parameter allows the app to determine the required array size (returned
    // in pdwNumDevices).  Otherwise, dwNumDevices returns the actual
    // number of devices retrieved.
    function GetAvailableMonitors(out pInfo: TVMRMONITORINFO; //if it fail try : "out pInfo" only /hg
      dwMaxInfoArraySize: DWORD;                              // in array members
      out pdwNumDevices: DWORD): HResult; stdcall;            // actual number of devices retrieved
  end;
{$ENDIF}

{$IFDEF ENABLEVMR7}
//=====================================================================
//
// IVMRImageCompositor
//
//=====================================================================

type
  PVMRVideoStreamInfo = ^TVMRVideoStreamInfo;
  _VMRVIDEOSTREAMINFO = record
    pddsVideoSurface  : IDIRECTDRAWSURFACE7;
    dwWidth           : DWORD;
    dwHeight          : DWORD;
    dwStrmID          : DWORD;
    fAlpha            : single;
    ddClrKey          : TDDCOLORKEY;
    rNormal           : TNORMALIZEDRECT;
  end;
  {$EXTERNALSYM _VMRVIDEOSTREAMINFO}
  VMRVIDEOSTREAMINFO = _VMRVIDEOSTREAMINFO;
  {$EXTERNALSYM VMRVIDEOSTREAMINFO}
  TVMRVideoStreamInfo = _VMRVIDEOSTREAMINFO;

  {$HPPEMIT 'typedef System::DelphiInterface<IVMRImageCompositor> _di_IVMRImageCompositor;'}
  {$EXTERNALSYM IVMRImageCompositor}
  IVMRImageCompositor = interface(IUnknown)
    ['{7a4fb5af-479f-4074-bb40-ce6722e43c82}']
    (*** IVMRImageCompositor methods ***)
    function InitCompositionTarget(pD3DDevice: IUnknown; pddsRenderTarget: IDIRECTDRAWSURFACE7): HResult; stdcall;
    function TermCompositionTarget(pD3DDevice: IUnknown; pddsRenderTarget: IDIRECTDRAWSURFACE7): HResult; stdcall;
    function SetStreamMediaType(dwStrmID: DWORD; pmt: PAMMediaType; fTexture: BOOL): HResult; stdcall;
    function CompositeImage(pD3DDevice: IUnknown; pddsRenderTarget: IDIRECTDRAWSURFACE7;
               pmtRenderTarget: PAMMediaType; rtStart, rtEnd: TReferenceTime;
               dwClrBkGnd: DWORD; pVideoStreamInfo: PVMRVIDEOSTREAMINFO; cStreams: cardinal): HResult; stdcall;
  end;
{$ENDIF}

{$IFDEF ENABLEVMR7}
///////////////////////////////////////////////////////////////////////////////
//
// VMR Filter configuration interfaces
//
///////////////////////////////////////////////////////////////////////////////

const
  RenderPrefs_RestrictToInitialMonitor     = $00000000; // not implemented do not use
  {$EXTERNALSYM RenderPrefs_RestrictToInitialMonitor}
  RenderPrefs_ForceOffscreen               = $00000001;
  {$EXTERNALSYM RenderPrefs_ForceOffscreen}
  RenderPrefs_ForceOverlays                = $00000002; // fail if no overlays
  {$EXTERNALSYM RenderPrefs_ForceOverlays}
  RenderPrefs_AllowOverlays                = $00000000; // overlay used by default
  {$EXTERNALSYM RenderPrefs_AllowOverlays}
  RenderPrefs_AllowOffscreen               = $00000000; // offscreen used if no overlay
  {$EXTERNALSYM RenderPrefs_AllowOffscreen}
  RenderPrefs_DoNotRenderColorKeyAndBorder = $00000008; // app paints color keys
  {$EXTERNALSYM RenderPrefs_DoNotRenderColorKeyAndBorder}
  RenderPrefs_Reserved                     = $00000010; // note: used to be RestrictToInitialMonitor
  {$EXTERNALSYM RenderPrefs_Reserved}
  RenderPrefs_PreferAGPMemWhenMixing	     = $00000020;
  {$EXTERNALSYM RenderPrefs_PreferAGPMemWhenMixing}
  RenderPrefs_Mask                         = $0000003f; // OR of all above flags
  {$EXTERNALSYM RenderPrefs_Mask}

  VMRMode_Windowed                         = $00000001;
  {$EXTERNALSYM VMRMode_Windowed}
  VMRMode_Windowless                       = $00000002;
  {$EXTERNALSYM VMRMode_Windowless}
  VMRMode_Renderless                       = $00000004;
  {$EXTERNALSYM VMRMode_Renderless}
  VMRMode_Mask                             = $00000007; // OR of all above flags
  {$EXTERNALSYM VMRMode_Mask}
                                                        // not a valid value to pass to SetRenderMode

  MAX_NUMBER_OF_STREAMS	= 16;
  {$EXTERNALSYM MAX_NUMBER_OF_STREAMS}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IVMRFilterConfig> _di_IVMRFilterConfig;'}
  {$EXTERNALSYM IVMRFilterConfig}
  IVMRFilterConfig = interface(IUnknown)
    ['{9e5530c5-7034-48b4-bb46-0b8a6efc8e36}']
    (*** IVMRFilterConfig methods ***)
    function SetImageCompositor(lpVMRImgCompositor: IVMRImageCompositor): HResult; stdcall;
    function SetNumberOfStreams(dwMaxStreams: DWORD): HResult; stdcall;
    function GetNumberOfStreams(out pdwMaxStreams: DWORD): HResult; stdcall;
    function SetRenderingPrefs(dwRenderFlags: DWORD): HResult; stdcall; // a combination of VMRRenderingPrefFlags
    function GetRenderingPrefs(out pdwRenderFlags: DWORD): HResult; stdcall;
    function SetRenderingMode(Mode: DWORD): HResult; stdcall; // a combination of VMRMode
    function GetRenderingMode(out pMode: DWORD): HResult; stdcall;
  end;
{$ENDIF}

{$IFDEF ENABLEVMR7}
//=====================================================================
//
// IVMRAspectRatioControl
//
//=====================================================================

  {$HPPEMIT 'typedef System::DelphiInterface<IVMRAspectRatioControl> _di_IVMRAspectRatioControl;'}
  {$EXTERNALSYM IVMRAspectRatioControl}
  IVMRAspectRatioControl = interface(IUnknown)
    ['{ede80b5c-bad6-4623-b537-65586c9f8dfd}']
    (*** IVMRAspectRatioControl methods ***)
    function GetAspectRatioMode(out lpdwARMode: TVMRAspectRatioMode): HResult; stdcall;
    function SetAspectRatioMode(dwARMode: TVMRAspectRatioMode): HResult; stdcall;
  end;
{$ENDIF}

{$IFDEF ENABLEVMR7}
//=====================================================================
//
// IVMRDeinterlaceControl
//
// New interfaced introduced into the WindowsXP SP1 release of the VMR.
// This interface allows applications to control the DX-VA deinterlacing
// support provided by the VMR.
//
// The VMR needs to be set into "mixing" mode for this interface to work.
//
// SetDeinterlaceMode is only effective for new connections made to the
// VMR.  It should be noted that the graphics device driver may refuse
// to use the specified deinterlace mode, in which case 3 fallback
// policies are offered by the VMR, these being:
//
//      1. Fallback to the next best mode offered by the driver.
//      2. Fallback to the BOB deinterlace mode.
//      3. Fallback to the WEAVE deinterlace mode (ie. turn deinterlacing off).
//
//=====================================================================
type
  VMRDeinterlacePrefs = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM VMRDeinterlacePrefs}

const
  DeinterlacePref_NextBest = $01;
  {$EXTERNALSYM DeinterlacePref_NextBest}
  DeinterlacePref_BOB      = $02;
  {$EXTERNALSYM DeinterlacePref_BOB}
  DeinterlacePref_Weave    = $04;
  {$EXTERNALSYM DeinterlacePref_Weave}
  DeinterlacePref_Mask     = $07;
  {$EXTERNALSYM DeinterlacePref_Mask}

type
  VMRDeinterlaceTech = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM VMRDeinterlaceTech}

const
  // the algorithm is unknown or proprietary
  DeinterlaceTech_Unknown                = $0000;
  {$EXTERNALSYM DeinterlaceTech_Unknown}

  // the algorithm creates the missing lines by repeating
  // the line either above or below it - this method will look very jaggy and
  // isn't recommended
  DeinterlaceTech_BOBLineReplicate       = $0001;
  {$EXTERNALSYM DeinterlaceTech_BOBLineReplicate}


  // the algorithm creates the missing lines by vertically stretching each
  // video field by a factor of two, for example by averaging two lines or
  // using a [-1, 9, 9, -1]/16 filter across four lines.
  // Slight vertical adjustments are made to ensure that the resulting image
  // does not "bob" up and down.
  DeinterlaceTech_BOBVerticalStretch     = $0002;
  {$EXTERNALSYM DeinterlaceTech_BOBVerticalStretch}

  // the pixels in the missing line are recreated by a median filtering operation
  DeinterlaceTech_MedianFiltering        = $0004;
  {$EXTERNALSYM DeinterlaceTech_MedianFiltering}

  // the pixels in the missing line are recreated by an edge filter.
  // In this process, spatial directional filters are applied to determine
  // the orientation of edges in the picture content, and missing
  // pixels are created by filtering along (rather than across) the
  // detected edges.
  DeinterlaceTech_EdgeFiltering          = $0010;
  {$EXTERNALSYM DeinterlaceTech_EdgeFiltering}

  // the pixels in the missing line are recreated by switching on a field by
  // field basis between using either spatial or temporal interpolation
  // depending on the amount of motion.
  DeinterlaceTech_FieldAdaptive          = $0020;
  {$EXTERNALSYM DeinterlaceTech_FieldAdaptive}

  // the pixels in the missing line are recreated by switching on a pixel by pixel
  // basis between using either spatial or temporal interpolation depending on
  // the amount of motion..
  DeinterlaceTech_PixelAdaptive          = $0040;
  {$EXTERNALSYM DeinterlaceTech_PixelAdaptive}

  // Motion Vector Steering  identifies objects within a sequence of video
  // fields.  The missing pixels are recreated after first aligning the
  // movement axes of the individual objects in the scene to make them
  // parallel with the time axis.
  DeinterlaceTech_MotionVectorSteered    = $0080;
  {$EXTERNALSYM DeinterlaceTech_MotionVectorSteered}

type
  PVMRFrequency = ^TVMRFrequency;
  _VMRFrequency = record
    dwNumerator   : DWORD;
    dwDenominator : DWORD;
  end;
  {$EXTERNALSYM _VMRFrequency}
  VMRFrequency = _VMRFrequency;
  {$EXTERNALSYM VMRFrequency}
  TVMRFrequency = _VMRFrequency;

  PVMRVideoDesc = ^TVMRVideoDesc;
  _VMRVideoDesc = record
    dwSize               : DWORD;
    dwSampleWidth        : DWORD;
    dwSampleHeight       : DWORD;
    SingleFieldPerSample : BOOL;
    dwFourCC             : DWORD;
    InputSampleFreq      : VMRFrequency;
    OutputFrameFreq      : VMRFrequency;
  end;
  {$EXTERNALSYM _VMRVideoDesc}
  VMRVideoDesc = _VMRVideoDesc;
  {$EXTERNALSYM VMRVideoDesc}
  TVMRVideoDesc = _VMRVideoDesc;

  PVMRDeinterlaceCaps = ^TVMRDeinterlaceCaps;
  _VMRDeinterlaceCaps = record
    dwSize                    : DWORD;
    dwNumPreviousOutputFrames : DWORD;
    dwNumForwardRefSamples    : DWORD;
    dwNumBackwardRefSamples   : DWORD;
    DeinterlaceTechnology     : VMRDeinterlaceTech;
  end;
  {$EXTERNALSYM _VMRDeinterlaceCaps}
  VMRDeinterlaceCaps = _VMRDeinterlaceCaps;
  {$EXTERNALSYM VMRDeinterlaceCaps}
  TVMRDeinterlaceCaps = _VMRDeinterlaceCaps;

  {$HPPEMIT 'typedef System::DelphiInterface<IVMRDeinterlaceControl> _di_IVMRDeinterlaceControl;'}
  {$EXTERNALSYM IVMRDeinterlaceControl}
  IVMRDeinterlaceControl = interface(IUnknown)
    ['{bb057577-0db8-4e6a-87a7-1a8c9a505a0f}']
    (*** IVMRDeinterlaceControl methods ***)
    // For the specified video description returns the
    // number of deinterlacing modes available to the VMR.
    // The deinterlacing modes are returned in descending
    // quality order ie. the best quality mode is at
    // lpdwNumDeinterlaceModes[0], the next best at
    // lpdwNumDeinterlaceModes[1] and so on.
    //
    // To determine how big an array of guids to pass to the
    // GetNumberOfDeinterlaceModes method call
    // GetNumberOfDeinterlaceModes(lpVideoDescription, &dwNumModes, NULL);
    //
    function GetNumberOfDeinterlaceModes(lpVideoDescription: PVMRVideoDesc;
      var lpdwNumDeinterlaceModes: DWORD; lpDeinterlaceModes: PGUID): HResult; stdcall;
    // For the given video description get the capabilities of the
    // specified de-interlace mode.
    function GetDeinterlaceModeCaps(const lpDeinterlaceMode: TGUID;
      lpVideoDescription: PVMRVideoDesc; lpDeinterlaceCaps: PVMRDeinterlaceCaps): HResult; stdcall;
    // Get/Set the deinterlace mode that you would like the
    // VMR to use when de-interlacing the specified stream.
    // It should be noted that the VMR may not actually be able
    // to use the requested deinterlace mode, in which case the
    // the VMR will fall back to other de-interlace modes as specified
    // by the de-interlace preferences (see SetDeinterlacePrefs below).
    function  GetDeinterlaceMode(
      dwStreamID: DWORD;
      out lpDeinterlaceMode: TGUID   // returns GUID_NULL if SetDeinterlaceMode
      ): HResult; stdcall;             // has not been called yet.

    function SetDeinterlaceMode(
      dwStreamID: DWORD;              // use $FFFFFFFF to set mode for all streams
      const lpDeinterlaceMode: TGUID // GUID_NULL == turn deinterlacing off
      ): HResult; stdcall;

    function GetDeinterlacePrefs(out lpdwDeinterlacePrefs: VMRDeinterlacePrefs): HResult; stdcall;
    function SetDeinterlacePrefs(dwDeinterlacePrefs: VMRDeinterlacePrefs): HResult; stdcall;

    // Get the DeinterlaceMode currently in use for the specified
    // video stream (ie. pin).  The returned GUID will be NULL if
    // the de-interlacing h/w has not been created by the VMR at the
    // time the function is called, or if the VMR determines that
    // this stream should not or can be de-interlaced.
    function GetActualDeinterlaceMode(
      dwStreamID: DWORD; out lpDeinterlaceMode: TGUID): HResult; stdcall;
  end;
{$ENDIF}

{$IFDEF ENABLEVMR7}
//=====================================================================
//
// IVMRMixerBitmap
//
//=====================================================================
  PVMRAlphaBitmap = ^TVMRAlphaBitmap;
  _VMRALPHABITMAP = record
    dwFlags   : DWORD;               // flags word
    hdc       : HDC;                 // DC for the bitmap to copy
    pDDS      : IDIRECTDRAWSURFACE7; // DirectDraw surface to copy
    rSrc      : TRECT;               // rectangle to copy from the DC/DDS
    rDest     : NORMALIZEDRECT;     // output rectangle in composition space
    fAlpha    : single;              // opacity of the bitmap
    clrSrcKey : COLORREF;            // src color key
  end;
  {$EXTERNALSYM _VMRALPHABITMAP}
  VMRALPHABITMAP = _VMRALPHABITMAP;
  {$EXTERNALSYM VMRALPHABITMAP}
  TVMRAlphaBitmap = _VMRALPHABITMAP;

const
  // Disable the alpha bitmap for now
  VMRBITMAP_DISABLE           = $00000001;
  {$EXTERNALSYM VMRBITMAP_DISABLE}

  // Take the bitmap from the HDC rather than the DirectDraw surface
  VMRBITMAP_HDC               = $00000002;
  {$EXTERNALSYM VMRBITMAP_HDC}

  // Take the entire DDraw surface - rSrc is ignored
  VMRBITMAP_ENTIREDDS         = $00000004;
  {$EXTERNALSYM VMRBITMAP_ENTIREDDS}

  // Indicates that the clrTrans value is valid and should be
  // used when blending
  VMRBITMAP_SRCCOLORKEY       = $00000008;
  {$EXTERNALSYM VMRBITMAP_SRCCOLORKEY}

  VMRBITMAP_SRCRECT           = $00000010;
  {$EXTERNALSYM VMRBITMAP_SRCRECT}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IVMRMixerBitmap> _di_IVMRMixerBitmap;'}
  {$EXTERNALSYM IVMRMixerBitmap}
  IVMRMixerBitmap = interface(IUnknown)
    ['{1E673275-0257-40aa-AF20-7C608D4A0428}']
    (*** IVMRMixerBitmap methods ***)
    // Set bitmap, location to blend it, and blending value
    function SetAlphaBitmap(var pBmpParms: TVMRALPHABITMAP): HResult; stdcall;
    // Change bitmap location, size and blending value,
    // graph must be running for change to take effect.
    function UpdateAlphaBitmapParameters(pBmpParms: PVMRALPHABITMAP): HResult; stdcall;
    // Get bitmap, location to blend it, and blending value
    function GetAlphaBitmapParameters(out pBmpParms: TVMRALPHABITMAP): HResult; stdcall;
  end;
{$ENDIF}
{$IFDEF ENABLEVMR7}
//=====================================================================
//
// IVMRVideoStreamControl
//
//=====================================================================

  {$HPPEMIT 'typedef System::DelphiInterface<IVMRVideoStreamControl> _di_IVMRVideoStreamControl;'}
  {$EXTERNALSYM IVMRVideoStreamControl}
  IVMRVideoStreamControl = interface(IUnknown)
    ['{058d1f11-2a54-4bef-bd54-df706626b727}']
    (*** IVMRVideoStreamControl methods ***)
    function SetColorKey(clr: PDDCOLORKEY): HResult; stdcall; // Source color key, set to 0xFFFFFFFF to disable
    function GetColorKey(out pclr: TDDCOLORKEY): HResult; stdcall;
    function SetStreamActiveState(fActive: BOOL): HResult; stdcall;
    function GetStreamActiveState(out lpfActive: BOOL): HResult; stdcall;
  end;
{$ENDIF}
{$IFDEF ENABLEVMR7}
//=====================================================================
//
// IVMRSurface
//
//=====================================================================

  {$HPPEMIT 'typedef System::DelphiInterface<IVMRSurface> _di_IVMRSurface;'}
  {$EXTERNALSYM IVMRSurface}
  IVMRSurface = interface(IUnknown)
    ['{a9849bbe-9ec8-4263-b764-62730f0d15d0}']
    (*** IVMRSurface methods ***)
    function IsSurfaceLocked: HResult; stdcall;
    function LockSurface(out lpSurface: PBYTE): HResult; stdcall;
    function UnlockSurface: HResult; stdcall;
    function GetSurface(lplpSurface: IDIRECTDRAWSURFACE7): HResult; stdcall;
  end;
{$ENDIF}

{$IFDEF ENABLEVMR7}
//=====================================================================
//
// IVMRImagePresenterConfig
//
//=====================================================================

  {$HPPEMIT 'typedef System::DelphiInterface<IVMRImagePresenterConfig> _di_IVMRImagePresenterConfig;'}
  {$EXTERNALSYM IVMRImagePresenterConfig}
  IVMRImagePresenterConfig = interface(IUnknown)
    ['{9f3a1c85-8555-49ba-935f-be5b5b29d178}']
    (*** IVMRImagePresenterConfig methods ***)
    function SetRenderingPrefs(dwRenderFlags: DWORD): HResult; stdcall;
    function GetRenderingPrefs(out dwRenderFlags: DWORD): HResult; stdcall;
  end;
//=====================================================================
//
// IVMRImagePresenterExclModeConfig
//
//=====================================================================

  {$HPPEMIT 'typedef System::DelphiInterface<IVMRImagePresenterExclModeConfig> _di_IVMRImagePresenterExclModeConfig;'}
  {$EXTERNALSYM IVMRImagePresenterExclModeConfig}
  IVMRImagePresenterExclModeConfig = interface(IVMRImagePresenterConfig)
    ['{e6f7ce40-4673-44f1-8f77-5499d68cb4ea}']
    (*** IVMRImagePresenterExclModeConfig methods ***)
    function SetXlcModeDDObjAndPrimarySurface(lpDDObj: IDIRECTDRAW7; lpPrimarySurf: IDIRECTDRAWSURFACE7): HResult; stdcall;
    function GetXlcModeDDObjAndPrimarySurface(lpDDObj: IDIRECTDRAW7; lpPrimarySurf: IDIRECTDRAWSURFACE7): HResult; stdcall;
  end;
{$ENDIF}

//=====================================================================
//
// IVPManager
//
//=====================================================================

  {$HPPEMIT 'typedef System::DelphiInterface<IVPManager> _di_IVPManager;'}
  {$EXTERNALSYM IVPManager}
  IVPManager = interface(IUnknown)
    ['{aac18c18-e186-46d2-825d-a1f8dc8e395a}']
    (*** IVPManager methods ***)
    // Use this method on a Multi-Monitor system to specify to the
    // video port manager filter which videoport index is used
    // to an upstream decoder filter.
    function SetVideoPortIndex(dwVideoPortIndex: DWORD): HResult; stdcall; // the video port number that this is connected to
    // This method returns the current video port index being used by the VPM.
    function GetVideoPortIndex(out pdwVideoPortIndex: DWORD): HResult; stdcall; // the video port number that this is connected to
  end;


(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       mmstream.h
 *
 ***************************************************************************)

const
  IID_IMultiMediaStream: TGUID = '{B502D1BC-9A57-11d0-8FDE-00C04FD9189D}';
  {$EXTERNALSYM IID_IMultiMediaStream}
  IID_IMediaStream: TGUID = '{B502D1BD-9A57-11d0-8FDE-00C04FD9189D}';
  {$EXTERNALSYM IID_IMediaStream}
  IID_IStreamSample: TGUID = '{B502D1BE-9A57-11d0-8FDE-00C04FD9189D}';
  {$EXTERNALSYM IID_IStreamSample}

const
  MS_S_PENDING                = $00040001;
  {$EXTERNALSYM MS_S_PENDING}
  MS_S_NOUPDATE               = $00040002;
  {$EXTERNALSYM MS_S_NOUPDATE}
  MS_S_ENDOFSTREAM            = $00040003;
  {$EXTERNALSYM MS_S_ENDOFSTREAM}
  MS_E_SAMPLEALLOC            = $80040401;
  {$EXTERNALSYM MS_E_SAMPLEALLOC}
  MS_E_PURPOSEID              = $80040402;
  {$EXTERNALSYM MS_E_PURPOSEID}
  MS_E_NOSTREAM               = $80040403;
  {$EXTERNALSYM MS_E_NOSTREAM}
  MS_E_NOSEEKING              = $80040404;
  {$EXTERNALSYM MS_E_NOSEEKING}
  MS_E_INCOMPATIBLE           = $80040405;
  {$EXTERNALSYM MS_E_INCOMPATIBLE}
  MS_E_BUSY                   = $80040406;
  {$EXTERNALSYM MS_E_BUSY}
  MS_E_NOTINIT                = $80040407;
  {$EXTERNALSYM MS_E_NOTINIT}
  MS_E_SOURCEALREADYDEFINED   = $80040408;
  {$EXTERNALSYM MS_E_SOURCEALREADYDEFINED}
  MS_E_INVALIDSTREAMTYPE      = $80040409;
  {$EXTERNALSYM MS_E_INVALIDSTREAMTYPE}
  MS_E_NOTRUNNING             = $8004040A;
  {$EXTERNALSYM MS_E_NOTRUNNING}

  MSPID_PrimaryVideo: TGUID = (D1:$A35FF56A;D2:$9FDA;D3:$11D0;D4:($8F,$DF,$00,$C0,$4F,$D9,$18,$9D));
  {$EXTERNALSYM MSPID_PrimaryVideo}
  MSPID_PrimaryAudio: TGUID = (D1:$A35FF56B;D2:$9FDA;D3:$11D0;D4:($8F,$DF,$00,$C0,$4F,$D9,$18,$9D));
  {$EXTERNALSYM MSPID_PrimaryAudio}

type
  PAPCFUNC = procedure(dwParam: DWORD); stdcall;
  {$EXTERNALSYM PAPCFUNC}

  STREAM_TIME = {$IFDEF TYPE_IDENTITY}type {$ENDIF} int64;
  {$EXTERNALSYM STREAM_TIME}

  PStreamType = ^TStreamType;
  STREAM_TYPE = (
    STREAMTYPE_READ,
    STREAMTYPE_WRITE,
    STREAMTYPE_TRANSFORM
  );
  {$EXTERNALSYM STREAM_TYPE}
  TStreamType = STREAM_TYPE;

  STREAM_STATE = (
    STREAMSTATE_STOP,
    STREAMSTATE_RUN
  );
  {$EXTERNALSYM STREAM_STATE}
  TStreamState = STREAM_STATE;

const
  COMPSTAT_NOUPDATEOK = 1;
  {$EXTERNALSYM COMPSTAT_NOUPDATEOK}
  COMPSTAT_WAIT       = 2;
  {$EXTERNALSYM COMPSTAT_WAIT}
  COMPSTAT_ABORT      = 4;
  {$EXTERNALSYM COMPSTAT_ABORT}

  MMSSF_HASCLOCK        = $1;
  {$EXTERNALSYM MMSSF_HASCLOCK}
  MMSSF_SUPPORTSEEK     = $2;
  {$EXTERNALSYM MMSSF_SUPPORTSEEK}
  MMSSF_ASYNCHRONOUS    = $4;
  {$EXTERNALSYM MMSSF_ASYNCHRONOUS}

  SSUPDATE_ASYNC = $1;
  {$EXTERNALSYM SSUPDATE_ASYNC}
  SSUPDATE_CONTINUOUS = $2;
  {$EXTERNALSYM SSUPDATE_CONTINUOUS}

type
  IMediaStream = interface;
  IStreamSample = interface;

  {$HPPEMIT 'typedef System::DelphiInterface<IMultiMediaStream> _di_IMultiMediaStream;'}
  {$EXTERNALSYM IMultiMediaStream}
  IMultiMediaStream = interface(IUnknown)
    ['{B502D1BC-9A57-11d0-8FDE-00C04FD9189D}']
    (*** IMultiMediaStream methods ***)
    function GetInformation(pdwFlags: PDWORD; pStreamType: PStreamType):
        HResult; stdcall;
    function GetMediaStream(const idPurpose: TGUID;
        out ppMediaStream: IMediaStream): HResult; stdcall;
    function EnumMediaStreams(Index: Longint; out ppMediaStream: IMediaStream):
        HResult; stdcall;
    function GetState(out pCurrentState: TStreamState): HResult; stdcall;
    function SetState(NewState: TStreamState): HResult; stdcall;
    function GetTime(out pCurrentTime: STREAM_TIME): HResult; stdcall;
    function GetDuration(out pDuration: STREAM_TIME): HResult; stdcall;
    function Seek(SeekTime: STREAM_TIME): HResult; stdcall;
    function GetEndOfStreamEventHandle(out phEOS: THandle): HResult; stdcall;
  end;

 
  {$HPPEMIT 'typedef System::DelphiInterface<IMediaStream> _di_IMediaStream;'}
  {$EXTERNALSYM IMediaStream}
  IMediaStream = interface(IUnknown)
    ['{B502D1BD-9A57-11d0-8FDE-00C04FD9189D}']
    (*** IMediaStream methods ***)
    function GetMultiMediaStream(out ppMultiMediaStream: IMultiMediaStream):
        HResult; stdcall;
    function GetInformation(pPurposeId: PGUID; pType: PStreamType): HResult; stdcall;
    function SetSameFormat(pStreamThatHasDesiredFormat: IMediaStream;
        dwFlags: DWORD): HResult; stdcall;
    function AllocateSample(dwFlags: DWORD; out ppSample: IStreamSample): HResult; stdcall;
    function CreateSharedSample(pExistingSample: IStreamSample; dwFlags: DWORD;
        out ppNewSample: IStreamSample): HResult; stdcall;
    function SendEndOfStream(dwFlags: DWORD): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IStreamSample> _di_IStreamSample;'}
  {$EXTERNALSYM IStreamSample}
  IStreamSample = interface(IUnknown)
    ['{B502D1BE-9A57-11d0-8FDE-00C04FD9189D}']
    (*** IStreamSample methods ***)
    function GetMediaStream(out ppMediaStream: IMediaStream): HResult; stdcall;
    function GetSampleTimes(out pStartTime, pEndTime,
        pCurrentTime: STREAM_TIME): HResult; stdcall;
    function SetSampleTimes(var pStartTime, pEndTime: STREAM_TIME): HResult; stdcall;
    function Update(dwFlags: DWORD; hEvent: THandle; pfnAPC: PAPCFUNC;
        dwAPCData: DWORD): HResult; stdcall;
    function CompletionStatus(dwFlags: DWORD; dwMilliseconds: DWORD): HResult; stdcall;
  end;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       amstream.h
 *
 ***************************************************************************)

const
  IID_IDirectShowStream: TGUID = '{7DB01C96-C0C3-11D0-8FF1-00C04FD9189D}';
  {$EXTERNALSYM IID_IDirectShowStream}
  IID_IAMMultiMediaStream: TGUID = '{BEBE595C-9A6F-11D0-8FDE-00C04FD9189D}';
  {$EXTERNALSYM IID_IAMMultiMediaStream}
  IID_IAMMediaStream: TGUID = '{BEBE595D-9A6F-11D0-8FDE-00C04FD9189D}';
  {$EXTERNALSYM IID_IAMMediaStream}
  IID_IMediaStreamFilter: TGUID = '{BEBE595E-9A6F-11D0-8FDE-00C04FD9189D}';
  {$EXTERNALSYM IID_IMediaStreamFilter}
  IID_IDirectDrawMediaSampleAllocator: TGUID = '{AB6B4AFC-F6E4-11D0-900D-00C04FD9189D}';
  {$EXTERNALSYM IID_IDirectDrawMediaSampleAllocator}
  IID_IDirectDrawMediaSample: TGUID = '{AB6B4AFE-F6E4-11D0-900D-00C04FD9189D}';
  {$EXTERNALSYM IID_IDirectDrawMediaSample}
  IID_IAMMediaTypeStream: TGUID = '{AB6B4AFA-F6E4-11D0-900D-00C04FD9189D}';
  {$EXTERNALSYM IID_IAMMediaTypeStream}
  IID_IAMMediaTypeSample: TGUID = '{AB6B4AFB-F6E4-11D0-900D-00C04FD9189D}';
  {$EXTERNALSYM IID_IAMMediaTypeSample}

const
  AMMSF_NOGRAPHTHREAD = $1;
  {$EXTERNALSYM AMMSF_NOGRAPHTHREAD}

  AMMSF_ADDDEFAULTRENDERER = $1;
  {$EXTERNALSYM AMMSF_ADDDEFAULTRENDERER}
  AMMSF_CREATEPEER         = $2;
  {$EXTERNALSYM AMMSF_CREATEPEER}
  AMMSF_STOPIFNOSAMPLES	   = $4;
  {$EXTERNALSYM AMMSF_STOPIFNOSAMPLES}
  AMMSF_NOSTALL	           = $8;
  {$EXTERNALSYM AMMSF_NOSTALL}

  AMMSF_RENDERTYPEMASK   = $3;
  {$EXTERNALSYM AMMSF_RENDERTYPEMASK}
  AMMSF_RENDERTOEXISTING = 0;
  {$EXTERNALSYM AMMSF_RENDERTOEXISTING}
  AMMSF_RENDERALLSTREAMS = $1;
  {$EXTERNALSYM AMMSF_RENDERALLSTREAMS}
  AMMSF_NORENDER         = $2;
  {$EXTERNALSYM AMMSF_NORENDER}
  AMMSF_NOCLOCK          = $4;
  {$EXTERNALSYM AMMSF_NOCLOCK}
  AMMSF_RUN              = $8;
  {$EXTERNALSYM AMMSF_RUN}

type
  OUTPUT_STATE = (
    Disabled,
    ReadData,
    RenderData
  );
  {$EXTERNALSYM OUTPUT_STATE}
  TOutputState = OUTPUT_STATE;

  {$HPPEMIT 'typedef System::DelphiInterface<IDirectShowStream> _di_IDirectShowStream;'}
  {$EXTERNALSYM IDirectShowStream}
  IDirectShowStream = interface(IDispatch)
    ['{7DB01C96-C0C3-11D0-8FF1-00C04FD9189D}']
    (*** IDirectShowStream methods ***)
    function get_FileName(out pVal: WideString): HResult; stdcall;
    function put_FileName(newVal: WideString): HResult; stdcall;
    function get_Video(out pVal: TOutputState): HResult; stdcall;
    function put_Video(newVal: TOutputState): HResult; stdcall;
    function get_Audio(out pVal: TOutputState): HResult; stdcall;
    function put_Audio(newVal: TOutputState): HResult; stdcall;
  end;

  IMediaStreamFilter = interface;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMMultiMediaStream> _di_IAMMultiMediaStream;'}
  {$EXTERNALSYM IAMMultiMediaStream}
  IAMMultiMediaStream = interface(IMultiMediaStream)
    ['{BEBE595C-9A6F-11D0-8FDE-00C04FD9189D}']
    (*** IAMMultiMediaStream methods ***)
    function Initialize(StreamType: TStreamType; dwFlags: DWORD;
        pFilterGraph: IGraphBuilder): HResult; stdcall;
    function GetFilterGraph(out ppGraphBuilder: IGraphBuilder): HResult; stdcall;
    function GetFilter(out ppFilter: IMediaStreamFilter): HResult; stdcall;
    function AddMediaStream(pStreamObject: IUnknown; PurposeId: PGUID;
        dwFlags: DWORD; out ppNewStream: IMediaStream): HResult; stdcall;
    function OpenFile(pszFileName: PWideChar; dwFlags: DWORD): HResult; stdcall;
    function OpenMoniker(pCtx: IBindCtx; pMoniker: IMoniker; dwFlags: DWORD): HResult; stdcall;
    function Render(dwFlags: DWORD): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMMediaStream> _di_IAMMediaStream;'}
  {$EXTERNALSYM IAMMediaStream}
  IAMMediaStream = interface(IMediaStream)
    ['{BEBE595D-9A6F-11D0-8FDE-00C04FD9189D}']
    (*** IAMMediaStream methods ***)
    function Initialize(pSourceObject: IUnknown; dwFlags: DWORD;
               PurposeId: PGUID; StreamType: TStreamType): HResult; stdcall;
    function SetState(State: TFilterState): HResult; stdcall;
    function JoinAMMultiMediaStream(pAMMultiMediaStream: IAMMultiMediaStream): HResult; stdcall;
    function JoinFilter(pMediaStreamFilter: IMediaStreamFilter): HResult; stdcall;
    function JoinFilterGraph(pFilterGraph: IFilterGraph): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaStreamFilter> _di_IMediaStreamFilter;'}
  {$EXTERNALSYM IMediaStreamFilter}
  IMediaStreamFilter = interface(IBaseFilter)
    ['{BEBE595E-9A6F-11D0-8FDE-00C04FD9189D}']
    (*** IMediaStreamFilter methods ***)
    function AddMediaStream(pAMMediaStream: IAMMediaStream): HResult; stdcall;
    function GetMediaStream( var idPurpose: TGUID;
        out ppMediaStream: IMediaStream): HResult; stdcall;
    function EnumMediaStreams(Index: Longint; out ppMediaStream: IMediaStream): HResult; stdcall;
    function SupportSeeking(bRenderer: BOOL): HResult; stdcall;
    function ReferenceTimeToStreamTime( var pTime: TReferenceTime): HResult; stdcall;
    function GetCurrentStreamTime(out pCurrentStreamTime: TReferenceTime): HResult; stdcall;
    function WaitUntil(WaitStreamTime: TReferenceTime): HResult; stdcall;
    function Flush(bCancelEOS: BOOL): HResult; stdcall;
    function EndOfStream: HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDirectDrawMediaSampleAllocator> _di_IDirectDrawMediaSampleAllocator;'}
  {$EXTERNALSYM IDirectDrawMediaSampleAllocator}
  IDirectDrawMediaSampleAllocator = interface(IUnknown)
    ['{AB6B4AFC-F6E4-11D0-900D-00C04FD9189D}']
    (*** IDirectDrawMediaSampleAllocator methods ***)
    function GetDirectDraw(out ppDirectDraw: IDirectDraw): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDirectDrawMediaSample> _di_IDirectDrawMediaSample;'}
  {$EXTERNALSYM IDirectDrawMediaSample}
  IDirectDrawMediaSample = interface(IUnknown)
    ['{AB6B4AFE-F6E4-11D0-900D-00C04FD9189D}']
    (*** IDirectDrawMediaSample methods ***)
    function GetSurfaceAndReleaseLock(out ppDirectDrawSurface: IDirectDrawSurface;
        out pRect: TRect): HResult; stdcall;
    function LockMediaSamplePointer: HResult; stdcall;
  end;

  IAMMediaTypeSample = interface;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMMediaTypeStream> _di_IAMMediaTypeStream;'}
  {$EXTERNALSYM IAMMediaTypeStream}
  IAMMediaTypeStream = interface(IMediaStream)
    ['{AB6B4AFA-F6E4-11D0-900D-00C04FD9189D}']
    (*** IAMMediaTypeStream methods ***)
    function GetFormat(out pMediaType: TAMMediaType; dwFlags: DWORD): HResult; stdcall;
    function SetFormat(const pMediaType: TAMMediaType; dwFlags: DWORD): HResult; stdcall;
    function CreateSample(lSampleSize: Longint; pbBuffer: Pointer;
        dwFlags: DWORD; pUnkOuter: IUnknown; out ppAMMediaTypeSample: IAMMediaTypeSample): HResult; stdcall;
    function GetStreamAllocatorRequirements(var pProps: TAllocatorProperties): HResult; stdcall;
    function SetStreamAllocatorRequirements(const pProps: TAllocatorProperties): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMMediaTypeSample> _di_IAMMediaTypeSample;'}
  {$EXTERNALSYM IAMMediaTypeSample}
  IAMMediaTypeSample = interface(IStreamSample)
    ['{AB6B4AFB-F6E4-11D0-900D-00C04FD9189D}']
    (*** IAMMediaTypeSample methods ***)
    function SetPointer(pBuffer: Pointer; lSize: Longint): HResult; stdcall;
    function GetPointer(out ppBuffer: Pointer): HResult; stdcall;
    function GetSize: Longint; stdcall;
    function GetTime(out pTimeStart, pTimeEnd: TReferenceTime): HResult; stdcall;
    function SetTime(pTimeStart, pTimeEnd: PReferenceTime): HResult; stdcall;
    function IsSyncPoint: HResult; stdcall;
    function SetSyncPoint(bIsSyncPoint: BOOL): HResult; stdcall;
    function IsPreroll: HResult; stdcall;
    function SetPreroll(bIsPreroll: BOOL): HResult; stdcall;
    function GetActualDataLength: Longint; stdcall;
    function SetActualDataLength(l: Longint): HResult; stdcall;
    function GetMediaType(var ppMediaType: PAMMediaType): HResult; stdcall;
    function SetMediaType(var pMediaType: TAMMediaType): HResult; stdcall;
    function IsDiscontinuity: HResult; stdcall;
    function SetDiscontinuity(bDiscontinuity: BOOL): HResult; stdcall;
    function GetMediaTime(out pTimeStart, pTimeEnd: int64): HResult; stdcall;
    function SetMediaTime(var pTimeStart, pTimeEnd: int64): HResult; stdcall;
  end;

const
{
EXTERN_C const IID LIBID_DirectShowStreamLib;

EXTERN_C const CLSID CLSID_AMMultiMediaStream;
}
  CLSID_AMMultiMediaStream: TGUID = '{49C47CE5-9BA4-11D0-8212-00C04FC32C45}';
  {$EXTERNALSYM CLSID_AMMultiMediaStream}

  CLSID_AMDirectDrawStream: TGUID = (D1:$49C47CE4;D2:$9BA4;D3:$11D0;D4:($82,$12,$00,$C0,$4F,$C3,$2C,$45));
  {$EXTERNALSYM CLSID_AMDirectDrawStream}
  CLSID_AMAudioStream: TGUID = (D1:$8496E040;D2:$AF4C;D3:$11D0;D4:($82,$12,$00,$C0,$4F,$C3,$2C,$45));
  {$EXTERNALSYM CLSID_AMAudioStream}
  CLSID_AMAudioData: TGUID = (D1:$F2468580;D2:$AF8A;D3:$11D0;D4:($82,$12,$00,$C0,$4F,$C3,$2C,$45));
  {$EXTERNALSYM CLSID_AMAudioData}
  CLSID_AMMediaTypeStream: TGUID = (D1:$CF0F2F7C;D2:$F7BF;D3:$11D0;D4:($90,$0D,$00,$C0,$4F,$D9,$18,$9D));
  {$EXTERNALSYM CLSID_AMMediaTypeStream}

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       ddstream.h
 *
 ***************************************************************************)

const
  DDSFF_PROGRESSIVERENDER = $1;
  {$EXTERNALSYM DDSFF_PROGRESSIVERENDER}

  IID_IDirectDrawMediaStream: TGUID = '{F4104FCE-9A70-11d0-8FDE-00C04FD9189D}';
  {$EXTERNALSYM IID_IDirectDrawMediaStream}
  IID_IDirectDrawStreamSample: TGUID = '{F4104FCF-9A70-11d0-8FDE-00C04FD9189D}';
  {$EXTERNALSYM IID_IDirectDrawStreamSample}

type
  IDirectDrawStreamSample = interface;

  {$HPPEMIT 'typedef System::DelphiInterface<IDirectDrawMediaStream> _di_IDirectDrawMediaStream;'}
  {$EXTERNALSYM IDirectDrawMediaStream}
  IDirectDrawMediaStream = interface(IMediaStream)
    ['{F4104FCE-9A70-11d0-8FDE-00C04FD9189D}']
    (*** IDirectDrawMediaStream methods ***)
    function GetFormat(out pDDSDCurrent: TDDSurfaceDesc;
        out ppDirectDrawPalette: IDirectDrawPalette;
        out pDDSDDesired: TDDSurfaceDesc; out pdwFlags: DWORD): HResult; stdcall;
    function SetFormat(const pTDDSurfaceDesc: TDDSurfaceDesc;
        pDirectDrawPalette: IDirectDrawPalette): HResult; stdcall;
    function GetDirectDraw(out ppDirectDraw: IDirectDraw): HResult; stdcall;
    function SetDirectDraw(pDirectDraw: IDirectDraw): HResult; stdcall;
    function CreateSample(pSurface: IDirectDrawSurface; const pRect: TRect;
        dwFlags: DWORD; out ppSample: IDirectDrawStreamSample): HResult;
        stdcall;
    function GetTimePerFrame(var pFrameTime: STREAM_TIME): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDirectDrawStreamSample> _di_IDirectDrawStreamSample;'}
  {$EXTERNALSYM IDirectDrawStreamSample}
  IDirectDrawStreamSample = interface(IStreamSample)
    ['{F4104FCF-9A70-11d0-8FDE-00C04FD9189D}']
    (*** IDirectDrawStreamSample methods ***)
    function GetSurface(out ppDirectDrawSurface: IDirectDrawSurface;
        out pRect: TRect): HResult; stdcall;
    function SetRect(const pRect: TRect): HResult; stdcall;
  end;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       austream.h
 *
 ***************************************************************************)

const
  IID_IAudioMediaStream: TGUID = '{F7537560-A3BE-11D0-8212-00C04FC32C45}';
  {$EXTERNALSYM IID_IAudioMediaStream}
  IID_IAudioStreamSample: TGUID = '{345FEE00-ABA5-11D0-8212-00C04FC32C45}';
  {$EXTERNALSYM IID_IAudioStreamSample}
  IID_IMemoryData: TGUID = '{327FC560-AF60-11D0-8212-00C04FC32C45}';
  {$EXTERNALSYM IID_IMemoryData}
  IID_IAudioData: TGUID = '{54C719C0-AF60-11D0-8212-00C04FC32C45}';
  {$EXTERNALSYM IID_IAudioData}

type
  IAudioStreamSample = interface;
  IAudioData = interface;

  {$HPPEMIT 'typedef System::DelphiInterface<IAudioMediaStream> _di_IAudioMediaStream;'}
  {$EXTERNALSYM IAudioMediaStream}
  IAudioMediaStream = interface(IMediaStream)
    ['{F7537560-A3BE-11D0-8212-00C04FC32C45}']
    (*** IAudioMediaStream methods ***)
    function GetFormat(out pWaveFormatCurrent: TWaveFormatEx): HResult; stdcall;
    function SetFormat(const lpWaveFormat: TWaveFormatEx): HResult; stdcall;
    function CreateSample(pAudioData: IAudioData; dwFlags: DWORD;
        out ppSample: IAudioStreamSample): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAudioStreamSample> _di_IAudioStreamSample;'}
  {$EXTERNALSYM IAudioStreamSample}
  IAudioStreamSample = interface(IStreamSample)
    ['{345FEE00-ABA5-11D0-8212-00C04FC32C45}']
    (*** IAudioStreamSample methods ***)
    function GetAudioData(out ppAudio: IAudioData): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMemoryData> _di_IMemoryData;'}
  {$EXTERNALSYM IMemoryData}
  IMemoryData = interface(IUnknown)
    ['{327FC560-AF60-11D0-8212-00C04FC32C45}']
    (*** IMemoryData methods ***)
    function SetBuffer(cbSize: DWORD; pbData: pointer; dwFlags: DWORD): HResult;
        stdcall;
    function GetInfo(out pdwLength: DWORD; out ppbData: pointer;
        out pcbActualData: DWORD): HResult; stdcall;
    function SetActual(cbDataValid: DWORD): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAudioData> _di_IAudioData;'}
  {$EXTERNALSYM IAudioData}
  IAudioData = interface(IMemoryData)
    ['{54C719C0-AF60-11D0-8212-00C04FC32C45}']
    (*** IAudioData methods ***)
    function GetFormat(out pWaveFormatCurrent: TWaveFormatEx): HResult; stdcall;
    function SetFormat(const lpWaveFormat: TWaveFormatEx): HResult; stdcall;
  end;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       mpconfig.h
 *
 ***************************************************************************)

const
  IID_IMixerPinConfig : TGUID = (D1:$593CDDE1;D2:$0759;D3:$11D1;D4:($9E,$69,$00,$C0,$4F,$D7,$C1,$5B));
  {$EXTERNALSYM IID_IMixerPinConfig}
  IID_IMixerPinConfig2: TGUID = (D1:$ebf47182;D2:$8764;D3:$11d1;D4:($9e,$69,$00,$c0,$4f,$d7,$c1,$5b));
  {$EXTERNALSYM IID_IMixerPinConfig2}

type
  _AM_ASPECT_RATIO_MODE = (
    AM_ARMODE_STRETCHED,        // don't do any aspect ratio correction
    AM_ARMODE_LETTER_BOX,       // letter box the video, paint background color in the excess region
    AM_ARMODE_CROP,             // crop the video to the right aspect ratio
    AM_ARMODE_STRETCHED_AS_PRIMARY
  );
  {$EXTERNALSYM _AM_ASPECT_RATIO_MODE}
  AM_ASPECT_RATIO_MODE = _AM_ASPECT_RATIO_MODE;
  {$EXTERNALSYM AM_ASPECT_RATIO_MODE}
  TAMAspectRatioMode = AM_ASPECT_RATIO_MODE;

  {$HPPEMIT 'typedef System::DelphiInterface<IMixerPinConfig> _di_IMixerPinConfig;'}
  {$EXTERNALSYM IMixerPinConfig}
  IMixerPinConfig = interface(IUnknown)
    ['{593CDDE1-0759-11D1-9E69-00C04FD7C15B}']
    (*** IMixerPinConfig methods ***)
    function SetRelativePosition(dwLeft, dwTop, dwRight, dwBottom: DWORD): HResult; stdcall;
    function GetRelativePosition(out dwLeft, dwTop, dwRight, dwBottom: DWORD): HResult; stdcall;
    function SetZOrder(dwZOrder: DWORD): HResult; stdcall;
    function GetZOrder(out dwZOrder: DWORD): HResult; stdcall;
    function SetColorKey(var pColorKey: TColorKey): HResult; stdcall;
    function GetColorKey(out pColorKey: TColorKey; out pColor: DWORD): HResult; stdcall;
    function SetBlendingParameter(dwBlendingParameter: DWORD): HResult; stdcall;
    function GetBlendingParameter(out dwBlendingParameter: DWORD): HResult; stdcall;
    function SetAspectRatioMode(amAspectRatioMode: TAMAspectRatioMode): HResult; stdcall;
    function GetAspectRatioMode(out amAspectRatioMode: TAMAspectRatioMode): HResult; stdcall;
    function SetStreamTransparent(bStreamTransparent: BOOL): HResult; stdcall;
    function GetStreamTransparent(out bStreamTransparent: BOOL): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMixerPinConfig2> _di_IMixerPinConfig2;'}
  {$EXTERNALSYM IMixerPinConfig2}
  IMixerPinConfig2 = interface(IMixerPinConfig)
    ['{EBF47182-8764-11d1-9E69-00C04FD7C15B}']
    (*** IMixerPinConfig2 methods ***)
    function SetOverlaySurfaceColorControls(pColorControl: PDDColorControl): HResult; stdcall;
    function GetOverlaySurfaceColorControls(out pColorControl: TDDColorControl): HResult; stdcall;
  end;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       control.h
 *
 ***************************************************************************)

const
  LIBID_QuartzTypeLib: TGUID = (D1:$56A868B0;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM LIBID_QuartzTypeLib}

  IID_IAMCollection: TGUID = (D1:$56A868B9;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IAMCollection}
  IID_IMediaControl: TGUID = (D1:$56A868B1;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IMediaControl}
  IID_IMediaEvent: TGUID = (D1:$56A868B6;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IMediaEvent}
  IID_IMediaEventEx: TGUID = (D1:$56A868C0;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IMediaEventEx}
  IID_IMediaPosition: TGUID = (D1:$56A868B2;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IMediaPosition}
  IID_IBasicAudio: TGUID = (D1:$56A868B3;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IBasicAudio}
  IID_IVideoWindow: TGUID = (D1:$56A868B4;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IVideoWindow}
  IID_IBasicVideo: TGUID = (D1:$56A868B5;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IBasicVideo}
  IID_IBasicVideo2: TGUID = (D1:$329bb360;D2:$f6ea;D3:$11d1;D4:($90,$38,$00,$a0,$c9,$69,$72,$98));
  {$EXTERNALSYM IID_IBasicVideo2}
  IID_IDeferredCommand: TGUID = (D1:$56A868B8;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IDeferredCommand}
  IID_IQueueCommand: TGUID = (D1:$56A868B7;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IQueueCommand}

  CLSID_FilgraphManager: TGUID = (D1:$E436EBB3;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM CLSID_FilgraphManager}

  IID_IFilterInfo: TGUID = (D1:$56A868BA;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IFilterInfo}
  IID_IRegFilterInfo: TGUID = (D1:$56A868BB;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IRegFilterInfo}
  IID_IMediaTypeInfo: TGUID = (D1:$56A868BC;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IMediaTypeInfo}
  IID_IPinInfo: TGUID = (D1:$56A868BD;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IPinInfo}
  IID_IAMStats: TGUID = (D1:$bc9bcf80;D2:$dcd2;D3:$11d2;D4:($ab,$f6,$00,$a0,$c9,$05,$f3,$75));
  {$EXTERNALSYM IID_IAMStats}
type
  OAEVENT = {$IFDEF TYPE_IDENTITY}type {$ENDIF} Longint;
  {$EXTERNALSYM OAEVENT}
  OAHWND = {$IFDEF TYPE_IDENTITY}type {$ENDIF} Longint;
  {$EXTERNALSYM OAHWND}
  OAFilterState = {$IFDEF TYPE_IDENTITY}type {$ENDIF} Longint;
  {$EXTERNALSYM OAFilterState}

  {$HPPEMIT 'typedef System::DelphiInterface<IAMCollection> _di_IAMCollection;'}
  {$EXTERNALSYM IAMCollection}
  IAMCollection = interface(IDispatch)
    ['{56A868B9-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IAMCollection methods ***)
    function get_Count(out plCount: Longint): HResult; stdcall;
    function Item(lItem: Longint; out ppUnk: IUnknown): HResult; stdcall;
    function get__NewEnum(out ppUnk: IUnknown): HResult; stdcall;

  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaControl> _di_IMediaControl;'}
  {$EXTERNALSYM IMediaControl}
  IMediaControl = interface(IDispatch)
    ['{56A868B1-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IMediaControl methods ***)
    function Run: HResult; stdcall;
    function Pause: HResult; stdcall;
    function Stop: HResult; stdcall;
    function GetState(msTimeout: DWORD; out pfs: TFilterState): HResult; stdcall;
    function RenderFile(strFilename: WideString): HResult; stdcall;
    function AddSourceFilter(strFilename: WideString; out ppUnk: IDispatch): HResult; stdcall;
    function get_FilterCollection(out ppUnk: IDispatch): HResult; stdcall;
    function get_RegFilterCollection(out ppUnk: IDispatch): HResult; stdcall;
    function StopWhenReady: HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaEvent> _di_IMediaEvent;'}
  {$EXTERNALSYM IMediaEvent}
  IMediaEvent = interface(IDispatch)
    ['{56A868B6-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IMediaEvent methods ***)
    function GetEventHandle(out hEvent: OAEVENT): HResult; stdcall;
    function GetEvent(out lEventCode: Longint; out lParam1, lParam2: Longint;
        msTimeout: DWORD): HResult; stdcall;
    function WaitForCompletion(msTimeout: DWORD; out pEvCode: Longint):
        HResult; stdcall;
    function CancelDefaultHandling(lEvCode: Longint): HResult; stdcall;
    function RestoreDefaultHandling(lEvCode: Longint): HResult; stdcall;
    function FreeEventParams(lEvCode: Longint; lParam1, lParam2: Longint):
        HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaEventEx> _di_IMediaEventEx;'}
  {$EXTERNALSYM IMediaEventEx}
  IMediaEventEx = interface(IMediaEvent)
    ['{56A868C0-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IMediaEventEx methods ***)
    function SetNotifyWindow(hwnd: OAHWND; lMsg: Longint;
        lInstanceData: Longint): HResult; stdcall;
    function SetNotifyFlags(lNoNotifyFlags: Longint): HResult; stdcall;
    function GetNotifyFlags(out lplNoNotifyFlags): HResult; stdcall; //longint
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaPosition> _di_IMediaPosition;'}
  {$EXTERNALSYM IMediaPosition}
  IMediaPosition = interface(IDispatch)
    ['{56A868B2-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IMediaPosition methods ***)
    function get_Duration(out plength: TRefTime): HResult; stdcall;
    function put_CurrentPosition(llTime: TRefTime): HResult; stdcall;
    function get_CurrentPosition(out pllTime: TRefTime): HResult; stdcall;
    function get_StopTime(out pllTime: TRefTime): HResult; stdcall;
    function put_StopTime(llTime: TRefTime): HResult; stdcall;
    function get_PrerollTime(out pllTime: TRefTime): HResult; stdcall;
    function put_PrerollTime(llTime: TRefTime): HResult; stdcall;
    function put_Rate(dRate: double): HResult; stdcall;
    function get_Rate(out pdRate: double): HResult; stdcall;
    function CanSeekForward(out pCanSeekForward: Longint): HResult; stdcall;
    function CanSeekBackward(out pCanSeekBackward: Longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IBasicAudio> _di_IBasicAudio;'}
  {$EXTERNALSYM IBasicAudio}
  IBasicAudio = interface(IDispatch)
    ['{56A868B3-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IBasicAudio methods ***)
    function put_Volume(lVolume: Longint): HResult; stdcall;
    function get_Volume(out plVolume: Longint): HResult; stdcall;
    function put_Balance(lBalance: Longint): HResult; stdcall;
    function get_Balance(out plBalance: Longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IVideoWindow> _di_IVideoWindow;'}
  {$EXTERNALSYM IVideoWindow}
  IVideoWindow = interface(IDispatch)
    ['{56A868B4-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IVideoWindow methods ***)
    function put_Caption(strCaption: WideString): HResult; stdcall;
    function get_Caption(out strCaption: WideString): HResult; stdcall;
    function put_WindowStyle(WindowStyle: Longint): HResult; stdcall;
    function get_WindowStyle(out WindowStyle: Longint): HResult; stdcall;
    function put_WindowStyleEx(WindowStyleEx: Longint): HResult; stdcall;
    function get_WindowStyleEx(out WindowStyleEx: Longint): HResult; stdcall;
    function put_AutoShow(AutoShow: LongBool): HResult; stdcall;
    function get_AutoShow(out AutoShow: LongBool): HResult; stdcall;
    function put_WindowState(WindowState: Longint): HResult; stdcall;
    function get_WindowState(out WindowState: Longint): HResult; stdcall;
    function put_BackgroundPalette(BackgroundPalette: Longint): HResult; stdcall;
    function get_BackgroundPalette(out pBackgroundPalette: Longint): HResult; stdcall;
    function put_Visible(Visible: LongBool): HResult; stdcall;
    function get_Visible(out pVisible: LongBool): HResult; stdcall;
    function put_Left(Left: Longint): HResult; stdcall;
    function get_Left(out pLeft: Longint): HResult; stdcall;
    function put_Width(Width: Longint): HResult; stdcall;
    function get_Width(out pWidth: Longint): HResult; stdcall;
    function put_Top(Top: Longint): HResult; stdcall;
    function get_Top(out pTop: Longint): HResult; stdcall;
    function put_Height(Height: Longint): HResult; stdcall;
    function get_Height(out pHeight: Longint): HResult; stdcall;
    function put_Owner(Owner: OAHWND): HResult; stdcall;
    function get_Owner(out Owner: OAHWND): HResult; stdcall;
    function put_MessageDrain(Drain: OAHWND): HResult; stdcall;
    function get_MessageDrain(out Drain: OAHWND): HResult; stdcall;
    function get_BorderColor(out Color: Longint): HResult; stdcall;
    function put_BorderColor(Color: Longint): HResult; stdcall;
    function get_FullScreenMode(out FullScreenMode: LongBool): HResult; stdcall;
    function put_FullScreenMode(FullScreenMode: LongBool): HResult; stdcall;
    function SetWindowForeground(Focus: Longint): HResult; stdcall;
    function NotifyOwnerMessage(hwnd: Longint; uMsg, wParam, lParam: Longint): HResult; stdcall;
    function SetWindowPosition(Left, Top, Width, Height: Longint): HResult; stdcall;
    function GetWindowPosition(out pLeft, pTop, pWidth, pHeight: Longint): HResult; stdcall;
    function GetMinIdealImageSize(out pWidth, pHeight: Longint): HResult; stdcall;
    function GetMaxIdealImageSize(out pWidth, pHeight: Longint): HResult; stdcall;
    function GetRestorePosition(out pLeft, pTop, pWidth, pHeight: Longint): HResult; stdcall;
    function HideCursor(HideCursor: LongBool): HResult; stdcall;
    function IsCursorHidden(out CursorHidden: LongBool): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IBasicVideo> _di_IBasicVideo;'}
  {$EXTERNALSYM IBasicVideo}
  IBasicVideo = interface(IDispatch)
    ['{56A868B5-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IBasicVideo methods ***)
    function get_AvgTimePerFrame(out pAvgTimePerFrame: TRefTime): HResult; stdcall;
    function get_BitRate(out pBitRate: Longint): HResult; stdcall;
    function get_BitErrorRate(out pBitErrorRate: Longint): HResult; stdcall;
    function get_VideoWidth(out pVideoWidth: Longint): HResult; stdcall;
    function get_VideoHeight(out pVideoHeight: Longint): HResult; stdcall;
    function put_SourceLeft(SourceLeft: Longint): HResult; stdcall;
    function get_SourceLeft(out pSourceLeft: Longint): HResult; stdcall;
    function put_SourceWidth(SourceWidth: Longint): HResult; stdcall;
    function get_SourceWidth(out pSourceWidth: Longint): HResult; stdcall;
    function put_SourceTop(SourceTop: Longint): HResult; stdcall;
    function get_SourceTop(out pSourceTop: Longint): HResult; stdcall;
    function put_SourceHeight(SourceHeight: Longint): HResult; stdcall;
    function get_SourceHeight(out pSourceHeight: Longint): HResult; stdcall;
    function put_DestinationLeft(DestinationLeft: Longint): HResult; stdcall;
    function get_DestinationLeft(out pDestinationLeft: Longint): HResult; stdcall;
    function put_DestinationWidth(DestinationWidth: Longint): HResult; stdcall;
    function get_DestinationWidth(out pDestinationWidth: Longint): HResult; stdcall;
    function put_DestinationTop(DestinationTop: Longint): HResult; stdcall;
    function get_DestinationTop(out pDestinationTop: Longint): HResult; stdcall;
    function put_DestinationHeight(DestinationHeight: Longint): HResult; stdcall;
    function get_DestinationHeight(out pDestinationHeight: Longint): HResult; stdcall;
    function SetSourcePosition(Left, Top, Width, Height: Longint): HResult; stdcall;
    function GetSourcePosition(out pLeft, pTop, pWidth, pHeight: Longint): HResult; stdcall;
    function SetDefaultSourcePosition: HResult; stdcall;
    function SetDestinationPosition(Left, Top, Width, Height: Longint): HResult; stdcall;
    function GetDestinationPosition(out pLeft, pTop, pWidth, pHeight: Longint): HResult; stdcall;
    function SetDefaultDestinationPosition: HResult; stdcall;
    function GetVideoSize(out pWidth, Height: Longint): HResult; stdcall;
    function GetVideoPaletteEntries(StartIndex, Entries: Longint;
        out pRetrieved: Longint; out pPalette): HResult; stdcall;
    function GetCurrentImage(var BufferSize: Longint; var pDIBImage): HResult; stdcall;
    function IsUsingDefaultSource: HResult; stdcall;
    function IsUsingDefaultDestination: HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IBasicVideo2> _di_IBasicVideo2;'}
  {$EXTERNALSYM IBasicVideo2}
  IBasicVideo2 = interface(IBasicVideo)
    ['{329bb360-f6ea-11d1-9038-00a0c9697298}']
    (*** IBasicVideo2 methods ***)
    function GetPreferredAspectRatio(out plAspectX, plAspectY: Longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDeferredCommand> _di_IDeferredCommand;'}
  {$EXTERNALSYM IDeferredCommand}
  IDeferredCommand = interface(IDispatch)
    ['{56A868B8-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IDeferredCommand methods ***)
    function Cancel: HResult; stdcall;
    function Confidence(out pConfidence: Longint): HResult; stdcall;
    function Postpone(newtime: TRefTime): HResult; stdcall;
    function GetHResult(out phrResult: HResult): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IQueueCommand> _di_IQueueCommand;'}
  {$EXTERNALSYM IQueueCommand}
  IQueueCommand = interface(IUnknown)
    ['{56A868B7-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IQueueCommand methods ***)
    function InvokeAtStreamTime(out pCmd: IDeferredCommand; time: TRefTime;
        const iid: TGUID; dispidMethod: Longint; wFlags: SmallInt;
        cArgs: Longint; const pDispParams: OleVariant; var pvarResult: OleVariant;
        out puArgErr: SmallInt):  HResult; stdcall;
    function InvokeAtPresentationTime(out pCmd: IDeferredCommand;
        time: TRefTime; const iid: TGUID; dispidMethod: Longint;
        wFlags: SmallInt; cArgs: Longint; const pDispParams: OleVariant;
        var pvarResult: OleVariant; out puArgErr: SmallInt): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IFilterInfo> _di_IFilterInfo;'}
  {$EXTERNALSYM IFilterInfo}
  IFilterInfo = interface(IDispatch)
    ['{56A868BA-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IFilterInfo methods ***)
    function FindPin(strPinID: WideString; out ppUnk: IDispatch): HResult; stdcall;
    function get_Name(out strName: WideString): HResult; stdcall;
    function get_VendorInfo(out strVendorInfo: WideString): HResult; stdcall;
    function get_Filter(out ppUnk: IUnknown): HResult; stdcall;
    function get_Pins(out ppUnk: IDispatch): HResult; stdcall;
    function get_IsFileSource(out pbIsSource: LongBool): HResult; stdcall;
    function get_Filename(out pstrFilename: WideString): HResult; stdcall;
    function put_Filename(strFilename: WideString): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IRegFilterInfo> _di_IRegFilterInfo;'}
  {$EXTERNALSYM IRegFilterInfo}
  IRegFilterInfo = interface(IDispatch)
    ['{56A868BB-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IRegFilterInfo methods ***)
    function get_Name(out strName: WideString): HResult; stdcall;
    function Filter(out ppUnk: IDispatch): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaTypeInfo> _di_IMediaTypeInfo;'}
  {$EXTERNALSYM IMediaTypeInfo}
  IMediaTypeInfo = interface(IDispatch)
    ['{56A868BC-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IMediaTypeInfo methods ***)
    function Get_Type(out strType: WideString): HResult; stdcall;
    function Get_Subtype(out strType: WideString): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IPinInfo> _di_IPinInfo;'}
  {$EXTERNALSYM IPinInfo}
  IPinInfo = interface(IDispatch)
    ['{56A868BD-0AD4-11CE-B03A-0020AF0BA770}']
    (*** IPinInfo methods ***)
    function get_Pin(out ppUnk: IUnknown): HResult; stdcall;
    function get_ConnectedTo(out ppUnk: IDispatch): HResult; stdcall;
    function get_ConnectionMediaType(out ppUnk: IDispatch): HResult; stdcall;
    function get_FilterInfo(out ppUnk: IDispatch): HResult; stdcall;
    function get_Name(out ppUnk: WideString): HResult; stdcall;
    function get_Direction(out ppDirection: Longint): HResult; stdcall;
    function get_PinID(out strPinID: WideString): HResult; stdcall;
    function get_MediaTypes(out ppUnk: IDispatch): HResult; stdcall;
    function Connect(pPin: IUnknown): HResult; stdcall;
    function ConnectDirect(pPin: IUnknown): HResult; stdcall;
    function ConnectWithType(pPin: IUnknown; pMediaType: IDispatch): HResult; stdcall;
    function Disconnect: HResult; stdcall;
    function Render: HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMStats> _di_IAMStats;'}
  {$EXTERNALSYM IAMStats}
  IAMStats = interface(IDispatch)
    ['{bc9bcf80-dcd2-11d2-abf6-00a0c905f375}']
    (*** IAMStats methods ***)
    function Reset: HResult; stdcall;
    function get_Count(out plCount: Longint): HResult; stdcall;
    function GetValueByIndex(lIndex: longint; out szName: WideString; out lCount: longint;
             out dLast, dAverage, dStdDev, dMin, dMax: double): HResult; stdcall;
    function GetValueByName(szName: WideString; out lIndex, lCount: Longint;
             out dLast, dAverage, dStdDev, dMin, dMax: double): HResult; stdcall;
    function GetIndex(szName: WideString; lCreate: longint; out plIndex: longint): HResult; stdcall;
    function AddValue(lIndex: longint; dValue: double): HResult; stdcall;
  end;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       qnetwork.h
 *
 ***************************************************************************)

const
  LIBID_QuartzNetTypeLib: TGUID = (D1:$56A868B1;D2:$0AD4;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM LIBID_QuartzNetTypeLib}

  IID_IAMNetShowConfig: TGUID = (D1:$FA2AA8F1;D2:$8B62;D3:$11D0;D4:($A5,$20,$00,$00,$00,$00,$00,$00));
  {$EXTERNALSYM IID_IAMNetShowConfig}
  IID_IAMChannelInfo: TGUID = (D1:$FA2AA8F2;D2:$8B62;D3:$11D0;D4:($A5,$20,$00,$00,$00,$00,$00,$00));
  {$EXTERNALSYM IID_IAMChannelInfo}
  IID_IAMNetworkStatus: TGUID = (D1:$FA2AA8F3;D2:$8B62;D3:$11D0;D4:($A5,$20,$00,$00,$00,$00,$00,$00));
  {$EXTERNALSYM IID_IAMNetworkStatus}
  IID_IAMExtendedSeeking: TGUID = (D1:$FA2AA8F9;D2:$8B62;D3:$11D0;D4:($A5,$20,$00,$00,$00,$00,$00,$00));
  {$EXTERNALSYM IID_IAMExtendedSeeking}
  IID_IAMNetShowExProps: TGUID = (D1:$FA2AA8F5;D2:$8B62;D3:$11D0;D4:($A5,$20,$00,$00,$00,$00,$00,$00));
  {$EXTERNALSYM IID_IAMNetShowExProps}
  IID_IAMExtendedErrorInfo: TGUID = (D1:$FA2AA8F6;D2:$8B62;D3:$11D0;D4:($A5,$20,$00,$00,$00,$00,$00,$00));
  {$EXTERNALSYM IID_IAMExtendedErrorInfo}
  IID_IAMMediaContent: TGUID = (D1:$FA2AA8F4;D2:$8B62;D3:$11D0;D4:($A5,$20,$00,$00,$00,$00,$00,$00));
  {$EXTERNALSYM IID_IAMMediaContent}
  IID_IAMMediaContent2 : TGUID = (D1:$CE8F78C1;D2:$74D9;D3:$11D2;D4:($B0,$9D,$00,$A0,$C9,$A8,$11,$17));
  {$EXTERNALSYM IID_IAMMediaContent2}
  IID_IAMNetShowPreroll: TGUID = (D1:$AAE7E4E2;D2:$6388;D3:$11D1;D4:($8D,$93,$00,$60,$97,$C9,$A2,$B2));
  {$EXTERNALSYM IID_IAMNetShowPreroll}
  IID_IDShowPlugin     : TGUID = (D1:$4746B7C8;D2:$700E;D3:$11D1;D4:($BE,$CC,$00,$C0,$4F,$B6,$E9,$37));
  {$EXTERNALSYM IID_IDShowPlugin}

//AMExtendedSeekingCapabilities
const
  AM_EXSEEK_CANSEEK               = 1;
  {$EXTERNALSYM AM_EXSEEK_CANSEEK}
  AM_EXSEEK_CANSCAN               = 2;
  {$EXTERNALSYM AM_EXSEEK_CANSCAN}
  AM_EXSEEK_MARKERSEEK            = 4;
  {$EXTERNALSYM AM_EXSEEK_MARKERSEEK}
  AM_EXSEEK_SCANWITHOUTCLOCK      = 8;
  {$EXTERNALSYM AM_EXSEEK_SCANWITHOUTCLOCK}
  AM_EXSEEK_NOSTANDARDREPAINT     = 16;
  {$EXTERNALSYM AM_EXSEEK_NOSTANDARDREPAINT}
  AM_EXSEEK_BUFFERING             = 32;
  {$EXTERNALSYM AM_EXSEEK_BUFFERING}
  AM_EXSEEK_SENDS_VIDEOFRAMEREADY = 64;
  {$EXTERNALSYM AM_EXSEEK_SENDS_VIDEOFRAMEREADY}

type
  DATE = record
    da_year: Integer;   // Year - 1980
    da_day : Byte;       // Day of the month
    da_mon : Byte;       // Month (1 = Jan)
  end;
  {$EXTERNALSYM DATE}
  //TDate = DATE;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMNetShowConfig> _di_IAMNetShowConfig;'}
  {$EXTERNALSYM IAMNetShowConfig}
  IAMNetShowConfig = interface(IDispatch)
    ['{FA2AA8F1-8B62-11D0-A520-000000000000}']
    (*** IAMNetShowConfig methods ***)
    function get_BufferingTime(var pBufferingTime: double): HResult; stdcall;
    function put_BufferingTime(BufferingTime: double): HResult; stdcall;
    function get_UseFixedUDPPort(var pUseFixedUDPPort: WordBool): HResult; stdcall;
    function put_UseFixedUDPPort(UseFixedUDPPort: WordBool): HResult; stdcall;
    function get_FixedUDPPort(var pFixedUDPPort: Longint): HResult; stdcall;
    function put_FixedUDPPort(FixedUDPPort: Longint): HResult; stdcall;
    function get_UseHTTPProxy(var pUseHTTPProxy: WordBool): HResult; stdcall;
    function put_UseHTTPProxy(UseHTTPProxy: WordBool): HResult; stdcall;
    function get_EnableAutoProxy(var pEnableAutoProxy: WordBool): HResult; stdcall;
    function put_EnableAutoProxy(EnableAutoProxy: WordBool): HResult; stdcall;
    function get_HTTPProxyHost(var pbstrHTTPProxyHost: TBSTR): HResult; stdcall;
    function put_HTTPProxyHost(bstrHTTPProxyHost: TBSTR): HResult; stdcall;
    function get_HTTPProxyPort(var pHTTPProxyPort: Longint): HResult; stdcall;
    function put_HTTPProxyPort(HTTPProxyPort: Longint): HResult; stdcall;
    function get_EnableMulticast(var pEnableMulticast: WordBool): HResult; stdcall;
    function put_EnableMulticast(EnableMulticast: WordBool): HResult; stdcall;
    function get_EnableUDP(var pEnableUDP: WordBool): HResult; stdcall;
    function put_EnableUDP(EnableUDP: WordBool): HResult; stdcall;
    function get_EnableTCP(var pEnableTCP: WordBool): HResult; stdcall;
    function put_EnableTCP(EnableTCP: WordBool): HResult; stdcall;
    function get_EnableHTTP(var pEnableHTTP: WordBool): HResult; stdcall;
    function put_EnableHTTP(EnableHTTP: WordBool): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMChannelInfo> _di_IAMChannelInfo;'}
  {$EXTERNALSYM IAMChannelInfo}
  IAMChannelInfo = interface(IDispatch)
    ['{FA2AA8F2-8B62-11D0-A520-000000000000}']
    (*** IAMChannelInfo methods ***)
    function get_ChannelName(var pbstrChannelName: TBSTR): HResult; stdcall;
    function get_ChannelDescription(var pbstrChannelDescription: TBSTR): HResult; stdcall;
    function get_ChannelURL(var pbstrChannelURL: TBSTR): HResult; stdcall;
    function get_ContactAddress(var pbstrContactAddress: TBSTR): HResult; stdcall;
    function get_ContactPhone(var pbstrContactPhone: TBSTR): HResult; stdcall;
    function get_ContactEmail(var pbstrContactEmail: TBSTR): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMNetworkStatus> _di_IAMNetworkStatus;'}
  {$EXTERNALSYM IAMNetworkStatus}
  IAMNetworkStatus = interface(IDispatch)
    ['{FA2AA8F3-8B62-11D0-A520-000000000000}']
    (*** IAMNetworkStatus methods ***)
    function get_ReceivedPackets(var pReceivedPackets: Longint): HResult; stdcall;
    function get_RecoveredPackets(var pRecoveredPackets: Longint): HResult; stdcall;
    function get_LostPackets(var pLostPackets: Longint): HResult; stdcall;
    function get_ReceptionQuality(var pReceptionQuality: Longint): HResult; stdcall;
    function get_BufferingCount(var pBufferingCount: Longint): HResult; stdcall;
    function get_IsBroadcast(var pIsBroadcast: WordBool): HResult; stdcall;
    function get_BufferingProgress(var pBufferingProgress: Longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMExtendedSeeking> _di_IAMExtendedSeeking;'}
  {$EXTERNALSYM IAMExtendedSeeking}
  IAMExtendedSeeking = interface(IDispatch)
    ['{FA2AA8F9-8B62-11D0-A520-000000000000}']
    (*** IAMExtendedSeeking methods ***)
    function get_ExSeekCapabilities(var pExCapabilities: Longint): HResult; stdcall;
    function get_MarkerCount(var pMarkerCount: Longint): HResult; stdcall;
    function get_CurrentMarker(var pCurrentMarker: Longint): HResult; stdcall;
    function GetMarkerTime(MarkerNum: Longint; var pMarkerTime: double): HResult; stdcall;
    function GetMarkerName(MarkerNum: Longint; var pbstrMarkerName: TBSTR): HResult; stdcall;
    function put_PlaybackSpeed(Speed: double): HResult; stdcall;
    function get_PlaybackSpeed(var pSpeed: double): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMNetShowExProps> _di_IAMNetShowExProps;'}
  {$EXTERNALSYM IAMNetShowExProps}
  IAMNetShowExProps = interface(IDispatch)
    ['{FA2AA8F5-8B62-11D0-A520-000000000000}']
    (*** IAMNetShowExProps methods ***)
    function get_SourceProtocol(var pSourceProtocol: Longint): HResult; stdcall;
    function get_Bandwidth(var pBandwidth: Longint): HResult; stdcall;
    function get_ErrorCorrection(var pbstrErrorCorrection: TBSTR): HResult; stdcall;
    function get_CodecCount(var pCodecCount: Longint): HResult; stdcall;
    function GetCodecInstalled(CodecNum: Longint; var pCodecInstalled: WordBool): HResult; stdcall;
    function GetCodecDescription(CodecNum: Longint; var pbstrCodecDescription: TBSTR): HResult; stdcall;
    function GetCodecURL(CodecNum: Longint; var pbstrCodecURL: TBSTR): HResult; stdcall;
    function get_CreationDate(var pCreationDate: Date): HResult; stdcall;
    function get_SourceLink(var pbstrSourceLink: TBSTR): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMExtendedErrorInfo> _di_IAMExtendedErrorInfo;'}
  {$EXTERNALSYM IAMExtendedErrorInfo}
  IAMExtendedErrorInfo = interface(IDispatch)
    ['{FA2AA8F6-8B62-11D0-A520-000000000000}']
    (*** IAMExtendedErrorInfo methods ***)
    function get_HasError(var pHasError: WordBool): HResult; stdcall;
    function get_ErrorDescription(var pbstrErrorDescription: TBSTR): HResult; stdcall;
    function get_ErrorCode(var pErrorCode: Longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMMediaContent> _di_IAMMediaContent;'}
  {$EXTERNALSYM IAMMediaContent}
  IAMMediaContent = interface(IDispatch)
    ['{FA2AA8F4-8B62-11D0-A520-000000000000}']
    (*** IAMMediaContent methods ***)
    function get_AuthorName(var pbstrAuthorName: TBSTR): HResult; stdcall;
    function get_Title(var pbstrTitle: TBSTR): HResult; stdcall;
    function get_Rating(var pbstrRating: TBSTR): HResult; stdcall;
    function get_Description(var pbstrDescription: TBSTR): HResult; stdcall;
    function get_Copyright(var pbstrCopyright: TBSTR): HResult; stdcall;
    function get_BaseURL(var pbstrBaseURL: TBSTR): HResult; stdcall;
    function get_LogoURL(var pbstrLogoURL: TBSTR): HResult; stdcall;
    function get_LogoIconURL(var pbstrLogoURL: TBSTR): HResult; stdcall;
    function get_WatermarkURL(var pbstrWatermarkURL: TBSTR): HResult; stdcall;
    function get_MoreInfoURL(var pbstrMoreInfoURL: TBSTR): HResult; stdcall;
    function get_MoreInfoBannerImage(var pbstrMoreInfoBannerImage: TBSTR): HResult; stdcall;
    function get_MoreInfoBannerURL(var pbstrMoreInfoBannerURL: TBSTR): HResult; stdcall;
    function get_MoreInfoText(var pbstrMoreInfoText: TBSTR): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMMediaContent2> _di_IAMMediaContent2;'}
  {$EXTERNALSYM IAMMediaContent2}
  IAMMediaContent2 = interface(IDispatch)
    ['{CE8F78C1-74D9-11D2-B09D-00A0C9A81117}']
    (*** IAMMediaContent2 methods ***)
    function get_MediaParameter(var EntryNum: longint; var bstrName, pbstrValue: TBSTR): HResult; stdcall;
    function get_MediaParameterName(var EntryNum, Index: longint; var pbstrName: TBSTR): HResult; stdcall;
    function get_PlaylistCount(var pNumberEntries: longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMNetShowPreroll> _di_IAMNetShowPreroll;'}
  {$EXTERNALSYM IAMNetShowPreroll}
  IAMNetShowPreroll = interface(IDispatch)
    ['{AAE7E4E2-6388-11D1-8D93-006097C9A2B2}']
    (*** IAMNetShowPreroll methods ***)
    function put_Preroll(var fPreroll : WordBool): HResult; stdcall;
    function get_Preroll(var pfPreroll: WordBool): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDShowPlugin> _di_IDShowPlugin;'}
  {$EXTERNALSYM IDShowPlugin}
  IDShowPlugin = interface(IUnknown)
    ['{4746B7C8-700E-11D1-BECC-00C04FB6E937}']
    (*** IDShowPlugin methods ***)
    function get_URL(var pURL: TBSTR): HResult; stdcall;
    function get_UserAgent(var pUserAgent: TBSTR): HResult; stdcall;
  end;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       playlist.h
 *
 ***************************************************************************)

const
  IID_IAMPlayListItem: TGUID = (D1:$56A868FF;D2:$0AD4;D3:$11CE;D4:($B0,$A3,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IAMPlayListItem}
  IID_IAMPlayList: TGUID = (D1:$56A868FE;D2:$0AD4;D3:$11CE;D4:($B0,$A3,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM IID_IAMPlayList}
  IID_ISpecifyParticularPages : TGUID = '{4C437B91-6E9E-11d1-A704-006097C4E476}';
  {$EXTERNALSYM IID_ISpecifyParticularPages}
  IID_IAMRebuild: TGUID = '{02EF04DD-7580-11d1-BECE-00C04FB6E937}';
  {$EXTERNALSYM IID_IAMRebuild}
  SPECIFYPAGES_STATISTICS: TGUID = (D1:$4c437b92;D2:$6e9e;D3:$11d1;D4:($a7,$4,$0,$60,$97,$c4,$e4,$76));
  {$EXTERNALSYM SPECIFYPAGES_STATISTICS}

  AMPLAYLISTITEM_CANSKIP = 1;
  {$EXTERNALSYM AMPLAYLISTITEM_CANSKIP}
  AMPLAYLISTITEM_CANBIND = 2;
  {$EXTERNALSYM AMPLAYLISTITEM_CANBIND}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMPlayListItem> _di_IAMPlayListItem;'}
  {$EXTERNALSYM IAMPlayListItem}
  IAMPlayListItem = interface(IUnknown)
    ['{56A868FF-0AD4-11CE-B0A3-0020AF0BA770}']
    (*** IAMPlayListItem methods ***)
    function GetFlags(out pdwFlags: DWORD): HResult; stdcall;
    function GetSourceCount(out pdwSources: DWORD): HResult; stdcall;
    function GetSourceURL(dwSourceIndex: DWORD; out pbstrURL: WideChar): HResult; stdcall;
    function GetSourceStart(dwSourceIndex: DWORD; out prtStart: TReferenceTime): HResult; stdcall;
    function GetSourceDuration(dwSourceIndex: DWORD;
        out prtDuration: TReferenceTime): HResult; stdcall;
    function GetSourceStartMarker(dwSourceIndex: DWORD;
        out pdwMarker: DWORD): HResult; stdcall;
    function GetSourceEndMarker(dwSourceIndex: DWORD;
        out pdwMarker: DWORD): HResult; stdcall;
    function GetSourceStartMarkerName(dwSourceIndex: DWORD;
        out pbstrStartMarker: WideChar): HResult; stdcall;
    function GetSourceEndMarkerName(dwSourceIndex: DWORD;
        out pbstrEndMarker: WideChar): HResult; stdcall;
    function GetLinkURL(out pbstrURL: WideChar): HResult; stdcall;
    function GetScanDuration(dwSourceIndex: DWORD;
        out prtScanDuration: TReferenceTime): HResult; stdcall;
  end;

const
  AMPLAYLIST_STARTINSCANMODE = 1;
  {$EXTERNALSYM AMPLAYLIST_STARTINSCANMODE}
  AMPLAYLIST_FORCEBANNER     = 2;
  {$EXTERNALSYM AMPLAYLIST_FORCEBANNER}

  AMPLAYLISTEVENT_RESUME  = $0;
  {$EXTERNALSYM AMPLAYLISTEVENT_RESUME}
  AMPLAYLISTEVENT_BREAK	  = $1;
  {$EXTERNALSYM AMPLAYLISTEVENT_BREAK}
  AMPLAYLISTEVENT_NEXT	  = $2;
  {$EXTERNALSYM AMPLAYLISTEVENT_NEXT}
  AMPLAYLISTEVENT_MASK	  = $f;
  {$EXTERNALSYM AMPLAYLISTEVENT_MASK}
  AMPLAYLISTEVENT_REFRESH	= $10;
  {$EXTERNALSYM AMPLAYLISTEVENT_REFRESH}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMPlayList> _di_IAMPlayList;'}
  {$EXTERNALSYM IAMPlayList}
  IAMPlayList = interface(IUnknown)
    ['{56A868FE-0AD4-11CE-B0A3-0020AF0BA770}']
    (*** IAMPlayList methods ***)
    function GetFlags(out pdwFlags: DWORD): HResult; stdcall;
    function GetItemCount(out pdwItems: DWORD): HResult; stdcall;
    function GetItem(dwItemIndex: DWORD; out ppItem: IAMPlayListItem): HResult; stdcall;
    function GetNamedEvent(var pwszEventName: WideChar; dwItemIndex: DWORD;
        out ppItem: IAMPlayListItem; out pdwFlags: DWORD): HResult; stdcall;
    function GetRepeatInfo(out pdwRepeatCount, pdwRepeatStart,
        pdwRepeatEnd: DWORD): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<ISpecifyParticularPages> _di_ISpecifyParticularPages;'}
  {$EXTERNALSYM ISpecifyParticularPages}
  ISpecifyParticularPages = interface(IUnknown)
    ['{4C437B91-6E9E-11d1-A704-006097C4E476}']
    (*** ISpecifyParticularPages methods ***)
    function GetPages(const guidWhatPages: TGUID; out pPages: PGUID): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMRebuild> _di_IAMRebuild;'}
  {$EXTERNALSYM IAMRebuild}
  IAMRebuild = interface(IUnknown)
    ['{02EF04DD-7580-11d1-BECE-00C04FB6E937}']
    (*** IAMRebuild methods ***)
    function RebuildNow: HResult; stdcall;
  end;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       amvideo.h
 *
 ***************************************************************************)

const
  IID_IDirectDrawVideo: TGUID = (D1:$36D39EB0;D2:$DD75;D3:$11CE;D4:($BF,$0E,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM IID_IDirectDrawVideo}
  IID_IQualProp: TGUID = (D1:$1BD0ECB0;D2:$F8E2;D3:$11CE;D4:($AA,$C6,$00,$20,$AF,$0B,$99,$A3));
  {$EXTERNALSYM IID_IQualProp}
  IID_IFullScreenVideo: TGUID = (D1:$DD1D7110;D2:$7836;D3:$11CF;D4:($BF,$47,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM IID_IFullScreenVideo}
  IID_IFullScreenVideoEx: TGUID = (D1:$53479470;D2:$F1DD;D3:$11CF;D4:($BC,$42,$00,$AA,$00,$AC,$74,$F6));
  {$EXTERNALSYM IID_IFullScreenVideoEx}
  IID_IBaseVideoMixer: TGUID = (D1:$61DED640;D2:$E912;D3:$11CE;D4:($A0,$99,$00,$AA,$00,$47,$9A,$58));
  {$EXTERNALSYM IID_IBaseVideoMixer}

const
  AMDDS_NONE    = $00;        // No use for DCI/DirectDraw
  {$EXTERNALSYM AMDDS_NONE}
  AMDDS_DCIPS   = $01;        // Use DCI primary surface
  {$EXTERNALSYM AMDDS_DCIPS}
  AMDDS_PS      = $02;        // Use DirectDraw primary
  {$EXTERNALSYM AMDDS_PS}
  AMDDS_RGBOVR  = $04;        // RGB overlay surfaces
  {$EXTERNALSYM AMDDS_RGBOVR}
  AMDDS_YUVOVR  = $08;        // YUV overlay surfaces
  {$EXTERNALSYM AMDDS_YUVOVR}
  AMDDS_RGBOFF  = $10;        // RGB offscreen surfaces
  {$EXTERNALSYM AMDDS_RGBOFF}
  AMDDS_YUVOFF  = $20;        // YUV offscreen surfaces
  {$EXTERNALSYM AMDDS_YUVOFF}
  AMDDS_RGBFLP  = $40;        // RGB flipping surfaces
  {$EXTERNALSYM AMDDS_RGBFLP}
  AMDDS_YUVFLP  = $80;        // YUV flipping surfaces
  {$EXTERNALSYM AMDDS_YUVFLP}
  AMDDS_ALL     = $FF;        // ALL the previous flags
  {$EXTERNALSYM AMDDS_ALL}
  AMDDS_DEFAULT = AMDDS_ALL;   // Use all available surfaces
  {$EXTERNALSYM AMDDS_DEFAULT}

  AMDDS_YUV = AMDDS_YUVOFF or AMDDS_YUVOVR or AMDDS_YUVFLP;
  {$EXTERNALSYM AMDDS_YUV}
  AMDDS_RGB = AMDDS_RGBOFF or AMDDS_RGBOVR or AMDDS_RGBFLP;
  {$EXTERNALSYM AMDDS_RGB}
  AMDDS_PRIMARY = AMDDS_DCIPS or AMDDS_PS;
  {$EXTERNALSYM AMDDS_PRIMARY}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IDirectDrawVideo> _di_IDirectDrawVideo;'}
  {$EXTERNALSYM IDirectDrawVideo}
  IDirectDrawVideo = interface(IUnknown)
    ['{36D39EB0-DD75-11CE-BF0E-00AA0055595A}']
    (*** IDirectDrawVideo methods ***)
    function GetSwitches(out pSwitches: DWORD): HResult; stdcall;
    function SetSwitches(pSwitches: DWORD): HResult; stdcall;
    function GetCaps(out pCaps: TDDCaps): HResult; stdcall;
    function GetEmulatedCaps(out pCaps: TDDCaps): HResult; stdcall;
    function GetSurfaceDesc(out pSurfaceDesc: TDDSurfaceDesc): HResult; stdcall;
    function GetFourCCCodes(out pCount, pCodes: DWORD): HResult; stdcall;
    function SetDirectDraw(pDirectDraw: IDirectDraw): HResult; stdcall;
    function GetDirectDraw(out ppDirectDraw: IDirectDraw): HResult; stdcall;
    function GetSurfaceType(out pSurfaceType: DWORD): HResult; stdcall;
    function SetDefault: HResult; stdcall;
    function UseScanLine(UseScanLine: LongBool): HResult; stdcall;
    function CanUseScanLine(var UseScanLine: LongBool): HResult; stdcall;
    function UseOverlayStretch(UseOverlayStretch: LongBool): HResult; stdcall;
    function CanUseOverlayStretch(var UseOverlayStretch: LongBool): HResult;
        stdcall;
    function UseWhenFullScreen(UseWhenFullScreen: LongBool): HResult; stdcall;
    function WillUseFullScreen(var UseWhenFullScreen: LongBool): HResult;
        stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IQualProp> _di_IQualProp;'}
  {$EXTERNALSYM IQualProp}
  IQualProp = interface(IUnknown)
    ['{1BD0ECB0-F8E2-11CE-AAC6-0020AF0B99A3}']
    (*** IQualProp methods ***)
    // Compare these with the functions in class CGargle in gargle.h
    function get_FramesDroppedInRenderer(var pcFrames: Integer): HResult; stdcall;
    function get_FramesDrawn(out pcFrames: Integer): HResult; stdcall;
    function get_AvgFrameRate(out piAvgFrameRate: Integer): HResult; stdcall;
    function get_Jitter(out iJitter: Integer): HResult; stdcall;
    function get_AvgSyncOffset(out piAvg: Integer): HResult; stdcall;
    function get_DevSyncOffset(out piDev: Integer): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IFullScreenVideo> _di_IFullScreenVideo;'}
  {$EXTERNALSYM IFullScreenVideo}
  IFullScreenVideo = interface(IUnknown)
    ['{DD1D7110-7836-11CF-BF47-00AA0055595A}']
    (*** IFullScreenVideo methods ***)
    function CountModes(out pModes: Longint): HResult; stdcall;
    function GetModeInfo(Mode: Longint; out pWidth, pHeight, pDepth: Longint):
        HResult; stdcall;
    function GetCurrentMode(out pMode: Longint): HResult; stdcall;
    function IsModeAvailable(Mode: Longint): HResult; stdcall;
    function IsModeEnabled(Mode: Longint): HResult; stdcall;
    function SetEnabled(Mode: Longint; bEnabled: Longint): HResult; stdcall;
    function GetClipFactor(out pClipFactor: Longint): HResult; stdcall;
    function SetClipFactor(ClipFactor: Longint): HResult; stdcall;
    function SetMessageDrain(hwnd: HWND): HResult; stdcall;
    function GetMessageDrain(out hwnd: HWND): HResult; stdcall;
    function SetMonitor(Monitor: Longint): HResult; stdcall;
    function GetMonitor(out Monitor: Longint): HResult; stdcall;
    function HideOnDeactivate(Hide: LongBool): HResult; stdcall;
    function IsHideOnDeactivate: HResult; stdcall;
    function SetCaption(strCaption: TBStr): HResult; stdcall;
    function GetCaption(out pstrCaption: TBStr): HResult; stdcall;
    function SetDefault: HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IFullScreenVideoEx> _di_IFullScreenVideoEx;'}
  {$EXTERNALSYM IFullScreenVideoEx}
  IFullScreenVideoEx = interface(IFullScreenVideo)
    ['{53479470-F1DD-11CF-BC42-00AA00AC74F6}']
    (*** IFullScreenVideoEx methods ***)
    // IFullScreenVideoEx
    function SetAcceleratorTable(hwnd: HWND; hAccel: HACCEL): HResult; stdcall;
    function GetAcceleratorTable(var hwnd: HWND; var hAccel: HACCEL): HResult;
        stdcall;
    function KeepPixelAspectRatio(KeepAspect: LongBool): HResult; stdcall;
    function IsKeepPixelAspectRatio(var pKeepAspect: LongBool): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IBaseVideoMixer> _di_IBaseVideoMixer;'}
  {$EXTERNALSYM IBaseVideoMixer}
  IBaseVideoMixer = interface(IUnknown)
    ['{61DED640-E912-11CE-A099-00AA00479A58}']
    (*** IBaseVideoMixer methods ***)
    function SetLeadPin(iPin: Integer): HResult; stdcall;
    function GetLeadPin(out iPin: Integer): HResult; stdcall;
    function GetInputPinCount(out piPinCount: Integer): HResult; stdcall;
    function IsUsingClock(out pbValue: Integer): HResult; stdcall;
    function SetUsingClock(bValue: Integer): HResult; stdcall;
    function GetClockPeriod(out pbValue: Integer): HResult; stdcall;
    function SetClockPeriod(bValue: Integer): HResult; stdcall;
  end;

const
  iPALETTE_COLORS = 256;     // Maximum colours in palette
  {$EXTERNALSYM iPALETTE_COLORS}
  iEGA_COLORS     = 16;      // Number colours in EGA palette
  {$EXTERNALSYM iEGA_COLORS}
  iMASK_COLORS    = 3;       // Maximum three components
  {$EXTERNALSYM iMASK_COLORS}
  iTRUECOLOR      = 16;      // Minimum true colour device
  {$EXTERNALSYM iTRUECOLOR}
  iRED            = 0;       // Index position for RED mask
  {$EXTERNALSYM iRED}
  iGREEN          = 1;       // Index position for GREEN mask
  {$EXTERNALSYM iGREEN}
  iBLUE           = 2;       // Index position for BLUE mask
  {$EXTERNALSYM iBLUE}
  iPALETTE        = 8;       // Maximum colour depth using a palette
  {$EXTERNALSYM iPALETTE}
  iMAXBITS        = 8;       // Maximum bits per colour component
  {$EXTERNALSYM iMAXBITS}

type
  // Used for true colour images that also have a palette
  tag_TRUECOLORINFO = record
    dwBitMasks: array[0..iMASK_COLORS-1] of DWORD;
    bmiColors: array[0..iPALETTE_COLORS-1] of TRGBQuad;
  end;
  {$EXTERNALSYM tag_TRUECOLORINFO}
  TRUECOLORINFO = tag_TRUECOLORINFO;
  {$EXTERNALSYM TRUECOLORINFO}
  TTrueColorInfo = tag_TRUECOLORINFO;

  PVideoInfoHeader = ^TVideoInfoHeader;
  tagVIDEOINFOHEADER = record
    rcSource: TRect;                   // The bit we really want to use
    rcTarget: TRect;                   // Where the video should go
    dwBitRate: DWORD;                  // Approximate bit data rate
    dwBitErrorRate: DWORD;             // Bit error rate for this stream
    AvgTimePerFrame: TReferenceTime;  // Average time per frame (100ns units)

    bmiHeader: TBitmapInfoHeader;
  end;
  {$EXTERNALSYM tagVIDEOINFOHEADER}
  VIDEOINFOHEADER = tagVIDEOINFOHEADER;
  {$EXTERNALSYM VIDEOINFOHEADER}
  TVideoInfoHeader = tagVIDEOINFOHEADER;

// make sure the pbmi is initialized before using these macros
{function TRUECOLOR(pbmi: PBitmapInfo): Pointer;
function COLORS(pbmi: PBitmapInfo): Pointer;
function BITMASKS(pbmi: PBitmapInfo): Pointer;
{
#define TRUECOLOR(pbmi)  ((TRUECOLORINFO *)(((LPBYTE)&((pbmi)->bmiHeader)) \
                                        + (pbmi)->bmiHeader.biSize))
#define COLORS(pbmi)    ((RGBQUAD *)(((LPBYTE)&((pbmi)->bmiHeader))     \
                                        + (pbmi)->bmiHeader.biSize))
#define BITMASKS(pbmi)  ((DWORD *)(((LPBYTE)&((pbmi)->bmiHeader))       \
                                        + (pbmi)->bmiHeader.biSize))
 }
// All the image based filters use this to communicate their media types. It's
// centred principally around the BITMAPINFO. This structure always contains a
// BITMAPINFOHEADER followed by a number of other fields depending on what the
// BITMAPINFOHEADER contains. If it contains details of a palettised format it
// will be followed by one or more RGBQUADs defining the palette. If it holds
// details of a true colour format then it may be followed by a set of three
// DWORD bit masks that specify where the RGB data can be found in the image
// (For more information regarding BITMAPINFOs see the Win32 documentation)

// The rcSource and rcTarget fields are not for use by filters supplying the
// data. The destination (target) rectangle should be set to all zeroes. The
// source may also be zero filled or set with the dimensions of the video. So
// if the video is 352x288 pixels then set it to (0,0,352,288). These fields
// are mainly used by downstream filters that want to ask the source filter
// to place the image in a different position in an output buffer. So when
// using for example the primary surface the video renderer may ask a filter
// to place the video images in a destination position of (100,100,452,388)
// on the display since that's where the window is positioned on the display

// !!! WARNING !!!
// DO NOT use this structure unless you are sure that the BITMAPINFOHEADER
// has a normal biSize == sizeof(BITMAPINFOHEADER) !
// !!! WARNING !!!

type
  PVideoInfo = ^TVideoInfo;
  tagVIDEOINFO = record
    rcSource: TRect;                   // The bit we really want to use
    rcTarget: TRect;                   // Where the video should go
    dwBitRate: DWORD;                  // Approximate bit data rate
    dwBitErrorRate: DWORD;             // Bit error rate for this stream
    AvgTimePerFrame: TReferenceTime;  // Average time per frame (100ns units)

    bmiHeader: TBitmapInfoHeader;

    case Integer of
    0: (
      bmiColors: array[0..iPALETTE_COLORS-1] of TRGBQuad // Colour palette
      );
    1: (
      dwBitMasks: array[0..iMASK_COLORS-1] of DWORD      // True colour masks
      );
    2: (
      TrueColorInfo: TTrueColorInfo                      // Both of the above
      );
  end;
  {$EXTERNALSYM tagVIDEOINFO}
  VIDEOINFO = tagVIDEOINFO;
  {$EXTERNALSYM VIDEOINFO}
  TVideoInfo = tagVIDEOINFO;

// These macros define some standard bitmap format sizes

const
  SIZE_EGA_PALETTE = iEGA_COLORS * SizeOf(TRGBQuad);
  {$EXTERNALSYM SIZE_EGA_PALETTE}
  SIZE_PALETTE = iPALETTE_COLORS * SizeOf(TRGBQuad);
  {$EXTERNALSYM SIZE_PALETTE}
  SIZE_MASKS = iMASK_COLORS * SizeOf(DWORD);
  {$EXTERNALSYM SIZE_MASKS}

  SIZE_PREHEADER = 48; // offset TVideoInfoHeader.bmiHeader
  {$EXTERNALSYM SIZE_PREHEADER}
  SIZE_VIDEOHEADER = SizeOf(TVideoInfoHeader);
  {$EXTERNALSYM SIZE_VIDEOHEADER}

// !!! for abnormal biSizes
// #define SIZE_VIDEOHEADER(pbmi) ((pbmi)->bmiHeader.biSize + SIZE_PREHEADER)

// DIBSIZE calculates the number of bytes required by an image
{
function WIDTHBYTES(bits: Integer): DWORD;
function DIBWIDTHBYTES(const bhi: TBitmapInfoHeader): DWORD;
function _DIBSIZE(const bmi: TBitmapInfoHeader): DWORD;
function DIBSIZE(const bmi: TBitmapInfoHeader): DWORD;
{
#define WIDTHBYTES(bits) ((DWORD)(((bits)+31) & (~31)) / 8)
#define DIBWIDTHBYTES(bi) (DWORD)WIDTHBYTES((DWORD)(bi).biWidth * (DWORD)(bi).biBitCount)
#define _DIBSIZE(bi) (DIBWIDTHBYTES(bi) * (DWORD)(bi).biHeight)
#define DIBSIZE(bi) ((bi).biHeight < 0 ? (-1)*(_DIBSIZE(bi)) : _DIBSIZE(bi))
}
// This compares the bit masks between two VIDEOINFOHEADERs
{
function BIT_MASKS_MATCH(const bmi1, bmi2: TBitmapInfo): Boolean;
{
#define BIT_MASKS_MATCH(pbmi1,pbmi2)                                \
    (((pbmi1)->dwBitMasks[iRED] == (pbmi2)->dwBitMasks[iRED]) &&        \
     ((pbmi1)->dwBitMasks[iGREEN] == (pbmi2)->dwBitMasks[iGREEN]) &&    \
     ((pbmi1)->dwBitMasks[iBLUE] == (pbmi2)->dwBitMasks[iBLUE]))
}
// These zero fill different parts of the VIDEOINFOHEADER structure

// Only use these macros for pbmi's with a normal BITMAPINFOHEADER biSize
{procedure RESET_MASKS(var bmi: TBitmapInfo);
procedure RESET_HEADER(var bmi: TBitmapInfo);
procedure RESET_PALETTE(var bmi: TBitmapInfo);
{
#define RESET_MASKS(pbmi) (ZeroMemory((PVOID)(pbmi)->dwBitFields,SIZE_MASKS))
#define RESET_HEADER(pbmi) (ZeroMemory((PVOID)(pbmi),SIZE_VIDEOHEADER))
#define RESET_PALETTE(pbmi) (ZeroMemory((PVOID)(pbmi)->bmiColors,SIZE_PALETTE));
}
{
// !!! This is the right way to do it, but may break existing code
#define RESET_MASKS(pbmi) (ZeroMemory((PVOID)(((LPBYTE)(pbmi)->bmiHeader) + \
                        (pbmi)->bmiHeader.biSize,SIZE_MASKS)))
#define RESET_HEADER(pbmi) (ZeroMemory((PVOID)(pbmi), SIZE_PREHEADER +      \
                        sizeof(BITMAPINFOHEADER)))
#define RESET_PALETTE(pbmi) (ZeroMemory((PVOID)(((LPBYTE)(pbmi)->bmiHeader) + \
                        (pbmi)->bmiHeader.biSize,SIZE_PALETTE))
}

// Other (hopefully) useful bits and bobs
{
#define PALETTISED(pbmi) ((pbmi)->bmiHeader.biBitCount <= iPALETTE)
#define PALETTE_ENTRIES(pbmi) ((DWORD) 1 << (pbmi)->bmiHeader.biBitCount)

// Returns the address of the BITMAPINFOHEADER from the VIDEOINFOHEADER
#define HEADER(pVideoInfo) (&(((VIDEOINFOHEADER *) (pVideoInfo))->bmiHeader))
 }

// MPEG variant - includes a DWORD length followed by the
// video sequence header after the video header.
//
// The sequence header includes the sequence header start code and the
// quantization matrices associated with the first sequence header in the
// stream so is a maximum of 140 bytes long.
type
  PMPEG1VideoInfo = ^TMPEG1VideoInfo;
  tagMPEG1VIDEOINFO = record
    hdr: TVideoInfoHeader;                  // Compatible with VIDEOINFO
    dwStartTimeCode: DWORD;                 // 25-bit Group of pictures time code
                                            // at start of data
    cbSequenceHeader: DWORD;                // Length in bytes of bSequenceHeader
    bSequenceHeader: array[0..0] of Byte;   // Sequence header including
                                            // quantization matrices if any
  end;
  {$EXTERNALSYM tagMPEG1VIDEOINFO}
  MPEG1VIDEOINFO = tagMPEG1VIDEOINFO;
  {$EXTERNALSYM MPEG1VIDEOINFO}
  TMPEG1VideoInfo = tagMPEG1VIDEOINFO;
  
const
  MAX_SIZE_MPEG1_SEQUENCE_INFO = 140;
  {$EXTERNALSYM MAX_SIZE_MPEG1_SEQUENCE_INFO}
{
#define SIZE_MPEG1VIDEOINFO(pv) (FIELD_OFFSET(MPEG1VIDEOINFO, bSequenceHeader[0]) + (pv)->cbSequenceHeader)
#define MPEG1_SEQUENCE_INFO(pv) ((const BYTE *)(pv)->bSequenceHeader)
}

// Analog video variant - Use this when the format is FORMAT_AnalogVideo
//
// rcSource defines the portion of the active video signal to use
// rcTarget defines the destination rectangle
//    both of the above are relative to the dwActiveWidth and dwActiveHeight fields
// dwActiveWidth is currently set to 720 for all formats (but could change for HDTV)
// dwActiveHeight is 483 for NTSC and 575 for PAL/SECAM  (but could change for HDTV)
type
  tagAnalogVideoInfo = record
    rcSource: TRect;                   // Width max is 720, height varies w/ TransmissionS
    rcTarget: TRect;                   // Where the video should go
    dwBitRate: DWORD;                  // Always 720 (CCIR-601 active samples per line)
    dwBitErrorRate: DWORD;             // 483 for NTSC, 575 for PAL/SECAM
    AvgTimePerFrame: TReferenceTime;  // Normal ActiveMovie units (100 nS)
  end;
  {$EXTERNALSYM tagAnalogVideoInfo}
  ANALOGVIDEOINFO = tagAnalogVideoInfo;
  {$EXTERNALSYM ANALOGVIDEOINFO}
  TAnalogVideoInfo = tagAnalogVideoInfo;


//
// AM_KSPROPSETID_FrameStep property set definitions
//

  AM_PROPERTY_FRAMESTEP = (
  {$IFNDEF COMPILER6_UP}
    AM_PROPERTY_FRAMESTEP_INVALID_O,
    //  Step
	  AM_PROPERTY_FRAMESTEP_STEP,
	  AM_PROPERTY_FRAMESTEP_CANCEL,
    //  S_OK for these 2 means we can - S_FALSE if we can't
    AM_PROPERTY_FRAMESTEP_CANSTEP,
    AM_PROPERTY_FRAMESTEP_CANSTEPMULTIPLE
  {$ELSE}
    //  Step
	  AM_PROPERTY_FRAMESTEP_STEP            = 1,
	  AM_PROPERTY_FRAMESTEP_CANCEL          = 2 ,
    //  S_OK for these 2 means we can - S_FALSE if we can't
    AM_PROPERTY_FRAMESTEP_CANSTEP         = 3,
    AM_PROPERTY_FRAMESTEP_CANSTEPMULTIPLE = 4
  {$ENDIF}
  );
  {$EXTERNALSYM AM_PROPERTY_FRAMESTEP}
  TAMPropertyFramesStep = AM_PROPERTY_FRAMESTEP;


  _AM_FRAMESTEP_STEP = record
    //  1 means step 1 frame forward
    //  0 is invalid
    //  n (n > 1) means skip n - 1 frames and show the nth
     dwFramesToStep: DWORD;
  end;
  {$EXTERNALSYM _AM_FRAMESTEP_STEP}
  AM_FRAMESTEP_STEP = _AM_FRAMESTEP_STEP;
  {$EXTERNALSYM AM_FRAMESTEP_STEP}
  TAMFramestepStep = _AM_FRAMESTEP_STEP;
     
(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       amaudio.h
 *
 ***************************************************************************)

const
  IID_IAMDirectSound: TGUID = (D1:$546F4260;D2:$D53E;D3:$11CF;D4:($B3,$F0,$00,$AA,$00,$37,$61,$C5));
  {$EXTERNALSYM IID_IAMDirectSound}

// This is the interface the audio renderer supports to give the application
// access to the direct sound object and buffers it is using, to allow the
// application to use things like the 3D features of Direct Sound for the
// soundtrack of a movie being played with Active Movie

// be nice to our friends in C
type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMDirectSound> _di_IAMDirectSound;'}
  {$EXTERNALSYM IAMDirectSound}
  IAMDirectSound = interface(IUnknown)
    ['{546F4260-D53E-11CF-B3F0-00AA003761C5}']
    (*** IAMDirectSound methods ***)
    function GetDirectSoundInterface(out lplpds: IDirectSound): HResult;
        stdcall;
    function GetPrimaryBufferInterface(out lplpdsb: IDirectSoundBuffer):
        HResult; stdcall;
    function GetSecondaryBufferInterface(out lplpdsb: IDirectSoundBuffer):
        HResult; stdcall;
    function ReleaseDirectSoundInterface(lpds: IDirectSound): HResult; stdcall;
    function ReleasePrimaryBufferInterface(lpdsb: IDirectSoundBuffer): HResult;
        stdcall;
    function ReleaseSecondaryBufferInterface(lpdsb: IDirectSoundBuffer):
        HResult; stdcall;
    function SetFocusWindow(hwnd: HWND; b: BOOL): HResult; stdcall;
    function GetFocusWindow(var hwnd: HWND; var b: BOOL): HResult; stdcall;
  end;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       vptype.h
 *
 ***************************************************************************)

type
  // enum to specify the criterion, which the vpmixer is supposed to use
  // in order to select the video format
  _AMVP_SELECT_FORMAT_BY = (
    AMVP_DO_NOT_CARE,
    AMVP_BEST_BANDWIDTH,
    AMVP_INPUT_SAME_AS_OUTPUT
  );
  {$EXTERNALSYM _AMVP_SELECT_FORMAT_BY}
  AMVP_SELECT_FORMAT_BY = _AMVP_SELECT_FORMAT_BY;
  {$EXTERNALSYM AMVP_SELECT_FORMAT_BY}
  TAMVPSelectFormatBy = AMVP_SELECT_FORMAT_BY;

  // enum to specify the various mode
  _AMVP_MODE = (
    AMVP_MODE_WEAVE,
    AMVP_MODE_BOBINTERLEAVED,
    AMVP_MODE_BOBNONINTERLEAVED,
    AMVP_MODE_SKIPEVEN,
    AMVP_MODE_SKIPODD
  );
  {$EXTERNALSYM _AMVP_MODE}
  AMVP_MODE = _AMVP_MODE;
  {$EXTERNALSYM AMVP_MODE}
  TAMVPMode = AMVP_MODE;

  // struct to specify the width and height. The context could be anything
  // such as scaling cropping etc.
  PAMVPSize = ^TAMVPSize;
  _AMVPSIZE = record
    dwWidth  : DWORD;                   // the width
    dwHeight : DWORD;                   // the height
  end;
  {$EXTERNALSYM _AMVPSIZE}
  AMVPSIZE = _AMVPSIZE;
  {$EXTERNALSYM AMVPSIZE}
  LPAMVPSIZE = ^AMVPSIZE;
  {$EXTERNALSYM LPAMVPSIZE}
  TAMVPSize = _AMVPSIZE;

  // struct to specify the dimensional characteristics of the input stream
  PAMVPDimInfo = ^TAMVPDimInfo;
  _AMVPDIMINFO = record
  {$EXTERNALSYM _AMVPDIMINFO}
    dwFieldWidth  : DWORD;               // Field height of the data
    dwFieldHeight : DWORD;              // Field width of the data
    dwVBIWidth    : DWORD;                 // Width of the VBI data
    dwVBIHeight   : DWORD;                // Height of the VBI data
    rcValidRegion : TRect;              // The vaild rectangle, used for cropping
  end;
  AMVPDIMINFO = _AMVPDIMINFO;
  {$EXTERNALSYM AMVPDIMINFO}
  LPAMVPDIMINFO = ^AMVPDIMINFO;
  {$EXTERNALSYM LPAMVPDIMINFO}
  TAMVPDimInfo = _AMVPDIMINFO;

  // struct to specify the various data specific characteristics of the input stream
  PAMVPDataInfo = ^TAMVPDataInfo;
  _AMVPDATAINFO = record
     dwSize                 : DWORD;         // Size of the struct
     dwMicrosecondsPerField : DWORD;         // Time taken by each field
     amvpDimInfo            : TAMVPDIMInfo;  // Dimensional Information
     dwPictAspectRatioX     : DWORD;         // X dimension of Picture Aspect Ratio
     dwPictAspectRatioY     : DWORD;         // Y dimension of Picture Aspect Ratio
     bEnableDoubleClock     : BOOL;          // Videoport should enable double clocking
     bEnableVACT            : BOOL;          // Videoport should use an external VACT signal
     bDataIsInterlaced      : BOOL;          // Indicates that the signal is interlaced
     lHalfLinesOdd          : Longint;       // number of halflines in the odd field
     bFieldPolarityInverted : BOOL;          // Device inverts the polarity by default
     dwNumLinesInVREF       : DWORD;         // Number of lines of data in VREF
     lHalfLinesEven         : Longint;       // number of halflines in the even field
     dwReserved1            : DWORD;         // Reserved for future use
  end;
  {$EXTERNALSYM _AMVPDATAINFO}
  AMVPDATAINFO = _AMVPDATAINFO;
  {$EXTERNALSYM AMVPDATAINFO}
  LPAMVPDATAINFO = ^AMVPDATAINFO;
  {$EXTERNALSYM LPAMVPDATAINFO}
  TAMVPDataInfo = _AMVPDATAINFO;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       vpconfig.h
 *
 ***************************************************************************)

const
  IID_IVPConfig: TGUID = (D1:$BC29A660;D2:$30E3;D3:$11D0;D4:($9E,$69,$00,$C0,$4F,$D7,$C1,$5B));
  {$EXTERNALSYM IID_IVPConfig}
  IID_IVPVBIConfig: TGUID = (D1:$EC529B00;D2:$1A1F;D3:$11D1;D4:($BA,$D9,$00,$60,$97,$44,$11,$1A));
  {$EXTERNALSYM IID_IVPVBIConfig}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IVPBaseConfig> _di_IVPBaseConfig;'}
  {$EXTERNALSYM IVPBaseConfig}
  IVPBaseConfig = interface(IUnknown)
    (*** IVPBaseConfig methods ***)
    // gets the various connection information structures (guid, portwidth)
    // in an array of structures. If the pointer to the array is NULL, first
    // parameter returns the total number of formats supported.
    function GetConnectInfo(var pdwNumConnectInfo: PDWORD;
      var pddVPConnectInfo: PDDVideoPortConnect): HResult; stdcall;

    // sets the connection entry chosen (0, 1, .. ,(dwNumProposedEntries-1))
    function SetConnectInfo(dwChosenEntry: DWORD): HResult; stdcall;

    // gets various data parameters, includes dimensionnal info
    function GetVPDataInfo(var pamvpDataInfo: PAMVPDataInfo): HResult; stdcall;

    // retrives maximum pixels per second rate expected for a given
    // format and a given scaling factor. If decoder does not support
    // those scaling factors, then it gives the rate and the nearest
    // scaling factors.
    function GetMaxPixelRate(var pamvpSize: PAMVPSize;
      out pdwMaxPixelsPerSecond: PDWORD): HResult; stdcall;

    // informs the callee of the videoformats supported by the videoport
    function InformVPInputFormats(dwNumFormats: DWORD;
             pTDDPixelFormats: PDDPixelFormat): HResult; stdcall;

    // gets the various formats supported by the decoder in an array
    // of structures. If the pointer to the array is NULL, first parameter
    // returns the total number of formats supported.
    function GetVideoFormats(var pdwNumFormats: PDWORD;
      var pTDDPixelFormats: PDDPixelFormat): HResult; stdcall;

    // sets the format entry chosen (0, 1, .. ,(dwNumProposedEntries-1))
    function SetVideoFormat(dwChosenEntry: DWORD): HResult; stdcall;

    // asks the decoder to treat even fields like odd fields and visa versa
    function SetInvertPolarity: HResult; stdcall;

    // the mixer uses this function to determine if the callee wants
    // the vpmixer to use its overlay surface and if so to get a pointer to it
    function GetOverlaySurface(out ppddOverlaySurface: IDirectDrawSurface):
        HResult; stdcall;

    // sets the direct draw kernel handle
    function SetDirectDrawKernelHandle(dwDDKernelHandle: THandle): HResult;
        stdcall;

    // sets the video port id
    function SetVideoPortID(dwVideoPortID: DWORD): HResult; stdcall;

    // sets the direct draw surface kernel handle
    function SetDDSurfaceKernelHandles(cHandles: DWORD;
        var rgDDKernelHandles: THandle): HResult; stdcall;

    // Tells driver about surface created on its behalf by ovmixer/vbisurf and
    // returned from videoport/ddraw. Should always return NOERROR or E_NOIMPL.
    // dwPitch is the pitch of the surface (distance in pixels between the start
    // pixels of two consecutive lines of the surface). (dwXOrigin, dwYOrigin)
    // are the (X, Y) coordinates of the pixel at which valid data starts.
    function SetSurfaceParameters(dwPitch, dwXOrigin, dwYOrigin: DWORD):
        HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IVPConfig> _di_IVPConfig;'}
  {$EXTERNALSYM IVPConfig}
  IVPConfig = interface(IVPBaseConfig)
    ['{BC29A660-30E3-11D0-9E69-00C04FD7C15B}']
    (*** IVPConfig methods ***)
    // the mixer uses this function to determine if the callee wants
    // the mixer to decimate VIDEO data at its own descrition
    function IsVPDecimationAllowed(out pbIsDecimationAllowed: PBOOL): HResult;
        stdcall;

    // sets the scaling factors. If decoder does not support these,
    // then it sets the values to the nearest factors it can support
    function SetScalingFactors(pamvpSize: PAMVPSize): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IVPVBIConfig> _di_IVPVBIConfig;'}
  {$EXTERNALSYM IVPVBIConfig}
  IVPVBIConfig = interface(IVPBaseConfig)
    ['{EC529B00-1A1F-11D1-BAD9-00609744111A}']
    (*** IVPVBIConfig methods ***)
  end;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       vpnotify.h
 *
 ***************************************************************************)

const
  IID_IVPNotify: TGUID  = (D1:$C76794A1;D2:$D6C5;D3:$11D0;D4:($9E,$69,$00,$C0,$4F,$D7,$C1,$5B));
  {$EXTERNALSYM IID_IVPNotify}
  IID_IVPVBINotify: TGUID = (D1:$EC529B01;D2:$1A1F;D3:$11D1;D4:($BA,$D9,$00,$60,$97,$44,$11,$1A));
  {$EXTERNALSYM IID_IVPVBINotify}
  IID_IVPNotify2: TGUID = (D1:$ebf47183;D2:$8764;D3:$11d1;D4:($9e,$69,$00,$c0,$4f,$d7,$c1,$5b));
  {$EXTERNALSYM IID_IVPNotify2}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IVPBaseNotify> _di_IVPBaseNotify;'}
  {$EXTERNALSYM IVPBaseNotify}
  IVPBaseNotify = interface(IUnknown)
    (*** IVPBaseNotify methods ***)
    // this function initializes the reconnection to the decoder.
    function RenegotiateVPParameters: HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IVPNotify> _di_IVPNotify;'}
  {$EXTERNALSYM IVPNotify}
  IVPNotify = interface(IVPBaseNotify)
    ['{C76794A1-D6C5-11D0-9E69-00C04FD7C15B}']
    (*** IVPNotify methods ***)
    // function to set the mode (bob, weave etc)
    function SetDeinterlaceMode(mode: TAMVPMode): HResult; stdcall;
    // function to get the mode (bob, weave etc)
    function GetDeinterlaceMode(out pMode: TAMVPMode): HResult; stdcall;
  end;

// 4 functions have been removed from dxmedia!!
  {$HPPEMIT 'typedef System::DelphiInterface<IVPNotify2> _di_IVPNotify2;'}
  {$EXTERNALSYM IVPNotify2}
  IVPNotify2 = interface(IVPNotify)
    ['{EBF47183-8764-11d1-9E69-00C04FD7C15B}']
    (*** IVPNotify2 methods ***)
    // function to set the mode (bob, weave etc)
    function SetVPSyncMaster(bVPSyncMaster: BOOL): HResult; stdcall;
    // function to get the mode (bob, weave etc)
    function GetVPSyncMaster(OUT pbVPSyncMaster: BOOL): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IVPVBINotify> _di_IVPVBINotify;'}
  {$EXTERNALSYM IVPVBINotify}
  IVPVBINotify = interface(IVPBaseNotify)
    ['{EC529B01-1A1F-11D1-BAD9-00609744111A}']
    (*** IVPVBINotify methods ***)
  end;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       mpegtype.h
 *
 ***************************************************************************)

const
  IID_IMpegAudioDecoder: TGUID = (D1:$B45DD570;D2:$3C77;D3:$11D1;D4:($AB,$E1,$00,$A0,$C9,$05,$F3,$75));
  {$EXTERNALSYM IID_IMpegAudioDecoder}

type
//
//  AM_MPEGSYSTEMTYPE defines the format block contents for
//  data of type MEDIATYPE_MPEG1System when the format
//  block GUID is FORMAT_MPEG1System
//
//  The format block consists of elements of type
//  AM_MPEGSYSTEMTYPE up to the length of the format block
//  Each format block is 8-byte aligned from the start of
//  the format block
//

  tagAM_MPEGSTREAMTYPE = record
    dwStreamId: DWORD;               // Stream id of stream to process
    dwReserved: DWORD;               // 8-byte alignment
    mt: TAMMediaType;              // Type for substream - pbFormat is NULL
    bFormat: array[0..0] of Byte;    // Format data
  end;
  {$EXTERNALSYM tagAM_MPEGSTREAMTYPE}
  AM_MPEGSTREAMTYPE = tagAM_MPEGSTREAMTYPE;
  {$EXTERNALSYM AM_MPEGSTREAMTYPE}
  TAMMPEGStreamType = tagAM_MPEGSTREAMTYPE;

  tagAM_MPEGSYSTEMTYPE = record
    dwBitRate: DWORD;                // Bits per second
    cStreams: DWORD;                 // Number of streams
    Streams: array[0..0] of TAMMPEGStreamType;
  end;
  {$EXTERNALSYM tagAM_MPEGSYSTEMTYPE}
  AM_MPEGSYSTEMTYPE = tagAM_MPEGSYSTEMTYPE;
  {$EXTERNALSYM AM_MPEGSYSTEMTYPE}
  TAMMPEGSystemType = tagAM_MPEGSYSTEMTYPE;
{
//
//  Helper macros for AM_MPEGSTREAMTYPE
//
#define AM_MPEGSTREAMTYPE_ELEMENTLENGTH(pStreamType)  \
    FIELD_OFFSET(AM_MPEGSTREAMTYPE, bFormat[(pStreamType)->mt.cbFormat])
#define AM_MPEGSTREAMTYPE_NEXT(pStreamType)           \
    ((AM_MPEGSTREAMTYPE *)((PBYTE)(pStreamType) +     \
     ((AM_MPEGSTREAMTYPE_ELEMENTLENGTH(pStreamType) + 7) & ~7)))
 }
//
// IMpegAudioDecoder
//

// Values for DualMode
const
  AM_MPEG_AUDIO_DUAL_MERGE = 0;
  {$EXTERNALSYM AM_MPEG_AUDIO_DUAL_MERGE}
  AM_MPEG_AUDIO_DUAL_LEFT  = 1;
  {$EXTERNALSYM AM_MPEG_AUDIO_DUAL_LEFT}
  AM_MPEG_AUDIO_DUAL_RIGHT = 2;
  {$EXTERNALSYM AM_MPEG_AUDIO_DUAL_RIGHT}

type
//
//
// Microsoft MPEG audio WAV definition
//
(*  MPEG-1 audio wave format (audio layer only).   (0x0050)   *)

  MPEG1WAVEFORMAT = record
    wfx: TWaveFormatEx;
    fwHeadLayer: Word;
    dwHeadBitrate: DWORD;
    fwHeadMode: Word;
    fwHeadModeExt: Word;
    wHeadEmphasis: Word;
    fwHeadFlags: Word;
    dwPTSLow: DWORD;
    dwPTSHigh: DWORD;
  end;
  {$EXTERNALSYM MPEG1WAVEFORMAT}
  TMPEG1WaveFormat = MPEG1WAVEFORMAT;

const
  ACM_MPEG_LAYER1         = $0001;
  {$EXTERNALSYM ACM_MPEG_LAYER1}
  ACM_MPEG_LAYER2         = $0002;
  {$EXTERNALSYM ACM_MPEG_LAYER2}
  ACM_MPEG_LAYER3         = $0004;
  {$EXTERNALSYM ACM_MPEG_LAYER3}
  ACM_MPEG_STEREO         = $0001;
  {$EXTERNALSYM ACM_MPEG_STEREO}
  ACM_MPEG_JOINTSTEREO    = $0002;
  {$EXTERNALSYM ACM_MPEG_JOINTSTEREO}
  ACM_MPEG_DUALCHANNEL    = $0004;
  {$EXTERNALSYM ACM_MPEG_DUALCHANNEL}
  ACM_MPEG_SINGLECHANNEL  = $0008;
  {$EXTERNALSYM ACM_MPEG_SINGLECHANNEL}
  ACM_MPEG_PRIVATEBIT     = $0001;
  {$EXTERNALSYM ACM_MPEG_PRIVATEBIT}
  ACM_MPEG_COPYRIGHT      = $0002;
  {$EXTERNALSYM ACM_MPEG_COPYRIGHT}
  ACM_MPEG_ORIGINALHOME   = $0004;
  {$EXTERNALSYM ACM_MPEG_ORIGINALHOME}
  ACM_MPEG_PROTECTIONBIT  = $0008;
  {$EXTERNALSYM ACM_MPEG_PROTECTIONBIT}
  ACM_MPEG_ID_MPEG1       = $0010;
  {$EXTERNALSYM ACM_MPEG_ID_MPEG1}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IMpegAudioDecoder> _di_IMpegAudioDecoder;'}
  {$EXTERNALSYM IMpegAudioDecoder}
  IMpegAudioDecoder = interface(IUnknown)
    ['{B45DD570-3C77-11D1-ABE1-00A0C905F375}']
    (*** IMpegAudioDecoder methods ***)
    function get_FrequencyDivider(out pDivider: LongWord): HResult; stdcall;
    function put_FrequencyDivider(Divider: LongWord): HResult; stdcall;
    function get_DecoderAccuracy(out pAccuracy: LongWord): HResult; stdcall;
    function put_DecoderAccuracy(Accuracy: LongWord): HResult; stdcall;
    function get_Stereo(out pStereo: LongWord): HResult; stdcall;
    function put_Stereo(Stereo: LongWord): HResult; stdcall;
    function get_DecoderWordSize(out pWordSize: LongWord): HResult; stdcall;
    function put_DecoderWordSize(WordSize: LongWord): HResult; stdcall;
    function get_IntegerDecode(out pIntDecode: LongWord): HResult; stdcall;
    function put_IntegerDecode(IntDecode: LongWord): HResult; stdcall;
    function get_DualMode(out pIntDecode: LongWord): HResult; stdcall;
    function put_DualMode(IntDecode: LongWord): HResult; stdcall;
    function get_AudioFormat(out lpFmt: TMPEG1WaveFormat): HResult; stdcall;
  end;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       il21dec.h
 *
 ***************************************************************************)
// Line 21 Decoder related definitions and interfaces for ActiveMovie

const
  IID_IAMLine21Decoder: TGUID = (D1:$6E8D4A21;D2:$310C;D3:$11D0;D4:($B7,$9A,$00,$AA,$00,$37,$67,$A7));
  {$EXTERNALSYM IID_IAMLine21Decoder}

type
//
//  Some enum data types used as line 21 decoder params by the interface
//
  _AM_LINE21_CCLEVEL = (       // should we use TC1, TC2 in stead?
    AM_L21_CCLEVEL_TC2
  );
  {$EXTERNALSYM _AM_LINE21_CCLEVEL}
  AM_LINE21_CCLEVEL = _AM_LINE21_CCLEVEL;
  {$EXTERNALSYM AM_LINE21_CCLEVEL}
  PAM_LINE21_CCLEVEL = ^AM_LINE21_CCLEVEL;
  {$EXTERNALSYM PAM_LINE21_CCLEVEL}
  TAMLine21CCLevel = AM_LINE21_CCLEVEL;

  _AM_LINE21_CCSERVICE = (
  {$IFNDEF COMPILER6_UP}
    AM_L21_CCSERVICE_None,
    AM_L21_CCSERVICE_Caption1,
    AM_L21_CCSERVICE_Caption2,
    AM_L21_CCSERVICE_Text1,
    AM_L21_CCSERVICE_Text2,
    AM_L21_CCSERVICE_XDS,
    AM_L21_CCSERVICE_INVALID_6,
    AM_L21_CCSERVICE_INVALID_7,
    AM_L21_CCSERVICE_INVALID_8,
    AM_L21_CCSERVICE_INVALID_9,
    AM_L21_CCSERVICE_DefChannel,
    AM_L21_CCSERVICE_Invalid
  {$ELSE}
    AM_L21_CCSERVICE_None       = 0,
    AM_L21_CCSERVICE_Caption1   = 1,
    AM_L21_CCSERVICE_Caption2   = 2,
    AM_L21_CCSERVICE_Text1      = 3,
    AM_L21_CCSERVICE_Text2      = 4,
    AM_L21_CCSERVICE_XDS        = 5,
    AM_L21_CCSERVICE_DefChannel = 10,
    AM_L21_CCSERVICE_Invalid    = 11
  {$ENDIF}
  );
  {$EXTERNALSYM _AM_LINE21_CCSERVICE}
  AM_LINE21_CCSERVICE = _AM_LINE21_CCSERVICE;
  {$EXTERNALSYM AM_LINE21_CCSERVICE}
  PAM_LINE21_CCSERVICE = ^AM_LINE21_CCSERVICE;
  {$EXTERNALSYM PAM_LINE21_CCSERVICE}
  TAMLine21CCService = AM_LINE21_CCSERVICE;

  _AM_LINE21_CCSTATE = (
    AM_L21_CCSTATE_Off,
    AM_L21_CCSTATE_On
  );
  {$EXTERNALSYM _AM_LINE21_CCSTATE}
  AM_LINE21_CCSTATE = _AM_LINE21_CCSTATE;
  {$EXTERNALSYM AM_LINE21_CCSTATE}
  PAM_LINE21_CCSTATE = ^AM_LINE21_CCSTATE;
  {$EXTERNALSYM PAM_LINE21_CCSTATE}
  TAMLine21CCState = AM_LINE21_CCSTATE;

  _AM_LINE21_CCSTYLE = (
    AM_L21_CCSTYLE_None,
    AM_L21_CCSTYLE_PopOn,
    AM_L21_CCSTYLE_PaintOn,
    AM_L21_CCSTYLE_RollUp
  );
  {$EXTERNALSYM _AM_LINE21_CCSTYLE}
  AM_LINE21_CCSTYLE = _AM_LINE21_CCSTYLE;
  {$EXTERNALSYM AM_LINE21_CCSTYLE}
  PAM_LINE21_CCSTYLE = ^AM_LINE21_CCSTYLE;
  {$EXTERNALSYM PAM_LINE21_CCSTYLE}
  TAMLine21CCStyle = AM_LINE21_CCSTYLE;

  _AM_LINE21_DRAWBGMODE = (
    AM_L21_DRAWBGMODE_Opaque,
    AM_L21_DRAWBGMODE_Transparent
  );
  {$EXTERNALSYM _AM_LINE21_DRAWBGMODE}
  AM_LINE21_DRAWBGMODE = _AM_LINE21_DRAWBGMODE;
  {$EXTERNALSYM AM_LINE21_DRAWBGMODE}
  PAM_LINE21_DRAWBGMODE = ^AM_LINE21_DRAWBGMODE;
  {$EXTERNALSYM PAM_LINE21_DRAWBGMODE}
  TAMLine21DrawBGMode = AM_LINE21_DRAWBGMODE;
  
//
//  Line 21 Decoder standard COM interface
//
  {$HPPEMIT 'typedef System::DelphiInterface<IAMLine21Decoder> _di_IAMLine21Decoder;'}
  {$EXTERNALSYM IAMLine21Decoder}
  IAMLine21Decoder = interface(IUnknown)
    ['{6E8D4A21-310C-11D0-B79A-00AA003767A7}']
    (*** IAMLine21Decoder methods ***)
    //
    // Decoder options to be used by apps
    //

    // What is the decoder's level
    function GetDecoderLevel(var lpLevel: TAMLine21CCLevel): HResult; stdcall;
    // supported level value is AM_L21Level_TC2 only
    // skipping the SetDecoderLevel( )

    // Which of the services is being currently used
    function GetCurrentService(var lpService: TAMLine21CCService): HResult;
        stdcall;
    function SetCurrentService(Service: TAMLine21CCService): HResult;
        stdcall;
    // supported service values are AM_L21Service_Caption1,
    // AM_L21Service_Caption2, AM_L21Service_Text1, AM_L21Service_Text2,
    // AM_L21Service_XDS, AM_L21Service_None)

    // Query/Set the service state (On/Off)
    // supported state values are AM_L21State_On and AM_L21State_Off
    function GetServiceState(var lpState: TAMLine21CCState): HResult;
        stdcall;
    function SetServiceState(State: TAMLine21CCState): HResult;
        stdcall;

    //
    // Output options to be used by downstream filters
    //

    // What size, bitdepth etc should the output video be
    function GetOutputFormat(lpbmih: PBitmapInfoHeader): HResult; stdcall;
    // GetOutputFormat() method, if successful, returns
    // 1.  S_FALSE if no output format has so far been defined by downstream filters
    // 2.  S_OK if an output format has already been defined by downstream filters
    function SetOutputFormat(lpbmih: PBitmapInfoHeader): HResult;
        stdcall;

    // Specify physical color to be used in colorkeying the background
    // for overlay mixing
    function GetBackgroundColor(var pdwPhysColor: DWORD): HResult; stdcall;
    function SetBackgroundColor(dwPhysColor: DWORD): HResult; stdcall;

    // Specify if whole output bitmap should be redrawn for each sample
    function GetRedrawAlways(lpbOption: PBOOL): HResult; stdcall;
    function SetRedrawAlways(bOption: BOOL): HResult; stdcall;

    // Specify if the caption text background should be opaque/transparent
    function GetDrawBackgroundMode(var lpMode: TAMLine21DrawBGMode): HResult;
        stdcall;
    function SetDrawBackgroundMode(Mode: TAMLine21DrawBGMode): HResult;
        stdcall;
    // supported mode values are AM_L21_DrawBGMode_Opaque and
    // AM_L21_DrawBGMode_Transparent
  end;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       dvdevcod.h
 *
 ***************************************************************************)
// list of standard DVD-Video event codes and the expected params

const
  EC_DVDBASE                                                    = $0100;
  {$EXTERNALSYM EC_DVDBASE}

type
  _tagDVD_ERROR = (
  {$IFNDEF COMPILER6_UP}
    DVD_ERROR_INVALID_0,
    DVD_ERROR_Unexpected,           // Something unexpected happened, perhaps content
                                    //   is incorrectly authored.  Playback is stopped.
    DVD_ERROR_CopyProtectFail,      // Key exchange for DVD copy protection failed.
                                    //   Playback is stopped.
    DVD_ERROR_InvalidDVD1_0Disc,    // DVD-Video disc is incorrectly authored for v1.0
                                    //   of spec. Playback is stopped.
    DVD_ERROR_InvalidDiscRegion,    // The Disc is not approved for playback by decoders
                                    //   from this DVD region.
    DVD_ERROR_LowParentalLevel,      // Player parental level is lower than the lowest parental
                                    //   level available in the DVD content. Playback is stopped.
    DVD_ERROR_MacrovisionFail,    // Macrovision Distribution Failed.
                                    // Playback is stopped.
    DVD_ERROR_IncompatibleSystemAndDecoderRegions,
                                    // No discs can be played because the system region
                                    // does not match the decoder region.
    DVD_ERROR_IncompatibleDiscAndDecoderRegions
                                    // The disc cannot be played because the disc is
                                    // not authored to be played in the decoder's region
  {$ELSE}
    DVD_ERROR_Unexpected        = 1,  // Something unexpected happened, perhaps content
                                      //   is incorrectly authored.  Playback is stopped.
    DVD_ERROR_CopyProtectFail   = 2,  // Key exchange for DVD copy protection failed.
                                      //   Playback is stopped.
    DVD_ERROR_InvalidDVD1_0Disc = 3,  // DVD-Video disc is incorrectly authored for v1.0
                                      //   of spec. Playback is stopped.
    DVD_ERROR_InvalidDiscRegion = 4,  // The Disc is not approved for playback by decoders
                                      //   from this DVD region.
    DVD_ERROR_LowParentalLevel  = 5,  // Player parental level is lower than the lowest parental
                                      //   level available in the DVD content. Playback is stopped.
    DVD_ERROR_MacrovisionFail   = 6,  // Macrovision Distribution Failed.
                                      // Playback is stopped.
    DVD_ERROR_IncompatibleSystemAndDecoderRegions = 7,
                                      // No discs can be played because the system region
                                      // does not match the decoder region.
    DVD_ERROR_IncompatibleDiscAndDecoderRegions = 8
                                      // The disc cannot be played because the disc is
                                      // not authored to be played in the decoder's region
  {$ENDIF}
  );
  {$EXTERNALSYM _tagDVD_ERROR}
  DVD_ERROR = _tagDVD_ERROR;
  {$EXTERNALSYM DVD_ERROR}
  TDVDError = DVD_ERROR;

  _tagDVD_WARNING = (
  {$IFNDEF COMPILER6_UP}
    DVD_WARNING_INVALID_0,
    DVD_WARNING_InvalidDVD1_0Disc,   // DVD-Video disc is incorrectly authored. Playback
                                     //   can continue, but unexpected behavior may occur.
    DVD_WARNING_FormatNotSupported,  // A decoder would not support the current format.  Playback
                                     //   of a stream (audio, video of SP) may not function.
                                     //   lParam2 contains the stream type (see AM_DVD_STREAM_FLAGS) -> Windows XP
    DVD_WARNING_IllegalNavCommand,   // The internal DVD navigation command processor attempted to
                                     //   process an illegal command.
    DVD_WARNING_Open,                // File Open Failed
    DVD_WARNING_Seek,                // File Seek Failed
    DVD_WARNING_Read                 // File Read Failed
  {$ELSE}
    DVD_WARNING_InvalidDVD1_0Disc  = 1, // DVD-Video disc is incorrectly authored. Playback
                                        //   can continue, but unexpected behavior may occur.
    DVD_WARNING_FormatNotSupported = 2, // A decoder would not support the current format.  Playback
                                        //   of a stream (audio, video of SP) may not function.
                                        //   lParam2 contains the stream type (see AM_DVD_STREAM_FLAGS) -> Windows XP
    DVD_WARNING_IllegalNavCommand = 3,  // The internal DVD navigation command processor attempted to
                                        //   process an illegal command.
    DVD_WARNING_Open = 4,               // File Open Failed
    DVD_WARNING_Seek = 5,               // File Seek Failed
    DVD_WARNING_Read = 6                // File Read Failed
  {$ENDIF}
  );
  {$EXTERNALSYM _tagDVD_WARNING}
  DVD_WARNING = _tagDVD_WARNING;
  {$EXTERNALSYM DVD_WARNING}
  TDVDWarning = DVD_WARNING;

  _tagDVD_PB_STOPPED = (
    DVD_PB_STOPPED_Other,               // The navigator stopped the playback (no reason available).
    DVD_PB_STOPPED_NoBranch,            // The nav completed the current pgc and there was no more video and
                                        // did not find any other branching instruction for subsequent playback.
    DVD_PB_STOPPED_NoFirstPlayDomain,   // The disc does not contain an initial startup program.
    DVD_PB_STOPPED_StopCommand,         // The app issued a stop() command or a stop command was authored on the disc.
    DVD_PB_STOPPED_Reset,               // The navigator was reset to the start of the disc (using ResetOnStop).
    DVD_PB_STOPPED_DiscEjected,         // The disc was ejected.
    DVD_PB_STOPPED_IllegalNavCommand,   // An illegal nav command prevented playback from continuing.
    DVD_PB_STOPPED_PlayPeriodAutoStop,  // PlayPeriod completed
    DVD_PB_STOPPED_PlayChapterAutoStop, // PlayChapter completed
    DVD_PB_STOPPED_ParentalFailure,     // A parental level failure prevented playback
    DVD_PB_STOPPED_RegionFailure,       // A region failure prevented playback
    DVD_PB_STOPPED_MacrovisionFailure,  // A Macrovision failure prevented playback.
    DVD_PB_STOPPED_DiscReadError,       // A read error prevented playback.
    DVD_PB_STOPPED_CopyProtectFailure   // Copy protection failure.
  );
  {$EXTERNALSYM _tagDVD_PB_STOPPED}
  DVD_PB_STOPPED = _tagDVD_PB_STOPPED;
  {$EXTERNALSYM DVD_PB_STOPPED}
  TDVDPBStopped = DVD_PB_STOPPED;

const

// DVD-Video event codes
// ======================
//
// All DVD-Video event are always passed on to the application, and are
// never processed by the filter graph


  EC_DVD_DOMAIN_CHANGE                    = (EC_DVDBASE + $01);
  {$EXTERNALSYM EC_DVD_DOMAIN_CHANGE}
// Parameters: ( DWORD, void )
// lParam1 is enum DVD_DOMAIN, and indicates the player's new domain
//
// Raised from following domains: all
//
// Signaled when ever the DVD player changes domains.


  EC_DVD_TITLE_CHANGE                     = (EC_DVDBASE + $02);
  {$EXTERNALSYM EC_DVD_TITLE_CHANGE}
// Parameters: ( DWORD, void )
// lParam1 is the new title number.
//
// Raised from following domains: DVD_DOMAIN_Title
//
// Indicates when the current title number changes.  Title numbers
// range 1 to 99.  This indicates the TTN, which is the title number
// with respect to the whole disc, not the VTS_TTN which is the title
// number with respect to just a current VTS.


  EC_DVD_CHAPTER_START                   = (EC_DVDBASE + $03);
  {$EXTERNALSYM EC_DVD_CHAPTER_START}
// Parameters: ( DWORD, void )
// lParam1 is the new chapter number (which is the program number for
// One_Sequential_PGC_Titles).
//
// Raised from following domains: DVD_DOMAIN_Title
//
// Signales that DVD player started playback of a new program in the Title
// domain.  This is only signaled for One_Sequential_PGC_Titles.


  EC_DVD_AUDIO_STREAM_CHANGE              = (EC_DVDBASE + $04);
  {$EXTERNALSYM EC_DVD_AUDIO_STREAM_CHANGE}
// Parameters: ( DWORD, void )
// lParam1 is the new user audio stream number.
//
// Raised from following domains: all
//
// Signaled when ever the current user audio stream number changes for the main
// title.  This can be changed automatically with a navigation command on disc
// as well as through IDVDAnnexJ.
// Audio stream numbers range from 0 to 7.  Stream $ffffffff
// indicates that no stream is selected.

  EC_DVD_SUBPICTURE_STREAM_CHANGE         = (EC_DVDBASE + $05);
  {$EXTERNALSYM EC_DVD_SUBPICTURE_STREAM_CHANGE}
// Parameters: ( DWORD, BOOL ) -> WindowsXP
// Parameters: ( DWORD, void )
// lParam1 is the new user subpicture stream number.
// lParam2 is the subpicture's on/off state (TRUE if on) -> WindowsXP

// Raised from following domains: all
//
// Signaled when ever the current user subpicture stream number changes for the main
// title.  This can be changed automatically with a navigation command on disc
// as well as through IDVDAnnexJ.
// Subpicture stream numbers range from 0 to 31.  Stream $ffffffff
// indicates that no stream is selected.

  EC_DVD_ANGLE_CHANGE                     = (EC_DVDBASE + $06);
  {$EXTERNALSYM EC_DVD_ANGLE_CHANGE}
// Parameters: ( DWORD, DWORD )
// lParam1 is the number of available angles.
// lParam2 is the current user angle number.
//
// Raised from following domains: all
//
// Signaled when ever either
//   a) the number of available angles changes, or
//   b) the current user angle number changes.
// Current angle number can be changed automatically with navigation command
// on disc as well as through IDVDAnnexJ.
// When the number of available angles is 1, the current video is not multiangle.
// Angle numbers range from 1 to 9.


  EC_DVD_BUTTON_CHANGE                    = (EC_DVDBASE + $07);
  {$EXTERNALSYM EC_DVD_BUTTON_CHANGE}
// Parameters: ( DWORD, DWORD )
// lParam1 is the number of available buttons.
// lParam2 is the current selected button number.
//
// Raised from following domains: all
//
// Signaled when ever either
//   a) the number of available buttons changes, or
//   b) the current selected button number changes.
// The current selected button can be changed automatically with navigation
// commands on disc as well as through IDVDAnnexJ.
// Button numbers range from 1 to 36.  Selected button number 0 implies that
// no button is selected.  Note that these button numbers enumerate all
// available button numbers, and do not always correspond to button numbers
// used for IDVDAnnexJ::ButtonSelectAndActivate since only a subset of buttons
// may be activated with ButtonSelectAndActivate.


  EC_DVD_VALID_UOPS_CHANGE                = (EC_DVDBASE + $08);
  {$EXTERNALSYM EC_DVD_VALID_UOPS_CHANGE}
// Parameters: ( DWORD, void )
// lParam1 is a VALID_UOP_SOMTHING_OR_OTHER bit-field stuct which indicates
//   which IDVDAnnexJ commands are explicitly disable by the DVD disc.
//
// Raised from following domains: all
//
// Signaled when ever the available set of IDVDAnnexJ methods changes.  This
// only indicates which operations are explicited disabled by the content on
// the DVD disc, and does not guarentee that it is valid to call methods
// which are not disabled.  For example, if no buttons are currently present,
// IDVDAnnexJ::ButtonActivate() won't work, even though the buttons are not
// explicitly disabled.


  EC_DVD_STILL_ON                         = (EC_DVDBASE + $09);
  {$EXTERNALSYM EC_DVD_STILL_ON}
// Parameters: ( BOOL, DWORD )
// lParam1 == 0  -->  buttons are available, so StillOff won't work
// lParam1 == 1  -->  no buttons available, so StillOff will work
// lParam2 indicates the number of seconds the still will last, with $ffffffff
//   indicating an infinite still (wait till button or StillOff selected).
//
// Raised from following domains: all
//
// Signaled at the beginning of any still: PGC still, Cell Still, or VOBU Still.
// Note that all combinations of buttons and still are possible (buttons on with
// still on, buttons on with still off, button off with still on, button off
// with still off).

  EC_DVD_STILL_OFF                         = (EC_DVDBASE + $0a);
  {$EXTERNALSYM EC_DVD_STILL_OFF}
// Parameters: ( void, void )
//
//   Indicating that any still that is currently active
//   has been released.
//
// Raised from following domains: all
//
// Signaled at the end of any still: PGC still, Cell Still, or VOBU Still.
//

  EC_DVD_CURRENT_TIME                     = (EC_DVDBASE + $0b);
  {$EXTERNALSYM EC_DVD_CURRENT_TIME}
// Parameters: ( DWORD, BOOL )
// lParam1 is a DVD_TIMECODE which indicates the current
//   playback time code in a BCD HH:MM:SS:FF format.
// lParam2 == 0  -->  time code is 25 frames/sec
// lParam2 == 1  -->  time code is 30 frames/sec (non-drop).
//
// Raised from following domains: DVD_DOMAIN_Title
//
// Signaled at the beginning of every VOBU, which occurs every .4 to 1.0 sec.
// This is only signaled for One_Sequential_PGC_Titles.


  EC_DVD_ERROR                            = (EC_DVDBASE + $0c);
  {$EXTERNALSYM EC_DVD_ERROR}
// Parameters: ( DWORD, void)
// lParam1 is an enum DVD_ERROR which notifies the app of some error condition.
//
// Raised from following domains: all
//

  EC_DVD_WARNING                           = (EC_DVDBASE + $0d);
  {$EXTERNALSYM EC_DVD_WARNING}
// Parameters: ( DWORD, DWORD) -> WindowsXP
// Parameters: ( DWORD, void)
// lParam1 is an enum DVD_WARNING which notifies the app of some warning condition.
// lParam2 contains more specific information about the warning (warning dependent) -> WindowsXP

// Raised from following domains: all
//

  EC_DVD_CHAPTER_AUTOSTOP                  = (EC_DVDBASE + $0e);
  {$EXTERNALSYM EC_DVD_CHAPTER_AUTOSTOP}
// Parameters: (void, void)
//
//  Indicating that playback is stopped as a result of a call
//  to IDVDControl::ChapterPlayAutoStop()
//
// Raised from following domains : DVD_DOMAIN_TITLE
//

  EC_DVD_NO_FP_PGC                         = (EC_DVDBASE + $0f);
  {$EXTERNALSYM EC_DVD_NO_FP_PGC}
//  Parameters : (void, void)
//
//  Raised from the following domains : FP_DOM
//
//  Indicates that the DVD disc does not have a FP_PGC (First Play Program Chain)
//  and the DVD Navigator will not automatically load any PGC and start playback.
//

  EC_DVD_PLAYBACK_RATE_CHANGE              = (EC_DVDBASE + $10);
  {$EXTERNALSYM EC_DVD_PLAYBACK_RATE_CHANGE}
//  Parameters : (LONG, void)
//  lParam1 is a LONG indicating the new playback rate.
//  lParam1 < 0 indicates reverse playback mode.
//  lParam1 > 0 indicates forward playback mode
//  Value of lParam1 is the actual playback rate multiplied by 10000.
//  i.e. lParam1 = rate * 10000
//
//  Raised from the following domains : TT_DOM
//
//  Indicates that a rate change in playback has been initiated and the parameter
//  lParam1 indicates the new playback rate that is being used.
//

  EC_DVD_PARENTAL_LEVEL_CHANGE             = (EC_DVDBASE + $11);
  {$EXTERNALSYM EC_DVD_PARENTAL_LEVEL_CHANGE}
//  Parameters : (LONG, void)
//  lParam1 is a LONG indicating the new parental level.
//
//  Raised from the following domains : VMGM_DOM
//
//  Indicates that an authored Nav command has changed the parental level
//  setting in the player.
//

  EC_DVD_PLAYBACK_STOPPED                  = (EC_DVDBASE + $12);
  {$EXTERNALSYM EC_DVD_PLAYBACK_STOPPED}
//  Parameters : (DWORD, void)
//
//  Raised from the following domains : All Domains
//
// Indicates that playback has been stopped as the Navigator has completed
// playback of the pgc and did not find any other branching instruction for
// subsequent playback.
//
//  The DWORD returns the reason for the completion of the playback.  See
//  The DVD_PB_STOPPED enumeration for details.
//

  EC_DVD_ANGLES_AVAILABLE                  = (EC_DVDBASE + $13);
  {$EXTERNALSYM EC_DVD_ANGLES_AVAILABLE}
//  Parameters : (BOOL, void)
//  lParam1 == 0 indicates that playback is not in an angle block and angles are
//             not available
//  lParam1 == 1 indicates that an angle block is being played back and angle changes
//             can be performed.
//
//  Indicates whether an angle block is being played and if angle changes can be
//  performed. However, angle changes are not restricted to angle blocks and the
//  manifestation of the angle change can be seen only in an angle block.

  EC_DVD_PLAYPERIOD_AUTOSTOP               = (EC_DVDBASE + $14);
  {$EXTERNALSYM EC_DVD_PLAYPERIOD_AUTOSTOP}
// Parameters: (void, void)
// Sent when the PlayPeriodInTitle completes or is cancelled
//
// Raised from following domains : DVD_DOMAIN_TITLE
//

  EC_DVD_BUTTON_AUTO_ACTIVATED             = (EC_DVDBASE + $15);
  {$EXTERNALSYM EC_DVD_BUTTON_AUTO_ACTIVATED}
// Parameters: (DWORD button, void)
// Sent when a button is automatically activated
//
// Raised from following domains : DVD_DOMAIN_MENU
//

  EC_DVD_CMD_START                         = (EC_DVDBASE + $16);
  {$EXTERNALSYM EC_DVD_CMD_START}
// Parameters: (CmdID, HResult)
// Sent when a command begins
//

  EC_DVD_CMD_END                           = (EC_DVDBASE + $17);
  {$EXTERNALSYM EC_DVD_CMD_END}
// Parameters: (CmdID, HResult)
// Sent when a command completes
//

  EC_DVD_DISC_EJECTED                      = (EC_DVDBASE + $18);
  {$EXTERNALSYM EC_DVD_DISC_EJECTED}
// Parameters: none
// Sent when the nav detects that a disc was ejected and stops the playback
// The app does not need to take any action to stop the playback.
//

  EC_DVD_DISC_INSERTED                     = (EC_DVDBASE + $19);
  {$EXTERNALSYM EC_DVD_DISC_INSERTED}
// Parameters: none
// Sent when the nav detects that a disc was inserted and the nav begins playback
// The app does not need to take any action to start the playback.
//

  EC_DVD_CURRENT_HMSF_TIME                 = (EC_DVDBASE + $1a);
  {$EXTERNALSYM EC_DVD_CURRENT_HMSF_TIME}
// Parameters: ( ULONG, ULONG )
// lParam2 contains a union of the DVD_TIMECODE_FLAGS
// lParam1 contains a DVD_HMSF_TIMECODE.  Assign lParam1 to a ULONG then cast the
// ULONG as a DVD_HMSF_TIMECODE to use its values.
//
// Raised from following domains: DVD_DOMAIN_Title
//
// Signaled at the beginning of every VOBU, which occurs every .4 to 1.0 sec.

  EC_DVD_KARAOKE_MODE                      = (EC_DVDBASE + $1b);
  {$EXTERNALSYM EC_DVD_KARAOKE_MODE}
// Parameters: ( BOOL, reserved )
// lParam1 is either TRUE (a karaoke track is being played) or FALSE (no karaoke data is being played).
//

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       dvdmedia.h
 *
 ***************************************************************************)

type
// -----------------------------------------------------------------------
// AC-3 definition for the AM_KSPROPSETID_AC3 property set
// -----------------------------------------------------------------------
  AM_PROPERTY_AC3 = (
    AM_PROPERTY_AC3_INVALID_0,
    AM_PROPERTY_AC3_ERROR_CONCEALMENT,
    AM_PROPERTY_AC3_ALTERNATE_AUDIO,
    AM_PROPERTY_AC3_DOWNMIX,
    AM_PROPERTY_AC3_BIT_STREAM_MODE,
    AM_PROPERTY_AC3_DIALOGUE_LEVEL,
    AM_PROPERTY_AC3_LANGUAGE_CODE,
    AM_PROPERTY_AC3_ROOM_TYPE
  );
  {$EXTERNALSYM AM_PROPERTY_AC3}
  TAMPropertyAC3 = AM_PROPERTY_AC3;

  AM_AC3_ERROR_CONCEALMENT = record
    fRepeatPreviousBlock: BOOL;
    fErrorInCurrentBlock: BOOL;
  end;
  {$EXTERNALSYM AM_AC3_ERROR_CONCEALMENT}
  PAM_AC3_ERROR_CONCEALMENT = ^AM_AC3_ERROR_CONCEALMENT;
  {$EXTERNALSYM PAM_AC3_ERROR_CONCEALMENT}
  TAMAC3ErrorConcelment = AM_AC3_ERROR_CONCEALMENT;

  AM_AC3_ALTERNATE_AUDIO = record
    fStereo: BOOL;
    DualMode: ULONG;
  end;
  {$EXTERNALSYM AM_AC3_ALTERNATE_AUDIO}
  PAM_AC3_ALTERNATE_AUDIO = ^AM_AC3_ALTERNATE_AUDIO;
  {$EXTERNALSYM PAM_AC3_ALTERNATE_AUDIO}
  TAMAC3AlteranateAudio = AM_AC3_ALTERNATE_AUDIO;

const
  AM_AC3_ALTERNATE_AUDIO_1     = 1;
  {$EXTERNALSYM AM_AC3_ALTERNATE_AUDIO_1}
  AM_AC3_ALTERNATE_AUDIO_2     = 2;
  {$EXTERNALSYM AM_AC3_ALTERNATE_AUDIO_2}
  AM_AC3_ALTERNATE_AUDIO_BOTH   = 3;
  {$EXTERNALSYM AM_AC3_ALTERNATE_AUDIO_BOTH}

type
  AM_AC3_DOWNMIX = record
    fDownMix       : BOOL;
    fDolbySurround : BOOL;
  end;
  {$EXTERNALSYM AM_AC3_DOWNMIX}
  PAM_AC3_DOWNMIX = ^AM_AC3_DOWNMIX;
  {$EXTERNALSYM PAM_AC3_DOWNMIX}
  TAMAC3DownMix = AM_AC3_DOWNMIX;

  AM_AC3_BIT_STREAM_MODE = record
    BitStreamMode: Longint;
  end;
  {$EXTERNALSYM AM_AC3_BIT_STREAM_MODE}
  PAM_AC3_BIT_STREAM_MODE = ^AM_AC3_BIT_STREAM_MODE;
  {$EXTERNALSYM PAM_AC3_BIT_STREAM_MODE}
  TAMAC3BitStreamMode = AM_AC3_BIT_STREAM_MODE;
const
  AM_AC3_SERVICE_MAIN_AUDIO        = 0;
  {$EXTERNALSYM AM_AC3_SERVICE_MAIN_AUDIO}
  AM_AC3_SERVICE_NO_DIALOG         = 1;
  {$EXTERNALSYM AM_AC3_SERVICE_NO_DIALOG}
  AM_AC3_SERVICE_VISUALLY_IMPAIRED = 2;
  {$EXTERNALSYM AM_AC3_SERVICE_VISUALLY_IMPAIRED}
  AM_AC3_SERVICE_HEARING_IMPAIRED  = 3;
  {$EXTERNALSYM AM_AC3_SERVICE_HEARING_IMPAIRED}
  AM_AC3_SERVICE_DIALOG_ONLY       = 4;
  {$EXTERNALSYM AM_AC3_SERVICE_DIALOG_ONLY}
  AM_AC3_SERVICE_COMMENTARY        = 5;
  {$EXTERNALSYM AM_AC3_SERVICE_COMMENTARY}
  AM_AC3_SERVICE_EMERGENCY_FLASH   = 6;
  {$EXTERNALSYM AM_AC3_SERVICE_EMERGENCY_FLASH}
  AM_AC3_SERVICE_VOICE_OVER        = 7;
  {$EXTERNALSYM AM_AC3_SERVICE_VOICE_OVER}

type
  AM_AC3_DIALOGUE_LEVEL = record
    DialogueLevel: ULONG;
  end;
  {$EXTERNALSYM AM_AC3_DIALOGUE_LEVEL}
  PAM_AC3_DIALOGUE_LEVEL = ^AM_AC3_DIALOGUE_LEVEL;
  {$EXTERNALSYM PAM_AC3_DIALOGUE_LEVEL}
  TAMAC3DialogueLevel = AM_AC3_DIALOGUE_LEVEL;

  AM_AC3_ROOM_TYPE = record
    fLargeRoom: BOOL;
  end;
  {$EXTERNALSYM AM_AC3_ROOM_TYPE}
  PAM_AC3_ROOM_TYPE = ^AM_AC3_ROOM_TYPE;
  {$EXTERNALSYM PAM_AC3_ROOM_TYPE}
  TAMAC3RoomType = AM_AC3_ROOM_TYPE;
  
// -----------------------------------------------------------------------
// subpicture definition for the AM_KSPROPSETID_DvdSubPic property set
// -----------------------------------------------------------------------

  AM_PROPERTY_DVDSUBPIC = (
    AM_PROPERTY_DVDSUBPIC_PALETTE,
    AM_PROPERTY_DVDSUBPIC_HLI,
    AM_PROPERTY_DVDSUBPIC_COMPOSIT_ON   // TRUE for subpicture is displayed
  );
  {$EXTERNALSYM AM_PROPERTY_DVDSUBPIC}
  TAM_Property_DVDSubpic = AM_PROPERTY_DVDSUBPIC;

  _AM_DVD_YUV = record
    Reserved: Byte;
    Y: byte;
    U: Byte;
    V: Byte;
  end;
  {$EXTERNALSYM _AM_DVD_YUV}
  AM_DVD_YUV = _AM_DVD_YUV;
  {$EXTERNALSYM AM_DVD_YUV}
  TAMDVDYUV = _AM_DVD_YUV;

  _AM_PROPERTY_SPPAL = record
    sppal: array[0..15] of TAMDVDYUV;
  end;
  {$EXTERNALSYM _AM_PROPERTY_SPPAL}
  AM_PROPERTY_SPPAL = _AM_PROPERTY_SPPAL;
  {$EXTERNALSYM AM_PROPERTY_SPPAL}
  PAM_PROPERTY_SPPAL = ^AM_PROPERTY_SPPAL;
  {$EXTERNALSYM PAM_PROPERTY_SPPAL}
  TAMPropertySPPAL = _AM_PROPERTY_SPPAL;

  _AM_COLCON = record
    emph1col : Byte;
    emph2col : Byte;
    backcol  : Byte;
    patcol   : Byte;
    emph1con : Byte;
    emph2con : Byte;
    backcon  : Byte;
    patcon   : Byte;
  end;
  {$EXTERNALSYM _AM_COLCON}
  AM_COLCON = _AM_COLCON;
  {$EXTERNALSYM AM_COLCON}
  PAM_COLCON = ^AM_COLCON;
  {$EXTERNALSYM PAM_COLCON}
  TAMColcon = _AM_COLCON;

  _AM_PROPERTY_SPHLI = record
    HLISS    : Word;      //
    Reserved : Word;
    StartPTM : ULONG;   // start presentation time in x/90000
    EndPTM   : ULONG;     // end PTM in x/90000
    StartX   : Word;
    StartY   : Word;
    StopX    : Word;
    StopY    : Word;
    ColCon   : TAMColCon;     // color contrast description (4 bytes as given in HLI)
  end;
  {$EXTERNALSYM _AM_PROPERTY_SPHLI}
  AM_PROPERTY_SPHLI = _AM_PROPERTY_SPHLI;
  {$EXTERNALSYM AM_PROPERTY_SPHLI}
  TAMPropertySPHLI = _AM_PROPERTY_SPHLI;

  AM_PROPERTY_COMPOSIT_ON = {$IFDEF TYPE_IDENTITY}type {$ENDIF} BOOL;
  {$EXTERNALSYM AM_PROPERTY_COMPOSIT_ON}
  PAM_PROPERTY_COMPOSIT_ON = ^AM_PROPERTY_COMPOSIT_ON;
  {$EXTERNALSYM PAM_PROPERTY_COMPOSIT_ON}

// -----------------------------------------------------------------------
// copy protection definitions
// -----------------------------------------------------------------------

// AM_UseNewCSSKey for the dwTypeSpecificFlags in IMediaSample2 to indicate
// the exact point in a stream after which to start applying a new CSS key.
// This is typically sent on an empty media sample just before attempting
// to renegotiate a CSS key.
const
  AM_UseNewCSSKey    = $1;
  {$EXTERNALSYM AM_UseNewCSSKey}

//
// AM_KSPROPSETID_CopyProt property set definitions
//
  AM_PROPERTY_DVDCOPY_CHLG_KEY       = $01;
  {$EXTERNALSYM AM_PROPERTY_DVDCOPY_CHLG_KEY}
  AM_PROPERTY_DVDCOPY_DVD_KEY1       = $02;
  {$EXTERNALSYM AM_PROPERTY_DVDCOPY_DVD_KEY1}
  AM_PROPERTY_DVDCOPY_DEC_KEY2       = $03;
  {$EXTERNALSYM AM_PROPERTY_DVDCOPY_DEC_KEY2}
  AM_PROPERTY_DVDCOPY_TITLE_KEY      = $04;
  {$EXTERNALSYM AM_PROPERTY_DVDCOPY_TITLE_KEY}
  AM_PROPERTY_COPY_MACROVISION       = $05;
  {$EXTERNALSYM AM_PROPERTY_COPY_MACROVISION}
  AM_PROPERTY_DVDCOPY_REGION         = $06;
  {$EXTERNALSYM AM_PROPERTY_DVDCOPY_REGION}
  AM_PROPERTY_DVDCOPY_SET_COPY_STATE = $07;
  {$EXTERNALSYM AM_PROPERTY_DVDCOPY_SET_COPY_STATE}
  AM_PROPERTY_DVDCOPY_DISC_KEY       = $80;
  {$EXTERNALSYM AM_PROPERTY_DVDCOPY_DISC_KEY}

type
  _AM_DVDCOPY_CHLGKEY = record
    ChlgKey: array[0..9] of Byte;
    Reserved: array[0..1] of Byte;
  end;
  {$EXTERNALSYM _AM_DVDCOPY_CHLGKEY}
  AM_DVDCOPY_CHLGKEY = _AM_DVDCOPY_CHLGKEY;
  {$EXTERNALSYM AM_DVDCOPY_CHLGKEY}
  PAM_DVDCOPY_CHLGKEY = ^AM_DVDCOPY_CHLGKEY;
  {$EXTERNALSYM PAM_DVDCOPY_CHLGKEY}
  TAMDVDCopyCHLGKey = _AM_DVDCOPY_CHLGKEY;

  _AM_DVDCOPY_BUSKEY = record
    BusKey: array[0..4] of Byte;
    Reserved: array[0..0] of Byte;
  end;
  {$EXTERNALSYM _AM_DVDCOPY_BUSKEY}
  AM_DVDCOPY_BUSKEY = _AM_DVDCOPY_BUSKEY;
  {$EXTERNALSYM AM_DVDCOPY_BUSKEY}
  PAM_DVDCOPY_BUSKEY = ^AM_DVDCOPY_BUSKEY;
  {$EXTERNALSYM PAM_DVDCOPY_BUSKEY}
  TAMDVDCopyBusKey = _AM_DVDCOPY_BUSKEY;

  _AM_DVDCOPY_DISCKEY = record
    DiscKey: array[0..2047] of Byte;
  end;
  {$EXTERNALSYM _AM_DVDCOPY_DISCKEY}
  AM_DVDCOPY_DISCKEY = _AM_DVDCOPY_DISCKEY;
  {$EXTERNALSYM AM_DVDCOPY_DISCKEY}
  PAM_DVDCOPY_DISCKEY = ^AM_DVDCOPY_DISCKEY;
  {$EXTERNALSYM PAM_DVDCOPY_DISCKEY}
  TAMDVDCopyDiscKey = _AM_DVDCOPY_DISCKEY;

  AM_DVDCOPY_TITLEKEY = record
    KeyFlags: ULONG;
    Reserved1: array[0..1] of ULONG;
    TitleKey: array[0..5] of Byte;
    Reserved2: array[0..1] of Byte;
  end;
  {$EXTERNALSYM AM_DVDCOPY_TITLEKEY}
  PAM_DVDCOPY_TITLEKEY = AM_DVDCOPY_TITLEKEY;
  {$EXTERNALSYM PAM_DVDCOPY_TITLEKEY}
  TAMDVDCopyTitleKey = AM_DVDCOPY_TITLEKEY;

  _AM_COPY_MACROVISION = record
    MACROVISIONLevel: ULONG;
  end;
  {$EXTERNALSYM _AM_COPY_MACROVISION}
  AM_COPY_MACROVISION = _AM_COPY_MACROVISION;
  {$EXTERNALSYM AM_COPY_MACROVISION}
  PAM_COPY_MACROVISION = ^AM_COPY_MACROVISION;
  {$EXTERNALSYM PAM_COPY_MACROVISION}
  TAMCopyMacroVision = _AM_COPY_MACROVISION;

  AM_DVDCOPY_SET_COPY_STATE = record
    DVDCopyState: ULONG;
  end;
  {$EXTERNALSYM AM_DVDCOPY_SET_COPY_STATE}
  PAM_DVDCOPY_SET_COPY_STATE = ^AM_DVDCOPY_SET_COPY_STATE;
  {$EXTERNALSYM PAM_DVDCOPY_SET_COPY_STATE}
  TAMDVDCopySetCopyState = AM_DVDCOPY_SET_COPY_STATE;

  AM_DVDCOPYSTATE = (
    AM_DVDCOPYSTATE_INITIALIZE,
    AM_DVDCOPYSTATE_INITIALIZE_TITLE,   // indicates we are starting a title
                                        // key copy protection sequence
    AM_DVDCOPYSTATE_AUTHENTICATION_NOT_REQUIRED,
    AM_DVDCOPYSTATE_AUTHENTICATION_REQUIRED,
    AM_DVDCOPYSTATE_DONE
  );
  {$EXTERNALSYM AM_DVDCOPYSTATE}
  TAMDVDCopyState = AM_DVDCOPYSTATE;

  AM_COPY_MACROVISION_LEVEL = (
    AM_MACROVISION_DISABLED,
    AM_MACROVISION_LEVEL1,
    AM_MACROVISION_LEVEL2,
    AM_MACROVISION_LEVEL3
  );
  {$EXTERNALSYM AM_COPY_MACROVISION_LEVEL}
  PAM_COPY_MACROVISION_LEVEL = ^AM_COPY_MACROVISION_LEVEL;
  {$EXTERNALSYM PAM_COPY_MACROVISION_LEVEL}
  TAMCopyMacroVisionLevel = AM_COPY_MACROVISION_LEVEL;

  // CSS region stucture
  _DVD_REGION = record
    CopySystem: Byte;
    RegionData: Byte;
    SystemRegion: Byte;
    Reserved: Byte;
  end;
  {$EXTERNALSYM _DVD_REGION}
  DVD_REGION = _DVD_REGION;
  {$EXTERNALSYM DVD_REGION}
  PDVD_REGION = ^DVD_REGION;
  {$EXTERNALSYM PDVD_REGION}
  TDVDRegion = _DVD_REGION;

//
// CGMS Copy Protection Flags
//

const
  AM_DVD_CGMS_RESERVED_MASK      = $00000078;
  {$EXTERNALSYM AM_DVD_CGMS_RESERVED_MASK}

  AM_DVD_CGMS_COPY_PROTECT_MASK  = $00000018;
  {$EXTERNALSYM AM_DVD_CGMS_COPY_PROTECT_MASK}
  AM_DVD_CGMS_COPY_PERMITTED     = $00000000;
  {$EXTERNALSYM AM_DVD_CGMS_COPY_PERMITTED}
  AM_DVD_CGMS_COPY_ONCE          = $00000010;
  {$EXTERNALSYM AM_DVD_CGMS_COPY_ONCE}
  AM_DVD_CGMS_NO_COPY            = $00000018;
  {$EXTERNALSYM AM_DVD_CGMS_NO_COPY}

  AM_DVD_COPYRIGHT_MASK          = $00000040;
  {$EXTERNALSYM AM_DVD_COPYRIGHT_MASK}
  AM_DVD_NOT_COPYRIGHTED         = $00000000;
  {$EXTERNALSYM AM_DVD_NOT_COPYRIGHTED}
  AM_DVD_COPYRIGHTED             = $00000040;
  {$EXTERNALSYM AM_DVD_COPYRIGHTED}

  AM_DVD_SECTOR_PROTECT_MASK     = $00000020;
  {$EXTERNALSYM AM_DVD_SECTOR_PROTECT_MASK}
  AM_DVD_SECTOR_NOT_PROTECTED    = $00000000;
  {$EXTERNALSYM AM_DVD_SECTOR_NOT_PROTECTED}
  AM_DVD_SECTOR_PROTECTED        = $00000020;
  {$EXTERNALSYM AM_DVD_SECTOR_PROTECTED}


// -----------------------------------------------------------------------
// video format blocks
// -----------------------------------------------------------------------

type
  AM_MPEG2Level = (
  {$IFNDEF COMPILER6_UP}
    AM_MPEG2Level_INVALID_0,
    AM_MPEG2Level_Low,
    AM_MPEG2Level_Main,
    AM_MPEG2Level_High1440,
    AM_MPEG2Level_High
  {$ELSE}
    AM_MPEG2Level_Low      = 1,
    AM_MPEG2Level_Main     = 2,
    AM_MPEG2Level_High1440 = 3,
    AM_MPEG2Level_High     = 4
  {$ENDIF}
  );
  {$EXTERNALSYM AM_MPEG2Level}
  TAMMPEG2Level = AM_MPEG2Level;

  AM_MPEG2Profile = (
  {$IFNDEF COMPILER6_UP}
    AM_MPEG2Profile_0,
    AM_MPEG2Profile_Simple,
    AM_MPEG2Profile_Main,
    AM_MPEG2Profile_SNRScalable,
    AM_MPEG2Profile_SpatiallyScalable,
    AM_MPEG2Profile_High
  {$ELSE}
    AM_MPEG2Profile_Simple            = 1,
    AM_MPEG2Profile_Main              = 2,
    AM_MPEG2Profile_SNRScalable       = 3,
    AM_MPEG2Profile_SpatiallyScalable = 4,
    AM_MPEG2Profile_High              = 5
  {$ENDIF}
  );
  {$EXTERNALSYM AM_MPEG2Profile}
  TAMMPEG2Profile = AM_MPEG2Profile;

const
  AMINTERLACE_IsInterlaced             = $00000001;  // if 0, other interlace bits are irrelevent
  {$EXTERNALSYM AMINTERLACE_IsInterlaced}
  AMINTERLACE_1FieldPerSample          = $00000002;  // else 2 fields per media sample
  {$EXTERNALSYM AMINTERLACE_1FieldPerSample}
  AMINTERLACE_Field1First              = $00000004;  // else Field 2 is first;  top field in PAL is field 1, top field in NTSC is field 2?
  {$EXTERNALSYM AMINTERLACE_Field1First}
  AMINTERLACE_UNUSED                   = $00000008;  //
  {$EXTERNALSYM AMINTERLACE_UNUSED}
  AMINTERLACE_FieldPatternMask         = $00000030;  // use this mask with AMINTERLACE_FieldPat*
  {$EXTERNALSYM AMINTERLACE_FieldPatternMask}
  AMINTERLACE_FieldPatField1Only       = $00000000;  // stream never contains a Field2
  {$EXTERNALSYM AMINTERLACE_FieldPatField1Only}
  AMINTERLACE_FieldPatField2Only       = $00000010;  // stream never contains a Field1
  {$EXTERNALSYM AMINTERLACE_FieldPatField2Only}
  AMINTERLACE_FieldPatBothRegular      = $00000020;  // There will be a Field2 for every Field1 (required for Weave?)
  {$EXTERNALSYM AMINTERLACE_FieldPatBothRegular}
  AMINTERLACE_FieldPatBothIrregular    = $00000030;  // Random pattern of Field1s and Field2s
  {$EXTERNALSYM AMINTERLACE_FieldPatBothIrregular}
  AMINTERLACE_DisplayModeMask          = $000000c0;
  {$EXTERNALSYM AMINTERLACE_DisplayModeMask}
  AMINTERLACE_DisplayModeBobOnly       = $00000000;
  {$EXTERNALSYM AMINTERLACE_DisplayModeBobOnly}
  AMINTERLACE_DisplayModeWeaveOnly     = $00000040;
  {$EXTERNALSYM AMINTERLACE_DisplayModeWeaveOnly}
  AMINTERLACE_DisplayModeBobOrWeave    = $00000080;
  {$EXTERNALSYM AMINTERLACE_DisplayModeBobOrWeave}

  AMCOPYPROTECT_RestrictDuplication    = $00000001;  // duplication of this stream should be restricted
  {$EXTERNALSYM AMCOPYPROTECT_RestrictDuplication}

  AMMPEG2_DoPanScan                    = $00000001;  //if set, the MPEG-2 video decoder should crop output image
  {$EXTERNALSYM AMMPEG2_DoPanScan}                   //  based on pan-scan vectors in picture_display_extension
                                                     //  and change the picture aspect ratio accordingly.
  AMMPEG2_DVDLine21Field1              = $00000002;  //if set, the MPEG-2 decoder must be able to produce an output
  {$EXTERNALSYM AMMPEG2_DVDLine21Field1}             //  pin for DVD style closed caption data found in GOP layer of field 1
  AMMPEG2_DVDLine21Field2              = $00000004;  //if set, the MPEG-2 decoder must be able to produce an output
  {$EXTERNALSYM AMMPEG2_DVDLine21Field2}             //  pin for DVD style closed caption data found in GOP layer of field 2
  AMMPEG2_SourceIsLetterboxed          = $00000008;  //if set, indicates that black bars have been encoded in the top
  {$EXTERNALSYM AMMPEG2_SourceIsLetterboxed}         //  and bottom of the video.
  AMMPEG2_FilmCameraMode               = $00000010;  //if set, indicates "film mode" used for 625/50 content.  If cleared,
  {$EXTERNALSYM AMMPEG2_FilmCameraMode}              //  indicates that "camera mode" was used.
  AMMPEG2_LetterboxAnalogOut           = $00000020;  //if set and this stream is sent to an analog output, it should
  {$EXTERNALSYM AMMPEG2_LetterboxAnalogOut}          //  be letterboxed.  Streams sent to VGA should be letterboxed only by renderers.
  AMMPEG2_DSS_UserData                 = $00000040;  //if set, the MPEG-2 decoder must process DSS style user data
  {$EXTERNALSYM AMMPEG2_DSS_UserData}
  AMMPEG2_DVB_UserData                 = $00000080;  //if set, the MPEG-2 decoder must process DVB style user data
  {$EXTERNALSYM AMMPEG2_DVB_UserData}
  AMMPEG2_27MhzTimebase                = $00000100;  //if set, the PTS,DTS timestamps advance at 27MHz rather than 90KHz
  {$EXTERNALSYM AMMPEG2_27MhzTimebase}

  AMMPEG2_WidescreenAnalogOut          = $00000200;  //if set and this stream is sent to an analog output, it should
  {$EXTERNALSYM AMMPEG2_WidescreenAnalogOut}
                                                     //  be in widescreen format (4x3 content should be centered on a 16x9 output).
                                                     //  Streams sent to VGA should be widescreened only by renderers.

// PRESENT in dwReserved1 field in VIDEOINFOHEADER2
  AMCONTROL_USED                       = $00000001; // Used to test if these flags are supported.  Set and test for AcceptMediaType.
  {$EXTERNALSYM AMCONTROL_USED}                     // If rejected, then you cannot use the AMCONTROL flags (send 0 for dwReserved1)
  AMCONTROL_PAD_TO_4x3                 = $00000002; // if set means display the image in a 4x3 area
  {$EXTERNALSYM AMCONTROL_PAD_TO_4x3}
  AMCONTROL_PAD_TO_16x9                = $00000004; // if set means display the image in a 16x9 area
  {$EXTERNALSYM AMCONTROL_PAD_TO_16x9}

type
  TVideoInfoHeader2ControlFlags = record
     case byte of
      0: (dwControlFlags : DWORD);   // use AMCONTROL_* defines, use this from now on
      1: (dwReserved1    : DWORD);   // for backward compatiblity (was "must be 0";  connection rejected otherwise)
  end;
  {$EXTERNALSYM TVideoInfoHeader2ControlFlags}

  PVideoInfoHeader2 = ^TVideoInfoHeader2;
  tagVIDEOINFOHEADER2 = record
    rcSource: TRect;
    rcTarget: TRect;
    dwBitRate: DWORD;
    dwBitErrorRate: DWORD;
    AvgTimePerFrame: TReferenceTime;
    dwInterlaceFlags: DWORD;         // use AMINTERLACE_* defines. Reject connection if undefined bits are not 0
    dwCopyProtectFlags: DWORD;       // use AMCOPYPROTECT_* defines. Reject connection if undefined bits are not 0
    dwPictAspectRatioX: DWORD;       // X dimension of picture aspect ratio, e.g. 16 for 16x9 display
    dwPictAspectRatioY: DWORD;       // Y dimension of picture aspect ratio, e.g.  9 for 16x9 display
    ControlFlags: TVideoInfoHeader2ControlFlags;
    dwReserved2: DWORD;              // must be 0; reject connection otherwise
    bmiHeader: TBitmapInfoHeader;
  end;
  {$EXTERNALSYM tagVIDEOINFOHEADER2}
  VIDEOINFOHEADER2 = tagVIDEOINFOHEADER2;
  {$EXTERNALSYM VIDEOINFOHEADER2}
  TVideoInfoHeader2 = tagVIDEOINFOHEADER2;

  PMPEG2VideoInfo = ^TMPEG2VideoInfo;
  tagMPEG2VIDEOINFO = record
     hdr: TVIDEOINFOHEADER2;
     dwStartTimeCode: DWORD;                 //  ?? not used for DVD ??
     cbSequenceHeader: DWORD;                // is 0 for DVD (no sequence header)
     dwProfile: DWORD;                       // use enum MPEG2Profile
     dwLevel: DWORD;                         // use enum MPEG2Level
     dwFlags: DWORD;                         // use AMMPEG2_* defines.  Reject connection if undefined bits are not 0
     dwSequenceHeader: array[0..0] of DWORD; // DWORD instead of Byte for alignment purposes
                                               //   For MPEG-2, if a sequence_header is included, the sequence_extension
                                               //   should also be included
  end;
  {$EXTERNALSYM tagMPEG2VIDEOINFO}
  MPEG2VIDEOINFO = tagMPEG2VIDEOINFO;
  {$EXTERNALSYM MPEG2VIDEOINFO}
  TMPEG2VideoInfo = tagMPEG2VIDEOINFO;
{
#define SIZE_MPEG2VIDEOINFO(pv) (FIELD_OFFSET(MPEG2VIDEOINFO, bSequenceHeader[0]) + (pv)->cbSequenceHeader)
#define MPEG1_SEQUENCE_INFO(pv) ((const BYTE *)(pv)->bSequenceHeader)
// use this macro instead, the previous only works for MPEG1VIDEOINFO structures
#define MPEG2_SEQUENCE_INFO(pv) ((const BYTE *)(pv)->dwSequenceHeader)
 }

//===================================================================================
// flags for dwTypeSpecificFlags in AM_SAMPLE2_PROPERTIES which define type specific
// data in IMediaSample2
//===================================================================================

const
  AM_VIDEO_FLAG_FIELD_MASK          = $0003;    // use this mask to check whether the sample is field1 or field2 or frame
  {$EXTERNALSYM AM_VIDEO_FLAG_FIELD_MASK}
  AM_VIDEO_FLAG_INTERLEAVED_FRAME   = $0000;    // the sample is a frame (remember to use AM_VIDEO_FLAG_FIELD_MASK when using this)
  {$EXTERNALSYM AM_VIDEO_FLAG_INTERLEAVED_FRAME}
  AM_VIDEO_FLAG_FIELD1              = $0001;    // the sample is field1 (remember to use AM_VIDEO_FLAG_FIELD_MASK when using this)
  {$EXTERNALSYM AM_VIDEO_FLAG_FIELD1}
  AM_VIDEO_FLAG_FIELD2              = $0002;    // the sample is the field2 (remember to use AM_VIDEO_FLAG_FIELD_MASK when using this)
  {$EXTERNALSYM AM_VIDEO_FLAG_FIELD2}
  AM_VIDEO_FLAG_FIELD1FIRST         = $0004;    // if set means display field1 first, else display field2 first.
  {$EXTERNALSYM AM_VIDEO_FLAG_FIELD1FIRST}
                                        // this bit is irrelavant for 1FieldPerSample mode
  AM_VIDEO_FLAG_WEAVE               = $0008;    // if set use bob display mode else weave
  {$EXTERNALSYM AM_VIDEO_FLAG_WEAVE}
  AM_VIDEO_FLAG_IPB_MASK            = $0030;    // use this mask to check whether the sample is I, P or B
  {$EXTERNALSYM AM_VIDEO_FLAG_IPB_MASK}
  AM_VIDEO_FLAG_I_SAMPLE            = $0000;    // I Sample (remember to use AM_VIDEO_FLAG_IPB_MASK when using this)
  {$EXTERNALSYM AM_VIDEO_FLAG_I_SAMPLE}
  AM_VIDEO_FLAG_P_SAMPLE            = $0010;    // P Sample (remember to use AM_VIDEO_FLAG_IPB_MASK when using this)
  {$EXTERNALSYM AM_VIDEO_FLAG_P_SAMPLE}
  AM_VIDEO_FLAG_B_SAMPLE            = $0020;    // B Sample (remember to use AM_VIDEO_FLAG_IPB_MASK when using this)
  {$EXTERNALSYM AM_VIDEO_FLAG_B_SAMPLE}
  AM_VIDEO_FLAG_REPEAT_FIELD        = $0040;    // if set means display the field which has been displayed first again after displaying
  {$EXTERNALSYM AM_VIDEO_FLAG_REPEAT_FIELD}
                                        // both fields first. This bit is irrelavant for 1FieldPerSample mode
// -----------------------------------------------------------------------
// AM_KSPROPSETID_DvdKaraoke property set definitions
// -----------------------------------------------------------------------
type
  tagAM_DvdKaraokeData = record
    dwDownmix           : DWORD;    // bitwise OR of AM_DvdKaraoke_Downmix flags
    dwSpeakerAssignment : DWORD;    // AM_DvdKaraoke_SpeakerAssignment
  end;
  {$EXTERNALSYM tagAM_DvdKaraokeData}
  AM_DvdKaraokeData = tagAM_DvdKaraokeData;
  {$EXTERNALSYM AM_DvdKaraokeData}
  TAMDvdKaraokeData = tagAM_DvdKaraokeData;

  AM_PROPERTY_DVDKARAOKE = (
    AM_PROPERTY_DVDKARAOKE_ENABLE,  // BOOL
    AM_PROPERTY_DVDKARAOKE_DATA
  );
  {$EXTERNALSYM AM_PROPERTY_DVDKARAOKE}
  TAMPropertyDVDKaraoke = AM_PROPERTY_DVDKARAOKE;

// -----------------------------------------------------------------------
// AM_KSPROPSETID_TSRateChange property set definitions for time stamp
// rate changes.
// -----------------------------------------------------------------------
type
  AM_PROPERTY_TS_RATE_CHANGE = (
  {$IFNDEF COMPILER6_UP}
    AM_RATE_INVALID_0,
    AM_RATE_SimpleRateChange,      // rw, use AM_SimpleRateChange
    AM_RATE_ExactRateChange,       // rw, use AM_ExactRateChange
    AM_RATE_MaxFullDataRate,       // r,  use AM_MaxFullDataRate
    AM_RATE_Step,                  // w,  use AM_Step
    AM_RATE_UseRateVersion,        // w,  use WORD
    AM_RATE_QueryFullFrameRate,    // r,  use AM_QueryRate
    AM_RATE_QueryLastRateSegPTS,   // r,  use REFERENCE_TIME
    AM_RATE_CorrectTS              // w,  use LONG
  {$ELSE}
    AM_RATE_SimpleRateChange    = 1, // rw, use AM_SimpleRateChange
    AM_RATE_ExactRateChange     = 2, // rw, use AM_ExactRateChange
    AM_RATE_MaxFullDataRate     = 3, // r,  use AM_MaxFullDataRate
    AM_RATE_Step                = 4, // w,  use AM_Step
    AM_RATE_UseRateVersion      = 5, // w,  use WORD
    AM_RATE_QueryFullFrameRate  = 6, // r,  use AM_QueryRate
    AM_RATE_QueryLastRateSegPTS = 7, // r,  use REFERENCE_TIME
    AM_RATE_CorrectTS           = 8 // w,  use LONG
  {$ENDIF}
  );
  {$EXTERNALSYM AM_PROPERTY_TS_RATE_CHANGE}
  TAMPropertyTSRateChange = AM_PROPERTY_TS_RATE_CHANGE;

// -------------------------------------------------------------------
// AM_KSPROPSETID_DVD_RateChange property set definitions for new DVD
// rate change scheme.
// -------------------------------------------------------------------

  AM_PROPERTY_DVD_RATE_CHANGE = (
  {$IFNDEF COMPILER6_UP}
    AM_RATE_INVALID__0,
    AM_RATE_ChangeRate,       // w,  use AM_DVD_ChangeRate
    AM_RATE_FullDataRateMax,  // r,  use AM_MaxFullDataRate
    AM_RATE_ReverseDecode,    // r,  use LONG
    AM_RATE_DecoderPosition,  // r,  use AM_DVD_DecoderPosition
    AM_RATE_DecoderVersion    // r,  use LONG
  {$ELSE}
    AM_RATE_ChangeRate      = 1, // w,  use AM_DVD_ChangeRate
    AM_RATE_FullDataRateMax = 2, // r,  use AM_MaxFullDataRate
    AM_RATE_ReverseDecode   = 3, // r,  use LONG
    AM_RATE_DecoderPosition = 4, // r,  use AM_DVD_DecoderPosition
    AM_RATE_DecoderVersion  = 5 // r,  use LONG
  {$ENDIF}
  );
  {$EXTERNALSYM AM_PROPERTY_DVD_RATE_CHANGE}
  TAMPropertyDVDRateChange = AM_PROPERTY_DVD_RATE_CHANGE;

  AM_SimpleRateChange = record
    // this is the simplest mechinism to set a time stamp rate change on
    // a filter (simplest for the person setting the rate change, harder
    // for the filter doing the rate change).
    StartTime: TReferenceTime;    //stream time at which to start this rate
    Rate: Longint;                //new rate * 10000 (decimal)
  end;
  {$EXTERNALSYM AM_SimpleRateChange}
  TAMSimpleRateChange = AM_SimpleRateChange;

  AM_QueryRate = record
    lMaxForwardFullFrame: LongInt; //  rate * 10000
    lMaxReverseFullFrame: LongInt; //  rate * 10000
  end;
  {$EXTERNALSYM AM_QueryRate}
  TAMQueryRate = AM_QueryRate;

  AM_ExactRateChange = record
    OutputZeroTime: TReferenceTime;   //input TS that maps to zero output TS
    Rate: Longint;                    //new rate * 10000 (decimal)
  end;
  {$EXTERNALSYM AM_ExactRateChange}
  TAMExactRateChange = AM_ExactRateChange;

  AM_MaxFullDateRate = {$IFDEF TYPE_IDENTITY}type {$ENDIF} Longint;    //rate * 10000 (decimal)
  {$EXTERNALSYM AM_MaxFullDateRate}

  AM_Step = {$IFDEF TYPE_IDENTITY}type {$ENDIF} DWORD;        // number of frame to step
  {$EXTERNALSYM AM_Step}

  // New rate change property set, structs. enums etc.
  AM_DVD_ChangeRate = record
     StartInTime  : TReferenceTime;  // stream time (input) at which to start decoding at this rate
     StartOutTime : TReferenceTime;  // reference time (output) at which to start showing at this rate
     Rate         : Longint;         // new rate * 10000 (decimal)
  end;
  {$EXTERNALSYM AM_DVD_ChangeRate}
  TAMDVDChangeRate = AM_DVD_ChangeRate;

  AM_DVD_DecoderPosition = {$IFDEF TYPE_IDENTITY}type {$ENDIF} int64 ;
  {$EXTERNALSYM AM_DVD_DecoderPosition}

  DVD_PLAY_DIRECTION = (
    DVD_DIR_FORWARD,
    DVD_DIR_BACKWARD
  );
  {$EXTERNALSYM DVD_PLAY_DIRECTION}
  TDVDPlayDirection = DVD_PLAY_DIRECTION;
  
(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       activecf.h
 *
 ***************************************************************************)

const
  CFSTR_VFW_FILTERLIST = 'Video for Windows 4 Filters';
  {$EXTERNALSYM CFSTR_VFW_FILTERLIST}

type
  tagVFW_FILTERLIST = record
    cFilters: UINT;                     // number of CLSIDs in aClsId
    aClsId: array[0..0] of TGUID;       // ClsId of each filter
  end;
  {$EXTERNALSYM tagVFW_FILTERLIST}
  VFW_FILTERLIST = tagVFW_FILTERLIST;
  {$EXTERNALSYM VFW_FILTERLIST}
  TVFWFilterList = tagVFW_FILTERLIST;

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       vfwmsgs.h
 *
 ***************************************************************************)

const
//
// Define the severity codes
//

  VFW_E_INVALIDMEDIATYPE                    = HResult($80040200);
  {$EXTERNALSYM VFW_E_INVALIDMEDIATYPE}
  VFW_E_INVALIDSUBTYPE                      = HResult($80040201);
  {$EXTERNALSYM VFW_E_INVALIDSUBTYPE}
  VFW_E_NEED_OWNER                          = HResult($80040202);
  {$EXTERNALSYM VFW_E_NEED_OWNER}
  VFW_E_ENUM_OUT_OF_SYNC                    = HResult($80040203);
  {$EXTERNALSYM VFW_E_ENUM_OUT_OF_SYNC}
  VFW_E_ALREADY_CONNECTED                   = HResult($80040204);
  {$EXTERNALSYM VFW_E_ALREADY_CONNECTED}
  VFW_E_FILTER_ACTIVE                       = HResult($80040205);
  {$EXTERNALSYM VFW_E_FILTER_ACTIVE}
  VFW_E_NO_TYPES                            = HResult($80040206);
  {$EXTERNALSYM VFW_E_NO_TYPES}
  VFW_E_NO_ACCEPTABLE_TYPES                 = HResult($80040207);
  {$EXTERNALSYM VFW_E_NO_ACCEPTABLE_TYPES}
  VFW_E_INVALID_DIRECTION                   = HResult($80040208);
  {$EXTERNALSYM VFW_E_INVALID_DIRECTION}
  VFW_E_NOT_CONNECTED                       = HResult($80040209);
  {$EXTERNALSYM VFW_E_NOT_CONNECTED}
  VFW_E_NO_ALLOCATOR                        = HResult($8004020A);
  {$EXTERNALSYM VFW_E_NO_ALLOCATOR}
  VFW_E_RUNTIME_ERROR                       = HResult($8004020B);
  {$EXTERNALSYM VFW_E_RUNTIME_ERROR}
  VFW_E_BUFFER_NOTSET                       = HResult($8004020C);
  {$EXTERNALSYM VFW_E_BUFFER_NOTSET}
  VFW_E_BUFFER_OVERFLOW                     = HResult($8004020D);
  {$EXTERNALSYM VFW_E_BUFFER_OVERFLOW}
  VFW_E_BADALIGN                            = HResult($8004020E);
  {$EXTERNALSYM VFW_E_BADALIGN}
  VFW_E_ALREADY_COMMITTED                   = HResult($8004020F);
  {$EXTERNALSYM VFW_E_ALREADY_COMMITTED}
  VFW_E_BUFFERS_OUTSTANDING                 = HResult($80040210);
  {$EXTERNALSYM VFW_E_BUFFERS_OUTSTANDING}
  VFW_E_NOT_COMMITTED                       = HResult($80040211);
  {$EXTERNALSYM VFW_E_NOT_COMMITTED}
  VFW_E_SIZENOTSET                          = HResult($80040212);
  {$EXTERNALSYM VFW_E_SIZENOTSET}
  VFW_E_NO_CLOCK                            = HResult($80040213);
  {$EXTERNALSYM VFW_E_NO_CLOCK}
  VFW_E_NO_SINK                             = HResult($80040214);
  {$EXTERNALSYM VFW_E_NO_SINK}
  VFW_E_NO_INTERFACE                        = HResult($80040215);
  {$EXTERNALSYM VFW_E_NO_INTERFACE}
  VFW_E_NOT_FOUND                           = HResult($80040216);
  {$EXTERNALSYM VFW_E_NOT_FOUND}
  VFW_E_CANNOT_CONNECT                      = HResult($80040217);
  {$EXTERNALSYM VFW_E_CANNOT_CONNECT}
  VFW_E_CANNOT_RENDER                       = HResult($80040218);
  {$EXTERNALSYM VFW_E_CANNOT_RENDER}
  VFW_E_CHANGING_FORMAT                     = HResult($80040219);
  {$EXTERNALSYM VFW_E_CHANGING_FORMAT}
  VFW_E_NO_COLOR_KEY_SET                    = HResult($8004021A);
  {$EXTERNALSYM VFW_E_NO_COLOR_KEY_SET}
  VFW_E_NOT_OVERLAY_CONNECTION              = HResult($8004021B);
  {$EXTERNALSYM VFW_E_NOT_OVERLAY_CONNECTION}
  VFW_E_NOT_SAMPLE_CONNECTION               = HResult($8004021C);
  {$EXTERNALSYM VFW_E_NOT_SAMPLE_CONNECTION}
  VFW_E_PALETTE_SET                         = HResult($8004021D);
  {$EXTERNALSYM VFW_E_PALETTE_SET}
  VFW_E_COLOR_KEY_SET                       = HResult($8004021E);
  {$EXTERNALSYM VFW_E_COLOR_KEY_SET}
  VFW_E_NO_COLOR_KEY_FOUND                  = HResult($8004021F);
  {$EXTERNALSYM VFW_E_NO_COLOR_KEY_FOUND}
  VFW_E_NO_PALETTE_AVAILABLE                = HResult($80040220);
  {$EXTERNALSYM VFW_E_NO_PALETTE_AVAILABLE}
  VFW_E_NO_DISPLAY_PALETTE                  = HResult($80040221);
  {$EXTERNALSYM VFW_E_NO_DISPLAY_PALETTE}
  VFW_E_TOO_MANY_COLORS                     = HResult($80040222);
  {$EXTERNALSYM VFW_E_TOO_MANY_COLORS}
  VFW_E_STATE_CHANGED                       = HResult($80040223);
  {$EXTERNALSYM VFW_E_STATE_CHANGED}
  VFW_E_NOT_STOPPED                         = HResult($80040224);
  {$EXTERNALSYM VFW_E_NOT_STOPPED}
  VFW_E_NOT_PAUSED                          = HResult($80040225);
  {$EXTERNALSYM VFW_E_NOT_PAUSED}
  VFW_E_NOT_RUNNING                         = HResult($80040226);
  {$EXTERNALSYM VFW_E_NOT_RUNNING}
  VFW_E_WRONG_STATE                         = HResult($80040227);
  {$EXTERNALSYM VFW_E_WRONG_STATE}
  VFW_E_START_TIME_AFTER_END                = HResult($80040228);
  {$EXTERNALSYM VFW_E_START_TIME_AFTER_END}
  VFW_E_INVALID_RECT                        = HResult($80040229);
  {$EXTERNALSYM VFW_E_INVALID_RECT}
  VFW_E_TYPE_NOT_ACCEPTED                   = HResult($8004022A);
  {$EXTERNALSYM VFW_E_TYPE_NOT_ACCEPTED}
  VFW_E_SAMPLE_REJECTED                     = HResult($8004022B);
  {$EXTERNALSYM VFW_E_SAMPLE_REJECTED}
  VFW_E_SAMPLE_REJECTED_EOS                 = HResult($8004022C);
  {$EXTERNALSYM VFW_E_SAMPLE_REJECTED_EOS}
  VFW_E_DUPLICATE_NAME                      = HResult($8004022D);
  {$EXTERNALSYM VFW_E_DUPLICATE_NAME}
  VFW_S_DUPLICATE_NAME                      = HResult($0004022D);
  {$EXTERNALSYM VFW_S_DUPLICATE_NAME}
  VFW_E_TIMEOUT                             = HResult($8004022E);
  {$EXTERNALSYM VFW_E_TIMEOUT}
  VFW_E_INVALID_FILE_FORMAT                 = HResult($8004022F);
  {$EXTERNALSYM VFW_E_INVALID_FILE_FORMAT}
  VFW_E_ENUM_OUT_OF_RANGE                   = HResult($80040230);
  {$EXTERNALSYM VFW_E_ENUM_OUT_OF_RANGE}
  VFW_E_CIRCULAR_GRAPH                      = HResult($80040231);
  {$EXTERNALSYM VFW_E_CIRCULAR_GRAPH}
  VFW_E_NOT_ALLOWED_TO_SAVE                 = HResult($80040232);
  {$EXTERNALSYM VFW_E_NOT_ALLOWED_TO_SAVE}
  VFW_E_TIME_ALREADY_PASSED                 = HResult($80040233);
  {$EXTERNALSYM VFW_E_TIME_ALREADY_PASSED}
  VFW_E_ALREADY_CANCELLED                   = HResult($80040234);
  {$EXTERNALSYM VFW_E_ALREADY_CANCELLED}
  VFW_E_CORRUPT_GRAPH_FILE                  = HResult($80040235);
  {$EXTERNALSYM VFW_E_CORRUPT_GRAPH_FILE}
  VFW_E_ADVISE_ALREADY_SET                  = HResult($80040236);
  {$EXTERNALSYM VFW_E_ADVISE_ALREADY_SET}
  VFW_S_STATE_INTERMEDIATE                  = HResult($00040237);
  {$EXTERNALSYM VFW_S_STATE_INTERMEDIATE}
  VFW_E_NO_MODEX_AVAILABLE                  = HResult($80040238);
  {$EXTERNALSYM VFW_E_NO_MODEX_AVAILABLE}
  VFW_E_NO_ADVISE_SET                       = HResult($80040239);
  {$EXTERNALSYM VFW_E_NO_ADVISE_SET}
  VFW_E_NO_FULLSCREEN                       = HResult($8004023B);
  {$EXTERNALSYM VFW_E_NO_FULLSCREEN}
  VFW_E_UNKNOWN_FILE_TYPE                   = HResult($80040240);
  {$EXTERNALSYM VFW_E_UNKNOWN_FILE_TYPE}
  VFW_E_CANNOT_LOAD_SOURCE_FILTER           = HResult($80040241);
  {$EXTERNALSYM VFW_E_CANNOT_LOAD_SOURCE_FILTER}
  VFW_S_PARTIAL_RENDER                      = HResult($00040242);
  {$EXTERNALSYM VFW_S_PARTIAL_RENDER}
  VFW_E_FILE_TOO_SHORT                      = HResult($80040243);
  {$EXTERNALSYM VFW_E_FILE_TOO_SHORT}
  VFW_E_INVALID_FILE_VERSION                = HResult($80040244);
  {$EXTERNALSYM VFW_E_INVALID_FILE_VERSION}
  VFW_S_SOME_DATA_IGNORED                   = HResult($00040245);
  {$EXTERNALSYM VFW_S_SOME_DATA_IGNORED}
  VFW_S_CONNECTIONS_DEFERRED                = HResult($00040246);
  {$EXTERNALSYM VFW_S_CONNECTIONS_DEFERRED}
  VFW_E_INVALID_CLSID                       = HResult($80040247);
  {$EXTERNALSYM VFW_E_INVALID_CLSID}
  VFW_E_INVALID_MEDIA_TYPE                  = HResult($80040248);
  {$EXTERNALSYM VFW_E_INVALID_MEDIA_TYPE}
  VFW_E_BAD_KEY                             = HResult($800403F2);
  {$EXTERNALSYM VFW_E_BAD_KEY}
  VFW_S_NO_MORE_ITEMS                       = HResult($00040103);
  {$EXTERNALSYM VFW_S_NO_MORE_ITEMS}
  VFW_E_SAMPLE_TIME_NOT_SET                 = HResult($80040249);
  {$EXTERNALSYM VFW_E_SAMPLE_TIME_NOT_SET}
  VFW_S_RESOURCE_NOT_NEEDED                 = HResult($00040250);
  {$EXTERNALSYM VFW_S_RESOURCE_NOT_NEEDED}
  VFW_E_MEDIA_TIME_NOT_SET                  = HResult($80040251);
  {$EXTERNALSYM VFW_E_MEDIA_TIME_NOT_SET}
  VFW_E_NO_TIME_FORMAT_SET                  = HResult($80040252);
  {$EXTERNALSYM VFW_E_NO_TIME_FORMAT_SET}
  VFW_E_MONO_AUDIO_HW                       = HResult($80040253);
  {$EXTERNALSYM VFW_E_MONO_AUDIO_HW}
  VFW_S_MEDIA_TYPE_IGNORED                  = HResult($00040254);
  {$EXTERNALSYM VFW_S_MEDIA_TYPE_IGNORED}
  VFW_E_NO_AUDIO_HARDWARE                   = HResult($80040256);
  {$EXTERNALSYM VFW_E_NO_AUDIO_HARDWARE}
  VFW_S_VIDEO_NOT_RENDERED                  = HResult($00040257);
  {$EXTERNALSYM VFW_S_VIDEO_NOT_RENDERED}
  VFW_S_AUDIO_NOT_RENDERED                  = HResult($00040258);
  {$EXTERNALSYM VFW_S_AUDIO_NOT_RENDERED}
  VFW_E_RPZA                                = HResult($80040259);
  {$EXTERNALSYM VFW_E_RPZA}
  VFW_S_RPZA                                = HResult($0004025A);
  {$EXTERNALSYM VFW_S_RPZA}
  VFW_E_PROCESSOR_NOT_SUITABLE              = HResult($8004025B);
  {$EXTERNALSYM VFW_E_PROCESSOR_NOT_SUITABLE}
  VFW_E_UNSUPPORTED_AUDIO                   = HResult($8004025C);
  {$EXTERNALSYM VFW_E_UNSUPPORTED_AUDIO}
  VFW_E_UNSUPPORTED_VIDEO                   = HResult($8004025D);
  {$EXTERNALSYM VFW_E_UNSUPPORTED_VIDEO}
  VFW_E_MPEG_NOT_CONSTRAINED                = HResult($8004025E);
  {$EXTERNALSYM VFW_E_MPEG_NOT_CONSTRAINED}
  VFW_E_NOT_IN_GRAPH                        = HResult($8004025F);
  {$EXTERNALSYM VFW_E_NOT_IN_GRAPH}
  VFW_S_ESTIMATED                           = HResult($00040260);
  {$EXTERNALSYM VFW_S_ESTIMATED}
  VFW_E_NO_TIME_FORMAT                      = HResult($80040261);
  {$EXTERNALSYM VFW_E_NO_TIME_FORMAT}
  VFW_E_READ_ONLY                           = HResult($80040262);
  {$EXTERNALSYM VFW_E_READ_ONLY}
  VFW_S_RESERVED                            = HResult($00040263);
  {$EXTERNALSYM VFW_S_RESERVED}
  VFW_E_BUFFER_UNDERFLOW                    = HResult($80040264);
  {$EXTERNALSYM VFW_E_BUFFER_UNDERFLOW}
  VFW_E_UNSUPPORTED_STREAM                  = HResult($80040265);
  {$EXTERNALSYM VFW_E_UNSUPPORTED_STREAM}
  VFW_E_NO_TRANSPORT                        = HResult($80040266);
  {$EXTERNALSYM VFW_E_NO_TRANSPORT}
  VFW_S_STREAM_OFF                          = HResult($00040267);
  {$EXTERNALSYM VFW_S_STREAM_OFF}
  VFW_S_CANT_CUE                            = HResult($00040268);
  {$EXTERNALSYM VFW_S_CANT_CUE}
  VFW_E_BAD_VIDEOCD                         = HResult($80040269);
  {$EXTERNALSYM VFW_E_BAD_VIDEOCD}
  VFW_S_NO_STOP_TIME                        = HResult($00040270);
  {$EXTERNALSYM VFW_S_NO_STOP_TIME}
  VFW_E_OUT_OF_VIDEO_MEMORY                 = HResult($80040271);
  {$EXTERNALSYM VFW_E_OUT_OF_VIDEO_MEMORY}
  VFW_E_VP_NEGOTIATION_FAILED               = HResult($80040272);
  {$EXTERNALSYM VFW_E_VP_NEGOTIATION_FAILED}
  VFW_E_DDRAW_CAPS_NOT_SUITABLE             = HResult($80040273);
  {$EXTERNALSYM VFW_E_DDRAW_CAPS_NOT_SUITABLE}
  VFW_E_NO_VP_HARDWARE                      = HResult($80040274);
  {$EXTERNALSYM VFW_E_NO_VP_HARDWARE}
  VFW_E_NO_CAPTURE_HARDWARE                 = HResult($80040275);
  {$EXTERNALSYM VFW_E_NO_CAPTURE_HARDWARE}
  VFW_E_DVD_OPERATION_INHIBITED             = HResult($80040276);
  {$EXTERNALSYM VFW_E_DVD_OPERATION_INHIBITED}
  VFW_E_DVD_INVALIDDOMAIN                   = HResult($80040277);
  {$EXTERNALSYM VFW_E_DVD_INVALIDDOMAIN}
  VFW_E_DVD_NO_BUTTON                       = Hresult($80040278);
  {$EXTERNALSYM VFW_E_DVD_NO_BUTTON}
  VFW_E_DVD_GRAPHNOTREADY                   = HResult($80040279);
  {$EXTERNALSYM VFW_E_DVD_GRAPHNOTREADY}
  VFW_E_DVD_RENDERFAIL                      = HResult($8004027A);
  {$EXTERNALSYM VFW_E_DVD_RENDERFAIL}
  VFW_E_DVD_DECNOTENOUGH                    = HResult($8004027B);
  {$EXTERNALSYM VFW_E_DVD_DECNOTENOUGH}
  VFW_E_DDRAW_VERSION_NOT_SUITABLE          = HResult($8004027C);
  {$EXTERNALSYM VFW_E_DDRAW_VERSION_NOT_SUITABLE}
  VFW_E_COPYPROT_FAILED                     = HResult($8004027D);
  {$EXTERNALSYM VFW_E_COPYPROT_FAILED}
  VFW_S_NOPREVIEWPIN                        = HResult($0004027E);
  {$EXTERNALSYM VFW_S_NOPREVIEWPIN}
  VFW_E_TIME_EXPIRED                        = HResult($8004027F);
  {$EXTERNALSYM VFW_E_TIME_EXPIRED}
  VFW_S_DVD_NON_ONE_SEQUENTIAL              = HResult($00040280);
  {$EXTERNALSYM VFW_S_DVD_NON_ONE_SEQUENTIAL}
  VFW_E_DVD_WRONG_SPEED                     = HResult($80040281);
  {$EXTERNALSYM VFW_E_DVD_WRONG_SPEED}
  VFW_E_DVD_MENU_DOES_NOT_EXIST             = HResult($80040282);
  {$EXTERNALSYM VFW_E_DVD_MENU_DOES_NOT_EXIST}
  VFW_E_DVD_CMD_CANCELLED                   = HResult($80040283);
  {$EXTERNALSYM VFW_E_DVD_CMD_CANCELLED}
  VFW_E_DVD_STATE_WRONG_VERSION             = HResult($80040284);
  {$EXTERNALSYM VFW_E_DVD_STATE_WRONG_VERSION}
  VFW_E_DVD_STATE_CORRUPT                   = HResult($80040285);
  {$EXTERNALSYM VFW_E_DVD_STATE_CORRUPT}
  VFW_E_DVD_STATE_WRONG_DISC                = HResult($80040286);
  {$EXTERNALSYM VFW_E_DVD_STATE_WRONG_DISC}
  VFW_E_DVD_INCOMPATIBLE_REGION             = HResult($80040287);
  {$EXTERNALSYM VFW_E_DVD_INCOMPATIBLE_REGION}
  VFW_E_DVD_NO_ATTRIBUTES                   = HResult($80040288);
  {$EXTERNALSYM VFW_E_DVD_NO_ATTRIBUTES}
  VFW_E_DVD_NO_GOUP_PGC                     = HResult($80040289);
  {$EXTERNALSYM VFW_E_DVD_NO_GOUP_PGC}
  VFW_E_DVD_LOW_PARENTAL_LEVEL              = HResult($8004028A);
  {$EXTERNALSYM VFW_E_DVD_LOW_PARENTAL_LEVEL}
  VFW_E_DVD_NOT_IN_KARAOKE_MODE             = HResult($8004028B);
  {$EXTERNALSYM VFW_E_DVD_NOT_IN_KARAOKE_MODE}
  VFW_S_DVD_CHANNEL_CONTENTS_NOT_AVAILABLE  = HResult($0004028C);
  {$EXTERNALSYM VFW_S_DVD_CHANNEL_CONTENTS_NOT_AVAILABLE}
  VFW_S_DVD_NOT_ACCURATE                    = HResult($0004028D);
  {$EXTERNALSYM VFW_S_DVD_NOT_ACCURATE}
  VFW_E_FRAME_STEP_UNSUPPORTED              = HResult($8004028E);
  {$EXTERNALSYM VFW_E_FRAME_STEP_UNSUPPORTED}
  VFW_E_DVD_STREAM_DISABLED                 = HResult($8004028F);
  {$EXTERNALSYM VFW_E_DVD_STREAM_DISABLED}
  VFW_E_DVD_TITLE_UNKNOWN                   = HResult($80040290);
  {$EXTERNALSYM VFW_E_DVD_TITLE_UNKNOWN}
  VFW_E_DVD_INVALID_DISC                    = HResult($80040291);
  {$EXTERNALSYM VFW_E_DVD_INVALID_DISC}
  VFW_E_DVD_NO_RESUME_INFORMATION           = HResult($80040292);
  {$EXTERNALSYM VFW_E_DVD_NO_RESUME_INFORMATION}
  VFW_E_PIN_ALREADY_BLOCKED_ON_THIS_THREAD  = HResult($80040293);
  {$EXTERNALSYM VFW_E_PIN_ALREADY_BLOCKED_ON_THIS_THREAD}
  VFW_E_PIN_ALREADY_BLOCKED                 = HResult($80040294);
  {$EXTERNALSYM VFW_E_PIN_ALREADY_BLOCKED}
  VFW_E_CERTIFICATION_FAILURE               = HResult($80040295);
  {$EXTERNALSYM VFW_E_CERTIFICATION_FAILURE}
  VFW_E_VMR_NOT_IN_MIXER_MODE               = HResult($80040296);
  {$EXTERNALSYM VFW_E_VMR_NOT_IN_MIXER_MODE}

  // The application has not yet provided the VMR filter with a valid allocator-presenter object.%0
  VFW_E_VMR_NO_AP_SUPPLIED       = HResult($80040297);
  {$EXTERNALSYM VFW_E_VMR_NO_AP_SUPPLIED}

  // The VMR could not find any de-interlacing hardware on the current display device.%0
  VFW_E_VMR_NO_DEINTERLACE_HW    = HResult($80040298);
  {$EXTERNALSYM VFW_E_VMR_NO_DEINTERLACE_HW}

  // The VMR could not find any ProcAmp hardware on the current display device.%0
  VFW_E_VMR_NO_PROCAMP_HW        = HResult($80040299);
  {$EXTERNALSYM VFW_E_VMR_NO_PROCAMP_HW}

  // VMR9 does not work with VPE-based hardware decoders.%0
  VFW_E_DVD_VMR9_INCOMPATIBLEDEC = HResult($8004029A);
  {$EXTERNALSYM VFW_E_DVD_VMR9_INCOMPATIBLEDEC}

  // The current display device does not support Content Output Protection Protocol (COPP) H/W.%0
  VFW_E_NO_COPP_HW = HRESULT($8004029B);
  {$EXTERNALSYM VFW_E_NO_COPP_HW}

  E_PROP_SET_UNSUPPORTED                    = HResult($80070492);
  {$EXTERNALSYM E_PROP_SET_UNSUPPORTED}
  E_PROP_ID_UNSUPPORTED                     = HResult($80070490);
  {$EXTERNALSYM E_PROP_ID_UNSUPPORTED}


(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  Files:       edevdefs.h
 *               XPrtDefs.h (derived from edevdefs.h)
 *
 ***************************************************************************)

const
  ED_BASE                                 = $1000;
  {$EXTERNALSYM ED_BASE}

// this is used to tell the device communications object which
// physical communications port to use.
  DEV_PORT_SIM                            = 1;
  {$EXTERNALSYM DEV_PORT_SIM}
  DEV_PORT_COM1                           = 2; // standard serial ports
  {$EXTERNALSYM DEV_PORT_COM1}
  DEV_PORT_COM2                           = 3;
  {$EXTERNALSYM DEV_PORT_COM2}
  DEV_PORT_COM3                           = 4;
  {$EXTERNALSYM DEV_PORT_COM3}
  DEV_PORT_COM4                           = 5;
  {$EXTERNALSYM DEV_PORT_COM4}
  DEV_PORT_DIAQ                           = 6; // Diaquest driver
  {$EXTERNALSYM DEV_PORT_DIAQ}
  DEV_PORT_ARTI                           = 7; // ARTI driver
  {$EXTERNALSYM DEV_PORT_ARTI}
  DEV_PORT_1394                           = 8; // IEEE 1394 Serial Bus
  {$EXTERNALSYM DEV_PORT_1394}
  DEV_PORT_USB                            = 9; // Universal Serial Bus
  {$EXTERNALSYM DEV_PORT_USB}
  DEV_PORT_MIN                            = DEV_PORT_SIM;
  {$EXTERNALSYM DEV_PORT_MIN}
  DEV_PORT_MAX                            = DEV_PORT_USB;
  {$EXTERNALSYM DEV_PORT_MAX}

//      IAMExtDevice Capability Items:  unless otherwise specified, these items return
//         OATRUE or OAFALSE.  All return values are in pdwValue unless otherwise specified:

  ED_DEVCAP_CAN_RECORD                    = ED_BASE+1;
  {$EXTERNALSYM ED_DEVCAP_CAN_RECORD}
  ED_DEVCAP_CAN_RECORD_STROBE             = ED_BASE+2;
  {$EXTERNALSYM ED_DEVCAP_CAN_RECORD_STROBE}
  ED_DEVCAP_HAS_AUDIO                     = ED_BASE+3;
  {$EXTERNALSYM ED_DEVCAP_HAS_AUDIO}
  ED_DEVCAP_HAS_VIDEO                     = ED_BASE+4;
  {$EXTERNALSYM ED_DEVCAP_HAS_VIDEO}
  ED_DEVCAP_USES_FILES                    = ED_BASE+5;
  {$EXTERNALSYM ED_DEVCAP_USES_FILES}
  ED_DEVCAP_CAN_SAVE                      = ED_BASE+6;
  {$EXTERNALSYM ED_DEVCAP_CAN_SAVE}
  ED_DEVCAP_DEVICE_TYPE                   = ED_BASE+7;
  {$EXTERNALSYM ED_DEVCAP_DEVICE_TYPE}
  ED_DEVTYPE_VCR                          = ED_BASE+8;
  {$EXTERNALSYM ED_DEVTYPE_VCR}
  ED_DEVTYPE_LASERDISK                    = ED_BASE+9;
  {$EXTERNALSYM ED_DEVTYPE_LASERDISK}
  ED_DEVTYPE_ATR                          = ED_BASE+10;
  {$EXTERNALSYM ED_DEVTYPE_ATR}
  ED_DEVTYPE_DDR                          = ED_BASE+11;
  {$EXTERNALSYM ED_DEVTYPE_DDR}
  ED_DEVTYPE_ROUTER                       = ED_BASE+12;
  {$EXTERNALSYM ED_DEVTYPE_ROUTER}
  ED_DEVTYPE_KEYER                        = ED_BASE+13;
  {$EXTERNALSYM ED_DEVTYPE_KEYER}
  ED_DEVTYPE_MIXER_VIDEO                  = ED_BASE+14;
  {$EXTERNALSYM ED_DEVTYPE_MIXER_VIDEO}
  ED_DEVTYPE_DVE                          = ED_BASE+15;
  {$EXTERNALSYM ED_DEVTYPE_DVE}
  ED_DEVTYPE_WIPEGEN                      = ED_BASE+16;
  {$EXTERNALSYM ED_DEVTYPE_WIPEGEN}
  ED_DEVTYPE_MIXER_AUDIO                  = ED_BASE+17;
  {$EXTERNALSYM ED_DEVTYPE_MIXER_AUDIO}
  ED_DEVTYPE_CG                           = ED_BASE+18;
  {$EXTERNALSYM ED_DEVTYPE_CG}
  ED_DEVTYPE_TBC                          = ED_BASE+19;
  {$EXTERNALSYM ED_DEVTYPE_TBC}
  ED_DEVTYPE_TCG                          = ED_BASE+20;
  {$EXTERNALSYM ED_DEVTYPE_TCG}
  ED_DEVTYPE_GPI                          = ED_BASE+21;
  {$EXTERNALSYM ED_DEVTYPE_GPI}
  ED_DEVTYPE_JOYSTICK                     = ED_BASE+22;
  {$EXTERNALSYM ED_DEVTYPE_JOYSTICK}
  ED_DEVTYPE_KEYBOARD                     = ED_BASE+23;
  {$EXTERNALSYM ED_DEVTYPE_KEYBOARD}

// returns mfr-specific ID from external device.
  ED_DEVCAP_EXTERNAL_DEVICE_ID            = ED_BASE+24;
  {$EXTERNALSYM ED_DEVCAP_EXTERNAL_DEVICE_ID}

  ED_DEVCAP_TIMECODE_READ                 = ED_BASE+25;
  {$EXTERNALSYM ED_DEVCAP_TIMECODE_READ}
  ED_DEVCAP_TIMECODE_WRITE                = ED_BASE+26;
  {$EXTERNALSYM ED_DEVCAP_TIMECODE_WRITE}
//      used for seekable non-timecode enabled devices
  ED_DEVCAP_CTLTRK_READ                   = ED_BASE+27;
  {$EXTERNALSYM ED_DEVCAP_CTLTRK_READ}
//      used for seekable non-timecode enabled devices
  ED_DEVCAP_INDEX_READ                    = ED_BASE+28;
  {$EXTERNALSYM ED_DEVCAP_INDEX_READ}

// returns device preroll time in current time format
  ED_DEVCAP_PREROLL                       = ED_BASE+29;
  {$EXTERNALSYM ED_DEVCAP_PREROLL}
// returns device postroll time in current time format
  ED_DEVCAP_POSTROLL                     = ED_BASE+30;
  {$EXTERNALSYM ED_DEVCAP_POSTROLL}

// returns indication of devices synchronization accuracy.
  ED_DEVCAP_SYNC_ACCURACY                = ED_BASE+31;
  {$EXTERNALSYM ED_DEVCAP_SYNC_ACCURACY}
  ED_SYNCACC_PRECISE                     = ED_BASE+32;
  {$EXTERNALSYM ED_SYNCACC_PRECISE}
  ED_SYNCACC_FRAME                       = ED_BASE+33;
  {$EXTERNALSYM ED_SYNCACC_FRAME}
  ED_SYNCACC_ROUGH                       = ED_BASE+34;
  {$EXTERNALSYM ED_SYNCACC_ROUGH}

// returns devices normal framerate.
  ED_DEVCAP_NORMAL_RATE                  = ED_BASE+35;
  {$EXTERNALSYM ED_DEVCAP_NORMAL_RATE}
  ED_RATE_24                             = ED_BASE+36;
  {$EXTERNALSYM ED_RATE_24}
  ED_RATE_25                             = ED_BASE+37;
  {$EXTERNALSYM ED_RATE_25}
  ED_RATE_2997                           = ED_BASE+38;
  {$EXTERNALSYM ED_RATE_2997}
  ED_RATE_30                             = ED_BASE+39;
  {$EXTERNALSYM ED_RATE_30}

  ED_DEVCAP_CAN_PREVIEW = ED_BASE+40;
  {$EXTERNALSYM ED_DEVCAP_CAN_PREVIEW}
  ED_DEVCAP_CAN_MONITOR_SOURCES = ED_BASE+41;
  {$EXTERNALSYM ED_DEVCAP_CAN_MONITOR_SOURCES}

// indicates implementation allows testing of methods/parameters by
// setting the hi bit of a parm that makes sense - see individual methods
// for details.
  ED_DEVCAP_CAN_TEST                     = ED_BASE+42;
  {$EXTERNALSYM ED_DEVCAP_CAN_TEST}

// indicates device accepts video as an input.
  ED_DEVCAP_VIDEO_INPUTS                 = ED_BASE+43;
  {$EXTERNALSYM ED_DEVCAP_VIDEO_INPUTS}

// indicates device accepts audio as an input.
  ED_DEVCAP_AUDIO_INPUTS                 = ED_BASE+44;
  {$EXTERNALSYM ED_DEVCAP_AUDIO_INPUTS}

  ED_DEVCAP_NEEDS_CALIBRATING            = ED_BASE+45;
  {$EXTERNALSYM ED_DEVCAP_NEEDS_CALIBRATING}

  ED_DEVCAP_SEEK_TYPE                    = ED_BASE+46;
  {$EXTERNALSYM ED_DEVCAP_SEEK_TYPE}
  ED_SEEK_PERFECT                        = ED_BASE+47;
  {$EXTERNALSYM ED_SEEK_PERFECT}
  ED_SEEK_FAST                           = ED_BASE+48;
  {$EXTERNALSYM ED_SEEK_FAST}
  ED_SEEK_SLOW                           = ED_BASE+49;
  {$EXTERNALSYM ED_SEEK_SLOW}

  ED_POWER_ON                            = ED_BASE+50;
  {$EXTERNALSYM ED_POWER_ON}
  ED_POWER_OFF                           = ED_BASE+51;
  {$EXTERNALSYM ED_POWER_OFF}
  ED_POWER_STANDBY                       = ED_BASE+52;
  {$EXTERNALSYM ED_POWER_STANDBY}

  ED_POWER_DEVICE_DEPENDENT              = ED_BASE+1033; // Power is on with limited functions
  {$EXTERNALSYM ED_POWER_DEVICE_DEPENDENT}

  ED_ACTIVE                              = ED_BASE+53;
  {$EXTERNALSYM ED_ACTIVE}
  ED_INACTIVE                            = ED_BASE+54;
  {$EXTERNALSYM ED_INACTIVE}
  ED_ALL                                 = ED_BASE+55;
  {$EXTERNALSYM ED_ALL}
  ED_TEST                                = ED_BASE+56;
  {$EXTERNALSYM ED_TEST}

//      IAMExtTransport Capability Items:  unless otherwise specified, these items return
//         OATRUE or OAFALSE.  All return values are in pdwValue unless otherwise specified:

  ED_TRANSCAP_CAN_EJECT                  = ED_BASE+100;
  {$EXTERNALSYM ED_TRANSCAP_CAN_EJECT}
  ED_TRANSCAP_CAN_BUMP_PLAY              = ED_BASE+101;
  {$EXTERNALSYM ED_TRANSCAP_CAN_BUMP_PLAY}
  ED_TRANSCAP_CAN_PLAY_BACKWARDS         = ED_BASE+102;
  {$EXTERNALSYM ED_TRANSCAP_CAN_PLAY_BACKWARDS}
  ED_TRANSCAP_CAN_SET_EE                 = ED_BASE+103;
  {$EXTERNALSYM ED_TRANSCAP_CAN_SET_EE}
  ED_TRANSCAP_CAN_SET_PB                 = ED_BASE+104;
  {$EXTERNALSYM ED_TRANSCAP_CAN_SET_PB}
  ED_TRANSCAP_CAN_DELAY_VIDEO_IN         = ED_BASE+105;
  {$EXTERNALSYM ED_TRANSCAP_CAN_DELAY_VIDEO_IN}
  ED_TRANSCAP_CAN_DELAY_VIDEO_OUT        = ED_BASE+106;
  {$EXTERNALSYM ED_TRANSCAP_CAN_DELAY_VIDEO_OUT}
  ED_TRANSCAP_CAN_DELAY_AUDIO_IN         = ED_BASE+107;
  {$EXTERNALSYM ED_TRANSCAP_CAN_DELAY_AUDIO_IN}
  ED_TRANSCAP_CAN_DELAY_AUDIO_OUT        = ED_BASE+108;
  {$EXTERNALSYM ED_TRANSCAP_CAN_DELAY_AUDIO_OUT}
  ED_TRANSCAP_FWD_VARIABLE_MAX           = ED_BASE+109;
  {$EXTERNALSYM ED_TRANSCAP_FWD_VARIABLE_MAX}
  ED_TRANSCAP_FWD_VARIABLE_MIN	         = ED_BASE+800;
  {$EXTERNALSYM ED_TRANSCAP_FWD_VARIABLE_MIN}
  ED_TRANSCAP_REV_VARIABLE_MAX           = ED_BASE+110;
  {$EXTERNALSYM ED_TRANSCAP_REV_VARIABLE_MAX}
  ED_TRANSCAP_REV_VARIABLE_MIN	         = ED_BASE+801;
  {$EXTERNALSYM ED_TRANSCAP_REV_VARIABLE_MIN}
  ED_TRANSCAP_FWD_SHUTTLE_MAX		         = ED_BASE+802;
  {$EXTERNALSYM ED_TRANSCAP_FWD_SHUTTLE_MAX}
  ED_TRANSCAP_FWD_SHUTTLE_MIN		         = ED_BASE+803;
  {$EXTERNALSYM ED_TRANSCAP_FWD_SHUTTLE_MIN}
  ED_TRANSCAP_REV_SHUTTLE_MAX		         = ED_BASE+804;
  {$EXTERNALSYM ED_TRANSCAP_REV_SHUTTLE_MAX}
  ED_TRANSCAP_REV_SHUTTLE_MIN		         = ED_BASE+805;
  {$EXTERNALSYM ED_TRANSCAP_REV_SHUTTLE_MIN}
  ED_TRANSCAP_NUM_AUDIO_TRACKS           = ED_BASE+111;
  {$EXTERNALSYM ED_TRANSCAP_NUM_AUDIO_TRACKS}
  ED_TRANSCAP_LTC_TRACK                  = ED_BASE+112;
  {$EXTERNALSYM ED_TRANSCAP_LTC_TRACK}
  ED_TRANSCAP_NEEDS_TBC                  = ED_BASE+113;
  {$EXTERNALSYM ED_TRANSCAP_NEEDS_TBC}
  ED_TRANSCAP_NEEDS_CUEING               = ED_BASE+114;
  {$EXTERNALSYM ED_TRANSCAP_NEEDS_CUEING}
  ED_TRANSCAP_CAN_INSERT                 = ED_BASE+115;
  {$EXTERNALSYM ED_TRANSCAP_CAN_INSERT}
  ED_TRANSCAP_CAN_ASSEMBLE               = ED_BASE+116;
  {$EXTERNALSYM ED_TRANSCAP_CAN_ASSEMBLE}
  ED_TRANSCAP_FIELD_STEP                 = ED_BASE+117;
  {$EXTERNALSYM ED_TRANSCAP_FIELD_STEP}
  ED_TRANSCAP_CLOCK_INC_RATE             = ED_BASE+118;
  {$EXTERNALSYM ED_TRANSCAP_CLOCK_INC_RATE}
  ED_TRANSCAP_CAN_DETECT_LENGTH          = ED_BASE+119;
  {$EXTERNALSYM ED_TRANSCAP_CAN_DETECT_LENGTH}
  ED_TRANSCAP_CAN_FREEZE                 = ED_BASE+120;
  {$EXTERNALSYM ED_TRANSCAP_CAN_FREEZE}
  ED_TRANSCAP_HAS_TUNER                  = ED_BASE+121;
  {$EXTERNALSYM ED_TRANSCAP_HAS_TUNER}
  ED_TRANSCAP_HAS_TIMER                  = ED_BASE+122;
  {$EXTERNALSYM ED_TRANSCAP_HAS_TIMER}
  ED_TRANSCAP_HAS_CLOCK                  = ED_BASE+123;
  {$EXTERNALSYM ED_TRANSCAP_HAS_CLOCK}
  ED_TRANSCAP_MULTIPLE_EDITS             = ED_BASE+806;
  {$EXTERNALSYM ED_TRANSCAP_MULTIPLE_EDITS}
  ED_TRANSCAP_IS_MASTER			             = ED_BASE+807;
  {$EXTERNALSYM ED_TRANSCAP_IS_MASTER}
  ED_TRANSCAP_HAS_DT			               = ED_BASE+814;
  {$EXTERNALSYM ED_TRANSCAP_HAS_DT}

//      IAMExtTransport Media States
  ED_MEDIA_SPIN_UP                       = ED_BASE+130;
  {$EXTERNALSYM ED_MEDIA_SPIN_UP}
  ED_MEDIA_SPIN_DOWN                     = ED_BASE+131;
  {$EXTERNALSYM ED_MEDIA_SPIN_DOWN}
  ED_MEDIA_UNLOAD                        = ED_BASE+132;
  {$EXTERNALSYM ED_MEDIA_UNLOAD}

//      IAMExtTransport Modes
  ED_MODE_PLAY                           = ED_BASE+200;
  {$EXTERNALSYM ED_MODE_PLAY}
  ED_MODE_STOP                           = ED_BASE+201;
  {$EXTERNALSYM ED_MODE_STOP}
  ED_MODE_FREEZE                         = ED_BASE+202;
  {$EXTERNALSYM ED_MODE_FREEZE}
  ED_MODE_THAW                           = ED_BASE+203;
  {$EXTERNALSYM ED_MODE_THAW}
  ED_MODE_FF                             = ED_BASE+204;
  {$EXTERNALSYM ED_MODE_FF}
  ED_MODE_REW                            = ED_BASE+205;
  {$EXTERNALSYM ED_MODE_REW}
  ED_MODE_RECORD                         = ED_BASE+206;
  {$EXTERNALSYM ED_MODE_RECORD}
  ED_MODE_RECORD_STROBE                  = ED_BASE+207;
  {$EXTERNALSYM ED_MODE_RECORD_STROBE}
  ED_MODE_RECORD_FREEZE		               = ED_BASE+808; // never "put", only "get"
  {$EXTERNALSYM ED_MODE_RECORD_FREEZE}
  ED_MODE_STEP                           = ED_BASE+208;
  {$EXTERNALSYM ED_MODE_STEP}
  ED_MODE_STEP_FWD			                 = ED_BASE+208;
  {$EXTERNALSYM ED_MODE_STEP_FWD}
  ED_MODE_STEP_REV			                 = ED_BASE+809;
  {$EXTERNALSYM ED_MODE_STEP_REV}
  ED_MODE_SHUTTLE                        = ED_BASE+209;
  {$EXTERNALSYM ED_MODE_SHUTTLE}
  ED_MODE_EDIT_CUE                       = ED_BASE+210;
  {$EXTERNALSYM ED_MODE_EDIT_CUE}
  ED_MODE_VAR_SPEED                      = ED_BASE+211;
  {$EXTERNALSYM ED_MODE_VAR_SPEED}
  ED_MODE_PERFORM                        = ED_BASE+212;
  {$EXTERNALSYM ED_MODE_PERFORM}
  ED_MODE_LINK_ON                        = ED_BASE+280;
  {$EXTERNALSYM ED_MODE_LINK_ON}
  ED_MODE_LINK_OFF                       = ED_BASE+281;
  {$EXTERNALSYM ED_MODE_LINK_OFF}
  ED_MODE_NOTIFY_ENABLE		               = ED_BASE+810;
  {$EXTERNALSYM ED_MODE_NOTIFY_ENABLE}
  ED_MODE_NOTIFY_DISABLE	               = ED_BASE+811;
  {$EXTERNALSYM ED_MODE_NOTIFY_DISABLE}
  ED_MODE_SHOT_SEARCH			               = ED_BASE+812;
  {$EXTERNALSYM ED_MODE_SHOT_SEARCH}

//      IAMTimecodeReader/Generator/Display defines
//
// Timecode Generator Mode params and values:
//
  ED_TCG_TIMECODE_TYPE                   = ED_BASE+400;
  {$EXTERNALSYM ED_TCG_TIMECODE_TYPE}
  ED_TCG_SMPTE_LTC                       = ED_BASE+401;
  {$EXTERNALSYM ED_TCG_SMPTE_LTC}
  ED_TCG_SMPTE_VITC                      = ED_BASE+402;
  {$EXTERNALSYM ED_TCG_SMPTE_VITC}
  ED_TCG_MIDI_QF                         = ED_BASE+403;
  {$EXTERNALSYM ED_TCG_MIDI_QF}
  ED_TCG_MIDI_FULL                       = ED_BASE+404;
  {$EXTERNALSYM ED_TCG_MIDI_FULL}

  ED_TCG_FRAMERATE                       = ED_BASE+405;
  {$EXTERNALSYM ED_TCG_FRAMERATE}
  ED_FORMAT_SMPTE_30                     = ED_BASE+406;
  {$EXTERNALSYM ED_FORMAT_SMPTE_30}
  ED_FORMAT_SMPTE_30DROP                 = ED_BASE+407;
  {$EXTERNALSYM ED_FORMAT_SMPTE_30DROP}
  ED_FORMAT_SMPTE_25                     = ED_BASE+408;
  {$EXTERNALSYM ED_FORMAT_SMPTE_25}
  ED_FORMAT_SMPTE_24                     = ED_BASE+409;
  {$EXTERNALSYM ED_FORMAT_SMPTE_24}

  ED_TCG_SYNC_SOURCE                     = ED_BASE+410;
  {$EXTERNALSYM ED_TCG_SYNC_SOURCE}
  ED_TCG_VIDEO                           = ED_BASE+411;
  {$EXTERNALSYM ED_TCG_VIDEO}
  ED_TCG_READER                          = ED_BASE+412;
  {$EXTERNALSYM ED_TCG_READER}
  ED_TCG_FREE                            = ED_BASE+413;
  {$EXTERNALSYM ED_TCG_FREE}

  ED_TCG_REFERENCE_SOURCE                = ED_BASE+414;
  {$EXTERNALSYM ED_TCG_REFERENCE_SOURCE}

// TimeCodeReader Mode params and values:
  ED_TCR_SOURCE                          = ED_BASE+416;
  {$EXTERNALSYM ED_TCR_SOURCE}
// ED_TCG (already defined)
  ED_TCR_LTC                             = ED_BASE+417;
  {$EXTERNALSYM ED_TCR_LTC}
  ED_TCR_VITC                            = ED_BASE+418;
  {$EXTERNALSYM ED_TCR_VITC}
  ED_TCR_CT                              = ED_BASE+419;
  {$EXTERNALSYM ED_TCR_CT}
  ED_TCR_FTC				 = ED_BASE+420;
  {$EXTERNALSYM ED_TCR_FTC}

// ED_MODE_NOTIFY_ENABLE can be OATRUE or OAFALSE (defined in transport mode
//  section of this file).  
  ED_TCR_LAST_VALUE		                   = ED_BASE+421;
  {$EXTERNALSYM ED_TCR_LAST_VALUE}

// TimeCode Display Mode params and values:
//
  ED_TCD_SOURCE                          = ED_BASE+422;
  {$EXTERNALSYM ED_TCD_SOURCE}
  ED_TCR                                 = ED_BASE+423;
  {$EXTERNALSYM ED_TCR}
  ED_TCG                                 = ED_BASE+424;
  {$EXTERNALSYM ED_TCG}

  ED_TCD_SIZE                            = ED_BASE+425;
  {$EXTERNALSYM ED_TCD_SIZE}
  ED_SMALL                               = ED_BASE+426;
  {$EXTERNALSYM ED_SMALL}
  ED_MED                                 = ED_BASE+427;
  {$EXTERNALSYM ED_MED}
  ED_LARGE                               = ED_BASE+428;
  {$EXTERNALSYM ED_LARGE}

  ED_TCD_POSITION                        = ED_BASE+429;
  {$EXTERNALSYM ED_TCD_POSITION}
  ED_TOP                                 = $0001;
  {$EXTERNALSYM ED_TOP}
  ED_MIDDLE                              = $0002;
  {$EXTERNALSYM ED_MIDDLE}
  ED_BOTTOM                              = $0004;
  {$EXTERNALSYM ED_BOTTOM}
  ED_LEFT                                = $0100;
  {$EXTERNALSYM ED_LEFT}
  ED_CENTER                              = $0200;
  {$EXTERNALSYM ED_CENTER}
  ED_RIGHT                               = $0400;
  {$EXTERNALSYM ED_RIGHT}

  ED_TCD_INTENSITY                       = ED_BASE+436;
  {$EXTERNALSYM ED_TCD_INTENSITY}
  ED_HIGH                                = ED_BASE+437;
  {$EXTERNALSYM ED_HIGH}
  ED_LOW                                 = ED_BASE+438;
  {$EXTERNALSYM ED_LOW}

  ED_TCD_TRANSPARENCY                    = ED_BASE+439;
  {$EXTERNALSYM ED_TCD_TRANSPARENCY}
  ED_TCD_INVERT                          = ED_BASE+440;
  {$EXTERNALSYM ED_TCD_INVERT}

//      IAMExtTransport defines
//
// Transport status, params and values
//

// IAMExtTransport Status items and and values:
  ED_MODE                                = ED_BASE+500;
  {$EXTERNALSYM ED_MODE}
  ED_ERROR                               = ED_BASE+501;
  {$EXTERNALSYM ED_ERROR}
  ED_LOCAL                               = ED_BASE+502;
  {$EXTERNALSYM ED_LOCAL}
  ED_RECORD_INHIBIT                      = ED_BASE+503;
  {$EXTERNALSYM ED_RECORD_INHIBIT}
  ED_SERVO_LOCK                          = ED_BASE+504;
  {$EXTERNALSYM ED_SERVO_LOCK}
  ED_MEDIA_PRESENT                       = ED_BASE+505;
  {$EXTERNALSYM ED_MEDIA_PRESENT}
  ED_MEDIA_LENGTH                        = ED_BASE+506;
  {$EXTERNALSYM ED_MEDIA_LENGTH}
  ED_MEDIA_SIZE                          = ED_BASE+507;
  {$EXTERNALSYM ED_MEDIA_SIZE}
  ED_MEDIA_TRACK_COUNT                   = ED_BASE+508;
  {$EXTERNALSYM ED_MEDIA_TRACK_COUNT}
  ED_MEDIA_TRACK_LENGTH                  = ED_BASE+509;
  {$EXTERNALSYM ED_MEDIA_TRACK_LENGTH}
  ED_MEDIA_SIDE                          = ED_BASE+510;
  {$EXTERNALSYM ED_MEDIA_SIDE}

  ED_MEDIA_TYPE                          = ED_BASE+511;
  {$EXTERNALSYM ED_MEDIA_TYPE}
  ED_MEDIA_VHS                           = ED_BASE+512;
  {$EXTERNALSYM ED_MEDIA_VHS}
  ED_MEDIA_SVHS                          = ED_BASE+513;
  {$EXTERNALSYM ED_MEDIA_SVHS}
  ED_MEDIA_HI8                           = ED_BASE+514;
  {$EXTERNALSYM ED_MEDIA_HI8}
  ED_MEDIA_UMATIC                        = ED_BASE+515;
  {$EXTERNALSYM ED_MEDIA_UMATIC}
  ED_MEDIA_DVC                           = ED_BASE+516;
  {$EXTERNALSYM ED_MEDIA_DVC}
  ED_MEDIA_1_INCH                        = ED_BASE+517;
  {$EXTERNALSYM ED_MEDIA_1_INCH}
  ED_MEDIA_D1                            = ED_BASE+518;
  {$EXTERNALSYM ED_MEDIA_D1}
  ED_MEDIA_D2                            = ED_BASE+519;
  {$EXTERNALSYM ED_MEDIA_D2}
  ED_MEDIA_D3                            = ED_BASE+520;
  {$EXTERNALSYM ED_MEDIA_D3}
  ED_MEDIA_D5                            = ED_BASE+521;
  {$EXTERNALSYM ED_MEDIA_D5}
  ED_MEDIA_DBETA                         = ED_BASE+522;
  {$EXTERNALSYM ED_MEDIA_DBETA}
  ED_MEDIA_BETA                          = ED_BASE+523;
  {$EXTERNALSYM ED_MEDIA_BETA}
  ED_MEDIA_8MM                           = ED_BASE+524;
  {$EXTERNALSYM ED_MEDIA_8MM}
  ED_MEDIA_DDR                           = ED_BASE+525;
  {$EXTERNALSYM ED_MEDIA_DDR}
  ED_MEDIA_SX				 = ED_BASE+813;
  {$EXTERNALSYM ED_MEDIA_SX}
  ED_MEDIA_OTHER                         = ED_BASE+526;
  {$EXTERNALSYM ED_MEDIA_OTHER}
  ED_MEDIA_CLV                           = ED_BASE+527;
  {$EXTERNALSYM ED_MEDIA_CLV}
  ED_MEDIA_CAV                           = ED_BASE+528;
  {$EXTERNALSYM ED_MEDIA_CAV}
  ED_MEDIA_POSITION                      = ED_BASE+529;
  {$EXTERNALSYM ED_MEDIA_POSITION}
  ED_MEDIA_NEO                           = ED_BASE+531; // Mini digital tape for MPEG2TS signal
  {$EXTERNALSYM ED_MEDIA_NEO}
  ED_MEDIA_MICROMV                       = ED_MEDIA_NEO;
  {$EXTERNALSYM ED_MEDIA_MICROMV}

  ED_LINK_MODE                           = ED_BASE+530;
  {$EXTERNALSYM ED_LINK_MODE}

// IAMExtTransport Basic Parms
  ED_TRANSBASIC_TIME_FORMAT              = ED_BASE+540;
  {$EXTERNALSYM ED_TRANSBASIC_TIME_FORMAT}
  ED_FORMAT_MILLISECONDS                 = ED_BASE+541;
  {$EXTERNALSYM ED_FORMAT_MILLISECONDS}
  ED_FORMAT_FRAMES                       = ED_BASE+542;
  {$EXTERNALSYM ED_FORMAT_FRAMES}
  ED_FORMAT_REFERENCE_TIME               = ED_BASE+543;
  {$EXTERNALSYM ED_FORMAT_REFERENCE_TIME}

  ED_FORMAT_HMSF                         = ED_BASE+547;
  {$EXTERNALSYM ED_FORMAT_HMSF}
  ED_FORMAT_TMSF                         = ED_BASE+548;
  {$EXTERNALSYM ED_FORMAT_TMSF}

  ED_TRANSBASIC_TIME_REFERENCE           = ED_BASE+549;
  {$EXTERNALSYM ED_TRANSBASIC_TIME_REFERENCE}
  ED_TIMEREF_TIMECODE                    = ED_BASE+550;
  {$EXTERNALSYM ED_TIMEREF_TIMECODE}
  ED_TIMEREF_CONTROL_TRACK               = ED_BASE+551;
  {$EXTERNALSYM ED_TIMEREF_CONTROL_TRACK}
  ED_TIMEREF_INDEX                       = ED_BASE+552;
  {$EXTERNALSYM ED_TIMEREF_INDEX}

  ED_TRANSBASIC_SUPERIMPOSE              = ED_BASE+553;
  {$EXTERNALSYM ED_TRANSBASIC_SUPERIMPOSE}
  ED_TRANSBASIC_END_STOP_ACTION          = ED_BASE+554;
  {$EXTERNALSYM ED_TRANSBASIC_END_STOP_ACTION}

  ED_TRANSBASIC_RECORD_FORMAT            = ED_BASE+555;
  {$EXTERNALSYM ED_TRANSBASIC_RECORD_FORMAT}
  ED_RECORD_FORMAT_SP                    = ED_BASE+556;
  {$EXTERNALSYM ED_RECORD_FORMAT_SP}
  ED_RECORD_FORMAT_LP                    = ED_BASE+557;
  {$EXTERNALSYM ED_RECORD_FORMAT_LP}
  ED_RECORD_FORMAT_EP                    = ED_BASE+558;
  {$EXTERNALSYM ED_RECORD_FORMAT_EP}

  ED_TRANSBASIC_STEP_COUNT               = ED_BASE+559;
  {$EXTERNALSYM ED_TRANSBASIC_STEP_COUNT}
  ED_TRANSBASIC_STEP_UNIT                = ED_BASE+560;
  {$EXTERNALSYM ED_TRANSBASIC_STEP_UNIT}
  ED_STEP_FIELD                          = ED_BASE+561;
  {$EXTERNALSYM ED_STEP_FIELD}
  ED_STEP_FRAME                          = ED_BASE+562;
  {$EXTERNALSYM ED_STEP_FRAME}
  ED_STEP_3_2                            = ED_BASE+563;
  {$EXTERNALSYM ED_STEP_3_2}

  ED_TRANSBASIC_PREROLL                  = ED_BASE+564;
  {$EXTERNALSYM ED_TRANSBASIC_PREROLL}
  ED_TRANSBASIC_RECPREROLL               = ED_BASE+565;
  {$EXTERNALSYM ED_TRANSBASIC_RECPREROLL}
  ED_TRANSBASIC_POSTROLL                 = ED_BASE+566;
  {$EXTERNALSYM ED_TRANSBASIC_POSTROLL}
  ED_TRANSBASIC_EDIT_DELAY               = ED_BASE+567;
  {$EXTERNALSYM ED_TRANSBASIC_EDIT_DELAY}
  ED_TRANSBASIC_PLAYTC_DELAY             = ED_BASE+568;
  {$EXTERNALSYM ED_TRANSBASIC_PLAYTC_DELAY}
  ED_TRANSBASIC_RECTC_DELAY              = ED_BASE+569;
  {$EXTERNALSYM ED_TRANSBASIC_RECTC_DELAY}
  ED_TRANSBASIC_EDIT_FIELD               = ED_BASE+570;
  {$EXTERNALSYM ED_TRANSBASIC_EDIT_FIELD}
  ED_TRANSBASIC_FRAME_SERVO              = ED_BASE+571;
  {$EXTERNALSYM ED_TRANSBASIC_FRAME_SERVO}
  ED_TRANSBASIC_CF_SERVO                 = ED_BASE+572;
  {$EXTERNALSYM ED_TRANSBASIC_CF_SERVO}
  ED_TRANSBASIC_SERVO_REF                = ED_BASE+573;
  {$EXTERNALSYM ED_TRANSBASIC_SERVO_REF}
  ED_REF_EXTERNAL                        = ED_BASE+574;
  {$EXTERNALSYM ED_REF_EXTERNAL}
  ED_REF_INPUT                           = ED_BASE+575;
  {$EXTERNALSYM ED_REF_INPUT}
  ED_REF_INTERNAL                        = ED_BASE+576;
  {$EXTERNALSYM ED_REF_INTERNAL}
  ED_REF_AUTO                            = ED_BASE+577;
  {$EXTERNALSYM ED_REF_AUTO}

  ED_TRANSBASIC_WARN_GL                  = ED_BASE+578;
  {$EXTERNALSYM ED_TRANSBASIC_WARN_GL}
  ED_TRANSBASIC_SET_TRACKING             = ED_BASE+579;
  {$EXTERNALSYM ED_TRANSBASIC_SET_TRACKING}
  ED_TRACKING_PLUS                       = ED_BASE+580;
  {$EXTERNALSYM ED_TRACKING_PLUS}
  ED_TRACKING_MINUS                      = ED_BASE+581;
  {$EXTERNALSYM ED_TRACKING_MINUS}
  ED_TRACKING_RESET                      = ED_BASE+582;
  {$EXTERNALSYM ED_TRACKING_RESET}

  ED_TRANSBASIC_SET_FREEZE_TIMEOUT       = ED_BASE+583;
  {$EXTERNALSYM ED_TRANSBASIC_SET_FREEZE_TIMEOUT}
  ED_TRANSBASIC_VOLUME_NAME              = ED_BASE+584;
  {$EXTERNALSYM ED_TRANSBASIC_VOLUME_NAME}
  ED_TRANSBASIC_BALLISTIC_1              = ED_BASE+585;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_1}
  ED_TRANSBASIC_BALLISTIC_2              = ED_BASE+586;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_2}
  ED_TRANSBASIC_BALLISTIC_3              = ED_BASE+587;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_3}
  ED_TRANSBASIC_BALLISTIC_4              = ED_BASE+588;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_4}
  ED_TRANSBASIC_BALLISTIC_5              = ED_BASE+589;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_5}
  ED_TRANSBASIC_BALLISTIC_6              = ED_BASE+590;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_6}
  ED_TRANSBASIC_BALLISTIC_7              = ED_BASE+591;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_7}
  ED_TRANSBASIC_BALLISTIC_8              = ED_BASE+592;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_8}
  ED_TRANSBASIC_BALLISTIC_9              = ED_BASE+593;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_9}
  ED_TRANSBASIC_BALLISTIC_10             = ED_BASE+594;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_10}
  ED_TRANSBASIC_BALLISTIC_11             = ED_BASE+595;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_11}
  ED_TRANSBASIC_BALLISTIC_12             = ED_BASE+596;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_12}
  ED_TRANSBASIC_BALLISTIC_13             = ED_BASE+597;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_13}
  ED_TRANSBASIC_BALLISTIC_14             = ED_BASE+598;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_14}
  ED_TRANSBASIC_BALLISTIC_15             = ED_BASE+599;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_15}
  ED_TRANSBASIC_BALLISTIC_16             = ED_BASE+600;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_16}
  ED_TRANSBASIC_BALLISTIC_17             = ED_BASE+601;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_17}
  ED_TRANSBASIC_BALLISTIC_18             = ED_BASE+602;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_18}
  ED_TRANSBASIC_BALLISTIC_19             = ED_BASE+603;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_19}
  ED_TRANSBASIC_BALLISTIC_20             = ED_BASE+604;
  {$EXTERNALSYM ED_TRANSBASIC_BALLISTIC_20}

// consumer VCR items
  ED_TRANSBASIC_SETCLOCK                 = ED_BASE+605;
  {$EXTERNALSYM ED_TRANSBASIC_SETCLOCK}
  ED_TRANSBASIC_SET_COUNTER_FORMAT       = ED_BASE+606;
  {$EXTERNALSYM ED_TRANSBASIC_SET_COUNTER_FORMAT}
  ED_TRANSBASIC_SET_COUNTER_VALUE        = ED_BASE+607;
  {$EXTERNALSYM ED_TRANSBASIC_SET_COUNTER_VALUE}

  ED_TRANSBASIC_SETTUNER_CH_UP           = ED_BASE+608;
  {$EXTERNALSYM ED_TRANSBASIC_SETTUNER_CH_UP}
  ED_TRANSBASIC_SETTUNER_CH_DN           = ED_BASE+609;
  {$EXTERNALSYM ED_TRANSBASIC_SETTUNER_CH_DN}
  ED_TRANSBASIC_SETTUNER_SK_UP           = ED_BASE+610;
  {$EXTERNALSYM ED_TRANSBASIC_SETTUNER_SK_UP}
  ED_TRANSBASIC_SETTUNER_SK_DN           = ED_BASE+611;
  {$EXTERNALSYM ED_TRANSBASIC_SETTUNER_SK_DN}
  ED_TRANSBASIC_SETTUNER_CH              = ED_BASE+612;
  {$EXTERNALSYM ED_TRANSBASIC_SETTUNER_CH}
  ED_TRANSBASIC_SETTUNER_NUM             = ED_BASE+613;
  {$EXTERNALSYM ED_TRANSBASIC_SETTUNER_NUM}
  ED_TRANSBASIC_SETTIMER_EVENT           = ED_BASE+614;
  {$EXTERNALSYM ED_TRANSBASIC_SETTIMER_EVENT}
  ED_TRANSBASIC_SETTIMER_STARTDAY        = ED_BASE+615;
  {$EXTERNALSYM ED_TRANSBASIC_SETTIMER_STARTDAY}
  ED_TRANSBASIC_SETTIMER_STARTTIME       = ED_BASE+616;
  {$EXTERNALSYM ED_TRANSBASIC_SETTIMER_STARTTIME}
  ED_TRANSBASIC_SETTIMER_STOPDAY         = ED_BASE+617;
  {$EXTERNALSYM ED_TRANSBASIC_SETTIMER_STOPDAY}
  ED_TRANSBASIC_SETTIMER_STOPTIME        = ED_BASE+618;
  {$EXTERNALSYM ED_TRANSBASIC_SETTIMER_STOPTIME}

// IAMExtTransport video parameters
  ED_TRANSVIDEO_SET_OUTPUT               = ED_BASE+630;
  {$EXTERNALSYM ED_TRANSVIDEO_SET_OUTPUT}
  ED_E2E                                 = ED_BASE+631;
  {$EXTERNALSYM ED_E2E}
  ED_PLAYBACK                            = ED_BASE+632;
  {$EXTERNALSYM ED_PLAYBACK}
  ED_OFF                                 = ED_BASE+633;
  {$EXTERNALSYM ED_OFF}

  ED_TRANSVIDEO_SET_SOURCE               = ED_BASE+634;
  {$EXTERNALSYM ED_TRANSVIDEO_SET_SOURCE}

// IAMExtTransport audio parameters
  ED_TRANSAUDIO_ENABLE_OUTPUT            = ED_BASE+640;
  {$EXTERNALSYM ED_TRANSAUDIO_ENABLE_OUTPUT}
  ED_AUDIO_ALL                           = $10000000;
  {$EXTERNALSYM ED_AUDIO_ALL}
  ED_AUDIO_1                             = $0000001;
  {$EXTERNALSYM ED_AUDIO_1}
  ED_AUDIO_2                             = $0000002;
  {$EXTERNALSYM ED_AUDIO_2}
  ED_AUDIO_3                             = $0000004;
  {$EXTERNALSYM ED_AUDIO_3}
  ED_AUDIO_4                             = $0000008;
  {$EXTERNALSYM ED_AUDIO_4}
  ED_AUDIO_5                             = $0000010;
  {$EXTERNALSYM ED_AUDIO_5}
  ED_AUDIO_6                             = $0000020;
  {$EXTERNALSYM ED_AUDIO_6}
  ED_AUDIO_7                             = $0000040;
  {$EXTERNALSYM ED_AUDIO_7}
  ED_AUDIO_8                             = $0000080;
  {$EXTERNALSYM ED_AUDIO_8}
  ED_AUDIO_9                             = $0000100;
  {$EXTERNALSYM ED_AUDIO_9}
  ED_AUDIO_10                            = $0000200;
  {$EXTERNALSYM ED_AUDIO_10}
  ED_AUDIO_11                            = $0000400;
  {$EXTERNALSYM ED_AUDIO_11}
  ED_AUDIO_12                            = $0000800;
  {$EXTERNALSYM ED_AUDIO_12}
  ED_AUDIO_13                            = $0001000;
  {$EXTERNALSYM ED_AUDIO_13}
  ED_AUDIO_14                            = $0002000;
  {$EXTERNALSYM ED_AUDIO_14}
  ED_AUDIO_15                            = $0004000;
  {$EXTERNALSYM ED_AUDIO_15}
  ED_AUDIO_16                            = $0008000;
  {$EXTERNALSYM ED_AUDIO_16}
  ED_AUDIO_17                            = $0010000;
  {$EXTERNALSYM ED_AUDIO_17}
  ED_AUDIO_18                            = $0020000;
  {$EXTERNALSYM ED_AUDIO_18}
  ED_AUDIO_19                            = $0040000;
  {$EXTERNALSYM ED_AUDIO_19}
  ED_AUDIO_20                            = $0080000;
  {$EXTERNALSYM ED_AUDIO_20}
  ED_AUDIO_21                            = $0100000;
  {$EXTERNALSYM ED_AUDIO_21}
  ED_AUDIO_22                            = $0200000;
  {$EXTERNALSYM ED_AUDIO_22}
  ED_AUDIO_23                            = $0400000;
  {$EXTERNALSYM ED_AUDIO_23}
  ED_AUDIO_24                            = $0800000;
  {$EXTERNALSYM ED_AUDIO_24}
  ED_VIDEO                               = $2000000;
  {$EXTERNALSYM ED_VIDEO}

  ED_TRANSAUDIO_ENABLE_RECORD            = ED_BASE+642;
  {$EXTERNALSYM ED_TRANSAUDIO_ENABLE_RECORD}
  ED_TRANSAUDIO_ENABLE_SELSYNC           = ED_BASE+643;
  {$EXTERNALSYM ED_TRANSAUDIO_ENABLE_SELSYNC}
  ED_TRANSAUDIO_SET_SOURCE               = ED_BASE+644;
  {$EXTERNALSYM ED_TRANSAUDIO_SET_SOURCE}
  ED_TRANSAUDIO_SET_MONITOR              = ED_BASE+645;
  {$EXTERNALSYM ED_TRANSAUDIO_SET_MONITOR}

// Edit Property Set-related defs

// The following values reflect (and control) the state of an
// edit property set
  ED_INVALID                             = ED_BASE+652;
  {$EXTERNALSYM ED_INVALID}
  ED_EXECUTING                           = ED_BASE+653;
  {$EXTERNALSYM ED_EXECUTING}
  ED_REGISTER                            = ED_BASE+654;
  {$EXTERNALSYM ED_REGISTER}
  ED_DELETE                              = ED_BASE+655;
  {$EXTERNALSYM ED_DELETE}

// Edit property set parameters and values
  ED_EDIT_HEVENT                         = ED_BASE+656;
  {$EXTERNALSYM ED_EDIT_HEVENT}
  ED_EDIT_TEST                           = ED_BASE+657;
  {$EXTERNALSYM ED_EDIT_TEST}
  ED_EDIT_IMMEDIATE                      = ED_BASE+658;
  {$EXTERNALSYM ED_EDIT_IMMEDIATE}

  ED_EDIT_MODE                           = ED_BASE+659;
  {$EXTERNALSYM ED_EDIT_MODE}
// can be one of the following values:
  ED_EDIT_MODE_ASSEMBLE                  = ED_BASE+660;
  {$EXTERNALSYM ED_EDIT_MODE_ASSEMBLE}
  ED_EDIT_MODE_INSERT                    = ED_BASE+661;
  {$EXTERNALSYM ED_EDIT_MODE_INSERT}
  ED_EDIT_MODE_CRASH_RECORD              = ED_BASE+662;
  {$EXTERNALSYM ED_EDIT_MODE_CRASH_RECORD}
  ED_EDIT_MODE_BOOKMARK_TIME             = ED_BASE+663;
  {$EXTERNALSYM ED_EDIT_MODE_BOOKMARK_TIME}
  ED_EDIT_MODE_BOOKMARK_CHAPTER          = ED_BASE+664;
  {$EXTERNALSYM ED_EDIT_MODE_BOOKMARK_CHAPTER}

  ED_EDIT_MASTER                         = ED_BASE+666;
  {$EXTERNALSYM ED_EDIT_MASTER}

  ED_EDIT_TRACK                          = ED_BASE+667;
  {$EXTERNALSYM ED_EDIT_TRACK}
// can be one of the following possible OR'd values:
//  ED_VIDEO, ED_AUDIO_1 thru ED_AUDIO_24 (or ED_AUDIO_ALL)

  EDED_EDIT_SRC_INPOINT                  = ED_BASE+668;
  {$EXTERNALSYM EDED_EDIT_SRC_INPOINT}
  ED_EDIT_SRC_OUTPOINT                   = ED_BASE+669;
  {$EXTERNALSYM ED_EDIT_SRC_OUTPOINT}
  ED_EDIT_REC_INPOINT                    = ED_BASE+670;
  {$EXTERNALSYM ED_EDIT_REC_INPOINT}
  ED_EDIT_REC_OUTPOINT                   = ED_BASE+671;
  {$EXTERNALSYM ED_EDIT_REC_OUTPOINT}

  ED_EDIT_REHEARSE_MODE                  = ED_BASE+672;
  {$EXTERNALSYM ED_EDIT_REHEARSE_MODE}
// can be one of the following possible values:
  ED_EDIT_BVB                            = ED_BASE+673;
  {$EXTERNALSYM ED_EDIT_BVB}
  ED_EDIT_VBV                            = ED_BASE+674;
  {$EXTERNALSYM ED_EDIT_VBV}
  ED_EDIT_VVV                            = ED_BASE+675;
  {$EXTERNALSYM ED_EDIT_VVV}
  ED_EDIT_PERFORM                        = ED_BASE+676;
  {$EXTERNALSYM ED_EDIT_PERFORM}


// Set this property to OATRUE to kill the edit if in progress
  ED_EDIT_ABORT                          = ED_BASE+677;
  {$EXTERNALSYM ED_EDIT_ABORT}
// how long to wait for edit to complete
  ED_EDIT_TIMEOUT                        = ED_BASE+678;
  {$EXTERNALSYM ED_EDIT_TIMEOUT}

// This property causes the device to seek to a point specified by
// ED_EDIT_SEEK_MODE (see below).  NOTE: Only one event at a time can seek.
  ED_EDIT_SEEK                           = ED_BASE+679;
  {$EXTERNALSYM ED_EDIT_SEEK}
  ED_EDIT_SEEK_MODE                      = ED_BASE+680;
  {$EXTERNALSYM ED_EDIT_SEEK_MODE}

//possible values:
  ED_EDIT_SEEK_EDIT_IN                   = ED_BASE+681;
  {$EXTERNALSYM ED_EDIT_SEEK_EDIT_IN}
  ED_EDIT_SEEK_EDIT_OUT                  = ED_BASE+682;
  {$EXTERNALSYM ED_EDIT_SEEK_EDIT_OUT}
  ED_EDIT_SEEK_PREROLL                   = ED_BASE+683;
  {$EXTERNALSYM ED_EDIT_SEEK_PREROLL}
  ED_EDIT_SEEK_PREROLL_CT                = ED_BASE+684;
  {$EXTERNALSYM ED_EDIT_SEEK_PREROLL_CT}
  ED_EDIT_SEEK_BOOKMARK                  = ED_BASE+685;
  {$EXTERNALSYM ED_EDIT_SEEK_BOOKMARK}
  ED_EDIT_OFFSET	                 = ED_BASE+686;
  {$EXTERNALSYM ED_EDIT_OFFSET}
  ED_EDIT_PREREAD	                 = ED_BASE+815;
  {$EXTERNALSYM ED_EDIT_PREREAD}
//
// Some error codes:
//
// device could be in local mode
  ED_ERR_DEVICE_NOT_READY                = ED_BASE+700;
  {$EXTERNALSYM ED_ERR_DEVICE_NOT_READY}

// **************************************************
//
// New constants added for implementation of DVCR
//
// **************************************************


//
// New Device type (a DV has two subunits: camera and VCR)
//
  ED_DEVTYPE_CAMERA        =  ED_BASE+900;
  {$EXTERNALSYM ED_DEVTYPE_CAMERA}

  ED_DEVTYPE_TUNER         =  ED_BASE+901;
  {$EXTERNALSYM ED_DEVTYPE_TUNER}

  ED_DEVTYPE_DVHS          =  ED_BASE+902;
  {$EXTERNALSYM ED_DEVTYPE_DVHS}

  ED_DEVTYPE_UNKNOWN        = ED_BASE+903;     // Driver cannot determine the device type
  {$EXTERNALSYM ED_DEVTYPE_UNKNOWN}

  ED_DEVTYPE_CAMERA_STORAGE = ED_BASE+1034;    // Storage for digital still images, short video files, etc.
  {$EXTERNALSYM ED_DEVTYPE_CAMERA_STORAGE}

  ED_DEVTYPE_DTV            = ED_BASE+1035;    // DTV with serial bus interface
  {$EXTERNALSYM ED_DEVTYPE_DTV}

  ED_DEVTYPE_PC_VIRTUAL     = ED_BASE+1036;    // Emulated device (virtual) on a PC
  {$EXTERNALSYM ED_DEVTYPE_PC_VIRTUAL}


//
// Unknownn capability
//     Instead of return E_NOTIMPL, or S_OK with OAFALSE, it may return S_OK with _UNKNOWN
//
  ED_CAPABILITY_UNKNOWN    =  ED_BASE+910;
  {$EXTERNALSYM ED_CAPABILITY_UNKNOWN}


//
// Send raw 1394/AVC extenal device command via GetTransportBasicParameters()
// This is specifically for a 1394 AVC device connected with DEV_PORT_1394.
//
  ED_RAW_EXT_DEV_CMD       =  ED_BASE+920;
  {$EXTERNALSYM ED_RAW_EXT_DEV_CMD}


//
// MEDIUM INFO
//
  ED_MEDIA_VHSC            =  ED_BASE+925;  // New media type
  {$EXTERNALSYM ED_MEDIA_VHSC}
  ED_MEDIA_UNKNOWN         =  ED_BASE+926;  // Unknown media
  {$EXTERNALSYM ED_MEDIA_UNKNOWN}
  ED_MEDIA_NOT_PRESENT     =  ED_BASE+927;
  {$EXTERNALSYM ED_MEDIA_NOT_PRESENT}


//
// Device Control command that can result in pending state.
//
  ED_CONTROL_HEVENT_GET         =  ED_BASE+928;  // To get a sychronous event handle
  {$EXTERNALSYM ED_CONTROL_HEVENT_GET}
  ED_CONTROL_HEVENT_RELEASE     =  ED_BASE+929;  // To release sychronous event handle must match what it got
  {$EXTERNALSYM ED_CONTROL_HEVENT_RELEASE}

  ED_DEV_REMOVED_HEVENT_GET     =  ED_BASE+960;  // To be a notify event and will be signal if device is removed.
  {$EXTERNALSYM ED_DEV_REMOVED_HEVENT_GET}
  ED_DEV_REMOVED_HEVENT_RELEASE =  ED_BASE+961;  // Release this event handle
  {$EXTERNALSYM ED_DEV_REMOVED_HEVENT_RELEASE}


//
// TRANSPORT STATE
//
  ED_NOTIFY_HEVENT_GET     =  ED_BASE+930;  // To get a sychronous event handle
  {$EXTERNALSYM ED_NOTIFY_HEVENT_GET}
  ED_NOTIFY_HEVENT_RELEASE =  ED_BASE+931;  // To release sychronous event handle must match what it got
  {$EXTERNALSYM ED_NOTIFY_HEVENT_RELEASE}
  ED_MODE_CHANGE_NOTIFY    =  ED_BASE+932;  // This is asynchronous operation, wait for event.
  {$EXTERNALSYM ED_MODE_CHANGE_NOTIFY}

  ED_MODE_PLAY_FASTEST_FWD =  ED_BASE+933;
  {$EXTERNALSYM ED_MODE_PLAY_FASTEST_FWD}
  ED_MODE_PLAY_SLOWEST_FWD =  ED_BASE+934;
  {$EXTERNALSYM ED_MODE_PLAY_SLOWEST_FWD}
  ED_MODE_PLAY_FASTEST_REV =  ED_BASE+935;
  {$EXTERNALSYM ED_MODE_PLAY_FASTEST_REV}
  ED_MODE_PLAY_SLOWEST_REV =  ED_BASE+936;
  {$EXTERNALSYM ED_MODE_PLAY_SLOWEST_REV}

  ED_MODE_WIND             =  ED_BASE+937;
  {$EXTERNALSYM ED_MODE_WIND}
  ED_MODE_REW_FASTEST      =  ED_BASE+938;  // High speed rewind
  {$EXTERNALSYM ED_MODE_REW_FASTEST}

  ED_MODE_REV_PLAY         =  ED_BASE+939;  // x1 speed reverse play
  {$EXTERNALSYM ED_MODE_REV_PLAY}

//
// Additional play modes (added post Windows XP)
//

  ED_MODE_PLAY_SLOW_FWD_6       = ED_BASE+1001;  // Slow forward
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_FWD_6}
  ED_MODE_PLAY_SLOW_FWD_5       = ED_BASE+1002;
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_FWD_5}
  ED_MODE_PLAY_SLOW_FWD_4       = ED_BASE+1003;
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_FWD_4}
  ED_MODE_PLAY_SLOW_FWD_3       = ED_BASE+1004;
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_FWD_3}
  ED_MODE_PLAY_SLOW_FWD_2       = ED_BASE+1005;
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_FWD_2}
  ED_MODE_PLAY_SLOW_FWD_1       = ED_BASE+1006;
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_FWD_1}

  ED_MODE_PLAY_FAST_FWD_1       = ED_BASE+1007;  // Fast forward
  {$EXTERNALSYM ED_MODE_PLAY_FAST_FWD_1}
  ED_MODE_PLAY_FAST_FWD_2       = ED_BASE+1008;
  {$EXTERNALSYM ED_MODE_PLAY_FAST_FWD_2}
  ED_MODE_PLAY_FAST_FWD_3       = ED_BASE+1009;
  {$EXTERNALSYM ED_MODE_PLAY_FAST_FWD_3}
  ED_MODE_PLAY_FAST_FWD_4       = ED_BASE+1010;
  {$EXTERNALSYM ED_MODE_PLAY_FAST_FWD_4}
  ED_MODE_PLAY_FAST_FWD_5       = ED_BASE+1011;
  {$EXTERNALSYM ED_MODE_PLAY_FAST_FWD_5}
  ED_MODE_PLAY_FAST_FWD_6       = ED_BASE+1012;
  {$EXTERNALSYM ED_MODE_PLAY_FAST_FWD_6}

  ED_MODE_PLAY_SLOW_REV_6       = ED_BASE+1013;  // Slow reverse
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_REV_6}
  ED_MODE_PLAY_SLOW_REV_5       = ED_BASE+1014;
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_REV_5}
  ED_MODE_PLAY_SLOW_REV_4       = ED_BASE+1015;
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_REV_4}
  ED_MODE_PLAY_SLOW_REV_3       = ED_BASE+1016;
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_REV_3}
  ED_MODE_PLAY_SLOW_REV_2       = ED_BASE+1017;
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_REV_2}
  ED_MODE_PLAY_SLOW_REV_1       = ED_BASE+1018;
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_REV_1}

  ED_MODE_PLAY_FAST_REV_1       = ED_BASE+1019;  // Fast reverse
  {$EXTERNALSYM ED_MODE_PLAY_FAST_REV_1}
  ED_MODE_PLAY_FAST_REV_2       = ED_BASE+1020;
  {$EXTERNALSYM ED_MODE_PLAY_FAST_REV_2}
  ED_MODE_PLAY_FAST_REV_3       = ED_BASE+1021;
  {$EXTERNALSYM ED_MODE_PLAY_FAST_REV_3}
  ED_MODE_PLAY_FAST_REV_4       = ED_BASE+1022;
  {$EXTERNALSYM ED_MODE_PLAY_FAST_REV_4}
  ED_MODE_PLAY_FAST_REV_5       = ED_BASE+1023;
  {$EXTERNALSYM ED_MODE_PLAY_FAST_REV_5}
  ED_MODE_PLAY_FAST_REV_6       = ED_BASE+1024;
  {$EXTERNALSYM ED_MODE_PLAY_FAST_REV_6}

  ED_MODE_REVERSE               = ED_MODE_REV_PLAY; // Same as Reverse playback
  {$EXTERNALSYM ED_MODE_REVERSE}
  ED_MODE_REVERSE_FREEZE        = ED_BASE+1025;    // Pause at reverse playback
  {$EXTERNALSYM ED_MODE_REVERSE_FREEZE}

  ED_MODE_PLAY_SLOW_FWD_X       = ED_BASE+1026;    // Possible response for a trick play
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_FWD_X}
  ED_MODE_PLAY_FAST_FWD_X       = ED_BASE+1027;    // Possible response for a trick play
  {$EXTERNALSYM ED_MODE_PLAY_FAST_FWD_X}
  ED_MODE_PLAY_SLOW_REV_X       = ED_BASE+1028;    // Possible response for a trick play
  {$EXTERNALSYM ED_MODE_PLAY_SLOW_REV_X}
  ED_MODE_PLAY_FAST_REV_X       = ED_BASE+1029;    // Possible response for a trick play
  {$EXTERNALSYM ED_MODE_PLAY_FAST_REV_X}

  ED_MODE_STOP_START            = ED_BASE+1030;    // Indicate stopping at the begin of a tape
  {$EXTERNALSYM ED_MODE_STOP_START}
  ED_MODE_STOP_END              = ED_BASE+1031;    // Indicate stopping at the end of a tape
  {$EXTERNALSYM ED_MODE_STOP_END}
  ED_MODE_STOP_EMERGENCY        = ED_BASE+1032;    // Indicate stopping due to an emergency
  {$EXTERNALSYM ED_MODE_STOP_EMERGENCY}

//
// TRANSPOSRTBASIC: input and output signal
//
  ED_TRANSBASIC_INPUT_SIGNAL      = ED_BASE+940;
  {$EXTERNALSYM ED_TRANSBASIC_INPUT_SIGNAL}
  ED_TRANSBASIC_OUTPUT_SIGNAL     = ED_BASE+941;
  {$EXTERNALSYM ED_TRANSBASIC_OUTPUT_SIGNAL}

  ED_TRANSBASIC_SIGNAL_525_60_SD  = ED_BASE+942;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_525_60_SD}
  ED_TRANSBASIC_SIGNAL_525_60_SDL = ED_BASE+943;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_525_60_SDL}
  ED_TRANSBASIC_SIGNAL_625_50_SD  = ED_BASE+944;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_625_50_SD}
  ED_TRANSBASIC_SIGNAL_625_50_SDL = ED_BASE+945;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_625_50_SDL}
  ED_TRANSBASIC_SIGNAL_MPEG2TS    = ED_BASE+946;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_MPEG2TS}
  ED_TRANSBASIC_SIGNAL_625_60_HD  = ED_BASE+947;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_625_60_HD}
  ED_TRANSBASIC_SIGNAL_625_50_HD  = ED_BASE+948;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_625_50_HD}

  ED_TRANSBASIC_SIGNAL_2500_60_MPEG   = ED_BASE+980;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_2500_60_MPEG}
  ED_TRANSBASIC_SIGNAL_1250_60_MPEG   = ED_BASE+981;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_1250_60_MPEG}
  ED_TRANSBASIC_SIGNAL_0625_60_MPEG   = ED_BASE+982;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_0625_60_MPEG}

  ED_TRANSBASIC_SIGNAL_2500_50_MPEG   = ED_BASE+985;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_2500_50_MPEG}
  ED_TRANSBASIC_SIGNAL_1250_50_MPEG   = ED_BASE+986;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_1250_50_MPEG}
  ED_TRANSBASIC_SIGNAL_0625_50_MPEG   = ED_BASE+987;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_0625_50_MPEG}

  ED_TRANSBASIC_SIGNAL_UNKNOWN   = ED_BASE+990;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_UNKNOWN}

  ED_TRANSBASIC_SIGNAL_525_60_DV25  = ED_BASE+991;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_525_60_DV25}
  ED_TRANSBASIC_SIGNAL_625_50_DV25  = ED_BASE+992;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_625_50_DV25}

  ED_TRANSBASIC_SIGNAL_525_60_DV50  = ED_BASE+993;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_525_60_DV50}
  ED_TRANSBASIC_SIGNAL_625_50_DV50  = ED_BASE+994;
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_625_50_DV50}

  ED_TRANSBASIC_SIGNAL_HD_60_DVH1   = ED_BASE+995;  // DVCPRO 100: 1080i or 720p
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_HD_60_DVH1}
  ED_TRANSBASIC_SIGNAL_HD_50_DVH1   = ED_BASE+996;  // DVCPRO 100: 1080i only
  {$EXTERNALSYM ED_TRANSBASIC_SIGNAL_HD_50_DVH1}


//
// TIMECODE/AbsoluteTrackNumber/RealTimeCounter read/seek/write
//
  ED_DEVCAP_TIMECODE_SEEK  =    ED_BASE+950;
  {$EXTERNALSYM ED_DEVCAP_TIMECODE_SEEK}

  ED_DEVCAP_ATN_READ	   =    ED_BASE+951;
  {$EXTERNALSYM ED_DEVCAP_ATN_READ}
  ED_DEVCAP_ATN_SEEK	   =    ED_BASE+952;
  {$EXTERNALSYM ED_DEVCAP_ATN_SEEK}
  ED_DEVCAP_ATN_WRITE	   =    ED_BASE+953;
  {$EXTERNALSYM ED_DEVCAP_ATN_WRITE}

  ED_DEVCAP_RTC_READ	   =    ED_BASE+954;
  {$EXTERNALSYM ED_DEVCAP_RTC_READ}
  ED_DEVCAP_RTC_SEEK	   =    ED_BASE+955;
  {$EXTERNALSYM ED_DEVCAP_RTC_SEEK}
  ED_DEVCAP_RTC_WRITE	   =    ED_BASE+956;
  {$EXTERNALSYM ED_DEVCAP_RTC_WRITE}

//
// Basic parameter
//
  ED_TIMEREF_ATN     =        ED_BASE+958;
  {$EXTERNALSYM ED_TIMEREF_ATN}

//
// GUID used to identify a class driver
//
  MSTapeDeviceGUID : TGUID = '{8C0F6AF2-0EDB-44c1-8AEB-59040BD830ED}'; // MSTapeDeviceGUID
  {$EXTERNALSYM MSTapeDeviceGUID}

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       aviriff.h
 *
 ***************************************************************************)

type
(*+
 *
 * Structures and defines for the RIFF AVI file format extended to
 * handle very large/long files
 *
 *-=====================================================================*)

                 {
#if !defined NUMELMS
  #define NUMELMS(aa) (sizeof(aa)/sizeof((aa)[0]))
#endif
                  }
// all structures in this file are packed on word boundaries
//
(*
 * heres the general layout of an AVI riff file (new format)
 *
 * RIFF (3F??????) AVI       <- not more than 1 GB in size
 *     LIST (size) hdrl
 *         avih (0038)
 *         LIST (size) strl
 *             strh (0038)
 *             strf (????)
 *             indx (3ff8)   <- size may vary, should be sector sized
 *         LIST (size) strl
 *             strh (0038)
 *             strf (????)
 *             indx (3ff8)   <- size may vary, should be sector sized
 *         LIST (size) odml
 *             dmlh (????)
 *         JUNK (size)       <- fill to align to sector - 12
 *     LIST (7f??????) movi  <- aligned on sector - 12
 *         00dc (size)       <- sector aligned
 *         01wb (size)       <- sector aligned
 *         ix00 (size)       <- sector aligned
 *     idx1 (00??????)       <- sector aligned
 * RIFF (7F??????) AVIX
 *     JUNK (size)           <- fill to align to sector -12
 *     LIST (size) movi
 *         00dc (size)       <- sector aligned
 * RIFF (7F??????) AVIX      <- not more than 2GB in size
 *     JUNK (size)           <- fill to align to sector - 12
 *     LIST (size) movi
 *         00dc (size)       <- sector aligned
 *
 *-===================================================================*)

//
// structures for manipulating RIFF headers
//
{
#define FCC(ch4) ((((DWORD)(ch4) & 0xFF) << 24) |     \
                  (((DWORD)(ch4) & 0xFF00) << 8) |    \
                  (((DWORD)(ch4) & 0xFF0000) >> 8) |  \
                  (((DWORD)(ch4) & 0xFF000000) >> 24))
}
  PRIFFChunk = ^TRIFFChunk;
  _riffchunk = record
    fcc: FOURCC;
    cb: DWORD;
  end;
  {$EXTERNALSYM _riffchunk}
  RIFFCHUNK = _riffchunk;
  {$EXTERNALSYM RIFFCHUNK}
  LPRIFFCHUNK = ^RIFFCHUNK;
  {$EXTERNALSYM LPRIFFCHUNK}
  TRIFFChunk = _riffchunk;

  PRIFFList = ^TRIFFList;
  _rifflist = record
    fcc: FOURCC;
    cb: DWORD;
    fccListType: FOURCC;
  end;
  {$EXTERNALSYM _rifflist}
  RIFFLIST = _rifflist;
  {$EXTERNALSYM RIFFLIST}
  LPRIFFLIST = ^RIFFLIST;
  {$EXTERNALSYM LPRIFFLIST}
  TRIFFList = _rifflist;

{
#define RIFFROUND(cb) ((cb) + ((cb)&1))
#define RIFFNEXT(pChunk) (LPRIFFCHUNK)((LPBYTE)(pChunk) \
                          + sizeof(RIFFCHUNK) \
                          + RIFFROUND(((LPRIFFCHUNK)pChunk)->cb))

}
//
// ==================== avi header structures ===========================
//

// main header for the avi file (compatibility header)
const
  ckidMAINAVIHEADER = $68697661;// 'avih'
  {$EXTERNALSYM ckidMAINAVIHEADER}

type
  _avimainheader = record
    fcc: FOURCC;                   // 'avih'
    cb: DWORD;                     // size of this structure -8
    dwMicroSecPerFrame: DWORD;     // frame display rate (or 0L)
    dwMaxBytesPerSec: DWORD;       // max. transfer rate
    dwPaddingGranularity: DWORD;   // pad to multiples of this size; normally 2K.
    dwFlags: DWORD;                // the ever-present flags
    dwTotalFrames: DWORD;          // # frames in first movi list
    dwInitialFrames: DWORD;
    dwStreams: DWORD;
    dwSuggestedBufferSize: DWORD;
    dwWidth: DWORD;
    dwHeight: DWORD;
    dwReserved: array[0..3] of DWORD;
  end;
  {$EXTERNALSYM _avimainheader}
  AVIMAINHEADER = _avimainheader;
  {$EXTERNALSYM AVIMAINHEADER}
  TAVIMainHeader = _avimainheader;

const
  AVIF_HASINDEX       = $00000010; // Index at end of file?
  {$EXTERNALSYM AVIF_HASINDEX}
  AVIF_MUSTUSEINDEX   = $00000020;
  {$EXTERNALSYM AVIF_MUSTUSEINDEX}
  AVIF_ISINTERLEAVED  = $00000100;
  {$EXTERNALSYM AVIF_ISINTERLEAVED}
  AVIF_TRUSTCKTYPE    = $00000800; // Use CKType to find key frames
  {$EXTERNALSYM AVIF_TRUSTCKTYPE}
  AVIF_WASCAPTUREFILE = $00010000;
  {$EXTERNALSYM AVIF_WASCAPTUREFILE}
  AVIF_COPYRIGHTED    = $00020000;
  {$EXTERNALSYM AVIF_COPYRIGHTED}

  ckidODML            = $6C6D646F; //'odml'
  {$EXTERNALSYM ckidODML}
  ckidAVIEXTHEADER    = $686C6D64; //'dmlh'
  {$EXTERNALSYM ckidAVIEXTHEADER}

type
  _aviextheader = record
    fcc: FOURCC;                       // 'dmlh'
    cb: DWORD;                         // size of this structure -8
    dwGrandFrames: DWORD;              // total number of frames in the file
    dwFuture: array[0..60] of DWORD;   // to be defined later
  end;
  {$EXTERNALSYM _aviextheader}
  AVIEXTHEADER = _aviextheader;
  {$EXTERNALSYM AVIEXTHEADER}
  TAVIExtHeader = _aviextheader;

//
// structure of an AVI stream header riff chunk
//
const
  ckidSTREAMLIST    = $6C727473; //'strl'
  {$EXTERNALSYM ckidSTREAMLIST}
  ckidSTREAMHEADER  = $68727473; //'strh'
  {$EXTERNALSYM ckidSTREAMHEADER}

type
  _avistreamheader = record
     fcc: FOURCC;            // 'strh'
     cb: DWORD;              // size of this structure - 8

     fccType: FOURCC;        // stream type codes

     fccHandler: FOURCC;
     dwFlags: DWORD;

     wPriority: WORD;
     wLanguage: WORD;
     dwInitialFrames: DWORD;
     dwScale: DWORD;
     dwRate: DWORD;          // dwRate/dwScale is stream tick rate in ticks/sec
     dwStart: DWORD;
     dwLength: DWORD;
     dwSuggestedBufferSize: DWORD;
     dwQuality: DWORD;
     dwSampleSize: DWORD;

     rcFrame: record
       left: SmallInt;
       top: SmallInt;
       right: SmallInt;
       bottom: SmallInt;
     end;
  end;
  {$EXTERNALSYM _avistreamheader}
  AVISTREAMHEADER = _avistreamheader;
  {$EXTERNALSYM AVISTREAMHEADER}
  TAVIStreamHeader = _avistreamheader;
  
const

  streamtypeVIDEO = $73646976; //'vids'
  {$EXTERNALSYM streamtypeVIDEO}
  streamtypeAUDIO = $73647561; //'auds'
  {$EXTERNALSYM streamtypeAUDIO}
  streamtypeMIDI  = $7364696D; //'mids'
  {$EXTERNALSYM streamtypeMIDI}
  streamtypeTEXT  = $73747874; //'txts'
  {$EXTERNALSYM streamtypeTEXT}

  AVISF_DISABLED         = $00000001;
  {$EXTERNALSYM AVISF_DISABLED}
  AVISF_VIDEO_PALCHANGES = $00010000;
  {$EXTERNALSYM AVISF_VIDEO_PALCHANGES}

//
// structure of an AVI stream format chunk
//

  ckidSTREAMFORMAT = $66727473; //'strf'
  {$EXTERNALSYM ckidSTREAMFORMAT}

//
// avi stream formats are different for each stream type
//
// BITMAPINFOHEADER for video streams
// WAVEFORMATEX or PCMWAVEFORMAT for audio streams
// nothing for text streams
// nothing for midi streams


//
// structure of old style AVI index
//
  ckidAVIOLDINDEX = $31786469;//'idx1'
  {$EXTERNALSYM ckidAVIOLDINDEX}

type
  _avioldindex = record
    fcc: FOURCC;      // 'idx1'
    cb: DWORD;        // size of this structure -8

    aIndex: array[0..0] of record
      dwChunkId: DWORD;
      dwFlags: DWORD;
      dwOffset: DWORD;      // offset of riff chunk header for the data
      dwSize: DWORD;        // size of the data (excluding riff header size)
    end;                    // size of this array
  end;
  {$EXTERNALSYM _avioldindex}
  AVIOLDINDEX = _avioldindex;
  {$EXTERNALSYM AVIOLDINDEX}
  TAVIOldIndex = _avioldindex;

const
  AVIIF_LIST       = $00000001;
  {$EXTERNALSYM AVIIF_LIST}
  AVIIF_KEYFRAME   = $00000010;
  {$EXTERNALSYM AVIIF_KEYFRAME}

  AVIIF_NO_TIME    = $00000100;
  {$EXTERNALSYM AVIIF_NO_TIME}
  AVIIF_COMPRESSOR = $0FFF0000;  // unused?
  {$EXTERNALSYM AVIIF_COMPRESSOR}


// old timecode structure
//typedef union _timecode {
//   struct {
//      WORD   wFrameRate;
//      WORD   wFrameFract;
//      LONG   cFrames;
//      };
//   DWORDLONG  qw;
//   } TIMECODE;
//
// struct for all the SMPTE timecode info
//
  TIMECODE_RATE_30DROP = 0;   // this MUST be zero
  {$EXTERNALSYM TIMECODE_RATE_30DROP}

type
  _timecodedata = record
    time: TTimeCode;
    dwSMPTEflags: DWORD;
    dwUser: DWORD;
  end;
  {$EXTERNALSYM _timecodedata}
  TIMECODEDATA = _timecodedata;
  {$EXTERNALSYM TIMECODEDATA}
  TTimeCodeData = _timecodedata;

// dwSMPTEflags masks/values
//
const
  TIMECODE_SMPTE_BINARY_GROUP = $07;
  {$EXTERNALSYM TIMECODE_SMPTE_BINARY_GROUP}
  TIMECODE_SMPTE_COLOR_FRAME  = $08;
  {$EXTERNALSYM TIMECODE_SMPTE_COLOR_FRAME}

//
// ============ structures for new style AVI indexes =================
//

// index type codes
//
  AVI_INDEX_OF_INDEXES      = $00;
  {$EXTERNALSYM AVI_INDEX_OF_INDEXES}
  AVI_INDEX_OF_CHUNKS       = $01;
  {$EXTERNALSYM AVI_INDEX_OF_CHUNKS}
  AVI_INDEX_OF_TIMED_CHUNKS = $02;
  {$EXTERNALSYM AVI_INDEX_OF_TIMED_CHUNKS}
  AVI_INDEX_OF_SUB_2FIELD   = $03;
  {$EXTERNALSYM AVI_INDEX_OF_SUB_2FIELD}
  AVI_INDEX_IS_DATA         = $80;
  {$EXTERNALSYM AVI_INDEX_IS_DATA}

// index subtype codes
//
  AVI_INDEX_SUB_DEFAULT     = $00;
  {$EXTERNALSYM AVI_INDEX_SUB_DEFAULT}

// INDEX_OF_CHUNKS subtype codes
//
  AVI_INDEX_SUB_2FIELD      = $01;
  {$EXTERNALSYM AVI_INDEX_SUB_2FIELD}

// meta structure of all avi indexes
//
type
  _avimetaindex = record
    fcc: FOURCC;
    cb: UINT;
    wLongsPerEntry: WORD;
    bIndexSubType: BYTE;
    bIndexType: BYTE;
    nEntriesInUse: DWORD;
    dwChunkId: DWORD;
    dwReserved: array[0..2] of DWORD;
    adwIndex: array[0..0] of DWORD;
  end;
  {$EXTERNALSYM _avimetaindex}
  AVIMETAINDEX = _avimetaindex;
  {$EXTERNALSYM AVIMETAINDEX}
  TAVIMetaIndex = _avimetaindex;


const
  STDINDEXSIZE = $4000;
  {$EXTERNALSYM STDINDEXSIZE}
{
#define NUMINDEX(wLongsPerEntry) ((STDINDEXSIZE-32)/4/(wLongsPerEntry))
#define NUMINDEXFILL(wLongsPerEntry) ((STDINDEXSIZE/4) - NUMINDEX(wLongsPerEntry))
}
// structure of a super index (INDEX_OF_INDEXES)
//
  ckidAVISUPERINDEX = $78646E69;//'indx'
  {$EXTERNALSYM ckidAVISUPERINDEX}

type
 _avisuperindex = record
   fcc: FOURCC;                      // 'indx'
   cb: UINT;                         // size of this structure
   wLongsPerEntry: WORD;             // ==4
   bIndexSubType: BYTE;              // ==0 (frame index) or AVI_INDEX_SUB_2FIELD
   bIndexType: BYTE;                 // ==AVI_INDEX_OF_INDEXES
   nEntriesInUse: DWORD;             // offset of next unused entry in aIndex
   dwChunkId: DWORD;                 // chunk ID of chunks being indexed, (i.e. RGB8)
   dwReserved: array[0..2] of DWORD; // must be 0

   aIndex: array[0..3] of record
     qwOffset: Int64;             // 64 bit offset to sub index chunk
     dwSize: DWORD;              // 32 bit size of sub index chunk
     dwDuration: DWORD;          // time span of subindex chunk (in stream ticks)
   end;
 end;
 {$EXTERNALSYM _avisuperindex}
 AVISUPERINDEX = _avisuperindex;
 {$EXTERNALSYM AVISUPERINDEX}
 TAVISuperIndex = _avisuperindex;

//#define Valid_SUPERINDEX(pi) (*(DWORD *)(&((pi)->wLongsPerEntry)) == (4 | (AVI_INDEX_OF_INDEXES << 24)))

// struct of a standard index (AVI_INDEX_OF_CHUNKS)
//

 _avistdindex_entry = record
   dwOffset: DWORD;      // 32 bit offset to data (points to data, not riff header)
   dwSize: DWORD;        // 31 bit size of data (does not include size of riff header), bit 31 is deltaframe bit
 end;
 {$EXTERNALSYM _avistdindex_entry}
 AVISTDINDEX_ENTRY = _avistdindex_entry;
 {$EXTERNALSYM AVISTDINDEX_ENTRY}
 TAVIStdIndexEntry = _avistdindex_entry;

const
  AVISTDINDEX_DELTAFRAME = $80000000; // Delta frames have the high bit set;
  {$EXTERNALSYM AVISTDINDEX_DELTAFRAME}
  AVISTDINDEX_SIZEMASK = not $80000000;
  {$EXTERNALSYM AVISTDINDEX_SIZEMASK}

type
  _avistdindex = record
    fcc: FOURCC;           // 'indx' or '##ix'
    cb: UINT;              // size of this structure
    wLongsPerEntry: WORD;  // ==2
    bIndexSubType: BYTE;   // ==0
    bIndexType: BYTE;      // ==AVI_INDEX_OF_CHUNKS
    nEntriesInUse: DWORD;  // offset of next unused entry in aIndex
    dwChunkId: DWORD;      // chunk ID of chunks being indexed, (i.e. RGB8)
    qwBaseOffset: Int64;    // base offset that all index intries are relative to
    dwReserved_3: DWORD;
    aIndex: array[0..2043] of TAVIStdIndexEntry;
  end;
  {$EXTERNALSYM _avistdindex}
  AVISTDINDEX = _avistdindex;
  {$EXTERNALSYM AVISTDINDEX}
  TAVIStdIndex = _avistdindex;

// struct of a time variant standard index (AVI_INDEX_OF_TIMED_CHUNKS)
//
  _avitimedindex_entry = record
    dwOffset: DWORD;     // 32 bit offset to data (points to data, not riff header)
    dwSize: DWORD;       // 31 bit size of data (does not include size of riff header) (high bit is deltaframe bit)
    dwDuration: DWORD;   // how much time the chunk should be played (in stream ticks)
  end;
  {$EXTERNALSYM _avitimedindex_entry}
  AVITIMEDINDEX_ENTRY = _avitimedindex_entry;
  {$EXTERNALSYM AVITIMEDINDEX_ENTRY}
  TAVITimedIndexEntry = _avitimedindex_entry;

  _avitimedindex = record
    fcc: FOURCC;           // 'indx' or '##ix'
    cb: UINT;              // size of this structure
    wLongsPerEntry: WORD;  // ==3
    bIndexSubType: BYTE;   // ==0
    bIndexType: BYTE;      // ==AVI_INDEX_OF_TIMED_CHUNKS
    nEntriesInUse: DWORD;  // offset of next unused entry in aIndex
    dwChunkId: DWORD;      // chunk ID of chunks being indexed, (i.e. RGB8)
    qwBaseOffset: Int64;    // base offset that all index intries are relative to
    dwReserved_3: DWORD;   // must be 0
    aIndex: array[0..1361] of TAVITimedIndexEntry;
    adwTrailingFill: array[0..2733] of DWORD; // to align struct to correct size
  end;
  {$EXTERNALSYM _avitimedindex}
  AVITIMEDINDEX = _avitimedindex;
  {$EXTERNALSYM AVITIMEDINDEX}
  TAVITimedIndex = _avitimedindex;

// structure of a timecode stream
//
  _avitimecodeindex = record
    fcc: FOURCC;                      // 'indx' or '##ix'
    cb: UINT;                         // size of this structure
    wLongsPerEntry: WORD;             // ==4
    bIndexSubType: BYTE;              // ==0
    bIndexType: BYTE;                 // ==AVI_INDEX_IS_DATA
    nEntriesInUse: DWORD;             // offset of next unused entry in aIndex
    dwChunkId: DWORD;                 // 'time'
    dwReserved: array[0..2] of DWORD; // must be 0
    aIndex: array[0..0] of TTimeCodeData;
  end;
  {$EXTERNALSYM _avitimecodeindex}
  AVITIMECODEINDEX = _avitimecodeindex;
  {$EXTERNALSYM AVITIMECODEINDEX}
  TAviTimeCodeIndex = _avitimecodeindex;

// structure of a timecode discontinuity list (when wLongsPerEntry == 7)
//
  _avitcdlindex_entry = record
    dwTick: DWORD;             // stream tick time that maps to this timecode value
    time: TTimeCode;
    dwSMPTEflags: DWORD;
    dwUser: DWORD;
    szReelId: array[0..11] of Char;
  end;
  {$EXTERNALSYM _avitcdlindex_entry}
  AVITCDLINDEX_ENTRY = _avitcdlindex_entry;
  {$EXTERNALSYM AVITCDLINDEX_ENTRY}
  TAVITcdlIndexEntry = _avitcdlindex_entry;

  _avitcdlindex = record
    fcc: FOURCC;                      // 'indx' or '##ix'
    cb: UINT;                         // size of this structure
    wLongsPerEntry: WORD;             // ==7 (must be 4 or more all 'tcdl' indexes
    bIndexSubType: BYTE;              // ==0
    bIndexType: BYTE;                 // ==AVI_INDEX_IS_DATA
    nEntriesInUse: DWORD;             // offset of next unused entry in aIndex
    dwChunkId: DWORD;                 // 'tcdl'
    dwReserved: array[0..2] of DWORD; // must be 0
    aIndex: array[0..583] of TAVITcdlIndexEntry;
    adwTrailingFill: array[0..3511] of DWORD;  // to align struct to correct size
  end;
  {$EXTERNALSYM _avitcdlindex}
  AVITCDLINDEX = _avitcdlindex;
  {$EXTERNALSYM AVITCDLINDEX}
  TAVITcdlIndex = _avitcdlindex;


  _avifieldindex_chunk = record
  {$EXTERNALSYM _avifieldindex_chunk}
    fcc: FOURCC;            // 'ix##'
    cb: DWORD;              // size of this structure
    wLongsPerEntry: WORD;   // must be 3 (size of each entry in
                            // aIndex array)
    bIndexSubType: BYTE;    // AVI_INDEX_2FIELD
    bIndexType: BYTE;       // AVI_INDEX_OF_CHUNKS
    nEntriesInUse: DWORD;   //
    dwChunkId: DWORD;       // '##dc' or '##db'
    qwBaseOffset: Int64;     // offsets in aIndex array are relative to this
    dwReserved3: DWORD;     // must be 0

    aIndex: array[0..0] of record
      dwOffset: DWORD;
      dwSize: DWORD;          // size of all fields
      dwOffsetField2: DWORD;  // (bit 31 set for NON-keyframes)
    end;                      // offset to second field
  end;
  AVIFIELDINDEX = _avifieldindex_chunk;
  {$EXTERNALSYM AVIFIELDINDEX}
  PAVIFIELDINDEX = ^AVIFIELDINDEX;
  {$EXTERNALSYM PAVIFIELDINDEX}
  TAVIFieldIndex = _avifieldindex_chunk;
  
(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       evcode.h
 *
 ***************************************************************************)

const
//
// list of standard Quartz event codes and the expected params
//

// Event codes are broken into two groups
//   -- system event codes
//   -- extension event codes
// All system event codes are below EC_USER

  EC_SYSTEMBASE                        = $00;
  {$EXTERNALSYM EC_SYSTEMBASE}
  EC_USER                              = $8000;
  {$EXTERNALSYM EC_USER}


// System-defined event codes
// ==========================
//
// There are three types of system-defined event codes:
//
// 1.  Those which are always passed through to the application
//     (To be collected by calls to GetEvent or within WaitForCompletion.)
//     (e.g. EC_ERRORABORT, EC_USERABORT.)
//
// 2.  Those which are pure internal and will never be passed to
//     the application.  (e.g. EC_SHUTDOWN)
//
// 3.  Those which have default handling.  Default handing implies that
//     the event is not passed to the application.  However, default
//     handling may be canceled by calling
//     IMediaEvent::CancelDefaultHandling.  If the default handling is
//     cancelled in this way, then the message will be delivered to the
//     application and the application must action it appropriately.
//     Default handling can be restored by calling RestoreDefaultHandling.
//
// We will refer to these events as application, internal and defaulted
// events respectively.
//
// System-defined events may have interface pointers, BSTR's, etc passed
// as parameters.  It is therefore essential that, for any message
// retrieved using GetEvent, a matching call to FreeEventParams is made
// to ensure that relevant interfaces are released and storage freed.
// Failure to call FreeEventParams will result in memory leaks, if not
// worse.
//
// Filters sending these messages to the filter graph should not AddRef()
// any interfaces that they may pass as parameters.  The filter graph
// manager will AddRef them if required.  E.g. if the event is to be queued
// for the application or queued to a worker thread.

// Each event listed below is immediately followed by a parameter list
// detailing the types of the parameters associated with the message,
// and an indication of whether the message is an application, internal
// or defaulted message.  This is then followed by a short description.
// The use of "void" in the parameter list implies that the parameter is not
// used.  Such parameters should be zero.

// Other defined EC_ regions:
// DVD event codes           0x0100 - 0x0150 (dvdevcod.h)
// audio device event codes  0x0200 - 0x0250 (audevcod.h)
// WindowsMedia SDK-originated events 0x0251 - 0x0300 (see below)
// MSVIDCTL                  0x0301 - 0x0325 (msvidctl.idl)
// stream buffer engine (PVR)   0x0326 - 0x0350 (sbe.idl)

  EC_COMPLETE                          = $01;
  {$EXTERNALSYM EC_COMPLETE}
// ( HResult, void ) : defaulted (special)
// Signals the completed playback of a stream within the graph.  This message
// is sent by renderers when they receive end-of-stream.  The default handling
// of this message results in a _SINGLE_ EC_COMPLETE being sent to the
// application when ALL of the individual renderers have signaled EC_COMPLETE
// to the filter graph.  If the default handing is canceled, the application
// will see all of the individual EC_COMPLETEs.


  EC_USERABORT                         = $02;
  {$EXTERNALSYM EC_USERABORT}
// ( void, void ) : application
// In some sense, the user has requested that playback be terminated.
// This message is typically sent by renderers that render into a
// window if the user closes the window into which it was rendering.
// It is up to the application to decide if playback should actually
// be stopped.


  EC_ERRORABORT                        = $03;
  {$EXTERNALSYM EC_ERRORABORT}
// ( HResult, void ) : application
// Operation aborted because of error


  EC_TIME                              = $04;
  {$EXTERNALSYM EC_TIME}
// ( DWORD, DWORD ) : application
// The requested reference time occurred.  (This event is currently not used).
// lParam1 is low dword of ref time, lParam2 is high dword of TRefTime.


  EC_REPAINT                           = $05;
  {$EXTERNALSYM EC_REPAINT}
// ( IPin * (could be NULL), void ) : defaulted
// A repaint is required - lParam1 contains the (IPin *) that needs the data
// to be sent again. Default handling is: if the output pin which the IPin is
// attached  to supports the IMediaEventSink interface then it will be called
// with the EC_REPAINT first.  If that fails then normal repaint processing is
// done by the filter graph.


// Stream error notifications
  EC_STREAM_ERROR_STOPPED              = $06;
  {$EXTERNALSYM EC_STREAM_ERROR_STOPPED}
  EC_STREAM_ERROR_STILLPLAYING         = $07;
  {$EXTERNALSYM EC_STREAM_ERROR_STILLPLAYING}
// ( HResult, DWORD ) : application
// lParam 1 is major code, lParam2 is minor code, either may be zero.


  EC_ERROR_STILLPLAYING                = $08;
  {$EXTERNALSYM EC_ERROR_STILLPLAYING}
// ( HResult, void ) : application
// The filter graph manager may issue Run's to the graph asynchronously.
// If such a Run fails, EC_ERROR_STILLPLAYING is issued to notify the
// application of the failure.  The state of the underlying filters
// at such a time will be indeterminate - they will all have been asked
// to run, but some are almost certainly not.


  EC_PALETTE_CHANGED                   = $09;
  {$EXTERNALSYM EC_PALETTE_CHANGED}
// ( void, void ) : application
// notify application that the video palette has changed


  EC_VIDEO_SIZE_CHANGED                = $0A;
  {$EXTERNALSYM EC_VIDEO_SIZE_CHANGED}
// ( DWORD, void ) : application
// Sent by video renderers.
// Notifies the application that the native video size has changed.
// LOWORD of the DWORD is the new width, HIWORD is the new height.


  EC_QUALITY_CHANGE                    = $0B;
  {$EXTERNALSYM EC_QUALITY_CHANGE}
// ( void, void ) : application
// Notify application that playback degradation has occurred


  EC_SHUTTING_DOWN                     = $0C;
  {$EXTERNALSYM EC_SHUTTING_DOWN}
// ( void, void ) : internal
// This message is sent by the filter graph manager to any plug-in
// distributors which support IMediaEventSink to notify them that
// the filter graph is starting to shutdown.


  EC_CLOCK_CHANGED                     = $0D;
  {$EXTERNALSYM EC_CLOCK_CHANGED}
// ( void, void ) : application
// Notify application that the clock has changed.
// (i.e. SetSyncSource has been called on the filter graph and has been
// distributed successfully to the filters in the graph.)

  EC_PAUSED                            = $0E;
  {$EXTERNALSYM EC_PAUSED}
// ( HResult, void ) : application
// Notify application the previous pause request has completed

  EC_OPENING_FILE                            = $10;
  {$EXTERNALSYM EC_OPENING_FILE}
  EC_BUFFERING_DATA                    = $11;
  {$EXTERNALSYM EC_BUFFERING_DATA}
// ( BOOL, void ) : application
// lParam1 == 1   --> starting to open file or buffer data
// lParam1 == 0   --> not opening or buffering any more
// (This event does not appear to be used by ActiveMovie.)


  EC_FULLSCREEN_LOST                   = $12;
  {$EXTERNALSYM EC_FULLSCREEN_LOST}
// ( void, IBaseFilter * ) : application
// Sent by full screen renderers when switched away from full screen.
// IBaseFilter may be NULL.


  EC_ACTIVATE                          = $13;
  {$EXTERNALSYM EC_ACTIVATE}
// ( BOOL, IBaseFilter * ) : internal
// Sent by video renderers when they lose or gain activation.
// lParam1 is set to 1 if gained or 0 if lost
// lParam2 is the IBaseFilter* for the filter that is sending the message
// Used for sound follows focus and full-screen switching


  EC_NEED_RESTART                      = $14;
  {$EXTERNALSYM EC_NEED_RESTART}
// ( void, void ) : defaulted
// Sent by renderers when they regain a resource (e.g. audio renderer).
// Causes a restart by Pause/put_Current/Run (if running).


  EC_WINDOW_DESTROYED                  = $15;
  {$EXTERNALSYM EC_WINDOW_DESTROYED}
// ( IBaseFilter *, void ) : internal
// Sent by video renderers when the window has been destroyed. Handled
// by the filter graph / distributor telling the resource manager.
// lParam1 is the IBaseFilter* of the filter whose window is being destroyed


  EC_DISPLAY_CHANGED                   = $16;
  {$EXTERNALSYM EC_DISPLAY_CHANGED}
// ( IPin *, void ) : internal
// Sent by renderers when they detect a display change. the filter graph
// will arrange for the graph to be stopped and the pin send in lParam1
// to be reconnected. by being reconnected it allows a renderer to reset
// and connect with a more appropriate format for the new display mode
// lParam1 contains an (IPin *) that should be reconnected by the graph


  EC_STARVATION                        = $17;
  {$EXTERNALSYM EC_STARVATION}
// ( void, void ) : defaulted
// Sent by a filter when it detects starvation. Default handling (only when
// running) is for the graph to be paused until all filters enter the
// paused state and then run. Normally this would be sent by a parser or source
// filter when too little data is arriving.


  EC_OLE_EVENT                       = $18;
  {$EXTERNALSYM EC_OLE_EVENT}
// ( BSTR, BSTR ) : application
// Sent by a filter to pass a text string to the application.
// Conventionally, the first string is a type, and the second a parameter.


  EC_NOTIFY_WINDOW                     = $19;
  {$EXTERNALSYM EC_NOTIFY_WINDOW}
// ( HWND, void ) : internal
// Pass the window handle around during pin connection.

  EC_STREAM_CONTROL_STOPPED          = $1A;
  {$EXTERNALSYM EC_STREAM_CONTROL_STOPPED}
// ( IPin * pSender, DWORD dwCookie )
// Notification that an earlier call to IAMStreamControl::StopAt
// has now take effect.  Calls to the method can be marked
// with a cookie which is passed back in the second parameter,
// allowing applications to easily tie together request
// and completion notifications.
//
// NB: IPin will point to the pin that actioned the Stop.  This
// may not be the pin that the StopAt was sent to.

  EC_STREAM_CONTROL_STARTED          = $1B;
  {$EXTERNALSYM EC_STREAM_CONTROL_STARTED}
// ( IPin * pSender, DWORD dwCookie )
// Notification that an earlier call to IAMStreamControl::StartAt
// has now take effect.  Calls to the method can be marked
// with a cookie which is passed back in the second parameter,
// allowing applications to easily tie together request
// and completion notifications.
//
// NB: IPin will point to the pin that actioned the Start.  This
// may not be the pin that the StartAt was sent to.

  EC_END_OF_SEGMENT                    = $1C;
  {$EXTERNALSYM EC_END_OF_SEGMENT}
//
// ( const REFERENCE_TIME *pStreamTimeAtEndOfSegment, DWORD dwSegmentNumber )
//
// pStreamTimeAtEndOfSegment
//     pointer to the accumulated stream clock
//     time since the start of the segment - this is directly computable
//     as the sum of the previous and current segment durations (Stop - Start)
//     and the rate applied to each segment
//     The source add this time to the time within each segment to get
//     a total elapsed time
//
// dwSegmentNumber
//     Segment number - starts at 0
//
// Notifies that a segment end has been reached when the
// AM_SEEKING_Segment flags was set for IMediaSeeking::SetPositions
// Passes in an IMediaSeeking interface to allow the next segment
// to be defined by the application

  EC_SEGMENT_STARTED                   = $1D;
  {$EXTERNALSYM EC_SEGMENT_STARTED}
//
// ( const REFERENCE_TIME *pStreamTimeAtStartOfSegment, DWORD dwSegmentNumber)
//
// pStreamTimeAtStartOfSegment
//     pointer to the accumulated stream clock
//     time since the start of the segment - this is directly computable
//     as the sum of the previous segment durations (Stop - Start)
//     and the rate applied to each segment
//
// dwSegmentNumber
//     Segment number - starts at 0
//
// Notifies that a new segment has been started.
// This is sent synchronously by any entity that will issue
// EC_END_OF_SEGMENT when a new segment is started
// (See IMediaSeeking::SetPositions - AM_SEEKING_Segment flag)
// It is used to compute how many EC_END_OF_SEGMENT notifications
// to expect at the end of a segment and as a consitency check

  EC_LENGTH_CHANGED                   = $1E;
  {$EXTERNALSYM EC_LENGTH_CHANGED}
// (void, void)
// sent to indicate that the length of the "file" has changed

  EC_DEVICE_LOST                      = $1f;
  {$EXTERNALSYM EC_DEVICE_LOST}
// (IUnknown, 0)
//
// request window notification when the device is available again
// (through WM_DEVICECHANGED messages registered with
// RegisterDeviceNotification; see IAMDeviceRemoval interface)

  EC_STEP_COMPLETE                    = $24;
  {$EXTERNALSYM EC_STEP_COMPLETE}
// (BOOL bCacelled, void)
// Step request complete
// if bCancelled is TRUE the step was cancelled.  This can happen
// if the application issued some control request or because there
// was a mode change etc etc


//  EC_SKIP_FRAMES                      = $25;
// ( nFramesToSkip, void ) : internal
// Get the filter graph to seek accuratley.
// Event code 25 is reserved for future use. (dx8.1 specific)

  EC_TIMECODE_AVAILABLE		      =	$30;
  {$EXTERNALSYM EC_TIMECODE_AVAILABLE}
// Sent by filter supporting timecode
// Param1 has a pointer to the sending object
// Param2 has the device ID of the sending object

  EC_EXTDEVICE_MODE_CHANGE	      =	$31;
  {$EXTERNALSYM EC_EXTDEVICE_MODE_CHANGE}
// Sent by filter supporting IAMExtDevice
// Param1 has the new mode
// Param2 has the device ID of the sending object


  EC_STATE_CHANGE                   = $32;
  {$EXTERNALSYM EC_STATE_CHANGE}
// ( FILTER_STATE, BOOL bInternal)
// Used to notify the application of any state changes in the filter graph.
// lParam1  is of type enum FILTER_STATE (defined in strmif.h) and indicates
//          the state of the filter graph.
//
// lParam2 == 0 indicates that the previous state change request has completed
//              & a change in application state.
// lParam2 == 1 reserved for future use to indicate internal state changes.

  EC_GRAPH_CHANGED                    = $50;
  {$EXTERNALSYM EC_GRAPH_CHANGED}
// Sent by filter to notify interesting graph changes

  EC_CLOCK_UNSET                      = $51;
  {$EXTERNALSYM EC_CLOCK_UNSET}
// ( void, void ) : application
// Used to notify the filter graph to unset the current graph clock.
// Has the affect of forcing the filter graph to reestablish the graph clock
// on the next Pause/Run (note that this is only used by ksproxy, when the pin
// of a clock providing filter is disconnected)

  EC_VMR_RENDERDEVICE_SET               = $53;
  {$EXTERNALSYM EC_VMR_RENDERDEVICE_SET}
// (Render_Device type, void)
// Identifies the type of rendering mechanism the VMR
// is using to display video.  Types used include:
  VMR_RENDER_DEVICE_OVERLAY      = $01;
  {$EXTERNALSYM VMR_RENDER_DEVICE_OVERLAY}
  VMR_RENDER_DEVICE_VIDMEM       = $02;
  {$EXTERNALSYM VMR_RENDER_DEVICE_VIDMEM}
  VMR_RENDER_DEVICE_SYSMEM       = $04;
  {$EXTERNALSYM VMR_RENDER_DEVICE_SYSMEM}


  EC_VMR_SURFACE_FLIPPED         = $54;
  {$EXTERNALSYM EC_VMR_SURFACE_FLIPPED}
// (hr - Flip return code, void)
// Identifies the VMR's allocator-presenter has called the DDraw flip api on
// the surface being presented.   This allows the VMR to keep its DX-VA table
// of DDraw surfaces in sync with DDraws flipping chain.

  EC_VMR_RECONNECTION_FAILED     = $55;
  {$EXTERNALSYM EC_VMR_RECONNECTION_FAILED}
// (hr - ReceiveConnection return code, void)
// Identifies that an upstream decoder tried to perform a dynamic format
// change and the VMR was unable to accept the new format.

  EC_PREPROCESS_COMPLETE         = $56;
  {$EXTERNALSYM EC_PREPROCESS_COMPLETE}
// Sent by the WM ASF writer filter (WMSDK V9 version) to signal the completion
// of a pre-process run when running in multipass encode mode.
// Param1 = 0, Param2 = IBaseFilter ptr of sending filter

  EC_CODECAPI_EVENT              = $57;
  {$EXTERNALSYM EC_CODECAPI_EVENT}
// Sent by the Codec API when an event is encountered.  Both the Data
// must be freed by the recipient using CoTaskMemFree
// Param1 = UserDataPointer, Param2 = VOID* Data




//------------------------------------------
//
//  BDA events:
//
//      Event code 0x80 through 0x8f are reserved for BDA
//


//------------------------------------------
//
// WindowsMedia SDK filter-specific events:
//
// 
// Note that for EC_WMT_EVENT events the wmsdk-based filters use the following structure for 
// passing event parameters to the app:

type
  PAMWMTEventData = ^TAMWMTEventData;
  AM_WMT_EVENT_DATA = record
    hrStatus : HResult; // status code
    pData    : pointer; // event data
  end;
  {$EXTERNALSYM AM_WMT_EVENT_DATA}
  TAMWMTEventData = AM_WMT_EVENT_DATA;
  
const

  EC_WMT_EVENT_BASE  = $0251;
  {$EXTERNALSYM EC_WMT_EVENT_BASE}
//
  EC_WMT_INDEX_EVENT = EC_WMT_EVENT_BASE;
  {$EXTERNALSYM EC_WMT_INDEX_EVENT}
// WindowsMedia SDK-originated file indexing status, sent by WMSDK-based filters
//
// lParam1 is one of the enum WMT_STATUS messages listed below, sent by the WindowsMedia SDK
// lParam2 is specific to the lParam event
//
//     the following WMT_STATUS messages are sent for this event:
//         WMT_STARTED        - lParam2 is 0
//         WMT_CLOSED         - lParam2 is 0
//         WMT_INDEX_PROGRESS - lParam2 is a DWORD containing the progress percent complete
//

  EC_WMT_EVENT                     =   EC_WMT_EVENT_BASE+1;
  {$EXTERNALSYM EC_WMT_EVENT}
// WindowsMedia SDK-originated event, sent by WMSDK-based filters
//
// lParam1 is one of the enum WMT_STATUS messages listed below, sent by the WindowsMedia SDK
// lParam2 is a pointer an AM_WMT_EVENT_DATA structure where,
//                          hrStatus is the status code sent by the wmsdk
//                          pData is specific to the lParam1 event
//
//     the following WMT_STATUS messages are sent by the WMSDK Reader filter for this event:
//         WMT_NO_RIGHTS        - pData is a pointer to a WCHAR string containing a challenge URL
//         WMT_ACQUIRE_LICENSE  - lParam2 is a pointer to a WM_GET_LICENSE_DATA struct
//         WMT_NO_RIGHTS_EX     - lParam2 is a pointer to a WM_GET_LICENSE_DATA struct
//         WMT_NEEDS_INDIVIDUALIZATION - lParam2 is NULL
//         WMT_INDIVIDUALIZE    - lParam2 is a pointer to a WM_INDIVIDUALIZE_STATUS struct
//     the WMSDK (V9) ASF Writer filter will send this event in response to a wmsdk-signaled error during file
//         writing, along with the wmsdk WMT_STATUS error as the lParam1 and hrStatus embedded in the 
//         AM_WMT_EVENT_DATA struct pointed to by the lParam2 pointer.
//
// end WMSDK-originated events
//-----------------------------------------

  EC_BUILT                          = $300;
  {$EXTERNALSYM EC_BUILT}
  // Sent to notify transition from unbuilt to built state

  EC_UNBUILT                        = $301;
  {$EXTERNALSYM EC_UNBUILT}
  // Sent to notify transtion from built to unbuilt state

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       uuids.h
 *
 ***************************************************************************)

const

// -- to allow consistent labeling of Media types and subtypes --
  // ?? GUID_NULL ??
  GUID_NULL: TGUID = (D1:$00000000;D2:$0000;D3:$0000;D4:($00,$00,$00,$00,$00,$00,$00,$00));
  MEDIATYPE_NULL: TGUID = (D1:$00000000;D2:$0000;D3:$0000;D4:($00,$00,$00,$00,$00,$00,$00,$00));
  MEDIASUBTYPE_NULL: TGUID = (D1:$00000000;D2:$0000;D3:$0000;D4:($00,$00,$00,$00,$00,$00,$00,$00));

// -- Use this subtype if you don't have a use for a subtype for your type
  MEDIASUBTYPE_None: TGUID = (D1:$E436EB8E;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_None}

// -- major types ---
  MEDIATYPE_Video: TGUID = (D1:$73646976;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIATYPE_Video}
  MEDIATYPE_Audio: TGUID = (D1:$73647561;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIATYPE_Audio}
  MEDIATYPE_Text: TGUID = (D1:$73747874;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIATYPE_Text}
  MEDIATYPE_Midi: TGUID = (D1:$7364696D;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIATYPE_Midi}
  MEDIATYPE_Stream: TGUID = (D1:$E436EB83;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIATYPE_Stream}
  MEDIATYPE_Interleaved: TGUID = (D1:$73766169;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIATYPE_Interleaved}
  MEDIATYPE_File: TGUID = (D1:$656C6966;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIATYPE_File}
  MEDIATYPE_ScriptCommand: TGUID = (D1:$73636D64;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIATYPE_ScriptCommand}
  MEDIATYPE_AUXLine21Data: TGUID = (D1:$670AEA80;D2:$3A82;D3:$11D0;D4:($B7,$9B,$00,$AA,$00,$37,$67,$A7));
  {$EXTERNALSYM MEDIATYPE_AUXLine21Data}
  MEDIATYPE_VBI : TGUID = '{F72A76E1-EB0A-11D0-ACE4-0000C0CC16BA}';
  {$EXTERNALSYM MEDIATYPE_VBI}
  MEDIATYPE_Timecode: TGUID = (D1:$0482DEE3;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIATYPE_Timecode}
  MEDIATYPE_LMRT : TGUID = (D1:$74726c6d;D2:$0000;D3:$0010;D4:($80,$00,$00,$aa,$00,$38,$9b,$71));
  {$EXTERNALSYM MEDIATYPE_LMRT}
  MEDIATYPE_URL_STREAM: TGUID = (D1:$736c7275;D2:$0000;D3:$0010;D4:($80,$00,$00,$aa,$00,$38,$9b,$71));
  {$EXTERNALSYM MEDIATYPE_URL_STREAM}

// -- sub types ---
  MEDIASUBTYPE_CLPL: TGUID = (D1:$4C504C43;D2:$0000;D3:$0010;D4:($80,$00,$00,$aa,$00,$38,$9b,$71));
  {$EXTERNALSYM MEDIASUBTYPE_CLPL}
  MEDIASUBTYPE_YUYV: TGUID = (D1:$56595559;D2:$0000;D3:$0010;D4:($80,$00,$00,$aa,$00,$38,$9b,$71));
  {$EXTERNALSYM MEDIASUBTYPE_YUYV}
  MEDIASUBTYPE_IYUV: TGUID = (D1:$56555949;D2:$0000;D3:$0010;D4:($80,$00,$00,$aa,$00,$38,$9b,$71));
  {$EXTERNALSYM MEDIASUBTYPE_IYUV}
  MEDIASUBTYPE_YVU9: TGUID = (D1:$39555659;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_YVU9}
  MEDIASUBTYPE_Y411: TGUID = (D1:$31313459;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_Y411}
  MEDIASUBTYPE_Y41P: TGUID = (D1:$50313459;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_Y41P}
  MEDIASUBTYPE_YUY2: TGUID = (D1:$32595559;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_YUY2}
  MEDIASUBTYPE_YVYU: TGUID = (D1:$55595659;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_YVYU}
  MEDIASUBTYPE_UYVY: TGUID = (D1:$59565955;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_UYVY}
  MEDIASUBTYPE_Y211: TGUID = (D1:$31313259;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_Y211}
  MEDIASUBTYPE_CLJR: TGUID = (D1:$524A4C43;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_CLJR}
  MEDIASUBTYPE_IF09: TGUID = (D1:$39304649;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_IF09}
  MEDIASUBTYPE_CPLA: TGUID = (D1:$414C5043;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_CPLA}
  MEDIASUBTYPE_MJPG: TGUID = (D1:$47504A4D;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_MJPG}
  MEDIASUBTYPE_TVMJ: TGUID = (D1:$4A4D5654;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_TVMJ}
  MEDIASUBTYPE_WAKE: TGUID = (D1:$454B4157;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_WAKE}
  MEDIASUBTYPE_CFCC: TGUID = (D1:$43434643;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_CFCC}
  MEDIASUBTYPE_IJPG: TGUID = (D1:$47504A49;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_IJPG}
  MEDIASUBTYPE_Plum: TGUID = (D1:$6D756C50;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_Plum}
  MEDIASUBTYPE_DVCS: TGUID = (D1:$53435644;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_DVCS}
  MEDIASUBTYPE_DVSD: TGUID = (D1:$44535644;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_DVSD}
  MEDIASUBTYPE_MDVF: TGUID = (D1:$4656444D;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_MDVF}
  MEDIASUBTYPE_RGB1: TGUID = (D1:$E436EB78;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_RGB1}
  MEDIASUBTYPE_RGB4: TGUID = (D1:$E436EB79;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_RGB4}
  MEDIASUBTYPE_RGB8: TGUID = (D1:$E436EB7A;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_RGB8}
  MEDIASUBTYPE_RGB565: TGUID = (D1:$E436EB7B;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_RGB565}
  MEDIASUBTYPE_RGB555: TGUID = (D1:$E436EB7C;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_RGB555}
  MEDIASUBTYPE_RGB24: TGUID = (D1:$E436EB7D;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_RGB24}
  MEDIASUBTYPE_RGB32:  TGUID = (D1:$E436EB7E;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_RGB32}
  MEDIASUBTYPE_ARGB1555 : TGUID = '{297C55AF-E209-4cb3-B757-C76D6B9C88A8}';
  {$EXTERNALSYM MEDIASUBTYPE_ARGB1555}
  MEDIASUBTYPE_ARGB4444 : TGUID = '{6E6415E6-5C24-425f-93CD-80102B3D1CCA}';
  {$EXTERNALSYM MEDIASUBTYPE_ARGB4444}
  MEDIASUBTYPE_ARGB32   : TGUID = (D1:$773c9ac0;D2:$3274;D3:$11d0;D4:($b7,$24,$00,$aa,$00,$6c,$1a,$1 ));
  {$EXTERNALSYM MEDIASUBTYPE_ARGB32}

  MEDIASUBTYPE_A2R10G10B10 : TGUID = '{2f8bb76d-b644-4550-acf3-d30caa65d5c5}';
  {$EXTERNALSYM MEDIASUBTYPE_A2R10G10B10}
  MEDIASUBTYPE_A2B10G10R10 : TGUID = '{576f7893-bdf6-48c4-875f-ae7b81834567}';
  {$EXTERNALSYM MEDIASUBTYPE_A2B10G10R10}

  MEDIASUBTYPE_AYUV     : TGUID = '{56555941-0000-0010-8000-00AA00389B71}'; //'AYUV' == MEDIASUBTYPE_AYUV
  {$EXTERNALSYM MEDIASUBTYPE_AYUV}
  MEDIASUBTYPE_AI44     : TGUID = '{34344941-0000-0010-8000-00AA00389B71}'; //'AI44' == MEDIASUBTYPE_AI44
  {$EXTERNALSYM MEDIASUBTYPE_AI44}
  MEDIASUBTYPE_IA44     : TGUID = '{34344149-0000-0010-8000-00AA00389B71}'; //'IA44' == MEDIASUBTYPE_IA44
  {$EXTERNALSYM MEDIASUBTYPE_IA44}

{$IFDEF ENABLEVMR7}
//
// DirectX7 D3D Render Target media subtypes.
//
  MEDIASUBTYPE_RGB32_D3D_DX7_RT    : TGUID = '{32335237-0000-0010-8000-00AA00389B71}'; //'7R32' == MEDIASUBTYPE_RGB32_D3D_DX7_RT
  {$EXTERNALSYM MEDIASUBTYPE_RGB32_D3D_DX7_RT}
  MEDIASUBTYPE_RGB16_D3D_DX7_RT    : TGUID = '{36315237-0000-0010-8000-00AA00389B71}'; //'7R16' == MEDIASUBTYPE_RGB16_D3D_DX7_RT
  {$EXTERNALSYM MEDIASUBTYPE_RGB16_D3D_DX7_RT}
  MEDIASUBTYPE_ARGB32_D3D_DX7_RT   : TGUID = '{38384137-0000-0010-8000-00AA00389B71}'; //'7A88' == MEDIASUBTYPE_ARGB32_D3D_DX7_RT
  {$EXTERNALSYM MEDIASUBTYPE_ARGB32_D3D_DX7_RT}
  MEDIASUBTYPE_ARGB4444_D3D_DX7_RT : TGUID = '{34344137-0000-0010-8000-00AA00389B71}'; //'7A44' == MEDIASUBTYPE_ARGB4444_D3D_DX7_RT
  {$EXTERNALSYM MEDIASUBTYPE_ARGB4444_D3D_DX7_RT}
  MEDIASUBTYPE_ARGB1555_D3D_DX7_RT : TGUID = '{35314137-0000-0010-8000-00AA00389B71}'; //'7A15' == MEDIASUBTYPE_ARGB1555_D3D_DX7_RT
  {$EXTERNALSYM MEDIASUBTYPE_ARGB1555_D3D_DX7_RT}
{$ENDIF}
//
// DirectX9 D3D Render Target media subtypes.
//

  MEDIASUBTYPE_RGB32_D3D_DX9_RT    : TGUID = '{32335239-0000-0010-8000-00AA00389B71}'; // 9R32
  {$EXTERNALSYM MEDIASUBTYPE_RGB32_D3D_DX9_RT}
  MEDIASUBTYPE_RGB16_D3D_DX9_RT    : TGUID = '{36315239-0000-0010-8000-00AA00389B71}'; // 9R16
  {$EXTERNALSYM MEDIASUBTYPE_RGB16_D3D_DX9_RT}
  MEDIASUBTYPE_ARGB32_D3D_DX9_RT   : TGUID = '{38384139-0000-0010-8000-00AA00389B71}'; // 9A88
  {$EXTERNALSYM MEDIASUBTYPE_ARGB32_D3D_DX9_RT}
  MEDIASUBTYPE_ARGB4444_D3D_DX9_RT : TGUID = '{34344139-0000-0010-8000-00AA00389B71}'; // 9A44
  {$EXTERNALSYM MEDIASUBTYPE_ARGB4444_D3D_DX9_RT}
  MEDIASUBTYPE_ARGB1555_D3D_DX9_RT : TGUID = '{35314139-0000-0010-8000-00AA00389B71}'; // 9A15
  {$EXTERNALSYM MEDIASUBTYPE_ARGB1555_D3D_DX9_RT}


{
#define MEDIASUBTYPE_HASALPHA(mt) ( ((mt).subtype == MEDIASUBTYPE_ARGB4444)            || \
                                    ((mt).subtype == MEDIASUBTYPE_ARGB32)              || \
                                    ((mt).subtype == MEDIASUBTYPE_AYUV)                || \
                                    ((mt).subtype == MEDIASUBTYPE_AI44)                || \
                                    ((mt).subtype == MEDIASUBTYPE_IA44)                || \
                                    ((mt).subtype == MEDIASUBTYPE_ARGB1555)            || \
                                    ((mt).subtype == MEDIASUBTYPE_ARGB32_D3D_DX7_RT)   || \
                                    ((mt).subtype == MEDIASUBTYPE_ARGB4444_D3D_DX7_RT) || \
                                    ((mt).subtype == MEDIASUBTYPE_ARGB1555_D3D_DX7_RT) || \
                                    ((mt).subtype == MEDIASUBTYPE_ARGB32_D3D_DX9_RT)   || \
                                    ((mt).subtype == MEDIASUBTYPE_ARGB4444_D3D_DX9_RT) || \
                                    ((mt).subtype == MEDIASUBTYPE_ARGB1555_D3D_DX9_RT) )

#define MEDIASUBTYPE_HASALPHA7(mt) (((mt).subtype == MEDIASUBTYPE_ARGB32_D3D_DX7_RT)   || \
                                    ((mt).subtype == MEDIASUBTYPE_ARGB4444_D3D_DX7_RT) || \
                                    ((mt).subtype == MEDIASUBTYPE_ARGB1555_D3D_DX7_RT) )

#define MEDIASUBTYPE_D3D_DX7_RT(mt) (((mt).subtype == MEDIASUBTYPE_ARGB32_D3D_DX7_RT)   || \
                                     ((mt).subtype == MEDIASUBTYPE_ARGB4444_D3D_DX7_RT) || \
                                     ((mt).subtype == MEDIASUBTYPE_ARGB1555_D3D_DX7_RT) || \
                                     ((mt).subtype == MEDIASUBTYPE_RGB32_D3D_DX7_RT)    || \
                                     ((mt).subtype == MEDIASUBTYPE_RGB16_D3D_DX7_RT))

#define MEDIASUBTYPE_HASALPHA9(mt) (((mt).subtype == MEDIASUBTYPE_ARGB32_D3D_DX9_RT)   || \
                                    ((mt).subtype == MEDIASUBTYPE_ARGB4444_D3D_DX9_RT) || \
                                    ((mt).subtype == MEDIASUBTYPE_ARGB1555_D3D_DX9_RT) )


#define MEDIASUBTYPE_D3D_DX9_RT(mt) (((mt).subtype == MEDIASUBTYPE_ARGB32_D3D_DX9_RT)   || \
                                     ((mt).subtype == MEDIASUBTYPE_ARGB4444_D3D_DX9_RT) || \
                                     ((mt).subtype == MEDIASUBTYPE_ARGB1555_D3D_DX9_RT) || \
                                     ((mt).subtype == MEDIASUBTYPE_RGB32_D3D_DX9_RT)    || \
                                     ((mt).subtype == MEDIASUBTYPE_RGB16_D3D_DX9_RT))
}

// DX-VA uncompressed surface formats

  MEDIASUBTYPE_YV12 : TGUID = '{32315659-0000-0010-8000-00AA00389B71}'; // YV12
  {$EXTERNALSYM MEDIASUBTYPE_YV12}
  MEDIASUBTYPE_NV12 : TGUID = '{3231564E-0000-0010-8000-00AA00389B71}'; // NV12
  {$EXTERNALSYM MEDIASUBTYPE_NV12}
  MEDIASUBTYPE_IMC1 : TGUID = '{31434D49-0000-0010-8000-00AA00389B71}'; // IMC1
  {$EXTERNALSYM MEDIASUBTYPE_IMC1}
  MEDIASUBTYPE_IMC2 : TGUID = '{32434d49-0000-0010-8000-00AA00389B71}'; // IMC2
  {$EXTERNALSYM MEDIASUBTYPE_IMC2}
  MEDIASUBTYPE_IMC3 : TGUID = '{33434d49-0000-0010-8000-00AA00389B71}'; // IMC3
  {$EXTERNALSYM MEDIASUBTYPE_IMC3}
  MEDIASUBTYPE_IMC4 : TGUID = '{34434d49-0000-0010-8000-00AA00389B71}'; // IMC4
  {$EXTERNALSYM MEDIASUBTYPE_IMC4}
  MEDIASUBTYPE_S340 : TGUID = '{30343353-0000-0010-8000-00AA00389B71}'; // S340
  {$EXTERNALSYM MEDIASUBTYPE_S340}
  MEDIASUBTYPE_S342 : TGUID = '{32343353-0000-0010-8000-00AA00389B71}'; // S342
  {$EXTERNALSYM MEDIASUBTYPE_S342}


  MEDIASUBTYPE_Overlay: TGUID = (D1:$E436EB7F;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_Overlay}
  MEDIASUBTYPE_MPEG1Packet: TGUID = (D1:$E436EB80;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_MPEG1Packet}
  MEDIASUBTYPE_MPEG1Payload: TGUID = (D1:$E436EB81;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_MPEG1Payload}
  MEDIASUBTYPE_MPEG1AudioPayload: TGUID = (D1:$00000050;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_MPEG1AudioPayload}
  MEDIATYPE_MPEG1SystemStream: TGUID = (D1:$E436EB82;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIATYPE_MPEG1SystemStream}
  MEDIASUBTYPE_MPEG1System: TGUID = (D1:$E436EB84;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_MPEG1System}
  MEDIASUBTYPE_MPEG1VideoCD: TGUID = (D1:$E436EB85;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_MPEG1VideoCD}
  MEDIASUBTYPE_MPEG1Video: TGUID = (D1:$E436EB86;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_MPEG1Video}
  MEDIASUBTYPE_MPEG1Audio: TGUID = (D1:$E436EB87;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_MPEG1Audio}
  MEDIASUBTYPE_Avi: TGUID = (D1:$E436EB88;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_Avi}
  MEDIASUBTYPE_Asf: TGUID = (D1:$3db80f90;D2:$9412;D3:$11d1;D4:($ad,$ed,$00,$00,$f8,$75,$4b,$99));
  {$EXTERNALSYM MEDIASUBTYPE_Asf}
  MEDIASUBTYPE_QTMovie: TGUID = (D1:$E436EB89;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_QTMovie}
  MEDIASUBTYPE_QTRpza: TGUID = (D1:$617A7072;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_QTRpza}
  MEDIASUBTYPE_QTSmc: TGUID = (D1:$20636D73;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_QTSmc}
  MEDIASUBTYPE_QTRle: TGUID = (D1:$20656C72;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_QTRle}
  MEDIASUBTYPE_QTJpeg: TGUID = (D1:$6765706A;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_QTJpeg}
  MEDIASUBTYPE_PCMAudio_Obsolete: TGUID = (D1:$E436EB8A;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_PCMAudio_Obsolete}
  MEDIASUBTYPE_PCM: TGUID = (D1:$00000001;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_PCM}
  MEDIASUBTYPE_WAVE: TGUID = (D1:$E436EB8B;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_WAVE}
  MEDIASUBTYPE_AU: TGUID = (D1:$E436EB8C;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_AU}
  MEDIASUBTYPE_AIFF: TGUID = (D1:$E436EB8D;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM MEDIASUBTYPE_AIFF}
  MEDIASUBTYPE_dvsd_: TGUID = (D1:$64737664;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_dvsd_}
  MEDIASUBTYPE_dvhd: TGUID = (D1:$64687664;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_dvhd}
  MEDIASUBTYPE_dvsl : TGUID = (D1:$6C737664;D2:$0000;D3:$0010;D4:($80,$00,$00,$AA,$00,$38,$9B,$71));
  {$EXTERNALSYM MEDIASUBTYPE_dvsl}

  MEDIASUBTYPE_dv25 : TGUID = '{35327664-0000-0010-8000-00aa00389b71}';
  {$EXTERNALSYM MEDIASUBTYPE_dv25}
  MEDIASUBTYPE_dv50 : TGUID = '{30357664-0000-0010-8000-00aa00389b71}';
  {$EXTERNALSYM MEDIASUBTYPE_dv50}
  MEDIASUBTYPE_dvh1 : TGUID = '{31687664-0000-0010-8000-00aa00389b71}';
  {$EXTERNALSYM MEDIASUBTYPE_dvh1}

  MEDIASUBTYPE_Line21_BytePair: TGUID = (D1:$6E8D4A22;D2:$310C;D3:$11D0;D4:($B7,$9A,$00,$AA,$00,$37,$67,$A7));
  {$EXTERNALSYM MEDIASUBTYPE_Line21_BytePair}
  MEDIASUBTYPE_Line21_GOPPacket: TGUID = (D1:$6E8D4A23;D2:$310C;D3:$11D0;D4:($B7,$9A,$00,$AA,$00,$37,$67,$A7));
  {$EXTERNALSYM MEDIASUBTYPE_Line21_GOPPacket}
  MEDIASUBTYPE_Line21_VBIRawData: TGUID = (D1:$6E8D4A24;D2:$310C;D3:$11D0;D4:($B7,$9A,$00,$AA,$00,$37,$67,$A7));
  {$EXTERNALSYM MEDIASUBTYPE_Line21_VBIRawData}
  MEDIASUBTYPE_TELETEXT : TGUID = '{F72A76E3-EB0A-11D0-ACE4-0000C0CC16BA}'; // MEDIASUBTYPE_TELETEXT
  {$EXTERNALSYM MEDIASUBTYPE_TELETEXT}
  MEDIASUBTYPE_WSS : TGUID = '{2791D576-8E7A-466F-9E90-5D3F3083738B}';
  {$EXTERNALSYM MEDIASUBTYPE_WSS}
  MEDIASUBTYPE_VPS : TGUID = '{A1B3F620-9792-4d8d-81A4-86AF25772090}';
  {$EXTERNALSYM MEDIASUBTYPE_VPS}
  MEDIASUBTYPE_DRM_Audio: TGUID = (D1:$00000009;D2:$0000;D3:$0010;D4:($80,$00,$00,$aa,$00,$38,$9b,$71));
  {$EXTERNALSYM MEDIASUBTYPE_DRM_Audio}
  MEDIASUBTYPE_IEEE_FLOAT: TGUID = (D1:$00000003;D2:$0000;D3:$0010;D4:($80,$00,$00,$aa,$00,$38,$9b,$71));
  {$EXTERNALSYM MEDIASUBTYPE_IEEE_FLOAT}
  MEDIASUBTYPE_DOLBY_AC3_SPDIF: TGUID = (D1:$00000092;D2:$0000;D3:$0010;D4:($80,$00,$00,$aa,$00,$38,$9b,$71));
  {$EXTERNALSYM MEDIASUBTYPE_DOLBY_AC3_SPDIF}
  MEDIASUBTYPE_RAW_SPORT: TGUID = (D1:$00000240;D2:$0000;D3:$0010;D4:($80,$00,$00,$aa,$00,$38,$9b,$71));
  {$EXTERNALSYM MEDIASUBTYPE_RAW_SPORT}
  MEDIASUBTYPE_SPDIF_TAG_241h: TGUID = (D1:$00000241;D2:$0000;D3:$0010;D4:($80,$00,$00,$aa,$00,$38,$9b,$71));
  {$EXTERNALSYM MEDIASUBTYPE_SPDIF_TAG_241h}

// DirectShow DSS definitions

  MEDIASUBTYPE_DssVideo: TGUID = (D1:$A0AF4F81;D2:$E163;D3:$11D0;D4:($BA,$D9,$00,$60,$97,$44,$11,$1A));
  {$EXTERNALSYM MEDIASUBTYPE_DssVideo}
  MEDIASUBTYPE_DssAudio: TGUID = (D1:$A0AF4F82;D2:$E163;D3:$11D0;D4:($BA,$D9,$00,$60,$97,$44,$11,$1A));
  {$EXTERNALSYM MEDIASUBTYPE_DssAudio}
  MEDIASUBTYPE_VPVideo: TGUID = (D1:$5A9B6A40;D2:$1A22;D3:$11D1;D4:($BA,$D9,$00,$60,$97,$44,$11,$1A));
  {$EXTERNALSYM MEDIASUBTYPE_VPVideo}
  MEDIASUBTYPE_VPVBI: TGUID = (D1:$5A9B6A41;D2:$1A22;D3:$11D1;D4:($BA,$D9,$00,$60,$97,$44,$11,$1A));
  {$EXTERNALSYM MEDIASUBTYPE_VPVBI}

//--- dxmedia (the cutlist source filter)
  CLSID_SimpleCutList: TGUID = (D1:$A5EA8D30;D2:$253D;D3:$11D1;D4:($B3,$F1,$00,$AA,$00,$37,$61,$C5));
  {$EXTERNALSYM CLSID_SimpleCutList}
  CLSID_VideoFileClip: TGUID = (D1:$A5EA8D31;D2:$253D;D3:$11D1;D4:($B3,$F1,$00,$AA,$00,$37,$61,$C5));
  {$EXTERNALSYM CLSID_VideoFileClip}
  CLSID_AudioFileClip: TGUID = (D1:$A5EA8D32;D2:$253D;D3:$11D1;D4:($B3,$F1,$00,$AA,$00,$37,$61,$C5));
  {$EXTERNALSYM CLSID_AudioFileClip}
  CLSID_CutListCacheMemory: TGUID = (D1:$A5EA8D33;D2:$253D;D3:$11D1;D4:($B3,$F1,$00,$AA,$00,$37,$61,$C5));
  {$EXTERNALSYM CLSID_CutListCacheMemory}
//--- end cut list stuff
  CLSID_CaptureGraphBuilder: TGUID = (D1:$BF87B6E0;D2:$8C27;D3:$11D0;D4:($B3,$F0,$00,$AA,$00,$37,$61,$C5));
  {$EXTERNALSYM CLSID_CaptureGraphBuilder}
  CLSID_CaptureGraphBuilder2: TGUID = (D1:$BF87B6E1;D2:$8C27;D3:$11d0;D4:($B3,$F0,$00,$AA,$00,$37,$61,$C5));
  {$EXTERNALSYM CLSID_CaptureGraphBuilder2}
  CLSID_ProtoFilterGraph: TGUID = (D1:$E436EBB0;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM CLSID_ProtoFilterGraph}
  CLSID_SystemClock: TGUID = (D1:$E436EBB1;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM CLSID_SystemClock}
  CLSID_FilterMapper: TGUID = (D1:$E436EBB2;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM CLSID_FilterMapper}
  CLSID_FilterGraph: TGUID = (D1:$E436EBB3;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM CLSID_FilterGraph}
  CLSID_FilterGraphNoThread: TGUID = (D1:$E436EBB8;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM CLSID_FilterGraphNoThread}
  CLSID_MPEG1Doc: TGUID = (D1:$E4BBD160;D2:$4269;D3:$11CE;D4:($83,$8D,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM CLSID_MPEG1Doc}
  CLSID_FileSource: TGUID = (D1:$701722E0;D2:$8AE3;D3:$11CE;D4:($A8,$5C,$00,$AA,$00,$2F,$EA,$B5));
  {$EXTERNALSYM CLSID_FileSource}
  CLSID_MPEG1PacketPlayer: TGUID = (D1:$26C25940;D2:$4CA9;D3:$11CE;D4:($A8,$28,$00,$AA,$00,$2F,$EA,$B5));
  {$EXTERNALSYM CLSID_MPEG1PacketPlayer}
  CLSID_MPEG1Splitter: TGUID = (D1:$336475D0;D2:$942A;D3:$11CE;D4:($A8,$70,$00,$AA,$00,$2F,$EA,$B5));
  {$EXTERNALSYM CLSID_MPEG1Splitter}
  CLSID_CMpegVideoCodec: TGUID = (D1:$FEB50740;D2:$7BEF;D3:$11CE;D4:($9B,$D9,$00,$00,$E2,$02,$59,$9C));
  {$EXTERNALSYM CLSID_CMpegVideoCodec}
  CLSID_CMpegAudioCodec: TGUID = (D1:$4A2286E0;D2:$7BEF;D3:$11CE;D4:($9B,$D9,$00,$00,$E2,$02,$59,$9C));
  {$EXTERNALSYM CLSID_CMpegAudioCodec}
  CLSID_TextRender: TGUID = (D1:$E30629D3;D2:$27E5;D3:$11CE;D4:($87,$5D,$00,$60,$8C,$B7,$80,$66));
  {$EXTERNALSYM CLSID_TextRender}

  CLSID_InfTee: TGUID = (D1:$F8388A40;D2:$D5BB;D3:$11D0;D4:($BE,$5A,$00,$80,$C7,$06,$56,$8E));
  {$EXTERNALSYM CLSID_InfTee}
  CLSID_AviSplitter: TGUID = (D1:$1B544C20;D2:$FD0B;D3:$11CE;D4:($8C,$63,$00,$AA,$00,$44,$B5,$1E));
  {$EXTERNALSYM CLSID_AviSplitter}
  CLSID_AviReader: TGUID = (D1:$1B544C21;D2:$FD0B;D3:$11CE;D4:($8C,$63,$00,$AA,$00,$44,$B5,$1E));
  {$EXTERNALSYM CLSID_AviReader}
  CLSID_VfwCapture: TGUID = (D1:$1B544C22;D2:$FD0B;D3:$11CE;D4:($8C,$63,$00,$AA,$00,$44,$B5,$1E));
  {$EXTERNALSYM CLSID_VfwCapture}
  CLSID_CaptureProperties: TGUID = (D1:$1B544C22;D2:$FD0B;D3:$11CE;D4:($8C,$63,$00,$AA,$00,$44,$B5,$1F));
  {$EXTERNALSYM CLSID_CaptureProperties}
  CLSID_FGControl: TGUID = (D1:$E436EBB4;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM CLSID_FGControl}
  CLSID_MOVReader: TGUID = (D1:$44584800;D2:$F8EE;D3:$11CE;D4:($B2,$D4,$00,$DD,$01,$10,$1B,$85));
  {$EXTERNALSYM CLSID_MOVReader}
  CLSID_QuickTimeParser: TGUID = (D1:$d51bd5a0;D2:$7548;D3:$11cf;D4:($a5,$20,$00,$80,$c7,$7e,$f5,$8a));
  {$EXTERNALSYM CLSID_QuickTimeParser}
  CLSID_QTDec: TGUID = (D1:$fdfe9681;D2:$74a3;D3:$11d0;D4:($af,$a7,$00,$aa,$00,$b6,$7a,$42));
  {$EXTERNALSYM CLSID_QTDec}
  CLSID_AVIDoc: TGUID = (D1:$D3588AB0;D2:$0781;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM CLSID_AVIDoc}
//---dxmedia
  CLSID_AVIDocWriter: TGUID = (D1:$D3588AB1;D2:$0781;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM CLSID_AVIDocWriter}
//---
  CLSID_VideoRenderer: TGUID = (D1:$70E102B0;D2:$5556;D3:$11CE;D4:($97,$C0,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM CLSID_VideoRenderer}
  CLSID_Colour: TGUID = (D1:$1643E180;D2:$90F5;D3:$11CE;D4:($97,$D5,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM CLSID_Colour}
  CLSID_Dither: TGUID = (D1:$1DA08500;D2:$9EDC;D3:$11CF;D4:($BC,$10,$00,$AA,$00,$AC,$74,$F6));
  {$EXTERNALSYM CLSID_Dither}
  CLSID_ModexRenderer: TGUID = (D1:$07167665;D2:$5011;D3:$11CF;D4:($BF,$33,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM CLSID_ModexRenderer}
  CLSID_AudioRender: TGUID = (D1:$E30629D1;D2:$27E5;D3:$11CE;D4:($87,$5D,$00,$60,$8C,$B7,$80,$66));
  {$EXTERNALSYM CLSID_AudioRender}
  CLSID_AudioProperties: TGUID = (D1:$05589FAF;D2:$C356;D3:$11CE;D4:($BF,$01,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM CLSID_AudioProperties}

  CLSID_DSoundRender: TGUID = (D1:$79376820;D2:$07D0;D3:$11CF;D4:($A2,$4D,$00,$20,$AF,$D7,$97,$67));
  {$EXTERNALSYM CLSID_DSoundRender}
  CLSID_AudioRecord: TGUID = (D1:$E30629D2;D2:$27E5;D3:$11CE;D4:($87,$5D,$00,$60,$8C,$B7,$80,$66));
  {$EXTERNALSYM CLSID_AudioRecord}
  CLSID_AudioInputMixerProperties: TGUID = (D1:$2ca8ca52;D2:$3c3f;D3:$11d2;D4:($b7,$3d,$00,$c0,$4f,$b6,$bd,$3d));
  {$EXTERNALSYM CLSID_AudioInputMixerProperties}
  CLSID_AVIDec: TGUID = (D1:$CF49D4E0;D2:$1115;D3:$11CE;D4:($B0,$3A,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM CLSID_AVIDec}
  CLSID_AVIDraw: TGUID = (D1:$a888df60;D2:$1e90;D3:$11cf;D4:($ac,$98,$00,$aa,$00,$4c,$f,$a9));
  {$EXTERNALSYM CLSID_AVIDraw}
  CLSID_ACMWrapper: TGUID = (D1:$6A08CF80;D2:$0E18;D3:$11CF;D4:($A2,$4D,$00,$20,$AF,$D7,$97,$67));
  {$EXTERNALSYM CLSID_ACMWrapper}
  CLSID_AsyncReader: TGUID = (D1:$E436EBB5;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM CLSID_AsyncReader}
  CLSID_URLReader: TGUID = (D1:$E436EBB6;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM CLSID_URLReader}
  CLSID_PersistMonikerPID: TGUID = (D1:$E436EBB7;D2:$524F;D3:$11CE;D4:($9F,$53,$00,$20,$AF,$0B,$A7,$70));
  {$EXTERNALSYM CLSID_PersistMonikerPID}
  CLSID_AMovie: TGUID = (D1:$5F2759C0;D2:$7685;D3:$11CF;D4:($8B,$23,$00,$80,$5F,$6C,$EF,$60));
  {$EXTERNALSYM CLSID_AMovie}
  CLSID_AVICo: TGUID = (D1:$D76E2820;D2:$1563;D3:$11CF;D4:($AC,$98,$00,$AA,$00,$4C,$0F,$A9));
  {$EXTERNALSYM CLSID_AVICo}
  CLSID_FileWriter: TGUID = (D1:$8596E5F0;D2:$0DA5;D3:$11D0;D4:($BD,$21,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_FileWriter}

  CLSID_AviDest: TGUID = (D1:$E2510970;D2:$F137;D3:$11CE;D4:($8B,$67,$00,$AA,$00,$A3,$F1,$A6));
  {$EXTERNALSYM CLSID_AviDest}
  CLSID_AviMuxProptyPage: TGUID = (D1:$C647B5C0;D2:$157C;D3:$11D0;D4:($BD,$23,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_AviMuxProptyPage}
  CLSID_AviMuxProptyPage1: TGUID = (D1:$0A9AE910;D2:$85C0;D3:$11D0;D4:($BD,$42,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_AviMuxProptyPage1}
  CLSID_AVIMIDIRender: TGUID = (D1:$07B65360;D2:$C445;D3:$11CE;D4:($AF,$DE,$00,$AA,$00,$6C,$14,$F4));
  {$EXTERNALSYM CLSID_AVIMIDIRender}
  CLSID_WMAsfReader: TGUID = (D1:$187463a0;D2:$5bb7;D3:$11d3;D4:($ac,$be,$00,$80,$c7,$5e,$24,$6e));
  {$EXTERNALSYM CLSID_WMAsfReader}
  CLSID_WMAsfWriter: TGUID = (D1:$7c23220e;D2:$55bb;D3:$11d3;D4:($8b,$16,$00,$c0,$4f,$b6,$bd,$3d));
  {$EXTERNALSYM CLSID_WMAsfWriter}
  CLSID_MPEG2Demultiplexer: TGUID = (D1:$afb6c280;D2:$2c41;D3:$11d3;D4:($8a,$60,$00,$00,$f8,$1e,$0e,$4a));
  {$EXTERNALSYM CLSID_MPEG2Demultiplexer}
  CLSID_MMSPLITTER: TGUID = (D1:$3ae86b20;D2:$7be8;D3:$11d1;D4:($ab,$e6,$00,$a0,$c9,$05,$f3,$75));
  {$EXTERNALSYM CLSID_MMSPLITTER}

  CLSID_StreamBufferSink                : TGUID = '{2DB47AE5-CF39-43c2-B4D6-0CD8D90946F4}';
  {$EXTERNALSYM CLSID_StreamBufferSink}
  CLSID_StreamBufferSource              : TGUID = '{C9F5FE02-F851-4eb5-99EE-AD602AF1E619}';
  {$EXTERNALSYM CLSID_StreamBufferSource}
  CLSID_StreamBufferConfig              : TGUID = '{FA8A68B2-C864-4ba2-AD53-D3876A87494B}';
  {$EXTERNALSYM CLSID_StreamBufferConfig}
  CLSID_Mpeg2VideoStreamAnalyzer        : TGUID = '{6CFAD761-735D-4aa5-8AFC-AF91A7D61EBA}';
  {$EXTERNALSYM CLSID_Mpeg2VideoStreamAnalyzer}
  CLSID_StreamBufferRecordingAttributes : TGUID = '{CCAA63AC-1057-4778-AE92-1206AB9ACEE6}';
  {$EXTERNALSYM CLSID_StreamBufferRecordingAttributes}
  CLSID_StreamBufferComposeRecording    : TGUID = '{D682C4BA-A90A-42fe-B9E1-03109849C423}';
  {$EXTERNALSYM CLSID_StreamBufferComposeRecording}

  CLSID_DVVideoCodec: TGUID = (D1:$B1B77C00;D2:$C3E4;D3:$11CF;D4:($AF,$79,$00,$AA,$00,$B6,$7A,$42));
  {$EXTERNALSYM CLSID_DVVideoCodec}
  CLSID_DVVideoEnc: TGUID = (D1:$13AA3650;D2:$BB6F;D3:$11D0;D4:($AF,$B9,$00,$AA,$00,$B6,$7A,$42));
  {$EXTERNALSYM CLSID_DVVideoEnc}
  CLSID_DVSplitter: TGUID = (D1:$4EB31670;D2:$9FC6;D3:$11CF;D4:($AF,$6E,$00,$AA,$00,$B6,$7A,$42));
  {$EXTERNALSYM CLSID_DVSplitter}
  CLSID_DVMux: TGUID = (D1:$129D7E40;D2:$C10D;D3:$11D0;D4:($AF,$B9,$00,$AA,$00,$B6,$7A,$42));
  {$EXTERNALSYM CLSID_DVMux}
  CLSID_SeekingPassThru: TGUID = (D1:$060AF76C;D2:$68DD;D3:$11D0;D4:($8F,$C1,$00,$C0,$4F,$D9,$18,$9D));
  {$EXTERNALSYM CLSID_SeekingPassThru}
  CLSID_Line21Decoder  : TGUID = (D1:$6E8D4A20;D2:$310C;D3:$11D0;D4:($B7,$9A,$00,$AA,$00,$37,$67,$A7));
  {$EXTERNALSYM CLSID_Line21Decoder}
  CLSID_Line21Decoder2 : TGUID = '{E4206432-01A1-4BEE-B3E1-3702C8EDC574}'; //Line21 (CC) Decoder v2
  {$EXTERNALSYM CLSID_Line21Decoder2}
  CLSID_OverlayMixer: TGUID = (D1:$CD8743A1;D2:$3736;D3:$11D0;D4:($9E,$69,$00,$C0,$4F,$D7,$C1,$5B));
  {$EXTERNALSYM CLSID_OverlayMixer}
  CLSID_OverlayMixer2: TGUID = '{A0025E90-E45B-11D1-ABE9-00A0C905F375}'; //Overlay Mixer v2
  {$EXTERNALSYM CLSID_OverlayMixer2}
  CLSID_VBISurfaces: TGUID = (D1:$814B9800;D2:$1C88;D3:$11D1;D4:($BA,$D9,$00,$60,$97,$44,$11,$1A));
  {$EXTERNALSYM CLSID_VBISurfaces}
  CLSID_WSTDecoder : TGUID = '{70BC06E0-5666-11d3-A184-00105AEF9F33}'; //WST Teletext Decoder
  {$EXTERNALSYM CLSID_WSTDecoder}
  CLSID_MjpegDec   : TGUID = '{301056D0-6DFF-11d2-9EEB-006008039E37}';
  {$EXTERNALSYM CLSID_MjpegDec}
  CLSID_MJPGEnc    : TGUID = '{B80AB0A0-7416-11d2-9EEB-006008039E37}';
  {$EXTERNALSYM CLSID_MJPGEnc}

// pnp objects and categories
  CLSID_SystemDeviceEnum: TGUID = (D1:$62BE5D10;D2:$60EB;D3:$11D0;D4:($BD,$3B,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_SystemDeviceEnum}
  CLSID_CDeviceMoniker: TGUID = (D1:$4315D437;D2:$5B8C;D3:$11D0;D4:($BD,$3B,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_CDeviceMoniker}
  CLSID_VideoInputDeviceCategory: TGUID = (D1:$860BB310;D2:$5D01;D3:$11D0;D4:($BD,$3B,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_VideoInputDeviceCategory}
  CLSID_CVidCapClassManager: TGUID = (D1:$860BB310;D2:$5D01;D3:$11D0;D4:($BD,$3B,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_CVidCapClassManager}
  CLSID_LegacyAmFilterCategory: TGUID = (D1:$083863F1;D2:$70DE;D3:$11D0;D4:($BD,$40,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_LegacyAmFilterCategory}
  CLSID_CQzFilterClassManager: TGUID = (D1:$083863F1;D2:$70DE;D3:$11D0;D4:($BD,$40,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_CQzFilterClassManager}
  CLSID_VideoCompressorCategory: TGUID = (D1:$33D9A760;D2:$90C8;D3:$11D0;D4:($BD,$43,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_VideoCompressorCategory}
  CLSID_CIcmCoClassManager: TGUID = (D1:$33D9A760;D2:$90C8;D3:$11D0;D4:($BD,$43,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_CIcmCoClassManager}
  CLSID_AudioCompressorCategory: TGUID = (D1:$33D9A761;D2:$90C8;D3:$11D0;D4:($BD,$43,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_AudioCompressorCategory}
  CLSID_CAcmCoClassManager: TGUID = (D1:$33D9A761;D2:$90C8;D3:$11D0;D4:($BD,$43,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_CAcmCoClassManager}
  CLSID_AudioInputDeviceCategory: TGUID = (D1:$33D9A762;D2:$90C8;D3:$11D0;D4:($BD,$43,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_AudioInputDeviceCategory}
  CLSID_CWaveinClassManager: TGUID = (D1:$33D9A762;D2:$90C8;D3:$11D0;D4:($BD,$43,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_CWaveinClassManager}
  CLSID_AudioRendererCategory: TGUID = (D1:$E0F158E1;D2:$CB04;D3:$11D0;D4:($BD,$4E,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_AudioRendererCategory}
  CLSID_CWaveOutClassManager: TGUID = (D1:$E0F158E1;D2:$CB04;D3:$11D0;D4:($BD,$4E,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_CWaveOutClassManager}
  CLSID_MidiRendererCategory: TGUID = (D1:$4EFE2452;D2:$168A;D3:$11D1;D4:($BC,$76,$00,$C0,$4F,$B9,$45,$3B));
  {$EXTERNALSYM CLSID_MidiRendererCategory}
  CLSID_CMidiOutClassManager: TGUID = (D1:$4EFE2452;D2:$168A;D3:$11D1;D4:($BC,$76,$00,$C0,$4F,$B9,$45,$3B));
  {$EXTERNALSYM CLSID_CMidiOutClassManager}
  CLSID_TransmitCategory: TGUID = (D1:$cc7bfb41;D2:$f175;D3:$11d1;D4:($a3,$92,$00,$e0,$29,$1f,$39,$59));
  {$EXTERNALSYM CLSID_TransmitCategory}
  CLSID_DeviceControlCategory: TGUID = (D1:$cc7bfb46;D2:$f175;D3:$11d1;D4:($a3,$92,$00,$e0,$29,$1f,$39,$59));
  {$EXTERNALSYM CLSID_DeviceControlCategory}
  CLSID_ActiveMovieCategories: TGUID = (D1:$DA4E3DA0;D2:$D07D;D3:$11D0;D4:($BD,$50,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_ActiveMovieCategories}
  CLSID_DVDHWDecodersCategory: TGUID = (D1:$2721AE20;D2:$7E70;D3:$11D0;D4:($A5,$D6,$28,$DB,$04,$C1,$00,$00));
  {$EXTERNALSYM CLSID_DVDHWDecodersCategory}

  CLSID_MediaEncoderCategory     : TGUID = '{7D22E920-5CA9-4787-8C2B-A6779BD11781}'; // Encoder API encoder category
  {$EXTERNALSYM CLSID_MediaEncoderCategory}
  CLSID_MediaMultiplexerCategory : TGUID = '{236C9559-ADCE-4736-BF72-BAB34E392196}'; // Encoder API multiplexer category
  {$EXTERNALSYM CLSID_MediaMultiplexerCategory}

  CLSID_FilterMapper2: TGUID = (D1:$CDA42200;D2:$BD88;D3:$11D0;D4:($BD,$4E,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_FilterMapper2}
  CLSID_MemoryAllocator: TGUID = (D1:$1E651CC0;D2:$B199;D3:$11D0;D4:($82,$12,$00,$C0,$4F,$C3,$2C,$45));
  {$EXTERNALSYM CLSID_MemoryAllocator}
  CLSID_MediaPropertyBag: TGUID = (D1:$CDBD8D00;D2:$C193;D3:$11D0;D4:($BD,$4E,$00,$A0,$C9,$11,$CE,$86));
  {$EXTERNALSYM CLSID_MediaPropertyBag}
  CLSID_DvdGraphBuilder: TGUID = (D1:$FCC152B7;D2:$F372;D3:$11D0;D4:($8E,$00,$00,$C0,$4F,$D7,$C0,$8B));
  {$EXTERNALSYM CLSID_DvdGraphBuilder}
  CLSID_DVDNavigator: TGUID = (D1:$9B8C4620;D2:$2C1A;D3:$11D0;D4:($84,$93,$00,$A0,$24,$38,$AD,$48));
  {$EXTERNALSYM CLSID_DVDNavigator}
  CLSID_DVDState: TGUID = (D1:$f963c5cf;D2:$a659;D3:$4a93;D4:($96,$38,$ca,$f3,$cd,$27,$7d,$13));
  {$EXTERNALSYM CLSID_DVDState}
  CLSID_SmartTee: TGUID = (D1:$cc58e280;D2:$8aa1;D3:$11d1;D4:($b3,$f1,$00,$aa,$00,$37,$61,$c5));
  {$EXTERNALSYM CLSID_SmartTee}

// -- format types ---
  FORMAT_None: TGUID = (D1:$0F6417D6;D2:$C318;D3:$11D0;D4:($A4,$3F,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM FORMAT_None}
  FORMAT_VideoInfo: TGUID = (D1:$05589F80;D2:$C356;D3:$11CE;D4:($BF,$01,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM FORMAT_VideoInfo}
  FORMAT_VideoInfo2: TGUID = (D1:$F72A76A0;D2:$EB0A;D3:$11D0;D4:($AC,$E4,$00,$00,$C0,$CC,$16,$BA));
  {$EXTERNALSYM FORMAT_VideoInfo2}
  FORMAT_WaveFormatEx: TGUID = (D1:$05589F81;D2:$C356;D3:$11CE;D4:($BF,$01,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM FORMAT_WaveFormatEx}
  FORMAT_MPEGVideo: TGUID = (D1:$05589F82;D2:$C356;D3:$11CE;D4:($BF,$01,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM FORMAT_MPEGVideo}
  FORMAT_MPEGStreams: TGUID = (D1:$05589F83;D2:$C356;D3:$11CE;D4:($BF,$01,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM FORMAT_MPEGStreams}
  FORMAT_DvInfo: TGUID = (D1:$05589F84;D2:$C356;D3:$11CE;D4:($BF,$01,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM FORMAT_DvInfo}


// -- Video related GUIDs ---
  CLSID_DirectDrawProperties: TGUID = (D1:$944D4C00;D2:$DD52;D3:$11CE;D4:($BF,$0E,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM CLSID_DirectDrawProperties}
  CLSID_PerformanceProperties: TGUID = (D1:$59CE6880;D2:$ACF8;D3:$11CF;D4:($B5,$6E,$00,$80,$C7,$C4,$B6,$8A));
  {$EXTERNALSYM CLSID_PerformanceProperties}
  CLSID_QualityProperties: TGUID = (D1:$418AFB70;D2:$F8B8;D3:$11CE;D4:($AA,$C6,$00,$20,$AF,$0B,$99,$A3));
  {$EXTERNALSYM CLSID_QualityProperties}
  CLSID_VPObject: TGUID = (D1:$CE292861;D2:$FC88;D3:$11D0;D4:($9E,$69,$00,$C0,$4F,$D7,$C1,$5B));
  {$EXTERNALSYM CLSID_VPObject}
  IID_IVPObject: TGUID = (D1:$CE292862;D2:$FC88;D3:$11D0;D4:($9E,$69,$00,$C0,$4F,$D7,$C1,$5B));
  {$EXTERNALSYM IID_IVPObject}
  IID_IVPControl: TGUID = (D1:$25DF12C1;D2:$3DE0;D3:$11D1;D4:($9E,$69,$00,$C0,$4F,$D7,$C1,$5B));
  {$EXTERNALSYM IID_IVPControl}
  CLSID_VPVBIObject: TGUID = (D1:$814B9801;D2:$1C88;D3:$11D1;D4:($BA,$D9,$00,$60,$97,$44,$11,$1A));
  {$EXTERNALSYM CLSID_VPVBIObject}
  IID_IVPVBIObject: TGUID = (D1:$814B9802;D2:$1C88;D3:$11D1;D4:($BA,$D9,$00,$60,$97,$44,$11,$1A));
  {$EXTERNALSYM IID_IVPVBIObject}

  CLSID_ModexProperties: TGUID = (D1:$0618AA30;D2:$6BC4;D3:$11CF;D4:($BF,$36,$00,$AA,$00,$55,$59,$5A));
  {$EXTERNALSYM CLSID_ModexProperties}

// DV decoder property
  CLSID_DVDecPropertiesPage: TGUID = (D1:$101193C0;D2:$0BFE;D3:$11D0;D4:($AF,$91,$00,$AA,$00,$B6,$7A,$42));
  {$EXTERNALSYM CLSID_DVDecPropertiesPage}

// DV encoder property
  CLSID_DVEncPropertiesPage: TGUID = (D1:$4150F050;D2:$BB6F;D3:$11D0;D4:($AF,$B9,$00,$AA,$00,$B6,$7A,$42));
  {$EXTERNALSYM CLSID_DVEncPropertiesPage}

// DV Muxer property
  CLSID_DVMuxPropertyPage: TGUID = (D1:$4DB880E0;D2:$C10D;D3:$11D0;D4:($AF,$B9,$00,$AA,$00,$B6,$7A,$42));
  {$EXTERNALSYM CLSID_DVMuxPropertyPage}


// -- Analog video related GUIDs ---


// -- format types ---
  FORMAT_AnalogVideo    : TGUID = (D1:$0482DDE0;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM FORMAT_AnalogVideo}

  MEDIATYPE_AnalogAudio : TGUID = '{0482DEE1-7817-11cf-8a03-00aa006ecb65}';
  {$EXTERNALSYM MEDIATYPE_AnalogAudio}
  MEDIATYPE_AnalogVideo : TGUID = (D1:$0482DDE1;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIATYPE_AnalogVideo}
  MEDIASUBTYPE_AnalogVideo_NTSC_M: TGUID = (D1:$0482DDE2;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_NTSC_M}
  MEDIASUBTYPE_AnalogVideo_PAL_B: TGUID = (D1:$0482DDE5;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_PAL_B}
  MEDIASUBTYPE_AnalogVideo_PAL_D: TGUID = (D1:$0482DDE6;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_PAL_D}
  MEDIASUBTYPE_AnalogVideo_PAL_G: TGUID = (D1:$0482DDE7;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_PAL_G}
  MEDIASUBTYPE_AnalogVideo_PAL_H: TGUID = (D1:$0482DDE8;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_PAL_H}
  MEDIASUBTYPE_AnalogVideo_PAL_I: TGUID = (D1:$0482DDE9;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_PAL_I}
  MEDIASUBTYPE_AnalogVideo_PAL_M: TGUID = (D1:$0482DDEA;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_PAL_M}
  MEDIASUBTYPE_AnalogVideo_PAL_N : TGUID = (D1:$0482DDEB;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_PAL_N}
  MEDIASUBTYPE_AnalogVideo_PAL_N_COMBO: TGUID = (D1:$482ddec;D2:$7817;D3:$11cf;D4:($8a,$3,$00,$aa,$00,$6e,$cb,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_PAL_N_COMBO}

// -- Analog Video subtypes, SECAM
  MEDIASUBTYPE_AnalogVideo_SECAM_B: TGUID = (D1:$0482DDF0;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_SECAM_B}
  MEDIASUBTYPE_AnalogVideo_SECAM_D: TGUID = (D1:$0482DDF1;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_SECAM_D}
  MEDIASUBTYPE_AnalogVideo_SECAM_G: TGUID = (D1:$0482DDF2;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_SECAM_G}
  MEDIASUBTYPE_AnalogVideo_SECAM_H: TGUID = (D1:$0482DDF3;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_SECAM_H}
  MEDIASUBTYPE_AnalogVideo_SECAM_K: TGUID = (D1:$0482DDF4;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_SECAM_K}
  MEDIASUBTYPE_AnalogVideo_SECAM_K1: TGUID = (D1:$0482DDF5;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_SECAM_K1}
  MEDIASUBTYPE_AnalogVideo_SECAM_L: TGUID = (D1:$0482DDF6;D2:$7817;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM MEDIASUBTYPE_AnalogVideo_SECAM_L}

// -- Well known time format GUIDs ---
  TIME_FORMAT_NONE: TGUID = (D1:$00000000;D2:$0000;D3:$0000;D4:($00,$00,$00,$00,$00,$00,$00,$00));
  {$EXTERNALSYM TIME_FORMAT_NONE}
  TIME_FORMAT_FRAME: TGUID = (D1:$7B785570;D2:$8C82;D3:$11CF;D4:($BC,$0C,$00,$AA,$00,$AC,$74,$F6));
  {$EXTERNALSYM TIME_FORMAT_FRAME}
  TIME_FORMAT_BYTE: TGUID = (D1:$7B785571;D2:$8C82;D3:$11CF;D4:($BC,$0C,$00,$AA,$00,$AC,$74,$F6));
  {$EXTERNALSYM TIME_FORMAT_BYTE}
  TIME_FORMAT_SAMPLE: TGUID = (D1:$7B785572;D2:$8C82;D3:$11CF;D4:($BC,$0C,$00,$AA,$00,$AC,$74,$F6));
  {$EXTERNALSYM TIME_FORMAT_SAMPLE}
  TIME_FORMAT_FIELD: TGUID = (D1:$7B785573;D2:$8C82;D3:$11CF;D4:($BC,$0C,$00,$AA,$00,$AC,$74,$F6));
  {$EXTERNALSYM TIME_FORMAT_FIELD}
  TIME_FORMAT_MEDIA_TIME: TGUID = (D1:$7B785574;D2:$8C82;D3:$11CF;D4:($BC,$0C,$00,$AA,$00,$AC,$74,$F6));
  {$EXTERNALSYM TIME_FORMAT_MEDIA_TIME}

// for IKsPropertySet
  AMPROPSETID_Pin: TGUID = (D1:$9B00F101;D2:$1567;D3:$11D1;D4:($B3,$F1,$00,$AA,$00,$37,$61,$C5));
  {$EXTERNALSYM AMPROPSETID_Pin}
  PIN_CATEGORY_CAPTURE: TGUID = (D1:$FB6C4281;D2:$0353;D3:$11D1;D4:($90,$5F,$00,$00,$C0,$CC,$16,$BA));
  {$EXTERNALSYM PIN_CATEGORY_CAPTURE}
  PIN_CATEGORY_PREVIEW: TGUID = (D1:$FB6C4282;D2:$0353;D3:$11D1;D4:($90,$5F,$00,$00,$C0,$CC,$16,$BA));
  {$EXTERNALSYM PIN_CATEGORY_PREVIEW}
  PIN_CATEGORY_ANALOGVIDEOIN: TGUID = (D1:$FB6C4283;D2:$0353;D3:$11D1;D4:($90,$5F,$00,$00,$C0,$CC,$16,$BA));
  {$EXTERNALSYM PIN_CATEGORY_ANALOGVIDEOIN}
  PIN_CATEGORY_VBI: TGUID = (D1:$FB6C4284;D2:$0353;D3:$11D1;D4:($90,$5F,$00,$00,$C0,$CC,$16,$BA));
  {$EXTERNALSYM PIN_CATEGORY_VBI}
  PIN_CATEGORY_VIDEOPORT: TGUID = (D1:$FB6C4285;D2:$0353;D3:$11D1;D4:($90,$5F,$00,$00,$C0,$CC,$16,$BA));
  {$EXTERNALSYM PIN_CATEGORY_VIDEOPORT}
  PIN_CATEGORY_NABTS: TGUID = (D1:$FB6C4286;D2:$0353;D3:$11D1;D4:($90,$5F,$00,$00,$C0,$CC,$16,$BA));
  {$EXTERNALSYM PIN_CATEGORY_NABTS}
  PIN_CATEGORY_EDS: TGUID = (D1:$FB6C4287;D2:$0353;D3:$11D1;D4:($90,$5F,$00,$00,$C0,$CC,$16,$BA));
  {$EXTERNALSYM PIN_CATEGORY_EDS}
  PIN_CATEGORY_TELETEXT: TGUID = (D1:$FB6C4288;D2:$0353;D3:$11D1;D4:($90,$5F,$00,$00,$C0,$CC,$16,$BA));
  {$EXTERNALSYM PIN_CATEGORY_TELETEXT}
  PIN_CATEGORY_CC: TGUID = (D1:$FB6C4289;D2:$0353;D3:$11D1;D4:($90,$5F,$00,$00,$C0,$CC,$16,$BA));
  {$EXTERNALSYM PIN_CATEGORY_CC}
  PIN_CATEGORY_STILL: TGUID = (D1:$FB6C428A;D2:$0353;D3:$11D1;D4:($90,$5F,$00,$00,$C0,$CC,$16,$BA));
  {$EXTERNALSYM PIN_CATEGORY_STILL}
  PIN_CATEGORY_TIMECODE: TGUID = (D1:$FB6C428B;D2:$0353;D3:$11D1;D4:($90,$5F,$00,$00,$C0,$CC,$16,$BA));
  {$EXTERNALSYM PIN_CATEGORY_TIMECODE}
  PIN_CATEGORY_VIDEOPORT_VBI: TGUID = (D1:$FB6C428C;D2:$0353;D3:$11D1;D4:($90,$5F,$00,$00,$C0,$CC,$16,$BA));
  {$EXTERNALSYM PIN_CATEGORY_VIDEOPORT_VBI}

// the following special GUIDS are used by ICaptureGraphBuilder::FindInterface
  LOOK_UPSTREAM_ONLY:   TGUID = (D1:$ac798be0;D2:$98e3;D3:$11d1;D4:($b3,$f1,$0,$aa,$0,$37,$61,$c5));
  {$EXTERNALSYM LOOK_UPSTREAM_ONLY}
  LOOK_DOWNSTREAM_ONLY: TGUID = (D1:$ac798be1;D2:$98e3;D3:$11d1;D4:($b3,$f1,$0,$aa,$0,$37,$61,$c5));
  {$EXTERNALSYM LOOK_DOWNSTREAM_ONLY}

// -------------------------------------------------------------------------
// KSProxy GUIDS
// -------------------------------------------------------------------------

  CLSID_TVTunerFilterPropertyPage: TGUID = (D1:$266EEE41;D2:$6C63;D3:$11CF;D4:($8A,$03,$00,$AA,$00,$6E,$CB,$65));
  {$EXTERNALSYM CLSID_TVTunerFilterPropertyPage}
  CLSID_CrossbarFilterPropertyPage: TGUID = (D1:$71F96461;D2:$78F3;D3:$11D0;D4:($A1,$8C,$00,$A0,$C9,$11,$89,$56));
  {$EXTERNALSYM CLSID_CrossbarFilterPropertyPage}
  CLSID_TVAudioFilterPropertyPage: TGUID = (D1:$71F96463;D2:$78F3;D3:$11D0;D4:($A1,$8C,$00,$A0,$C9,$11,$89,$56));
  {$EXTERNALSYM CLSID_TVAudioFilterPropertyPage}
  CLSID_VideoProcAmpPropertyPage: TGUID = (D1:$71F96464;D2:$78F3;D3:$11D0;D4:($A1,$8C,$00,$A0,$C9,$11,$89,$56));
  {$EXTERNALSYM CLSID_VideoProcAmpPropertyPage}
  CLSID_CameraControlPropertyPage: TGUID = (D1:$71F96465;D2:$78F3;D3:$11D0;D4:($A1,$8C,$00,$A0,$C9,$11,$89,$56));
  {$EXTERNALSYM CLSID_CameraControlPropertyPage}
  CLSID_AnalogVideoDecoderPropertyPage: TGUID = (D1:$71F96466;D2:$78F3;D3:$11D0;D4:($A1,$8C,$00,$A0,$C9,$11,$89,$56));
  {$EXTERNALSYM CLSID_AnalogVideoDecoderPropertyPage}
  CLSID_VideoStreamConfigPropertyPage: TGUID = (D1:$71F96467;D2:$78F3;D3:$11D0;D4:($A1,$8C,$00,$A0,$C9,$11,$89,$56));
  {$EXTERNALSYM CLSID_VideoStreamConfigPropertyPage}
  CLSID_AudioRendererAdvancedProperties: TGUID = (D1:$37e92a92;D2:$d9aa;D3:$11d2;D4:($bf,$84,$8e,$f2,$b1,$55,$5a,$ed));
  {$EXTERNALSYM CLSID_AudioRendererAdvancedProperties}

// -------------------------------------------------------------------------
// VMRender GUIDS DX8
// -------------------------------------------------------------------------
  CLSID_VideoMixingRenderer     : TGUID = (D1:$B87BEB7B;D2:$8D29;D3:$423f;D4:($AE,$4D,$65,$82,$C1,$01,$75,$AC));
  {$EXTERNALSYM CLSID_VideoMixingRenderer}
  CLSID_VideoRendererDefault    : TGUID = '{6BC1CFFA-8FC1-4261-AC22-CFB4CC38DB50}';
  {$EXTERNALSYM CLSID_VideoRendererDefault}
  CLSID_AllocPresenter          : TGUID = '{99d54f63-1a69-41ae-aa4d-c976eb3f0713}';
  {$EXTERNALSYM CLSID_AllocPresenter}
  CLSID_AllocPresenterDDXclMode : TGUID = '{4444ac9e-242e-471b-a3c7-45dcd46352bc}';
  {$EXTERNALSYM CLSID_AllocPresenterDDXclMode}
  CLSID_VideoPortManager        : TGUID = '{6f26a6cd-967b-47fd-874a-7aed2c9d25a2}';
  {$EXTERNALSYM CLSID_VideoPortManager}
  CLSID_ImageSynchronization    : TGUID = '{7D8AA343-6E63-4663-BE90-6B80F66540A3}';
  {$EXTERNALSYM CLSID_ImageSynchronization}
  CLSID_VideoMixer              : TGUID = '{06b32aee-77da-484b-973b-5d64f47201b0}';
  {$EXTERNALSYM CLSID_VideoMixer}
// -------------------------------------------------------------------------
// VMR GUIDS for DX9
// -------------------------------------------------------------------------

  CLSID_VideoMixingRenderer9 : TGUID = '{51b4abf3-748f-4e3b-a276-c828330e926a}';
  {$EXTERNALSYM CLSID_VideoMixingRenderer9}
  CLSID_AllocPresenter9         : TGUID = '{2D2E24CB-0CD5-458F-86EA-3E6FA22C8E64}'; // Found in Registry, Should'nt be used directly
  {$EXTERNALSYM CLSID_AllocPresenter9}
  CLSID_ImageSynchronization9   : TGUID = '{E4979309-7A32-495E-8A92-7B014AAD4961}'; // Found in Registry
  {$EXTERNALSYM CLSID_ImageSynchronization9}

// -------------------------------------------------------------------------
// BDA Network Provider GUIDS
// -------------------------------------------------------------------------
  CLSID_ATSCNetworkProvider    : TGUID = (D1:$0dad2fdd;D2:$5fd7;D3:$11d3;D4:($8f,$50,$00,$c0,$4f,$79,$71,$e2));
  {$EXTERNALSYM CLSID_ATSCNetworkProvider}
  CLSID_ATSCNetworkPropertyPage: TGUID = (D1:$e3444d16;D2:$5ac4;D3:$4386;D4:($88,$df,$13,$fd,$23,$0e,$1d,$da));
  {$EXTERNALSYM CLSID_ATSCNetworkPropertyPage}
  CLSID_DVBSNetworkProvider    : TGUID = (D1:$fa4b375a;D2:$45b4;D3:$4d45;D4:($84,$40,$26,$39,$57,$b1,$16,$23));
  {$EXTERNALSYM CLSID_DVBSNetworkProvider}
  CLSID_DVBTNetworkProvider    : TGUID = '{216C62DF-6D7F-4e9a-8571-05F14EDB766A}';
  {$EXTERNALSYM CLSID_DVBTNetworkProvider}
  CLSID_DVBCNetworkProvider    : TGUID = '{DC0C0FE7-0485-4266-B93F-68FBF80ED834}';
  {$EXTERNALSYM CLSID_DVBCNetworkProvider}


// --- WST Decoder interface GUID ---
  IID_IAMWstDecoder            : TGUID = '{C056DE21-75C2-11d3-A184-00105AEF9F33}'; // IID_IAMWstDecoder
  {$EXTERNALSYM IID_IAMWstDecoder}
// --- WST Decoder Property Page ---
  CLSID_WstDecoderPropertyPage : TGUID = '{04E27F80-91E4-11d3-A184-00105AEF9F33}'; // WST Decoder Property Page
  {$EXTERNALSYM CLSID_WstDecoderPropertyPage}

// -------------------------------------------------------------------------
// TVE Receiver filter guids
// -------------------------------------------------------------------------

// The CLSID used by the TVE Receiver filter
  CLSID_DShowTVEFilter           : TGUID = '{05500280-FAA5-4DF9-8246-BFC23AC5CEA8}';
  {$EXTERNALSYM CLSID_DShowTVEFilter}
  CLSID_TVEFilterTuneProperties  : TGUID = '{05500281-FAA5-4DF9-8246-BFC23AC5CEA8}';
  {$EXTERNALSYM CLSID_TVEFilterTuneProperties}
  CLSID_TVEFilterCCProperties    : TGUID = '{05500282-FAA5-4DF9-8246-BFC23AC5CEA8}';
  {$EXTERNALSYM CLSID_TVEFilterCCProperties}
  CLSID_TVEFilterStatsProperties : TGUID = '{05500283-FAA5-4DF9-8246-BFC23AC5CEA8}';
  {$EXTERNALSYM CLSID_TVEFilterStatsProperties}

// -------------------------------------------------------------------------
// Defined ENCAPI parameter GUIDs
// -------------------------------------------------------------------------

  // The CLSID for the original IVideoEncoder proxy plug-in
  CLSID_IVideoEncoderProxy : TGUID = '{B43C4EEC-8C32-4791-9102-508ADA5EE8E7}';
  {$EXTERNALSYM CLSID_IVideoEncoderProxy}

  // The CLSID for the ICodecAPI proxy plug-in
  CLSID_ICodecAPIProxy : TGUID = '{7ff0997a-1999-4286-a73c-622b8814e7eb}';
  {$EXTERNALSYM CLSID_ICodecAPIProxy}

  // The CLSID for the combination ICodecAPI/IVideoEncoder proxy plug-in
  CLSID_IVideoEncoderCodecAPIProxy : TGUID = '{b05dabd9-56e5-4fdc-afa4-8a47e91f1c9c}';
  {$EXTERNALSYM CLSID_IVideoEncoderCodecAPIProxy}

  ENCAPIPARAM_BITRATE      : TGUID = '{49CC4C43-CA83-4ad4-A9AF-F3696AF666DF}';
  {$EXTERNALSYM ENCAPIPARAM_BITRATE}
  ENCAPIPARAM_PEAK_BITRATE : TGUID = '{703F16A9-3D48-44a1-B077-018DFF915D19}';
  {$EXTERNALSYM ENCAPIPARAM_PEAK_BITRATE}
  ENCAPIPARAM_BITRATE_MODE : TGUID = '{EE5FB25C-C713-40d1-9D58-C0D7241E250F}';
  {$EXTERNALSYM ENCAPIPARAM_BITRATE_MODE}

  // for kernel control

  CODECAPI_CHANGELISTS       : TGUID = '{62b12acf-f6b0-47d9-9456-96f22c4e0b9d}';
  {$EXTERNALSYM CODECAPI_CHANGELISTS}
  CODECAPI_VIDEO_ENCODER     : TGUID = '{7112e8e1-3d03-47ef-8e60-03f1cf537301}';
  {$EXTERNALSYM CODECAPI_VIDEO_ENCODER}
  CODECAPI_AUDIO_ENCODER     : TGUID = '{b9d19a3e-f897-429c-bc46-8138b7272b2d}';
  {$EXTERNALSYM CODECAPI_AUDIO_ENCODER}
  CODECAPI_SETALLDEFAULTS    : TGUID = '{6c5e6a7c-acf8-4f55-a999-1a628109051b}';
  {$EXTERNALSYM CODECAPI_SETALLDEFAULTS}
  CODECAPI_ALLSETTINGS       : TGUID = '{6a577e92-83e1-4113-adc2-4fcec32f83a1}';
  {$EXTERNALSYM CODECAPI_ALLSETTINGS}
  CODECAPI_SUPPORTSEVENTS    : TGUID = '{0581af97-7693-4dbd-9dca-3f9ebd6585a1}';
  {$EXTERNALSYM CODECAPI_SUPPORTSEVENTS}
  CODECAPI_CURRENTCHANGELIST : TGUID = '{1cb14e83-7d72-4657-83fd-47a2c5b9d13d}';
  {$EXTERNALSYM CODECAPI_CURRENTCHANGELIST}

(*==========================================================================;
 *
 *  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       ksuuids.h
 *
 ***************************************************************************)
// contains the GUIDs for the MediaType type, subtype fields and format types
// for DVD/MPEG2 media types.

const
// --- MPEG 2 definitions ---
  MEDIATYPE_MPEG2_PACK: TGUID     = (D1:$36523B13;D2:$8EE5;D3:$11d1;D4:($8C,$A3,$00,$60,$B0,$57,$66,$4A));
  {$EXTERNALSYM MEDIATYPE_MPEG2_PACK}
  MEDIATYPE_MPEG2_PES: TGUID      = (D1:$e06d8020;D2:$db46;D3:$11cf;D4:($b4,$d1,$00,$80,$5f,$6c,$bb,$ea));
  {$EXTERNALSYM MEDIATYPE_MPEG2_PES}
  MEDIATYPE_CONTROL: TGUID        = (D1:$e06d8021;D2:$db46;D3:$11cf;D4:($b4,$d1,$00,$80,$5f,$6c,$bb,$ea));
  {$EXTERNALSYM MEDIATYPE_CONTROL}
  MEDIASUBTYPE_MPEG2_VIDEO: TGUID = (D1:$e06d8026;D2:$db46;D3:$11cf;D4:($b4,$d1,$00,$80,$5f,$6c,$bb,$ea));
  {$EXTERNALSYM MEDIASUBTYPE_MPEG2_VIDEO}

  MEDIATYPE_MPEG2_SECTIONS : TGUID = '{455f176c-4b06-47ce-9aef-8caef73df7b5}';
  {$EXTERNALSYM MEDIATYPE_MPEG2_SECTIONS}
  MEDIASUBTYPE_ATSC_SI     : TGUID = '{b3c7397c-d303-414d-b33c-4ed2c9d29733}';
  {$EXTERNALSYM MEDIASUBTYPE_ATSC_SI}
  MEDIASUBTYPE_DVB_SI      : TGUID = '{e9dd31a3-221d-4adb-8532-9af309c1a408}';
  {$EXTERNALSYM MEDIASUBTYPE_DVB_SI}
  MEDIASUBTYPE_MPEG2DATA   : TGUID = '{C892E55B-252D-42b5-A316-D997E7A5D995}';
  {$EXTERNALSYM MEDIASUBTYPE_MPEG2DATA}


// use MPEG2VIDEOINFO (defined below) with FORMAT_MPEG2_VIDEO
  FORMAT_MPEG2_VIDEO: TGUID = (D1:$e06d80e3;D2:$db46;D3:$11cf;D4:($b4,$d1,$00,$80,$5f,$6c,$bb,$ea));
  {$EXTERNALSYM FORMAT_MPEG2_VIDEO}

// MPEG2 Other subtypes
  MEDIASUBTYPE_MPEG2_PROGRAM: TGUID   = (D1:$e06d8022;D2:$db46;D3:$11cf;D4:($b4,$d1,$00,$80,$05f,$6c,$bb,$ea));
  {$EXTERNALSYM MEDIASUBTYPE_MPEG2_PROGRAM}
  MEDIASUBTYPE_MPEG2_TRANSPORT: TGUID = (D1:$e06d8023;D2:$db46;D3:$11cf;D4:($b4,$d1,$00,$80,$05f,$6c,$bb,$ea));
  {$EXTERNALSYM MEDIASUBTYPE_MPEG2_TRANSPORT}
  MEDIASUBTYPE_MPEG2_AUDIO: TGUID = (D1:$E06D802B;D2:$DB46;D3:$11CF;D4:($B4,$D1,$00,$80,$005F,$6C,$BB,$EA));
  {$EXTERNALSYM MEDIASUBTYPE_MPEG2_AUDIO}
  MEDIASUBTYPE_DOLBY_AC3: TGUID = (D1:$E06D802C;D2:$DB46;D3:$11CF;D4:($B4,$D1,$00,$80,$005F,$6C,$BB,$EA));
  {$EXTERNALSYM MEDIASUBTYPE_DOLBY_AC3}
  MEDIASUBTYPE_DVD_SUBPICTURE: TGUID = (D1:$E06D802D;D2:$DB46;D3:$11CF;D4:($B4,$D1,$00,$80,$005F,$6C,$BB,$EA));
  {$EXTERNALSYM MEDIASUBTYPE_DVD_SUBPICTURE}
  MEDIASUBTYPE_DVD_LPCM_AUDIO: TGUID = (D1:$E06D8032;D2:$DB46;D3:$11CF;D4:($B4,$D1,$00,$80,$005F,$6C,$BB,$EA));
  {$EXTERNALSYM MEDIASUBTYPE_DVD_LPCM_AUDIO}
  MEDIASUBTYPE_DTS: TGUID  = (D1:$e06d8033;D2:$db46;D3:$11cf;D4:($b4,$d1,$00,$80,$5f,$6c,$bb,$ea));
  {$EXTERNALSYM MEDIASUBTYPE_DTS}
  MEDIASUBTYPE_SDDS: TGUID = (D1:$e06d8034;D2:$db46;D3:$11cf;D4:($b4,$d1,$00,$80,$5f,$6c,$bb,$ea));
  {$EXTERNALSYM MEDIASUBTYPE_SDDS}

// DVD-related mediatypes
  MEDIATYPE_DVD_ENCRYPTED_PACK: TGUID = (D1:$ED0B916A;D2:$044D;D3:$11D1;D4:($AA,$78,$00,$C0,$004F,$C3,$1D,$60));
  {$EXTERNALSYM MEDIATYPE_DVD_ENCRYPTED_PACK}
  MEDIATYPE_DVD_NAVIGATION: TGUID = (D1:$E06D802E;D2:$DB46;D3:$11CF;D4:($B4,$D1,$00,$80,$005F,$6C,$BB,$EA));
  {$EXTERNALSYM MEDIATYPE_DVD_NAVIGATION}
  MEDIASUBTYPE_DVD_NAVIGATION_PCI: TGUID = (D1:$E06D802F;D2:$DB46;D3:$11CF;D4:($B4,$D1,$00,$80,$005F,$6C,$BB,$EA));
  {$EXTERNALSYM MEDIASUBTYPE_DVD_NAVIGATION_PCI}
  MEDIASUBTYPE_DVD_NAVIGATION_DSI: TGUID = (D1:$E06D8030;D2:$DB46;D3:$11CF;D4:($B4,$D1,$00,$80,$005F,$6C,$BB,$EA));
  {$EXTERNALSYM MEDIASUBTYPE_DVD_NAVIGATION_DSI}
  MEDIASUBTYPE_DVD_NAVIGATION_PROVIDER: TGUID = (D1:$E06D8031;D2:$DB46;D3:$11CF;D4:($B4,$D1,$00,$80,$005F,$6C,$BB,$EA));
  {$EXTERNALSYM MEDIASUBTYPE_DVD_NAVIGATION_PROVIDER}

//
// DVD - MPEG2/AC3-related Formats
//

  FORMAT_MPEG2Video: TGUID = (D1:$E06D80E3;D2:$DB46;D3:$11CF;D4:($B4,$D1,$00,$80,$005F,$6C,$BB,$EA));
  {$EXTERNALSYM FORMAT_MPEG2Video}
  FORMAT_DolbyAC3: TGUID = (D1:$E06D80E4;D2:$DB46;D3:$11CF;D4:($B4,$D1,$00,$80,$005F,$6C,$BB,$EA));
  {$EXTERNALSYM FORMAT_DolbyAC3}
  FORMAT_MPEG2Audio: TGUID = (D1:$E06D80E5;D2:$DB46;D3:$11CF;D4:($B4,$D1,$00,$80,$005F,$6C,$BB,$EA));
  {$EXTERNALSYM FORMAT_MPEG2Audio}
  FORMAT_DVD_LPCMAudio: TGUID = (D1:$E06D80E6;D2:$DB46;D3:$11CF;D4:($B4,$D1,$00,$80,$005F,$6C,$BB,$EA));
  {$EXTERNALSYM FORMAT_DVD_LPCMAudio}

//
// KS Property Set Id (to communicate with the WDM Proxy filter) -- from
// ksmedia.h of WDM DDK.
//

  AM_KSPROPSETID_AC3: TGUID = (D1:$BFABE720;D2:$6E1F;D3:$11D0;D4:($BC,$F2,$44,$45,$53,$54,$00,$00));
  {$EXTERNALSYM AM_KSPROPSETID_AC3}
  AM_KSPROPSETID_DvdSubPic: TGUID = (D1:$AC390460;D2:$43AF;D3:$11D0;D4:($BD,$6A,$00,$35,$05,$C1,$03,$A9));
  {$EXTERNALSYM AM_KSPROPSETID_DvdSubPic}
  AM_KSPROPSETID_CopyProt: TGUID = (D1:$0E8A0A40;D2:$6AEF;D3:$11D0;D4:($9E,$D0,$00,$A0,$24,$CA,$19,$B3));
  {$EXTERNALSYM AM_KSPROPSETID_CopyProt}
  AM_KSPROPSETID_TSRateChange: TGUID = (D1:$A503C5C0;D2:$1D1D;D3:$11D1;D4:($AD,$80,$44,$45,$53,$54,$00,$00));
  {$EXTERNALSYM AM_KSPROPSETID_TSRateChange}
  AM_KSPROPSETID_DVD_RateChange: TGUID = (D1:$3577eb09;D2:$9582;D3:$477f;D4:($b2,$9c,$b0,$c4,$52,$a4,$ff,$9a));
  {$EXTERNALSYM AM_KSPROPSETID_DVD_RateChange}
  AM_KSPROPSETID_DvdKaraoke: TGUID = (D1:$ae4720ae;D2:$aa71;D3:$42d8;D4:($b8,$2a,$ff,$fd,$f5,$8b,$76,$fd));
  {$EXTERNALSYM AM_KSPROPSETID_DvdKaraoke}
  AM_KSPROPSETID_FrameStep: TGUID = (D1:$c830acbd;D2:$ab07;D3:$492f;D4:($88,$52,$45,$b6,$98,$7c,$29,$79));
  {$EXTERNALSYM AM_KSPROPSETID_FrameStep}
//
// KS categories from ks.h and ksmedia.h
//
//

  AM_KSCATEGORY_CAPTURE: TGUID = (D1:$65E8773D;D2:$8F56;D3:$11D0;D4:($A3,$B9,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM AM_KSCATEGORY_CAPTURE}
  AM_KSCATEGORY_RENDER: TGUID = (D1:$65E8773E;D2:$8F56;D3:$11D0;D4:($A3,$B9,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM AM_KSCATEGORY_RENDER}
  AM_KSCATEGORY_DATACOMPRESSOR: TGUID = (D1:$1E84C900;D2:$7E70;D3:$11D0;D4:($A5,$D6,$28,$DB,$04,$C1,$00,$00));
  {$EXTERNALSYM AM_KSCATEGORY_DATACOMPRESSOR}
  AM_KSCATEGORY_AUDIO: TGUID = (D1:$6994AD04;D2:$93EF;D3:$11D0;D4:($A3,$CC,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM AM_KSCATEGORY_AUDIO}
  AM_KSCATEGORY_VIDEO: TGUID = (D1:$6994AD05;D2:$93EF;D3:$11D0;D4:($A3,$CC,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM AM_KSCATEGORY_VIDEO}
  AM_KSCATEGORY_TVTUNER: TGUID = (D1:$A799A800;D2:$A46D;D3:$11D0;D4:($A1,$8C,$00,$A0,$24,$01,$DC,$D4));
  {$EXTERNALSYM AM_KSCATEGORY_TVTUNER}
  AM_KSCATEGORY_CROSSBAR: TGUID = (D1:$A799A801;D2:$A46D;D3:$11D0;D4:($A1,$8C,$00,$A0,$24,$01,$DC,$D4));
  {$EXTERNALSYM AM_KSCATEGORY_CROSSBAR}
  AM_KSCATEGORY_TVAUDIO: TGUID = (D1:$A799A802;D2:$A46D;D3:$11D0;D4:($A1,$8C,$00,$A0,$24,$01,$DC,$D4));
  {$EXTERNALSYM AM_KSCATEGORY_TVAUDIO}
  AM_KSCATEGORY_VBICODEC: TGUID = (D1:$07dad660;D2:$22f1;D3:$11d1;D4:($a9,$f4,$00,$c0,$4f,$bb,$de,$8f));
  {$EXTERNALSYM AM_KSCATEGORY_VBICODEC}
  AM_KSCATEGORY_SPLITTER: TGUID = (D1:$0A4252A0;D2:$7E70;D3:$11D0;D4:($A5,$D6,$28,$DB,$04,$C1,$00,$00));
  {$EXTERNALSYM AM_KSCATEGORY_SPLITTER}

//
// guids needed to support IKsPin interface
//
//
  IID_IKsInterfaceHandler: TGUID = (D1:$D3ABC7E0;D2:$9A61;D3:$11D0;D4:($A4,$0D,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM IID_IKsInterfaceHandler}
  STATIC_IID_IKsInterfaceHandler: TGUID = (D1:$D3ABC7E0;D2:$9A61;D3:$11D0;D4:($A4,$0D,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM STATIC_IID_IKsInterfaceHandler}

  IID_IKsDataTypeHandler:  TGUID = (D1:$5FFBAA02;D2:$49A3;D3:$11D0;D4:($9F,$36,$00,$AA,$00,$A2,$16,$A1));
  {$EXTERNALSYM IID_IKsDataTypeHandler}
  STATIC_IID_IKsDataTypeHandler:  TGUID = (D1:$5FFBAA02;D2:$49A3;D3:$11D0;D4:($9F,$36,$00,$AA,$00,$A2,$16,$A1));
  {$EXTERNALSYM STATIC_IID_IKsDataTypeHandler}

  IID_IKsPin: TGUID = (D1:$B61178D1;D2:$A2D9;D3:$11CF;D4:($9E,$53,$00,$AA,$00,$A2,$16,$A1));
  {$EXTERNALSYM IID_IKsPin}
  STATIC_IID_IKsPin: TGUID = (D1:$B61178D1;D2:$A2D9;D3:$11CF;D4:($9E,$53,$00,$AA,$00,$A2,$16,$A1));
  {$EXTERNALSYM STATIC_IID_IKsPin}

  IID_IKsControl:    TGUID = (D1:$28F54685;D2:$06FD;D3:$11D2;D4:($B2,$7A,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM IID_IKsControl}
  STATIC_IID_IKsControl : TGUID = (D1:$28F54685;D2:$06FD;D3:$11D2;D4:($B2,$7A,$00,$A0,$C9,$22,$31,$96));

  {$EXTERNALSYM STATIC_IID_IKsControl}
  IID_IKsPinFactory: TGUID = (D1:$CD5EBE6B;D2:$8B6E;D3:$11D1;D4:($8A,$E0,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM IID_IKsPinFactory}
  AM_INTERFACESETID_Standard: TGUID = (D1:$1A8766A0;D2:$62CE;D3:$11CF;D4:($A5,$D6,$28,$DB,$04,$C1,$00,$00));
  {$EXTERNALSYM AM_INTERFACESETID_Standard}

//------------------------------------------------------------------------------
// File: DXVA.h
// Desc: DirectX Video Acceleration header file.
// Copyright (c) 1999 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

const
  DXVA_ModeNone     : TGUID = (D1:$1b81be00; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeNone}
  DXVA_ModeH261_A   : TGUID = (D1:$1b81be01; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeH261_A}
  DXVA_ModeH261_B   : TGUID = (D1:$1b81be02; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeH261_B}
  DXVA_ModeH263_A   : TGUID = (D1:$1b81be03; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeH263_A}
  DXVA_ModeH263_B   : TGUID = (D1:$1b81be04; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeH263_B}
  DXVA_ModeH263_C   : TGUID = (D1:$1b81be05; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeH263_C}
  DXVA_ModeH263_D   : TGUID = (D1:$1b81be06; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeH263_D}
  DXVA_ModeH263_E   : TGUID = (D1:$1b81be07; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeH263_E}
  DXVA_ModeH263_F   : TGUID = (D1:$1b81be08; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeH263_F}
  DXVA_ModeMPEG1_A  : TGUID = (D1:$1b81be09; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeMPEG1_A}
  DXVA_ModeMPEG2_A  : TGUID = (D1:$1b81be0A; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeMPEG2_A}
  DXVA_ModeMPEG2_B  : TGUID = (D1:$1b81be0B; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeMPEG2_B}
  DXVA_ModeMPEG2_C  : TGUID = (D1:$1b81be0C; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeMPEG2_C}
  DXVA_ModeMPEG2_D  : TGUID = (D1:$1b81be0D; D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeMPEG2_D}

  DXVA_ModeWMV8_A   : TGUID = (D1:$1b81be80 ;D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeWMV8_A}
  DXVA_ModeWMV8_B   : TGUID = (D1:$1b81be81 ;D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeWMV8_B}

  DXVA_ModeWMV9_A   : TGUID = (D1:$1b81be90 ;D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeWMV9_A}
  DXVA_ModeWMV9_B   : TGUID = (D1:$1b81be91 ;D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeWMV9_B}
  DXVA_ModeWMV9_Ai  : TGUID = (D1:$1b81be92 ;D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeWMV9_Ai}
  DXVA_ModeWMV9_Bi  : TGUID = (D1:$1b81be93 ;D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeWMV9_Bi}

  DXVA_ModeWMV9_C   : TGUID = (D1:$1b81be94 ;D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeWMV9_C}
  DXVA_ModeWMVA_A   : TGUID = (D1:$1b81be96 ;D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeWMVA_A}
  DXVA_ModeWMVA_B   : TGUID = (D1:$1b81be97 ;D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeWMVA_B}
  DXVA_ModeWMVA_C   : TGUID = (D1:$1b81be98 ;D2:$a0c7; D3:$11d3; D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_ModeWMVA_C}

  DXVA_NoEncrypt    : TGUID = (D1:$1b81beD0;D2:$a0c7;D3:$11d3;D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));
  {$EXTERNALSYM DXVA_NoEncrypt}
  //DXVA_EncryptProt1 : TGUID = (D1:$1b81beD1;D2:$a0c7;D3:$11d3;D4:($b9,$84,$00,$c0,$4f,$2e,$73,$c5));

  DXVA_RESTRICTED_MODE_UNRESTRICTED =       $FFFF;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_UNRESTRICTED}
  DXVA_RESTRICTED_MODE_H261_A  = 1;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_H261_A}
  DXVA_RESTRICTED_MODE_H261_B  = 2;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_H261_B}
  DXVA_RESTRICTED_MODE_H263_A  = 3;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_H263_A}
  DXVA_RESTRICTED_MODE_H263_B  = 4;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_H263_B}
  DXVA_RESTRICTED_MODE_H263_C  = 5;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_H263_C}
  DXVA_RESTRICTED_MODE_H263_D  = 6;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_H263_D}
  DXVA_RESTRICTED_MODE_H263_E  = 7;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_H263_E}
  DXVA_RESTRICTED_MODE_H263_F  = 8;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_H263_F}
  DXVA_RESTRICTED_MODE_MPEG1_A = 9;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_MPEG1_A}
  DXVA_RESTRICTED_MODE_MPEG2_A = $A;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_MPEG2_A}
  DXVA_RESTRICTED_MODE_MPEG2_B = $B;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_MPEG2_B}
  DXVA_RESTRICTED_MODE_MPEG2_C = $C;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_MPEG2_C}
  DXVA_RESTRICTED_MODE_MPEG2_D = $D;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_MPEG2_D}

  DXVA_RESTRICTED_MODE_WMV8_A  = $80;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_WMV8_A}
  DXVA_RESTRICTED_MODE_WMV8_B  = $81;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_WMV8_B}

  DXVA_RESTRICTED_MODE_WMV9_A  = $90;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_WMV9_A}
  DXVA_RESTRICTED_MODE_WMV9_B  = $91;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_WMV9_B}
  DXVA_RESTRICTED_MODE_WMV9_Ai = $92;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_WMV9_Ai}
  DXVA_RESTRICTED_MODE_WMV9_Bi = $93;
  {$EXTERNALSYM DXVA_RESTRICTED_MODE_WMV9_Bi}


  DXVA_COMPBUFFER_TYPE_THAT_IS_NOT_USED   = 0;
  {$EXTERNALSYM DXVA_COMPBUFFER_TYPE_THAT_IS_NOT_USED}
  DXVA_PICTURE_DECODE_BUFFER              = 1;
  {$EXTERNALSYM DXVA_PICTURE_DECODE_BUFFER}
  DXVA_MACROBLOCK_CONTROL_BUFFER          = 2;
  {$EXTERNALSYM DXVA_MACROBLOCK_CONTROL_BUFFER}
  DXVA_RESIDUAL_DIFFERENCE_BUFFER         = 3;
  {$EXTERNALSYM DXVA_RESIDUAL_DIFFERENCE_BUFFER}
  DXVA_DEBLOCKING_CONTROL_BUFFER          = 4;
  {$EXTERNALSYM DXVA_DEBLOCKING_CONTROL_BUFFER}
  DXVA_INVERSE_QUANTIZATION_MATRIX_BUFFER = 5;
  {$EXTERNALSYM DXVA_INVERSE_QUANTIZATION_MATRIX_BUFFER}
  DXVA_SLICE_CONTROL_BUFFER               = 6;
  {$EXTERNALSYM DXVA_SLICE_CONTROL_BUFFER}
  DXVA_BITSTREAM_DATA_BUFFER              = 7;
  {$EXTERNALSYM DXVA_BITSTREAM_DATA_BUFFER}
  DXVA_AYUV_BUFFER                        = 8;
  {$EXTERNALSYM DXVA_AYUV_BUFFER}
  DXVA_IA44_SURFACE_BUFFER                = 9;
  {$EXTERNALSYM DXVA_IA44_SURFACE_BUFFER}
  DXVA_DPXD_SURFACE_BUFFER                = 10;
  {$EXTERNALSYM DXVA_DPXD_SURFACE_BUFFER}
  DXVA_HIGHLIGHT_BUFFER                   = 11;
  {$EXTERNALSYM DXVA_HIGHLIGHT_BUFFER}
  DXVA_DCCMD_SURFACE_BUFFER               = 12;
  {$EXTERNALSYM DXVA_DCCMD_SURFACE_BUFFER}
  DXVA_ALPHA_BLEND_COMBINATION_BUFFER     = 13;
  {$EXTERNALSYM DXVA_ALPHA_BLEND_COMBINATION_BUFFER}
  DXVA_PICTURE_RESAMPLE_BUFFER            = 14;
  {$EXTERNALSYM DXVA_PICTURE_RESAMPLE_BUFFER}
  DXVA_READ_BACK_BUFFER                   = 15;
  {$EXTERNALSYM DXVA_READ_BACK_BUFFER}

  DXVA_NUM_TYPES_COMP_BUFFERS             = 16;
  {$EXTERNALSYM DXVA_NUM_TYPES_COMP_BUFFERS}

  // values for bDXVA_Func
  DXVA_PICTURE_DECODING_FUNCTION        = 1;
  {$EXTERNALSYM DXVA_PICTURE_DECODING_FUNCTION}
  DXVA_ALPHA_BLEND_DATA_LOAD_FUNCTION   = 2;
  {$EXTERNALSYM DXVA_ALPHA_BLEND_DATA_LOAD_FUNCTION}
  DXVA_ALPHA_BLEND_COMBINATION_FUNCTION = 3;
  {$EXTERNALSYM DXVA_ALPHA_BLEND_COMBINATION_FUNCTION}
  DXVA_PICTURE_RESAMPLE_FUNCTION        = 4;
  {$EXTERNALSYM DXVA_PICTURE_RESAMPLE_FUNCTION}

  // values returned from Execute command in absence of read-back
  DXVA_EXECUTE_RETURN_OK                 = 0;
  {$EXTERNALSYM DXVA_EXECUTE_RETURN_OK}
  DXVA_EXECUTE_RETURN_DATA_ERROR_MINOR   = 1;
  {$EXTERNALSYM DXVA_EXECUTE_RETURN_DATA_ERROR_MINOR}
  DXVA_EXECUTE_RETURN_DATA_ERROR_SIGNIF  = 2;
  {$EXTERNALSYM DXVA_EXECUTE_RETURN_DATA_ERROR_SIGNIF}
  DXVA_EXECUTE_RETURN_DATA_ERROR_SEVERE  = 3;
  {$EXTERNALSYM DXVA_EXECUTE_RETURN_DATA_ERROR_SEVERE}
  DXVA_EXECUTE_RETURN_OTHER_ERROR_SEVERE = 4;
  {$EXTERNALSYM DXVA_EXECUTE_RETURN_OTHER_ERROR_SEVERE}

type
  PDXVAConnectMode = ^TDXVAConnectMode;
  _DXVA_ConnectMode = record
     guidMode        : TGUID;
     wRestrictedMode : WORD;
  end;
  {$EXTERNALSYM _DXVA_ConnectMode}
  DXVA_ConnectMode = _DXVA_ConnectMode;
  {$EXTERNALSYM DXVA_ConnectMode}
  LPDXVA_ConnectMode = ^DXVA_ConnectMode;
  {$EXTERNALSYM LPDXVA_ConnectMode}
  TDXVAConnectMode = _DXVA_ConnectMode;

  DXVA_ConfigQueryOrReplyFunc = {$IFDEF TYPE_IDENTITY}type {$ENDIF} DWORD;
  {$EXTERNALSYM DXVA_ConfigQueryOrReplyFunc}
  LPDXVA_ConfigQueryOrReplyFunc = ^DXVA_ConfigQueryOrReplyFunc;
  {$EXTERNALSYM LPDXVA_ConfigQueryOrReplyFunc}

const
  DXVA_QUERYORREPLYFUNCFLAG_DECODER_PROBE_QUERY    = $FFFFF1;
  {$EXTERNALSYM DXVA_QUERYORREPLYFUNCFLAG_DECODER_PROBE_QUERY}
  DXVA_QUERYORREPLYFUNCFLAG_DECODER_LOCK_QUERY     = $FFFFF5;
  {$EXTERNALSYM DXVA_QUERYORREPLYFUNCFLAG_DECODER_LOCK_QUERY}
  DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_OK_COPY    = $FFFFF8;
  {$EXTERNALSYM DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_OK_COPY}
  DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_OK_PLUS    = $FFFFF9;
  {$EXTERNALSYM DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_OK_PLUS}
  DXVA_QUERYORREPLYFUNCFLAG_ACCEL_LOCK_OK_COPY     = $FFFFFC;
  {$EXTERNALSYM DXVA_QUERYORREPLYFUNCFLAG_ACCEL_LOCK_OK_COPY}
  DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_FALSE_PLUS = $FFFFFB;
  {$EXTERNALSYM DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_FALSE_PLUS}
  DXVA_QUERYORREPLYFUNCFLAG_ACCEL_LOCK_FALSE_PLUS  = $FFFFFF;
  {$EXTERNALSYM DXVA_QUERYORREPLYFUNCFLAG_ACCEL_LOCK_FALSE_PLUS}

{
#define readDXVA_QueryOrReplyFuncFlag(ptr)        ((*(ptr)) >> 8)
#define readDXVA_QueryOrReplyFuncFlag_ACCEL(ptr)  (((*(ptr)) >> 11) & 1)
#define readDXVA_QueryOrReplyFuncFlag_LOCK(ptr)   (((*(ptr)) >> 10) & 1)
#define readDXVA_QueryOrReplyFuncFlag_BAD(ptr)    (((*(ptr)) >>  9) & 1)
#define readDXVA_QueryOrReplyFuncFlag_PLUS(ptr)   (((*(ptr)) >>  8) & 1)
#define readDXVA_QueryOrReplyFuncFunc(ptr)        ((*(ptr)) & 0xFF)
#define writeDXVA_QueryOrReplyFunc(ptr, flg, fnc) ((*(ptr)) = ((flg) << 8) | (fnc))
#define setDXVA_QueryOrReplyFuncFlag(ptr, flg) ((*(ptr)) |= ((flg) << 8))
#define setDXVA_QueryOrReplyFuncFunc(ptr, fnc) ((*(ptr)) |= (fnc));
}

type
  DXVA_EncryptProtocolFunc = {$IFDEF TYPE_IDENTITY}type {$ENDIF} DWORD;
  {$EXTERNALSYM DXVA_EncryptProtocolFunc}
  LPDXVA_EncryptProtocolFunc = ^DXVA_EncryptProtocolFunc;
  {$EXTERNALSYM LPDXVA_EncryptProtocolFunc}

const
  DXVA_ENCRYPTPROTOCOLFUNCFLAG_HOST  = $FFFF00;
  {$EXTERNALSYM DXVA_ENCRYPTPROTOCOLFUNCFLAG_HOST}
  DXVA_ENCRYPTPROTOCOLFUNCFLAG_ACCEL = $FFFF08;
  {$EXTERNALSYM DXVA_ENCRYPTPROTOCOLFUNCFLAG_ACCEL}

{
#define readDXVA_EncryptProtocolFuncFlag(ptr)        ((*(ptr)) >> 8)
#define readDXVA_EncryptProtocolFuncFlag_ACCEL(ptr)  (((*(ptr)) >> 11) & 1)
#define readDXVA_EncryptProtocolFuncFunc(ptr)        ((*(ptr)) & 0xFF)
#define writeDXVA_EncryptProtocolFunc(ptr, flg, fnc) ((*(ptr)) = ((flg) << 8) | (fnc))
#define setDXVA_EncryptProtocolFuncFlag(ptr, flg) ((*(ptr)) |= ((flg) << 8))
#define setDXVA_EncryptProtocolFuncFunc(ptr, fnc) ((*(ptr)) |= (fnc));
}

type
  PDXVAEncryptProtocolHeader = ^TDXVAEncryptProtocolHeader;
  _DXVA_EncryptProtocolHeader = record
    dwFunction          : DXVA_EncryptProtocolFunc;
    ReservedBits        : array [0..2] of LongWord;
    guidEncryptProtocol : TGUID;
  end;
  {$EXTERNALSYM _DXVA_EncryptProtocolHeader}
  DXVA_EncryptProtocolHeader = _DXVA_EncryptProtocolHeader;
  {$EXTERNALSYM DXVA_EncryptProtocolHeader}
  LPDXVA_EncryptProtocolHeader = ^DXVA_EncryptProtocolHeader;
  {$EXTERNALSYM LPDXVA_EncryptProtocolHeader}
  TDXVAEncryptProtocolHeader = _DXVA_EncryptProtocolHeader;

  PDXVAConfigPictureDecode = ^TDXVAConfigPictureDecode;
  _DXVA_ConfigPictureDecode = record
    // Operation Indicated
    dwFunction: DXVA_ConfigQueryOrReplyFunc;
    // Alignment
    dwReservedBits : array[0..2] of DWORD;
    // Encryption GUIDs
    guidConfigBitstreamEncryption  : TGUID;
    guidConfigMBcontrolEncryption  : TGUID;
    guidConfigResidDiffEncryption  : TGUID;
    // Bitstream Processing Indicator
    bConfigBitstreamRaw            : BYTE;
    // Macroblock Control Config
    bConfigMBcontrolRasterOrder    : BYTE;
    // Host Resid Diff Config
    bConfigResidDiffHost           : BYTE;
    bConfigSpatialResid8           : BYTE;
    bConfigResid8Subtraction       : BYTE;
    bConfigSpatialHost8or9Clipping : BYTE;
    bConfigSpatialResidInterleaved : BYTE;
    bConfigIntraResidUnsigned      : BYTE;
    // Accelerator Resid Diff Config
    bConfigResidDiffAccelerator    : BYTE;
    bConfigHostInverseScan         : BYTE;
    bConfigSpecificIDCT            : BYTE;
    bConfig4GroupedCoefs           : BYTE;
  end;
  {$EXTERNALSYM _DXVA_ConfigPictureDecode}
  DXVA_ConfigPictureDecode = _DXVA_ConfigPictureDecode;
  {$EXTERNALSYM DXVA_ConfigPictureDecode}
  LPDXVA_ConfigPictureDecode = ^DXVA_ConfigPictureDecode;
  {$EXTERNALSYM LPDXVA_ConfigPictureDecode}
  TDXVAConfigPictureDecode = _DXVA_ConfigPictureDecode;

  // Picture Decoding Parameters
  PDXVAPictureParameters = ^TDXVAPictureParameters;
  _DXVA_PictureParameters = record
    wDecodedPictureIndex          : WORD;
    wDeblockedPictureIndex        : WORD;
    wForwardRefPictureIndex       : WORD;
    wBackwardRefPictureIndex      : WORD;
    wPicWidthInMBminus1           : WORD;
    wPicHeightInMBminus1          : WORD;
    bMacroblockWidthMinus1        : BYTE;
    bMacroblockHeightMinus1       : BYTE;
    bBlockWidthMinus1             : BYTE;
    bBlockHeightMinus1            : BYTE;
    bBPPminus1                    : BYTE;
    bPicStructure                 : BYTE;
    bSecondField                  : BYTE;
    bPicIntra                     : BYTE;
    bPicBackwardPrediction        : BYTE;
    bBidirectionalAveragingMode   : BYTE;
    bMVprecisionAndChromaRelation : BYTE;
    bChromaFormat                 : BYTE;
    bPicScanFixed                 : BYTE;
    bPicScanMethod                : BYTE;
    bPicReadbackRequests          : BYTE;
    bRcontrol                     : BYTE;
    bPicSpatialResid8             : BYTE;
    bPicOverflowBlocks            : BYTE;
    bPicExtrapolation             : BYTE;
    bPicDeblocked                 : BYTE;
    bPicDeblockConfined           : BYTE;
    bPic4MVallowed                : BYTE;
    bPicOBMC                      : BYTE;
    bPicBinPB                     : BYTE;
    bMV_RPS                       : BYTE;
    bReservedBits                 : BYTE;
    wBitstreamFcodes              : WORD;
    wBitstreamPCEelements         : WORD;
    bBitstreamConcealmentNeed     : BYTE;
    bBitstreamConcealmentMethod   : BYTE;
  end;
  {$EXTERNALSYM _DXVA_PictureParameters}
  DXVA_PictureParameters = _DXVA_PictureParameters;
  {$EXTERNALSYM DXVA_PictureParameters}
  LPDXVA_PictureParameters = ^DXVA_PictureParameters;
  {$EXTERNALSYM LPDXVA_PictureParameters}
  TDXVAPictureParameters = _DXVA_PictureParameters;

  // Picture Resampling
  PDXVAPicResample = ^TDXVAPicResample;
  _DXVA_PicResample = record
    wPicResampleSourcePicIndex  : WORD;
    wPicResampleDestPicIndex    : WORD;
    wPicResampleRcontrol        : WORD;
    bPicResampleExtrapWidth     : BYTE;
    bPicResampleExtrapHeight    : BYTE;
    dwPicResampleSourceWidth    : DWORD;
    dwPicResampleSourceHeight   : DWORD;
    dwPicResampleDestWidth      : DWORD;
    dwPicResampleDestHeight     : DWORD;
    dwPicResampleFullDestWidth  : DWORD;
    dwPicResampleFullDestHeight : DWORD;
  end;
  {$EXTERNALSYM _DXVA_PicResample}
  DXVA_PicResample = _DXVA_PicResample;
  {$EXTERNALSYM DXVA_PicResample}
  LPDXVA_PicResample = ^DXVA_PicResample;
  {$EXTERNALSYM LPDXVA_PicResample}
  TDXVAPicResample = _DXVA_PicResample;

const
  DXVA_CHROMA_FORMAT_420 = 1;
  {$EXTERNALSYM DXVA_CHROMA_FORMAT_420}
  DXVA_CHROMA_FORMAT_422 = 2;
  {$EXTERNALSYM DXVA_CHROMA_FORMAT_422}
  DXVA_CHROMA_FORMAT_444 = 3;
  {$EXTERNALSYM DXVA_CHROMA_FORMAT_444}

  DXVA_PICTURE_STRUCTURE_TOP_FIELD    = 1;
  {$EXTERNALSYM DXVA_PICTURE_STRUCTURE_TOP_FIELD}
  DXVA_PICTURE_STRUCTURE_BOTTOM_FIELD = 2;
  {$EXTERNALSYM DXVA_PICTURE_STRUCTURE_BOTTOM_FIELD}
  DXVA_PICTURE_STRUCTURE_FRAME        = 3;
  {$EXTERNALSYM DXVA_PICTURE_STRUCTURE_FRAME}

  DXVA_BIDIRECTIONAL_AVERAGING_MPEG2_ROUND = 0;
  {$EXTERNALSYM DXVA_BIDIRECTIONAL_AVERAGING_MPEG2_ROUND}
  DXVA_BIDIRECTIONAL_AVERAGING_H263_TRUNC  = 1;
  {$EXTERNALSYM DXVA_BIDIRECTIONAL_AVERAGING_H263_TRUNC}

  DXVA_MV_PRECISION_AND_CHROMA_RELATION_MPEG2 = 0;
  {$EXTERNALSYM DXVA_MV_PRECISION_AND_CHROMA_RELATION_MPEG2}
  DXVA_MV_PRECISION_AND_CHROMA_RELATION_H263  = 1;
  {$EXTERNALSYM DXVA_MV_PRECISION_AND_CHROMA_RELATION_H263}
  DXVA_MV_PRECISION_AND_CHROMA_RELATION_H261  = 2;
  {$EXTERNALSYM DXVA_MV_PRECISION_AND_CHROMA_RELATION_H261}

  DXVA_SCAN_METHOD_ZIG_ZAG              = 0;
  {$EXTERNALSYM DXVA_SCAN_METHOD_ZIG_ZAG}
  DXVA_SCAN_METHOD_ALTERNATE_VERTICAL   = 1;
  {$EXTERNALSYM DXVA_SCAN_METHOD_ALTERNATE_VERTICAL}
  DXVA_SCAN_METHOD_ALTERNATE_HORIZONTAL = 2;
  {$EXTERNALSYM DXVA_SCAN_METHOD_ALTERNATE_HORIZONTAL}
  DXVA_SCAN_METHOD_ARBITRARY            = 3;
  {$EXTERNALSYM DXVA_SCAN_METHOD_ARBITRARY}

  DXVA_BITSTREAM_CONCEALMENT_NEED_UNLIKELY = 0;
  {$EXTERNALSYM DXVA_BITSTREAM_CONCEALMENT_NEED_UNLIKELY}
  DXVA_BITSTREAM_CONCEALMENT_NEED_MILD     = 1;
  {$EXTERNALSYM DXVA_BITSTREAM_CONCEALMENT_NEED_MILD}
  DXVA_BITSTREAM_CONCEALMENT_NEED_LIKELY   = 2;
  {$EXTERNALSYM DXVA_BITSTREAM_CONCEALMENT_NEED_LIKELY}
  DXVA_BITSTREAM_CONCEALMENT_NEED_SEVERE   = 3;
  {$EXTERNALSYM DXVA_BITSTREAM_CONCEALMENT_NEED_SEVERE}

  DXVA_BITSTREAM_CONCEALMENT_METHOD_UNSPECIFIED = 0;
  {$EXTERNALSYM DXVA_BITSTREAM_CONCEALMENT_METHOD_UNSPECIFIED}
  DXVA_BITSTREAM_CONCEALMENT_METHOD_INTRA       = 1;
  {$EXTERNALSYM DXVA_BITSTREAM_CONCEALMENT_METHOD_INTRA}
  DXVA_BITSTREAM_CONCEALMENT_METHOD_FORWARD     = 2;
  {$EXTERNALSYM DXVA_BITSTREAM_CONCEALMENT_METHOD_FORWARD}
  DXVA_BITSTREAM_CONCEALMENT_METHOD_BACKWARD    = 3;
  {$EXTERNALSYM DXVA_BITSTREAM_CONCEALMENT_METHOD_BACKWARD}


Type
  // Buffer Description Data
  PDXVABufferDescription = ^TDXVABufferDescription;
  _DXVA_BufferDescription = record
    dwTypeIndex      : DWORD;
    dwBufferIndex    : DWORD;
    dwDataOffset     : DWORD;
    dwDataSize       : DWORD;
    dwFirstMBaddress : DWORD;
    dwNumMBsInBuffer : DWORD;
    dwWidth          : DWORD;
    dwHeight         : DWORD;
    dwStride         : DWORD;
    dwReservedBits   : DWORD;
  end;
  {$EXTERNALSYM _DXVA_BufferDescription}
  DXVA_BufferDescription = _DXVA_BufferDescription;
  {$EXTERNALSYM DXVA_BufferDescription}
  LPDXVA_BufferDescription = ^DXVA_BufferDescription;
  {$EXTERNALSYM LPDXVA_BufferDescription}
  TDXVABufferDescription = _DXVA_BufferDescription;

  // Off-Host IDCT Coefficient Data Structures
  PDXVATCoef4Group = ^TDXVATCoef4Group;
  _DXVA_TCoef4Group = record
    TCoefIDX   : array [0..3] of BYTE;
    TCoefValue : array [0..3] of smallint;
  end;
  {$EXTERNALSYM _DXVA_TCoef4Group}
  DXVA_TCoef4Group = _DXVA_TCoef4Group;
  {$EXTERNALSYM DXVA_TCoef4Group}
  LPDXVA_TCoef4Group = ^DXVA_TCoef4Group;
  {$EXTERNALSYM LPDXVA_TCoef4Group}
  TDXVATCoef4Group = _DXVA_TCoef4Group;

  PDXVATCoefSingle = ^TDXVATCoefSingle;
  _DXVA_TCoefSingle = record
    wIndexWithEOB : WORD;
    TCoefValue    : smallint;
  end;
  {$EXTERNALSYM _DXVA_TCoefSingle}
  DXVA_TCoefSingle = _DXVA_TCoefSingle;
  {$EXTERNALSYM DXVA_TCoefSingle}
  LPDXVA_TCoefSingle = ^DXVA_TCoefSingle;
  {$EXTERNALSYM LPDXVA_TCoefSingle}
  TDXVATCoefSingle = _DXVA_TCoefSingle;

// Macros for Reading EOB and Index Values
{
#define readDXVA_TCoefSingleIDX(ptr) ((ptr)->wIndexWithEOB >> 1)
#define readDXVA_TCoefSingleEOB(ptr) ((ptr)->wIndexWithEOB & 1)
}
// Macro for Writing EOB and Index Values
{
#define writeDXVA_TCoefSingleIndexWithEOB(ptr, idx, eob) ((ptr)->wIndexWithEOB = ((idx) << 1) | (eob))
#define setDXVA_TCoefSingleIDX(ptr, idx) ((ptr)->wIndexWithEOB |= ((idx) << 1))
#define setDXVA_TCoefSingleEOB(ptr)      ((ptr)->wIndexWithEOB |= 1)
}

const
  // Spatial-Domain Residual Difference Blocks
  DXVA_USUAL_BLOCK_WIDTH  = 8;
  {$EXTERNALSYM DXVA_USUAL_BLOCK_WIDTH}
  DXVA_USUAL_BLOCK_HEIGHT = 8;
  {$EXTERNALSYM DXVA_USUAL_BLOCK_HEIGHT}
  DXVA_USUAL_BLOCK_SIZE   = (DXVA_USUAL_BLOCK_WIDTH * DXVA_USUAL_BLOCK_HEIGHT);
  {$EXTERNALSYM DXVA_USUAL_BLOCK_SIZE}

type
  DXVA_Sample16 = array[0..DXVA_USUAL_BLOCK_SIZE-1] of smallint;
  {$EXTERNALSYM DXVA_Sample16}
  DXVA_Sample8  = array[0..DXVA_USUAL_BLOCK_SIZE-1] of Shortint;
  {$EXTERNALSYM DXVA_Sample8}

  // Deblocking Filter Control Structure
  DXVA_DeblockingEdgeControl = {$IFDEF TYPE_IDENTITY}type {$ENDIF} BYTE;
  {$EXTERNALSYM DXVA_DeblockingEdgeControl}
  LPDXVA_DeblockingEdgeControl= ^DXVA_DeblockingEdgeControl;
  {$EXTERNALSYM LPDXVA_DeblockingEdgeControl}

// Macros for Reading STRENGTH and FilterOn
{
#define readDXVA_EdgeFilterStrength(ptr) ((*(ptr)) >> 1)
#define readDXVA_EdgeFilterOn(ptr)       ((*(ptr)) & 1)
}
// Macro for Writing STRENGTH and FilterOn
{
#define writeDXVA_DeblockingEdgeControl(ptr, str, fon) ((*(ptr)) = ((str) << 1) | (fon))
#define setDXVA_EdgeFilterStrength(ptr, str)           ((*(ptr)) |= ((str) << 1))
#define setDXVA_EdgeFilterOn(ptr)                      ((*(ptr)) |= 1)
}

  // Macroblock Control Command Data Structures */
  PDXVAMVvalue = ^TDXVAMVvalue;
  _DXVA_MVvalue = record
    horz,vert : smallint;
   end;
  {$EXTERNALSYM _DXVA_MVvalue}
  DXVA_MVvalue = _DXVA_MVvalue;
  {$EXTERNALSYM DXVA_MVvalue}
  LPDXVA_MVvalue = ^DXVA_MVvalue;
  {$EXTERNALSYM LPDXVA_MVvalue}
  TDXVAMVvalue = _DXVA_MVvalue;

  // Inverse Quantization Matrices
  PDXVAQmatrixData = ^TDXVAQmatrixData;
  _DXVA_QmatrixData = record
    bNewQmatrix : array [0..3] of BYTE;
    // intra Y, inter Y, intra chroma, inter chroma
    Qmatrix : array [0..3,0..(DXVA_USUAL_BLOCK_WIDTH*DXVA_USUAL_BLOCK_HEIGHT)-1] of WORD;
  end;
  {$EXTERNALSYM _DXVA_QmatrixData}
  DXVA_QmatrixData = _DXVA_QmatrixData;
  {$EXTERNALSYM DXVA_QmatrixData}
  LPDXVA_QmatrixData = ^DXVA_QmatrixData;
  {$EXTERNALSYM LPDXVA_QmatrixData}
  TDXVAQmatrixData = _DXVA_QmatrixData;

  // Slice Control Buffer Data
  PDXVASliceInfo = ^TDXVASliceInfo;
  _DXVA_SliceInfo = record
    wHorizontalPosition : WORD;
    wVerticalPosition   : WORD;
    dwSliceBitsInBuffer : LongWord;
    dwSliceDataLocation : LongWord;
    bStartCodeBitOffset : BYTE;
    bReservedBits       : BYTE;
    wMBbitOffset        : WORD;
    wNumberMBsInSlice   : WORD;
    wQuantizerScaleCode : WORD;
    wBadSliceChopping   : WORD;
  end;
  {$EXTERNALSYM _DXVA_SliceInfo}
  DXVA_SliceInfo = _DXVA_SliceInfo;
  {$EXTERNALSYM DXVA_SliceInfo}
  LPDXVA_SliceInfo = ^DXVA_SliceInfo;
  {$EXTERNALSYM LPDXVA_SliceInfo}
  TDXVASliceInfo = _DXVA_SliceInfo;

const
  DXVA_NumMV_OBMC_off_BinPBwith4MV_off = 4;
  {$EXTERNALSYM DXVA_NumMV_OBMC_off_BinPBwith4MV_off}
  DXVA_NumMV_OBMC_off_BinPBwith4MV_on  = (4+1);
  {$EXTERNALSYM DXVA_NumMV_OBMC_off_BinPBwith4MV_on}
  DXVA_NumMV_OBMC_on__BinPB_off        = (10);
  {$EXTERNALSYM DXVA_NumMV_OBMC_on__BinPB_off}
  DXVA_NumMV_OBMC_on__BinPB_on         = (11); // not current standards
  {$EXTERNALSYM DXVA_NumMV_OBMC_on__BinPB_on}

  DXVA_NumBlocksPerMB_420 = (4+2+0);
  {$EXTERNALSYM DXVA_NumBlocksPerMB_420}
  DXVA_NumBlocksPerMB_422 = (4+2+2);
  {$EXTERNALSYM DXVA_NumBlocksPerMB_422}
  DXVA_NumBlocksPerMB_444 = (4+4+4);
  {$EXTERNALSYM DXVA_NumBlocksPerMB_444}

type
  // Basic form for I pictures
  // Host Residual Differences
  _DXVA_MBctrl_I_HostResidDiff_1 = record
    wMBaddress      : WORD;
    wMBtype         : WORD;
    dwMB_SNL        : LongWord;
    wPatternCode    : WORD;
    wPC_Overflow    : WORD;
    // zero if not overflow format
    dwReservedBits2 : LongWord;
  end;
  {$EXTERNALSYM _DXVA_MBctrl_I_HostResidDiff_1}
  DXVA_MBctrl_I_HostResidDiff_1 = _DXVA_MBctrl_I_HostResidDiff_1;
  {$EXTERNALSYM DXVA_MBctrl_I_HostResidDiff_1}
  TDXVAMBctrlIHostResidDiff1 = _DXVA_MBctrl_I_HostResidDiff_1;

  // Basic form for I pictures
  // Off-Host IDCT, 4:2:0 sampling
  _DXVA_MBctrl_I_OffHostIDCT_1 = record
    wMBaddress   : WORD;
    wMBtype      : WORD;
    dwMB_SNL     : LongWord;
    wPatternCode : WORD;
    bNumCoef     : array [0..DXVA_NumBlocksPerMB_420-1] of BYTE;
  end;
  {$EXTERNALSYM _DXVA_MBctrl_I_OffHostIDCT_1}
  DXVA_MBctrl_I_OffHostIDCT_1 = _DXVA_MBctrl_I_OffHostIDCT_1;
  {$EXTERNALSYM DXVA_MBctrl_I_OffHostIDCT_1}
  TDXVAMBctrlIOffHostIDCT1 = _DXVA_MBctrl_I_OffHostIDCT_1;

  // Basic form for P and B pictures
  // Should also be used for concealment MVs in MPEG-2 I pictures
  // Without OBMC, without BinPB and 4MV together, without MV RPS
  // Host Residual Differences
  _DXVA_MBctrl_P_HostResidDiff_1 = record
    wMBaddress   : WORD;
    wMBtype      : WORD;
    dwMB_SNL     : LongWord;
    wPatternCode : WORD;
    wPC_Overflow : WORD;
    // zero if not overflow format
    dwReservedBits2 : LongWord;
    MVector : array [0..DXVA_NumMV_OBMC_off_BinPBwith4MV_off-1] of TDXVAMVvalue;
  end;
  {$EXTERNALSYM _DXVA_MBctrl_P_HostResidDiff_1}
  DXVA_MBctrl_P_HostResidDiff_1 = _DXVA_MBctrl_P_HostResidDiff_1;
  {$EXTERNALSYM DXVA_MBctrl_P_HostResidDiff_1}
  TDXVAMBctrlPHostResidDiff1 = _DXVA_MBctrl_P_HostResidDiff_1;

  // Basic form for P and B pictures
  // Without OBMC, without BinPB and 4MV together, without MV RPS
  // Off-Host IDCT, 4:2:0 sampling
  _DXVA_MBctrl_P_OffHostIDCT_1 = record
    wMBaddress : WORD;
    wMBtype : WORD;
    dwMB_SNL : LongWord;
    wPatternCode : WORD;
    bNumCoef : array [0..DXVA_NumBlocksPerMB_420-1] of BYTE;
    MVector : array [0..DXVA_NumMV_OBMC_off_BinPBwith4MV_off-1] of TDXVAMVvalue;
  end;
  {$EXTERNALSYM _DXVA_MBctrl_P_OffHostIDCT_1}
  DXVA_MBctrl_P_OffHostIDCT_1 = _DXVA_MBctrl_P_OffHostIDCT_1;
  {$EXTERNALSYM DXVA_MBctrl_P_OffHostIDCT_1}
  TDXVAMBctrlPOffHostIDCT1 = _DXVA_MBctrl_P_OffHostIDCT_1;

  // How to load alpha blending graphic data
  PDXVAConfigAlphaLoad = ^TDXVAConfigAlphaLoad;
  _DXVA_ConfigAlphaLoad = record
    // Operation Indicated
    dwFunction: DXVA_ConfigQueryOrReplyFunc ;
    // Alignment
    dwReservedBits: array[0..2] of DWORD;
    bConfigDataType: BYTE;
  end;
  {$EXTERNALSYM _DXVA_ConfigAlphaLoad}
  DXVA_ConfigAlphaLoad = _DXVA_ConfigAlphaLoad;
  {$EXTERNALSYM DXVA_ConfigAlphaLoad}
  LPDXVA_ConfigAlphaLoad = ^DXVA_ConfigAlphaLoad;
  {$EXTERNALSYM LPDXVA_ConfigAlphaLoad}
  TDXVAConfigAlphaLoad = _DXVA_ConfigAlphaLoad;

const
  DXVA_CONFIG_DATA_TYPE_IA44 = 0;
  {$EXTERNALSYM DXVA_CONFIG_DATA_TYPE_IA44}
  DXVA_CONFIG_DATA_TYPE_AI44 = 1;
  {$EXTERNALSYM DXVA_CONFIG_DATA_TYPE_AI44}
  DXVA_CONFIG_DATA_TYPE_DPXD = 2;
  {$EXTERNALSYM DXVA_CONFIG_DATA_TYPE_DPXD}
  DXVA_CONFIG_DATA_TYPE_AYUV = 3;
  {$EXTERNALSYM DXVA_CONFIG_DATA_TYPE_AYUV}


// How to combine alpha blending graphic data
type
  PDXVAConfigAlphaCombine = ^TDXVAConfigAlphaCombine;
  _DXVA_ConfigAlphaCombine = record
    // Operation Indicated
    dwFunction: DXVA_ConfigQueryOrReplyFunc;
    // Alignment
    dwReservedBits: array[0..2] of DWORD;
    bConfigBlendType: BYTE;
    bConfigPictureResizing: BYTE;
    bConfigOnlyUsePicDestRectArea: BYTE;
    bConfigGraphicResizing: BYTE;
    bConfigWholePlaneAlpha: BYTE;
  end;
  {$EXTERNALSYM _DXVA_ConfigAlphaCombine}
  DXVA_ConfigAlphaCombine = _DXVA_ConfigAlphaCombine;
  {$EXTERNALSYM DXVA_ConfigAlphaCombine}
  LPDXVA_ConfigAlphaCombine = ^DXVA_ConfigAlphaCombine;
  {$EXTERNALSYM LPDXVA_ConfigAlphaCombine}
  TDXVAConfigAlphaCombine = _DXVA_ConfigAlphaCombine;

const
  DXVA_CONFIG_BLEND_TYPE_FRONT_BUFFER  = 0;
  {$EXTERNALSYM DXVA_CONFIG_BLEND_TYPE_FRONT_BUFFER}
  DXVA_CONFIG_BLEND_TYPE_BACK_HARDWARE = 1;
  {$EXTERNALSYM DXVA_CONFIG_BLEND_TYPE_BACK_HARDWARE}

// AYUV sample for 16-entry YUV palette or graphic surface
type
  PDXVAAYUVsample2 = ^TDXVAAYUVsample2;
  _DXVA_AYUVsample2 = record
    bCrValue      : BYTE;
    bCbValue      : BYTE;
    bY_Value      : BYTE;
    bSampleAlpha8 : BYTE;
  end;
  {$EXTERNALSYM _DXVA_AYUVsample2}
  DXVA_AYUVsample2 = _DXVA_AYUVsample2;
  {$EXTERNALSYM DXVA_AYUVsample2}
  LPDXVA_AYUVsample2 = ^DXVA_AYUVsample2;
  {$EXTERNALSYM LPDXVA_AYUVsample2}
  TDXVAAYUVsample2 = _DXVA_AYUVsample2;

  // Macros for IA44 alpha blending surface samples
  DXVA_AI44sample   = {$IFDEF TYPE_IDENTITY}type {$ENDIF} BYTE;
  {$EXTERNALSYM DXVA_AI44sample}
  LPDXVA_AI44sample = ^DXVA_AI44sample;
  {$EXTERNALSYM LPDXVA_AI44sample}

{
#define readDXVA_AI44index(ptr)  ((*(ptr)) & 0x0F)
#define readDXVA_AI44alpha(ptr) (((*(ptr)) & 0xF0) >> 4)
#define writeDXVA_AI44(ptr, idx, alpha) ((*(ptr)) = (((alpha) << 4) | (idx)))
#define setDXVA_AI44index(ptr, idx)    ((*(ptr)) |= (idx))
#define setDXVA_AI44alpha(ptr, alpha)  ((*(ptr)) |= ((alpha) << 4))
}

  // Highlight data structure
  PDXVAHighlight = ^TDXVAHighlight;
  _DXVA_Highlight = record
    wHighlightActive  : WORD;
    wHighlightIndices : WORD;
    wHighlightAlphas  : WORD;
    HighlightRect     : TRect;
  end;
  {$EXTERNALSYM _DXVA_Highlight}
  DXVA_Highlight = _DXVA_Highlight;
  {$EXTERNALSYM DXVA_Highlight}
  LPDXVA_Highlight = ^DXVA_Highlight;
  {$EXTERNALSYM LPDXVA_Highlight}
  TDXVAHighlight = _DXVA_Highlight;

  DXVA_DPXD = {$IFDEF TYPE_IDENTITY}type {$ENDIF} BYTE;
  {$EXTERNALSYM DXVA_DPXD}
  LPDXVA_DPXD = ^DXVA_DPXD;
  {$EXTERNALSYM LPDXVA_DPXD}
  DXVA_DCCMD = {$IFDEF TYPE_IDENTITY}type {$ENDIF} WORD;
  {$EXTERNALSYM DXVA_DCCMD}
  LPDXVA_DCCMD = ^DXVA_DCCMD;
  {$EXTERNALSYM LPDXVA_DCCMD}

  // Alpha blend combination
  PDXVABlendCombination = ^TDXVABlendCombination;
  _DXVA_BlendCombination = record
    wPictureSourceIndex      : WORD;
    wBlendedDestinationIndex : WORD;
    PictureSourceRect16thPel : TRECT;
    PictureDestinationRect   : TRECT;
    GraphicSourceRect        : TRECT;
    GraphicDestinationRect   : TRECT;
    wBlendDelay              : WORD;
    bBlendOn                 : BYTE;
    bWholePlaneAlpha         : BYTE;
    OutsideYUVcolor          : TDXVAAYUVsample2;
  end;
  {$EXTERNALSYM _DXVA_BlendCombination}
  DXVA_BlendCombination = _DXVA_BlendCombination;
  {$EXTERNALSYM DXVA_BlendCombination}
  LPDXVA_BlendCombination = ^DXVA_BlendCombination;
  {$EXTERNALSYM LPDXVA_BlendCombination}
  TDXVABlendCombination = _DXVA_BlendCombination;

  LPDXVA_MBctrl_I_HostResidDiff_1 = ^DXVA_MBctrl_I_HostResidDiff_1;
  {$EXTERNALSYM LPDXVA_MBctrl_I_HostResidDiff_1}
  LPDXVA_MBctrl_I_OffHostIDCT_1   = ^DXVA_MBctrl_I_OffHostIDCT_1;
  {$EXTERNALSYM LPDXVA_MBctrl_I_OffHostIDCT_1}
  LPDXVA_MBctrl_P_HostResidDiff_1 = ^DXVA_MBctrl_P_HostResidDiff_1;
  {$EXTERNALSYM LPDXVA_MBctrl_P_HostResidDiff_1}
  LPDXVA_MBctrl_P_OffHostIDCT_1   = ^DXVA_MBctrl_P_OffHostIDCT_1;
  {$EXTERNALSYM LPDXVA_MBctrl_P_OffHostIDCT_1}

//#pragma pack(pop)

//
// Other forms of pictures are constructed in the obvious way
// from the above by adjusting the number of residual difference
// blocks, the number of motion vectors per macroblock, etc.
//
{
#define readDXVA_MBskipsFollowing(ptr)       (((ptr)->dwMB_SNL & 0xFF000000) >> 24)
#define readDXVA_MBdataLocation(ptr)         (((ptr)->dwMB_SNL & 0x00FFFFFF))

#define writeDXVA_MB_SNL(ptr, skips, dloc)   ((ptr)->dwMB_SNL = (((skips) << 24) | (dloc)))
#define setDXVA_MBskipsFollowing(ptr, skips) ((ptr)->dwMB_SNL |= ((skips) << 24))
#define setDXVA_MBdataLocation(ptr, dloc)    ((ptr)->dwMB_SNL |= (dloc))

#define readDXVA_MvertFieldSel_3(ptr)    (((ptr)->wMBtype & 0x8000) >> 15)
#define readDXVA_MvertFieldSel_2(ptr)    (((ptr)->wMBtype & 0x4000) >> 14)
#define readDXVA_MvertFieldSel_1(ptr)    (((ptr)->wMBtype & 0x2000) >> 13)
#define readDXVA_MvertFieldSel_0(ptr)    (((ptr)->wMBtype & 0x1000) >> 12)
#define readDXVA_ReservedBits(ptr)       (((ptr)->wMBtype & 0x0800) >> 11)
#define readDXVA_HostResidDiff(ptr)      (((ptr)->wMBtype & 0x0400) >> 10)
#define readDXVA_MotionType(ptr)         (((ptr)->wMBtype & 0x0300) >>  8)
#define readDXVA_MBscanMethod(ptr)       (((ptr)->wMBtype & 0x00C0) >>  6)
#define readDXVA_FieldResidual(ptr)      (((ptr)->wMBtype & 0x0020) >>  5)
#define readDXVA_H261LoopFilter(ptr)     (((ptr)->wMBtype & 0x0010) >>  4)
#define readDXVA_Motion4MV(ptr)          (((ptr)->wMBtype & 0x0008) >>  3)
#define readDXVA_MotionBackward(ptr)     (((ptr)->wMBtype & 0x0004) >>  2)
#define readDXVA_MotionForward(ptr)      (((ptr)->wMBtype & 0x0002) >>  1)
#define readDXVA_IntraMacroblock(ptr)    (((ptr)->wMBtype & 0x0001))

#define setDXVA_MvertFieldSel_3(ptr)     ((ptr)->wMBtype |= 0x8000)
#define setDXVA_MvertFieldSel_2(ptr)     ((ptr)->wMBtype |= 0x4000)
#define setDXVA_MvertFieldSel_1(ptr)     ((ptr)->wMBtype |= 0x2000)
#define setDXVA_MvertFieldSel_0(ptr)     ((ptr)->wMBtype |= 0x1000)
#define setDXVA_ReservedBits(ptr)        ((ptr)->wMBtype |= 0x0800)
#define setDXVA_HostResidDiff(ptr)       ((ptr)->wMBtype |= 0x0400)
#define setDXVA_MotionType(ptr, value)   ((ptr)->wMBtype |= ((value) << 8))
#define setDXVA_MBscanMethod(ptr, value) ((ptr)->wMBtype |= ((value) << 6))
#define setDXVA_FieldResidual(ptr)       ((ptr)->wMBtype |= 0x0020)
#define setDXVA_H261LoopFilter(ptr)      ((ptr)->wMBtype |= 0x0010)
#define setDXVA_Motion4MV(ptr)           ((ptr)->wMBtype |= 0x0008)
#define setDXVA_MotionBackward(ptr)      ((ptr)->wMBtype |= 0x0004)
#define setDXVA_MotionForward(ptr)       ((ptr)->wMBtype |= 0x0002)
#define setDXVA_IntraMacroblock(ptr)     ((ptr)->wMBtype |= 0x0001)

#define readDXVA_Y___0coded(ptr)        (((ptr)->wPatternCode & 0x0800) >> 11)
#define readDXVA_Y___1coded(ptr)        (((ptr)->wPatternCode & 0x0400) >> 10)
#define readDXVA_Y___2coded(ptr)        (((ptr)->wPatternCode & 0x0200) >>  9)
#define readDXVA_Y___3coded(ptr)        (((ptr)->wPatternCode & 0x0100) >>  8)
#define readDXVA_Cb__4coded(ptr)        (((ptr)->wPatternCode & 0x0080) >>  7)
#define readDXVA_Cr__5coded(ptr)        (((ptr)->wPatternCode & 0x0040) >>  6)
#define readDXVA_Cb__6coded(ptr)        (((ptr)->wPatternCode & 0x0020) >>  5)
#define readDXVA_Cr__7coded(ptr)        (((ptr)->wPatternCode & 0x0010) >>  4)
#define readDXVA_Cb__8coded(ptr)        (((ptr)->wPatternCode & 0x0008) >>  3)
#define readDXVA_Cb__9coded(ptr)        (((ptr)->wPatternCode & 0x0004) >>  2)
#define readDXVA_Cr_10coded(ptr)        (((ptr)->wPatternCode & 0x0002) >>  1)
#define readDXVA_Cr_11coded(ptr)        (((ptr)->wPatternCode & 0x0001))

#define readDXVA_Y___0oflow(ptr)        (((ptr)->wPC_Overflow & 0x0800) >> 11)
#define readDXVA_Y___1oflow(ptr)        (((ptr)->wPC_Overflow & 0x0400) >> 10)
#define readDXVA_Y___2oflow(ptr)        (((ptr)->wPC_Overflow & 0x0200) >>  9)
#define readDXVA_Y___3oflow(ptr)        (((ptr)->wPC_Overflow & 0x0100) >>  8)
#define readDXVA_Cb__4oflow(ptr)        (((ptr)->wPC_Overflow & 0x0080) >>  7)
#define readDXVA_Cr__5oflow(ptr)        (((ptr)->wPC_Overflow & 0x0040) >>  6)
#define readDXVA_Cb__6oflow(ptr)        (((ptr)->wPC_Overflow & 0x0020) >>  5)
#define readDXVA_Cr__7oflow(ptr)        (((ptr)->wPC_Overflow & 0x0010) >>  4)
#define readDXVA_Cb__8oflow(ptr)        (((ptr)->wPC_Overflow & 0x0008) >>  3)
#define readDXVA_Cb__9oflow(ptr)        (((ptr)->wPC_Overflow & 0x0004) >>  2)
#define readDXVA_Cr_10oflow(ptr)        (((ptr)->wPC_Overflow & 0x0002) >>  1)
#define readDXVA_Cr_11oflow(ptr)        (((ptr)->wPC_Overflow & 0x0001))
}

// -------------------------------------------------------------------------
//
// D3DFORMAT describes a pixel memory layout, DXVA sample format contains
// additional information that describes how the pixels should be interpreted.
//
// -------------------------------------------------------------------------

//#define DXVABit(__x) (1 << __x)
const
  DXVA_SampleFormatMask = $FF;   // 8 bits used for DXVA Sample format
  {$EXTERNALSYM DXVA_SampleFormatMask}

type
  DXVA_SampleFormat = (
    DXVA_SampleUnknown,
    DXVA_SamplePreviousFrame,
    DXVA_SampleProgressiveFrame,
    DXVA_SampleFieldInterleavedEvenFirst,
    DXVA_SampleFieldInterleavedOddFirst,
    DXVA_SampleFieldSingleEven,
    DXVA_SampleFieldSingleOdd,
    DXVA_SampleSubStream
  );
  {$EXTERNALSYM DXVA_SampleFormat}
  TDXVASampleFormat = DXVA_SampleFormat;

//#define DXVA_ExtractSampleFormat(_sf) ((_sf) & (DXVA_SampleFormatMask))



//#define DXVA_ExtractExtColorData(_sf, _Mask, _Shift) \
//    (((_sf) >> (_Shift)) & (_Mask))

const

//#define DXVABitMask(__n) (~((~0) << __n))
  DXVA_ExtColorData_ShiftBase  = 8;
  {$EXTERNALSYM DXVA_ExtColorData_ShiftBase}
//#define DXVAColorMask(__bits,__base) (DXVABitMask(__bits) << ( __base - DXVA_ExtColorData_ShiftBase))

  // DXVA_VideoTransFuncShift = (DXVA_ExtColorData_ShiftBase + 19),
  DXVA_VideoTransFuncShift = (DXVA_ExtColorData_ShiftBase + 19);
  {$EXTERNALSYM DXVA_VideoTransFuncShift}
  // DXVA_VideoTransFuncMask = DXVAColorMask(5, DXVA_VideoTransFuncShift),
  DXVA_VideoTransFuncMask = (not((not 0) shl 5)) shl ( DXVA_VideoTransFuncShift - DXVA_ExtColorData_ShiftBase);
  {$EXTERNALSYM DXVA_VideoTransFuncMask}

type
  DXVA_VideoTransferFunction = (
    DXVA_VideoTransFunc_Unknown,
    DXVA_VideoTransFunc_10,
    DXVA_VideoTransFunc_18,
    DXVA_VideoTransFunc_20,
    DXVA_VideoTransFunc_22,
    DXVA_VideoTransFunc_22_709,
    DXVA_VideoTransFunc_22_240M,
    DXVA_VideoTransFunc_22_8bit_sRGB,
    DXVA_VideoTransFunc_28
  );
  {$EXTERNALSYM DXVA_VideoTransferFunction}
  TDXVAVideoTransferFunction = DXVA_VideoTransferFunction;

const


  // DXVA_VideoPrimariesShift = (DXVA_ExtColorData_ShiftBase + 14),
  DXVA_VideoPrimariesShift = (DXVA_ExtColorData_ShiftBase + 14);
  {$EXTERNALSYM DXVA_VideoPrimariesShift}
  // DXVA_VideoPrimariesMask = DXVAColorMask(5, DXVA_VideoPrimariesShift),
  DXVA_VideoPrimariesMask = (not((not 0) shl 5)) shl ( DXVA_VideoPrimariesShift - DXVA_ExtColorData_ShiftBase);
  {$EXTERNALSYM DXVA_VideoPrimariesMask}

type
  DXVA_VideoPrimaries = (
    DXVA_VideoPrimaries_Unknown,
    DXVA_VideoPrimaries_reserved,
    DXVA_VideoPrimaries_BT709,
    DXVA_VideoPrimaries_BT470_2_SysM,
    DXVA_VideoPrimaries_BT470_2_SysBG,
    DXVA_VideoPrimaries_SMPTE170M,
    DXVA_VideoPrimaries_SMPTE240M,
    DXVA_VideoPrimaries_EBU3213,
    DXVA_VideoPrimaries_SMPTE_C
  );
  {$EXTERNALSYM DXVA_VideoPrimaries}
  TDXVAVideoPrimaries = DXVA_VideoPrimaries;

const

  // DXVA_VideoLightingShift = (DXVA_ExtColorData_ShiftBase + 10),
  DXVA_VideoLightingShift = (DXVA_ExtColorData_ShiftBase + 10);
  {$EXTERNALSYM DXVA_VideoLightingShift}
  // DXVA_VideoLightingMask = DXVAColorMask(4, DXVA_VideoLightingShift),
  DXVA_VideoLightingMask = (not((not 0) shl 4)) shl ( DXVA_VideoLightingShift - DXVA_ExtColorData_ShiftBase);
  {$EXTERNALSYM DXVA_VideoLightingMask}

type
  DXVA_VideoLighting = (
    DXVA_VideoLighting_Unknown,
    DXVA_VideoLighting_bright,
    DXVA_VideoLighting_office,
    DXVA_VideoLighting_dim,
    DXVA_VideoLighting_dark
  );
  {$EXTERNALSYM DXVA_VideoLighting}
  TDXVAVideoLighting = DXVA_VideoLighting;

const
  DXVA_VideoTransferMatrixShift = (DXVA_ExtColorData_ShiftBase + 7);
  {$EXTERNALSYM DXVA_VideoTransferMatrixShift}
  DXVA_VideoTransferMatrixMask = (not((not 0) shl 3)) shl (DXVA_VideoTransferMatrixShift - DXVA_ExtColorData_ShiftBase);
  {$EXTERNALSYM DXVA_VideoTransferMatrixMask}

type
  DXVA_VideoTransferMatrix = (
    DXVA_VideoTransferMatrix_Unknown,
    DXVA_VideoTransferMatrix_BT709,
    DXVA_VideoTransferMatrix_BT601,
    DXVA_VideoTransferMatrix_SMPTE240M
  );
  {$EXTERNALSYM DXVA_VideoTransferMatrix}
  TDXVAVideoTransferMatrix = DXVA_VideoTransferMatrix;

const
  DXVA_NominalRangeShift = (DXVA_ExtColorData_ShiftBase + 4);
  {$EXTERNALSYM DXVA_NominalRangeShift}
  DXVA_NominalRangeMask = (not((not 0) shl 3)) shl (DXVA_NominalRangeShift - DXVA_ExtColorData_ShiftBase);
  {$EXTERNALSYM DXVA_NominalRangeMask}

type
  DXVA_NominalRange = (
    DXVA_NominalRange_Unknown,
    DXVA_NominalRange_Normal,
    DXVA_NominalRange_Wide
  );
  {$EXTERNALSYM DXVA_NominalRange}
  TDXVANominalRange = DXVA_NominalRange;

  DXVA_VideoChromaSubsampling = LongWord;
  {$EXTERNALSYM DXVA_VideoChromaSubsampling}
const
  DXVA_VideoChromaSubsamplingShift = (DXVA_ExtColorData_ShiftBase + 0);
  {$EXTERNALSYM DXVA_VideoChromaSubsamplingShift}
  DXVA_VideoChromaSubsamplingMask = (not((not 0) shl 4)) shl (DXVA_VideoChromaSubsamplingShift - DXVA_ExtColorData_ShiftBase);
  {$EXTERNALSYM DXVA_VideoChromaSubsamplingMask}
  DXVA_VideoChromaSubsampling_Unknown = 0;
  {$EXTERNALSYM DXVA_VideoChromaSubsampling_Unknown}
  DXVA_VideoChromaSubsampling_ProgressiveChroma = $8;
  {$EXTERNALSYM DXVA_VideoChromaSubsampling_ProgressiveChroma}
  DXVA_VideoChromaSubsampling_Horizontally_Cosited = $4;
  {$EXTERNALSYM DXVA_VideoChromaSubsampling_Horizontally_Cosited}
  DXVA_VideoChromaSubsampling_Vertically_Cosited = $2;
  {$EXTERNALSYM DXVA_VideoChromaSubsampling_Vertically_Cosited}
  DXVA_VideoChromaSubsampling_Vertically_AlignedChromaPlanes = $1;
  {$EXTERNALSYM DXVA_VideoChromaSubsampling_Vertically_AlignedChromaPlanes}

//typedef struct _DXVA_ExtendedFormat
//{
//    UINT                        SampleFormat : 8;           // See DXVA_SampleFormat
//    UINT                        VideoChromaSubsampling : 4; // See DXVA_VideoChromaSubSampling
//    DXVA_NominalRange           NominalRange : 3;           // See DXVA_NominalRange
//    DXVA_VideoTransferMatrix    VideoTransferMatrix : 3;    // See DXVA_VideoTransferMatrix
//    DXVA_VideoLighting          VideoLighting : 4;          // See DXVA_VideoLighting
//    DXVA_VideoPrimaries         VideoPrimaries : 5;         // See DXVA_VideoPrimaries
//    DXVA_VideoTransferFunction  VideoTransferFunction : 5;  // See DXVA_VideoTransferFunction
//} DXVA_ExtendedFormat;


// -------------------------------------------------------------------------
//
// The definitions that follow describe the video de-interlace interface
// between the VMR and the graphics device driver.  This interface is not
// accessable via the IAMVideoAccelerator interface.
//
// -------------------------------------------------------------------------
//
const
  DXVA_DeinterlaceBobDevice       : TGUID = '{335aa36e-7884-43a4-9c91-7f87faf3e37e}';
  {$EXTERNALSYM DXVA_DeinterlaceBobDevice}
  DXVA_DeinterlaceContainerDevice : TGUID = '{0e85cb93-3046-4ff0-aecc-d58cb5f035fd}';
  {$EXTERNALSYM DXVA_DeinterlaceContainerDevice}

type
  _DXVA_Frequency = record
    Numerator   : DWORD;
    Denominator : DWORD;
  end;
  {$EXTERNALSYM _DXVA_Frequency}
  DXVA_Frequency = _DXVA_Frequency;
  {$EXTERNALSYM DXVA_Frequency}
  TDXVAFrequency = _DXVA_Frequency;

  PDXVAVideoDesc = ^TDXVAVideoDesc;
  _DXVA_VideoDesc = record
    Size            : DWORD;
    SampleWidth     : DWORD;
    SampleHeight    : DWORD;
    SampleFormat    : DWORD; // also contains extend color data
    d3dFormat       : TD3DFORMAT;
    InputSampleFreq : TDXVAFrequency;
    OutputFrameFreq : TDXVAFrequency;
  end;
  {$EXTERNALSYM _DXVA_VideoDesc}
  DXVA_VideoDesc = _DXVA_VideoDesc;
  {$EXTERNALSYM DXVA_VideoDesc}
  LPDXVA_VideoDesc = ^DXVA_VideoDesc;
  {$EXTERNALSYM LPDXVA_VideoDesc}
  TDXVAVideoDesc = _DXVA_VideoDesc;

  DXVA_VideoProcessCaps = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM DXVA_VideoProcessCaps}
const
  DXVA_VideoProcess_None       = $0000;
  {$EXTERNALSYM DXVA_VideoProcess_None}
  DXVA_VideoProcess_YUV2RGB    = $0001;
  {$EXTERNALSYM DXVA_VideoProcess_YUV2RGB}
  DXVA_VideoProcess_StretchX   = $0002;
  {$EXTERNALSYM DXVA_VideoProcess_StretchX}
  DXVA_VideoProcess_StretchY   = $0004;
  {$EXTERNALSYM DXVA_VideoProcess_StretchY}
  DXVA_VideoProcess_AlphaBlend = $0008;
  {$EXTERNALSYM DXVA_VideoProcess_AlphaBlend}
  DXVA_VideoProcess_SubRects   = $0010;
  {$EXTERNALSYM DXVA_VideoProcess_SubRects}
  DXVA_VideoProcess_SubStreams            = $0020;
  {$EXTERNALSYM DXVA_VideoProcess_SubStreams}
  DXVA_VideoProcess_SubStreamsExtended    = $0040;
  {$EXTERNALSYM DXVA_VideoProcess_SubStreamsExtended}
  DXVA_VideoProcess_YUV2RGBExtended       = $0080;
  {$EXTERNALSYM DXVA_VideoProcess_YUV2RGBExtended}
  DXVA_VideoProcess_AlphaBlendExtended    = $0100;
  {$EXTERNALSYM DXVA_VideoProcess_AlphaBlendExtended}

type
  DXVA_DeinterlaceTech = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM DXVA_DeinterlaceTech}
  const
    // the algorithm is unknown or proprietary
    DXVA_DeinterlaceTech_Unknown                = $0000;
    {$EXTERNALSYM DXVA_DeinterlaceTech_Unknown}

    // the algorithm creates the missing lines by repeating
    // the line either above or below it - this method will look very jaggy and
    // isn't recommended
    DXVA_DeinterlaceTech_BOBLineReplicate       = $0001;
    {$EXTERNALSYM DXVA_DeinterlaceTech_BOBLineReplicate}

    // The algorithm creates the missing lines by vertically stretching each
    // video field by a factor of two by averaging two lines
    DXVA_DeinterlaceTech_BOBVerticalStretch     = $0002;
    {$EXTERNALSYM DXVA_DeinterlaceTech_BOBVerticalStretch}

    // or using a [-1, 9, 9, -1]/16 filter across four lines.
    DXVA_DeinterlaceTech_BOBVerticalStretch4Tap = $0100;
    {$EXTERNALSYM DXVA_DeinterlaceTech_BOBVerticalStretch4Tap}

    // the pixels in the missing line are recreated by a median filtering operation
    DXVA_DeinterlaceTech_MedianFiltering        = $0004;
    {$EXTERNALSYM DXVA_DeinterlaceTech_MedianFiltering}

    // the pixels in the missing line are recreated by an edge filter.
    // In this process, spatial directional filters are applied to determine
    // the orientation of edges in the picture content, and missing
    // pixels are created by filtering along (rather than across) the
    // detected edges.
    DXVA_DeinterlaceTech_EdgeFiltering          = $0010;
    {$EXTERNALSYM DXVA_DeinterlaceTech_EdgeFiltering}

    // the pixels in the missing line are recreated by switching on a field by
    // field basis between using either spatial or temporal interpolation
    // depending on the amount of motion.
    DXVA_DeinterlaceTech_FieldAdaptive          = $0020;
    {$EXTERNALSYM DXVA_DeinterlaceTech_FieldAdaptive}

    // the pixels in the missing line are recreated by switching on a pixel by pixel
    // basis between using either spatial or temporal interpolation depending on
    // the amount of motion..
    DXVA_DeinterlaceTech_PixelAdaptive          = $0040;
    {$EXTERNALSYM DXVA_DeinterlaceTech_PixelAdaptive}

    // Motion Vector Steering  identifies objects within a sequence of video
    // fields.  The missing pixels are recreated after first aligning the
    // movement axes of the individual objects in the scene to make them
    // parallel with the time axis.
    DXVA_DeinterlaceTech_MotionVectorSteered    = $0080;
    {$EXTERNALSYM DXVA_DeinterlaceTech_MotionVectorSteered}

type
  PDXVAVideoSample = ^TDXVAVideoSample;
  _DXVA_VideoSample = record
   rtStart         : TReferenceTime;
   rtEnd           : TReferenceTime;
   SampleFormat    : TDXVASampleFormat; // only lower 8 bits used
   lpDDSSrcSurface : Pointer;
  end;
  {$EXTERNALSYM _DXVA_VideoSample}
  DXVA_VideoSample = _DXVA_VideoSample;
  {$EXTERNALSYM DXVA_VideoSample}
  LPDXVA_VideoSample = ^DXVA_VideoSample;
  {$EXTERNALSYM LPDXVA_VideoSample}
  TDXVAVideoSample = _DXVA_VideoSample;


// -------------------------------------------------------------------------
// DeinterlaceBltEx declarations
// -------------------------------------------------------------------------
//
type
  DXVA_SampleFlags = LongWord;
  {$EXTERNALSYM DXVA_SampleFlags}
const
  DXVA_SampleFlagsMask = (1 shl 3) or (1 shl 2) or (1 shl 1) or (1 shl 0);
  {$EXTERNALSYM DXVA_SampleFlagsMask}
  DXVA_SampleFlag_Palette_Changed   = $0001;
  {$EXTERNALSYM DXVA_SampleFlag_Palette_Changed}
  DXVA_SampleFlag_SrcRect_Changed   = $0002;
  {$EXTERNALSYM DXVA_SampleFlag_SrcRect_Changed}
  DXVA_SampleFlag_DstRect_Changed   = $0004;
  {$EXTERNALSYM DXVA_SampleFlag_DstRect_Changed}
  DXVA_SampleFlag_ColorData_Changed = $0008;
  {$EXTERNALSYM DXVA_SampleFlag_ColorData_Changed}

type
  DXVA_DestinationFlags = LongWord;
const
  DXVA_DestinationFlagMask = (1 shl 3) or (1 shl 2) or (1 shl 1) or (1 shl 0);
  {$EXTERNALSYM DXVA_DestinationFlagMask}
  DXVA_DestinationFlag_Background_Changed = $0001;
  {$EXTERNALSYM DXVA_DestinationFlag_Background_Changed}
  DXVA_DestinationFlag_TargetRect_Changed = $0002;
  {$EXTERNALSYM DXVA_DestinationFlag_TargetRect_Changed}
  DXVA_DestinationFlag_ColorData_Changed  = $0004;
  {$EXTERNALSYM DXVA_DestinationFlag_ColorData_Changed}
  DXVA_DestinationFlag_Alpha_Changed      = $0008;
  {$EXTERNALSYM DXVA_DestinationFlag_Alpha_Changed}

type
  PDXVAVideoSample2 = ^TDXVAVideoSample2;
  DXVA_VideoSample2 = record
    rtStart: REFERENCE_TIME;
    rtEnd: REFERENCE_TIME;
    SampleFormat: DWORD; // cast to DXVA_ExtendedFormat, or use Extract macros
    SampleFlags: DWORD;
    lpDDSSrcSurface: Pointer;
    rcSrc: TRect;
    rcDst: TRect;
    Palette: array[0..15] of TDXVAAYUVsample2;
  end;
  {$EXTERNALSYM DXVA_VideoSample2}
  LPDXVA_VideoSample2 = ^DXVA_VideoSample2;
  {$EXTERNALSYM LPDXVA_VideoSample2}
  TDXVAVideoSample2 = DXVA_VideoSample2;

  PDXVADeinterlaceCaps = ^TDXVADeinterlaceCaps;
  _DXVA_DeinterlaceCaps = record
     Size                    : DWORD;
     NumPreviousOutputFrames : DWORD;
     InputPool               : DWORD;
     NumForwardRefSamples    : DWORD;
     NumBackwardRefSamples   : DWORD;
     d3dOutputFormat         : TD3DFORMAT;
     VideoProcessingCaps     : DXVA_VideoProcessCaps;
     DeinterlaceTechnology   : DXVA_DeinterlaceTech;
  end;
  {$EXTERNALSYM _DXVA_DeinterlaceCaps}
  DXVA_DeinterlaceCaps = _DXVA_DeinterlaceCaps;
  {$EXTERNALSYM DXVA_DeinterlaceCaps}
  LPDXVA_DeinterlaceCaps = ^DXVA_DeinterlaceCaps;
  {$EXTERNALSYM LPDXVA_DeinterlaceCaps}
  TDXVADeinterlaceCaps = _DXVA_DeinterlaceCaps;


// -------------------------------------------------------------------------
// Data types used with RenderMoComp in kernel mode
// -------------------------------------------------------------------------

const
  // Function codes for RenderMoComp
  MAX_DEINTERLACE_SURFACES = 32;
  {$EXTERNALSYM MAX_DEINTERLACE_SURFACES}

type
  PDXVADeinterlaceBlt = ^TDXVADeinterlaceBlt;
  _DXVA_DeinterlaceBlt = record
    Size              : DWORD;
    Reserved          : DWORD;
    rtTarget          : TReferenceTime;
    DstRect           : TRECT;
    SrcRect           : TRECT;
    NumSourceSurfaces : DWORD;
    Alpha             : Single;
    Source: array[0..MAX_DEINTERLACE_SURFACES-1] of TDXVAVideoSample;
  end;
  {$EXTERNALSYM _DXVA_DeinterlaceBlt}
  DXVA_DeinterlaceBlt = _DXVA_DeinterlaceBlt;
  {$EXTERNALSYM DXVA_DeinterlaceBlt}
  TDXVADeinterlaceBlt = _DXVA_DeinterlaceBlt;

const
  DXVA_DeinterlaceBltFnCode = $01;
  {$EXTERNALSYM DXVA_DeinterlaceBltFnCode}
  // lpInput => DXVA_DeinterlaceBlt*
  // lpOuput => NULL /* not currently used */

type  
  DXVA_DeinterlaceBltEx = record
    Size: DWORD;
    BackgroundColor   : DXVA_AYUVsample2;
    rcTarget          : TRect;
    rtTarget          : REFERENCE_TIME;
    NumSourceSurfaces : DWORD;
    Alpha             : Single;
    Source            : array[0..MAX_DEINTERLACE_SURFACES-1] of DXVA_VideoSample2;
    DestinationFormat : DWORD;
    DestinationFlags  : DWORD;
  end;
  {$EXTERNALSYM DXVA_DeinterlaceBltEx}

const
  DXVA_DeinterlaceBltExFnCode = $02;
  {$EXTERNALSYM DXVA_DeinterlaceBltExFnCode}
// lpInput => DXVA_DeinterlaceBltEx*
// lpOuput => NULL /* not currently used */


  MAX_DEINTERLACE_DEVICE_GUIDS = 32;
  {$EXTERNALSYM MAX_DEINTERLACE_DEVICE_GUIDS}

type
  PDXVADeinterlaceQueryAvailableModes = ^TDXVADeinterlaceQueryAvailableModes;
  _DXVA_DeinterlaceQueryAvailableModes = record
    Size     : DWORD;
    NumGuids : DWORD;
    Guids: array[0..MAX_DEINTERLACE_DEVICE_GUIDS-1] of TGUID;
  end;
  {$EXTERNALSYM _DXVA_DeinterlaceQueryAvailableModes}
  DXVA_DeinterlaceQueryAvailableModes = _DXVA_DeinterlaceQueryAvailableModes;
  {$EXTERNALSYM DXVA_DeinterlaceQueryAvailableModes}
  TDXVADeinterlaceQueryAvailableModes = _DXVA_DeinterlaceQueryAvailableModes;

const
  TDXVA_DeinterlaceQueryAvailableModesFnCode = $01;
  {$EXTERNALSYM TDXVA_DeinterlaceQueryAvailableModesFnCode}
  // lpInput => DXVA_VideoDesc*
  // lpOuput => DXVA_DeinterlaceQueryAvailableModes*

type
  PDXVADeinterlaceQueryModeCaps = ^TDXVADeinterlaceQueryModeCaps;
  _DXVA_DeinterlaceQueryModeCaps = record
    Size      : DWORD;
    Guid      : TGUID;
    VideoDesc : TDXVAVideoDesc;
  end;
  {$EXTERNALSYM _DXVA_DeinterlaceQueryModeCaps}
  DXVA_DeinterlaceQueryModeCaps = _DXVA_DeinterlaceQueryModeCaps;
  {$EXTERNALSYM DXVA_DeinterlaceQueryModeCaps}
  TDXVADeinterlaceQueryModeCaps = _DXVA_DeinterlaceQueryModeCaps;

const
  DXVA_DeinterlaceQueryModeCapsFnCode = $02;
  {$EXTERNALSYM DXVA_DeinterlaceQueryModeCapsFnCode}
  // lpInput => DXVA_DeinterlaceQueryModeCaps*
  // lpOuput => DXVA_DeinterlaceCaps*

// -------------------------------------------------------------------------
//
// The definitions that follow describe the video ProcAmp interface
// between the VMR and the graphics device driver.  This interface is not
// accessable via the IAMVideoAccelerator interface.
//
// -------------------------------------------------------------------------
//
const
  DXVA_ProcAmpControlDevice : TGUID = '{9f200913-2ffd-4056-9f1e-e1b508f22dcf}';
  {$EXTERNALSYM DXVA_ProcAmpControlDevice}

type
  DXVA_ProcAmpControlProp = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM DXVA_ProcAmpControlProp}
  const
    DXVA_ProcAmp_None       = $0000;
    {$EXTERNALSYM DXVA_ProcAmp_None}
    DXVA_ProcAmp_Brightness = $0001;
    {$EXTERNALSYM DXVA_ProcAmp_Brightness}
    DXVA_ProcAmp_Contrast   = $0002;
    {$EXTERNALSYM DXVA_ProcAmp_Contrast}
    DXVA_ProcAmp_Hue        = $0004;
    {$EXTERNALSYM DXVA_ProcAmp_Hue}
    DXVA_ProcAmp_Saturation = $0008;
    {$EXTERNALSYM DXVA_ProcAmp_Saturation}

type
  PDXVAProcAmpControlCaps = ^TDXVAProcAmpControlCaps;
  _DXVA_ProcAmpControlCaps = record
    Size                : DWORD;
    InputPool           : DWORD;
    d3dOutputFormat     : TD3DFORMAT;
    ProcAmpControlProps : DWORD; // see DXVA_ProcAmpControlProp
    VideoProcessingCaps : DWORD; // see DXVA_VideoProcessCaps
  end;
  {$EXTERNALSYM _DXVA_ProcAmpControlCaps}
  DXVA_ProcAmpControlCaps = _DXVA_ProcAmpControlCaps;
  {$EXTERNALSYM DXVA_ProcAmpControlCaps}
  LPDXVA_ProcAmpControlCaps = ^DXVA_ProcAmpControlCaps;
  {$EXTERNALSYM LPDXVA_ProcAmpControlCaps}
  TDXVAProcAmpControlCaps = _DXVA_ProcAmpControlCaps;

const
  DXVA_ProcAmpControlQueryCapsFnCode = $03;
  {$EXTERNALSYM DXVA_ProcAmpControlQueryCapsFnCode}
  // lpInput => DXVA_VideoDesc*
  // lpOuput => DXVA_ProcAmpControlCaps*

type
  PDXVAProcAmpControlQueryRange = ^TDXVAProcAmpControlQueryRange;
  _DXVA_ProcAmpControlQueryRange = record
    Size               : DWORD;
    ProcAmpControlProp : DXVA_ProcAmpControlProp;
    VideoDesc          : TDXVAVideoDesc;
  end;
  {$EXTERNALSYM _DXVA_ProcAmpControlQueryRange}
  DXVA_ProcAmpControlQueryRange = _DXVA_ProcAmpControlQueryRange;
  {$EXTERNALSYM DXVA_ProcAmpControlQueryRange}
  LPDXVA_ProcAmpControlQueryRange = ^DXVA_ProcAmpControlQueryRange;
  {$EXTERNALSYM LPDXVA_ProcAmpControlQueryRange}
  TDXVAProcAmpControlQueryRange = _DXVA_ProcAmpControlQueryRange;

  PDXVAVideoPropertyRange = ^TDXVAVideoPropertyRange;
  _DXVA_VideoPropertyRange = record
    MinValue     : Single;
    MaxValue     : Single;
    DefaultValue : Single;
    StepSize     : Single;
  end;
  {$EXTERNALSYM _DXVA_VideoPropertyRange}
  DXVA_VideoPropertyRange = _DXVA_VideoPropertyRange;
  {$EXTERNALSYM DXVA_VideoPropertyRange}
  LPDXVA_VideoPropertyRange = ^DXVA_VideoPropertyRange;
  {$EXTERNALSYM LPDXVA_VideoPropertyRange}
  TDXVAVideoPropertyRange = _DXVA_VideoPropertyRange;

const
  DXVA_ProcAmpControlQueryRangeFnCode = $04;
  {$EXTERNALSYM DXVA_ProcAmpControlQueryRangeFnCode}
  // lpInput => DXVA_ProcAmpControlQueryRange*
  // lpOuput => DXVA_VideoPropertyRange*

type
  PDXVAProcAmpControlBlt = ^TDXVAProcAmpControlBlt;
  _DXVA_ProcAmpControlBlt = record
    Size       : DWORD;
    DstRect    : TRECT;
    SrcRect    : TRECT;
    Alpha      : Single;
    Brightness : Single;
    Contrast   : Single;
    Hue        : Single;
    Saturation : Single;
  end;
  {$EXTERNALSYM _DXVA_ProcAmpControlBlt}
  DXVA_ProcAmpControlBlt = _DXVA_ProcAmpControlBlt;
  {$EXTERNALSYM DXVA_ProcAmpControlBlt}
  TDXVAProcAmpControlBlt = _DXVA_ProcAmpControlBlt;

const
  DXVA_ProcAmpControlBltFnCode = $01;
  {$EXTERNALSYM DXVA_ProcAmpControlBltFnCode}
  // lpInput => DXVA_ProcAmpControlBlt*
  // lpOuput => NULL /* not currently used */

// -------------------------------------------------------------------------
//
// The definitions that follow describe the Certified Output Protection
// Protocol between the VMR and the graphics device driver.  This interface
// is not accessable via the IAMVideoAccelerator interface.
//
// -------------------------------------------------------------------------
//

const
  DXVA_COPPDevice : TGUID = '{D2457ADD-8999-45ED-8A8A-D1AA047BA4D5}';
  {$EXTERNALSYM DXVA_COPPDevice}


// -------------------------------------------------------------------------
// COPPGetCertificateLength
// -------------------------------------------------------------------------
  DXVA_COPPGetCertificateLengthFnCode = $01;
  {$EXTERNALSYM DXVA_COPPGetCertificateLengthFnCode}
// lpInput => NULL
// lpOuput => DWORD*


// -------------------------------------------------------------------------
// COPPKeyExchange
// -------------------------------------------------------------------------
  DXVA_COPPKeyExchangeFnCode = $02;
  {$EXTERNALSYM DXVA_COPPKeyExchangeFnCode}
// lpInputData => NULL
// lpOuputData => GUID*


// -------------------------------------------------------------------------
// COPPSequenceStart
// -------------------------------------------------------------------------
type
  PDXVACOPPSignature = ^TDXVACOPPSignature;
  DXVA_COPPSignature = record
    Signature: array[0..255] of Char;
  end;
  {$EXTERNALSYM DXVA_COPPSignature}
  LPDXVA_COPPSignature = ^DXVA_COPPSignature;
  {$EXTERNALSYM LPDXVA_COPPSignature}
  TDXVACOPPSignature = DXVA_COPPSignature;

const  
  DXVA_COPPSequenceStartFnCode = $03;
  {$EXTERNALSYM DXVA_COPPSequenceStartFnCode}
// lpInputData => DXVA_COPPSignature*
// lpOuputData => NULL



// -------------------------------------------------------------------------
// COPPCommand
// -------------------------------------------------------------------------
type
  PDXVACOPPCommand = ^TDXVACOPPCommand;
  DXVA_COPPCommand = packed record
    macKDI: TGUID;                //   16 bytes
    guidCommandID: TGUID;         //   16 bytes
    dwSequence: ULONG;            //    4 bytes
    cbSizeData: ULONG;            //    4 bytes
    CommandData: array[0..4055] of Char;  // 4056 bytes (4056+4+4+16+16 = 4096)
  end;
  {$EXTERNALSYM DXVA_COPPCommand}
  LPDXVA_COPPCommand = ^DXVA_COPPCommand;
  {$EXTERNALSYM LPDXVA_COPPCommand}
  TDXVACOPPCommand = DXVA_COPPCommand;

const
  DXVA_COPPCommandFnCode = $04;
  {$EXTERNALSYM DXVA_COPPCommandFnCode}
// lpInputData => DXVA_COPPCommand*
// lpOuputData => NULL

  DXVA_COPPSetProtectionLevel : TGUID = '{9bb9327c-4eb5-4727-9f00-b42b0919c0da}';
  {$EXTERNALSYM DXVA_COPPSetProtectionLevel}

type
  PDXVACOPPSetProtectionLevelCmdData = ^TDXVACOPPSetProtectionLevelCmdData;
  DXVA_COPPSetProtectionLevelCmdData = packed record
    ProtType: ULONG;
    ProtLevel: ULONG;
    ExtendedInfoChangeMask: ULONG;
    ExtendedInfoData: ULONG;
  end;
  {$EXTERNALSYM DXVA_COPPSetProtectionLevelCmdData}
  TDXVACOPPSetProtectionLevelCmdData = DXVA_COPPSetProtectionLevelCmdData;


// Set the HDCP protection level - (0 - 1 DWORD, 4 bytes)

  COPP_HDCP_Protection_Level = LongWord;
  {$EXTERNALSYM COPP_HDCP_Protection_Level}
const
  COPP_HDCP_Level0    = 0;
  {$EXTERNALSYM COPP_HDCP_Level0}
  COPP_HDCP_LevelMin  = COPP_HDCP_Level0;
  {$EXTERNALSYM COPP_HDCP_LevelMin}
  COPP_HDCP_Level1    = 1;
  {$EXTERNALSYM COPP_HDCP_Level1}
  COPP_HDCP_LevelMax  = COPP_HDCP_Level1;
  {$EXTERNALSYM COPP_HDCP_LevelMax}
  COPP_HDCP_ForceDWORD = $7fffffff;
  {$EXTERNALSYM COPP_HDCP_ForceDWORD}

type
  COPP_CGMSA_Protection_Level = LongWord;
  {$EXTERNALSYM COPP_CGMSA_Protection_Level}
const
  COPP_CGMSA_Disabled = 0;
  {$EXTERNALSYM COPP_CGMSA_Disabled}
  COPP_CGMSA_LevelMin = COPP_CGMSA_Disabled;
  {$EXTERNALSYM COPP_CGMSA_LevelMin}
  COPP_CGMSA_CopyFreely = 1;
  {$EXTERNALSYM COPP_CGMSA_CopyFreely}
  COPP_CGMSA_CopyNoMore = 2;
  {$EXTERNALSYM COPP_CGMSA_CopyNoMore}
  COPP_CGMSA_CopyOneGeneration = 3;
  {$EXTERNALSYM COPP_CGMSA_CopyOneGeneration}
  COPP_CGMSA_CopyNever = 4;
  {$EXTERNALSYM COPP_CGMSA_CopyNever}
  COPP_CGMSA_RedistributionControlRequired = $08;
  {$EXTERNALSYM COPP_CGMSA_RedistributionControlRequired}
  COPP_CGMSA_LevelMax = (COPP_CGMSA_RedistributionControlRequired + COPP_CGMSA_CopyNever);
  {$EXTERNALSYM COPP_CGMSA_LevelMax}
  COPP_CGMSA_ForceDWORD = $7fffffff;
  {$EXTERNALSYM COPP_CGMSA_ForceDWORD}

type
  COPP_ACP_Protection_Level = LongWord;
  {$EXTERNALSYM COPP_ACP_Protection_Level}
const
  COPP_ACP_Level0     = 0;
  {$EXTERNALSYM COPP_ACP_Level0}
  COPP_ACP_LevelMin   = COPP_ACP_Level0;
  {$EXTERNALSYM COPP_ACP_LevelMin}
  COPP_ACP_Level1     = 1;
  {$EXTERNALSYM COPP_ACP_Level1}
  COPP_ACP_Level2     = 2;
  {$EXTERNALSYM COPP_ACP_Level2}
  COPP_ACP_Level3     = 3;
  {$EXTERNALSYM COPP_ACP_Level3}
  COPP_ACP_LevelMax   = COPP_ACP_Level3;
  {$EXTERNALSYM COPP_ACP_LevelMax}
  COPP_ACP_ForceDWORD = $7fffffff;
  {$EXTERNALSYM COPP_ACP_ForceDWORD}

  COPP_NoProtectionLevelAvailable = -1;
  {$EXTERNALSYM COPP_NoProtectionLevelAvailable}
  COPP_DefaultProtectionLevel = 0;
  {$EXTERNALSYM COPP_DefaultProtectionLevel}


//
// Bit flags of possible protection types.  Note that it is possible to apply
// different protection settings to a single connector.
//
  COPP_ProtectionType_Unknown      = $80000000;
  {$EXTERNALSYM COPP_ProtectionType_Unknown}
  COPP_ProtectionType_None         = $00000000;
  {$EXTERNALSYM COPP_ProtectionType_None}
  COPP_ProtectionType_HDCP         = $00000001;
  {$EXTERNALSYM COPP_ProtectionType_HDCP}
  COPP_ProtectionType_ACP          = $00000002;
  {$EXTERNALSYM COPP_ProtectionType_ACP}
  COPP_ProtectionType_CGMSA        = $00000004;
  {$EXTERNALSYM COPP_ProtectionType_CGMSA}
  COPP_ProtectionType_Mask         = $80000007;
  {$EXTERNALSYM COPP_ProtectionType_Mask}
  COPP_ProtectionType_Reserved     = $7FFFFFF8;
  {$EXTERNALSYM COPP_ProtectionType_Reserved}

  DXVA_COPPSetSignaling : TGUID = '{09A631A5-D684-4C60-8E4D-D3BB0F0BE3EE}';
  {$EXTERNALSYM DXVA_COPPSetSignaling}

type
  DXVA_COPPSetSignalingCmdData = packed record
    ActiveTVProtectionStandard: ULONG;           // See COPP_TVProtectionStandard
    AspectRatioChangeMask1: ULONG;
    AspectRatioData1: ULONG;                     // See COPP_ImageAspectRatio_EN300294 for ETSI EN 300 294 values
    AspectRatioChangeMask2: ULONG;
    AspectRatioData2: ULONG;
    AspectRatioChangeMask3: ULONG;
    AspectRatioData3: ULONG;
    ExtendedInfoChangeMask: array[0..3] of ULONG;
    ExtendedInfoData: array[0..3] of ULONG;
    Reserved: ULONG;
  end;
  {$EXTERNALSYM DXVA_COPPSetSignalingCmdData}
  TDXVACOPPSetSignalingCmdData = DXVA_COPPSetSignalingCmdData;

// Add format enum and data enum
  COPP_TVProtectionStandard = longword;
  {$EXTERNALSYM COPP_TVProtectionStandard}
const
  COPP_ProtectionStandard_Unknown             = $80000000;
  {$EXTERNALSYM COPP_ProtectionStandard_Unknown}
  COPP_ProtectionStandard_None                = $00000000;
  {$EXTERNALSYM COPP_ProtectionStandard_None}
  COPP_ProtectionStandard_IEC61880_525i       = $00000001;
  {$EXTERNALSYM COPP_ProtectionStandard_IEC61880_525i}
  COPP_ProtectionStandard_IEC61880_2_525i     = $00000002;
  {$EXTERNALSYM COPP_ProtectionStandard_IEC61880_2_525i}
  COPP_ProtectionStandard_IEC62375_625p       = $00000004;
  {$EXTERNALSYM COPP_ProtectionStandard_IEC62375_625p}
  COPP_ProtectionStandard_EIA608B_525         = $00000008;
  {$EXTERNALSYM COPP_ProtectionStandard_EIA608B_525}
  COPP_ProtectionStandard_EN300294_625i       = $00000010;
  {$EXTERNALSYM COPP_ProtectionStandard_EN300294_625i}
  COPP_ProtectionStandard_CEA805A_TypeA_525p  = $00000020;
  {$EXTERNALSYM COPP_ProtectionStandard_CEA805A_TypeA_525p}
  COPP_ProtectionStandard_CEA805A_TypeA_750p  = $00000040;
  {$EXTERNALSYM COPP_ProtectionStandard_CEA805A_TypeA_750p}
  COPP_ProtectionStandard_CEA805A_TypeA_1125i = $00000080;
  {$EXTERNALSYM COPP_ProtectionStandard_CEA805A_TypeA_1125i}
  COPP_ProtectionStandard_CEA805A_TypeB_525p  = $00000100;
  {$EXTERNALSYM COPP_ProtectionStandard_CEA805A_TypeB_525p}
  COPP_ProtectionStandard_CEA805A_TypeB_750p  = $00000200;
  {$EXTERNALSYM COPP_ProtectionStandard_CEA805A_TypeB_750p}
  COPP_ProtectionStandard_CEA805A_TypeB_1125i = $00000400;
  {$EXTERNALSYM COPP_ProtectionStandard_CEA805A_TypeB_1125i}
  COPP_ProtectionStandard_ARIBTRB15_525i      = $00000800;
  {$EXTERNALSYM COPP_ProtectionStandard_ARIBTRB15_525i}
  COPP_ProtectionStandard_ARIBTRB15_525p      = $00001000;
  {$EXTERNALSYM COPP_ProtectionStandard_ARIBTRB15_525p}
  COPP_ProtectionStandard_ARIBTRB15_750p      = $00002000;
  {$EXTERNALSYM COPP_ProtectionStandard_ARIBTRB15_750p}
  COPP_ProtectionStandard_ARIBTRB15_1125i     = $00004000;
  {$EXTERNALSYM COPP_ProtectionStandard_ARIBTRB15_1125i}
  COPP_ProtectionStandard_Mask                = $80007FFF;
  {$EXTERNALSYM COPP_ProtectionStandard_Mask}
  COPP_ProtectionStandard_Reserved            = $7FFF8000;
  {$EXTERNALSYM COPP_ProtectionStandard_Reserved}


  COPP_ImageAspectRatio_EN300294_Mask         = $00000007;
  {$EXTERNALSYM COPP_ImageAspectRatio_EN300294_Mask}

type
  COPP_ImageAspectRatio_EN300294 = (
    COPP_AspectRatio_EN300294_FullFormat4by3,
    COPP_AspectRatio_EN300294_Box14by9Center,
    COPP_AspectRatio_EN300294_Box14by9Top,
    COPP_AspectRatio_EN300294_Box16by9Center,
    COPP_AspectRatio_EN300294_Box16by9Top,
    COPP_AspectRatio_EN300294_BoxGT16by9Center,
    COPP_AspectRatio_EN300294_FullFormat4by3ProtectedCenter,
    COPP_AspectRatio_EN300294_FullFormat16by9Anamorphic
  );
  {$EXTERNALSYM COPP_ImageAspectRatio_EN300294}
  TCOPPImageAspectRatioEN300294 = COPP_ImageAspectRatio_EN300294;

// -------------------------------------------------------------------------
// COPPQueryStatus
// -------------------------------------------------------------------------
type
  PDXVACOPPStatusInput = ^TDXVACOPPStatusInput;
  DXVA_COPPStatusInput = packed record
    rApp                : TGUID;         //   16 bytes
    guidStatusRequestID : TGUID;         //   16 bytes
    dwSequence          : ULONG;         //    4 bytes
    cbSizeData          : ULONG;         //    4 bytes
    StatusData: array[0..4055] of char;  // 4056 bytes (4056+4+4+16+16 = 4096)
  end;
  {$EXTERNALSYM DXVA_COPPStatusInput}
  LPDXVA_COPPStatusInput = ^DXVA_COPPStatusInput;
  {$EXTERNALSYM LPDXVA_COPPStatusInput}
  TDXVACOPPStatusInput = DXVA_COPPStatusInput;

  PDXVACOPPStatusOutput = ^TDXVACOPPStatusOutput;
  DXVA_COPPStatusOutput = packed record
    macKDI     : TGUID;         //   16 bytes
    cbSizeData : ULONG;         //    4 bytes
    COPPStatus : array[0..4075] of Char; // 4076 bytes (4076+16+4 = 4096)
  end;
  {$EXTERNALSYM DXVA_COPPStatusOutput}
  LPDXVA_COPPStatusOutput = ^DXVA_COPPStatusOutput;
  {$EXTERNALSYM LPDXVA_COPPStatusOutput}
  TDXVACOPPStatusOutput = DXVA_COPPStatusOutput;

type
  COPP_StatusFlags = (
    COPP_StatusNormal,
    COPP_LinkLost,
    COPP_RenegotiationRequired
  );
  {$EXTERNALSYM COPP_StatusFlags}
  TCOPPStatusFlags = COPP_StatusFlags;

const
  COPP_StatusFlagsReserved = $FFFFFFFC;
  {$EXTERNALSYM COPP_StatusFlagsReserved}
  
type
  PDXVACOPPStatusData = ^TDXVACOPPStatusData;
  DXVA_COPPStatusData = packed record
    rApp             : TGUID;
    dwFlags          : ULONG; // See COPP_StatusFlags above
    dwData           : ULONG;
    ExtendedInfoValidMask : ULONG;
    ExtendedInfoData : ULONG;
  end;
  {$EXTERNALSYM DXVA_COPPStatusData}
  TDXVACOPPStatusData = DXVA_COPPStatusData;

  DXVA_COPPStatusDisplayData = packed record
    rApp: TGUID;
    dwFlags: ULONG;    // See COPP_StatusFlags above
    DisplayWidth: ULONG;
    DisplayHeight: ULONG;
    Format: ULONG;     // also contains extended color data
    d3dFormat: ULONG;
    FreqNumerator: ULONG;
    FreqDenominator: ULONG;
  end;
  {$EXTERNALSYM DXVA_COPPStatusDisplayData}

  COPP_StatusHDCPFlags    = LongWord;
  {$EXTERNALSYM COPP_StatusHDCPFlags}
const
  COPP_HDCPRepeater       = $01;
  {$EXTERNALSYM COPP_HDCPRepeater}
  COPP_HDCPFlagsReserved  = $FFFFFFFE;
  {$EXTERNALSYM COPP_HDCPFlagsReserved}

type
  PDXVACOPPStatusHDCPKeyData = ^TDXVACOPPStatusHDCPKeyData;
  DXVA_COPPStatusHDCPKeyData = packed record
    rApp: TGUID;
    dwFlags: ULONG;        // See COPP_StatusFlags above
    dwHDCPFlags: ULONG;    // See COPP_StatusHDCPFlags above
    BKey: TGUID;           // Lower 40 bits
    Reserved1: TGUID;
    Reserved2: TGUID;
  end;
  {$EXTERNALSYM DXVA_COPPStatusHDCPKeyData}
  TDXVACOPPStatusHDCPKeyData = DXVA_COPPStatusHDCPKeyData;

const
  DXVA_COPPQueryStatusFnCode = $05;
  {$EXTERNALSYM DXVA_COPPQueryStatusFnCode}
// lpInputData => DXVA_COPPStatusInput*
// lpOuputData => DXVA_COPPStatusOutput*


//
// Status GUID and enumerations
//
  DXVA_COPPQueryConnectorType: TGUID =  '{81d0bfd5-6afe-48c2-99c0-95a08f97c5da}';
  {$EXTERNALSYM DXVA_COPPQueryConnectorType}

const
  COPP_ConnectorType_Unknown = -1;
  {$EXTERNALSYM COPP_ConnectorType_Unknown}
  COPP_ConnectorType_Internal = $80000000;   // can be combined with the other connector types
  {$EXTERNALSYM COPP_ConnectorType_Internal}
type
  COPP_ConnectorType = (
    COPP_ConnectorType_VGA,
    COPP_ConnectorType_SVideo,
    COPP_ConnectorType_CompositeVideo,
    COPP_ConnectorType_ComponentVideo,
    COPP_ConnectorType_DVI,
    COPP_ConnectorType_HDMI,
    COPP_ConnectorType_LVDS,
    COPP_ConnectorType_TMDS,
    COPP_ConnectorType_D_JPN
  //COPP_ConnectorType_ForceDWORD = $7fffffff;  (* force 32-bit size enum *)
  );
  {$EXTERNALSYM COPP_ConnectorType}
  TCOPPConnectorType = COPP_ConnectorType;
  
const
  DXVA_COPPQueryProtectionType        : TGUID = '{38f2a801-9a6c-48bb-9107-b6696e6f1797}';
  {$EXTERNALSYM DXVA_COPPQueryProtectionType}
  DXVA_COPPQueryLocalProtectionLevel  : TGUID = '{b2075857-3eda-4d5d-88db-748f8c1a0549}';
  {$EXTERNALSYM DXVA_COPPQueryLocalProtectionLevel}
  DXVA_COPPQueryGlobalProtectionLevel : TGUID = '{1957210a-7766-452a-b99a-d27aed54f03a}';
  {$EXTERNALSYM DXVA_COPPQueryGlobalProtectionLevel}
  DXVA_COPPQueryDisplayData           : TGUID = '{d7bf1ba3-ad13-4f8e-af98-0dcb3ca204cc}';
  {$EXTERNALSYM DXVA_COPPQueryDisplayData}
  DXVA_COPPQueryHDCPKeyData           : TGUID = '{0db59d74-a992-492e-a0bd-c23fda564e00}';
  {$EXTERNALSYM DXVA_COPPQueryHDCPKeyData}
  DXVA_COPPQueryBusData               : TGUID = '{c6f4d673-6174-4184-8e35-f6db5200bcba}';
  {$EXTERNALSYM DXVA_COPPQueryBusData}

  COPP_BusType_Integrated = $80000000; // can be combined with the other bus types
  {$EXTERNALSYM COPP_BusType_Integrated}

type
  COPP_BusType = (
    COPP_BusType_Unknown,
    COPP_BusType_PCI,
    COPP_BusType_PCIX,
    COPP_BusType_PCIExpress,
    COPP_BusType_AGP
    //COPP_BusType_ForceDWORD = 0x7fffffff  /* force 32-bit size enum */
  );
  {$EXTERNALSYM COPP_BusType}
  TCOPPBusType = COPP_BusType;

const
  DXVA_COPPQuerySignaling : TGUID = '{6629A591-3B79-4CF3-924A-11E8E7811671}';
  {$EXTERNALSYM DXVA_COPPQuerySignaling}

type
  DXVA_COPPStatusSignalingCmdData = packed record
    rApp: TGUID;
    dwFlags: ULONG;                                // See COPP_StatusFlags above
    AvailableTVProtectionStandards: ULONG;         // See COPP_TVProtectionStandard
    ActiveTVProtectionStandard: ULONG;             // See COPP_TVProtectionStandard
    TVType: ULONG;
    AspectRatioValidMask1: ULONG;
    AspectRatioData1: ULONG;                       // See COPP_AspectRatio_EN300294 for ETSI EN 300 294 values
    AspectRatioValidMask2: ULONG;
    AspectRatioData2: ULONG;
    AspectRatioValidMask3: ULONG;
    AspectRatioData3: ULONG;
    ExtendedInfoValidMask: array[0..3] of ULONG;
    ExtendedInfoData: array[0..3] of ULONG;
  end;
  {$EXTERNALSYM DXVA_COPPStatusSignalingCmdData}
  TDXVACOPPStatusSignalingCmdData = DXVA_COPPStatusSignalingCmdData;

//------------------------------------------------------------------------------
// File: AMVA.h
// Desc: DirectShowMotionComp include file.
// Copyright (c) 1997 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

const
  AMVA_TYPEINDEX_OUTPUTFRAME = $FFFFFFFF;
  {$EXTERNALSYM AMVA_TYPEINDEX_OUTPUTFRAME}

  //  Flags for QueryRenderStatus
  AMVA_QUERYRENDERSTATUSF_READ = $00000001;  // Query for read
  {$EXTERNALSYM AMVA_QUERYRENDERSTATUSF_READ}
                                           // set this bit to 0
                                           // if query for update
type
  PAMVAUncompBufferInfo = ^TAMVAUncompBufferInfo;
  _tag_AMVAUncompBufferInfo = record
    dwMinNumSurfaces    : DWORD                   ; // IN   min number of surfaces to be allocated
    dwMaxNumSurfaces    : DWORD                   ; // IN   max number of surfaces to be allocated
    ddUncompPixelFormat : TDDPixelFormat          ; // IN   pixel format of surfaces to be allocated
  end;
  {$EXTERNALSYM _tag_AMVAUncompBufferInfo}
  AMVAUncompBufferInfo = _tag_AMVAUncompBufferInfo;
  {$EXTERNALSYM AMVAUncompBufferInfo}
  LPAMVAUncompBufferInfo = ^AMVAUncompBufferInfo;
  {$EXTERNALSYM LPAMVAUncompBufferInfo}
  TAMVAUncompBufferInfo = _tag_AMVAUncompBufferInfo;

  PAMVAUncompDataInfo = ^TAMVAUncompDataInfo;
  _tag_AMVAUncompDataInfo = record
    dwUncompWidth       : DWORD               ; // [in]     width of uncompressed data
    dwUncompHeight      : DWORD               ; // [in]     height of uncompressed data
    ddUncompPixelFormat : TDDPixelFormat      ; // [in]     pixel-format of uncompressed data
  end;
  {$EXTERNALSYM _tag_AMVAUncompDataInfo}
  AMVAUncompDataInfo = _tag_AMVAUncompDataInfo;
  {$EXTERNALSYM AMVAUncompDataInfo}
  LPAMVAUncompDataInfo = ^AMVAUncompDataInfo;
  {$EXTERNALSYM LPAMVAUncompDataInfo}
  TAMVAUncompDataInfo = _tag_AMVAUncompDataInfo;

  PAMVAInternalMemInfo = ^TAMVAInternalMemInfo;
  _tag_AMVAInternalMemInfo = record
    dwScratchMemAlloc : DWORD ; // [out]    amount of scratch memory will the hal allocate for its private use
  end;
  {$EXTERNALSYM _tag_AMVAInternalMemInfo}
  AMVAInternalMemInfo = _tag_AMVAInternalMemInfo;
  {$EXTERNALSYM AMVAInternalMemInfo}
  LPAMVAInternalMemInfo = ^AMVAInternalMemInfo;
  {$EXTERNALSYM LPAMVAInternalMemInfo}
  TAMVAInternalMemInfo = _tag_AMVAInternalMemInfo;

  PAMVACompBufferInfo = ^TAMVACompBufferInfo;
  _tag_AMVACompBufferInfo = record
    dwNumCompBuffers  : DWORD         ; // [out]    number of buffers reqd for compressed data
    dwWidthToCreate   : DWORD         ; // [out]    Width of surface to create
    dwHeightToCreate  : DWORD         ; // [out]    Height of surface to create
    dwBytesToAllocate : DWORD         ; // [out]    Total number of bytes used by each surface
    ddCompCaps        : TDDSCAPS2     ; // [out]    caps to create surfaces to store compressed data
    ddPixelFormat     : TDDPixelFormat; // [out]    fourcc to create surfaces to store compressed data
  end;
  {$EXTERNALSYM _tag_AMVACompBufferInfo}
  AMVACompBufferInfo = _tag_AMVACompBufferInfo;
  {$EXTERNALSYM AMVACompBufferInfo}
  LPAMVACompBufferInfo = ^AMVACompBufferInfo;
  {$EXTERNALSYM LPAMVACompBufferInfo}
  TAMVACompBufferInfo = _tag_AMVACompBufferInfo;

// Note that you are NOT allowed to store any pointer in pMiscData
  PAMVABeginFrameInfo = ^TAMVABeginFrameInfo;
  _tag_AMVABeginFrameInfo = record
    dwDestSurfaceIndex : DWORD   ; // IN  destination buffer in which to decoding this frame
    pInputData         : pointer ; // IN  pointer to misc data
    dwSizeInputData    : DWORD   ; // IN  size of other misc data to begin frame
    pOutputData        : pointer ; // OUT pointer to data which the VGA is going to fill
    dwSizeOutputData   : DWORD   ; // IN  size of data which the VGA is going to fill
  end;
  {$EXTERNALSYM _tag_AMVABeginFrameInfo}
  AMVABeginFrameInfo = _tag_AMVABeginFrameInfo;
  {$EXTERNALSYM AMVABeginFrameInfo}
  LPAMVABeginFrameInfo = ^AMVABeginFrameInfo;
  {$EXTERNALSYM LPAMVABeginFrameInfo}
  TAMVABeginFrameInfo = _tag_AMVABeginFrameInfo;

// Note that you are NOT allowed to store any pointer in pMiscData
  PAMVAEndFrameInfo = ^TAMVAEndFrameInfo;
  _tag_AMVAEndFrameInfo = record
    dwSizeMiscData : DWORD  ; // [in]     size of other misc data to begin frame
    pMiscData      : pointer; // [in]     pointer to misc data
  end;
  {$EXTERNALSYM _tag_AMVAEndFrameInfo}
  AMVAEndFrameInfo = _tag_AMVAEndFrameInfo;
  {$EXTERNALSYM AMVAEndFrameInfo}
  LPAMVAEndFrameInfo = ^AMVAEndFrameInfo;
  {$EXTERNALSYM LPAMVAEndFrameInfo}
  TAMVAEndFrameInfo = _tag_AMVAEndFrameInfo;

  PAMVABufferInfo = ^TAMVABufferInfo;
  _tag_AMVABUFFERINFO = record
    dwTypeIndex   : DWORD; // [in]    Type of buffer
    dwBufferIndex : DWORD; // [in]    Buffer index
    dwDataOffset  : DWORD; // [in]    offset of relevant data from the beginning of buffer
    dwDataSize    : DWORD; // [in]    size of relevant data
  end;
  {$EXTERNALSYM _tag_AMVABUFFERINFO}
  AMVABUFFERINFO = _tag_AMVABUFFERINFO;
  {$EXTERNALSYM AMVABUFFERINFO}
  LPAMVABUFFERINFO = ^AMVABUFFERINFO;
  {$EXTERNALSYM LPAMVABUFFERINFO}
  TAMVABufferInfo = _tag_AMVABUFFERINFO;
  
//------------------------------------------------------------------------------
// File: videoacc.h
// Desc: DirectX Video Acceleration interfaces
// Copyright (c) 1999 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

const
  IID_IAMVideoAcceleratorNotify : TGUID = '{256A6A21-FBAD-11d1-82BF-00A0C9696C8F}';
  {$EXTERNALSYM IID_IAMVideoAcceleratorNotify}
  IID_IAMVideoAccelerator       : TGUID = '{256A6A22-FBAD-11d1-82BF-00A0C9696C8F}';
  {$EXTERNALSYM IID_IAMVideoAccelerator}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IAMVideoAcceleratorNotify> _di_IAMVideoAcceleratorNotify;'}
  {$EXTERNALSYM IAMVideoAcceleratorNotify}
  IAMVideoAcceleratorNotify = interface(IUnknown)
    ['{256A6A21-FBAD-11d1-82BF-00A0C9696C8F}']
    (*** IAMVideoAcceleratorNotify methods ***)
    function GetUncompSurfacesInfo(const pGuid: TGUID; var pUncompBufferInfo: PAMVAUncompBufferInfo): HResult; stdcall;
    function SetUncompSurfacesInfo(dwActualUncompSurfacesAllocated: DWORD): HResult; stdcall;
    function GetCreateVideoAcceleratorData(const pGuid: TGUID; out pdwSizeMiscData: PDWORD; out ppMiscData: pointer): HResult; stdcall;
    end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMVideoAccelerator> _di_IAMVideoAccelerator;'}
  {$EXTERNALSYM IAMVideoAccelerator}
  IAMVideoAccelerator = interface(IUnknown)
    ['{256A6A22-FBAD-11d1-82BF-00A0C9696C8F}']
    (*** IAMVideoAccelerator methods ***)
    function GetVideoAcceleratorGUIDs(var pdwNumGuidsSupported: PDWORD; var pGuidsSupported: PGUID): HResult; stdcall;
    function GetUncompFormatsSupported(const pGuid: TGUID; var pdwNumFormatsSupported: PDWORD;
             var pFormatsSupported: PDDPixelFormat): HResult; stdcall;
    function GetInternalMemInfo(const pGuid: TGUID; const pamvaUncompDataInfo: TAMVAUncompDataInfo;
             var pamvaInternalMemInfo: PAMVAInternalMemInfo): HResult; stdcall;
    function GetCompBufferInfo(const pGuid: TGUID; const pamvaUncompDataInfo: TAMVAUncompDataInfo ;
             var pdwNumTypesCompBuffers: PDWORD; out pamvaCompBufferInfo: PAMVACompBufferInfo): HResult; stdcall;
    function GetInternalCompBufferInfo(var pdwNumTypesCompBuffers: PDWORD; out pamvaCompBufferInfo: PAMVACompBufferInfo): HResult; stdcall;
    function BeginFrame(const amvaBeginFrameInfo: TAMVABeginFrameInfo): HResult; stdcall;
    function EndFrame(const pEndFrameInfo: TAMVAEndFrameInfo): HResult; stdcall;
    function GetBuffer(dwTypeIndex, dwBufferIndex: DWORD; bReadOnly: BOOL; out ppBuffer; out lpStride: LONGINT): HResult; stdcall;
    function ReleaseBuffer(dwTypeIndex, dwBufferIndex: DWORD): HResult; stdcall;
    function Execute(dwFunction: DWORD; lpPrivateInputData : pointer; cbPrivateInputData: DWORD;
             lpPrivateOutputDat: pointer; cbPrivateOutputData, dwNumBuffers: DWORD;
             const pamvaBufferInfo: TAMVABUFFERINFO): HResult; stdcall;
    function QueryRenderStatus(dwTypeIndex, dwBufferIndex, dwFlags: DWORD): HResult; stdcall;
    function DisplayFrame(dwFlipToIndex: DWORD; pMediaSample: IMediaSample): HResult; stdcall;
    end;

//------------------------------------------------------------------------------
// File: BDATypes.h
//
// Desc: Typedefs and enums needed by both the WDM drivers and the user mode
//       COM interfaces.
//
// Copyright (c) 1999 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

// Utility Macros
const
  MIN_DIMENSION = 1;
  {$EXTERNALSYM MIN_DIMENSION}
  NATURAL       = 4;
  {$EXTERNALSYM NATURAL}
  CACHE_LINE    = 128;
  {$EXTERNALSYM CACHE_LINE}
  PAGE          = 4096;
  {$EXTERNALSYM PAGE}
  //#define ALIGN( pointer, size) (((ULONG)(pointer) + (ULONG)(size) - 1) & ~((ULONG)(size) - 1))
  //#define BDA_STRING_CONST(x)   {sizeof(L##x)-2, sizeof(L##x), L##x}

//===========================================================================
//
//  BDA Topology Structures
//
//===========================================================================
type
  PBDATemplateConnection = ^TBDATemplateConnection;
  _BDA_TEMPLATE_CONNECTION = record
    FromNodeType    : ULONG;
    FromNodePinType : ULONG;
    ToNodeType      : ULONG;
    ToNodePinType   : ULONG;
  end;
  {$EXTERNALSYM _BDA_TEMPLATE_CONNECTION}
  BDA_TEMPLATE_CONNECTION = _BDA_TEMPLATE_CONNECTION;
  {$EXTERNALSYM BDA_TEMPLATE_CONNECTION}
  PBDA_TEMPLATE_CONNECTION = ^BDA_TEMPLATE_CONNECTION;
  {$EXTERNALSYM PBDA_TEMPLATE_CONNECTION}
  TBDATemplateConnection = _BDA_TEMPLATE_CONNECTION;

  PBDATemplatePinJoint = ^TBDATemplatePinJoint;
  _BDA_TEMPLATE_PIN_JOINT = record
    uliTemplateConnection : ULONG;
    ulcInstancesMax       : ULONG;
  end;
  {$EXTERNALSYM _BDA_TEMPLATE_PIN_JOINT}
  BDA_TEMPLATE_PIN_JOINT = _BDA_TEMPLATE_PIN_JOINT;
  {$EXTERNALSYM BDA_TEMPLATE_PIN_JOINT}
  PBDA_TEMPLATE_PIN_JOINT = ^BDA_TEMPLATE_PIN_JOINT;
  {$EXTERNALSYM PBDA_TEMPLATE_PIN_JOINT}
  TBDATemplatePinJoint = _BDA_TEMPLATE_PIN_JOINT;

//===========================================================================
//  BDA Events
//===========================================================================
//  In-band Event IDs
  PBDAEventID = ^TBDAEventID;
  BDA_EVENT_ID = (
    BDA_EVENT_SIGNAL_LOSS,
    BDA_EVENT_SIGNAL_LOCK,
    BDA_EVENT_DATA_START,
    BDA_EVENT_DATA_STOP,
    BDA_EVENT_CHANNEL_ACQUIRED,
    BDA_EVENT_CHANNEL_LOST,
    BDA_EVENT_CHANNEL_SOURCE_CHANGED,
    BDA_EVENT_CHANNEL_ACTIVATED,
    BDA_EVENT_CHANNEL_DEACTIVATED,
    BDA_EVENT_SUBCHANNEL_ACQUIRED,
    BDA_EVENT_SUBCHANNEL_LOST,
    BDA_EVENT_SUBCHANNEL_SOURCE_CHANGED,
    BDA_EVENT_SUBCHANNEL_ACTIVATED,
    BDA_EVENT_SUBCHANNEL_DEACTIVATED,
    BDA_EVENT_ACCESS_GRANTED,
    BDA_EVENT_ACCESS_DENIED,
    BDA_EVENT_OFFER_EXTENDED,
    BDA_EVENT_PURCHASE_COMPLETED,
    BDA_EVENT_SMART_CARD_INSERTED,
    BDA_EVENT_SMART_CARD_REMOVED
  );
  {$EXTERNALSYM BDA_EVENT_ID}
  PBDA_EVENT_ID = ^BDA_EVENT_ID;
  {$EXTERNALSYM PBDA_EVENT_ID}
  TBDAEventID = BDA_EVENT_ID;

//===========================================================================
//
//  KSSTREAM_HEADER extensions for BDA
//
//===========================================================================

  PKSBDAFrameInfo = ^TKSBDAFrameInfo;
  tagKS_BDA_FRAME_INFO = record
    ExtendedHeaderSize : ULONG; // Size of this extended header
    dwFrameFlags       : DWORD;
    ulEvent            : ULONG;
    ulChannelNumber    : ULONG;
    ulSubchannelNumber : ULONG;
    ulReason           : ULONG;
  end;
  {$EXTERNALSYM tagKS_BDA_FRAME_INFO}
  KS_BDA_FRAME_INFO = tagKS_BDA_FRAME_INFO;
  {$EXTERNALSYM KS_BDA_FRAME_INFO}
  PKS_BDA_FRAME_INFO = ^KS_BDA_FRAME_INFO;
  {$EXTERNALSYM PKS_BDA_FRAME_INFO}
  TKSBDAFrameInfo = tagKS_BDA_FRAME_INFO;

//------------------------------------------------------------
//  BDA Network Ethernet Filter Property Set
// {71985F43-1CA1-11d3-9CC8-00C04F7971E0}

  PBDAEthernetAddress = ^TBDAEthernetAddress;
  _BDA_ETHERNET_ADDRESS = record
    rgbAddress : array[0..5] of BYTE;
  end;
  {$EXTERNALSYM _BDA_ETHERNET_ADDRESS}
  BDA_ETHERNET_ADDRESS = _BDA_ETHERNET_ADDRESS;
  {$EXTERNALSYM BDA_ETHERNET_ADDRESS}
  PBDA_ETHERNET_ADDRESS = ^BDA_ETHERNET_ADDRESS;
  {$EXTERNALSYM PBDA_ETHERNET_ADDRESS}
  TBDAEthernetAddress = _BDA_ETHERNET_ADDRESS;

  PBDAEthernetAddressList = ^TBDAEthernetAddressList;
  _BDA_ETHERNET_ADDRESS_LIST = record
    ulcAddresses : ULONG;
    rgAddressl : array[0..MIN_DIMENSION-1] of TBDAEthernetAddress;
  end;
  {$EXTERNALSYM _BDA_ETHERNET_ADDRESS_LIST}
  BDA_ETHERNET_ADDRESS_LIST = _BDA_ETHERNET_ADDRESS_LIST;
  {$EXTERNALSYM BDA_ETHERNET_ADDRESS_LIST}
  PBDA_ETHERNET_ADDRESS_LIST = ^BDA_ETHERNET_ADDRESS_LIST;
  {$EXTERNALSYM PBDA_ETHERNET_ADDRESS_LIST}
  TBDAEthernetAddressList = _BDA_ETHERNET_ADDRESS_LIST;

  PBDAMulticastMode = ^TBDAMulticastMode;
  BDA_MULTICAST_MODE = (
    BDA_PROMISCUOUS_MULTICAST,
    BDA_FILTERED_MULTICAST,
    BDA_NO_MULTICAST
  );
  {$EXTERNALSYM BDA_MULTICAST_MODE}
  PBDA_MULTICAST_MODE = ^BDA_MULTICAST_MODE;
  {$EXTERNALSYM PBDA_MULTICAST_MODE}
  TBDAMulticastMode = BDA_MULTICAST_MODE;

//------------------------------------------------------------
//  BDA Network IPv4 Filter Property Set
// {71985F44-1CA1-11d3-9CC8-00C04F7971E0}

  PBDAIPv4Address = ^TBDAIPv4Address;
  _BDA_IPv4_ADDRESS = record
    rgbAddress : array[0..3] of BYTE;
  end;
  {$EXTERNALSYM _BDA_IPv4_ADDRESS}
  BDA_IPv4_ADDRESS = _BDA_IPv4_ADDRESS;
  {$EXTERNALSYM BDA_IPv4_ADDRESS}
  PBDA_IPv4_ADDRESS = ^BDA_IPv4_ADDRESS;
  {$EXTERNALSYM PBDA_IPv4_ADDRESS}
  TBDAIPv4Address = _BDA_IPv4_ADDRESS;

  PBDAIPv4AddressList = ^TBDAIPv4AddressList;
  _BDA_IPv4_ADDRESS_LIST = record
    ulcAddresses : ULONG;
    rgAddressl   : array[0..MIN_DIMENSION-1] of TBDAIPv4Address;
  end;
  {$EXTERNALSYM _BDA_IPv4_ADDRESS_LIST}
  BDA_IPv4_ADDRESS_LIST = _BDA_IPv4_ADDRESS_LIST;
  {$EXTERNALSYM BDA_IPv4_ADDRESS_LIST}
  PBDA_IPv4_ADDRESS_LIST = ^BDA_IPv4_ADDRESS_LIST;
  {$EXTERNALSYM PBDA_IPv4_ADDRESS_LIST}
  TBDAIPv4AddressList = _BDA_IPv4_ADDRESS_LIST;

//------------------------------------------------------------
//  BDA Network IPv4 Filter Property Set
// {E1785A74-2A23-4fb3-9245-A8F88017EF33}

  PBDAIPv6Address = ^TBDAIPv6Address;
  _BDA_IPv6_ADDRESS = record
    rgbAddress : array[0..5] of BYTE;
  end;
  {$EXTERNALSYM _BDA_IPv6_ADDRESS}
  BDA_IPv6_ADDRESS = _BDA_IPv6_ADDRESS;
  {$EXTERNALSYM BDA_IPv6_ADDRESS}
  PBDA_IPv6_ADDRESS = ^BDA_IPv6_ADDRESS;
  {$EXTERNALSYM PBDA_IPv6_ADDRESS}
  TBDAIPv6Address = _BDA_IPv6_ADDRESS;

  PBDAIPv6AddressList = ^TBDAIPv6AddressList;
  _BDA_IPv6_ADDRESS_LIST = record
    ulcAddresses : ULONG;
    rgAddressl   : array [0..MIN_DIMENSION-1] of TBDAIPv6Address;
  end;
  {$EXTERNALSYM _BDA_IPv6_ADDRESS_LIST}
  BDA_IPv6_ADDRESS_LIST = _BDA_IPv6_ADDRESS_LIST;
  {$EXTERNALSYM BDA_IPv6_ADDRESS_LIST}
  PBDA_IPv6_ADDRESS_LIST = ^BDA_IPv6_ADDRESS_LIST;
  {$EXTERNALSYM PBDA_IPv6_ADDRESS_LIST}
  TBDAIPv6AddressList = _BDA_IPv6_ADDRESS_LIST;

//------------------------------------------------------------
//  BDA Signal Property Set
//  {D2F1644B-B409-11d2-BC69-00A0C9EE9E16}

  PBDASignalState = ^TBDASignalState;
  BDA_SIGNAL_STATE = (
    BDA_SIGNAL_UNAVAILABLE,
    BDA_SIGNAL_INACTIVE,
    BDA_SIGNAL_ACTIVE
  );
  {$EXTERNALSYM BDA_SIGNAL_STATE}
  PBDA_SIGNAL_STATE = ^BDA_SIGNAL_STATE;
  {$EXTERNALSYM PBDA_SIGNAL_STATE}
  TBDASignalState = BDA_SIGNAL_STATE;

//------------------------------------------------------------
//  BDA Change Sync Method Set
// {FD0A5AF3-B41D-11d2-9C95-00C04F7971E0}

  PBDAChangeState = ^TBDAChangeState;
  BDA_CHANGE_STATE = (
    BDA_CHANGES_COMPLETE,
    BDA_CHANGES_PENDING
  );
  {$EXTERNALSYM BDA_CHANGE_STATE}
  PBDA_CHANGE_STATE = ^BDA_CHANGE_STATE;
  TBDAChangeState = BDA_CHANGE_STATE;

//------------------------------------------------------------
//  BDA Device Configuration Method Set
// {71985F45-1CA1-11d3-9CC8-00C04F7971E0}

//------------------------------------------------------------
//  BDA Topology Property Set
// {A14EE835-0A23-11d3-9CC7-00C04F7971E0}
  PBDANodeDescriptor = ^TBDANodeDescriptor;
  _BDANODE_DESCRIPTOR = record
    ulBdaNodeType : ULONG;  // The node type as it is used
                            // in the BDA template topology
    guidFunction  : TGUID;  // GUID from BdaMedia.h describing
                            // the node's function (e.g.
                            // KSNODE_BDA_RF_TUNER)
    guidName      : TGUID;  // GUID that can be use to look up
                            // a displayable name for the node.
  end;
  {$EXTERNALSYM _BDANODE_DESCRIPTOR}
  BDANODE_DESCRIPTOR = _BDANODE_DESCRIPTOR;
  {$EXTERNALSYM BDANODE_DESCRIPTOR}
  PBDANODE_DESCRIPTOR = ^BDANODE_DESCRIPTOR;
  {$EXTERNALSYM PBDANODE_DESCRIPTOR}
  TBDANodeDescriptor = _BDANODE_DESCRIPTOR;

//------------------------------------------------------------
//  BDA Void Transform Property Set
// {71985F46-1CA1-11d3-9CC8-00C04F7971E0}

//------------------------------------------------------------
//  BDA Null Transform Property Set
// {DDF15B0D-BD25-11d2-9CA0-00C04F7971E0}

//------------------------------------------------------------
//  BDA Frequency Filter Property Set
// {71985F47-1CA1-11d3-9CC8-00C04F7971E0}

//------------------------------------------------------------
//  BDA Autodemodulate Property Set
// {DDF15B12-BD25-11d2-9CA0-00C04F7971E0}
const
  KSPROPSETID_BdaAutodemodulate: TGuid = '{DDF15B12-BD25-11d2-9CA0-00C04F7971E0}';
  {$EXTERNALSYM KSPROPSETID_BdaAutodemodulate}

type
  KSPROPERTY_BDA_AUTODEMODULATE = (
    KSPROPERTY_BDA_AUTODEMODULATE_START,
    KSPROPERTY_BDA_AUTODEMODULATE_STOP
  );
  {$EXTERNALSYM KSPROPERTY_BDA_AUTODEMODULATE}

//------------------------------------------------------------
//  BDA Table Section Property Set
// {516B99C5-971C-4aaf-B3F3-D9FDA8A15E16}
type
  PBDATableSection = ^TBDATableSection;
  _BDA_TABLE_SECTION = record
    ulPrimarySectionId   : ULONG;
    ulSecondarySectionId : ULONG;
    ulcbSectionLength    : ULONG;
    argbSectionData      : array[0..MIN_DIMENSION-1] of ULONG;
  end;
  {$EXTERNALSYM _BDA_TABLE_SECTION}
  BDA_TABLE_SECTION = _BDA_TABLE_SECTION;
  {$EXTERNALSYM BDA_TABLE_SECTION}
  PBDA_TABLE_SECTION = ^BDA_TABLE_SECTION;
  {$EXTERNALSYM PBDA_TABLE_SECTION}
  TBDATableSection = _BDA_TABLE_SECTION;

//------------------------------------------------------------
//  BDA PID Filter Property Set
// {D0A67D65-08DF-4fec-8533-E5B550410B85}

//---------------------------------------------------------------------
// From IEnumPIDMap interface
//---------------------------------------------------------------------

  MEDIA_SAMPLE_CONTENT = (
    MEDIA_TRANSPORT_PACKET,         //  complete TS packet e.g. pass-through mode
    MEDIA_ELEMENTARY_STREAM,        //  PES payloads; audio/video only
    MEDIA_MPEG2_PSI,                //  PAT, PMT, CAT, Private
    MEDIA_TRANSPORT_PAYLOAD         //  gathered TS packet payloads (PES packets, etc...)
  );
  {$EXTERNALSYM MEDIA_SAMPLE_CONTENT}
  TMediaSampleContent = MEDIA_SAMPLE_CONTENT;

  PID_MAP = record
    ulPID              : ULONG;
    MediaSampleContent : TMediaSampleContent;
  end;
  {$EXTERNALSYM PID_MAP}
  TPIDMap = PID_MAP;
  PPIDMap = ^PID_MAP;


  PBDAPIDMap = ^TBDAPIDMap;
  _BDA_PID_MAP = record
    MediaSampleContent : TMediaSampleContent;
    ulcPIDs            : ULONG;
    aulPIDs            : array[0..MIN_DIMENSION-1] of ULONG;
  end;
  {$EXTERNALSYM _BDA_PID_MAP}
  BDA_PID_MAP = _BDA_PID_MAP;
  {$EXTERNALSYM BDA_PID_MAP}
  PBDA_PID_MAP = ^BDA_PID_MAP;
  TBDAPIDMap = _BDA_PID_MAP;

  PBDAPIDUnmap = ^TBDAPIDUnmap;
  _BDA_PID_UNMAP = record
    ulcPIDs : ULONG;
    aulPIDs : array[0..MIN_DIMENSION-1] of ULONG;
  end;
  {$EXTERNALSYM _BDA_PID_UNMAP}
  BDA_PID_UNMAP = _BDA_PID_UNMAP;
  {$EXTERNALSYM BDA_PID_UNMAP}
  PBDA_PID_UNMAP = ^BDA_PID_UNMAP;
  {$EXTERNALSYM PBDA_PID_UNMAP}
  TBDAPIDUnmap = _BDA_PID_UNMAP;

//------------------------------------------------------------
//  BDA CA Property Set
// {B0693766-5278-4ec6-B9E1-3CE40560EF5A}

  PBDACAModuleUI = ^TBDACAModuleUI;
  _BDA_CA_MODULE_UI = record
    ulFormat : ULONG;
    ulbcDesc : ULONG;
    ulDesc   : array[0..MIN_DIMENSION-1] of ULONG;
  end;
  {$EXTERNALSYM _BDA_CA_MODULE_UI}
  BDA_CA_MODULE_UI = _BDA_CA_MODULE_UI;
  {$EXTERNALSYM BDA_CA_MODULE_UI}
  PBDA_CA_MODULE_UI = ^BDA_CA_MODULE_UI;
  {$EXTERNALSYM PBDA_CA_MODULE_UI}
  TBDACAModuleUI = _BDA_CA_MODULE_UI;

  PBDAProgramPIDList = ^TBDAProgramPIDList;
  _BDA_PROGRAM_PID_LIST = record
    ulProgramNumber : ULONG;
    ulcPIDs         : ULONG;
    ulPID           : array[0..MIN_DIMENSION-1] of ULONG;
  end;
  {$EXTERNALSYM _BDA_PROGRAM_PID_LIST}
  BDA_PROGRAM_PID_LIST = _BDA_PROGRAM_PID_LIST;
  {$EXTERNALSYM BDA_PROGRAM_PID_LIST}
  PBDA_PROGRAM_PID_LIST = ^BDA_PROGRAM_PID_LIST;
  {$EXTERNALSYM PBDA_PROGRAM_PID_LIST}
  TBDAProgramPIDList = _BDA_PROGRAM_PID_LIST;

//------------------------------------------------------------
//  BDA CA Event Set
// {488C4CCC-B768-4129-8EB1-B00A071F9068}

//=============================================================
//
//
//  BDA Tuning Model enumerations
//
//
//=============================================================

// system type for particular DVB Tuning Space instance
  DVBSystemType = (
    DVB_Cable,
    DVB_Terrestrial,
    DVB_Satellite
  );
  {$EXTERNALSYM DVBSystemType}
  TDVBSystemType = DVBSystemType;
  
//------------------------------------------------------------
//  BDA Channel Tune Request

const
  BDA_UNDEFINED_CHANNEL = -1;
  {$EXTERNALSYM BDA_UNDEFINED_CHANNEL}

//------------------------------------------------------------
//  BDA Component(substream)
type
  ComponentCategory = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM ComponentCategory}
  const
    CategoryNotSet = -1;
    {$EXTERNALSYM CategoryNotSet}
    CategoryOther  = 0;
    {$EXTERNALSYM CategoryOther}
    CategoryVideo  = 1;
    {$EXTERNALSYM CategoryVideo}
    CategoryAudio  = 2;
    {$EXTERNALSYM CategoryAudio}
    CategoryText   = 3;
    {$EXTERNALSYM CategoryText}
    CategoryData   = 4;
    {$EXTERNALSYM CategoryData}

// Component Status
type
  ComponentStatus = (
    StatusActive,
    StatusInactive,
    StatusUnavailable
  );
  {$EXTERNALSYM ComponentStatus}
  TComponentStatus = ComponentStatus;

//------------------------------------------------------------
//
//  BDA MPEG2 Component Type
//
// from the MPEG2 specification
  MPEG2StreamType = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM MPEG2StreamType}
  const
    BDA_UNITIALIZED_MPEG2STREAMTYPE = -1;
    {$EXTERNALSYM BDA_UNITIALIZED_MPEG2STREAMTYPE}
    Reserved1                       = $0;
    {$NODEFINE Reserved1}
    ISO_IEC_11172_2_VIDEO           = Reserved1 + 1;
    {$EXTERNALSYM ISO_IEC_11172_2_VIDEO}
    ISO_IEC_13818_2_VIDEO           = ISO_IEC_11172_2_VIDEO + 1;
    {$EXTERNALSYM ISO_IEC_13818_2_VIDEO}
    ISO_IEC_11172_3_AUDIO           = ISO_IEC_13818_2_VIDEO + 1;
    {$EXTERNALSYM ISO_IEC_11172_3_AUDIO}
    ISO_IEC_13818_3_AUDIO           = ISO_IEC_11172_3_AUDIO + 1;
    {$EXTERNALSYM ISO_IEC_13818_3_AUDIO}
    ISO_IEC_13818_1_PRIVATE_SECTION = ISO_IEC_13818_3_AUDIO + 1;
    {$EXTERNALSYM ISO_IEC_13818_1_PRIVATE_SECTION}
    ISO_IEC_13818_1_PES             = ISO_IEC_13818_1_PRIVATE_SECTION + 1;
    {$EXTERNALSYM ISO_IEC_13818_1_PES}
    ISO_IEC_13522_MHEG              = ISO_IEC_13818_1_PES + 1;
    {$EXTERNALSYM ISO_IEC_13522_MHEG}
    ANNEX_A_DSM_CC                  = ISO_IEC_13522_MHEG + 1;
    {$EXTERNALSYM ANNEX_A_DSM_CC}
    ITU_T_REC_H_222_1               = ANNEX_A_DSM_CC + 1;
    {$EXTERNALSYM ITU_T_REC_H_222_1}
    ISO_IEC_13818_6_TYPE_A          = ITU_T_REC_H_222_1 + 1;
    {$EXTERNALSYM ISO_IEC_13818_6_TYPE_A}
    ISO_IEC_13818_6_TYPE_B          = ISO_IEC_13818_6_TYPE_A + 1;
    {$EXTERNALSYM ISO_IEC_13818_6_TYPE_B}
    ISO_IEC_13818_6_TYPE_C          = ISO_IEC_13818_6_TYPE_B + 1;
    {$EXTERNALSYM ISO_IEC_13818_6_TYPE_C}
    ISO_IEC_13818_6_TYPE_D          = ISO_IEC_13818_6_TYPE_C + 1;
    {$EXTERNALSYM ISO_IEC_13818_6_TYPE_D}
    ISO_IEC_13818_1_AUXILIARY       = ISO_IEC_13818_6_TYPE_D + 1;
    {$EXTERNALSYM ISO_IEC_13818_1_AUXILIARY}
    ISO_IEC_13818_1_RESERVED        = ISO_IEC_13818_1_AUXILIARY + 1;
    {$EXTERNALSYM ISO_IEC_13818_1_RESERVED}
    USER_PRIVATE                    = ISO_IEC_13818_1_RESERVED + 1;
    {$EXTERNALSYM USER_PRIVATE}

//------------------------------------------------------------
//
//  mpeg-2 transport stride format block; associated with media
//   types MEDIATYPE_Stream/MEDIASUBTYPE_MPEG2_TRANSPORT_STRIDE;
//   *all* format blocks associated with above media type *must*
//   start with the MPEG2_TRANSPORT_STRIDE structure
//
type
  PMPEG2TransportStride = ^TMPEG2TransportStride;
  _MPEG2_TRANSPORT_STRIDE = record
    dwOffset       : DWORD;
    dwPacketLength : DWORD;
    dwStride       : DWORD;
  end;
  {$EXTERNALSYM _MPEG2_TRANSPORT_STRIDE}
  MPEG2_TRANSPORT_STRIDE = _MPEG2_TRANSPORT_STRIDE;
  {$EXTERNALSYM MPEG2_TRANSPORT_STRIDE}
  PMPEG2_TRANSPORT_STRIDE = ^MPEG2_TRANSPORT_STRIDE;
  {$EXTERNALSYM PMPEG2_TRANSPORT_STRIDE}
  TMPEG2TransportStride = _MPEG2_TRANSPORT_STRIDE;

//------------------------------------------------------------
//
//  BDA ATSC Component Type
//
//
// ATSC made AC3 Audio a descriptor instead of
// defining a user private stream type.
//enum ATSCComponentTypeFlags {
    // bit flags for various component type properties
const
  ATSCCT_AC3 = $00000001;
  {$EXTERNALSYM ATSCCT_AC3}

//------------------------------------------------------------
//  BDA Locators

type
  BinaryConvolutionCodeRate = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM BinaryConvolutionCodeRate}
  const
    BDA_BCC_RATE_NOT_SET     = -1;
    {$EXTERNALSYM BDA_BCC_RATE_NOT_SET}
    BDA_BCC_RATE_NOT_DEFINED = 0;
    {$EXTERNALSYM BDA_BCC_RATE_NOT_DEFINED}
    BDA_BCC_RATE_1_2         = 1;  // 1/2
    {$EXTERNALSYM BDA_BCC_RATE_1_2}
    BDA_BCC_RATE_2_3         = 2;  // 2/3
    {$EXTERNALSYM BDA_BCC_RATE_2_3}
    BDA_BCC_RATE_3_4         = 3;  // 3/4
    {$EXTERNALSYM BDA_BCC_RATE_3_4}
    BDA_BCC_RATE_3_5         = 4;
    {$EXTERNALSYM BDA_BCC_RATE_3_5}
    BDA_BCC_RATE_4_5         = 5;
    {$EXTERNALSYM BDA_BCC_RATE_4_5}
    BDA_BCC_RATE_5_6         = 6;  // 5/6
    {$EXTERNALSYM BDA_BCC_RATE_5_6}
    BDA_BCC_RATE_5_11        = 7;
    {$EXTERNALSYM BDA_BCC_RATE_5_11}
    BDA_BCC_RATE_7_8         = 8;  // 7/8
    {$EXTERNALSYM BDA_BCC_RATE_7_8}
    BDA_BCC_RATE_MAX         = 9;
    {$EXTERNALSYM BDA_BCC_RATE_MAX}

type
  FECMethod = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM FECMethod}
  const
    BDA_FEC_METHOD_NOT_SET     = -1;
    {$EXTERNALSYM BDA_FEC_METHOD_NOT_SET}
    BDA_FEC_METHOD_NOT_DEFINED = 0;
    {$EXTERNALSYM BDA_FEC_METHOD_NOT_DEFINED}
    BDA_FEC_VITERBI            = 1; // FEC is a Viterbi Binary Convolution.
    {$EXTERNALSYM BDA_FEC_VITERBI}
    BDA_FEC_RS_204_188         = 2; // The FEC is Reed-Solomon 204/188 (outer FEC)
    {$EXTERNALSYM BDA_FEC_RS_204_188}
    BDA_FEC_MAX                = 3;
    {$EXTERNALSYM BDA_FEC_MAX}

type
  ModulationType = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM ModulationType}
  const
    BDA_MOD_NOT_SET          = -1;
    {$EXTERNALSYM BDA_MOD_NOT_SET}
    BDA_MOD_NOT_DEFINED      = 0;
    {$EXTERNALSYM BDA_MOD_NOT_DEFINED}
    BDA_MOD_16QAM            = 1;
    {$EXTERNALSYM BDA_MOD_16QAM}
    BDA_MOD_32QAM            = 2;
    {$EXTERNALSYM BDA_MOD_32QAM}
    BDA_MOD_64QAM            = 3;
    {$EXTERNALSYM BDA_MOD_64QAM}
    BDA_MOD_80QAM            = 4;
    {$EXTERNALSYM BDA_MOD_80QAM}
    BDA_MOD_96QAM            = 5;
    {$EXTERNALSYM BDA_MOD_96QAM}
    BDA_MOD_112QAM           = 6;
    {$EXTERNALSYM BDA_MOD_112QAM}
    BDA_MOD_128QAM           = 7;
    {$EXTERNALSYM BDA_MOD_128QAM}
    BDA_MOD_160QAM           = 8;
    {$EXTERNALSYM BDA_MOD_160QAM}
    BDA_MOD_192QAM           = 9;
    {$EXTERNALSYM BDA_MOD_192QAM}
    BDA_MOD_224QAM           = 10;
    {$EXTERNALSYM BDA_MOD_224QAM}
    BDA_MOD_256QAM           = 11;
    {$EXTERNALSYM BDA_MOD_256QAM}
    BDA_MOD_320QAM           = 12;
    {$EXTERNALSYM BDA_MOD_320QAM}
    BDA_MOD_384QAM           = 13;
    {$EXTERNALSYM BDA_MOD_384QAM}
    BDA_MOD_448QAM           = 14;
    {$EXTERNALSYM BDA_MOD_448QAM}
    BDA_MOD_512QAM           = 15;
    {$EXTERNALSYM BDA_MOD_512QAM}
    BDA_MOD_640QAM           = 16;
    {$EXTERNALSYM BDA_MOD_640QAM}
    BDA_MOD_768QAM           = 17;
    {$EXTERNALSYM BDA_MOD_768QAM}
    BDA_MOD_896QAM           = 18;
    {$EXTERNALSYM BDA_MOD_896QAM}
    BDA_MOD_1024QAM          = 19;
    {$EXTERNALSYM BDA_MOD_1024QAM}
    BDA_MOD_QPSK             = 20;
    {$EXTERNALSYM BDA_MOD_QPSK}
    BDA_MOD_BPSK             = 21;
    {$EXTERNALSYM BDA_MOD_BPSK}
    BDA_MOD_OQPSK            = 22;
    {$EXTERNALSYM BDA_MOD_OQPSK}
    BDA_MOD_8VSB             = 23;
    {$EXTERNALSYM BDA_MOD_8VSB}
    BDA_MOD_16VSB            = 24;
    {$EXTERNALSYM BDA_MOD_16VSB}
    BDA_MOD_ANALOG_AMPLITUDE = 25; // std am
    {$EXTERNALSYM BDA_MOD_ANALOG_AMPLITUDE}
    BDA_MOD_ANALOG_FREQUENCY = 26; // std fm
    {$EXTERNALSYM BDA_MOD_ANALOG_FREQUENCY}
    BDA_MOD_MAX              = 27;
    {$EXTERNALSYM BDA_MOD_MAX}

Type
  SpectralInversion = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM SpectralInversion}
  const
    BDA_SPECTRAL_INVERSION_NOT_SET     = -1;
    {$EXTERNALSYM BDA_SPECTRAL_INVERSION_NOT_SET}
    BDA_SPECTRAL_INVERSION_NOT_DEFINED = 0;
    {$EXTERNALSYM BDA_SPECTRAL_INVERSION_NOT_DEFINED}
    BDA_SPECTRAL_INVERSION_AUTOMATIC   = 1;
    {$EXTERNALSYM BDA_SPECTRAL_INVERSION_AUTOMATIC}
    BDA_SPECTRAL_INVERSION_NORMAL      = 2;
    {$EXTERNALSYM BDA_SPECTRAL_INVERSION_NORMAL}
    BDA_SPECTRAL_INVERSION_INVERTED    = 3;
    {$EXTERNALSYM BDA_SPECTRAL_INVERSION_INVERTED}
    BDA_SPECTRAL_INVERSION_MAX         = 4;
    {$EXTERNALSYM BDA_SPECTRAL_INVERSION_MAX}

Type
  Polarisation = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM Polarisation}
  const
    BDA_POLARISATION_NOT_SET     = -1;
    {$EXTERNALSYM BDA_POLARISATION_NOT_SET}
    BDA_POLARISATION_NOT_DEFINED = 0;
    {$EXTERNALSYM BDA_POLARISATION_NOT_DEFINED}
    BDA_POLARISATION_LINEAR_H    = 1; // Linear horizontal polarisation
    {$EXTERNALSYM BDA_POLARISATION_LINEAR_H}
    BDA_POLARISATION_LINEAR_V    = 2; // Linear vertical polarisation
    {$EXTERNALSYM BDA_POLARISATION_LINEAR_V}
    BDA_POLARISATION_CIRCULAR_L  = 3; // Circular left polarisation
    {$EXTERNALSYM BDA_POLARISATION_CIRCULAR_L}
    BDA_POLARISATION_CIRCULAR_R  = 4; // Circular right polarisation
    {$EXTERNALSYM BDA_POLARISATION_CIRCULAR_R}
    BDA_POLARISATION_MAX         = 5;
    {$EXTERNALSYM BDA_POLARISATION_MAX}

type
  GuardInterval = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM GuardInterval}
  const
    BDA_GUARD_NOT_SET     = -1;
    {$EXTERNALSYM BDA_GUARD_NOT_SET}
    BDA_GUARD_NOT_DEFINED = 0;
    {$EXTERNALSYM BDA_GUARD_NOT_DEFINED}
    BDA_GUARD_1_32        = 1; // Guard interval is 1/32
    {$EXTERNALSYM BDA_GUARD_1_32}
    BDA_GUARD_1_16        = 2; // Guard interval is 1/16
    {$EXTERNALSYM BDA_GUARD_1_16}
    BDA_GUARD_1_8         = 3; // Guard interval is 1/8
    {$EXTERNALSYM BDA_GUARD_1_8}
    BDA_GUARD_1_4         = 4; // Guard interval is 1/4
    {$EXTERNALSYM BDA_GUARD_1_4}
    BDA_GUARD_MAX         = 5;
    {$EXTERNALSYM BDA_GUARD_MAX}

type
  HierarchyAlpha = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM HierarchyAlpha}
  const
    BDA_HALPHA_NOT_SET     = -1;
    {$EXTERNALSYM BDA_HALPHA_NOT_SET}
    BDA_HALPHA_NOT_DEFINED = 0;
    {$EXTERNALSYM BDA_HALPHA_NOT_DEFINED}
    BDA_HALPHA_1           = 1; // Hierarchy alpha is 1.
    {$EXTERNALSYM BDA_HALPHA_1}
    BDA_HALPHA_2           = 2; // Hierarchy alpha is 2.
    {$EXTERNALSYM BDA_HALPHA_2}
    BDA_HALPHA_4           = 3; // Hierarchy alpha is 4.
    {$EXTERNALSYM BDA_HALPHA_4}
    BDA_HALPHA_MAX         = 4;
    {$EXTERNALSYM BDA_HALPHA_MAX}

type
  TransmissionMode = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM TransmissionMode}
  const
    BDA_XMIT_MODE_NOT_SET     = -1;
    {$EXTERNALSYM BDA_XMIT_MODE_NOT_SET}
    BDA_XMIT_MODE_NOT_DEFINED = 0;
    {$EXTERNALSYM BDA_XMIT_MODE_NOT_DEFINED}
    BDA_XMIT_MODE_2K          = 1; // Transmission uses 1705 carriers (use a 2K FFT)
    {$EXTERNALSYM BDA_XMIT_MODE_2K}
    BDA_XMIT_MODE_8K          = 2; // Transmission uses 6817 carriers (use an 8K FFT)
    {$EXTERNALSYM BDA_XMIT_MODE_8K}
    BDA_XMIT_MODE_MAX         = 3;
    {$EXTERNALSYM BDA_XMIT_MODE_MAX}


//  Settings for Tuner Frequency
//

  BDA_FREQUENCY_NOT_SET      = -1;
  {$EXTERNALSYM BDA_FREQUENCY_NOT_SET}
  BDA_FREQUENCY_NOT_DEFINED  = 0;
  {$EXTERNALSYM BDA_FREQUENCY_NOT_DEFINED}

//  Settings for Tuner Range
//
//  Tuner range refers to the setting of LNB High/Low as well as the
//  selection of a satellite on a multiple satellite switch.
//
  BDA_RANGE_NOT_SET      = -1;
  {$EXTERNALSYM BDA_RANGE_NOT_SET}
  BDA_RANGE_NOT_DEFINED  = 0;
  {$EXTERNALSYM BDA_RANGE_NOT_DEFINED}

//  Settings for Tuner Channel Bandwidth
//
  BDA_CHAN_BANDWITH_NOT_SET      = -1;
  {$EXTERNALSYM BDA_CHAN_BANDWITH_NOT_SET}
  BDA_CHAN_BANDWITH_NOT_DEFINED  = 0;
  {$EXTERNALSYM BDA_CHAN_BANDWITH_NOT_DEFINED}

//  Settings for Tuner Frequency Multiplier
//
  BDA_FREQUENCY_MULTIPLIER_NOT_SET       = -1;
  {$EXTERNALSYM BDA_FREQUENCY_MULTIPLIER_NOT_SET}
  BDA_FREQUENCY_MULTIPLIER_NOT_DEFINED   = 0;
  {$EXTERNALSYM BDA_FREQUENCY_MULTIPLIER_NOT_DEFINED}

//------------------------------------------------------------------------------
// File: Regbag.h
// Desc: part of Tuner library
// Copyright (c) 1999 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

const
  IID_ICreatePropBagOnRegKey : TGUID = '{8A674B48-1F63-11d3-B64C-00C04F79498E}';
  {$EXTERNALSYM IID_ICreatePropBagOnRegKey}

type
  {$HPPEMIT 'typedef System::DelphiInterface<ICreatePropBagOnRegKey> _di_ICreatePropBagOnRegKey;'}
  {$EXTERNALSYM ICreatePropBagOnRegKey}
  ICreatePropBagOnRegKey = interface(IUnknown)
    ['{8A674B48-1F63-11d3-B64C-00C04F79498E}']
    (*** ICreatePropBagOnRegKey methods ***)
    function Create(hkey: HKEY; subkey: POleStr; ulOptions, samDesired: DWORD;
             const iid: TGUID; out ppBag): HResult; stdcall;
    end;

//------------------------------------------------------------------------------
// File: Tuner.h
// Desc: Tuner library
// Copyright (c) 1999 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

const
  IID_ITuningSpaces            : TGUID = '{901284E4-33FE-4b69-8D63-634A596F3756}';
  {$EXTERNALSYM IID_ITuningSpaces}
  IID_ITuningSpaceContainer    : TGUID = '{5B692E84-E2F1-11d2-9493-00C04F72D980}';
  {$EXTERNALSYM IID_ITuningSpaceContainer}
  IID_ITuningSpace             : TGUID = '{061C6E30-E622-11d2-9493-00C04F72D980}';
  {$EXTERNALSYM IID_ITuningSpace}
  IID_IEnumTuningSpaces        : TGUID = '{8B8EB248-FC2B-11d2-9D8C-00C04F72D980}';
  {$EXTERNALSYM IID_IEnumTuningSpaces}
  IID_IDVBTuningSpace          : TGUID = '{ADA0B268-3B19-4e5b-ACC4-49F852BE13BA}';
  {$EXTERNALSYM IID_IDVBTuningSpace}
  IID_IAnalogTVTuningSpace     : TGUID = '{2A6E293C-2595-11d3-B64C-00C04F79498E}';
  {$EXTERNALSYM IID_IAnalogTVTuningSpace}
  IID_IATSCTuningSpace         : TGUID = '{0369B4E2-45B6-11d3-B650-00C04F79498E}';
  {$EXTERNALSYM IID_IATSCTuningSpace}
  IID_IAnalogRadioTuningSpace  : TGUID = '{2A6E293B-2595-11d3-B64C-00C04F79498E}';
  {$EXTERNALSYM IID_IAnalogRadioTuningSpace}
  IID_ITuneRequest             : TGUID = '{07DDC146-FC3D-11d2-9D8C-00C04F72D980}';
  {$EXTERNALSYM IID_ITuneRequest}
  IID_IChannelTuneRequest      : TGUID = '{0369B4E0-45B6-11d3-B650-00C04F79498E}';
  {$EXTERNALSYM IID_IChannelTuneRequest}
  IID_IATSCChannelTuneRequest  : TGUID = '{0369B4E1-45B6-11d3-B650-00C04F79498E}';
  {$EXTERNALSYM IID_IATSCChannelTuneRequest}
  IID_IDVBTuneRequest          : TGUID = '{0D6F567E-A636-42bb-83BA-CE4C1704AFA2}';
  {$EXTERNALSYM IID_IDVBTuneRequest}
  IID_ITuner                   : TGUID = '{28C52640-018A-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM IID_ITuner}
  IID_IScanningTuner           : TGUID = '{1DFD0A5C-0284-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM IID_IScanningTuner}
  IID_ITunerEvents             : TGUID = '{68481420-0280-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM IID_ITunerEvents}
  IID_ISignalEvents            : TGUID = '{85E2439E-0E23-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM IID_ISignalEvents}
  IID_IComponentType           : TGUID = '{6A340DC0-0311-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM IID_IComponentType}
  IID_ILanguageComponentType   : TGUID = '{B874C8BA-0FA2-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM IID_ILanguageComponentType}
  IID_IMPEG2ComponentType      : TGUID = '{2C073D84-B51C-48c9-AA9F-68971E1F6E38}';
  {$EXTERNALSYM IID_IMPEG2ComponentType}
  IID_IATSCComponentType       : TGUID = '{FC189E4D-7BD4-4125-B3B3-3A76A332CC96}';
  {$EXTERNALSYM IID_IATSCComponentType}
  IID_IEnumComponentTypes      : TGUID = '{8A674B4A-1F63-11d3-B64C-00C04F79498E}';
  {$EXTERNALSYM IID_IEnumComponentTypes}
  IID_IComponentTypes          : TGUID = '{0DC13D4A-0313-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM IID_IComponentTypes}
  IID_IComponent               : TGUID = '{1A5576FC-0E19-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM IID_IComponent}
  IID_IMPEG2Component          : TGUID = '{1493E353-1EB6-473c-802D-8E6B8EC9D2A9}';
  {$EXTERNALSYM IID_IMPEG2Component}
  IID_IEnumComponents          : TGUID = '{2A6E2939-2595-11d3-B64C-00C04F79498E}';
  {$EXTERNALSYM IID_IEnumComponents}
  IID_IComponents              : TGUID = '{FCD01846-0E19-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM IID_IComponents}
  IID_ILocator                 : TGUID = '{286D7F89-760C-4F89-80C4-66841D2507AA}';
  {$EXTERNALSYM IID_ILocator}
  IID_IATSCLocator             : TGUID = '{BF8D986F-8C2B-4131-94D7-4D3D9FCC21EF}';
  {$EXTERNALSYM IID_IATSCLocator}
  IID_IDVBTLocator             : TGUID = '{8664DA16-DDA2-42ac-926A-C18F9127C302}';
  {$EXTERNALSYM IID_IDVBTLocator}
  IID_IDVBSLocator             : TGUID = '{3D7C353C-0D04-45f1-A742-F97CC1188DC8}';
  {$EXTERNALSYM IID_IDVBSLocator}
  IID_IDVBCLocator             : TGUID = '{6E42F36E-1DD2-43c4-9F78-69D25AE39034}';
  {$EXTERNALSYM IID_IDVBCLocator}

  IID_IDVBTuningSpace2         : TGUID = '{843188B4-CE62-43db-966B-8145A094E040}';
  {$EXTERNALSYM IID_IDVBTuningSpace2}
  IID_IDVBSTuningSpace         : TGUID = '{CDF7BE60-D954-42fd-A972-78971958E470}';
  {$EXTERNALSYM IID_IDVBSTuningSpace}
  IID_IMPEG2TuneRequest        : TGUID = '{EB7D987F-8A01-42AD-B8AE-574DEEE44D1A}';
  {$EXTERNALSYM IID_IMPEG2TuneRequest}
  IID_IMPEG2TuneRequestFactory : TGUID = '{14E11ABD-EE37-4893-9EA1-6964DE933E39}';
  {$EXTERNALSYM IID_IMPEG2TuneRequestFactory}
  IID_IMPEG2TuneRequestSupport : TGUID = '{1B9D5FC3-5BBC-4b6c-BB18-B9D10E3EEEBF}';
  {$EXTERNALSYM IID_IMPEG2TuneRequestSupport}
  IID_IBroadcastEvent          : TGUID = '{3B21263F-26E8-489d-AAC4-924F7EFD9511}';
  {$EXTERNALSYM IID_IBroadcastEvent}

  IID_IAuxInTuningSpace        : TGUID = '{E48244B8-7E17-4f76-A763-5090FF1E2F30}'; // DX9
  {$EXTERNALSYM IID_IAuxInTuningSpace}

  CLSID_SystemTuningSpaces     : TGUID = '{D02AAC50-027E-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM CLSID_SystemTuningSpaces}
  CLSID_TuningSpace            : TGUID = '{5FFDC5E6-B83A-4b55-B6E8-C69E765FE9DB}';
  {$EXTERNALSYM CLSID_TuningSpace}
  CLSID_ATSCTuningSpace        : TGUID = '{A2E30750-6C3D-11d3-B653-00C04F79498E}';
  {$EXTERNALSYM CLSID_ATSCTuningSpace}
  CLSID_AnalogRadioTuningSpace : TGUID = '{8A674B4C-1F63-11d3-B64C-00C04F79498E}';
  {$EXTERNALSYM CLSID_AnalogRadioTuningSpace}
  CLSID_AnalogTVTuningSpace    : TGUID = '{8A674B4D-1F63-11d3-B64C-00C04F79498E}';
  {$EXTERNALSYM CLSID_AnalogTVTuningSpace}
  CLSID_DVBTuningSpace         : TGUID = '{C6B14B32-76AA-4a86-A7AC-5C79AAF58DA7}';
  {$EXTERNALSYM CLSID_DVBTuningSpace}
  CLSID_ComponentTypes         : TGUID = '{A1A2B1C4-0E3A-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM CLSID_ComponentTypes}
  CLSID_ComponentType          : TGUID = '{823535A0-0318-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM CLSID_ComponentType}
  CLSID_LanguageComponentType  : TGUID = '{1BE49F30-0E1B-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM CLSID_LanguageComponentType}
  CLSID_MPEG2ComponentType     : TGUID = '{418008F3-CF67-4668-9628-10DC52BE1D08}';
  {$EXTERNALSYM CLSID_MPEG2ComponentType}
  CLSID_ATSCComponentType      : TGUID = '{A8DCF3D5-0780-4ef4-8A83-2CFFAACB8ACE}';
  {$EXTERNALSYM CLSID_ATSCComponentType}
  CLSID_Components             : TGUID = '{809B6661-94C4-49e6-B6EC-3F0F862215AA}';
  {$EXTERNALSYM CLSID_Components}
  CLSID_Component              : TGUID = '{59DC47A8-116C-11d3-9D8E-00C04F72D980}';
  {$EXTERNALSYM CLSID_Component}
  CLSID_MPEG2Component         : TGUID = '{055CB2D7-2969-45cd-914B-76890722F112}';
  {$EXTERNALSYM CLSID_MPEG2Component}
  CLSID_TuneRequest            : TGUID = '{B46E0D38-AB35-4a06-A137-70576B01B39F}';
  {$EXTERNALSYM CLSID_TuneRequest}
  CLSID_ChannelTuneRequest     : TGUID = '{0369B4E5-45B6-11d3-B650-00C04F79498E}';
  {$EXTERNALSYM CLSID_ChannelTuneRequest}
  CLSID_ATSCChannelTuneRequest : TGUID = '{0369B4E6-45B6-11d3-B650-00C04F79498E}';
  {$EXTERNALSYM CLSID_ATSCChannelTuneRequest}
  CLSID_Locator                : TGUID = '{0888C883-AC4F-4943-B516-2C38D9B34562}';
  {$EXTERNALSYM CLSID_Locator}
  CLSID_ATSCLocator            : TGUID = '{8872FF1B-98FA-4d7a-8D93-C9F1055F85BB}';
  {$EXTERNALSYM CLSID_ATSCLocator}
  CLSID_DVBTLocator            : TGUID = '{9CD64701-BDF3-4d14-8E03-F12983D86664}';
  {$EXTERNALSYM CLSID_DVBTLocator}
  CLSID_DVBSLocator            : TGUID = '{1DF7D126-4050-47f0-A7CF-4C4CA9241333}';
  {$EXTERNALSYM CLSID_DVBSLocator}
  CLSID_DVBCLocator            : TGUID = '{C531D9FD-9685-4028-8B68-6E1232079F1E}';
  {$EXTERNALSYM CLSID_DVBCLocator}
  CLSID_DVBTuneRequest         : TGUID = '{15D6504A-5494-499c-886C-973C9E53B9F1}';
  {$EXTERNALSYM CLSID_DVBTuneRequest}
  CLSID_CreatePropBagOnRegKey  : TGUID = '{8A674B49-1F63-11d3-B64C-00C04F79498E}';
  {$EXTERNALSYM CLSID_CreatePropBagOnRegKey}

  CLSID_DVBSTuningSpace        : TGUID = '{B64016F3-C9A2-4066-96F0-BD9563314726}';
  {$EXTERNALSYM CLSID_DVBSTuningSpace}
  CLSID_MPEG2TuneRequest       : TGUID = '{0955AC62-BF2E-4CBA-A2B9-A63F772D46CF}';
  {$EXTERNALSYM CLSID_MPEG2TuneRequest}
  CLSID_BroadcastEventService  : TGUID = '{0B3FFB92-0919-4934-9D5B-619C719D0202}';
  {$EXTERNALSYM CLSID_BroadcastEventService}
  CLSID_MPEG2TuneRequestFactory: TGUID = '{2C63E4EB-4CEA-41B8-919C-E947EA19A77C}';
  {$EXTERNALSYM CLSID_MPEG2TuneRequestFactory}

  CLSID_AuxInTuningSpace       : TGUID = '{F9769A06-7ACA-4e39-9CFB-97BB35F0E77E}';
  {$EXTERNALSYM CLSID_AuxInTuningSpace}

  DISPID_TUNER_TS_UNIQUENAME	                    = 1;
  {$EXTERNALSYM DISPID_TUNER_TS_UNIQUENAME}
  DISPID_TUNER_TS_FRIENDLYNAME	                  = 2;
  {$EXTERNALSYM DISPID_TUNER_TS_FRIENDLYNAME}
  DISPID_TUNER_TS_CLSID	                          = 3;
  {$EXTERNALSYM DISPID_TUNER_TS_CLSID}
  DISPID_TUNER_TS_NETWORKTYPE	                    = 4;
  {$EXTERNALSYM DISPID_TUNER_TS_NETWORKTYPE}
  DISPID_TUNER_TS__NETWORKTYPE	                  = 5;
  {$EXTERNALSYM DISPID_TUNER_TS__NETWORKTYPE}
  DISPID_TUNER_TS_CREATETUNEREQUEST	              = 6;
  {$EXTERNALSYM DISPID_TUNER_TS_CREATETUNEREQUEST}
  DISPID_TUNER_TS_ENUMCATEGORYGUIDS	              = 7;
  {$EXTERNALSYM DISPID_TUNER_TS_ENUMCATEGORYGUIDS}
  DISPID_TUNER_TS_ENUMDEVICEMONIKERS	            = 8;
  {$EXTERNALSYM DISPID_TUNER_TS_ENUMDEVICEMONIKERS}
  DISPID_TUNER_TS_DEFAULTPREFERREDCOMPONENTTYPES	= 9;
  {$EXTERNALSYM DISPID_TUNER_TS_DEFAULTPREFERREDCOMPONENTTYPES}
  DISPID_TUNER_TS_FREQMAP	                        = 10;
  {$EXTERNALSYM DISPID_TUNER_TS_FREQMAP}
  DISPID_TUNER_TS_DEFLOCATOR	                    = 11;
  {$EXTERNALSYM DISPID_TUNER_TS_DEFLOCATOR}
  DISPID_TUNER_TS_CLONE	                          = 12;
  {$EXTERNALSYM DISPID_TUNER_TS_CLONE}

  // DISPIDs for ITuneRequest interface
  DISPID_TUNER_TR_TUNINGSPACE	                    = 1;
  {$EXTERNALSYM DISPID_TUNER_TR_TUNINGSPACE}
  DISPID_TUNER_TR_COMPONENTS	                    = 2;
  {$EXTERNALSYM DISPID_TUNER_TR_COMPONENTS}
  DISPID_TUNER_TR_CLONE	                          = 3;
  {$EXTERNALSYM DISPID_TUNER_TR_CLONE}
  DISPID_TUNER_TR_LOCATOR	                        = 4;
  {$EXTERNALSYM DISPID_TUNER_TR_LOCATOR}

  // DISPID for IComponentType interface
  DISPID_TUNER_CT_CATEGORY	                      = 1;
  {$EXTERNALSYM DISPID_TUNER_CT_CATEGORY}
  DISPID_TUNER_CT_MEDIAMAJORTYPE	                = 2;
  {$EXTERNALSYM DISPID_TUNER_CT_MEDIAMAJORTYPE}
  DISPID_TUNER_CT__MEDIAMAJORTYPE	                = 3;
  {$EXTERNALSYM DISPID_TUNER_CT__MEDIAMAJORTYPE}
  DISPID_TUNER_CT_MEDIASUBTYPE	                  = 4;
  {$EXTERNALSYM DISPID_TUNER_CT_MEDIASUBTYPE}
  DISPID_TUNER_CT__MEDIASUBTYPE	                  = 5;
  {$EXTERNALSYM DISPID_TUNER_CT__MEDIASUBTYPE}
  DISPID_TUNER_CT_MEDIAFORMATTYPE	                = 6;
  {$EXTERNALSYM DISPID_TUNER_CT_MEDIAFORMATTYPE}
  DISPID_TUNER_CT__MEDIAFORMATTYPE	              = 7;
  {$EXTERNALSYM DISPID_TUNER_CT__MEDIAFORMATTYPE}
  DISPID_TUNER_CT_MEDIATYPE	                      = 8;
  {$EXTERNALSYM DISPID_TUNER_CT_MEDIATYPE}
  DISPID_TUNER_CT_CLONE	                          = 9;
  {$EXTERNALSYM DISPID_TUNER_CT_CLONE}

  // DISPID for ILanguageComponentType interface
  DISPID_TUNER_LCT_LANGID	                        = 100;
  {$EXTERNALSYM DISPID_TUNER_LCT_LANGID}

  // DISPID for IMPEG2ComponentType interface
  DISPID_TUNER_MP2CT_TYPE	                        = 200;
  {$EXTERNALSYM DISPID_TUNER_MP2CT_TYPE}

  // DISPID for IATSCComponentType interface
  DISPID_TUNER_ATSCCT_FLAGS	                = 300;
  {$EXTERNALSYM DISPID_TUNER_ATSCCT_FLAGS}

  // DISPID for ILocator interface
  DISPID_TUNER_L_CARRFREQ	       = 1;
  {$EXTERNALSYM DISPID_TUNER_L_CARRFREQ}
  DISPID_TUNER_L_INNERFECMETHOD	 = 2;
  {$EXTERNALSYM DISPID_TUNER_L_INNERFECMETHOD}
  DISPID_TUNER_L_INNERFECRATE	   = 3;
  {$EXTERNALSYM DISPID_TUNER_L_INNERFECRATE}
  DISPID_TUNER_L_OUTERFECMETHOD	 = 4;
  {$EXTERNALSYM DISPID_TUNER_L_OUTERFECMETHOD}
  DISPID_TUNER_L_OUTERFECRATE	   = 5;
  {$EXTERNALSYM DISPID_TUNER_L_OUTERFECRATE}
  DISPID_TUNER_L_MOD	           = 6;
  {$EXTERNALSYM DISPID_TUNER_L_MOD}
  DISPID_TUNER_L_SYMRATE	       = 7;
  {$EXTERNALSYM DISPID_TUNER_L_SYMRATE}
  DISPID_TUNER_L_CLONE	         = 8;
  {$EXTERNALSYM DISPID_TUNER_L_CLONE}

  // DISPID for IATSCLocator interface
  DISPID_TUNER_L_ATSC_PHYS_CHANNEL	     = 201;
  {$EXTERNALSYM DISPID_TUNER_L_ATSC_PHYS_CHANNEL}
  DISPID_TUNER_L_ATSC_TSID	             = 202;
  {$EXTERNALSYM DISPID_TUNER_L_ATSC_TSID}

  // DISPID for IDVBTLocator interface
  DISPID_TUNER_L_DVBT_BANDWIDTH	         = 301;
  {$EXTERNALSYM DISPID_TUNER_L_DVBT_BANDWIDTH}
  DISPID_TUNER_L_DVBT_LPINNERFECMETHOD	 = 302;
  {$EXTERNALSYM DISPID_TUNER_L_DVBT_LPINNERFECMETHOD}
  DISPID_TUNER_L_DVBT_LPINNERFECRATE	   = 303;
  {$EXTERNALSYM DISPID_TUNER_L_DVBT_LPINNERFECRATE}
  DISPID_TUNER_L_DVBT_GUARDINTERVAL	     = 304;
  {$EXTERNALSYM DISPID_TUNER_L_DVBT_GUARDINTERVAL}
  DISPID_TUNER_L_DVBT_HALPHA	           = 305;
  {$EXTERNALSYM DISPID_TUNER_L_DVBT_HALPHA}
  DISPID_TUNER_L_DVBT_TRANSMISSIONMODE	 = 306;
  {$EXTERNALSYM DISPID_TUNER_L_DVBT_TRANSMISSIONMODE}
  DISPID_TUNER_L_DVBT_INUSE	             = 307;
  {$EXTERNALSYM DISPID_TUNER_L_DVBT_INUSE}

  // DISPID for IDVBSLocator interface
  DISPID_TUNER_L_DVBS_POLARISATION	     = 401;
  {$EXTERNALSYM DISPID_TUNER_L_DVBS_POLARISATION}
  DISPID_TUNER_L_DVBS_WEST	             = 402;
  {$EXTERNALSYM DISPID_TUNER_L_DVBS_WEST}
  DISPID_TUNER_L_DVBS_ORBITAL	           = 403;
  {$EXTERNALSYM DISPID_TUNER_L_DVBS_ORBITAL}
  DISPID_TUNER_L_DVBS_AZIMUTH	           = 404;
  {$EXTERNALSYM DISPID_TUNER_L_DVBS_AZIMUTH}
  DISPID_TUNER_L_DVBS_ELEVATION	         = 405;
  {$EXTERNALSYM DISPID_TUNER_L_DVBS_ELEVATION}

  // DISPID for IDVBCLocator interface

  // DISPIDs for IComponent interface
  DISPID_TUNER_C_TYPE	                   = 1;
  {$EXTERNALSYM DISPID_TUNER_C_TYPE}
  DISPID_TUNER_C_STATUS	                 = 2;
  {$EXTERNALSYM DISPID_TUNER_C_STATUS}
  DISPID_TUNER_C_LANGID	                 = 3;
  {$EXTERNALSYM DISPID_TUNER_C_LANGID}
  DISPID_TUNER_C_DESCRIPTION	           = 4;
  {$EXTERNALSYM DISPID_TUNER_C_DESCRIPTION}
  DISPID_TUNER_C_CLONE	                 = 5;
  {$EXTERNALSYM DISPID_TUNER_C_CLONE}

  // DISPIDs for IMPEG2Component interface
  DISPID_TUNER_C_MP2_PID	               = 101;
  {$EXTERNALSYM DISPID_TUNER_C_MP2_PID}
  DISPID_TUNER_C_MP2_PCRPID	             = 102;
  {$EXTERNALSYM DISPID_TUNER_C_MP2_PCRPID}
  DISPID_TUNER_C_MP2_PROGNO	             = 103;
  {$EXTERNALSYM DISPID_TUNER_C_MP2_PROGNO}
  DISPID_TUNER_TS_DVB_SYSTEMTYPE	       = 101;
  {$EXTERNALSYM DISPID_TUNER_TS_DVB_SYSTEMTYPE}

  // DISPIDs for IDVBTuningSpace2 interface
  DISPID_TUNER_TS_DVB2_NETWORK_ID               = 102;
  {$EXTERNALSYM DISPID_TUNER_TS_DVB2_NETWORK_ID}
  // DISPIDs for IDVBSTuningSpace interface
  DISPID_TUNER_TS_DVBS_LOW_OSC_FREQ             = 1001;
  {$EXTERNALSYM DISPID_TUNER_TS_DVBS_LOW_OSC_FREQ}
  DISPID_TUNER_TS_DVBS_HI_OSC_FREQ              = 1002;
  {$EXTERNALSYM DISPID_TUNER_TS_DVBS_HI_OSC_FREQ}
  DISPID_TUNER_TS_DVBS_LNB_SWITCH_FREQ          = 1003;
  {$EXTERNALSYM DISPID_TUNER_TS_DVBS_LNB_SWITCH_FREQ}
  DISPID_TUNER_TS_DVBS_INPUT_RANGE              = 1004;
  {$EXTERNALSYM DISPID_TUNER_TS_DVBS_INPUT_RANGE}
  DISPID_TUNER_TS_DVBS_SPECTRAL_INVERSION       = 1005;
  {$EXTERNALSYM DISPID_TUNER_TS_DVBS_SPECTRAL_INVERSION}

  // DISPIDs for IAnalogRadioTuningSpace interface
  DISPID_TUNER_TS_AR_MINFREQUENCY	              = 101;
  {$EXTERNALSYM DISPID_TUNER_TS_AR_MINFREQUENCY}
  DISPID_TUNER_TS_AR_MAXFREQUENCY	              = 102;
  {$EXTERNALSYM DISPID_TUNER_TS_AR_MAXFREQUENCY}
  DISPID_TUNER_TS_AR_STEP	                      = 103;
  {$EXTERNALSYM DISPID_TUNER_TS_AR_STEP}

  // DISPIDs for IAnalogTVTuningSpace interface
  DISPID_TUNER_TS_ATV_MINCHANNEL	              = 101;
  {$EXTERNALSYM DISPID_TUNER_TS_ATV_MINCHANNEL}
  DISPID_TUNER_TS_ATV_MAXCHANNEL	              = 102;
  {$EXTERNALSYM DISPID_TUNER_TS_ATV_MAXCHANNEL}
  DISPID_TUNER_TS_ATV_INPUTTYPE	                = 103;
  {$EXTERNALSYM DISPID_TUNER_TS_ATV_INPUTTYPE}
  DISPID_TUNER_TS_ATV_COUNTRYCODE	              = 104;
  {$EXTERNALSYM DISPID_TUNER_TS_ATV_COUNTRYCODE}

  // DISPIDs for IATSCTuningSpace interface
  DISPID_TUNER_TS_ATSC_MINMINORCHANNEL	        = 201;
  {$EXTERNALSYM DISPID_TUNER_TS_ATSC_MINMINORCHANNEL}
  DISPID_TUNER_TS_ATSC_MAXMINORCHANNEL	        = 202;
  {$EXTERNALSYM DISPID_TUNER_TS_ATSC_MAXMINORCHANNEL}
  DISPID_TUNER_TS_ATSC_MINPHYSCHANNEL	          = 203;
  {$EXTERNALSYM DISPID_TUNER_TS_ATSC_MINPHYSCHANNEL}
  DISPID_TUNER_TS_ATSC_MAXPHYSCHANNEL	          = 204;
  {$EXTERNALSYM DISPID_TUNER_TS_ATSC_MAXPHYSCHANNEL}

  // DISPID for IAnalogTVAudioComponent interface
  DISPID_CHTUNER_ATVAC_CHANNEL	                = 101;
  {$EXTERNALSYM DISPID_CHTUNER_ATVAC_CHANNEL}

  // DISPIDs for IAnalogTVDataComponent interface
  DISPID_CHTUNER_ATVDC_SYSTEM	                  = 101;
  {$EXTERNALSYM DISPID_CHTUNER_ATVDC_SYSTEM}
  DISPID_CHTUNER_ATVDC_CONTENT	                = 102;
  {$EXTERNALSYM DISPID_CHTUNER_ATVDC_CONTENT}

  // DISPID for IChannelTuneRequest interface
  DISPID_CHTUNER_CTR_CHANNEL	                  = 101;
  {$EXTERNALSYM DISPID_CHTUNER_CTR_CHANNEL}

  // DISPID IATSCChannelTuneRequest
  DISPID_CHTUNER_ACTR_MINOR_CHANNEL	            = 201;
  {$EXTERNALSYM DISPID_CHTUNER_ACTR_MINOR_CHANNEL}

  // DISPIDs for IDVBComponent interface
  DISPID_DVBTUNER_DVBC_ATTRIBUTESVALID	        = 101;
  {$EXTERNALSYM DISPID_DVBTUNER_DVBC_ATTRIBUTESVALID}
  DISPID_DVBTUNER_DVBC_PID                 	    = 102;
  {$EXTERNALSYM DISPID_DVBTUNER_DVBC_PID}
  DISPID_DVBTUNER_DVBC_TAG	                    = 103;
  {$EXTERNALSYM DISPID_DVBTUNER_DVBC_TAG}
  DISPID_DVBTUNER_DVBC_COMPONENTTYPE	          = 104;
  {$EXTERNALSYM DISPID_DVBTUNER_DVBC_COMPONENTTYPE}

  // DISPIDs for IDVBTuneRequest interface
  DISPID_DVBTUNER_ONID	                        = 101;
  {$EXTERNALSYM DISPID_DVBTUNER_ONID}
  DISPID_DVBTUNER_TSID	                        = 102;
  {$EXTERNALSYM DISPID_DVBTUNER_TSID}
  DISPID_DVBTUNER_SID	                          = 103;
  {$EXTERNALSYM DISPID_DVBTUNER_SID}

  // DISPIDs for IMPEG2TuneRequest interface
  DISPID_MP2TUNER_TSID                          = 101;
  {$EXTERNALSYM DISPID_MP2TUNER_TSID}
  DISPID_MP2TUNER_PROGNO                        = 102;
  {$EXTERNALSYM DISPID_MP2TUNER_PROGNO}

  // DISPIDs for IMPEG2TuneRequestFactory interface
  DISPID_MP2TUNERFACTORY_CREATETUNEREQUEST      = 1;
  {$EXTERNALSYM DISPID_MP2TUNERFACTORY_CREATETUNEREQUEST}

type
  ITuningSpace = interface;
  IEnumTuningSpaces = interface;

  {$HPPEMIT 'typedef System::DelphiInterface<ITuningSpaces> _di_ITuningSpaces;'}
  {$EXTERNALSYM ITuningSpaces}
  ITuningSpaces = interface(IDispatch)
    ['{901284E4-33FE-4b69-8D63-634A596F3756}']
    (*** ITuningSpaces methods ***)
    function get_Count(out Count: longint): HResult; stdcall;
    function get__NewEnum(out NewEnum: IEnumVARIANT): HResult; stdcall;
    function get_Item(varIndex: OLEVARIANT; out TuningSpace: ITuningSpace): HResult; stdcall;
    function get_EnumTuningSpaces(out NewEnum: IEnumTuningSpaces): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<ITuningSpaceContainer> _di_ITuningSpaceContainer;'}
  {$EXTERNALSYM ITuningSpaceContainer}
  ITuningSpaceContainer = interface(IDispatch)
    ['{5B692E84-E2F1-11d2-9493-00C04F72D980}']
    (*** ITuningSpaceContainer methods ***)
    function get_Count(out Count: longint): HResult; stdcall;
    function get__NewEnum(out NewEnum: IEnumVARIANT): HResult; stdcall;
    function get_Item(varIndex: OLEVARIANT; out TuningSpace: ITuningSpace): HResult; stdcall;
    function put_Item(varIndex: OLEVARIANT; TuningSpace: ITuningSpace): HResult; stdcall;
    function TuningSpacesForCLSID(SpaceCLSID: widestring; out NewColl: ITuningSpaces): HResult; stdcall;
    function _TuningSpacesForCLSID(const SpaceCLSID: TGUID; out NewColl: ITuningSpaces): HResult; stdcall;
    function TuningSpacesForName(Name: WideString; out NewColl: ITuningSpaces): HResult; stdcall;
    function FindID(TuningSpace: ITuningSpace; out ID: longint): HResult; stdcall;
    function Add(TuningSpace: ITuningSpace; out NewIndex: OLEVARIANT): HResult; stdcall;
    function get_EnumTuningSpaces(out ppEnum: IEnumTuningSpaces): HResult; stdcall;
    function Remove(Index: OLEVARIANT): HResult; stdcall;
    function get_MaxCount(out MaxCount: longint): HResult; stdcall;
    function put_MaxCount(MaxCount: longint): HResult; stdcall;
   end;

  ITuneRequest = interface;
  IComponentTypes = interface;
  ILocator = interface;

  {$HPPEMIT 'typedef System::DelphiInterface<ITuningSpace> _di_ITuningSpace;'}
  {$EXTERNALSYM ITuningSpace}
  ITuningSpace = interface(IDispatch)
    ['{061C6E30-E622-11d2-9493-00C04F72D980}']
    (*** ITuningSpace methods ***)
    function get_UniqueName(out Name: WideString): HResult; stdcall;
    function put_UniqueName(Name: WideString): HResult; stdcall;
    function get_FriendlyName(out Name: WideString): HResult; stdcall;
    function put_FriendlyName(Name: WideString): HResult; stdcall;
    function get_CLSID(out SpaceCLSID: WideString): HResult; stdcall;
    function get_NetworkType(out NetworkTypeGuid: WideString): HResult; stdcall;
    function put_NetworkType(NetworkTypeGuid: WideString): HResult; stdcall;
    function get__NetworkType(out NetworkTypeGuid: WideString): HResult; stdcall;
    function put__NetworkType(const NetworkTypeGuid: WideString): HResult; stdcall;
    // this method creates the "best" kind of tune request for this tuning space.
    // the tuning space may support other kinds of tune requests created via
    // other factory mechanisms(for example, see mpeg2tunerequestfactory).  but,
    // this method is the preferred way to get a tune request as it always returns
    // the optimal type of tune request for this space.
    function CreateTuneRequest(out TuneRequest: ITuneRequest): HResult; stdcall;
    function EnumCategoryGUIDs(out ppEnum: IEnumGUID): HResult; stdcall;
    function EnumDeviceMonikers(out ppEnum: IEnumMoniker): HResult; stdcall;
    function get_DefaultPreferredComponentTypes(out ComponentTypes: IComponentTypes): HResult; stdcall;
    function put_DefaultPreferredComponentTypes(NewComponentTypes: IComponentTypes): HResult; stdcall;
    function get_FrequencyMapping(out pMapping: WideString): HResult; stdcall;
    function put_FrequencyMapping(Mapping: WideString): HResult; stdcall;
    function get_DefaultLocator(out LocatorVal: ILocator): HResult; stdcall;
    function put_DefaultLocator(LocatorVal: ILocator): HResult; stdcall;
    function Clone(out NewTS: ITuningSpace): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IEnumTuningSpaces> _di_IEnumTuningSpaces;'}
  {$EXTERNALSYM IEnumTuningSpaces}
  IEnumTuningSpaces = interface(IUnknown)
    ['{8B8EB248-FC2B-11d2-9D8C-00C04F72D980}']
    (*** IEnumTuningSpaces methods ***)
    function Next(celt: ULONG; out rgelt: ITuningSpace; out pceltFetched: ULONG): HResult; stdcall;
    function Skip(celt: ULONG): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out ppEnum: IEnumTuningSpaces): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDVBTuningSpace> _di_IDVBTuningSpace;'}
  {$EXTERNALSYM IDVBTuningSpace}
  IDVBTuningSpace = interface(ITuningSpace)
    ['{ADA0B268-3B19-4e5b-ACC4-49F852BE13BA}']
    (*** IDVBTuningSpace methods ***)
    function get_SystemType(out SysType: TDVBSystemType): HResult; stdcall;
    function put_SystemType(SysType: TDVBSystemType): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDVBTuningSpace2> _di_IDVBTuningSpace2;'}
  {$EXTERNALSYM IDVBTuningSpace2}
  IDVBTuningSpace2 = interface(IDVBTuningSpace)
    ['{843188B4-CE62-43db-966B-8145A094E040}']
    (*** IDVBTuningSpace2 methods ***)
    function get_NetworkID(out NetworkID: longint): HResult; stdcall;
    function put_NetworkID(NetworkID: longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDVBSTuningSpace> _di_IDVBSTuningSpace;'}
  {$EXTERNALSYM IDVBSTuningSpace}
  IDVBSTuningSpace = interface(IDVBTuningSpace2)
    ['{CDF7BE60-D954-42FD-A972-78971958E470}']
    (*** IDVBSTuningSpace methods ***)
    function  get_LowOscillator(out LowOscillator: longint): HResult; stdcall;
    function  put_LowOscillator(LowOscillator: longint): HResult; stdcall;
    function  get_HighOscillator(out HighOscillator: longint): HResult; stdcall;
    function  put_HighOscillator(HighOscillator: longint): HResult; stdcall;
    function  get_LNBSwitch(out LNBSwitch: longint): HResult; stdcall;
    function  put_LNBSwitch(LNBSwitch: longint): HResult; stdcall;
    function  get_InputRange(out InputRange: WideString): HResult; stdcall;
    function  put_InputRange(const InputRange: WideString): HResult; stdcall;
    function  get_SpectralInversion(out SpectralInversionVal: SpectralInversion): HResult; stdcall;
    function  put_SpectralInversion(SpectralInversionVal: SpectralInversion): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAuxInTuningSpace> _di_IAuxInTuningSpace;'}
  {$EXTERNALSYM IAuxInTuningSpace}
  IAuxInTuningSpace = interface(ITuningSpace)
    ['{E48244B8-7E17-4f76-A763-5090FF1E2F30}']
    (*** IAuxInTuningSpace methods ***)
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAnalogTVTuningSpace> _di_IAnalogTVTuningSpace;'}
  {$EXTERNALSYM IAnalogTVTuningSpace}
  IAnalogTVTuningSpace = interface(ITuningSpace)
    ['{2A6E293C-2595-11d3-B64C-00C04F79498E}']
    (*** IAnalogTVTuningSpace methods ***)
    function get_MinChannel(out MinChannelVal: longint): HResult; stdcall;
    function put_MinChannel(NewMinChannelVal: longint): HResult; stdcall;
    function get_MaxChannel(out MaxChannelVal: longint): HResult; stdcall;
    function put_MaxChannel(NewMaxChannelVal: longint): HResult; stdcall;
    function get_InputType(out InputTypeVal: TTunerInputType): HResult; stdcall;
    function put_InputType(NewInputTypeVal: TTunerInputType): HResult; stdcall;
    function get_CountryCode(out CountryCodeVal: longint): HResult; stdcall;
    function put_CountryCode(NewCountryCodeVal: longint): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IATSCTuningSpace> _di_IATSCTuningSpace;'}
  {$EXTERNALSYM IATSCTuningSpace}
  IATSCTuningSpace = interface(IAnalogTVTuningSpace)
    ['{0369B4E2-45B6-11d3-B650-00C04F79498E}']
    (*** IATSCTuningSpace methods ***)
    function get_MinMinorChannel(out MinMinorChannelVal: longint): HResult; stdcall;
    function put_MinMinorChannel(NewMinMinorChannelVal: longint): HResult; stdcall;
    function get_MaxMinorChannel(out MaxMinorChannelVal: longint): HResult; stdcall;
    function put_MaxMinorChannel(NewMaxMinorChannelVal: longint): HResult; stdcall;
    function get_MinPhysicalChannel(out MinPhysicalChannelVal: longint): HResult; stdcall;
    function put_MinPhysicalChannel(NewMinPhysicalChannelVal: longint): HResult; stdcall;
    function get_MaxPhysicalChannel(out MaxPhysicalChannelVal: longint): HResult; stdcall;
    function put_MaxPhysicalChannel(NewMaxPhysicalChannelVal: longint): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAnalogRadioTuningSpace> _di_IAnalogRadioTuningSpace;'}
  {$EXTERNALSYM IAnalogRadioTuningSpace}
  IAnalogRadioTuningSpace = interface(ITuningSpace)
    ['{2A6E293B-2595-11d3-B64C-00C04F79498E}']
    (*** IAnalogRadioTuningSpace methods ***)
    function get_MinFrequency(out MinFrequencyVal: longint): HResult; stdcall;
    function put_MinFrequency(NewMinFrequencyVal: longint): HResult; stdcall;
    function get_MaxFrequency(out MaxFrequencyVal: longint): HResult; stdcall;
    function put_MaxFrequency(NewMaxFrequencyVal: longint): HResult; stdcall;
    function get_Step(out StepVal: longint): HResult; stdcall;
    function put_Step(NewStepVal: longint): HResult; stdcall;
   end;

  IComponents = interface;

  //////////////////////////////////////////////////////////////////////////////////////
  // Tune Request Interfaces
  //////////////////////////////////////////////////////////////////////////////////////
  // tune requests(of any kind) can only be obtained from tune request factories such as
  // ITuningSpace::CreateTuneRequest.  one reason for this is that we always want to be
  // certain that a tune request is bound to the right tuning space.  this means we don't
  // have to perform consistency checks all over the place.

  {$HPPEMIT 'typedef System::DelphiInterface<ITuneRequest> _di_ITuneRequest;'}
  {$EXTERNALSYM ITuneRequest}
  ITuneRequest = interface(IDispatch)
    ['{07DDC146-FC3D-11d2-9D8C-00C04F72D980}']
    (*** ITuneRequest methods ***)
    function get_TuningSpace(out TuningSpace: ITuningSpace): HResult; stdcall;
    function get_Components(out Components: IComponents): HResult; stdcall;
    function Clone(out NewTuneRequest: ITuneRequest): HResult; stdcall;
    function get_Locator(out Locator: ILocator): HResult; stdcall;
    function put_Locator(Locator: ILocator): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IChannelTuneRequest> _di_IChannelTuneRequest;'}
  {$EXTERNALSYM IChannelTuneRequest}
  IChannelTuneRequest = interface(ITuneRequest)
    ['{0369B4E0-45B6-11d3-B650-00C04F79498E}']
    (*** IChannelTuneRequest methods ***)
    function get_Channel(out Channel: longint): HResult; stdcall;
    function put_Channel(Channel: longint): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IATSCChannelTuneRequest> _di_IATSCChannelTuneRequest;'}
  {$EXTERNALSYM IATSCChannelTuneRequest}
  IATSCChannelTuneRequest = interface(IChannelTuneRequest)
    ['{0369B4E1-45B6-11d3-B650-00C04F79498E}']
    (*** IATSCChannelTuneRequest methods ***)
    function get_MinorChannel(out MinorChannel: longint): HResult; stdcall;
    function put_MinorChannel(MinorChannel: longint): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDVBTuneRequest> _di_IDVBTuneRequest;'}
  {$EXTERNALSYM IDVBTuneRequest}
  IDVBTuneRequest = interface(ITuneRequest)
    ['{0D6F567E-A636-42bb-83BA-CE4C1704AFA2}']
    (*** IDVBTuneRequest methods ***)
    function get_ONID(out ONID: longint): HResult; stdcall;
    function put_ONID(ONID: longint): HResult; stdcall;
    function get_TSID(out TSID: longint): HResult; stdcall;
    function put_TSID(TSID: longint): HResult; stdcall;
    function get_SID(out SID: longint): HResult; stdcall;
    function put_SID(SID: longint): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMPEG2TuneRequest> _di_IMPEG2TuneRequest;'}
  {$EXTERNALSYM IMPEG2TuneRequest}
  IMPEG2TuneRequest = interface(ITuneRequest)
    ['{EB7D987F-8A01-42AD-B8AE-574DEEE44D1A}']
    (*** IMPEG2TuneRequest methods ***)
    function get_TSID: HResult; stdcall;
    function put_TSID(TSID: longint): HResult; stdcall;
    function get_ProgNo: HResult; stdcall;
    function put_ProgNo(ProgNo: longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMPEG2TuneRequestFactory> _di_IMPEG2TuneRequestFactory;'}
  {$EXTERNALSYM IMPEG2TuneRequestFactory}
  IMPEG2TuneRequestFactory = interface(IDispatch)
    ['{14E11ABD-EE37-4893-9EA1-6964DE933E39}']
    (*** IMPEG2TuneRequestFactory methods ***)
    function CreateTuneRequest(TuningSpace: ITuningSpace;
      out TuneRequest: IMPEG2TuneRequest): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMPEG2TuneRequestSupport> _di_IMPEG2TuneRequestSupport;'}
  {$EXTERNALSYM IMPEG2TuneRequestSupport}
  IMPEG2TuneRequestSupport = interface(IUnknown)
    ['{1B9D5FC3-5BBC-4b6c-BB18-B9D10E3EEEBF}']
    (*** IMPEG2TuneRequestSupport methods ***)
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<ITuner> _di_ITuner;'}
  {$EXTERNALSYM ITuner}
  ITuner = interface(IUnknown)
    ['{28C52640-018A-11d3-9D8E-00C04F72D980}']
    (*** ITuner methods ***)
    function get_TuningSpace(out TuningSpace: ITuningSpace): HResult; stdcall;
    function put_TuningSpace(TuningSpace: ITuningSpace): HResult; stdcall;
    function EnumTuningSpaces(out ppEnum: IEnumTuningSpaces): HResult; stdcall;
    function get_TuneRequest(out TuneRequest: ITuneRequest): HResult; stdcall;
    function put_TuneRequest(TuneRequest: ITuneRequest): HResult; stdcall;
    function Validate(TuneRequest: ITuneRequest): HResult; stdcall;
    function get_PreferredComponentTypes(out ComponentTypes: IComponentTypes): HResult; stdcall;
    function put_PreferredComponentTypes(ComponentTypes: IComponentTypes): HResult; stdcall;
    function get_SignalStrength(out Strength: longint): HResult; stdcall;
    function TriggerSignalEvents(Interval: longint): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IScanningTuner> _di_IScanningTuner;'}
  {$EXTERNALSYM IScanningTuner}
  IScanningTuner = interface(ITuner)
    ['{1DFD0A5C-0284-11d3-9D8E-00C04F72D980}']
    (*** IScanningTuner methods ***)
    function SeekUp: HResult; stdcall;
    function SeekDown: HResult; stdcall;
    function ScanUp(MillisecondsPause: longint): HResult; stdcall;
    function ScanDown(MillisecondsPause: longint): HResult; stdcall;
    function AutoProgram: HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IComponentType> _di_IComponentType;'}
  {$EXTERNALSYM IComponentType}
  IComponentType = interface(IDispatch)
    ['{6A340DC0-0311-11d3-9D8E-00C04F72D980}']
    (*** IComponentType methods ***)
    function get_Category(out Category: ComponentCategory): HResult; stdcall;
    function put_Category(Category: ComponentCategory): HResult; stdcall;
    function get_MediaMajorType(out MediaMajorType: WideString): HResult; stdcall;
    function put_MediaMajorType(MediaMajorType: WideString): HResult; stdcall;
    function get__MediaMajorType(out MediaMajorTypeGuid: TGUID): HResult; stdcall;
    function put__MediaMajorType(const MediaMajorTypeGuid: TGUID): HResult; stdcall;
    function get_MediaSubType(out MediaSubType: WideString): HResult; stdcall;
    function put_MediaSubType(MediaSubType: WideString): HResult; stdcall;
    function get__MediaSubType(out MediaSubTypeGuid: TGUID): HResult; stdcall;
    function put__MediaSubType(const MediaSubTypeGuid: TGUID): HResult; stdcall;
    function get_MediaFormatType(out MediaFormatType: WideString): HResult; stdcall;
    function put_MediaFormatType(MediaFormatType: WideString): HResult; stdcall;
    function get__MediaFormatType(out MediaFormatTypeGuid: TGUID): HResult; stdcall;
    function put__MediaFormatType(const MediaFormatTypeGuid: TGUID): HResult; stdcall;
    function get_MediaType(out MediaType: TAMMediaType): HResult; stdcall;
    function put_MediaType(MediaType: TAMMediaType): HResult; stdcall;
    function Clone(out NewCT: IComponentType): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<ILanguageComponentType> _di_ILanguageComponentType;'}
  {$EXTERNALSYM ILanguageComponentType}
  ILanguageComponentType = interface(IComponentType)
    ['{B874C8BA-0FA2-11d3-9D8E-00C04F72D980}']
    (*** ILanguageComponentType methods ***)
    function get_LangID(out LangID: longint): HResult; stdcall;
    function put_LangID(LangID: longint): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMPEG2ComponentType> _di_IMPEG2ComponentType;'}
  {$EXTERNALSYM IMPEG2ComponentType}
  IMPEG2ComponentType = interface(ILanguageComponentType)
    ['{2C073D84-B51C-48c9-AA9F-68971E1F6E38}']
    (*** IMPEG2ComponentType methods ***)
    function get_StreamType(out MP2StreamType: MPEG2StreamType): HResult; stdcall;
    function put_StreamType(MP2StreamType: MPEG2StreamType): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IATSCComponentType> _di_IATSCComponentType;'}
  {$EXTERNALSYM IATSCComponentType}
  IATSCComponentType = interface(IMPEG2ComponentType)
    ['{FC189E4D-7BD4-4125-B3B3-3A76A332CC96}']
    (*** IATSCComponentType methods ***)
    function get_Flags(out Flags: longint): HResult; stdcall;
    function put_Flags(Flags: longint): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IEnumComponentTypes> _di_IEnumComponentTypes;'}
  {$EXTERNALSYM IEnumComponentTypes}
  IEnumComponentTypes = interface(IUnknown)
    ['{8A674B4A-1F63-11d3-B64C-00C04F79498E}']
    (*** IEnumComponentTypes methods ***)
    function Next(celt: ULONG; out rgelt: IComponentType; out pceltFetched: ULONG): HResult; stdcall;
    function Skip(celt: ULONG): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out ppEnum: IEnumComponentTypes): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IComponentTypes> _di_IComponentTypes;'}
  {$EXTERNALSYM IComponentTypes}
  IComponentTypes = interface(IDispatch)
    ['{0DC13D4A-0313-11d3-9D8E-00C04F72D980}']
    (*** IComponentTypes methods ***)
    function get_Count(out Count: longint): HResult; stdcall;
    function get__NewEnum(out ppNewEnum: IEnumVARIANT): HResult; stdcall;
    function EnumComponentTypes(out ppNewEnum: IEnumComponentTypes): HResult; stdcall;
    function get_Item(Index: OLEVARIANT; out ComponentType: IComponentType): HResult; stdcall;
    function put_Item(Index: OLEVARIANT; ComponentType: IComponentType): HResult; stdcall;
    function Add(ComponentType: IComponentType; out NewIndex: OLEVARIANT): HResult; stdcall;
    function Remove(Index: OLEVARIANT): HResult; stdcall;
    function Clone(out NewList: IComponentTypes): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IComponent> _di_IComponent;'}
  {$EXTERNALSYM IComponent}
  IComponent = interface(IDispatch)
    ['{1A5576FC-0E19-11d3-9D8E-00C04F72D980}']
    (*** IComponent methods ***)
    function get_Type(out CT: IComponentType): HResult; stdcall;
    function put_Type(CT: IComponentType): HResult; stdcall;
    function get_DescLangID(out LangID: longint): HResult; stdcall;
    function put_DescLangID(LangID: longint): HResult; stdcall;
    function get_Status(out Status: TComponentStatus): HResult; stdcall;
    function put_Status(Status: TComponentStatus): HResult; stdcall;
    function get_Description(out Description: WideString): HResult; stdcall;
    function put_Description(Description: WideString): HResult; stdcall;
    function Clone(out NewComponent: IComponent): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMPEG2Component> _di_IMPEG2Component;'}
  {$EXTERNALSYM IMPEG2Component}
  IMPEG2Component = interface(IComponent)
    ['{1493E353-1EB6-473c-802D-8E6B8EC9D2A9}']
    (*** IMPEG2Component methods ***)
    function get_PID(out PID: longint): HResult; stdcall;
    function put_PID(PID: longint): HResult; stdcall;
    function get_PCRPID(out PCRPID: longint): HResult; stdcall;
    function put_PCRPID(PCRPID: longint): HResult; stdcall;
    function get_ProgramNumber(out ProgramNumber: longint): HResult; stdcall;
    function put_ProgramNumber(ProgramNumber: longint): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IEnumComponents> _di_IEnumComponents;'}
  {$EXTERNALSYM IEnumComponents}
  IEnumComponents = interface(IUnknown)
    ['{2A6E2939-2595-11d3-B64C-00C04F79498E}']
    (*** IEnumComponents methods ***)
    function Next(celt: ULONG; out rgelt: IComponent; out pceltFetched: ULONG): HResult; stdcall;
    function Skip(celt: ULONG): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out ppEnum: IEnumComponents): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IComponents> _di_IComponents;'}
  {$EXTERNALSYM IComponents}
  IComponents = interface(IDispatch)
    ['{FCD01846-0E19-11d3-9D8E-00C04F72D980}']
    (*** IComponents methods ***)
    function get_Count(out Count: longint): HResult; stdcall;
    function get__NewEnum(out ppNewEnum: IEnumVARIANT): HResult; stdcall;
    function EnumComponents(out ppNewEnum: IEnumComponents): HResult; stdcall;
    function get_Item(Index: OLEVARIANT; out ppComponent: IComponent): HResult; stdcall;
    function Add(Component: IComponent; out NewIndex: OLEVARIANT): HResult; stdcall;
    function Remove(Index: OLEVARIANT): HResult; stdcall;
    function Clone(out NewList: IComponents): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<ILocator> _di_ILocator;'}
  {$EXTERNALSYM ILocator}
  ILocator = interface(IDispatch)
    ['{286D7F89-760C-4F89-80C4-66841D2507AA}']
    (*** ILocator methods ***)
    function get_CarrierFrequency(out Frequency: longint): HResult; stdcall;
    function put_CarrierFrequency(Frequency: longint): HResult; stdcall;
    function get_InnerFEC(out FEC: FECMethod): HResult; stdcall;
    function put_InnerFEC(FEC: FECMethod): HResult; stdcall;
    function get_InnerFECRate(out FEC: BinaryConvolutionCodeRate): HResult; stdcall;
    function put_InnerFECRate(FEC: BinaryConvolutionCodeRate): HResult; stdcall;
    function get_OuterFEC(out FEC: FECMethod): HResult; stdcall;
    function put_OuterFEC(FEC: FECMethod): HResult; stdcall;
    function get_OuterFECRate(out FEC: BinaryConvolutionCodeRate): HResult; stdcall;
    function put_OuterFECRate(FEC: BinaryConvolutionCodeRate): HResult; stdcall;
    function get_Modulation(out Modulation: ModulationType): HResult; stdcall;
    function put_Modulation(Modulation: ModulationType): HResult; stdcall;
    function get_SymbolRate(out Rate: longint): HResult; stdcall;
    function put_SymbolRate(Rate: longint): HResult; stdcall;
    function Clone(out NewLocator: ILocator): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IATSCLocator> _di_IATSCLocator;'}
  {$EXTERNALSYM IATSCLocator}
  IATSCLocator = interface(ILocator)
    ['{BF8D986F-8C2B-4131-94D7-4D3D9FCC21EF}']
    (*** IATSCLocator methods ***)
    function get_PhysicalChannel(out PhysicalChannel: longint): HResult; stdcall;
    function put_PhysicalChannel(PhysicalChannel: longint): HResult; stdcall;
    function get_TSID(out TSID: longint): HResult; stdcall;
    function put_TSID(TSID: longint): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDVBTLocator> _di_IDVBTLocator;'}
  {$EXTERNALSYM IDVBTLocator}
  IDVBTLocator = interface(ILocator)
    ['{8664DA16-DDA2-42ac-926A-C18F9127C302}']
    (*** IDVBTLocator methods ***)
    function get_Bandwidth(out BandWidthVal: longint): HResult; stdcall;
    function put_Bandwidth(BandwidthVal: longint): HResult; stdcall;
    function get_LPInnerFEC(out FEC: FECMethod): HResult; stdcall;
    function put_LPInnerFEC(FEC: FECMethod): HResult; stdcall;
    function get_LPInnerFECRate(out FEC: BinaryConvolutionCodeRate): HResult; stdcall;
    function put_LPInnerFECRate(FEC: BinaryConvolutionCodeRate): HResult; stdcall;
    function get_HAlpha(out Alpha: HierarchyAlpha): HResult; stdcall;
    function put_HAlpha(Alpha: HierarchyAlpha): HResult; stdcall;
    function get_Guard(out GI: GuardInterval): HResult; stdcall;
    function put_Guard(GI: GuardInterval): HResult; stdcall;
    function get_Mode(out mode: TransmissionMode): HResult; stdcall;
    function put_Mode(mode: TransmissionMode): HResult; stdcall;
    function get_OtherFrequencyInUse(out OtherFrequencyInUseVal: WordBool): HResult; stdcall;
    function put_OtherFrequencyInUse(OtherFrequencyInUseVal: WordBool): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDVBSLocator> _di_IDVBSLocator;'}
  {$EXTERNALSYM IDVBSLocator}
  IDVBSLocator = interface(ILocator)
    ['{3D7C353C-0D04-45f1-A742-F97CC1188DC8}']
    (*** IDVBSLocator methods ***)
    function get_SignalPolarisation(out PolarisationVal: Polarisation): HResult; stdcall;
    function put_SignalPolarisation(PolarisationVal: Polarisation): HResult; stdcall;
    function get_WestPosition(out WestLongitude: WordBool): HResult; stdcall;
    function put_WestPosition(WestLongitude: WordBool): HResult; stdcall;
    function get_OrbitalPosition(out longitude: longint): HResult; stdcall;
    function put_OrbitalPosition(longitude: longint): HResult; stdcall;
    function get_Azimuth(out Azimuth: longint): HResult; stdcall;
    function put_Azimuth(Azimuth: longint): HResult; stdcall;
    function get_Elevation(out Elevation: longint): HResult; stdcall;
    function put_Elevation(Elevation: longint): HResult; stdcall;
   end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDVBCLocator> _di_IDVBCLocator;'}
  {$EXTERNALSYM IDVBCLocator}
  IDVBCLocator = interface(ILocator)
    ['{6E42F36E-1DD2-43c4-9F78-69D25AE39034}']
    (*** IDVBCLocator methods ***)
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IBroadcastEvent> _di_IBroadcastEvent;'}
  {$EXTERNALSYM IBroadcastEvent}
  IBroadcastEvent = interface(IUnknown)
    ['{3B21263F-26E8-489d-AAC4-924F7EFD9511}']
    (*** IBroadcastEvent methods ***)
    function Fire(EventID: TGUID): HResult; stdcall;
  end;

//------------------------------------------------------------------------------
// File: DXTrans.h
// Desc: DirectX Transform library
// Copyright (c) 1999 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

const
  LIBID_DXTRANSLib         : TGUID = '{54314D1D-35FE-11D1-81A1-0000F87557DB}';
  {$EXTERNALSYM LIBID_DXTRANSLib}

  IID_IDXBaseObject        : TGUID = '{17B59B2B-9CC8-11D1-9053-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXBaseObject}
  IID_IDXTransformFactory  : TGUID = '{6A950B2B-A971-11D1-81C8-0000F87557DB}';
  {$EXTERNALSYM IID_IDXTransformFactory}
  IID_IDXTransform         : TGUID = '{30A5FB78-E11F-11D1-9064-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXTransform}
  IID_IDXSurfacePick       : TGUID = '{30A5FB79-E11F-11d1-9064-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXSurfacePick}
  IID_IDXTBindHost         : TGUID = '{D26BCE55-E9DC-11d1-9066-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXTBindHost}
  IID_IDXTaskManager       : TGUID = '{254DBBC1-F922-11D0-883A-3C8B00C10000}';
  {$EXTERNALSYM IID_IDXTaskManager}
  IID_IDXSurfaceFactory    : TGUID = '{144946F5-C4D4-11D1-81D1-0000F87557DB}';
  {$EXTERNALSYM IID_IDXSurfaceFactory}
  IID_IDXSurfaceModifier   : TGUID = '{9EA3B637-C37D-11D1-905E-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXSurfaceModifier}
  IID_IDXSurface           : TGUID = '{B39FD73F-E139-11D1-9065-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXSurface}
  IID_IDXSurfaceInit       : TGUID = '{9EA3B639-C37D-11d1-905E-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXSurfaceInit}
  IID_IDXARGBSurfaceInit   : TGUID = '{9EA3B63A-C37D-11d1-905E-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXARGBSurfaceInit}
  IID_IDXARGBReadPtr       : TGUID = '{EAAAC2D6-C290-11d1-905D-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXARGBReadPtr}
  IID_IDXARGBReadWritePtr  : TGUID = '{EAAAC2D7-C290-11d1-905D-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXARGBReadWritePtr}
  IID_IDXDCLock            : TGUID = '{0F619456-CF39-11D1-905E-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXDCLock}
  IID_IDXTScaleOutput      : TGUID = '{B2024B50-EE77-11D1-9066-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXTScaleOutput}
  IID_IDXGradient          : TGUID = '{B2024B51-EE77-11D1-9066-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXGradient}
  IID_IDXTScale            : TGUID = '{B39FD742-E139-11D1-9065-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXTScale}
  IID_IDXEffect            : TGUID = '{E31FB81B-1335-11d1-8189-0000F87557DB}';
  {$EXTERNALSYM IID_IDXEffect}
  IID_IDXLookupTable       : TGUID = '{01BAFC7F-9E63-11D1-9053-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXLookupTable}
  IID_IDXRawSurface        : TGUID = '{09756C8A-D96A-11d1-9062-00C04FD9189D}';
  {$EXTERNALSYM IID_IDXRawSurface}
  IID_IHTMLDXTransform     : TGUID = '{30E2AB7D-4FDD-4159-B7EA-DC722BF4ADE5}';
  {$EXTERNALSYM IID_IHTMLDXTransform}

  CLSID_DXTransformFactory : TGUID = '{D1FE6762-FC48-11D0-883A-3C8B00C10000}';
  {$EXTERNALSYM CLSID_DXTransformFactory}
  CLSID_DXTaskManager      : TGUID = '{4CB26C03-FF93-11D0-817E-0000F87557DB}';
  {$EXTERNALSYM CLSID_DXTaskManager}
  CLSID_DXTScale           : TGUID = '{555278E2-05DB-11D1-883A-3C8B00C10000}';
  {$EXTERNALSYM CLSID_DXTScale}
  CLSID_DXSurface          : TGUID = '{0E890F83-5F79-11D1-9043-00C04FD9189D}';
  {$EXTERNALSYM CLSID_DXSurface}
  CLSID_DXSurfaceModifier  : TGUID = '{3E669F1D-9C23-11D1-9053-00C04FD9189D}';
  {$EXTERNALSYM CLSID_DXSurfaceModifier}
  CLSID_DXGradient         : TGUID = '{C6365470-F667-11D1-9067-00C04FD9189D}';
  {$EXTERNALSYM CLSID_DXGradient}


//
//  Pixel format definitions
//
  DDPF_RGB1     : TGUID = '{e436eb78-524f-11ce-9f53-0020af0ba770}';
  {$EXTERNALSYM DDPF_RGB1}
  DDPF_RGB2     : TGUID = '{BBF7D3F3-143F-11d1-B50A-0000F8756A10}';
  {$EXTERNALSYM DDPF_RGB2}
  DDPF_RGB4     : TGUID = '{e436eb79-524f-11ce-9f53-0020af0ba770}';
  {$EXTERNALSYM DDPF_RGB4}
  DDPF_RGB8     : TGUID = '{e436eb7a-524f-11ce-9f53-0020af0ba770}';
  {$EXTERNALSYM DDPF_RGB8}
  DDPF_RGB332   : TGUID = '{BBF7D3F6-143F-11d1-B50A-0000F8756A10}';
  {$EXTERNALSYM DDPF_RGB332}
  DDPF_ARGB4444 : TGUID = '{BBF7D3F7-143F-11d1-B50A-0000F8756A10}';
  {$EXTERNALSYM DDPF_ARGB4444}
  DDPF_RGB565   : TGUID = '{e436eb7b-524f-11ce-9f53-0020af0ba770}';
  {$EXTERNALSYM DDPF_RGB565}
  DDPF_BGR565   : TGUID = '{BBF7D3F9-143F-11d1-B50A-0000F8756A10}';
  {$EXTERNALSYM DDPF_BGR565}
  DDPF_RGB555   : TGUID = '{e436eb7c-524f-11ce-9f53-0020af0ba770}';
  {$EXTERNALSYM DDPF_RGB555}
  DDPF_ARGB1555 : TGUID = '{BBF7D3FB-143F-11d1-B50A-0000F8756A10}';
  {$EXTERNALSYM DDPF_ARGB1555}
  DDPF_RGB24    : TGUID = '{e436eb7d-524f-11ce-9f53-0020af0ba770}';
  {$EXTERNALSYM DDPF_RGB24}
  DDPF_BGR24    : TGUID = '{BBF7D3FD-143F-11d1-B50A-0000F8756A10}';
  {$EXTERNALSYM DDPF_BGR24}
  DDPF_RGB32    : TGUID = '{e436eb7e-524f-11ce-9f53-0020af0ba770}';
  {$EXTERNALSYM DDPF_RGB32}
  DDPF_BGR32    : TGUID = '{BBF7D3FF-143F-11d1-B50A-0000F8756A10}';
  {$EXTERNALSYM DDPF_BGR32}
  DDPF_ABGR32   : TGUID = '{BBF7D401-143F-11d1-B50A-0000F8756A10}';
  {$EXTERNALSYM DDPF_ABGR32}
  DDPF_ARGB32   : TGUID = '{773c9ac0-3274-11d0-B724-00aa006c1A01}';
  {$EXTERNALSYM DDPF_ARGB32}
  DDPF_PMARGB32 : TGUID = '{BBF7D403-143F-11d1-B50A-0000F8756A10}';
  {$EXTERNALSYM DDPF_PMARGB32}
  DDPF_A1       : TGUID = '{7846F94E-3915-11d1-99AA-0000F8756A10}';
  {$EXTERNALSYM DDPF_A1}
  DDPF_A2       : TGUID = '{7846F94F-3915-11d1-99AA-0000F8756A10}';
  {$EXTERNALSYM DDPF_A2}
  DDPF_A4       : TGUID = '{7846F950-3915-11d1-99AA-0000F8756A10}';
  {$EXTERNALSYM DDPF_A4}
  DDPF_A8       : TGUID = '{7846F951-3915-11d1-99AA-0000F8756A10}';
  {$EXTERNALSYM DDPF_A8}
  DDPF_Z8       : TGUID = '{7846F952-3915-11d1-99AA-0000F8756A10}';
  {$EXTERNALSYM DDPF_Z8}
  DDPF_Z16      : TGUID = '{7846F953-3915-11d1-99AA-0000F8756A10}';
  {$EXTERNALSYM DDPF_Z16}
  DDPF_Z24      : TGUID = '{7846F954-3915-11d1-99AA-0000F8756A10}';
  {$EXTERNALSYM DDPF_Z24}
  DDPF_Z32      : TGUID = '{7846F955-3915-11d1-99AA-0000F8756A10}';
  {$EXTERNALSYM DDPF_Z32}
//
//  Component categories
//
  CATID_DXImageTransform     : TGUID = '{C501EDBE-9E70-11d1-9053-00C04FD9189D}';
  {$EXTERNALSYM CATID_DXImageTransform}
  CATID_DX3DTransform        : TGUID = '{C501EDBF-9E70-11d1-9053-00C04FD9189D}';
  {$EXTERNALSYM CATID_DX3DTransform}
  CATID_DXAuthoringTransform : TGUID = '{ACAC94FC-E5CF-11d1-9066-00C04FD9189D}';
  {$EXTERNALSYM CATID_DXAuthoringTransform}
  CATID_DXSurface            : TGUID = '{52BA7097-B52C-11d1-81CB-0000F87557DB}';
  {$EXTERNALSYM CATID_DXSurface}

//
//  Service IDs.
//
  SID_SDirectDraw         : TGUID = (D1:$618f8ad4;D2:$8b7a;D3:$11d0;D4:($8f,$cc,$0,$c0,$4f,$d9,$18,$9d));
  {$EXTERNALSYM SID_SDirectDraw}
  SID_SDirect3DRM         : TGUID = (D1:$2bc49361;D2:$8327;D3:$11cf;D4:($ac,$4a,$0,$0,$c0,$38,$25,$a1));
  {$EXTERNALSYM SID_SDirect3DRM}
  SID_SDXTaskManager      : TGUID = '{4CB26C03-FF93-11D0-817E-0000F87557DB}';
  {$EXTERNALSYM SID_SDXTaskManager}
  SID_SDXSurfaceFactory   : TGUID = '{144946F5-C4D4-11D1-81D1-0000F87557DB}';
  {$EXTERNALSYM SID_SDXSurfaceFactory}
  SID_SDXTransformFactory : TGUID = '{6A950B2B-A971-11D1-81C8-0000F87557DB}';
  {$EXTERNALSYM SID_SDXTransformFactory}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IDXBaseObject> _di_IDXBaseObject;'}
  {$EXTERNALSYM IDXBaseObject}
  IDXBaseObject = interface(IUnknown)
    ['{17B59B2B-9CC8-11D1-9053-00C04FD9189D}']
    (*** IDXBaseObject methods ***)
    function  GetGenerationId(out pID: ULONG): HResult; stdcall;
    function  IncrementGenerationId(bRefresh: BOOL): HResult; stdcall;
    function  GetObjectSize(out pcbSize: ULONG): HResult; stdcall;
  end;

  DXBNDID = (
    DXB_X,
    DXB_Y,
    DXB_Z,
    DXB_T
  );
  {$EXTERNALSYM DXBNDID}
  TDXBNDID = DXBNDID;

  DXBNDTYPE = (
    DXBT_DISCRETE,
    DXBT_DISCRETE64,
    DXBT_CONTINUOUS,
    DXBT_CONTINUOUS64
  );
  {$EXTERNALSYM DXBNDTYPE}
  TDXBNDType = DXBNDTYPE;

  DXDBND = record
    Min: longint;
    Max: longint;
  end;
  {$EXTERNALSYM DXDBND}
  TDXDBND = DXDBND;

  DXDBNDS = array[0..3] of TDXDBND;
  {$EXTERNALSYM DXDBNDS}

  DXDBND64 = record
    Min: int64;
    Max: int64;
  end;
  {$EXTERNALSYM DXDBND64}
  TDXDBND64 = DXDBND64;

  DXDBNDS64 = array [0..3] of TDXDBND64;
  {$EXTERNALSYM DXDBNDS64}

  DXCBND = record
  {$EXTERNALSYM DXCBND}
    Min: single;
    Max: single;
  end;
  TDXCBND = DXCBND;

  DXCBNDS = array[0..3] of TDXCBND;
  {$EXTERNALSYM DXCBNDS}

  DXCBND64 = record
    Min: double;
    Max: double;
  end;
  {$EXTERNALSYM DXCBND64}
  TDXCBND64 = DXCBND64;

  DXCBNDS64 = array[0..3] of TDXCBND64;
  {$EXTERNALSYM DXCBNDS64}

  DXBNDS = record
  {$EXTERNALSYM DXBNDS}
    eType: TDXBNDTYPE;
    case Integer of
      0: (D:  array[0..3] of TDXDBND);
      1: (LD: array[0..3] of TDXDBND64);
      2: (C:  array[0..3] of TDXCBND);
      3: (LC: array[0..3] of TDXCBND64);
  end;
  TDXBNDS = DXBNDS;

  DXDVEC = array[0..3] of longint;
  {$EXTERNALSYM DXDVEC}

  DXDVEC64 = array[0..3] of int64;
  {$EXTERNALSYM DXDVEC64}

  DXCVEC = array[0..3] of single;
  {$EXTERNALSYM DXCVEC}

  DXCVEC64 = array[0..3] of double;
  {$EXTERNALSYM DXCVEC64}

  DXVEC = record
    eType: TDXBNDTYPE;
    case Integer of
      0: (D:  array[0..3] of Longint);
      1: (LD: array[0..3] of Int64);
      2: (C:  array[0..3] of Single);
      3: (LC: array[0..3] of Double);
  end;
  {$EXTERNALSYM DXVEC}
  TDXVEC = DXVEC;

  {$HPPEMIT 'typedef System::DelphiInterface<IDXTransform> _di_IDXTransform;'}
  {$EXTERNALSYM IDXTransform}
  IDXTransform = interface(IDXBaseObject)
    ['{30A5FB78-E11F-11D1-9064-00C04FD9189D}']
    (*** IDXTransform methods ***)
    function Setup(punkInputs: IUnknown; ulNumInputs: ULONG; punkOutputs: IUnknown;
               ulNumOutputs: ULONG; dwFlags: DWORD): HResult; stdcall;
    function Execute(const pRequestID: TGUID; var pClipBnds: TDXBNDS; var pPlacement: TDXVEC): HResult; stdcall;
    function MapBoundsIn2Out(var pInBounds: TDXBNDS; ulNumInBnds: ULONG; ulOutIndex: ULONG;
               out pOutBounds: TDXBNDS): HResult; stdcall;
    function MapBoundsOut2In(ulOutIndex: ULONG; var pOutBounds: TDXBNDS; ulInIndex: ULONG;
               out pInBounds: TDXBNDS): HResult; stdcall;
    function SetMiscFlags(dwMiscFlags: DWORD): HResult; stdcall;
    function GetMiscFlags(out pdwMiscFlags: DWORD): HResult; stdcall;
    function GetInOutInfo(bIsOutput: BOOL; ulIndex: ULONG; out pdwFlags: DWORD;
               out pIDs: TGUID; var pcIDs: ULONG; out ppUnkCurrentObject: IUnknown): HResult; stdcall;
    function SetQuality(fQuality: Single): HResult; stdcall;
    function GetQuality(out fQuality: Single): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDXTransformFactory> _di_IDXTransformFactory;'}
  {$EXTERNALSYM IDXTransformFactory}
  IDXTransformFactory = interface(IServiceProvider)
    ['{6A950B2B-A971-11D1-81C8-0000F87557DB}']
    (*** IDXTransformFactory methods ***)
    function SetService(const guidService: TGUID; pUnkService: IUnknown;
               bWeakReference: BOOL): HResult; stdcall;
    function CreateTransform(punkInputs: IUnknown; ulNumInputs: ULONG;
               punkOutputs: IUnknown; ulNumOutputs: ULONG;
               pInitProps: IPropertyBag; pErrLog: IErrorLog;
               const TransCLSID: TGUID; const TransIID: TGUID; out ppTransform: Pointer): HResult; stdcall;
    function InitializeTransform(pTransform: IDXTransform; punkInputs: IUnknown;
               ulNumInputs: ULONG; punkOutputs: IUnknown;
               ulNumOutputs: ULONG; pInitProps: IPropertyBag;
               pErrLog: IErrorLog): HResult; stdcall;
  end;


  DXTMISCFLAGS = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM DXTMISCFLAGS}
  const
    DXTMF_BLEND_WITH_OUTPUT	 = 1 shl 0;
    {$EXTERNALSYM DXTMF_BLEND_WITH_OUTPUT}
    DXTMF_DITHER_OUTPUT	     = 1 shl 1;
    {$EXTERNALSYM DXTMF_DITHER_OUTPUT}
    DXTMF_OPTION_MASK	       = $ffff;
    {$EXTERNALSYM DXTMF_OPTION_MASK}
    DXTMF_VALID_OPTIONS	     = DXTMF_BLEND_WITH_OUTPUT or DXTMF_DITHER_OUTPUT;
    {$EXTERNALSYM DXTMF_VALID_OPTIONS}
    DXTMF_BLEND_SUPPORTED	   = 1 shl 16;
    {$EXTERNALSYM DXTMF_BLEND_SUPPORTED}
    DXTMF_DITHER_SUPPORTED	 = 1 shl 17;
    {$EXTERNALSYM DXTMF_DITHER_SUPPORTED}
    DXTMF_INPLACE_OPERATION	 = 1 shl 24;
    {$EXTERNALSYM DXTMF_INPLACE_OPERATION}
    DXTMF_BOUNDS_SUPPORTED	 = 1 shl 25;
    {$EXTERNALSYM DXTMF_BOUNDS_SUPPORTED}
    DXTMF_PLACEMENT_SUPPORTED= 1 shl 26;
    {$EXTERNALSYM DXTMF_PLACEMENT_SUPPORTED}
    DXTMF_QUALITY_SUPPORTED  = 1 shl 27;
    {$EXTERNALSYM DXTMF_QUALITY_SUPPORTED}
    DXTMF_OPAQUE_RESULT	     = 1 shl 28;
    {$EXTERNALSYM DXTMF_OPAQUE_RESULT}

type
  DXINOUTINFOFLAGS = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM DXINOUTINFOFLAGS}
  const
    DXINOUTF_OPTIONAL	= 1 shl 0;
    {$EXTERNALSYM DXINOUTF_OPTIONAL}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IDXSurfacePick> _di_IDXSurfacePick;'}
  {$EXTERNALSYM IDXSurfacePick}
  IDXSurfacePick = interface(IUnknown)
    ['{30A5FB79-E11F-11d1-9064-00C04FD9189D}']
    (*** IDXSurfacePick methods ***)
    function PointPick(var pPoint: TDXVEC; out pulInputSurfaceIndex: ULONG;
               out pInputPoint: TDXVEC): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDXTBindHost> _di_IDXTBindHost;'}
  {$EXTERNALSYM IDXTBindHost}
  IDXTBindHost = interface(IUnknown)
    ['{D26BCE55-E9DC-11d1-9066-00C04FD9189D}']
    (*** IDXTBindHost methods ***)
    function SetBindHost(pBindHost: IBindHost): HResult; stdcall;
  end;

  DXTASKPROC = procedure(var pTaskData: pointer; var pbContinueProcessing: BOOL); stdcall;
  {$EXTERNALSYM DXTASKPROC}
  PFNDXTASKPROC = ^DXTASKPROC;
  {$EXTERNALSYM PFNDXTASKPROC}

  DXAPCPROC = procedure(dwData: DWORD);stdcall;
  {$EXTERNALSYM DXAPCPROC}
  PFNDXAPCPROC = ^DXAPCPROC;
  {$EXTERNALSYM PFNDXAPCPROC}

  DXTMTASKINFO = record
    pfnTaskProc: PFNDXTASKPROC;
    pTaskData: Pointer;
    pfnCompletionAPC: PFNDXAPCPROC;
    dwCompletionData: DWORD;
    pRequestID: PGUID;
  end;
  {$EXTERNALSYM DXTMTASKINFO}
  TDXTMTaskInfo = DXTMTASKINFO;

  {$HPPEMIT 'typedef System::DelphiInterface<IDXTaskManager> _di_IDXTaskManager;'}
  {$EXTERNALSYM IDXTaskManager}
  IDXTaskManager = interface(IUnknown)
    ['{254DBBC1-F922-11D0-883A-3C8B00C10000}']
    (*** IDXTaskManager methods ***)
    function  QueryNumProcessors(out pulNumProc: ULONG): HResult; stdcall;
    function  SetThreadPoolSize(ulNumThreads: ULONG): HResult; stdcall;
    function  GetThreadPoolSize(out pulNumThreads: ULONG): HResult; stdcall;
    function  SetConcurrencyLimit(ulNumThreads: ULONG): HResult; stdcall;
    function  GetConcurrencyLimit(out pulNumThreads: ULONG): HResult; stdcall;
    function  ScheduleTasks(var TaskInfo: TDXTMTASKINFO; Events: PHANDLE;
                            out TaskIDs: DWORD; ulNumTasks: ULONG; ulWaitPeriod: ULONG): HResult; stdcall;
    function  TerminateTasks(var TaskIDs: DWORD; ulCount: ULONG; ulTimeOut: ULONG): HResult; stdcall;
    function  TerminateRequest(const RequestID: TGUID; ulTimeOut: ULONG): HResult; stdcall;
  end;

  DXBASESAMPLE = record
    Blue  : Byte;
    Green : Byte;
    Red   : Byte;
    Alpha : Byte;
  end;
  {$EXTERNALSYM DXBASESAMPLE}
  TDXBaseSample = DXBASESAMPLE;

  DXSAMPLE = record
    Blue  : Byte;
    Green : Byte;
    Red   : Byte;
    Alpha : Byte;
  end;
  {$EXTERNALSYM DXSAMPLE}
  TDXSample = DXSAMPLE;

  DXPMSAMPLE = record
    Blue  : Byte;
    Green : Byte;
    Red   : Byte;
    Alpha : Byte;
  end;
  {$EXTERNALSYM DXPMSAMPLE}
  TDXPMSample = DXPMSAMPLE;

  DXRUNTYPE = (
    DXRUNTYPE_CLEAR,
    DXRUNTYPE_OPAQUE,
    DXRUNTYPE_TRANS,
    DXRUNTYPE_UNKNOWN
  );
  {$EXTERNALSYM DXRUNTYPE}
  TDXRunType = DXRUNTYPE;

const
  DX_MAX_RUN_INFO_COUNT	= 128;
  {$EXTERNALSYM DX_MAX_RUN_INFO_COUNT}

type
// 2  : Type  ;   // Type
// 30 : Count ;  // Number of samples in run
  PDXRunInfo = ^TDXRunInfo;
  DXRUNINFO = record
    Bitfields : ULONG;
  end;
  {$EXTERNALSYM DXRUNINFO}
  TDXRunInfo = DXRUNINFO;

  DXSFCREATE = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM DXSFCREATE}
  const
    DXSF_FORMAT_IS_CLSID    = 1 shl 0;
    {$EXTERNALSYM DXSF_FORMAT_IS_CLSID}
    DXSF_NO_LAZY_DDRAW_LOCK = 1 shl 1;
    {$EXTERNALSYM DXSF_NO_LAZY_DDRAW_LOCK}

type
  DXBLTOPTIONS = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM DXBLTOPTIONS}
  const
    DXBOF_DO_OVER	= 1 shl 0;
    {$EXTERNALSYM DXBOF_DO_OVER}
    DXBOF_DITHER	= 1 shl 1;
    {$EXTERNALSYM DXBOF_DITHER}

type
  DXSAMPLEFORMATENUM = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM DXSAMPLEFORMATENUM}
  const
    DXPF_FLAGSMASK    = $FFFF0000;
    {$EXTERNALSYM DXPF_FLAGSMASK}
    DXPF_NONPREMULT   = $00010000;
    {$EXTERNALSYM DXPF_NONPREMULT}
    DXPF_TRANSPARENCY = $00020000;
    {$EXTERNALSYM DXPF_TRANSPARENCY}
    DXPF_TRANSLUCENCY = $00040000;
    {$EXTERNALSYM DXPF_TRANSLUCENCY}
    DXPF_2BITERROR    = $00200000;
    {$EXTERNALSYM DXPF_2BITERROR}
    DXPF_3BITERROR    = $00300000;
    {$EXTERNALSYM DXPF_3BITERROR}
    DXPF_4BITERROR    = $00400000;
    {$EXTERNALSYM DXPF_4BITERROR}
    DXPF_5BITERROR    = $00500000;
    {$EXTERNALSYM DXPF_5BITERROR}
    DXPF_ERRORMASK    = $00700000;
    {$EXTERNALSYM DXPF_ERRORMASK}
    DXPF_NONSTANDARD  = $00000000;
    {$EXTERNALSYM DXPF_NONSTANDARD}
    DXPF_PMARGB32     = $00060001;
    {$EXTERNALSYM DXPF_PMARGB32}
    DXPF_ARGB32       = $00070002;
    {$EXTERNALSYM DXPF_ARGB32}
    DXPF_ARGB4444     = $00470003;
    {$EXTERNALSYM DXPF_ARGB4444}
    DXPF_A8           = $00060004;
    {$EXTERNALSYM DXPF_A8}
    DXPF_RGB32        = $00000005;
    {$EXTERNALSYM DXPF_RGB32}
    DXPF_RGB24        = $00000006;
    {$EXTERNALSYM DXPF_RGB24}
    DXPF_RGB565       = $00300007;
    {$EXTERNALSYM DXPF_RGB565}
    DXPF_RGB555       = $00300008;
    {$EXTERNALSYM DXPF_RGB555}
    DXPF_RGB8         = $00500009;
    {$EXTERNALSYM DXPF_RGB8}
    DXPF_ARGB1555     = $0032000A;
    {$EXTERNALSYM DXPF_ARGB1555}
    DXPF_RGB32_CK     = $00020005;
    {$EXTERNALSYM DXPF_RGB32_CK}
    DXPF_RGB24_CK     = $00020006;
    {$EXTERNALSYM DXPF_RGB24_CK}
    DXPF_RGB555_CK    = $00320008;
    {$EXTERNALSYM DXPF_RGB555_CK}
    DXPF_RGB565_CK    = $00320007;
    {$EXTERNALSYM DXPF_RGB565_CK}
    DXPF_RGB8_CK      = $00520009;
    {$EXTERNALSYM DXPF_RGB8_CK}

type
  DXLOCKSURF = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM DXLOCKSURF}
  const
    DXLOCKF_READ	           = 0;
    {$EXTERNALSYM DXLOCKF_READ}
    DXLOCKF_READWRITE	   = 1 shl 0;
    {$EXTERNALSYM DXLOCKF_READWRITE}
    DXLOCKF_EXISTINGINFOONLY = 1 shl 1;
    {$EXTERNALSYM DXLOCKF_EXISTINGINFOONLY}
    DXLOCKF_WANTRUNINFO	   = 1 shl 2;
    {$EXTERNALSYM DXLOCKF_WANTRUNINFO}
    DXLOCKF_NONPREMULT	   = 1 shl 16;
    {$EXTERNALSYM DXLOCKF_NONPREMULT}
    DXLOCKF_VALIDFLAGS	   = (DXLOCKF_READWRITE or DXLOCKF_EXISTINGINFOONLY or DXLOCKF_WANTRUNINFO or DXLOCKF_NONPREMULT);
    {$EXTERNALSYM DXLOCKF_VALIDFLAGS}

Type
  DXSURFSTATUS = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM DXSURFSTATUS}
  const
    DXSURF_TRANSIENT  = 1 shl 0;
    {$EXTERNALSYM DXSURF_TRANSIENT}
    DXSURF_READONLY   = 1 shl 1;
    {$EXTERNALSYM DXSURF_READONLY}
    DXSURF_VALIDFLAGS = (DXSURF_TRANSIENT or DXSURF_READONLY);
    {$EXTERNALSYM DXSURF_VALIDFLAGS}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IDXDCLock> _di_IDXDCLock;'}
  {$EXTERNALSYM IDXDCLock}
  IDXDCLock = interface(IUnknown)
    ['{0F619456-CF39-11D1-905E-00C04FD9189D}']
    (*** IDXDCLock methods ***)
    function  GetDC: HDC; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDXSurface> _di_IDXSurface;'}
  {$EXTERNALSYM IDXSurface}
  IDXSurface = interface(IDXBaseObject)
    ['{B39FD73F-E139-11D1-9065-00C04FD9189D}']
    (*** IDXSurface methods ***)
    function GetPixelFormat(out pFormatID: TGUID; out pSampleFormatEnum: DXSAMPLEFORMATENUM): HResult; stdcall;
    function GetBounds(out pBounds: TDXBNDS): HResult; stdcall;
    function GetStatusFlags(out pdwStatusFlags: DWORD): HResult; stdcall;
    function SetStatusFlags(dwStatusFlags: DWORD): HResult; stdcall;
    function LockSurface(var pBounds: TDXBNDS; ulTimeOut: ULONG; dwFlags: DWORD;
             const riid: TGUID; out ppPointer: Pointer; out pulGenerationId: ULONG): HResult; stdcall;
    function GetDirectDrawSurface(const riid: TGUID; out ppSurface: Pointer): HResult; stdcall;
    function GetColorKey(var pColorKey: TDXSAMPLE): HResult; stdcall;
    function SetColorKey(ColorKey: TDXSAMPLE): HResult; stdcall;
    function LockSurfaceDC(var pBounds: TDXBNDS; ulTimeOut: ULONG; dwFlags: DWORD;
                            out ppDCLock: IDXDCLock): HResult; stdcall;
    function SetAppData(dwAppData: DWORD): HResult; stdcall;
    function GetAppData(var pdwAppData: DWORD): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDXSurfaceFactory> _di_IDXSurfaceFactory;'}
  {$EXTERNALSYM IDXSurfaceFactory}
  IDXSurfaceFactory = interface(IUnknown)
    ['{144946F5-C4D4-11D1-81D1-0000F87557DB}']
    (*** IDXSurfaceFactory methods ***)
    function CreateSurface(pDirectDraw: IUnknown; var pDDSurfaceDesc: PDDSurfaceDesc;
               const pFormatID: TGUID; var pBounds: TDXBNDS; dwFlags: DWORD;
               punkOuter: IUnknown; const riid: TGUID; out ppDXSurface: Pointer): HResult; stdcall;
    function CreateFromDDSurface(pDDrawSurface: IUnknown; const pFormatID: TGUID;
               dwFlags: DWORD; punkOuter: IUnknown; const riid: TGUID;
               out ppDXSurface: Pointer): HResult; stdcall;
    function LoadImage(pszFileName: PWideChar; pDirectDraw: IUnknown;
               pDDSurfaceDesc: PDDSURFACEDESC; const pFormatID: TGUID; const riid: TGUID;
               out ppDXSurface: Pointer): HResult; stdcall;
    function LoadImageFromStream(pStream: IStream; pDirectDraw: IUnknown;
               pDDSurfaceDesc: PDDSURFACEDESC; const pFormatID: TGUID;
               const riid: TGUID; out ppDXSurface: Pointer): HResult; stdcall;
    function CopySurfaceToNewFormat(pSrc: IDXSurface; pDirectDraw: IUnknown;
               pDDSurfaceDesc: PDDSURFACEDESC; const pDestFormatID: TGUID;
               out ppNewSurface: IDXSurface): HResult; stdcall;
    function CreateD3DRMTexture(pSrc: IDXSurface; pDirectDraw: IUnknown;
               pD3DRM3: IUnknown; const riid: TGUID; out ppTexture3: Pointer): HResult; stdcall;
    function BitBlt(pDest: IDXSurface; var pPlacement: TDXVEC; pSrc: IDXSurface;
               var pClipBounds: TDXBNDS; dwFlags: DWORD): HResult; stdcall;
  end;

  //convenient type declaration for IDXLookupTable
  LUT = array[0..255] of Byte;
  {$EXTERNALSYM LUT}

  {$HPPEMIT 'typedef System::DelphiInterface<IDXLookupTable> _di_IDXLookupTable;'}
  {$EXTERNALSYM IDXLookupTable}
  IDXLookupTable = interface(IDXBaseObject)
    ['{01BAFC7F-9E63-11D1-9053-00C04FD9189D}']
    (*** IDXLookupTable methods ***)
    function  GetTables(RedLUT: LUT; GreenLUT: LUT; BlueLUT: LUT; AlphaLUT: LUT): HResult; stdcall;
    function  IsChannelIdentity(out pSampleBools: TDXBASESAMPLE): HResult; stdcall;
    function  GetIndexValues(Index: ULONG; out pSample: TDXBASESAMPLE): HResult; stdcall;
    function  ApplyTables(var pSamples: TDXSAMPLE; cSamples: ULONG): HResult; stdcall;
  end;

  DXSURFMODCOMPOP = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM DXSURFMODCOMPOP}
  const
    DXSURFMOD_COMP_OVER	    = 0;
    {$EXTERNALSYM DXSURFMOD_COMP_OVER}
    DXSURFMOD_COMP_ALPHA_MASK = 1;
    {$EXTERNALSYM DXSURFMOD_COMP_ALPHA_MASK}
    DXSURFMOD_COMP_MAX_VALID  = 1;
    {$EXTERNALSYM DXSURFMOD_COMP_MAX_VALID}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IDXSurfaceModifier> _di_IDXSurfaceModifier;'}
  {$EXTERNALSYM IDXSurfaceModifier}
  IDXSurfaceModifier = interface(IUnknown)
    ['{9EA3B637-C37D-11D1-905E-00C04FD9189D}']
    (*** IDXSurfaceModifier methods ***)
    function  SetFillColor(Color: TDXSAMPLE): HResult; stdcall;
    function  GetFillColor(out pColor: TDXSAMPLE): HResult; stdcall;
    function  SetBounds(var pBounds: TDXBNDS): HResult; stdcall;
    function  SetBackground(pSurface: IDXSurface): HResult; stdcall;
    function  GetBackground(out ppSurface: IDXSurface): HResult; stdcall;
    function  SetCompositeOperation(CompOp: DXSURFMODCOMPOP): HResult; stdcall;
    function  GetCompositeOperation(out pCompOp: DXSURFMODCOMPOP): HResult; stdcall;
    function  SetForeground(pSurface: IDXSurface; bTile: BOOL; var pOrigin: TPOINT): HResult; stdcall;
    function  GetForeground(out ppSurface: IDXSurface; out pbTile: BOOL; out pOrigin: TPOINT): HResult; stdcall;
    function  SetOpacity(Opacity: Single): HResult; stdcall;
    function  GetOpacity(out pOpacity: Single): HResult; stdcall;
    function  SetLookup(pLookupTable: IDXLookupTable): HResult; stdcall;
    function  GetLookup(out ppLookupTable: IDXLookupTable): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDXSurfaceInit> _di_IDXSurfaceInit;'}
  {$EXTERNALSYM IDXSurfaceInit}
  IDXSurfaceInit = interface(IUnknown)
    ['{9EA3B639-C37D-11d1-905E-00C04FD9189D}']
    (*** IDXSurfaceInit methods ***)
    function InitSurface(pDirectDraw: IUnknown; var pDDSurfaceDesc: TDDSURFACEDESC;
               const pFormatID: TGUID; var pBounds: TDXBNDS; dwFlags: DWORD): HResult; stdcall;
  end;

  DXRAWSURFACEINFO = record
    pFirstByte   : PBYTE;
    lPitch       : LongInt;
    Width        : ULONG;
    Height       : ULONG;
    pPixelFormat : PGUID;
    hdc          : HDC;
    dwColorKey   : DWORD;
    pPalette     : ^TDXBASESAMPLE;
  end;
  {$EXTERNALSYM DXRAWSURFACEINFO}
  TDXRawSurfaceInfo = DXRAWSURFACEINFO;

  {$HPPEMIT 'typedef System::DelphiInterface<IDXRawSurface> _di_IDXRawSurface;'}
  {$EXTERNALSYM IDXRawSurface}
  IDXRawSurface = interface(IUnknown)
    ['{09756C8A-D96A-11d1-9062-00C04FD9189D}']
    (*** IDXRawSurface methods ***)
    function GetSurfaceInfo(var pSurfaceInfo: TDXRawSurfaceInfo): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDXARGBSurfaceInit> _di_IDXARGBSurfaceInit;'}
  {$EXTERNALSYM IDXARGBSurfaceInit}
  IDXARGBSurfaceInit = interface(IDXSurfaceInit)
    ['{9EA3B63A-C37D-11d1-905E-00C04FD9189D}']
    (*** IDXARGBSurfaceInit methods ***)
    function InitFromDDSurface(pDDrawSurface: IUnknown; const pFormatID: TGUID;
               dwFlags: DWORD): HResult; stdcall;
    function InitFromRawSurface(pRawSurface: IDXRawSurface): HResult; stdcall;
  end;

  DXNATIVETYPEINFO = record
    pCurrentData : ^BYTE;
    pFirstByte   : ^PBYTE;
    lPitch       : LongInt;
    dwColorKey   : DWORD;
  end;
  {$EXTERNALSYM DXNATIVETYPEINFO}
  TDXNativeTypeInfo = DXNATIVETYPEINFO;

  DXPACKEDRECTDESC = record
    pSamples    : ^TDXBASESAMPLE;
    bPremult    : BOOL;
    rect        : TRECT;
    lRowPadding : LongInt;
  end;
  {$EXTERNALSYM DXPACKEDRECTDESC}
  TDXPackedRectDesc = DXPACKEDRECTDESC;

  DXOVERSAMPLEDESC = record
    p     : TPOINT;
    Color : TDXPMSAMPLE;
  end;
  {$EXTERNALSYM DXOVERSAMPLEDESC}
  TDXOverSampleDesc = DXOVERSAMPLEDESC;

  {$HPPEMIT 'typedef System::DelphiInterface<IDXARGBReadPtr> _di_IDXARGBReadPtr;'}
  {$EXTERNALSYM IDXARGBReadPtr}
  IDXARGBReadPtr = interface(IUnknown)
    ['{EAAAC2D6-C290-11d1-905D-00C04FD9189D}']
    (*** IDXARGBReadPtr methods ***)
    function GetSurface(const riid: TGUID; out ppSurface: pointer): HResult; stdcall;
    function GetNativeType(out pInfo: TDXNativeTypeInfo): DXSAMPLEFORMATENUM; stdcall;
    procedure Move(cSamples: LongInt); stdcall;
    procedure MoveToRow(y: ULONG); stdcall;
    procedure MoveToXY(x, y: ULONG); stdcall;
    function MoveAndGetRunInfo(Row: ULONG; out ppInfo: PDXRUNINFO): ULONG; stdcall;
    function Unpack(var pSamples: TDXSAMPLE; cSamples: ULONG; bMove: BOOL): TDXSAMPLE; stdcall;
    function UnpackPremult(var pSamples: TDXPMSAMPLE; cSamples: ULONG; bMove: BOOL): TDXPMSAMPLE; stdcall;
    procedure UnpackRect(var pRectDesc: TDXPackedRectDesc); stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDXARGBReadWritePtr> _di_IDXARGBReadWritePtr;'}
  {$EXTERNALSYM IDXARGBReadWritePtr}
  IDXARGBReadWritePtr = interface(IDXARGBReadPtr)
    ['{EAAAC2D7-C290-11d1-905D-00C04FD9189D}']
    (*** IDXARGBReadWritePtr methods ***)
    procedure PackAndMove(var pSamples: TDXSAMPLE; cSamples: ULONG); stdcall;
    procedure PackPremultAndMove(var pSamples: TDXPMSAMPLE; cSamples: ULONG); stdcall;
    procedure PackRect(var pRectDesc: TDXPackedRectDesc); stdcall;
    procedure CopyAndMoveBoth(var pScratchBuffer: TDXBASESAMPLE; pSrc: IDXARGBReadPtr;
                cSamples: ULONG; bIsOpaque: BOOL); stdcall;
    procedure CopyRect(var pScratchBuffer: TDXBASESAMPLE; var pDestRect: TRECT;
                pSrc: IDXARGBReadPtr; var pSrcOrigin: TPOINT; bIsOpaque: BOOL); stdcall;
    procedure FillAndMove(var pScratchBuffer: TDXBASESAMPLE; SampVal: TDXPMSAMPLE;
                cSamples: ULONG; bDoOver: BOOL); stdcall;
    procedure FillRect(var pRect: TRECT; SampVal: TDXPMSAMPLE; bDoOver: BOOL); stdcall;
    procedure OverSample(var pOverDesc: TDXOverSampleDesc); stdcall;
    procedure OverArrayAndMove(var pScratchBuffer: TDXBASESAMPLE; var pSrc: TDXPMSAMPLE;
                cSamples: ULONG); stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDXTScaleOutput> _di_IDXTScaleOutput;'}
  {$EXTERNALSYM IDXTScaleOutput}
  IDXTScaleOutput = interface(IUnknown)
    ['{B2024B50-EE77-11D1-9066-00C04FD9189D}']
    (*** IDXTScaleOutput methods ***)
    function  SetOutputSize(const OutSize: SIZE; bMaintainAspect: BOOL): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDXGradient> _di_IDXGradient;'}
  {$EXTERNALSYM IDXGradient}
  IDXGradient = interface(IDXTScaleOutput)
    ['{B2024B51-EE77-11D1-9066-00C04FD9189D}']
    (*** IDXGradient methods ***)
    function SetGradient(StartColor: TDXSAMPLE; EndColor: TDXSAMPLE; bHorizontal: BOOL): HResult; stdcall;
    function GetOutputSize(out pOutSize: SIZE): HResult; stdcall;
  end;

  Scales = array[0..1] of Single;
  {$EXTERNALSYM Scales}

  {$HPPEMIT 'typedef System::DelphiInterface<IDXTScale> _di_IDXTScale;'}
  {$EXTERNALSYM IDXTScale}
  IDXTScale = interface(IUnknown)
    ['{B39FD742-E139-11D1-9065-00C04FD9189D}']
    (*** IDXTScale methods ***)
    function SetScales(var Scales: Scales): HResult; stdcall;
    function GetScales(out Scales: Scales): HResult; stdcall;
    function ScaleFitToSize(var pClipBounds: TDXBNDS; FitToSize: SIZE; bMaintainAspect: BOOL): HResult; stdcall;
  end;

  DISPIDDXEFFECT = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM DISPIDDXEFFECT}
  const
    DISPID_DXECAPABILITIES = 10000;
    {$EXTERNALSYM DISPID_DXECAPABILITIES}
    DISPID_DXEPROGRESS     = DISPID_DXECAPABILITIES + 1;
    {$EXTERNALSYM DISPID_DXEPROGRESS}
    DISPID_DXESTEP         = DISPID_DXEPROGRESS + 1;
    {$EXTERNALSYM DISPID_DXESTEP}
    DISPID_DXEDURATION     = DISPID_DXESTEP + 1;
    {$EXTERNALSYM DISPID_DXEDURATION}
    DISPID_DXE_NEXT_ID     = DISPID_DXEDURATION + 1;
    {$EXTERNALSYM DISPID_DXE_NEXT_ID}

type
  DXEFFECTTYPE = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM DXEFFECTTYPE}
  const
    DXTET_PERIODIC = 1 shl 0;
    {$EXTERNALSYM DXTET_PERIODIC}
    DXTET_MORPH	 = 1 shl 1;
    {$EXTERNALSYM DXTET_MORPH}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IDXEffect> _di_IDXEffect;'}
  {$EXTERNALSYM IDXEffect}
  IDXEffect = interface(IDispatch)
    ['{E31FB81B-1335-11d1-8189-0000F87557DB}']
    (*** IDXEffect methods ***)
    function get_Capabilities(out pVal: LongInt): HResult; stdcall;
    function get_Progress(out pVal: Single): HResult; stdcall;
    function put_Progress(newVal: Single): HResult; stdcall;
    function get_StepResolution(out pVal: Single): HResult; stdcall;
    function get_Duration(out pVal: Single): HResult; stdcall;
    function put_Duration(newVal: Single): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IHTMLDXTransform> _di_IHTMLDXTransform;'}
  {$EXTERNALSYM IHTMLDXTransform}
  IHTMLDXTransform = interface(IUnknown)
    ['{30E2AB7D-4FDD-4159-B7EA-DC722BF4ADE5}']
    (*** IHTMLDXTransform methods ***)
    function SetHostUrl(bstrHostUrl: WideString): HResult; stdcall;
  end;

//------------------------------------------------------------------------------
// File: QEdit.h
// Desc: Dexter library (DES)
// Copyright (c) 1999 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

const
  LIBID_DexterLib: TGUID = '{78530B68-61F9-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM LIBID_DexterLib}

  IID_IPropertySetter         : TGUID = '{AE9472BD-B0C3-11D2-8D24-00A0C9441E20}';
  {$EXTERNALSYM IID_IPropertySetter}
  IID_IDxtCompositor          : TGUID = '{BB44391E-6ABD-422F-9E2E-385C9DFF51FC}';
  {$EXTERNALSYM IID_IDxtCompositor}
  IID_IDxtAlphaSetter         : TGUID = '{4EE9EAD9-DA4D-43D0-9383-06B90C08B12B}';
  {$EXTERNALSYM IID_IDxtAlphaSetter}
  IID_IDxtJpeg                : TGUID = '{DE75D011-7A65-11D2-8CEA-00A0C9441E20}';
  {$EXTERNALSYM IID_IDxtJpeg}
  IID_IDxtKey                 : TGUID = '{3255DE56-38FB-4901-B980-94B438010D7B}';
  {$EXTERNALSYM IID_IDxtKey}
  IID_IMediaLocator           : TGUID = '{288581E0-66CE-11D2-918F-00C0DF10D434}';
  {$EXTERNALSYM IID_IMediaLocator}
  IID_IMediaDet               : TGUID = '{65BD0710-24D2-4FF7-9324-ED2E5D3ABAFA}';
  {$EXTERNALSYM IID_IMediaDet}
  IID_IGrfCache               : TGUID = '{AE9472BE-B0C3-11D2-8D24-00A0C9441E20}';
  {$EXTERNALSYM IID_IGrfCache}
  IID_IRenderEngine           : TGUID = '{6BEE3A81-66C9-11D2-918F-00C0DF10D434}';
  {$EXTERNALSYM IID_IRenderEngine}
  IID_IRenderEngine2          : TGUID = '{6BEE3A82-66C9-11d2-918F-00C0DF10D434}';
  {$EXTERNALSYM IID_IRenderEngine2}
  IID_IFindCompressorCB       : TGUID = '{F03FA8DE-879A-4D59-9B2C-26BB1CF83461}';
  {$EXTERNALSYM IID_IFindCompressorCB}
  IID_ISmartRenderEngine      : TGUID = '{F03FA8CE-879A-4D59-9B2C-26BB1CF83461}';
  {$EXTERNALSYM IID_ISmartRenderEngine}
  IID_IAMTimelineObj          : TGUID = '{78530B77-61F9-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM IID_IAMTimelineObj}
  IID_IAMTimelineEffectable   : TGUID = '{EAE58537-622E-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM IID_IAMTimelineEffectable}
  IID_IAMTimelineEffect       : TGUID = '{BCE0C264-622D-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM IID_IAMTimelineEffect}
  IID_IAMTimelineTransable    : TGUID = '{378FA386-622E-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM IID_IAMTimelineTransable}
  IID_IAMTimelineSplittable   : TGUID = '{A0F840A0-D590-11D2-8D55-00A0C9441E20}';
  {$EXTERNALSYM IID_IAMTimelineSplittable}
  IID_IAMTimelineTrans        : TGUID = '{BCE0C265-622D-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM IID_IAMTimelineTrans}
  IID_IAMTimelineSrc          : TGUID = '{78530B79-61F9-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM IID_IAMTimelineSrc}
  IID_IAMTimelineTrack        : TGUID = '{EAE58538-622E-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM IID_IAMTimelineTrack}
  IID_IAMTimelineVirtualTrack : TGUID = '{A8ED5F80-C2C7-11D2-8D39-00A0C9441E20}';
  {$EXTERNALSYM IID_IAMTimelineVirtualTrack}
  IID_IAMTimelineComp         : TGUID = '{EAE58536-622E-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM IID_IAMTimelineComp}
  IID_IAMTimelineGroup        : TGUID = '{9EED4F00-B8A6-11D2-8023-00C0DF10D434}';
  {$EXTERNALSYM IID_IAMTimelineGroup}
  IID_IAMTimeline             : TGUID = '{78530B74-61F9-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM IID_IAMTimeline}
  IID_IXml2Dex                : TGUID = '{18C628ED-962A-11D2-8D08-00A0C9441E20}';
  {$EXTERNALSYM IID_IXml2Dex}
  IID_IAMErrorLog             : TGUID = '{E43E73A2-0EFA-11D3-9601-00A0C9441E20}';
  {$EXTERNALSYM IID_IAMErrorLog}
  IID_IAMSetErrorLog          : TGUID = '{963566DA-BE21-4EAF-88E9-35704F8F52A1}';
  {$EXTERNALSYM IID_IAMSetErrorLog}
  IID_ISampleGrabberCB        : TGUID = '{0579154A-2B53-4994-B0D0-E773148EFF85}';
  {$EXTERNALSYM IID_ISampleGrabberCB}
  IID_ISampleGrabber          : TGUID = '{6B652FFF-11FE-4FCE-92AD-0266B5D7C78F}';
  {$EXTERNALSYM IID_ISampleGrabber}
  IID_IResize                 : TGUID = '{4ada63a0-72d5-11d2-952a-0060081840bc}';
  {$EXTERNALSYM IID_IResize}

  CLSID_AMTimeline            : TGUID = '{78530B75-61F9-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM CLSID_AMTimeline}
  CLSID_AMTimelineObj         : TGUID = '{78530B78-61F9-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM CLSID_AMTimelineObj}
  CLSID_AMTimelineSrc         : TGUID = '{78530B7A-61F9-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM CLSID_AMTimelineSrc}
  CLSID_AMTimelineTrack       : TGUID = '{8F6C3C50-897B-11D2-8CFB-00A0C9441E20}';
  {$EXTERNALSYM CLSID_AMTimelineTrack}
  CLSID_AMTimelineComp        : TGUID = '{74D2EC80-6233-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM CLSID_AMTimelineComp}
  CLSID_AMTimelineGroup       : TGUID = '{F6D371E1-B8A6-11D2-8023-00C0DF10D434}';
  {$EXTERNALSYM CLSID_AMTimelineGroup}
  CLSID_AMTimelineTrans       : TGUID = '{74D2EC81-6233-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM CLSID_AMTimelineTrans}
  CLSID_AMTimelineEffect      : TGUID = '{74D2EC82-6233-11D2-8CAD-00A024580902}';
  {$EXTERNALSYM CLSID_AMTimelineEffect}
  CLSID_RenderEngine          : TGUID = '{64D8A8E0-80A2-11D2-8CF3-00A0C9441E20}';
  {$EXTERNALSYM CLSID_RenderEngine}
  CLSID_SmartRenderEngine     : TGUID = '{498B0949-BBE9-4072-98BE-6CCAEB79DC6F}';
  {$EXTERNALSYM CLSID_SmartRenderEngine}
  CLSID_AudMixer              : TGUID = '{036A9790-C153-11D2-9EF7-006008039E37}';
  {$EXTERNALSYM CLSID_AudMixer}
  CLSID_Xml2Dex               : TGUID = '{18C628EE-962A-11D2-8D08-00A0C9441E20}';
  {$EXTERNALSYM CLSID_Xml2Dex}
  CLSID_MediaLocator          : TGUID = '{CC1101F2-79DC-11D2-8CE6-00A0C9441E20}';
  {$EXTERNALSYM CLSID_MediaLocator}
  CLSID_PropertySetter        : TGUID = '{ADF95821-DED7-11D2-ACBE-0080C75E246E}';
  {$EXTERNALSYM CLSID_PropertySetter}
  CLSID_MediaDet              : TGUID = '{65BD0711-24D2-4FF7-9324-ED2E5D3ABAFA}';
  {$EXTERNALSYM CLSID_MediaDet}
  CLSID_SampleGrabber         : TGUID = '{C1F400A0-3F08-11D3-9F0B-006008039E37}';
  {$EXTERNALSYM CLSID_SampleGrabber}
  CLSID_NullRenderer          : TGUID = '{C1F400A4-3F08-11D3-9F0B-006008039E37}';
  {$EXTERNALSYM CLSID_NullRenderer}
  CLSID_DxtCompositor         : TGUID = '{BB44391D-6ABD-422F-9E2E-385C9DFF51FC}';
  {$EXTERNALSYM CLSID_DxtCompositor}
  CLSID_DxtAlphaSetter        : TGUID = '{506D89AE-909A-44F7-9444-ABD575896E35}';
  {$EXTERNALSYM CLSID_DxtAlphaSetter}
  CLSID_DxtJpeg               : TGUID = '{DE75D012-7A65-11D2-8CEA-00A0C9441E20}';
  {$EXTERNALSYM CLSID_DxtJpeg}
  CLSID_ColorSource           : TGUID = '{0CFDD070-581A-11D2-9EE6-006008039E37}';
  {$EXTERNALSYM CLSID_ColorSource}
  CLSID_DxtKey                : TGUID = '{C5B19592-145E-11D3-9F04-006008039E37}';
  {$EXTERNALSYM CLSID_DxtKey}

type
  // used by DEXTER_VALUE's dwInterp var
  DEXTERF = (
    DEXTERF_JUMP,
    DEXTERF_INTERPOLATE
  );
  {$EXTERNALSYM DEXTERF}
  TDexterF = DEXTERF;

  // used to set values on the property setter
  PDexterParam = ^TDexterParam;
  DEXTER_PARAM = record
    Name    : WideString ;
    dispID  : longint;
    nValues : longint;
  end;
  {$EXTERNALSYM DEXTER_PARAM}
  TDexterParam = DEXTER_PARAM;

  // used to set values on the property setter
  PDexterValue = ^TDexterValue;
  DEXTER_VALUE = record
    v        : OLEVARIANT ;
    rt       : TReferenceTime ;
    dwInterp : DWORD ;
  end;
  {$EXTERNALSYM DEXTER_VALUE}
  TDexterValue = DEXTER_VALUE;

const
  // used by bMethod directly below
  DEXTER_AUDIO_JUMP	        = 0;
  {$EXTERNALSYM DEXTER_AUDIO_JUMP}
  DEXTER_AUDIO_INTERPOLATE	= DEXTER_AUDIO_JUMP + 1;
  {$EXTERNALSYM DEXTER_AUDIO_INTERPOLATE}

type
  // used to set volumes on the mixer and mixer pins
  DEXTER_AUDIO_VOLUMEENVELOPE = record
    rtEnd   : TReferenceTime ;
    dLevel  : double ;
    bMethod : BOOL ;
  end;
  {$EXTERNALSYM DEXTER_AUDIO_VOLUMEENVELOPE}
  TDexterAudioVolumeEnvelope = DEXTER_AUDIO_VOLUMEENVELOPE;

const
  // used in IAMTimeline::Get(Set)InsertMode
  TIMELINE_INSERT_MODE_INSERT	= 1;
  {$EXTERNALSYM TIMELINE_INSERT_MODE_INSERT}
  TIMELINE_INSERT_MODE_OVERLAY	= 2;
  {$EXTERNALSYM TIMELINE_INSERT_MODE_OVERLAY}

  // define what main 'things' can be put into the timeline tree.
  // these values are used quite a bit with timeline access
  // (bitmap mask flags)
// TIMELINE_MAJOR_TYPE
  TIMELINE_MAJOR_TYPE_COMPOSITE	= 1;
  {$EXTERNALSYM TIMELINE_MAJOR_TYPE_COMPOSITE}
	TIMELINE_MAJOR_TYPE_TRACK	= 2;
  {$EXTERNALSYM TIMELINE_MAJOR_TYPE_TRACK}
	TIMELINE_MAJOR_TYPE_SOURCE	= 4;
  {$EXTERNALSYM TIMELINE_MAJOR_TYPE_SOURCE}
	TIMELINE_MAJOR_TYPE_TRANSITION	= 8;
  {$EXTERNALSYM TIMELINE_MAJOR_TYPE_TRANSITION}
	TIMELINE_MAJOR_TYPE_EFFECT	= 16;
  {$EXTERNALSYM TIMELINE_MAJOR_TYPE_EFFECT}
	TIMELINE_MAJOR_TYPE_GROUP	= 128;
  {$EXTERNALSYM TIMELINE_MAJOR_TYPE_GROUP}

// used in various IAMTimelineXXX "search" functions. Look in this
// file for "SearchDirection" to see where it's used. I didn't want
// to use an enum as an interface param type, so I used a long. Probably
// silly of me.
// DEXTERF_TRACK_SEARCH_FLAGS
  DEXTERF_BOUNDING	= -1;
  {$EXTERNALSYM DEXTERF_BOUNDING}
	DEXTERF_EXACTLY_AT	= 0;
  {$EXTERNALSYM DEXTERF_EXACTLY_AT}
	DEXTERF_FORWARDS	= 1;
  {$EXTERNALSYM DEXTERF_FORWARDS}

type
  // right now, the media type in the group contains enough information about
  // how we want to recompress. This might not be enough information in the
  // future, so we define a structure we can get and set to the group.
  _SCompFmt0 = record
    nFormatId : longint ;
    MediaType : TAMMediaType ;
  end;
  {$EXTERNALSYM _SCompFmt0}
  SCompFmt0 = _SCompFmt0;
  {$EXTERNALSYM SCompFmt0}
  TSCompFmt0 = _SCompFmt0;

const
  // used in IAMTimelineSrc::Get(Set)StretchMode
  RESIZEF_STRETCH	                        = 0;
  {$EXTERNALSYM RESIZEF_STRETCH}
	RESIZEF_CROP	                          = RESIZEF_STRETCH + 1;
  {$EXTERNALSYM RESIZEF_CROP}
	RESIZEF_PRESERVEASPECTRATIO	            = RESIZEF_CROP + 1;
  {$EXTERNALSYM RESIZEF_PRESERVEASPECTRATIO}
	RESIZEF_PRESERVEASPECTRATIO_NOLETTERBOX	= RESIZEF_PRESERVEASPECTRATIO + 1;
  {$EXTERNALSYM RESIZEF_PRESERVEASPECTRATIO_NOLETTERBOX}

  // used in IRenderEngine::SetDynamicReconnectLevel
  // (bitmap mask flags)
  CONNECTF_DYNAMIC_NONE	 = 0;
  {$EXTERNALSYM CONNECTF_DYNAMIC_NONE}
	CONNECTF_DYNAMIC_SOURCES = $1;
  {$EXTERNALSYM CONNECTF_DYNAMIC_SOURCES}
	CONNECTF_DYNAMIC_EFFECTS = $2;
  {$EXTERNALSYM CONNECTF_DYNAMIC_EFFECTS}

  // used in
  // IMediaLocator::FindMediaFile
  // IRenderEngine::SetSourceNameValidation
  // IAMTimeline::ValidateSourceNames
  // (bitmap mask flags)
  SFN_VALIDATEF_CHECK       = $1;
  {$EXTERNALSYM SFN_VALIDATEF_CHECK}
	SFN_VALIDATEF_POPUP	      = $2;
  {$EXTERNALSYM SFN_VALIDATEF_POPUP}
	SFN_VALIDATEF_TELLME	    = $4;
  {$EXTERNALSYM SFN_VALIDATEF_TELLME}
	SFN_VALIDATEF_REPLACE	    = $8;
  {$EXTERNALSYM SFN_VALIDATEF_REPLACE}
	SFN_VALIDATEF_USELOCAL    = $10;
  {$EXTERNALSYM SFN_VALIDATEF_USELOCAL}
	SFN_VALIDATEF_NOFIND	    = $20;
  {$EXTERNALSYM SFN_VALIDATEF_NOFIND}
	SFN_VALIDATEF_IGNOREMUTED = $40;
  {$EXTERNALSYM SFN_VALIDATEF_IGNOREMUTED}
	SFN_VALIDATEF_END	= SFN_VALIDATEF_IGNOREMUTED + 1;
  {$EXTERNALSYM SFN_VALIDATEF_END}

  // key transitions types
  DXTKEY_RGB	 = 0;
  {$EXTERNALSYM DXTKEY_RGB}
	DXTKEY_NONRED	 = DXTKEY_RGB + 1;
  {$EXTERNALSYM DXTKEY_NONRED}
	DXTKEY_LUMINANCE = DXTKEY_NONRED + 1;
  {$EXTERNALSYM DXTKEY_LUMINANCE}
	DXTKEY_ALPHA	 = DXTKEY_LUMINANCE + 1;
  {$EXTERNALSYM DXTKEY_ALPHA}
	DXTKEY_HUE	 = DXTKEY_ALPHA + 1;
  {$EXTERNALSYM DXTKEY_HUE}

type
  ////////////////////////////////////////////////////////////////
  ////////////////////////////////////////////////////////////////
  // New Property setting Interfaces
  ////////////////////////////////////////////////////////////////
  ////////////////////////////////////////////////////////////////

  {$HPPEMIT 'typedef System::DelphiInterface<IPropertySetter> _di_IPropertySetter;'}
  {$EXTERNALSYM IPropertySetter}
  IPropertySetter = interface(IUnknown)
    ['{AE9472BD-B0C3-11D2-8D24-00A0C9441E20}']
    (*** IPropertySetter methods ***)
    // for loading and saving through XML
    function LoadXML(pxml: IUnknown): HResult; stdcall;
    // !!! doesn't work HResult LoadXML([in] IXMLElement * pxml);
    function PrintXML(out pszXML: pchar; cbXML: integer; out pcbPrinted: pinteger; indent: integer): HResult; stdcall;
    // for cloning a portion of the props when splitting the object
    function CloneProps(out ppSetter: IPropertySetter; rtStart, rtStop: TReferenceTime): HResult; stdcall;
    // for loading and saving programmatically
    // caller must call this in pre-sorted order, this time must be > all
    // previous times
    function AddProp(Param: TDexterParam; var paValue: TDexterValue): HResult; stdcall;
    function GetProps(out pcParams: longint; out paParam: PDexterParam; out paValue: PDexterValue): HResult; stdcall;
    // after calling GetProps, you must call FreeProps to free resources
    function FreeProps(cParams: longint; var paParam: TDexterParam; var paValue: TDexterValue): HResult; stdcall;
    // to empty to property setter, so you can start over again
    function ClearProps: HResult; stdcall;
    // for persisting
    function SaveToBlob(out pcSize: longint; out ppb: pbyte): HResult; stdcall;
    //
    function LoadFromBlob(cSize: longint; var pb: Byte): HResult; stdcall;
    // to program the object that supports IDispatch with the props
    // call with rtNow == -1 to set Static Props when your object instantiates
    // errors will be logged, if a log is provided
    function SetProps(pTarget: IUnknown; rtNow: TReferenceTime): HResult; stdcall;
    // unicode version
    function PrintXMLW({out}pszXML: PWideChar; cchXML: integer; out pcchPrinted: integer; indent: integer): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDxtCompositor> _di_IDxtCompositor;'}
  {$EXTERNALSYM IDxtCompositor}
  IDxtCompositor = interface(IDXEffect)
    ['{BB44391E-6ABD-422F-9E2E-385C9DFF51FC}']
    (*** IDxtCompositor methods ***)
    function get_OffsetX(out pVal: longint): HResult; stdcall;
    function put_OffsetX(newVal: longint): HResult; stdcall;
    function get_OffsetY(out pVal: longint): HResult; stdcall;
    function put_OffsetY(newVal: longint): HResult; stdcall;
    function get_Width(out pVal: longint): HResult; stdcall;
    function put_Width(newVal: longint): HResult; stdcall;
    function get_Height(out pVal: longint): HResult; stdcall;
    function put_Height(newVal: longint): HResult; stdcall;
    function get_SrcOffsetX(out pVal: longint): HResult; stdcall;
    function put_SrcOffsetX(newVal: longint): HResult; stdcall;
    function get_SrcOffsetY(out pVal: longint): HResult; stdcall;
    function put_SrcOffsetY(newVal: longint): HResult; stdcall;
    function get_SrcWidth(out pVal: longint): HResult; stdcall;
    function put_SrcWidth(newVal: longint): HResult; stdcall;
    function get_SrcHeight(out pVal: longint): HResult; stdcall;
    function put_SrcHeight(newVal: longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDxtAlphaSetter> _di_IDxtAlphaSetter;'}
  {$EXTERNALSYM IDxtAlphaSetter}
  IDxtAlphaSetter = interface(IDXEffect)
    ['{4EE9EAD9-DA4D-43D0-9383-06B90C08B12B}']
    (*** IDxtAlphaSetter methods ***)
    function get_Alpha(out pVal: longint): HResult; stdcall;
    function put_Alpha(newVal: longint): HResult; stdcall;
    function get_AlphaRamp(out pVal: Double): HResult; stdcall;
    function put_AlphaRamp(newVal: Double): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDxtJpeg> _di_IDxtJpeg;'}
  {$EXTERNALSYM IDxtJpeg}
  IDxtJpeg = interface(IDXEffect)
    ['{DE75D011-7A65-11D2-8CEA-00A0C9441E20}']
    (*** IDxtJpeg methods ***)
    function get_MaskNum(out pVal: longint): HResult; stdcall;
    function put_MaskNum(newVal: longint): HResult; stdcall;
    function get_MaskName(out pVal: WideString): HResult; stdcall;
    function put_MaskName(newVal: WideString): HResult; stdcall;
    function get_ScaleX(out pVal: Double): HResult; stdcall;
    function put_ScaleX(newVal: Double): HResult; stdcall;
    function get_ScaleY(out pVal: Double): HResult; stdcall;
    function put_ScaleY(newVal: Double): HResult; stdcall;
    function get_OffsetX(out pVal: longint): HResult; stdcall;
    function put_OffsetX(newVal: longint): HResult; stdcall;
    function get_OffsetY(out pVal: longint): HResult; stdcall;
    function put_OffsetY(newVal: longint): HResult; stdcall;
    function get_ReplicateX(out pVal: longint): HResult; stdcall;
    function put_ReplicateX(newVal: longint): HResult; stdcall;
    function get_ReplicateY(out pVal: longint): HResult; stdcall;
    function put_ReplicateY(newVal: longint): HResult; stdcall;
    function get_BorderColor(out pVal: longint): HResult; stdcall;
    function put_BorderColor(newVal: longint): HResult; stdcall;
    function get_BorderWidth(out pVal: longint): HResult; stdcall;
    function put_BorderWidth(newVal: longint): HResult; stdcall;
    function get_BorderSoftness(out pVal: longint): HResult; stdcall;
    function put_BorderSoftness(newVal: longint): HResult; stdcall;
    function ApplyChanges: HResult; stdcall;
    function LoadDefSettings: HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IDxtKey> _di_IDxtKey;'}
  {$EXTERNALSYM IDxtKey}
  IDxtKey = interface(IDXEffect)
    ['{3255DE56-38FB-4901-B980-94B438010D7B}']
    (*** IDxtKey methods ***)
    function get_KeyType(out pVal: integer): HResult; stdcall;
    function put_KeyType(newVal: integer): HResult; stdcall;
    function get_Hue(out pVal: integer): HResult; stdcall;
    function put_Hue(newVal: integer): HResult; stdcall;
    function get_Luminance(out pVal: integer): HResult; stdcall;
    function put_Luminance(newVal: integer): HResult; stdcall;
    function get_RGB(out pVal: DWORD): HResult; stdcall;
    function put_RGB(newVal: DWORD): HResult; stdcall;
    function get_Similarity(out pVal: integer): HResult; stdcall;
    function put_Similarity(newVal: integer): HResult; stdcall;
    function get_Invert(out pVal: BOOL): HResult; stdcall;
    function put_Invert(newVal: BOOL): HResult; stdcall;
  end;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // This little COM interface will look 'around' for the closest
    // path match for a given file. If the file already exists, then
    // this interface should hardly do anything. If it's not found,
    // it will go look for it and if successful, return S_FALSE. If it
    // cannot find the file, it will call the hook, if set and return
    // it's return code. if the hook is not set, it is in a type of
    // error condition. The Dexter-provided MediaLocator will bring up
    // a dialog box asking you to browse for your file. Other COM
    // objects may do something else.
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaLocator> _di_IMediaLocator;'}
  {$EXTERNALSYM IMediaLocator}
  IMediaLocator = interface(IUnknown)
    ['{288581E0-66CE-11D2-918F-00C0DF10D434}']
    (*** IMediaLocator methods ***)
    function FindMediaFile(Input: TBSTR; FilterString: TBSTR;
               out pOutput: TBSTR; Flags: longint): HResult; stdcall;
    function AddFoundLocation(DirectoryName: TBSTR): HResult; stdcall;
  end;

  ISampleGrabber = interface;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // This object provides caching of duration and stream type
    // information for files that would produce a directshow source
    // filter. It takes too long to figure this out in DShow right
    // now, so this is one way around it. The way it works is that
    // you first fill out the Filename property, then call and
    // ask how many streams it has, or, set the CurrentStream prop
    // and then ask for the per-stream properties, StreamType or
    // StreamLength. They both reference the CurrentStream prop that
    // you set. I also allowed you (for convenience) to just give
    // it a IUnknown Filter that represents an IBaseFilter source
    // filter that is NOT currently in a graph. It will use that
    // instead. When using this, though, you will not get cached
    // values. The cached values are stored in the system's ini file
    // called DCBC2A70-70D8-4459-BFFA-E0D61DEA3FDF.INI. Nice, huh? :-)
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaDet> _di_IMediaDet;'}
  {$EXTERNALSYM IMediaDet}
  IMediaDet = interface(IUnknown)
    ['{65BD0710-24D2-4FF7-9324-ED2E5D3ABAFA}']
    (*** IMediaDet methods ***)
    function get_Filter(out pVal: IUnknown): HResult; stdcall;
    function put_Filter(newVal: IUnknown): HResult; stdcall;
    function get_OutputStreams(out pVal: longint): HResult; stdcall;
    function get_CurrentStream(out pVal: longint): HResult; stdcall;
    function put_CurrentStream(newVal: longint): HResult; stdcall;
    function get_StreamType(out pVal: TGUID): HResult; stdcall;
    function get_StreamTypeB(out pVal: WideString): HResult; stdcall;
    function get_StreamLength(out pVal: Double): HResult; stdcall;
    function get_Filename(out pVal: WideString): HResult; stdcall;
    function put_Filename(pVal: WideString): HResult; stdcall;
    function GetBitmapBits(streamTime: Double; pBufferSize: Plongint; pBuffer: PByte;
             Width: longint; Height: longint): HResult; stdcall;
    function WriteBitmapBits(streamTime: Double; Width: longint; Height: longint;
             Filename: WideString): HResult; stdcall;
    function get_StreamMediaType(out pVal: TAMMediaType): HResult; stdcall;
    function GetSampleGrabber(out ppVal: ISampleGrabber): HResult; stdcall;
    function get_FrameRate(out pVal: Double): HResult; stdcall;
    function EnterBitmapGrabMode(SeekTime: Double): HResult; stdcall;
  end;

  // useless interface, don't use it!

  {$HPPEMIT 'typedef System::DelphiInterface<IGrfCache> _di_IGrfCache;'}
  {$EXTERNALSYM IGrfCache}
  IGrfCache = interface(IDispatch)
    ['{AE9472BE-B0C3-11D2-8D24-00A0C9441E20}']
    (*** IGrfCache methods ***)
    function AddFilter(ChainedCache: IGrfCache; Id: Int64; const pFilter: IBaseFilter;
             pName: PWideChar): HResult; stdcall;
    function ConnectPins(ChainedCache: IGrfCache; PinID1: Int64; const pPin1: IPin;
             PinID2: Int64; const pPin2: IPin): HResult; stdcall;
    function SetGraph(const pGraph: IGraphBuilder): HResult; stdcall;
    function DoConnectionsNow: HResult; stdcall;
  end;

  IAMTimeline = interface;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // The RenderEngin builds a graph from the timeline and gives
    // you some simple positional commands.
    // explained methods:
    // SetTimelineObject - tell the render engine who to parse
    // ConnectEverything - build up a graph based on the timeline
    // ScrapIt - throw away graph and everything
    // GetFilterGraph - get the graph that's built up, if any
    // SetFilterGraph - allows you to preset the graph that's built up.
    //      cannot call this if there already is a graph.

    // !!! the following methods are unused/not implemented

    // SetInterestRange - discard COM objects and memory outside of this
    //      range, if possible. Used for scrubbing on a long timeline and
    //      freeing up resources
    // SetRenderRange - pretend like a portion of the timeline IS the timeline
    //      and don't connect anything in the graph outside of that range.
    // Commit - allocate what's necessary and get prepared to run
    // Decommit - free anything possible
    // GetCaps - find out some info about the render engine
    // DoSmartRecompression - connect compressed sources if
    //      possible
    // in the graph, this will RenderPin( ) on every switcher
    //      rendering pin.
    // SetSourceNameValidation - allows you to set some flags which
    // determine how source files are found, if they need to be found.
    //      FilterString is a list of extensions to find for the media
    //      files (see OPENFILENAME filters)
    //      pOverride is a media locator you would like to use instead
    //      of the built in one
    //      The flags are defined in the struct immediately below.
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IRenderEngine> _di_IRenderEngine;'}
  {$EXTERNALSYM IRenderEngine}
  IRenderEngine = interface(IUnknown)
    ['{6BEE3A81-66C9-11D2-918F-00C0DF10D434}']
    (*** IRenderEngine methods ***)
    function SetTimelineObject(pTimeline: IAMTimeline): HResult; stdcall;
    function GetTimelineObject(out ppTimeline: IAMTimeline): HResult; stdcall;
    function GetFilterGraph(out ppFG: IGraphBuilder): HResult; stdcall;
    function SetFilterGraph(pFG: IGraphBuilder): HResult; stdcall;
    function SetInterestRange(Start, Stop: TReferenceTime): HResult; stdcall;
    function SetInterestRange2(Start, Stop: Double): HResult; stdcall;
    function SetRenderRange(Start, Stop: TReferenceTime): HResult; stdcall;
    function SetRenderRange2(Start, Stop: Double): HResult; stdcall;
    function GetGroupOutputPin(Group: longint; out ppRenderPin: IPin): HResult; stdcall;
    function ScrapIt: HResult; stdcall;
    function RenderOutputPins: HResult; stdcall;
    function GetVendorString(out pVendorID: WideString): HResult; stdcall;
    function ConnectFrontEnd: HResult; stdcall;
    function SetSourceConnectCallback(pCallback: IGrfCache): HResult; stdcall;
    function SetDynamicReconnectLevel(Level: longint): HResult; stdcall;
    function DoSmartRecompression: HResult; stdcall;
    function UseInSmartRecompressionGraph: HResult; stdcall;
    function SetSourceNameValidation(const FilterString: WideString;
             pOverride: IMediaLocator; Flags: longint): HResult; stdcall;
    function Commit: HResult; stdcall;
    function Decommit: HResult; stdcall;
    function GetCaps(Index: longint; var pReturn: longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IRenderEngine2> _di_IRenderEngine2;'}
  {$EXTERNALSYM IRenderEngine2}
  IRenderEngine2 = interface(IUnknown)
    ['{6BEE3A82-66C9-11d2-918F-00C0DF10D434}']
    (*** IRenderEngine2 methods ***)
    function SetResizerGUID(const ResizerGuid: TGUID): HResult;
  end;

  // used for the smart render engine when it needs to find a compressor
  {$HPPEMIT 'typedef System::DelphiInterface<IFindCompressorCB> _di_IFindCompressorCB;'}
  {$EXTERNALSYM IFindCompressorCB}
  IFindCompressorCB = interface(IUnknown)
    ['{F03FA8DE-879A-4D59-9B2C-26BB1CF83461}']
    (*** IFindCompressorCB methods ***)
    function GetCompressor(var pType: TAMMediaType; var pCompType: TAMMediaType;
                            out ppFilter: IBaseFilter): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<ISmartRenderEngine> _di_ISmartRenderEngine;'}
  {$EXTERNALSYM ISmartRenderEngine}
  ISmartRenderEngine = interface(IUnknown)
    ['{F03FA8CE-879A-4D59-9B2C-26BB1CF83461}']
    (*** ISmartRenderEngine methods ***)
    function SetGroupCompressor(Group: longint; pCompressor: IBaseFilter): HResult; stdcall;
    function GetGroupCompressor(Group: longint; var pCompressor: IBaseFilter): HResult; stdcall;
    function SetFindCompressorCB(pCallback: IFindCompressorCB): HResult; stdcall;
  end;

  IAMTimelineGroup = interface;
  
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
// TIMELINE TIMELINE TIMELINE TIMELINE TIMELINE TIMELINE
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // Every object on the timeline supports at least this interface.
    // explained methods:
    // Get/SetStartStop - the timeline times at which this object is
    //      active. Groups and Tracks have start times of zero.
    // FixTimes - used by the render engine. Rounds the input times
    //      to the nearest FPS of the parent Group, for use in setting
    //      up the big switch.
    // GetSubObject - get the sub-object which is associated with this
    //      timeline object. Each timeline object can carry around a
    //      pointer to 'something else'. For our Render Engine, this is
    //      a pointer to a filter that gets put into a graph. 
    // NOTE: Getting the subobject will FORCE it to load if it's possible
    //      to force this. If you don't want it to do this, don't call
    //      this function.
    // SetSubObject - see GetSubObject
    // SetSubObjectGUID - instead of giving the node a pointer, you can
    //      instead give it a GUID and see if this works instead. The
    //      sub-object will attempt to be instantiated when 'necessary'
    //      which is really when it's asked for with GetSubObject./
    //      !!! a better way to do this perhaps?
    // GetSubObjectLoaded - ask if the sub-object pointer is set
    // Get/SetTimelineType - return the major type which is stored here,
    //      used by the API user and the render engine.
    // Get/SetTimelineSubType - see above
    // Get/SetUserID - get and set a number, any number
    // GetGenID - every created object has a unique number to it. Used
    //      by the render engine.
    // Get/SetUserName - a storable name, for users of the API
    // Get/SetPropertySetter - the object that will set properties for this
    //      object (it will support IPropertySetter and it is created by 
    //      CPropertySetter)
    // Get/SetUserData - gets the persistant data used by the user of
    //      the API.
    // Get/SetMuted - set whether this object should be active or not.
    //      Setting a parent of other objects off also turns off the
    //      sub-objects.
    // Get/SetLocked - set whether you can edit this object or not.
    //      Note: the timeline doesn't enforce this, it just stores
    //      a value for convenience.
    // Get/SetDirtyRange -
    // RemoveAll - remove this object, and if in the tree already, all it's
    //        sub objects, including children
    // Remove - remove this object, and if in the tree already, all it's
    //        sub objects, but not kids
    // GetTimelineNoRef - called internally by the timeline.
    // GetGroupIBelongTo - called internally by the timeline.
    // GetEmbedDepth - find out how many tracks we are a part of
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimelineObj> _di_IAMTimelineObj;'}
  {$EXTERNALSYM IAMTimelineObj}
  IAMTimelineObj = interface(IUnknown)
    ['{78530B77-61F9-11D2-8CAD-00A024580902}']
    (*** IAMTimelineObj methods ***)
    function GetStartStop(var pStart, pStop: TReferenceTime): HResult; stdcall;
    function GetStartStop2(var pStart, pStop: TREFTIME): HResult; stdcall;
    function FixTimes(var pStart, pStop: TReferenceTime): HResult; stdcall;
    function FixTimes2(var pStart, pStop: TREFTIME): HResult; stdcall;
    function SetStartStop(Start, Stop: TReferenceTime): HResult; stdcall;
    function SetStartStop2(Start, Stop: TREFTIME): HResult; stdcall;
    function GetPropertySetter(out pVal: IPropertySetter): HResult; stdcall;
    function SetPropertySetter(newVal: IPropertySetter): HResult; stdcall;
    function GetSubObject(out pVal: IUnknown): HResult; stdcall;
    function SetSubObject(newVal: IUnknown): HResult; stdcall;
    function SetSubObjectGUID(newVal: TGUID): HResult; stdcall;
    function SetSubObjectGUIDB(const newVal: WideString): HResult; stdcall;
    function GetSubObjectGUID(var pVal: TGUID): HResult; stdcall;
    function GetSubObjectGUIDB(out pVal: WideString): HResult; stdcall;
    function GetSubObjectLoaded(var pVal: BOOL): HResult; stdcall;
    function GetTimelineType(var pVal: integer): HResult; stdcall; // TIMELINE_MAJOR_TYPE
    function SetTimelineType(newVal: integer): HResult; stdcall;   // TIMELINE_MAJOR_TYPE
    function GetUserID(var pVal: longint): HResult; stdcall;
    function SetUserID(newVal: longint): HResult; stdcall;
    function GetGenID(var pVal: longint): HResult; stdcall;
    function GetUserName(out pVal: WideString): HResult; stdcall;
    function SetUserName(const newVal: WideString): HResult; stdcall;
    function GetUserData(var pData: PByte; var pSize: Integer): HResult; stdcall;
    function SetUserData(var pData: Byte; Size: Integer): HResult; stdcall;
    function GetMuted(var pVal: BOOL): HResult; stdcall;
    function SetMuted(newVal: BOOL): HResult; stdcall;
    function GetLocked(var pVal: BOOL): HResult; stdcall;
    function SetLocked(newVal: BOOL): HResult; stdcall;
    function GetDirtyRange(var pStart, pStop: TReferenceTime): HResult; stdcall;
    function GetDirtyRange2(var pStart, pStop: TREFTIME): HResult; stdcall;
    function SetDirtyRange(Start, Stop: TReferenceTime): HResult; stdcall;
    function SetDirtyRange2(Start, Stop: TREFTIME): HResult; stdcall;
    function ClearDirty: HResult; stdcall;
    function Remove: HResult; stdcall;
    function RemoveAll: HResult; stdcall;
    function GetTimelineNoRef(var ppResult: IAMTimeline): HResult; stdcall;
    function GetGroupIBelongTo(out ppGroup: IAMTimelineGroup): HResult; stdcall;
    function GetEmbedDepth(var pVal: longint): HResult; stdcall;
  end;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // Any object on the timeline that can have an effect put on it 
    // implements this interface. This includes sources, tracks, and
    // compositions.
    // explained methods:
    // EffectInsBefore - insert an effect at the given priority onto
    //      this object. The effect's times will be clipped within
    //      this object's bounds. Use -1 to specify 'at the end' for priority.
    //      You cannot have two effects at the same priority.
    // EffectSwapPriorities - swaparoo two effects. Makes undo easier to
    //      implement.
    // EffectGetCount - get how many effects are applied to this object.
    // GetEffect - get the nth effect applied to this object
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimelineEffectable> _di_IAMTimelineEffectable;'}
  {$EXTERNALSYM IAMTimelineEffectable}
  IAMTimelineEffectable = interface(IUnknown)
    ['{EAE58537-622E-11D2-8CAD-00A024580902}']
    (*** IAMTimelineEffectable methods ***)
    function EffectInsBefore(pFX: IAMTimelineObj; priority: longint): HResult; stdcall;
    function EffectSwapPriorities(PriorityA, PriorityB: longint): HResult; stdcall;
    function EffectGetCount(var pCount: longint): HResult; stdcall;
    function GetEffect(out ppFx: IAMTimelineObj; Which: longint): HResult; stdcall;
  end;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // Any effect on the timeline will support at least this interface.
    // NOTE: The Start/Stop times on this object are RELATIVE to their
    // parent's, as are all start/stop times.
    // explained methods:
    // EffectGetPriority - finds out this effect's priority related to the others.
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimelineEffect> _di_IAMTimelineEffect;'}
  {$EXTERNALSYM IAMTimelineEffect}
  IAMTimelineEffect = interface(IUnknown)
    ['{BCE0C264-622D-11D2-8CAD-00A024580902}']
    (*** IAMTimelineEffect methods ***)
    function EffectGetPriority(var pVal: longint): HResult; stdcall;
  end;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // Any object on the timeline that can have a transition put on it
    // implements this interface
    // explained methods:
    // TransAdd - add a transition on this object. Multiple trans's on 
    //      the same object cannot overlap in time. Transitions' times
    //      must lie within the bounds of their parent.
    // TransGetCount - get how many transitions are applied to this
    //      object.
    // GetNextTrans - given a time, get the next transition that happens
    //      on this object after that time. On exit, the input time is
    //      set to the start time of the transition.
    // GetTransAtTime - find a transition forwards or backwards from
    //        a given spot. See DEXTERF_TRACK_SEARCH_FLAGS enum.
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  
  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimelineTransable> _di_IAMTimelineTransable;'}
  {$EXTERNALSYM IAMTimelineTransable}
  IAMTimelineTransable = interface(IUnknown)
    ['{378FA386-622E-11D2-8CAD-00A024580902}']
    (*** IAMTimelineTransable methods ***)
    function TransAdd(pTrans: IAMTimelineObj): HResult; stdcall;
    function TransGetCount(var pCount: longint): HResult; stdcall;
    function GetNextTrans(out ppTrans: IAMTimelineObj; var pInOut: TReferenceTime): HResult; stdcall;
    function GetNextTrans2(out ppTrans: IAMTimelineObj; var pInOut: TREFTIME): HResult; stdcall;
    function GetTransAtTime(out ppObj: IAMTimelineObj; Time: TReferenceTime; SearchDirection: longint): HResult; stdcall;
    function GetTransAtTime2(out ppObj: IAMTimelineObj; Time: TREFTIME; SearchDirection: longint): HResult; stdcall;
  end;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // Any object on the timeline that can be split into two will
    // implement this interface. Namely, source, effects, and transitions
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimelineSplittable> _di_IAMTimelineSplittable;'}
  {$EXTERNALSYM IAMTimelineSplittable}
  IAMTimelineSplittable = interface(IUnknown)
    ['{A0F840A0-D590-11D2-8D55-00A0C9441E20}']
    (*** IAMTimelineSplittable methods ***)
    function SplitAt(Time: TReferenceTime): HResult; stdcall;
    function SplitAt2(Time: TREFTIME): HResult; stdcall;
  end;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // Any trans on the timeline will support at least this interface.
    // NOTE: The Start/Stop times on this object are RELATIVE to their
    // parent's, as are all start/stop times.
    // explained methods:
    // GetCutPoint - get where this transition should cut from A to B
    //      if the transition were not applied.
    // GetA2B - get if this transition is to go from A->B or B->A.
    // GetBackwards - get if this transition should run backwards.
    // GetCutsOnly - force no transition, force doing a cut
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimelineTrans> _di_IAMTimelineTrans;'}
  {$EXTERNALSYM IAMTimelineTrans}
  IAMTimelineTrans = interface(IUnknown)
    ['{BCE0C265-622D-11D2-8CAD-00A024580902}']
    (*** IAMTimelineTrans methods ***)
    function GetCutPoint(var pTLTime: TReferenceTime): HResult; stdcall;
    function GetCutPoint2(var pTLTime: TREFTIME): HResult; stdcall;
    function SetCutPoint(TLTime: TReferenceTime): HResult; stdcall;
    function SetCutPoint2(TLTime: TREFTIME): HResult; stdcall;
    function GetSwapInputs(var pVal: BOOL): HResult; stdcall;
    function SetSwapInputs(pVal: BOOL): HResult; stdcall;
    function GetCutsOnly(var pVal: BOOL): HResult; stdcall;
    function SetCutsOnly(pVal: BOOL): HResult; stdcall;
  end;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // Sources represent any source media object on the timeline.
    // They extend an IAMTimelineObj to include media start and stop
    // times, a media name (which could represent darned near anything),
    // and a StreamNumber, which defines which stream out of a potential
    // many this stream represents from a source clip.
    // explained methods:
    // ModifyStopTime - like calling SetStartStop, but this method just
    //      adjusts the tail end of the clip.
    // FixMediaTimes - called by the render engine to round times to
    //      this source clip's parent group's FPS.
    // SpliceWithNext - if the next clip after this is the same source
    //      and this's stop time matches next's start time, the two
    //      will be joined.
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimelineSrc> _di_IAMTimelineSrc;'}
  {$EXTERNALSYM IAMTimelineSrc}
  IAMTimelineSrc = interface(IUnknown)
    ['{78530B79-61F9-11D2-8CAD-00A024580902}']
    (*** IAMTimelineSrc methods ***)
    function GetMediaTimes(var pStart, pStop: TReferenceTime): HResult; stdcall;
    function GetMediaTimes2(var pStart, pStop: TREFTIME): HResult; stdcall;
    function ModifyStopTime(Stop: TReferenceTime): HResult; stdcall;
    function ModifyStopTime2(Stop: TREFTIME): HResult; stdcall;
    function FixMediaTimes(var pStart, pStop: TReferenceTime): HResult; stdcall;
    function FixMediaTimes2(var pStart, pStop: TREFTIME): HResult; stdcall;
    function SetMediaTimes(Start, Stop: TReferenceTime): HResult; stdcall;
    function SetMediaTimes2(Start, Stop: TREFTIME): HResult; stdcall;
    function SetMediaLength(Length: TReferenceTime): HResult; stdcall;
    function SetMediaLength2(Length: TREFTIME): HResult; stdcall;
    function GetMediaLength(var pLength: TReferenceTime): HResult; stdcall;
    function GetMediaLength2(var pLength: TREFTIME): HResult; stdcall;
    function GetMediaName(out pVal: WideString): HResult; stdcall;
    function SetMediaName(const newVal: WideString): HResult; stdcall;
    function SpliceWithNext(pNext: IAMTimelineObj): HResult; stdcall;
    function GetStreamNumber(var pVal: longint): HResult; stdcall;
    function SetStreamNumber(Val: longint): HResult; stdcall;
    function IsNormalRate(var pVal: BOOL): HResult; stdcall;
    // If a source can't figure out its frames per second, this number
    // will be used (eg: Dib sequences).  AVI, MPEG, etc. will not need this
    // Use 0 fps to prevent a filename like "ski4.jpg" from using a dib seq
    function GetDefaultFPS(var pFPS: Double): HResult; stdcall;
    function SetDefaultFPS(FPS: Double): HResult; stdcall;
    // !!! This is video specific.. new interface?
    // what kind of stretching? Stretch, crop, or preserve aspect ratio?
    function GetStretchMode(var pnStretchMode: integer): HResult; stdcall;
    function SetStretchMode(nStretchMode: integer): HResult; stdcall;
  end;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // Tracks are things that can contain media in them. You can add
    // and remove sources, effects, and transitions from them. Sources
    // are added according to the current insert mode of the timeline.
    // If in OVERLAY mode, moving or adding a source to a time that's
    // already occupied by another source will wipe out any overlapping
    // portion of the underlying source. In InsertMode, everything at
    // the insert point is moved down in time to make room for the
    // new source.
    // explained methods:
    // SrcAdd - add the source to this track. The source's start/stop
    //      times must be set up first.
    // GetNextSrc - pass a time in at which you wish to find a source
    //      and it will return the first source which occurs after the 
    //      given time.
    // MoveEverythingBy - bump a bunch of objects a certain direction
    //      on the track by a given time.
    // GetSourcesCount - how many sources are on this track?
    // AreYouBlank - do you contain anything at all?
    // GetSrcAtTime - find a source at a given time. SearchDirection
    //      is which way to search. -1 = backwards, 1 = forwards
    // MakeSpace - !!! what does this do, anyhow?
    // RemoveSlice - !!! what does this do, anyhow?
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimelineTrack> _di_IAMTimelineTrack;'}
  {$EXTERNALSYM IAMTimelineTrack}
  IAMTimelineTrack = interface(IUnknown)
    ['{EAE58538-622E-11D2-8CAD-00A024580902}']
    (*** IAMTimelineTrack methods ***)
    function SrcAdd(pSource: IAMTimelineObj): HResult; stdcall;
    function GetNextSrc(out ppSrc: IAMTimelineObj; var pInOut: TReferenceTime): HResult; stdcall;
    function GetNextSrc2(out ppSrc: IAMTimelineObj; var pInOut: TREFTIME): HResult; stdcall;
    function MoveEverythingBy(Start, MoveBy: TReferenceTime): HResult; stdcall;
    function MoveEverythingBy2(Start, MoveBy: TREFTIME): HResult; stdcall;
    function GetSourcesCount(var pVal: longint): HResult; stdcall;
    function AreYouBlank(var pVal: longint): HResult; stdcall;
    function GetSrcAtTime(out ppSrc: IAMTimelineObj; Time: TReferenceTime; SearchDirection: longint): HResult; stdcall;
    function GetSrcAtTime2(out ppSrc: IAMTimelineObj; Time: TREFTIME; SearchDirection: longint): HResult; stdcall;
    function InsertSpace(rtStart, rtEnd: TReferenceTime): HResult; stdcall;
    function InsertSpace2(rtStart, rtEnd: TREFTIME): HResult; stdcall;
    function ZeroBetween(rtStart, rtEnd: TReferenceTime): HResult; stdcall;
    function ZeroBetween2(rtStart, rtEnd: TREFTIME): HResult; stdcall;
    function GetNextSrcEx(pLast: IAMTimelineObj; out ppNext: IAMTimelineObj): HResult; stdcall;
  end;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // This virtual track interface is shared by both the compositions
    // and tracks (and groups). 
    // explained methods:
    // TrackGetPriority - used by rendering objects which need to know this.
    // SetTrackDirty - !!! not sure if this is useful.
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimelineVirtualTrack> _di_IAMTimelineVirtualTrack;'}
  {$EXTERNALSYM IAMTimelineVirtualTrack}
  IAMTimelineVirtualTrack = interface(IUnknown)
    ['{A8ED5F80-C2C7-11D2-8D39-00A0C9441E20}']
    (*** IAMTimelineVirtualTrack methods ***)
    function TrackGetPriority(var pPriority: longint): HResult; stdcall;
    function SetTrackDirty: HResult; stdcall;
  end;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // Compositions are like tracks in the sense that they also
    // implement IAMVirtualTrack and you can put transitions and effects
    // on them, but they really are the SUM of those tracks that they
    // contain. They are "embedded" compositions. They should only contain
    // media of one particular type (like all video or all audio), but 
    // this is not enforced. You can add a composition to another
    // composition with VTrackInsBefore, just like you can add a track.
    // The very top composition to which all other comps and tracks belong
    // is a Group, which supports I-AMTimelineGroup as well as I-AMTimelineComp.
    // explained methods:
    // VTrackInsBefore - does NOT mean VideoTrack. Means Virtual Track.
    //      Adds a virtual track to a composition at a given priority.
    //      use -1 to mean "at the end"
    // VTrackSwapPriorities - switch two vtracks around.
    // VTrackGetCount - get how many vtracks this comp contains.
    // GetVTrack - you get the idea
    // GetCountOfType - Get the total number of these objects this comp
    //      and all it's vtracks (recursively) contains. !!! this may be dead.
    // GetRecursiveLayerOfType - given a number, returns a given track. This
    //      is done recursively. You need to pass in a pointer to the number,
    //        and it will be modified upon exit to an unknown value. DO NOT
    //      CALL THE VERSION WITH THE POINTER!
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimelineComp> _di_IAMTimelineComp;'}
  {$EXTERNALSYM IAMTimelineComp}
  IAMTimelineComp = interface(IUnknown)
    ['{EAE58536-622E-11D2-8CAD-00A024580902}']
    (*** IAMTimelineComp methods ***)
    function VTrackInsBefore(pVirtualTrack: IAMTimelineObj; priority: longint): HResult; stdcall;
    function VTrackSwapPriorities(VirtualTrackA, VirtualTrackB: longint): HResult; stdcall;
    function VTrackGetCount(var pVal: longint): HResult; stdcall;
    function GetVTrack(out ppVirtualTrack: IAMTimelineObj; Which: longint): HResult; stdcall;
    function GetCountOfType(var pVal, pValWithComps: longint; majortype: integer): HResult; stdcall; // TIMELINE_MAJOR_TYPE
    function GetRecursiveLayerOfType(out ppVirtualTrack: IAMTimelineObj; WhichLayer: longint;
             Type_: integer): HResult; stdcall; // TIMELINE_MAJOR_TYPE
    function GetRecursiveLayerOfTypeI(out ppVirtualTrack: IAMTimelineObj;
             var pWhichLayer: longint; Type_: integer): HResult; stdcall; // TIMELINE_MAJOR_TYPE
    function GetNextVTrack(pVirtualTrack: IAMTimelineObj; out ppNextVirtualTrack: IAMTimelineObj): HResult; stdcall;
  end;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // Groups represent the topmost composition in a timeline. Every
    // group should contain media of only one major type (like all video).
    // The timeline can contain multiple groups, see it's interface for
    // this. Each group has a particular "media type" that you can get/set
    // which help identify it. Each group has an associated FPS which
    // is used by the render engine in setting up the big switch. All
    // cuts on the timeline will happen rounded to this nearest FPS for
    // this particular group. Each group has a priority which enables
    // writing out multiple-stream files with 1 or more streams of the
    // same type. (Like a 2 video stream AVI file).
    // explained methods:
    // SetTimeline - this is called internally when the group is added.
    //      Do not call this.
    // GetTimeline - get the timeline this group belongs to.
    // GetPriority - get this group's priority
    // Get/SetOutputFPS - explained above
    // SetMediaTypeForVB - method for VB. Pass in 0 for video, 1 for audio
    // SetRecompFormatFromSource - set the recompress format based on the
    //  source that's loaded or set in the IAMTimelineSrc
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimelineGroup> _di_IAMTimelineGroup;'}
  {$EXTERNALSYM IAMTimelineGroup}
  IAMTimelineGroup = interface(IUnknown)
    ['{9EED4F00-B8A6-11D2-8023-00C0DF10D434}']
    (*** IAMTimelineGroup methods ***)
    function SetTimeline(pTimeline: IAMTimeline): HResult; stdcall;
    function GetTimeline(out ppTimeline: IAMTimeline): HResult; stdcall;
    function GetPriority(var pPriority: longint): HResult; stdcall;
    function GetMediaType(out value: TAMMediaType): HResult; stdcall;
    function SetMediaType(value: PAMMediaType): HResult; stdcall;
    function SetOutputFPS(FPS: Double): HResult; stdcall;
    function GetOutputFPS(var pFPS: Double): HResult; stdcall;
    function SetGroupName(const pGroupName: WideString): HResult; stdcall;
    function GetGroupName(out pGroupName: WideString): HResult; stdcall;
    function SetPreviewMode(fPreview: BOOL): HResult; stdcall;
    function GetPreviewMode(var pfPreview: BOOL): HResult; stdcall;
    function SetMediaTypeForVB(Val: longint): HResult; stdcall;
    function GetOutputBuffering(out pnBuffer: integer): HResult; stdcall;
    function SetOutputBuffering(nBuffer: integer): HResult; stdcall;
    function SetSmartRecompressFormat(var pFormat: longint): HResult; stdcall;
    function GetSmartRecompressFormat(ppFormat: Plongint): HResult; stdcall;
    function IsSmartRecompressFormatSet(var pVal: BOOL): HResult; stdcall;
    function IsRecompressFormatDirty(var pVal: BOOL): HResult; stdcall;
    function ClearRecompressFormatDirty: HResult; stdcall;
    function SetRecompFormatFromSource(pSource: IAMTimelineSrc): HResult; stdcall;
  end;

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // The main timeline. This is the base object you use to set
    // properties of the timeline as a whole, and to create blank
    // objects for use within the timeline. You cannot create the
    // objects using COM methods, you must go through the timeline to
    // create this. That's because certain information is set before
    // handing the object back to you. Every object created by the
    // timeline will support at LEAST IAMTimelineObj. For any timeline,
    // it can have one or more "groups" that it knows about. Each group
    // has the capability to hold a complete sub-tree containing media
    // that is all of one type. This logical seperation is used for the
    // rendering engine, but is not strictly enforced.
    // explained methods:
    // CreateEmptyNode - pass in a mid type and it will pass back
    //      an object of the type you requested.
    // AddGroup - add a created group to the tree
    // RemGroupFromList - make sure timeline no longer knows about this group.
    //        does NOT do anything to the group itself. Normally the user
    //        does not want to call this, it's called from the Group's Remove( ) method.
    // GetGroup - get a certain group
    // GetGroupCount - get how many groups
    // ClearAllGroups - clear everything
    // GetInsertMode - ask what the insert mode is, overlay or insert
    // SetInsertMode - set whether to insert or overlay
    // EnableTransitions - turn transitions on or off as a whole
    // EnableEffects - same deal.
    // SetIntererstRange - discard sub-objects outside of a given
    //      time range, to save memory/resources
    // Get/SetDefaultFPS - set the 'default' FPS for this timeline,
    //      the RenderEngine reads this information for setting itself up
    //      by default.
    // GetCountOfType - ask for how many of a given thing are in a given
    //      group. !!! this may be a useless function.
    // !!! not implemented
    // IsDirty - asks if anything in the timeline needs to be redrawn
    // GetDirtyRange - same deal
    // ValidateSourceNames - make sure the filenames in the sources
    //      really exist. Use the same enum flags as the render engine
    //      uses for SetSourceNameValidation. Source's filenames will be
    //      changed to those of the found ones in the timeline.
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IAMTimeline> _di_IAMTimeline;'}
  {$EXTERNALSYM IAMTimeline}
  IAMTimeline = interface(IUnknown)
    ['{78530B74-61F9-11D2-8CAD-00A024580902}']
    (*** IAMTimeline methods ***)
    function CreateEmptyNode(out ppObj: IAMTimelineObj; Type_: integer): HResult; stdcall; // TIMELINE_MAJOR_TYPE
    function AddGroup(pGroup: IAMTimelineObj): HResult; stdcall;
    function RemGroupFromList(pGroup: IAMTimelineObj): HResult; stdcall;
    function GetGroup(out ppGroup: IAMTimelineObj; WhichGroup: longint): HResult; stdcall;
    function GetGroupCount(var pCount: longint): HResult; stdcall;
    function ClearAllGroups: HResult; stdcall;
    function GetInsertMode(var pMode: longint): HResult; stdcall;
    function SetInsertMode(Mode: longint): HResult; stdcall;
    function EnableTransitions(fEnabled: BOOL): HResult; stdcall;
    function TransitionsEnabled(var pfEnabled: BOOL): HResult; stdcall;
    function EnableEffects(fEnabled: BOOL): HResult; stdcall;
    function EffectsEnabled(var pfEnabled: BOOL): HResult; stdcall;
    function SetInterestRange(Start, Stop: TReferenceTime): HResult; stdcall;
    function GetDuration(var pDuration: TReferenceTime): HResult; stdcall;
    function GetDuration2(var pDuration: Double): HResult; stdcall;
    function SetDefaultFPS(FPS: Double): HResult; stdcall;
    function GetDefaultFPS(var pFPS: Double): HResult; stdcall;
    function IsDirty(var pDirty: BOOL): HResult; stdcall;
    function GetDirtyRange(var pStart, pStop: TReferenceTime): HResult; stdcall;
    function GetCountOfType(Group: longint; var pVal, pValWithComps: longint;
             majortype: integer): HResult; stdcall; // TIMELINE_MAJOR_TYPE
    function ValidateSourceNames(ValidateFlags: longint; pOverride: IMediaLocator;
             NotifyEventHandle: integer): HResult; stdcall;
    function SetDefaultTransition(const pGuid: TGUID): HResult; stdcall;
    function GetDefaultTransition(var pGuid: TGUID): HResult; stdcall;
    function SetDefaultEffect(const pGuid: TGUID): HResult; stdcall;
    function GetDefaultEffect(var pGuid: TGUID): HResult; stdcall;
    function SetDefaultTransitionB(const pGuid: WideString): HResult; stdcall;
    function GetDefaultTransitionB(out pGuid: WideString): HResult; stdcall;
    function SetDefaultEffectB(const pGuid: WideString): HResult; stdcall;
    function GetDefaultEffectB(out pGuid: WideString): HResult; stdcall;
  end;

////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
// XML STUFF --- XML STUFF --- XML STUFF --- XML STUFF --- XML
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Xml2Dex - converts back and forth between XML and a dexter project
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  
  {$HPPEMIT 'typedef System::DelphiInterface<IXml2Dex> _di_IXml2Dex;'}
  {$EXTERNALSYM IXml2Dex}
  IXml2Dex = interface(IDispatch)
    ['{18C628ED-962A-11D2-8D08-00A0C9441E20}']
    (*** IXml2Dex methods ***)
    function CreateGraphFromFile(out ppGraph: IUnknown; pTimeline: IUnknown;
             const Filename: WideString): HResult; stdcall;
    function WriteGrfFile(pGraph: IUnknown; const Filename: WideString): HResult; stdcall;
    function WriteXMLFile(pTimeline: IUnknown; const Filename: WideString): HResult; stdcall;
    function ReadXMLFile(pTimeline: IUnknown; const XMLName: WideString): HResult; stdcall;
    function Delete(pTimeline: IUnknown; dStart, dEnd: Double): HResult; stdcall;
    function WriteXMLPart(pTimeline: IUnknown; dStart, dEnd: Double;
             const Filename: WideString): HResult; stdcall;
    function PasteXMLFile(pTimeline: IUnknown; dStart: Double; const Filename: WideString): HResult; stdcall;
    function CopyXML(pTimeline: IUnknown; dStart, dEnd: Double): HResult; stdcall;
    function PasteXML(pTimeline: IUnknown; dStart: Double): HResult; stdcall;
    function Reset: HResult; stdcall;
    function ReadXML(pTimeline: IUnknown; pxml: IUnknown): HResult; stdcall;
    function WriteXML(pTimeline: IUnknown; var pbstrXML: WideString): HResult; stdcall;
  end;

////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
// USEFUL HELPER INTERFACES
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// IAMErrorLog - an interface that receives error information from
// a timeline or a render engine.
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  {$HPPEMIT 'typedef System::DelphiInterface<IAMErrorLog> _di_IAMErrorLog;'}
  {$EXTERNALSYM IAMErrorLog}
  IAMErrorLog = interface(IUnknown)
    ['{E43E73A2-0EFA-11D3-9601-00A0C9441E20}']
    (*** IAMErrorLog methods ***)
    function LogError(Severity: longint; const pErrorString: WideString; ErrorCode: longint;
                       HResult: longint; var pExtraInfo: OleVariant): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IAMSetErrorLog> _di_IAMSetErrorLog;'}
  {$EXTERNALSYM IAMSetErrorLog}
  IAMSetErrorLog = interface(IUnknown)
    ['{963566DA-BE21-4EAF-88E9-35704F8F52A1}']
    (*** IAMSetErrorLog methods ***)
    function get_ErrorLog(out pVal: IAMErrorLog): HResult; stdcall;
    function put_ErrorLog(pVal: IAMErrorLog): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<ISampleGrabberCB> _di_ISampleGrabberCB;'}
  {$EXTERNALSYM ISampleGrabberCB}
  ISampleGrabberCB = interface(IUnknown)
    ['{0579154A-2B53-4994-B0D0-E773148EFF85}']
    (*** ISampleGrabberCB methods ***)
    function  SampleCB(SampleTime: Double; pSample: IMediaSample): HResult; stdcall;
    function  BufferCB(SampleTime: Double; pBuffer: PByte; BufferLen: longint): HResult; stdcall;
  end;
  
  {$HPPEMIT 'typedef System::DelphiInterface<ISampleGrabber> _di_ISampleGrabber;'}
  {$EXTERNALSYM ISampleGrabber}
  ISampleGrabber = interface(IUnknown)
    ['{6B652FFF-11FE-4FCE-92AD-0266B5D7C78F}']
    (*** ISampleGrabber methods ***)
    // set this to have the filter immediate stop after
    // garnishing a sample
    function SetOneShot(OneShot: BOOL): HResult; stdcall;
    // set what media type we connect to. It can be partially
    // specified by setting only the major type, OR the major and
    // subtype, OR major, subtype, and the formattype.
    function SetMediaType(var pType: TAMMediaType): HResult; stdcall;
    // after something's connected to this filter, find out
    // what it is
    function GetConnectedMediaType(out pType: TAMMediaType): HResult; stdcall;
    // call this to buffer incoming samples, so the next two methods will work
    // If this is not called, the next two methods will return
    // E_INVALIDARG
    function SetBufferSamples(BufferThem: BOOL): HResult; stdcall;
    // pass in NULL for pBuffer to get out the buffer size you need to
    // allocate. This will NOT return a pointer to a compressed dib
    // any longer! It will return the IMediaSample's GetPointer buffer.
    function GetCurrentBuffer(var pBufferSize: longint; pBuffer: Pointer): HResult; stdcall;
    // return the currently buffered sample
    function GetCurrentSample(out ppSample: IMediaSample): HResult; stdcall;
    // if this callback is set, then it will be called for
    // every sample passing through the filter. Do not take a long time
    // in the callback for smooth playback (obviously!)
    function SetCallback(pCallback: ISampleGrabberCB; WhichMethodToCallback: longint): HResult; stdcall;
  end;

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  // resize the input video to an output size, for uniformity within DES.
  // DES will set the output media type and probably also put_Size. By setting
  // the output media type, DES is stating the resizer must produce only that
  // media type on the output pin, unless it is succeeded by a put_Size call.
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  {$HPPEMIT 'typedef System::DelphiInterface<IResize> _di_IResize;'}
  {$EXTERNALSYM IResize}
  IResize = interface(IUnknown)
    ['{4ada63a0-72d5-11d2-952a-0060081840bc}']
    (*** IResize methods ***)
    function get_Size(out piHeight, piWidth: Integer; out pFlag: LongInt): HResult; stdcall;
    function get_InputSize(out piHeight, piWidth: Integer): HResult; stdcall;
    function put_Size(Height, Width: Integer; Flag: LongInt): HResult; stdcall;
    function get_MediaType(out pmt: TAMMediaType): HResult; stdcall;
    function put_MediaType(pmt: PAMMediaType): HResult; stdcall;
  end;

const
  E_NOTINTREE               = HResult($80040400);
  {$EXTERNALSYM E_NOTINTREE}
  E_RENDER_ENGINE_IS_BROKEN = HResult($80040401);
  {$EXTERNALSYM E_RENDER_ENGINE_IS_BROKEN}
  E_MUST_INIT_RENDERER      = HResult($80040402);
  {$EXTERNALSYM E_MUST_INIT_RENDERER}
  E_NOTDETERMINED           = HResult($80040403);
  {$EXTERNALSYM E_NOTDETERMINED}
  E_NO_TIMELINE             = HResult($80040404);
  {$EXTERNALSYM E_NO_TIMELINE}
  S_WARN_OUTPUTRESET        = 40404;
  {$EXTERNALSYM S_WARN_OUTPUTRESET}

// These codes are given to the app in IAMErrorLog to help identify what went wrong

// Filename doesn't exist, or DShow doesn't recognize the filetype
// EXTRA - filename
  DEX_IDS_BAD_SOURCE_NAME   = 1400;
  {$EXTERNALSYM DEX_IDS_BAD_SOURCE_NAME}

// Filename doesn't exist or contains unknown data
// EXTRA - filename (maybe no codec?)
  DEX_IDS_BAD_SOURCE_NAME2  = 1401;
  {$EXTERNALSYM DEX_IDS_BAD_SOURCE_NAME2}

// filename was required, but wasn't given
  DEX_IDS_MISSING_SOURCE_NAME   = 1402;
  {$EXTERNALSYM DEX_IDS_MISSING_SOURCE_NAME}

// cannot parse data provided by this source
// !!! what source?
  DEX_IDS_UNKNOWN_SOURCE   = 1403;
  {$EXTERNALSYM DEX_IDS_UNKNOWN_SOURCE}

// unexpected error - some DShow component not installed correctly
  DEX_IDS_INSTALL_PROBLEM   = 1404;
  {$EXTERNALSYM DEX_IDS_INSTALL_PROBLEM}

// Source filter does not accept filenames
// !!! What source?
  DEX_IDS_NO_SOURCE_NAMES   = 1405;
  {$EXTERNALSYM DEX_IDS_NO_SOURCE_NAMES}

// The group's mediatype is not supported
// EXTRA - gives you an integer group number
  DEX_IDS_BAD_MEDIATYPE   = 1406;
  {$EXTERNALSYM DEX_IDS_BAD_MEDIATYPE}

// Invalid stream number for a source
// EXTRA - gives the stream number !!! should identify which source!
  DEX_IDS_STREAM_NUMBER   = 1407;
  {$EXTERNALSYM DEX_IDS_STREAM_NUMBER}

// You ran out of memory
  DEX_IDS_OUTOFMEMORY       = 1408;
  {$EXTERNALSYM DEX_IDS_OUTOFMEMORY}

// One bitmap in a sequence was not the same type as the others
// EXTRA - gives the bitmap name
  DEX_IDS_DIBSEQ_NOTALLSAME   = 1409;
  {$EXTERNALSYM DEX_IDS_DIBSEQ_NOTALLSAME}

// Clip's mediatimes are invalid, or DibSeq too short, or a previous error caused this
// !!! Needs to give the clip name
  DEX_IDS_CLIPTOOSHORT       = 1410;
  {$EXTERNALSYM DEX_IDS_CLIPTOOSHORT}

// Clsid of FX/Transition is not a DirectX Transform
// EXTRA - gives the CLSID
  DEX_IDS_INVALID_DXT       = 1411;
  {$EXTERNALSYM DEX_IDS_INVALID_DXT}

// Default FX/Transition Clsid is not a DirectX Transform"
// EXTRA - gives the CLSID
  DEX_IDS_INVALID_DEFAULT_DXT   = 1412;
  {$EXTERNALSYM DEX_IDS_INVALID_DEFAULT_DXT}

// Your version of DX doesn't support 3D transforms"
// EXTRA - gives the CLSID of the 3D transform you tried to use
  DEX_IDS_NO_3D       = 1413;
  {$EXTERNALSYM DEX_IDS_NO_3D}

// This DirectX Transform is not the right kind, or is broken
// EXTRA - gives the CLSID of the broken transform
  DEX_IDS_BROKEN_DXT       = 1414;
  {$EXTERNALSYM DEX_IDS_BROKEN_DXT}

// No such property exists on an object
// EXTRA - gives the name of the property (if given as a string)
  DEX_IDS_NO_SUCH_PROPERTY   = 1415;
  {$EXTERNALSYM DEX_IDS_NO_SUCH_PROPERTY}

// Illegal value for a property
// EXTRA - gives the VARIANT value that was illegal
  DEX_IDS_ILLEGAL_PROPERTY_VAL   = 1416;
  {$EXTERNALSYM DEX_IDS_ILLEGAL_PROPERTY_VAL}

// Syntax error in XML file at line:
// EXTRA - gives I4 line number, if available
  DEX_IDS_INVALID_XML       = 1417;
  {$EXTERNALSYM DEX_IDS_INVALID_XML}

// Can't find filter specified in XML by Category and Instance
// EXTRA - gives friendly name (instance)
  DEX_IDS_CANT_FIND_FILTER   = 1418;
  {$EXTERNALSYM DEX_IDS_CANT_FIND_FILTER}

// Disk error writing XML file
  DEX_IDS_DISK_WRITE_ERROR   = 1419;
  {$EXTERNALSYM DEX_IDS_DISK_WRITE_ERROR}

// Clsid not a valid DShow audio effect filter
// EXTRA - gives the CLSID
  DEX_IDS_INVALID_AUDIO_FX   = 1420;
  {$EXTERNALSYM DEX_IDS_INVALID_AUDIO_FX}

// Cannot find compressor for smart recompression type
  DEX_IDS_CANT_FIND_COMPRESSOR = 1421;
  {$EXTERNALSYM DEX_IDS_CANT_FIND_COMPRESSOR}



// !!! Here go problems hooking up sources or finding codecs


// THE FOLLOWING SHOULD NEVER HAPPEN - please call me if they do

// Unexpected error in parsing the timeline
  DEX_IDS_TIMELINE_PARSE   = 1426;
  {$EXTERNALSYM DEX_IDS_TIMELINE_PARSE}
// Unexpected error building the filtergraph
  DEX_IDS_GRAPH_ERROR      = 1427;
  {$EXTERNALSYM DEX_IDS_GRAPH_ERROR}
// Unexpected error with the internal grid
  DEX_IDS_GRID_ERROR       = 1428;
  {$EXTERNALSYM DEX_IDS_GRID_ERROR}
// Unexpected error getting an interface
  DEX_IDS_INTERFACE_ERROR  = 1429;
  {$EXTERNALSYM DEX_IDS_INTERFACE_ERROR}

// these are the enumeration categories for effects
//
  CLSID_VideoEffects1Category : TGUID = '{CC7BFB42-F175-11d1-A392-00E0291F3959}';
  {$EXTERNALSYM CLSID_VideoEffects1Category}
  CLSID_VideoEffects2Category : TGUID = '{CC7BFB43-F175-11d1-A392-00E0291F3959}';
  {$EXTERNALSYM CLSID_VideoEffects2Category}
  CLSID_AudioEffects1Category : TGUID = '{cc7bfb44-f175-11d1-a392-00e0291f3959}';
  {$EXTERNALSYM CLSID_AudioEffects1Category}
  CLSID_AudioEffects2Category : TGUID = '{cc7bfb45-f175-11d1-a392-00e0291f3959}';
  {$EXTERNALSYM CLSID_AudioEffects2Category}

{**************************************************************************}
{* Module Name: mpeguids.h                                                *}
{* This file was inadvertently left out of the DirectX by Microsoft       *}
{* Universal ID's for the mpeg decoder property pages.                    *}
{*                                                                        *}
{* Copyright (c) 1995 - 1997  Microsoft Corporation.  All Rights Reserved.*}
{**************************************************************************}

  IID_IMpegVideoDecoder             : TGUID = '{EB1BB270-F71F-11CE-8E85-02608C9BABA2}';
  CLSID_MpegAudioDecodePropertyPage : TGUID = '{CC785860-B2CA-11ce-8D2B-0000E202599C}';
  CLSID_MpegVideoDecodePropertyPage : TGUID = '{E5B4EAA0-B2CA-11ce-8D2B-0000E202599C}';
  CLSID_MMMpeg1VideoCodec           : TGUID = '{eafd3a00-a2c7-11d0-b0ac-006097707a2c}';
  VIDEO_DECODER_CLSID               : TGUID = '{eafd3a00-a2c7-11d0-b0ac-006097707a2c}';
  CLSID_MMMpeg1AudioCodec           : TGUID = '{2cd28f20-a2c8-11d0-b0ac-006097707a2c}';
  AUDIO_DECODER_CLSID               : TGUID = '{2cd28f20-a2c8-11d0-b0ac-006097707a2c}';

type
// Structure to describe the caps of the mpeg video decoder.
  MPEGVideoDecoderCaps = record
    VideoMaxBitRate: DWORD
  end;
  TMPEGVideoDecoderCaps = MPEGVideoDecoderCaps;

// --------------------------------------------------------------------------------------
// Structure to hold the contents of an Mpeg 1 sequence header.                        //
// This structure come from mpgvideo.h in DXMedia SDK!!                                //
// --------------------------------------------------------------------------------------
  SeqHdrInfo = record                                                           //
    Width           : LongInt;               //  Native Width in pixels                //
    Height          : LongInt;               //  Native Height in pixels               //
    vbv             : LongInt;               //  vbv                                   //
    PictureTime     : TReferenceTime;        //  Time per picture in 100ns units       //
    TimePerFrame    : LongInt;               //  Time per picture in MPEG units        //
    BitRate         : LongInt;               //  Bits per second                       //
    XPelsPerMeter   : LongInt;               //  Pel aspect ratio                      //
    YPelsPerMeter   : LongInt;               //  Pel aspect ratio                      //
    StartTimeCode   : DWORD;                 //  First GOP time code (or -1)           //
    ActualHeaderLen : LongInt;               //  Length of valid bytes in raw seq hdr  //
    RawHeader       : array[0..139] of Byte; //  The real sequence header              //
  end;                                                                                 //
  TSeqHdrInfo = SeqHdrInfo;

// --------------------------------------------------------------------------------------

// IMpegVideoDecoder not documented...
  IMpegVideoDecoder = interface(IUnknown)
    ['{EB1BB270-F71F-11CE-8E85-02608C9BABA2}']
    (*** IMpegVideoDecoder methods ***)
    procedure get_CurrentDecoderOption(out pOptions: DWORD); stdcall;
    procedure set_CurrentDecoderOption(Options: DWORD); stdcall;
    procedure get_DefaultDecoderOption(out pOptions: DWORD); stdcall;
    procedure set_DefaultDecoderOption(Options: DWORD); stdcall;
    procedure get_QualityMsgProcessing(out pfIgnore: BOOL); stdcall;
    procedure set_QualityMsgProcessing(fIgnore: BOOL); stdcall;
    procedure get_GreyScaleOutput(out pfGrey: BOOL); stdcall;
    procedure set_GreyScaleOutput(fGrey: BOOL); stdcall;
    procedure get_SequenceHeader(out pSeqHdrInfo: TSeqHdrInfo); stdcall;
    procedure get_OutputFormat(out pOutputFormat: DWORD); stdcall;
    procedure get_FrameStatistics(out pIFramesDecoded, pPFramesDecoded, stdcall;
      pBFramesDecoded, pIFramesSkipped, pPFramesSkipped, pBFramesSkipped: DWORD);
    procedure ResetFrameStatistics; stdcall;
    procedure get_DecoderPaletteInfo(lpdwFirstEntry, lpdwLastEntry: PDWORD); stdcall;
    procedure get_DecoderPaletteEntries(dwStartEntry, dwNumEntries: DWORD;
      lppe: PPALETTEENTRY); stdcall;
    procedure get_EncryptionKey(out dwEncrptionKey: DWORD); stdcall;
    procedure put_EncryptionKey(dwEncrptionKey: DWORD); stdcall;
    procedure get_DecoderCaps(out pCaps: TMPEGVideoDecoderCaps); stdcall;
  end;

//------------------------------------------------------------------------------
// File: DShowASF.h
//
// Copyright (c) 1992-2000, Microsoft Corporation. All rights reserved.
//------------------------------------------------------------------------------

const
  IID_IConfigAsfWriter : TGUID = (D1:$45086030;D2:$F7E4;D3:$486a;D4:($B5,$04,$82,$6B,$B5,$79,$2A,$3B));
  {$EXTERNALSYM IID_IConfigAsfWriter}
 // IID_IWMProfile       : TGUID = (D1:$96406bdb;D2:$2b2b;D3:$11d3;D4:($b3,$6b,$00,$c0,$4f,$61,$08,$ff));

type
// Interface to control the ASF writer
  {$HPPEMIT 'typedef System::DelphiInterface<IConfigAsfWriter> _di_IConfigAsfWriter;'}
  {$EXTERNALSYM IConfigAsfWriter}
  IConfigAsfWriter = interface(IUnknown)
    ['{45086030-F7E4-486a-B504-826BB5792A3B}']
    (*** IConfigAsfWriter methods ***)
    // The user is expected to enumerate profiles using the wmsdk IWMProfileManager
    // method and then pass the desired profile index to the ASF Writer filter via this
    // method. The filter will then try to configure itself for the selected profile.
    //
    // NOTE: These 2 XXXProfileId methods are now obsolete because they assume
    //       version 4.0 WMSDK profiles. To configure the filter for later profile
    //       versions using a profile index, use the XXXProfile methods which take
    //       the IWMProfile* directly.
    function ConfigureFilterUsingProfileId(dwProfileId: DWORD): HResult; stdcall;
    function GetCurrentProfileId(out pdwProfileId: DWORD): HResult; stdcall;
    // configure using a pre-defined wmsdk profile guid
    function ConfigureFilterUsingProfileGuid(const guidProfile: TGUID): HResult; stdcall;
    function GetCurrentProfileGuid(out pProfileGuid: TGUID): HResult; stdcall;
    // Use these methods when a custom profile setup is preferred
    function ConfigureFilterUsingProfile(pProfile: IUnKnown): HResult; stdcall;  // IWMProfile in Window Media Format SDK
    function GetCurrentProfile(out ppProfile: IUnKnown): HResult; stdcall;       // IWMProfile in Window Media Format SDK
    // allow app to control whether or not to index file
    function SetIndexMode(bIndexFile: BOOL): HResult; stdcall;
    function GetIndexMode(out pbIndexFile: BOOL): HResult; stdcall;
  end;

//------------------------------------------------------------------------------
// File: AMParse.h
//
// Desc: Interface to the parser to get current time.  This is useful for
//       multifile playback.
//
// Copyright (c) 1996 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

const
  IID_IAMParse : TGUID = (D1:$c47a3420;D2:$005c;D3:$11d2;D4:($90,$38,$00,$a0,$c9,$69,$72,$98));
{$EXTERNALSYM IID_IAMParse}

type
//  Parser interface - supported by MPEG-2 splitter filter
  {$HPPEMIT 'typedef System::DelphiInterface<IAMParse> _di_IAMParse;'}
  {$EXTERNALSYM IAMParse}
  IAMParse = interface(IUnknown)
    ['{c47a3420-005c-11d2-9038-00a0c9697298}']
    (*** IAMParse methods ***)
    function GetParseTime(out prtCurrent: TReferenceTime): HResult; stdcall;
    function SetParseTime(rtCurrent: TReferenceTime): HResult; stdcall;
    function Flush: HResult; stdcall;
  end;

//------------------------------------------------------------------------------
// File: AudEvCod.h
//
// Desc: List of Audio device error event codes and the expected params.
//
// Copyright (c) 1999 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

const
  EC_SND_DEVICE_ERROR_BASE = $0200;
  {$EXTERNALSYM EC_SND_DEVICE_ERROR_BASE}

type
  _tagSND_DEVICE_ERROR = (
  {$IFNDEF COMPILER6_UP}
    SNDDEV_ERROR_INVALID_0,
    SNDDEV_ERROR_Open,
  {$ELSE}
    SNDDEV_ERROR_Open = 1,
  {$ENDIF}
    SNDDEV_ERROR_Close,
    SNDDEV_ERROR_GetCaps,
    SNDDEV_ERROR_PrepareHeader,
    SNDDEV_ERROR_UnprepareHeader,
    SNDDEV_ERROR_Reset,
    SNDDEV_ERROR_Restart,
    SNDDEV_ERROR_GetPosition,
    SNDDEV_ERROR_Write,
    SNDDEV_ERROR_Pause,
    SNDDEV_ERROR_Stop,
    SNDDEV_ERROR_Start,
    SNDDEV_ERROR_AddBuffer,
    SNDDEV_ERROR_Query
  );
  {$EXTERNALSYM _tagSND_DEVICE_ERROR}
  SNDDEV_ERR = _tagSND_DEVICE_ERROR;
  {$EXTERNALSYM SNDDEV_ERR}
  TSndDevErr = SNDDEV_ERR;

// Sound device error event codes
// ==============================
//
// All audio device error events are always passed on to the application, and are
// never processed by the filter graph

const
  EC_SNDDEV_IN_ERROR  = EC_SND_DEVICE_ERROR_BASE + $00;
  {$EXTERNALSYM EC_SNDDEV_IN_ERROR}
  EC_SNDDEV_OUT_ERROR = EC_SND_DEVICE_ERROR_BASE + $01;
  {$EXTERNALSYM EC_SNDDEV_OUT_ERROR}
// Parameters: ( DWORD, DWORD)
// lParam1 is an enum SND_DEVICE_ERROR which notifies the app how the device was
// being accessed when the failure occurred.
//
// lParam2 is the error returned from the sound device call.

//------------------------------------------------------------------------------
// File: ATSMedia.h
//
// Desc: Broadcast Driver Architecture Media Definitions for ATSC
//
// Copyright (c) 1996 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

//===========================================================================
//
//  ATSC Network Type
//
//===========================================================================

const
  BDANETWORKTYPE_ATSC : TGUID = '{71985F51-1CA1-11d3-9CC8-00C04F7971E0}';
  {$EXTERNALSYM BDANETWORKTYPE_ATSC}

//------------------------------------------------------------------------------
// File: MediaErr.h
//
// Desc: Shell error codes
//
// Copyright (c) 1999 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------
const
  DMO_E_INVALIDSTREAMINDEX = HResult($80040201);
  {$EXTERNALSYM DMO_E_INVALIDSTREAMINDEX}
  DMO_E_INVALIDTYPE        = HResult($80040202);
  {$EXTERNALSYM DMO_E_INVALIDTYPE}
  DMO_E_TYPE_NOT_SET       = HResult($80040203);
  {$EXTERNALSYM DMO_E_TYPE_NOT_SET}
  DMO_E_NOTACCEPTING       = HResult($80040204);
  {$EXTERNALSYM DMO_E_NOTACCEPTING}
  DMO_E_TYPE_NOT_ACCEPTED  = HResult($80040205);
  {$EXTERNALSYM DMO_E_TYPE_NOT_ACCEPTED}
  DMO_E_NO_MORE_ITEMS      = HResult($80040206);
  {$EXTERNALSYM DMO_E_NO_MORE_ITEMS}

//------------------------------------------------------------------------------
// File: MedParam.h
// Desc: Definition of the IMediaParams and associated interfaces. These
//       interfaces are designed to allow communication of curve-following
//       behaviors for parameters of objects which require dynamic changes
//       to their parameters at run time. All changes are specified by
//       timestamp and curve type to ensure the parameters can be set
//       at sufficient accuracy with predictable behavior on subsequent
//       playback of the same curves.
// Copyright (c) 1999 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

const
  IID_IMediaParamInfo : TGUID = '{6d6cbb60-a223-44aa-842f-a2f06750be6d}';
  {$EXTERNALSYM IID_IMediaParamInfo}
  IID_IMediaParams    : TGUID = '{6d6cbb61-a223-44aa-842f-a2f06750be6e}';
  {$EXTERNALSYM IID_IMediaParams}

  GUID_TIME_REFERENCE : TGUID = (D1:$93ad712b;D2:$daa0;D3:$4ffe;D4:($bc,$81,$b0,$ce,$50,$f ,$cd,$d9));
  {$EXTERNALSYM GUID_TIME_REFERENCE}
  GUID_TIME_MUSIC     : TGUID = (D1:$574c49d ;D2:$5b04;D3:$4b15;D4:($a5,$42,$ae,$28,$20,$30,$11,$7b));
  {$EXTERNALSYM GUID_TIME_MUSIC}
  GUID_TIME_SAMPLES   : TGUID = (D1:$a8593d05;D2:$c43 ;D3:$4984;D4:($9a,$63,$97,$af,$9e,$2 ,$c4,$c0));
  {$EXTERNALSYM GUID_TIME_SAMPLES}

type
  MP_DATA = {$IFDEF TYPE_IDENTITY}type {$ENDIF} Single;
  {$EXTERNALSYM MP_DATA}
  MPData = MP_DATA;
  
  _MP_Type = (
    MPT_INT,
    MPT_FLOAT,
    MPT_BOOL,
    MPT_ENUM,
    MPT_MAX
  );
  {$EXTERNALSYM _MP_Type}
  MP_TYPE = _MP_Type;
  {$EXTERNALSYM MP_TYPE}
  TMPTYPE = MP_TYPE;

const
  MPBOOL_TRUE  = 1;
  {$EXTERNALSYM MPBOOL_TRUE}
  MPBOOL_FALSE = 0;
  {$EXTERNALSYM MPBOOL_FALSE}

type
  MP_CURVE_TYPE = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM MP_CURVE_TYPE}
  MPCurveType = MP_CURVE_TYPE;
  const
    MP_CURVE_JUMP	     = $1;
    {$EXTERNALSYM MP_CURVE_JUMP}
    MP_CURVE_LINEAR    = $2;
    {$EXTERNALSYM MP_CURVE_LINEAR}
    MP_CURVE_SQUARE    = $4;
    {$EXTERNALSYM MP_CURVE_SQUARE}
    MP_CURVE_INVSQUARE = $8;
    {$EXTERNALSYM MP_CURVE_INVSQUARE}
    MP_CURVE_SINE	     = $10;
    {$EXTERNALSYM MP_CURVE_SINE}

type
  MP_CAPS = {$IFDEF TYPE_IDENTITY}type {$ENDIF} DWORD;
  {$EXTERNALSYM MP_CAPS}
  MPCaps = MP_CAPS;
  const
    MP_CAPS_CURVE_JUMP      = MP_CURVE_JUMP;
    {$EXTERNALSYM MP_CAPS_CURVE_JUMP}
    MP_CAPS_CURVE_LINEAR	  = MP_CURVE_LINEAR;
    {$EXTERNALSYM MP_CAPS_CURVE_LINEAR}
    MP_CAPS_CURVE_SQUARE	  = MP_CURVE_SQUARE;
    {$EXTERNALSYM MP_CAPS_CURVE_SQUARE}
    MP_CAPS_CURVE_INVSQUARE = MP_CURVE_INVSQUARE;
    {$EXTERNALSYM MP_CAPS_CURVE_INVSQUARE}
    MP_CAPS_CURVE_SINE	    = MP_CURVE_SINE;
    {$EXTERNALSYM MP_CAPS_CURVE_SINE}

type
  _MP_PARAMINFO = record
    mpType          : TMPType;
    mopCaps         : MPCaps;
    mpdMinValue     : MPData;
    mpdMaxValue     : MPData;
    mpdNeutralValue : MPData;
    szUnitText      : array[0..31] of WCHAR;
    szLabel         : array[0..31] of WCHAR;
  end;
  {$EXTERNALSYM _MP_PARAMINFO}
  MP_PARAMINFO = _MP_PARAMINFO;
  {$EXTERNALSYM MP_PARAMINFO}
  TMPParamInfo = _MP_PARAMINFO;

const
  DWORD_ALLPARAMS = -1;
  {$EXTERNALSYM DWORD_ALLPARAMS}

type
  MP_TIMEDATA = {$IFDEF TYPE_IDENTITY}type {$ENDIF} DWORD;
  {$EXTERNALSYM MP_TIMEDATA}
  MPTimeData = MP_TIMEDATA;

  MP_FLAGS    = {$IFDEF TYPE_IDENTITY}type {$ENDIF} DWORD;
  {$EXTERNALSYM MP_FLAGS}
  MPFlags = MP_FLAGS;

const
  MPF_ENVLP_STANDARD         = $0;
  {$EXTERNALSYM MPF_ENVLP_STANDARD}
  MPF_ENVLP_BEGIN_CURRENTVAL = $1;
  {$EXTERNALSYM MPF_ENVLP_BEGIN_CURRENTVAL}
  MPF_ENVLP_BEGIN_NEUTRALVAL = $2;
  {$EXTERNALSYM MPF_ENVLP_BEGIN_NEUTRALVAL}

type
  _MP_ENVELOPE_SEGMENT = record
    rtStart  : TReferenceTime;
    rtEnd    : TReferenceTime;
    valStart : MPData;
    valEnd   : MPData;
    iCurve   : MPCURVETYPE;
    flags    : MPFlags;
  end;
  {$EXTERNALSYM _MP_ENVELOPE_SEGMENT}
  MP_ENVELOPE_SEGMENT = _MP_ENVELOPE_SEGMENT;
  {$EXTERNALSYM MP_ENVELOPE_SEGMENT}
  TMPEnvelopeSegment = _MP_ENVELOPE_SEGMENT;
  

const
  MPF_PUNCHIN_REFTIME =	$0;
  {$EXTERNALSYM MPF_PUNCHIN_REFTIME}
  MPF_PUNCHIN_NOW     =	$1;
  {$EXTERNALSYM MPF_PUNCHIN_NOW}
  MPF_PUNCHIN_STOPPED =	$2;
  {$EXTERNALSYM MPF_PUNCHIN_STOPPED}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IMediaParamInfo> _di_IMediaParamInfo;'}
  {$EXTERNALSYM IMediaParamInfo}
  IMediaParamInfo = interface(IUnknown)
    ['{6d6cbb60-a223-44aa-842f-a2f06750be6d}']
    (*** IMediaParamInfo methods ***)
    function GetParamCount(out pdwParams: DWORD): HResult; stdcall;
    function GetParamInfo(dwParamIndex: DWORD; out pInfo: TMPPARAMINFO): HResult; stdcall;
    function GetParamText(dwParamIndex: DWORD; out ppwchText: PWideChar): HResult; stdcall;
    function GetNumTimeFormats(out pdwNumTimeFormats: DWORD): HResult; stdcall;
    function GetSupportedTimeFormat(dwFormatIndex: DWORD; out pguidTimeFormat: TGUID): HResult; stdcall;
    function GetCurrentTimeFormat(out pguidTimeFormat: TGUID; out pTimeData: MPTimeData): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaParams> _di_IMediaParams;'}
  {$EXTERNALSYM IMediaParams}
  IMediaParams = interface(IUnknown)
    ['{6d6cbb61-a223-44aa-842f-a2f06750be6e}']
    (*** IMediaParams methods ***)
    function GetParam(dwParamIndex: DWORD; out pValue: MPData): HResult; stdcall;
    function SetParam(dwParamIndex: DWORD; value: MPData): HResult; stdcall;
    function AddEnvelope(dwParamIndex, cSegments: DWORD; var pEnvelopeSegments: TMPENVELOPESEGMENT): HResult; stdcall;
    function FlushEnvelope(dwParamIndex: DWORD; refTimeStart, refTimeEnd: TReferenceTime): HResult; stdcall;
    function SetTimeFormat(const guidTimeFormat: TGUID; mpTimeData: MPTimeData): HResult; stdcall;
  end;

//------------------------------------------------------------------------------
// File: mediaobj.h
// Desc: Define the interfaces for DirectX Media Objects.
// Copyright (c) 1999 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

const
  IID_IMediaBuffer                 : TGUID = '{59eff8b9-938c-4a26-82f2-95cb84cdc837}';
  {$EXTERNALSYM IID_IMediaBuffer}
  IID_IMediaObject                 : TGUID = '{d8ad0f58-5494-4102-97c5-ec798e59bcf4}';
  {$EXTERNALSYM IID_IMediaObject}
  IID_IEnumDMO                     : TGUID = '{2c3cd98a-2bfa-4a53-9c27-5249ba64ba0f}';
  {$EXTERNALSYM IID_IEnumDMO}
  IID_IMediaObjectInPlace          : TGUID = '{651b9ad0-0fc7-4aa9-9538-d89931010741}';
  {$EXTERNALSYM IID_IMediaObjectInPlace}
  IID_IDMOQualityControl           : TGUID = '{65abea96-cf36-453f-af8a-705e98f16260}';
  {$EXTERNALSYM IID_IDMOQualityControl}
  IID_IDMOVideoOutputOptimizations : TGUID = '{be8f4f4e-5b16-4d29-b350-7f6b5d9298ac}';
  {$EXTERNALSYM IID_IDMOVideoOutputOptimizations}

type
//  DMO_MEDIA_TYPE structure
  DMO_MEDIA_TYPE = AM_MEDIA_TYPE;
  {$EXTERNALSYM DMO_MEDIA_TYPE}
  PDMOMediaType = ^TDMOMediaType;
  TDMOMediaType = DMO_MEDIA_TYPE;

const
// Per-buffer flags that apply to input buffers
  DMO_INPUT_DATA_BUFFERF_SYNCPOINT  = $1;
  {$EXTERNALSYM DMO_INPUT_DATA_BUFFERF_SYNCPOINT}
  DMO_INPUT_DATA_BUFFERF_TIME	    = $2;
  {$EXTERNALSYM DMO_INPUT_DATA_BUFFERF_TIME}
  DMO_INPUT_DATA_BUFFERF_TIMELENGTH = $4;
  {$EXTERNALSYM DMO_INPUT_DATA_BUFFERF_TIMELENGTH}

// Per-buffer flags that apply to output buffers.
  DMO_OUTPUT_DATA_BUFFERF_SYNCPOINT	  = $1;
  {$EXTERNALSYM DMO_OUTPUT_DATA_BUFFERF_SYNCPOINT}
  DMO_OUTPUT_DATA_BUFFERF_TIME	      = $2;
  {$EXTERNALSYM DMO_OUTPUT_DATA_BUFFERF_TIME}
  DMO_OUTPUT_DATA_BUFFERF_TIMELENGTH	= $4;
  {$EXTERNALSYM DMO_OUTPUT_DATA_BUFFERF_TIMELENGTH}
  // This flag means the object could have generated more data for this
  // output stream, even with no additional input from any input stream,
  // but the output buffer did not have sufficient room.
  DMO_OUTPUT_DATA_BUFFERF_INCOMPLETE	= $1000000;
  {$EXTERNALSYM DMO_OUTPUT_DATA_BUFFERF_INCOMPLETE}

// Flags returned by GetInputStatus()
  // ACCEPT_DATA indicates that the input stream is ready to accept
  // new data via ProcessInput().
  DMO_INPUT_STATUSF_ACCEPT_DATA	= $1;
  {$EXTERNALSYM DMO_INPUT_STATUSF_ACCEPT_DATA}

// Flags returned by GetInputStreamInfo()
  DMO_INPUT_STREAMF_WHOLE_SAMPLES	     = $1;
  {$EXTERNALSYM DMO_INPUT_STREAMF_WHOLE_SAMPLES}
  DMO_INPUT_STREAMF_SINGLE_SAMPLE_PER_BUFFER = $2;
  {$EXTERNALSYM DMO_INPUT_STREAMF_SINGLE_SAMPLE_PER_BUFFER}
  DMO_INPUT_STREAMF_FIXED_SAMPLE_SIZE	     = $4;
  {$EXTERNALSYM DMO_INPUT_STREAMF_FIXED_SAMPLE_SIZE}
  DMO_INPUT_STREAMF_HOLDS_BUFFERS	     = $8;
  {$EXTERNALSYM DMO_INPUT_STREAMF_HOLDS_BUFFERS}

// Flags returned by GetOutputStreamInfo()
  DMO_OUTPUT_STREAMF_WHOLE_SAMPLES	          = $1;
  {$EXTERNALSYM DMO_OUTPUT_STREAMF_WHOLE_SAMPLES}
  DMO_OUTPUT_STREAMF_SINGLE_SAMPLE_PER_BUFFER = $2;
  {$EXTERNALSYM DMO_OUTPUT_STREAMF_SINGLE_SAMPLE_PER_BUFFER}
  DMO_OUTPUT_STREAMF_FIXED_SAMPLE_SIZE	      = $4;
  {$EXTERNALSYM DMO_OUTPUT_STREAMF_FIXED_SAMPLE_SIZE}
  DMO_OUTPUT_STREAMF_DISCARDABLE	            = $8;
  {$EXTERNALSYM DMO_OUTPUT_STREAMF_DISCARDABLE}
  DMO_OUTPUT_STREAMF_OPTIONAL	                = $10;
  {$EXTERNALSYM DMO_OUTPUT_STREAMF_OPTIONAL}

//  SetType flags
  DMO_SET_TYPEF_TEST_ONLY = $1;
  {$EXTERNALSYM DMO_SET_TYPEF_TEST_ONLY}
  DMO_SET_TYPEF_CLEAR	  = $2;
  {$EXTERNALSYM DMO_SET_TYPEF_CLEAR}

//  Process Output Flags
  DMO_PROCESS_OUTPUT_DISCARD_WHEN_NO_BUFFER = $1;
  {$EXTERNALSYM DMO_PROCESS_OUTPUT_DISCARD_WHEN_NO_BUFFER}

type
// Buffer wrapper interface
  {$HPPEMIT 'typedef System::DelphiInterface<IMediaBuffer> _di_IMediaBuffer;'}
  {$EXTERNALSYM IMediaBuffer}
  IMediaBuffer = interface(IUnknown)
    ['{59eff8b9-938c-4a26-82f2-95cb84cdc837}']
    (*** IMediaBuffer methods ***)
    function SetLength(cbLength: DWORD): HResult; stdcall;
    function GetMaxLength(out pcbMaxLength: DWORD): HResult; stdcall;
    function GetBufferAndLength(out ppBuffer: PByte; // not filled if NULL
                                out pcbLength: DWORD    // not filled if NULL
                                ): HResult; stdcall;
  end;


// Output buffer info structure: one of these must be passed in for each
// output stream with every ProcessOutput() call
// All [out] fields should be
// assumed undefined if ProcessOutput() failed
  PDMOOutputDataBuffer = ^TDMOOutputDataBuffer;
  _DMO_OUTPUT_DATA_BUFFER = record
    pBuffer      : IMediaBuffer;    // [in] can be NULL
    // ProcessOutput() must set any appropriate flags and zero out the rest.
    dwStatus     : DWORD;           // [out] DMO_OUTPUT_DATA_BUFFERF_XXX (INCOMPLETE, etc.)
    // Each of these is valid if the corresponding flag is set in dwStatus
    rtTimestamp  : TReferenceTime; // [out]
    rtTimelength : TReferenceTime; // [out]
  end;
  {$EXTERNALSYM _DMO_OUTPUT_DATA_BUFFER}
  DMO_OUTPUT_DATA_BUFFER = _DMO_OUTPUT_DATA_BUFFER;
  {$EXTERNALSYM DMO_OUTPUT_DATA_BUFFER}
  TDMOOutputDataBuffer = _DMO_OUTPUT_DATA_BUFFER;

  PDMO_OUTPUT_DATA_BUFFER = ^_DMO_OUTPUT_DATA_BUFFER;
  {$EXTERNALSYM PDMO_OUTPUT_DATA_BUFFER}

  PDMOOutputDataBufferArray = ^TDMOOutputDataBufferArray;
  TDMOOutputDataBufferArray = array [0..0] of TDMOOutputDataBuffer;

  {$HPPEMIT 'typedef System::DelphiInterface<IMediaObject> _di_IMediaObject;'}
  {$EXTERNALSYM IMediaObject}
  IMediaObject = interface(IUnknown)
    ['{d8ad0f58-5494-4102-97c5-ec798e59bcf4}']
    (*** IMediaObject methods ***)
    function GetStreamCount(out pcInputStreams, pcOutputStreams: DWORD): HResult; stdcall;
    function GetInputStreamInfo(dwInputStreamIndex: DWORD; out pdwFlags: DWORD): HResult; stdcall;
    function GetOutputStreamInfo(dwOutputStreamIndex: DWORD; out pdwFlags: DWORD): HResult; stdcall;
    function GetInputType(dwInputStreamIndex, dwTypeIndex: DWORD; out pmt: TDMOMediaType): HResult; stdcall;
    function GetOutputType(dwOutputStreamIndex, dwTypeIndex: DWORD; out pmt: TDMOMediaType): HResult; stdcall;
    function SetInputType(dwInputStreamIndex: DWORD; const pmt: PDMOMediaType; dwFlags: DWORD): HResult; stdcall;
    function SetOutputType(dwOutputStreamIndex: DWORD; const pmt: PDMOMediaType; dwFlags: DWORD): HResult; stdcall;
    function GetInputCurrentType(dwInputStreamIndex: DWORD; out pmt: TDMOMediaType): HResult; stdcall;
    function GetOutputCurrentType(dwOutputStreamIndex: DWORD; out pmt: TDMOMediaType): HResult; stdcall;
    function GetInputSizeInfo(dwInputStreamIndex: DWORD; out pcbSize, pcbMaxLookahead, pcbAlignment: DWORD): HResult; stdcall;
    function GetOutputSizeInfo(dwOutputStreamIndex: DWORD; out pcbSize, pcbAlignment: DWORD): HResult; stdcall;
    function GetInputMaxLatency(dwInputStreamIndex: DWORD; out prtMaxLatency: TReferenceTime): HResult; stdcall;
    function SetInputMaxLatency(dwInputStreamIndex: DWORD; rtMaxLatency: TReferenceTime): HResult; stdcall;
    function Flush: HResult; stdcall;
    function Discontinuity(dwInputStreamIndex: DWORD): HResult; stdcall;
    function AllocateStreamingResources: HResult; stdcall;
    function FreeStreamingResources: HResult; stdcall;
    function GetInputStatus(dwInputStreamIndex: DWORD; out dwFlags: DWORD): HResult; stdcall;
    function ProcessInput(dwInputStreamIndex: DWORD; pBuffer: IMediaBuffer; dwFlags: DWORD;
               rtTimestamp, rtTimelength: TReferenceTime): HResult; stdcall;
    function ProcessOutput(dwFlags, cOutputBufferCount: DWORD; var pOutputBuffers: TDMOOutputDataBufferArray;
               out pdwStatus: DWORD): HResult; stdcall;
    function Lock(bLock: longint): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IEnumDMO> _di_IEnumDMO;'}
  {$EXTERNALSYM IEnumDMO}
  IEnumDMO = interface(IUnknown)
    ['{2c3cd98a-2bfa-4a53-9c27-5249ba64ba0f}']
    (*** IEnumDMO methods ***)
    function Next(cItemsToFetch: DWORD; out pCLSID: TGUID; out Names: PWideChar;
      pcItemsFetched: PDWORD): HResult; stdcall;
    function Skip(cItemsToSkip: DWORD): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out ppEnum: IEnumDMO): HResult; stdcall;
  end;

const
  DMO_INPLACE_NORMAL = $0;
  {$EXTERNALSYM DMO_INPLACE_NORMAL}
  DMO_INPLACE_ZERO   = $1;
  {$EXTERNALSYM DMO_INPLACE_ZERO}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IMediaObjectInPlace> _di_IMediaObjectInPlace;'}
  {$EXTERNALSYM IMediaObjectInPlace}
  IMediaObjectInPlace = interface(IUnknown)
    ['{651b9ad0-0fc7-4aa9-9538-d89931010741}']
    (*** IMediaObjectInPlace methods ***)
    function Process(ulSize: ULONG; {in/out} pData: Pointer; refTimeStart: TReferenceTime;
      dwFlags: DWORD): HResult; stdcall;
    function Clone(out ppMediaObject: IMediaObjectInPlace): HResult; stdcall;
    function GetLatency(out pLatencyTime: TReferenceTime): HResult; stdcall;
  end;

const
  DMO_QUALITY_STATUS_ENABLED	= $1;
  {$EXTERNALSYM DMO_QUALITY_STATUS_ENABLED}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IDMOQualityControl> _di_IDMOQualityControl;'}
  {$EXTERNALSYM IDMOQualityControl}
  IDMOQualityControl = interface(IUnknown)
    ['{65abea96-cf36-453f-af8a-705e98f16260}']
    (*** IDMOQualityControl methods ***)
    function SetNow(rtNow: TReferenceTime): HResult; stdcall;
    function SetStatus(dwFlags: DWORD): HResult; stdcall;
    function GetStatus(out pdwFlags: DWORD): HResult; stdcall;
  end;

const
  DMO_VOSF_NEEDS_PREVIOUS_SAMPLE = $1;
  {$EXTERNALSYM DMO_VOSF_NEEDS_PREVIOUS_SAMPLE}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IDMOVideoOutputOptimizations> _di_IDMOVideoOutputOptimizations;'}
  {$EXTERNALSYM IDMOVideoOutputOptimizations}
  IDMOVideoOutputOptimizations = interface(IUnknown)
    ['{be8f4f4e-5b16-4d29-b350-7f6b5d9298ac}']
    (*** IDMOVideoOutputOptimizations methods ***)
    function QueryOperationModePreferences(ulOutputStreamIndex: ULONG;
      var pdwRequestedCapabilities: DWORD): HResult; stdcall;
    function SetOperationMode(ulOutputStreamIndex: ULONG;
      dwEnabledFeatures: DWORD): HResult; stdcall;
    function GetCurrentOperationMode(ulOutputStreamIndex: ULONG;
      var pdwEnabledFeatures: DWORD): HResult; stdcall;
    function GetCurrentSampleRequirements(ulOutputStreamIndex: ULONG;
      var pdwRequestedFeatures: DWORD): HResult; stdcall;
  end;

(************************************************************************
*                                                                       *
*   dmodshow.h -- This module defines the DirectMusic core API's        *
*                                                                       *
*   Copyright (c) 1998, Microsoft Corp. All rights reserved.            *
*                                                                       *
************************************************************************)
const
  IID_IDMOWrapperFilter   : TGUID = '{52d6f586-9f0f-4824-8fc8-e32ca04930c2}';
  {$EXTERNALSYM IID_IDMOWrapperFilter}
  CLSID_DMOWrapperFilter  : TGUID = '{94297043-bd82-4dfd-b0de-8177739c6d20}';
  {$EXTERNALSYM CLSID_DMOWrapperFilter}
  CLSID_DMOFilterCategory : TGUID = '{bcd5796c-bd52-4d30-ab76-70f975b89199}';
  {$EXTERNALSYM CLSID_DMOFilterCategory}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IDMOWrapperFilter> _di_IDMOWrapperFilter;'}
  {$EXTERNALSYM IDMOWrapperFilter}
  IDMOWrapperFilter = interface(IUnknown)
    ['{52d6f586-9f0f-4824-8fc8-e32ca04930c2}']
    (*** IDMOWrapperFilter methods ***)
    function Init(const clsidDMO, catDMO: TGUID): HResult; stdcall;
  end;

//------------------------------------------------------------------------------
// File: DMOReg.h
//
// Desc:
//
// Copyright (c) 1999 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

const
  DMOCATEGORY_AUDIO_DECODER        : TGUID = '{57f2db8b-e6bb-4513-9d43-dcd2a6593125}';
  {$EXTERNALSYM DMOCATEGORY_AUDIO_DECODER}
  DMOCATEGORY_AUDIO_ENCODER        : TGUID = '{33D9A761-90C8-11d0-BD43-00A0C911CE86}';
  {$EXTERNALSYM DMOCATEGORY_AUDIO_ENCODER}
  DMOCATEGORY_VIDEO_DECODER        : TGUID = '{4a69b442-28be-4991-969c-b500adf5d8a8}';
  {$EXTERNALSYM DMOCATEGORY_VIDEO_DECODER}
  DMOCATEGORY_VIDEO_ENCODER        : TGUID = '{33D9A760-90C8-11d0-BD43-00A0C911CE86}';
  {$EXTERNALSYM DMOCATEGORY_VIDEO_ENCODER}
  DMOCATEGORY_AUDIO_EFFECT         : TGUID = '{f3602b3f-0592-48df-a4cd-674721e7ebeb}';
  {$EXTERNALSYM DMOCATEGORY_AUDIO_EFFECT}
  DMOCATEGORY_VIDEO_EFFECT         : TGUID = '{d990ee14-776c-4723-be46-3da2f56f10b9}';
  {$EXTERNALSYM DMOCATEGORY_VIDEO_EFFECT}
  DMOCATEGORY_AUDIO_CAPTURE_EFFECT : TGUID = '{f665aaba-3e09-4920-aa5f-219811148f09}';
  {$EXTERNALSYM DMOCATEGORY_AUDIO_CAPTURE_EFFECT}

// Acoustic Echo Canceller {BF963D80-C559-11D0-8A2B-00A0C9255AC1}
// Matches KSNODETYPE_ACOUSTIC_ECHO_CANCEL in ksmedia.h
  DMOCATEGORY_ACOUSTIC_ECHO_CANCEL : TGUID = '{BF963D80-C559-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM DMOCATEGORY_ACOUSTIC_ECHO_CANCEL}

// Noise Supression {E07F903F-62FD-4e60-8CDD-DEA7236665B5}
// Matches KSNODETYPE_AUDIO_NOISE_SUPPRESS in post Windows ME DDK's ksmedia.h
  DMOCATEGORY_AUDIO_NOISE_SUPPRESS : TGUID = '{E07F903F-62FD-4e60-8CDD-DEA7236665B5}';
  {$EXTERNALSYM DMOCATEGORY_AUDIO_NOISE_SUPPRESS}

// Automatic Gain Control {E88C9BA0-C557-11D0-8A2B-00A0C9255AC1}
// Matches KSNODETYPE_AGC in ksmedia.h
  DMOCATEGORY_AGC                  : TGUID = '{E88C9BA0-C557-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM DMOCATEGORY_AGC}

type
  PDMOPartialMediaType = ^TDMOPartialMediaType;
  _DMO_PARTIAL_MEDIATYPE = record
    type_    : TGUID;
    subtype  : TGUID;
  end;
  {$EXTERNALSYM _DMO_PARTIAL_MEDIATYPE}
  DMO_PARTIAL_MEDIATYPE = _DMO_PARTIAL_MEDIATYPE;
  {$EXTERNALSYM DMO_PARTIAL_MEDIATYPE}
  PDMO_PARTIAL_MEDIATYPE = ^DMO_PARTIAL_MEDIATYPE;
  {$EXTERNALSYM PDMO_PARTIAL_MEDIATYPE}
  TDMOPartialMediaType = _DMO_PARTIAL_MEDIATYPE;

const
  DMO_REGISTERF_IS_KEYED   = $00000001;
  {$EXTERNALSYM DMO_REGISTERF_IS_KEYED}
  DMO_ENUMF_INCLUDE_KEYED  = $00000001;
  {$EXTERNALSYM DMO_ENUMF_INCLUDE_KEYED}

type
  TDMOName = array[0..79] of WCHAR;

  function DMORegister(szName: PWideChar; const clsidDMO, guidCategory: TGUID; dwFlags: DWORD; // DMO_REGISTERF_XXX
     // Register all mediatypes supported by the object.  This carries no
     // information about which combinations of input/output types would
     // actually work.
     cInTypes: DWORD; const pInTypes: PDMO_PARTIAL_MEDIATYPE; cOutTypes: DWORD;
     const pOutTypes: PDMO_PARTIAL_MEDIATYPE): HResult; stdcall;
  {$EXTERNALSYM DMORegister}

  function DMOUnregister(const clsidDMO,
     guidCategory: TGUID// optional - GUID_NULL means unregister from all
     ): HResult; stdcall;
  {$EXTERNALSYM DMOUnregister}


  function DMOEnum(
     const guidCategory: TGUID; // GUID_NULL for "all"
     dwFlags: DWORD;      // DMO_ENUMF_XXX
     //
	// Enumerate only objects that support at least one of the specified input types
	// and at least one of the specified output types.  If no input types are specified,
	// enumerate objects regardless of what input types they support.  Same for
	// output types.
     //
     cInTypes: DWORD;
     pInTypes: PDMO_PARTIAL_MEDIATYPE;  // can be NULL only of ulInTypes = 0
     cOutTypes: DWORD;
     pOutTypes: PDMO_PARTIAL_MEDIATYPE; // can be NULL only of ulOutTypes = 0
     //
     // Output parameter - this receives a pointer to the DMO CLSID enumerator
     //
     out ppEnum: IEnumDMO): HResult; stdcall;
  {$EXTERNALSYM DMOEnum}

  function DMOGetTypes(
     const clsidDMO: TGUID;
     ulInputTypesRequested: ULONG;
     pulInputTypesSupplied: PULONG;
     pInputTypes: PDMO_PARTIAL_MEDIATYPE;
     ulOutputTypesRequested: ULONG;
     pulOutputTypesSupplied: PULONG;
     pOutputTypes: PDMO_PARTIAL_MEDIATYPE): HResult; stdcall;
  {$EXTERNALSYM DMOGetTypes}

  function DMOGetName(const clsidDMO: TGUID; szName: TDMOName): HResult; stdcall;
  {$EXTERNALSYM DMOGetName}

//------------------------------------------------------------------------------
// File: DMORt.h
//
// Desc: Miscellaneous runtime support for DirectShow Media Objects
//
// Copyright (c) 1999 - 2000, Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------

// Mediatype helpers.  MoInitMediaType() goes with MoFreeMediaType(),
// MoCreateMediaType() goes with MoDeleteMediaType() - don't mix !

// Takes a pointer to an already allocated DMO_MEDIA_TYPE structure, allocates
// a format block of cbFormat bytes, and sets appropriate members of
// DMO_MEDIA_TYPE to point to the newly allocated format block.  Also
// initializes the IUnknown pointer inside DMO_MEDIA_TYPE to NULL.
//
// The format block allocated by MoInitMediaType must be freed by calling
// MoFreeMediaType().
  function MoInitMediaType(pmt: PDMOMediaType; cbFormat: DWORD): HResult; stdcall;
  {$EXTERNALSYM MoInitMediaType}

// Frees the format block and releases any IUnknown, but does not free the
// DMO_MEDIA_TYPE structure itself.  Input parameter must point to an
// DMO_MEDIA_TYPE structure previously initialized by MoInitMediaType().
  function MoFreeMediaType(pmt: PDMOMediaType): HResult; stdcall;
  {$EXTERNALSYM MoFreeMediaType}

// Copies the DMO_MEDIA_TYPE members.  Also duplicates the format block and
// the IUnknown pointer.  Both parameters must point to valid DMO_MEDIA_TYPE
// structures.  Target structure must be later freed using MoFreeMediaType().
  function MoCopyMediaType(out pmtDest: TDMOMediaType; const pmtSrc: PDMOMediaType): HResult; stdcall;
  {$EXTERNALSYM MoCopyMediaType}

// Allocates a new DMO_MEDIA_TYPE structure and initializes it just like
// MoInitMediaType.  I.e., this function allocates both the format block
// and the DMO_MEDIA_TYPE structure itself.  Pointer to DMO_MEDIA_TYPE is
// returned as *ppmt.
//
// DMO_MEDIA_TYPE structures allocated by MoCreateMediaType() must be freed
// by calling MoDeleteMediaType().
  function MoCreateMediaType(out ppmt: PDMOMediaType; cbFormat: DWORD): HResult; stdcall;
  {$EXTERNALSYM MoCreateMediaType}

// Frees any format block, releases any IUnknown, and deletes the
// DMO_MEDIA_TYPE structure itself.  The input parameter must point to an
// DMO_MEDIA_TYPE structure previously allocated by MoCreateMediaType().
  function MoDeleteMediaType(pmt: PDMOMediaType): HResult; stdcall;
  {$EXTERNALSYM MoDeleteMediaType}

// Allocates a new DMO_MEDIA_TYPE structure and copies pmtSrc into it like
// MoCopyMediaType.  I.e., this function allocates a new DMO_MEDIA_TYPE struct
// as well as a new format block for the target mediatype.  Trager mediatype
// must later be freed using MoDeleteMediaType().
  function MoDuplicateMediaType(out ppmtDest: PDMOMediaType; const pmtSrc: PDMOMediaType): HResult; stdcall;
  {$EXTERNALSYM MoDuplicateMediaType}

{===============================================================================
 *
 * Copyright (C) Microsoft Corporation, 1996 - 1999
 *
 * Module Name: ks.h
 * Abstract:
 *   Windows Driver Model/Connection and Streaming Architecture (WDM-CSA)
 *   core definitions.
 *
 * Note : All _NTDDK_ specific definitions have been removed from original file
 *        because never used in DX8SDK.
 ===============================================================================}
const
//===========================================================================
  IOCTL_KS_PROPERTY      = DWORD(3080195);
  {$EXTERNALSYM IOCTL_KS_PROPERTY}
  IOCTL_KS_ENABLE_EVENT  = DWORD(3080199);
  {$EXTERNALSYM IOCTL_KS_ENABLE_EVENT}
  IOCTL_KS_DISABLE_EVENT = DWORD(3080203);
  {$EXTERNALSYM IOCTL_KS_DISABLE_EVENT}
  IOCTL_KS_METHOD        = DWORD(3080207);
  {$EXTERNALSYM IOCTL_KS_METHOD}
  IOCTL_KS_WRITE_STREAM  = DWORD(3112979);
  {$EXTERNALSYM IOCTL_KS_WRITE_STREAM}
  IOCTL_KS_READ_STREAM   = DWORD(3096599);
  {$EXTERNALSYM IOCTL_KS_READ_STREAM}
  IOCTL_KS_RESET_STATE   = DWORD(3080219);
  {$EXTERNALSYM IOCTL_KS_RESET_STATE}
//===========================================================================

type
  KSRESET = (
    KSRESET_BEGIN,
    KSRESET_END
  );
  {$EXTERNALSYM KSRESET}
  TKSReset = KSRESET;

  KSSTATE = (
    KSSTATE_STOP,
    KSSTATE_ACQUIRE,
    KSSTATE_PAUSE,
    KSSTATE_RUN
  );
  {$EXTERNALSYM KSSTATE}
  PKSSTATE = ^KSSTATE;
  {$EXTERNALSYM PKSSTATE}
  TKSState = KSSTATE;

const
  KSPRIORITY_LOW       = $00000001;
  {$EXTERNALSYM KSPRIORITY_LOW}
  KSPRIORITY_NORMAL    = $40000000;
  {$EXTERNALSYM KSPRIORITY_NORMAL}
  KSPRIORITY_HIGH      = $80000000;
  {$EXTERNALSYM KSPRIORITY_HIGH}
  KSPRIORITY_EXCLUSIVE = $FFFFFFFF;
  {$EXTERNALSYM KSPRIORITY_EXCLUSIVE}

type
  KSPRIORITY = record
    PriorityClass    : ULONG;
    PrioritySubClass : ULONG;
  end;
  {$EXTERNALSYM KSPRIORITY}
  PKSPRIORITY = ^KSPRIORITY;
  {$EXTERNALSYM PKSPRIORITY}
  TKSPriority = KSPRIORITY;

  KSIDENTIFIER = record
    case Integer of
      0: (
        Set_  : TGUID;
        Id    : ULONG;
        Flags : ULONG);
      1: (
        Alignment : int64);
  end;
  {$EXTERNALSYM KSIDENTIFIER}
  PKSIDENTIFIER = ^KSIDENTIFIER;
  {$EXTERNALSYM PKSIDENTIFIER}
  TKSIdentifier = KSIDENTIFIER;

  KSPROPERTY  = {$IFDEF TYPE_IDENTITY}type {$ENDIF} KSIDENTIFIER;
  {$EXTERNALSYM KSPROPERTY}
  PKSPROPERTY = ^KSPROPERTY;
  {$EXTERNALSYM PKSPROPERTY}
  KSMETHOD    = KSPROPERTY;
  {$EXTERNALSYM KSMETHOD}
  PKSMETHOD   = ^KSMETHOD;
  {$EXTERNALSYM PKSMETHOD}
  KSEVENT     = PKSMETHOD;
  {$EXTERNALSYM KSEVENT}
  PKSEVENT    = ^KSEVENT;
  {$EXTERNALSYM PKSEVENT}

const
  KSMETHOD_TYPE_NONE             = $00000000;
  {$EXTERNALSYM KSMETHOD_TYPE_NONE}
  KSMETHOD_TYPE_READ             = $00000001;
  {$EXTERNALSYM KSMETHOD_TYPE_READ}
  KSMETHOD_TYPE_WRITE            = $00000002;
  {$EXTERNALSYM KSMETHOD_TYPE_WRITE}
  KSMETHOD_TYPE_MODIFY           = $00000003;
  {$EXTERNALSYM KSMETHOD_TYPE_MODIFY}
  KSMETHOD_TYPE_SOURCE           = $00000004;
  {$EXTERNALSYM KSMETHOD_TYPE_SOURCE}

  KSMETHOD_TYPE_SEND             = $00000001;
  {$EXTERNALSYM KSMETHOD_TYPE_SEND}
  KSMETHOD_TYPE_SETSUPPORT       = $00000100;
  {$EXTERNALSYM KSMETHOD_TYPE_SETSUPPORT}
  KSMETHOD_TYPE_BASICSUPPORT     = $00000200;
  {$EXTERNALSYM KSMETHOD_TYPE_BASICSUPPORT}

  KSMETHOD_TYPE_TOPOLOGY         = $10000000;
  {$EXTERNALSYM KSMETHOD_TYPE_TOPOLOGY}

  KSPROPERTY_TYPE_GET            = $00000001;
  {$EXTERNALSYM KSPROPERTY_TYPE_GET}
  KSPROPERTY_TYPE_SET            = $00000002;
  {$EXTERNALSYM KSPROPERTY_TYPE_SET}
  KSPROPERTY_TYPE_SETSUPPORT     = $00000100;
  {$EXTERNALSYM KSPROPERTY_TYPE_SETSUPPORT}
  KSPROPERTY_TYPE_BASICSUPPORT   = $00000200;
  {$EXTERNALSYM KSPROPERTY_TYPE_BASICSUPPORT}
  KSPROPERTY_TYPE_RELATIONS      = $00000400;
  {$EXTERNALSYM KSPROPERTY_TYPE_RELATIONS}
  KSPROPERTY_TYPE_SERIALIZESET   = $00000800;
  {$EXTERNALSYM KSPROPERTY_TYPE_SERIALIZESET}
  KSPROPERTY_TYPE_UNSERIALIZESET = $00001000;
  {$EXTERNALSYM KSPROPERTY_TYPE_UNSERIALIZESET}
  KSPROPERTY_TYPE_SERIALIZERAW   = $00002000;
  {$EXTERNALSYM KSPROPERTY_TYPE_SERIALIZERAW}
  KSPROPERTY_TYPE_UNSERIALIZERAW = $00004000;
  {$EXTERNALSYM KSPROPERTY_TYPE_UNSERIALIZERAW}
  KSPROPERTY_TYPE_SERIALIZESIZE  = $00008000;
  {$EXTERNALSYM KSPROPERTY_TYPE_SERIALIZESIZE}
  KSPROPERTY_TYPE_DEFAULTVALUES  = $00010000;
  {$EXTERNALSYM KSPROPERTY_TYPE_DEFAULTVALUES}

  KSPROPERTY_TYPE_TOPOLOGY       = $10000000;
  {$EXTERNALSYM KSPROPERTY_TYPE_TOPOLOGY}

type
  PKSPNode = ^TKSPNode;
  KSP_NODE = record
    Property_ : KSPROPERTY;
    NodeId    : ULONG;
    Reserved  : ULONG;
  end;
  {$EXTERNALSYM KSP_NODE}
  PKSP_NODE = ^KSP_NODE;
  {$EXTERNALSYM PKSP_NODE}
  TKSPNode = KSP_NODE;

  PKSMNode = ^TKSMNode;
  KSM_NODE = record
    Method   : KSMETHOD;
    NodeId   : ULONG;
    Reserved : ULONG;
  end;
  {$EXTERNALSYM KSM_NODE}
  PKSM_NODE = ^KSM_NODE;
  {$EXTERNALSYM PKSM_NODE}
  TKSMNode = KSM_NODE;

  PKSENode = ^TKSENode;
  KSE_NODE = record
    Event    : KSEVENT;
    NodeId   : ULONG;
    Reserved : ULONG;
  end;
  {$EXTERNALSYM KSE_NODE}
  PKSE_NODE = ^KSE_NODE;
  {$EXTERNALSYM PKSE_NODE}
  TKSENode = KSE_NODE;

const
  KSPROPTYPESETID_General : TGUID = '{97E99BA0-BDEA-11CF-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSPROPTYPESETID_General}

type
  PKSMultipleItem = ^TKSMultipleItem;
  KSMULTIPLE_ITEM = record
    Size  : ULONG;
    Count : ULONG;
  end;
  {$EXTERNALSYM KSMULTIPLE_ITEM}
  PKSMULTIPLE_ITEM = ^KSMULTIPLE_ITEM;
  {$EXTERNALSYM PKSMULTIPLE_ITEM}
  TKSMultipleItem = KSMULTIPLE_ITEM;

  PKSPropertyDescription = ^TKSPropertyDescription;
  KSPROPERTY_DESCRIPTION = record
    AccessFlags      : ULONG;
    DescriptionSize  : ULONG;
    PropTypeSet      : TKSIDENTIFIER;
    MembersListCount : ULONG;
    Reserved         : ULONG;
  end;
  {$EXTERNALSYM KSPROPERTY_DESCRIPTION}
  PKSPROPERTY_DESCRIPTION = ^KSPROPERTY_DESCRIPTION;
  {$EXTERNALSYM PKSPROPERTY_DESCRIPTION}
  TKSPropertyDescription = KSPROPERTY_DESCRIPTION;

const
  KSPROPERTY_MEMBER_RANGES        = $00000001;
  {$EXTERNALSYM KSPROPERTY_MEMBER_RANGES}
  KSPROPERTY_MEMBER_STEPPEDRANGES = $00000002;
  {$EXTERNALSYM KSPROPERTY_MEMBER_STEPPEDRANGES}
  KSPROPERTY_MEMBER_VALUES        = $00000003;
  {$EXTERNALSYM KSPROPERTY_MEMBER_VALUES}

  KSPROPERTY_MEMBER_FLAG_DEFAULT  = $00000001;
  {$EXTERNALSYM KSPROPERTY_MEMBER_FLAG_DEFAULT}

type
  PKSPropertyMembersHeader = ^TKSPropertyMembersHeader;
  KSPROPERTY_MEMBERSHEADER = record
    MembersFlags : ULONG;
    MembersSize  : ULONG;
    MembersCount : ULONG;
    Flags        : ULONG;
  end;
  {$EXTERNALSYM KSPROPERTY_MEMBERSHEADER}
  PKSPROPERTY_MEMBERSHEADER = ^KSPROPERTY_MEMBERSHEADER;
  {$EXTERNALSYM PKSPROPERTY_MEMBERSHEADER}
  TKSPropertyMembersHeader = KSPROPERTY_MEMBERSHEADER;

  PKSPropertyBoundsLong = ^TKSPropertyBoundsLong;
  KSPROPERTY_BOUNDS_LONG = record
    case Integer of
      0: (
        SignedMinimum   : Longint;
        SignedMaximum   : Longint);
      1: (
        UnsignedMinimum : ULONG;
        UnsignedMaximum : ULONG);
  end;
  {$EXTERNALSYM KSPROPERTY_BOUNDS_LONG}
  PKSPROPERTY_BOUNDS_LONG = ^KSPROPERTY_BOUNDS_LONG;
  {$EXTERNALSYM PKSPROPERTY_BOUNDS_LONG}
  TKSPropertyBoundsLong = KSPROPERTY_BOUNDS_LONG;

  PKSPropertyBoundsLongLong = ^TKSPropertyBoundsLongLong;
  KSPROPERTY_BOUNDS_LONGLONG = record
    case Integer of
      0: (
        SignedMinimum   : TLargeInteger;
        SignedMaximum   : TLargeInteger);
      1: (
        UnsignedMinimum : TULargeInteger;
        UnsignedMaximum : TULargeInteger);
  end;
  {$EXTERNALSYM KSPROPERTY_BOUNDS_LONGLONG}
  PKSPROPERTY_BOUNDS_LONGLONG = ^KSPROPERTY_BOUNDS_LONGLONG;
  {$EXTERNALSYM PKSPROPERTY_BOUNDS_LONGLONG}
  TKSPropertyBoundsLongLong = KSPROPERTY_BOUNDS_LONGLONG;

  PKSPropertySteppingLong = ^TKSPropertySteppingLong;
  KSPROPERTY_STEPPING_LONG = record
    SteppingDelta : ULONG;
    Reserved      : ULONG;
    Bounds        : TKSPropertyBoundsLong;
  end;
  {$EXTERNALSYM KSPROPERTY_STEPPING_LONG}
  PKSPROPERTY_STEPPING_LONG = ^KSPROPERTY_STEPPING_LONG;
  {$EXTERNALSYM PKSPROPERTY_STEPPING_LONG}
  TKSPropertySteppingLong = KSPROPERTY_STEPPING_LONG;

  PKSPropertySteppingLongLong = ^TKSPropertySteppingLongLong;
  KSPROPERTY_STEPPING_LONGLONG = record
    SteppingDelta : TULargeInteger;
    Bounds        : TKSPropertyBoundsLongLong;
  end;
  {$EXTERNALSYM KSPROPERTY_STEPPING_LONGLONG}
  PKSPROPERTY_STEPPING_LONGLONG = KSPROPERTY_STEPPING_LONGLONG;
  {$EXTERNALSYM PKSPROPERTY_STEPPING_LONGLONG}
  TKSPropertySteppingLongLong = KSPROPERTY_STEPPING_LONGLONG;

//===========================================================================
  PKSWORKER = pointer;
  {$EXTERNALSYM PKSWORKER}

  KSEVENTDATA = record
    NotificationType : ULONG;
    case integer of
      0: ( // EventHandle
        Event          : THandle;
        Reserved       : array[0..1] of ULONG);
      1: ( // SemaphoreHandle
        Semaphore      : THandle;
        Reserved_       : ULONG;
        Adjustment     : Longint);
      2: ( // Alignment
        Unused         : Pointer;
        Alignment      : array[0..1] of Longint);
  end;
  {$EXTERNALSYM KSEVENTDATA}
  PKSEVENTDATA = ^KSEVENTDATA;
  {$EXTERNALSYM PKSEVENTDATA}
  TKSEventData = KSEVENTDATA;

const
  KSEVENTF_EVENT_HANDLE     = $00000001;
  {$EXTERNALSYM KSEVENTF_EVENT_HANDLE}
  KSEVENTF_SEMAPHORE_HANDLE = $00000002;
  {$EXTERNALSYM KSEVENTF_SEMAPHORE_HANDLE}

  KSEVENT_TYPE_ENABLE         = $00000001;
  {$EXTERNALSYM KSEVENT_TYPE_ENABLE}
  KSEVENT_TYPE_ONESHOT        = $00000002;
  {$EXTERNALSYM KSEVENT_TYPE_ONESHOT}
  KSEVENT_TYPE_ENABLEBUFFERED = $00000004;
  {$EXTERNALSYM KSEVENT_TYPE_ENABLEBUFFERED}
  KSEVENT_TYPE_SETSUPPORT     = $00000100;
  {$EXTERNALSYM KSEVENT_TYPE_SETSUPPORT}
  KSEVENT_TYPE_BASICSUPPORT   = $00000200;
  {$EXTERNALSYM KSEVENT_TYPE_BASICSUPPORT}
  KSEVENT_TYPE_QUERYBUFFER    = $00000400;
  {$EXTERNALSYM KSEVENT_TYPE_QUERYBUFFER}

  KSEVENT_TYPE_TOPOLOGY       = $10000000;
  {$EXTERNALSYM KSEVENT_TYPE_TOPOLOGY}

type
  KSQUERYBUFFER = record
    Event     : KSEVENT;
    EventData : PKSEVENTDATA;
    Reserved  : Pointer;
  end;
  {$EXTERNALSYM KSQUERYBUFFER}
  PKSQUERYBUFFER = ^KSQUERYBUFFER;
  {$EXTERNALSYM PKSQUERYBUFFER}
  TKSQueryBuffer = KSQUERYBUFFER;

  KSRELATIVEEVENT = record
     Size      : ULONG;
     Flags     : ULONG;
     case integer of
       0: ( ObjectHandle  : THandle;
            Reserved      : Pointer;
            Event         : KSEVENT;
            EventData     : TKSEVENTDATA);
       1: ( ObjectPointer : Pointer);

  end;
  {$EXTERNALSYM KSRELATIVEEVENT}
  TKSRelativeEvent = KSRELATIVEEVENT;

const
  KSRELATIVEEVENT_FLAG_HANDLE  = $00000001;
  {$EXTERNALSYM KSRELATIVEEVENT_FLAG_HANDLE}
  KSRELATIVEEVENT_FLAG_POINTER = $00000002;
  {$EXTERNALSYM KSRELATIVEEVENT_FLAG_POINTER}

//===========================================================================

type
  PKSEventTimeMark = ^TKSEventTimeMark;
  KSEVENT_TIME_MARK = record
    EventData : TKSEVENTDATA;
    MarkTime  : int64;
  end;
  {$EXTERNALSYM KSEVENT_TIME_MARK}
  PKSEVENT_TIME_MARK = ^KSEVENT_TIME_MARK;
  {$EXTERNALSYM PKSEVENT_TIME_MARK}
  TKSEventTimeMark = KSEVENT_TIME_MARK;

  PKSEventTimeInterval = ^TKSEventTimeInterval;
  KSEVENT_TIME_INTERVAL = record
    EventData : TKSEVENTDATA;
    TimeBase  : int64;
    Interval  : int64;
  end;
  {$EXTERNALSYM KSEVENT_TIME_INTERVAL}
  PKSEVENT_TIME_INTERVAL = ^KSEVENT_TIME_INTERVAL;
  {$EXTERNALSYM PKSEVENT_TIME_INTERVAL}
  TKSEventTimeInterval = KSEVENT_TIME_INTERVAL;

  KSINTERVAL = record
    TimeBase : int64;
    Interval : int64;
  end;
  {$EXTERNALSYM KSINTERVAL}
  PKSINTERVAL = ^KSINTERVAL;
  {$EXTERNALSYM PKSINTERVAL}
  TKSInterval = KSINTERVAL;

//===========================================================================
const
  KSPROPSETID_General : TGUID = '{1464EDA5-6A8F-11D1-9AA7-00A0C9223196}';
  {$EXTERNALSYM KSPROPSETID_General}

type
  KSPROPERTY_GENERAL = (
  {$EXTERNALSYM KSPROPERTY_GENERAL}
    KSPROPERTY_GENERAL_COMPONENTID
  );
  TKSPropertyGeneral = KSPROPERTY_GENERAL;

  KSCOMPONENTID = record
    Manufacturer : TGUID;
    Product      : TGUID;
    Component    : TGUID;
    Name         : TGUID;
    Version      : ULONG;
    Revision     : ULONG;
  end;
  {$EXTERNALSYM KSCOMPONENTID}
  PKSCOMPONENTID = ^KSCOMPONENTID;
  {$EXTERNALSYM PKSCOMPONENTID}
  TKSComponentID = KSCOMPONENTID;

const
  KSMETHODSETID_StreamIo : TGUID = '{65D003CA-1523-11D2-B27A-00A0C9223196}';
  {$EXTERNALSYM KSMETHODSETID_StreamIo}

type
  KSMETHOD_STREAMIO = (
    KSMETHOD_STREAMIO_READ,
    KSMETHOD_STREAMIO_WRITE
  );
  {$EXTERNALSYM KSMETHOD_STREAMIO}
  TKSMethodStreamIO = KSMETHOD_STREAMIO;

const
  KSPROPSETID_MediaSeeking : TGUID = '{EE904F0C-D09B-11D0-ABE9-00A0C9223196}';
  {$EXTERNALSYM KSPROPSETID_MediaSeeking}

type
  KSPROPERTY_MEDIASEEKING = (
    KSPROPERTY_MEDIASEEKING_CAPABILITIES,
    KSPROPERTY_MEDIASEEKING_FORMATS,
    KSPROPERTY_MEDIASEEKING_TIMEFORMAT,
    KSPROPERTY_MEDIASEEKING_POSITION,
    KSPROPERTY_MEDIASEEKING_STOPPOSITION,
    KSPROPERTY_MEDIASEEKING_POSITIONS,
    KSPROPERTY_MEDIASEEKING_DURATION,
    KSPROPERTY_MEDIASEEKING_AVAILABLE,
    KSPROPERTY_MEDIASEEKING_PREROLL,
    KSPROPERTY_MEDIASEEKING_CONVERTTIMEFORMAT
  );
  {$EXTERNALSYM KSPROPERTY_MEDIASEEKING}
  TKSPropertyMediaSeeking = KSPROPERTY_MEDIASEEKING;

  KS_SEEKING_FLAGS = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM KS_SEEKING_FLAGS}
  const
    KS_SEEKING_NoPositioning          = $0;
    {$EXTERNALSYM KS_SEEKING_NoPositioning}
    KS_SEEKING_AbsolutePositioning    = $1;
    {$EXTERNALSYM KS_SEEKING_AbsolutePositioning}
    KS_SEEKING_RelativePositioning    = $2;
    {$EXTERNALSYM KS_SEEKING_RelativePositioning}
    KS_SEEKING_IncrementalPositioning = $3;
    {$EXTERNALSYM KS_SEEKING_IncrementalPositioning}
    KS_SEEKING_PositioningBitsMask    = $3;
    {$EXTERNALSYM KS_SEEKING_PositioningBitsMask}
    KS_SEEKING_SeekToKeyFrame         = $4;
    {$EXTERNALSYM KS_SEEKING_SeekToKeyFrame}
    KS_SEEKING_ReturnTime             = $8;
    {$EXTERNALSYM KS_SEEKING_ReturnTime}

type
  KS_SEEKING_CAPABILITIES = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM KS_SEEKING_CAPABILITIES}
  const
    KS_SEEKING_CanSeekAbsolute  = $1;
    {$EXTERNALSYM KS_SEEKING_CanSeekAbsolute}
    KS_SEEKING_CanSeekForwards  = $2;
    {$EXTERNALSYM KS_SEEKING_CanSeekForwards}
    KS_SEEKING_CanSeekBackwards = $4;
    {$EXTERNALSYM KS_SEEKING_CanSeekBackwards}
    KS_SEEKING_CanGetCurrentPos = $8;
    {$EXTERNALSYM KS_SEEKING_CanGetCurrentPos}
    KS_SEEKING_CanGetStopPos    = $10;
    {$EXTERNALSYM KS_SEEKING_CanGetStopPos}
    KS_SEEKING_CanGetDuration   = $20;
    {$EXTERNALSYM KS_SEEKING_CanGetDuration}
    KS_SEEKING_CanPlayBackwards = $40;
    {$EXTERNALSYM KS_SEEKING_CanPlayBackwards}

type
  PKSPropertyPositions = ^TKSPropertyPositions;
  KSPROPERTY_POSITIONS = record
    Current      : int64;
    Stop         : int64;
    CurrentFlags : KS_SEEKING_FLAGS;
    StopFlags    : KS_SEEKING_FLAGS;
  end;
  {$EXTERNALSYM KSPROPERTY_POSITIONS}
  PKSPROPERTY_POSITIONS = ^KSPROPERTY_POSITIONS;
  {$EXTERNALSYM PKSPROPERTY_POSITIONS}
  TKSPropertyPositions = KSPROPERTY_POSITIONS;

  PKSPropertyMediaAvailable = ^TKSPropertyMediaAvailable;
  KSPROPERTY_MEDIAAVAILABLE = record
    Earliest : int64;
    Latest   : int64;
  end;
  {$EXTERNALSYM KSPROPERTY_MEDIAAVAILABLE}
  PKSPROPERTY_MEDIAAVAILABLE = ^KSPROPERTY_MEDIAAVAILABLE;
  {$EXTERNALSYM PKSPROPERTY_MEDIAAVAILABLE}
  TKSPropertyMediaAvailable = KSPROPERTY_MEDIAAVAILABLE;

  PKSPTimeFormat = ^TKSPTimeFormat;
  KSP_TIMEFORMAT = record
    Property_    : KSPROPERTY;
    SourceFormat : TGUID;
    TargetFormat : TGUID;
    Time         : int64;
  end;
  {$EXTERNALSYM KSP_TIMEFORMAT}
  PKSP_TIMEFORMAT = ^KSP_TIMEFORMAT;
  {$EXTERNALSYM PKSP_TIMEFORMAT}
  TKSPTimeFormat = KSP_TIMEFORMAT;

//===========================================================================

const
  KSPROPSETID_Topology : TGUID = '{720D4AC0-7533-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSPROPSETID_Topology}

type
  KSPROPERTY_TOPOLOGY = (
    KSPROPERTY_TOPOLOGY_CATEGORIES,
    KSPROPERTY_TOPOLOGY_NODES,
    KSPROPERTY_TOPOLOGY_CONNECTIONS,
    KSPROPERTY_TOPOLOGY_NAME
  );
  {$EXTERNALSYM KSPROPERTY_TOPOLOGY}
  TKSPropertyTopology = KSPROPERTY_TOPOLOGY;

const
  KSCATEGORY_BRIDGE                  : TGUID = '{085AFF00-62CE-11CF-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSCATEGORY_BRIDGE}
  KSCATEGORY_CAPTURE                 : TGUID = '{65E8773D-8F56-11D0-A3B9-00A0C9223196}';
  {$EXTERNALSYM KSCATEGORY_CAPTURE}
  KSCATEGORY_RENDER                  : TGUID = '{65E8773E-8F56-11D0-A3B9-00A0C9223196}';
  {$EXTERNALSYM KSCATEGORY_RENDER}
  KSCATEGORY_MIXER                   : TGUID = '{AD809C00-7B88-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSCATEGORY_MIXER}
  KSCATEGORY_SPLITTER                : TGUID = '{0A4252A0-7E70-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSCATEGORY_SPLITTER}
  KSCATEGORY_DATACOMPRESSOR          : TGUID = '{1E84C900-7E70-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSCATEGORY_DATACOMPRESSOR}
  KSCATEGORY_DATADECOMPRESSOR        : TGUID = '{2721AE20-7E70-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSCATEGORY_DATADECOMPRESSOR}
  KSCATEGORY_DATATRANSFORM           : TGUID = '{2EB07EA0-7E70-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSCATEGORY_DATATRANSFORM}
  KSCATEGORY_COMMUNICATIONSTRANSFORM : TGUID = '{CF1DDA2C-9743-11D0-A3EE-00A0C9223196}';
  {$EXTERNALSYM KSCATEGORY_COMMUNICATIONSTRANSFORM}
  KSCATEGORY_INTERFACETRANSFORM      : TGUID = '{CF1DDA2D-9743-11D0-A3EE-00A0C9223196}';
  {$EXTERNALSYM KSCATEGORY_INTERFACETRANSFORM}
  KSCATEGORY_MEDIUMTRANSFORM         : TGUID = '{CF1DDA2E-9743-11D0-A3EE-00A0C9223196}';
  {$EXTERNALSYM KSCATEGORY_MEDIUMTRANSFORM}
  KSCATEGORY_FILESYSTEM              : TGUID = '{760FED5E-9357-11D0-A3CC-00A0C9223196}';
  {$EXTERNALSYM KSCATEGORY_FILESYSTEM}

// KSNAME_Clock
  KSCATEGORY_CLOCK   : TGUID = '{53172480-4791-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSCATEGORY_CLOCK}
  KSCATEGORY_PROXY   : TGUID = '{97EBAACA-95BD-11D0-A3EA-00A0C9223196}';
  {$EXTERNALSYM KSCATEGORY_PROXY}
  KSCATEGORY_QUALITY : TGUID = '{97EBAACB-95BD-11D0-A3EA-00A0C9223196}';
  {$EXTERNALSYM KSCATEGORY_QUALITY}

type
  PKSTopologyConnection = ^TKSTopologyConnection;
  KSTOPOLOGY_CONNECTION = record
    FromNode    : ULONG;
    FromNodePin : ULONG;
    ToNode      : ULONG;
    ToNodePin   : ULONG;
  end;
  {$EXTERNALSYM KSTOPOLOGY_CONNECTION}
  PKSTOPOLOGY_CONNECTION = ^KSTOPOLOGY_CONNECTION;
  {$EXTERNALSYM PKSTOPOLOGY_CONNECTION}
  TKSTopologyConnection = KSTOPOLOGY_CONNECTION;

  KSTOPOLOGY = record
    CategoriesCount          : ULONG;
    Categories               : PGUID;
    TopologyNodesCount       : ULONG;
    TopologyNodes            : PGUID;
    TopologyConnectionsCount : ULONG;
    TopologyConnections      : PKSTOPOLOGY_CONNECTION;
    TopologyNodesNames       : PGUID;
    Reserved                 : ULONG;
  end;
  {$EXTERNALSYM KSTOPOLOGY}
  PKSTOPOLOGY = ^KSTOPOLOGY;
  {$EXTERNALSYM PKSTOPOLOGY}
  TKSTopology = KSTOPOLOGY;

const
  KSFILTER_NODE = ULONG(-1);
  {$EXTERNALSYM KSFILTER_NODE}
  KSALL_NODES   = ULONG(-1);
  {$EXTERNALSYM KSALL_NODES}

type
  PKSNodeCreate = ^TKSNodeCreate;
  KSNODE_CREATE = record
    CreateFlags : ULONG;
    Node        : ULONG;
  end;
  {$EXTERNALSYM KSNODE_CREATE}
  PKSNODE_CREATE = ^KSNODE_CREATE;
  {$EXTERNALSYM PKSNODE_CREATE}
  TKSNodeCreate = KSNODE_CREATE;

//===========================================================================
const
// TIME_FORMAT_NONE
  KSTIME_FORMAT_NONE       : TGUID = '{00000000-0000-0000-0000-000000000000}';
  {$EXTERNALSYM KSTIME_FORMAT_NONE}

// TIME_FORMAT_FRAME
  KSTIME_FORMAT_FRAME      : TGUID = '{7b785570-8c82-11cf-bc0c-00aa00ac74f6}';
  {$EXTERNALSYM KSTIME_FORMAT_FRAME}

// TIME_FORMAT_BYTE
  KSTIME_FORMAT_BYTE       : TGUID = '{7b785571-8c82-11cf-bc0c-00aa00ac74f6}';
  {$EXTERNALSYM KSTIME_FORMAT_BYTE}

// TIME_FORMAT_SAMPLE
  KSTIME_FORMAT_SAMPLE     : TGUID = '{7b785572-8c82-11cf-bc0c-00aa00ac74f6}';
  {$EXTERNALSYM KSTIME_FORMAT_SAMPLE}

// TIME_FORMAT_FIELD
  KSTIME_FORMAT_FIELD      : TGUID = '{7b785573-8c82-11cf-bc0c-00aa00ac74f6}';
  {$EXTERNALSYM KSTIME_FORMAT_FIELD}

// TIME_FORMAT_MEDIA_TIME
  KSTIME_FORMAT_MEDIA_TIME : TGUID = '{7b785574-8c82-11cf-bc0c-00aa00ac74f6}';
  {$EXTERNALSYM KSTIME_FORMAT_MEDIA_TIME}

//===========================================================================

type
  PKSPIN_INTERFACE = ^KSPIN_INTERFACE;
  {$EXTERNALSYM PKSPIN_INTERFACE}
  KSPIN_INTERFACE = KSIDENTIFIER;
  {$EXTERNALSYM KSPIN_INTERFACE}

  PKSPinInterface = PKSPIN_INTERFACE;
  TKSPinInterface = KSPIN_INTERFACE;

const
  KSINTERFACESETID_Standard : TGUID = '{1A8766A0-62CE-11CF-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSINTERFACESETID_Standard}

type
  KSINTERFACE_STANDARD = (
    KSINTERFACE_STANDARD_STREAMING,
    KSINTERFACE_STANDARD_LOOPED_STREAMING,
    KSINTERFACE_STANDARD_CONTROL
  );
  {$EXTERNALSYM KSINTERFACE_STANDARD}
  TKSInterfaceStandard = KSINTERFACE_STANDARD;

const
  KSINTERFACESETID_FileIo : TGUID = '{8C6F932C-E771-11D0-B8FF-00A0C9223196}';
  {$EXTERNALSYM KSINTERFACESETID_FileIo}

type
  KSINTERFACE_FILEIO = (
    KSINTERFACE_FILEIO_STREAMING
  );
  {$EXTERNALSYM KSINTERFACE_FILEIO}
  TKSInterfaceFileIO = KSINTERFACE_FILEIO;

//===========================================================================
const
  KSMEDIUM_TYPE_ANYINSTANCE = 0;
  {$EXTERNALSYM KSMEDIUM_TYPE_ANYINSTANCE}

  KSMEDIUMSETID_Standard : TGUID = '{4747B320-62CE-11CF-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSMEDIUMSETID_Standard}

//For compatibility only
  KSMEDIUM_STANDARD_DEVIO = KSMEDIUM_TYPE_ANYINSTANCE;
  {$EXTERNALSYM KSMEDIUM_STANDARD_DEVIO}

//===========================================================================

  KSPROPSETID_Pin : TGUID = '{8C134960-51AD-11CF-878A-94F801C10000}';
  {$EXTERNALSYM KSPROPSETID_Pin}

type
  KSPROPERTY_PIN = (
    KSPROPERTY_PIN_CINSTANCES,
    KSPROPERTY_PIN_CTYPES,
    KSPROPERTY_PIN_DATAFLOW,
    KSPROPERTY_PIN_DATARANGES,
    KSPROPERTY_PIN_DATAINTERSECTION,
    KSPROPERTY_PIN_INTERFACES,
    KSPROPERTY_PIN_MEDIUMS,
    KSPROPERTY_PIN_COMMUNICATION,
    KSPROPERTY_PIN_GLOBALCINSTANCES,
    KSPROPERTY_PIN_NECESSARYINSTANCES,
    KSPROPERTY_PIN_PHYSICALCONNECTION,
    KSPROPERTY_PIN_CATEGORY,
    KSPROPERTY_PIN_NAME,
    KSPROPERTY_PIN_CONSTRAINEDDATARANGES,
    KSPROPERTY_PIN_PROPOSEDATAFORMAT
  );
  {$EXTERNALSYM KSPROPERTY_PIN}
  TKSPropertyPin = KSPROPERTY_PIN;

  PKSPPin = ^TKSPPin;
  KSP_PIN = record
    Property_  : KSPROPERTY;
    PinId      : ULONG;
    Reserved   : ULONG;
  end;
  {$EXTERNALSYM KSP_PIN}
  PKSP_PIN = ^KSP_PIN;
  {$EXTERNALSYM PKSP_PIN}
  TKSPPin = KSP_PIN;

const
  KSINSTANCE_INDETERMINATE = ULONG(-1);
  {$EXTERNALSYM KSINSTANCE_INDETERMINATE}

type
  PKSPinCInstance = ^TKSPinCInstance;
  KSPIN_CINSTANCES = record
    PossibleCount : ULONG;
    CurrentCount  : ULONG;
  end;
  {$EXTERNALSYM KSPIN_CINSTANCES}
  PKSPIN_CINSTANCES = ^KSPIN_CINSTANCES;
  {$EXTERNALSYM PKSPIN_CINSTANCES}
  TKSPinCInstance = KSPIN_CINSTANCES;


  PKSPinDataFlow = ^TKSPinDataFlow;
  KSPIN_DATAFLOW = (
    KSPIN_DATAFLOW_Invalid,
    KSPIN_DATAFLOW_IN,
    KSPIN_DATAFLOW_OUT
  );
  {$EXTERNALSYM KSPIN_DATAFLOW}
  PKSPIN_DATAFLOW = ^KSPIN_DATAFLOW;
  {$EXTERNALSYM PKSPIN_DATAFLOW}
  TKSPinDataFlow = KSPIN_DATAFLOW;

const
  KSDATAFORMAT_BIT_TEMPORAL_COMPRESSION =  0;
  {$EXTERNALSYM KSDATAFORMAT_BIT_TEMPORAL_COMPRESSION}
  KSDATAFORMAT_TEMPORAL_COMPRESSION     =  (1 shl KSDATAFORMAT_BIT_TEMPORAL_COMPRESSION);
  {$EXTERNALSYM KSDATAFORMAT_TEMPORAL_COMPRESSION}
  KSDATAFORMAT_BIT_ATTRIBUTES           =  1;
  {$EXTERNALSYM KSDATAFORMAT_BIT_ATTRIBUTES}
  KSDATAFORMAT_ATTRIBUTES               =  (1 shl KSDATAFORMAT_BIT_ATTRIBUTES);
  {$EXTERNALSYM KSDATAFORMAT_ATTRIBUTES}

  KSDATARANGE_BIT_ATTRIBUTES          = 1;
  {$EXTERNALSYM KSDATARANGE_BIT_ATTRIBUTES}
  KSDATARANGE_ATTRIBUTES              = (1 shl KSDATARANGE_BIT_ATTRIBUTES);
  {$EXTERNALSYM KSDATARANGE_ATTRIBUTES}
  KSDATARANGE_BIT_REQUIRED_ATTRIBUTES = 2;
  {$EXTERNALSYM KSDATARANGE_BIT_REQUIRED_ATTRIBUTES}
  KSDATARANGE_REQUIRED_ATTRIBUTES     = (1 shl KSDATARANGE_BIT_REQUIRED_ATTRIBUTES);
  {$EXTERNALSYM KSDATARANGE_REQUIRED_ATTRIBUTES}

type
  KSDATAFORMAT = record
    case integer of
    0: (
      FormatSize  : ULONG;
      Flags       : ULONG;
      SampleSize  : ULONG;
      Reserved    : ULONG;
      MajorFormat : TGUID;
      SubFormat   : TGUID;
      Specifier   : TGUID);
    1: (
      Alignment   : int64);
  end;
  {$EXTERNALSYM KSDATAFORMAT}
  PKSDATAFORMAT = ^KSDATAFORMAT;
  {$EXTERNALSYM PKSDATAFORMAT}
  TKSDataFormat = KSDATAFORMAT;

  PKSDATARANGE = ^KSDATARANGE;
  {$EXTERNALSYM PKSDATARANGE}
  KSDATARANGE = KSDATAFORMAT;
  {$EXTERNALSYM KSDATARANGE}

  TKSDataRange = KSDATARANGE;

const
  KSATTRIBUTE_REQUIRED = $00000001;
  {$EXTERNALSYM KSATTRIBUTE_REQUIRED}

type
  KSATTRIBUTE = record
    Size      : ULONG;
    Flags     : ULONG;
    Attribute : TGUID;
  end;
  {$EXTERNALSYM KSATTRIBUTE}
  PKSATTRIBUTE = ^KSATTRIBUTE;
  {$EXTERNALSYM PKSATTRIBUTE}
  TKSAttribute = KSATTRIBUTE;

  PKSPinCommunication = ^TKSPinCommunication;
  KSPIN_COMMUNICATION = (
    KSPIN_COMMUNICATION_NONE,
    KSPIN_COMMUNICATION_SINK,
    KSPIN_COMMUNICATION_SOURCE,
    KSPIN_COMMUNICATION_BOTH,
    KSPIN_COMMUNICATION_BRIDGE
  );
  {$EXTERNALSYM KSPIN_COMMUNICATION}
  PKSPIN_COMMUNICATION = ^KSPIN_COMMUNICATION;
  {$EXTERNALSYM PKSPIN_COMMUNICATION}
  TKSPinCommunication = KSPIN_COMMUNICATION;

  PKSPIN_MEDIUM = ^KSPIN_MEDIUM;
  {$EXTERNALSYM PKSPIN_MEDIUM}
  KSPIN_MEDIUM = KSIDENTIFIER;
  {$EXTERNALSYM KSPIN_MEDIUM}

  PKSPinMedium = PKSPIN_MEDIUM;
  TKSPinMedium = KSPIN_MEDIUM;

  PKSPinConnect = ^TKSPinConnect;
  KSPIN_CONNECT = record
    Interface_  : TKSPinInterface;
    Medium      : TKSPinMedium;
    PinId       : ULONG;
    PinToHandle : THandle;
    Priority    : TKSPriority;
  end;
  {$EXTERNALSYM KSPIN_CONNECT}
  PKSPIN_CONNECT = KSPIN_CONNECT;
  {$EXTERNALSYM PKSPIN_CONNECT}
  TKSPinConnect = KSPIN_CONNECT;

  PKSPinPhysicalConnection = ^TKSPinPhysicalConnection;
  KSPIN_PHYSICALCONNECTION = record
    Size             : ULONG;
    Pin              : ULONG;
    SymbolicLinkName : array[0..0] of WCHAR;
  end;
  {$EXTERNALSYM KSPIN_PHYSICALCONNECTION}
  PKSPIN_PHYSICALCONNECTION = KSPIN_PHYSICALCONNECTION;
  {$EXTERNALSYM PKSPIN_PHYSICALCONNECTION}
  TKSPinPhysicalConnection = KSPIN_PHYSICALCONNECTION;

const
  KSNAME_Filter       : TGUID = '{9b365890-165f-11d0-a195-0020afd156e4}';
  {$EXTERNALSYM KSNAME_Filter}
  KSSTRING_Filter             = '{9B365890-165F-11D0-A195-0020AFD156E4}';
  {$EXTERNALSYM KSSTRING_Filter}

  KSNAME_Pin          : TGUID = '{146F1A80-4791-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSNAME_Pin}
  KSSTRING_Pin                = '{146F1A80-4791-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSSTRING_Pin}

  KSNAME_Clock        : TGUID = '{53172480-4791-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSNAME_Clock}
  KSSTRING_Clock              = '{53172480-4791-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSSTRING_Clock}

  KSNAME_Allocator    : TGUID = '{642F5D00-4791-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSNAME_Allocator}
  KSSTRING_Allocator          = '{642F5D00-4791-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSSTRING_Allocator}

  KSSTRING_AllocatorEx        = '{091BB63B-603F-11D1-B067-00A0C9062802}';
  {$EXTERNALSYM KSSTRING_AllocatorEx}

  KSNAME_TopologyNode : TGUID = '{0621061A-EE75-11D0-B915-00A0C9223196}';
  {$EXTERNALSYM KSNAME_TopologyNode}
  KSSTRING_TopologyNode       = '{0621061A-EE75-11D0-B915-00A0C9223196}';
  {$EXTERNALSYM KSSTRING_TopologyNode}

//===========================================================================

// MEDIATYPE_NULL
const
  KSDATAFORMAT_TYPE_WILDCARD       : TGUID = '{00000000-0000-0000-0000-000000000000}';
  {$EXTERNALSYM KSDATAFORMAT_TYPE_WILDCARD}

// MEDIASUBTYPE_NULL
  KSDATAFORMAT_SUBTYPE_WILDCARD    : TGUID = '{00000000-0000-0000-0000-000000000000}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_WILDCARD}

// MEDIATYPE_Stream
  KSDATAFORMAT_TYPE_STREAM         : TGUID = '{E436EB83-524F-11CE-9F53-0020AF0BA770}';
  {$EXTERNALSYM KSDATAFORMAT_TYPE_STREAM}

// MEDIASUBTYPE_None
  KSDATAFORMAT_SUBTYPE_NONE        : TGUID = '{E436EB8E-524F-11CE-9F53-0020AF0BA770}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_NONE}

  KSDATAFORMAT_SPECIFIER_WILDCARD  : TGUID = '{00000000-0000-0000-0000-000000000000}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_WILDCARD}

  KSDATAFORMAT_SPECIFIER_FILENAME  : TGUID = '{AA797B40-E974-11CF-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_FILENAME}
  KSDATAFORMAT_SPECIFIER_FILEHANDLE: TGUID = '{65E8773C-8F56-11D0-A3B9-00A0C9223196}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_FILEHANDLE}

// FORMAT_None
  KSDATAFORMAT_SPECIFIER_NONE      : TGUID = '{0F6417D6-C318-11D0-A43F-00A0C9223196}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_NONE}

//===========================================================================

  KSPROPSETID_Quality : TGUID = '{D16AD380-AC1A-11CF-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSPROPSETID_Quality}

type
  KSPROPERTY_QUALITY = (
    KSPROPERTY_QUALITY_REPORT,
    KSPROPERTY_QUALITY_ERROR
  );
  {$EXTERNALSYM KSPROPERTY_QUALITY}
  TKSPropertyQuality = KSPROPERTY_QUALITY;

//===========================================================================
const
  KSPROPSETID_Connection : TGUID = '{1D58C920-AC9B-11CF-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSPROPSETID_Connection}
type
  KSPROPERTY_CONNECTION = (
    KSPROPERTY_CONNECTION_STATE,
    KSPROPERTY_CONNECTION_PRIORITY,
    KSPROPERTY_CONNECTION_DATAFORMAT,
    KSPROPERTY_CONNECTION_ALLOCATORFRAMING,
    KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT,
    KSPROPERTY_CONNECTION_ACQUIREORDERING,
    KSPROPERTY_CONNECTION_ALLOCATORFRAMING_EX,
    KSPROPERTY_CONNECTION_STARTAT
  );
  {$EXTERNALSYM KSPROPERTY_CONNECTION}
  TKSPropertyConnection = KSPROPERTY_CONNECTION;

//===========================================================================
//
// pins flags
//
const
  KSALLOCATOR_REQUIREMENTF_INPLACE_MODIFIER  = $00000001;
  {$EXTERNALSYM KSALLOCATOR_REQUIREMENTF_INPLACE_MODIFIER}
  KSALLOCATOR_REQUIREMENTF_SYSTEM_MEMORY     = $00000002;
  {$EXTERNALSYM KSALLOCATOR_REQUIREMENTF_SYSTEM_MEMORY}
  KSALLOCATOR_REQUIREMENTF_FRAME_INTEGRITY   = $00000004;
  {$EXTERNALSYM KSALLOCATOR_REQUIREMENTF_FRAME_INTEGRITY}
  KSALLOCATOR_REQUIREMENTF_MUST_ALLOCATE     = $00000008;
  {$EXTERNALSYM KSALLOCATOR_REQUIREMENTF_MUST_ALLOCATE}
  KSALLOCATOR_REQUIREMENTF_PREFERENCES_ONLY  = $80000000;
  {$EXTERNALSYM KSALLOCATOR_REQUIREMENTF_PREFERENCES_ONLY}

  KSALLOCATOR_OPTIONF_COMPATIBLE             = $00000001;
  {$EXTERNALSYM KSALLOCATOR_OPTIONF_COMPATIBLE}
  KSALLOCATOR_OPTIONF_SYSTEM_MEMORY          = $00000002;
  {$EXTERNALSYM KSALLOCATOR_OPTIONF_SYSTEM_MEMORY}
  KSALLOCATOR_OPTIONF_VALID                  = $00000003;
  {$EXTERNALSYM KSALLOCATOR_OPTIONF_VALID}
//
// pins extended framing flags
//
  KSALLOCATOR_FLAG_PARTIAL_READ_SUPPORT      = $00000010;
  {$EXTERNALSYM KSALLOCATOR_FLAG_PARTIAL_READ_SUPPORT}
  KSALLOCATOR_FLAG_DEVICE_SPECIFIC           = $00000020;
  {$EXTERNALSYM KSALLOCATOR_FLAG_DEVICE_SPECIFIC}
  KSALLOCATOR_FLAG_CAN_ALLOCATE              = $00000040;
  {$EXTERNALSYM KSALLOCATOR_FLAG_CAN_ALLOCATE}
  KSALLOCATOR_FLAG_INSIST_ON_FRAMESIZE_RATIO = $00000080;
  {$EXTERNALSYM KSALLOCATOR_FLAG_INSIST_ON_FRAMESIZE_RATIO}
//
// allocator pipes flags
//
// there is at least one data modification in a pipe
  KSALLOCATOR_FLAG_NO_FRAME_INTEGRITY        = $00000100;
  {$EXTERNALSYM KSALLOCATOR_FLAG_NO_FRAME_INTEGRITY}
  KSALLOCATOR_FLAG_MULTIPLE_OUTPUT           = $00000200;
  {$EXTERNALSYM KSALLOCATOR_FLAG_MULTIPLE_OUTPUT}
  KSALLOCATOR_FLAG_CYCLE                     = $00000400;
  {$EXTERNALSYM KSALLOCATOR_FLAG_CYCLE}
  KSALLOCATOR_FLAG_ALLOCATOR_EXISTS          = $00000800;
  {$EXTERNALSYM KSALLOCATOR_FLAG_ALLOCATOR_EXISTS}
// there is no framing dependency between neighbouring pipes.
  KSALLOCATOR_FLAG_INDEPENDENT_RANGES        = $00001000;
  {$EXTERNALSYM KSALLOCATOR_FLAG_INDEPENDENT_RANGES}
  KSALLOCATOR_FLAG_ATTENTION_STEPPING        = $00002000;
  {$EXTERNALSYM KSALLOCATOR_FLAG_ATTENTION_STEPPING}


//
// old Framing structure
//
type
  PKSAllocatorFraming = ^TKSAllocatorFraming;
  KSALLOCATOR_FRAMING = record
  case integer of
  0: (
    OptionsFlags : ULONG);       // allocator options (create)
  1: (
    RequirementsFlags : ULONG;   // allocation requirements (query)
    PoolType      : ULONG;
    Frames        : ULONG; // total number of allowable outstanding frames
    FrameSize     : ULONG; // total size of frame
    FileAlignment : ULONG;
    Reserved      : ULONG);
  end;
  {$EXTERNALSYM KSALLOCATOR_FRAMING}
  PKSALLOCATOR_FRAMING = ^KSALLOCATOR_FRAMING;
  {$EXTERNALSYM PKSALLOCATOR_FRAMING}
  TKSAllocatorFraming = KSALLOCATOR_FRAMING;

//
// new Framing structure, eventually will replace KSALLOCATOR_FRAMING.
//
  PKSFramingRange = ^TKSFramingRange;
  KS_FRAMING_RANGE = record
    MinFrameSize : ULONG;
    MaxFrameSize : ULONG;
    Stepping     : ULONG;
  end;
  {$EXTERNALSYM KS_FRAMING_RANGE}
  PKS_FRAMING_RANGE = ^KS_FRAMING_RANGE;
  {$EXTERNALSYM PKS_FRAMING_RANGE}
  TKSFramingRange = KS_FRAMING_RANGE;

  PKSFramingRangeWeighted = ^TKSFramingRangeWeighted;
  KS_FRAMING_RANGE_WEIGHTED = record
    Range            : TKSFramingRange;
    InPlaceWeight    : ULONG;
    NotInPlaceWeight : ULONG;
  end;
  {$EXTERNALSYM KS_FRAMING_RANGE_WEIGHTED}
  PKS_FRAMING_RANGE_WEIGHTED = ^KS_FRAMING_RANGE_WEIGHTED;
  {$EXTERNALSYM PKS_FRAMING_RANGE_WEIGHTED}
  TKSFramingRangeWeighted = KS_FRAMING_RANGE_WEIGHTED;

  PKSCompression = ^TKSCompression;
  KS_COMPRESSION = record
    RatioNumerator      : ULONG;      // compression/expansion ratio
    RatioDenominator    : ULONG;
    RatioConstantMargin : ULONG;
  end;
  {$EXTERNALSYM KS_COMPRESSION}
  PKS_COMPRESSION = ^KS_COMPRESSION;
  {$EXTERNALSYM PKS_COMPRESSION}
  TKSCompression = KS_COMPRESSION;

//
// Memory Types and Buses are repeated in each entry.
// Easiest to use but takes a little more memory than the varsize layout Pin\Memories\Buses\Ranges.
//
  PKSFramingItem = ^TKSFramingItem;
  KS_FRAMING_ITEM = record
    MemoryType       : TGUID;
    BusType          : TGUID;
    MemoryFlags      : ULONG;
    BusFlags         : ULONG;
    Flags            : ULONG;
    Frames           : ULONG; // total number of allowable outstanding frames
    FileAlignment    : ULONG;
    MemoryTypeWeight : ULONG; // this memory type Weight pin-wide
    PhysicalRange    : TKSFramingRange;
    FramingRange     : TKSFramingRangeWeighted;
  end;
  {$EXTERNALSYM KS_FRAMING_ITEM}
  PKS_FRAMING_ITEM = ^KS_FRAMING_ITEM;
  {$EXTERNALSYM PKS_FRAMING_ITEM}
  TKSFramingItem = KS_FRAMING_ITEM;

  PKSAllocatorFramingEx = ^TKSAllocatorFramingEx;
  KSALLOCATOR_FRAMING_EX = record
    CountItems        : ULONG;         // count of FramingItem-s below.
    PinFlags          : ULONG;
    OutputCompression : TKSCompression;
    PinWeight         : ULONG;          // this pin framing's Weight graph-wide
    FramingItem       : array[0..0] of TKSFramingItem;
  end;
  {$EXTERNALSYM KSALLOCATOR_FRAMING_EX}
  PKSALLOCATOR_FRAMING_EX = ^KSALLOCATOR_FRAMING_EX;
  {$EXTERNALSYM PKSALLOCATOR_FRAMING_EX}
  TKSAllocatorFramingEx = KSALLOCATOR_FRAMING_EX;

//
// define memory type GUIDs
//
const
  KSMEMORY_TYPE_WILDCARD        : TGUID = '{00000000-0000-0000-0000-000000000000}';
  {$EXTERNALSYM KSMEMORY_TYPE_WILDCARD}
  KSMEMORY_TYPE_DONT_CARE       : TGUID = '{00000000-0000-0000-0000-000000000000}';
  {$EXTERNALSYM KSMEMORY_TYPE_DONT_CARE}
  KS_TYPE_DONT_CARE             : TGUID = '{00000000-0000-0000-0000-000000000000}';
  {$EXTERNALSYM KS_TYPE_DONT_CARE}

  KSMEMORY_TYPE_SYSTEM          : TGUID = '{091bb638-603f-11d1-b067-00a0c9062802}';
  {$EXTERNALSYM KSMEMORY_TYPE_SYSTEM}
  KSMEMORY_TYPE_USER            : TGUID = '{8cb0fc28-7893-11d1-b069-00a0c9062802}';
  {$EXTERNALSYM KSMEMORY_TYPE_USER}
  KSMEMORY_TYPE_KERNEL_PAGED    : TGUID = '{d833f8f8-7894-11d1-b069-00a0c9062802}';
  {$EXTERNALSYM KSMEMORY_TYPE_KERNEL_PAGED}
  KSMEMORY_TYPE_KERNEL_NONPAGED : TGUID = '{4a6d5fc4-7895-11d1-b069-00a0c9062802}';
  {$EXTERNALSYM KSMEMORY_TYPE_KERNEL_NONPAGED}

// old KS clients did not specify the device memory type
  KSMEMORY_TYPE_DEVICE_UNKNOWN  : TGUID = '{091bb639-603f-11d1-b067-00a0c9062802}';
  {$EXTERNALSYM KSMEMORY_TYPE_DEVICE_UNKNOWN}

//
// Helper framing macros.
//
{#define DECLARE_SIMPLE_FRAMING_EX(FramingExName, MemoryType, Flags, Frames, Alignment, MinFrameSize, MaxFrameSize) \
    const KSALLOCATOR_FRAMING_EX FramingExName = \
    {\
        1, \
        0, \
        {\
            1, \
            1, \
            0 \
        }//, \
//        0, \
        {\
            {\
                MemoryType, \
                STATIC_KS_TYPE_DONT_CARE, \
                0, \
                0, \
                Flags, \
                Frames, \
                Alignment, \
                0, \
                {\
                    0, \
                    (ULONG)-1, \
                    1 \
                }//, \
                {\
                    {\
                        MinFrameSize, \
                        MaxFrameSize, \
                        1 \
                    }//, \
 //                   0, \
 //                   0  \
 //               }\
 //           }\
 //       }\
 //   }

{#define SetDefaultKsCompression(KsCompressionPointer) \
{\
    KsCompressionPointer->RatioNumerator = 1;\
    KsCompressionPointer->RatioDenominator = 1;\
    KsCompressionPointer->RatioConstantMargin = 0;\
}

{#define SetDontCareKsFramingRange(KsFramingRangePointer) \
{\
    KsFramingRangePointer->MinFrameSize = 0;\
    KsFramingRangePointer->MaxFrameSize = (ULONG) -1;\
    KsFramingRangePointer->Stepping = 1;\
}

{#define SetKsFramingRange(KsFramingRangePointer, P_MinFrameSize, P_MaxFrameSize) \
{\
    KsFramingRangePointer->MinFrameSize = P_MinFrameSize;\
    KsFramingRangePointer->MaxFrameSize = P_MaxFrameSize;\
    KsFramingRangePointer->Stepping = 1;\
}

{#define SetKsFramingRangeWeighted(KsFramingRangeWeightedPointer, P_MinFrameSize, P_MaxFrameSize) \
{\
    KS_FRAMING_RANGE *KsFramingRange = &KsFramingRangeWeightedPointer->Range;\
    SetKsFramingRange(KsFramingRange, P_MinFrameSize, P_MaxFrameSize);\
    KsFramingRangeWeightedPointer->InPlaceWeight = 0;\
    KsFramingRangeWeightedPointer->NotInPlaceWeight = 0;\
}

{#define INITIALIZE_SIMPLE_FRAMING_EX(FramingExPointer, P_MemoryType, P_Flags, P_Frames, P_Alignment, P_MinFrameSize, P_MaxFrameSize) \
{\
    KS_COMPRESSION *KsCompression = &FramingExPointer->OutputCompression;\
    KS_FRAMING_RANGE *KsFramingRange = &FramingExPointer->FramingItem[0].PhysicalRange;\
    KS_FRAMING_RANGE_WEIGHTED *KsFramingRangeWeighted = &FramingExPointer->FramingItem[0].FramingRange;\
    FramingExPointer->CountItems = 1;\
    FramingExPointer->PinFlags = 0;\
    SetDefaultKsCompression(KsCompression);\
    FramingExPointer->PinWeight = 0;\
    FramingExPointer->FramingItem[0].MemoryType = P_MemoryType;\
    FramingExPointer->FramingItem[0].BusType = KS_TYPE_DONT_CARE;\
    FramingExPointer->FramingItem[0].MemoryFlags = 0;\
    FramingExPointer->FramingItem[0].BusFlags = 0;\
    FramingExPointer->FramingItem[0].Flags = P_Flags;\
    FramingExPointer->FramingItem[0].Frames = P_Frames;\
    FramingExPointer->FramingItem[0].FileAlignment = P_Alignment;\
    FramingExPointer->FramingItem[0].MemoryTypeWeight = 0;\
    SetDontCareKsFramingRange(KsFramingRange);\
    SetKsFramingRangeWeighted(KsFramingRangeWeighted, P_MinFrameSize, P_MaxFrameSize);\
}

  KSEVENTSETID_StreamAllocator : TGUID = '{75d95571-073c-11d0-a161-0020afd156e4}';
  {$EXTERNALSYM KSEVENTSETID_StreamAllocator}

type
  KSEVENT_STREAMALLOCATOR = (
    KSEVENT_STREAMALLOCATOR_INTERNAL_FREEFRAME,
    KSEVENT_STREAMALLOCATOR_FREEFRAME
  );
  {$EXTERNALSYM KSEVENT_STREAMALLOCATOR}
  TKSEventStreamAllocator = KSEVENT_STREAMALLOCATOR;

const
  KSMETHODSETID_StreamAllocator : TGUID = '{cf6e4341-ec87-11cf-a130-0020afd156e4}';
  {$EXTERNALSYM KSMETHODSETID_StreamAllocator}

type
  KSMETHOD_STREAMALLOCATOR = (
    KSMETHOD_STREAMALLOCATOR_ALLOC,
    KSMETHOD_STREAMALLOCATOR_FREE
  );
  {$EXTERNALSYM KSMETHOD_STREAMALLOCATOR}
  TKSMethodStreamAllocation = KSMETHOD_STREAMALLOCATOR;

{#define DEFINE_KSMETHOD_ITEM_STREAMALLOCATOR_ALLOC(Handler)\
    DEFINE_KSMETHOD_ITEM(\
        KSMETHOD_STREAMALLOCATOR_ALLOC,\
        KSMETHOD_TYPE_WRITE,\
        (Handler),\
        sizeof(KSMETHOD),\
        sizeof(PVOID),\
        NULL)

#define DEFINE_KSMETHOD_ITEM_STREAMALLOCATOR_FREE(Handler)\
    DEFINE_KSMETHOD_ITEM(\
        KSMETHOD_STREAMALLOCATOR_FREE,\
        KSMETHOD_TYPE_READ,\
        (Handler),\
        sizeof(KSMETHOD),\
        sizeof(PVOID),\
        NULL)

#define DEFINE_KSMETHOD_ALLOCATORSET(AllocatorSet, MethodAlloc, MethodFree)\
DEFINE_KSMETHOD_TABLE(AllocatorSet) {\
    DEFINE_KSMETHOD_ITEM_STREAMALLOCATOR_ALLOC(MethodAlloc),\
    DEFINE_KSMETHOD_ITEM_STREAMALLOCATOR_FREE(MethodFree)\
}
const
  KSPROPSETID_StreamAllocator : TGUID = '{cf6e4342-ec87-11cf-a130-0020afd156e4}';
  {$EXTERNALSYM KSPROPSETID_StreamAllocator}

type
  PKSStreamAllocatorStatus = ^TKSStreamAllocatorStatus;
  KSSTREAMALLOCATOR_STATUS = record
    Framing         : TKSAllocatorFraming;
    AllocatedFrames : ULONG;
    Reserved        : ULONG;
  end;
  {$EXTERNALSYM KSSTREAMALLOCATOR_STATUS}
  PKSSTREAMALLOCATOR_STATUS = ^KSSTREAMALLOCATOR_STATUS;
  {$EXTERNALSYM PKSSTREAMALLOCATOR_STATUS}
  TKSStreamAllocatorStatus = KSSTREAMALLOCATOR_STATUS;

  PKSStreamAllocatorStatusEx = ^TKSStreamAllocatorStatusEx;
  KSSTREAMALLOCATOR_STATUS_EX = record
    Framing         : TKSAllocatorFramingEx;
    AllocatedFrames : ULONG;
    Reserved        : ULONG;
  end;
  {$EXTERNALSYM KSSTREAMALLOCATOR_STATUS_EX}
  PKSSTREAMALLOCATOR_STATUS_EX = ^KSSTREAMALLOCATOR_STATUS_EX;
  {$EXTERNALSYM PKSSTREAMALLOCATOR_STATUS_EX}
  TKSStreamAllocatorStatusEx = KSSTREAMALLOCATOR_STATUS_EX;

const
  KSSTREAM_HEADER_OPTIONSF_SPLICEPOINT       = $00000001;
  {$EXTERNALSYM KSSTREAM_HEADER_OPTIONSF_SPLICEPOINT}
  KSSTREAM_HEADER_OPTIONSF_PREROLL           = $00000002;
  {$EXTERNALSYM KSSTREAM_HEADER_OPTIONSF_PREROLL}
  KSSTREAM_HEADER_OPTIONSF_DATADISCONTINUITY = $00000004;
  {$EXTERNALSYM KSSTREAM_HEADER_OPTIONSF_DATADISCONTINUITY}
  KSSTREAM_HEADER_OPTIONSF_TYPECHANGED       = $00000008;
  {$EXTERNALSYM KSSTREAM_HEADER_OPTIONSF_TYPECHANGED}
  KSSTREAM_HEADER_OPTIONSF_TIMEVALID         = $00000010;
  {$EXTERNALSYM KSSTREAM_HEADER_OPTIONSF_TIMEVALID}
  KSSTREAM_HEADER_OPTIONSF_TIMEDISCONTINUITY = $00000040;
  {$EXTERNALSYM KSSTREAM_HEADER_OPTIONSF_TIMEDISCONTINUITY}
  KSSTREAM_HEADER_OPTIONSF_FLUSHONPAUSE      = $00000080;
  {$EXTERNALSYM KSSTREAM_HEADER_OPTIONSF_FLUSHONPAUSE}
  KSSTREAM_HEADER_OPTIONSF_DURATIONVALID     = $00000100;
  {$EXTERNALSYM KSSTREAM_HEADER_OPTIONSF_DURATIONVALID}
  KSSTREAM_HEADER_OPTIONSF_ENDOFSTREAM       = $00000200;
  {$EXTERNALSYM KSSTREAM_HEADER_OPTIONSF_ENDOFSTREAM}
  KSSTREAM_HEADER_OPTIONSF_LOOPEDDATA        = $80000000;
  {$EXTERNALSYM KSSTREAM_HEADER_OPTIONSF_LOOPEDDATA}

type
  KSTIME = record
    Time        : int64;
    Numerator   : ULONG;
    Denominator : ULONG;
  end;
  {$EXTERNALSYM KSTIME}
  PKSTIME = ^KSTIME;
  {$EXTERNALSYM PKSTIME}
  TKSTime = KSTIME;

  PKSStreamHeader = ^TKSStreamHeader;
  KSSTREAM_HEADER = record
    Size              : ULONG;
    TypeSpecificFlags : ULONG;
    PresentationTime  : TKSTIME;
    Duration          : int64;
    FrameExtent       : ULONG;
    DataUsed          : ULONG;
    Data              : Pointer;
    OptionsFlags      : ULONG;
//#if _WIN64
//  Reserved          : ULONG;
//#endif
  end;
  {$EXTERNALSYM KSSTREAM_HEADER}
  PKSSTREAM_HEADER = ^KSSTREAM_HEADER;
  {$EXTERNALSYM PKSSTREAM_HEADER}
  TKSStreamHeader = KSSTREAM_HEADER;

const
  KSPROPSETID_StreamInterface : TGUID = '{1fdd8ee1-9cd3-11d0-82aa-0000f822fe8a}';
  {$EXTERNALSYM KSPROPSETID_StreamInterface}
type
  KSPROPERTY_STREAMINTERFACE = (
    KSPROPERTY_STREAMINTERFACE_HEADERSIZE
  );
  {$EXTERNALSYM KSPROPERTY_STREAMINTERFACE}
  TKSPropertyStreamInterface = KSPROPERTY_STREAMINTERFACE;

{#define DEFINE_KSPROPERTY_ITEM_STREAMINTERFACE_HEADERSIZE( GetHandler )\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_STREAMINTERFACE_HEADERSIZE,\
        (GetHandler),\
        sizeof(KSPROPERTY),\
        sizeof(ULONG),\
        NULL, NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_STREAMINTERFACESET(StreamInterfaceSet,\
    HeaderSizeHandler)\
DEFINE_KSPROPERTY_TABLE(StreamInterfaceSet) {\
    DEFINE_KSPROPERTY_ITEM_STREAMINTERFACE_HEADERSIZE( HeaderSizeHandler )\
}
const
  KSPROPSETID_Stream : TGUId = '{65aaba60-98ae-11cf-a10d-0020afd156e4}';
  {$EXTERNALSYM KSPROPSETID_Stream}

type
  KSPROPERTY_STREAM = (
    KSPROPERTY_STREAM_ALLOCATOR,
    KSPROPERTY_STREAM_QUALITY,
    KSPROPERTY_STREAM_DEGRADATION,
    KSPROPERTY_STREAM_MASTERCLOCK,
    KSPROPERTY_STREAM_TIMEFORMAT,
    KSPROPERTY_STREAM_PRESENTATIONTIME,
    KSPROPERTY_STREAM_PRESENTATIONEXTENT,
    KSPROPERTY_STREAM_FRAMETIME,
    KSPROPERTY_STREAM_RATECAPABILITY,
    KSPROPERTY_STREAM_RATE,
    KSPROPERTY_STREAM_PIPE_ID
  );
  {$EXTERNALSYM KSPROPERTY_STREAM}
  TKSPropertyStream = KSPROPERTY_STREAM;

{#define DEFINE_KSPROPERTY_ITEM_STREAM_ALLOCATOR(GetHandler, SetHandler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_STREAM_ALLOCATOR,\
        (GetHandler),\
        sizeof(KSPROPERTY),\
        sizeof(HANDLE),\
        (SetHandler),\
        NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_STREAM_QUALITY(Handler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_STREAM_QUALITY,\
        (Handler),\
        sizeof(KSPROPERTY),\
        sizeof(KSQUALITY_MANAGER),\
        NULL, NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_STREAM_DEGRADATION(GetHandler, SetHandler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_STREAM_DEGRADATION,\
        (GetHandler),\
        sizeof(KSPROPERTY),\
        0,\
        (SetHandler),\
        NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_STREAM_MASTERCLOCK(GetHandler, SetHandler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_STREAM_MASTERCLOCK,\
        (GetHandler),\
        sizeof(KSPROPERTY),\
        sizeof(HANDLE),\
        (SetHandler),\
        NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_STREAM_TIMEFORMAT(Handler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_STREAM_TIMEFORMAT,\
        (Handler),\
        sizeof(KSPROPERTY),\
        sizeof(GUID),\
        NULL, NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_STREAM_PRESENTATIONTIME(GetHandler, SetHandler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_STREAM_PRESENTATIONTIME,\
        (GetHandler),\
        sizeof(KSPROPERTY),\
        sizeof(KSTIME),\
        (SetHandler),\
        NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_STREAM_PRESENTATIONEXTENT(Handler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_STREAM_PRESENTATIONEXTENT,\
        (Handler),\
        sizeof(KSPROPERTY),\
        sizeof(LONGLONG),\
        NULL, NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_STREAM_FRAMETIME(Handler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_STREAM_FRAMETIME,\
        (Handler),\
        sizeof(KSPROPERTY),\
        sizeof(KSFRAMETIME),\
        NULL, NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_STREAM_RATECAPABILITY(Handler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_STREAM_RATECAPABILITY,\
        (Handler),\
        sizeof(KSRATE_CAPABILITY),\
        sizeof(KSRATE),\
        NULL, NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_STREAM_RATE(GetHandler, SetHandler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_STREAM_RATE,\
        (GetHandler),\
        sizeof(KSPROPERTY),\
        sizeof(KSRATE),\
        (SetHandler),\
        NULL, 0, NULL, NULL, 0)

#define DEFINE_KSPROPERTY_ITEM_STREAM_PIPE_ID(GetHandler, SetHandler)\
    DEFINE_KSPROPERTY_ITEM(\
        KSPROPERTY_STREAM_PIPE_ID,\
        (GetHandler),\
        sizeof(KSPROPERTY),\
        sizeof(HANDLE),\
        (SetHandler),\
        NULL, 0, NULL, NULL, 0)  }

  PKSQualityManager = ^TKSQualityManager;
  KSQUALITY_MANAGER = record
    QualityManager : THandle;
    Context        : Pointer;
  end;
  {$EXTERNALSYM KSQUALITY_MANAGER}
  PKSQUALITY_MANAGER = ^KSQUALITY_MANAGER;
  {$EXTERNALSYM PKSQUALITY_MANAGER}
  TKSQualityManager = KSQUALITY_MANAGER;

  KSFRAMETIME = record
    Duration   : int64;
    FrameFlags : ULONG;
    Reserved   : ULONG;
  end;
  {$EXTERNALSYM KSFRAMETIME}
  PKSFRAMETIME = ^KSFRAMETIME;
  {$EXTERNALSYM PKSFRAMETIME}
  TKSFrameTime = KSFRAMETIME;
const
  KSFRAMETIME_VARIABLESIZE = $00000001;
  {$EXTERNALSYM KSFRAMETIME_VARIABLESIZE}

type
  KSRATE = record
  {$EXTERNALSYM KSRATE}
    PresentationStart : int64;
    Duration          : int64;
    Interface_        : TKSPinInterface;
    Rate              : Longint;
    Flags             : ULONG;
  end;
  PKSRATE = ^KSRATE;
  {$EXTERNALSYM PKSRATE}
  TKSRate = KSRATE;

const
  KSRATE_NOPRESENTATIONSTART    = $00000001;
  {$EXTERNALSYM KSRATE_NOPRESENTATIONSTART}
  KSRATE_NOPRESENTATIONDURATION = $00000002;
  {$EXTERNALSYM KSRATE_NOPRESENTATIONDURATION}

type
  PKSRateCapability = ^TKSRateCapability;
  KSRATE_CAPABILITY = record
    Property_ : KSPROPERTY;
    Rate      : TKSRATE;
  end;
  {$EXTERNALSYM KSRATE_CAPABILITY}
  PKSRATE_CAPABILITY = ^KSRATE_CAPABILITY;
  {$EXTERNALSYM PKSRATE_CAPABILITY}
  TKSRateCapability = KSRATE_CAPABILITY;

const
  KSPROPSETID_Clock : TGUID = '{DF12A4C0-AC17-11CF-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSPROPSETID_Clock}

//
// Performs a x*y/z operation on 64 bit quantities by splitting the operation. The equation
// is simplified with respect to adding in the remainder for the upper 32 bits.
//
// (xh * 10000000 / Frequency) * 2^32 + ((((xh * 10000000) % Frequency) * 2^32 + (xl * 10000000)) / Frequency)
//
  NANOSECONDS = 10000000;
  {$EXTERNALSYM NANOSECONDS}
{#define KSCONVERT_PERFORMANCE_TIME(Frequency, PerformanceTime) \
    ((((ULONGLONG)(ULONG)(PerformanceTime).HighPart * NANOSECONDS / (Frequency)) << 32) + \
    ((((((ULONGLONG)(ULONG)(PerformanceTime).HighPart * NANOSECONDS) % (Frequency)) << 32) + \
    ((ULONGLONG)(PerformanceTime).LowPart * NANOSECONDS)) / (Frequency)))}

type
  PKSClockCreate = ^TKSClockCreate;
  KSCLOCK_CREATE = record
    CreateFlags : ULONG;
  end;
  {$EXTERNALSYM KSCLOCK_CREATE}
  PKSCLOCK_CREATE = ^KSCLOCK_CREATE;
  {$EXTERNALSYM PKSCLOCK_CREATE}
  TKSClockCreate = KSCLOCK_CREATE;

  PKSCorrelatedTime = ^TKSCorrelatedTime;
  KSCORRELATED_TIME = record
    Time       : int64;
    SystemTime : int64;
  end;
  {$EXTERNALSYM KSCORRELATED_TIME}
  PKSCORRELATED_TIME = ^KSCORRELATED_TIME;
  {$EXTERNALSYM PKSCORRELATED_TIME}
  TKSCorrelatedTime = KSCORRELATED_TIME;

  KSRESOLUTION = record
    Granularity : int64;
    Error       : int64;
  end;
  {$EXTERNALSYM KSRESOLUTION}
  PKSRESOLUTION = ^KSRESOLUTION;
  {$EXTERNALSYM PKSRESOLUTION}
  TKSResolution = KSRESOLUTION;

  KSPROPERTY_CLOCK = (
    KSPROPERTY_CLOCK_TIME,
    KSPROPERTY_CLOCK_PHYSICALTIME,
    KSPROPERTY_CLOCK_CORRELATEDTIME,
    KSPROPERTY_CLOCK_CORRELATEDPHYSICALTIME,
    KSPROPERTY_CLOCK_RESOLUTION,
    KSPROPERTY_CLOCK_STATE
  );
  {$EXTERNALSYM KSPROPERTY_CLOCK}
  TKSPropertyClock = KSPROPERTY_CLOCK;

const
  KSEVENTSETID_Clock : TGUID = '{364D8E20-62C7-11CF-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSEVENTSETID_Clock}

type
  KSEVENT_CLOCK_POSITION = (
    KSEVENT_CLOCK_INTERVAL_MARK,
    KSEVENT_CLOCK_POSITION_MARK
  );
  {$EXTERNALSYM KSEVENT_CLOCK_POSITION}
  TKSEventClockPosition = KSEVENT_CLOCK_POSITION;

const
  KSEVENTSETID_Connection : TGUID = '{7f4bcbe0-9ea5-11cf-a5d6-28db04c10000}';
  {$EXTERNALSYM KSEVENTSETID_Connection}

type
  KSEVENT_CONNECTION = (
    KSEVENT_CONNECTION_POSITIONUPDATE,
    KSEVENT_CONNECTION_DATADISCONTINUITY,
    KSEVENT_CONNECTION_TIMEDISCONTINUITY,
    KSEVENT_CONNECTION_PRIORITY,
    KSEVENT_CONNECTION_ENDOFSTREAM
  );
  {$EXTERNALSYM KSEVENT_CONNECTION}
  TKSEventConnection = KSEVENT_CONNECTION;

  KSQUALITY = record
    Context    : Pointer;
    Proportion : ULONG;
    DeltaTime  : int64;
  end;
  {$EXTERNALSYM KSQUALITY}
  PKSQUALITY = ^KSQUALITY;
  {$EXTERNALSYM PKSQUALITY}
  TKSQuality = KSQUALITY;

  KSERROR = record
  {$EXTERNALSYM KSERROR}
    Context : Pointer;
    Status  : ULONG;
  end;
  PKSERROR = ^KSERROR;
  {$EXTERNALSYM PKSERROR}
  TKSError = KSERROR;

  PKSDEGRADE = ^KSDEGRADE;
  {$EXTERNALSYM PKSDEGRADE}
  KSDEGRADE = KSIDENTIFIER;
  {$EXTERNALSYM KSDEGRADE}

  TKSDegrade = KSDEGRADE;

const
  KSDEGRADESETID_Standard : TGUID = '{9F564180-704C-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSDEGRADESETID_Standard}

type
  KSDEGRADE_STANDARD = (
    KSDEGRADE_STANDARD_SAMPLE,
    KSDEGRADE_STANDARD_QUALITY,
    KSDEGRADE_STANDARD_COMPUTATION,
    KSDEGRADE_STANDARD_SKIP
  );
  {$EXTERNALSYM KSDEGRADE_STANDARD}
  TKSDegradeStandard = KSDEGRADE_STANDARD;

//#if !defined( PACK_PRAGMAS_NOT_SUPPORTED )
//#include <pshpack1.h>
//#endif

  KSPROPERTY_SERIALHDR = record
    PropertySet : TGUID;
    Count       : ULONG;
  end;
  {$EXTERNALSYM KSPROPERTY_SERIALHDR}
  PKSPROPERTY_SERIALHDR = ^KSPROPERTY_SERIALHDR;
  {$EXTERNALSYM PKSPROPERTY_SERIALHDR}
  TKSPropertySerialHDR = KSPROPERTY_SERIALHDR;

//#if !defined( PACK_PRAGMAS_NOT_SUPPORTED )
//#include <poppack.h>
//#endif

  PKSPropertySerial = ^TKSPropertySerial;
  KSPROPERTY_SERIAL = record
    PropTypeSet    : TKSIdentifier;
    Id             : ULONG;
    PropertyLength : ULONG;
  end;
  {$EXTERNALSYM KSPROPERTY_SERIAL}
  PKSPROPERTY_SERIAL = ^KSPROPERTY_SERIAL;
  {$EXTERNALSYM PKSPROPERTY_SERIAL}
  TKSPropertySerial = KSPROPERTY_SERIAL;

//===========================================================================
//
// exported prototypes


//  From WinNT.h (H.GOURVEST)
//  Define the access mask as a longword sized structure divided up as
//  follows:
//
//       3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//       1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//      +---------------+---------------+-------------------------------+
//      |G|G|G|G|Res'd|A| StandardRights|         SpecificRights        |
//      |R|W|E|A|     |S|               |                               |
//      +-+-------------+---------------+-------------------------------+
//
//      typedef struct _ACCESS_MASK {
//          WORD   SpecificRights;
//          BYTE  StandardRights;
//          BYTE  AccessSystemAcl : 1;
//          BYTE  Reserved : 3;
//          BYTE  GenericAll : 1;
//          BYTE  GenericExecute : 1;
//          BYTE  GenericWrite : 1;
//          BYTE  GenericRead : 1;
//      } ACCESS_MASK;
//      typedef ACCESS_MASK *PACCESS_MASK;
//
//  but to make life simple for programmer's we'll allow them to specify
//  a desired access mask by simply OR'ing together mulitple single rights
//  and treat an access mask as a DWORD.  For example
//
//      DesiredAccess = DELETE | READ_CONTROL
//
//  So we'll declare ACCESS_MASK as DWORD
//

  function KsCreateAllocator(ConnectionHandle: THandle;
             AllocatorFraming: PKSAllocatorFraming;
             out AllocatorHandle: PHandle): DWORD; stdcall;
  {$EXTERNALSYM KsCreateAllocator}

  function KsCreateClock(ConnectionHandle: THandle;
             ClockCreate: PKSClockCreate;
             out ClockHandle: PHandle): DWORD; stdcall;
  {$EXTERNALSYM KsCreateClock}

  function KsCreatePin(FilterHandle: THandle;
             Connect: PKSPinConnect;
             DesiredAccess: ACCESS_MASK ;
             out ConnectionHandle: PHandle): DWORD; stdcall;
  {$EXTERNALSYM KsCreatePin}

  function KsCreateTopologyNode(ParentHandle: THandle;
             NodeCreate: PKSNodeCreate;
             DesiredAccess: ACCESS_MASK;
             out NodeHandle: PHandle): DWORD; stdcall;
  {$EXTERNALSYM KsCreateTopologyNode}

{===============================================================================
*
* Copyright (C) Microsoft Corporation, 1996 - 1999
* Module Name:   ksproxy.h
* Abstract   :   Interface definitions for WDM-CSA proxy filters.
*
*==============================================================================}
const
  IID_IKsObject             : TGUID = (D1:$423c13a2;D2:$2070;D3:$11d0;D4:($9e,$f7,$00,$aa,$00,$a2,$16,$a1));
  {$EXTERNALSYM IID_IKsObject}
  STATIC_IID_IKsObject      : TGUID = (D1:$423c13a2;D2:$2070;D3:$11d0;D4:($9e,$f7,$00,$aa,$00,$a2,$16,$a1));
  {$EXTERNALSYM STATIC_IID_IKsObject}

  IID_IKsPinEx              : TGUID = (D1:$7bb38260;D2:$d19c;D3:$11d2;D4:($b3,$8a,$00,$a0,$c9,$5e,$c2,$2e));
  {$EXTERNALSYM IID_IKsPinEx}
  STATIC_IID_IKsPinEx       : TGUID = (D1:$7bb38260;D2:$d19c;D3:$11d2;D4:($b3,$8a,$00,$a0,$c9,$5e,$c2,$2e));
  {$EXTERNALSYM STATIC_IID_IKsPinEx}

  IID_IKsPinPipe            : TGUID = (D1:$e539cd90;D2:$a8b4;D3:$11d1;D4:($81,$89,$00,$a0,$c9,$06,$28,$02));
  {$EXTERNALSYM IID_IKsPinPipe}
  STATIC_IID_IKsPinPipe     : TGUID = (D1:$e539cd90;D2:$a8b4;D3:$11d1;D4:($81,$89,$00,$a0,$c9,$06,$28,$02));
  {$EXTERNALSYM STATIC_IID_IKsPinPipe}

  IID_IKsDataTypeCompletion : TGUID = (D1:$827D1A0E;D2:$0F73;D3:$11D2;D4:($B2,$7A,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM IID_IKsDataTypeCompletion}
  STATIC_IID_IKsDataTypeCompletion : TGUID = (D1:$827D1A0E;D2:$0F73;D3:$11D2;D4:($B2,$7A,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM STATIC_IID_IKsDataTypeCompletion}

  IID_IKsClockPropertySet   : TGUID = (D1:$5C5CBD84;D2:$E755;D3:$11D0;D4:($AC,$18,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM IID_IKsClockPropertySet}
  STATIC_IID_IKsClockPropertySet   : TGUID = (D1:$5C5CBD84;D2:$E755;D3:$11D0;D4:($AC,$18,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM STATIC_IID_IKsClockPropertySet}

  IID_IKsAllocator          : TGUID = (D1:$8da64899;D2:$c0d9;D3:$11d0;D4:($84,$13,$00,$00,$f8,$22,$fe,$8a));
  {$EXTERNALSYM IID_IKsAllocator}
  STATIC_IID_IKsAllocator          : TGUID = (D1:$8da64899;D2:$c0d9;D3:$11d0;D4:($84,$13,$00,$00,$f8,$22,$fe,$8a));
  {$EXTERNALSYM STATIC_IID_IKsAllocator}

  IID_IKsAllocatorEx        : TGUID = (D1:$091bb63a;D2:$603f;D3:$11d1;D4:($b0,$67,$00,$a0,$c9,$06,$28,$02));
  {$EXTERNALSYM IID_IKsAllocatorEx}
  STATIC_IID_IKsAllocatorEx        : TGUID = (D1:$091bb63a;D2:$603f;D3:$11d1;D4:($b0,$67,$00,$a0,$c9,$06,$28,$02));
  {$EXTERNALSYM STATIC_IID_IKsAllocatorEx}

  IID_IKsTopology           : TGUID = (D1:$28F54683;D2:$06FD;D3:$11D2;D4:($B2,$7A,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM IID_IKsTopology}
  STATIC_IID_IKsTopology    : TGUID = (D1:$28F54683;D2:$06FD;D3:$11D2;D4:($B2,$7A,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM STATIC_IID_IKsTopology}

  IID_IKsAggregateControl   : TGUID = (D1:$7F40EAC0;D2:$3947;D3:$11D2;D4:($87,$4E,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM IID_IKsAggregateControl}
  STATIC_IID_IKsAggregateControl   : TGUID = (D1:$7F40EAC0;D2:$3947;D3:$11D2;D4:($87,$4E,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM STATIC_IID_IKsAggregateControl}

  CLSID_Proxy               : TGUID = (D1:$17CCA71B;D2:$ECD7;D3:$11D0;D4:($B9,$08,$00,$A0,$C9,$22,$31,$96));
  {$EXTERNALSYM CLSID_Proxy}

  IID_IKsQualityForwarder   : TGUID = '{97EBAACB-95BD-11D0-A3EA-00A0C9223196}';
  {$EXTERNALSYM IID_IKsQualityForwarder}
  STATIC_IID_IKsQualityForwarder   : TGUID = '{97EBAACB-95BD-11D0-A3EA-00A0C9223196}';
  {$EXTERNALSYM STATIC_IID_IKsQualityForwarder}

  IID_IKsNotifyEvent : TGUID = '{412bd695-f84b-46c1-ac73-54196dbc8fa7}';
  {$EXTERNALSYM IID_IKsNotifyEvent}

type
  KSALLOCATORMODE = (
    KsAllocatorMode_User,
    KsAllocatorMode_Kernel
  );
  {$EXTERNALSYM KSALLOCATORMODE}
  TKSAllocatorMode = KSALLOCATORMODE;

  PFramingProp = ^TFramingProp;
  FRAMING_PROP = (
    FramingProp_Uninitialized,
    FramingProp_None,
    FramingProp_Old,
    FramingProp_Ex
  );
  {$EXTERNALSYM FRAMING_PROP}
  PFRAMING_PROP = ^FRAMING_PROP;
  {$EXTERNALSYM PFRAMING_PROP}
  TFramingProp = FRAMING_PROP;

  FRAMING_CACHE_OPS = (
    Framing_Cache_Update,     // request to bypass cache when read/write
    Framing_Cache_ReadLast,
    Framing_Cache_ReadOrig,
    Framing_Cache_Write
  );
  {$EXTERNALSYM FRAMING_CACHE_OPS}
  TFramingCacheOps = FRAMING_CACHE_OPS;

  OPTIMAL_WEIGHT_TOTALS = record
    MinTotalNominator : int64;
    MaxTotalNominator : int64;
    TotalDenominator  : int64;
  end;
  {$EXTERNALSYM OPTIMAL_WEIGHT_TOTALS}
  TOptimalWeightTotals = OPTIMAL_WEIGHT_TOTALS;

//
// allocators strategy is defined by graph manager
//
const
  AllocatorStrategy_DontCare = 0;
  {$EXTERNALSYM AllocatorStrategy_DontCare}

//
// what to optimize
//
  AllocatorStrategy_MinimizeNumberOfFrames     = $00000001;
  {$EXTERNALSYM AllocatorStrategy_MinimizeNumberOfFrames}
  AllocatorStrategy_MinimizeFrameSize          = $00000002;
  {$EXTERNALSYM AllocatorStrategy_MinimizeFrameSize}
  AllocatorStrategy_MinimizeNumberOfAllocators = $00000004;
  {$EXTERNALSYM AllocatorStrategy_MinimizeNumberOfAllocators}
  AllocatorStrategy_MaximizeSpeed              = $00000008;
  {$EXTERNALSYM AllocatorStrategy_MaximizeSpeed}

//
// factors (flags) defining the Pipes properties
//
  PipeFactor_None               = 0;
  {$EXTERNALSYM PipeFactor_None}
  PipeFactor_UserModeUpstream   = $00000001;
  {$EXTERNALSYM PipeFactor_UserModeUpstream}
  PipeFactor_UserModeDownstream = $00000002;
  {$EXTERNALSYM PipeFactor_UserModeDownstream}
  PipeFactor_MemoryTypes        = $00000004;
  {$EXTERNALSYM PipeFactor_MemoryTypes}
  PipeFactor_Flags              = $00000008;
  {$EXTERNALSYM PipeFactor_Flags}
  PipeFactor_PhysicalRanges     = $00000010;
  {$EXTERNALSYM PipeFactor_PhysicalRanges}
  PipeFactor_OptimalRanges      = $00000020;
  {$EXTERNALSYM PipeFactor_OptimalRanges}
  PipeFactor_FixedCompression   = $00000040;
  {$EXTERNALSYM PipeFactor_FixedCompression}
  PipeFactor_UnknownCompression = $00000080;
  {$EXTERNALSYM PipeFactor_UnknownCompression}
  PipeFactor_Buffers            = $00000100;
  {$EXTERNALSYM PipeFactor_Buffers}
  PipeFactor_Align              = $00000200;
  {$EXTERNALSYM PipeFactor_Align}

  PipeFactor_PhysicalEnd        = $00000400;
  {$EXTERNALSYM PipeFactor_PhysicalEnd}
  PipeFactor_LogicalEnd         = $00000800;
  {$EXTERNALSYM PipeFactor_LogicalEnd}

type
  PIPE_STATE = (
    PipeState_DontCare,
    PipeState_RangeNotFixed,
    PipeState_RangeFixed,
    PipeState_CompressionUnknown,
    PipeState_Finalized
  );
  {$EXTERNALSYM PIPE_STATE}
  TPipeState = PIPE_STATE;

//
// pipe dimensions relative to BeginPin.
//
  PPipeDimensions = ^TPipeDimensions;
  PIPE_DIMENSIONS = record
    AllocatorPin    : TKSCompression;
    MaxExpansionPin : TKSCompression;
    EndPin          : TKSCompression;
  end;
  {$EXTERNALSYM PIPE_DIMENSIONS}
  PPIPE_DIMENSIONS = ^PIPE_DIMENSIONS;
  {$EXTERNALSYM PPIPE_DIMENSIONS}
  TPipeDimensions = PIPE_DIMENSIONS;

  PPipeAllocatorPlace = ^TPipeAllocatorPlace;
  PIPE_ALLOCATOR_PLACE = (
    Pipe_Allocator_None,
    Pipe_Allocator_FirstPin,
    Pipe_Allocator_LastPin,
    Pipe_Allocator_MiddlePin
  );
  {$EXTERNALSYM PIPE_ALLOCATOR_PLACE}
  PPIPE_ALLOCATOR_PLACE = ^PIPE_ALLOCATOR_PLACE;
  {$EXTERNALSYM PPIPE_ALLOCATOR_PLACE}
  TPipeAllocatorPlace = PIPE_ALLOCATOR_PLACE;

  PKSLogicalMemoryType = ^TKSLogicalMemoryType;
  KS_LogicalMemoryType = (
    KS_MemoryTypeDontCare,
    KS_MemoryTypeKernelPaged,
    KS_MemoryTypeKernelNonPaged,
    KS_MemoryTypeDeviceHostMapped,
    KS_MemoryTypeDeviceSpecific,
    KS_MemoryTypeUser,
    KS_MemoryTypeAnyHost
  );
  {$EXTERNALSYM KS_LogicalMemoryType}
  PKS_LogicalMemoryType = ^KS_LogicalMemoryType;
  {$EXTERNALSYM PKS_LogicalMemoryType}
  TKSLogicalMemoryType = KS_LogicalMemoryType;

  PIPE_TERMINATION = record
    Flags          : ULONG;
    OutsideFactors : ULONG;
    Weigth         : ULONG;            // outside weight
    PhysicalRange  : TKSFramingRange;
    OptimalRange   : TKSFramingRangeWeighted;
    Compression    : TKSCompression;  // relative to the connected pin on a neighboring filter.
  end;
  {$EXTERNALSYM PIPE_TERMINATION}
  TPipeTermination = PIPE_TERMINATION;

  IKsAllocatorEx = interface;

//
// extended allocator properties
//
  PAllocatorPropertiesEx = ^TAllocatorPropertiesEx;
  ALLOCATOR_PROPERTIES_EX = record
    cBuffers          : longint;
    cbBuffer          : longint;
    cbAlign           : longint;
    cbPrefix          : longint;
// new part
    MemoryType        : TGUID;
    BusType           : TGUID;                 // one of the buses this pipe is using
    State             : TPipeState;
    Input             : TPipeTermination;
    Output            : TPipeTermination;
    Strategy          : ULONG;
    Flags             : ULONG;
    Weight            : ULONG;
    LogicalMemoryType : TKSLogicalMemoryType;
    AllocatorPlace    : TPipeAllocatorPlace;
    Dimensions        : TPipeDimensions;
    PhysicalRange     : TKSFramingRange;     // on allocator pin
    PrevSegment       : IKsAllocatorEx;        // doubly-linked list of KS allocators
    CountNextSegments : ULONG;                 // possible multiple dependent pipes
    NextSegments      : IKsAllocatorEx;
    InsideFactors     : ULONG;                 // existing factors (different from "don't care")
    NumberPins        : ULONG;
  end;
  {$EXTERNALSYM ALLOCATOR_PROPERTIES_EX}
  PALLOCATOR_PROPERTIES_EX =^ALLOCATOR_PROPERTIES_EX;
  {$EXTERNALSYM PALLOCATOR_PROPERTIES_EX}
  TAllocatorPropertiesEx = ALLOCATOR_PROPERTIES_EX;

  {$HPPEMIT 'typedef System::DelphiInterface<IKsClockPropertySet> _di_IKsClockPropertySet;'}
  {$EXTERNALSYM IKsClockPropertySet}
  IKsClockPropertySet = interface(IUnknown)
    ['{5C5CBD84-E755-11D0-AC18-00A0C9223196}']
    (*** IKsClockPropertySet methods ***)
    procedure KsGetTime(out Time: int64); stdcall;
    procedure KsSetTime(Time: int64); stdcall;
    procedure KsGetPhysicalTime(out Time: int64); stdcall;
    procedure KsSetPhysicalTime(Time: int64); stdcall;
    procedure KsGetCorrelatedTime(out CorrelatedTime: TKSCorrelatedTime); stdcall;
    procedure KsSetCorrelatedTime(CorrelatedTime: TKSCorrelatedTime); stdcall;
    procedure KsGetCorrelatedPhysicalTime(out CorrelatedTime: TKSCorrelatedTime); stdcall;
    procedure KsSetCorrelatedPhysicalTime(CorrelatedTime: TKSCorrelatedTime); stdcall;
    procedure KsGetResolution(out Resolution: TKSResolution); stdcall;
    procedure KsGetState(out State: TKSState); stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IKsAllocator> _di_IKsAllocator;'}
  {$EXTERNALSYM IKsAllocator}
  IKsAllocator = interface(IUnknown)
    ['{8da64899-c0d9-11d0-8413-0000f822fe8a}']
    (*** IKsAllocator methods ***)
    function  KsGetAllocatorHandle: THandle; stdcall;
    function  KsGetAllocatorMode: TKSALLOCATORMODE; stdcall;
    procedure KsGetAllocatorStatus(AllocatorStatus: PKSSTREAMALLOCATOR_STATUS); stdcall;
    procedure KsSetAllocatorMode(Mode: TKSALLOCATORMODE); stdcall;
  end;

  IKsPin = interface;

  {$HPPEMIT 'typedef System::DelphiInterface<IKsAllocatorEx> _di_IKsAllocatorEx;'}
  {$EXTERNALSYM IKsAllocatorEx}
  IKsAllocatorEx = interface(IKsAllocator)
    ['{091bb63a-603f-11d1-b067-00a0c9062802}']
    (*** IKsAllocatorEx methods ***)
    function  KsGetProperties: TAllocatorPropertiesEx; stdcall;
    procedure KsSetProperties(PROPERTIES: PALLOCATOR_PROPERTIES_EX); stdcall;
    procedure KsSetAllocatorHandle(AllocatorHandle: THandle); stdcall;
    function  KsCreateAllocatorAndGetHandle(KsPin: IKsPin): THandle; stdcall;
  end;

  KSPEEKOPERATION = (
    KsPeekOperation_PeekOnly,
    KsPeekOperation_AddRef
  );
  {$EXTERNALSYM KSPEEKOPERATION}
  TKSPeekOperation = KSPEEKOPERATION;

  IKsInterfaceHandler = interface;
  IKsDataTypeHandler = interface;

  KSIOOPERATION = (
    KsIoOperation_Write,
    KsIoOperation_Read
  );
  {$EXTERNALSYM KSIOOPERATION}
  TKSIOOperation = KSIOOPERATION;

  PKSStreamSegment = ^TKSStreamSegment;
  KSSTREAM_SEGMENT = record
    KsInterfaceHandler : IKsInterfaceHandler;
    KsDataTypeHandler  : IKsDataTypeHandler;
    IoOperation        : TKSIOOPERATION;
    CompletionEvent    : THandle;
  end;
  {$EXTERNALSYM KSSTREAM_SEGMENT}
  PKSSTREAM_SEGMENT = ^KSSTREAM_SEGMENT;
  {$EXTERNALSYM PKSSTREAM_SEGMENT}
  TKSStreamSegment = KSSTREAM_SEGMENT;

  {$HPPEMIT 'typedef System::DelphiInterface<IKsPin> _di_IKsPin;'}
  {$EXTERNALSYM IKsPin}
  IKsPin = interface(IUnknown)
    ['{b61178d1-a2d9-11cf-9e53-00aa00a216a1}']
    (*** IKsPin methods ***)
    // [pjh, 2003-07-14] fix wrong translation
    function KsQueryMediums(out MediumList: PKSMULTIPLE_ITEM): HResult; stdcall;
    function KsQueryInterfaces(InterfaceList: PKSMULTIPLE_ITEM): HResult; stdcall;
    function KsCreateSinkPinHandle(Interface_: TKSPinInterface; Medium: TKSPinMedium): HResult; stdcall;
    function KsGetCurrentCommunication(Communication: PKSPIN_COMMUNICATION;
      Interface_: PKSPIN_INTERFACE; Medium: PKSPIN_MEDIUM): HResult; stdcall;
    function KsPropagateAcquire: HResult; stdcall;
    function KsDeliver(Sample: IMediaSample; Flags: ULONG): HResult; stdcall;
    function KsMediaSamplesCompleted(StreamSegment: PKSSTREAM_SEGMENT): HResult; stdcall;
    function KsPeekAllocator(Operation: TKSPEEKOPERATION): IMemAllocator; stdcall;
    function KsReceiveAllocator(MemAllocator: IMemAllocator): HResult; stdcall;
    function KsRenegotiateAllocator: HResult; stdcall;
    function KsIncrementPendingIoCount: Longint; stdcall;
    function KsDecrementPendingIoCount: Longint; stdcall;
    function KsQualityNotify(Proportion: ULONG; TimeDelta: TReferenceTime): HResult; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IKsPinEx> _di_IKsPinEx;'}
  {$EXTERNALSYM IKsPinEx}
  IKsPinEx = interface(IKsPin)
    ['{7bb38260-d19c-11d2-b38a-00a0c95ec22e}']
    (*** IKsPinEx methods ***)
    procedure KsNotifyError(Sample: IMediaSample; hr: HResult);
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IKsPinPipe> _di_IKsPinPipe;'}
  {$EXTERNALSYM IKsPinPipe}
  IKsPinPipe = interface(IUnknown)
    ['{e539cd90-a8b4-11d1-8189-00a0c9062802}']
    (*** IKsPinPipe methods ***)
    procedure KsGetPinFramingCache(FramingEx: PKSALLOCATOR_FRAMING_EX;
                FramingProp: PFRAMING_PROP; Option: TFramingCacheOps); stdcall;
    procedure KsSetPinFramingCache(FramingEx: PKSALLOCATOR_FRAMING_EX;
                FramingProp: PFRAMING_PROP; Option: TFramingCacheOps); stdcall;
    function KsGetConnectedPin: IPin; stdcall;
    function KsGetPipe(Operation: TKSPEEKOPERATION): IKsAllocatorEx; stdcall;
    procedure KsSetPipe(KsAllocator: IKsAllocatorEx); stdcall;
    function KsGetPipeAllocatorFlag: ULONG; stdcall;
    procedure KsSetPipeAllocatorFlag(Flag: ULONG); stdcall;
    function KsGetPinBusCache: TGUID; stdcall;
    procedure KsSetPinBusCache(const Bus: TGUID); stdcall;
    // very useful methods for tracing.
    function KsGetPinName: PWideChar; stdcall;
    function KsGetFilterName: PWideChar; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IKsPinFactory> _di_IKsPinFactory;'}
  {$EXTERNALSYM IKsPinFactory}
  IKsPinFactory = interface(IUnknown)
    ['{CD5EBE6B-8B6E-11D1-8AE0-00A0C9223196}']
    (*** IKsPinFactory methods ***)
    procedure KsPinFactory(PinFactory: PULONG); stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IKsDataTypeHandler> _di_IKsDataTypeHandler;'}
  {$EXTERNALSYM IKsDataTypeHandler}
  IKsDataTypeHandler = interface(IUnknown)
    ['{5ffbaa02-49a3-11d0-9f36-00aa00a216a1}']
    (*** IKsDataTypeHandler methods ***)
    procedure KsCompleteIoOperation(Sample: IMediaSample; StreamHeader: Pointer;
                IoOperation: TKSIOOPERATION; Cancelled: BOOL); stdcall;
    procedure KsIsMediaTypeInRanges(DataRanges: Pointer); stdcall;
    procedure KsPrepareIoOperation(Sample: IMediaSample; StreamHeader: Pointer;
                IoOperation: TKSIOOPERATION); stdcall;
    procedure KsQueryExtendedSize(var ExtendedSize: ULONG); stdcall;
    procedure KsSetMediaType(const AmMediaType: TAMMediaType); stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IKsDataTypeCompletion> _di_IKsDataTypeCompletion;'}
  {$EXTERNALSYM IKsDataTypeCompletion}
  IKsDataTypeCompletion = interface(IUnknown)
    ['{827D1A0E-0F73-11D2-B27A-00A0C9223196}']
    (*** IKsDataTypeCompletion methods ***)
    procedure KsCompleteMediaType(FilterHandle: THandle; PinFactoryId: ULONG;
                var AmMediaType: TAMMediaType); stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IKsInterfaceHandler> _di_IKsInterfaceHandler;'}
  {$EXTERNALSYM IKsInterfaceHandler}
  IKsInterfaceHandler = interface(IUnknown)
    ['{D3ABC7E0-9A61-11d0-A40D-00A0C9223196}']
    (*** IKsInterfaceHandler methods ***)
    procedure KsSetPin(KsPin: IKsPin); stdcall;
    procedure KsProcessMediaSamples(KsDataTypeHandler: IKsDataTypeHandler;
                SampleList: IMediaSample; SampleCount: PLongint;
                IoOperation: TKSIOOPERATION; StreamSegment: PKSSTREAM_SEGMENT); stdcall;
    procedure KsCompleteIo(StreamSegment: PKSSTREAM_SEGMENT); stdcall;
  end;


//
// This structure definition is the common header required by the proxy to
// dispatch the stream segment to the interface handler.  Interface handlers
// will create extended structures to include other information such as
// media samples, extended header size and so on.


  {$HPPEMIT 'typedef System::DelphiInterface<IKsObject> _di_IKsObject;'}
  {$EXTERNALSYM IKsObject}
  IKsObject = interface(IUnknown)
    ['{423c13a2-2070-11d0-9ef7-00aa00a216a1}']
    (*** IKsObject methods ***)
    function KsGetObjectHandle: THandle; stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IKsQualityForwarder> _di_IKsQualityForwarder;'}
  {$EXTERNALSYM IKsQualityForwarder}
  IKsQualityForwarder = interface(IUnknown)
    ['{97ebaacb-95bd-11d0-a3ea-00a0c9223196}']
    (*** IKsQualityForwarder methods ***)
    procedure KsFlushClient(Pin: IKsPin); stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IKsNotifyEvent> _di_IKsNotifyEvent;'}
  {$EXTERNALSYM IKsNotifyEvent}
  IKsNotifyEvent = interface(IUnknown)
    ['{412bd695-f84b-46c1-ac73-54196dbc8fa7}']
    (*** IKsNotifyEvent methods ***)
    procedure KsNotifyEvent(Event,lParam1, lParam2: ULONG); stdcall;
  end;

 function KsResolveRequiredAttributes(DataRange: PKSDATARANGE;
             {OPTIONAL}Attributes: PKSMULTIPLE_ITEM): HResult; stdcall;
 {$EXTERNALSYM KsResolveRequiredAttributes}

 function KsOpenDefaultDevice(Category: TGUID; Access: ACCESS_MASK;
             DeviceHandle: PHANDLE): HResult; stdcall;
 {$EXTERNALSYM KsOpenDefaultDevice}

 function KsSynchronousDeviceControl(Handle: THandle; IoControl: ULONG;
             InBuffer: Pointer; InLength: ULONG; OutBuffer: Pointer;
             OutLength: ULONG; BytesReturned: PULONG): HResult; stdcall;
 {$EXTERNALSYM KsSynchronousDeviceControl}

 function KsGetMultiplePinFactoryItems(FilterHandle: THandle; PinFactoryId: ULONG;
             PropertyId: ULONG; Items: Pointer): HResult; stdcall;
 {$EXTERNALSYM KsGetMultiplePinFactoryItems}

 function KsGetMediaTypeCount(FilterHandle: THandle; PinFactoryId: ULONG;
             out MediaTypeCount: ULONG): HResult; stdcall;
 {$EXTERNALSYM KsGetMediaTypeCount}

 function KsGetMediaType(Position: integer; out AmMediaType: TAMMediaType;
             FilterHandle: THandle; PinFactoryId: ULONG): HResult; stdcall;
 {$EXTERNALSYM KsGetMediaType}

type
  {$HPPEMIT 'typedef System::DelphiInterface<IKsAggregateControl> _di_IKsAggregateControl;'}
  {$EXTERNALSYM IKsAggregateControl}
  IKsAggregateControl = interface(IUnknown)
    ['{7F40EAC0-3947-11D2-874E-00A0C9223196}']
    (*** IKsAggregateControl methods ***)
    procedure KsAddAggregate(const AggregateClass: TGUID); stdcall;
    procedure KsRemoveAggregate(const AggregateClass: TGUID); stdcall;
  end;

  {$HPPEMIT 'typedef System::DelphiInterface<IKsTopology> _di_IKsTopology;'}
  {$EXTERNALSYM IKsTopology}
  IKsTopology = interface(IUnknown)
    ['{28F54683-06FD-11D2-B27A-00A0C9223196}']
    (*** IKsTopology methods ***)
    procedure CreateNodeInstance(NodeId: ULONG; Flags: ULONG; DesiredAccess: ACCESS_MASK;
              {OPTIONAL}UnkOuter: IUnknown; const InterfaceId: TGUID; out Interface_); stdcall;
  end;

 {*****************************************************************************
 *  Copyright (C) Microsoft Corporation, 1996 - 2000                          *
 *                                                                            *
 *  Module Name: ksmedia.h                                                    *
 *                                                                            *
 *  Abstract: WDM-CSA Multimedia Definitions.                                 *
 *                                                                            *
 *****************************************************************************}

  PKSMultipleDataProp = ^TKSMultipleDataProp;
  KSMULTIPLE_DATA_PROP = record
    Property_    : KSPROPERTY;
    MultipleItem : TKSMultipleItem;
  end;
  {$EXTERNALSYM KSMULTIPLE_DATA_PROP}
  PKSMULTIPLE_DATA_PROP = ^KSMULTIPLE_DATA_PROP;
  {$EXTERNALSYM PKSMULTIPLE_DATA_PROP}
  TKSMultipleDataProp = KSMULTIPLE_DATA_PROP;

const
  KSMEDIUMSETID_MidiBus  : TGUID = '{05908040-3246-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSMEDIUMSETID_MidiBus}
  KSMEDIUMSETID_VPBus    : TGUID = '{A18C15EC-CE43-11D0-ABE7-00A0C9223196}';
  {$EXTERNALSYM KSMEDIUMSETID_VPBus}
  KSINTERFACESETID_Media : TGUID = '{3A13EB40-30A7-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSINTERFACESETID_Media}

type
  KSINTERFACE_MEDIA = (
    KSINTERFACE_MEDIA_MUSIC,
    KSINTERFACE_MEDIA_WAVE_BUFFERED,
    KSINTERFACE_MEDIA_WAVE_QUEUED
  );
  {$EXTERNALSYM KSINTERFACE_MEDIA}
  TKSInterfaceMedia = KSINTERFACE_MEDIA;

// USB Terminals
//#define INIT_USB_TERMINAL(guid, id)\
{\
    (guid)->Data1 = 0xDFF219E0 + (USHORT)(id);\
    (guid)->Data2 = 0xF70F;\
    (guid)->Data3 = 0x11D0;\
    (guid)->Data4[0] = 0xb9;\
    (guid)->Data4[1] = 0x17;\
    (guid)->Data4[2] = 0x00;\
    (guid)->Data4[3] = 0xa0;\
    (guid)->Data4[4] = 0xc9;\
    (guid)->Data4[5] = 0x22;\
    (guid)->Data4[6] = 0x31;\
    (guid)->Data4[7] = 0x96;\
}

{#define EXTRACT_USB_TERMINAL(guid)\
    (USHORT)((guid)->Data1 - 0xDFF219E0)
#define DEFINE_USB_TERMINAL_GUID(id)\
    0xDFF219E0+(USHORT)(id), 0xF70F, 0x11D0, 0xB9, 0x17, 0x00, 0xA0, 0xC9, 0x22, 0x31, 0x96}
const
  KSNODETYPE_MICROPHONE                      : TGUID = '{DFF21BE1-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_MICROPHONE}
  KSNODETYPE_DESKTOP_MICROPHONE              : TGUID = '{DFF21BE2-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_DESKTOP_MICROPHONE}
  KSNODETYPE_PERSONAL_MICROPHONE             : TGUID = '{DFF21BE3-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_PERSONAL_MICROPHONE}
  KSNODETYPE_OMNI_DIRECTIONAL_MICROPHONE     : TGUID = '{DFF21BE4-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_OMNI_DIRECTIONAL_MICROPHONE}
  KSNODETYPE_MICROPHONE_ARRAY                : TGUID = '{DFF21BE5-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_MICROPHONE_ARRAY}
  KSNODETYPE_PROCESSING_MICROPHONE_ARRAY     : TGUID = '{DFF21BE6-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_PROCESSING_MICROPHONE_ARRAY}
  KSCATEGORY_MICROPHONE_ARRAY_PROCESSOR      : TGUID = '{830a44f2-a32d-476b-be97-42845673b35a}';
  {$EXTERNALSYM KSCATEGORY_MICROPHONE_ARRAY_PROCESSOR}
  KSNODETYPE_SPEAKER                         : TGUID = '{DFF21CE1-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_SPEAKER}
  KSNODETYPE_HEADPHONES                      : TGUID = '{DFF21CE2-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_HEADPHONES}
  KSNODETYPE_HEAD_MOUNTED_DISPLAY_AUDIO      : TGUID = '{DFF21CE3-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_HEAD_MOUNTED_DISPLAY_AUDIO}
  KSNODETYPE_DESKTOP_SPEAKER                 : TGUID = '{DFF21CE4-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_DESKTOP_SPEAKER}
  KSNODETYPE_ROOM_SPEAKER                    : TGUID = '{DFF21CE5-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_ROOM_SPEAKER}
  KSNODETYPE_COMMUNICATION_SPEAKER           : TGUID = '{DFF21CE6-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_COMMUNICATION_SPEAKER}
  KSNODETYPE_LOW_FREQUENCY_EFFECTS_SPEAKER   : TGUID = '{DFF21CE7-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_LOW_FREQUENCY_EFFECTS_SPEAKER}
  KSNODETYPE_HANDSET                         : TGUID = '{DFF21DE1-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_HANDSET}
  KSNODETYPE_HEADSET                         : TGUID = '{DFF21DE2-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_HEADSET}
  KSNODETYPE_SPEAKERPHONE_NO_ECHO_REDUCTION  : TGUID = '{DFF21DE3-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_SPEAKERPHONE_NO_ECHO_REDUCTION}
  KSNODETYPE_ECHO_SUPPRESSING_SPEAKERPHONE   : TGUID = '{DFF21DE4-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_ECHO_SUPPRESSING_SPEAKERPHONE}
  KSNODETYPE_ECHO_CANCELING_SPEAKERPHONE     : TGUID = '{DFF21DE5-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_ECHO_CANCELING_SPEAKERPHONE}
  KSNODETYPE_PHONE_LINE                      : TGUID = '{DFF21EE1-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_PHONE_LINE}
  KSNODETYPE_TELEPHONE                       : TGUID = '{DFF21EE2-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_TELEPHONE}
  KSNODETYPE_DOWN_LINE_PHONE                 : TGUID = '{DFF21EE3-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_DOWN_LINE_PHONE}
  KSNODETYPE_ANALOG_CONNECTOR                : TGUID = '{DFF21FE1-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_ANALOG_CONNECTOR}
  KSNODETYPE_DIGITAL_AUDIO_INTERFACE         : TGUID = '{DFF21FE2-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_DIGITAL_AUDIO_INTERFACE}
  KSNODETYPE_LINE_CONNECTOR                  : TGUID = '{DFF21FE3-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_LINE_CONNECTOR}
  KSNODETYPE_LEGACY_AUDIO_CONNECTOR          : TGUID = '{DFF21FE4-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_LEGACY_AUDIO_CONNECTOR}
  KSNODETYPE_SPDIF_INTERFACE                 : TGUID = '{DFF21FE5-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_SPDIF_INTERFACE}
  KSNODETYPE_1394_DA_STREAM                  : TGUID = '{DFF21FE6-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_1394_DA_STREAM}
  KSNODETYPE_1394_DV_STREAM_SOUNDTRACK       : TGUID = '{DFF21FE7-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_1394_DV_STREAM_SOUNDTRACK}
  KSNODETYPE_LEVEL_CALIBRATION_NOISE_SOURCE  : TGUID = '{DFF220E1-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_LEVEL_CALIBRATION_NOISE_SOURCE}
  KSNODETYPE_EQUALIZATION_NOISE              : TGUID = '{DFF220E2-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_EQUALIZATION_NOISE}
  KSNODETYPE_CD_PLAYER                       : TGUID = '{DFF220E3-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_CD_PLAYER}
  KSNODETYPE_DAT_IO_DIGITAL_AUDIO_TAPE       : TGUID = '{DFF220E4-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_DAT_IO_DIGITAL_AUDIO_TAPE}
  KSNODETYPE_DCC_IO_DIGITAL_COMPACT_CASSETTE : TGUID = '{DFF220E5-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_DCC_IO_DIGITAL_COMPACT_CASSETTE}
  KSNODETYPE_MINIDISK                        : TGUID = '{DFF220E6-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_MINIDISK}
  KSNODETYPE_ANALOG_TAPE                     : TGUID = '{DFF220E7-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_ANALOG_TAPE}
  KSNODETYPE_PHONOGRAPH                      : TGUID = '{DFF220E8-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_PHONOGRAPH}
  KSNODETYPE_VCR_AUDIO                       : TGUID = '{DFF220E9-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_VCR_AUDIO}
  KSNODETYPE_VIDEO_DISC_AUDIO                : TGUID = '{DFF220EA-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_VIDEO_DISC_AUDIO}
  KSNODETYPE_DVD_AUDIO                       : TGUID = '{DFF220EB-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_DVD_AUDIO}
  KSNODETYPE_TV_TUNER_AUDIO                  : TGUID = '{DFF220EC-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_TV_TUNER_AUDIO}
  KSNODETYPE_SATELLITE_RECEIVER_AUDIO        : TGUID = '{DFF220ED-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_SATELLITE_RECEIVER_AUDIO}
  KSNODETYPE_CABLE_TUNER_AUDIO               : TGUID = '{DFF220EE-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_CABLE_TUNER_AUDIO}
  KSNODETYPE_DSS_AUDIO                       : TGUID = '{DFF220EF-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_DSS_AUDIO}
  KSNODETYPE_RADIO_RECEIVER                  : TGUID = '{DFF220F0-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_RADIO_RECEIVER}
  KSNODETYPE_RADIO_TRANSMITTER               : TGUID = '{DFF220F1-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_RADIO_TRANSMITTER}
  KSNODETYPE_MULTITRACK_RECORDER             : TGUID = '{DFF220F2-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_MULTITRACK_RECORDER}
  KSNODETYPE_SYNTHESIZER                     : TGUID = '{DFF220F3-F70F-11D0-B917-00A0C9223196}';
  {$EXTERNALSYM KSNODETYPE_SYNTHESIZER}
// Microsoft's WDMAUD virtual swsynth pin name guid
  KSNODETYPE_SWSYNTH                         : TGUID = '{423274A0-8B81-11D1-A050-0000F8004788}';
  {$EXTERNALSYM KSNODETYPE_SWSYNTH}
// Microsoft's SWMIDI midi pin and node name guid
  KSNODETYPE_SWMIDI                          : TGUID = '{CB9BEFA0-A251-11D1-A050-0000F8004788}';
  {$EXTERNALSYM KSNODETYPE_SWMIDI}
  KSNODETYPE_DRM_DESCRAMBLE                  : TGUID = '{FFBB6E3F-CCFE-4D84-90D9-421418B03A8E}';
  {$EXTERNALSYM KSNODETYPE_DRM_DESCRAMBLE}
// General categories
  KSCATEGORY_AUDIO                           : TGUID = '{6994AD04-93EF-11D0-A3CC-00A0C9223196}';
  {$EXTERNALSYM KSCATEGORY_AUDIO}
  KSCATEGORY_VIDEO                           : TGUID = '{6994AD05-93EF-11D0-A3CC-00A0C9223196}';
  {$EXTERNALSYM KSCATEGORY_VIDEO}
  KSCATEGORY_TEXT                            : TGUID = '{6994AD06-93EF-11D0-A3CC-00A0C9223196}';
  {$EXTERNALSYM KSCATEGORY_TEXT}
  KSCATEGORY_NETWORK                         : TGUID = '{67C9CC3C-69C4-11D2-8759-00A0C9223196}';
  {$EXTERNALSYM KSCATEGORY_NETWORK}
  KSCATEGORY_TOPOLOGY                        : TGUID = '{DDA54A40-1E4C-11D1-A050-405705C10000}';
  {$EXTERNALSYM KSCATEGORY_TOPOLOGY}
  KSCATEGORY_VIRTUAL                         : TGUID = '{3503EAC4-1F26-11D1-8AB0-00A0C9223196}';
  {$EXTERNALSYM KSCATEGORY_VIRTUAL}
  KSCATEGORY_ACOUSTIC_ECHO_CANCEL            : TGUID = '{BF963D80-C559-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSCATEGORY_ACOUSTIC_ECHO_CANCEL}
  KSCATEGORY_SYSAUDIO                        : TGUID = '{A7C7A5B1-5AF3-11D1-9CED-00A024BF0407}';
  {$EXTERNALSYM KSCATEGORY_SYSAUDIO}
  KSCATEGORY_WDMAUD                          : TGUID = '{3E227E76-690D-11D2-8161-0000F8775BF1}';
  {$EXTERNALSYM KSCATEGORY_WDMAUD}
  KSCATEGORY_AUDIO_GFX                       : TGUID = '{9BAF9572-340C-11D3-ABDC-00A0C90AB16F}';
  {$EXTERNALSYM KSCATEGORY_AUDIO_GFX}
  KSCATEGORY_AUDIO_SPLITTER                  : TGUID = '{9EA331FA-B91B-45F8-9285-BD2BC77AFCDE}';
  {$EXTERNALSYM KSCATEGORY_AUDIO_SPLITTER}

  KSCATEGORY_SYNTHESIZER                     : TGUID = '{DFF220F3-F70F-11D0-B917-00A0C9223196}'; //KSNODETYPE_SYNTHESIZER
  {$EXTERNALSYM KSCATEGORY_SYNTHESIZER}
  KSCATEGORY_DRM_DESCRAMBLE                  : TGUID = '{FFBB6E3F-CCFE-4D84-90D9-421418B03A8E}'; //KSNODETYPE_DRM_DESCRAMBLE
  {$EXTERNALSYM KSCATEGORY_DRM_DESCRAMBLE}

  KSCATEGORY_AUDIO_DEVICE                    : TGUID = '{FBF6F530-07B9-11D2-A71E-0000F8004788}';
  {$EXTERNALSYM KSCATEGORY_AUDIO_DEVICE}
  KSCATEGORY_PREFERRED_WAVEOUT_DEVICE        : TGUID = '{D6C5066E-72C1-11D2-9755-0000F8004788}';
  {$EXTERNALSYM KSCATEGORY_PREFERRED_WAVEOUT_DEVICE}
  KSCATEGORY_PREFERRED_WAVEIN_DEVICE         : TGUID = '{D6C50671-72C1-11D2-9755-0000F8004788}';
  {$EXTERNALSYM KSCATEGORY_PREFERRED_WAVEIN_DEVICE}
  KSCATEGORY_PREFERRED_MIDIOUT_DEVICE        : TGUID = '{D6C50674-72C1-11D2-9755-0000F8004788}';
  {$EXTERNALSYM KSCATEGORY_PREFERRED_MIDIOUT_DEVICE}
// Special pin category for wdmaud
  KSCATEGORY_WDMAUD_USE_PIN_NAME             : TGUID = '{47A4FA20-A251-11D1-A050-0000F8004788}';
  {$EXTERNALSYM KSCATEGORY_WDMAUD_USE_PIN_NAME}
// Escalante Platform Interface
  KSCATEGORY_ESCALANTE_PLATFORM_DRIVER       : TGUID = '{74f3aea8-9768-11d1-8e07-00a0c95ec22e}';
  {$EXTERNALSYM KSCATEGORY_ESCALANTE_PLATFORM_DRIVER}
// -- major types ---

// 'vids' == MEDIATYPE_Video,
  KSDATAFORMAT_TYPE_VIDEO                    : TGUID = '{73646976-0000-0010-8000-00aa00389b71}';
  {$EXTERNALSYM KSDATAFORMAT_TYPE_VIDEO}
// 'auds' == MEDIATYPE_Audio
  KSDATAFORMAT_TYPE_AUDIO                    : TGUID = '{73647561-0000-0010-8000-00aa00389b71}';
  {$EXTERNALSYM KSDATAFORMAT_TYPE_AUDIO}
// 'txts' == MEDIATYPE_Text
  KSDATAFORMAT_TYPE_TEXT                     : TGUID = '{73747874-0000-0010-8000-00aa00389b71}';
  {$EXTERNALSYM KSDATAFORMAT_TYPE_TEXT}

{#if !defined( DEFINE_WAVEFORMATEX_GUID )
#define DEFINE_WAVEFORMATEX_GUID(x) (USHORT)(x), 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71
#endif}

  KSDATAFORMAT_SUBTYPE_WAVEFORMATEX          : TGUID = '{00000000-0000-0010-8000-00aa00389b71}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_WAVEFORMATEX}

//#define INIT_WAVEFORMATEX_GUID(Guid, x)\
{\
    *(Guid) = KSDATAFORMAT_SUBTYPE_WAVEFORMATEX;\
    (Guid)->Data1 = (USHORT)(x);\
}

{#define EXTRACT_WAVEFORMATEX_ID(Guid)\
    (USHORT)((Guid)->Data1)

#define IS_VALID_WAVEFORMATEX_GUID(Guid)\
    (!memcmp(((PUSHORT)&KSDATAFORMAT_SUBTYPE_WAVEFORMATEX) + 1, ((PUSHORT)(Guid)) + 1, sizeof(GUID) - sizeof(USHORT)))

#if !defined(INIT_MMREG_MID)}
//{d5a47fa7-6d98-11d1-a21a-00a0c9223196}
//#define INIT_MMREG_MID(guid, id)\
{\
    (guid)->Data1 = 0xd5a47fa7 + (USHORT)(id);\
    (guid)->Data2 = 0x6d98;\
    (guid)->Data3 = 0x11d1;\
    (guid)->Data4[0] = 0xa2;\
    (guid)->Data4[1] = 0x1a;\
    (guid)->Data4[2] = 0x00;\
    (guid)->Data4[3] = 0xa0;\
    (guid)->Data4[4] = 0xc9;\
    (guid)->Data4[5] = 0x22;\
    (guid)->Data4[6] = 0x31;\
    (guid)->Data4[7] = 0x96;\
}
{#define EXTRACT_MMREG_MID(guid)\
    (USHORT)((guid)->Data1 - 0xd5a47fa7)
#define DEFINE_MMREG_MID_GUID(id)\
    0xd5a47fa7+(USHORT)(id), 0x6d98, 0x11d1, 0xa2, 0x1a, 0x00, 0xa0, 0xc9, 0x22, 0x31, 0x96

#define IS_COMPATIBLE_MMREG_MID(guid)\
    (((guid)->Data1 >= 0xd5a47fa7) &&\
    ((guid)->Data1 < 0xd5a47fa7 + 0xffff) &&\
    ((guid)->Data2 == 0x6d98) &&\
    ((guid)->Data3 == 0x11d1) &&\
    ((guid)->Data4[0] == 0xa2) &&\
    ((guid)->Data4[1] == 0x1a) &&\
    ((guid)->Data4[2] == 0x00) &&\
    ((guid)->Data4[3] == 0xa0) &&\
    ((guid)->Data4[4] == 0xc9) &&\
    ((guid)->Data4[5] == 0x22) &&\
    ((guid)->Data4[6] == 0x31) &&\
    ((guid)->Data4[7] == 0x96))
#endif // !defined(INIT_MMREG_MID)

#if !defined(INIT_MMREG_PID)
//{e36dc2ac-6d9a-11d1-a21a-00a0c9223196}
//#define INIT_MMREG_PID(guid, id)\
{\
    (guid)->Data1 = 0xe36dc2ac + (USHORT)(id);\
    (guid)->Data2 = 0x6d9a;\
    (guid)->Data3 = 0x11d1;\
    (guid)->Data4[0] = 0xa2;\
    (guid)->Data4[1] = 0x1a;\
    (guid)->Data4[2] = 0x00;\
    (guid)->Data4[3] = 0xa0;\
    (guid)->Data4[4] = 0xc9;\
    (guid)->Data4[5] = 0x22;\
    (guid)->Data4[6] = 0x31;\
    (guid)->Data4[7] = 0x96;\
}
{#define EXTRACT_MMREG_PID(guid)\
    (USHORT)((guid)->Data1 - 0xe36dc2ac)
#define DEFINE_MMREG_PID_GUID(id)\
    0xe36dc2ac+(USHORT)(id), 0x6d9a, 0x11d1, 0xa2, 0x1a, 0x00, 0xa0, 0xc9, 0x22, 0x31, 0x96

#define IS_COMPATIBLE_MMREG_PID(guid)\
    (((guid)->Data1 >= 0xe36dc2ac) &&\
    ((guid)->Data1 < 0xe36dc2ac + 0xffff) &&\
    ((guid)->Data2 == 0x6d9a) &&\
    ((guid)->Data3 == 0x11d1) &&\
    ((guid)->Data4[0] == 0xa2) &&\
    ((guid)->Data4[1] == 0x1a) &&\
    ((guid)->Data4[2] == 0x00) &&\
    ((guid)->Data4[3] == 0xa0) &&\
    ((guid)->Data4[4] == 0xc9) &&\
    ((guid)->Data4[5] == 0x22) &&\
    ((guid)->Data4[6] == 0x31) &&\
    ((guid)->Data4[7] == 0x96))
#endif // !defined(INIT_MMREG_PID)}

 KSDATAFORMAT_SUBTYPE_ANALOG         : TGUID = '{6dba3190-67bd-11cf-a0f7-0020afd156e4}';
 {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_ANALOG}
 KSDATAFORMAT_SUBTYPE_PCM            : TGUID = '{00000001-0000-0010-8000-00aa00389b71}';
 {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_PCM}
 KSDATAFORMAT_SUBTYPE_IEEE_FLOAT     : TGUID = '{00000003-0000-0010-8000-00aa00389b71}';
 {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_IEEE_FLOAT}
 KSDATAFORMAT_SUBTYPE_DRM            : TGUID = '{00000009-0000-0010-8000-00aa00389b71}';
 {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_DRM}
 KSDATAFORMAT_SUBTYPE_ALAW           : TGUID = '{00000006-0000-0010-8000-00aa00389b71}';
 {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_ALAW}
 KSDATAFORMAT_SUBTYPE_MULAW          : TGUID = '{00000007-0000-0010-8000-00aa00389b71}';
 {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_MULAW}
 KSDATAFORMAT_SUBTYPE_ADPCM          : TGUID = '{00000002-0000-0010-8000-00aa00389b71}';
 {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_ADPCM}
 KSDATAFORMAT_SUBTYPE_MPEG           : TGUID = '{00000050-0000-0010-8000-00aa00389b71}';
 {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_MPEG}
 KSDATAFORMAT_SPECIFIER_VC_ID        : TGUID = '{AD98D184-AAC3-11D0-A41C-00A0C9223196}';
 {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_VC_ID}
 KSDATAFORMAT_SPECIFIER_WAVEFORMATEX : TGUID = '{05589f81-c356-11ce-bf01-00aa0055595a}';
 {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_WAVEFORMATEX}
 KSDATAFORMAT_SPECIFIER_DSOUND       : TGUID = '{518590a2-a184-11d0-8522-00c04fd9baf3}';
 {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_DSOUND}

type
  PKSDataFormatWaveFormatEx = ^TKSDataFormatWaveFormatEx;
  KSDATAFORMAT_WAVEFORMATEX = record
    DataFormat   : TKSDATAFORMAT;
    WaveFormatEx : TWAVEFORMATEX;
  end;
  {$EXTERNALSYM KSDATAFORMAT_WAVEFORMATEX}
  PKSDATAFORMAT_WAVEFORMATEX = ^KSDATAFORMAT_WAVEFORMATEX;
  {$EXTERNALSYM PKSDATAFORMAT_WAVEFORMATEX}
  TKSDataFormatWaveFormatEx = KSDATAFORMAT_WAVEFORMATEX;

  //
  // The WAVEFORMATEXTENSIBLE structure defines the format of waveform-audio data for formats having more than two channels.
  // This structure is part of the Platform SDK and is not declared in Dsound.h. It is included here for convenience.
  //
  TWaveFormatExtensibleSamples = record
     case byte of
      0: (wValidBitsPerSample : Word);   // bits of precision
      1: (wSamplesPerBlock    : Word);   // valid if wBitsPerSample = 0
      2: (wReserved           : Word);   // If neither applies, set to zero.
  end;
  {$EXTERNALSYM TWaveFormatExtensibleSamples}

  PWaveFormatExtensible = ^TWaveFormatExtensible;
  WAVEFORMATEXTENSIBLE = record
    Format: TWaveFormatEx;
    Samples: TWaveFormatExtensibleSamples;
    dwChannelMask       : DWORD;  // which channels are present in stream
    SubFormat           : TGUID;
  end;
  {$EXTERNALSYM WAVEFORMATEXTENSIBLE}
  TWaveFormatExtensible = WAVEFORMATEXTENSIBLE;

const
  WAVE_FORMAT_EXTENSIBLE          = $FFFE;
  {$EXTERNALSYM WAVE_FORMAT_EXTENSIBLE}

type
// DirectSound buffer description
  PKSDSoundBufferDesc = ^TKSDSoundBufferDesc;
  KSDSOUND_BUFFERDESC = record
    Flags        : ULONG;
    Control      : ULONG;
    WaveFormatEx : TWAVEFORMATEX;
  end;
  {$EXTERNALSYM KSDSOUND_BUFFERDESC}
  PKSDSOUND_BUFFERDESC = ^KSDSOUND_BUFFERDESC;
  {$EXTERNALSYM PKSDSOUND_BUFFERDESC}
  TKSDSoundBufferDesc = KSDSOUND_BUFFERDESC;

// DirectSound format
  PKSDataFormatDSound = ^TKSDataFormatDSound;
  KSDATAFORMAT_DSOUND = record
    DataFormat :TKSDataFormat;
    BufferDesc :TKSDSoundBufferDesc;
  end;
  {$EXTERNALSYM KSDATAFORMAT_DSOUND}
  PKSDATAFORMAT_DSOUND = ^KSDATAFORMAT_DSOUND;
  {$EXTERNALSYM PKSDATAFORMAT_DSOUND}
  TKSDataFormatDSound = KSDATAFORMAT_DSOUND;

const
// DirectSound buffer flags
  KSDSOUND_BUFFER_PRIMARY     = $00000001;
  {$EXTERNALSYM KSDSOUND_BUFFER_PRIMARY}
  KSDSOUND_BUFFER_STATIC      = $00000002;
  {$EXTERNALSYM KSDSOUND_BUFFER_STATIC}
  KSDSOUND_BUFFER_LOCHARDWARE = $00000004;
  {$EXTERNALSYM KSDSOUND_BUFFER_LOCHARDWARE}
  KSDSOUND_BUFFER_LOCSOFTWARE = $00000008;
  {$EXTERNALSYM KSDSOUND_BUFFER_LOCSOFTWARE}

// DirectSound buffer control flags
  KSDSOUND_BUFFER_CTRL_3D             = $00000001;
  {$EXTERNALSYM KSDSOUND_BUFFER_CTRL_3D}
  KSDSOUND_BUFFER_CTRL_FREQUENCY      = $00000002;
  {$EXTERNALSYM KSDSOUND_BUFFER_CTRL_FREQUENCY}
  KSDSOUND_BUFFER_CTRL_PAN            = $00000004;
  {$EXTERNALSYM KSDSOUND_BUFFER_CTRL_PAN}
  KSDSOUND_BUFFER_CTRL_VOLUME         = $00000008;
  {$EXTERNALSYM KSDSOUND_BUFFER_CTRL_VOLUME}
  KSDSOUND_BUFFER_CTRL_POSITIONNOTIFY = $00000010;
  {$EXTERNALSYM KSDSOUND_BUFFER_CTRL_POSITIONNOTIFY}

  KSDSOUND_BUFFER_CTRL_HRTF_3D        = $40000000;
  {$EXTERNALSYM KSDSOUND_BUFFER_CTRL_HRTF_3D}

type
  PKSAudioPosition = ^TKSAudioPosition;
  KSAUDIO_POSITION = record
    PlayOffset  :int64;
    WriteOffset :int64;
  end;
  {$EXTERNALSYM KSAUDIO_POSITION}
  PKSAUDIO_POSITION = ^KSAUDIO_POSITION;
  {$EXTERNALSYM PKSAUDIO_POSITION}
  TKSAudioPosition = KSAUDIO_POSITION;

// DirectSound3D FIR context
//  PKSDS3DITDParams = ^TKSDS3DITDParams;
//  KSDS3D_ITD_PARAMS = record
//    Channel             : longint;
//    VolSmoothScale      : single;
//    TotalDryAttenuation : single;
//    TotalWetAttenuation : single;
//    SmoothFrequency     : longint;
//    Delay               : longint;
//  end;
//  {$EXTERNALSYM KSDS3D_ITD_PARAMS}
//  PKSDS3D_ITD_PARAMS = ^KSDS3D_ITD_PARAMS;
//  {$EXTERNALSYM PKSDS3D_ITD_PARAMS}
//  TKSDS3DITDParams = KSDS3D_ITD_PARAMS;

//  PKSDS3DITDParamsMsg = ^TKSDS3DITDParamsMsg;
//  KSDS3D_ITD_PARAMS_MSG = record
//    Enabled     :ULONG;
//    LeftParams  :TKSDS3DITDParams;
//    RightParams :TKSDS3DITDParams;
//    Reserved    :ULONG;
//  end;
//  {$EXTERNALSYM KSDS3D_ITD_PARAMS_MSG}
//  PKSDS3D_ITD_PARAMS_MSG = ^KSDS3D_ITD_PARAMS_MSG;
//  {$EXTERNALSYM PKSDS3D_ITD_PARAMS_MSG}
//  TKSDS3DITDParamsMsg = KSDS3D_ITD_PARAMS_MSG;

// DirectSound3D HRTF messages

//  PKSDS3DHRTFParamsMsg = ^TKSDS3DHRTFParamsMsg;
//  KSDS3D_HRTF_PARAMS_MSG = record
//    Size            :ULONG; // This is the size of the struct in bytes
//    Enabled         :ULONG;
//    SwapChannels    :BOOL;
//    ZeroAzimuth     :BOOL;
//    CrossFadeOutput :BOOL;
//    FilterSize      :ULONG; // This is the additional size of the filter coeff in bytes
//  end;
//  {$EXTERNALSYM KSDS3D_HRTF_PARAMS_MSG}
//  PKSDS3D_HRTF_PARAMS_MSG = ^KSDS3D_HRTF_PARAMS_MSG;
//  {$EXTERNALSYM PKSDS3D_HRTF_PARAMS_MSG}
//  TKSDS3DHRTFParamsMsg = KSDS3D_HRTF_PARAMS_MSG;

// HRTF filter quality levels
//  KSDS3D_HRTF_FILTER_QUALITY = (
//    FULL_FILTER,
//    LIGHT_FILTER,
//    KSDS3D_FILTER_QUALITY_COUNT
//  );
//  {$EXTERNALSYM KSDS3D_HRTF_FILTER_QUALITY}
//  TKSDS3DHRTFFilterQuality = KSDS3D_HRTF_FILTER_QUALITY;

//  PKSDS3DHRTFInitMsg = ^TKSDS3DHRTFInitMsg;
//  KSDS3D_HRTF_INIT_MSG = record
//    Size                      : ULONG; // This is the size of the struct in bytes
//    Quality                   : TKSDS3DHRTFFilterQuality;
//    SampleRate                : single;
//    MaxFilterSize             : ULONG;
//    FilterTransientMuteLength : ULONG;
//    FilterOverlapBufferLength : ULONG;
//    OutputOverlapBufferLength : ULONG;
//    Reserved                  : ULONG;
//  end;
//  {$EXTERNALSYM KSDS3D_HRTF_INIT_MSG}
//  PKSDS3D_HRTF_INIT_MSG = ^KSDS3D_HRTF_INIT_MSG;
//  {$EXTERNALSYM PKSDS3D_HRTF_INIT_MSG}
//  TKSDS3DHRTFInitMsg = KSDS3D_HRTF_INIT_MSG;

// Coefficient formats
//  KSDS3D_HRTF_COEFF_FORMAT = (
//    FLOAT_COEFF,
//    SHORT_COEFF,
//    KSDS3D_COEFF_COUNT
//  );
//  {$EXTERNALSYM KSDS3D_HRTF_COEFF_FORMAT}
//  TKSDS3DHRTFCoeffFormat = KSDS3D_HRTF_COEFF_FORMAT;

//// Filter methods
//  KSDS3D_HRTF_FILTER_METHOD = (
//    DIRECT_FORM,
//    CASCADE_FORM,
//    KSDS3D_FILTER_METHOD_COUNT
//  );
//  {$EXTERNALSYM KSDS3D_HRTF_FILTER_METHOD}
//  TKSDS3DHRTFFilterMethod = KSDS3D_HRTF_FILTER_METHOD;

// Filter methods
//  KSDS3D_HRTF_FILTER_VERSION = (
//    DS3D_HRTF_VERSION_1
//  );
//  {$EXTERNALSYM KSDS3D_HRTF_FILTER_VERSION}
//  TKSDS3DHRTFFilterVersion = KSDS3D_HRTF_FILTER_VERSION;

//  PKSDS3DHRTFFilterFormatMsg = ^TKSDS3DHRTFFilterFormatMsg;
//  KSDS3D_HRTF_FILTER_FORMAT_MSG = record
//    FilterMethod : TKSDS3DHRTFFilterMethod;
//    CoeffFormat  : TKSDS3DHRTFCoeffFormat;
//    Version      : TKSDS3DHRTFFilterVersion;
//    Reserved     : ULONG;
//  end;
//  {$EXTERNALSYM KSDS3D_HRTF_FILTER_FORMAT_MSG}
//  PKSDS3D_HRTF_FILTER_FORMAT_MSG = ^KSDS3D_HRTF_FILTER_FORMAT_MSG;
//  {$EXTERNALSYM PKSDS3D_HRTF_FILTER_FORMAT_MSG}
//  TKSDS3DHRTFFilterFormatMsg = KSDS3D_HRTF_FILTER_FORMAT_MSG;

//===========================================================================
// DirectSound3D HAL


  _DS3DVECTOR = record
    case integer of
    0: (
      x   : single;
      y   : single;
      z   : single);
    1: (
      dvX : single;
      dvY : single;
      dvZ : single);
    end;
  {$EXTERNALSYM _DS3DVECTOR}
  DS3DVECTOR = _DS3DVECTOR;
  {$EXTERNALSYM DS3DVECTOR}
  PDS3DVECTOR = ^DS3DVECTOR;
  {$EXTERNALSYM PDS3DVECTOR}
  TDS3DVector = DS3DVECTOR;

//===========================================================================
//===========================================================================

// KSPROPSETID_DirectSound3DListener : {437B3414-D060-11d0-8583-00C04FD9BAF3}
const
  KSPROPSETID_DirectSound3DListener : TGUID = '{437b3414-d060-11d0-8583-00c04fd9baf3}';
  {$EXTERNALSYM KSPROPSETID_DirectSound3DListener}

type
  KSPROPERTY_DIRECTSOUND3DLISTENER = (
    KSPROPERTY_DIRECTSOUND3DLISTENER_ALL,
    KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION,
    KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY,
    KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION,
    KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR,
    KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR,
    KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR,
    KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH,
    KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION
  );
  {$EXTERNALSYM KSPROPERTY_DIRECTSOUND3DLISTENER}
  TKSPropertyDirectSound3DListener = KSPROPERTY_DIRECTSOUND3DLISTENER;

  PKSDS3DListenerAll = ^TKSDS3DListenerAll;
  KSDS3D_LISTENER_ALL = record
    Position       : TDS3DVECTOR;
    Velocity       : TDS3DVECTOR;
    OrientFront    : TDS3DVECTOR;
    OrientTop      : TDS3DVECTOR;
    DistanceFactor : single;
    RolloffFactor  : single;
    DopplerFactor  : single;
  end;
  {$EXTERNALSYM KSDS3D_LISTENER_ALL}
  PKSDS3D_LISTENER_ALL = ^KSDS3D_LISTENER_ALL;
  {$EXTERNALSYM PKSDS3D_LISTENER_ALL}
  TKSDS3DListenerAll = KSDS3D_LISTENER_ALL;


  KSDS3D_LISTENER_ORIENTATION = record
    Front : TDS3DVECTOR;
    Top   : TDS3DVECTOR;
  end;
  {$EXTERNALSYM KSDS3D_LISTENER_ORIENTATION}
  PKSDS3D_LISTENER_ORIENTATION = ^KSDS3D_LISTENER_ORIENTATION;
  {$EXTERNALSYM PKSDS3D_LISTENER_ORIENTATION}
  TKSDS3DListenerOrientation = KSDS3D_LISTENER_ORIENTATION;

//===========================================================================
//===========================================================================
// KSPROPSETID_DirectSound3DBuffer : {437B3411-D060-11d0-8583-00C04FD9BAF3}
const
  KSPROPSETID_DirectSound3DBuffer : TGUID = '{437B3411-D060-11d0-8583-00C04FD9BAF3}';
  {$EXTERNALSYM KSPROPSETID_DirectSound3DBuffer}

type
  KSPROPERTY_DIRECTSOUND3DBUFFER = (
    KSPROPERTY_DIRECTSOUND3DBUFFER_ALL,
    KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION,
    KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY,
    KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES,
    KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION,
    KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME,
    KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE,
    KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE,
    KSPROPERTY_DIRECTSOUND3DBUFFER_MODE
  );
  {$EXTERNALSYM KSPROPERTY_DIRECTSOUND3DBUFFER}
  TKSPropertyDirectSound3DBuffer = KSPROPERTY_DIRECTSOUND3DBUFFER;

  KSDS3D_BUFFER_ALL = record
    Position          : TDS3DVECTOR;
    Velocity          : TDS3DVECTOR;
    InsideConeAngle   : ULONG;
    OutsideConeAngle  : ULONG;
    ConeOrientation   : TDS3DVECTOR;
    ConeOutsideVolume : longint;
    MinDistance       : single;
    MaxDistance       : single;
    Mode              : ULONG;
  end;
  {$EXTERNALSYM KSDS3D_BUFFER_ALL}
  PKSDS3D_BUFFER_ALL = ^KSDS3D_BUFFER_ALL;
  {$EXTERNALSYM PKSDS3D_BUFFER_ALL}
  TKSDS3DBufferAll = KSDS3D_BUFFER_ALL;

  KSDS3D_BUFFER_CONE_ANGLES = record
    InsideConeAngle  : ULONG;
    OutsideConeAngle : ULONG;
  end;
  {$EXTERNALSYM KSDS3D_BUFFER_CONE_ANGLES}
  PKSDS3D_BUFFER_CONE_ANGLES = ^KSDS3D_BUFFER_CONE_ANGLES;
  {$EXTERNALSYM PKSDS3D_BUFFER_CONE_ANGLES}
  TKSDS3DBufferConeAngles = KSDS3D_BUFFER_CONE_ANGLES;

const
  KSAUDIO_STEREO_SPEAKER_GEOMETRY_HEADPHONE = -1;
  {$EXTERNALSYM KSAUDIO_STEREO_SPEAKER_GEOMETRY_HEADPHONE}
  KSAUDIO_STEREO_SPEAKER_GEOMETRY_MIN       = 5;
  {$EXTERNALSYM KSAUDIO_STEREO_SPEAKER_GEOMETRY_MIN}
  KSAUDIO_STEREO_SPEAKER_GEOMETRY_NARROW    = 10;
  {$EXTERNALSYM KSAUDIO_STEREO_SPEAKER_GEOMETRY_NARROW}
  KSAUDIO_STEREO_SPEAKER_GEOMETRY_WIDE      = 20;
  {$EXTERNALSYM KSAUDIO_STEREO_SPEAKER_GEOMETRY_WIDE}
  KSAUDIO_STEREO_SPEAKER_GEOMETRY_MAX       = 180;
  {$EXTERNALSYM KSAUDIO_STEREO_SPEAKER_GEOMETRY_MAX}

  KSDSOUND_3D_MODE_NORMAL       = $00000000;
  {$EXTERNALSYM KSDSOUND_3D_MODE_NORMAL}
  KSDSOUND_3D_MODE_HEADRELATIVE = $00000001;
  {$EXTERNALSYM KSDSOUND_3D_MODE_HEADRELATIVE}
  KSDSOUND_3D_MODE_DISABLE      = $00000002;
  {$EXTERNALSYM KSDSOUND_3D_MODE_DISABLE}

type
  KSDATARANGE_AUDIO = record
    DataRange              : TKSDataRange;
    MaximumChannels        : ULONG;
    MinimumBitsPerSample   : ULONG;
    MaximumBitsPerSample   : ULONG;
    MinimumSampleFrequency : ULONG;
    MaximumSampleFrequency : ULONG;
  end;
  {$EXTERNALSYM KSDATARANGE_AUDIO}
  PKSDATARANGE_AUDIO = ^KSDATARANGE_AUDIO;
  {$EXTERNALSYM PKSDATARANGE_AUDIO}
  TKSDataRangeAudio = KSDATARANGE_AUDIO;

//---------------------------------------------------------------------------
const
  KSDATAFORMAT_SUBTYPE_RIFF     : TGUID = '{4995DAEE-9EE6-11D0-A40E-00A0C9223196}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_RIFF}
  KSDATAFORMAT_SUBTYPE_RIFFWAVE : TGUID = '{e436eb8b-524f-11ce-9f53-0020af0ba770}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_RIFFWAVE}

//===========================================================================
//===========================================================================

  KSPROPSETID_Bibliographic     : TGUID = '{07BA150E-E2B1-11D0-AC17-00A0C9223196}';
  {$EXTERNALSYM KSPROPSETID_Bibliographic}

//Repeatable tags contain all entries within the property, each preceeded by length
type
  KSPROPERTY_BIBLIOGRAPHIC = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC}
  const
    KSPROPERTY_BIBLIOGRAPHIC_LEADER                      = 'RDL ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_LEADER}
    KSPROPERTY_BIBLIOGRAPHIC_LCCN                        = '010 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_LCCN}
    KSPROPERTY_BIBLIOGRAPHIC_ISBN                        = '020 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_ISBN}
    KSPROPERTY_BIBLIOGRAPHIC_ISSN                        = '220 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_ISSN}
    KSPROPERTY_BIBLIOGRAPHIC_CATALOGINGSOURCE            = '040 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_CATALOGINGSOURCE}
    KSPROPERTY_BIBLIOGRAPHIC_MAINPERSONALNAME            = '001 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_MAINPERSONALNAME}
    KSPROPERTY_BIBLIOGRAPHIC_MAINCORPORATEBODY           = '011 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_MAINCORPORATEBODY}
    KSPROPERTY_BIBLIOGRAPHIC_MAINMEETINGNAME             = '111 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_MAINMEETINGNAME}
    KSPROPERTY_BIBLIOGRAPHIC_MAINUNIFORMTITLE            = '031 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_MAINUNIFORMTITLE}
    KSPROPERTY_BIBLIOGRAPHIC_UNIFORMTITLE                = '042 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_UNIFORMTITLE}
    KSPROPERTY_BIBLIOGRAPHIC_TITLESTATEMENT              = '542 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_TITLESTATEMENT}
    KSPROPERTY_BIBLIOGRAPHIC_VARYINGFORMTITLE            = '642 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_VARYINGFORMTITLE}
    KSPROPERTY_BIBLIOGRAPHIC_PUBLICATION                 = '062 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_PUBLICATION}
    KSPROPERTY_BIBLIOGRAPHIC_PHYSICALDESCRIPTION         = '003 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_PHYSICALDESCRIPTION}
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYTITLE             = '044 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYTITLE}
    KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENT             = '094 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENT}
    KSPROPERTY_BIBLIOGRAPHIC_GENERALNOTE                 = '005 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_GENERALNOTE}
    KSPROPERTY_BIBLIOGRAPHIC_BIBLIOGRAPHYNOTE            = '405 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_BIBLIOGRAPHYNOTE}
    KSPROPERTY_BIBLIOGRAPHIC_CONTENTSNOTE                = '505 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_CONTENTSNOTE}
    KSPROPERTY_BIBLIOGRAPHIC_CREATIONCREDIT              = '805 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_CREATIONCREDIT}
    KSPROPERTY_BIBLIOGRAPHIC_CITATION                    = '015 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_CITATION}
    KSPROPERTY_BIBLIOGRAPHIC_PARTICIPANT                 = '115 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_PARTICIPANT}
    KSPROPERTY_BIBLIOGRAPHIC_SUMMARY                     = '025 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_SUMMARY}
    KSPROPERTY_BIBLIOGRAPHIC_TARGETAUDIENCE              = '125 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_TARGETAUDIENCE}
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDFORMAVAILABLE          = '035 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_ADDEDFORMAVAILABLE}
    KSPROPERTY_BIBLIOGRAPHIC_SYSTEMDETAILS               = '835 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_SYSTEMDETAILS}
    KSPROPERTY_BIBLIOGRAPHIC_AWARDS                      = '685 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_AWARDS}
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYPERSONALNAME      = '006 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYPERSONALNAME}
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYTOPICALTERM       = '056 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYTOPICALTERM}
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYGEOGRAPHIC        = '156 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYGEOGRAPHIC}
    KSPROPERTY_BIBLIOGRAPHIC_INDEXTERMGENRE              = '556 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_INDEXTERMGENRE}
    KSPROPERTY_BIBLIOGRAPHIC_INDEXTERMCURRICULUM         = '856 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_INDEXTERMCURRICULUM}
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYUNIFORMTITLE      = '037 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYUNIFORMTITLE}
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYRELATED           = '047 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYRELATED}
    KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENTPERSONALNAME = '008 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENTPERSONALNAME}
    KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENTUNIFORMTITLE = '038 ';
    {$EXTERNALSYM KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENTUNIFORMTITLE}

  KSPROPSETID_TopologyNode : TGUID = '{45FFAAA1-6E1B-11D0-BCF2-444553540000}';
  {$EXTERNALSYM KSPROPSETID_TopologyNode}

type
  KSPROPERTY_TOPOLOGYNODE = (
  {$IFNDEF COMPILER6_UP}
    KSPROPERTY_TOPOLOGYNODE_INVALID_0,
    KSPROPERTY_TOPOLOGYNODE_ENABLE,
    KSPROPERTY_TOPOLOGYNODE_RESET
  {$ELSE}
    KSPROPERTY_TOPOLOGYNODE_ENABLE = 1,
    KSPROPERTY_TOPOLOGYNODE_RESET  = 2
  {$ENDIF}
  );
  {$EXTERNALSYM KSPROPERTY_TOPOLOGYNODE}
  TKSPropertyTopologyNode = KSPROPERTY_TOPOLOGYNODE;

//===========================================================================
const
  KSPROPSETID_DrmAudioStream : TGUID = '{2F2C8DDD-4198-4fac-BA29-61BB05B7DE06}';
  {$EXTERNALSYM KSPROPSETID_DrmAudioStream}

type
  KSPROPERTY_DRMAUDIOSTREAM = (
    KSPROPERTY_DRMAUDIOSTREAM_CONTENTID,
    KSPROPERTY_DRMAUDIOSTREAM_AUTHENTICATEFUNCTION
  );
  {$EXTERNALSYM KSPROPERTY_DRMAUDIOSTREAM}
  TKSPRopertyDRMAudioStream = KSPROPERTY_DRMAUDIOSTREAM;

//===========================================================================
const
  KSPROPSETID_Audio : TGUID = '{45FFAAA0-6E1B-11D0-BCF2-444553540000}';
  {$EXTERNALSYM KSPROPSETID_Audio}

type
  KSPROPERTY_AUDIO = (
  {$IFNDEF COMPILER6_UP}
    KSPROPERTY_AUDIO_INVALID_0,
    KSPROPERTY_AUDIO_LATENCY,
  {$ELSE}
    KSPROPERTY_AUDIO_LATENCY = 1,
  {$ENDIF}
    KSPROPERTY_AUDIO_COPY_PROTECTION,
    KSPROPERTY_AUDIO_CHANNEL_CONFIG,
    KSPROPERTY_AUDIO_VOLUMELEVEL,
    KSPROPERTY_AUDIO_POSITION,
    KSPROPERTY_AUDIO_DYNAMIC_RANGE,
    KSPROPERTY_AUDIO_QUALITY,
    KSPROPERTY_AUDIO_SAMPLING_RATE,
    KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE,
    KSPROPERTY_AUDIO_MIX_LEVEL_TABLE,
    KSPROPERTY_AUDIO_MIX_LEVEL_CAPS,
    KSPROPERTY_AUDIO_MUX_SOURCE,
    KSPROPERTY_AUDIO_MUTE,
    KSPROPERTY_AUDIO_BASS,
    KSPROPERTY_AUDIO_MID,
    KSPROPERTY_AUDIO_TREBLE,
    KSPROPERTY_AUDIO_BASS_BOOST,
    KSPROPERTY_AUDIO_EQ_LEVEL,
    KSPROPERTY_AUDIO_NUM_EQ_BANDS,
    KSPROPERTY_AUDIO_EQ_BANDS,
    KSPROPERTY_AUDIO_AGC,
    KSPROPERTY_AUDIO_DELAY,
    KSPROPERTY_AUDIO_LOUDNESS,
    KSPROPERTY_AUDIO_WIDE_MODE,
    KSPROPERTY_AUDIO_WIDENESS,
    KSPROPERTY_AUDIO_REVERB_LEVEL,
    KSPROPERTY_AUDIO_CHORUS_LEVEL,
    KSPROPERTY_AUDIO_DEV_SPECIFIC,
    KSPROPERTY_AUDIO_DEMUX_DEST,
    KSPROPERTY_AUDIO_STEREO_ENHANCE,
    KSPROPERTY_AUDIO_MANUFACTURE_GUID,
    KSPROPERTY_AUDIO_PRODUCT_GUID,
    KSPROPERTY_AUDIO_CPU_RESOURCES,
    KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY,
    KSPROPERTY_AUDIO_SURROUND_ENCODE,
    KSPROPERTY_AUDIO_3D_INTERFACE,
    KSPROPERTY_AUDIO_PEAKMETER,
    KSPROPERTY_AUDIO_ALGORITHM_INSTANCE
  );
  {$EXTERNALSYM KSPROPERTY_AUDIO}
  TKSPropertyAudio = KSPROPERTY_AUDIO;

// Audio quality constants
const
  KSAUDIO_QUALITY_WORST    = $0;
  {$EXTERNALSYM KSAUDIO_QUALITY_WORST}
  KSAUDIO_QUALITY_PC       = $1;
  {$EXTERNALSYM KSAUDIO_QUALITY_PC}
  KSAUDIO_QUALITY_BASIC    = $2;
  {$EXTERNALSYM KSAUDIO_QUALITY_BASIC}
  KSAUDIO_QUALITY_ADVANCED = $3;
  {$EXTERNALSYM KSAUDIO_QUALITY_ADVANCED}

// Audio CPU resource constants
  KSAUDIO_CPU_RESOURCES_NOT_HOST_CPU = $00000000;
  {$EXTERNALSYM KSAUDIO_CPU_RESOURCES_NOT_HOST_CPU}
  KSAUDIO_CPU_RESOURCES_HOST_CPU     = $7FFFFFFF;
  {$EXTERNALSYM KSAUDIO_CPU_RESOURCES_HOST_CPU}

type
  PKSAudioCopyProtection = ^TKSAudioCopyProtection;
  KSAUDIO_COPY_PROTECTION = record
    fCopyrighted : BOOL;
    fOriginal    : BOOL;
  end;
  {$EXTERNALSYM KSAUDIO_COPY_PROTECTION}
  PKSAUDIO_COPY_PROTECTION = ^KSAUDIO_COPY_PROTECTION;
  {$EXTERNALSYM PKSAUDIO_COPY_PROTECTION}
  TKSAudioCopyProtection = KSAUDIO_COPY_PROTECTION;

  PKSAudioChannelConfig = ^TKSAudioChannelConfig;
  KSAUDIO_CHANNEL_CONFIG = record
    ActiveSpeakerPositions : Longint;
  end;
  {$EXTERNALSYM KSAUDIO_CHANNEL_CONFIG}
  PKSAUDIO_CHANNEL_CONFIG = ^KSAUDIO_CHANNEL_CONFIG;
  {$EXTERNALSYM PKSAUDIO_CHANNEL_CONFIG}
  TKSAudioChannelConfig = KSAUDIO_CHANNEL_CONFIG;

// Speaker Positions:
const
  SPEAKER_FRONT_LEFT            = $1;
  {$EXTERNALSYM SPEAKER_FRONT_LEFT}
  SPEAKER_FRONT_RIGHT           = $2;
  {$EXTERNALSYM SPEAKER_FRONT_RIGHT}
  SPEAKER_FRONT_CENTER          = $4;
  {$EXTERNALSYM SPEAKER_FRONT_CENTER}
  SPEAKER_LOW_FREQUENCY         = $8;
  {$EXTERNALSYM SPEAKER_LOW_FREQUENCY}
  SPEAKER_BACK_LEFT             = $10;
  {$EXTERNALSYM SPEAKER_BACK_LEFT}
  SPEAKER_BACK_RIGHT            = $20;
  {$EXTERNALSYM SPEAKER_BACK_RIGHT}
  SPEAKER_FRONT_LEFT_OF_CENTER  = $40;
  {$EXTERNALSYM SPEAKER_FRONT_LEFT_OF_CENTER}
  SPEAKER_FRONT_RIGHT_OF_CENTER = $80;
  {$EXTERNALSYM SPEAKER_FRONT_RIGHT_OF_CENTER}
  SPEAKER_BACK_CENTER           = $100;
  {$EXTERNALSYM SPEAKER_BACK_CENTER}
  SPEAKER_SIDE_LEFT             = $200;
  {$EXTERNALSYM SPEAKER_SIDE_LEFT}
  SPEAKER_SIDE_RIGHT            = $400;
  {$EXTERNALSYM SPEAKER_SIDE_RIGHT}
  SPEAKER_TOP_CENTER            = $800;
  {$EXTERNALSYM SPEAKER_TOP_CENTER}
  SPEAKER_TOP_FRONT_LEFT        = $1000;
  {$EXTERNALSYM SPEAKER_TOP_FRONT_LEFT}
  SPEAKER_TOP_FRONT_CENTER      = $2000;
  {$EXTERNALSYM SPEAKER_TOP_FRONT_CENTER}
  SPEAKER_TOP_FRONT_RIGHT       = $4000;
  {$EXTERNALSYM SPEAKER_TOP_FRONT_RIGHT}
  SPEAKER_TOP_BACK_LEFT         = $8000;
  {$EXTERNALSYM SPEAKER_TOP_BACK_LEFT}
  SPEAKER_TOP_BACK_CENTER       = $10000;
  {$EXTERNALSYM SPEAKER_TOP_BACK_CENTER}
  SPEAKER_TOP_BACK_RIGHT        = $20000;
  {$EXTERNALSYM SPEAKER_TOP_BACK_RIGHT}

// Bit mask locations reserved for future use
  SPEAKER_RESERVED  = $7FFC0000;
  {$EXTERNALSYM SPEAKER_RESERVED}

// Used to specify that any possible permutation of speaker configurations
  SPEAKER_ALL       = $80000000;
  {$EXTERNALSYM SPEAKER_ALL}

// DirectSound Speaker Config
  KSAUDIO_SPEAKER_MONO     =       (SPEAKER_FRONT_CENTER);
  {$EXTERNALSYM KSAUDIO_SPEAKER_MONO}
  KSAUDIO_SPEAKER_STEREO   =       (SPEAKER_FRONT_LEFT           or SPEAKER_FRONT_RIGHT);
  {$EXTERNALSYM KSAUDIO_SPEAKER_STEREO}
  KSAUDIO_SPEAKER_QUAD     =       (SPEAKER_FRONT_LEFT           or SPEAKER_FRONT_RIGHT or
                                    SPEAKER_BACK_LEFT            or SPEAKER_BACK_RIGHT);
  {$EXTERNALSYM KSAUDIO_SPEAKER_QUAD}
  KSAUDIO_SPEAKER_SURROUND =       (SPEAKER_FRONT_LEFT           or SPEAKER_FRONT_RIGHT or
                                    SPEAKER_FRONT_CENTER         or SPEAKER_BACK_CENTER);
  {$EXTERNALSYM KSAUDIO_SPEAKER_SURROUND}
  KSAUDIO_SPEAKER_5POINT1  =       (SPEAKER_FRONT_LEFT           or SPEAKER_FRONT_RIGHT or
                                    SPEAKER_FRONT_CENTER         or SPEAKER_LOW_FREQUENCY or
                                    SPEAKER_BACK_LEFT            or SPEAKER_BACK_RIGHT);
  {$EXTERNALSYM KSAUDIO_SPEAKER_5POINT1}
  KSAUDIO_SPEAKER_7POINT1  =       (SPEAKER_FRONT_LEFT           or SPEAKER_FRONT_RIGHT or
                                    SPEAKER_FRONT_CENTER         or SPEAKER_LOW_FREQUENCY or
                                    SPEAKER_BACK_LEFT            or SPEAKER_BACK_RIGHT or
                                    SPEAKER_FRONT_LEFT_OF_CENTER or SPEAKER_FRONT_RIGHT_OF_CENTER);
  {$EXTERNALSYM KSAUDIO_SPEAKER_7POINT1}
  KSAUDIO_SPEAKER_5POINT1_SURROUND = (SPEAKER_FRONT_LEFT or SPEAKER_FRONT_RIGHT or
                                      SPEAKER_FRONT_CENTER or SPEAKER_LOW_FREQUENCY or
                                         SPEAKER_SIDE_LEFT  or SPEAKER_SIDE_RIGHT);
  {$EXTERNALSYM KSAUDIO_SPEAKER_5POINT1_SURROUND}
  KSAUDIO_SPEAKER_7POINT1_SURROUND = (SPEAKER_FRONT_LEFT or SPEAKER_FRONT_RIGHT or
                                         SPEAKER_FRONT_CENTER or SPEAKER_LOW_FREQUENCY or
                                         SPEAKER_BACK_LEFT or SPEAKER_BACK_RIGHT or
                                         SPEAKER_SIDE_LEFT or SPEAKER_SIDE_RIGHT);
  {$EXTERNALSYM KSAUDIO_SPEAKER_7POINT1_SURROUND}
// The following are obsolete 5.1 and 7.1 settings (they lack side speakers).  Note this means
// that the default 5.1 and 7.1 settings (KSAUDIO_SPEAKER_5POINT1 and KSAUDIO_SPEAKER_7POINT1 are
// similarly obsolete but are unchanged for compatibility reasons).
  KSAUDIO_SPEAKER_5POINT1_BACK = KSAUDIO_SPEAKER_5POINT1;
  {$EXTERNALSYM KSAUDIO_SPEAKER_5POINT1_BACK}
  KSAUDIO_SPEAKER_7POINT1_WIDE = KSAUDIO_SPEAKER_7POINT1;
  {$EXTERNALSYM KSAUDIO_SPEAKER_7POINT1_WIDE}


// DVD Speaker Positions
  KSAUDIO_SPEAKER_GROUND_FRONT_LEFT   = SPEAKER_FRONT_LEFT;
  {$EXTERNALSYM KSAUDIO_SPEAKER_GROUND_FRONT_LEFT}
  KSAUDIO_SPEAKER_GROUND_FRONT_CENTER = SPEAKER_FRONT_CENTER;
  {$EXTERNALSYM KSAUDIO_SPEAKER_GROUND_FRONT_CENTER}
  KSAUDIO_SPEAKER_GROUND_FRONT_RIGHT  = SPEAKER_FRONT_RIGHT;
  {$EXTERNALSYM KSAUDIO_SPEAKER_GROUND_FRONT_RIGHT}
  KSAUDIO_SPEAKER_GROUND_REAR_LEFT    = SPEAKER_BACK_LEFT;
  {$EXTERNALSYM KSAUDIO_SPEAKER_GROUND_REAR_LEFT}
  KSAUDIO_SPEAKER_GROUND_REAR_RIGHT   = SPEAKER_BACK_RIGHT;
  {$EXTERNALSYM KSAUDIO_SPEAKER_GROUND_REAR_RIGHT}
  KSAUDIO_SPEAKER_TOP_MIDDLE          = SPEAKER_TOP_CENTER;
  {$EXTERNALSYM KSAUDIO_SPEAKER_TOP_MIDDLE}
  KSAUDIO_SPEAKER_SUPER_WOOFER        = SPEAKER_LOW_FREQUENCY;
  {$EXTERNALSYM KSAUDIO_SPEAKER_SUPER_WOOFER}

type
  PKSAudioDynamicRange = ^TKSAudioDynamicRange;
  KSAUDIO_DYNAMIC_RANGE = record
    QuietCompression : ULONG;
    LoudCompression  : ULONG;
  end;
  {$EXTERNALSYM KSAUDIO_DYNAMIC_RANGE}
  PKSAUDIO_DYNAMIC_RANGE = ^KSAUDIO_DYNAMIC_RANGE;
  {$EXTERNALSYM PKSAUDIO_DYNAMIC_RANGE}
  TKSAudioDynamicRange = KSAUDIO_DYNAMIC_RANGE;

  PKSAudioMixLevel = ^TKSAudioMixLevel;
  KSAUDIO_MIXLEVEL = record
    Mute  : BOOL;
    Level : Longint;
  end;
  {$EXTERNALSYM KSAUDIO_MIXLEVEL}
  PKSAUDIO_MIXLEVEL = ^KSAUDIO_MIXLEVEL;
  {$EXTERNALSYM PKSAUDIO_MIXLEVEL}
  TKSAudioMixLevel = KSAUDIO_MIXLEVEL;

  PKSAudioMixCaps = ^TKSAudioMixCaps;
  KSAUDIO_MIX_CAPS = record
    Mute    : BOOL;
    Minimum : longint;
    Maximum : longint;
    Reset   : longint;
  end;
  {$EXTERNALSYM KSAUDIO_MIX_CAPS}
  PKSAUDIO_MIX_CAPS = ^KSAUDIO_MIX_CAPS;
  {$EXTERNALSYM PKSAUDIO_MIX_CAPS}
  TKSAudioMixCaps = KSAUDIO_MIX_CAPS;

  PKSaudioMixcapTable = ^TKSaudioMixcapTable;
  KSAUDIO_MIXCAP_TABLE = record
    InputChannels  : ULONG;
    OutputChannels : ULONG;
    Capabilities   : array[0..0] of TKSAudioMixCaps;
  end;
  {$EXTERNALSYM KSAUDIO_MIXCAP_TABLE}
  PKSAUDIO_MIXCAP_TABLE = ^KSAUDIO_MIXCAP_TABLE;
  {$EXTERNALSYM PKSAUDIO_MIXCAP_TABLE}
  TKSaudioMixcapTable = KSAUDIO_MIXCAP_TABLE;

  SE_TECHNIQUE = (
    SE_TECH_NONE,
    SE_TECH_ANALOG_DEVICES_PHAT,
    SE_TECH_CREATIVE,
    SE_TECH_NATIONAL_SEMI,
    SE_TECH_YAMAHA_YMERSION,
    SE_TECH_BBE,
    SE_TECH_CRYSTAL_SEMI,
    SE_TECH_QSOUND_QXPANDER,
    SE_TECH_SPATIALIZER,
    SE_TECH_SRS,
    SE_TECH_PLATFORM_TECH,
    SE_TECH_AKM,
    SE_TECH_AUREAL,
    SE_TECH_AZTECH,
    SE_TECH_BINAURA,
    SE_TECH_ESS_TECH,
    SE_TECH_HARMAN_VMAX,
    SE_TECH_NVIDEA,
    SE_TECH_PHILIPS_INCREDIBLE,
    SE_TECH_TEXAS_INST,
    SE_TECH_VLSI_TECH
  );
  {$EXTERNALSYM SE_TECHNIQUE}
  TSETechnique = SE_TECHNIQUE;

  PKSAudioStereoEnhance = ^TKSAudioStereoEnhance;
  KSAUDIO_STEREO_ENHANCE = record
    Technique : TSETechnique;
    Center    : ULONG;
    Depth     : ULONG;
    Reserved  : ULONG;
  end;
  {$EXTERNALSYM KSAUDIO_STEREO_ENHANCE}
  PKSAUDIO_STEREO_ENHANCE = ^KSAUDIO_STEREO_ENHANCE;
  {$EXTERNALSYM PKSAUDIO_STEREO_ENHANCE}
  TKSAudioStereoEnhance = KSAUDIO_STEREO_ENHANCE;

//===========================================================================
// Topology Node Type GUIDs
const
  KSNODETYPE_DAC                        : TGUID = '{507AE360-C554-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_DAC}
  KSNODETYPE_ADC                        : TGUID = '{4D837FE0-C555-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_ADC}
  KSNODETYPE_SRC                        : TGUID = '{9DB7B9E0-C555-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_SRC}
  KSNODETYPE_SUPERMIX                   : TGUID = '{E573ADC0-C555-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_SUPERMIX}
  KSNODETYPE_MUX                        : TGUID = '{2CEAF780-C556-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_MUX}
  KSNODETYPE_DEMUX                      : TGUID = '{C0EB67D4-E807-11D0-958A-00C04FB925D3}';
  {$EXTERNALSYM KSNODETYPE_DEMUX}
  KSNODETYPE_SUM                        : TGUID = '{DA441A60-C556-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_SUM}
  KSNODETYPE_MUTE                       : TGUID = '{02B223C0-C557-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_MUTE}
  KSNODETYPE_VOLUME                     : TGUID = '{3A5ACC00-C557-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_VOLUME}
  KSNODETYPE_TONE                       : TGUID = '{7607E580-C557-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_TONE}
  KSNODETYPE_EQUALIZER                  : TGUID = '{9D41B4A0-C557-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_EQUALIZER}
  KSNODETYPE_AGC                        : TGUID = '{E88C9BA0-C557-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_AGC}
  KSNODETYPE_NOISE_SUPPRESS             : TGUID = '{E07F903F-62FD-4e60-8CDD-DEA7236665B5}';
  {$EXTERNALSYM KSNODETYPE_NOISE_SUPPRESS}
  KSNODETYPE_DELAY                      : TGUID = '{144981E0-C558-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_DELAY}
  KSNODETYPE_LOUDNESS                   : TGUID = '{41887440-C558-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_LOUDNESS}
  KSNODETYPE_PROLOGIC_DECODER           : TGUID = '{831C2C80-C558-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_PROLOGIC_DECODER}
  KSNODETYPE_STEREO_WIDE                : TGUID = '{A9E69800-C558-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_STEREO_WIDE}
  KSNODETYPE_STEREO_ENHANCE             : TGUID = '{AF6878AC-E83F-11D0-958A-00C04FB925D3}';
  {$EXTERNALSYM KSNODETYPE_STEREO_ENHANCE}
  KSNODETYPE_REVERB                     : TGUID = '{EF0328E0-C558-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_REVERB}
  KSNODETYPE_CHORUS                     : TGUID = '{20173F20-C559-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_CHORUS}
  KSNODETYPE_3D_EFFECTS                 : TGUID = '{55515860-C559-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_3D_EFFECTS}

  KSNODETYPE_ACOUSTIC_ECHO_CANCEL       : TGUID = '{BF963D80-C559-11D0-8A2B-00A0C9255AC1}'; //KSCATEGORY_ACOUSTIC_ECHO_CANCEL
  {$EXTERNALSYM KSNODETYPE_ACOUSTIC_ECHO_CANCEL}
  KSNODETYPE_MICROPHONE_ARRAY_PROCESSOR : TGUID = '{830a44f2-a32d-476b-be97-42845673b35a}'; //KSCATEGORY_MICROPHONE_ARRAY_PROCESSOR
  {$EXTERNALSYM KSNODETYPE_MICROPHONE_ARRAY_PROCESSOR}

  KSNODETYPE_DEV_SPECIFIC               : TGUID = '{941C7AC0-C559-11D0-8A2B-00A0C9255AC1}';
  {$EXTERNALSYM KSNODETYPE_DEV_SPECIFIC}
  KSNODETYPE_SURROUND_ENCODER           : TGUID = '{8074C5B2-3C66-11D2-B45A-3078302C2030}';
  {$EXTERNALSYM KSNODETYPE_SURROUND_ENCODER}
  KSNODETYPE_PEAKMETER                  : TGUID = '{A085651E-5F0D-4b36-A869-D195D6AB4B9E}';
  {$EXTERNALSYM KSNODETYPE_PEAKMETER}

//===========================================================================
// Topology Node Name GUIDs for common audio nodes
  KSAUDFNAME_BASS                       : TGUID = '{185FEDE0-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_BASS}
  KSAUDFNAME_TREBLE                     : TGUID = '{185FEDE1-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_TREBLE}
  KSAUDFNAME_3D_STEREO                  : TGUID = '{185FEDE2-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_3D_STEREO}
  KSAUDFNAME_MASTER_VOLUME              : TGUID = '{185FEDE3-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_MASTER_VOLUME}
  KSAUDFNAME_MASTER_MUTE                : TGUID = '{185FEDE4-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_MASTER_MUTE}
  KSAUDFNAME_WAVE_VOLUME                : TGUID = '{185FEDE5-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_WAVE_VOLUME}
  KSAUDFNAME_WAVE_MUTE                  : TGUID = '{185FEDE6-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_WAVE_MUTE}
  KSAUDFNAME_MIDI_VOLUME                : TGUID = '{185FEDE7-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_MIDI_VOLUME}
  KSAUDFNAME_MIDI_MUTE                  : TGUID = '{185FEDE8-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_MIDI_MUTE}
  KSAUDFNAME_CD_VOLUME                  : TGUID = '{185FEDE9-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_CD_VOLUME}
  KSAUDFNAME_CD_MUTE                    : TGUID = '{185FEDEA-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_CD_MUTE}
  KSAUDFNAME_LINE_VOLUME                : TGUID = '{185FEDEB-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_LINE_VOLUME}
  KSAUDFNAME_LINE_MUTE                  : TGUID = '{185FEDEC-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_LINE_MUTE}
  KSAUDFNAME_MIC_VOLUME                 : TGUID = '{185FEDED-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_MIC_VOLUME}
  KSAUDFNAME_MIC_MUTE                   : TGUID = '{185FEDEE-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_MIC_MUTE}
  KSAUDFNAME_RECORDING_SOURCE           : TGUID = '{185FEDEF-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_RECORDING_SOURCE}
  KSAUDFNAME_PC_SPEAKER_VOLUME          : TGUID = '{185FEDF0-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_PC_SPEAKER_VOLUME}
  KSAUDFNAME_PC_SPEAKER_MUTE            : TGUID = '{185FEDF1-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_PC_SPEAKER_MUTE}
  KSAUDFNAME_MIDI_IN_VOLUME             : TGUID = '{185FEDF2-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_MIDI_IN_VOLUME}
  KSAUDFNAME_CD_IN_VOLUME               : TGUID = '{185FEDF3-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_CD_IN_VOLUME}
  KSAUDFNAME_LINE_IN_VOLUME             : TGUID = '{185FEDF4-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_LINE_IN_VOLUME}
  KSAUDFNAME_MIC_IN_VOLUME              : TGUID = '{185FEDF5-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_MIC_IN_VOLUME}
  KSAUDFNAME_WAVE_IN_VOLUME             : TGUID = '{185FEDF6-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_WAVE_IN_VOLUME}
  KSAUDFNAME_VOLUME_CONTROL             : TGUID = '{185FEDF7-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_VOLUME_CONTROL}
  KSAUDFNAME_MIDI                       : TGUID = '{185FEDF8-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_MIDI}
  KSAUDFNAME_LINE_IN                    : TGUID = '{185FEDF9-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_LINE_IN}
  KSAUDFNAME_RECORDING_CONTROL          : TGUID = '{185FEDFA-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_RECORDING_CONTROL}
  KSAUDFNAME_CD_AUDIO                   : TGUID = '{185FEDFB-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_CD_AUDIO}
  KSAUDFNAME_AUX_VOLUME                 : TGUID = '{185FEDFC-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_AUX_VOLUME}
  KSAUDFNAME_AUX_MUTE                   : TGUID = '{185FEDFD-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_AUX_MUTE}
  KSAUDFNAME_AUX                        : TGUID = '{185FEDFE-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_AUX}
  KSAUDFNAME_PC_SPEAKER                 : TGUID = '{185FEDFF-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_PC_SPEAKER}
  KSAUDFNAME_WAVE_OUT_MIX               : TGUID = '{185FEE00-9905-11D1-95A9-00C04FB925D3}';
  {$EXTERNALSYM KSAUDFNAME_WAVE_OUT_MIX}
  KSAUDFNAME_MONO_OUT                   : TGUID = '{F9B41DC3-96E2-11d2-AC4C-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_MONO_OUT}
  KSAUDFNAME_STEREO_MIX                 : TGUID = '{00DFF077-96E3-11d2-AC4C-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_STEREO_MIX}
  KSAUDFNAME_MONO_MIX                   : TGUID = '{00DFF078-96E3-11d2-AC4C-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_MONO_MIX}
  KSAUDFNAME_MONO_OUT_VOLUME            : TGUID = '{1AD247EB-96E3-11d2-AC4C-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_MONO_OUT_VOLUME}
  KSAUDFNAME_MONO_OUT_MUTE              : TGUID = '{1AD247EC-96E3-11d2-AC4C-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_MONO_OUT_MUTE}
  KSAUDFNAME_STEREO_MIX_VOLUME          : TGUID = '{1AD247ED-96E3-11d2-AC4C-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_STEREO_MIX_VOLUME}
  KSAUDFNAME_STEREO_MIX_MUTE            : TGUID = '{22B0EAFD-96E3-11d2-AC4C-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_STEREO_MIX_MUTE}
  KSAUDFNAME_MONO_MIX_VOLUME            : TGUID = '{22B0EAFE-96E3-11d2-AC4C-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_MONO_MIX_VOLUME}
  KSAUDFNAME_MONO_MIX_MUTE              : TGUID = '{2BC31D69-96E3-11d2-AC4C-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_MONO_MIX_MUTE}
  KSAUDFNAME_MICROPHONE_BOOST           : TGUID = '{2BC31D6A-96E3-11d2-AC4C-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_MICROPHONE_BOOST}
  KSAUDFNAME_ALTERNATE_MICROPHONE       : TGUID = '{2BC31D6B-96E3-11d2-AC4C-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_ALTERNATE_MICROPHONE}
  KSAUDFNAME_3D_DEPTH                   : TGUID = '{63FF5747-991F-11d2-AC4D-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_3D_DEPTH}
  KSAUDFNAME_3D_CENTER                  : TGUID = '{9F0670B4-991F-11d2-AC4D-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_3D_CENTER}
  KSAUDFNAME_VIDEO_VOLUME               : TGUID = '{9B46E708-992A-11d2-AC4D-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_VIDEO_VOLUME}
  KSAUDFNAME_VIDEO_MUTE                 : TGUID = '{9B46E709-992A-11d2-AC4D-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_VIDEO_MUTE}
  KSAUDFNAME_VIDEO                      : TGUID = '{915DAEC4-A434-11d2-AC52-00C04F8EFB68}';
  {$EXTERNALSYM KSAUDFNAME_VIDEO}
  KSAUDFNAME_PEAKMETER                  : TGUID = '{57E24340-FC5B-4612-A562-72B11A29DFAE}';
  {$EXTERNALSYM KSAUDFNAME_PEAKMETER}

// Internal topology node pin definitions

  KSNODEPIN_STANDARD_IN     = 1;
  {$EXTERNALSYM KSNODEPIN_STANDARD_IN}
  KSNODEPIN_STANDARD_OUT    = 0;
  {$EXTERNALSYM KSNODEPIN_STANDARD_OUT}

  KSNODEPIN_SUM_MUX_IN      = 1; // can be >= 1
  {$EXTERNALSYM KSNODEPIN_SUM_MUX_IN}
  KSNODEPIN_SUM_MUX_OUT     = 0;
  {$EXTERNALSYM KSNODEPIN_SUM_MUX_OUT}

  KSNODEPIN_DEMUX_IN        = 0;
  {$EXTERNALSYM KSNODEPIN_DEMUX_IN}
  KSNODEPIN_DEMUX_OUT       = 1; // can be >= 1
  {$EXTERNALSYM KSNODEPIN_DEMUX_OUT}

  KSNODEPIN_AEC_RENDER_IN   = 1;
  {$EXTERNALSYM KSNODEPIN_AEC_RENDER_IN}
  KSNODEPIN_AEC_RENDER_OUT  = 0;
  {$EXTERNALSYM KSNODEPIN_AEC_RENDER_OUT}
  KSNODEPIN_AEC_CAPTURE_IN  = 2;
  {$EXTERNALSYM KSNODEPIN_AEC_CAPTURE_IN}
  KSNODEPIN_AEC_CAPTURE_OUT = 3;
  {$EXTERNALSYM KSNODEPIN_AEC_CAPTURE_OUT}

//===========================================================================
//===========================================================================

  KSMETHODSETID_Wavetable : TGUID = '{DCEF31EB-D907-11D0-9583-00C04FB925D3}';
  {$EXTERNALSYM KSMETHODSETID_Wavetable}

type
  KSMETHOD_WAVETABLE = (
    KSMETHOD_WAVETABLE_WAVE_ALLOC,
    KSMETHOD_WAVETABLE_WAVE_FREE,
    KSMETHOD_WAVETABLE_WAVE_FIND,
    KSMETHOD_WAVETABLE_WAVE_WRITE
  );
  {$EXTERNALSYM KSMETHOD_WAVETABLE}
  TKSMethodWavetable = KSMETHOD_WAVETABLE;

  PKSWaveTableWaveDesc = ^TKSWaveTableWaveDesc;
  KSWAVETABLE_WAVE_DESC = record
    Identifier : TKSIdentifier; // wave identifier
    Size       : ULONG;         // wave size
    Looped     : BOOL;          // wave looped flag
    LoopPoint  : ULONG;         // wave loop point
    InROM      : BOOL;          // wave InROM flag
    Format     : TKSDataFormat; // wave format
  end;
  {$EXTERNALSYM KSWAVETABLE_WAVE_DESC}
  PKSWAVETABLE_WAVE_DESC = ^KSWAVETABLE_WAVE_DESC;
  {$EXTERNALSYM PKSWAVETABLE_WAVE_DESC}
  TKSWaveTableWaveDesc = KSWAVETABLE_WAVE_DESC;

//===========================================================================
//===========================================================================

//
//  Property sets and items
//

//===========================================================================
//===========================================================================

const
  KSPROPSETID_Itd3d : TGUID = '{6429f090-9fd9-11d0-a75b-00a0c90365e3}';
  {$EXTERNALSYM KSPROPSETID_Itd3d}

//type
//  KSPROPERTY_ITD3D = (
//    KSPROPERTY_ITD3D_PARAMS
//  );
//  {$EXTERNALSYM KSPROPERTY_ITD3D}
//  TKSPropertyITD3D = KSPROPERTY_ITD3D;

//===========================================================================
//===========================================================================
const
  KSPROPSETID_Hrtf3d: TGUID = '{b66decb0-a083-11d0-851e-00c04fd9baf3}';
  {$EXTERNALSYM KSPROPSETID_Hrtf3d}

//type
//  KSPROPERTY_HRTF3D = (
//    KSPROPERTY_HRTF3D_PARAMS,
//    KSPROPERTY_HRTF3D_INITIALIZE,
//    KSPROPERTY_HRTF3D_FILTER_FORMAT
//  );
//  {$EXTERNALSYM KSPROPERTY_HRTF3D}
//  TKSPropertyHRTF3D = KSPROPERTY_HRTF3D;

//===========================================================================
//===========================================================================
const
  KSPROPSETID_Wave_Queued   : TGUID = '{16a15b10-16f0-11d0-a195-0020afd156e4}';
  {$EXTERNALSYM KSPROPSETID_Wave_Queued}

  KSPROPERTY_WAVE_QUEUED_POSITION   = $00000001;
  {$EXTERNALSYM KSPROPERTY_WAVE_QUEUED_POSITION}

  KSMETHODSETID_Wave_Queued : TGUID = '{7432c160-8827-11cf-a102-0020afd156e4}';
  {$EXTERNALSYM KSMETHODSETID_Wave_Queued}

  KSMETHOD_WAVE_QUEUED_BREAKLOOP    = $00000001;
  {$EXTERNALSYM KSMETHOD_WAVE_QUEUED_BREAKLOOP}

  KSPROPSETID_Wave          : TGUID = '{924e54b0-630f-11cf-ada7-08003e30494a}';
  {$EXTERNALSYM KSPROPSETID_Wave}

type
  KSPROPERTY_WAVE = (
    KSPROPERTY_WAVE_COMPATIBLE_CAPABILITIES,
    KSPROPERTY_WAVE_INPUT_CAPABILITIES,
    KSPROPERTY_WAVE_OUTPUT_CAPABILITIES,
    KSPROPERTY_WAVE_BUFFER,
    KSPROPERTY_WAVE_FREQUENCY,
    KSPROPERTY_WAVE_VOLUME,
    KSPROPERTY_WAVE_PAN
  );
  {$EXTERNALSYM KSPROPERTY_WAVE}
  TKSPropertyWave = KSPROPERTY_WAVE;

  PKSWaveCompatCaps = ^TKSWaveCompatCaps;
  KSWAVE_COMPATCAPS = record
    ulDeviceType : ULONG;
  end;
  {$EXTERNALSYM KSWAVE_COMPATCAPS}
  PKSWAVE_COMPATCAPS = ^KSWAVE_COMPATCAPS;
  {$EXTERNALSYM PKSWAVE_COMPATCAPS}
  TKSWaveCompatCaps = KSWAVE_COMPATCAPS;

const
  KSWAVE_COMPATCAPS_INPUT  = $00000000;
  {$EXTERNALSYM KSWAVE_COMPATCAPS_INPUT}
  KSWAVE_COMPATCAPS_OUTPUT = $00000001;
  {$EXTERNALSYM KSWAVE_COMPATCAPS_OUTPUT}

type
  PKSWaveInputCapabilities = ^TKSWaveInputCapabilities;
  KSWAVE_INPUT_CAPABILITIES = record
    MaximumChannelsPerConnection : ULONG;
    MinimumBitsPerSample         : ULONG;
    MaximumBitsPerSample         : ULONG;
    MinimumSampleFrequency       : ULONG;
    MaximumSampleFrequency       : ULONG;
    TotalConnections             : ULONG;
    ActiveConnections            : ULONG;
  end;
  {$EXTERNALSYM KSWAVE_INPUT_CAPABILITIES}
  PKSWAVE_INPUT_CAPABILITIES = ^KSWAVE_INPUT_CAPABILITIES;
  {$EXTERNALSYM PKSWAVE_INPUT_CAPABILITIES}
  TKSWaveInputCapabilities = KSWAVE_INPUT_CAPABILITIES;

  PKSWaveOutputCapabilities = ^TKSWaveOutputCapabilities;
  KSWAVE_OUTPUT_CAPABILITIES = record
    MaximumChannelsPerConnection      : ULONG;
    MinimumBitsPerSample              : ULONG;
    MaximumBitsPerSample              : ULONG;
    MinimumSampleFrequency            : ULONG;
    MaximumSampleFrequency            : ULONG;
    TotalConnections                  : ULONG;
    StaticConnections                 : ULONG;
    StreamingConnections              : ULONG;
    ActiveConnections                 : ULONG;
    ActiveStaticConnections           : ULONG;
    ActiveStreamingConnections        : ULONG;
    Total3DConnections                : ULONG;
    Static3DConnections               : ULONG;
    Streaming3DConnections            : ULONG;
    Active3DConnections               : ULONG;
    ActiveStatic3DConnections         : ULONG;
    ActiveStreaming3DConnections      : ULONG;
    TotalSampleMemory                 : ULONG;
    FreeSampleMemory                  : ULONG;
    LargestFreeContiguousSampleMemory : ULONG;
  end;
  {$EXTERNALSYM KSWAVE_OUTPUT_CAPABILITIES}
  PKSWAVE_OUTPUT_CAPABILITIES = ^KSWAVE_OUTPUT_CAPABILITIES;
  {$EXTERNALSYM PKSWAVE_OUTPUT_CAPABILITIES}
  TKSWaveOutputCapabilities = KSWAVE_OUTPUT_CAPABILITIES;

  PKSWaveVolume = ^TKSWaveVolume;
  KSWAVE_VOLUME = record
    LeftAttenuation  : longint;
    RightAttenuation : longint;
  end;
  {$EXTERNALSYM KSWAVE_VOLUME}
  PKSWAVE_VOLUME = ^KSWAVE_VOLUME;
  {$EXTERNALSYM PKSWAVE_VOLUME}
  TKSWaveVolume = KSWAVE_VOLUME;

const
  KSWAVE_BUFFER_ATTRIBUTEF_LOOPING = $00000001;
  {$EXTERNALSYM KSWAVE_BUFFER_ATTRIBUTEF_LOOPING}
  KSWAVE_BUFFER_ATTRIBUTEF_STATIC  = $00000002;
  {$EXTERNALSYM KSWAVE_BUFFER_ATTRIBUTEF_STATIC}

type
  PKSWaveBuffer = ^TKSWaveBuffer;
  KSWAVE_BUFFER = record
    Attributes    : ULONG;
    BufferSize    : ULONG;
    BufferAddress : Pointer;
  end;
  {$EXTERNALSYM KSWAVE_BUFFER}
  PKSWAVE_BUFFER = ^KSWAVE_BUFFER;
  {$EXTERNALSYM PKSWAVE_BUFFER}
  TKSWaveBuffer = KSWAVE_BUFFER;

//===========================================================================
//===========================================================================
const
 KSMUSIC_TECHNOLOGY_PORT      : TGUID = '{86C92E60-62E8-11CF-A5D6-28DB04C10000}';
 {$EXTERNALSYM KSMUSIC_TECHNOLOGY_PORT}
 KSMUSIC_TECHNOLOGY_SQSYNTH   : TGUID = '{0ECF4380-62E9-11CF-A5D6-28DB04C10000}';
 {$EXTERNALSYM KSMUSIC_TECHNOLOGY_SQSYNTH}
 KSMUSIC_TECHNOLOGY_FMSYNTH   : TGUID = '{252C5C80-62E9-11CF-A5D6-28DB04C10000}';
 {$EXTERNALSYM KSMUSIC_TECHNOLOGY_FMSYNTH}
 KSMUSIC_TECHNOLOGY_WAVETABLE : TGUID = '{394EC7C0-62E9-11CF-A5D6-28DB04C10000}';
 {$EXTERNALSYM KSMUSIC_TECHNOLOGY_WAVETABLE}
 KSMUSIC_TECHNOLOGY_SWSYNTH   : TGUID = '{37407736-3620-11D1-85D3-0000F8754380}';
 {$EXTERNALSYM KSMUSIC_TECHNOLOGY_SWSYNTH}
 KSPROPSETID_WaveTable        : TGUID = '{8539E660-62E9-11CF-A5D6-28DB04C10000}';
 {$EXTERNALSYM KSPROPSETID_WaveTable}

type
  KSPROPERTY_WAVETABLE = (
    KSPROPERTY_WAVETABLE_LOAD_SAMPLE,
    KSPROPERTY_WAVETABLE_UNLOAD_SAMPLE,
    KSPROPERTY_WAVETABLE_MEMORY,
    KSPROPERTY_WAVETABLE_VERSION
  );
  {$EXTERNALSYM KSPROPERTY_WAVETABLE}
  TKSPropertyWaveTable = KSPROPERTY_WAVETABLE;

  PKSDataRangeMusic = ^TKSDataRangeMusic;
  KSDATARANGE_MUSIC = record
    DataRange   : TKSDataRange;
    Technology  : TGUID;
    Channels    : ULONG;
    Notes       : ULONG;
    ChannelMask : ULONG;
  end;
  {$EXTERNALSYM KSDATARANGE_MUSIC}
  PKSDATARANGE_MUSIC = ^KSDATARANGE_MUSIC;
  {$EXTERNALSYM PKSDATARANGE_MUSIC}
  TKSDataRangeMusic = KSDATARANGE_MUSIC;

//===========================================================================
const
  KSEVENTSETID_Cyclic : TGUID = '{142C1AC0-072A-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSEVENTSETID_Cyclic}

type
  KSEVENT_CYCLIC_TIME = (
    KSEVENT_CYCLIC_TIME_INTERVAL
  );
  {$EXTERNALSYM KSEVENT_CYCLIC_TIME}
  TKSEventCyclicTime = KSEVENT_CYCLIC_TIME;

const
  KSPROPSETID_Cyclic: TGUID = '{3FFEAEA0-2BEE-11CF-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSPROPSETID_Cyclic}

type
  KSPROPERTY_CYCLIC = (
    KSPROPERTY_CYCLIC_POSITION
  );
  {$EXTERNALSYM KSPROPERTY_CYCLIC}
  TKSPropertyCyclic = KSPROPERTY_CYCLIC;

//===========================================================================
const
  KSEVENTSETID_AudioControlChange: TGUID = '{E85E9698-FA2F-11D1-95BD-00C04FB925D3}';
  {$EXTERNALSYM KSEVENTSETID_AudioControlChange}

type
  KSEVENT_AUDIO_CONTROL_CHANGE = (
    KSEVENT_CONTROL_CHANGE
  );
  {$EXTERNALSYM KSEVENT_AUDIO_CONTROL_CHANGE}
  TKSEventAudioControlChange = KSEVENT_AUDIO_CONTROL_CHANGE;

//===========================================================================
const
  KSEVENTSETID_LoopedStreaming : TGUID = '{4682B940-C6EF-11D0-96D8-00AA0051E51D}';
  {$EXTERNALSYM KSEVENTSETID_LoopedStreaming}

type
  KSEVENT_LOOPEDSTREAMING = (
    KSEVENT_LOOPEDSTREAMING_POSITION
  );
  {$EXTERNALSYM KSEVENT_LOOPEDSTREAMING}
  TKSEventLoopedStreaming = KSEVENT_LOOPEDSTREAMING;

  PLoopedStreamingPositionEventData = ^TLoopedStreamingPositionEventData;
  LOOPEDSTREAMING_POSITION_EVENT_DATA = record
    KsEventData : TKSEVENTDATA;
    Position    : int64;
  end;
  {$EXTERNALSYM LOOPEDSTREAMING_POSITION_EVENT_DATA}
  PLOOPEDSTREAMING_POSITION_EVENT_DATA = ^LOOPEDSTREAMING_POSITION_EVENT_DATA;
  {$EXTERNALSYM PLOOPEDSTREAMING_POSITION_EVENT_DATA}
  TLoopedStreamingPositionEventData = LOOPEDSTREAMING_POSITION_EVENT_DATA;

const
  KSEVENTSETID_Sysaudio : TGUID = '{04800320-4491-11D1-A050-405705C10000}';
  {$EXTERNALSYM KSEVENTSETID_Sysaudio}

type
  KSEVENT_SYSAUDIO = (
    KSEVENT_SYSAUDIO_ADDREMOVE_DEVICE,
    KSEVENT_SYSAUDIO_CHANGE_DEVICE
  );
  {$EXTERNALSYM KSEVENT_SYSAUDIO}
  TKSEventSysAudio = KSEVENT_SYSAUDIO;

const
  KSPROPSETID_Sysaudio : TGUID = '{CBE3FAA0-CC75-11D0-B465-00001A1818E6}';
  {$EXTERNALSYM KSPROPSETID_Sysaudio}

type
  KSPROPERTY_SYSAUDIO = (
    KSPROPERTY_SYSAUDIO_DEVICE_Invalid,
    KSPROPERTY_SYSAUDIO_DEVICE_COUNT,                   
    KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME,           
    KSPROPERTY_SYSAUDIO_DEVICE_INSTANCE,                
    KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME,          
    KSPROPERTY_SYSAUDIO_SELECT_GRAPH,                   
    KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE,          
    KSPROPERTY_SYSAUDIO_DEVICE_DEFAULT,                 
    KSPROPERTY_SYSAUDIO_ALWAYS_CREATE_VIRTUAL_SOURCE,   
    KSPROPERTY_SYSAUDIO_ADDREMOVE_LOCK,                 
    KSPROPERTY_SYSAUDIO_ADDREMOVE_UNLOCK,               
    KSPROPERTY_SYSAUDIO_RENDER_PIN_INSTANCES,           
    KSPROPERTY_SYSAUDIO_RENDER_CONNECTION_INDEX,        
    KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE_ONLY,     
    KSPROPERTY_SYSAUDIO_INSTANCE_INFO,                  
    KSPROPERTY_SYSAUDIO_PREFERRED_DEVICE,                
    KSPROPERTY_SYSAUDIO_COMPONENT_ID,                   
    KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX
  );
  {$EXTERNALSYM KSPROPERTY_SYSAUDIO}
  TKSPropertySysAudio = KSPROPERTY_SYSAUDIO;

  PSysAudioCreateVirtualSource = ^TSysAudioCreateVirtualSource;
  SYSAUDIO_CREATE_VIRTUAL_SOURCE = record
    Property_   : KSPROPERTY;
    PinCategory : TGUID;
    PinName     : TGUID;
  end;
  {$EXTERNALSYM SYSAUDIO_CREATE_VIRTUAL_SOURCE}
  PSYSAUDIO_CREATE_VIRTUAL_SOURCE = ^SYSAUDIO_CREATE_VIRTUAL_SOURCE;
  {$EXTERNALSYM PSYSAUDIO_CREATE_VIRTUAL_SOURCE}
  TSysAudioCreateVirtualSource = SYSAUDIO_CREATE_VIRTUAL_SOURCE;

  PSysAudioSelectGraph = ^TSysAudioSelectGraph;
  SYSAUDIO_SELECT_GRAPH = record
     Property_ : KSPROPERTY;
     PinId     : ULONG;
     NodeId    : ULONG;
     Flags     : ULONG;
     Reserved  : ULONG;
  end;
  {$EXTERNALSYM SYSAUDIO_SELECT_GRAPH}
  PSYSAUDIO_SELECT_GRAPH = ^SYSAUDIO_SELECT_GRAPH;
  {$EXTERNALSYM PSYSAUDIO_SELECT_GRAPH}
  TSysAudioSelectGraph = SYSAUDIO_SELECT_GRAPH;

  PSysAudioInstanceInfo = ^TSysAudioInstanceInfo;
  SYSAUDIO_INSTANCE_INFO = record
    Property_    : KSPROPERTY;
    Flags        : ULONG;
    DeviceNumber : ULONG;
  end;
  {$EXTERNALSYM SYSAUDIO_INSTANCE_INFO}
  PSYSAUDIO_INSTANCE_INFO = ^SYSAUDIO_INSTANCE_INFO;
  {$EXTERNALSYM PSYSAUDIO_INSTANCE_INFO}
  TSysAudioInstanceInfo = SYSAUDIO_INSTANCE_INFO;

const
  SYSAUDIO_FLAGS_DONT_COMBINE_PINS = $00000001;
  {$EXTERNALSYM SYSAUDIO_FLAGS_DONT_COMBINE_PINS}

type
  SYSAUDIO_PREFERRED_DEVICE = record
    Property_ : KSPROPERTY;
    Flags     : ULONG;
    Index     : ULONG; // KSPROPERTY_SYSAUDIO_DEFAULT_TYPE
  end;
  {$EXTERNALSYM SYSAUDIO_PREFERRED_DEVICE}
  PSYSAUDIO_PREFERRED_DEVICE = ^SYSAUDIO_PREFERRED_DEVICE;
  {$EXTERNALSYM PSYSAUDIO_PREFERRED_DEVICE}
  TSysAudioPreferredDevice = SYSAUDIO_PREFERRED_DEVICE;

const
  SYSAUDIO_FLAGS_CLEAR_PREFERRED = $00000002;
  {$EXTERNALSYM SYSAUDIO_FLAGS_CLEAR_PREFERRED}

type
  KSPROPERTY_SYSAUDIO_DEFAULT_TYPE = ( // preferred device index
    KSPROPERTY_SYSAUDIO_NORMAL_DEFAULT,
    KSPROPERTY_SYSAUDIO_PLAYBACK_DEFAULT,
    KSPROPERTY_SYSAUDIO_RECORD_DEFAULT,
    KSPROPERTY_SYSAUDIO_MIDI_DEFAULT,
    KSPROPERTY_SYSAUDIO_MIXER_DEFAULT
  );
  {$EXTERNALSYM KSPROPERTY_SYSAUDIO_DEFAULT_TYPE}
  TKSPropertySysAudioDefaultType = KSPROPERTY_SYSAUDIO_DEFAULT_TYPE;

const
   KSPROPSETID_Sysaudio_Pin : TGUID = '{A3A53220-C6E4-11D0-B465-00001A1818E6}';
   {$EXTERNALSYM KSPROPSETID_Sysaudio_Pin}

type
  KSPROPERTY_SYSAUDIO_PIN = (
    KSPROPERTY_SYSAUDIO_TOPOLOGY_CONNECTION_INDEX,
    KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE,
    KSPROPERTY_SYSAUDIO_PIN_VOLUME_NODE
  );
  {$EXTERNALSYM KSPROPERTY_SYSAUDIO_PIN}
  TKSPropertySysAudioPin = KSPROPERTY_SYSAUDIO_PIN;

  PSysAudioAttachVirtualSource = ^TSysAudioAttachVirtualSource;
  SYSAUDIO_ATTACH_VIRTUAL_SOURCE = record
    Property_  : KSPROPERTY;
    MixerPinId : ULONG;
    Reserved   : ULONG;
  end;
  {$EXTERNALSYM SYSAUDIO_ATTACH_VIRTUAL_SOURCE}
  PSYSAUDIO_ATTACH_VIRTUAL_SOURCE = ^SYSAUDIO_ATTACH_VIRTUAL_SOURCE;
  {$EXTERNALSYM PSYSAUDIO_ATTACH_VIRTUAL_SOURCE}
  TSysAudioAttachVirtualSource = SYSAUDIO_ATTACH_VIRTUAL_SOURCE;

  KSNODEPROPERTY = record
    Property_ : KSPROPERTY;
    NodeId    : ULONG;
    Reserved  : ULONG;
  end;
  {$EXTERNALSYM KSNODEPROPERTY}
  PKSNODEPROPERTY = ^KSNODEPROPERTY;
  {$EXTERNALSYM PKSNODEPROPERTY}
  TKSNodeProperty = KSNODEPROPERTY;

  PKSNodePropertyAudioChannel = ^TKSNodePropertyAudioChannel;
  KSNODEPROPERTY_AUDIO_CHANNEL = record
    NodeProperty : TKSNODEPROPERTY;
    Channel      : Longint; // value to get or set
    Reserved     : ULONG;
  end;
  {$EXTERNALSYM KSNODEPROPERTY_AUDIO_CHANNEL}
  PKSNODEPROPERTY_AUDIO_CHANNEL = ^KSNODEPROPERTY_AUDIO_CHANNEL;
  {$EXTERNALSYM PKSNODEPROPERTY_AUDIO_CHANNEL}
  TKSNodePropertyAudioChannel = KSNODEPROPERTY_AUDIO_CHANNEL;

  PKSNodePropertyAudioDevSpecific = ^TKSNodePropertyAudioDevSpecific;
  KSNODEPROPERTY_AUDIO_DEV_SPECIFIC = record
    NodeProperty  :TKSNODEPROPERTY;
    DevSpecificId :ULONG;
    DeviceInfo    :ULONG;
    Length        :ULONG;
  end;
  {$EXTERNALSYM KSNODEPROPERTY_AUDIO_DEV_SPECIFIC}
  PKSNODEPROPERTY_AUDIO_DEV_SPECIFIC = ^KSNODEPROPERTY_AUDIO_DEV_SPECIFIC;
  {$EXTERNALSYM PKSNODEPROPERTY_AUDIO_DEV_SPECIFIC}
  TKSNodePropertyAudioDevSpecific = KSNODEPROPERTY_AUDIO_DEV_SPECIFIC;

  PKSNodePropertyAudio3DListenerp = ^TKSNodePropertyAudio3DListener;
  KSNODEPROPERTY_AUDIO_3D_LISTENER = record
    NodeProperty : TKSNODEPROPERTY;
    ListenerId   : pointer;
    Reserved     : ULONG;
  end;
  {$EXTERNALSYM KSNODEPROPERTY_AUDIO_3D_LISTENER}
  PKSNODEPROPERTY_AUDIO_3D_LISTENER = ^KSNODEPROPERTY_AUDIO_3D_LISTENER;
  {$EXTERNALSYM PKSNODEPROPERTY_AUDIO_3D_LISTENER}
  TKSNodePropertyAudio3DListener = KSNODEPROPERTY_AUDIO_3D_LISTENER;

  PKSNodePropertyAudioProperty = ^TKSNodePropertyAudioProperty;
  KSNODEPROPERTY_AUDIO_PROPERTY = record
    NodeProperty : TKSNODEPROPERTY;
    AppContext   : Pointer;
    Length       : ULONG;
    Reserved     : ULONG;
  end;
  {$EXTERNALSYM KSNODEPROPERTY_AUDIO_PROPERTY}
  PKSNODEPROPERTY_AUDIO_PROPERTY = ^KSNODEPROPERTY_AUDIO_PROPERTY;
  {$EXTERNALSYM PKSNODEPROPERTY_AUDIO_PROPERTY}
  TKSNodePropertyAudioProperty = KSNODEPROPERTY_AUDIO_PROPERTY;

//===========================================================================
const
  KSPROPSETID_Linear : TGUID = '{5A2FFE80-16B9-11D0-A5D6-28DB04C10000}';
  {$EXTERNALSYM KSPROPSETID_Linear}

type
  KSPROPERTY_LINEAR = (
    KSPROPERTY_LINEAR_POSITION
  );
  {$EXTERNALSYM KSPROPERTY_LINEAR}
  TKSPropertyLinear = KSPROPERTY_LINEAR;

//===========================================================================

//
// Midi definitions
//

//
//  Formats
//
const
 KSDATAFORMAT_TYPE_MUSIC       : TGUID = '{E725D360-62CC-11CF-A5D6-28DB04C10000}';
 {$EXTERNALSYM KSDATAFORMAT_TYPE_MUSIC}
// 'mids' == MEDIATYPE_Midi
 KSDATAFORMAT_TYPE_MIDI        : TGUID = '{7364696D-0000-0010-8000-00aa00389b71}';
 {$EXTERNALSYM KSDATAFORMAT_TYPE_MIDI}
 KSDATAFORMAT_SUBTYPE_MIDI     : TGUID = '{1D262760-E957-11CF-A5D6-28DB04C10000}';
 {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_MIDI}
 KSDATAFORMAT_SUBTYPE_MIDI_BUS : TGUID = '{2CA15FA0-6CFE-11CF-A5D6-28DB04C10000}';
 {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_MIDI_BUS}
 KSDATAFORMAT_SUBTYPE_RIFFMIDI : TGUID = '{4995DAF0-9EE6-11D0-A40E-00A0C9223196}';
 {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_RIFFMIDI}

//
//  KSDATAFORMAT_SUBTYPE_DIRECTMUSIC
//    see DMusicKS.h
//

// WARNING! This structure MUST be dword aligned
// regardless of the number of data bytes.
type
  KSMUSICFORMAT = record
    TimeDeltaMs : ULONG   ;     // Delta Milliseconds from the previous midiformat
                                // in the packet. The first midiformat in the packet
                                // is a delta from the PTS in the KSSTREAM_HEADER.
    ByteCount   : ULONG   ;     // Number of bytes of data that follow this struct.
  end;
  {$EXTERNALSYM KSMUSICFORMAT}
  PKSMUSICFORMAT = ^KSMUSICFORMAT;
  {$EXTERNALSYM PKSMUSICFORMAT}
  TKSMusicFormat = KSMUSICFORMAT;

//
// This entire set of MPEG Standard/Dialect Guids are obsolete. Do not use them.
//
//====================================================================================================
//====================================================================================================
// The following official MPEG Formats, Subtypes and Specifiers are listed as required or optional
// These official MPEG GUIDs are the preferred method of supporting MPEG/AC-3 media types in new code.
// Older MPEG GUIDs should also be supported for compatibilty, but these new modes are still required.
//====================================================================================================
//====================================================================================================

{
This is a summary of what media types/specifiers will be required for all DVD+DSS+DVB+DTV MPEG decoders.
These media types are what the decoder driver must accept, hardware support for all of these media types
may or may not actually be provided by the decoder natively.  These media types are intended to define
the "officially" supported MPEG/AC-3 media types that all WHQL certified decoders must implement.  This
specifically includes driver and/or hardware support for all the required standards and dialects.

All MPEG video decoders must support all of the MPEG video modes shown as [required] below.
All MPEG audio decoders must support all of the MPEG audio modes shown as [required] below.
All AC-3 audio decoders must support all of the AC-3 audio modes shown as [required] below.
The line items shown as [optional] need not be implemented, but are possible formats that might be implemented.

Note that the input/output pin formats are defined by 2 or 3 GUIDs: TYPE, SUBTYPE, and maybe SPECIFIER.
The specifiers are included if the data format is a "dialect" that needs to be differentiated during decoding.
The decoder MUST be prepared to deal with ALL requests for _required_ "Standard" formats OR _required_ "Dialects".

STATIC_KSDATAFORMAT_TYPE_STANDARD_ELEMENTARY_STREAM         [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO           [optional]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO           [optional]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO           [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO           [optional]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO              [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO             [optional]
STATIC_KSDATAFORMAT_TYPE_STANDARD_PES_PACKET                [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO            [optional]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO           [optional]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO            [optional]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO           [optional]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO           [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO           [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO              [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO             [optional]
STATIC_KSDATAFORMAT_TYPE_STANDARD_PACK_HEADER               [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO           [required]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO            [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO           [optional]
    STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO              [required]
        STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO             [optional]

Note that the SPECIFIER GUIDs normally identify particular versions of MPEG such as DSS and DVD.
This approach was taken to minimize the number of DSS/DVB/DVD/DTV etc. media SUBTYPES.
These specifiers are currently required to disambiguate MPEG syntax _parsing_ by the decoder
using alternate parsing routines or downloadable firmware or hardware decode settings.

In the future these specifiers will be extended to cover new KS MPEG flavors such as DVB and DTV.
Thus, the optional specifiers will be subject to clarification and/or definition as they are needed.

Important note: Per the ITU MPEG specs, MPEG 2 media may contain pure MPEG 1 syntax and
any "MPEG 2" PES packets may actually contain MPEG 1 payloads and MPEG 1 syntax.  Some MPEG
broadcasts can revert from MPEG2 to MPEG1 format data at their discretion, without warning.

CAUTION: Decoders MUST attempt to process MPEG data AS SOON AS POSSIBLE after reception.
In particular, elementary MPEG or MPEG PES packet streams should not be aggregated into DVD
"pack headers" internally before submission to the codec hardware if AT ALL POSSIBLE.  The
reason is that mpeg data may need to be processed immediately but there may be no additional
MPEG data forthcoming to fill up the PES packet OR DVD "pack" in a timely fashion.  This is
particularly true of MPEG dialects that utilize "repeat field signally" to reuse the last
decoded MPEG video field.

}

/////////////////////////////////////////////////////////////////////////
// The major data type GUIDs that define the data packet encapsulation //
/////////////////////////////////////////////////////////////////////////
const
// STATIC_KSDATAFORMAT_TYPE_STANDARD_ELEMENTARY_STREAM
  KSDATAFORMAT_TYPE_STANDARD_ELEMENTARY_STREAM : TGUID = '{36523B11-8EE5-11d1-8CA3-0060B057664A}';
  {$EXTERNALSYM KSDATAFORMAT_TYPE_STANDARD_ELEMENTARY_STREAM}

// STATIC_KSDATAFORMAT_TYPE_STANDARD_PES_PACKET
  KSDATAFORMAT_TYPE_STANDARD_PES_PACKET        : TGUID = '{36523B12-8EE5-11d1-8CA3-0060B057664A}';
  {$EXTERNALSYM KSDATAFORMAT_TYPE_STANDARD_PES_PACKET}

// STATIC_KSDATAFORMAT_TYPE_STANDARD_PACK_HEADER
  KSDATAFORMAT_TYPE_STANDARD_PACK_HEADER       : TGUID = '{36523B13-8EE5-11d1-8CA3-0060B057664A}';
  {$EXTERNALSYM KSDATAFORMAT_TYPE_STANDARD_PACK_HEADER}

///////////////////////////////////////////////////////////////////////////////
// The minor data subtype GUIDs that define the exact class of the data type.//
///////////////////////////////////////////////////////////////////////////////

// STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO
  KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO    : TGUID = '{36523B21-8EE5-11d1-8CA3-0060B057664A}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO}

// STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO
  KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO    : TGUID = '{36523B22-8EE5-11d1-8CA3-0060B057664A}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO}

// STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO
  KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO    : TGUID = '{36523B23-8EE5-11d1-8CA3-0060B057664A}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO}

// STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO
  KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO    : TGUID = '{36523B24-8EE5-11d1-8CA3-0060B057664A}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO}

// STATIC_KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO
  KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO      : TGUID = '{36523B25-8EE5-11d1-8CA3-0060B057664A}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO}

///////////////////////////////////////////////////////////////////////////////
// The low-level specifier GUIDs that define the flavor of the data subtype. //
// Some SUBTYPES, notably MPEG2_VIDEO, MPEG2_AUDIO have different dialects.  //
// These specifiers are intended to be accompanied by a specifier structure. //
///////////////////////////////////////////////////////////////////////////////

// STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO
  KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO    : TGUID = '{36523B31-8EE5-11d1-8CA3-0060B057664A}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO}

// STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO
  KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO    : TGUID = '{36523B32-8EE5-11d1-8CA3-0060B057664A}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO}

// STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO    Associated with KS_MPEGVIDEOINFO2 defined later
  KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO    : TGUID = '{36523B33-8EE5-11d1-8CA3-0060B057664A}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO}

// STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO    Associated with KS_MPEGAUDIOINFO defined later
  KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO    : TGUID = '{36523B34-8EE5-11d1-8CA3-0060B057664A}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO}

// STATIC_KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO
  KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO      : TGUID = '{36523B35-8EE5-11d1-8CA3-0060B057664A}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO}

//====================================================================================================
//====================================================================================================
//                              *** COMPATIBILITY WARNING ***
// The *following* older DSS, MPEG, DVD & AC-3 GUID definitions are retained for backward compability.
// These MPEG GUIDs should also be supported for compatibilty, but the above newer modes are still required.
//====================================================================================================
//====================================================================================================

//
// DSS definitions
//

  KSDATAFORMAT_SUBTYPE_DSS_VIDEO : TGUID = '{a0af4f81-e163-11d0-bad9-00609744111a}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_DSS_VIDEO}
  KSDATAFORMAT_SUBTYPE_DSS_AUDIO : TGUID = '{a0af4f82-e163-11d0-bad9-00609744111a}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_DSS_AUDIO}

//
// End of obsolete MPEG definitions.
//

//
// mpeg 1 definitions
//
  KSDATAFORMAT_SUBTYPE_MPEG1Packet   : TGUID = '{e436eb80-524f-11ce-9F53-0020af0ba770}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_MPEG1Packet}
  KSDATAFORMAT_SUBTYPE_MPEG1Payload  : TGUID = '{e436eb81-524f-11ce-9F53-0020af0ba770}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_MPEG1Payload}

// MEDIASUBTYPE_MPEG1Video
  KSDATAFORMAT_SUBTYPE_MPEG1Video    : TGUID = '{e436eb86-524f-11ce-9f53-0020af0ba770}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_MPEG1Video}

//FORMAT_MPEGVideo
  KSDATAFORMAT_SPECIFIER_MPEG1_VIDEO : TGUID = '{05589f82-c356-11ce-bf01-00aa0055595a}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_MPEG1_VIDEO}

//
// mpeg 2 definitions
//
  KSDATAFORMAT_TYPE_MPEG2_PES        : TGUID = '{e06d8020-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_TYPE_MPEG2_PES}
  KSDATAFORMAT_TYPE_MPEG2_PROGRAM    : TGUID = '{e06d8022-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_TYPE_MPEG2_PROGRAM}
  KSDATAFORMAT_TYPE_MPEG2_TRANSPORT  : TGUID = '{e06d8023-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_TYPE_MPEG2_TRANSPORT}
  KSDATAFORMAT_SUBTYPE_MPEG2_VIDEO   : TGUID = '{e06d8026-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_MPEG2_VIDEO}

// use MPEGVIDEOINFO2 (defined below) with KSDATAFORMAT_SPECIFIER_MPEG2_VIDEO
  KSDATAFORMAT_SPECIFIER_MPEG2_VIDEO : TGUID = '{e06d80e3-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_MPEG2_VIDEO}

//
// Mpeg2 video properties
//
  KSPROPSETID_Mpeg2Vid : TGUID = '{C8E11B60-0CC9-11D0-BD69-003505C103A9}';
  {$EXTERNALSYM KSPROPSETID_Mpeg2Vid}

type
  KSPROPERTY_MPEG2VID = (
    KSPROPERTY_MPEG2VID_MODES,          // available output modes of decoder
    KSPROPERTY_MPEG2VID_CUR_MODE,       // current mode of the decoder
    KSPROPERTY_MPEG2VID_4_3_RECT,       // output coordinates for 4:3 source
    KSPROPERTY_MPEG2VID_16_9_RECT,      // output coordinates for 16:9 source
    KSPROPERTY_MPEG2VID_16_9_PANSCAN    // pan and scan vectors
  );
  {$EXTERNALSYM KSPROPERTY_MPEG2VID}
  TKSPropertyMPEG2Vid = KSPROPERTY_MPEG2VID;

//
// bit field definitions for MPEG2 VIDEO mode
//
const
  KSMPEGVIDMODE_PANSCAN = $0001;
  {$EXTERNALSYM KSMPEGVIDMODE_PANSCAN}
  KSMPEGVIDMODE_LTRBOX  = $0002;
  {$EXTERNALSYM KSMPEGVIDMODE_LTRBOX}
  KSMPEGVIDMODE_SCALE   = $0004;
  {$EXTERNALSYM KSMPEGVIDMODE_SCALE}

//
// rectangle definitions for the 4/3 and 16/9 cropping properties of
// the MPEG2Video decoder
//
type
  PKSMPEGVidRect = ^TKSMPEGVidRect;
  _KSMPEGVID_RECT = record
    StartX : ULONG;
    StartY : ULONG;
    EndX   : ULONG;
    EndY   : ULONG;
  end;
  {$EXTERNALSYM _KSMPEGVID_RECT}
  KSMPEGVID_RECT = _KSMPEGVID_RECT;
  {$EXTERNALSYM KSMPEGVID_RECT}
  PKSMPEGVID_RECT = ^KSMPEGVID_RECT;
  {$EXTERNALSYM PKSMPEGVID_RECT}
  TKSMPEGVidRect = _KSMPEGVID_RECT;

//
// Params for pan / scan
//


//
// MPEG2 Audio definition
//
const
  KSDATAFORMAT_SUBTYPE_MPEG2_AUDIO   : TGUID = '{e06d802b-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_MPEG2_AUDIO}
  KSDATAFORMAT_SPECIFIER_MPEG2_AUDIO : TGUID = '{e06d80e5-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_MPEG2_AUDIO}

//
// DVD LPCM Audio definition
//

  KSDATAFORMAT_SUBTYPE_LPCM_AUDIO    : TGUID = '{e06d8032-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_LPCM_AUDIO}
  KSDATAFORMAT_SPECIFIER_LPCM_AUDIO  : TGUID = '{e06d80e6-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_LPCM_AUDIO}

//
// AC-3 definition
//

  KSDATAFORMAT_SUBTYPE_AC3_AUDIO     : TGUID = '{e06d802c-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_AC3_AUDIO}
  KSDATAFORMAT_SPECIFIER_AC3_AUDIO   : TGUID = '{e06d80e4-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_AC3_AUDIO}
  KSPROPSETID_AC3                    : TGUID = '{BFABE720-6E1F-11D0-BCF2-444553540000}';
  {$EXTERNALSYM KSPROPSETID_AC3}

type
  KSPROPERTY_AC3 = (
    KSPROPERTY_AC3_Invalid,
    KSPROPERTY_AC3_ERROR_CONCEALMENT,
    KSPROPERTY_AC3_ALTERNATE_AUDIO,
    KSPROPERTY_AC3_DOWNMIX,
    KSPROPERTY_AC3_BIT_STREAM_MODE,
    KSPROPERTY_AC3_DIALOGUE_LEVEL,
    KSPROPERTY_AC3_LANGUAGE_CODE,
    KSPROPERTY_AC3_ROOM_TYPE
  );
  {$EXTERNALSYM KSPROPERTY_AC3}
  TKSPropertyAC3 = KSPROPERTY_AC3;


  PKSAC3ErrorConcealment = ^TKSAC3ErrorConcealment;
  KSAC3_ERROR_CONCEALMENT = record
    fRepeatPreviousBlock : BOOL;
    fErrorInCurrentBlock : BOOL;
  end;
  {$EXTERNALSYM KSAC3_ERROR_CONCEALMENT}
  PKSAC3_ERROR_CONCEALMENT = ^KSAC3_ERROR_CONCEALMENT;
  {$EXTERNALSYM PKSAC3_ERROR_CONCEALMENT}
  TKSAC3ErrorConcealment = KSAC3_ERROR_CONCEALMENT;

  PKSAC3AlternateAudio = ^TKSAC3AlternateAudio;
  KSAC3_ALTERNATE_AUDIO = record
    fStereo  : BOOL;
    DualMode : ULONG;
  end;
  {$EXTERNALSYM KSAC3_ALTERNATE_AUDIO}
  PKSAC3_ALTERNATE_AUDIO = ^KSAC3_ALTERNATE_AUDIO;
  {$EXTERNALSYM PKSAC3_ALTERNATE_AUDIO}
  TKSAC3AlternateAudio = KSAC3_ALTERNATE_AUDIO;

const
  KSAC3_ALTERNATE_AUDIO_1    = 1;
  {$EXTERNALSYM KSAC3_ALTERNATE_AUDIO_1}
  KSAC3_ALTERNATE_AUDIO_2    = 2;
  {$EXTERNALSYM KSAC3_ALTERNATE_AUDIO_2}
  KSAC3_ALTERNATE_AUDIO_BOTH = 3;
  {$EXTERNALSYM KSAC3_ALTERNATE_AUDIO_BOTH}

type
  PKSAC3DownMix = ^TKSAC3DownMix;
  KSAC3_DOWNMIX = record
    fDownMix       : BOOL;
    fDolbySurround : BOOL;
  end;
  {$EXTERNALSYM KSAC3_DOWNMIX}
  PKSAC3_DOWNMIX = ^KSAC3_DOWNMIX;
  {$EXTERNALSYM PKSAC3_DOWNMIX}
  TKSAC3DownMix = KSAC3_DOWNMIX;

  PKSAC3BitStreamMode = ^TKSAC3BitStreamMode;
  KSAC3_BIT_STREAM_MODE = record
    BitStreamMode : Longint;
  end;
  {$EXTERNALSYM KSAC3_BIT_STREAM_MODE}
  PKSAC3_BIT_STREAM_MODE = ^KSAC3_BIT_STREAM_MODE;
  {$EXTERNALSYM PKSAC3_BIT_STREAM_MODE}
  TKSAC3BitStreamMode = KSAC3_BIT_STREAM_MODE;

const
  KSAC3_SERVICE_MAIN_AUDIO        = 0;
  {$EXTERNALSYM KSAC3_SERVICE_MAIN_AUDIO}
  KSAC3_SERVICE_NO_DIALOG         = 1;
  {$EXTERNALSYM KSAC3_SERVICE_NO_DIALOG}
  KSAC3_SERVICE_VISUALLY_IMPAIRED = 2;
  {$EXTERNALSYM KSAC3_SERVICE_VISUALLY_IMPAIRED}
  KSAC3_SERVICE_HEARING_IMPAIRED  = 3;
  {$EXTERNALSYM KSAC3_SERVICE_HEARING_IMPAIRED}
  KSAC3_SERVICE_DIALOG_ONLY       = 4;
  {$EXTERNALSYM KSAC3_SERVICE_DIALOG_ONLY}
  KSAC3_SERVICE_COMMENTARY        = 5;
  {$EXTERNALSYM KSAC3_SERVICE_COMMENTARY}
  KSAC3_SERVICE_EMERGENCY_FLASH   = 6;
  {$EXTERNALSYM KSAC3_SERVICE_EMERGENCY_FLASH}
  KSAC3_SERVICE_VOICE_OVER        = 7;
  {$EXTERNALSYM KSAC3_SERVICE_VOICE_OVER}

type
  PKSAC3DialogueLevel = ^TKSAC3DialogueLevel;
  KSAC3_DIALOGUE_LEVEL = record
    DialogueLevel : ULONG;
  end;
  {$EXTERNALSYM KSAC3_DIALOGUE_LEVEL}
  PKSAC3_DIALOGUE_LEVEL = ^KSAC3_DIALOGUE_LEVEL;
  {$EXTERNALSYM PKSAC3_DIALOGUE_LEVEL}
  TKSAC3DialogueLevel = KSAC3_DIALOGUE_LEVEL;

  PKSAC3RoomType = ^TKSAC3RoomType;
  KSAC3_ROOM_TYPE = record
    fLargeRoom : BOOL;
  end;
  {$EXTERNALSYM KSAC3_ROOM_TYPE}
  PKSAC3_ROOM_TYPE = ^KSAC3_ROOM_TYPE;
  {$EXTERNALSYM PKSAC3_ROOM_TYPE}
  TKSAC3RoomType = KSAC3_ROOM_TYPE;

//
// DTS and SDDS definitions (media subtype GUIDs)
//
const
  KSDATAFORMAT_SUBTYPE_DTS_AUDIO  : TGUID = '{e06d8033-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_DTS_AUDIO}
  KSDATAFORMAT_SUBTYPE_SDDS_AUDIO : TGUID = '{e06d8034-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_SDDS_AUDIO}

//
// audio decoder output properties
//

  KSPROPSETID_AudioDecoderOut     : TGUID = '{6ca6e020-43bd-11d0-bd6a-003505c103a9}';
  {$EXTERNALSYM KSPROPSETID_AudioDecoderOut}

type
  KSPROPERTY_AUDDECOUT = (
    KSPROPERTY_AUDDECOUT_MODES,        // available output modes of decoder
    KSPROPERTY_AUDDECOUT_CUR_MODE      // current mode of the decoder
  );
  {$EXTERNALSYM KSPROPERTY_AUDDECOUT}
  TKSPropertyAuddecout = KSPROPERTY_AUDDECOUT;

const
  KSAUDDECOUTMODE_STEREO_ANALOG = $0001;
  {$EXTERNALSYM KSAUDDECOUTMODE_STEREO_ANALOG}
  KSAUDDECOUTMODE_PCM_51        = $0002;
  {$EXTERNALSYM KSAUDDECOUTMODE_PCM_51}
  KSAUDDECOUTMODE_SPDIFF        = $0004;
  {$EXTERNALSYM KSAUDDECOUTMODE_SPDIFF}

//
// subpicture definition
//

  KSDATAFORMAT_SUBTYPE_SUBPICTURE : TGUID = '{e06d802d-db46-11cf-b4d1-00805f6cbbea}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_SUBPICTURE}
  KSPROPSETID_DvdSubPic           : TGUID = '{ac390460-43af-11d0-bd6a-003505c103a9}';
  {$EXTERNALSYM KSPROPSETID_DvdSubPic}

type
  KSPROPERTY_DVDSUBPIC = (
    KSPROPERTY_DVDSUBPIC_PALETTE,
    KSPROPERTY_DVDSUBPIC_HLI,
    KSPROPERTY_DVDSUBPIC_COMPOSIT_ON  // TRUE for subpicture is displayed
  );
  {$EXTERNALSYM KSPROPERTY_DVDSUBPIC}
  TKSPropertyDVDSubPic = KSPROPERTY_DVDSUBPIC;

  PKSDVDYCrCb = ^TKSDVDYCrCb;
  _KS_DVD_YCrCb = record
    Reserved : byte;
    Y        : byte;
    Cr       : byte;
    Cb       : byte;
  end;
  {$EXTERNALSYM _KS_DVD_YCrCb}
  KS_DVD_YCrCb = _KS_DVD_YCrCb;
  {$EXTERNALSYM KS_DVD_YCrCb}
  PKS_DVD_YCrCb = ^KS_DVD_YCrCb;
  {$EXTERNALSYM PKS_DVD_YCrCb}
  TKSDVDYCrCb = _KS_DVD_YCrCb;

// The KS_DVD_YUV structure is now superseded by KS_DVD_YCrCb above and is
//   here for backward compatibility only

  PKSDVDYUV = ^TKSDVDYUV;
  _KS_DVD_YUV = record
    Reserved : byte;
    Y        : byte;
    V        : byte;
    U        : byte;
  end;
  {$EXTERNALSYM _KS_DVD_YUV}
  KS_DVD_YUV = _KS_DVD_YUV;
  {$EXTERNALSYM KS_DVD_YUV}
  PKS_DVD_YUV = ^KS_DVD_YUV;
  {$EXTERNALSYM PKS_DVD_YUV}
  TKSDVDYUV = _KS_DVD_YUV;

  PKSPropertySPPAL = ^TKSPropertySPPAL;
  _KSPROPERTY_SPPAL = record
    sppal : array[0..15] of TKSDVDYUV;
  end;
  {$EXTERNALSYM _KSPROPERTY_SPPAL}
  KSPROPERTY_SPPAL = _KSPROPERTY_SPPAL;
  {$EXTERNALSYM KSPROPERTY_SPPAL}
  PKSPROPERTY_SPPAL = ^KSPROPERTY_SPPAL;
  {$EXTERNALSYM PKSPROPERTY_SPPAL}
  TKSPropertySPPAL = _KSPROPERTY_SPPAL;

  PKSColCon = ^TKSColCon;
  _KS_COLCON = record
    emph1col : byte; //:4;
    emph2col : byte; //:4;
    backcol  : byte; //:4;
    patcol   : byte; //:4;
    emph1con : byte; //:4;
    emph2con : byte; //:4;
    backcon  : byte; //:4;
    patcon   : byte; //:4;
  end;
  {$EXTERNALSYM _KS_COLCON}
  KS_COLCON = _KS_COLCON;
  {$EXTERNALSYM KS_COLCON}
  PKS_COLCON = ^KS_COLCON;
  {$EXTERNALSYM PKS_COLCON}
  TKSColCon = _KS_COLCON;

  PKSPropertySPHLI = ^TKSPropertySPHLI;
  _KSPROPERTY_SPHLI = record
    HLISS    : WORD;
    Reserved : WORD;
    StartPTM : ULONG;      // start presentation time in x/90000
    EndPTM   : ULONG;      // end PTM in x/90000
    StartX   : WORD;
    StartY   : WORD;
    StopX    : WORD;
    StopY    : WORD;
    ColCon   : TKSColCon; // color contrast description (4 bytes as given in HLI)
  end;
  {$EXTERNALSYM _KSPROPERTY_SPHLI}
  KSPROPERTY_SPHLI = _KSPROPERTY_SPHLI;
  {$EXTERNALSYM KSPROPERTY_SPHLI}
  PKSPROPERTY_SPHLI = ^KSPROPERTY_SPHLI;
  {$EXTERNALSYM PKSPROPERTY_SPHLI}
  TKSPropertySPHLI = _KSPROPERTY_SPHLI;

  PKSPROPERTY_COMPOSIT_ON = ^KSPROPERTY_COMPOSIT_ON;
  {$EXTERNALSYM PKSPROPERTY_COMPOSIT_ON}
  KSPROPERTY_COMPOSIT_ON = {$IFDEF TYPE_IDENTITY}type {$ENDIF} BOOL;
  {$EXTERNALSYM KSPROPERTY_COMPOSIT_ON}

const
  KSPROPSETID_CopyProt : TGUID = '{0E8A0A40-6AEF-11D0-9ED0-00A024CA19B3}';
  {$EXTERNALSYM KSPROPSETID_CopyProt}

type
  KSPROPERTY_COPYPROT = {$IFDEF TYPE_IDENTITY}type {$ENDIF} LongWord;
  {$EXTERNALSYM KSPROPERTY_COPYPROT}
  const
    KSPROPERTY_DVDCOPY_CHLG_KEY       = $01;
    {$EXTERNALSYM KSPROPERTY_DVDCOPY_CHLG_KEY}
    KSPROPERTY_DVDCOPY_DVD_KEY1       = $02;
    {$EXTERNALSYM KSPROPERTY_DVDCOPY_DVD_KEY1}
    KSPROPERTY_DVDCOPY_DEC_KEY2       = $03;
    {$EXTERNALSYM KSPROPERTY_DVDCOPY_DEC_KEY2}
    KSPROPERTY_DVDCOPY_TITLE_KEY      = $04;
    {$EXTERNALSYM KSPROPERTY_DVDCOPY_TITLE_KEY}
    KSPROPERTY_COPY_MACROVISION       = $05;
    {$EXTERNALSYM KSPROPERTY_COPY_MACROVISION}
    KSPROPERTY_DVDCOPY_REGION         = $06;
    {$EXTERNALSYM KSPROPERTY_DVDCOPY_REGION}
    KSPROPERTY_DVDCOPY_SET_COPY_STATE = $07;
    {$EXTERNALSYM KSPROPERTY_DVDCOPY_SET_COPY_STATE}
    KSPROPERTY_DVDCOPY_DISC_KEY       = $80;
    {$EXTERNALSYM KSPROPERTY_DVDCOPY_DISC_KEY}

type
  PKSDVDCopyCHLGKey = ^TKSDVDCopyCHLGKey;
  _KS_DVDCOPY_CHLGKEY = record
   ChlgKey   : array[0..9] of BYTE;
   Reserved  : array[0..1] of BYTE;
  end;
  {$EXTERNALSYM _KS_DVDCOPY_CHLGKEY}
  KS_DVDCOPY_CHLGKEY = _KS_DVDCOPY_CHLGKEY;
  {$EXTERNALSYM KS_DVDCOPY_CHLGKEY}
  PKS_DVDCOPY_CHLGKEY = ^KS_DVDCOPY_CHLGKEY;
  {$EXTERNALSYM PKS_DVDCOPY_CHLGKEY}
  TKSDVDCopyCHLGKey = _KS_DVDCOPY_CHLGKEY;

  PKSDVDCopyBusKey = ^TKSDVDCopyBusKey;
  _KS_DVDCOPY_BUSKEY = record
    BusKey   : array[0..4] of BYTE;
    Reserved : array[0..0] of BYTE;
  end;
  {$EXTERNALSYM _KS_DVDCOPY_BUSKEY}
  KS_DVDCOPY_BUSKEY = _KS_DVDCOPY_BUSKEY;
  {$EXTERNALSYM KS_DVDCOPY_BUSKEY}
  PKS_DVDCOPY_BUSKEY = ^KS_DVDCOPY_BUSKEY;
  {$EXTERNALSYM PKS_DVDCOPY_BUSKEY}
  TKSDVDCopyBusKey = _KS_DVDCOPY_BUSKEY;

  PKSDVDCopyDiscKey = ^TKSDVDCopyDiscKey;
  _KS_DVDCOPY_DISCKEY = record
    DiscKey : array[0..2047] of BYTE;
  end;
  {$EXTERNALSYM _KS_DVDCOPY_DISCKEY}
  KS_DVDCOPY_DISCKEY = _KS_DVDCOPY_DISCKEY;
  {$EXTERNALSYM KS_DVDCOPY_DISCKEY}
  PKS_DVDCOPY_DISCKEY = ^KS_DVDCOPY_DISCKEY;
  {$EXTERNALSYM PKS_DVDCOPY_DISCKEY}
  TKSDVDCopyDiscKey = _KS_DVDCOPY_DISCKEY;

  PKSDVDCopyRegion = ^TKSDVDCopyRegion;
  _KS_DVDCOPY_REGION = record
    Reserved   : UCHAR;
    RegionData : UCHAR;
    Reserved2  : array[0..1] of UCHAR;
  end;
  {$EXTERNALSYM _KS_DVDCOPY_REGION}
  KS_DVDCOPY_REGION = _KS_DVDCOPY_REGION;
  {$EXTERNALSYM KS_DVDCOPY_REGION}
  PKS_DVDCOPY_REGION = ^KS_DVDCOPY_REGION;
  {$EXTERNALSYM PKS_DVDCOPY_REGION}
  TKSDVDCopyRegion = _KS_DVDCOPY_REGION;

  PKSDVDCopyTitleKey = ^TKSDVDCopyTitleKey;
  _KS_DVDCOPY_TITLEKEY = record
    KeyFlags   : ULONG;
    ReservedNT : array[0..1] of ULONG;
    TitleKey   : array[0..5] of UCHAR;
    Reserved   : array[0..1] of UCHAR;
  end;
  {$EXTERNALSYM _KS_DVDCOPY_TITLEKEY}
  KS_DVDCOPY_TITLEKEY = _KS_DVDCOPY_TITLEKEY;
  {$EXTERNALSYM KS_DVDCOPY_TITLEKEY}
  PKS_DVDCOPY_TITLEKEY = ^KS_DVDCOPY_TITLEKEY;
  {$EXTERNALSYM PKS_DVDCOPY_TITLEKEY}
  TKSDVDCopyTitleKey = _KS_DVDCOPY_TITLEKEY;

  PKSCopyMacrovision = ^TKSCopyMacrovision;
  _KS_COPY_MACROVISION = record
    MACROVISIONLevel : ULONG;
  end;
  {$EXTERNALSYM _KS_COPY_MACROVISION}
  KS_COPY_MACROVISION = _KS_COPY_MACROVISION;
  {$EXTERNALSYM KS_COPY_MACROVISION}
  PKS_COPY_MACROVISION = ^KS_COPY_MACROVISION;
  {$EXTERNALSYM PKS_COPY_MACROVISION}
  TKSCopyMacrovision = _KS_COPY_MACROVISION;

  PKSDVDCopySetCopyState = ^TKSDVDCopySetCopyState;
  _KS_DVDCOPY_SET_COPY_STATE = record
    DVDCopyState : ULONG;
  end;
  {$EXTERNALSYM _KS_DVDCOPY_SET_COPY_STATE}
  KS_DVDCOPY_SET_COPY_STATE = _KS_DVDCOPY_SET_COPY_STATE;
  {$EXTERNALSYM KS_DVDCOPY_SET_COPY_STATE}
  PKS_DVDCOPY_SET_COPY_STATE = ^KS_DVDCOPY_SET_COPY_STATE;
  {$EXTERNALSYM PKS_DVDCOPY_SET_COPY_STATE}
  TKSDVDCopySetCopyState = _KS_DVDCOPY_SET_COPY_STATE;

  KS_DVDCOPYSTATE = (
    KS_DVDCOPYSTATE_INITIALIZE,         // indicates we are starting a full
                                        // copy protection sequence.
    KS_DVDCOPYSTATE_INITIALIZE_TITLE,   // indicates we are starting a title
                                        // key copy protection sequence
    KS_DVDCOPYSTATE_AUTHENTICATION_NOT_REQUIRED,
    KS_DVDCOPYSTATE_AUTHENTICATION_REQUIRED,
    KS_DVDCOPYSTATE_DONE
  );
  {$EXTERNALSYM KS_DVDCOPYSTATE}
  TKSDVDCopyState = KS_DVDCOPYSTATE;

  PKSCopyMacrovisionLevel = ^TKSCopyMacrovisionLevel;
  KS_COPY_MACROVISION_LEVEL = (
    KS_MACROVISION_DISABLED,
    KS_MACROVISION_LEVEL1,
    KS_MACROVISION_LEVEL2,
    KS_MACROVISION_LEVEL3
  );
  {$EXTERNALSYM KS_COPY_MACROVISION_LEVEL}
  PKS_COPY_MACROVISION_LEVEL = ^KS_COPY_MACROVISION_LEVEL;
  {$EXTERNALSYM PKS_COPY_MACROVISION_LEVEL}
  TKSCopyMacrovisionLevel = KS_COPY_MACROVISION_LEVEL;


//
// CGMS Copy Protection Flags
//
const
  KS_DVD_CGMS_RESERVED_MASK     = $00000078;
  {$EXTERNALSYM KS_DVD_CGMS_RESERVED_MASK}

  KS_DVD_CGMS_COPY_PROTECT_MASK = $00000018;
  {$EXTERNALSYM KS_DVD_CGMS_COPY_PROTECT_MASK}
  KS_DVD_CGMS_COPY_PERMITTED    = $00000000;
  {$EXTERNALSYM KS_DVD_CGMS_COPY_PERMITTED}
  KS_DVD_CGMS_COPY_ONCE         = $00000010;
  {$EXTERNALSYM KS_DVD_CGMS_COPY_ONCE}
  KS_DVD_CGMS_NO_COPY           = $00000018;
  {$EXTERNALSYM KS_DVD_CGMS_NO_COPY}

  KS_DVD_COPYRIGHT_MASK         = $00000040;
  {$EXTERNALSYM KS_DVD_COPYRIGHT_MASK}
  KS_DVD_NOT_COPYRIGHTED        = $00000000;
  {$EXTERNALSYM KS_DVD_NOT_COPYRIGHTED}
  KS_DVD_COPYRIGHTED            = $00000040;
  {$EXTERNALSYM KS_DVD_COPYRIGHTED}

  KS_DVD_SECTOR_PROTECT_MASK    = $00000020;
  {$EXTERNALSYM KS_DVD_SECTOR_PROTECT_MASK}
  KS_DVD_SECTOR_NOT_PROTECTED   = $00000000;
  {$EXTERNALSYM KS_DVD_SECTOR_NOT_PROTECTED}
  KS_DVD_SECTOR_PROTECTED       = $00000020;
  {$EXTERNALSYM KS_DVD_SECTOR_PROTECTED}

//===========================================================================
// The following MUST match the structures in WinGDI.h and AMVideo.h
//===========================================================================

  KSCATEGORY_TVTUNER                 : TGUID = '{a799a800-a46d-11d0-a18c-00a02401dcd4}';
  {$EXTERNALSYM KSCATEGORY_TVTUNER}
  KSCATEGORY_CROSSBAR                : TGUID = '{a799a801-a46d-11d0-a18c-00a02401dcd4}';
  {$EXTERNALSYM KSCATEGORY_CROSSBAR}
  KSCATEGORY_TVAUDIO                 : TGUID = '{a799a802-a46d-11d0-a18c-00a02401dcd4}';
  {$EXTERNALSYM KSCATEGORY_TVAUDIO}
  KSCATEGORY_VPMUX                   : TGUID = '{a799a803-a46d-11d0-a18c-00a02401dcd4}';
  {$EXTERNALSYM KSCATEGORY_VPMUX}
  KSCATEGORY_VBICODEC                : TGUID = '{07dad660-22f1-11d1-a9f4-00c04fbbde8f}';
  {$EXTERNALSYM KSCATEGORY_VBICODEC}

  // SUBTYPE_VPVideo
  KSDATAFORMAT_SUBTYPE_VPVideo       : TGUID = '{5a9b6a40-1a22-11d1-bad9-00609744111a}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_VPVideo}

  // SUBTYPE_VPVBI
  KSDATAFORMAT_SUBTYPE_VPVBI         : TGUID = '{5a9b6a41-1a22-11d1-bad9-00609744111a}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_VPVBI}

  // FORMAT_VideoInfo
  KSDATAFORMAT_SPECIFIER_VIDEOINFO   : TGUID = '{05589f80-c356-11ce-bf01-00aa0055595a}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_VIDEOINFO}

  // FORMAT_VideoInfo2
  KSDATAFORMAT_SPECIFIER_VIDEOINFO2  : TGUID = '{f72a76A0-eb0a-11d0-ace4-0000c0cc16ba}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_VIDEOINFO2}

  // MEDIATYPE_AnalogVideo
  KSDATAFORMAT_TYPE_ANALOGVIDEO      : TGUID = '{0482dde1-7817-11cf-8a03-00aa006ecb65}';
  {$EXTERNALSYM KSDATAFORMAT_TYPE_ANALOGVIDEO}

  // FORMAT_AnalogVideo
  KSDATAFORMAT_SPECIFIER_ANALOGVIDEO : TGUID = '{0482dde0-7817-11cf-8a03-00aa006ecb65}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_ANALOGVIDEO}

  // FORMAT_VBI
  KSDATAFORMAT_SPECIFIER_VBI         : TGUID = '{f72a76e0-eb0a-11d0-ace4-0000c0cc16ba}';
  {$EXTERNALSYM KSDATAFORMAT_SPECIFIER_VBI}

  // MEDIATYPE_VBI
  KSDATAFORMAT_TYPE_VBI              : TGUID = '{f72a76e1-eb0a-11d0-ace4-0000c0cc16ba}';
  {$EXTERNALSYM KSDATAFORMAT_TYPE_VBI}

  // SUBTYPE_RAW8
  KSDATAFORMAT_SUBTYPE_RAW8          : TGUID = '{ca20d9a0-3e3e-11d1-9bf9-00c04fbbdebf}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_RAW8}

  // MEDIASUBTYPE_CC
  KSDATAFORMAT_SUBTYPE_CC            : TGUID = '{33214CC1-011F-11D2-B4B1-00A0D102CFBE}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_CC}

  // MEDIASUBTYPE_NABTS
  KSDATAFORMAT_SUBTYPE_NABTS         : TGUID = '{f72a76e2-eb0a-11d0-ace4-0000c0cc16ba}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_NABTS}

  // MEDIASUBTYPE_TELETEXT
  KSDATAFORMAT_SUBTYPE_TELETEXT      : TGUID = '{f72a76e3-eb0a-11d0-ace4-0000c0cc16ba}';
  {$EXTERNALSYM KSDATAFORMAT_SUBTYPE_TELETEXT}


// constants for the biCompression field
  KS_BI_RGB       = 0;
  {$EXTERNALSYM KS_BI_RGB}
  KS_BI_RLE8      = 1;
  {$EXTERNALSYM KS_BI_RLE8}
  KS_BI_RLE4      = 2;
  {$EXTERNALSYM KS_BI_RLE4}
  KS_BI_BITFIELDS = 3;
  {$EXTERNALSYM KS_BI_BITFIELDS}

type
  PKSRGBQuad = ^TKSRGBQuad;
  tagKS_RGBQUAD = record // rgbq
    rgbBlue     : BYTE;
    rgbGreen    : BYTE;
    rgbRed      : BYTE;
    rgbReserved : BYTE;
  end;
  {$EXTERNALSYM tagKS_RGBQUAD}
  KS_RGBQUAD = tagKS_RGBQUAD;
  {$EXTERNALSYM KS_RGBQUAD}
  PKS_RGBQUAD = ^KS_RGBQUAD;
  {$EXTERNALSYM PKS_RGBQUAD}
  TKSRGBQuad = tagKS_RGBQUAD;

// constants for palettes
const
  KS_iPALETTE_COLORS  = 256; // Maximum colours in palette
  {$EXTERNALSYM KS_iPALETTE_COLORS}
  KS_iEGA_COLORS      = 16;  // Number colours in EGA palette
  {$EXTERNALSYM KS_iEGA_COLORS}
  KS_iMASK_COLORS     = 3;   // Maximum three components
  {$EXTERNALSYM KS_iMASK_COLORS}
  KS_iTRUECOLOR       = 16;  // Minimum true colour device
  {$EXTERNALSYM KS_iTRUECOLOR}
  KS_iRED             = 0;   // Index position for RED mask
  {$EXTERNALSYM KS_iRED}
  KS_iGREEN           = 1;   // Index position for GREEN mask
  {$EXTERNALSYM KS_iGREEN}
  KS_iBLUE            = 2;   // Index position for BLUE mask
  {$EXTERNALSYM KS_iBLUE}
  KS_iPALETTE         = 8;   // Maximum colour depth using a palette
  {$EXTERNALSYM KS_iPALETTE}
  KS_iMAXBITS         = 8;   // Maximum bits per colour component
  {$EXTERNALSYM KS_iMAXBITS}
  KS_SIZE_EGA_PALETTE = (KS_iEGA_COLORS * sizeof(TKSRGBQUAD));
  {$EXTERNALSYM KS_SIZE_EGA_PALETTE}
  KS_SIZE_PALETTE     = (KS_iPALETTE_COLORS * sizeof(TKSRGBQUAD));
  {$EXTERNALSYM KS_SIZE_PALETTE}

type
  PKSBitmapInfoHeader = ^TKSBitmapInfoHeader;
  tagKS_BITMAPINFOHEADER = record
    biSize          : DWORD;
    biWidth         : longint;
    biHeight        : longint;
    biPlanes        : WORD;
    biBitCount      : WORD;
    biCompression   : DWORD;
    biSizeImage     : DWORD;
    biXPelsPerMeter : longint;
    biYPelsPerMeter : longint;
    biClrUsed       : DWORD;
    biClrImportant  : DWORD;
  end;
  {$EXTERNALSYM tagKS_BITMAPINFOHEADER}
  KS_BITMAPINFOHEADER = tagKS_BITMAPINFOHEADER;
  {$EXTERNALSYM KS_BITMAPINFOHEADER}
  PKS_BITMAPINFOHEADER = ^KS_BITMAPINFOHEADER;
  {$EXTERNALSYM PKS_BITMAPINFOHEADER}
  TKSBitmapInfoHeader = tagKS_BITMAPINFOHEADER;

// Used for true colour images that also have a palette

  PKSTrueColorInfo = ^TKSTrueColorInfo;
  tag_KS_TRUECOLORINFO = record
    dwBitMasks : array[0..KS_iMASK_COLORS-1]    of DWORD;
    bmiColors  : array[0..KS_iPALETTE_COLORS-1] of TKSRGBQUAD;
  end;
  {$EXTERNALSYM tag_KS_TRUECOLORINFO}
  KS_TRUECOLORINFO = tag_KS_TRUECOLORINFO;
  {$EXTERNALSYM KS_TRUECOLORINFO}
  PKS_TRUECOLORINFO = ^KS_TRUECOLORINFO;
  {$EXTERNALSYM PKS_TRUECOLORINFO}
  TKSTrueColorInfo = tag_KS_TRUECOLORINFO;

//  KS_WIDTHBYTES(bits)  ((DWORD)(((bits)+31) & (~31)) / 8)
//  KS_DIBWIDTHBYTES(bi) (DWORD)KS_WIDTHBYTES((DWORD)(bi).biWidth * (DWORD)(bi).biBitCount)
//  KS__DIBSIZE(bi)      (KS_DIBWIDTHBYTES(bi) * (DWORD)(bi).biHeight)
//  KS_DIBSIZE(bi)       ((bi).biHeight < 0 ? (-1)*(KS__DIBSIZE(bi)) : KS__DIBSIZE(bi))

//  typedef  REFERENCE_TIME: int64;

// The BITMAPINFOHEADER contains all the details about the video stream such
// as the actual image dimensions and their pixel depth. A source filter may
// also request that the sink take only a section of the video by providing a
// clipping rectangle in rcSource. In the worst case where the sink filter
// forgets to check this on connection it will simply render the whole thing
// which isn't a disaster. Ideally a sink filter will check the rcSource and
// if it doesn't support image extraction and the rectangle is not empty then
// it will reject the connection. A filter should use SetRectEmpty to reset a
// rectangle to all zeroes (and IsRectEmpty to later check the rectangle).
// The rcTarget specifies the destination rectangle for the video, for most
// source filters they will set this to all zeroes, a downstream filter may
// request that the video be placed in a particular area of the buffers it
// supplies in which case it will call QueryAccept with a non empty target

  PKSVideoInfoHeader = ^TKSVideoInfoHeader;
  tagKS_VIDEOINFOHEADER = record
    rcSource        : TRECT;               // The bit we really want to use
    rcTarget        : TRECT;               // Where the video should go
    dwBitRate       : DWORD;               // Approximate bit data rate
    dwBitErrorRate  : DWORD;               // Bit error rate for this stream
    AvgTimePerFrame : TReferenceTime;     // Average time per frame (100ns units)
    bmiHeader       : TKSBitmapInfoHeader;
  end;
  {$EXTERNALSYM tagKS_VIDEOINFOHEADER}
  KS_VIDEOINFOHEADER = tagKS_VIDEOINFOHEADER;
  {$EXTERNALSYM KS_VIDEOINFOHEADER}
  PKS_VIDEOINFOHEADER = ^KS_VIDEOINFOHEADER;
  {$EXTERNALSYM PKS_VIDEOINFOHEADER}
  TKSVideoInfoHeader = tagKS_VIDEOINFOHEADER;

// !!! WARNING !!!
// DO NOT use the following structure unless you are sure that the BITMAPINFOHEADER
// has a normal biSize == sizeof(BITMAPINFOHEADER) !
// !!! WARNING !!!

  PKSVideoInfo = ^TKSVideoInfo;
  tagKS_VIDEOINFO = record
    rcSource        : TRECT;           // The bit we really want to use
    rcTarget        : TRECT;           // Where the video should go
    dwBitRate       : DWORD;           // Approximate bit data rate
    dwBitErrorRate  : DWORD;           // Bit error rate for this stream
    AvgTimePerFrame : TReferenceTime; // Average time per frame (100ns units)
    bmiHeader       : TKSBitmapInfoHeader;
    case integer of
      0: (bmiColors     : array[0..KS_iPALETTE_COLORS-1] of TKSRGBQUAD); // Colour palette
      1: (dwBitMasks    : array[0..KS_iMASK_COLORS-1] of DWORD);          // True colour masks
      2: (TrueColorInfo : TKSTrueColorInfo);                             // Both of the above
  end;
  {$EXTERNALSYM tagKS_VIDEOINFO}
  KS_VIDEOINFO = tagKS_VIDEOINFO;
  {$EXTERNALSYM KS_VIDEOINFO}
  PKS_VIDEOINFO = ^KS_VIDEOINFO;
  {$EXTERNALSYM PKS_VIDEOINFO}
  TKSVideoInfo = tagKS_VIDEOINFO;

const
  KS_SIZE_MASKS     = (KS_iMASK_COLORS * sizeof(DWORD));
  {$EXTERNALSYM KS_SIZE_MASKS}
//  KS_SIZE_PREHEADER = (FIELD_OFFSET(KS_VIDEOINFOHEADER,bmiHeader))

// For normal size
// #define KS_SIZE_VIDEOHEADER (sizeof(KS_BITMAPINFOHEADER) + KS_SIZE_PREHEADER)
// !!! for abnormal biSizes
//#define KS_SIZE_VIDEOHEADER(pbmi) ((pbmi)->bmiHeader.biSize + KS_SIZE_PREHEADER)

// VBI
// Used for NABTS, CC, Intercast,
type
  PKSVBIInfoHeader = ^TKSVBIInfoHeader;
  tagKS_VBIINFOHEADER = record
    StartLine           : ULONG; // inclusive
    EndLine             : ULONG; // inclusive
    SamplingFrequency   : ULONG; // Hz.
    MinLineStartTime    : ULONG; // microSec * 100 from HSync LE
    MaxLineStartTime    : ULONG; // microSec * 100 from HSync LE
    ActualLineStartTime : ULONG; // microSec * 100 from HSync LE
    ActualLineEndTime   : ULONG; // microSec * 100 from HSync LE
    VideoStandard       : ULONG; // KS_AnalogVideoStandard*
    SamplesPerLine      : ULONG;
    StrideInBytes       : ULONG; // May be > SamplesPerLine
    BufferSize          : ULONG; // Bytes
  end;
  {$EXTERNALSYM tagKS_VBIINFOHEADER}
  KS_VBIINFOHEADER = tagKS_VBIINFOHEADER;
  {$EXTERNALSYM KS_VBIINFOHEADER}
  PKS_VBIINFOHEADER = ^KS_VBIINFOHEADER;
  {$EXTERNALSYM PKS_VBIINFOHEADER}
  TKSVBIInfoHeader = tagKS_VBIINFOHEADER;

// VBI Sampling Rates
const
  KS_VBIDATARATE_NABTS         = 5727272;
  {$EXTERNALSYM KS_VBIDATARATE_NABTS}
  KS_VBIDATARATE_CC            = 503493;    // ~= 1/1.986125e-6
  {$EXTERNALSYM KS_VBIDATARATE_CC}
  KS_VBISAMPLINGRATE_4X_NABTS  = longint(4*KS_VBIDATARATE_NABTS);
  {$EXTERNALSYM KS_VBISAMPLINGRATE_4X_NABTS}
  KS_VBISAMPLINGRATE_47X_NABTS = longint(27000000);
  {$EXTERNALSYM KS_VBISAMPLINGRATE_47X_NABTS}
  KS_VBISAMPLINGRATE_5X_NABTS  = longint(5*KS_VBIDATARATE_NABTS);
  {$EXTERNALSYM KS_VBISAMPLINGRATE_5X_NABTS}

  KS_47NABTS_SCALER = KS_VBISAMPLINGRATE_47X_NABTS/KS_VBIDATARATE_NABTS;
  {$EXTERNALSYM KS_47NABTS_SCALER}

// Analog video variant - Use this when the format is FORMAT_AnalogVideo
//
// rcSource defines the portion of the active video signal to use
// rcTarget defines the destination rectangle
//    both of the above are relative to the dwActiveWidth and dwActiveHeight fields
// dwActiveWidth is currently set to 720 for all formats (but could change for HDTV)
// dwActiveHeight is 483 for NTS