{******************************************************************************}
{ FileName............: SetDefaultsStv0299                                     }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Write defaults to STV0299                                                   }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ Result is in exit code:                                                      }
{    $0000 = No error                                                          }
{    $10xx = Driver/card not available                                         }
{    $20xx = Operation failed                                                  }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20030919 - Initial release                                           }
{******************************************************************************}
program SetDefaultsStv0299;

uses
  SysUtils, Windows,
  Saa7146aI2c,
  Saa7146aInterface;

var
  CardHandle: THandle;
  Error     : Integer;
begin
  if Saa7146aGetNumberOfCards = 0 then
    Halt($1000);
  // Note: We can not use a HALT from this point on because the ..finally..
  //       part of the try..finally is then NOT executed!
  Error := $2000;
  CardHandle := Saa7146aCreateFile(-1);
  try
    // Only for the BSRU6 ....
    // Use <CTunerSU1278> for the SU1278
    if Saa7146aWriteDefaultsToQpsk(CardHandle, CTunerBSRU6) then
      Error := $0000;
  finally
    Saa7146aCloseHandle(CardHandle);
    Halt(Error);
  end;
end.
