{******************************************************************************}
{ FileName............: ReadRegisterStv0299                                    }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Read value from register of STV0299                                         }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ Usage:                                                                       }
{    programname register                                                      }
{ Result is in the exit code $0000-$00FF is a valid result                     }
{ Other result indicate an error:                                              }
{    $00xx = No error, data in low part                                        }
{    $01xx = Invalid number of parameters                                      }
{    $02xx = First parameter incorrect                                         }
{    $03xx = 2nd parameter incorrect                                           }
{    $04xx = 3rd parameter incorrect                                           }
{    $05xx = etc                                                               }
{    $10xx = Driver/card not available                                         }
{    $20xx = Operation failed                                                  }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20030102 - Initial release                                           }
{******************************************************************************}
program ReadRegisterStv0299;

uses
  SysUtils, Windows,
  Saa7146aI2c,
  Saa7146aInterface,
  Stv0299bRegisters;

var
  CardHandle    : THandle;
  AccessRegister: Integer;
  ReturnedByte  : Byte;
  Error         : Integer;
begin
  if ParamCount <> 1 then
    Halt($0100);
  Val(ParamStr(1), AccessRegister, Error);
  if Error <> 0 then
    Halt($0200);
  if not (AccessRegister in [Low(CStv0299bRegisterTexts)..High(CStv0299bRegisterTexts)]) then
    Halt($0200);
  if Saa7146aGetNumberOfCards = 0 then
    Halt($1000);
  // Note: We can not use a HALT from this point on because the ..finally..
  //       part of the try..finaly is then NOT executed!
  Error := $2000;
  CardHandle := Saa7146aCreateFile(-1);
  try
    if Saa7146aReadFromQpsk(CardHandle, Lo(AccessRegister), ReturnedByte) then
      Error := ReturnedByte;
  finally
    Saa7146aCloseHandle(CardHandle);
    Halt(Error);
  end;
end.
