{******************************************************************************}
{ FileName............: CheckingHardwareUnit001                                }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.01                                                   }
{------------------------------------------------------------------------------}
{  Checking the hardware.                                                      }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20030917 - Initial WDM release                                       }
{  1.01   20040419 - Adapted for vaiable synthesizer address                   }
{******************************************************************************}
unit CheckingHardwareUnit001;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Saa7146AInterface, Saa7146aGpio, Saa7146AI2c, Stv0299bRegisters,
  Tsa5059Registers, ExtCtrls,
Saa7146aRegisters;
type
  TfrmMain = class(TForm)
    btnExit: TButton;
    mmoDriver: TMemo;
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Creation of form.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.FormCreate(Sender: TObject);
var
  CardHandle         : THandle;
  MajorVersion       : Word;
  MinorVersion       : Word;
  Build              : Dword;
  DeviceName         : PChar;
  ReturnedByte       : Byte;
  SynthesizerAddress : Byte;
begin
  // Check if the driver is present and/or multiple cards are present
  case Saa7146aGetNumberOfCards of
    0:   mmoDriver.Lines.Add('No SAA7146A driver and/or card detected.');
    1:   mmoDriver.Lines.Add('One SAA7146A card detected.');
    else mmoDriver.Lines.Add(format('%d SAA7146A cards detected.', [Saa7146aGetNumberOfCards]));
  end;
  // If any card detected then display additional information
  if Saa7146aGetNumberOfCards <> 0 then
  begin
    // At this time we don't have a link to the driver itself. We have to create this.
    // We use the first available card (-1==auto) there is.
    CardHandle := Saa7146aCreateFile(-1);
    try
      // Now with the handle we can actually access the driver.
      // Start with getting the version information of the driver.
      GetMem(DeviceName, 128);
      if Saa7146aGetDriverVersion(CardHandle, @MajorVersion, @MinorVersion, @Build, DeviceName) then
        mmoDriver.Lines.Add(format('Driver "%s", Version %d.%d, Build %8.8x.', [DeviceName, MajorVersion, MinorVersion, Build]));
      FreeMem(DeviceName);
      if not Saa7146aWriteToSaa7146aRegister(CardHandle, CSaa7146aMc1, CSaa7146aMc1SoftReset) then
        mmoDriver.Lines.Add('Could not issue a soft reset');

      // The RESET of the tuner is connected to a GPIO line of the SAA7146A, so we have to configure this
      // Note: Not all tuner have this reset line (eg. Cinergy 1200 DVB-S has no reset facility)
      if not Saa7146aInitializeGpio(CardHandle, True) then
      begin
        mmoDriver.Lines.Add('Could not initialize GPIO.');
        Exit;
      end;
      mmoDriver.Lines.Add('------ BSRU6 tuner ------');
      // Now issue a reset signal
      if not Saa7146aIssueReset(CardHandle, 2) then
      begin
        mmoDriver.Lines.Add('Could not issue a reset.');
        Exit;
      end;
      mmoDriver.Lines.Add('Tuner has been reset.');
      if Saa7146aInitializeI2c(CardHandle) then
      begin
        mmoDriver.Lines.Add('I2C initialized.');
        if Saa7146aReadFromQpsk(CardHandle, CStv0299bId, ReturnedByte) then
        begin
          if ReturnedByte = $A1 then
          begin
            mmoDriver.Lines.Add(format('QPSK demodulator identification correct ($%x).', [ReturnedByte]));
            if Saa7146aCheckQpskResetValues(CardHandle) then
              mmoDriver.Lines.Add('QPSK registers after reset comply with expected values.')
            else
              mmoDriver.Lines.Add('QPSK registers after reset DO NOT comply with expected values.')
          end
          else
            mmoDriver.Lines.Add(format('QPSK demodulator identification NOT correct ($%x).', [ReturnedByte]));

          if Saa7146aWriteDefaultsToQpsk(CardHandle, CTunerBSRU6) then
            mmoDriver.Lines.Add('QPSK registers set to default values BSRU6.')
          else
            mmoDriver.Lines.Add('QPSK registers could not be set to default values.');
          if Saa7146aCheckQpskDefaultValues(CardHandle, CTunerBSRU6) then
            mmoDriver.Lines.Add('QPSK registers after default comply with expected values BSRU6.')
          else
            mmoDriver.Lines.Add('QPSK registers after default DO NOT comply with expected values BSRU6 (might be normal!).');

          if Saa7146aEnableLNB(CardHandle, True) then
          begin
            mmoDriver.Lines.Add('LNB enabled.');
            Saa7146aUsDelay(2000);
          end
          else
            mmoDriver.Lines.Add('Enabling LNB failed -> ' + Saa7146aGetLastI2CError);

          if Saa7146aVerticalPolarityLNB(CardHandle, True) then
            mmoDriver.Lines.Add('Vertical polarity set.')
          else
            mmoDriver.Lines.Add('Setting vertical polarity failed -> ' + Saa7146aGetLastI2CError);

          SynthesizerAddress := Saa7146aDetectSynthesizerAddress(CardHandle);
          if SynthesizerAddress <> 255 then
            mmoDriver.Lines.Add(format('Synthesizer address detection successful (address %d).', [SynthesizerAddress]))
          else
            mmoDriver.Lines.Add('Synthesizer address detection SU1278 failed -> ' + Saa7146aGetLastI2CError);

          if Saa7146aFrequencyLNB(CardHandle, 10719000, 9750000, 10600000, CTunerBSRU6, SynthesizerAddress) then
            mmoDriver.Lines.Add('Setting LNB frequency')
          else
            mmoDriver.Lines.Add('Setting LNB frequency failed -> ' + Saa7146aGetLastI2CError);

          if Saa7146aQpskSetSymbolRate(CardHandle, {22000}27500) then
            mmoDriver.Lines.Add('QPSK demodulator symbolrate set.')
          else
            mmoDriver.Lines.Add('QPSK demodulator symbolrate set failed -> ' + Saa7146aGetLastI2CError);

          if Saa7146aQpskSetSymbolRate(CardHandle, {22000}27500) then
            mmoDriver.Lines.Add('QPSK demodulator symbolrate set.')
          else
            mmoDriver.Lines.Add('QPSK demodulator symbolrate set failed -> ' + Saa7146aGetLastI2CError);

          // Setup time before we check the lock
          Saa7146aUsDelay(25000);

          if Saa7146aQpskGetLockDetectorPercentage(CardHandle, ReturnedByte) then
          begin
            mmoDriver.Lines.Add(format('QSPK demodulator lock (%d%%).', [ReturnedByte]))
          end
          else
            mmoDriver.Lines.Add('Failed to read QSPK demodulator lock -> ' + Saa7146aGetLastI2CError);

          if Saa7146aDisableLNB(CardHandle, True) then
            mmoDriver.Lines.Add('LNB disabled.')
          else
            mmoDriver.Lines.Add('Disabling LNB failed -> ' + Saa7146aGetLastI2CError);

        end
        else
          mmoDriver.Lines.Add('Read from QPSK demodulator (STV0299B) failed -> ' + Saa7146aGetLastI2CError);
      end
      else
        mmoDriver.Lines.Add('Error initializing I2C');

      mmoDriver.Lines.Add('------ SU1278 tuner ------');
      // Now issue a reset signal
//      if not Saa7146aIssueReset(CardHandle) then
//      begin
//      mmoDriver.Lines.Add('Could not issue a reset.');
//        Exit;
//      end;
//      mmoDriver.Lines.Add('Tuner has been reset.');
      if Saa7146aInitializeI2c(CardHandle) then
      begin
        mmoDriver.Lines.Add('I2C initialized.');
        if Saa7146aReadFromQpsk(CardHandle, CStv0299bId, ReturnedByte) then
        begin
          if ReturnedByte = $A1 then
          begin
            mmoDriver.Lines.Add(format('QPSK demodulator identification correct ($%x).', [ReturnedByte]));
            if Saa7146aCheckQpskResetValues(CardHandle) then
              mmoDriver.Lines.Add('QPSK registers after reset comply with expected values.')
            else
              mmoDriver.Lines.Add('QPSK registers after reset DO NOT comply with expected values.')
          end
          else
            mmoDriver.Lines.Add(format('QPSK demodulator identification NOT correct ($%x).', [ReturnedByte]));

          if Saa7146aWriteDefaultsToQpsk(CardHandle, CTunerSU1278) then
            mmoDriver.Lines.Add('QPSK registers set to default values SU1278.')
          else
            mmoDriver.Lines.Add('QPSK registers could not be set to default values.');
          if Saa7146aCheckQpskDefaultValues(CardHandle, CTunerSU1278) then
            mmoDriver.Lines.Add('QPSK registers after default comply with expected values SU1278.')
          else
            mmoDriver.Lines.Add('QPSK registers after default DO NOT comply with expected values SU1278 (might be normal!).');

          if Saa7146aEnableLNB(CardHandle, True) then
          begin
            mmoDriver.Lines.Add('LNB enabled.');
            Saa7146aUsDelay(2000);
          end
          else
            mmoDriver.Lines.Add('Enabling LNB failed -> ' + Saa7146aGetLastI2CError);

          if Saa7146aVerticalPolarityLNB(CardHandle, False) then
            mmoDriver.Lines.Add('Vertical polarity set.')
          else
            mmoDriver.Lines.Add('Setting vertical polarity failed -> ' + Saa7146aGetLastI2CError);

          SynthesizerAddress := Saa7146aDetectSynthesizerAddress(CardHandle);
          if SynthesizerAddress <> 255 then
            mmoDriver.Lines.Add(format('Synthesizer address detection successful (address %d).', [SynthesizerAddress]))
          else
            mmoDriver.Lines.Add('Synthesizer address detection SU1278 failed -> ' + Saa7146aGetLastI2CError);

          if Saa7146aFrequencyLNB(CardHandle, 10719000, 9750000, 10600000, CTunerSU1278, SynthesizerAddress) then
            mmoDriver.Lines.Add('Setting LNB frequency')
          else
            mmoDriver.Lines.Add('Setting LNB frequency failed -> ' + Saa7146aGetLastI2CError);

          if Saa7146aQpskSetSymbolRate(CardHandle, {22000}27500) then
            mmoDriver.Lines.Add('QPSK demodulator symbolrate set.')
          else
            mmoDriver.Lines.Add('QPSK demodulator symbolrate set failed -> ' + Saa7146aGetLastI2CError);

          // Setup time before we check the lock
          Saa7146aUsDelay(25000);

          if Saa7146aQpskGetLockDetectorPercentage(CardHandle, ReturnedByte) then
          begin
            mmoDriver.Lines.Add(format('QSPK demodulator lock (%d%%).', [ReturnedByte]))
          end
          else
            mmoDriver.Lines.Add('Failed to read QSPK demodulator lock -> ' + Saa7146aGetLastI2CError);

          if Saa7146aDisableLNB(CardHandle, True) then
            mmoDriver.Lines.Add('LNB disabled.')
          else
            mmoDriver.Lines.Add('Disabling LNB failed -> ' + Saa7146aGetLastI2CError);
        end
        else
          mmoDriver.Lines.Add('Read from QPSK demodulator (STV0299B) failed -> ' + Saa7146aGetLastI2CError);
      end
      else
        mmoDriver.Lines.Add('Error initializing I2C');
    finally
      Saa7146aCloseHandle(CardHandle);
    end;
  end;
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Destruction of form.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  //
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Exit application.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;


end.
