{******************************************************************************}
{ FileName............: InitializeI2cSaa7146a                                  }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Initialize SAA7146A I2C                                                     }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ Result is in exit code:                                                      }
{    $0000 = No error                                                          }
{    $10xx = Driver/card not available                                         }
{    $20xx = Operation failed                                                  }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20030102 - Initial release                                           }
{******************************************************************************}
program InitializeI2cSaa7146a;

uses
  Windows,
  Saa7146aI2c,
  Saa7146aInterface;

var
  CardHandle: THandle;
  Error     : Integer;
begin
  Error := $2000;
  if Saa7146aGetNumberOfCards = 0 then
    Halt($1000);
  CardHandle := Saa7146aCreateFile(-1);
  try
    if Saa7146aInitializeI2c(CardHandle) then
      Error := $0000;
  finally
    Saa7146aCloseHandle(CardHandle);
    Halt(Error);
  end;
end.
