{******************************************************************************}
{ FileName............: DumpRegistersSaa7146a                                  }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{   Dump SAA7146A registers to file                                            }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ By default uses SAA7146A.TXT as file                                         }
{ Use command line parameter to define another file                            }
{ Result is also in exit code:                                                 }
{    $0000 = No error                                                          }
{    $01xx = Invalid number of parameters                                      }
{    $02xx = First parameter incorrect                                         }
{    $03xx = 2nd parameter incorrect                                           }
{    $04xx = 3rd parameter incorrect                                           }
{    $05xx = etc                                                               }
{    $10xx = Driver/card not available                                         }
{    $20xx = Operation failed                                                  }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20030102 - Initial release                                           }
{******************************************************************************}
program DumpRegistersSaa7146a;

uses
  SysUtils,
  Windows,
  Saa7146aI2c,
  Saa7146aInterface,
  Saa7146aRegisters;

var
  CardHandle   : THandle;
  FileName     : string;
  OutputFile   : Text;
  Loop         : Byte;
  ReturnedDword: Dword;
  Error        : Integer;
begin
  Error := $2000;
  FileName := 'SAA7146A.TXT';
  if ParamCount > 0 then
    FileName := ParamStr(1);
  AssignFile(OutputFile, FileName);
  try
    Rewrite(OutputFile);
    if Saa7146aGetNumberOfCards = 0 then
    begin
      WriteLn(OutputFile, 'No SAA7146A driver/card detected');
      Error := $1000;
      Exit;
    end;
    CardHandle := Saa7146aCreateFile(-1);
    try
      WriteLn(OutputFile, 'Contents of SAA7146A (' + FormatDateTime('', Now) + ')');
      WriteLn(OutputFile);
      for Loop := 0 to 127 do
      begin
        if not Saa7146aReadFromSaa7146aRegister(CardHandle, Loop * 4, ReturnedDword) then
        begin
          WriteLn(OutputFile, 'Error reading SAA7146A register');
          Exit;
        end;
        WriteLn(OutputFile, format('Register $%3.3x == $%8.8x', [Loop * 4, ReturnedDword]));
      end;
      Error := $0000;
    finally
      Saa7146aCloseHandle(CardHandle);
    end;
  finally
    CloseFile(OutputFile);
    Halt(Error);
  end;
end.
