{******************************************************************************}
{ FileName............: Tsa5059Registers                                       }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Register/constant definitions for the TSA5059 synthesizer (part of the      }
{  tuner)                                                                      }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20040905 - Initial release                                           }
{******************************************************************************}
unit Tsa5059Registers;

interface

const
  // TSA5059 frequency synthesizer is part of the tuner and connected to the I2C repeater of the STV0299B
  // It supports the 400 kHz (fast mode) protocol
  CTsa5059SynthesizerWriteAddress : array[0..3] of Byte = ($C0, $C2, $C4, $C6);
  CTsa5059SynthesizerReadAddress  : array[0..3] of Byte = ($C1, $C3, $C5, $C7);

{------------------------------------------------------------------------------
  Descript:  Default settings control register 2
 -----------------------------------------------------------------------------}
  CTsa5059DefaultControlRegisterBSRU6  = $C0;
  CTsa5059DefaultControlRegisterBSBE1  = $E0;
  CTsa5059DefaultControlRegisterSU1278 = $20;

{------------------------------------------------------------------------------
  Descript:  Control 1 data masks
 -----------------------------------------------------------------------------}
  CTsa5059SetPrescalerEnable = $10;                        // Typically NOT enabled
  CTsa5059SetDividerRatio    = $0F;

{------------------------------------------------------------------------------
  Descript:  Divider ratio/Comparison frequencies (part of control 1)
 -----------------------------------------------------------------------------}
  CTsa5059Comparison2MHz   = $00;                          // Ratio /2
  CTsa5059Comparison1MHz   = $01;                          // Ratio /2 * 2   = /4
  CTsa5059Comparison500kHz = $02;                          // Ratio /2 * 4   = /8
  CTsa5059Comparison250kHz = $03;                          // Ratio /2 * 8   = /16
  CTsa5059Comparison125kHz = $04;                          // Ratio /2 * 16  = /32
  CTsa5059Comparison63kHz  = $05;                          // Ratio /2 * 32  = /64
  CTsa5059Comparison31kHz  = $06;                          // Ratio /2 * 64  = /128
  CTsa5059Comparison16kHz  = $07;                          // Ratio /2 * 128 = /256
  CTsa5059Comparison800kHz = $09;                          // Ratio /5
  CTsa5059Comparison400kHz = $0A;                          // Ratio /5 * 2   = /10
  CTsa5059Comparison200kHz = $0B;                          // Ratio /5 * 4   = /20
  CTsa5059Comparison100kHz = $0C;                          // Ratio /5 * 8   = /40
  CTsa5059Comparison50kHz  = $0D;                          // Ratio /5 * 16  = /80
  CTsa5059Comparison25kHz  = $0E;                          // Ratio /5 * 32  = /160
  CTsa5059Comparison13kHz  = $0F;                          // Ratio /5 * 64  = /320

{------------------------------------------------------------------------------
  Descript:  Control 2 data masks
 -----------------------------------------------------------------------------}
  CTsa5059SetPort0         = $01;
  CTsa5059SetPort1         = $02;
  CTsa5059SetPort2         = $04;
  CTsa5059SetPort3         = $08;
  CTsa5059SetXtCompSelect  = $10;
  CTsa5059SetXtCompEnable  = $20;
  CTsa5059SetChargePump    = $C0;

{------------------------------------------------------------------------------
  Descript:  Charge pump currents
 -----------------------------------------------------------------------------}
  CTsa5059ChargePump135uA   = $00;
  CTsa5059ChargePump280uA   = $40;
  CTsa5059ChargePump600uA   = $80;
  CTsa5059ChargePump1230uA  = $C0;

{------------------------------------------------------------------------------
  Descript:  Status masks
 -----------------------------------------------------------------------------}
  CTsa5059StatusPowerOnReset  = $80;
  CTsa5059StatusInLockFlag    = $40;
  CTsa5059StatusPort2         = $20;
  CTsa5059StatusPort1         = $10;
  CTsa5059StatusPort0         = $08;
  CTsa5059StatusAdcLevel      = $07;

{------------------------------------------------------------------------------
  Descript:  ADC levels (part of status)
 -----------------------------------------------------------------------------}
  CTsa5059AdcLevelAtMax15Percent  = $00;
  CTsa5059AdcLevelAtMax30Percent  = $01;
  CTsa5059AdcLevelAtMax45Percent  = $02;
  CTsa5059AdcLevelAtMax60Percent  = $03;
  CTsa5059AdcLevelAtMax100Percent = $04;

implementation

end.
