@echo off
@rem Usage:
@rem   SetFrequencyTsa5059 TunerIndex SynthesizerIndex Frequency

@rem Frequency in kHz

@rem Known TunerIndex-es:
@rem   0:  BSRU6
@rem   1:  SU1278
@rem   2:  BSBE1

@rem Known SynthesizerIndex-es:
@rem   1  :  BSRU6
@rem   0  :  SU1278 (Terratec Cinergy Digital 1200 DVB-S)
@rem   1  :  SU1278

SetFrequencyTsa5059 %1 %2 %3 %4 %5 %6 %7 %8 %9

@rem 'if errorlevel ...' is valid for >= errorlevel so scan these from high to low
if errorlevel 8192  goto Error8192
if errorlevel 4096  goto Error4096
if errorlevel 1024  goto Error1024
if errorlevel  768  goto Error768
if errorlevel  512  goto Error512
if errorlevel  256  goto Error256
goto End

:Error256
echo Need correct number of parameters: Tuner index, Synthesizer index and frequency
goto End
:Error512
echo Tuner index parameter incorrect
goto End
:Error768
echo Synthesizer index parameter incorrect
goto End
:Error1024
echo Frequency (kHz) parameter incorrect
goto End
:Error4096
echo No driver/card detected
goto End
:Error8192
echo Operation failed (SAA7146A/QPSK initiazed?)
goto End

:End