@echo off
@rem Usage:
@rem   WriteRegistersTda10021 DemodulatorIndex Register Data

@rem Known DemodulatorIndex-es:
@rem   0:  CU1216 tuner (Terratec Cinergy 1200 DVB-C)
@rem   1:  -

WriteRegisterTda10021 %1 %2 %3 %4 %5 %6 %7 %8 %9

@rem 'if errorlevel ...' is valid for >= errorlevel so scan these from high to low
if errorlevel 8192  goto Error8192
if errorlevel 4096  goto Error4096
if errorlevel 1024  goto Error1024
if errorlevel  768  goto Error768
if errorlevel  512  goto Error512
if errorlevel  256  goto Error256
goto End

:Error256
echo Need three parameters: demodulator index, register and data
goto End
:Error512
echo Demodulator parameter incorrect
goto End
:Error768
echo Register parameter incorrect
goto End
:Error1024
echo Data parameter incorrect
goto End
:Error4096
echo No driver/card detected
goto End
:Error8192
echo Operation failed
goto End

:End