{******************************************************************************}
{ FileName............: SetGpio                                                }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Set GPIOx output of SAA7146A                                                }
{                                                                              }
{  Copyright (C) 2003-2005  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{  Usage:                                                                      }
{    SetGpio GpioLine State                                                    }
{                                                                              }
{    GpioLine     GPIO to set/reset (0..3)                                     }
{    State        Set on (1) or off (0)                                        }
{                                                                              }
{ Result is in exit code:                                                      }
{    $0000 = No error                                                          }
{    $01xx = Invalid number of parameters                                      }
{    $02xx = First parameter incorrect                                         }
{    $03xx = 2nd parameter incorrect                                           }
{    $10xx = Driver/card not available                                         }
{    $20xx = Operation failed                                                  }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20050111 - Initial release                                           }
{******************************************************************************}
program SetGpio;

uses
  SysUtils,
  Windows,
  Saa7146aGpio,
  Saa7146aInterface;

var
  CardHandle: THandle;
  Error: Integer;
  Gpio: Integer;
  State: Integer;
  VError: Integer;
begin
  if Saa7146aGetNumberOfCards = 0 then
    Halt($1000);
  if ParamCount <> 2 then
  begin
    Error := $0100;
    Halt(Error);
  end;
  Val(ParamStr(1), Gpio, VError);
  if (VError <> 0) then
  begin
    Error := $0200;
    Halt(Error);
  end;
  if (Gpio < 0) or (Gpio > 3) then
    Halt($0200);
  Val(ParamStr(2), State, VError);
  if (VError <> 0) then
  begin
    Error := $0300;
    Halt(Error);
  end;
  if (State <> 0) and (State <> 1) then
    Halt($0300);
  // Note: We can not use a HALT from this point on because the ..finally..
  //       part of the try..finally is then NOT executed!
  Error := $2000;
  CardHandle := Saa7146aCreateFile(-1);
  try
    if not Saa7146aSetGpio(CardHandle, Gpio, (State = 1)) then
      Exit
    else
      Error := $0000;
  finally
    Saa7146aCloseHandle(CardHandle);
    Halt(Error);
  end;
end.

