@echo off
@rem Usage:
@rem   SetGpio GpioLine State

@rem Known GpioLines (Nova card)
@rem   0:  INPUT so don't use this as output (CI interrupt)
@rem   1:  Select between tuner 'clock' and CI 'clock'
@rem   2:  Reset# of tuner
@rem   3:  INPUT so don't use this as output (infrared)
@rem States
@rem   0: OFF
@rem   1: ON

SetGpio %1 %2 %3 %4 %5 %6 %7 %8 %9

@rem 'if errorlevel ...' is valid for >= errorlevel so scan these from high to low
if errorlevel 8192  goto Error8192
if errorlevel 4096  goto Error4096
if errorlevel 768   goto Error768
if errorlevel 512   goto Error512
if errorlevel 256   goto Error256
goto End

:Error256
echo Invalid number of parameters
echo Usage:
echo   ... GpioLine State
goto End
:Error512
echo Invalid GpioLine parameter (range 0..3)
goto End
:Error768
echo Invalid State parameter (0=off, 1=on)
goto End
:Error4096
echo No driver/card detected
goto End
:Error8192
echo Operation failed (SAA7146A might be resetting the tuner)
echo or incorrect demodulator index
goto End

:End