{******************************************************************************}
{ FileName............: SetFrequencyTsa5059                                    }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Write frquency to TSA5059 synthesizer                                       }
{                                                                              }
{  Copyright (C) 2003-2005  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{  Usage:                                                                      }
{    SetFrequencyTsa5059 TunerIndex SynthesizerIndex Frequency                 }
{                                                                              }
{    TunerIndex         Index of tuner                                         }
{    SynthesizerIndex   Index of synthesizer                                   }
{    Frequency          Frequency to set (kHz)                                 }
{                                                                              }
{ Result is in exit code:                                                      }
{    $0000 = No error                                                          }
{    $01xx = Invalid number of parameters                                      }
{    $02xx = First parameter incorrect                                         }
{    $03xx = 2nd parameter incorrect                                           }
{    $04xx = 3rd parameter incorrect                                           }
{    $05xx = etc                                                               }
{    $10xx = Driver/card not available                                         }
{    $20xx = Operation failed                                                  }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20050109 - Initial release                                           }
{******************************************************************************}
program SetFrequencyTsa5059;

uses
  SysUtils, Windows,
  Saa7146aI2c,
  Saa7146aInterface,
  Stv0299bRegisters,
  Tsa5059Registers;

var
  CardHandle: THandle;
  Frequency: Int64;
  Error: Integer;
  TunerIndex: Integer;
  Index: Integer;
begin
  if ParamCount <> 3 then
    Halt($0100);
  Val(ParamStr(1), TunerIndex, Error);
  if Error <> 0 then
    Halt($0200);
  if (TunerIndex < 0) or
    (TunerIndex > CTunerBSBE1) then
    Halt($0200);
  Val(ParamStr(2), Index, Error);
  if Error <> 0 then
    Halt($0300);
  if (Index < Low(CTsa5059SynthesizerWriteAddress)) or
    (Index > High(CTsa5059SynthesizerWriteAddress)) then
    Halt($0300);
  Val(ParamStr(3), Frequency, Error);
  if Error <> 0 then
    Halt($0400);
  if Saa7146aGetNumberOfCards = 0 then
    Halt($1000);
  // The tuner itslef is not important but the synthsizer address is
  if not Saa7146aSetTunerType(TunerIndex, CStv0299bDemodulatorWriteAddress,
    CTsa5059SynthesizerWriteAddress[Index]) then
    Exit;
  // Note: We can not use a HALT from this point on because the ..finally..
  //       part of the try..finally is then NOT executed!
  Error := $2000;
  CardHandle := Saa7146aCreateFile(-1);
  try
    if Saa7146aFrequencyLNB(CardHandle, Frequency, 9750000, 10600000) then
      Error := $0000;
  finally
    Saa7146aCloseHandle(CardHandle);
    Halt(Error);
  end;
end.

