{******************************************************************************}
{ FileName............: SetDefaults                                            }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Write defaults to tuner                                                     }
{                                                                              }
{  Copyright (C) 2003-2005  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{  Usage:                                                                      }
{    SetDefaults TunerIndex Index                                              }
{                                                                              }
{    TunerIndex   Tuner index                                                  }
{    Index        Index (demodulator/synthesizer)                              }
{                                                                              }
{ Result is in exit code:                                                      }
{    $0000 = No error                                                          }
{    $01xx = Invalid number of parameters                                      }
{    $02xx = First parameter incorrect                                         }
{    $03xx = 2nd parameter incorrect                                           }
{    $10xx = Driver/card not available                                         }
{    $20xx = Operation failed                                                  }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20050109 - Initial release                                           }
{******************************************************************************}
program SetDefaults;

uses
  SysUtils,
  Windows,
  Saa7146aI2c,
  Saa7146aInterface,
  Stv0299bRegisters,
  Tda10021Registers,
  Tsa5059Registers;

var
  CardHandle: THandle;
  Error: Integer;
  TunerIndex: Integer;
  Index: Integer;
  VError: Integer;
begin
  if Saa7146aGetNumberOfCards = 0 then
    Halt($1000);
  if ParamCount <> 2 then
  begin
    Error := $0100;
    Halt(Error);
  end;
  Val(ParamStr(1), TunerIndex, VError);
  if (VError <> 0) then
  begin
    Error := $0200;
    Halt(Error);
  end;
  Val(ParamStr(2), Index, VError);
  if (VError <> 0) then
  begin
    Error := $0300;
    Halt(Error);
  end;
  // Note: We can not use a HALT from this point on because the ..finally..
  //       part of the try..finally is then NOT executed!
  Error := $2000;
  CardHandle := Saa7146aCreateFile(-1);
  try
    // Synthesizer address is not of importance here ...
    case TunerIndex of
      CTunerBSRU6,
        CTunerSU1278,
        CTunerBSBE1:
        begin
          if (Index < Low(CTsa5059SynthesizerWriteAddress)) or
            (Index > High(CTsa5059SynthesizerWriteAddress)) then
            Exit;
          if not Saa7146aSetTunerType(TunerIndex,
            CStv0299bDemodulatorWriteAddress,
              CTsa5059SynthesizerWriteAddress[Index]) then
            Exit;
        end;
      CTunerCU1216:
        begin
          if (Index < Low(CTda10021DemodulatorWriteAddress)) or
            (Index > High(CTda10021DemodulatorWriteAddress)) then
            Exit;
          if not Saa7146aSetTunerType(TunerIndex,
            CTda10021DemodulatorWriteAddress[Index], 0) then
            Exit;
        end;
    end;
    // Initialize I2C (in case an incorrect address was used prior to this)
    if not Saa7146aInitializeI2c(CardHandle) then
      Exit;
    if Saa7146aWriteDefaultsToDemodulator(CardHandle) then
      Error := $0000;
  finally
    Saa7146aCloseHandle(CardHandle);
    Halt(Error);
  end;
end.

