@echo off
@rem Usage:
@rem   SetDefaults TunerIndex Index

@rem Known TunerIndex-es:
@rem   0:  BSRU6   ('Index' is synthesizer index)
@rem   1:  SU1278  ('Index' is synthesizer index)
@rem   2:  BSBE1   ('Index' is synthesizer index)
@rem   3:  CU1216  ('Index' is demodulator index)

@rem Known Index-es:
@rem   1  :  BSRU6
@rem   0  :  SU1278 (Terratec Cinergy Digital 1200 DVB-S)
@rem   1  :  SU1278
@rem   0  :  CU1216


SetDefaults %1 %2 %3 %4 %5 %6 %7 %8 %9

@rem 'if errorlevel ...' is valid for >= errorlevel so scan these from high to low
if errorlevel 8192  goto Error8192
if errorlevel 4096  goto Error4096
if errorlevel 768   goto Error768
if errorlevel 512   goto Error512
if errorlevel 256   goto Error256
goto End

:Error256
echo Invalid number of parameters
echo Usage:
echo   ... TunerIndex Index
goto End
:Error512
echo Invalid TunerIndex parameter
goto End
:Error768
echo Invalid Index parameter
goto End
:Error4096
echo No driver/card detected
goto End
:Error8192
echo Operation failed (SAA7146A might be resetting the tuner)
echo or incorrect demodulator index
goto End

:End