@echo off
@rem Usage:
@rem   DumpRegistersI2c Filename BaseAddress Register BytesToRead


DumpRegistersI2c %1 %2 %3 %4 %5 %6 %7 %8 %9

@rem 'if errorlevel ...' is valid for >= errorlevel so scan these from high to low
if errorlevel 8192  goto Error8192
if errorlevel 4096  goto Error4096
if errorlevel 1280  goto Error1280
if errorlevel 1024  goto Error1024
if errorlevel 768   goto Error768
if errorlevel 512   goto Error512
if errorlevel 256   goto Error256
goto End

:Error256
echo Invalid number of parameters
echo Usage:
echo   ... Filename BaseAddress Register BytesToRead
goto End
:Error512
echo Error filename parameter
goto End
:Error768
echo Error base address parameter (must be even)
goto End
:Error1024
echo Error register parameter
goto End
:Error1290
echo Error bytes to read parameter
goto End
:Error4096
echo No driver/card detected
goto End
:Error8192
echo Operation failed (SAA7146A might be resetting the tuner)
goto End

:End