@rem The EEPROM must be read as individual pages of max 256 bytes
@rem The pages are selected by means of bit 1..3
@rem  -> note: bit 0 select read/write access
@rem  24C01: 1  Kbit/128 bytes, page 0
@rem  24C02: 2  Kbit/256 bytes, page 0
@rem  24C04: 4  Kbit/512 bytes, page 0/1
@rem  24C08: 8  Kbit/1024 bytes, page 0/1/2/3
@rem  24C16: 16 Kbit/2048 bytes, page 0/1/2/3/4/5/6/7
@rem  Page 0: $A0
@rem  Page 1: $A2
@rem  Page 2: $A4
@rem  Page 3: $A6
@rem  Page 4: $A8
@rem  Page 5: $AA
@rem  Page 6: $AC
@rem  Page 7: $AE

@rem IMPORTANT NOTE
@rem The SAA7146A chipset uses part of the EEPROM for it's PCI settings
@rem Address  Name
@rem  $00     Subsystem ID (MSB)   == $10
@rem  $01     Subsystem ID (LSB)   == $0C
@rem  $02     Subsystem vendor ID (MSB) == $13
@rem  $03     Subsystem vendor ID (LSB) == $C2
@rem  $04     Max_Lat     == $26
@rem  $05     Min_Gnt     == $0F
@rem
@rem The subsystem/vendo id is the identifier of PCI card. This is used
@rem to identify the card and is used for selection of the correct driver
@rem (the INF installation file of a driver has these identifiers).
@rem Example:
@rem  . Sample contents of EEPROM (first value is address 0 in EEPROM):
@rem      $10 $0C $13 $C2 $26 $0F
@rem    -> PCI card identifier is then: '100C13C2'

DumpRegistersI2c Page00.txt $A0 0 256
if errorlevel 256 goto End
DumpRegistersI2c Page01.txt $A2 0 256
if errorlevel 256 goto End
DumpRegistersI2c Page02.txt $A4 0 256
if errorlevel 256 goto End
DumpRegistersI2c Page03.txt $A6 0 256
if errorlevel 256 goto End
DumpRegistersI2c Page04.txt $A8 0 256
if errorlevel 256 goto End
DumpRegistersI2c Page05.txt $AA 0 256
if errorlevel 256 goto End
DumpRegistersI2c Page06.txt $AC 0 256
if errorlevel 256 goto End
DumpRegistersI2c Page07.txt $AE 0 256

:End