//{******************************************************************************}
//{ FileName............: Saa7146aIoControl                                      }
//{ Project.............: SAA7146A                                               }
//{ Author(s)...........: MM                                                     }
//{ Version.............: 1.00                                                   }
//{------------------------------------------------------------------------------}
//{  I/O control definitions for the SAA7146A driver                             }
//{                                                                              }
//{  Copyright (C) 2003-2004  M.Majoor                                           }
//{                                                                              }
//{  This program is free software; you can redistribute it and/or               }
//{  modify it under the terms of the GNU General Public License                 }
//{  as published by the Free Software Foundation; either version 2              }
//{  of the License, or (at your option) any later version.                      }
//{                                                                              }
//{  This program is distributed in the hope that it will be useful,             }
//{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
//{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
//{  GNU General Public License for more details.                                }
//{                                                                              }
//{  You should have received a copy of the GNU General Public License           }
//{  along with this program; if not, write to the Free Software                 }
//{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
//{                                                                              }
//{------------------------------------------------------------------------------}
//{                                                                              }
//{ Version   Date   Comment                                                     }
//{  1.00   20040918 - Initial release SAA7146A.SYS V2.0X                        }
//{******************************************************************************}


#ifndef Saa7146aIoControl_h
  #define Saa7146aIoControl_


/* ------------------------------------------------------------------------------
                               From WDM.H
   ------------------------------------------------------------------------------ */
  #define CTL_CODE( DeviceType, Function, Method, Access ) (                 \
      ((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) \
  )
  #define FILE_DEVICE_UNKNOWN             0x00000022
  #define FILE_ANY_ACCESS                 0
  #define METHOD_BUFFERED                 0
/* ------------------------------------------------------------------------------
                               End WDM.H
   ------------------------------------------------------------------------------ */


  typedef LARGE_INTEGER PHYSICAL_ADDRESS, *PPHYSICAL_ADDRESS;

  typedef struct _TSaa7146aWrite
  {
    ULONG   Address;                                       // Address to write to
    ULONG   Data;                                          // Data to write
  } TSaa7146aWrite, *PTSaa7146aWrite;


  typedef struct _TSaa7146aGetDriverVersion
  {
    USHORT  MajorVersion;                                  // Major version
    USHORT  MinorVersion;                                  // Minor version
    ULONG   Build;                                         // Build (date) -> $YYYYMMDD
  } TSaa7146aGetDriverVersion, *PTSaa7146aGetDriverVersion;


  typedef struct _TSaa7146aGetDmaStatus
  {
    ULONG            Interrupts;                           // Interrupts occured
    ULONG            Isr;                                  // Interrupt status register of last interrupt
    PVOID            VirtualAddress;                       // Virtual address DMA buffer
    PHYSICAL_ADDRESS PhysicalAddress;                      // Physical address DMA buffer
    ULONG            Size;                                 // Size of DMA buffer (in bytes)
    ULONG            FifoOverflows;                        // Global FIFO overflows
  } TSaa7146aGetDmaStatus, *PTSaa7146aGetDmaStatus;

  typedef struct _TSaa7146aDmaBuffer
  {
    LONG             Identifier;                           // ID of buffer
    PVOID            VirtualAddress;                       // Virtual address of buffer
    PHYSICAL_ADDRESS PhysicalAddress;                      // Physical address of buffer
    ULONG            Size;                                 // Size of buffer
  } TSaa7146aDmaBuffer, *PTSaa7146aDmaBuffer;


  typedef struct _TSaa7146aTransferBuffer
  {
    LONG             Identifier;                           // Identification of buffer
    PUCHAR           TransferAddress;                      // Transfer buffer (source/target)
    ULONG            SourceIndex;                          // Source transfer index in buffer
    ULONG            TargetIndex;                          // Target transfer index in buffer
    ULONG            TransferLength;                       // Transfer length
  } TSaa7146aTransferBuffer, *PTSaa7146aTransferBuffer;

  typedef struct _TSaa7146aFifoTransferBuffer
  {
    LONG             Identifier;                           // Identification of FIFO buffer (<0 means not in use)
    LONG             NumberOfBuffers;                      // Number of buffers
    PVOID            TransferAddress;                      // Transfer buffer (source/target)
    ULONG            TransferLength;                       // Transfer length (buffer sizes)
    BOOLEAN          IsValid;                              // Copy of <writeTag> indicating buffer has been written to
    ULONG            OrderNumber;                          // Copy of <irqsActiveReceived> counter when FIFO was written = order number
    ULONG            Overflows;                            // Counter incremented when written to buffer with <writeTag> TRUE
    ULONG            Irqs;                                 // Counter incremented for each interrupt associated with the FIFO
    ULONG            AllOverflows;                         // Counter incremented when written to buffer with <writeTag> TRUE for ALL FIFO buffers of the associated IRQ
  } TSaa7146aFifoTransferBuffer, *PTSaa7146aFifoTransferBuffer;

  typedef struct _TSaa7146aIrqBuffer
  {
    ULONG            Irqs;                                 // Counter incremented for each interrupt of this type
    ULONG            IrqsWhenActive;                       // Counter incremented for each interrupt of this type when active
    BOOLEAN          IrqBufferingIsActive;                 // Global activation flag of the interrupt
    BOOLEAN          UseNotificationEvent;                 // Indicates notify event to be triggered
    BOOLEAN          UseSignaling;                         // Indicates signal to be triggered
    BOOLEAN          UseFifo;                              // Indicates FIFO to be used
    BOOLEAN          IrqAutoDisable;                       // Indicates if interrupt is only triggered once (interrupt enable register is cleared)
                                                           // which is necessary for 'persistent' interrupts (like RPS timeout)

    ULONG            SignalSaa7146aRegister;               // SAA7146 register to read and write back for banking info
    ULONG            SignalAndValue;                       // AND operation to perform on register contents to extract bit
    ULONG            SignalOrValue;                        // OR  peration to perform on ANDED register contents to extract bit
    ULONG            SignalXorValue;                       // XOR (invert) operation to perform on ANDED and ORED register contents to write bit

    UCHAR            FifoBufferPreviousIndex;              // Previous FIFO used (index FIFO buffer array)
    UCHAR            FifoBufferFirstIndex;                 // First FIFO to use (index FIFO buffer array)
    UCHAR            FifoBufferLastIndex;                  // Last  FIFO to use (index FIFO buffer array)
    ULONG            FifoBufferCirculations;               // Counter incremented each time <fifoBufferNext> == <fifoBufferStart>
    ULONG            FifoOverflows;                        // Counter incremented each time a FIFO <writeTag> was still set when written to it
  } TSaa7146aIrqBuffer, *PTSaa7146aIrqBuffer;

  typedef struct _TSaa7146aIrqTransferBuffer
  {
    LONG               Identifier;                         // ID of SAA7146A IRQ bit number (0..31)
    TSaa7146aIrqBuffer Information;                        // Information structure
  } TSaa7146aIrqTransferBuffer, *PTSaa7146aIrqTransferBuffer;


/* ------------------------------------------------------------------------------
    Descript: IOCTL codes to access driver.
   ----------------------------------------------------------------------------- */
  #define CIoctlSaa7146aGetDriverVersion            CTL_CODE(FILE_DEVICE_UNKNOWN, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS) // Retrieve version information (SAA7146A_GET_VERSION structure)
  #define CIoctlSaa7146aGetDmaStatus                CTL_CODE(FILE_DEVICE_UNKNOWN, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS) // Retrieve status information  (SAA7146A_GET_STATUS  structure)
  #define CIoctlSaa7146aReadFromSaa7146aRegister    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x802, METHOD_BUFFERED, FILE_ANY_ACCESS) // Read  a SAA7146A register
  #define CIoctlSaa7146aWriteToSaa7146aRegister     CTL_CODE(FILE_DEVICE_UNKNOWN, 0x803, METHOD_BUFFERED, FILE_ANY_ACCESS) // Write a SAA7146A register
  #define CIoctlSaa7146aWaitForNotification         CTL_CODE(FILE_DEVICE_UNKNOWN, 0x804, METHOD_BUFFERED, FILE_ANY_ACCESS) // Wait for a notification
  #define CIoctlSaa7146aGenerateManualNotification  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x805, METHOD_BUFFERED, FILE_ANY_ACCESS) // Manually trigger the notification
  #define CIoctlSaa7146aAllocateDma                 CTL_CODE(FILE_DEVICE_UNKNOWN, 0x806, METHOD_BUFFERED, FILE_ANY_ACCESS) // Allocate  DMA buffer
  #define CIoctlSaa7146aReleaseDma                  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x807, METHOD_BUFFERED, FILE_ANY_ACCESS) // Release   DMA buffer
  #define CIoctlSaa7146aReadFromDma                 CTL_CODE(FILE_DEVICE_UNKNOWN, 0x808, METHOD_BUFFERED, FILE_ANY_ACCESS) // Read from DMA buffer
  #define CIoctlSaa7146aWriteToDma                  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x809, METHOD_BUFFERED, FILE_ANY_ACCESS) // Write to  DMA buffer
  #define CIoctlSaa7146aAllocateFifo                CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80A, METHOD_BUFFERED, FILE_ANY_ACCESS) // Allocate  FIFO buffer
  #define CIoctlSaa7146aReleaseFifo                 CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80B, METHOD_BUFFERED, FILE_ANY_ACCESS) // Release   FIFO buffer
  #define CIoctlSaa7146aReadFromFifo                CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80C, METHOD_BUFFERED, FILE_ANY_ACCESS) // Read from FIFO buffer
  #define CIoctlSaa7146aWriteToIrqHandling          CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80D, METHOD_BUFFERED, FILE_ANY_ACCESS) // Write to  IRQ handling
  #define CIoctlSaa7146aReadFromIrqHandling         CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80E, METHOD_BUFFERED, FILE_ANY_ACCESS) // Read from IRQ handling

#endif
