//{******************************************************************************}
//{ FileName............: CheckingTheDriver                                      }
//{ Project.............: SAA7146A                                               }
//{ Author(s)...........: MM                                                     }
//{ Version.............: 1.00                                                   }
//{------------------------------------------------------------------------------}
//{  Checking the driver.                                                        }
//{                                                                              }
//{  Copyright (C) 2003-2004  M.Majoor                                           }
//{                                                                              }
//{  This program is free software; you can redistribute it and/or               }
//{  modify it under the terms of the GNU General Public License                 }
//{  as published by the Free Software Foundation; either version 2              }
//{  of the License, or (at your option) any later version.                      }
//{                                                                              }
//{  This program is distributed in the hope that it will be useful,             }
//{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
//{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
//{  GNU General Public License for more details.                                }
//{                                                                              }
//{  You should have received a copy of the GNU General Public License           }
//{  along with this program; if not, write to the Free Software                 }
//{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
//{                                                                              }
//{------------------------------------------------------------------------------}
//{                                                                              }
//{ Version   Date   Comment                                                     }
//{  1.00   20040921 - Initial DLL release                                       }
//{******************************************************************************}


#include "stdafx.h"
#include <stdio.h>

// Next only included to demonstrate on how to call the driver directly
#include "Saa7146aIoControl.h"

// DLL defines
#include "Saa7146aInterface.h"


/* ------------------------------------------------------------------------------
  Params  : ...
  Returns : ...

  Descript: Entry
  Notes   : Not much checking done on success of allocation and such ...
 ------------------------------------------------------------------------------ */
int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
  HINSTANCE                   Saa7146aInterfaceDLL;        // Handle to DLL
  pSaa7146aGetNumberOfCards   Saa7146aGetNumberOfCards;    // Function pointers
  pSaa7146aCreateFile         Saa7146aCreateFile;
  pSaa7146aCloseHandle        Saa7146aCloseHandle;
  pSaa7146aGetDriverVersion   Saa7146aGetDriverVersion;
  pSaa7146aGetCardOfHandle    Saa7146aGetCardOfHandle;
  pSaa7146aGetHandleOfCard    Saa7146aGetHandleOfCard;

  INT                         NumberOfCards;
  HANDLE                      CardHandle;
  WORD                        MajorVersion;
  WORD                        MinorVersion;
  DWORD                       Build;
  INT                         Card;  
  HANDLE                      TestHandle;

  CHAR                        ResultString[1024];
  int                         ResultLength;
  CHAR                        DeviceName[128];

  // We use the DLL dynamically
  Saa7146aInterfaceDLL = LoadLibrary(Saa7146aInterfaceName);
  if (Saa7146aInterfaceDLL != NULL)
  {
    // Get functions dynamically
    Saa7146aGetNumberOfCards = (pSaa7146aGetNumberOfCards)GetProcAddress(Saa7146aInterfaceDLL, "Saa7146aGetNumberOfCards");
    Saa7146aCreateFile       = (pSaa7146aCreateFile)      GetProcAddress(Saa7146aInterfaceDLL, "Saa7146aCreateFile");
    Saa7146aCloseHandle      = (pSaa7146aCloseHandle)     GetProcAddress(Saa7146aInterfaceDLL, "Saa7146aCloseHandle");
    Saa7146aGetDriverVersion = (pSaa7146aGetDriverVersion)GetProcAddress(Saa7146aInterfaceDLL, "Saa7146aGetDriverVersion");
    Saa7146aGetCardOfHandle  = (pSaa7146aGetCardOfHandle) GetProcAddress(Saa7146aInterfaceDLL, "Saa7146aGetCardOfHandle");
    Saa7146aGetHandleOfCard  = (pSaa7146aGetHandleOfCard) GetProcAddress(Saa7146aInterfaceDLL, "Saa7146aGetHandleOfCard");
    if (!Saa7146aGetCardOfHandle  ||
        !Saa7146aGetNumberOfCards ||
        !Saa7146aCloseHandle      ||
        !Saa7146aGetDriverVersion ||
        !Saa7146aGetCardOfHandle  ||
        !Saa7146aGetHandleOfCard)
    {
       FreeLibrary(Saa7146aInterfaceDLL);
       sprintf(ResultString, "Some functions in '%s.dll' not found.\n", Saa7146aInterfaceName);
       MessageBox(NULL, ResultString, NULL, MB_OK | MB_ICONHAND);
       return -1;
    }
    else
    {
      ResultLength = sprintf(ResultString, "***** DLL calls *****\n");
      // Check if the driver is present and/or multiple cards are present
      NumberOfCards = Saa7146aGetNumberOfCards();
      switch (NumberOfCards)
      {
        case 0:  ResultLength += sprintf(ResultString + ResultLength, "No SAA7146A driver and/or card detected.\n");
                 break;
        case 1:  ResultLength += sprintf(ResultString + ResultLength, "One SAA7146A card detected.\n");
                 break;
        default: ResultLength += sprintf(ResultString + ResultLength, "%d SAA7146A cards detected.\n", NumberOfCards);
      }
      // If any card detected then display additional information
      if (NumberOfCards != 0)
      {
        // At this time we don't have a link to the driver itself. We have to create this.
        // We use the first available card (-1==auto) there is.
        CardHandle = Saa7146aCreateFile(-1);
        // Now with the handle we can actually access the driver.
        // Start with getting the version information of the driver.
        if (Saa7146aGetDriverVersion(CardHandle, &MajorVersion, &MinorVersion, &Build, DeviceName))
          ResultLength += sprintf(ResultString + ResultLength, "Driver '%s', Version %d.%d, Build %8.8x.\n", DeviceName, MajorVersion, MinorVersion, Build);

        Card = Saa7146aGetCardOfHandle(CardHandle);
        ResultLength += sprintf(ResultString + ResultLength, "Using card %d.\n", Card);
        // For demonstration purposes do the inverse
        TestHandle = Saa7146aGetHandleOfCard(Card);
        if (TestHandle != CardHandle)
          ResultLength += sprintf(ResultString + ResultLength, "Oops, returned handle for card %d is different from acquired handle.\n", Card);
        else
          ResultLength += sprintf(ResultString + ResultLength, "Returned handle for card %d complies with acquired handle.\n", Card);


        // There is only one function in this DLL which actually communicates with the driver.
        // All other functions have to do with acquiring/releasing/storing driver handle(s).
        // For demonstrating purposes the function accessing the driver is called here 'directly'
        // instead through a wrapper function in the DLL.
        // The function concerned is <Saa7146aGetDriverVersion>. The only thing which is
        // not returned by the driver is the driver name (which is handled in the DLL).
        ResultLength += sprintf(ResultString + ResultLength, "\n***** Direct calls to driver *****\n");
        PTSaa7146aGetDriverVersion   ABuffer;
        DWORD                        BytesRead;

        ABuffer = new TSaa7146aGetDriverVersion;
        if (DeviceIoControl(CardHandle, 
                            CIoctlSaa7146aGetDriverVersion, 
                            NULL,
                            0,
                            ABuffer,
                            sizeof(TSaa7146aGetDriverVersion),
                            &BytesRead,
                            NULL))
           ResultLength += sprintf(ResultString + ResultLength, "Driver info: Version %d.%d, Build %8.8x.\n", ABuffer->MajorVersion, ABuffer->MinorVersion, ABuffer->Build);
         else
           ResultLength += sprintf(ResultString + ResultLength, "Function call to driver failed.\n");
         delete ABuffer;

         // Another direct access to the driver is reading/writing a SAA7146A register   
         DWORD    Address;
         DWORD    Data;
         // Read from SAA7146A register, use a register which is safe for read and write ('Chroma key range')
         Address = 0x074;
         if (DeviceIoControl(CardHandle,
                             CIoctlSaa7146aReadFromSaa7146aRegister,
                             &Address,
                             sizeof(Address),
                             &Data,
                             sizeof(Data),
                             &BytesRead,
                             NULL))
           ResultLength += sprintf(ResultString + ResultLength, "SAA7146A register $%3.3x reads $%8.8x.\n", Address, Data);
         else
           ResultLength += sprintf(ResultString + ResultLength, "Function call  1 to driver failed.\n");

         // Now write some specific data to the same register
         PTSaa7146aWrite  WriteBuffer;

         WriteBuffer = new TSaa7146aWrite;
         WriteBuffer->Address = Address;
         WriteBuffer->Data    = Data ^ 0xFFFFFFFF;
         if (DeviceIoControl(CardHandle,
                             CIoctlSaa7146aWriteToSaa7146aRegister,
                             WriteBuffer,
                             sizeof(TSaa7146aWrite),
                             NULL,
                             0,
                             &BytesRead,
                             NULL))
           ResultLength += sprintf(ResultString + ResultLength, "SAA7146A register $%3.3x written with $%8.8x.\n", WriteBuffer->Address, WriteBuffer->Data);
         else
           ResultLength += sprintf(ResultString + ResultLength, "Function call 2 to driver failed.\n");

         delete WriteBuffer;

         // And read it back again
         if (DeviceIoControl(CardHandle,
                             CIoctlSaa7146aReadFromSaa7146aRegister,
                             &Address,
                             sizeof(Address),
                             &Data,
                             sizeof(Data),
                             &BytesRead,
                             NULL))
           ResultLength += sprintf(ResultString + ResultLength, "SAA7146A register $%3.3x reads $%8.8x.\n", Address, Data);
         else
           ResultLength += sprintf(ResultString + ResultLength, "Function call  3 to driver failed.\n");


        // We have to release the handle we created
        Saa7146aCloseHandle(CardHandle);
      }
      // Display results
      MessageBox(NULL, ResultString, "Information", MB_OK | MB_ICONINFORMATION);
      FreeLibrary(Saa7146aInterfaceDLL);
    }       
  }
  else
  {
    // No DLL found ...
    sprintf(ResultString, "'%s.dll' could not be found.\n", Saa7146aInterfaceName);
    MessageBox(NULL, ResultString, NULL, MB_OK | MB_ICONHAND);
    return -1;
  }

  return 0;
}