{******************************************************************************}
{ FileName............: SetDiSEqC                                              }
{ Project.............:                                                        }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Send DiSEqC command                                                         }
{  Without a command line parameter SAA7146A is used, otherwise FLEXCOP access.}
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20050430 - Initial release                                           }
{******************************************************************************}
unit SetDiSEqCUnit001;

interface

uses
  Forms, Windows, StdCtrls, Classes, Controls;

type
  TfrmMain = class(TForm)
    btnExit: TButton;
    StaticText1: TStaticText;
    edtManualDiSEqC: TEdit;
    btnManualSend: TButton;
    mmoDescription: TMemo;
    edtManualDiSEqC2: TEdit;
    btnManualSend2: TButton;
    procedure btnManualSendClick(Sender: TObject);
    procedure btnManualSend2Click(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure edtManualDiSEqCKeyPress(Sender: TObject; var Key: Char);
    procedure btnManualSend2KeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

uses
  Graphics,
  Saa7146aI2C,
  FlexCopI2C,
  FlexCopInterface,
  Saa7146aInterface;

var
  CardHandle: THandle;
  UseFlexCop: Boolean;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Issue manual DiSEqC command
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.btnManualSendClick(Sender: TObject);
var
  Success: Boolean;
begin
  if UseFlexCop then
    Success := FlexCopDiSEqCCommandVdr(CardHandle, '0 0 V 0 ' +
      edtManualDiSEqC.Text)
  else
    Success := Saa7146aDiSEqCCommandVdr(CardHandle, '0 0 V 0 ' +
      edtManualDiSEqC.Text);
  if not Success then
  begin
    if edtManualDiSEqC.Color = clRed then
      edtManualDiSEqC.Color := $000000E0
    else
      edtManualDiSEqC.Color := clRed;
  end
  else
  begin
    if edtManualDiSEqC.Color = clWhite then
      edtManualDiSEqC.Color := $00E0E0E0
    else
      edtManualDiSEqC.Color := clWhite;
  end;
end;

procedure TfrmMain.btnManualSend2Click(Sender: TObject);
var
  Success: Boolean;
begin
  if UseFlexCop then
    Success := FlexCopDiSEqCCommandVdr(CardHandle, '0 0 V 0 ' +
      edtManualDiSEqC2.Text)
  else
    Success := Saa7146aDiSEqCCommandVdr(CardHandle, '0 0 V 0 ' +
      edtManualDiSEqC2.Text);
  if not Success then
  begin
    if edtManualDiSEqC2.Color = clRed then
      edtManualDiSEqC2.Color := $000000E0
    else
      edtManualDiSEqC2.Color := clRed;
  end
  else
  begin
    if edtManualDiSEqC2.Color = clWhite then
      edtManualDiSEqC2.Color := $00E0E0E0
    else
      edtManualDiSEqC2.Color := clWhite;
  end;
end;


procedure TfrmMain.edtManualDiSEqCKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
  begin
    btnManualSendClick(Sender);
    Key := #0;
  end;
end;

procedure TfrmMain.btnManualSend2KeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
  begin
    btnManualSend2Click(Sender);
    Key := #0;
  end;
end;


procedure TfrmMain.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Initialize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Initialize;
begin
  if ParamCount <> 0 then
    UseFlexCop := True
  else
    UseFlexCop := False;
  if UseFlexCop then
    CardHandle := FlexCopCreateFile(0)
  else
    CardHandle := Saa7146aCreateFile(0);
  if CardHandle = INVALID_HANDLE_VALUE then
    Application.Terminate;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Finalize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Finalize;
begin
  if CardHandle <> INVALID_HANDLE_VALUE then
    if UseFlexCop then
      FlexCopCloseHandle(CardHandle)
    else
      Saa7146aCloseHandle(CardHandle);
end;


initialization
  Initialize;


finalization
  Finalize;
end.
