{******************************************************************************}
{ FileName............: Sl1935Registers                                        }
{ Project.............: DVB                                                    }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Register/constant definitions for the SL1935 synthesizer (part of the       }
{  tuner)                                                                      }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20040528 - Initial release                                           }
{******************************************************************************}
unit Sl1935Registers;

interface

const
  // SL1935 frequency synthesizer is part of the tuner and connected to the I2C
  // repeater of the STV0299B
  CSl1935SynthesizerWriteAddress : array[0..3] of Byte = ($C0, $C2, $C4, $C6);
  CSl1935SynthesizerReadAddress  : array[0..3] of Byte = ($C1, $C3, $C5, $C7);

{------------------------------------------------------------------------------
  Descript:  Default settings control registers
 -----------------------------------------------------------------------------}
  CSl1935DefaultControlRegister1  = $C0;
  CSl1935DefaultControlRegister2  = $08;

{------------------------------------------------------------------------------
  Descript:  Control 1 data masks
 -----------------------------------------------------------------------------}
  CSl1935SetDividerRatio    = $1F;
  CSl1935SetChargePump      = $60;

{------------------------------------------------------------------------------
  Descript:  Divider ratio/Comparison frequencies (part of control 1)
 -----------------------------------------------------------------------------}
  CSl1935Comparison2MHz   = $00;                           // Ratio /2
  CSl1935Comparison1MHz   = $01;                           // Ratio /2 * 2   = /4
  CSl1935Comparison500kHz = $02;                           // Ratio /2 * 4   = /8
  CSl1935Comparison250kHz = $03;                           // Ratio /2 * 8   = /16
  CSl1935Comparison125kHz = $04;                           // Ratio /2 * 16  = /32
  CSl1935Comparison63kHz  = $05;                           // Ratio /2 * 32  = /64
  CSl1935Comparison31kHz  = $06;                           // Ratio /2 * 64  = /128
  CSl1935Comparison16kHz  = $07;                           // Ratio /2 * 128 = /256
  CSl1935Comparison800kHz = $09;                           // Ratio /5
  CSl1935Comparison400kHz = $0A;                           // Ratio /5 * 2   = /10
  CSl1935Comparison200kHz = $0B;                           // Ratio /5 * 4   = /20
  CSl1935Comparison100kHz = $0C;                           // Ratio /5 * 8   = /40
  CSl1935Comparison50kHz  = $0D;                           // Ratio /5 * 16  = /80
  CSl1935Comparison25kHz  = $0E;                           // Ratio /5 * 32  = /160
  CSl1935Comparison13kHz  = $0F;                           // Ratio /5 * 64  = /320
  CSl1935Comparison667kHz = $11;                           // Ratio /6
  CSl1935Comparison333kHz = $12;                           // Ratio /6 * 2   = /12
  CSl1935Comparison167kHz = $13;                           // Ratio /6 * 4   = /24
  CSl1935Comparison83kHz  = $14;                           // Ratio /6 * 8   = /48
  CSl1935Comparison42kHz  = $15;                           // Ratio /6 * 16  = /96
  CSl1935Comparison21kHz  = $16;                           // Ratio /6 * 32  = /192
  CSl1935Comparison10kHz  = $17;                           // Ratio /6 * 64  = /384
  CSl1935Comparison571kHz = $19;                           // Ratio /7
  CSl1935Comparison286kHz = $1A;                           // Ratio /7 * 2   = /14
  CSl1935Comparison143kHz = $1B;                           // Ratio /7 * 4   = /28
  CSl1935Comparison71kHz  = $1C;                           // Ratio /7 * 8   = /56
  CSl1935Comparison36kHz  = $1D;                           // Ratio /7 * 16  = /112
  CSl1935Comparison18kHz  = $1E;                           // Ratio /7 * 32  = /224
  CSl1935Comparison9kHz   = $1F;                           // Ratio /7 * 64  = /448

{------------------------------------------------------------------------------
  Descript:  Control 2 data masks/control
 -----------------------------------------------------------------------------}
  CSl1935SetPort0         = $01;
  CSl1935SetBufRef        = $02;
  CSl1935SetBaseBand      = $08;
  CSl1935SetOsc950_1500   = $10;                           // Sets 950-1500  MHz range
  CSl1935SetOsc1500_2150  = $00;                           // Sets 1500-2150 MHz range
  CSl1935SetChargePumpCtl = $E0;

{------------------------------------------------------------------------------
  Descript:  Charge pump currents
 -----------------------------------------------------------------------------}
  CSl1935ChargePump155uA   = $00;
  CSl1935ChargePump330uA   = $20;
  CSl1935ChargePump690uA   = $40;
  CSl1935ChargePump1450uA  = $60;

{------------------------------------------------------------------------------
  Descript:  Status masks
 -----------------------------------------------------------------------------}
  CSl1935StatusPowerOnReset  = $80;
  CSl1935StatusInLockFlag    = $40;

implementation

end.
