{******************************************************************************}
{ FileName............: USaa7146aFrontEndTest                                  }
{ Project.............:                                                        }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Test for front end budget card interface.                                   }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20040710 - Initial release                                           }
{  1.01   20041025 - Minor changes                                             }
{******************************************************************************}
unit USaa7146aFrontEndTest;

interface

uses
{$IFNDEF USEDLL}
  USaa7146aFrontEnd,
{$ENDIF}
  Saa7146aFrontEndDefines,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    btnExit: TButton;
    mmoMessage: TMemo;
    gpDiSEqC: TGroupBox;
    Label1: TLabel;
    cmbRepeats: TComboBox;
    btnOverload: TButton;
    btnSatAA: TButton;
    btnSatAB: TButton;
    btnSatBA: TButton;
    btnSatBB: TButton;
    gpSystem: TGroupBox;
    btnOpen: TButton;
    btnClose: TButton;
    gpSignal: TGroupBox;
    btnStatus: TButton;
    btnBER: TButton;
    btnBlocks: TButton;
    btnStrength: TButton;
    btnNoise: TButton;
    gpTuning: TGroupBox;
    btnInfo: TButton;
    btnBurstA: TButton;
    btnBurstB: TButton;
    btnToneOn: TButton;
    btnToneOff: TButton;
    btn13V: TButton;
    btn18V: TButton;
    btnFrequency: TButton;
    btnGet: TButton;
    cmbFec: TComboBox;
    Label2: TLabel;
    edtSymbolrate: TEdit;
    edtFrequency: TEdit;
    cmbInversion: TComboBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    procedure btnExitClick(Sender: TObject);
    procedure btnOpenClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure btnInfoClick(Sender: TObject);
    procedure btnStatusClick(Sender: TObject);
    procedure btnBERClick(Sender: TObject);
    procedure btnBlocksClick(Sender: TObject);
    procedure btnStrengthClick(Sender: TObject);
    procedure btnNoiseClick(Sender: TObject);
    procedure btnOverloadClick(Sender: TObject);
    procedure btnSatAAClick(Sender: TObject);
    procedure btnSatABClick(Sender: TObject);
    procedure btnSatBAClick(Sender: TObject);
    procedure btnSatBBClick(Sender: TObject);
    procedure btnBurstAClick(Sender: TObject);
    procedure btnBurstBClick(Sender: TObject);
    procedure btnToneOnClick(Sender: TObject);
    procedure btnToneOffClick(Sender: TObject);
    procedure btn13VClick(Sender: TObject);
    procedure btn18VClick(Sender: TObject);
    procedure btnFrequencyClick(Sender: TObject);
    procedure btnGetClick(Sender: TObject);
  private
    { Private declarations }
    FcardHandle: THandle;
  public
    { Public declarations }
  end;

{$IFDEF USEDLL}
  {$IFDEF DLLSTATIC}
    function Saa7146aFrontEndOpen (const DeviceName: PChar; const Flags: Integer): Integer;                            stdcall; external 'Saa7146aFrontEnd' name 'Open';
    function Saa7146aFrontEndClose(const FileDescriptor: Integer): Integer;                                            stdcall; external 'Saa7146aFrontEnd' name 'Close';
    function Saa7146aFrontEndIoCtl(const FileDescriptor: Integer; constRequest: Integer; Parameter: Pointer): Integer; stdcall; external 'Saa7146aFrontEnd' name 'IoCtl';
  {$ENDIF}
{$ENDIF}

var
  Form1: TForm1;
{$IFDEF USEDLL}
  {$IFNDEF DLLSTATIC}
    FrontEndDll          : Integer;
    Saa7146aFrontEndOpen : TSaa7146aOpen;
    Saa7146aFrontEndClose: TSaa7146aClose;
    Saa7146aFrontEndIoCtl: TSaa7146aIoCtl;
  {$ENDIF}
{$ENDIF}


implementation

{$R *.DFM}

procedure TForm1.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;


procedure TForm1.btnOpenClick(Sender: TObject);
var
  DeviceName: PChar;
  Result    : Integer;
begin
  if FCardhandle <> INVALID_HANDLE_VALUE then
  begin
{$IFDEF USEDLL}
    Result := Saa7146aFrontEndClose(FCardHandle);
{$ELSE}
    Result := USaa7146aFrontEnd.Close(FCardHandle);
{$ENDIF}
    if Result < 0 then
      mmoMessage.Lines.Add(format('Unable to close handle. Error code %d.', [Result]))
    else
      mmoMessage.Lines.Add('Handle closed.');
  end;
  FCardHandle := INVALID_HANDLE_VALUE;
  GetMem(DeviceName, 128);
  try
    StrPCopy(DeviceName, 'frontend0'#0);
{$IFDEF USEDLL}
    FCardHandle := Saa7146aFrontEndOpen(DeviceName, 0);
{$ELSE}
    FCardHandle := USaa7146aFrontEnd.Open(DeviceName, 0);
{$ENDIF}
    if Integer(FCardHandle) >= 0 then
    begin
      mmoMessage.Lines.Add(format('Handle %d opened for ''%s''.', [FCardHandle, DeviceName]));
    end
    else
    begin
      mmoMessage.Lines.Add(format('Could not open handle. Error code %d for ''%s''.', [FCardHandle, DeviceName]));
      FCardHandle := INVALID_HANDLE_VALUE;
    end;
  finally
    FreeMem(DeviceName, 128);
  end;
end;


procedure TForm1.FormDestroy(Sender: TObject);
begin
{$IFDEF USEDLL}
  Saa7146aFrontEndClose(FCardhandle);
{$ELSE}
  USaa7146aFrontEnd.Close(FCardhandle);
{$ENDIF}
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  FCardHandle := INVALID_HANDLE_VALUE;
  CmbRepeats.ItemIndex   := 0;
  CmbFec.ItemIndex       := 9;
  CmbInversion.ItemIndex := 0;
{$IFDEF USEDLL}
  {$IFDEF DLLSTATIC}
    Caption := 'Frontend test using DLL (static loading)';
  {$ELSE}
    Caption := 'Frontend test using DLL (dynamic loading)';
  {$ENDIF}
{$ELSE}
  Caption := 'Frontend test (internal code)';
{$ENDIF}
end;


procedure TForm1.btnCloseClick(Sender: TObject);
var
  Result: Integer;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndClose(FCardHandle);
{$ELSE}
  Result := USaa7146aFrontEnd.Close(FCardHandle);
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to close handle. Error code %d.', [Result]))
  else
    mmoMessage.Lines.Add('Handle closed.');
  FCardHandle := INVALID_HANDLE_VALUE;
end;


procedure TForm1.btnInfoClick(Sender: TObject);
var
  FrontEndInfo: TDvbFrontEndInfo;
  Result      : Integer;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_GET_INFO, @FrontEndInfo);
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_GET_INFO, @FrontEndInfo);
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to get information. Error code %d.', [Result]))
  else
  begin
    mmoMessage.Lines.Add('');
    mmoMessage.Lines.Add('Front end information');
    mmoMessage.Lines.Add('=====================');
    mmoMessage.Lines.Add(       'Name                : ''' + FrontEndInfo.Name + '''');
    case FrontEndInfo.FeType of
      FE_QPSK : mmoMessage.Lines.Add('Type                : QPSK');
      FE_QAM  : mmoMessage.Lines.Add('Type                : QAM');
      FE_OFDM : mmoMessage.Lines.Add('Type                : OFDM');
    end;
    mmoMessage.Lines.Add(format('Frequency range     : %d - %d kHz', [FrontEndInfo.FrequencyMin, FrontEndInfo.FrequencyMax]));
    mmoMessage.Lines.Add(format('Frequency step size : %d kHz', [FrontEndInfo.FrequencyStepSize]));
    mmoMessage.Lines.Add(format('Frequency tolerance : %d Hz', [FrontEndInfo.FrequencyTolerance]));
    mmoMessage.Lines.Add(format('Symbol rate range   : %d - %d Symbols/s', [FrontEndInfo.SymbolRateMin, FrontEndInfo.SymbolRateMax]));
    mmoMessage.Lines.Add(format('Frequency tolerance : %d ppm', [FrontEndInfo.SymbolRateTolerance]));
    mmoMessage.Lines.Add(format('Notifier delay      : %d ms', [FrontEndInfo.NotifierDelay]));
    mmoMessage.Lines.Add(format('Capabilities        : $%8.8x', [FrontEndInfo.Capabilities]));
  end;
end;

procedure TForm1.btnStatusClick(Sender: TObject);
var
  Result: Integer;
  Status: Integer;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_READ_STATUS, @Status);
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_READ_STATUS, @Status);
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to read status. Error code %d.', [Result]))
  else
  begin
    mmoMessage.Lines.Add('');
    mmoMessage.Lines.Add('Status information');
    mmoMessage.Lines.Add('==================');
    if (Status and FE_HAS_SIGNAL) <> 0 then
      mmoMessage.Lines.Add('Found something above the noise level.')
    else
      mmoMessage.Lines.Add('No signal above the noise level.');
    if (Status and FE_HAS_CARRIER) <> 0 then
      mmoMessage.Lines.Add('Found a DVB signal.')
    else
      mmoMessage.Lines.Add('No DVB signal found.');
    if (Status and FE_HAS_VITERBI) <> 0 then
      mmoMessage.Lines.Add('FEC is stable.')
    else
      mmoMessage.Lines.Add('FEC is not stable.');
    if (Status and FE_HAS_SYNC) <> 0 then
      mmoMessage.Lines.Add('Everything''s working...');
    if (Status and FE_TIMEDOUT) <> 0 then
      mmoMessage.Lines.Add('No lock within the last ~2 seconds.');
    if (Status and FE_REINIT) <> 0 then
      mmoMessage.Lines.Add('Frontend was reinitialized.');
  end;
end;


procedure TForm1.btnBERClick(Sender: TObject);
var
  Result: Integer;
  Status: Integer;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_READ_BER, @Status);
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_READ_BER, @Status);
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to read bit error rate. Error code %d.', [Result]))
  else
    mmoMessage.Lines.Add(format('Bit error rate: %d.', [Status]));
end;


procedure TForm1.btnBlocksClick(Sender: TObject);
var
  Result: Integer;
  Status: Integer;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_READ_UNCORRECTED_BLOCKS, @Status);
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_READ_UNCORRECTED_BLOCKS, @Status);
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to read uncorrected blocks. Error code %d.', [Result]))
  else
    mmoMessage.Lines.Add(format('Uncorrected blocks: %d.', [Status]));
end;


procedure TForm1.btnStrengthClick(Sender: TObject);
var
  Result  : Integer;
  Strength: SmallInt;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_READ_SIGNAL_STRENGTH, @Strength);
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_READ_SIGNAL_STRENGTH, @Strength);
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to read signal strength. Error code %d.', [Result]))
  else
    mmoMessage.Lines.Add(format('Signal strength: %d.', [Strength]));
end;


procedure TForm1.btnNoiseClick(Sender: TObject);
var
  Result: Integer;
  Noise : SmallInt;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_READ_SNR, @Noise);
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_READ_SNR, @Noise);
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to read noise level. Error code %d.', [Result]))
  else
    mmoMessage.Lines.Add(format('Noise level: %d.', [Noise]));
end;


procedure TForm1.btnOverloadClick(Sender: TObject);
var
  Result: Integer;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_DISEQC_RESET_OVERLOAD, nil);
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_DISEQC_RESET_OVERLOAD, nil);
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to reset DiSEqC overload. Error code %d.', [Result]))
  else
    mmoMessage.Lines.Add('DiSEqC overload reset.');
end;


procedure TForm1.btnSatAAClick(Sender: TObject);
var
  Result : Integer;
  DiSEqC : TDvbDiSEqCMasterCmd;
  Repeats: Integer;
begin
  DiSEqC.Msg[0] := $E0;                                    // Framing: Command from master, no reply required, first transmission
  DiSEqC.Msg[1] := $10;                                    // Address: Any LNB/switcher
  DiSEqC.Msg[2] := $38;                                    // Command: Committed sitches (DiSEqc level 1.0)
  DiSEqC.Msg[3] := $F0;                                    // Data   : Switch ID in low nibble
  DiSEqC.MsgLen := 4;
  Repeats := CmbRepeats.ItemIndex;
  repeat
  {$IFDEF USEDLL}
    Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_DISEQC_SEND_MASTER_CMD, @DiSEqC);
  {$ELSE}
    Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_DISEQC_SEND_MASTER_CMD, @DiSEqC);
  {$ENDIF}
    if Result < 0 then
      mmoMessage.Lines.Add(format('Unable to send DiSEqC master command. Error code %d.', [Result]))
    else
      mmoMessage.Lines.Add('DiSEqC master command send.');
    DiSEqC.Msg[0] := $E1;                                  // Framing: Command from master, no reply required, repeated transmission
    if Repeats >= 0 then
      Sleep(100);                                          // When there is a repeated command we need a 100 ms delay in between
    Dec(Repeats);
  until Repeats < 0;
end;


procedure TForm1.btnSatABClick(Sender: TObject);
var
  Result: Integer;
  DiSEqC: TDvbDiSEqCMasterCmd;
  Repeats: Integer;
begin
  DiSEqC.Msg[0] := $E0;                                    // Framing: Command from master, no reply required, first transmission
  DiSEqC.Msg[1] := $10;                                    // Address: Any LNB/switcher
  DiSEqC.Msg[2] := $38;                                    // Command: Committed sitches (DiSEqc level 1.0)
  DiSEqC.Msg[3] := $F8;                                    // Data   : Switch ID in low nibble
  DiSEqC.MsgLen := 4;
  Repeats := CmbRepeats.ItemIndex;
  repeat
  {$IFDEF USEDLL}
    Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_DISEQC_SEND_MASTER_CMD, @DiSEqC);
  {$ELSE}
    Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_DISEQC_SEND_MASTER_CMD, @DiSEqC);
  {$ENDIF}
    if Result < 0 then
      mmoMessage.Lines.Add(format('Unable to send DiSEqC master command. Error code %d.', [Result]))
    else
      mmoMessage.Lines.Add('DiSEqC master command send.');
    DiSEqC.Msg[0] := $E1;                                  // Framing: Command from master, no reply required, repeated transmission
    if Repeats >= 0 then
      Sleep(100);                                          // When there is a repeated command we need a 100 ms delay in between
    Dec(Repeats);
  until Repeats < 0;
end;


procedure TForm1.btnSatBAClick(Sender: TObject);
var
  Result: Integer;
  DiSEqC: TDvbDiSEqCMasterCmd;
  Repeats: Integer;
begin
  DiSEqC.Msg[0] := $E0;                                    // Framing: Command from master, no reply required, first transmission
  DiSEqC.Msg[1] := $10;                                    // Address: Any LNB/switcher
  DiSEqC.Msg[2] := $38;                                    // Command: Committed sitches (DiSEqc level 1.0)
  DiSEqC.Msg[3] := $F4;                                    // Data   : Switch ID in low nibble
  DiSEqC.MsgLen := 4;
  Repeats := CmbRepeats.ItemIndex;
  repeat
  {$IFDEF USEDLL}
    Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_DISEQC_SEND_MASTER_CMD, @DiSEqC);
  {$ELSE}
    Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_DISEQC_SEND_MASTER_CMD, @DiSEqC);
  {$ENDIF}
    if Result < 0 then
      mmoMessage.Lines.Add(format('Unable to send DiSEqC master command. Error code %d.', [Result]))
    else
      mmoMessage.Lines.Add('DiSEqC master command send.');
    DiSEqC.Msg[0] := $E1;                                  // Framing: Command from master, no reply required, repeated transmission
    if Repeats >= 0 then
      Sleep(100);                                          // When there is a repeated command we need a 100 ms delay in between
    Dec(Repeats);
  until Repeats < 0;
end;


procedure TForm1.btnSatBBClick(Sender: TObject);
var
  Result: Integer;
  DiSEqC: TDvbDiSEqCMasterCmd;
  Repeats: Integer;
begin
  DiSEqC.Msg[0] := $E0;                                    // Framing: Command from master, no reply required, first transmission
  DiSEqC.Msg[1] := $10;                                    // Address: Any LNB/switcher
  DiSEqC.Msg[2] := $38;                                    // Command: Committed sitches (DiSEqc level 1.0)
  DiSEqC.Msg[3] := $FC;                                    // Data   : Switch ID in low nibble
  DiSEqC.MsgLen := 4;
  Repeats := CmbRepeats.ItemIndex;
  repeat
  {$IFDEF USEDLL}
    Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_DISEQC_SEND_MASTER_CMD, @DiSEqC);
  {$ELSE}
    Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_DISEQC_SEND_MASTER_CMD, @DiSEqC);
  {$ENDIF}
    if Result < 0 then
      mmoMessage.Lines.Add(format('Unable to send DiSEqC master command. Error code %d.', [Result]))
    else
      mmoMessage.Lines.Add('DiSEqC master command send.');
    DiSEqC.Msg[0] := $E1;                                  // Framing: Command from master, no reply required, repeated transmission
    if Repeats >= 0 then
      Sleep(100);                                          // When there is a repeated command we need a 100 ms delay in between
    Dec(Repeats);
  until Repeats < 0;
end;


procedure TForm1.btnBurstAClick(Sender: TObject);
var
  Result: Integer;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_DISEQC_SEND_BURST, Pointer(SEC_MINI_A));
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_DISEQC_SEND_BURST, Pointer(SEC_MINI_A));
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to send burst A. Error code %d.', [Result]))
  else
    mmoMessage.Lines.Add('DiSEqC burst A send.');
end;


procedure TForm1.btnBurstBClick(Sender: TObject);
var
  Result: Integer;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_DISEQC_SEND_BURST, Pointer(SEC_MINI_B));
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_DISEQC_SEND_BURST, Pointer(SEC_MINI_B));
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to send burst B. Error code %d.', [Result]))
  else
    mmoMessage.Lines.Add('DiSEqC burst B send.');
end;


procedure TForm1.btnToneOnClick(Sender: TObject);
var
  Result: Integer;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_SET_TONE, Pointer(SEC_TONE_ON));
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_SET_TONE, Pointer(SEC_TONE_ON));
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to set tone on. Error code %d.', [Result]))
  else
    mmoMessage.Lines.Add('Tone on.');
end;


procedure TForm1.btnToneOffClick(Sender: TObject);
var
  Result: Integer;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_SET_TONE, Pointer(SEC_TONE_OFF));
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_SET_TONE, Pointer(SEC_TONE_OFF));
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to set tone off. Error code %d.', [Result]))
  else
    mmoMessage.Lines.Add('Tone off.');
end;


procedure TForm1.btn13VClick(Sender: TObject);
var
  Result: Integer;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_SET_VOLTAGE, Pointer(SEC_VOLTAGE_13));
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_SET_VOLTAGE, Pointer(SEC_VOLTAGE_13));
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to set voltage to 13V. Error code %d.', [Result]))
  else
    mmoMessage.Lines.Add('Voltage set to 13V.');
end;


procedure TForm1.btn18VClick(Sender: TObject);
var
  Result: Integer;
begin
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_SET_VOLTAGE, Pointer(SEC_VOLTAGE_18));
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_SET_VOLTAGE, Pointer(SEC_VOLTAGE_18));
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to set voltage to 18V. Error code %d.', [Result]))
  else
    mmoMessage.Lines.Add('Voltage set to 18V.');
end;


procedure TForm1.btnFrequencyClick(Sender: TObject);
var
  Result           : Integer;
  FrontEndParameter: TDvbFrontEndParameters;
  Value            : Integer;
  Error            : Integer;
begin
  Val(edtFrequency.Text, Value, Error);
  if Error <> 0 then
  begin
    mmoMessage.Lines.Add('Conversion error frequency.');
    Exit;
  end;
  FrontEndParameter.Frequency := Value;
  FrontEndParameter.Inversion := cmbInversion.ItemIndex;
  FrontEndParameter.Qpsk.FecInner := cmbFec.ItemIndex;
  Val(edtSymbolRate.Text, Value, Error);
  if Error <> 0 then
  begin
    mmoMessage.Lines.Add('Conversion error symbol rate.');
    Exit;
  end;
  FrontEndParameter.Qpsk.SymbolRate := Value;
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_SET_FRONTEND, @FrontEndParameter);
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_SET_FRONTEND, @FrontEndParameter);
{$ENDIF}
  if Result < 0 then
    mmoMessage.Lines.Add(format('Unable to set front end parameters. Error code %d.', [Result]))
  else
    mmoMessage.Lines.Add('Front end parameters set.');
end;


procedure TForm1.btnGetClick(Sender: TObject);
var
  Result           : Integer;
  FrontEndParameter: TDvbFrontEndParameters;
  Value            : Integer;
  Error            : Integer;
begin
  // Since the <Frequency> returned will be the parameters frequency corrected
  // with the detecte deviation make sure the frequency is set
  Val(edtFrequency.Text, Value, Error);
  if Error <> 0 then
  begin
    mmoMessage.Lines.Add('Conversion error frequency.');
    Exit;
  end;
  FrontEndParameter.Frequency := Value;
{$IFDEF USEDLL}
  Result := Saa7146aFrontEndIoCtl(FCardHandle, FE_GET_FRONTEND, @FrontEndParameter);
{$ELSE}
  Result := USaa7146aFrontEnd.IoCtl(FCardHandle, FE_GET_FRONTEND, @FrontEndParameter);
{$ENDIF}
  if Result < 0 then
  begin
    mmoMessage.Lines.Add(format('Unable to get front end parameters. Error code %d.', [Result]));
    Exit;
  end
  else
    mmoMessage.Lines.Add(format('Front end parameters read. FEC: %s', [cmbFec.Items[FrontEndParameter.Qpsk.FecInner]]));
  EdtFrequency.Text := format('%d', [FrontEndParameter.Frequency]);
  cmbInversion.ItemIndex := FrontEndParameter.Inversion;
  // Do not change if the requested FEC is AUTO
  if cmbFec.ItemIndex <> FEC_AUTO then
    cmbFec.ItemIndex := FrontEndParameter.Qpsk.FecInner;
  edtSymbolRate.Text := format('%d', [FrontEndParameter.Qpsk.SymbolRate]);
end;


procedure Initialize;
begin
  {$IFDEF USEDLL}
    {$IFNDEF DLLSTATIC}
      FrontEndDll := LoadLibrary(PChar(ExtractFilepath(Application.ExeName) + 'Saa7146aFrontEnd.dll'));
      if FrontEndDll = 0 then
      begin
        ShowMessage(format('LoadLibrary(%s) failed', ['Saa7146aFrontEnd.dll']));
        Application.Terminate;
        Exit;
      end;
      Saa7146aFrontEndOpen := GetProcAddress(FrontEndDll, 'Open');
      if not Assigned(@Saa7146aFrontEndOpen) then
      begin
        ShowMessage(format('GetProcAddress(%s) failed', ['Open']));
      end;
      Saa7146aFrontEndClose := GetProcAddress(FrontEndDll, 'Close');
      if not Assigned(@Saa7146aFrontEndClose) then
      begin
        ShowMessage(format('GetProcAddress(%s) failed', ['Close']));
      end;
      Saa7146aFrontEndIoCtl := GetProcAddress(FrontEndDll, 'IoCtl');
      if not Assigned(@Saa7146aFrontEndIoCtl) then
      begin
        ShowMessage(format('GetProcAddress(%s) failed', ['IoCtl']));
      end;
    {$ENDIF}
  {$ENDIF}
end;


procedure Finalize;
begin
  {$IFDEF USEDLL}
    {$IFNDEF DLLSTATIC}
      if FrontEndDll <> 0 then
        FreeLibrary(FrontEndDll);
    {$ENDIF}
  {$ENDIF}
end;


initialization
  Initialize;

finalization
  Finalize;
end.

