//{******************************************************************************}
//{ FileName............: Saa7146aFrontEnd                                       }
//{ Project.............: SAA7146A                                               }
//{ Author(s)...........: MM                                                     }
//{ Version.............: 1.00                                                   }
//{------------------------------------------------------------------------------}
//{  Saa7146aFrontEnd header file                                                }
//{                                                                              }
//{  Copyright (C) 2003-2004  M.Majoor                                           }
//{                                                                              }
//{  This program is free software; you can redistribute it and/or               }
//{  modify it under the terms of the GNU General Public License                 }
//{  as published by the Free Software Foundation; either version 2              }
//{  of the License, or (at your option) any later version.                      }
//{                                                                              }
//{  This program is distributed in the hope that it will be useful,             }
//{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
//{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
//{  GNU General Public License for more details.                                }
//{                                                                              }
//{  You should have received a copy of the GNU General Public License           }
//{  along with this program; if not, write to the Free Software                 }
//{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
//{                                                                              }
//{------------------------------------------------------------------------------}
//{                                                                              }
//{ Version   Date   Comment                                                     }
//{  1.00   20040923 - Initial release                                           }
//{******************************************************************************}


#ifndef Saa7146aFrontEnd_h
  #define Saa7146aFrontEnd_h

#define Saa7146aFrontEndName "Saa7146aFrontEnd"
typedef INT    (__stdcall *pSaa7146aFrontEndOpen) (PCHAR, INT);
typedef INT    (__stdcall *pSaa7146aFrontEndClose)(INT);
typedef INT    (__stdcall *pSaa7146aFrontEndIoCtl)(INT, INT, PVOID);


// Error codes
#define  ENOERROR       0                        // No error
#define  EPERM          1                        // Operation not permitted
#define  EBADF          9                        // Bad file number
#define  EFAULT         14                       // Bad address
#define  ENODEV         19                       // No such device
#define  EINVAL         22                       // Invalid argument
#define  ENOSYS         38                       // Function not implemented
#define  EOPNOTSUPP     95                       // Operation not supported on transport endpoint

// Front end type
#define  FE_QPSK        0
#define  FE_QAM         1
#define  FE_OFDM        2

// Front end capabilities
#define  FE_IS_STUPID                  0x00000000
#define  FE_CAN_INVERSION_AUTO         0x00000001
#define  FE_CAN_FEC_1_2                0x00000002
#define  FE_CAN_FEC_2_3                0x00000004
#define  FE_CAN_FEC_3_4                0x00000008
#define  FE_CAN_FEC_4_5                0x00000010
#define  FE_CAN_FEC_5_6                0x00000020
#define  FE_CAN_FEC_6_7                0x00000040
#define  FE_CAN_FEC_7_8                0x00000080
#define  FE_CAN_FEC_8_9                0x00000100
#define  FE_CAN_FEC_AUTO               0x00000200
#define  FE_CAN_QPSK                   0x00000400
#define  FE_CAN_QAM_16                 0x00000800
#define  FE_CAN_QAM_32                 0x00001000
#define  FE_CAN_QAM_64                 0x00002000
#define  FE_CAN_QAM_128                0x00004000
#define  FE_CAN_QAM_256                0x00008000
#define  FE_CAN_QAM_AUTO               0x00010000
#define  FE_CAN_TRANSMISSION_MODE_AUTO 0x00020000
#define  FE_CAN_BANDWIDTH_AUTO         0x00040000
#define  FE_CAN_GUARD_INTERVAL_AUTO    0x00080000
#define  FE_CAN_HIERARCHY_AUTO         0x00100000
#define  FE_CAN_RECOVER                0x20000000
#define  FE_CAN_CLEAN_SETUP            0x40000000
#define  FE_CAN_MUTE_TS                0x80000000


typedef struct _TDvbFrontEndInfo
{
  CHAR Name[128];
  INT  FeType;
  INT  FrequencyMin;
  INT  FrequencyMax;
  INT  FrequencyStepSize;
  INT  FrequencyTolerance;
  INT  SymbolRateMin;
  INT  SymbolRateMax;
  INT  SymbolRateTolerance;
  INT  NotifierDelay;
  INT  Capabilities;
} TDvbFrontEndInfo, *PTDvbFrontEndInfo;


typedef struct _TDvbDiSEqCMasterCmd
{
  CHAR  Msg[6];                                  // Framing, address, command, data1/2/3
  BYTE  MsgLen;                                  // Length
} TDvbDiSEqCMasterCmd, *PTDvbDiSEqCMasterCmd;


typedef struct _TDvbDiSEqCSlaveReply
{
  CHAR  Msg[4];                                  // Framing, data1/2/3
  BYTE  MsgLen;                                  // Length (0 = no message)
  INT   TimeOut;                                 // Timeout in ms
} TDvbDiSEqCSlaveReply, *PTDvbDiSEqCSlaveReply;


// SEC voltage
#define  SEC_VOLTAGE_13 0
#define  SEC_VOLTAGE_18 1

// SEC tone mode
#define  SEC_TONE_ON    0
#define  SEC_TONE_OFF   1

// SEC mini command
#define  SEC_MINI_A     0
#define  SEC_MINI_B     1

// Front end status
#define  FE_HAS_SIGNAL  0x01                     // Found something above the noise level
#define  FE_HAS_CARRIER 0x02                     // Found a DVB signal
#define  FE_HAS_VITERBI 0x04                     // FEC is stable
#define  FE_HAS_SYNC    0x08                     // Found sync bytes
#define  FE_HAS_LOCK    0x10                     // Everything's working...
#define  FE_TIMEDOUT    0x20                     // No lock within the last ~2 seconds
#define  FE_REINIT      0x40                     // Frontend was reinitialized, application is
                                                 // recommended to reset DiSEqC, tone and parameters
// Spectral inversion
#define  INVERSION_OFF  0
#define  INVERSION_ON   1
#define  INVERSION_AUTO 2

// Forward error correction code rate
#define  FEC_NONE       0
#define  FEC_1_2        1
#define  FEC_2_3        2
#define  FEC_3_4        3
#define  FEC_4_5        4
#define  FEC_5_6        5
#define  FEC_6_7        6
#define  FEC_7_8        7
#define  FEC_8_9        8
#define  FEC_AUTO       9


typedef struct _TDvbQpskParameters
{
  INT  SymbolRate;                               // Symbol rate in Symbols per second
  INT  FecInner;                                 // Forward error correction
} TDvbQpskParameters, *PTDvbQpskParameters;


// Modulation type
#define  QPSK     0
#define  QAM_16   1
#define  QAM_32   2
#define  QAM_64   3
#define  QAM_128  4
#define  QAM_256  5
#define  QAM_AUTO 6


typedef struct _TDvbQamParameters
{
  INT  SymbolRate;                               // Symbol rate in Symbols per second
  INT  FecInner;                                 // Forward error correction
  INT  Modulation;                               // Modulation type
} TDvbQamParameters, *PTDvbQamParameters;


// Band width
#define  BANDWIDTH_8_MHZ        0
#define  BANDWIDTH_7_MHZ        1
#define  BANDWIDTH_6_MHZ        2
#define  BANDWIDTH_AUTO         3

  // Transmission mode
#define  TRANSMISSION_MODE_2K   0
#define  TRANSMISSION_MODE_8K   1
#define  TRANSMISSION_MODE_AUTO 2

  // Guard interval
#define  GUARD_INTERVAL_1_32    0
#define  GUARD_INTERVAL_1_16    1
#define  GUARD_INTERVAL_1_8     2
#define  GUARD_INTERVAL_1_4     3
#define  GUARD_INTERVAL_AUTO    4

  // Hierarchy information
#define  HIERARCHY_NONE         0
#define  HIERARCHY_1            1
#define  HIERARCHY_2            2
#define  HIERARCHY_4            3
#define  HIERARCHY_AUTO         4


typedef struct _TDvbOfdmParameters
{
  INT  BandWidth;
  INT  CodeRateHp;                               // High priority stream code rate
  INT  CodeRateLp;                               // Low priority stream code rate
  INT  Constellation;                            // Modulation type
  INT  TransmissionMode;
  INT  GuardInterval;
  INT  HierarchyInformation;
} TDvbOfdmParameters, *PTDvbOfdmParameters;

typedef struct _TDvbFrontEndParameters
{
  INT  Frequency;                                // (absolute) frequency in Hz for QAM/OFDM
                                                 // intermediate frequency in kHz for QPSK
  INT  Inversion;
  union {
    struct _TDvbQpskParameters Qpsk;
    struct _TDvbQamParameters  Qam;
    struct _TDvbOfdmParameters Ofdm;
  };
} TDvbFrontEndParameters, *PTDvbFrontEndParameters;

typedef struct _TDvbFrontEndEvent
{
  INT                     Status;
  TDvbFrontEndParameters  Parameters;
} TDvbFrontEndEvent, *PTDvbFrontEndEvent;


// Next are -default- settings (actual values depend on INI setting!)
#define  FE_GET_INFO                0x80A86F3D
#define  FE_DISEQC_RESET_OVERLOAD   0x00006F3E
#define  FE_DISEQC_SEND_MASTER_CMD  0x40076F3F
#define  FE_DISEQC_RECV_SLAVE_REPLY 0x800C6F40
#define  FE_DISEQC_SEND_BURST       0x00006F41
#define  FE_SET_TONE                0x00006F42
#define  FE_SET_VOLTAGE             0x00006F43
#define  FE_ENABLE_HIGH_LNB_VOLTAGE 0x00006F44
#define  FE_READ_STATUS             0x80046F45
#define  FE_READ_BER                0x80046F46
#define  FE_READ_SIGNAL_STRENGTH    0x80026F47
#define  FE_READ_SNR                0x80026F48
#define  FE_READ_UNCORRECTED_BLOCKS 0x80046F49
#define  FE_SET_FRONTEND            0x40246F4C
#define  FE_GET_FRONTEND            0x80246F4D
#define  FE_GET_EVENT               0x80286F4E


#endif
