{******************************************************************************}
{ FileName............: USaa7146aDemuxTest                                     }
{ Project.............:                                                        }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Test for demux budget card interface.                                       }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{  . IoCtl()                                                                   }
{    - DMX_BACKDOOR_START_FEED                                                 }
{    - DMX_BACKDOOR_STOP_FEED                                                  }
{    - DMX_REGISTER_CALLBACK                                                   }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20040710 - Initial release                                           }
{******************************************************************************}
unit USaa7146aDemuxTest;

interface

uses
{$IFNDEF USEDLL}
  USaa7146aDemux,
{$ENDIF}
  Saa7146aDemuxDefines,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    btnExit: TButton;
    Label1: TLabel;
    btnAddAllPids: TButton;
    btmnRemoveAddPids: TButton;
    Label2: TLabel;
    Label3: TLabel;
    lblPackets: TLabel;
    lblPacketsSync: TLabel;
    lblPacketsNoSync: TLabel;
    tmrUpdate: TTimer;
    btnEnableCallback: TButton;
    btnDisableCallback: TButton;
    edtPid: TEdit;
    btnAddPid: TButton;
    Label4: TLabel;
    btnRemovePid: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnAddAllPidsClick(Sender: TObject);
    procedure btmnRemoveAddPidsClick(Sender: TObject);
    procedure tmrUpdateTimer(Sender: TObject);
    procedure btnEnableCallbackClick(Sender: TObject);
    procedure btnDisableCallbackClick(Sender: TObject);
    procedure btnAddPidClick(Sender: TObject);
    procedure btnRemovePidClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

{$IFDEF USEDLL}
  {$IFDEF DLLSTATIC}
    function Saa7146aDemuxIoCtl(const FileDescriptor: Integer; const Request: Integer; Parameter: Pointer): Integer;  stdcall; external 'Saa7146aDemux' name 'IoCtl';
  {$ENDIF}
{$ENDIF}

var
  Form1: TForm1;
  PacketCount : Word;
  PacketSync  : Word;
  PacketNoSync: Word;
{$IFDEF USEDLL}
  {$IFNDEF DLLSTATIC}
    DemuxDll          : Integer;
    Saa7146aDemuxIoCtl: TSaa7146aIoCtl;
  {$ENDIF}
{$ENDIF}

implementation

{$R *.DFM}


{------------------------------------------------------------------------------
  Params  : <Buffer>  Pointer to packet data
            <Length>  Length of data (always 188)
  Returns : <Result>  Not used

  Descript: Called for every packet with a PID which was set by _START_FEED
  Notes   :
------------------------------------------------------------------------------}
function PacketCallback(Buffer: PByteArray; DataLength: Dword): Dword; stdcall;
begin
  Result := 0;
  if PacketCount = $FFFF then
    PacketCount := 0
  else
    Inc(PacketCount);
  if Buffer^[0] <> $47 then
  begin
    if PacketNoSync = $FFFF then
      PacketNoSync := 0
    else
      Inc(PacketNoSync);
  end
  else
  begin
    if PacketSync = $FFFF then
      PacketSync := 0
    else
      Inc(PacketSync);
  end;
end;


procedure TForm1.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  PacketCount  := 0;
  PacketSync   := 0;
  PacketNoSync := 0;
{$IFDEF USEDLL}
  {$IFDEF DLLSTATIC}
    Caption := 'Demux test using DLL (static loading)';
  {$ELSE}
    Caption := 'Demux test using DLL (dynamic loading)';
  {$ENDIF}
{$ELSE}
  Caption := 'Demux test (internal code)';
{$ENDIF}
end;


procedure TForm1.btnAddAllPidsClick(Sender: TObject);
var
  DmxBackDoorFeed: TDmxbackDoorFeed;
begin
  // Special PID for enabling all
  DmxBackDoorFeed.Pid := $FFFF;
{$IFDEF USEDLL}
  Saa7146aDemuxIoCtl(0, DMX_BACKDOOR_START_FEED, @DmxBackDoorFeed);
{$ELSE}
  USaa7146aDemux.IoCtl(0, DMX_BACKDOOR_START_FEED, @DmxBackDoorFeed);
{$ENDIF}
end;


procedure TForm1.btmnRemoveAddPidsClick(Sender: TObject);
var
  DmxBackDoorFeed: TDmxbackDoorFeed;
begin
  // Special PID for disabling all
  DmxBackDoorFeed.Pid := $FFFF;
{$IFDEF USEDLL}
  Saa7146aDemuxIoCtl(0, DMX_BACKDOOR_STOP_FEED, @DmxBackDoorFeed);
{$ELSE}
  USaa7146aDemux.IoCtl(0, DMX_BACKDOOR_STOP_FEED, @DmxBackDoorFeed);
{$ENDIF}
end;


procedure TForm1.tmrUpdateTimer(Sender: TObject);
begin
  lblPackets.Caption       := format('%d', [PacketCount]);
  lblPacketsSync.Caption   := format('%d', [PacketSync]);
  lblPacketsNoSync.Caption := format('%d', [PacketNoSync]);
end;


procedure TForm1.btnEnableCallbackClick(Sender: TObject);
begin
{$IFDEF USEDLL}
  Saa7146aDemuxIoCtl(0, 666999, @PacketCallback);
{$ELSE}
  USaa7146aDemux.IoCtl(0, 666999, @PacketCallback);
{$ENDIF}
end;


procedure TForm1.btnDisableCallbackClick(Sender: TObject);
begin
{$IFDEF USEDLL}
  Saa7146aDemuxIoCtl(0, DMX_REGISTER_CALLBACK, nil);
{$ELSE}
  USaa7146aDemux.IoCtl(0, DMX_REGISTER_CALLBACK, nil);
{$ENDIF}
end;


procedure TForm1.btnAddPidClick(Sender: TObject);
var
  DmxBackDoorFeed: TDmxbackDoorFeed;
  Value          : Integer;
  Error          : Integer;
begin
  // Get PID to add
  Val(edtPid.Text, Value, Error);
  if Error <> 0 then
  begin
    Caption := 'Invalid PID value';
    Exit;
  end;
  DmxBackDoorFeed.Pid := Value;
{$IFDEF USEDLL}
  Saa7146aDemuxIoCtl(0, DMX_BACKDOOR_START_FEED, @DmxBackDoorFeed);
{$ELSE}
  USaa7146aDemux.IoCtl(0, DMX_BACKDOOR_START_FEED, @DmxBackDoorFeed);
{$ENDIF}
end;


procedure TForm1.btnRemovePidClick(Sender: TObject);
var
  DmxBackDoorFeed: TDmxbackDoorFeed;
  Value          : Integer;
  Error          : Integer;
begin
  // Get PID to add
  Val(edtPid.Text, Value, Error);
  if Error <> 0 then
  begin
    Caption := 'Invalid PID value';
    Exit;
  end;
  DmxBackDoorFeed.Pid := Value;
{$IFDEF USEDLL}
  Saa7146aDemuxIoCtl(0, DMX_BACKDOOR_STOP_FEED, @DmxBackDoorFeed);
{$ELSE}
  USaa7146aDemux.IoCtl(0, DMX_BACKDOOR_STOP_FEED, @DmxBackDoorFeed);
{$ENDIF}
end;



procedure Initialize;
begin
  {$IFDEF USEDLL}
    {$IFNDEF DLLSTATIC}
      DemuxDll := LoadLibrary(PChar(ExtractFilepath(Application.ExeName) + 'Saa7146aDemux.dll'));
      if DemuxDll = 0 then
      begin
        raise Exception.CreateFmt('LoadLibrary(%s) failed', ['Saa7146aDemux.dll']);
        Application.Terminate;
        Exit;
      end;
      Saa7146aDemuxIoCtl := GetProcAddress(DemuxDll, 'IoCtl');
      if not Assigned(@Saa7146aDemuxIoCtl) then
      begin
        raise Exception.CreateFmt('GetProcAddress(%s) failed', ['IoCtl']);
      end;
    {$ENDIF}
  {$ENDIF}
end;


procedure Finalize;
begin
  {$IFDEF USEDLL}
    {$IFNDEF DLLSTATIC}
      if DemuxDll <> 0 then
        FreeLibrary(DemuxDll);
    {$ENDIF}
  {$ENDIF}
end;


initialization
  Initialize;

finalization
  Finalize;
end.
