{******************************************************************************}
{ FileName............: Saa7146aDemuxDefines                                   }
{ Project.............:                                                        }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Demux device defines.                                                       }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20040711 - Initial release                                           }
{******************************************************************************}
unit Saa7146aDemuxDefines;


interface

type
  // Callback for DMX_REGISTER_CALLBACK function
  TCallbackProc  = function(Buffer: Pointer; DataLength: Integer): Integer; stdcall;
  // Type for dynamically loading the DLL
  TSaa7146aIoCtl = function(const FileDescriptor: Integer; const Request: Integer; Parameter: Pointer): Integer;  stdcall;

const
  // Note: This are the 'default' values. The correct values are defined in
  //       the INI file!!
  DMX_BACKDOOR_START_FEED = 666000;
  DMX_BACKDOOR_STOP_FEED  = 666001;
  DMX_REGISTER_CALLBACK   = 666999;

  // PID type
  DMX_TYPE_TS  = Integer(0);
  DMX_TYPE_SEC = Integer(1);
  DMX_TYPE_PES = Integer(2);

  // Some possible errors (Linux equivalent)
  ENOERROR       = Integer(0);                   // No error
  EFAULT         = Integer(14);                  // Bad address
  EOPNOTSUPP     = Integer(95);                  // Operation not supported on transport endpoint

type
  PDmxBackDoorFeed = ^TDmxBackDoorFeed;
  TDmxBackDoorFeed = packed record
    Pid       : Integer;
    PidType   : Integer;
    PidPesType: Integer;
  end;

  
implementation


end.
