//{******************************************************************************}
//{ FileName............: Saa7146aDemux                                          }
//{ Project.............: SAA7146A                                               }
//{ Author(s)...........: MM                                                     }
//{ Version.............: 1.00                                                   }
//{------------------------------------------------------------------------------}
//{  Saa7146aDemux header file                                                   }
//{                                                                              }
//{  Copyright (C) 2003-2004  M.Majoor                                           }
//{                                                                              }
//{  This program is free software; you can redistribute it and/or               }
//{  modify it under the terms of the GNU General Public License                 }
//{  as published by the Free Software Foundation; either version 2              }
//{  of the License, or (at your option) any later version.                      }
//{                                                                              }
//{  This program is distributed in the hope that it will be useful,             }
//{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
//{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
//{  GNU General Public License for more details.                                }
//{                                                                              }
//{  You should have received a copy of the GNU General Public License           }
//{  along with this program; if not, write to the Free Software                 }
//{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
//{                                                                              }
//{------------------------------------------------------------------------------}
//{                                                                              }
//{ Version   Date   Comment                                                     }
//{  1.00   20040923 - Initial release                                           }
//{******************************************************************************}


#ifndef Saa7146aDemux_h
  #define Saa7146aDemux_h

#define Saa7146aDemuxName "Saa7146aDemux"
typedef INT    (__stdcall *pSaa7146aDemuxIoCtl)(INT, INT, PVOID);

// Callback for DMX_REGISTER_CALLBACK function
typedef INT    (__stdcall *pTDemuxCallbackProc)(PVOID, INT);


// Next are -default- settings (actual values depend on INI setting!)
#define  DMX_BACKDOOR_START_FEED   666000
#define  DMX_BACKDOOR_STOP_FEED    666001
#define  DMX_REGISTER_CALLBACK     666999


// PID type
#define  DMX_TYPE_TS   0
#define  DMX_TYPE_SEC  1
#define  DMX_TYPE_PES  2


// Some possible errors (Linux equivalent)
#define  ENOERROR      0                   // No error
#define  EFAULT        14                  // Bad address
#define  EOPNOTSUPP    95                  // Operation not supported on transport endpoint


typedef struct  _TDmxBackDoorFeed
{
  INT  Pid;
  INT  PidType;
  INT  PidPesType;
} TDmxBackDoorFeed, *PTDmxBackDoorFeed;


#endif

