{******************************************************************************}
{ FileName............: DiseqcUnit001                                          }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Finding a carrier.                                                          }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20030623 - Initial WDM release                                       }
{******************************************************************************}
unit DiseqcUnit001;

interface

uses
  SyncObjs,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Saa7146AInterface, Saa7146aGpio, Saa7146AI2c, Stv0299bRegisters,
  Tsa5059Registers, ExtCtrls, Mask, Gauges, ComCtrls;

type
  TfrmMain = class(TForm)
    btnExit: TButton;
    mmoDriver: TMemo;
    rgPolarity: TRadioGroup;
    mskSymbolRate: TMaskEdit;
    StaticText1: TStaticText;
    tmrUpdate: TTimer;
    ggLock: TGauge;
    StaticText2: TStaticText;
    StaticText3: TStaticText;
    mskFrequency: TMaskEdit;
    StaticText4: TStaticText;
    stDeviation: TStaticText;
    StaticText5: TStaticText;
    StaticText6: TStaticText;
    StaticText7: TStaticText;
    stDeviationSymbolrate: TStaticText;
    btnBeforeLock: TButton;
    btnAfterLock: TButton;
    rgLNB: TRadioGroup;
    btnReset: TButton;
    StaticText8: TStaticText;
    rgInversion: TRadioGroup;
    GroupBox1: TGroupBox;
    btnBurstA: TButton;
    btnBurstB: TButton;
    btnDiseqcA: TButton;
    btnDiseqcB: TButton;
    btnDiseqcBurstA: TButton;
    btnDiseqcBurstB: TButton;
    btnDiseqcABurstB: TButton;
    btnDiseqcBBurstA: TButton;
    StaticText9: TStaticText;
    StaticText10: TStaticText;
    GroupBox2: TGroupBox;
    StaticText11: TStaticText;
    btnStopMovement: TButton;
    btnResetPositioner: TButton;
    btnGoEast: TButton;
    btnGoWest: TButton;
    StaticText12: TStaticText;
    btnSetEastLimit: TButton;
    btnSetWestLimit: TButton;
    btnDisableLimits: TButton;
    btnStorePosition: TButton;
    btnStepEast: TButton;
    btnStepWest: TButton;
    udPosition: TUpDown;
    txtPosition: TStaticText;
    btnGotoPosition: TButton;
    StaticText13: TStaticText;
    btnGotoAngular: TButton;
    btnRecalculate: TButton;
    rgTuner: TRadioGroup;
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure rgPolarityClick(Sender: TObject);
    procedure mskSymbolRateChange(Sender: TObject);
    procedure tmrUpdateTimer(Sender: TObject);
    procedure mskFrequencyChange(Sender: TObject);
    procedure mskFrequencyKeyPress(Sender: TObject; var Key: Char);
    procedure mskSymbolRateKeyPress(Sender: TObject; var Key: Char);
    procedure btnBeforeLockClick(Sender: TObject);
    procedure btnAfterLockClick(Sender: TObject);
    procedure rgLNBClick(Sender: TObject);
    procedure btnResetClick(Sender: TObject);
    procedure rgInversionClick(Sender: TObject);
    procedure btnBurstAClick(Sender: TObject);
    procedure btnBurstBClick(Sender: TObject);
    procedure btnDiseqcAClick(Sender: TObject);
    procedure btnDiseqcBClick(Sender: TObject);
    procedure btnDiseqcBurstAClick(Sender: TObject);
    procedure btnDiseqcBurstBClick(Sender: TObject);
    procedure btnDiseqcABurstBClick(Sender: TObject);
    procedure btnDiseqcBBurstAClick(Sender: TObject);
    procedure btnStopMovementClick(Sender: TObject);
    procedure btnResetPositionerClick(Sender: TObject);
    procedure btnGoEastClick(Sender: TObject);
    procedure btnGoWestClick(Sender: TObject);
    procedure btnSetEastLimitClick(Sender: TObject);
    procedure btnSetWestLimitClick(Sender: TObject);
    procedure btnDisableLimitsClick(Sender: TObject);
    procedure btnStorePositionClick(Sender: TObject);
    procedure btnStepEastClick(Sender: TObject);
    procedure btnStepWestClick(Sender: TObject);
    procedure btnGotoPositionClick(Sender: TObject);
    procedure udPositionChangingEx(Sender: TObject;
      var AllowChange: Boolean; NewValue: Smallint;
      Direction: TUpDownDirection);
    procedure btnGotoAngularClick(Sender: TObject);
    procedure btnRecalculateClick(Sender: TObject);
    procedure rgTunerClick(Sender: TObject);
  private
    { Private declarations }
    FCardHandle : THandle;
    FCardNoError: Boolean;
    FFrequencySearch: Boolean;
    FFrequencySearchCountDown: Byte;
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Creation of form.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.FormCreate(Sender: TObject);
begin
  FCardHandle  := INVALID_HANDLE_VALUE;
  FCardNoError := False;
  FFrequencySearch := False;
  FFrequencySearchCountDown := 0;
  // Check if the driver is present and/or multiple cards are present
  case Saa7146aGetNumberOfCards of
    0:   mmoDriver.Lines.Add('No SAA7146A driver and/or card detected.');
  end;
  // If any card detected then display additional information
  if Saa7146aGetNumberOfCards <> 0 then
    FCardHandle := Saa7146aCreateFile(-1);
  btnResetClick(nil);
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Destruction of form.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  if FCardHandle <> INVALID_HANDLE_VALUE then
  begin
    Saa7146aDisableLNB(FCardHandle, True);
    Saa7146aCloseHandle(FCardHandle);
  end;
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Exit application.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;


procedure TfrmMain.rgPolarityClick(Sender: TObject);
begin
  case rgPolarity.ItemIndex of
    0: if not Saa7146aHorizontalPolarityLNB(FCardHandle, True) then
         mmoDriver.Lines.Add('Could not set horizontal polarity.');
    1: if not Saa7146aVerticalPolarityLNB(FCardHandle, True) then
         mmoDriver.Lines.Add('Could not set vertical polarity.');
  end;
end;


procedure TfrmMain.mskSymbolRateChange(Sender: TObject);
var
  SymbolRate: Dword;
  Error:      Integer;
begin
  Val(mskSymbolRate.EditText, SymbolRate, Error);
  if Error <> 0 then
  begin
    mmoDriver.Lines.Add('Could not convert symbolrate.');
    Exit;
  end;
  if not Saa7146aQpskSetSymbolRate(FCardHandle, SymbolRate) then
    mskSymbolRate.Color := clRed
  else
    mskSymbolrate.Color := clLime;
end;


procedure TfrmMain.tmrUpdateTimer(Sender: TObject);
var
  Percentage: Byte;
  Deviation : Integer;
  Frequency : Dword;
  Error     : Integer;
  PowerPercentage: Double;
  PowerDecibel   : Double;
  LockState : Byte;
  Noise     : Double;
  StatusStr : string;
begin
FFrequencySearch := False;
  if Saa7146aQpskGetLockDetectorPercentage(FCardHandle, Percentage) then
    ggLock.Progress := Percentage;
  if Saa7146aQpskGetCarrierDeviation(FCardHandle, Deviation) then
    stDeviation.Caption := format('%d', [Deviation]);
  if Saa7146aQpskGetSymbolRateDeviation(FCardHandle, Deviation) then
    stDeviationSymbolRate.Caption := format('%d', [Deviation]);
  if FFrequencySearch then
  begin
    Val(mskFrequency.EditText, Frequency, Error);
    if Error = 0 then
    begin
      Frequency := Frequency + Dword(Deviation);
      mskFrequency.Text := format('%d', [Frequency]);
      mskFrequencyChange(nil);
    end;
    if FFrequencySearchCountDown <> 0 then
      Dec(FFrequencySearchCountDown);
    if FFrequencySearchCountDown = 0 then
      FFrequencySearch := False;
  end;

  if Saa7146aQpskGetSignalPower(FCardHandle, PowerPercentage, PowerDecibel) then
  begin
    statictext5.caption := format('Power: %f%% (%f dB)', [PowerPercentage, PowerDecibel]);
  end;
  if Saa7146aReadFromQpsk(FCardHandle, CStv0299bVStatus, LockState) then
  begin
    if (LockState and $80) <> 0 then
      StatusStr := 'CARRIER'
    else
      StatusStr := 'NO CARRIER';
    if (LockState and $10) <> 0 then
      StatusStr := StatusStr + ' - VITERBI'
    else
      StatusStr := StatusStr + ' - NO VITERBI';
    if (LockState and $08) <> 0 then
      StatusStr := StatusStr + ' - SYNC'
    else
      StatusStr := StatusStr + ' - NO SYNC';
    if (LockState and $98) = $98 then
      StatusStr := StatusStr + ' - LOCK'
    else
      StatusStr := StatusStr + ' - NO LOCK';
    statictext6.caption := format('Status $%2.2x : %s', [LockState, StatusStr]);
  end;
  if Saa7146aQpskGetNoiseIndicator(FCardHandle, Noise) then
  begin
    statictext8.caption := format('C/N: %f dB', [Noise]);
  end;
end;

procedure TfrmMain.mskFrequencyChange(Sender: TObject);
var
  Frequency: Dword;
  Error:     Integer;
begin
  Val(mskFrequency.EditText, Frequency, Error);
  if Error <> 0 then
  begin
    mmoDriver.Lines.Add('Could not convert frequency.');
    Exit;
  end;
  // Befi

  if not Saa7146aFrequencyLNB(FCardHandle, Frequency, 9750000, 10600000, rgTuner.ItemIndex, 1) then
    mskFrequency.Color := clRed
  else
    mskFrequency.Color := clLime;
  if FFrequencySearchCountDown = 0 then
  begin
//    Saa7146aWriteToQpsk(FCardHandle, CStv0299bBclc, LockState) then
    FFrequencySearchCountDown := 10;
  end;
  FFrequencySearch := True;
end;

procedure TfrmMain.mskFrequencyKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    mskFrequencyChange(nil);
end;

procedure TfrmMain.mskSymbolRateKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    mskSymbolrateChange(nil);
end;

procedure TfrmMain.btnBeforeLockClick(Sender: TObject);
var
  Data: Byte;
begin
  if not Saa7146aReadFromQpsk(FCardHandle, CStv0299bCfd, Data) then
    Exit;
  Data := Data or  $80;
  Saa7146aWriteToQpsk(FCardHandle, CStv0299bCfd, Data);
end;

procedure TfrmMain.btnAfterLockClick(Sender: TObject);
var
  Data: Byte;
begin
  if not Saa7146aReadFromQpsk(FCardHandle, CStv0299bCfd, Data) then
    Exit;
  Data := Data and $7F;
  Saa7146aWriteToQpsk(FCardHandle, CStv0299bCfd, Data);
end;

procedure TfrmMain.rgLNBClick(Sender: TObject);
begin
  case rgLNB.ItemIndex of
    0: if not Saa7146aEnableLNB(FCardHandle, True) then
         mmoDriver.Lines.Add('Could not enable LNB.');
    1: if not Saa7146aDisableLNB(FCardHandle, True) then
         mmoDriver.Lines.Add('Could not disable LNB.');
  end;
end;

procedure TfrmMain.btnResetClick(Sender: TObject);
var
  ReturnedByte : Byte;
begin
  FCardNoError := False;
  // The RESET of the tuner is connected to a GPIO line of the SAA7146A, so we have to configure this
  if not Saa7146aInitializeGpio(FCardHandle, True) then
  begin
    mmoDriver.Lines.Add('Could not initialize GPIO.');
    Exit;
  end;
  // Now issue a reset signal
  if not Saa7146aIssueReset(FCardHandle, 2) then
  begin
    mmoDriver.Lines.Add('Could not issue a reset.');
    Exit;
  end;
  if not Saa7146aInitializeI2c(FCardHandle) then
  begin
    mmoDriver.Lines.Add('Error initializing I2C');
    Exit;
  end;
  if not Saa7146aReadFromQpsk(FCardHandle, CStv0299bId, ReturnedByte) then
  begin
    mmoDriver.Lines.Add('Could not read identification of QPSK demodulator.');
    Exit;
  end;
  if not ReturnedByte = $A1 then
  begin
    mmoDriver.Lines.Add(format('QPSK demodulator identification NOT correct ($%x).', [ReturnedByte]));
    Exit;
  end;
  if not Saa7146aWriteDefaultsToQpsk(FCardHandle, rgTuner.ItemIndex) then
  begin
    mmoDriver.Lines.Add('QPSK registers could not be set to default values.');
    Exit;
  end;
  FCardNoError := True;
  rgPolarityClick(nil);
  rgLNBClick(nil);
  rgInversionClick(nil);
  mskFrequencyChange(nil);
  mskSymbolrateChange(nil);
  if FCardNoError then
    tmrUpdate.Enabled := True;
end;

procedure TfrmMain.rgInversionClick(Sender: TObject);
begin
  case rgInversion.ItemIndex of
    0: if not Saa7146aQpskSetInversion(FCardHandle, True) then
         mmoDriver.Lines.Add('Could not set inversion.');
    1: if not Saa7146aQpskSetInversion(FCardHandle, False) then
         mmoDriver.Lines.Add('Could not reset inversion.');
  end;
end;

procedure TfrmMain.btnBurstAClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCBurstA, 0, DiSEqCData) then
    mmoDriver.Lines.Add('Burst A error.')
  else
    mmoDriver.Lines.Add('Burst A OK. First satellite should be selected.')
end;

procedure TfrmMain.btnBurstBClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCBurstB, 0, DiSEqCData) then
    mmoDriver.Lines.Add('Burst B error.')
  else
    mmoDriver.Lines.Add('Burst B OK. Second satellite should be selected.')
end;

procedure TfrmMain.btnDiseqcAClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $10;                                    // Any LNB/switcher
  DiSEqCData[2] := $38;                                    // Committed sitches (DiSEqc level 1.0)
  DiSEqCData[3] := $F0;                                    // Switch ID in low nibble
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 4, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC A error.')
  else
    mmoDriver.Lines.Add('DiSEqC A OK. First satellite should be selected.')
end;

procedure TfrmMain.btnDiseqcBClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $10;                                    // Any LNB/switcher
  DiSEqCData[2] := $38;                                    // Committed sitches (DiSEqc level 1.0)
  DiSEqCData[3] := $F4;                                    // Switch ID in low nibble
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 4, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC B error.')
  else
    mmoDriver.Lines.Add('DiSEqC B OK. Second satellite should be selected.')
end;

procedure TfrmMain.btnDiseqcBurstAClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $10;                                    // Any LNB/switcher
  DiSEqCData[2] := $38;                                    // Committed sitches (DiSEqc level 1.0)
  DiSEqCData[3] := $F0;                                    // Switch ID in low nibble
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand or CDiSEqCBurstA, 4, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC A with burst A error.')
  else
    mmoDriver.Lines.Add('DiSEqC A with burst A OK. First satellite should be selected.')
end;

procedure TfrmMain.btnDiseqcBurstBClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $10;                                    // Any LNB/switcher
  DiSEqCData[2] := $38;                                    // Committed sitches (DiSEqc level 1.0)
  DiSEqCData[3] := $F4;                                    // Switch ID in low nibble
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand or CDiSEqCBurstB, 4, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC B with burst B error.')
  else
    mmoDriver.Lines.Add('DiSEqC B with burst B OK. Second satellite should be selected.')
end;

procedure TfrmMain.btnDiseqcABurstBClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $10;                                    // Any LNB/switcher
  DiSEqCData[2] := $38;                                    // Committed sitches (DiSEqc level 1.0)
  DiSEqCData[3] := $F0;                                    // Switch ID in low nibble
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand or CDiSEqCBurstB, 4, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC A with burst B error.')
  else
    mmoDriver.Lines.Add('DiSEqC A with burst B OK. Second satellite most likely selected.')
end;

procedure TfrmMain.btnDiseqcBBurstAClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $10;                                    // Any LNB/switcher
  DiSEqCData[2] := $38;                                    // Committed sitches (DiSEqc level 1.0)
  DiSEqCData[3] := $F4;                                    // Switch ID in low nibble
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand or CDiSEqCBurstA, 4, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC B with burst A error.')
  else
    mmoDriver.Lines.Add('DiSEqC B with burst A OK. First satellite most likely selected.')
end;



procedure TfrmMain.btnResetPositionerClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $30;                                    // Any positioner
  DiSEqCData[2] := $00;                                    // Reset
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 3, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC error.');
end;

procedure TfrmMain.btnStopMovementClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $30;                                    // Any positioner
  DiSEqCData[2] := $60;                                    // Stop positioner movement
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 3, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC error.');
end;

procedure TfrmMain.btnDisableLimitsClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $30;                                    // Any positioner
  DiSEqCData[2] := $63;                                    // Disable limits
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 3, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC error.');
end;

procedure TfrmMain.btnSetEastLimitClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $30;                                    // Any positioner
  DiSEqCData[2] := $66;                                    // Set East limit
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 3, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC error.');
end;

procedure TfrmMain.btnSetWestLimitClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $30;                                    // Any positioner
  DiSEqCData[2] := $67;                                    // Set West limit
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 3, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC error.');
end;

procedure TfrmMain.btnGoEastClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $30;                                    // Any positioner
  DiSEqCData[2] := $68;                                    // Drive East
  DiSEqCData[3] := $00;                                    // Timeout (no timeout)
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 4, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC error.');
end;

procedure TfrmMain.btnStepEastClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $30;                                    // Any positioner
  DiSEqCData[2] := $68;                                    // Drive East
  DiSEqCData[3] := $FF;                                    // $00 - steps, $FF = smallest
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 4, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC error.');
end;

procedure TfrmMain.btnGoWestClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $30;                                    // Any positioner
  DiSEqCData[2] := $69;                                    // Drive West
  DiSEqCData[3] := $00;                                    // Timeout (no timeout)
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 4, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC error.');
end;

procedure TfrmMain.btnStepWestClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $30;                                    // Any positioner
  DiSEqCData[2] := $69;                                    // Drive West
  DiSEqCData[3] := $FF;                                    // $00 - steps, $FF = smallest
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 4, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC error.');
end;

procedure TfrmMain.btnStorePositionClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $30;                                    // Any positioner
  DiSEqCData[2] := $6A;                                    // Store position xx
  DiSEqCData[3] := UdPosition.Position;                    // Position xx
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 4, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC error.');
  udPosition.Position := udPosition.Position + 1;  
end;

procedure TfrmMain.btnGotoPositionClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $30;                                    // Any positioner
  DiSEqCData[2] := $6B;                                    // Goto position xx
  DiSEqCData[3] := UdPosition.Position;                    // Position xx
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 4, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC error.');
end;

procedure TfrmMain.btnGotoAngularClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $30;                                    // Any positioner
  DiSEqCData[2] := $6E;                                    // Goto angular position
  DiSEqCData[3] := $00;                                    // Angular pos,  16 degrees steps
  DiSEqCData[4] := $00;                                    // Angular pos, degrees and fraction
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 5, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC error.');
end;

procedure TfrmMain.btnRecalculateClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $30;                                    // Any positioner
  DiSEqCData[2] := $6F;                                    // recalculate positions
  if not Saa7146aDiSEqCCommand(FCardHandle, 1, CDiSEqCCommand, 3, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC error.');
end;

procedure TfrmMain.udPositionChangingEx(Sender: TObject;
  var AllowChange: Boolean; NewValue: Smallint;
  Direction: TUpDownDirection);
begin
  Newvalue := udPosition.Position;
  if Direction = updUp then
  begin
    Newvalue := NewValue + 1;
    if NewValue > udPosition.Max then
      NewValue := udPosition.Max;
  end
  else
    if Direction = updDown then
    begin
      Newvalue := NewValue - 1;
      if NewValue < udPosition.Min then
        NewValue := udPosition.Min;
    end;
  txtPosition.Caption := format('%3.3d', [Newvalue]);
end;



procedure TfrmMain.rgTunerClick(Sender: TObject);
begin
  btnResetClick(nil);
end;

end.
