//{ **************************************************************************** }
//{ FileName............: STDDCLS.H                                              }
//{ Project.............: Generic                                                }
//{ Author(s)...........: M.Majoor                                               }
//{ Original contents...: Walter Oney ('Programming the Windows Driver Model')   }
//{ Version.............: 3.20                                                   }
//{ ---------------------------------------------------------------------------- }
//{ Precompiled headers for WDM drivers.                                         }
//{                                                                              }
//{ Version  Date      Comment                                                   }
//{ 1.00     20010818  - Initial release                                         }
//{ 1.01     20020917  - No changes                                              }
//{ 2.00     20020930  - No changes                                              }
//{ 2.01     20040514  - No changes                                              }
//{ 2.02     20050408  - No changes                                              }
//{ 3.00     20060624  - No changes                                              }
//{ 3.10     20080126  - No changes                                              }
//{ 3.20     20171208  - No changes                                              }
//{ **************************************************************************** }


#ifdef __cplusplus
  extern "C" {
#endif

#include <wdm.h>
#include <wmilib.h>
#include <wmistr.h>
#include <stdio.h>

#ifdef __cplusplus
  }
#endif

#define PAGEDCODE  code_seg("page")
#define LOCKEDCODE code_seg()
#define INITCODE   code_seg("init")

#define PAGEDDATA  data_seg("page")
#define LOCKEDDATA data_seg()
#define INITDATA   data_seg("init")

#define arraysize(p) (sizeof(p)/sizeof((p)[0]))

// Override DDK definition of ASSERT so that debugger halts in the
// affected code and halts even in the unchecked OS

#if DBG && defined(_X86_)
  #undef ASSERT
  #define ASSERT(e) if(!(e)){DbgPrint("Assertion failure in "\
                                      __FILE__ ", line %d: " #e "\n", __LINE__);\
                                      _asm int 1\
                            }
#endif

#if !DBG
  #pragma warning(disable:4390)                            // Empty controlled stmt [e.g., if() KdPrint();]
#endif

// Currently, the support routines for managing the device remove lock aren't
// implemented in Windows 98. The following declarations
// provide equivalent functionality on all WDM platforms by means of a private
// implementation in RemoveLock.cpp

typedef struct _REMOVE_LOCK
{
  LONG    usage;                                           // Reference count
  BOOLEAN removing;                                        // True if removal is pending
  KEVENT  evRemove;                                        // Event to wait on
} REMOVE_LOCK, *PREMOVE_LOCK;


VOID     InitializeRemoveLock    (PREMOVE_LOCK lock, ULONG tag, ULONG minutes, ULONG maxcount);
NTSTATUS AcquireRemoveLock       (PREMOVE_LOCK lock, PVOID tag);
VOID     ReleaseRemoveLock       (PREMOVE_LOCK lock, PVOID tag);
VOID     ReleaseRemoveLockAndWait(PREMOVE_LOCK lock, PVOID tag);

// Redefine macros in case the programmer changes the driver to include NTDDK.H
// instead of WDM.H

#undef  IoInitializeRemoveLock
#define IoInitializeRemoveLock InitializeRemoveLock

#undef  IoAcquireRemoveLock
#define IoAcquireRemoveLock AcquireRemoveLock

#undef  IoReleaseRemoveLock
#define IoReleaseRemoveLock ReleaseRemoveLock

#undef  IoReleaseRemoveLockAndWait
#define IoReleaseRemoveLockAndWait ReleaseRemoveLockAndWait

#define _IO_REMOVE_LOCK _REMOVE_LOCK
#define IO_REMOVE_LOCK REMOVE_LOCK
#define PIO_REMOVE_LOCK PREMOVE_LOCK
