//{ **************************************************************************** }
//{ FileName............: INSTALLDRIVER.C                                        }
//{ Project.............: Installation of driver                                 }
//{ Author(s)...........: M.Majoor                                               }
//{ Version.............: 1.00                                                   }
//{ ---------------------------------------------------------------------------- }
//{ Automatic installation of driver                                             }
//{                                                                              }
//{ Version  Date      Comment                                                   }
//{ 1.00     20060714  - Initial release                                         }
//{ **************************************************************************** }

#include <windows.h>
#include <stdio.h>
#include "newdev.h"   // for the API UpdateDriverForPlugAndPlayDevices().

#include "argcargv.h" // Command line arguments converter


// ----------------------------------------------------------------------------
//  Params  : <InfFile>    (Pointer to) Name of INF file
//            <PciDevice>  (Pointer to) Name of PCI device
//  Returns : <Result>     0 if no error
//
//  Descript: Install driver
//  Notes   :
// ----------------------------------------------------------------------------
int InstallDriver(LPCSTR InfFile, LPCSTR PciDevice)
{
//   MessageBox(0, InfFile,   "Inf file",   0);
//   MessageBox(0, PciDevice, "Pci device", 0);
   if (UpdateDriverForPlugAndPlayDevices(0, PciDevice, InfFile, INSTALLFLAG_FORCE, 0))
     return 0;
   else
   { DWORD Error = GetLastError();
     char buffer[1024];

     sprintf(buffer, "Error installing driver:\n\tWindows error code $%8.8x\n", Error);
     if (Error == 0x00000002)                 // ERROR_FILE_NOT_FOUND
       sprintf(buffer, "Error installing driver:\n\tThe [InfFile] parameter is incorrect (check path and name).\n");
     if (Error == 0x00000005)                 // ERROR_ACCESS_DENIED
       sprintf(buffer, "Error installing driver:\n\tAccess denied (insufficients rights to install the driver).\n\n"\
                       "For Windows Vista users:\n"\
                       "\tThis is a non-signed driver and this driver can only be\n"\
                       "\tinstalled when the check on signed drivers is disabled.\n"\
                       "\tThis can be done from a command prompt but you need to have\n"\
                       "\tadministrator rights.\n"\
                       "\tUnder 'Start/Programs/Accessories' right click on\n"\
                       "\t'Command Prompt' and select 'Run as administrator'\n"\
                       "\tor 'Run elevated'.\n"\
                       "\tThen execute the following command:\n"\
                       "\t\tbcdedit -set nointegritychecks ON\n\n"\
                       "\tThen restart the InstallDriver application by right clicking\n"\
                       "\tit and select 'Run as administrator or 'Run elevated'.\n"\
                       "\tAfter confirmation and succesful installation, you\n"\
                       "\tneed to restart the PC since the check on signed drivers\n"\
                       "\tis still active until the next reboot.\n");
     if (Error == 0xE0000203)
       sprintf(buffer, "Error installing driver:\n\tThere is no driver selected for the device information set or element ([InfFile] parameter probably not an INF file).\n");
     if (Error == 0xE000022F)                 //  ERROR_NO_CATALOG_FOR_OEM_INF
       sprintf(buffer, "Error installing driver:\n\tInstallation stopped.\n");
     if (Error == 0xE0000235)                 // ERROR_IN_WOW64
       sprintf(buffer, "Error installing driver:\n\t32-bit application attempting to execute in 64-bit.\n");
     if (Error == 0xE000020B)                  // ERROR_NO_SUCH_DEVINST
       sprintf(buffer, "Error installing driver:\n\tThe [PciDeviceIdentifier] parameter does not match any plugged in devices.\n");
     MessageBox(0, buffer, "InstallDriver error",   0);
     return -1;
   }
}


int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{

  // Convert string to argv format
  int argc = _ConvertCommandLineToArgcArgv(lpCmdLine);

  BOOL bSuccess = FALSE;

  if (argc != 2)
  { MessageBox(0, "Expected two command line parameters:\n\n" \
                  "Usage:\n\n\tInstallDriver \"InfFile\" \"PciDeviceIdentifier\"\n\n" \
                  "Examples:\n" \
                  "\tInstallDriver  \"SAA7146A.INF\"  \"PCI\\VEN_1131&DEV_7146\"\n" \
                  "\tInstallDriver  \"FLEXCOP.INF\"   \"PCI\\VEN_13D0&DEV_2103\"\n" \
                  "\tInstallDriver  \"FLEXCOP.INF\"   \"PCI\\VEN_13D0&DEV_2200\"\n\n", \
                  "InstallDriver error", 0);
    return -1;
  }
  else
  { if (InstallDriver(_ppszArgv[0], _ppszArgv[1]) != 0)
    { // MessageBox(0, "Some error occured and the driver could not be installed (check the command line parameters).\n", "InstallDriver error", 0);
      return -1;
    }
    else
      return 0;
  }
}
