{******************************************************************************}
{ FileName............: Saa7146aIoControl                                      }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{ Io control definitions for the SAA7146A driver                               }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20021227 - Initial release SAA7146A.SYS V2.00                        }
{******************************************************************************}
unit Saa7146aIoControl;

interface
uses
  Windows;

type
  Pvoid            = Pointer;
  PPhysicalMemoryAddress = ^PhysicalMemoryAddress;
  PhysicalMemoryAddress  = LARGE_INTEGER;

  TSaa7146AGetDriverVersion = record
    MajorVersion: Word;                // Major version
    MinorVersion: Word;                // Minor version
    Build       : Dword;               // Build (date): $YYYMMDD
  end;

  TSaa7146aGetDmaStatus  = record
    Interrupts              : Longint;                     // Number of interrupts counted sofar
    Isr                     : Dword;                       // Interrupt status register
    VirtualAddress          : Pvoid;                       // Virtual address of common buffer
    PhysicalAddress         : PhysicalMemoryAddress;       // Physical address of common buffer (use only for in RPS programs)
    Size                    : Dword;                       // Size of common buffer
    FifoOverflows           : Dword;                       // Global FIFO overflows
  end;

  TSaa7146aDmaBuffer  = record
    Identifier              : Longint;                     // ID of buffer
    VirtualAddress          : Pvoid;                       // Virtual address of buffer
    PhysicalAddress         : PhysicalMemoryAddress;       // Physical address of buffer
    Size                    : Dword;                       // Size of buffer
  end;

  TSaa7146aTransferBuffer  = record
    Identifier      : Longint;                             // ID of buffer
    TransferAddress : Pchar;                               // Pointer to source/target buffer
    SourceIndex     : Dword;                               // Index into source buffer
    TargetIndex     : Dword;                               // Index into target buffer
    TransferLength  : Dword;                               // Number of bytes to transfer
  end;

  TSaa7146aFifoTransferBuffer  = record
    Identifier      : Longint;                             // ID of buffer
    NumberOfBuffers : Dword;                               // Number of buffers
    TransferAddress : Pchar;                               // Pointer to source/target buffer
    TransferLength  : Dword;                               // Number of bytes to transfer
    IsValid         : Boolean;                             // Copy of <writeTag> indicating buffer has been written to
    OrderNumber     : Dword;                               // Copy of <irqsActiveReceived> counter when FIFO was written = order number
    Overflows       : Dword;                               // Counter incremented when written to buffer without reading it before
    Irqs            : Dword;                               // Counter incremented for each interrupt associated with the FIFO
    AllOverflows    : Dword;                               // Counter incremented when written to buffer without reading it before for ALL FIFO buffers of this IRQ
  end;

  TSaa7146aIrqBuffer = record
    Irqs                    : Dword;                       // Counter incremented for each interrupt of this type
    IrqsWhenActive          : Dword;                       // Counter incremented for each interrupt of this type when active
    IrqBufferingIsActive    : Boolean;                     // Global activation flag of this interrupt
    UseNotificationEvent    : Boolean;                     // Indicates notify event to be triggered
    UseSignaling            : Boolean;                     // Indicates signal to be triggered
    UseFifo                 : Boolean;                     // Indicates FIFO to be used
    IrqAutoDisable          : Boolean;                     // Indicates if interrupt is only triggered once (interrupt enable register is cleared)
                                                           // which is necessary for 'persistent' interrupts (like RPS timeout)
    SignalSaa7146aRegister  : Dword;                       // SAA7146A register to check for banking info
    SignalAndValue          : Dword;                       // AND operation to perform on register contents to extract bit
    SignalOrValue           : Dword;                       // OR  operation to perform on ANDED register contents to extract bit
    SignalXorValue          : Dword;                       // XOR (invert) operation to perform on ANDED and ORED register contents to extract bit

    FifoBufferPreviousIndex : Byte;                        // Previous FIFO used (index FIFO buffer array)
    FifoBufferFirstIndex    : Byte;                        // First FIFO to use (index FIFO buffer array)
    FifoBufferLastIndex     : Byte;                        // Last  FIFO to use (index FIFO buffer array)
    FifoBufferCirculations  : Dword;                       // Counter incremented each time <fifoBufferNext> == <fifoBufferStart>
    FifoOverflows           : Dword;                       // Counter incremented each time a FIFO <writeTag> was still set when written to it
  end;

  TSaa7146aIrqTransferBuffer  = record
    Identifier  : Longint;                                 // ID of SAA7146A IRQ bit number (0..31)
    Information : TSaa7146aIrqBuffer;                      // Information structure
  end;

  
const
  CSaa7146aDriverName = '\\.\SAA7146A1';                   // NT name for driver


{------------------------------------------------------------------------------
  Descript: IOCTL codes to access driver.
 -----------------------------------------------------------------------------}
  CIoctlSaa7146aGetDriverVersion           = $222000;      // Retrieve version information (SAA7146A_GET_VERSION structure)
  CIoctlSaa7146aGetDmaStatus               = $222004;      // Retrieve status information  (SAA7146A_GET_STATUS  structure)
  CIoctlSaa7146aReadFromSaa7146aRegister   = $222008;      // Read  a SAA7146A register
  CIoctlSaa7146aWriteToSaa7146aRegister    = $22200C;      // Write a SAA7146A register
  CIoctlSaa7146aWaitForNotification        = $222010;      // Wait for a notification
  CIoctlSaa7146aGenerateManualNotification = $222014;      // Manually trigger the notification
  CIoctlSaa7146aAllocateDma                = $222018;      // Allocate  DMA buffer
  CIoctlSaa7146aReleaseDma                 = $22201C;      // Release   DMA buffer
  CIoctlSaa7146aReadFromDma                = $222020;      // Read from DMA buffer
  CIoctlSaa7146aWriteToDma                 = $222024;      // Write to  DMA buffer
  CIoctlSaa7146aAllocateFifo               = $222028;      // Allocate  FIFO buffer
  CIoctlSaa7146aReleaseFifo                = $22202C;      // Release   FIFO buffer
  CIoctlSaa7146aReadFromFifo               = $222030;      // Read from FIFO buffer
  CIoctlSaa7146aWriteToIrqHandling         = $222034;      // Write to  IRQ handling
  CIoctlSaa7146aReadFromIrqHandling        = $222038;      // Read from IRQ handling

implementation

end.
