{******************************************************************************}
{ FileName............: Pico                                                   }
{ Project.............:                                                        }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Command line interface for Pico script                                      }
{                                                                              }
{  Usage:                                                                      }
{    Pico Script [Function [Parameter] [Parameter]]                            }
{  where                                                                       }
{    Script   : Script file                                                    }
{    Function : Optional function to call                                      }
{    Parameter: Optional parameters                                            }
{                                                                              }
{  Copyright (C) 2003-2006  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20060205 - Initial release                                           }
{******************************************************************************}
program Pico;
uses
  FastMM4,
  Dialogs,
  PicoExecute,
  SysUtils;

var
  PicoId    : Integer;
  Loop      : Integer;
  Error     : Integer;
  Params    : OleVariant;
  ParamsOut : OleVariant;
  AReal     : Extended;
  AnInteger : Integer;
  A         : array[0..127] of Char;
begin
  // Insert user code here
  if ParamCount = 0 then
    Exit;
  if not FileExists(ParamStr(1)) then
    Exit;
  PicoId := ScriptLoad(ParamStr(1));
  VarClear(Params);
  VarClear(ParamsOut);
  try
    if PicoId >= 0 then
    begin
      if ParamCount > 2 then
      begin
        Params := VarArrayCreate([0, ParamCount-3], varVariant);
        for Loop := 3 to ParamCount do
        begin
          Val(ParamStr(Loop), AnInteger, Error);
          if Error <> 0 then
          begin
            Val(ParamStr(Loop), AReal, Error);
            if Error <> 0 then
              Params[Loop-3] := VarAsType(ParamStr(Loop), varOleStr)
            else
              Params[Loop-3] := VarAsType(AReal, varDouble);
          end
          else
            Params[Loop-3] := VarAsType(AnInteger, varInteger)
        end;
      end;
      if ParamCount > 1 then
      begin
        StrPCopy(A, ParamStr(2));
        if not ScriptExecute(PicoId, A, Params, ParamsOut) then
          ShowMessage(ScriptMessage);
      end;
      ScriptUnload(PicoId);
    end
    else
      ShowMessage(ScriptMessage);
  finally
    VarClear(Params);
    VarClear(ParamsOut);
  end;
end.

