--{******************************************************************************}
--{ FileName............: i2c_simulation.vhdl
--{ Author(s)...........: Marcel Majoor
--{ Copyright...........: 2026 - 2026
--{------------------------------------------------------------------------------}
--{
--{ Implements:
--{ . Main clock
--{ . Blinky LED
--{ . Keyboard input that is put on the serial output
--{ . Debug data on P2 PMOD port
--{
--{ Version       Comment
--{ 2026.01.02.0  - First release
--{------------------------------------------------------------------------------}
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity i2c_simulation is
end i2c_simulation;

architecture Behavioral of i2c_simulation is
  constant  STRINGSIZE: integer := 32;
  constant  OUTPUTBITS: integer := 8;
  -- Our clock signal we derive our LED signals from
  signal ClkIn             : std_logic;
  -- I2C
  signal I2cScl        : std_logic;
  signal I2cSda        : std_logic;
  signal I2cOperations : string(1 to STRINGSIZE);
  signal I2cStart      : std_logic;
  signal I2cData       : std_logic_vector(OUTPUTBITS-1 downto 0);      
  signal I2cError      : std_logic;
  signal I2cReady      : std_logic;
  signal I2cDebug      : std_logic_vector(7 downto 0);      

begin
  -- Instantiation of the I2C
  I2c_I: entity work.i2c
    generic map (
      CLKRATE    => 10000000,
      I2CRATE    => 100000,
      STRINGSIZE => STRINGSIZE,
      OUTPUTBITS => OUTPUTBITS
    )
    port map (
      clk        => ClkIn,
      scl        => I2cScl,
      sda        => I2cSda,
      operations => I2cOperations,
      start      => I2cStart,
      data       => I2cData,
      error      => I2cError,
      ready      => I2cReady,
      debug      => I2cDebug
    );

  --{------------------------------------------------------------------------------}
  --{ Descript: Generate the main clock
  --{------------------------------------------------------------------------------}
  process
  begin
    ClkIn <= '0';
		wait for 5 ns;
		ClkIn <= '1';
		wait for 5 ns;
  end process;


  --{------------------------------------------------------------------------------}
  --{------------------------------------------------------------------------------}
  process
  begin
    I2cStart            <= '0';
    wait for 1 ms;
    if I2cReady = '0' then
      wait until I2cReady = '1';
    end if;  
    I2cOperations       <= "SLHHLLLLLabbbbbbbbaP?_no_matter_";
    I2cStart            <= '1';
    wait until I2cReady = '0';
    I2cStart            <= '0';
    wait until I2cReady = '1';
    -- Now operations that do not end in a STOP
    I2cOperations       <= "SLHLHLHLHAbAbababbabbbbb?_no_mat";
    I2cStart            <= '1';
    wait until I2cReady = '0';
    I2cStart            <= '0';
    wait until I2cReady = '1';
    I2cOperations       <= "bbbbbbbbabbbbbbbbabbbbbbbba?_no_";
    I2cStart            <= '1';
    wait until I2cReady = '0';
    I2cStart            <= '0';
    wait until I2cReady = '1';
    I2cOperations       <= "bbbbbbbbP?_no_matter_no_matter_n";
    I2cStart            <= '1';
    wait until I2cReady = '0';
    I2cStart            <= '0';
    wait until I2cReady = '1';
    
    wait;

  end process;
  
  
end Behavioral;
