--{******************************************************************************}
--{ FileName............: led_to_keyboard.vhdl
--{ Author(s)...........: Marcel Majoor
--{ Copyright...........: 2025 - 2025
--{------------------------------------------------------------------------------}
--{
--{ Translate a LED 'request' into bit numbers (0.. 127) for the keyboard controller
--{
--{ LED data:
--{ . Data bits (to keyboard controller):
--{     127..120  -
--{     119..112  -
--{     111..104  -
--{     103..096  -
--{     095..088  Blue  1  Brightness (right power LED)
--{     087..080  Green 1  Brightness (right power LED)
--{     079..072  Red   1  Brightness (right power LED)
--{     071..064  Blue  0  Brightness (left  power LED)
--{     063..056  Green 0  Brightness (left  power LED)
--{     055..048  Red   0  Brightness (left  power LED)
--{     047..040  Blue  3  Brightness (right drive LED)
--{     039..032  Green 3  Brightness (right drive LED)
--{     031..024  Red   3  Brightness (right drive LED)
--{     023..016  Blue  2  Brightness (left  drive LED)
--{     015..008  Green 2  Brightness (left  drive LED)
--{     007..000  Red   2  Brightness (left  drive LED)
--(
--{ Version       Comment
--{ 2025.03.29.0  - First release
--{------------------------------------------------------------------------------}
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;
use work.mega_package.all;

entity led_to_keyboard is
  port (
    clk                         : in  std_logic;
    power_led_left_brightness_R : in  std_logic_vector(  7 downto 0);
    power_led_left_brightness_G : in  std_logic_vector(  7 downto 0);
    power_led_left_brightness_B : in  std_logic_vector(  7 downto 0);
    power_led_right_brightness_R: in  std_logic_vector(  7 downto 0);
    power_led_right_brightness_G: in  std_logic_vector(  7 downto 0);
    power_led_right_brightness_B: in  std_logic_vector(  7 downto 0);
    drive_led_left_brightness_R : in  std_logic_vector(  7 downto 0);
    drive_led_left_brightness_G : in  std_logic_vector(  7 downto 0);
    drive_led_left_brightness_B : in  std_logic_vector(  7 downto 0);
    drive_led_right_brightness_R: in  std_logic_vector(  7 downto 0);
    drive_led_right_brightness_G: in  std_logic_vector(  7 downto 0);
    drive_led_right_brightness_B: in  std_logic_vector(  7 downto 0);
    led_data                    : out std_logic_vector(127 downto 0)
   );
end led_to_keyboard;


architecture Behavioral of led_to_keyboard is
  signal KeyboardData: std_logic_vector(127 downto 0);
  
begin
  --{------------------------------------------------------------------------------}
  --{ Descript: Put everything at the correct place
  --{------------------------------------------------------------------------------}
  process (clk)
  begin
    if rising_edge(clk) then
      KeyboardData(127 downto 96) <= (others => '0');
      KeyboardData( 95 downto 88) <= power_led_right_brightness_B;
      KeyboardData( 87 downto 80) <= power_led_right_brightness_G;
      KeyboardData( 79 downto 72) <= power_led_right_brightness_R;
      KeyboardData( 71 downto 64) <= power_led_left_brightness_B;
      KeyboardData( 63 downto 56) <= power_led_left_brightness_G;
      KeyboardData( 55 downto 48) <= power_led_left_brightness_R;
      KeyboardData( 47 downto 40) <= drive_led_right_brightness_B;
      KeyboardData( 39 downto 32) <= drive_led_right_brightness_G;
      KeyboardData( 31 downto 24) <= drive_led_right_brightness_R;
      KeyboardData( 23 downto 16) <= drive_led_left_brightness_B;
      KeyboardData( 15 downto  8) <= drive_led_left_brightness_G;
      KeyboardData(  7 downto  0) <= drive_led_left_brightness_R;
    end if;           
  end process;

  led_data <= KeyboardData;
  
end Behavioral;
