--{******************************************************************************}
--{ FileName............: main_serialinout_simulation.vhdl
--{ Author(s)...........: Marcel Majoor
--{ Copyright...........: 2025 - 2025
--{------------------------------------------------------------------------------}
--{
--{ Does a simulation of main_serialinout by providing a simulated clock
--{ For visually checking of the implementation (this is not a test bench)
--{ Note that the simulation needs to run a long time because of the 'slow'
--{ baudrate.
--{
--{ Implements:
--{ . Simulated signals
--{
--{ Version       Comment
--{ 2025.03.29.0  - First release
--{------------------------------------------------------------------------------}
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity main_serialinout_simulation is
end main_serialinout_simulation;

architecture Behavioral of main_serialinout_simulation is
  signal clk_in        : std_logic;
  signal reset_button  : std_logic;
  signal led           : std_logic;
  signal data_out_busy : std_logic;
  signal data_in_toggle: std_logic;
  signal serial_out    : std_logic;
  signal serial_in     : std_logic;
  
  signal SerialData: std_logic_vector(7 downto 0);

begin
  MainSerialInOut: entity work.main_serialinout
    port map ( 
      clk_in       => clk_in,
      reset_button => reset_button,
      led          => led,
      led_g        => data_out_busy,
      led_r        => data_in_toggle,
      uart_txd     => serial_out,
      rsrx         => serial_in
    );


  --{------------------------------------------------------------------------------}
  --{ Descript: Generate the main 100 MHz clock
  --{------------------------------------------------------------------------------}
  process
  begin
    -- 100 Mhz == 10 ns (5 ns high, 5 ns low)
    clk_in <= '0';
		wait for 5 ns;
		clk_in <= '1';
		wait for 5 ns;
  end process;


  --{------------------------------------------------------------------------------}
  --{ Descript: Generate serial input data
  --{------------------------------------------------------------------------------}
  process
  begin
    reset_button <= '0';
    SerialData <= "10101010";
		serial_in <= '1';
		wait for 100 us;
		--
		-- Start bit
		serial_in <= '0';
		wait for 8.68 us;
		-- Data bits
    for i in SerialData'LOW to SerialData'HIGH loop
  		serial_in <= SerialData(i);
      wait for 8.68 us;
    end loop;
		-- Stop bit
		serial_in <= '1';
		wait for 8.68 us;
		wait for 30 us;
		--
		--
    SerialData <= "11111010";
		-- Start bit
		serial_in <= '0';
		wait for 8.68 us;
		-- Data bits
    for i in SerialData'LOW to SerialData'HIGH loop
  		serial_in <= SerialData(i);
      wait for 8.68 us;
    end loop;
		-- Stop bit
		serial_in <= '1';
		wait for 8.68 us;
		wait for 30 us;
		--
		
		wait for 100 ns;
  end process;

end Behavioral;
