--{******************************************************************************}
--{ FileName............: main_serialout_simulation.vhdl
--{ Author(s)...........: Marcel Majoor
--{ Copyright...........: 2025 - 2025
--{------------------------------------------------------------------------------}
--{
--{ Does a simulation of main_serialout by providing a simulated clock
--{ For visually checking of the implementation (this is not a test bench)
--{ Note that the simulation needs to run a long time because of the 'slow'
--{ baudrate.
--{
--{ Implements:
--{ . Simulated signals
--{
--{ Version       Comment
--{ 2025.03.29.0  - First release
--{------------------------------------------------------------------------------}
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity main_serialout_simulation is
end main_serialout_simulation;

architecture Behavioral of main_serialout_simulation is
  signal clk_in      : std_logic;
  signal reset_button: std_logic;
  signal led         : std_logic;
  signal busy        : std_logic;
  signal data_start  : std_logic;
  signal uart_txd    : std_logic;

begin
  MainSerialOut: entity work.main_serialout
    port map ( 
      clk_in       => clk_in,
      reset_button => reset_button,
      led          => led,
      led_g        => busy,
      led_r        => data_start,
      uart_txd     => uart_txd
    );


  --{------------------------------------------------------------------------------}
  --{ Descript: Generate the main 100 MHz clock
  --{------------------------------------------------------------------------------}
  process
  begin
    -- 100 Mhz == 10 ns (5 ns high, 5 ns low)
    clk_in <= '0';
		wait for 5 ns;
		clk_in <= '1';
		wait for 5 ns;
  end process;


end Behavioral;
