# Set bank voltages
set_property CONFIG_VOLTAGE 3.3 [current_design]
set_property CFGBVS VCCO [current_design]

# Clock signal input (100MHz) from U17 via 22E
set_property -dict {PACKAGE_PIN V13 IOSTANDARD LVCMOS33} [get_ports clk_in]

create_clock -period 10.000 -name clk_in [get_ports clk_in]

create_generated_clock -name clock325 [get_pins clocks1/mmcm_adv0/CLKOUT0]
create_generated_clock -name clock81p [get_pins clocks1/mmcm_adv0/CLKOUT2]
create_generated_clock -name clock41  [get_pins clocks1/mmcm_adv0/CLKOUT3]
create_generated_clock -name clock27  [get_pins clocks1/mmcm_adv0/CLKOUT4]
create_generated_clock -name clock163 [get_pins clocks1/mmcm_adv0/CLKOUT5]
create_generated_clock -name clock270 [get_pins clocks1/mmcm_adv0/CLKOUT6]
create_generated_clock -name clock50  [get_pins clocks1/mmcm_adv1_eth/CLKOUT1]
create_generated_clock -name clock200 [get_pins clocks1/mmcm_adv1_eth/CLKOUT2]
# create_generated_clock -name clock60  [get_pins AUDIO_TONE/CLOCK/MMCM/CLKOUT1]


# Red   LED D9  via 240E to GND  (ULED), centre board, near FPGA 
set_property -dict {PACKAGE_PIN U22 IOSTANDARD LVCMOS33} [get_ports led]
# Green LED D10 via 240E to 3.3V (LED_G), edge of board
set_property -dict {PACKAGE_PIN V19 IOSTANDARD LVCMOS33} [get_ports led_g]
# Red   LED D12 via 240E to 3.3V (LED_R), edge of board
set_property -dict {PACKAGE_PIN V20 IOSTANDARD LVCMOS33} [get_ports led_r]

# Reset button S2 (switched to 3.3V when reset)
set_property -dict {PACKAGE_PIN J19 IOSTANDARD LVCMOS33} [get_ports reset_button]

# Debug UART/JTAG
set_property -dict {PACKAGE_PIN L13 IOSTANDARD LVCMOS33} [get_ports uart_txd]
# set_property -dict {PACKAGE_PIN L14 IOSTANDARD LVCMOS33} [get_ports rsrx]

# PMOD Header P2
set_property -dict { PACKAGE_PIN F3 IOSTANDARD LVCMOS33 } [get_ports {p2lo[0]}]
set_property -dict { PACKAGE_PIN E3 IOSTANDARD LVCMOS33 } [get_ports {p2lo[1]}]
set_property -dict { PACKAGE_PIN H4 IOSTANDARD LVCMOS33 } [get_ports {p2lo[2]}]
set_property -dict { PACKAGE_PIN H5 IOSTANDARD LVCMOS33 } [get_ports {p2lo[3]}]
set_property -dict { PACKAGE_PIN E2 IOSTANDARD LVCMOS33 } [get_ports {p2hi[0]}]
set_property -dict { PACKAGE_PIN D2 IOSTANDARD LVCMOS33 } [get_ports {p2hi[1]}]
set_property -dict { PACKAGE_PIN G4 IOSTANDARD LVCMOS33 } [get_ports {p2hi[2]}]
set_property -dict { PACKAGE_PIN J5 IOSTANDARD LVCMOS33 } [get_ports {p2hi[3]}]
