{******************************************************************************}
{ FileName............: MajorPushSourceUnit003                                 }
{ Project.............: DirectShow                                             }
{ Author(s)...........: MM                                                     }
{ Version.............: 2.00                                                   }
{------------------------------------------------------------------------------}
{  DirectShow push source filter property page                                 }
{                                                                              }
{  Copyright (C) 2003-2006  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20060115 - Initial release                                           }
{  2.00   20060922 - Displayed text adapated for additional settings           }
{******************************************************************************}
unit MajorPushSourceUnit003;

interface
uses
  BaseClass,
  Classes,
  Controls,
  DirectShow9,
  ExtCtrls,
  Graphics,
  MajorPushSourceUnit001,
  Messages,
  StdCtrls,
  SysUtils,
  Windows;

type
  TfrmPropertiesAbout = class(TFormPropertyPage)
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    mmoGNU: TMemo;
  private
  public
    function  OnConnect(Unknown: IUnknown): HRESULT; override;
    function  OnDisconnect: HRESULT; override;
    function  OnApplyChanges: HRESULT; override;
  end;

implementation



{$R *.DFM}


{------------------------------------------------------------------------------
  Params  : <Unknown>
  Returns : <Result>

  Descript: On connect property page.
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmPropertiesAbout.OnConnect(Unknown: IUnknown): HRESULT;
var
  hr          : HRESULT;
  Version     : PChar;
  SourceFilter: IMajorPushSource;
begin
  Version := nil;
  if not Assigned(Unknown) then
  begin
    Result := E_POINTER;
    Exit;
  end;
  // Next will fail if connected to a running graph from the *ROT* ...
  hr := Unknown.QueryInterface(IMajorPushSource, SourceFilter);
  if Succeeded(hr) then
  begin
    // Place version information in tab header
    // Setting the caption will fail if the graph is already running, since
    // the Caption is then 'locked'!
    GetMem(Version, 128);
    SourceFilter.GetVersionInformation(Version);
    mmoGNU.Lines[1] := Version + '  -  Copyright (C) 2003-2006  M.Majoor';
    Caption := 'About';
    FreeMem(Version);
  end;
  Result := NOERROR;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>

  Descript: On disconnect property page.
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmPropertiesAbout.OnDisconnect: HRESULT;
begin
  Result := NOERROR;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: On apply changes property page.
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmPropertiesAbout.OnApplyChanges: HRESULT;
begin
  Result := NOERROR;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Initialization
  Notes   :
 ------------------------------------------------------------------------------}
initialization
  TBCClassFactory.CreatePropertyPage(TfrmPropertiesAbout, CLSID_MajorPushSourcePropertyPageAbout);
end.

