{******************************************************************************}
{ FileName............: MajorDvbSetupRemote                                    }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 0.01                                                   }
{------------------------------------------------------------------------------}
{  DirectShow options                                                          }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ Version   Date   Comment                                                     }
{  0.01   20041115 - Initial release                                           }
{******************************************************************************}
unit MajorDvbSetupRemote;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Grids;

type
  TfrmSetupRemote = class(TForm)
    btnOK: TButton;
    btnDiscard: TButton;
    Shape1: TShape;
    sgRemoteSettings: TStringGrid;
    btnDefaults: TButton;
    btnUp: TButton;
    btnDown: TButton;
    btnRemove: TButton;
    btnAdd: TButton;
    grpCommand: TGroupBox;
    Label1: TLabel;
    cmbDevice: TComboBox;
    Label4: TLabel;
    cmbApplication: TComboBox;
    btnAddItem: TButton;
    Shape3: TShape;
    Shape4: TShape;
    cmbCommand: TComboBox;
    Label3: TLabel;
    Memo1: TMemo;
    btnRevert: TButton;
    procedure SetSetting(Index: Integer; Value: ShortString);
    function  GetSetting(Index: Integer): ShortString;
    procedure btnOKClick(Sender: TObject);
    procedure btnDiscardClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure btnUpClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure btnDefaultsClick(Sender: TObject);
    procedure btnAddItemClick(Sender: TObject);
    procedure btnRevertClick(Sender: TObject);
  private
    { Private declarations }
    FOrgSettings       : array[0..99] of ShortString;
    FOrgRowCount       : Integer;
    FExitCallback      : TNotifyEvent;
    FAccepted          : Boolean;
    procedure Revert;
    function  GetSettingChanged    : Boolean;
  public
    { Public declarations }
    property Setting[Index: Integer]: ShortString  read GetSetting         write SetSetting;
    property ExitNotify             : TNotifyEvent read FExitCallback      write FExitCallback;
    property SettingChanged         : Boolean      read GetSettingChanged;
    property Accepted               : Boolean      read FAccepted;
  end;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>  True if a setting has changed

  Descript: Get flag if a setting has changed
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmSetupRemote.GetSettingChanged: Boolean;
var
  Loop      : Integer;
  NewSetting: ShortString;
begin
  Result := False;
  Result := Result or (FOrgRowCount <> sgRemoteSettings.RowCount);
  if not Result and (sgRemoteSettings.RowCount > 0) then
    for Loop := 1 to sgRemoteSettings.RowCount-1 do
    begin
      NewSetting := Trim(sgRemoteSettings.Cells[1, Loop]) + Trim(sgRemoteSettings.Cells[2, Loop]) + '=' +
                    Trim(sgRemoteSettings.Cells[3, Loop]);
      if Trim(sgRemoteSettings.Cells[1, Loop]) <> '' then
        if NewSetting <> FOrgSettings[Loop-1] then
        begin
          Result := True;
          Exit;
        end;
    end;
end;


procedure TfrmSetupRemote.SetSetting(Index: Integer; Value: ShortString);
begin
  if (Index < Low(FOrgSettings)) or (Index > High(FOrgSettings)) then
    Exit;
  if Length(Value) < 9 then
    Exit;
  if Pos('Key', Value) <> 1 then
    Exit;
  if Pos('=', Value) <> 8 then
    Exit;
  if Index >= (sgRemoteSettings.RowCount - 2) then
  begin
    sgRemoteSettings.RowCount := Index + 3;
    FOrgRowCount := sgRemoteSettings.RowCount;
  end;
  Delete(Value, 1, 3);
  sgRemoteSettings.Cells[1, Index + 1] := Copy(Value, 1, 2);
  sgRemoteSettings.Cells[2, Index + 1] := Copy(Value, 3, 2);
  sgRemoteSettings.Cells[3, Index + 1] := Copy(Value, 6, 255);
  sgRemoteSettings.Cells[0, Index + 2] := format('%2.2d', [Index + 2]);
  FOrgSettings[Index] := Trim(sgRemoteSettings.Cells[1, Index + 1]) + Trim(sgRemoteSettings.Cells[2, Index + 1]) + '=' +
                         Trim(sgRemoteSettings.Cells[3, Index + 1]);
end;


function TfrmSetupRemote.GetSetting(Index: Integer): ShortString;
begin
  Result := '';
  if (Index < Low(FOrgSettings)) or (Index > High(FOrgSettings)) then
    Exit;
  if (Index >= (sgRemoteSettings.RowCount - 1)) then
    Result := ''
  else
    if Trim(sgRemoteSettings.Cells[1, Index + 1]) <> '' then
      Result := 'Key' + sgRemoteSettings.Cells[1, Index + 1] + sgRemoteSettings.Cells[2, Index + 1] + '=' +
                        sgRemoteSettings.Cells[3, Index + 1];
end;


procedure TfrmSetupRemote.btnDefaultsClick(Sender: TObject);
begin
  sgRemoteSettings.RowCount := 22;
  sgRemoteSettings.Cells[0, 1] := '01';
  sgRemoteSettings.Cells[1, 1] := '00';
  sgRemoteSettings.Cells[2, 1] := '15';
  sgRemoteSettings.Cells[3, 1] := 'undefined -- tv';
  sgRemoteSettings.Cells[0, 2] := '02';
  sgRemoteSettings.Cells[1, 2] := '00';
  sgRemoteSettings.Cells[2, 2] := '32';
  sgRemoteSettings.Cells[3, 2] := 'up';
  sgRemoteSettings.Cells[0, 3] := '03';
  sgRemoteSettings.Cells[1, 3] := '00';
  sgRemoteSettings.Cells[2, 3] := '12';
  sgRemoteSettings.Cells[3, 3] := 'undefined -- radio';
  sgRemoteSettings.Cells[0, 4] := '04';
  sgRemoteSettings.Cells[1, 4] := '00';
  sgRemoteSettings.Cells[2, 4] := '17';
  sgRemoteSettings.Cells[3, 4] := 'left';
  sgRemoteSettings.Cells[0, 5] := '05';
  sgRemoteSettings.Cells[1, 5] := '00';
  sgRemoteSettings.Cells[2, 5] := '46';
  sgRemoteSettings.Cells[3, 5] := 'fullscreen';
  sgRemoteSettings.Cells[0, 6] := '06';
  sgRemoteSettings.Cells[1, 6] := '00';
  sgRemoteSettings.Cells[2, 6] := '16';
  sgRemoteSettings.Cells[3, 6] := 'right';
  sgRemoteSettings.Cells[0, 7] := '07';
  sgRemoteSettings.Cells[1, 7] := '00';
  sgRemoteSettings.Cells[2, 7] := '13';
  sgRemoteSettings.Cells[3, 7] := 'mute';
  sgRemoteSettings.Cells[0, 8] := '08';
  sgRemoteSettings.Cells[1, 8] := '00';
  sgRemoteSettings.Cells[2, 8] := '33';
  sgRemoteSettings.Cells[3, 8] := 'down';
  sgRemoteSettings.Cells[0, 9] := '09';
  sgRemoteSettings.Cells[1, 9] := '00';
  sgRemoteSettings.Cells[2, 9] := '34';
  sgRemoteSettings.Cells[3, 9] := 'undefined -- source';
  sgRemoteSettings.Cells[0, 10] := '10';
  sgRemoteSettings.Cells[1, 10] := '00';
  sgRemoteSettings.Cells[2, 10] := '01';
  sgRemoteSettings.Cells[3, 10] := '1';
  sgRemoteSettings.Cells[0, 11] := '11';
  sgRemoteSettings.Cells[1, 11] := '00';
  sgRemoteSettings.Cells[2, 11] := '02';
  sgRemoteSettings.Cells[3, 11] := '2';
  sgRemoteSettings.Cells[0, 12] := '12';
  sgRemoteSettings.Cells[1, 12] := '00';
  sgRemoteSettings.Cells[2, 12] := '03';
  sgRemoteSettings.Cells[3, 12] := '3';
  sgRemoteSettings.Cells[0, 13] := '13';
  sgRemoteSettings.Cells[1, 13] := '00';
  sgRemoteSettings.Cells[2, 13] := '04';
  sgRemoteSettings.Cells[3, 13] := '4';
  sgRemoteSettings.Cells[0, 14] := '14';
  sgRemoteSettings.Cells[1, 14] := '00';
  sgRemoteSettings.Cells[2, 14] := '05';
  sgRemoteSettings.Cells[3, 14] := '5';
  sgRemoteSettings.Cells[0, 15] := '15';
  sgRemoteSettings.Cells[1, 15] := '00';
  sgRemoteSettings.Cells[2, 15] := '06';
  sgRemoteSettings.Cells[3, 15] := '6';
  sgRemoteSettings.Cells[0, 16] := '16';
  sgRemoteSettings.Cells[1, 16] := '00';
  sgRemoteSettings.Cells[2, 16] := '07';
  sgRemoteSettings.Cells[3, 16] := '7';
  sgRemoteSettings.Cells[0, 17] := '17';
  sgRemoteSettings.Cells[1, 17] := '00';
  sgRemoteSettings.Cells[2, 17] := '08';
  sgRemoteSettings.Cells[3, 17] := '8';
  sgRemoteSettings.Cells[0, 18] := '18';
  sgRemoteSettings.Cells[1, 18] := '00';
  sgRemoteSettings.Cells[2, 18] := '09';
  sgRemoteSettings.Cells[3, 18] := '9';
  sgRemoteSettings.Cells[0, 19] := '19';
  sgRemoteSettings.Cells[1, 19] := '00';
  sgRemoteSettings.Cells[2, 19] := '30';
  sgRemoteSettings.Cells[3, 19] := 'undefined -- reserved';
  sgRemoteSettings.Cells[0, 20] := '20';
  sgRemoteSettings.Cells[1, 20] := '00';
  sgRemoteSettings.Cells[2, 20] := '00';
  sgRemoteSettings.Cells[3, 20] := '0';
  sgRemoteSettings.Cells[0, 21] := '21';
  sgRemoteSettings.Cells[1, 21] := '00';
  sgRemoteSettings.Cells[2, 21] := '38';
  sgRemoteSettings.Cells[3, 21] := 'undefined -- minimize';
  btnAddClick(Sender);
end;


procedure TfrmSetupRemote.Revert;
var
  High1   : Integer;
  Loop    : Integer;
begin
  // Find highest entry
  High1 := High(FOrgSettings);
  while (High1 >= Low(FOrgSettings)) and (FOrgSettings[High1] = '') do
    Dec(High1);
  sgRemoteSettings.RowCount := High1 + 3;
  for Loop := 1 to sgRemoteSettings.RowCount-1 do
  begin
    sgRemoteSettings.Cells[0, Loop] := format('%2.2d', [Loop]);
    sgRemoteSettings.Cells[1, Loop] := Copy(FOrgSettings[Loop-1], 1, 2);
    sgRemoteSettings.Cells[2, Loop] := Copy(FOrgSettings[Loop-1], 3, 2);
    sgRemoteSettings.Cells[3, Loop] := Copy(FOrgSettings[Loop-1], 6, 255);
  end;
end;


procedure TfrmSetupRemote.btnAddClick(Sender: TObject);
begin
  sgRemoteSettings.RowCount := sgRemoteSettings.RowCount + 1;
  sgRemoteSettings.Cells[0, sgRemoteSettings.RowCount - 1] := format('%2.2d', [sgRemoteSettings.RowCount - 1]);
  sgRemoteSettings.Cells[1, sgRemoteSettings.RowCount - 1] := '';
  sgRemoteSettings.Cells[2, sgRemoteSettings.RowCount - 1] := '';
  sgRemoteSettings.Cells[3, sgRemoteSettings.RowCount - 1] := '';
end;


procedure TfrmSetupRemote.btnAddItemClick(Sender: TObject);
begin
  sgRemoteSettings.Cells[1, sgRemoteSettings.Row] := format('%2.2d', [cmbDevice.ItemIndex]);
  sgRemoteSettings.Cells[2, sgRemoteSettings.Row] := format('%2.2d', [cmbCommand.ItemIndex]);
  sgRemoteSettings.Cells[3, sgRemoteSettings.Row] := cmbApplication.Text;
end;


procedure TfrmSetupRemote.btnRemoveClick(Sender: TObject);
var
  Loop: Integer;
begin
  if sgRemoteSettings.RowCount <= 2 then
    Exit;
  if sgRemoteSettings.Row >= (sgRemoteSettings.RowCount-1) then
    Exit;
  for Loop := sgRemoteSettings.Row+1 to sgRemoteSettings.RowCount-1 do
  begin
    sgRemoteSettings.Cells[1, Loop-1] := sgRemoteSettings.Cells[1, Loop];
    sgRemoteSettings.Cells[2, Loop-1] := sgRemoteSettings.Cells[2, Loop];
    sgRemoteSettings.Cells[3, Loop-1] := sgRemoteSettings.Cells[3, Loop];
  end;
  sgRemoteSettings.RowCount := sgRemoteSettings.RowCount - 1;
  sgRemoteSettings.Cells[1, sgRemoteSettings.RowCount - 1] := '';
  sgRemoteSettings.Cells[2, sgRemoteSettings.RowCount - 1] := '';
  sgRemoteSettings.Cells[3, sgRemoteSettings.RowCount - 1] := '';
  sgRemoteSettings.Cells[0, sgRemoteSettings.RowCount - 1] := format('%2.2d', [sgRemoteSettings.RowCount - 1]);
  if sgRemoteSettings.Row > 1 then
    sgRemoteSettings.Row := sgRemoteSettings.Row - 1;
end;


procedure TfrmSetupRemote.btnUpClick(Sender: TObject);
var
  TempString: string;
begin
  if sgRemoteSettings.Row < 2 then
    Exit;
  if sgRemoteSettings.Row >= (sgRemoteSettings.RowCount-1) then
    Exit;
  TempString := sgRemoteSettings.Cells[1, sgRemoteSettings.Row-1];
  sgRemoteSettings.Cells[1, sgRemoteSettings.Row-1] := sgRemoteSettings.Cells[1, sgRemoteSettings.Row];
  sgRemoteSettings.Cells[1, sgRemoteSettings.Row]   := TempString;
  TempString := sgRemoteSettings.Cells[2, sgRemoteSettings.Row-1];
  sgRemoteSettings.Cells[2, sgRemoteSettings.Row-1] := sgRemoteSettings.Cells[2, sgRemoteSettings.Row];
  sgRemoteSettings.Cells[2, sgRemoteSettings.Row]   := TempString;
  TempString := sgRemoteSettings.Cells[3, sgRemoteSettings.Row-1];
  sgRemoteSettings.Cells[3, sgRemoteSettings.Row-1] := sgRemoteSettings.Cells[3, sgRemoteSettings.Row];
  sgRemoteSettings.Cells[3, sgRemoteSettings.Row]   := TempString;
  sgRemoteSettings.Row := sgRemoteSettings.Row - 1;
end;


procedure TfrmSetupRemote.btnDownClick(Sender: TObject);
var
  TempString: string;
begin
  if sgRemoteSettings.Row >= (sgRemoteSettings.RowCount-2) then
    Exit;
  TempString := sgRemoteSettings.Cells[1, sgRemoteSettings.Row+1];
  sgRemoteSettings.Cells[1, sgRemoteSettings.Row+1] := sgRemoteSettings.Cells[1, sgRemoteSettings.Row];
  sgRemoteSettings.Cells[1, sgRemoteSettings.Row]   := TempString;
  TempString := sgRemoteSettings.Cells[2, sgRemoteSettings.Row+1];
  sgRemoteSettings.Cells[2, sgRemoteSettings.Row+1] := sgRemoteSettings.Cells[2, sgRemoteSettings.Row];
  sgRemoteSettings.Cells[2, sgRemoteSettings.Row]   := TempString;
  TempString := sgRemoteSettings.Cells[3, sgRemoteSettings.Row+1];
  sgRemoteSettings.Cells[3, sgRemoteSettings.Row+1] := sgRemoteSettings.Cells[3, sgRemoteSettings.Row];
  sgRemoteSettings.Cells[3, sgRemoteSettings.Row]   := TempString;
  sgRemoteSettings.Row := sgRemoteSettings.Row + 1;
end;


procedure TfrmSetupRemote.btnRevertClick(Sender: TObject);
begin
  Revert;
end;


procedure TfrmSetupRemote.btnOKClick(Sender: TObject);
begin
  FAccepted := True;
  Hide;
  Refresh;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupRemote.btnDiscardClick(Sender: TObject);
begin
  Hide;
  Refresh;
  Revert;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupRemote.FormCreate(Sender: TObject);
var
  Loop: Integer;
begin
  @FExitCallback              := nil;
  FAccepted                   := False;
  for Loop := Low(FOrgSettings) to High(FOrgSettings) do
    FOrgSettings[Loop] := '';
  FOrgRowCount                  := 0;
  sgRemoteSettings.ColWidths[0] := 20;
  sgRemoteSettings.ColWidths[1] := 30;
  sgRemoteSettings.ColWidths[2] := 30;
  sgRemoteSettings.ColWidths[3] := 345;
  sgRemoteSettings.Cells[1, 0] := 'Dev';
  sgRemoteSettings.Cells[2, 0] := 'Com';
  sgRemoteSettings.Cells[3, 0] := 'Application command';
  sgRemoteSettings.Cells[0, 1] := format('%2.2d', [1]);
  cmbDevice.ItemIndex  := 0;
  cmbCommand.ItemIndex := 0;
end;


procedure TfrmSetupRemote.FormDestroy(Sender: TObject);
begin
  btnDiscardClick(nil);
  @FExitCallback := nil;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Initialize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Initialize;
begin
  //
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Finalize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Finalize;
begin
  //
end;


initialization
  Initialize;


finalization
  Finalize;

end.

