{******************************************************************************}
{ FileName............: MajorDvbSetupDiSEqC                                    }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 0.03                                                   }
{------------------------------------------------------------------------------}
{  DiSEqC/LNB options                                                          }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ Version   Date   Comment                                                     }
{  0.01   20041113 - Initial release                                           }
{  0.02   20051016 - Added 4 satellite configuration                           }
{  0.03   20051120 - Added DVB-C, DVB-T configuration                          }
{******************************************************************************}
unit MajorDvbSetupDiSEqC;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Grids;

type
  TfrmSetupDiSEqC = class(TForm)
    btnOK: TButton;
    btnDiscard: TButton;
    Shape1: TShape;
    Shape2: TShape;
    sgDiSEqCSettings: TStringGrid;
    btnMiniDiSEqC: TButton;
    btnUp: TButton;
    btnDown: TButton;
    btnRemove: TButton;
    btnAdd: TButton;
    cmbDelay: TComboBox;
    Label5: TLabel;
    grpDiSEqC: TGroupBox;
    Label3: TLabel;
    cmbFraming: TComboBox;
    btnAddDiSEqC: TButton;
    cmbAddress: TComboBox;
    Label6: TLabel;
    cmbCommand: TComboBox;
    Label7: TLabel;
    btnAddDelay: TButton;
    rgTone: TRadioGroup;
    btnAddTone: TButton;
    rgVoltage: TRadioGroup;
    btnAddVoltage: TButton;
    rgBurst: TRadioGroup;
    btnAddBurst: TButton;
    grpLNB: TGroupBox;
    Label1: TLabel;
    cmbSatellite: TComboBox;
    Label2: TLabel;
    cmbSlof: TComboBox;
    rgPolarization: TRadioGroup;
    Label4: TLabel;
    cmbLof: TComboBox;
    btnAddLnb: TButton;
    btnFullDiSEqC: TButton;
    Shape3: TShape;
    Shape4: TShape;
    btnOptimizedDiSEqC: TButton;
    btnRevert: TButton;
    btnFourDiSEqC: TButton;
    btnDVBCT: TButton;
    procedure SetSetting(Index: Integer; Value: ShortString);
    function  GetSetting(Index: Integer): ShortString;
    procedure btnOKClick(Sender: TObject);
    procedure btnDiscardClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure btnUpClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure btnMiniDiSEqCClick(Sender: TObject);
    procedure btnAddLnbClick(Sender: TObject);
    procedure btnAddToneClick(Sender: TObject);
    procedure btnAddVoltageClick(Sender: TObject);
    procedure btnAddBurstClick(Sender: TObject);
    procedure btnAddDelayClick(Sender: TObject);
    procedure btnAddDiSEqCClick(Sender: TObject);
    procedure btnFullDiSEqCClick(Sender: TObject);
    procedure btnOptimizedDiSEqCClick(Sender: TObject);
    procedure btnRevertClick(Sender: TObject);
    procedure btnFourDiSEqCClick(Sender: TObject);
    procedure btnDVBCTClick(Sender: TObject);
  private
    { Private declarations }
    FOrgSettings       : array[0..99] of ShortString;
    FOrgRowCount       : Integer;
    FExitCallback      : TNotifyEvent;
    FAccepted          : Boolean;
    procedure Revert;
    function  GetSettingChanged    : Boolean;
  public
    { Public declarations }
    property Setting[Index: Integer]: ShortString  read GetSetting         write SetSetting;
    property ExitNotify             : TNotifyEvent read FExitCallback      write FExitCallback;
    property SettingChanged         : Boolean      read GetSettingChanged;
    property Accepted               : Boolean      read FAccepted;
  end;

implementation

{$R *.DFM}
uses
  Saa7146aI2c;                         // Support routines

{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>  True if a setting has changed

  Descript: Get flag if a setting has changed
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmSetupDiSEqC.GetSettingChanged: Boolean;
var
  Loop      : Integer;
  NewSetting: ShortString;
begin
  Result := False;
  Result := Result or (FOrgRowCount <> sgDiSEqCSettings.RowCount);
  if not Result and (sgDiSEqCSettings.RowCount > 0) then
    for Loop := 1 to sgDiSEqCSettings.RowCount-1 do
    begin
      NewSetting := Trim(sgDiSEqCSettings.Cells[1, Loop]) + ' ' + Trim(sgDiSEqCSettings.Cells[2, Loop]) + ' ' +
                    Trim(sgDiSEqCSettings.Cells[3, Loop]) + ' ' + Trim(sgDiSEqCSettings.Cells[4, Loop]) + ' ' +
                    Trim(sgDiSEqCSettings.Cells[5, Loop]);
      if Trim(sgDiSEqCSettings.Cells[1, Loop]) <> '' then
        if NewSetting <> FOrgSettings[Loop-1] then
        begin
          Result := True;
          Exit;
        end;
    end;
end;


procedure TfrmSetupDiSEqC.SetSetting(Index: Integer; Value: ShortString);
var
  Sat     : ShortString;
  SLof    : Integer;
  Polarity: Char;
  Lof     : Integer;
  DiSEqC  : ShortString;
begin
  if (Index < Low(FOrgSettings)) or (Index > High(FOrgSettings)) then
    Exit;
  if Index >= (sgDiSEqCSettings.RowCount - 2) then
  begin
    sgDiSEqCSettings.RowCount := Index + 3;
    FOrgRowCount := sgDiSEqCSettings.RowCount;
  end;
  ExtractFromDiSEqCSetting(Value, Sat, Slof, Polarity, Lof, DiSEqC);
  sgDiSEqCSettings.Cells[1, Index + 1] := Sat;
  sgDiSEqCSettings.Cells[2, Index + 1] := format('%5.5d', [SLof]);
  sgDiSEqCSettings.Cells[3, Index + 1] := Polarity;
  sgDiSEqCSettings.Cells[4, Index + 1] := format('%5.5d', [Lof]);
  sgDiSEqCSettings.Cells[5, Index + 1] := DiSEqC + ' ';
  sgDiSEqCSettings.Cells[0, Index + 2] := format('%2.2d', [Index + 2]);
  FOrgSettings[Index] := Trim(sgDiSEqCSettings.Cells[1, Index + 1]) + ' ' + Trim(sgDiSEqCSettings.Cells[2, Index + 1]) + ' ' +
                         Trim(sgDiSEqCSettings.Cells[3, Index + 1]) + ' ' + Trim(sgDiSEqCSettings.Cells[4, Index + 1]) + ' ' +
                         Trim(sgDiSEqCSettings.Cells[5, Index + 1]);
end;


function TfrmSetupDiSEqC.GetSetting(Index: Integer): ShortString;
begin
  Result := '';
  if (Index < Low(FOrgSettings)) or (Index > High(FOrgSettings)) then
    Exit;
  if (Index >= (sgDiSEqCSettings.RowCount - 1)) then
    Result := ''
  else
    if Trim(sgDiSEqCSettings.Cells[1, Index + 1]) <> '' then
      Result := sgDiSEqCSettings.Cells[1, Index + 1] + ' ' + sgDiSEqCSettings.Cells[2, Index + 1] + ' ' +
                sgDiSEqCSettings.Cells[3, Index + 1] + ' ' + sgDiSEqCSettings.Cells[4, Index + 1] + ' ' +
                Trim(sgDiSEqCSettings.Cells[5, Index + 1]);
end;


procedure TfrmSetupDiSEqC.btnMiniDiSEqCClick(Sender: TObject);
begin
  sgDiSEqCSettings.RowCount := 9;
  sgDiSEqCSettings.Cells[0, 1] := '01';
  sgDiSEqCSettings.Cells[1, 1] := '1';
  sgDiSEqCSettings.Cells[2, 1] := '11700';
  sgDiSEqCSettings.Cells[3, 1] := 'V';
  sgDiSEqCSettings.Cells[4, 1] := '09750';
  sgDiSEqCSettings.Cells[5, 1] := 't v W15 A W15 t ';
  sgDiSEqCSettings.Cells[0, 2] := '02';
  sgDiSEqCSettings.Cells[1, 2] := '1';
  sgDiSEqCSettings.Cells[2, 2] := '99999';
  sgDiSEqCSettings.Cells[3, 2] := 'V';
  sgDiSEqCSettings.Cells[4, 2] := '10600';
  sgDiSEqCSettings.Cells[5, 2] := 't v W15 A W15 T ';
  sgDiSEqCSettings.Cells[0, 3] := '03';
  sgDiSEqCSettings.Cells[1, 3] := '1';
  sgDiSEqCSettings.Cells[2, 3] := '11700';
  sgDiSEqCSettings.Cells[3, 3] := 'H';
  sgDiSEqCSettings.Cells[4, 3] := '09750';
  sgDiSEqCSettings.Cells[5, 3] := 't V W15 A W15 t ';
  sgDiSEqCSettings.Cells[0, 4] := '04';
  sgDiSEqCSettings.Cells[1, 4] := '1';
  sgDiSEqCSettings.Cells[2, 4] := '99999';
  sgDiSEqCSettings.Cells[3, 4] := 'H';
  sgDiSEqCSettings.Cells[4, 4] := '10600';
  sgDiSEqCSettings.Cells[5, 4] := 't V W15 A W15 T ';
  sgDiSEqCSettings.Cells[0, 5] := '01';
  sgDiSEqCSettings.Cells[1, 5] := '2';
  sgDiSEqCSettings.Cells[2, 5] := '11700';
  sgDiSEqCSettings.Cells[3, 5] := 'V';
  sgDiSEqCSettings.Cells[4, 5] := '09750';
  sgDiSEqCSettings.Cells[5, 5] := 't v W15 B W15 t ';
  sgDiSEqCSettings.Cells[0, 6] := '02';
  sgDiSEqCSettings.Cells[1, 6] := '2';
  sgDiSEqCSettings.Cells[2, 6] := '99999';
  sgDiSEqCSettings.Cells[3, 6] := 'V';
  sgDiSEqCSettings.Cells[4, 6] := '10600';
  sgDiSEqCSettings.Cells[5, 6] := 't v W15 B W15 T ';
  sgDiSEqCSettings.Cells[0, 7] := '03';
  sgDiSEqCSettings.Cells[1, 7] := '2';
  sgDiSEqCSettings.Cells[2, 7] := '11700';
  sgDiSEqCSettings.Cells[3, 7] := 'H';
  sgDiSEqCSettings.Cells[4, 7] := '09750';
  sgDiSEqCSettings.Cells[5, 7] := 't V W15 B W15 t ';
  sgDiSEqCSettings.Cells[0, 8] := '04';
  sgDiSEqCSettings.Cells[1, 8] := '2';
  sgDiSEqCSettings.Cells[2, 8] := '99999';
  sgDiSEqCSettings.Cells[3, 8] := 'H';
  sgDiSEqCSettings.Cells[4, 8] := '10600';
  sgDiSEqCSettings.Cells[5, 8] := 't V W15 B W15 T ';
  btnAddClick(Sender);
end;


procedure TfrmSetupDiSEqC.btnFullDiSEqCClick(Sender: TObject);
begin
  sgDiSEqCSettings.RowCount := 9;
  sgDiSEqCSettings.Cells[0, 1] := '01';
  sgDiSEqCSettings.Cells[1, 1] := '1';
  sgDiSEqCSettings.Cells[2, 1] := '11700';
  sgDiSEqCSettings.Cells[3, 1] := 'V';
  sgDiSEqCSettings.Cells[4, 1] := '09750';
  sgDiSEqCSettings.Cells[5, 1] := 't v W15 [E0 10 38 F0] W15 A W15 t ';
  sgDiSEqCSettings.Cells[0, 2] := '02';
  sgDiSEqCSettings.Cells[1, 2] := '1';
  sgDiSEqCSettings.Cells[2, 2] := '99999';
  sgDiSEqCSettings.Cells[3, 2] := 'V';
  sgDiSEqCSettings.Cells[4, 2] := '10600';
  sgDiSEqCSettings.Cells[5, 2] := 't v W15 [E0 10 38 F1] W15 A W15 T ';
  sgDiSEqCSettings.Cells[0, 3] := '03';
  sgDiSEqCSettings.Cells[1, 3] := '1';
  sgDiSEqCSettings.Cells[2, 3] := '11700';
  sgDiSEqCSettings.Cells[3, 3] := 'H';
  sgDiSEqCSettings.Cells[4, 3] := '09750';
  sgDiSEqCSettings.Cells[5, 3] := 't V W15 [E0 10 38 F2] W15 A W15 t ';
  sgDiSEqCSettings.Cells[0, 4] := '04';
  sgDiSEqCSettings.Cells[1, 4] := '1';
  sgDiSEqCSettings.Cells[2, 4] := '99999';
  sgDiSEqCSettings.Cells[3, 4] := 'H';
  sgDiSEqCSettings.Cells[4, 4] := '10600';
  sgDiSEqCSettings.Cells[5, 4] := 't V W15 [E0 10 38 F3] W15 A W15 T ';
  sgDiSEqCSettings.Cells[0, 5] := '01';
  sgDiSEqCSettings.Cells[1, 5] := '2';
  sgDiSEqCSettings.Cells[2, 5] := '11700';
  sgDiSEqCSettings.Cells[3, 5] := 'V';
  sgDiSEqCSettings.Cells[4, 5] := '09750';
  sgDiSEqCSettings.Cells[5, 5] := 't v W15 [E0 10 38 F4] W15 B W15 t ';
  sgDiSEqCSettings.Cells[0, 6] := '02';
  sgDiSEqCSettings.Cells[1, 6] := '2';
  sgDiSEqCSettings.Cells[2, 6] := '99999';
  sgDiSEqCSettings.Cells[3, 6] := 'V';
  sgDiSEqCSettings.Cells[4, 6] := '10600';
  sgDiSEqCSettings.Cells[5, 6] := 't v W15 [E0 10 38 F5] W15 B W15 T ';
  sgDiSEqCSettings.Cells[0, 7] := '03';
  sgDiSEqCSettings.Cells[1, 7] := '2';
  sgDiSEqCSettings.Cells[2, 7] := '11700';
  sgDiSEqCSettings.Cells[3, 7] := 'H';
  sgDiSEqCSettings.Cells[4, 7] := '09750';
  sgDiSEqCSettings.Cells[5, 7] := 't V W15 [E0 10 38 F6] W15 B W15 t ';
  sgDiSEqCSettings.Cells[0, 8] := '04';
  sgDiSEqCSettings.Cells[1, 8] := '2';
  sgDiSEqCSettings.Cells[2, 8] := '99999';
  sgDiSEqCSettings.Cells[3, 8] := 'H';
  sgDiSEqCSettings.Cells[4, 8] := '10600';
  sgDiSEqCSettings.Cells[5, 8] := 't V W15 [E0 10 38 F7] W15 B W15 T ';
  btnAddClick(Sender);
end;


procedure TfrmSetupDiSEqC.btnOptimizedDiSEqCClick(Sender: TObject);
begin
  sgDiSEqCSettings.RowCount := 9;
  sgDiSEqCSettings.Cells[0, 1] := '01';
  sgDiSEqCSettings.Cells[1, 1] := '1';
  sgDiSEqCSettings.Cells[2, 1] := '11700';
  sgDiSEqCSettings.Cells[3, 1] := 'V';
  sgDiSEqCSettings.Cells[4, 1] := '09750';
  sgDiSEqCSettings.Cells[5, 1] := '[E0 10 38 F0]';
  sgDiSEqCSettings.Cells[0, 2] := '02';
  sgDiSEqCSettings.Cells[1, 2] := '1';
  sgDiSEqCSettings.Cells[2, 2] := '99999';
  sgDiSEqCSettings.Cells[3, 2] := 'V';
  sgDiSEqCSettings.Cells[4, 2] := '10600';
  sgDiSEqCSettings.Cells[5, 2] := '[E0 10 38 F1]';
  sgDiSEqCSettings.Cells[0, 3] := '03';
  sgDiSEqCSettings.Cells[1, 3] := '1';
  sgDiSEqCSettings.Cells[2, 3] := '11700';
  sgDiSEqCSettings.Cells[3, 3] := 'H';
  sgDiSEqCSettings.Cells[4, 3] := '09750';
  sgDiSEqCSettings.Cells[5, 3] := '[E0 10 38 F2]';
  sgDiSEqCSettings.Cells[0, 4] := '04';
  sgDiSEqCSettings.Cells[1, 4] := '1';
  sgDiSEqCSettings.Cells[2, 4] := '99999';
  sgDiSEqCSettings.Cells[3, 4] := 'H';
  sgDiSEqCSettings.Cells[4, 4] := '10600';
  sgDiSEqCSettings.Cells[5, 4] := '[E0 10 38 F3]';
  sgDiSEqCSettings.Cells[0, 5] := '01';
  sgDiSEqCSettings.Cells[1, 5] := '2';
  sgDiSEqCSettings.Cells[2, 5] := '11700';
  sgDiSEqCSettings.Cells[3, 5] := 'V';
  sgDiSEqCSettings.Cells[4, 5] := '09750';
  sgDiSEqCSettings.Cells[5, 5] := '[E0 10 38 F4]';
  sgDiSEqCSettings.Cells[0, 6] := '02';
  sgDiSEqCSettings.Cells[1, 6] := '2';
  sgDiSEqCSettings.Cells[2, 6] := '99999';
  sgDiSEqCSettings.Cells[3, 6] := 'V';
  sgDiSEqCSettings.Cells[4, 6] := '10600';
  sgDiSEqCSettings.Cells[5, 6] := '[E0 10 38 F5]';
  sgDiSEqCSettings.Cells[0, 7] := '03';
  sgDiSEqCSettings.Cells[1, 7] := '2';
  sgDiSEqCSettings.Cells[2, 7] := '11700';
  sgDiSEqCSettings.Cells[3, 7] := 'H';
  sgDiSEqCSettings.Cells[4, 7] := '09750';
  sgDiSEqCSettings.Cells[5, 7] := '[E0 10 38 F6]';
  sgDiSEqCSettings.Cells[0, 8] := '04';
  sgDiSEqCSettings.Cells[1, 8] := '2';
  sgDiSEqCSettings.Cells[2, 8] := '99999';
  sgDiSEqCSettings.Cells[3, 8] := 'H';
  sgDiSEqCSettings.Cells[4, 8] := '10600';
  sgDiSEqCSettings.Cells[5, 8] := '[E0 10 38 F7]';
  btnAddClick(Sender);
end;


procedure TfrmSetupDiSEqC.btnFourDiSEqCClick(Sender: TObject);
begin
  sgDiSEqCSettings.RowCount := 17;
  sgDiSEqCSettings.Cells[0, 1] := '01';
  sgDiSEqCSettings.Cells[1, 1] := '1';
  sgDiSEqCSettings.Cells[2, 1] := '11700';
  sgDiSEqCSettings.Cells[3, 1] := 'V';
  sgDiSEqCSettings.Cells[4, 1] := '09750';
  sgDiSEqCSettings.Cells[5, 1] := 't v W15 [E0 10 38 F0] W15 t ';
  sgDiSEqCSettings.Cells[0, 2] := '02';
  sgDiSEqCSettings.Cells[1, 2] := '1';
  sgDiSEqCSettings.Cells[2, 2] := '99999';
  sgDiSEqCSettings.Cells[3, 2] := 'V';
  sgDiSEqCSettings.Cells[4, 2] := '10600';
  sgDiSEqCSettings.Cells[5, 2] := 't v W15 [E0 10 38 F1] W15 T ';
  sgDiSEqCSettings.Cells[0, 3] := '03';
  sgDiSEqCSettings.Cells[1, 3] := '1';
  sgDiSEqCSettings.Cells[2, 3] := '11700';
  sgDiSEqCSettings.Cells[3, 3] := 'H';
  sgDiSEqCSettings.Cells[4, 3] := '09750';
  sgDiSEqCSettings.Cells[5, 3] := 't V W15 [E0 10 38 F2] W15 t ';
  sgDiSEqCSettings.Cells[0, 4] := '04';
  sgDiSEqCSettings.Cells[1, 4] := '1';
  sgDiSEqCSettings.Cells[2, 4] := '99999';
  sgDiSEqCSettings.Cells[3, 4] := 'H';
  sgDiSEqCSettings.Cells[4, 4] := '10600';
  sgDiSEqCSettings.Cells[5, 4] := 't V W15 [E0 10 38 F3] W15 T ';
  sgDiSEqCSettings.Cells[0, 5] := '01';
  sgDiSEqCSettings.Cells[1, 5] := '2';
  sgDiSEqCSettings.Cells[2, 5] := '11700';
  sgDiSEqCSettings.Cells[3, 5] := 'V';
  sgDiSEqCSettings.Cells[4, 5] := '09750';
  sgDiSEqCSettings.Cells[5, 5] := 't v W15 [E0 10 38 F4] W15 t ';
  sgDiSEqCSettings.Cells[0, 6] := '02';
  sgDiSEqCSettings.Cells[1, 6] := '2';
  sgDiSEqCSettings.Cells[2, 6] := '99999';
  sgDiSEqCSettings.Cells[3, 6] := 'V';
  sgDiSEqCSettings.Cells[4, 6] := '10600';
  sgDiSEqCSettings.Cells[5, 6] := 't v W15 [E0 10 38 F5] W15 T ';
  sgDiSEqCSettings.Cells[0, 7] := '03';
  sgDiSEqCSettings.Cells[1, 7] := '2';
  sgDiSEqCSettings.Cells[2, 7] := '11700';
  sgDiSEqCSettings.Cells[3, 7] := 'H';
  sgDiSEqCSettings.Cells[4, 7] := '09750';
  sgDiSEqCSettings.Cells[5, 7] := 't V W15 [E0 10 38 F6] W15 t ';
  sgDiSEqCSettings.Cells[0, 8] := '04';
  sgDiSEqCSettings.Cells[1, 8] := '2';
  sgDiSEqCSettings.Cells[2, 8] := '99999';
  sgDiSEqCSettings.Cells[3, 8] := 'H';
  sgDiSEqCSettings.Cells[4, 8] := '10600';
  sgDiSEqCSettings.Cells[5, 8] := 't V W15 [E0 10 38 F7] W15 T ';
  sgDiSEqCSettings.Cells[0, 9] := '01';
  sgDiSEqCSettings.Cells[1, 9] := '3';
  sgDiSEqCSettings.Cells[2, 9] := '11700';
  sgDiSEqCSettings.Cells[3, 9] := 'V';
  sgDiSEqCSettings.Cells[4, 9] := '09750';
  sgDiSEqCSettings.Cells[5, 9] := 't v W15 [E0 10 38 F8] W15 t ';
  sgDiSEqCSettings.Cells[0, 10] := '02';
  sgDiSEqCSettings.Cells[1, 10] := '3';
  sgDiSEqCSettings.Cells[2, 10] := '99999';
  sgDiSEqCSettings.Cells[3, 10] := 'V';
  sgDiSEqCSettings.Cells[4, 10] := '10600';
  sgDiSEqCSettings.Cells[5, 10] := 't v W15 [E0 10 38 F9] W15 T ';
  sgDiSEqCSettings.Cells[0, 11] := '03';
  sgDiSEqCSettings.Cells[1, 11] := '3';
  sgDiSEqCSettings.Cells[2, 11] := '11700';
  sgDiSEqCSettings.Cells[3, 11] := 'H';
  sgDiSEqCSettings.Cells[4, 11] := '09750';
  sgDiSEqCSettings.Cells[5, 11] := 't V W15 [E0 10 38 FA] W15 t ';
  sgDiSEqCSettings.Cells[0, 12] := '04';
  sgDiSEqCSettings.Cells[1, 12] := '3';
  sgDiSEqCSettings.Cells[2, 12] := '99999';
  sgDiSEqCSettings.Cells[3, 12] := 'H';
  sgDiSEqCSettings.Cells[4, 12] := '10600';
  sgDiSEqCSettings.Cells[5, 12] := 't V W15 [E0 10 38 FB] W15 T ';
  sgDiSEqCSettings.Cells[0, 13] := '01';
  sgDiSEqCSettings.Cells[1, 13] := '4';
  sgDiSEqCSettings.Cells[2, 13] := '11700';
  sgDiSEqCSettings.Cells[3, 13] := 'V';
  sgDiSEqCSettings.Cells[4, 13] := '09750';
  sgDiSEqCSettings.Cells[5, 13] := 't v W15 [E0 10 38 FC] W15 t ';
  sgDiSEqCSettings.Cells[0, 14] := '02';
  sgDiSEqCSettings.Cells[1, 14] := '4';
  sgDiSEqCSettings.Cells[2, 14] := '99999';
  sgDiSEqCSettings.Cells[3, 14] := 'V';
  sgDiSEqCSettings.Cells[4, 14] := '10600';
  sgDiSEqCSettings.Cells[5, 14] := 't v W15 [E0 10 38 FD] W15 T ';
  sgDiSEqCSettings.Cells[0, 15] := '03';
  sgDiSEqCSettings.Cells[1, 15] := '4';
  sgDiSEqCSettings.Cells[2, 15] := '11700';
  sgDiSEqCSettings.Cells[3, 15] := 'H';
  sgDiSEqCSettings.Cells[4, 15] := '09750';
  sgDiSEqCSettings.Cells[5, 15] := 't V W15 [E0 10 38 FE] W15 t ';
  sgDiSEqCSettings.Cells[0, 16] := '04';
  sgDiSEqCSettings.Cells[1, 16] := '4';
  sgDiSEqCSettings.Cells[2, 16] := '99999';
  sgDiSEqCSettings.Cells[3, 16] := 'H';
  sgDiSEqCSettings.Cells[4, 16] := '10600';
  sgDiSEqCSettings.Cells[5, 16] := 't V W15 [E0 10 38 FF] W15 T ';
  btnAddClick(Sender);
end;


procedure TfrmSetupDiSEqC.btnDVBCTClick(Sender: TObject);
begin
  sgDiSEqCSettings.RowCount := 3;
  sgDiSEqCSettings.Cells[0, 1] := '01';
  sgDiSEqCSettings.Cells[1, 1] := '1';
  sgDiSEqCSettings.Cells[2, 1] := '99999';
  sgDiSEqCSettings.Cells[3, 1] := 'V';
  sgDiSEqCSettings.Cells[4, 1] := '00000';
  sgDiSEqCSettings.Cells[5, 1] := '';
  sgDiSEqCSettings.Cells[0, 2] := '02';
  sgDiSEqCSettings.Cells[1, 2] := '1';
  sgDiSEqCSettings.Cells[2, 2] := '99999';
  sgDiSEqCSettings.Cells[3, 2] := 'H';
  sgDiSEqCSettings.Cells[4, 2] := '00000';
  sgDiSEqCSettings.Cells[5, 2] := '';
end;


procedure TfrmSetupDiSEqC.Revert;
var
  High1   : Integer;
  Loop    : Integer;
  Sat     : ShortString;
  SLof    : Integer;
  Polarity: Char;
  Lof     : Integer;
  DiSEqC  : ShortString;
begin
  // Find highest entry
  High1 := High(FOrgSettings);
  while (High1 >= Low(FOrgSettings)) and (FOrgSettings[High1] = '') do
    Dec(High1);
  sgDiSEqCSettings.RowCount := High1 + 3;
  for Loop := 1 to sgDiSEqCSettings.RowCount-1 do
  begin
    ExtractFromDiSEqCSetting(FOrgSettings[Loop-1], Sat, Slof, Polarity, Lof, DiSEqC);
    sgDiSEqCSettings.Cells[0, Loop] := format('%2.2d', [Loop]);
    sgDiSEqCSettings.Cells[1, Loop] := Sat;
    sgDiSEqCSettings.Cells[2, Loop] := format('%5.5d', [SLof]);
    sgDiSEqCSettings.Cells[3, Loop] := Polarity;
    sgDiSEqCSettings.Cells[4, Loop] := format('%5.5d', [Lof]);
    sgDiSEqCSettings.Cells[5, Loop] := DiSEqC + ' ';
  end;
end;


procedure TfrmSetupDiSEqC.btnAddClick(Sender: TObject);
begin
  sgDiSEqCSettings.RowCount := sgDiSEqCSettings.RowCount + 1;
  sgDiSEqCSettings.Cells[0, sgDiSEqCSettings.RowCount - 1] := format('%2.2d', [sgDiSEqCSettings.RowCount - 1]);
  sgDiSEqCSettings.Cells[1, sgDiSEqCSettings.RowCount - 1] := '';
  sgDiSEqCSettings.Cells[2, sgDiSEqCSettings.RowCount - 1] := '';
  sgDiSEqCSettings.Cells[3, sgDiSEqCSettings.RowCount - 1] := '';
  sgDiSEqCSettings.Cells[4, sgDiSEqCSettings.RowCount - 1] := '';
  sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.RowCount - 1] := '';
end;


procedure TfrmSetupDiSEqC.btnAddLnbClick(Sender: TObject);
begin
  sgDiSEqCSettings.Cells[1, sgDiSEqCSettings.Row] := format('%d', [cmbSatellite.ItemIndex]);
  sgDiSEqCSettings.Cells[2, sgDiSEqCSettings.Row] := cmbSlof.Text;
  if rgPolarization.ItemIndex = 0 then
    sgDiSEqCSettings.Cells[3, sgDiSEqCSettings.Row] := 'V'
  else
    sgDiSEqCSettings.Cells[3, sgDiSEqCSettings.Row] := 'H';
  sgDiSEqCSettings.Cells[4, sgDiSEqCSettings.Row] := cmbLof.Text;
end;


procedure TfrmSetupDiSEqC.btnAddToneClick(Sender: TObject);
begin
  if rgTone.ItemIndex = 0 then
    sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] + 't '
  else
    sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] + 'T '
end;


procedure TfrmSetupDiSEqC.btnAddVoltageClick(Sender: TObject);
begin
  if rgVoltage.ItemIndex = 0 then
    sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] + 'v '
  else
    sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] + 'V '
end;


procedure TfrmSetupDiSEqC.btnAddBurstClick(Sender: TObject);
begin
  if rgBurst.ItemIndex = 0 then
    sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] + 'A '
  else
    sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] + 'B '
end;


procedure TfrmSetupDiSEqC.btnAddDelayClick(Sender: TObject);
var
  Delay: Integer;
  Error: Integer;
begin
  Val(cmbDelay.Text, Delay, Error);
  if (Error = 0) and (Delay > 0) then
    sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] + format('W%d ', [Delay]);
end;


procedure TfrmSetupDiSEqC.btnAddDiSEqCClick(Sender: TObject);
var
  Value: Integer;
  Error: Integer;
begin
  sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] + '[';
  sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] + Copy(cmbFraming.Text, 1, 2) + ' ';
  sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] + Copy(cmbAddress.Text, 1, 2) + ' ';
  sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] + Copy(cmbCommand.Text, 1, 2) + ' ';
  Val(cmbCommand.Text[Length(cmbCommand.Text)], Value, Error);
  if (Error = 0) and (Value > 3) then
    for Error := 3 to Value-1 do
      sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] + '00 ';
  sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row] + '] ';
end;

procedure TfrmSetupDiSEqC.btnRemoveClick(Sender: TObject);
var
  Loop: Integer;
begin
  if sgDiSEqCSettings.RowCount <= 2 then
    Exit;
  if sgDiSEqCSettings.Row >= (sgDiSEqCSettings.RowCount-1) then
    Exit;
  for Loop := sgDiSEqCSettings.Row+1 to sgDiSEqCSettings.RowCount-1 do
  begin
    sgDiSEqCSettings.Cells[1, Loop-1] := sgDiSEqCSettings.Cells[1, Loop];
    sgDiSEqCSettings.Cells[2, Loop-1] := sgDiSEqCSettings.Cells[2, Loop];
    sgDiSEqCSettings.Cells[3, Loop-1] := sgDiSEqCSettings.Cells[3, Loop];
    sgDiSEqCSettings.Cells[4, Loop-1] := sgDiSEqCSettings.Cells[4, Loop];
    sgDiSEqCSettings.Cells[5, Loop-1] := sgDiSEqCSettings.Cells[5, Loop];
  end;
  sgDiSEqCSettings.RowCount := sgDiSEqCSettings.RowCount - 1;
  sgDiSEqCSettings.Cells[1, sgDiSEqCSettings.RowCount - 1] := '';
  sgDiSEqCSettings.Cells[2, sgDiSEqCSettings.RowCount - 1] := '';
  sgDiSEqCSettings.Cells[3, sgDiSEqCSettings.RowCount - 1] := '';
  sgDiSEqCSettings.Cells[4, sgDiSEqCSettings.RowCount - 1] := '';
  sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.RowCount - 1] := '';
  sgDiSEqCSettings.Cells[0, sgDiSEqCSettings.RowCount - 1] := format('%2.2d', [sgDiSEqCSettings.RowCount - 1]);
  if sgDiSEqCSettings.Row > 1 then
    sgDiSEqCSettings.Row := sgDiSEqCSettings.Row - 1;
end;


procedure TfrmSetupDiSEqC.btnUpClick(Sender: TObject);
var
  TempString: string;
begin
  if sgDiSEqCSettings.Row < 2 then
    Exit;
  if sgDiSEqCSettings.Row >= (sgDiSEqCSettings.RowCount-1) then
    Exit;
  TempString := sgDiSEqCSettings.Cells[1, sgDiSEqCSettings.Row-1];
  sgDiSEqCSettings.Cells[1, sgDiSEqCSettings.Row-1] := sgDiSEqCSettings.Cells[1, sgDiSEqCSettings.Row];
  sgDiSEqCSettings.Cells[1, sgDiSEqCSettings.Row]   := TempString;
  TempString := sgDiSEqCSettings.Cells[2, sgDiSEqCSettings.Row-1];
  sgDiSEqCSettings.Cells[2, sgDiSEqCSettings.Row-1] := sgDiSEqCSettings.Cells[2, sgDiSEqCSettings.Row];
  sgDiSEqCSettings.Cells[2, sgDiSEqCSettings.Row]   := TempString;
  TempString := sgDiSEqCSettings.Cells[3, sgDiSEqCSettings.Row-1];
  sgDiSEqCSettings.Cells[3, sgDiSEqCSettings.Row-1] := sgDiSEqCSettings.Cells[3, sgDiSEqCSettings.Row];
  sgDiSEqCSettings.Cells[3, sgDiSEqCSettings.Row]   := TempString;
  TempString := sgDiSEqCSettings.Cells[4, sgDiSEqCSettings.Row-1];
  sgDiSEqCSettings.Cells[4, sgDiSEqCSettings.Row-1] := sgDiSEqCSettings.Cells[4, sgDiSEqCSettings.Row];
  sgDiSEqCSettings.Cells[4, sgDiSEqCSettings.Row]   := TempString;
  TempString := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row-1];
  sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row-1] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row];
  sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row]   := TempString;
  sgDiSEqCSettings.Row := sgDiSEqCSettings.Row - 1;
end;


procedure TfrmSetupDiSEqC.btnDownClick(Sender: TObject);
var
  TempString: string;
begin
  if sgDiSEqCSettings.Row >= (sgDiSEqCSettings.RowCount-2) then
    Exit;
  TempString := sgDiSEqCSettings.Cells[1, sgDiSEqCSettings.Row+1];
  sgDiSEqCSettings.Cells[1, sgDiSEqCSettings.Row+1] := sgDiSEqCSettings.Cells[1, sgDiSEqCSettings.Row];
  sgDiSEqCSettings.Cells[1, sgDiSEqCSettings.Row]   := TempString;
  TempString := sgDiSEqCSettings.Cells[2, sgDiSEqCSettings.Row+1];
  sgDiSEqCSettings.Cells[2, sgDiSEqCSettings.Row+1] := sgDiSEqCSettings.Cells[2, sgDiSEqCSettings.Row];
  sgDiSEqCSettings.Cells[2, sgDiSEqCSettings.Row]   := TempString;
  TempString := sgDiSEqCSettings.Cells[3, sgDiSEqCSettings.Row+1];
  sgDiSEqCSettings.Cells[3, sgDiSEqCSettings.Row+1] := sgDiSEqCSettings.Cells[3, sgDiSEqCSettings.Row];
  sgDiSEqCSettings.Cells[3, sgDiSEqCSettings.Row]   := TempString;
  TempString := sgDiSEqCSettings.Cells[4, sgDiSEqCSettings.Row+1];
  sgDiSEqCSettings.Cells[4, sgDiSEqCSettings.Row+1] := sgDiSEqCSettings.Cells[4, sgDiSEqCSettings.Row];
  sgDiSEqCSettings.Cells[4, sgDiSEqCSettings.Row]   := TempString;
  TempString := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row+1];
  sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row+1] := sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row];
  sgDiSEqCSettings.Cells[5, sgDiSEqCSettings.Row]   := TempString;
  sgDiSEqCSettings.Row := sgDiSEqCSettings.Row + 1;
end;


procedure TfrmSetupDiSEqC.btnRevertClick(Sender: TObject);
begin
  Revert;
end;


procedure TfrmSetupDiSEqC.btnOKClick(Sender: TObject);
begin
  FAccepted := True;
  Hide;
  Refresh;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupDiSEqC.btnDiscardClick(Sender: TObject);
begin
  Hide;
  Refresh;
  Revert;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupDiSEqC.FormCreate(Sender: TObject);
var
  Loop: Integer;
begin
  @FExitCallback              := nil;
  FAccepted                   := False;
  for Loop := Low(FOrgSettings) to High(FOrgSettings) do
    FOrgSettings[Loop] := '';
  FOrgRowCount                := 0;
  sgDiSEqCSettings.ColWidths[0] := 20;
  sgDiSEqCSettings.ColWidths[1] := 25;
  sgDiSEqCSettings.ColWidths[2] := 45;
  sgDiSEqCSettings.ColWidths[3] := 25;
  sgDiSEqCSettings.ColWidths[4] := 45;
  sgDiSEqCSettings.ColWidths[5] := 280;
  sgDiSEqCSettings.Cells[1, 0] := 'Sat';
  sgDiSEqCSettings.Cells[2, 0] := 'SLOF';
  sgDiSEqCSettings.Cells[3, 0] := 'H/V';
  sgDiSEqCSettings.Cells[4, 0] := 'LOF';
  sgDiSEqCSettings.Cells[5, 0] := 'Commands';
  sgDiSEqCSettings.Cells[0, 1] := format('%2.2d', [1]);
  cmbSatellite.ItemIndex := 1;
  cmbFraming.ItemIndex := 0;
  cmbAddress.ItemIndex := 1;
  cmbCommand.ItemIndex := 26;
end;


procedure TfrmSetupDiSEqC.FormDestroy(Sender: TObject);
begin
  btnDiscardClick(nil);
  @FExitCallback := nil;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Initialize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Initialize;
begin
  //
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Finalize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Finalize;
begin
  //
end;


initialization
  Initialize;


finalization
  Finalize;

end.

