{******************************************************************************}
{ FileName............: MajorDvbSetupCard                                      }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 0.04                                                   }
{------------------------------------------------------------------------------}
{  Card / Hardware options                                                     }
{                                                                              }
{  Copyright (C) 2003-2005  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ Version   Date   Comment                                                     }
{  0.01   20041019 - Initial release                                           }
{  0.02   20050410 - FlexCop added                                             }
{  0.03   20050529 - Real hardware stuff remove (now by script)                }
{  0.04   20050723 - hardware stuff added (script is changed based on it)      }
{                  - 'First available' card selection removed                  }
{******************************************************************************}
unit MajorDvbSetupCard;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TfrmSetupCard = class(TForm)
    btnOK: TButton;
    btnDiscard: TButton;
    Shape2: TShape;
    gbMiscellaneous: TGroupBox;
    Label1: TLabel;
    cmbThreadPriority: TComboBox;
    cmbCardNumber: TComboBox;
    Label2: TLabel;
    Label3: TLabel;
    cmbRpsProgram: TComboBox;
    rgMasterMode: TRadioGroup;
    Label4: TLabel;
    cmbBufferSize: TComboBox;
    Shape4: TShape;
    btnRevert: TButton;
    rgCard: TRadioGroup;
    rgCardFull: TRadioGroup;
    lblCardSuggestion: TLabel;
    procedure btnOKClick(Sender: TObject);
    procedure btnDiscardClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnRevertClick(Sender: TObject);
  private
    { Private declarations }
    FOrgCardNumber        : Integer;
    FOrgCardSelected      : Integer;
    FOrgThreadPriority    : Integer;
    FOrgRpsProgram        : Integer;
    FOrgBufferSize        : Integer;
    FOrgMasterMode        : Integer;
    FExitCallback         : TNotifyEvent;
    FAccepted             : Boolean;
    procedure SetCardSuggestion    (Value: string);
    function  GetCardNumber        : Integer;
    procedure SetCardNumber        (Value: Integer);
    function  GetCard              : string;
    procedure SetCard              (Value: string);
    function  GetCardFull          : string;
    procedure SetCardFull          (Value: string);
    function  GetCardSelected      : Integer;
    procedure SetCardSelected      (Value: Integer);
    function  GetThreadPriority    : Integer;
    procedure SetThreadPriority    (Value: Integer);
    function  GetRpsProgram        : Integer;
    procedure SetRpsProgram        (Value: Integer);
    function  GetBufferSize        : Integer;
    procedure SetBufferSize        (Value: Integer);
    function  GetMasterMode        : Integer;
    procedure SetMasterMode        (Value: Integer);
    function  GetPriorityName      : string;
    procedure SetPriorityName      (Value: string);
    procedure Revert;
    function  GetSettingChanged    : Boolean;
  public
    { Public declarations }
    property CardSuggestion     : string                                  write SetCardSuggestion;
    property CardNumber         : Integer      read GetCardNumber         write SetCardNumber;
    property Card               : string       read GetCard               write SetCard;
    property CardFull           : string       read GetCardFull           write SetCardFull;
    property CardSelected       : Integer      read GetCardSelected       write SetCardSelected;
    property ThreadPriority     : Integer      read GetThreadPriority     write SetThreadPriority;
    property RpsProgram         : Integer      read GetRpsProgram         write SetRpsProgram;
    property BufferSize         : Integer      read GetBufferSize         write SetBufferSize;
    property MasterMode         : Integer      read GetMasterMode         write SetMasterMode;
    property PriorityName       : string       read GetPriorityName       write SetPriorityName;
    property ExitNotify         : TNotifyEvent read FExitCallback         write FExitCallback;
    property SettingChanged     : Boolean      read GetSettingChanged;
    property Accepted           : Boolean      read FAccepted;
  end;

implementation

{$R *.DFM}


{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>  True if a setting has changed

  Descript: Get flag if a setting has changed
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmSetupCard.GetSettingChanged: Boolean;
begin
  Result := False;
  Result := Result or (cmbCardNumber.ItemIndex        <> FOrgCardNumber);
  Result := Result or (rgCard.ItemIndex               <> FOrgCardSelected);
  Result := Result or (cmbThreadPriority.ItemIndex    <> FOrgThreadPriority);
  Result := Result or (cmbRpsProgram.ItemIndex        <> FOrgRpsProgram);
  Result := Result or (cmbBufferSize.ItemIndex        <> FOrgBufferSize);
  Result := Result or (rgMasterMode.ItemIndex         <> FOrgMasterMode);
end;


function TfrmSetupCard.GetCardNumber: Integer;
begin
  Result := cmbCardNumber.ItemIndex;
end;


procedure TfrmSetupCard.SetCardSuggestion(Value: string);
begin
  lblCardSuggestion.Caption := Value;
end;


procedure TfrmSetupCard.SetCardNumber(Value: Integer);
begin
  if Value < 0 then
    Value := 0;
  if Value > (cmbCardNumber.Items.Count-1) then
    Value := (cmbCardNumber.Items.Count-1);
  cmbCardNumber.ItemIndex := Value;
  FOrgCardNumber := Value;
end;


function TfrmSetupCard.GetCard: string;
begin
  Result := rgCard.Items[rgCard.ItemIndex];
end;


procedure TfrmSetupCard.SetCard(Value: string);
begin
  rgCard.Items.Add(Value);
  FOrgCardSelected := rgCard.Items.Count - 1;
  rgCard.ItemIndex := FOrgCardSelected;
  rgCard.Height := rgCard.Items.Count * (rgCard.Font.Size * 3);
end;


function TfrmSetupCard.GetCardFull: string;
begin
  Result := rgCardFull.Items[rgCard.ItemIndex]; // Note: Index from visible part!
end;


procedure TfrmSetupCard.SetCardFull(Value: string);
begin
  rgCardFull.Items.Add(Value);
end;


function TfrmSetupCard.GetCardSelected: Integer;
begin
  Result := rgCard.ItemIndex;
end;


procedure TfrmSetupCard.SetCardSelected(Value: Integer);
begin
  if Value < 0 then
    Value := 0;
  if Value > (rgCard.Items.Count-1) then
    Value := (rgCard.Items.Count-1);
  rgCard.ItemIndex := Value;
  FOrgCardSelected := Value;
end;


function TfrmSetupCard.GetThreadPriority: Integer;
begin
  Result := cmbThreadPriority.ItemIndex;
end;


procedure TfrmSetupCard.SetThreadPriority(Value: Integer);
begin
  if Value < 0 then
    Value := 0;
  if Value > (cmbThreadPriority.Items.Count-1) then
    Value := cmbThreadPriority.Items.Count-1;
  cmbThreadPriority.ItemIndex := Value;
  FOrgThreadPriority          := Value;
end;


function TfrmSetupCard.GetRpsProgram: Integer;
begin
  Result := cmbRpsProgram.ItemIndex - 2;
end;


procedure TfrmSetupCard.SetRpsProgram(Value: Integer);
begin
  Value := Value + 2;
  if Value < 0 then
    Value := 0;
  if Value > (cmbRpsProgram.Items.Count-1) then
    Value := cmbRpsProgram.Items.Count-1;
  cmbRpsProgram.ItemIndex := Value;
  FOrgRpsProgram          := Value;
end;


function TfrmSetupCard.GetBufferSize: Integer;
begin
  Result := (cmbBufferSize.ItemIndex + 1) * 100;
end;


procedure TfrmSetupCard.SetBufferSize(Value: Integer);
begin
  Value := Value div 100;
  Value := Value - 1;
  if Value < 0 then
    Value := 0;
  if Value > (cmbBufferSize.Items.Count-1) then
    Value := cmbBufferSize.Items.Count-1;
  cmbBufferSize.ItemIndex := Value;
  FOrgBufferSize          := Value;
end;


function TfrmSetupCard.GetMasterMode: Integer;
begin
  Result := rgMasterMode.ItemIndex;
end;


procedure TfrmSetupCard.SetMasterMode(Value: Integer);
begin
  if Value < 0 then
    Value := 0;
  if Value > (rgMasterMode.Items.Count-1) then
    Value := rgMasterMode.Items.Count-1;
  rgMasterMode.ItemIndex := Value;
  FOrgMasterMode          := Value;
end;


function TfrmSetupCard.GetPriorityName: string;
begin
  case cmbThreadPriority.ItemIndex of
    0: Result := 'Lowest';
    1: Result := 'Low';
    2: Result := 'Normal';
    3: Result := 'Default';
    4: Result := 'High';
    5: Result := 'Highest';
    6: Result := 'Realtime';
    else Result := '';
  end;
end;


procedure TfrmSetupCard.SetPriorityName(Value: string);
begin
  Value := UpperCase(Value);
  // Default to 'default'
  cmbThreadPriority.ItemIndex := 3;
  if Value = UpperCase('Lowest') then
    cmbThreadPriority.ItemIndex := 0;
  if Value = UpperCase('Low') then
    cmbThreadPriority.ItemIndex := 1;
  if Value = UpperCase('Normal') then
    cmbThreadPriority.ItemIndex := 2;
  if Value = UpperCase('Default') then
    cmbThreadPriority.ItemIndex := 3;
  if Value = UpperCase('High') then
    cmbThreadPriority.ItemIndex := 4;
  if Value = UpperCase('Highest') then
    cmbThreadPriority.ItemIndex := 5;
  if Value = UpperCase('Realtime') then
    cmbThreadPriority.ItemIndex := 6;
  FOrgThreadPriority := cmbThreadPriority.ItemIndex;
end;


procedure TfrmSetupCard.Revert;
begin
  cmbCardNumber.ItemIndex        := FOrgCardNumber;
  rgCard.ItemIndex               := FOrgCardSelected;
  cmbThreadPriority.ItemIndex    := FOrgThreadPriority;
  cmbRpsProgram.ItemIndex        := FOrgRpsProgram;
  cmbBufferSize.ItemIndex        := FOrgBufferSize;
  rgMasterMode.ItemIndex         := FOrgMasterMode;
end;


procedure TfrmSetupCard.btnRevertClick(Sender: TObject);
begin
  Revert;
end;


procedure TfrmSetupCard.btnOKClick(Sender: TObject);
begin
  FAccepted := True;
  Hide;
  Refresh;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupCard.btnDiscardClick(Sender: TObject);
begin
  Hide;
  Refresh;
  Revert;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupCard.FormCreate(Sender: TObject);
begin
  FOrgCardNumber         := 0;
  FOrgCardSelected       := 0;
  FOrgThreadPriority     := 0;
  FOrgRpsProgram         := 0;
  FOrgBufferSize         := 0;
  FOrgMasterMode         := -1;
  @FExitCallback         := nil;
  FAccepted              := False;
  cmbCardNumber.ItemIndex     := FOrgCardNumber;
  cmbThreadPriority.ItemIndex := FOrgThreadPriority;
  cmbRpsProgram.ItemIndex     := FOrgRpsProgram;
  cmbBufferSize.ItemIndex     := FOrgBufferSize;
end;


procedure TfrmSetupCard.FormDestroy(Sender: TObject);
begin
  btnDiscardClick(nil);
  @FExitCallback := nil;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Initialize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Initialize;
begin
  //
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Finalize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Finalize;
begin
  //
end;


initialization
  Initialize;


finalization
  Finalize;

end.

