{******************************************************************************}
{ FileName............: FlexCopIoControl                                       }
{ Project.............: FLEXCOP                                                }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  I/O control definitions for the FLEXCOP driver                              }
{                                                                              }
{  Copyright (C) 2003-2005  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20050413 - Initial release FLEXCOP.SYS V1.00                         }
{******************************************************************************}
unit FlexCopIoControl;

interface
uses
  Windows;

type
  Pvoid            = Pointer;
  PPhysicalMemoryAddress = ^PhysicalMemoryAddress;
  PhysicalMemoryAddress  = LARGE_INTEGER;

  TFlexCopGetDriverVersion = record
    MajorVersion: Word;                // Major version
    MinorVersion: Word;                // Minor version
    Build       : Dword;               // Build (date): $YYYMMDD
  end;

  TFlexCopGetDmaStatus  = record
    Interrupts              : Longint;                     // Number of interrupts counted sofar
    Isr                     : Dword;                       // Interrupt status register
    VirtualAddress          : Pvoid;                       // Virtual address of common buffer
    PhysicalAddress         : PhysicalMemoryAddress;       // Physical address of common buffer (use only for in RPS programs)
    Size                    : Dword;                       // Size of common buffer
    FifoOverflows           : Dword;                       // Global FIFO overflows
  end;

  TFlexCopDmaBuffer  = record
    Identifier              : Longint;                     // ID of buffer
    VirtualAddress          : Pvoid;                       // Virtual address of buffer
    PhysicalAddress         : PhysicalMemoryAddress;       // Physical address of buffer
    Size                    : Dword;                       // Size of buffer
  end;

  TFlexCopTransferBuffer  = record
    Identifier      : Longint;                             // ID of buffer
    TransferAddress : Pchar;                               // Pointer to source/target buffer
    SourceIndex     : Dword;                               // Index into source buffer
    TargetIndex     : Dword;                               // Index into target buffer
    TransferLength  : Dword;                               // Number of bytes to transfer
  end;

  TFlexCopFifoTransferBuffer  = record
    Identifier      : Longint;                             // ID of buffer
    NumberOfBuffers : Dword;                               // Number of buffers

    TransferAddress : packed array[0..1] of Pointer;       // Pointer to source buffer for each interrupt (sub buffer 0/1)
    TransferLength  : Dword;                               // Number of bytes to transfer
    IsValid         : Boolean;                             // Copy of <writeTag> indicating buffer has been written to
    OrderNumber     : Dword;                               // Copy of <irqsActiveReceived> counter when FIFO was written = order number
    Overflows       : Dword;                               // Counter incremented when written to buffer without reading it before
    Irqs            : Dword;                               // Counter incremented for each interrupt associated with the FIFO
    AllOverflows    : Dword;                               // Counter incremented when written to buffer without reading it before for ALL FIFO buffers of this IRQ
  end;

  TFlexCopIrqBuffer = record
    Irqs                    : Dword;                       // Counter incremented for each interrupt of this type
    IrqsWhenActive          : Dword;                       // Counter incremented for each interrupt of this type when active
    IrqBufferingIsActive    : Boolean;                     // Global activation flag of this interrupt
    UseNotificationEvent    : Boolean;                     // Indicates notify event to be triggered
    UseSignaling            : Boolean;                     // Indicates signal to be triggered
    UseFifo                 : Boolean;                     // Indicates FIFO to be used
    Reserved                : Boolean;
    SignalFlexCopRegister   : Dword;                       // FlexCop register for signalling
    SignalAndValue          : Dword;                       // AND operation to perform on register contents to extract bit
    SignalOrValue           : Dword;                       // OR  operation to perform on ANDED register contents to extract bit
    SignalXorValue          : Dword;                       // XOR (invert) operation to perform on ANDED and ORED register contents to extract bit

    FifoBufferPreviousIndex : Byte;                        // Previous FIFO used (index FIFO buffer array)
    FifoBufferFirstIndex    : Byte;                        // First FIFO to use (index FIFO buffer array)
    FifoBufferLastIndex     : Byte;                        // Last  FIFO to use (index FIFO buffer array)
    FifoBufferCirculations  : Dword;                       // Counter incremented each time <fifoBufferNext> == <fifoBufferStart>
    FifoOverflows           : Dword;                       // Counter incremented each time a FIFO <writeTag> was still set when written to it
  end;

  TFlexCopIrqTransferBuffer  = record
    Identifier  : Longint;                                 // ID of FlexCop IRQ bit number (0..31)
    Information : TFlexCopIrqBuffer;                       // Information structure
  end;

  TFlexCopWriteRegister  = record
    Address: Longint;                                      // Address to write to
    Data   : Dword;                                        // Data to write
  end;

  TFlexCopWriteRegisterWord  = record
    Address: Longint;                                      // Address to write to
    Data   : Word;                                         // Data to write
  end;


const
  CFlexCopDriverName = '\\.\FLEXCOP1';                     // NT name for driver


{------------------------------------------------------------------------------
  Descript: IOCTL codes to access driver.
 -----------------------------------------------------------------------------}
  CIoctlFlexCopGetDriverVersion           = $222000;       // Retrieve version information (FLEXCOP_GET_VERSION structure)
  CIoctlFlexCopGetDmaStatus               = $222004;       // Retrieve status information  (FLEXCOP_GET_STATUS  structure)
  CIoctlFlexCopReadFromFlexCopRegister    = $222008;       // Read  a FlexCop register
  CIoctlFlexCopWriteToFlexCopRegister     = $22200C;       // Write a FlexCop register
  CIoctlFlexCopWaitForNotification        = $222010;       // Wait for a notification
  CIoctlFlexCopGenerateManualNotification = $222014;       // Manually trigger the notification
  CIoctlFlexCopAllocateDma                = $222018;       // Allocate  DMA buffer
  CIoctlFlexCopReleaseDma                 = $22201C;       // Release   DMA buffer
  CIoctlFlexCopReadFromDma                = $222020;       // Read from DMA buffer
  CIoctlFlexCopWriteToDma                 = $222024;       // Write to  DMA buffer
  CIoctlFlexCopAllocateFifo               = $222028;       // Allocate  FIFO buffer
  CIoctlFlexCopReleaseFifo                = $22202C;       // Release   FIFO buffer
  CIoctlFlexCopReadFromFifo               = $222030;       // Read from FIFO buffer
  CIoctlFlexCopWriteToIrqHandling         = $222034;       // Write to  IRQ handling
  CIoctlFlexCopReadFromIrqHandling        = $222038;       // Read from IRQ handling
  CIoctlFlexCopReadFromFlexCopRegister2   = $22203C;       // Read  a FlexCop register (word)
  CIoctlFlexCopWriteToFlexCopRegister2    = $222040;       // Write a FlexCop register (word)

implementation

end.
