{******************************************************************************}
{ FileName............: MajorDvbSetupMiscellaneous                             }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 0.07                                                   }
{------------------------------------------------------------------------------}
{  Miscellaneous options                                                       }
{                                                                              }
{  Copyright (C) 2003-2005  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ Version   Date   Comment                                                     }
{  0.01   20041113 - Initial release                                           }
{  0.02   20041225 - Option added                                              }
{  0.03   20041231 - Option added                                              }
{  0.04   20050209 - Options added                                             }
{  0.05   20050305 - Options added                                             }
{  0.06   20050629 - Options added                                             }
{  0.07   20050726 - Options added                                             }
{******************************************************************************}
unit MajorDvbSetupMiscellaneous;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Mask, ComCtrls,
  ShlObj;

type
  TfrmSetupMiscellaneous = class(TForm)
    btnOK: TButton;
    btnDiscard: TButton;
    Shape2: TShape;
    Shape1: TShape;
    cmbCsa: TComboBox;
    Label1: TLabel;
    chkLogClear: TCheckBox;
    cmbLogLevel: TComboBox;
    Label2: TLabel;
    edtPreferredLanguage: TEdit;
    Label3: TLabel;
    chkAlwaysUpdateProgram: TCheckBox;
    chkKeySwapUpDown: TCheckBox;
    Label4: TLabel;
    edtFontName: TEdit;
    Label5: TLabel;
    cmbFontSize: TComboBox;
    mskEpgHeight: TMaskEdit;
    Label6: TLabel;
    Label7: TLabel;
    edtMdPluginPassFullPacket: TEdit;
    chkMdPluginAllowSetPids: TCheckBox;
    chkDisplayDuringRecording: TCheckBox;
    Shape3: TShape;
    Label8: TLabel;
    edtRecordingDirectory: TEdit;
    chkRecordingInfoFile: TCheckBox;
    tpTimeCorrection: TDateTimePicker;
    tpTimeCorrectionParameters: TDateTimePicker;
    tpTimeCorrectionPreRecord: TDateTimePicker;
    tpTimeCorrectionPostRecord: TDateTimePicker;
    Shape4: TShape;
    mskTimeoutNumericalKeys: TMaskEdit;
    mskTimeoutNumericalKeysRemote: TMaskEdit;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Shape5: TShape;
    Label13: TLabel;
    Label14: TLabel;
    Shape6: TShape;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    chkTimeCorrectionGmt: TCheckBox;
    btnBrowse: TButton;
    btnRevert: TButton;
    chkAutoContinueOnException: TCheckBox;
    Label18: TLabel;
    mskFreezeTimeout: TMaskEdit;
    edtFontNameEpg: TEdit;
    cmbFontSizeEPG: TComboBox;
    Label19: TLabel;
    Label20: TLabel;
    mskRecordingSplitSize: TMaskEdit;
    Label21: TLabel;
    Label22: TLabel;
    chkDisableSpecialButtons: TCheckBox;
    procedure SetCsa(Value: string);
    function  GetCsa: string;
    procedure SetLogLevel(Value: Integer);
    function  GetLogLevel: Integer;
    procedure SetLogClear(Value: Boolean);
    function  GetLogClear: Boolean;
    procedure SetPreferredLanguage(Value: string);
    function  GetPreferredLanguage: string;
    procedure SetAlwaysUpdateProgram(Value: Boolean);
    function  GetAlwaysUpdateProgram: Boolean;
    procedure SetKeySwapUpDown(Value: Boolean);
    function  GetKeySwapUpDown: Boolean;
    procedure SetDisableSpecialButtons(Value: Boolean);
    function  GetDisableSpecialButtons: Boolean;
    procedure SetFontName(Value: string);
    function  GetFontName: string;
    procedure SetFontSize(Value: Integer);
    function  GetFontSize: Integer;
    procedure SetFontNameEpg(Value: string);
    function  GetFontNameEpg: string;
    procedure SetFontSizeEpg(Value: Integer);
    function  GetFontSizeEpg: Integer;
    procedure SetEpgHeight(Value: Integer);
    function  GetEpgHeight: Integer;
    procedure SetTimeCorrectionGmt(Value: Boolean);
    function  GetTimeCorrectionGmt: Boolean;
    procedure SetTimeCorrection(Value: TDateTime);
    function  GetTimeCorrection: TDateTime;
    procedure SetTimeCorrectionPreRecord(Value: TDateTime);
    function  GetTimeCorrectionPreRecord: TDateTime;
    procedure SetTimeCorrectionPostRecord(Value: TDateTime);
    function  GetTimeCorrectionPostRecord: TDateTime;
    procedure SetMdPluginPassFullPacket(Value: string);
    function  GetMdPluginPassFullPacket: string;
    procedure SetMdPluginAllowSetPids(Value: Boolean);
    function  GetMdPluginAllowSetPids: Boolean;
    procedure SetDisplayDuringRecording(Value: Boolean);
    function  GetDisplayDuringRecording: Boolean;
    procedure SetRecordingDirectory(Value: string);
    function  GetRecordingDirectory: string;
    procedure SetRecordingInfoFile(Value: Boolean);
    function  GetRecordingInfoFile: Boolean;
    procedure SetRecordingSplitSize(Value: Integer);
    function  GetRecordingSplitSize: Integer;
    procedure SetTimeCorrectionParameters(Value: TDateTime);
    function  GetTimeCorrectionParameters: TDateTime;
    procedure SetTimeoutNumericalKeys(Value: Integer);
    function  GetTimeoutNumericalKeys: Integer;
    procedure SetTimeoutNumericalKeysRemote(Value: Integer);
    function  GetTimeoutNumericalKeysRemote: Integer;
    procedure SetAutoContinueOnException(Value: Boolean);
    function  GetAutoContinueOnException: Boolean;
    procedure SetFreezeTimeout(Value: Integer);
    function  GetFreezeTimeout: Integer;
    procedure btnOKClick(Sender: TObject);
    procedure btnDiscardClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnBrowseClick(Sender: TObject);
    procedure btnRevertClick(Sender: TObject);
  private
    { Private declarations }
    FOrgCsa                       : Integer;
    FOrgLogLevel                  : Integer;
    FOrgLogClear                  : Boolean;
    FOrgPreferredLanguage         : string;
    FOrgAlwaysUpdateProgram       : Boolean;
    FOrgKeySwapUpDown             : Boolean;
    FOrgDisableSpecialButtons     : Boolean;
    FOrgFontName                  : string;
    FOrgFontSize                  : Integer;
    FOrgFontNameEpg               : string;
    FOrgFontSizeEpg               : Integer;
    FOrgEpgHeight                 : string;
    FOrgTimeCorrectionGmt         : Boolean;
    FOrgTimeCorrection            : TDateTime;
    FOrgTimeCorrectionPreRecord   : TDateTime;
    FOrgTimeCorrectionPostRecord  : TDateTime;
    FOrgMdPluginPassFullPacket    : string;
    FOrgMdPluginAllowSetPids      : Boolean;
    FOrgDisplayDuringRecording    : Boolean;
    FOrgRecordingDirectory        : string;
    FOrgRecordingInfoFile         : Boolean;
    FOrgRecordingSplitSize        : string;
    FOrgTimeCorrectionParameters  : TDateTime;
    FOrgTimeoutNumericalKeys      : string;
    FOrgTimeoutNumericalKeysRemote: string;
    FOrgAutoContinueOnException   : Boolean;
    FOrgFreezeTimeout             : string;
    FExitCallback                 : TNotifyEvent;
    FAccepted                     : Boolean;
    procedure Revert;
    function  GetSettingChanged: Boolean;
  public
    { Public declarations }
    property Csa                       : string       read GetCsa                        write SetCsa;
    property LogLevel                  : Integer      read GetLogLevel                   write SetLogLevel;
    property LogClear                  : Boolean      read GetLogClear                   write SetLogClear;
    property PreferredLanguage         : string       read GetPreferredLanguage          write SetPreferredLanguage;
    property AlwaysUpdateProgram       : Boolean      read GetAlwaysUpdateProgram        write SetAlwaysUpdateProgram;
    property KeySwapUpDown             : Boolean      read GetKeySwapUpDown              write SetKeySwapUpDown;
    property DisableSpecialButtons     : Boolean      read GetDisableSpecialButtons      write SetDisableSpecialButtons;
    property FontName                  : string       read GetFontName                   write SetFontName;
    property FontSize                  : Integer      read GetFontSize                   write SetFontSize;
    property FontNameEpg               : string       read GetFontNameEpg                write SetFontNameEpg;
    property FontSizeEpg               : Integer      read GetFontSizeEpg                write SetFontSizeEpg;
    property EpgHeight                 : Integer      read GetEpgHeight                  write SetEpgHeight;
    property TimeCorrectionGmt         : Boolean      read GetTimeCorrectionGmt          write SetTimeCorrectionGmt;
    property TimeCorrection            : TDateTime    read GetTimeCorrection             write SetTimeCorrection;
    property TimeCorrectionPreRecord   : TDateTime    read GetTimeCorrectionPreRecord    write SetTimeCorrectionPreRecord;
    property TimeCorrectionPostRecord  : TDateTime    read GetTimeCorrectionPostRecord   write SetTimeCorrectionPostRecord;
    property MdPluginPassFullPacket    : string       read GetMdPluginPassFullPacket     write SetMdPluginPassFullPacket;
    property MdPluginAllowSetPids      : Boolean      read GetMdPluginAllowSetPids       write SetMdPluginAllowSetPids;
    property DisplayDuringRecording    : Boolean      read GetDisplayDuringRecording     write SetDisplayDuringRecording;
    property RecordingDirectory        : string       read GetRecordingDirectory         write SetRecordingDirectory;
    property RecordingInfoFile         : Boolean      read GetRecordingInfoFile          write SetRecordingInfoFile;
    property RecordingSplitSize        : Integer      read GetRecordingSplitSize         write SetRecordingSplitSize;
    property TimeCorrectionParameters  : TDateTime    read GetTimeCorrectionParameters   write SetTimeCorrectionParameters;
    property TimeoutNumericalKeys      : Integer      read GetTimeoutNumericalKeys       write SetTimeoutNumericalKeys;
    property TimeoutNumericalKeysRemote: Integer      read GetTimeoutNumericalKeysRemote write SetTimeoutNumericalKeysRemote;
    property AutoContinueOnException   : Boolean      read GetAutoContinueOnException    write SetAutoContinueOnException;
    property FreezeTimeout             : Integer      read GetFreezeTimeout              write SetFreezeTimeout;
    property ExitNotify                : TNotifyEvent read FExitCallback                 write FExitCallback;
    property SettingChanged            : Boolean      read GetSettingChanged;
    property Accepted                  : Boolean      read FAccepted;
  end;


implementation

{$R *.DFM}


{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>  True if a setting has changed

  Descript: Get flag if a setting has changed
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmSetupMiscellaneous.GetSettingChanged: Boolean;
begin
  Result := False;
  Result := Result or (FOrgCsa                        <> cmbCsa.ItemIndex);
  Result := Result or (FOrgLogLevel                   <> cmbLogLevel.ItemIndex);
  Result := Result or (FOrgLogClear                   <> chkLogClear.Checked);
  Result := Result or (FOrgPreferredLanguage          <> edtPreferredLanguage.Text);
  Result := Result or (FOrgAlwaysUpdateProgram        <> chkAlwaysUpdateProgram.Checked);
  Result := Result or (FOrgKeySwapUpDown              <> chkKeySwapUpDown.Checked);
  Result := Result or (FOrgDisableSpecialButtons      <> chkDisableSpecialButtons.Checked);
  Result := Result or (FOrgFontName                   <> edtFontName.Text);
  Result := Result or (FOrgFontSize                   <> cmbFontSize.ItemIndex);
  Result := Result or (FOrgFontNameEpg                <> edtFontNameEpg.Text);
  Result := Result or (FOrgFontSizeEpg                <> cmbFontSizeEpg.ItemIndex);
  Result := Result or (FOrgEpgHeight                  <> mskEpgHeight.Text);
  Result := Result or (FOrgTimeCorrectionGmt          <> chkTimeCorrectionGmt.Checked);
  Result := Result or (FOrgTimeCorrection             <> tpTimeCorrection.Time);
  Result := Result or (FOrgTimeCorrectionPreRecord    <> tpTimeCorrectionPreRecord.Time);
  Result := Result or (FOrgTimeCorrectionPostRecord   <> tpTimeCorrectionPostRecord.Time);
  Result := Result or (FOrgMdPluginPassFullPacket     <> edtMdPluginPassFullPacket.Text);
  Result := Result or (FOrgMdPluginAllowSetPids       <> chkMdPluginAllowSetPids.Checked);
  Result := Result or (FOrgDisplayDuringRecording     <> chkDisplayDuringRecording.Checked);
  Result := Result or (FOrgRecordingDirectory         <> edtRecordingDirectory.Text);
  Result := Result or (FOrgRecordingInfoFile          <> chkRecordingInfoFile.Checked);
  Result := Result or (FOrgRecordingSplitSize         <> mskRecordingSplitSize.Text);
  Result := Result or (FOrgTimeCorrectionParameters   <> tpTimeCorrectionParameters.Time);
  Result := Result or (FOrgTimeoutNumericalKeys       <> mskTimeoutNumericalKeys.Text);
  Result := Result or (FOrgTimeoutNumericalKeysRemote <> mskTimeoutNumericalKeysRemote.Text);
  Result := Result or (FOrgAutoContinueOnException    <> chkAutoContinueOnException.Checked);
  Result := Result or (FOrgFreezeTimeout              <> mskFreezeTimeout.Text);
end;


procedure TfrmSetupMiscellaneous.SetCsa(Value: string);
var
  Index: Integer;
begin
  FOrgCsa := -1;
  if Value <> '' then
  begin
    for Index := 0 to cmbCsa.Items.Count-1 do
      if LowerCase(cmbCsa.Items[Index]) = LowerCase(Value) then
        ForgCsa := Index;
    if FOrgCsa < 0 then
    begin
      cmbCsa.Items.Add(Value);
      FOrgCsa := cmbCsa.Items.Count-1;
    end;
  end;
  cmbCsa.ItemIndex := FOrgCsa;
end;


function TfrmSetupMiscellaneous.GetCsa: string;
begin
  Result := cmbCsa.Text;
end;


procedure TfrmSetupMiscellaneous.SetLogLevel(Value: Integer);
begin
  if (Value < 0) or (Value > cmbLogLevel.Items.Count-1) then
    Value := 0;
  FOrgLogLevel          := Value;
  cmbLogLevel.ItemIndex := Value;
end;


function TfrmSetupMiscellaneous.GetLogLevel: Integer;
begin
  Result := cmbLogLevel.ItemIndex;
end;


procedure TfrmSetupMiscellaneous.SetLogClear(Value: Boolean);
begin
  FOrgLogClear        := Value;
  chkLogClear.Checked := Value;
end;


function TfrmSetupMiscellaneous.GetLogClear: Boolean;
begin
  Result := chkLogClear.Checked;
end;


procedure TfrmSetupMiscellaneous.SetPreferredLanguage(Value: string);
begin
  FOrgPreferredLanguage     := Value;
  edtPreferredLanguage.Text := Value;
end;


function TfrmSetupMiscellaneous.GetPreferredLanguage: string;
begin
  Result := edtPreferredLanguage.Text;
end;


procedure TfrmSetupMiscellaneous.SetAlwaysUpdateProgram(Value: Boolean);
begin
  FOrgAlwaysUpdateProgram        := Value;
  chkAlwaysUpdateProgram.Checked := Value;
end;


function TfrmSetupMiscellaneous.GetAlwaysUpdateProgram: Boolean;
begin
  Result := chkAlwaysUpdateProgram.Checked;
end;


procedure TfrmSetupMiscellaneous.SetKeySwapUpDown(Value: Boolean);
begin
  FOrgKeySwapUpDown        := Value;
  chkKeySwapUpDown.Checked := Value;
end;


function TfrmSetupMiscellaneous.GetKeySwapUpDown: Boolean;
begin
  Result := chkKeySwapUpDown.Checked;
end;


procedure TfrmSetupMiscellaneous.SetDisableSpecialButtons(Value: Boolean);
begin
  FOrgDisableSpecialButtons        := Value;
  chkDisableSpecialButtons.Checked := Value;
end;


function TfrmSetupMiscellaneous.GetDisableSpecialButtons: Boolean;
begin
  Result := chkDisableSpecialButtons.Checked;
end;


procedure TfrmSetupMiscellaneous.SetFontName(Value: string);
begin
  FOrgFontName     := Value;
  edtFontName.Text := Value;
end;


function TfrmSetupMiscellaneous.GetFontName: string;
begin
  Result := edtFontName.Text;
end;


procedure TfrmSetupMiscellaneous.SetFontSize(Value: Integer);
begin
  if (Value < 1) then
    Value := 1;
  if (value > 60) then
    Value := 60;
  FOrgFontSize          := Value-1;
  cmbFontSize.ItemIndex := ForgFontSize;
end;


function TfrmSetupMiscellaneous.GetFontSize: Integer;
begin
  Result := cmbFontSize.ItemIndex + 1;
end;


procedure TfrmSetupMiscellaneous.SetFontNameEpg(Value: string);
begin
  FOrgFontNameEpg     := Value;
  edtFontNameEpg.Text := Value;
end;


function TfrmSetupMiscellaneous.GetFontNameEpg: string;
begin
  Result := edtFontNameEpg.Text;
end;


procedure TfrmSetupMiscellaneous.SetFontSizeEpg(Value: Integer);
begin
  if (Value < 1) then
    Value := 1;
  if (value > 60) then
    Value := 60;
  FOrgFontSizeEpg          := Value-1;
  cmbFontSizeEpg.ItemIndex := ForgFontSizeEpg;
end;


function TfrmSetupMiscellaneous.GetFontSizeEpg: Integer;
begin
  Result := cmbFontSizeEpg.ItemIndex + 1;
end;


procedure TfrmSetupMiscellaneous.SetEpgHeight(Value: Integer);
begin
  mskEpgHeight.Text := format('%d', [Value]);
  FOrgEpgHeight     := mskEpgHeight.Text;
end;


function TfrmSetupMiscellaneous.GetEpgHeight: Integer;
var
  Error: Integer;
begin
  Val(mskEpgHeight.Text, Result, Error);
end;


procedure TfrmSetupMiscellaneous.SetTimeCorrectionGmt(Value: Boolean);
begin
  FOrgTimeCorrectionGmt        := Value;
  chkTimeCorrectionGmt.Checked := Value;
end;


function TfrmSetupMiscellaneous.GetTimeCorrectionGmt: Boolean;
begin
  Result := chkTimeCorrectionGmt.Checked;
end;


procedure TfrmSetupMiscellaneous.SetTimeCorrection(Value: TDateTime);
begin
  if Value < 0 then
  begin
    Value := StrToTime('23' + TimeSeparator + '59' + TimeSeparator + '59') + Value;
    Value := Value + StrToTime('00' + TimeSeparator + '00' + TimeSeparator + '01');
  end;
  tpTimeCorrection.Time := Value;
  ForgTimeCorrection    := tpTimeCorrection.Time;
end;


function TfrmSetupMiscellaneous.GetTimeCorrection: TDateTime;
begin
  // Note: Since the .Time component can also contain the date make sure
  //       it is not taken into account ..
  if Frac(tpTimeCorrection.Time) > StrToTime('12' + TimeSeparator + '00' + TimeSeparator + '00') then
  begin
    Result := StrToTime('23' + TimeSeparator + '59' + TimeSeparator + '59') - Frac(tpTimeCorrection.Time);
    Result := Result + StrToTime('00' + TimeSeparator + '00' + TimeSeparator + '01');
    Result := -Result;
  end
  else
    Result := Frac(tpTimeCorrection.Time);
end;


procedure TfrmSetupMiscellaneous.SetTimeCorrectionPreRecord(Value: TDateTime);
begin
  if Value < 0 then
  begin
    Value := StrToTime('23' + TimeSeparator + '59' + TimeSeparator + '59') + Value;
    Value := Value + StrToTime('00' + TimeSeparator + '00' + TimeSeparator + '01');
  end;
  tpTimeCorrectionPreRecord.Time := Value;
  ForgTimeCorrectionPreRecord    := tpTimeCorrectionPreRecord.Time;
end;


function TfrmSetupMiscellaneous.GetTimeCorrectionPreRecord: TDateTime;
begin
  // Note: Since the .Time component can also contain the date make sure
  //       it is not taken into account ..
  if Frac(tpTimeCorrectionPreRecord.Time) > StrToTime('12' + TimeSeparator + '00' + TimeSeparator + '00') then
  begin
    Result := StrToTime('23' + TimeSeparator + '59' + TimeSeparator + '59') - Frac(tpTimeCorrectionPreRecord.Time);
    Result := Result + StrToTime('00' + TimeSeparator + '00' + TimeSeparator + '01');
    Result := -Result;
  end
  else
    Result := Frac(tpTimeCorrectionPreRecord.Time);
end;


procedure TfrmSetupMiscellaneous.SetTimeCorrectionPostRecord(Value: TDateTime);
begin
  if Value < 0 then
  begin
    Value := StrToTime('23' + TimeSeparator + '59' + TimeSeparator + '59') + Value;
    Value := Value + StrToTime('00' + TimeSeparator + '00' + TimeSeparator + '01');
  end;
  tpTimeCorrectionPostRecord.Time := Value;
  ForgTimeCorrectionPostRecord    := tpTimeCorrectionPostRecord.Time;
end;


function TfrmSetupMiscellaneous.GetTimeCorrectionPostRecord: TDateTime;
begin
  // Note: Since the .Time component can also contain the date make sure
  //       it is not taken into account ..
  if Frac(tpTimeCorrectionPostRecord.Time) > StrToTime('12' + TimeSeparator + '00' + TimeSeparator + '00') then
  begin
    Result := StrToTime('23' + TimeSeparator + '59' + TimeSeparator + '59') - Frac(tpTimeCorrectionPostRecord.Time);
    Result := Result + StrToTime('00' + TimeSeparator + '00' + TimeSeparator + '01');
    Result := -Result;
  end
  else
    Result := Frac(tpTimeCorrectionPostRecord.Time);
end;


procedure TfrmSetupMiscellaneous.SetMdPluginPassFullPacket(Value: string);
begin
  FOrgMdPluginPassFullPacket     := Value;
  edtMdPluginPassFullPacket.Text := Value;
end;


function TfrmSetupMiscellaneous.GetMdPluginPassFullPacket: string;
begin
  Result := edtMdPluginPassFullPacket.Text;
end;


procedure TfrmSetupMiscellaneous.SetMdPluginAllowSetPids(Value: Boolean);
begin
  FOrgMdPluginAllowSetPids        := Value;
  chkMdPluginAllowSetPids.Checked := Value;
end;


function TfrmSetupMiscellaneous.GetMdPluginAllowSetPids: Boolean;
begin
  Result := chkMdPluginAllowSetPids.Checked;
end;


procedure TfrmSetupMiscellaneous.SetDisplayDuringRecording(Value: Boolean);
begin
  FOrgDisplayDuringRecording        := Value;
  chkDisplayDuringRecording.Checked := Value;
end;


function TfrmSetupMiscellaneous.GetDisplayDuringRecording: Boolean;
begin
  Result := chkDisplayDuringRecording.Checked;
end;


procedure TfrmSetupMiscellaneous.SetRecordingDirectory(Value: string);
begin
  FOrgRecordingDirectory     := Value;
  edtRecordingDirectory.Text := Value;
end;


function TfrmSetupMiscellaneous.GetRecordingDirectory: string;
begin
  Result := edtRecordingDirectory.Text;
end;


procedure TfrmSetupMiscellaneous.SetRecordingInfoFile(Value: Boolean);
begin
  FOrgRecordingInfoFile        := Value;
  chkRecordingInfoFile.Checked := Value;
end;


function TfrmSetupMiscellaneous.GetRecordingInfoFile: Boolean;
begin
  Result := chkRecordingInfoFile.Checked;
end;


procedure TfrmSetupMiscellaneous.SetRecordingSplitSize(Value: Integer);
begin
  mskRecordingSplitSize.Text := format('%d', [Value]);
  FOrgRecordingSplitSize     := mskRecordingSplitSize.Text;
end;


function TfrmSetupMiscellaneous.GetRecordingSplitSize: Integer;
var
  Error: Integer;
begin
  Val(mskRecordingSplitSize.Text, Result, Error);
end;


procedure TfrmSetupMiscellaneous.SetTimeCorrectionParameters(Value: TDateTime);
begin
  if Value < 0 then
  begin
    Value := StrToTime('23' + TimeSeparator + '59' + TimeSeparator + '59') + Value;
    Value := Value + StrToTime('00' + TimeSeparator + '00' + TimeSeparator + '01');
  end;
  tpTimeCorrectionParameters.Time := Value;
  ForgTimeCorrectionParameters    := tpTimeCorrectionParameters.Time;
end;


function TfrmSetupMiscellaneous.GetTimeCorrectionParameters: TDateTime;
begin
  // Note: Since the .Time component can also contain the date make sure
  //       it is not taken into account ..
  if Frac(tpTimeCorrectionParameters.Time) > StrToTime('12' + TimeSeparator + '00' + TimeSeparator + '00') then
  begin
    Result := StrToTime('23' + TimeSeparator + '59' + TimeSeparator + '59') - Frac(tpTimeCorrectionParameters.Time);
    Result := Result + StrToTime('00' + TimeSeparator + '00' + TimeSeparator + '01');
    Result := -Result;
  end
  else
    Result := Frac(tpTimeCorrectionParameters.Time);
end;


procedure TfrmSetupMiscellaneous.SetTimeoutNumericalKeys(Value: Integer);
begin
  mskTimeoutNumericalKeys.Text := format('%d', [Value]);
  FOrgTimeoutNumericalKeys     := mskTimeoutNumericalKeys.Text;
end;


function TfrmSetupMiscellaneous.GetTimeoutNumericalKeys: Integer;
var
  Error: Integer;
begin
  Val(mskTimeoutNumericalKeys.Text, Result, Error);
end;


procedure TfrmSetupMiscellaneous.SetTimeoutNumericalKeysRemote(Value: Integer);
begin
  mskTimeoutNumericalKeysRemote.Text := format('%d', [Value]);
  FOrgTimeoutNumericalKeysRemote     := mskTimeoutNumericalKeysRemote.Text;
end;


function TfrmSetupMiscellaneous.GetTimeoutNumericalKeysRemote: Integer;
var
  Error: Integer;
begin
  Val(mskTimeoutNumericalKeysRemote.Text, Result, Error);
end;


procedure TfrmSetupMiscellaneous.SetAutoContinueOnException(Value: Boolean);
begin
  FOrgAutoContinueOnException        := Value;
  chkAutoContinueOnException.Checked := Value;
end;


function TfrmSetupMiscellaneous.GetAutoContinueOnException: Boolean;
begin
  Result := chkAutoContinueOnException.Checked;
end;


procedure TfrmSetupMiscellaneous.SetFreezeTimeout(Value: Integer);
begin
  mskFreezeTimeout.Text := format('%d', [Value]);
  FOrgFreezeTimeout := mskFreezeTimeout.Text;
end;


function TfrmSetupMiscellaneous.GetFreezeTimeout: Integer;
var
  Error: Integer;
begin
  Val(mskFreezeTimeout.Text, Result, Error);
  // Make sure at least some time is allowed
  if Result < 1 then
    Result := 1; 
end;


procedure TfrmSetupMiscellaneous.Revert;
begin
  cmbCsa.ItemIndex                   := FOrgCsa;
  cmbLogLevel.ItemIndex              := FOrgLogLevel;
  chkLogClear.Checked                := FOrgLogClear;
  edtPreferredLanguage.Text          := FOrgPreferredLanguage;
  chkAlwaysUpdateProgram.Checked     := FOrgAlwaysUpdateProgram;
  chkKeySwapUpDown.Checked           := FOrgKeySwapUpDown;
  chkDisableSpecialButtons.Checked   := FOrgDisableSpecialButtons;
  edtFontName.Text                   := FOrgFontName;
  cmbFontSize.ItemIndex              := FOrgFontSize;
  edtFontNameEpg.Text                := FOrgFontNameEpg;
  cmbFontSizeEpg.ItemIndex           := FOrgFontSizeEpg;
  mskEpgHeight.Text                  := FOrgEpgHeight;
  chkTimeCorrectionGmt.Checked       := FOrgTimeCorrectionGmt;
  tpTimeCorrection.Time              := FOrgTimeCorrection;
  tpTimeCorrectionPreRecord.Time     := FOrgTimeCorrectionPreRecord;
  tpTimeCorrectionPostRecord.Time    := FOrgTimeCorrectionPostRecord;
  edtMdPluginPassFullPacket.Text     := FOrgMdPluginPassFullPacket;
  chkMdPluginAllowSetPids.Checked    := FOrgMdPluginAllowSetPids;
  chkDisplayDuringRecording.Checked  := FOrgDisplayDuringRecording;
  edtRecordingDirectory.Text         := FOrgRecordingDirectory;
  chkRecordingInfoFile.Checked       := FOrgRecordingInfoFile;
  mskRecordingSplitSize.Text         := FOrgRecordingSplitSize;
  tpTimeCorrectionParameters.Time    := FOrgTimeCorrectionParameters;
  mskTimeoutNumericalKeys.Text       := FOrgTimeoutNumericalKeys;
  mskTimeoutNumericalKeysRemote.Text := FOrgTimeoutNumericalKeysRemote;
  chkAutoContinueOnException.Checked := FOrgAutoContinueOnException;
  mskFreezeTimeout.Text              := FOrgFreezeTimeout;
end;


procedure TfrmSetupMiscellaneous.FormCreate(Sender: TObject);
var
  SearchRec       : TSearchRec;
  Success         : Integer;
  NewName         : string;
//  CsaDLLIdentifier: Integer;
begin
  Success := FindFirst('*.DLL', faAnyFile, SearchRec);
  if Success = 0 then
  try
    repeat
      NewName := SearchRec.Name;
//    FOR SOME REASON NOT ALWAYS ABLE TO LOAD ALL DLL'S - SAME PROBLEM WHEN SWITCHING DLL'S
//    IN MAIN APPLICATION
//    THIS IS PROBABLY DUE TO RESOURCE PROBLEMS (PROBABLY BECAUSE OF DEBUGGING ENVIRONMENT
//    AND INTERRUPTING/EXITING THE PROGRAM). DLL'S WHICH ALREADY LOADED AT SOME
//    POINT ARE STILL BEING 'DETECTED'
      // Try if correct DLL
(*      CsaDLLIdentifier := LoadLibrary(PChar(NewName));
      // If we failed using the library use the internal mechanism
      if CsaDLLIdentifier <> 0 then
      begin
        // Check for 'normal' CSA mechanism
        if (GetProcAddress(CsaDLLIdentifier, 'set_cws') <> nil) and
           (GetProcAddress(CsaDLLIdentifier, 'decrypt') <> nil) then
          cmbCsa.Items.Add(ExtractFileName(NewName))
        else
          // Check for FFDeCSA mechanism
          if (GetProcAddress(CsaDLLIdentifier, 'set_control_words') <> nil) and
             (GetProcAddress(CsaDLLIdentifier, 'decrypt_packets'  ) <> nil) and
             (GetProcAddress(CsaDLLIdentifier, 'get_keyset_size'  ) <> nil) and
             (GetProcAddress(CsaDLLIdentifier, 'get_parallelism'  ) <> nil) then
            cmbCsa.Items.Add(ExtractFileName(NewName));
        FreeLibrary(CsaDLLIdentifier);
      end;
*)
      cmbCsa.Items.Add(ExtractFileName(NewName));
      Success := FindNext(SearchRec);
    until Success <> 0;
  finally
    SysUtils.FindClose(SearchRec);
  end;
  @FExitCallback        := nil;
  FAccepted             := False;
  FOrgCsa                            := cmbCsa.Items.Count-1;
  cmbCsa.ItemIndex                   := FOrgCsa;
  FOrgLogLevel                       := 0;
  cmbLogLevel.ItemIndex              := FOrgLogLevel;
  FOrgLogClear                       := True;
  chkLogClear.Checked                := FOrgLogClear;
  FOrgPreferredLanguage              := '***, dut, ned, eng, ger, deu';
  edtPreferredLanguage.Text          := FOrgPreferredLanguage;
  FOrgAlwaysUpdateProgram            := True;
  chkAlwaysUpdateProgram.Checked     := FOrgAlwaysUpdateProgram;
  FOrgKeySwapUpDown                  := False;
  chkKeySwapUpDown.Checked           := FOrgKeySwapUpDown;
  FOrgDisableSpecialButtons          := False;
  chkDisableSpecialButtons.Checked   := FOrgDisableSpecialButtons;
  FOrgFontName                       := '';
  edtFontName.Text                   := FOrgFontName;
  FOrgFontSize                       := 7;
  cmbFontSize.ItemIndex              := FOrgFontSize;
  FOrgFontNameEpg                    := '';
  edtFontNameEpg.Text                := FOrgFontNameEpg;
  FOrgFontSizeEpg                    := 7;
  cmbFontSizeEpg.ItemIndex           := FOrgFontSizeEpg;
  mskEpgHeight.Text                  := '72';
  FOrgEpgHeight                      := mskEpgHeight.Text;
  FOrgTimeCorrectionGmt              := True;
  chkTimeCorrectionGmt.Checked       := FOrgTimeCorrectionGmt;
  tpTimeCorrection.Time              := StrToTime('00' + TimeSeparator + '00' + TimeSeparator + '00');
  FOrgTimeCorrection                 := tpTimeCorrection.Time;
  tpTimeCorrectionPreRecord.Time     := StrToTime('00' + TimeSeparator + '05' + TimeSeparator + '00');
  FOrgTimeCorrectionPreRecord        := tpTimeCorrectionPreRecord.Time;
  tpTimeCorrectionPostRecord.Time    := StrToTime('00' + TimeSeparator + '05' + TimeSeparator + '00');
  FOrgTimeCorrectionPostRecord       := tpTimeCorrectionPostRecord.Time;
  FOrgMdPluginPassFullPacket         := '';
  edtMdPluginPassFullPacket.Text     := FOrgMdPluginPassFullPacket;
  FOrgMdPluginAllowSetPids           := False;
  chkMdPluginAllowSetPids.Checked    := FOrgMdPluginAllowSetPids;
  FOrgDisplayDuringRecording         := True;
  chkDisplayDuringRecording.Checked  := FOrgDisplayDuringRecording;
  FOrgRecordingDirectory             := '';
  edtRecordingDirectory.Text         := FOrgRecordingDirectory;
  FOrgRecordingInfoFile              := False;
  chkRecordingInfoFile.Checked       := FOrgRecordingInfoFile;
  mskRecordingSplitSize.Text         := '9999';
  FOrgRecordingSplitSize             := mskRecordingSplitSize.Text;
  tpTimeCorrectionParameters.Time    := StrToTime('00' + TimeSeparator + '00' + TimeSeparator + '00');
  FOrgTimeCorrectionParameters       := tpTimeCorrectionParameters.Time;
  FOrgTimeoutNumericalKeys           := '500';
  mskTimeoutNumericalKeys.Text       := FOrgTimeoutNumericalKeys;
  FOrgTimeoutNumericalKeysRemote     := '1000';
  mskTimeoutNumericalKeysRemote.Text := FOrgTimeoutNumericalKeysRemote;
  chkAutoContinueOnException.Checked := False;
  FOrgFreezeTimeout                  := '30';
  mskFreezeTimeout.Text              := FOrgFreezeTimeout;
end;


procedure TfrmSetupMiscellaneous.btnBrowseClick(Sender: TObject);
var
  lpItemID   : PItemIDList;
  BrowseInfo : TBrowseInfo;
  DisplayName: array[0..MAX_PATH] of Char;
  TempPath   : array[0..MAX_PATH] of Char;
begin
  BrowseInfo.hwndOwner      := Self.Handle;
  BrowseInfo.pidlRoot       := nil;
  BrowseInfo.pszDisplayName := @DisplayName;
  BrowseInfo.lpszTitle      := PChar('Select download folder:');
  BrowseInfo.ulFlags        := BIF_RETURNONLYFSDIRS ;
  BrowseInfo.lpfn           := nil;
  lpItemID := SHBrowseForFolder(BrowseInfo);
  if Assigned(lpItemId) then
  begin
    SHGetPathFromIDList(lpItemID, TempPath);
    edtRecordingDirectory.Text := TempPath;
    GlobalFreePtr(lpItemID);
  end;
end;


procedure TfrmSetupMiscellaneous.btnRevertClick(Sender: TObject);
begin
  Revert;
end;


procedure TfrmSetupMiscellaneous.btnOKClick(Sender: TObject);
begin
  FAccepted := True;
  Hide;
  Refresh;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupMiscellaneous.btnDiscardClick(Sender: TObject);
begin
  Hide;
  Refresh;
  Revert;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupMiscellaneous.FormDestroy(Sender: TObject);
begin
  btnDiscardClick(nil);
  @FExitCallback := nil;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Initialize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Initialize;
begin
  //
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Finalize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Finalize;
begin
  //
end;


initialization
  Initialize;


finalization
  Finalize;

end.

