{******************************************************************************}
{ FileName............: MajorDvbSetupFiles                                     }
{ Project.............: MajorDvb                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 0.03                                                   }
{------------------------------------------------------------------------------}
{  File options                                                                }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ Version   Date   Comment                                                     }
{  0.01   20041113 - Initial release                                           }
{  0.02   20050312 - Removal of executable path                                }
{  0.03   20050729 - FEC checkbox added                                        }
{******************************************************************************}
unit MajorDvbSetupFiles;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Mask, ComCtrls, Grids;

type
  TfrmSetupFiles = class(TForm)
    btnOK: TButton;
    btnDiscard: TButton;
    Shape3: TShape;
    Label8: TLabel;
    edtTransponderFile: TEdit;
    Shape4: TShape;
    Shape6: TShape;
    btnBrowse: TButton;
    sgFavouriteFiles: TStringGrid;
    Label1: TLabel;
    btnRemove: TButton;
    btnAdd: TButton;
    btnUp: TButton;
    btnDown: TButton;
    btnRevert: TButton;
    chkFecFromTransponder: TCheckBox;
    procedure SetTransponderFile(Value: string);
    function  GetTransponderFile: string;
    procedure SetFavouriteFile(Index: Integer; Value: string);
    function  GetFavouriteFile(Index: Integer): string;
    procedure SetFavouriteDescription(Index: Integer; Value: string);
    function  GetFavouriteDescription(Index: Integer): string;
    procedure SetFecFromTransponder(Value: Boolean);
    function  GetFecFromTransponder: Boolean;
    procedure btnOKClick(Sender: TObject);
    procedure btnDiscardClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnBrowseClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure btnUpClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure sgFavouriteFilesKeyPress(Sender: TObject; var Key: Char);
    procedure btnRevertClick(Sender: TObject);
  private
    { Private declarations }
    FOrgTransponderFile      : string;
    FOrgFavouriteFiles       : array[0..99] of string;
    FOrgFavouriteDescriptions: array[0..99] of string;
    FOrgRowCount             : Integer;
    FOrgFecFromTransponder   : Boolean;
    FExitCallback            : TNotifyEvent;
    FAccepted                : Boolean;
    FExeDirectory            : string;           // Applications path (MUST be lower case)
    procedure Revert;
    function  GetSettingChanged: Boolean;
  public
    { Public declarations }
    property TransponderFile                     : string       read GetTransponderFile      write SetTransponderFile;
    property FavouriteFile       [Index: Integer]: string       read GetFavouriteFile        write SetfavouriteFile;
    property FavouriteDescription[Index: Integer]: string       read GetFavouriteDescription write SetfavouriteDescription;
    property FecFromTransponder                  : Boolean      read GetFecFromTransponder   write SetFecFromTransponder;
    property ExitNotify                          : TNotifyEvent read FExitCallback           write FExitCallback;
    property SettingChanged                      : Boolean      read GetSettingChanged;
    property Accepted                            : Boolean      read FAccepted;
    property ExeDirectory                        : string                                    write FExeDirectory;
  end;


implementation

{$R *.DFM}


{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>  True if a setting has changed

  Descript: Get flag if a setting has changed
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmSetupFiles.GetSettingChanged: Boolean;
var
  Loop: Integer;
begin
  Result := False;
  Result := Result or (FOrgTransponderFile <> edtTransponderFile.Text);
  Result := Result or (FOrgRowCount <> sgFavouriteFiles.RowCount);
  Result := Result or (FOrgFecfromTransponder <> chkFecFromTransponder.Checked);
  if sgFavouriteFiles.RowCount > 0 then
    for Loop := 1 to sgFavouriteFiles.RowCount-1 do
    begin
      Result := Result or (FOrgFavouriteFiles[Loop-1]        <> sgFavouriteFiles.Cells[1, Loop]);
      Result := Result or (FOrgFavouriteDescriptions[Loop-1] <> sgFavouriteFiles.Cells[2, Loop]);
    end;
end;


procedure TfrmSetupFiles.SetTransponderFile(Value: string);
begin
  FOrgTransponderFile     := Value;
  edtTransponderFile.Text := Value;
end;


function TfrmSetupFiles.GetTransponderFile: string;
begin
  Result := edtTransponderFile.Text;
end;


procedure TfrmSetupFiles.SetFavouriteFile(Index: Integer; Value: string);
begin
  if (Index < Low(FOrgFavouriteFiles)) or (Index > High(FOrgfavouriteFiles)) then
    Exit;
  FOrgFavouriteFiles[Index] := Value;
  if Index >= (sgFavouriteFiles.RowCount - 2) then
  begin
    sgFavouriteFiles.RowCount := Index + 3;
    FOrgRowCOunt := sgFavouriteFiles.RowCount;
  end;
  sgFavouriteFiles.Cells[1, Index + 1] := Value;
  sgFavouriteFiles.Cells[0, Index + 1] := format('%2.2d', [Index + 1]);
  sgFavouriteFiles.Cells[0, Index + 2] := format('%2.2d', [Index + 2]);
end;


function TfrmSetupFiles.GetFavouriteFile(Index: Integer): string;
begin
  if (Index < Low(FOrgFavouriteFiles)) or (Index > High(FOrgFavouriteFiles)) then
    Exit;
  if (Index >= (sgFavouriteFiles.RowCount - 1)) then
    Result := ''
  else
    Result := sgFavouriteFiles.Cells[1, Index+1];
end;


procedure TfrmSetupFiles.SetFavouriteDescription(Index: Integer; Value: string);
begin
  if (Index < Low(FOrgFavouriteFiles)) or (Index > High(FOrgFavouriteFiles)) then
    Exit;
  FOrgFavouriteDescriptions[Index] := Value;
  if Index >= (sgFavouriteFiles.RowCount - 2) then
  begin
    sgFavouriteFiles.RowCount := Index + 3;
    FOrgRowCount := sgFavouriteFiles.RowCount;
  end;
  sgFavouriteFiles.Cells[2, Index + 1] := Value;
  sgFavouriteFiles.Cells[0, Index + 1] := format('%2.2d', [Index + 1]);
  sgFavouriteFiles.Cells[0, Index + 2] := format('%2.2d', [Index + 2]);
end;


function TfrmSetupFiles.GetFavouriteDescription(Index: Integer): string;
begin
  Result := '';
  if (Index < Low(FOrgFavouriteDescriptions)) or (Index > High(FOrgFavouriteDescriptions)) then
    Exit;
  if (Index >= (sgFavouriteFiles.RowCount - 1)) then
    Exit
  else
    Result := sgFavouriteFiles.Cells[2, Index+1];
end;


procedure TfrmSetupFiles.SetFecFromTransponder(Value: Boolean);
begin
  FOrgFecFromTransponder := Value;
  chkFecFromTransponder.Checked := Value;
end;


function TfrmSetupFiles.GetFecFromTransponder: Boolean;
begin
  Result := chkFecFromTransponder.Checked;
end;


procedure TfrmSetupFiles.Revert;
var
  High1 : Integer;
  High2 : Integer;
  Loop  : Integer;
begin
  edtTransponderFile.Text := FOrgTransponderFile;
  chkFecFromTransponder.Checked := FOrgFecFromTransponder;
  // Find highest entry
  High1 := High(FOrgFavouriteFiles);
  while (High1 >= Low(FOrgFavouriteFiles)) and (FOrgFavouriteFiles[High1] = '') do
    Dec(High1);
  High2 := High(FOrgFavouriteDescriptions);
  while (High2 >= Low(FOrgFavouriteDescriptions)) and (FOrgFavouriteDescriptions[High2] = '') do
    Dec(High2);
  if High1 > High2 then
    sgFavouriteFiles.RowCount := High1 + 3
  else
    sgFavouriteFiles.RowCount := High2 + 3;
  for Loop := 1 to sgFavouriteFiles.RowCount-1 do
  begin
    sgFavouriteFiles.Cells[1, Loop] := FOrgFavouriteFiles[Loop-1];
    sgFavouriteFiles.Cells[2, Loop] := FOrgFavouriteDescriptions[Loop-1];
    sgFavouriteFiles.Cells[0, Loop] := format('%2.2d', [Loop]);
    sgFavouriteFiles.Cells[0, Loop + 1] := format('%2.2d', [Loop + 1]);
  end;
end;


procedure TfrmSetupFiles.FormCreate(Sender: TObject);
var
  Loop: Integer;
begin
  @FExitCallback          := nil;
  FAccepted               := False;
  FOrgTransponderFile     := '';
  FOrgRowCount            := 0;
  FOrgFecFromTransponder  := False;
  FExeDirectory           := '';
  edtTransponderFile.Text := FOrgTransponderFile;
  for Loop := Low(FOrgFavouriteFiles) to High(FOrgFavouriteFiles) do
    FOrgFavouriteFiles[Loop] := '';
  for Loop := Low(FOrgFavouriteDescriptions) to High(FOrgFavouriteDescriptions) do
    FOrgFavouriteDescriptions[Loop] := '';
  sgFavouriteFiles.ColWidths[0] := 20;
  sgFavouriteFiles.ColWidths[1] := 128;
  sgFavouriteFiles.ColWidths[2] := 296;
  sgFavouriteFiles.Cells[1, 0] := 'File';
  sgFavouriteFiles.Cells[2, 0] := 'Description';
  sgFavouriteFiles.Cells[0, 1] := format('%2.2d', [1]);
end;


procedure TfrmSetupFiles.btnBrowseClick(Sender: TObject);
var
  Browser : TOpenDialog;
  FileName: string;
begin
  Browser := TOpenDialog.Create(Self);
  try
    Browser.Options := [];
    if Browser.Execute then
    begin
      // Remove applications path is present
      FileName := LowerCase(Browser.FileName);
      if Pos(FExeDirectory, FileName) = 1 then
        Delete(FileName, 1, Length(FExeDirectory));
      edtTransponderFile.Text := FileName;
    end;
  finally
    Browser.Free;
  end;
end;


procedure TfrmSetupFiles.btnAddClick(Sender: TObject);
var
  Browser: TOpenDialog;
  FileName: string;
begin
  Browser := TOpenDialog.Create(Self);
  try
    Browser.Options := [];
    if Browser.Execute then
    begin
      // Remove applications path is present
      FileName := LowerCase(Browser.FileName);
      if Pos(FExeDirectory, FileName) = 1 then
        Delete(FileName, 1, Length(FExeDirectory));
      sgFavouriteFiles.RowCount := sgFavouriteFiles.RowCount + 1;
      sgFavouriteFiles.Cells[1, sgFavouriteFiles.RowCount - 2] := FileName;
      sgFavouriteFiles.Cells[0, sgFavouriteFiles.RowCount - 1] := format('%2.2d', [sgFavouriteFiles.RowCount - 1]);
      sgFavouriteFiles.Cells[1, sgFavouriteFiles.RowCount - 1] := '';
      sgFavouriteFiles.Cells[2, sgFavouriteFiles.RowCount - 1] := '';
    end;
  finally
    Browser.Free;
  end;
end;


procedure TfrmSetupFiles.btnRemoveClick(Sender: TObject);
var
  Loop: Integer;
begin
  if sgFavouriteFiles.RowCount <= 2 then
    Exit;
  if sgFavouriteFiles.Row >= (sgFavouriteFiles.RowCount-1) then
    Exit;
  for Loop := sgFavouriteFiles.Row+1 to sgFavouriteFiles.RowCount-1 do
  begin
    sgFavouriteFiles.Cells[1, Loop-1] := sgFavouriteFiles.Cells[1, Loop];
    sgFavouriteFiles.Cells[2, Loop-1] := sgFavouriteFiles.Cells[2, Loop];
  end;
  sgFavouriteFiles.RowCount := sgFavouriteFiles.RowCount - 1;
  sgFavouriteFiles.Cells[1, sgFavouriteFiles.RowCount - 1] := '';
  sgFavouriteFiles.Cells[2, sgFavouriteFiles.RowCount - 1] := '';
  sgFavouriteFiles.Cells[0, sgFavouriteFiles.RowCount - 1] := format('%2.2d', [sgFavouriteFiles.RowCount - 1]);
  if sgFavouriteFiles.Row > 1 then
    sgFavouriteFiles.Row := sgFavouriteFiles.Row - 1;
end;


procedure TfrmSetupFiles.btnUpClick(Sender: TObject);
var
  TempString: string;
begin
  if sgFavouriteFiles.Row < 2 then
    Exit;
  if sgFavouriteFiles.Row >= (sgFavouriteFiles.RowCount-1) then
    Exit;
  TempString := sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row-1];
  sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row-1] := sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row];
  sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row]   := TempString;
  TempString := sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row-1];
  sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row-1] := sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row];
  sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row]   := TempString;
  sgFavouriteFiles.Row := sgFavouriteFiles.Row - 1;
end;


procedure TfrmSetupFiles.btnDownClick(Sender: TObject);
var
  TempString: string;
begin
  if sgFavouriteFiles.Row >= (sgFavouriteFiles.RowCount-2) then
    Exit;
  TempString := sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row+1];
  sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row+1] := sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row];
  sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row]   := TempString;
  TempString := sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row+1];
  sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row+1] := sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row];
  sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row]   := TempString;
  sgFavouriteFiles.Row := sgFavouriteFiles.Row + 1;
end;


procedure TfrmSetupFiles.sgFavouriteFilesKeyPress(Sender: TObject;
  var Key: Char);
begin
  if sgFavouriteFiles.Row >= (sgFavouriteFiles.RowCount - 1) then
    sgFavouriteFiles.RowCount := sgFavouriteFiles.RowCount + 1;
  sgFavouriteFiles.Cells[1, sgFavouriteFiles.RowCount - 1] := '';
  sgFavouriteFiles.Cells[2, sgFavouriteFiles.RowCount - 1] := '';
  sgFavouriteFiles.Cells[0, sgFavouriteFiles.RowCount - 1] := format('%2.2d', [sgFavouriteFiles.RowCount - 1]);
end;


procedure TfrmSetupFiles.btnRevertClick(Sender: TObject);
begin
  Revert;
end;


procedure TfrmSetupFiles.btnOKClick(Sender: TObject);
begin
  FAccepted := True;
  Hide;
  Refresh;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupFiles.btnDiscardClick(Sender: TObject);
begin
  Hide;
  Refresh;
  Revert;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupFiles.FormDestroy(Sender: TObject);
begin
  btnDiscardClick(nil);
  @FExitCallback := nil;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Initialize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Initialize;
begin
  //
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Finalize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Finalize;
begin
  //
end;


initialization
  Initialize;


finalization
  Finalize;

end.

