{******************************************************************************}
{ FileName............: MajorDvbSetupExceptions                                }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 0.01                                                   }
{------------------------------------------------------------------------------}
{  Exception options                                                           }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ Version   Date   Comment                                                     }
{  0.01   20041220 - Initial release                                           }
{******************************************************************************}
unit MajorDvbSetupExceptions;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Mask, ComCtrls, Grids;

type
  TfrmSetupExceptions = class(TForm)
    btnOK: TButton;
    btnDiscard: TButton;
    Shape3: TShape;
    Shape4: TShape;
    Shape6: TShape;
    btnRevert: TButton;
    procedure SetShowExceptionBox(Value: Boolean);
    function  GetShowExceptionBox: Boolean;
    procedure SetAutoClipboard(Value: Boolean);
    function  GetAutoClipboard: Boolean;
    procedure SetAutoSave(Value: Boolean);
    function  GetAutoSave: Boolean;
    procedure SetAutoMail(Value: Boolean);
    function  GetAutoMail: Boolean;
    procedure SetAutoContinue(Value: Boolean);
    function  GetAutoContinue: Boolean;
    procedure SetAutoRestart(Value: Dword);
    function  GetAutoRestart: Dword;
    procedure SetAutoClose(Value: Dword);
    function  GetAutoClose: Dword;
    procedure SetBugReportFileSize(Value: Dword);
    function  GetBugReportFileSize: Dword;
    procedure SetBugReportFile(Value: ShortString);
    function  GetBugReportFile: ShortString;
    procedure SetMailAddr(Value: ShortString);
    function  GetMailAddr: ShortString;
    procedure SetMailSubject(Value: ShortString);
    function  GetMailSubject: ShortString;
    procedure SetAttachBugReportFile(Value: Boolean);
    function  GetAttachBugReportFile: Boolean;
    procedure SetDeleteBugReportFile(Value: Boolean);
    function  GetDeleteBugReportFile: Boolean;
    procedure SetScreenShotDepth(Value: Integer);
    function  GetScreenShotDepth: Integer;
    procedure SetMailAsSmtpServer(Value: Boolean);
    function  GetMailAsSmtpServer: Boolean;
    procedure SetMailAsSmtpClient(Value: Boolean);
    function  GetMailAsSmtpClient: Boolean;
    procedure SetMailViaMapi(Value: Boolean);
    function  GetMailViaMapi: Boolean;
    procedure SetMailViaMailTo(Value: Boolean);
    function  GetMailViaMailTo: Boolean;
    procedure SetMailFrom(Value: ShortString);
    function  GetMailFrom: ShortString;
    procedure SetSmtpServer(Value: ShortString);
    function  GetSmtpServer: ShortString;
    procedure SetSmtpPort(Value: Dword);
    function  GetSmtpPort: Dword;
    procedure SetSmtpAccount(Value: ShortString);
    function  GetSmtpAccount: ShortString;
    procedure SetSmtpPassword(Value: ShortString);
    function  GetSmtpPassword: ShortString;
    procedure SetMailSuccessMsg(Value: ShortString);
    function  GetMailSuccessMsg: ShortString;
    procedure SetMailFailureMsg(Value: ShortString);
    function  GetMailFailureMsg: ShortString;
    procedure SetTitleBar(Value: ShortString);
    function  GetTtleBar: ShortString;
    procedure SetExceptMsg(Value: ShortString);
    function  GetExceptMsg: ShortString;
    procedure SetFrozenMsg(Value: ShortString);
    function  GetFrozenMsg: ShortString;

    procedure btnOKClick(Sender: TObject);
    procedure btnDiscardClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnBrowseClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure btnUpClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure sgFavouriteFilesKeyPress(Sender: TObject; var Key: Char);
    procedure btnRevertClick(Sender: TObject);
  private
    { Private declarations }
    FOrgTransponderFile      : string;
    FOrgFavouriteFiles       : array[0..99] of string;
    FOrgFavouriteDescriptions: array[0..99] of string;
    FOrgRowCount             : Integer;
    FExitCallback            : TNotifyEvent;
    FAccepted                : Boolean;
    procedure Revert;
    function  GetSettingChanged: Boolean;
  public
    { Public declarations }
    property TransponderFile                     : string       read GetTransponderFile      write SetTransponderFile;
    property FavouriteFile       [Index: Integer]: string       read GetFavouriteFile        write SetfavouriteFile;
    property FavouriteDescription[Index: Integer]: string       read GetFavouriteDescription write SetfavouriteDescription;
    property ExitNotify                          : TNotifyEvent read FExitCallback           write FExitCallback;
    property SettingChanged                      : Boolean      read GetSettingChanged;
    property Accepted                            : Boolean      read FAccepted;
  end;


implementation

{$R *.DFM}


{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>  True if a setting has changed

  Descript: Get flag if a setting has changed
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmSetupExceptions.GetSettingChanged: Boolean;
var
  Loop: Integer;
begin
  Result := False;
  Result := Result or (FOrgTransponderFile <> edtTransponderFile.Text);
  Result := Result or (FOrgRowCount <> sgFavouriteFiles.RowCount);
  if sgFavouriteFiles.RowCount > 0 then
    for Loop := 1 to sgFavouriteFiles.RowCount-1 do
    begin
      Result := Result or (FOrgFavouriteFiles[Loop-1]        <> sgFavouriteFiles.Cells[1, Loop]);
      Result := Result or (FOrgFavouriteDescriptions[Loop-1] <> sgFavouriteFiles.Cells[2, Loop]);
    end;
end;


procedure TfrmSetupExceptions.SetTransponderFile(Value: string);
begin
  FOrgTransponderFile     := Value;
  edtTransponderFile.Text := Value;
end;


function TfrmSetupExceptions.GetTransponderFile: string;
begin
  Result := edtTransponderFile.Text;
end;


procedure TfrmSetupExceptions.SetFavouriteFile(Index: Integer; Value: string);
begin
  if (Index < Low(FOrgFavouriteFiles)) or (Index > High(FOrgfavouriteFiles)) then
    Exit;
  FOrgFavouriteFiles[Index] := Value;
  if Index >= (sgFavouriteFiles.RowCount - 2) then
  begin
    sgFavouriteFiles.RowCount := Index + 3;
    FOrgRowCOunt := sgFavouriteFiles.RowCount;
  end;
  sgFavouriteFiles.Cells[1, Index + 1] := Value;
  sgFavouriteFiles.Cells[0, Index + 1] := format('%2.2d', [Index + 1]);
  sgFavouriteFiles.Cells[0, Index + 2] := format('%2.2d', [Index + 2]);
end;


function TfrmSetupExceptions.GetFavouriteFile(Index: Integer): string;
begin
  if (Index < Low(FOrgFavouriteFiles)) or (Index > High(FOrgFavouriteFiles)) then
    Exit;
  if (Index >= (sgFavouriteFiles.RowCount - 1)) then
    Result := ''
  else
    Result := sgFavouriteFiles.Cells[1, Index+1];
end;


procedure TfrmSetupExceptions.SetFavouriteDescription(Index: Integer; Value: string);
begin
  if (Index < Low(FOrgFavouriteFiles)) or (Index > High(FOrgFavouriteFiles)) then
    Exit;
  FOrgFavouriteDescriptions[Index] := Value;
  if Index >= (sgFavouriteFiles.RowCount - 2) then
  begin
    sgFavouriteFiles.RowCount := Index + 3;
    FOrgRowCount := sgFavouriteFiles.RowCount;
  end;
  sgFavouriteFiles.Cells[2, Index + 1] := Value;
  sgFavouriteFiles.Cells[0, Index + 1] := format('%2.2d', [Index + 1]);
  sgFavouriteFiles.Cells[0, Index + 2] := format('%2.2d', [Index + 2]);
end;


function TfrmSetupExceptions.GetFavouriteDescription(Index: Integer): string;
begin
  Result := '';
  if (Index < Low(FOrgFavouriteDescriptions)) or (Index > High(FOrgFavouriteDescriptions)) then
    Exit;
  if (Index >= (sgFavouriteFiles.RowCount - 1)) then
    Exit
  else
    Result := sgFavouriteFiles.Cells[2, Index+1];
end;


procedure TfrmSetupExceptions.Revert;
var
  High1 : Integer;
  High2 : Integer;
  Loop  : Integer;
begin
  edtTransponderFile.Text := FOrgTransponderFile;
  // Find highest entry
  High1 := High(FOrgFavouriteFiles);
  while (High1 >= Low(FOrgFavouriteFiles)) and (FOrgFavouriteFiles[High1] = '') do
    Dec(High1);
  High2 := High(FOrgFavouriteDescriptions);
  while (High2 >= Low(FOrgFavouriteDescriptions)) and (FOrgFavouriteDescriptions[High2] = '') do
    Dec(High2);
  if High1 > High2 then
    sgFavouriteFiles.RowCount := High1 + 3
  else
    sgFavouriteFiles.RowCount := High2 + 3;
  for Loop := 1 to sgFavouriteFiles.RowCount-1 do
  begin
    sgFavouriteFiles.Cells[1, Loop] := FOrgFavouriteFiles[Loop-1];
    sgFavouriteFiles.Cells[2, Loop] := FOrgFavouriteDescriptions[Loop-1];
    sgFavouriteFiles.Cells[0, Loop] := format('%2.2d', [Loop]);
    sgFavouriteFiles.Cells[0, Loop + 1] := format('%2.2d', [Loop + 1]);
  end;
end;


procedure TfrmSetupExceptions.FormCreate(Sender: TObject);
var
  Loop: Integer;
begin
  @FExitCallback          := nil;
  FAccepted               := False;
  FOrgTransponderFile     := '';
  FOrgRowCount            := 0;
  edtTransponderFile.Text := FOrgTransponderFile;
  for Loop := Low(FOrgFavouriteFiles) to High(FOrgFavouriteFiles) do
    FOrgFavouriteFiles[Loop] := '';
  for Loop := Low(FOrgFavouriteDescriptions) to High(FOrgFavouriteDescriptions) do
    FOrgFavouriteDescriptions[Loop] := '';
  sgFavouriteFiles.ColWidths[0] := 20;
  sgFavouriteFiles.ColWidths[1] := 128;
  sgFavouriteFiles.ColWidths[2] := 296;
  sgFavouriteFiles.Cells[1, 0] := 'File';
  sgFavouriteFiles.Cells[2, 0] := 'Description';
  sgFavouriteFiles.Cells[0, 1] := format('%2.2d', [1]);
end;


procedure TfrmSetupExceptions.btnBrowseClick(Sender: TObject);
var
  Browser: TOpenDialog;
begin
  Browser := TOpenDialog.Create(Self);
  try
    Browser.Options := [];
    if Browser.Execute then
    begin
      edtTransponderFile.Text := Browser.FileName;
    end;
  finally
    Browser.Free;
  end;
end;


procedure TfrmSetupExceptions.btnAddClick(Sender: TObject);
var
  Browser: TOpenDialog;
begin
  Browser := TOpenDialog.Create(Self);
  try
    Browser.Options := [];
    if Browser.Execute then
    begin
      sgFavouriteFiles.RowCount := sgFavouriteFiles.RowCount + 1;
      sgFavouriteFiles.Cells[1, sgFavouriteFiles.RowCount - 2] := Browser.FileName;
      sgFavouriteFiles.Cells[0, sgFavouriteFiles.RowCount - 1] := format('%2.2d', [sgFavouriteFiles.RowCount - 1]);
      sgFavouriteFiles.Cells[1, sgFavouriteFiles.RowCount - 1] := '';
      sgFavouriteFiles.Cells[2, sgFavouriteFiles.RowCount - 1] := '';
    end;
  finally
    Browser.Free;
  end;
end;


procedure TfrmSetupExceptions.btnRemoveClick(Sender: TObject);
var
  Loop: Integer;
begin
  if sgFavouriteFiles.RowCount <= 2 then
    Exit;
  if sgFavouriteFiles.Row >= (sgFavouriteFiles.RowCount-1) then
    Exit;
  for Loop := sgFavouriteFiles.Row+1 to sgFavouriteFiles.RowCount-1 do
  begin
    sgFavouriteFiles.Cells[1, Loop-1] := sgFavouriteFiles.Cells[1, Loop];
    sgFavouriteFiles.Cells[2, Loop-1] := sgFavouriteFiles.Cells[2, Loop];
  end;
  sgFavouriteFiles.RowCount := sgFavouriteFiles.RowCount - 1;
  sgFavouriteFiles.Cells[1, sgFavouriteFiles.RowCount - 1] := '';
  sgFavouriteFiles.Cells[2, sgFavouriteFiles.RowCount - 1] := '';
  sgFavouriteFiles.Cells[0, sgFavouriteFiles.RowCount - 1] := format('%2.2d', [sgFavouriteFiles.RowCount - 1]);
  if sgFavouriteFiles.Row > 1 then
    sgFavouriteFiles.Row := sgFavouriteFiles.Row - 1;
end;


procedure TfrmSetupExceptions.btnUpClick(Sender: TObject);
var
  TempString: string;
begin
  if sgFavouriteFiles.Row < 2 then
    Exit;
  if sgFavouriteFiles.Row >= (sgFavouriteFiles.RowCount-1) then
    Exit;
  TempString := sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row-1];
  sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row-1] := sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row];
  sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row]   := TempString;
  TempString := sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row-1];
  sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row-1] := sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row];
  sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row]   := TempString;
  sgFavouriteFiles.Row := sgFavouriteFiles.Row - 1;
end;


procedure TfrmSetupExceptions.btnDownClick(Sender: TObject);
var
  TempString: string;
begin
  if sgFavouriteFiles.Row >= (sgFavouriteFiles.RowCount-2) then
    Exit;
  TempString := sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row+1];
  sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row+1] := sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row];
  sgFavouriteFiles.Cells[1, sgFavouriteFiles.Row]   := TempString;
  TempString := sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row+1];
  sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row+1] := sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row];
  sgFavouriteFiles.Cells[2, sgFavouriteFiles.Row]   := TempString;
  sgFavouriteFiles.Row := sgFavouriteFiles.Row + 1;
end;


procedure TfrmSetupExceptions.sgFavouriteFilesKeyPress(Sender: TObject;
  var Key: Char);
begin
  if sgFavouriteFiles.Row >= (sgFavouriteFiles.RowCount - 1) then
    sgFavouriteFiles.RowCount := sgFavouriteFiles.RowCount + 1;
  sgFavouriteFiles.Cells[1, sgFavouriteFiles.RowCount - 1] := '';
  sgFavouriteFiles.Cells[2, sgFavouriteFiles.RowCount - 1] := '';
  sgFavouriteFiles.Cells[0, sgFavouriteFiles.RowCount - 1] := format('%2.2d', [sgFavouriteFiles.RowCount - 1]);
end;


procedure TfrmSetupExceptions.btnRevertClick(Sender: TObject);
begin
  Revert;
end;


procedure TfrmSetupExceptions.btnOKClick(Sender: TObject);
begin
  FAccepted := True;
  Hide;
  Refresh;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupExceptions.btnDiscardClick(Sender: TObject);
begin
  Hide;
  Refresh;
  Revert;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupExceptions.FormDestroy(Sender: TObject);
begin
  btnDiscardClick(nil);
  @FExitCallback := nil;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Initialize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Initialize;
begin
  //
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Finalize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Finalize;
begin
  //
end;


initialization
  Initialize;


finalization
  Finalize;

end.

