unit UCSAEmu_2;

interface uses SysUtils, windows;

type
  PKBarray = ^TKBarray;
  TKBarray = array[1..56] of cardinal;

  PBlock = ^TBlock;
  TBlock = array[1..8] of byte; {optimization}

  TKey = record
    Complete: Boolean;
    odd_kk, even_kk: TKBArray;
    odd_ck, even_ck: TBlock;
  end;
var CsaKey: TKey;
  gCK: PBlock;
  gKK: PKBarray;

procedure SetKey(Oddkey, evenKey: TBlock);
procedure DecryptTS(data: PByteArray);

implementation

const CKbPerm: array[0..63] of byte = (18, 36, 9, 7, 42, 49, 29, 21, 28, 54, 62, 50, 19, 33, 59, 64, 24, 20, 37, 39, 2, 53, 27, 1, 34, 4,
    13, 14, 57, 40, 26, 41, 51, 35, 52, 12, 22, 48, 30, 58, 45, 31, 8, 25, 23, 47, 61, 17, 60, 5, 56,
    43, 11, 6, 10, 44, 32, 63, 46, 15, 3, 38, 16, 55);
  BCPerm: array[0..255] of byte = ($00, $02, $80, $82, $20, $22, $A0, $A2, $10, $12, $90, $92, $30, $32, $B0, $B2, $04, $06, $84,
    $86, $24, $26, $A4, $A6, $14, $16, $94, $96, $34, $36, $B4, $B6, $40, $42, $C0, $C2, $60,
    $62, $E0, $E2, $50, $52, $D0, $D2, $70, $72, $F0, $F2, $44, $46, $C4, $C6, $64, $66, $E4,
    $E6, $54, $56, $D4, $D6, $74, $76, $F4, $F6, $1, $3, $81, $83, $21, $23, $A1, $A3, $11, $13,
    $91, $93, $31, $33, $B1, $B3, $5, $7, $85, $87, $25, $27, $A5, $A7, $15, $17, $95, $97, $35,
    $37, $B5, $B7, $41, $43, $C1, $C3, $61, $63, $E1, $E3, $51, $53, $D1, $D3, $71, $73, $F1,
    $F3, $45, $47, $C5, $C7, $65, $67, $E5, $E7, $55, $57, $D5, $D7, $75, $77, $F5, $F7, $8, $A,
    $88, $8A, $28, $2A, $A8, $AA, $18, $1A, $98, $9A, $38, $3A, $B8, $BA, $C, $E, $8C, $8E, $2C,
    $2E, $AC, $AE, $1C, $1E, $9C, $9E, $3C, $3E, $BC, $BE, $48, $4A, $C8, $CA, $68, $6A, $E8,
    $EA, $58, $5A, $D8, $DA, $78, $7A, $F8, $FA, $4C, $4E, $CC, $CE, $6C, $6E, $EC, $EE, $5C,
    $5E, $DC, $DE, $7C, $7E, $FC, $FE, $9, $B, $89, $8B, $29, $2B, $A9, $AB, $19, $1B, $99, $9B,
    $39, $3B, $B9, $BB, $D, $F, $8D, $8F, $2D, $2F, $AD, $AF, $1D, $1F, $9D, $9F, $3D, $3F, $BD,
    $BF, $49, $4B, $C9, $CB, $69, $6B, $E9, $EB, $59, $5B, $D9, $DB, $79, $7B, $F9, $FB, $4D, $4F,
    $CD, $CF, $6D, $6F, $ED, $EF, $5D, $5F, $DD, $DF, $7D, $7F, $FD, $FF);
  BCSbox: array[0..255] of byte = ($3A, $EA, $68, $FE, $33, $E9, $88, $1A, $83, $CF, $E1, $7F, $BA, $E2, $38, $12, $E8, $27, $61, $95, $0C,
    $36, $E5, $70, $A2, $06, $82, $7C, $17, $A3, $26, $49, $BE, $7A, $6D, $47, $C1, $51, $8F, $F3, $CC, $5B,
    $67, $BD, $CD, $18, $08, $C9, $FF, $69, $EF, $03, $4E, $48, $4A, $84, $3F, $B4, $10, $04, $DC, $F5, $5C,
    $C6, $16, $AB, $AC, $4C, $F1, $6A, $2F, $3C, $3B, $D4, $D5, $94, $D0, $C4, $63, $62, $71, $A1, $F9, $4F,
    $2E, $AA, $C5, $56, $E3, $39, $93, $CE, $65, $64, $E4, $58, $6C, $19, $42, $79, $DD, $EE, $96, $F6, $8A,
    $EC, $1E, $85, $53, $45, $DE, $BB, $7E, $0A, $9A, $13, $2A, $9D, $C2, $5E, $5A, $1F, $32, $35, $9C, $A8,
    $73, $30, $29, $3D, $E7, $92, $87, $1B, $2B, $4B, $A5, $57, $97, $40, $15, $E6, $BC, $0E, $EB, $C3, $34,
    $2D, $B8, $44, $25, $A4, $1C, $C7, $23, $ED, $90, $6E, $50, $00, $99, $9E, $4D, $D9, $DA, $8D, $6F, $5F,
    $3E, $D7, $21, $74, $86, $DF, $6B, $05, $8E, $5D, $37, $11, $D2, $28, $75, $D6, $A7, $77, $24, $BF, $F0,
    $B0, $02, $B7, $F8, $FC, $81, $09, $B1, $01, $76, $91, $7D, $0F, $C8, $A0, $F2, $CB, $78, $60, $D1, $F7,
    $E0, $B5, $98, $22, $B3, $20, $1D, $A6, $DB, $7B, $59, $9F, $AE, $31, $FB, $D3, $B6, $CA, $43, $72, $07,
    $F4, $D8, $41, $14, $55, $0D, $54, $8B, $B9, $AD, $46, $0B, $AF, $80, $52, $2C, $FA, $8C, $89, $66, $FD,
    $B2, $A9, $9B, $C0);
  BitValueTable: array[0..7] of byte = ($80, $40, $20, $10, $08, $04, $02, $01);
type TSbox = array[0..31] of cardinal;
const
  SBox1a: array[0..31] of byte = (0, 0, 4, 4, 0, 4, 4, 0, 4, 0, 0, 0, 4, 4, 0, 4, 0, 4, 4, 0, 0, 0, 4, 4, 0, 0, 0, 4, 4, 4, 4, 0);
  SBox1b: array[0..31] of byte = (1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0);

  SBox2a: array[0..31] of byte = (8, 8, 0, 0, 0, 8, 8, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 8, 8, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 8);
  SBox2b: array[0..31] of byte = (2, 0, 0, 2, 2, 2, 2, 0, 0, 2, 2, 0, 0, 0, 0, 2, 2, 0, 0, 2, 2, 2, 0, 2, 0, 0, 0, 2, 2, 0, 2, 0);

  SBox3a: array[0..31] of byte = (0, 0, 4, 0, 0, 4, 4, 4, 4, 4, 0, 4, 4, 0, 0, 0, 4, 4, 0, 4, 4, 0, 0, 0, 0, 0, 4, 0, 0, 4, 4, 4);
  SBox3b: array[0..31] of byte = (1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0);

  Sbox4a: array[0..31] of byte = (8, 8, 0, 8, 0, 0, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 8, 0, 8, 8, 0, 8, 0, 8, 0, 8, 0, 0, 8, 0, 0, 8);
  Sbox4b: array[0..31] of byte = (2, 0, 2, 2, 0, 2, 0, 2, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 2, 0, 2, 2, 0, 2, 0, 2, 2, 0, 0, 2, 2, 0);

  SBox5a: array[0..31] of byte = (0, 0, 0, 4, 4, 0, 4, 0, 0, 4, 4, 4, 4, 0, 0, 4, 0, 4, 0, 0, 0, 4, 4, 4, 4, 0, 4, 0, 4, 4, 0, 0);
  SBox5b: array[0..31] of byte = (1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1);

  SBox6a: array[0..31] of byte = (0, 8, 0, 8, 8, 0, 0, 0, 0, 8, 8, 0, 0, 8, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 8, 8, 0, 0, 8, 8, 0);
  SBox6b: array[0..31] of byte = (0, 0, 2, 2, 0, 2, 2, 0, 0, 0, 2, 0, 2, 2, 0, 2, 2, 2, 0, 2, 2, 0, 0, 0, 2, 0, 0, 2, 0, 2, 2, 0);

  SBox7a: array[0..31] of byte = (0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0);
  SBox7b: array[0..31] of byte = (0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1);

// --- block cypher ------------------------------------------------------------
var
  A, B: array[0..10] of cardinal;
  next_A1: cardinal absolute A[0];
  next_B1: cardinal absolute B[0];
  X, Y, Z, D, E, F, p, q, r: cardinal;

procedure ResetStreamcipher(CK: TBlock); stdcall;
var i: integer;
begin

  for i := 0 to 3 do
  begin
    A[i * 2 + 1] := (gCK[i + 1] and 240) shr 4;
    A[i * 2 + 2] := (gCK[i + 1] and 15);
    B[i * 2 + 1] := (gCK[i + 5] and 240) shr 4;
    B[i * 2 + 2] := (gCK[i + 5] and 15);
  end;
  asm
    xor eax,eax;
    mov X,eax;
    mov Y,eax;
    mov Z,eax;
    mov D,eax;
    mov E,eax;
    mov F,eax;
    mov p,eax;
    mov q,eax;
    mov r,eax;
    mov [offset A+9*4],eax; // mov A[9],eax
    mov [offset A+10*4],eax; // mov A[10],eax
    mov [offset B+9*4],eax; // mov B[9],eax
    mov [offset B+10*4],eax; // mov B[10],eax
  end;
end;

procedure InitStreamcipher(ScrambledBlock1: TBlock); stdcall;
var MNibble, LNibble: Cardinal;
  step, i: Cardinal;
  Dold, Buffer: Cardinal;
begin
  for step := 0 to 31 do
  begin
    MNibble := (ScrambledBlock1[(step shr 2) + 1] and 240) shr 4;
    LNibble := ScrambledBlock1[(step shr 2) + 1] and 15;

    // T3
    // 'Buffer' used for Nibble derived from B
    Buffer := ((B[9] shr 2) xor (B[6] shr 3) xor (B[3] shr 1) xor B[8]) and 1;
    Buffer := Buffer or ((B[5] shr 2) xor (B[8] shr 1) xor (B[4] shl 1) xor B[5]) and 2;
    Buffer := Buffer or ((B[6] shl 2) xor (B[8] shl 1) xor (B[3] shr 1) xor B[4]) and 4;
    Buffer := Buffer or ((B[3] shl 3) xor (B[6] shl 2) xor (B[7] shl 1) xor B[9]) and 8;

    Dold := D;
    D := Buffer xor E xor Z;

    // T4
    Buffer := E;
    E := F;
    if q = 0 then
      F := Buffer
    else
    begin
      F := Buffer + Z + r;
      r := (F and 16) shr 4;
      F := F and 15;
    end;

    // T1
    if (step and 1) = 0 then
      Buffer := A[10] xor X xor Dold xor Mnibble
    else
      Buffer := A[10] xor X xor Dold xor Lnibble;

    for i := 10 downto 2 do
      A[i] := A[i - 1];
    A[1] := Buffer;

    // T2
    if (step and 1) = 0 then
      Buffer := Lnibble xor Y xor B[7] xor B[10]
    else
      Buffer := Mnibble xor Y xor B[7] xor B[10];

    if p = 1 then
      Buffer := ((Buffer and 7) shl 1) or ((Buffer and 8) shr 3);

    for i := 10 downto 2 do
      B[i] := B[i - 1];
    B[1] := Buffer;


    Buffer := ((A[5] and 1) shl 4) or ((A[2] and 4) shl 1) or ((A[7] and 2) shl 1) or ((A[8] and 8) shr 2) or (A[10] and 1);
    Z := Sbox1a[Buffer];
    X := Sbox1b[Buffer];

    Buffer := ((A[3] and 2) shl 3) or ((A[4] and 4) shl 1) or ((A[7] and 8) shr 1) or ((A[8] and 1) shl 1) or ((A[10] and 2) shr 1);
    Z := Z or Sbox2a[Buffer];
    X := X or Sbox2b[Buffer];

    Buffer := ((A[2] and 8) shl 1) or ((A[3] and 1) shl 3) or ((A[6] and 2) shl 1) or ((A[6] and 8) shr 2) or ((A[7] and 4) shr 2);
    X := X or Sbox3a[Buffer];
    Y := Sbox3b[Buffer];

    Buffer := ((A[4] and 8) shl 1) or ((A[2] and 2) shl 2) or ((A[3] and 8) shr 1) or ((A[5] and 4) shr 1) or (A[9] and 1);
    X := X or Sbox4a[Buffer];
    Y := Y or Sbox4b[Buffer];

    Buffer := ((A[6] and 4) shl 2) or (A[5] and 8) or ((A[7] and 1) shl 2) or (A[9] and 2) or ((A[10] and 4) shr 2);
    Y := Y or Sbox5a[Buffer];
    Z := Z or Sbox5b[Buffer];

    Buffer := ((A[4] and 2) shl 3) or ((A[5] and 2) shl 2) or ((A[6] and 1) shl 2) or ((A[8] and 4) shr 1) or ((A[10] and 8) shr 3);
    Y := Y or Sbox6a[Buffer];
    Z := Z or Sbox6b[Buffer];

    Buffer := ((A[3] and 4) shl 2) or ((A[4] and 1) shl 3) or ((A[8] and 2) shl 1) or ((A[9] and 4) shr 1) or ((A[9] and 8) shr 3);
    q := Sbox7a[Buffer];
    p := Sbox7b[Buffer];

  end;

end;

function GenerateStreamcipher: Cardinal; stdcall;
var step, i, SCResult: Cardinal;
  Buffer: Cardinal;
begin
  SCResult := 0;
  for step := 0 to 3 do
  begin
    // T3
    // 'Buffer' used for Nibble derived from B
    Buffer := ((B[9] shr 2) xor (B[6] shr 3) xor (B[3] shr 1) xor B[8]) and 1;
    Buffer := Buffer or ((B[5] shr 2) xor (B[8] shr 1) xor (B[4] shl 1) xor B[5]) and 2;
    Buffer := Buffer or ((B[6] shl 2) xor (B[8] shl 1) xor (B[3] shr 1) xor B[4]) and 4;
    Buffer := Buffer or ((B[3] shl 3) xor (B[6] shl 2) xor (B[7] shl 1) xor B[9]) and 8;

    D := Buffer xor E xor Z;
    Buffer := ((D xor (D shr 1)) and 1) or ((((D shr 1) xor D) shr 1) and 2);
    SCResult := Buffer or (SCResult shl 2); //put new 2 Bits into Result for building a byte

  // T4
    Buffer := E;
    E := F;
    if q = 0 then
      F := Buffer
    else
    begin
      F := Buffer + Z + r;
      r := (F and 16) shr 4;
      F := F and 15;
    end;

    // T1
    Buffer := A[10] xor X;
    for i := 10 downto 2 do
      A[i] := A[i - 1];
    A[1] := Buffer;

    // T2
    Buffer := Y xor B[7] xor B[10];
    if p = 1 then
      Buffer := ((Buffer and 7) shl 1) or ((Buffer and 8) shr 3);

    for i := 10 downto 2 do
      B[i] := B[i - 1];
    B[1] := Buffer;

    Buffer := ((A[5] and 1) shl 4) or ((A[2] and 4) shl 1) or ((A[7] and 2) shl 1) or ((A[8] and 8) shr 2) or (A[10] and 1);
    Z := Sbox1a[Buffer];
    X := Sbox1b[Buffer];

    Buffer := ((A[3] and 2) shl 3) or ((A[4] and 4) shl 1) or ((A[7] and 8) shr 1) or ((A[8] and 1) shl 1) or ((A[10] and 2) shr 1);
    Z := Z or Sbox2a[Buffer];
    X := X or Sbox2b[Buffer];

    Buffer := ((A[2] and 8) shl 1) or ((A[3] and 1) shl 3) or ((A[6] and 2) shl 1) or ((A[6] and 8) shr 2) or ((A[7] and 4) shr 2);
    X := X or Sbox3a[Buffer];
    Y := Sbox3b[Buffer];

    Buffer := ((A[4] and 8) shl 1) or ((A[2] and 2) shl 2) or ((A[3] and 8) shr 1) or ((A[5] and 4) shr 1) or (A[9] and 1);
    X := X or Sbox4a[Buffer];
    Y := Y or Sbox4b[Buffer];

    Buffer := ((A[6] and 4) shl 2) or (A[5] and 8) or ((A[7] and 1) shl 2) or (A[9] and 2) or ((A[10] and 4) shr 2);
    Y := Y or Sbox5a[Buffer];
    Z := Z or Sbox5b[Buffer];

    Buffer := ((A[4] and 2) shl 3) or ((A[5] and 2) shl 2) or ((A[6] and 1) shl 2) or ((A[8] and 4) shr 1) or ((A[10] and 8) shr 3);
    Y := Y or Sbox6a[Buffer];
    Z := Z or Sbox6b[Buffer];

    Buffer := ((A[3] and 4) shl 2) or ((A[4] and 1) shl 3) or ((A[8] and 2) shl 1) or ((A[9] and 4) shr 1) or ((A[9] and 8) shr 3);
    q := Sbox7a[Buffer];
    p := Sbox7b[Buffer];

  end;
  result := SCResult;
end;

function PermuteCK(CK: TBlock): TBlock;
var CKBuffer: TBlock;
  i, j, PermBit: byte;
begin
  ZeroMemory(@CKBuffer, sizeof(TBlock));
  for i := 0 to 63 do
  begin
    j := i and 7; //j = Position of Bit in KeyByte
    PermBit := CKbPerm[i]; //Permbit = New (permuted) Position of current Bit
    Dec(PermBit, 1);
    j := BitValueTable[j];
    if (CK[(i shr 3) + 1] and j) = j then //It's only neccecary to permute if current Bit is set
    begin
      j := PermBit shr 3; //j = Byte to change in new KeyByte
      PermBit := PermBit and 7; //PermBit = Position of Bit in new KeyByte
      PermBit := BitValueTable[PermBit];
      CKBuffer[j + 1] := CKBuffer[j + 1] or PermBit;
    end;
  end;
  PermuteCK := CKBuffer;
end;



procedure key_schedule(CK: TBlock; var KK: TKBArray);
var i, j: integer;
begin
  j := 48;
  repeat
    for i := 1 to 8 do KK[j + i] := CK[i];
    CK := PermuteCK(CK); //permute CK for next round
    dec(j, 8);
  until j < 0;
end;

procedure block_decypher(ib: TBlock; var bd: TBlock);
var r8buf, SBout, SBin: Cardinal;
  r1, r2, r3, r4, r5, r6, r7, r8: cardinal;
  i: cardinal;
begin
  r1 := ib[1]; r2 := ib[2]; r3 := ib[3]; r4 := ib[4];
  r5 := ib[5]; r6 := ib[6]; r7 := ib[7]; r8 := ib[8];
  for i := 55 downto 0 do
  begin
    SBin := gkk[i + 1] xor (i shr 3) xor R7;
    SBout := BCSBox[SBin];
    r8buf := SBout xor R8;
    R8 := R7;
    R7 := R6 xor BCPerm[SBout];
    R6 := R5;
    R5 := R4 xor r8buf;
    R4 := R3 xor r8buf;
    R3 := R2 xor r8buf;
    R2 := R1;
    R1 := R8buf;
  end;
  bd[1] := r1; bd[2] := r2; bd[3] := r3; bd[4] := r4;
  bd[5] := r5; bd[6] := r6; bd[7] := r7; bd[8] := r8;
end;


procedure SetKey(oddkey, evenkey: TBlock);
begin
  csaKey.Complete := true;
  csakey.odd_ck := oddkey;
  csaKey.even_ck := evenKey;
  key_schedule(csakey.odd_ck, csakey.odd_kk);
  key_schedule(csakey.even_ck, csakey.even_kk);
end;

procedure DecryptTS(data: PByteArray);
var i, j, k, offset, N: cardinal;
  ib, block: TBlock;
  residue: cardinal;
begin
  if not csakey.complete then exit;
  offset := 4;

  if (data[3] and $40 > 0) then begin // ODD
    gKK := @csakey.odd_kk;
    gCK := @csakey.odd_ck;
  end else begin // EVEN
    gKK := @csakey.even_kk;
    gCK := @csakey.even_ck;
  end;

  data[3] := data[3] and $3F; (* remove scrambling bits *)

  if ((data[3] and $20) = $20) then begin
    offset := offset + data[4] + 1; (* skip adaption field *)
    N := (188 - offset) div 8;
    residue := (188 - offset) mod 8;
  end else begin (* no adaption field *)
    N := 23;
    residue := 0;
  end;
    // 1st 8 bytes of initialisation

  if N = 0 then exit;

  ResetStreamcipher(gCK^);
    // 8 bytes per operation
  move(Data[offset], ib, sizeof(ib)); // Load first 8 Byte
  initStreamCipher(ib);

  for j := 1 to N do begin
    block_decypher(ib, block); // -> Calc Block
    if (j <> N) then begin
      k := (j - 1) shl 3;
      for i := 0 to 7 do begin
        ib[i + 1] := data[8 + offset + k + i] xor GenerateStreamCipher;
        data[offset + k + i] := ib[i + 1] xor block[i + 1]; // <- Block
      end;
    end
    else begin
      k := (j - 1) shl 3;
      for i := 0 to 7 do data[offset + k + i] := block[i + 1]; // <- Block
    end;

  end;

  if residue > 0 then begin
    for i := 0 to residue - 1 do
      data[188 - residue + i] := data[188 - residue + i] xor GenerateStreamCipher;
  end;
end;

procedure _DecryptTS(data: PByteArray);
var i, j, offset: cardinal;
  ib, block: TBlock;
  residue: cardinal;
begin
  if not csakey.complete then exit;
  if (data[3] and $40 > 0) then begin // ODD
    gKK := @csakey.odd_kk;
    gCK := @csakey.odd_ck;
  end else begin // EVEN
    gKK := @csakey.even_kk;
    gCK := @csakey.even_ck;
  end;

  data[3] := data[3] and $3F; (* remove scrambling bits *)

  if ((data[3] and $20) = $20) then offset := 5 + data[4] else offset := 4;

  ResetStreamcipher(gCK^);
    // 8 bytes per operation
  move(Data[offset], ib, sizeof(ib)); // Load first 8 Byte
  initStreamCipher(ib);
  j := offset;
  while j < 173 do begin
    block_decypher(ib, block); // -> Calc Block
    for i := 0 to 7 do begin
      ib[i + 1] := data[8 + j + i] xor GenerateStreamCipher;
      data[j + i] := ib[i + 1] xor block[i + 1]; // <- Block
    end;
    inc(j, 8);
  end;

  block_decypher(ib, block); // -> Calc Block
  for i := 0 to 7 do data[j + i] := block[i + 1]; // <- Block
  residue := (188 - offset) mod 8; //180-j;//
  if residue > 0 then begin
    for i := 0 to residue - 1 do
      data[188 - residue + i] := data[188 - residue + i] xor GenerateStreamCipher;
  end;
end;

end.

