{******************************************************************************}
{ FileName............: Saa7146aRegisters                                      }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Register/constant definitions for the SAA7146A                              }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20030812 - Initial release                                           }
{******************************************************************************}
{                                                                              }
{ Bugs/features in the SAA7146A:                                               }
{ - Endian Swapping (Revision 0,1,2)                                           }
{   The "two Byte swap" for the three video DMA channels does not work as      }
{   specified in the specs. The programming of the bits [1:0] of the video DMA }
{   control registers 0x10,0x28,0x40 has these impacts:                        }
{   00  no swap                                                                }
{   01  3210 => 1032                                                           }
{   01  3210 => 0123                                                           }
{ - Endian Swapping (Revision 3)                                               }
{   The "two Byte swap" for the Video DMA 2 channel does not work as specified }
{   in the specs. Additionally, the "two Byte swap" does not work for Video    }
{   DMA 3 when reading. The programming of the bits [1:0] of the video DMA     }
{   control registers 0x28 and 0x40 (only when reading, that means Bit[2] is   }
{   set) has these impacts:                                                    }
{   00  no swap                                                                }
{   01  3210 => 1032                                                           }
{   01  3210 => 0123                                                           }
{ - RPS "JUMP"-command (Revision 0,1,2)                                        }
{   When using the JUMP-Command in an RPS-program, the jump address gets       }
{   interpreted as an RPS-command(!), too. This can cause the most weird       }
{   side-effects, for example: if the address begins with 0x0..., the RPS sees }
{   a CLEAR_SIG-command and clears signals depending on the actual             }
{   jump-address.                                                              }
{ - RPS "STREG"-command (all revisions)                                        }
{   The RPS STREG-command writes wrong values to the target address, when      }
{   accessing registers not read from "shadow ram" or when accessing shadowed  }
{   registers located one address below registers not read from "shadow ram".  }
{   The affected registers are 0x7c,...,0x90 and 0xf8,...,0x148. Accessing     }
{   these registers using PCI-commands, however, is not affected.              }
{ - Starting a new RPS does not reset status bits (all revisions)              }
{   All RPS-specific bits in the PSR, SSR and ISR are not resetted when        }
{   starting a new RPS task. Once a RPS task has set one of these status bits, }
{   it will remain active until the next software or hardware reset.           }
{ **************************************************************************** }

unit Saa7146aRegisters;

interface
uses
  Windows;

const
  {------------------------------------------------------------------------------
    Descript: Register definitions for SAA7146A.
   -----------------------------------------------------------------------------}
  CSaa7146aBaseOdd1 = $00; // PCI base address for odd fields
  CSaa7146aBaseEven1 = $04; // PCI base address for even fields
  CSaa7146aProtAddr1 = $08; // Protection address
  CSaa7146aPitch1 = $0C; // Distance between consecutive lines
  CSaa7146aPage1 = $10; // Base address page table
  CSaa7146aNumLines1 = $14; // Number of lines per field
  CSaa7146aBaseOdd2 = $18; // PCI base address for odd fields
  CSaa7146aBaseEven2 = $1C; // PCI base address for even fields
  CSaa7146aProtAddr2 = $20; // Protection address
  CSaa7146aPitch2 = $24; // Distance between consecutive lines
  CSaa7146aPage2 = $28; // Base address page table
  CSaa7146aNumLines2 = $2C; // Number of lines per field
  CSaa7146aBaseOdd3 = $30; // PCI address for odd fields
  CSaa7146aBaseEven3 = $34; // PCI address for even fields
  CSaa7146aProtAddr3 = $38; // Protection address
  CSaa7146aPitch3 = $3C; // Distance between consecutive lines
  CSaa7146aPage3 = $40; // Base address page table
  CSaa7146aNumLines3 = $44; // Number of lines per field
  CSaa7146aPciBtV = $48; // PCI DEBI/video DMA channel
  CSaa7146aPciBtA = $4C; // PCI audio DMA channel
  CSaa7146aDd1Init = $50; // Initial setting dual D1 interface
  CSaa7146aDd1Data = $54; // Video data port handling
  CSaa7146aBrsCtrl = $58; // BRS control
  CSaa7146aHpsCtrl = $5C; // HPS control
  CSaa7146aHpsVs = $60; // HPS vertical scaling
  CSaa7146aHpsVsg = $64; // HPS gain
  CSaa7146aHpsHp = $68; // HPS horizontal prescaler
  CSaa7146aHpsHs = $6C; // HPS horizontal fine scale
  CSaa7146aBcsCtrl = $70; // BCS control
  CSaa7146aChroma = $74; // Chroma key range
  CSaa7146aHpsOut = $78; // HPS output and formats
  CSaa7146aDebiConfig = $7C; // DEBI config
  CSaa7146aDebiCommand = $80; // DEBI command
  CSaa7146aDebiPage = $84; // DEBI page
  CSaa7146aDebiAd = $88; // DEBI data input/output/DMA
  CSaa7146aI2cTrf = $8C; // I2C control
  CSaa7146aI2cSta = $90; // I2C status
  CSaa7146aBaseA1In = $94; // Base address audio input channel
  CSaa7146aProtA1In = $98; // Protection address
  CSaa7146aPageA1In = $9C; // Base address page table
  CSaa7146aBaseA1Out = $A0; // Base address audio output channel
  CSaa7146aProtA1Out = $A4; // Protection address
  CSaa7146aPageA1Out = $A8; // Base address page table
  CSaa7146aBaseA2In = $AC; // Base address audio input channel
  CSaa7146aProtA2In = $B0; // Protection address
  CSaa7146aPageA2In = $B4; // Base address page table
  CSaa7146aBaseA2Out = $B8; // Base address audio output channel
  CSaa7146aProtA2Out = $BC; // Protection address
  CSaa7146aPageA2Out = $C0; // Base address page table
  CSaa7146aRpsPage0 = $C4; // RPS 0 page
  CSaa7146aRpsPage1 = $C8; // RPS 1 page
  CSaa7146aRpsThresh0 = $CC; // HBI 0 threshold
  CSaa7146aRpsThresh1 = $D0; // HBI 1 threshold
  CSaa7146aRpsTov0 = $D4; // RPS 0 timeout value
  CSaa7146aRpsTov1 = $D8; // RPS 1 timeout value
  CSaa7146aIer = $DC; // Interrupt enable
  CSaa7146aGpioCtrl = $E0; // GPIO registers
  CSaa7146aEc1Ssr = $E4; // Event counter set 1 source select
  CSaa7146aEc2Ssr = $E8; // Event counter set 2 source select
  CSaa7146aEcT1R = $EC; // Event counter threshold set 1
  CSaa7146aEcT2R = $F0; // Event counter threshold set 2
  CSaa7146aAcon1 = $F4; // Audio configuration 1
  CSaa7146aAcon2 = $F8; // Audio configuration 2
  CSaa7146aMc1 = $FC; // Main control 1
  CSaa7146aMc2 = $100; // Main control 2
  CSaa7146aRpsAddr0 = $104; // RPS 0 address
  CSaa7146aRpsAddr1 = $108; // RPS 1 address
  CSaa7146aIsr = $10C; // Interrupt status
  CSaa7146aPsr = $110; // Primary status
  CSaa7146aSsr = $114; // Secondary status
  CSaa7146aEcr1 = $118; // Event counter set 1
  CSaa7146aEcr2 = $11C; // Event counter set 2
  CSaa7146aPciVdp1 = $120; // Logical video DMA pointer
  CSaa7146aPciVdp2 = $124; // Logical video DMA pointer
  CSaa7146aPciVdp3 = $128; // Logical video DMA pointer
  CSaa7146aPciAdp1 = $12C; // Logical audio DMA pointer
  CSaa7146aPciAdp2 = $130; // Logical audio DMA pointer
  CSaa7146aPciAdp3 = $134; // Logical audio DMA pointer
  CSaa7146aPciAdp4 = $138; // Logical audio DMA pointer
  CSaa7146aPciDdp = $13C; // Logical DEBI  DMA pointer
  CSaa7146aLevelReport = $140; // Level report
  CSaa7146aFbBuffer1 = $144; // Feedback buffer 1
  CSaa7146aFbBuffer2 = $148; // Feedback buffer 2
  CSaa7146aTsl100 = $180; // Time slot list 1
  CSaa7146aTsl101 = $184;
  CSaa7146aTsl102 = $188;
  CSaa7146aTsl103 = $18C;
  CSaa7146aTsl104 = $190;
  CSaa7146aTsl105 = $194;
  CSaa7146aTsl106 = $198;
  CSaa7146aTsl107 = $19C;
  CSaa7146aTsl108 = $1A0;
  CSaa7146aTsl109 = $1A4;
  CSaa7146aTsl110 = $1A8;
  CSaa7146aTsl111 = $1AC;
  CSaa7146aTsl112 = $1B0;
  CSaa7146aTsl113 = $1B4;
  CSaa7146aTsl114 = $1B8;
  CSaa7146aTsl115 = $1BC;
  CSaa7146aTsl200 = $1C0; // Time slot list 2
  CSaa7146aTsl201 = $1C4;
  CSaa7146aTsl202 = $1C8;
  CSaa7146aTsl203 = $1CC;
  CSaa7146aTsl204 = $1D0;
  CSaa7146aTsl205 = $1D4;
  CSaa7146aTsl206 = $1D8;
  CSaa7146aTsl207 = $1DC;
  CSaa7146aTsl208 = $1E0;
  CSaa7146aTsl209 = $1E4;
  CSaa7146aTsl210 = $1E8;
  CSaa7146aTsl211 = $1EC;
  CSaa7146aTsl212 = $1F0;
  CSaa7146aTsl213 = $1F4;
  CSaa7146aTsl214 = $1F8;
  CSaa7146aTsl215 = $1FC;

  {------------------------------------------------------------------------------
    Descript:  Interrupt sources <CSaa7146aIer>/<CSaa7146aIsr>
    Note    :  These indicate bit numbers, so typically you have to use
               '1 shl xxx' !!!
   -----------------------------------------------------------------------------}
  CSaa7146aIrqEc0S = $00; // Event counter 0 status interrupt
  CSaa7146aIrqEc3S = $01; // Event counter 3 status interrupt
  CSaa7146aIrqEcS = $02; // Event counter 1,2,4,5 status interrupt
  CSaa7146aIrqPin0 = $03; // GPIO pin 0 interrupt
  CSaa7146aIrqPin1 = $04; // GPIO pin 1 interrupt
  CSaa7146aIrqPin2 = $05; // GPIO pin 2 interrupt
  CSaa7146aIrqPin3 = $06; // GPIO pin 3 interrupt
  CSaa7146aIrqFidB = $07; // Field ID port B interrupt
  CSaa7146aIrqFidA = $08; // Field ID port A interrupt
  CSaa7146aIrqVfou = $09; // Video Fifo overflow/underflow interrupt
  CSaa7146aIrqVpE = $0A; // Video address protection error interrupt
  CSaa7146aIrqAfou = $0B; // Audio Fifo overflow/underflow interrupt
  CSaa7146aIrqA1out = $0C; // Audio output DMA1 protection interrupt
  CSaa7146aIrqA1in = $0D; // Audio input DMA1 protection interrupt
  CSaa7146aIrqA2out = $0E; // Audio output DMA2 protection interrupt
  CSaa7146aIrqA2in = $0F; // Audio input DMA2 protection interrupt
  CSaa7146aIrqI2cE = $10; // I2C error interrupt
  CSaa7146aIrqI2cS = $11; // I2C status interrupt
  CSaa7146aIrqDebiE = $12; // DEBI error interrupt
  CSaa7146aIrqDebiS = $13; // DEBI status interrupt
  CSaa7146aIrqUpld = $14; // DEBI upload interrupt
  CSaa7146aIrqRpsTo0 = $15; // RPS time out task 0 interrupt
  CSaa7146aIrqRpsTo1 = $16; // RPS time out task 1 interrupt
  CSaa7146aIrqRpsE0 = $17; // RPS task 0 error interrupt
  CSaa7146aIrqRpsE1 = $18; // RPS task 1 error interrupt
  CSaa7146aIrqRpsLate0 = $19; // RPS task 0 late interrupt
  CSaa7146aIrqRpsLate1 = $1A; // RPS task 1 late interrupt
  CSaa7146aIrqRpsI0 = $1B; // RPS task 0 interrupt
  CSaa7146aIrqRpsI1 = $1C; // RPS task 1 interrupt
  CSaa7146aIrqPped = $1D; // PCI parity error interrupt
  CSaa7146aIrqPabo = $1E; // PCI access error interrupt
  CSaa7146aIrqPpef = $1F; // PCI parity error interrupt

  {------------------------------------------------------------------------------
    Descript:  MC1 Master Control Register 1 constants
               $XXXX____ = mask
               $____XXXX = data
   -----------------------------------------------------------------------------}
  CSaa7146aMc1SoftReset = $80000000; // Invoke SAA7146A soft reset
  CSaa7146aMc1Rps1On = $20002000; // Enable RPS task 1
  CSaa7146aMc1Rps0On = $10001000; // Enable RPS task 0
  CSaa7146aMc1DebiEnable = $08000800; // Enable DEBI pins
  CSaa7146aMc1Dd1Enable = $04000400; // Enable real time video port pins (DD1)
  CSaa7146aMc1AudioEnable = $02000200; // Enable audio port pins
  CSaa7146aMc1I2cEnable = $01000100; // Enable I2C interface
  CSaa7146aMc1TrDebiEnable = $00800080; // Enable transfer DEBI
  CSaa7146aMc1TrVideo1Enable = $00400040; // Enable transfer video channel 1
  CSaa7146aMc1TrVideo2Enable = $00200020; // Enable transfer video channel 2
  CSaa7146aMc1TrVideo3Enable = $00100010; // Enable transfer video channel 3
  CSaa7146aMc1TrAudio2OutEnable = $00080008;
    // Enable transfer audio channel 2 out
  CSaa7146aMc1TrAudio2InEnable = $00040004; // Enable transfer audio channel 2 in
  CSaa7146aMc1TrAudio1OutEnable = $00020002;
    // Enable transfer audio channel 1 out
  CSaa7146aMc1TrAudio1InEnable = $00010001; // Enable transfer audio channel 1 in
  CSaa7146aMc1Rps1Off = $20000000; // Disable RPS task 1
  CSaa7146aMc1Rps0Off = $10000000; // Disable RPS task 0
  CSaa7146aMc1DebiDisable = $08000000; // Disable DEBI pins
  CSaa7146aMc1Dd1Disable = $04000000; // Disable real time video port pins (DD1)
  CSaa7146aMc1AudioDisable = $02000000; // Disable audio port pins
  CSaa7146aMc1I2cDisable = $01000000; // Disable I2C interface
  CSaa7146aMc1TrDebiDisable = $00800000; // Disable transfer DEBI
  CSaa7146aMc1TrVideo1Disable = $00400000; // Disable transfer video channel 1
  CSaa7146aMc1TrVideo2Disable = $00200000; // Disable transfer video channel 2
  CSaa7146aMc1TrVideo3Disable = $00100000; // Disable transfer video channel 3
  CSaa7146aMc1TrAudio2OutDisable = $00080000;
    // Disable transfer audio channel 2 out
  CSaa7146aMc1TrAudio2InDisable = $00040000;
    // Disable transfer audio channel 2 in
  CSaa7146aMc1TrAudio1OutDisable = $00020000;
    // Disable transfer audio channel 1 out
  CSaa7146aMc1TrAudio1InDisable = $00010000;
    // Disable transfer audio channel 1 in
  CSaa7146aMc1Shutdown = $3FFF0000; // Shut down all MC1-controlled enables
  CSaa7146aMc1TrVideo3Mask = $00000010; // Transfer enable video 3 mask
  CSaa7146aMc1Rps1Mask = $00002000; // RPS task 1 mask
  CSaa7146aMc1Rps0Mask = $00001000; // RPS task 0 mask

  {------------------------------------------------------------------------------
    Descript:  MC2 Master Control Register 2 constants
               $XXXX____ = mask
               $____XXXX = data
   -----------------------------------------------------------------------------}
  CSaa7146aMc2UpldDd1Initial = $06000600; // Upload DD1 initial settings
  CSaa7146aMc2UpldDd1B = $04000400; // Upload DD1 port B
  CSaa7146aMc2UpldDd1A = $02000200; // Upload DD1 port A
  CSaa7146aMc2UpldBrs = $01000100; // Upload BRS
  CSaa7146aMc2UpldHpsH = $00400040; // Upload HPS H
  CSaa7146aMc2UpldHpsV = $00200020; // Upload HPS V
  CSaa7146aMc2UpldDma3 = $00100010; // Upload DMA3 registers
  CSaa7146aMc2UpldDma2 = $00080008; // Upload DMA2 registers
  CSaa7146aMc2UpldDma1 = $00040004; // Upload DMA1 registers
  CSaa7146aMc2UpldDebi = $00020002; // Upload DEBI registers
  CSaa7146aMc2UpldI2c = $00010001; // Upload I2C registers

  CSaa7146aMc2RpsSig4On = $80008000; // Assert RPS_SIG4
  CSaa7146aMc2RpsSig3On = $40004000; // Assert RPS_SIG3
  CSaa7146aMc2RpsSig2On = $20002000; // Assert RPS_SIG2
  CSaa7146aMc2RpsSig1On = $10001000; // Assert RPS_SIG1
  CSaa7146aMc2RpsSig0On = $08000800; // Assert RPS_SIG0
  CSaa7146aMc2RpsSig4Off = $80000000; // Reset RPS_SIG4
  CSaa7146aMc2RpsSig3Off = $40000000; // Reset RPS_SIG3
  CSaa7146aMc2RpsSig2Off = $20000000; // Reset RPS_SIG2
  CSaa7146aMc2RpsSig1Off = $10000000; // Reset RPS_SIG1
  CSaa7146aMc2RpsSig0Off = $08000000; // Reset RPS_SIG0
  CSaa7146aMc2UpldBrsMask = $00000010; // Upload BRS mask
  CSaa7146aMc2UpldDebiMask = $00000002; // Upload DEBI mask
  CSaa7146aMc2UpldI2cMask = $00000001; // Upload I2C mask
  CSaa7146aMc2RpsSig4Mask = $00008000; // RPS_SIG4 bit mask
  CSaa7146aMc2RpsSig3Mask = $00004000; // RPS_SIG3 bit mask
  CSaa7146aMc2RpsSig2Mask = $00002000; // RPS_SIG2 bit mask
  CSaa7146aMc2RpsSig1Mask = $00001000; // RPS_SIG1 bit mask
  CSaa7146aMc2RpsSig0Mask = $00000800; // RPS_SIG0 bit mask

  {------------------------------------------------------------------------------
    Descript:  PSR: Primary Status Register constants
   -----------------------------------------------------------------------------}
  CSaa7146aPsrDebiE = $00040000; // Event flag in PSR
  CSaa7146aPsrDebiS = $00080000; // Status flag in PSR

  {------------------------------------------------------------------------------
    Descript:  SSR: Secondary Status Register constants
   -----------------------------------------------------------------------------}
  CSaa7146aSsrDebiTo = $00800000; // Debi timeout
  CSaa7146aSsrDebiEf = $00400000; // Debi format error

  {------------------------------------------------------------------------------
    Descript:  GPIO constants
   -----------------------------------------------------------------------------}
  CSaa7146aGpioInput = $00000000; // GPIO input
  CSaa7146aGpioInputRising = $10101010; // GPIO input, rising edge
  CSaa7146aGpioInputFalling = $20202020; // GPIO input, falling edge
  CSaa7146aGpioInputEdges = $30303030; // GPIO input, both edges
  CSaa7146aGpioOutputLow = $40404040; // GPIO output, low
  CSaa7146aGpioOutputHigh = $50505050; // GPIO output, high
  CSaa7146aGpioOutputMonitor = $C0C0C0C0; // GPIO output, monitoring

  CSaa7146aGpioBase = $00000000; // GPIO all inputs
  CSaa7146aGpio0Lo = $00000040; // GPIO0 set to LO
  CSaa7146aGpio0Hi = $00000050; // GPIO0 set to HIGH
  CSaa7146aGpio1Lo = $00004000; // GPIO1 set to LO
  CSaa7146aGpio1Hi = $00005000; // GPIO1 set to HIGH
  CSaa7146aGpio2Lo = $00400000; // GPIO2 set to LO
  CSaa7146aGpio2Hi = $00500000; // GPIO2 set to HIGH
  CSaa7146aGpio3Rising = $10000000; // GPIO3 set to rising edge IRQ
  CSaa7146aGpio3Falling = $20000000; // GPIO3 set to falling edge IRQ
  CSaa7146aGpio3Both = $30000000; // GPIO3 set to both edge IRQ
  CSaa7146aGpio3Lo = $40000000; // GPIO3 set to LO
  CSaa7146aGpio3Hi = $50000000; // GPIO3 set to HIGH
  CSaa7146aGpio0Mask = $000000FF; // GPIO0
  CSaa7146aGpio1Mask = $0000FF00; // GPIO1
  CSaa7146aGpio2Mask = $00FF0000; // GPIO2
  CSaa7146aGpio3Mask = $FF000000; // GPIO3

  {------------------------------------------------------------------------------
    Descript:  DEBI constants
   -----------------------------------------------------------------------------}
  CSaa7146aDebiCfgIntel = $00020000; // Intel mode
  CSaa7146aDebiCfgNoSwap = $00000000; // No endian swap
  CSaa7146aDebiCfg2Swap = $00100000; // 2 byte endian swap
  CSaa7146aDebiCfg4Swap = $00200000; // 4 byte endian swap
  CSaa7146aDebiCfgFast = $10000000; // Fast mode enable
  CSaa7146aDebiCfg16 = $00080000; // 16-bit access enable
  CSaa7146aDebiCfgInc = $00040000; // Enable address increment
  CSaa7146aDebiCfgTimeoutOff = $00010000; // Disable time out
  CSaa7146aDebiCmdRd = $00010000; // Read
  CSaa7146aDebiCmdWr = $00000000; // Write
  CSaa7146aDebiPageDisable = $00000000; // Paging disable

  {------------------------------------------------------------------------------
    Descript:  Bit masks and constants for ACON1 register
   -----------------------------------------------------------------------------}
  CSaa7146aA2Run = $40000000; // Run A2 based on TSL2
  CSaa7146aA1Run = $20000000; // Run A1 based on TSL1
  CSaa7146aA1Swap = $00200000; // Use big-endian for A1
  CSaa7146aA2Swap = $00100000; // Use big-endian for A2

  {------------------------------------------------------------------------------
    Descript:  I2C configuration constants
   -----------------------------------------------------------------------------}
  CSaa7146aI2cClkSel5kHz = $0500; // I2C bit rate = PCIclk/6400 = 5.156 kHz
  CSaa7146aI2cClkSel10kHz = $0100; // I2C bit rate = PCIclk/3200 = 10.31 kHz
  CSaa7146aI2cClkSel69kHz = $0400; // I2C bit rate = PCIclk/480  = 68.75 kHz
  CSaa7146aI2cClkSel103kHz = $0600; // I2C bit rate = PCIclk/320  = 103.1 kHz
  CSaa7146aI2cClkSel138kHz = $0700; // I2C bit rate = PCIclk/240  = 137.5 kHz
  CSaa7146aI2cClkSel275kHz = $0000; // I2C bit rate = PCIclk/120  = 275   kHz
  CSaa7146aI2cClkSel413kHz = $0200; // I2C bit rate = PCIclk/80   = 412.5 kHz
  CSaa7146aI2cClkSel550kHz = $0300; // I2C bit rate = PCIclk/60   = 550   kHz
  CSaa7146aI2cErr = $0002; // I2C control/status flag ERROR
  CSaa7146aI2cBusy = $0001; // I2C control/status flag BUSY
  CSaa7146aI2cAbort = $0080; // I2C status flag ABORT
  CSaa7146aI2cInvalidStartStop = $0040;
    // I2C status flag error invalid start/stop condition
  CSaa7146aI2cNackAddressPhase = $0020;
    // I2C status flag error NACK address phase
  CSaa7146aI2cNackTransmission = $0010;
    // I2C status flag error NACK data transmission
  CSaa7146aI2cNackReception = $0008; // I2C status flag error NACK receiving data
  CSaa7146aI2cArbitrationLost = $0004; // I2C status flag error arbitration lost
  CSaa7146aI2cAttrStart: Dword = $3; // I2C Byte attribute START
  CSaa7146aI2cAttrCont: Dword = $2; // I2C Byte attribute CONT
  CSaa7146aI2cAttrStop: Dword = $1; // I2C Byte attribute STOP
  CSaa7146aI2cAttrNop: Dword = $0; // I2C Byte attribute NOP

  {------------------------------------------------------------------------------
    Descript:  RPS command codes and constants
   -----------------------------------------------------------------------------}
  CSaa7146aRpsI2cDone = $00000001; // RPS I2C done
  CSaa7146aRpsDebi = $00000002; // DEBI done
  CSaa7146aRpsVtd1 = $00000004; // RPS Video Transfer Dma1 (for upload)
  CSaa7146aRpsVtd2 = $00000008; // RPS Video Transfer Dma2 (for upload)
  CSaa7146aRpsVtd3 = $00000010; // RPS Video Transfer Dma3 (for upload)
  CSaa7146aRpsHpsDone = $00000020; // RPS HPS DONE
  CSaa7146aRpsHpsLineDone = $00000040; // RPS HPS LINE DONE
  CSaa7146aRpsBrsDone = $00000100; // RPS BPS DONE
  CSaa7146aRpsVbiB = $00000200; // RPS Vertical Blanking Indicator B detection
  CSaa7146aRpsVbiA = $00000400; // RPS Vertical Blanking Indicator A detection
  CSaa7146aRpsEFidA = $00000800; // RPS Even field A detection
  CSaa7146aRpsOFidA = $00001000; // RPS Odd field A detection
  CSaa7146aRpsEFidB = $00002000; // RPS Even field B detection
  CSaa7146aRpsOFidB = $00004000; // RPS Odd field B detection
  CSaa7146aRpsHs = $00008000; // RPS HPS Source
  CSaa7146aRpsHt = $00010000; // RPS HPS Target
  CSaa7146aRpsGpio0 = $00020000; // RPS GPIO0
  CSaa7146aRpsGpio1 = $00040000; // RPS GPIO1
  CSaa7146aRpsGpio2 = $00080000; // RPS GPIO2
  CSaa7146aRpsGpio3 = $00100000; // RPS GPIO3
  CSaa7146aRpsSig0 = $00200000; // RPS semaphore 0
  CSaa7146aRpsSig1 = $00400000; // RPS semaphore 1
  CSaa7146aRpsSig2 = $00800000; // RPS semaphore 2
  CSaa7146aRpsSig3 = $01000000; // RPS semaphore 3
  CSaa7146aRpsSig4 = $02000000; // RPS semaphore 4
  CSaa7146aRpsInvert = $04000000; // Test for negated semaphores
  CSaa7146aRpsLogicalOr = $08000000; // Logical OR conditionals

  CSaa7146aRpsNop = $00000000; // NOP
  CSaa7146aRpsClrSignal = $00000000; // CLEAR SIGNAL
  CSaa7146aRpsSetSignal = $10000000; // SET SIGNAL
  CSaa7146aRpsPause = $20000000; // PAUSE
  CSaa7146aRpsCheckLate = $30000000; // CHECK LATE
  CSaa7146aRpsUpload = $40000000; // UPLOAD
  CSaa7146aRpsStop = $50000000; // STOP
  CSaa7146aRpsInterrupt = $60000000; // INTERRUPT
  CSaa7146aRpsJump = $80000000; // JUMP
  CSaa7146aRpsLdReg = $90000100; // LDREG (1 Dword only)
  CSaa7146aRpsStReg = $A0000100; // STREG (1 Dword only) NEEDS BUG CORRECTION!
  CSaa7146aRpsMaskLoad = $C0000000; // MASKLOAD

  CSaa7146aRpsClkScalar = 8;
    // This is apparent ratio of PCI/RPS clks (undocumented!!)
  CSaa7146aRpsClkPerUs = (33 / CSaa7146aRpsClkScalar);
    // Number of RPS clocks in one microsecond

  {------------------------------------------------------------------------------
    Descript:  Bit masks and constants for DD1 interface <CSaa7146aDd1Init>
   -----------------------------------------------------------------------------}
  CSaa7146aDd1A = $FFFF0000; // DD1 port A
  CSaa7146aDd1B = $0000FFFF; // DD1 port B
  CSaa7146aDd1LlcInput = $00000000; // Line locked clock control for D1, input
  CSaa7146aDd1LlcOutput = $80008000; // Line locked clock control for D1, output
  CSaa7146aDd1SioInput = $00000000; // Synchronization port configuration, input
  CSaa7146aDd1SioHps = $20002000;
    // Synchronization port configuration, output, HPS
  CSaa7146aDd1SioReset = $40004000;
    // Synchronization port configuration, output, reset input
  CSaa7146aDd1SioBrs = $60006000;
    // Synchronization port configuration, output, BRS
  CSaa7146aDd1PvoDirect = $00000000; // Polarity VS port if output, direct
  CSaa7146aDd1PvoInverted = $10001000; // Polarity VS port if output, inverted
  CSaa7146aDd1PhoDirect = $00000000; // Polarity HS port if output, direct
  CSaa7146aDd1PhoInverted = $08000800; // Polarity HS port if output, inverted
  CSaa7146aDd1Sync0 = $00000000; // Sync edge selection, all rising
  CSaa7146aDd1Sync1 = $01000100;
    // Sync edge selection, HS rising, VS falling, Field falling, direct
  CSaa7146aDd1Sync2 = $02000200;
    // Sync edge selection, HS rising, VS rising, Field falling
  CSaa7146aDd1Sync3 = $03000300;
    // Sync edge selection, HS rising, VS falling, Field falling, toggle
  CSaa7146aDd1Sync4 = $04000400; // Sync edge selection, HS rising, VS rising
  CSaa7146aDd1Sync5 = $05000500;
    // Sync edge selection, HS rising, VS falling, Field toggle
  CSaa7146aDd1Sync6 = $06000600;
    // Sync edge selection, HS rising, VS both frame, Field direct
  CSaa7146aDd1Sync7 = $07000700; // Sync edge selection, SAV/EAV
  CSaa7146aDd1FidesNoIrq = $00000000; // Field identification port, no interrupt
  CSaa7146aDd1FidesRisingIrq = $00400040;
    // Field identification port, rising edge
  CSaa7146aDd1FidesFallingIrq = $00800080;
    // Field identification port, falling edge
  CSaa7146aDd1FidesEdgesIrq = $00C000C0; // Field identification port, both edges

  CSaa7146aDd1LlcA = $80000000; // Line locked clock control for D1 A
  CSaa7146aDd1LlcB = $00008000; // Line locked clock control for D1 B
  CSaa7146aDd1SioA = $60000000; // Synchronization port A configuration
  CSaa7146aDd1SioB = $00006000; // Synchronization port B configuration
  CSaa7146aDd1PvoA = $10000000; // Polarity VS port A if output
  CSaa7146aDd1PvoB = $00001000; // Polarity VS port B if output
  CSaa7146aDd1PhoA = $08000000; // Polarity HS port A if output
  CSaa7146aDd1PhoB = $00000800; // Polarity HS port B if output
  CSaa7146aDd1SyncA = $07000000; // Sync edge selection port A
  CSaa7146aDd1SyncB = $00000700; // Sync edge selection port B
  CSaa7146aDd1FidesA = $00C00000; // Field identification port A
  CSaa7146aDd1FidesB = $000000C0; // Field identification port B

  {------------------------------------------------------------------------------
    Descript:  Bit masks and constants for DD1 interface <CSaa7146aDd1Data>
   -----------------------------------------------------------------------------}
  CSaa7146aDd1VidInput = $00000000; // Port and PXQ select, input
  CSaa7146aDd1VidBrs = $80008000; // Port and PXQ select, output from BRS
  CSaa7146aDd1VidHps = $C000C000; // Port and PXQ select, output from HPS
  CSaa7146aDd1Y8cNoSavEav = $00000000; // Y8C codes, no SAV/EAV data
  CSaa7146aDd1Y8cSavEav = $20002000; // Y8C codes, with SAV/EAV data
  CSaa7146aDd1PfidDirect = $00000000; // Polarity change, direct
  CSaa7146aDd1PfidInverted = $04000400; // Polarity change, inverted

  CSaa7146aDd1VidA = $C0000000; // Port and PXQ select port A
  CSaa7146aDd1VidB = $0000C000; // Port and PXQ select port B
  CSaa7146aDd1Y8cA = $20000000; // Y8C codes port A
  CSaa7146aDd1Y8cB = $00002000; // Y8C codes port B
  CSaa7146aDd1PfidA = $04000000; // Polarity change port A
  CSaa7146aDd1PfidB = $00000400; // Polarity change port B

  {------------------------------------------------------------------------------
    Descript:  Bit masks and constants for DD1 interface <CSaa7146aBrsCtrl>
   -----------------------------------------------------------------------------}
  CSaa7146aDd1BrsStreamInA = $00000000; // Video data stream from A
  CSaa7146aDd1BrsStreamInB = $40000000; // Video data stream from B
  CSaa7146aDd1BrsStreamOut = $C0000000; // Video data stream read from DMA/FIFO
  CSaa7146aDd1BrsSyncInA = $00000000; // Sync signals from A
  CSaa7146aDd1BrsSyncInB = $20000000; // Sync signals from B
  CSaa7146aDd1BrsVOffset = $1FF80000; // Vertical offset
  CSaa7146aDd1BrsVOffsetShift = 19; // Vertical offset bit shifts
  CSaa7146aDd1BrsVScale1 = $00000000; // Vertical scale:  1:1
  CSaa7146aDd1BrsVScale2 = $00020000; // Vertical scale:  1:2
  CSaa7146aDd1BrsVScale4 = $00060000; // Vertical scale:  1:4
  CSaa7146aDd1BrsHOffset = $0001FF80; // Horizontal offset
  CSaa7146aDd1BrsHOffsetShift = 7; // Horizontal offset bit shifts
  CSaa7146aDd1BrsHScale1 = $00000000; // Horizontal scale:  1:1
  CSaa7146aDd1BrsHScale2 = $00000010; // Horizontal scale:  1:2
  CSaa7146aDd1BrsHScale4 = $00000030; // Horizontal scale:  1:4
  CSaa7146aDd1BrsHScale8 = $00000070; // Horizontal scale:  1:8
  CSaa7146aDd1BrsFormatYuv = $00000000; // YUV 4:2:2 format
  CSaa7146aDd1BrsFormatY8 = $00000001; // Y8 format
  CSaa7146aDd1BrsFormatY2 = $00000002; // Y2 format
  CSaa7146aDd1BrsFormatY1 = $00000003; // Y1 format

  {------------------------------------------------------------------------------
    Descript:  Event counter constants
   -----------------------------------------------------------------------------}
  CSaa7146aEcrFidB = $18; // Number of odd/even fields port B

  CSaa7146aEcs0Shift = 2; // Number of shifts for source selection
  CSaa7146aEcs0Clear = $00000001; // Event counter 0 clear
  CSaa7146aEcs0Enable = $00000002; // Event counter 0 enable
  CSaa7146aEcs1Shift = 10; // Number of shifts for source selection
  CSaa7146aEcs1Clear = $00000100; // Event counter 1 clear
  CSaa7146aEcs1Enable = $00000200; // Event counter 1 enable
  CSaa7146aEcs2Shift = 18; // Number of shifts for source selection
  CSaa7146aEcs2Clear = $00010000; // Event counter 2 clear
  CSaa7146aEcs2Enable = $00020000; // Event counter 2 enable
  CSaa7146aEcs3Shift = 2; // Number of shifts for source selection
  CSaa7146aEcs3Clear = $00000001; // Event counter 3 clear
  CSaa7146aEcs3Enable = $00000002; // Event counter 3 enable
  CSaa7146aEcs4Shift = 10; // Number of shifts for source selection
  CSaa7146aEcs4Clear = $00000100; // Event counter 4 clear
  CSaa7146aEcs4Enable = $00000200; // Event counter 4 enable
  CSaa7146aEcs5Shift = 18; // Number of shifts for source selection
  CSaa7146aEcs5Clear = $00010000; // Event counter 5 clear
  CSaa7146aEcs5Enable = $00020000; // Event counter 5 enable

implementation

end.

