{******************************************************************************}
{ FileName............: MajorDvbUnit001                                        }
{ Project.............: SAA7146A/FLEXCOP                                       }
{ Author(s)...........: MM                                                     }
{ Version.............: 0.073                                                  }
{------------------------------------------------------------------------------}
{  Fully functional DVB-S application                                          }
{                                                                              }
{  Copyright (C) 2003-2006  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Note: The supplied VIDEO.GRF does not always has connected output pins.      }
{       This is not absolute necessary because these are automatically         }
{       connected to the last installed 'correct' video/audio filters.         }
{       These video/audio filters are typically part of a DVD viewer (like     }
{       InterVideo / PowerDVD etc. You can also connect these pins as required }
{       so they are forced to a specific connection. You need the FilterGraph  }
{       from DirectX 9 for this.                                               }
{                                                                              }
{ Note: Some DirectShow Filters DO NO ALLOW DEBUGGING. You typically get an    }
{       error '$FC' when DirectShow is being initialized. If you set debugging }
{       off then you don't have a problem.                                     }
{       Some audio decoders do not correctly decode. You get either a runtime  }
{       error or a Mickey Mouse sound on some audio channels....               }
{                                                                              }
{ Note: Some plugins may create problems.                                      }
{       Examples:                                                              }
{       - Spurious runtime errors at finalization when debugging in Delphi     }
{         (might also give 'normal' runtime errors when terminating application}
{         (resolvable through INI setting -> FreeLibrary skip)                 }
{       - During program switching they may 'hang'                             }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  0.02   20040203 - Initial release                                           }
{  0.03   20040206 - <adCpuUsage> unit slightly modified so it won't keep      }
{                    generating errors. Instead <CollectCpuData> returns a     }
{                    success flag.                                             }
{  0.04   20040222 - Added local font                                          }
{                  - Status panels added                                       }
{                  - Added option to not render audi/video of DirectShow       }
{                    (eg. NERO MEDIAPLAYER does something to system which makes}
{                    rendering takes forever, so the application does not start}
{                    and at times the application terminates with error when   }
{                    exit).                                                    }
{                  - LOF lowband/higband added                                 }
{                  - <Saa7146AI2C> frequency LNB also allows 'negative'        }
{                    results for tuner frequency -> these are converted to     }
{                    positive values. This is for C-band LOFs which give a     }
{                    negative tuner frequency.                                 }
{                  - Added manual DiSEqC commands                              }
{                  - Added DiSEqC repeats setting                              }
{                  - Added DiSEqC setting to use positioner command            }
{                  - Additional settings, particular for DirectShow            }
{                  - DirectShow parameter added and cleanup revised            }
{                  - Up/Down swap option added                                 }
{                  - try/except in program/event retreive (DvbFilter)          }
{                  - Added option to disable FreeLibrary for specific plgins   }
{  0.05   20040321 - Changes in EPG                                            }
{                  - Program name in status bar                                }
{                  - .info file optional (INI parameter)                       }
{                  - Filename box added for recording (as prefix)              }
{                  - Manual commands initiate 'transponder' change for program }
{                    up/down afterwards too                                    }
{                  - Integer overflow <Saa7146AI2C> setting frequency resolved }
{                  - Fixed tags for remote control messages                    }
{                  - More extensive remote control codes, incl keyboard        }
{                    emulation                                                 }
{                  - TCP Network support                                       }
{                  - Also allows <MajorDvbPsi.ax> to be used (V2.01/V2.02)     }
{                    . <DvbFilter> is now indirectly called in <DvbDirectShow> }
{                  - Windowless mode added in <DvbDirectShow> and as INI       }
{                  - Graph file can be set in INI file                         }
{                  - First command line parameter can set Graph file to use    }
{                  - INI setting added which allows all data to be send to     }
{                    DirectShow                                                }
{                  - DirectShow graph is created 'manually' if no graph file   }
{                    given                                                     }
{  0.06   20041231 - Other cards supported (variable settings tuner)           }
{                  - Added decrambled indication                               }
{                  - Auto ECM added / Prefered 'removed'                       }
{                    If 'on' will also force an update of all program info     }
{                  - Remote control shutdown command added                     }
{                  - Fixed bug that always CSA.DLL was used instead of ini     }
{                    setting                                                   }
{                  - 'CSA=Disable' disables CSA al together                    }
{                  - Multiple cards supported (Device=)                        }
{                  - Possible to run without hardware and receiving data       }
{                  - Network update button now correctly made visible          }
{                  - PID 0 can now also be recorded (needed for preprocessing) }
{                  - Try/Except surrounding DirectShow and plugins             }
{                  - StreamLock in timer changed slightly. Menu text for TS    }
{                    processing handled by flag.                               }
{                  - Application does not need to be called from the           }
{                    applications main directory.                              }
{                  - Both PLUGINS and MDPLUGINS directory are scanned for      }
{                    plugins                                                   }
{                  - PacketThread.Execute deadlocks removed if no signal is    }
{                    received. Also the manual notification changed so it      }
{                    repeats notifications until success or too much retries.  }
{                  - Parameter changed. Now using "XXX=YYY" so parameters can  }
{                    be used randomly.                                         }
{                    Parameters are now:                                       }
{                     DirectShowGraph         DirectShow file to use           }
{                     Favourite               index   in favourite list        }
{                     Program                 index-1 from selected favourite  }
{                     StartRecording          Start time recording             }
{                     StartRecordingIfExpired Start when <StartRecording>      }
{                                             already expired                  }
{                     StopRecording           Stop time recording              }
{                     Shutdown                Shutdown time                    }
{                     Exit                    Exit time                        }
{                     ExitAfterRecording      Exit after recording ends        }
{                     ShutdownAfterRecording  Exit after recording ends        }
{                     FullScreen              Full screen mode                 }
{                  - Additional time correction for above parameters           }
{                  - Additional remote control commands besides of toggle      }
{                    (recordon/recordoff/fullscreen/fullscreenoff/fullscreenon)}
{                  - 'Scan' now calls 'Scan all'                               }
{                    Scan buttons only visible when 'Transponder display'      }
{                    active.                                                   }
{                    Using Tag instead of visibility of button for 'exit'.     }
{                    Instead of SCAN.LST a unique new file is generated.       }
{                  - New RichView component used - with 'jump' which sets      }
{                    recording time                                            }
{                    Added 'offset' in INI file for this:                      }
{                     TimeCorrectionPreRecord                                  }
{                     TimeCorrectionPostRecord                                 }
{                    EPG more colorfull                                        }
{                  - Faster update when processing TS file                     }
{                  - Full screen mode is forced every second when active       }
{                    ESC key reverses it                                       }
{                  - Added characters which simulate left/right/down/left etc  }
{                  - TSBufferTime bug corrected                                }
{                  - <LastBuffer> forced to valid value for correct termination}
{                  - Half second intervals for checking start/stop recording   }
{                  - Termination of thread exits it immediately now (spurious  }
{                    exit behaviour otherwise)                                 }
{                  - Threads with generic try..except for spurious problems    }
{                  - using Saa7146aCloseHandle instead of CloseHandle because  }
{                    multiple handles for a single card s now supported        }
{                  - ServiceId added                                           }
{                    Now used instead of program index (no longer 'supported') }
{                  - Implemented MDAPI_GET_PROGRAM (partially?)                }
{                  - Implemented MDAPI_GET_PROGRAM_NUMBER                      }
{                  - Single favourite also allowed (bug)                       }
{                  - Buffering of DirectShow data added to test improvement    }
{                    of performance  -  only slight improvement (?)            }
{                    Use DEFINE DSBUFFER to enable it                          }
{                  - Now also allows 'foreign' transponder files (eg. WinSTB / }
{                    www.satelliweb.com / TechnoTrend INI)                     }
{                  - Added a possible deadlock check in EventUpdate            }
{                  - Corrected 100% load bug when very first time started      }
{                    without any signal (returned buffer index > PacketBuffers)}
{                  - Added InitializationSuccess flag                          }
{                  - Added MdPluginExit in cleanup                             }
{                  - MDAPI SET_PROGRAM supported (INI setting added)           }
{                  - For SU1278 tuner low symbolrates (<4000kS) supported      }
{                    <Saa7146aI2c>                                             }
{                  - Added CA_System82 to MdApi stuff (used by some plugins)   }
{                  - TV/Radio/Data seletion added (sorts out lists)            }
{                  - Mini-DiSEqC (burst) always used in DiSEqC command         }
{                    Mini-DiSEqC only by means of INI setting                  }
{                  - DiSEqC now also includes polarity/band information        }
{                  - Added FiltersOff flag which disables plugin filters while }
{                    changing data - set to TRUE and FALSE at places were      }
{                    MdApiOnChannelChange is called                            }
{                  - Elapsed time recording added                              }
{                  - Volume control added (bidirectional)                      }
{                  - Keyboard control expanded                                 }
{                  - Remote control expanded (0..9 / PP)                       }
{                  - Recording size added                                      }
{                  - Name of recording now also includes PID number            }
{                  - PID name for PID 0 also set                               }
{                  - More PIDs can be included in recording                    }
{                  - Recording of PID 0 was not saved in INI - corrected       }
{                  - FilterLock more centralized (not in .execute)             }
{                  - Filters removed at FormDestroy (possible reason for some  }
{                    errors when closing apllication)                          }
{                  - EPG height can be set by user                             }
{                  - Position of form is retained                              }
{                  - Resize of form added                                      }
{                  - Doubleclick on video swicthes between full screen mode    }
{                  - Problem with some plugins who change there filter while   }
{                    they are called resolved (was due to FilterLock)          }
{                  - When a filter is added with an already existing name then }
{                    the old filter is removed (some plugins work that way ->  }
{                    not removing the old filter but just starting a new one   }
{                  - Default size reduced to 720x576                           }
{                  - Slider now also correctly positioned at resize            }
{                  - Last panel of status keeps same width, Panel[8] resizes   }
{                  - File positioner has smaller stepsize                      }
{                  - Suppression of MdApi command OnChannelChange after        }
{                    transponder change until valid data received              }
{                  - CAT event added - initiates PidChanged                    }
{                    PMT event initiates PidChanged after transponder change   }
{                  - Auto retune if no lock for a second (tuner has then       }
{                    corrected it's AGC and so to the extends, of which it will}
{                    not recover                                               }
{                  - TransponderChanged now forces an update of the frequency  }
{                  - Possible to use frequencies and such which are not in the }
{                    transponder list                                          }
{                  - Manual tuning 'disabled' because of auto re-tune function }
{                    which will interfere                                      }
{                  - Added bars for power/ C/N                                 }
{                  - Network support removed                                   }
{                  - Preferred language added                                  }
{                  - try..except surrounding external 'plugin' code in         }
{                    <DecodeTransportStreamData>                               }
{                  - Every plugin now has it's own set of filters              }
{                  - Every plugin can use either 184 or 188 bytes              }
{                  - Additional ECM information removed                        }
{                  - Channels can be marked 'disabled'                         }
{                  - Plugins can be in more subdirectories so each plugin can  }
{                    have it's own location/settings (MDPLUGINx)               }
{                    PLUGINS subdirectory no longer supported                  }
{                  - Remote control commands for 'language'/'disabled'         }
{                  - <AlwaysUpdateProgram> setting added                       }
{                  - DirectShow using VMR9 only (windowless mode)              }
{                    because of upcoming OSD                                   }
{                  - None of the plugins are now freed                         }
{                  - Circular lists                                            }
{                  - Variable timeout numerical keys input                     }
{                  - User defined DiSEqC settings added                        }
{                  - DirectShow filters shown in menu plus property page option}
{                  - RPS0 programs can be selected (0..3=simulated VSYNC)      }
{                  - Added trick for letting DirectShow filters think no       }
{                    debugger is active                                        }
{                  - Complete rework of DirectShow (more options)              }
{                  - Native video size (=size from stream) added               }
{                  - Setup screen(s) added                                     }
{                  - Startup parameter 'Setup' added                           }
{                  - TimeSeparator/EncodeTime used instead of fixed ':'        }
{                  - Event mechanism of DirectShow tested -                    }
{                    not all expected events are being received so removed     }
{                  - Available DirectShow graphs in menu                       }
{                  - Reinit in menu instead of through button                  }
{                  - Added TimeCorrectionGmt for correction on time zone       }
{                  - Added progress bar current event                          }
{                  - EMM entry added                                           }
{                  - DiSEqCReset added                                         }
{                  - Wait for PMT update extended to 200 instead of 50         }
{                    (NoSignal extended to 3 instead of 2 because of this)     }
{                  - Revised DiSEqC setting. Old method only used as no new    }
{                    settings used.                                            }
{                  - Added FFDeCsa mechanism                                   }
{                  - Manual DiSEqC command added                               }
{                  - 'Old' DirectShow also supported                           }
{                  - Without lock no packets are being processed (otherwise    }
{                    random data)                                              }
{                  - Without <AlwaysUpdateProgram> no wait is done on PMT      }
{                    (increases switching between transponders)                }
{                  - Multiple recordings on same transponder introduced        }
{                  - Multiple instances of plugins allowed (if they support it)}
{                    -> only one plugin gets the menu command instead of all   }
{                       plugins                                                }
{                    Tried multiple instances of plugins:                      }
{                    - changing identfiers to new application identifiers does }
{                      not work because internal processing of the plugin does }
{                      not know how to handle these different identifiers (to  }
{                      update the menu item)                                   }
{                    ! Success with recording addressed plugin with            }
{                      WM_INITMENUPOPUP but removed because of ...             }
{                    Note: Problem of updating menu still exists though        }
{                          (update menu items are applied to first instance    }
{                           menu)                                              }
{                  - Bug concerning DiSEqC resolved (one byte too many)        }
{                  - Scheduler added. Also switches channels 30 seconds prior  }
{                    to recording time.                                        }
{                  - Directshow as object so multiple instances possible       }
{                    . Note: first impression of multiple instances in same    }
{                      process: not possible -> usrc fails                     }
{                      Same with using thread                                  }
{                  - Auto registering of usrc.ax                               }
{                  - AC3 support added                                         }
{                    AC3 audio internally added ('*' after audio PID text)     }
{                  - AutoContinueOnException added as option                   }
{                  - Even less done while scanning (no DirectShow)             }
{                  - FreezeTimeOut added as option                             }
{  0.061  20050111 - Bugfix <MajorDvbRecording>                                }
{  0.062  20050118 - <try><except> around reading <ActiveTimeBias> since this  }
{                    can fail if the user does nat have administrator rights   }
{  0.063  20050128 - <ProcessMessages> added in scanning (ProcessMessages was  }
{                    otherwise only called at success of tuning, which would   }
{                    lead to long timeout if multiple frequencies were 'dead') }
{                  - Added failed transponders indication in scan all          }
{  0.064  20050129 - Added 'scrambled' options for not showing these           }
{  0.065  20050209 - Fontsize EPG variable                                     }
{  0.066  20050213 - Bug corrected: Recorded file was not processed if not     }
{                    tuned                                                     }
{  0.067  20050305 - Recording size always shown                               }
{                  - Max recording size added                                  }
{                  - Bug FreeAndNil of current recording corrected             }
{                  - Events can be enabled during recording                    }
{  0.068  20050312 - Application directory also scanned for plugins            }
{                  - Application directory explicitly removed from files       }
{  0.070  20050417 - FlexCop support added (crude method - should be done      }
{                    completely different, but this is a -quick- implementation}
{  0.071  20050603 - All PIDs in PMT can be shown                              }
{                  - Search in favourite list                                  }
{                  - Smaller resolutions supported                             }
{  0.072  20051009 - Bugfix MajorDVBRecording.pas concerning valid PIDS        }
{                  - MadExcept V3 now used                                     }
{  0.073  20060427 - UDP multicasting added                                    }
{                                                                              }
{ To know:                                                                     }
{ . You can place the video window on most controls.                           }
{   However, there color will be forced so you can not always use it as you    }
{   would like.                                                                }
{ . You can place a control on top of the video window and make it transparent }
{   by using the color $100010                                                 }
{******************************************************************************}

unit MajorDvbUnit001;

interface
uses
  IdGlobal, IdUDPClient,
  Forms, ExtCtrls, StdCtrls, Mask, Controls, Classes, Gauges, ComCtrls,
  MajorDvbUnitVolume,
  MajorDvbSetupCard,
  MajorDvbSetupDiSEqC,
  MajorDvbSetupDirectShow,
  MajorDvbSetupFiles,
  MajorDvbSetupMiscellaneous,
  MajorDvbSetupRemote,
  MajorDvbRecording,
  Messages, Buttons, Graphics, Menus, Dialogs, Grids, Outline, DirOutln,
  FileCtrl, Spin,
  RichView, RVStyle,
  Windows;

const
  WM_REMOTE = WM_USER + 1;
  WM_SIGNALLING = WM_USER + 10;

  // All remote control messages must be 4 bytes (they are typecasted to Integer)
  CRemoteMessage0: array[0..3] of Char = '0   ';
  CRemoteMessage1: array[0..3] of Char = '1   ';
  CRemoteMessage2: array[0..3] of Char = '2   ';
  CRemoteMessage3: array[0..3] of Char = '3   ';
  CRemoteMessage4: array[0..3] of Char = '4   ';
  CRemoteMessage5: array[0..3] of Char = '5   ';
  CRemoteMessage6: array[0..3] of Char = '6   ';
  CRemoteMessage7: array[0..3] of Char = '7   ';
  CRemoteMessage8: array[0..3] of Char = '8   ';
  CRemoteMessage9: array[0..3] of Char = '9   ';
  CRemoteMessagePp: array[0..3] of Char = 'PP  ';
  CRemoteMessageUp: array[0..3] of Char = 'UP  ';
  CRemoteMessageDown: array[0..3] of Char = 'DOWN';
  CRemoteMessageLeft: array[0..3] of Char = 'LEFT';
  CRemoteMessageRight: array[0..3] of Char = 'RIGH';
  CRemoteMessageRecord: array[0..3] of Char = 'RECO';
  CRemoteMessageRecordOn: array[0..3] of Char = 'REON';
  CRemoteMessageRecordOff: array[0..3] of Char = 'REOF';
  CRemoteMessageReInit: array[0..3] of Char = 'REIN';
  CRemoteMessageUpdate: array[0..3] of Char = 'UPDA';
  CRemoteMessageEPG: array[0..3] of Char = 'EPG ';
  CRemoteMessageEPGShort: array[0..3] of Char = 'EPGS';
  CRemoteMessageEPGCurrent: array[0..3] of Char = 'EPGC';
  CRemoteMessageVideo: array[0..3] of Char = 'VIDE';
  CRemoteMessageAudio: array[0..3] of Char = 'AUDI';
  CRemoteMessagePids: array[0..3] of Char = 'PIDS';
  CRemoteMessageDirectShow: array[0..3] of Char = 'DIRE';
  CRemoteMessageTransponder: array[0..3] of Char = 'TRAN';
  CRemoteMessageSettings: array[0..3] of Char = 'SETT';
  CRemoteMessageShutdown: array[0..3] of Char = 'SHUT';
  CRemoteMessageExit: array[0..3] of Char = 'EXIT';
  CRemoteMessageFullScreen: array[0..3] of Char = 'FULL';
  CRemoteMessageFullScreenOn: array[0..3] of Char = 'FUON';
  CRemoteMessageFullScreenOff: array[0..3] of Char = 'FUOF';
  CRemoteMessageMute: array[0..3] of Char = 'MUTE';
  CRemoteMessageMuteOn: array[0..3] of Char = 'MUON';
  CRemoteMessageMuteOff: array[0..3] of Char = 'MUOF';
  CRemoteMessageVolumeUp: array[0..3] of Char = 'VOLU';
  CRemoteMessageVolumeDown: array[0..3] of Char = 'VOLD';
  CRemoteMessageLanguage: array[0..3] of Char = 'LANG';
  CRemoteMessageDisable: array[0..3] of Char = 'DISA';
  CRemoteMessageScramble: array[0..3] of Char = 'SCRA';

  CClientCommandRemote = 0;
  CClientCommandTransponderIndex = 1;
  CClientCommandListIndex = 2;
  CClientCommandFavouriteIndex = 3;
  CClientCommandTransponder = 4;
  CClientCommandProgram = 5;

type
  TfrmMain = class(TForm)
    tmrUpdate: TTimer;
    pgInfo: TPageControl;
    tsTuning: TTabSheet;
    tsProgram: TTabSheet;
    tsMessages: TTabSheet;
    mmoDriver: TMemo;
    tsDebug: TTabSheet;
    StaticText5: TStaticText;
    txtSignalPower: TStaticText;
    StaticText8: TStaticText;
    txtNoiseIndicator: TStaticText;
    cmbTransponders: TComboBox;
    txtTransponder: TLabel;
    Label9: TLabel;
    lblOvertaken: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    txtPacketCount: TLabel;
    txtOvertaken: TLabel;
    txtFiltersDefinedApp: TLabel;
    txtMs: TLabel;
    txtPacketErrors: TLabel;
    Label22: TLabel;
    chkEPGPresentInfoOnly: TCheckBox;
    btnAddToFavourites: TButton;
    btnDeleteFavourite: TButton;
    reEvents: TRichEdit;
    cmbFavourites: TComboBox;
    btnScan: TButton;
    btnScanAll: TButton;
    pnlSettings: TPanel;
    txtService: TLabel;
    Label5: TLabel;
    cmbVideoPids: TComboBox;
    Label6: TLabel;
    cmbAudioPids: TComboBox;
    cmbAudioLanguages: TComboBox;
    Label15: TLabel;
    cmbTeletextPids: TComboBox;
    Label16: TLabel;
    mskPmt: TMaskEdit;
    Label17: TLabel;
    mskPcr: TMaskEdit;
    cmbEcmPids: TComboBox;
    Label14: TLabel;
    chkDirectShow: TCheckBox;
    chkPids: TCheckBox;
    chkVideo: TCheckBox;
    chkAudio: TCheckBox;
    Label7: TLabel;
    cmbLists: TComboBox;
    chkTransponderDisplay: TCheckBox;
    btnUpdate: TButton;
    Label8: TLabel;
    txtRemoteControl: TLabel;
    Label20: TLabel;
    cmbSubtitlePids: TComboBox;
    cmbSubtitleLanguages: TComboBox;
    chkRecordVideo: TCheckBox;
    chkRecordAudio: TCheckBox;
    chkRecordTeletext: TCheckBox;
    chkRecordSubtitle: TCheckBox;
    chkRecordPMT: TCheckBox;
    chkRecordPCR: TCheckBox;
    chkRecordAudioAll: TCheckBox;
    chkRecordVideoAll: TCheckBox;
    chkRecordTeletextAll: TCheckBox;
    chkRecordSubtitleAll: TCheckBox;
    chkRecordPMTAll: TCheckBox;
    chkRecordPCRAll: TCheckBox;
    chkRecordECM: TCheckBox;
    chkRecordECMAll: TCheckBox;
    chkRecordIndividualStreams: TCheckBox;
    btnRecordDefault: TButton;
    chkRecordRawData: TCheckBox;
    chkRecordNoFiltering: TCheckBox;
    chkRecordTransponder: TCheckBox;
    Label28: TLabel;
    txtVideoPackets: TLabel;
    stbStatus1: TStatusBar;
    stbStatus2: TStatusBar;
    chkEpg: TCheckBox;
    tbFile: TTrackBar;
    mnuMain: TMainMenu;
    mnuExit: TMenuItem;
    Processrawdatastream1: TMenuItem;
    ProcessRecordedTSFile: TMenuItem;
    mnuPlugins: TMenuItem;
    mnuDummyPlugins: TMenuItem;
    chkEPGShortNameOnly: TCheckBox;
    rgOperation: TRadioGroup;
    Label19: TLabel;
    txtPacketSyncErrors: TLabel;
    chkAutoECM: TCheckBox;
    tmrStateMachineAutoECM: TTimer;
    chkRecordPat: TCheckBox;
    pnlVideo: TPanel;
    pnlBorder: TPanel;
    Settings1: TMenuItem;
    mnuTV: TMenuItem;
    mnuRadio: TMenuItem;
    mnuData: TMenuItem;
    cmbServices: TComboBox;
    tmrStateMachineKeys: TTimer;
    tmrInitStart: TTimer;
    chkRecordEmm: TCheckBox;
    chkRecordMandatory: TCheckBox;
    chkRecordCat: TCheckBox;
    pnlControl: TPanel;
    imgBackgroundButtons: TImage;
    imgRecord2: TImage;
    imgRecord: TImage;
    imgRight: TImage;
    imgDown: TImage;
    imgUp: TImage;
    imgEnter: TImage;
    Image1: TImage;
    Image2: TImage;
    imgLeft: TImage;
    imgVolumeOff: TImage;
    imgVolumeOn: TImage;
    imgVolumeUp: TImage;
    imgVolumeDown: TImage;
    Image3: TImage;
    chkShutdown: TCheckBox;
    dtStartRecording: TDateTimePicker;
    dtStopRecording: TDateTimePicker;
    chkStartRecording: TCheckBox;
    chkStopRecording: TCheckBox;
    dtShutdown: TDateTimePicker;
    edtFileNamePrefix: TEdit;
    dtExit: TDateTimePicker;
    edtTime: TEdit;
    edtFilePos: TEdit;
    Label18: TLabel;
    txtVideoSize: TLabel;
    ggSignalPower: TGauge;
    ggNoiseIndicator: TGauge;
    chkCarrier: TCheckBox;
    chkViterbi: TCheckBox;
    chkSync: TCheckBox;
    chkLock: TCheckBox;
    pgDiSEqC: TPageControl;
    tsPositioner: TTabSheet;
    btnPositionerStop: TButton;
    spnSatellitePosition: TSpinEdit;
    btnPositionerReset: TButton;
    btnPositionerGoEast: TButton;
    btnPositionerStepEast: TButton;
    btnPositionerGoWest: TButton;
    btnPositionerStepWest: TButton;
    btnPositionerSetEastLimit: TButton;
    btnPositionerSetWestLimit: TButton;
    btnPositionerStore: TButton;
    btnPositionerGoto: TButton;
    btnPositionerDisableLimits: TButton;
    chkRetuneDisable: TCheckBox;
    txtSignalLevel: TStaticText;
    StaticText2: TStaticText;
    ggSignalLevel: TGauge;
    txtFiltersDefinedPlugin1: TLabel;
    txtFiltersDefinedPlugin2: TLabel;
    txtFiltersDefinedPlugin3: TLabel;
    txtFiltersDefinedPlugin4: TLabel;
    Label2: TLabel;
    txtFiltersPlugin1: TLabel;
    txtFiltersPlugin2: TLabel;
    txtFiltersPlugin3: TLabel;
    txtFiltersPlugin4: TLabel;
    mnuDisabled: TMenuItem;
    btnDisableEnable: TButton;
    mnuDirectShow: TMenuItem;
    SetProcessDelay: TMenuItem;
    SetProcessDelayTo5ms: TMenuItem;
    SetProcessDelayTo10ms: TMenuItem;
    SetProcessDelayTo15ms: TMenuItem;
    SetProcessDelayTo20ms: TMenuItem;
    SetProcessDelayTo50ms: TMenuItem;
    SetProcessDelayTo0ms: TMenuItem;
    txtNativeVideoSize: TLabel;
    Label3: TLabel;
    mnuDirectShowFilters: TMenuItem;
    mnuDirectShowOptions: TMenuItem;
    mnuSetup: TMenuItem;
    mnuCard: TMenuItem;
    mnuDirectShowGraphs: TMenuItem;
    mnuReInit: TMenuItem;
    mnuDiSEqC: TMenuItem;
    mnuMiscellaneous: TMenuItem;
    edtEmmPids: TEdit;
    chkEmmManual: TCheckBox;
    mnuFiles: TMenuItem;
    Label11: TLabel;
    txtPacketTime: TLabel;
    pbCurrentEvent: TProgressBar;
    txtMinutesToGo: TStaticText;
    edtManualDiSEqC: TEdit;
    StaticText1: TStaticText;
    btnManualSend: TButton;
    mnuRemotecontrol: TMenuItem;
    imgAddRecording: TImage;
    imgRecordList: TImage;
    chkTransponderValid: TCheckBox;
    imgRecord3: TImage;
    mnuScrambled: TMenuItem;
    btnScrambled: TButton;
    btnScrambleScan: TButton;
    chkEventsWhileRecording: TCheckBox;
    btnPids: TButton;
    SearchFavourite: TMenuItem;
    tsControl: TTabSheet;
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure tmrUpdateTimer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure chkVideoClick(Sender: TObject);
    procedure chkPidsClick(Sender: TObject);
    //    procedure udTransponderClick(Sender: TObject; Button: TUDBtnType);
    procedure imgUpClick(Sender: TObject);
    procedure imgDownClick(Sender: TObject);
    procedure imgLeftClick(Sender: TObject);
    procedure imgRightClick(Sender: TObject);
    procedure imgRecordClick(Sender: TObject);
    procedure mskPmtKeyPress(Sender: TObject; var Key: Char);
    procedure chkEpgClick(Sender: TObject);
    procedure btnReinitClick(Sender: TObject);
    procedure btnAddToFavouritesClick(Sender: TObject);
    procedure btnDeleteFavouriteClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure chkAudioClick(Sender: TObject);
    procedure chkDirectShowClick(Sender: TObject);
    procedure UpdateSettings(Sender: TObject);
    procedure cmbServicesKeyPress(Sender: TObject; var Key: Char);
    procedure cmbVideoPidsKeyPress(Sender: TObject; var Key: Char);
    procedure cmbAudioPidsKeyPress(Sender: TObject; var Key: Char);
    procedure cmbEcmPidsKeyPress(Sender: TObject; var Key: Char);
    procedure mskPcrKeyPress(Sender: TObject; var Key: Char);
    procedure btnScanAllClick(Sender: TObject);
    procedure btnScrambleScanClick(Sender: TObject);
    procedure chkTransponderDisplayClick(Sender: TObject);
    procedure btnUpdateClick(Sender: TObject);
    procedure cmbSubtitlePidsKeyPress(Sender: TObject; var Key: Char);
    procedure btnRecordDefaultClick(Sender: TObject);
    procedure ProcessRecordedTSFileClick(Sender: TObject);
    procedure imgEnterClick(Sender: TObject);
    procedure ReadSettings;
    procedure WriteSettings;
    procedure btnPositionerStopClick(Sender: TObject);
    procedure btnPositionerResetClick(Sender: TObject);
    procedure btnPositionerGotoClick(Sender: TObject);
    procedure btnPositionerStoreClick(Sender: TObject);
    procedure btnPositionerGoEastClick(Sender: TObject);
    procedure btnPositionerStepEastClick(Sender: TObject);
    procedure btnPositionerSetEastLimitClick(Sender: TObject);
    procedure btnPositionerGoWestClick(Sender: TObject);
    procedure btnPositionerStepWestClick(Sender: TObject);
    procedure btnPositionerSetWestLimitClick(Sender: TObject);
    procedure btnPositionerDisableLimitsClick(Sender: TObject);
    procedure tmrStateMachineAutoECMTimer(Sender: TObject);
    procedure tmrStateMachineKeysTimer(Sender: TObject);
    procedure mnuDataClick(Sender: TObject);
    procedure mnuScrambledClick(Sender: TObject);
    procedure mnuRadioClick(Sender: TObject);
    procedure mnuTVClick(Sender: TObject);
    procedure imgVolumeOffClick(Sender: TObject);
    procedure imgVolumeUpClick(Sender: TObject);
    procedure imgVolumeDownClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure tmrInitStartTimer(Sender: TObject);
    procedure FormCanResize(Sender: TObject; var NewWidth,
      NewHeight: Integer; var Resize: Boolean);
    procedure FormResize(Sender: TObject);
    procedure pnlVideoDblClick(Sender: TObject);
    procedure sbVolumeScroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure mnuDisabledClick(Sender: TObject);
    procedure btnDisableEnableClick(Sender: TObject);
    procedure btnScrambleClick(Sender: TObject);
    procedure mnuDirectShowClick(Sender: TObject);
    procedure mnuDirectShowGraphClick(Sender: TObject);
    procedure SetProcessDelayToMsClick(Sender: TObject);
    procedure mnuDirectShowOptionsClick(Sender: TObject);
    procedure SetupDirectShowExit(Sender: TObject);
    procedure mnuSetupCardClick(Sender: TObject);
    procedure SetupCardExit(Sender: TObject);
    procedure mnuSetupFilesClick(Sender: TObject);
    procedure SetupFilesExit(Sender: TObject);
    procedure mnuSetupDiSEqCClick(Sender: TObject);
    procedure SetupDiSEqCExit(Sender: TObject);
    procedure mnuSetupMiscellaneousClick(Sender: TObject);
    procedure SetupMiscellaneousExit(Sender: TObject);
    procedure mnuSetupRemoteClick(Sender: TObject);
    procedure SetupRemoteExit(Sender: TObject);
    procedure edtEmmPidsExit(Sender: TObject);
    procedure edtEmmPidsKeyPress(Sender: TObject; var Key: Char);
    procedure btnManualSendClick(Sender: TObject);
    procedure edtManualDiSEqCKeyPress(Sender: TObject; var Key: Char);
    procedure imgRecordListClick(Sender: TObject);
    procedure imgAddRecordingClick(Sender: TObject);
    procedure RecordingsExit(Sender: TObject);
    procedure btnPidsClick(Sender: TObject);
    procedure SearchFavouriteClick(Sender: TObject);
  private
    { Private declarations }
    FFullScreenMode: Boolean; // Flag indicating full screen mode active
    FFullScreenForm: TForm;
    FStateMachineAutoEcm: Integer;
    FStateMachineKeys: Integer;
    FRichView: TRichView;
    FRichViewStyle: TRVStyle;
    FRichViewStyle1: Integer;
    FRichViewStyle2: Integer;
    FRichViewStyle3: Integer;
    FRichViewStyle4: Integer;
    FRichViewEventStart: array of TDateTime;
    FRichViewEventEnd: array of TDateTime;
    FSetupDirectShow: TfrmSetupDirectShow;
    FSetupCard: TfrmSetupCard;
    FSetupFiles: TfrmSetupFiles;
    FSetupDiSEqC: TfrmSetupDiSEqC;
    FSetupMiscellaneous: TfrmSetupMiscellaneous;
    FSetupRemote: TfrmSetupRemote;
    FRecordings: TfrmRecording;
    procedure WMCommand(var Msg: TWMCommand); message WM_COMMAND;
    //    procedure WMInitMenuPopup  (var Msg: TWMInitMenuPopup); message WM_INITMENUPOPUP;
    //    procedure WMUnInitMenuPopup(var Msg: TWMInitMenuPopup); message WM_UNINITMENUPOPUP;
    procedure WMUser(var Msg: TMessage); message WM_USER;
    procedure WMRemote(var Msg: TMessage); message WM_REMOTE;
    procedure WMSignalling(var Msg: TMessage); message WM_SIGNALLING;
    procedure FullScreenMode(FullScreen: Boolean);
    function HandleKeys(Sender: TObject; Key: Word; Accepted: Boolean): Boolean;
    procedure RichViewJump(Sender: TObject; id: Integer);
    function StartRecordingProgram: Byte;
    function StartRecording(Pids: array of TPidList): Byte;
    function GetRecordingPids(var PidsRecord: TPidLists): Boolean;
    function TransponderDisplay: Boolean;
    function RecordingIsActive: Boolean;
    procedure StopRecording(Index: Byte);
    //    procedure StopAllRecordings;
    procedure ReadFavourites;
    procedure ReadLists;
    function AddStringToTransponderList(SatelliteNumber: Integer; StringToAdd:
      string): Boolean;
    function ProcessProgramLine(ProcessLine: string;
      var Video: Word; var Audio: Word;
      var Teletext: Word; var Pmt: Word;
      var Pcr: Word; var Ecm: Word;
      var Subtitle: Word; var Options: Word;
      var Name: string;
      var AudioIsAc3: Boolean): Boolean;
    procedure ProcessTransponderFile(SatelliteNumber: Integer; ProcessFile:
      string);
    procedure ReadTransponders(TransponderFile: string);
    procedure EventUpdate;
    procedure TransponderChanged;
    procedure TransponderChangedTuner;
    procedure ResetDiSEqC;
    procedure ListChanged;
    procedure SetFrequency(Freq: LongWord);
    procedure SetFrequencyTuner(Freq: LongWord; Lof: LongWord);
    procedure SetSymbolrate(Symbolrate: LongWord);
    procedure SetPolarity(PolarityVertical: Boolean);
    procedure UpdateProgramInfo(RetainEcmFavourite: Boolean;
      UsePreferredlanguage: Boolean; UseCurrentLanguage: Boolean);
    procedure FavouriteChanged;
    procedure SyncService(ServiceToSyncWith: Word);
    //    procedure SyncServiceToFavourite(FavouriteToSyncWith: string);
    procedure SyncFavouriteToService(ServiceToSyncWith: Word);
    procedure ProgramChanged(UseCurrentSettings: Boolean);
    procedure PidChanged;
    procedure Scan;
    procedure VolumeUpdate(Sender: TObject);
    procedure DirectShowFiltersAddToMenu;
    procedure DirectShowGraphsAddToMenu;
  public
    { Public declarations }
    PrevSliderPosition: Integer;
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}
uses
  // CPU load indication
  adCpuUsage,
  // Proprietary
  DvbDirectShow2,
  DvbDirectShow,
  DvbFilter, // Note: Only used for types! <DvbDirectShow> calls <DvbFilter> functions!
  DvbStreamBuffering,
  FlexCopGeneral,
  FlexCopDvbStreamBuffering,
  FlexCopInterface,
  FlexCopI2c,
  FlexCopIoControl,
  FlexCopRegisters,
  Saa7146AInterface,
  Saa7146AI2c,
  Saa7146aIoControl,
  Saa7146aRegisters,
  Stv0299bRegisters,
  Tsa5059Registers,

  MadExcept,
  // INI file
  FastIniFile,
  // Soft CSA
  UCsaEmu,
  // Windows
  Registry,
  SyncObjs,
  SysUtils;

const
  Version = $0007;
  SubVersion = '3';
  Build = $20060427;
  MaskColor = $100010; // Mask color (video window 'transparent' color)

type
  TOperation = (otNoOp, otNormal, otError); // Type of 'hardware' using

  // The data thread is the work horse of the application. It receives the DVB-S data,
  // processes them. and sends them to DirectShow.
  TDataThread = class(TThread)
  private
    { Private declarations }
    FHasStopped: Boolean; // Flag indicating thread not running
    FProgrammedStop: Boolean; // If true indicates programmed termination
    FBufferId: Dword; // Buffer identifier for DMA data
    FPacketBuffers: Word; // Number of buffers used
    FFileStream: TFileStream; // Assigned if file stream instead of satellite
    FFileStreamSize: Int64; // Size of file currently handling
    FFileStreamStop: Boolean; // Set to True when file stream should be stopped
    FFileStreamDelay: Word; // Delay to use during file stream mode

    FOperation: TOperation; // Operational types
    FStreamData: PDvbTransportPackets; // Current pointer to stream data
    procedure DecodeTransportStreamData;
    procedure DescrambleFFDeCsa;
  protected
    procedure Execute; override;
  end;

  // Thread used for remote control
  TRcThread = class(TThread)
  private
    { Private declarations }
    HasStopped: Boolean; // Flag indicating thread not running
    ProgrammedStop: Boolean; // If true indicates programmed termination
  protected
    procedure Execute; override;
  end;

  {------------------------------------------------------------------------------
                                   MultiDec API Start
   ------------------------------------------------------------------------------}
  TMDAPIFilterProc = procedure(hFilter: DWORD; Len: Cardinal; Buf: PByteArray);
  cdecl;

  // PID filter definition
  TFilter = record
    Name: string; // Name of filter
    Active: Boolean; // Filter is (to be) set active
    Pid: Word; // Only used for cross reference
    FilterId: Word; // Filter ID as used by plugin
    CallBackFunction: TMDAPIFilterProc; // Function to call
  end;
  PTFilters = ^TFilters;
  TFilters = record
    Filters: array[1..255] of TFilter; // The filter definitions
    CrossReference: array[0..$1FFF] of Byte; // Pid index references to <Filters>
    Active: Word; // Number of active filters
    ActiveText: string; // Active filters as text
  end;

procedure GetAndWriteDirectShowSetup(SetupForm: TfrmSetupDirectShow; ForceWrite:
  Boolean); forward;
procedure SetDirectShowSetup(SetupForm: TfrmSetupDirectShow); forward
  procedure GetAndWriteCardSetup(SetupForm: TfrmSetupCard; ForceWrite: Boolean);
  forward;
procedure SetCardSetup(SetupForm: TfrmSetupCard); forward
  procedure GetAndWriteFilesSetup(SetupForm: TfrmSetupFiles; ForceWrite:
  Boolean); forward;
procedure SetFilesSetup(SetupForm: TfrmSetupFiles); forward
  procedure GetAndWriteDiSEqCSetup(SetupForm: TfrmSetupDiSEqC; ForceWrite:
  Boolean); forward;
procedure SetDiSEqCSetup(SetupForm: TfrmSetupDiSEqC); forward
  procedure GetAndWriteMiscellaneousSetup(SetupForm: TfrmSetupMiscellaneous;
  ForceWrite: Boolean); forward;
procedure SetMiscellaneousSetup(SetupForm: TfrmSetupMiscellaneous); forward
  procedure GetAndWriteRemoteSetup(SetupForm: TfrmSetupRemote; ForceWrite:
  Boolean); forward;
procedure SetRemoteSetup(SetupForm: TfrmSetupRemote); forward
  procedure GetAndWriteRecordings(SetupForm: TfrmRecording; ForceWrite:
  Boolean); forward;
function SetRecordings(SetupForm: TfrmRecording): Boolean; forward
  procedure ReadRecordings; forward;
procedure WriteRecordings; forward;

const
  MDAPI_GET_TRANSPONDER = $01020000;
  MDAPI_SET_TRANSPONDER = $01020001;
  MDAPI_GET_PROGRAM = $01020010;
  MDAPI_SET_PROGRAM = $01020011;
  MDAPI_RESCAN_PROGRAM = $01020012;
  MDAPI_SAVE_PROGRAM = $01020013;
  MDAPI_GET_PROGRAM_NUMBER = $01020014;
  MDAPI_SET_PROGRAM_NUMBER = $01020015;
  MDAPI_START_FILTER = $01020020;
  MDAPI_STOP_FILTER = $01020021;
  MDAPI_SCAN_CURRENT_TP = $01020030;
  MDAPI_SCAN_CURRENT_CAT = $01020031;
  MDAPI_START_OSD = $01020040;
  MDAPI_OSD_DRAWBLOCK = $01020041;
  MDAPI_OSD_SETFONT = $01020042;
  MDAPI_OSD_TEXT = $01020043;
  MDAPI_SEND_OSD_KEY = $01020044;
  MDAPI_STOP_OSD = $01020049;
  MDAPI_DVB_COMMAND = $01020060;
  MDAPI_GET_VERSION = $01020100;

type
  PDVB_COMMAND = ^TDVB_COMMAND;
  TDVB_COMMAND = record
    CmdLength: Word;
    CmdBuffer: array[0..31] of Byte;
  end;

  PProgramNumberParam = ^TProgramNumberParam;
  TProgramNumberParam = record
    RealNumber: Integer;
    VirtNumber: Integer;
  end;

  PStartFilterParam = ^TStartFilterParam;
  TStartFilterParam = record
    DLLIdentifier: Word;
    Filter_ID: Word;
    Pid: Word;
    Name: array[0..31] of Byte;
    CallAddress: LongInt;
    Running_ID: Integer;
  end;

  TPIDFilters = record
    FilterName: array[0..4] of Char;
    FilterId: Byte;
    PID: Word;
  end;

  TCA_System82 = record
    CA_Type: Word;
    ECM: Word;
    EMM: Word;
    Provider_Id: Dword;
  end;

  PProgram82 = ^TProgram82;
  TProgram82 = record
    Name: array[00..29] of Char;
    Provider: array[00..29] of Char;
    Country: array[00..29] of Char;
    Freq: Dword;
    PType: Byte;
    Voltage: Byte;
    Afc: Byte;
    DiSEqC: Byte;
    Symbolrate: Word;
    Qam: Word;
    Fec: Word;
    Norm: Byte;
    Tp_id: Word;
    Video_pid: Word;
    Audio_pid: Word;
    TeleText_pid: Word;
    PMT_pid: Word;
    PCR_pid: Word;
    ECM_pid: Word;
    SID_pid: Word;
    AC3_pid: Word;
    TVType: Byte;
    ServiceTyp: Byte;
    CA_ID: Byte;
    Temp_Audio: Word;
    FilterNr: Word;
    Filters: array[00..31] of TPIDFilters;
    CA_Nr: Word;
    CA_System82: array[0..31] of TCA_System82;
    CA_Country: array[0..5] of Char;
    Marker: Byte;
    Link_TP: Word;
    Link_SID: Word;
    PDynamic: Byte;
    Extern_Buffer: array[00..15] of Char;
  end;

  TMDAPIInitPluginProc =
    procedure(MDInstance: LongWord; MDWnd: HWND;
    Log_Set: Bool; DLL_ID: Integer; HotKey: PChar; Vers: PChar;
    var ReturnValue: Integer); cdecl;
  TMDAPIGetPluginName =
    procedure(Buf: PByteArray); cdecl;
  TMDAPIProcessPluginMenuCommandProc =
    procedure(MenuID: integer); cdecl;
  TMDAPIProcessChannelChange =
    procedure(prg: TProgram82); cdecl;
  TMDAPIExitPluginProc =
    procedure(MDInstance: LongWord; MDWnd: HWND; Log_Set: Bool); cdecl;
  TMDAPIProcessHotKeyProc =
    procedure; cdecl;
  TMDAPIFilterCloseProc =
    procedure(MDInstance: LongWord); cdecl;
  TMDAPIProcessRecPlayProc =
    procedure(Mode: Integer); cdecl;

  TMdPlugin = record
    DllIdentifier: THandle; // Handle to DLL
    Name: string; // Name of plugin
    HotKey: Char; // Hot key
    PacketSize188: Boolean; // Packet size 188 bytes (True) or 184 bytes (False)
    Filters: TFilters; // Pid filters
    PluginMenu: HMENU; // Menu of plugin
    GetPluginName: TMDAPIGetPluginName;
    InitPlugin: TMDAPIInitPluginProc;
    ProcessPluginMenuCommand: TMDAPIProcessPluginMenuCommandProc;
    ProcessChannelChange: TMDAPIProcessChannelChange;
    ExitMDPlugin: TMDAPIExitPluginProc;
    ProcessHotKey: TMDAPIProcessHotKeyProc;
    ProcessFilterClose: TMDAPIFilterCloseProc;
    ProcessRecPlay: TMDAPIProcessRecPlayProc;
  end;
  {------------------------------------------------------------------------------
                                   MultiDec API End
   ------------------------------------------------------------------------------}

  {------------------------------------------------------------------------------
                                   Soft CSA Start
   ------------------------------------------------------------------------------}
    // 'Normal' CSA
  TSetKeyProc = procedure(Key: PByteArray; KeyStruct: PByteArray); cdecl;
  TCSADecryptProc = procedure(KeyStruct: PByteArray; Encrypted: PByteArray);
  cdecl;

  // FFDeCSA
  TFFDeCsaCluster = packed record
    StartBuffer: Pointer;
    EndBuffer: Pointer;
  end;
  PFFDeCsaClusters = ^TFFDeCsaClusters;
  TFFDeCsaClusters = array[0..CDvbPacketVSync] of TFFDeCsaCluster;
  // One to many for trailing nil

  TFFSetKeyProc = function(Even, Odd, KeySet: PByteArray): Integer; stdcall;
  TFFDecryptProc = function(Cluster: PFFDeCsaClusters; KeySet: PByteArray):
    Integer; stdcall;
  TFFKeySizeProc = function: Integer; stdcall;
  TFFParallelismProc = function: Integer; stdcall;

  {------------------------------------------------------------------------------
                                   Soft CSA End
   ------------------------------------------------------------------------------}

    // Recording 'modes'
  TRecording = (rtIdle, rtStartRecording, rtRecording, rtStopRecording);

  TRecordPid = record
    Pid: Word;
    RecordingFile: TFileStream;
    RecordingLink: Byte; // Index to record holding filestream
    MasterLink: Byte; // Index to record acting as master
    RecordingFileFileName: ShortString; // Name of file
    SplitIndex: Integer; // Splitted index
    SplitSize: Int64; // Splitted size
  end;

  {------------------------------------------------------------------------------
                                      OSD
   ------------------------------------------------------------------------------}
const
  // Header of bitmap includes 256 colors
  COsdSizeBitmapHeader = sizeof(BITMAPINFO) + 256 * sizeOf(TRGBQuad);
  COsdTransparentColor = $00112211;
  COsdTransparentColorRGB: TRGBQuad = (
    rgbBlue: ((COsdTransparentColor shr 0) and $FF);
    rgbGreen: ((COsdTransparentColor shr 8) and $FF);
    rgbRed: ((COsdTransparentColor shr 16) and $FF);
    rgbReserved: 0);
  COsdWidth = 500;
  COsdHeight = 500;

type
  // Bitmap data array
  PTMainWindowOsdData = ^TMainWindowOsdData;
  TMainWindowOsdData = array[0..(COsdWidth * COsdHeight) - 1] of TRGBQuad;

  BitmapDef = record
    Header: array[0..COsdSizeBitmapHeader] of Byte;
    Info: PBitmapInfo;
    Handle: HBITMAP;
    DC: HDC;
    Data: PTMainWindowOsdData;
  end;

var
  OsdBitmaps: array[0..4] of BitmapDef;
  OsdTimeout: Integer;

  {------------------------------------------------------------------------------
                                    OSD END
   ------------------------------------------------------------------------------}

var
  AppName: string; // Application name (header)
  ExeDirectory: string; // Directory of executable

  GUDPClient   : TIdUDPClient;
  GUDPBuffer   : TIdBytes;
  GUDPPointer  : PByte;
  GUDPLastIndex: Integer;
  GUDPIndex    : Integer;


  IsSlave: Boolean; // True if act as slave
  ThreadHandle: THandle; // Handle to driver in thread
  PacketThread: TDataThread; // Thread handling packets
  RemoteThread: TRcThread; // Thread handling remote control

  CardHandle: THandle;
  CardNoError: Boolean;

  CardNumber: Integer; // Selected card (INI)
  CardInUse: Integer; // Selected card actually in use
  Priority: string; // Thread priority
  BufferTime: Integer; // Buffer size/time
  Buffers: Integer; // Actual number of buffers used
  TunerType: Byte; // Tuner type
  SynthesizerAddress: Byte; // Synthesizer address tuner
  TunerReset: Byte; // GPIO line for reset ($FF if not to be used)
  LNBPolarity: Byte; // OPx line to use for polarity ($FF if not to be used)
  LNBOnOff: Byte; // OPx line to use for on/off ($FF if not to be used)

  ShutdownOnExit: Boolean; // Shutdowns the PC at exit;

  // Debug
  SecondUpdatePreviousTimer: Dword; // Second timer
  HalfSecondUpdatePrevTimer: Dword; // Half a second timer
  PacketBufferCount: Word; // Number of packet buffers received
  PacketPreviousCount: Word; // <PacketBufferCount> previous run
  VideoPacketCount: Word; // Counts received video packets
  VideoPacketPreviousCount: Word; // Counts received buffers previous check
  Overtaken: Word; // Number of times we run 'behind', eg. NOT waiting for data

  StreamDataBuffer: TDvbTransportPackets2; // DVB-S data (one too many)
const
  StreamDataBufferSize = SizeOf(TDvbTransportPackets); // Exactly the size
var
  //  InitMenuPopup       : HMENU;                   // Last opened popup menu (eg. used for seleting plugin to address)
  NewTransponderSet: Boolean; // Set to True when a new transponder has been set
  // Used for clearing DVB tables
  NewChannelSet: Boolean; // Set to True when a new channel has been set
  FiltersOff: Boolean; // TRUE when filters are not to be called
  TransponderHasChanged: Word;
  // Indicates what updates will trigger a PidChanged
// %xxx1 = PMT received
// %xx1x = CAT received
  TSProcessingDone: Boolean; // Flag from packet thread
  Rps0Program: Integer; // RPS0 program running

  ShowAudioVideo: Boolean; // True shows audio/video
  ShowVideo: Boolean; // True shows video
  ShowAudio: Boolean; // True 'shows' audio
  ProcessPids: Boolean; // True processes PIDs

  Recording: TRecording; // Recording state
  RecordingRawData: Boolean; // True indicates raw data recording
  RecordingAllData: Boolean; // True indicates all data recording
  RecordingPids: array[0..127] of TRecordPid; // What to record
  RecordingTimerIndex: Byte; // Recording identifier timed/manual recording
  RecordAllAudio: Boolean; // True will record all audio channels
  RecordingDirectory: string; // Path of destination directory for recording
  RecordingInfoFile: Boolean; // Flag indicating .info file to create or not
  FilteringOff: Boolean; // True switches (external) filtering off
  RecordDefault: string; // Recording defaults ('default' button')
  RecordingAllFile: TFileStream; // Filestream for recording all data
  RecordingAllFilePart: Integer; // Part of split file
  RecordingAllFileFileName: ShortString; // Name of recording
  RecordingAllSplitSize: Int64;
    // Accumulated splitted size for total recorded size
  RecordingSplitSize: Int64;
    // Splitted size (in bytes) Max 4Gb ! because of .Position
  RecordingSplitted: Boolean; // True if using split recordings
  DisplayDuringRecording: Boolean;
  // False will disable DirectShow video processing during recording
  ChannelSwitchPreTime: TDateTime;
  // Delta time channel switch takes place before recording

  RecordItems: TRecordItems; // Recordings

  Satellite: Integer; // Current satellite
  List: Integer; // Current list of favourites (index in list)
  Favourite: Integer; // Current favourite (index in list)
  Transponder: Integer; // Current transponder (index in list)
  Frequency: Dword; // Current frequency
  ProgramName: string; // Current program name
  ServiceNumber: Word; // Current service identifier
  PidVideo: Word; // Current PID for video
  PidAudio: Word; // Current PID for audio
  PidAudioIsAc3: Boolean; // Indicates that audio PID is AC3
  PidPCR: Word; // Current PID for PCR
  PidPMT: Word; // Current PID for PMT
  PidEcm: Word; // Current PID for ECM
  PidTeletext: Word; // Current PID for Teletext
  PidSubtitle: Word; // Current PID for subtitle

  FavouriteOld: Integer; // Old setting (for returning to previous setting)
  TransponderOld: Integer; // Old setting (for returning to previous setting)

  NoSignal: Integer; // Counter for no signal (auto re-tune)

  UpdateProgram: Boolean; // True if new program information available
  UpdateProgramCount: Word; // Increases for each new program information update
  UpdatePmt: Boolean; // True if new PMT information available
  UpdatePmtCount: Word; // Increases for each PMT information update
  UpdatePat: Boolean; // True if new PAT information available
  UpdateCat: Boolean; // True if new CAT information available
  UpdateCatCount: Word; // Increases for each CAT information update
  UpdateEvent: Boolean; // True if new event information available
  Scanning: Boolean; // True when scanning
  ProgramOptions: Word; // Current options of program
  // $0001 = Disabled
  // $0002 = Scrambled

  TimeRecordStarted: TDateTime; // Time recording started

  TimeCorrection: TDateTime; // Correction to apply to time of EPG
  TimeCorrectionGmt: Boolean; // If True the TimeCorrectionBias is used
  TimeCorrectionBias: TDateTime; // Active time bias from GMT
  TimeCorrectionParameters: TDateTime;
  // Correction to apply to time of parameters
  TimeCorrectionPreRecord: TDateTime;
  // Additional time for starting recording (event hyperlink)
  TimeCorrectionPostRecord: TDateTime;
  // Additional time for ending recording (event hyperlink)
  TimeStartTime: TDateTime; // Start time of 'current' event
  TimeEndTime: TDateTime; // End time of 'current' event
  TimeDeltaTime: TDateTime; // Start-End time of 'current' event

  PacketTiming: TLargeInteger;
  // Accumulated high performance timing for 512 packets (descramble/plugins/DirectShow)
  PacketTimingCount: Integer; // Total packets
  HighPerformanceFrequency: TLargeInteger; // High performance frequency

  IniFile: TFastIniFile; // Ini file
  FavouritesIniFile: TFastIniFile; // List of favourites
  TransponderListIniFile: TFastIniFile; // File used for transponder list
  EpgHeight: Integer; // Height of event part
  LowestTop: Integer; // Lowest allowed top  position event
  LowestLeft: Integer; // Lowest allowed left position screen
  MenuAndCaption: Integer; // Height of menu and caption

  // Logging (debug)
  LogStream: TFileStream; // Filestream for log
  LogLevel: Byte; // LogLevel (00 = no log)
  //  $x0 = No log
  //  $x1 = Lowest level
  //  $x2 = Command errors
  //  $x3 = Procedure/Function entries
  //  $x4 = Procedure/Function specifics
  //  $x5 = Generic procedure/Function entries
  LogClear: Boolean; // True if log to clear

  DvbCard: string; // DVB card identifier used
  DvbCardPreset: Boolean; // True if correct DvbCard identifier used
  TransponderValid: Boolean; // True if locked correctly

  // DiSEqC / LNB
  DiSEqCList: TStringList; // List with DiSEqC settings
  DiSEqCCurrentLof: Integer; // Current LOF

  LNBLofLowBand: Integer; // Low band Local Oscillator Frequency
  LNBLofHighBand: Integer; // High band Local Oscillator Frequency
  DiSEqCRepeats: Byte; // Repeats for DiSEqC
  DiSEqCUsePositioner: Boolean;
  // True will use positioner command instead of committed switch
  DiSEqCMini: Boolean; // True will use mini-DiSEqc (burst) only

  PreferredLanguage: string; // Preferred languages order
  AlwaysUpdateProgram: Boolean; // True will always do a ProgramChanged

  UpdateLock: TCriticalSection;
  // Prevents updating while we are already processing them
  UpdateLocked: Boolean; // Indication that updating is in progress
  UpdateAgain: Boolean; // Used by UpdateSettings to re-update
  StreamLock: TCriticalSection;
  // Prevents updating stream while we are already processing them

  FontName: string; // Name of font we are using
  FontSize: Integer; // Font size
  FontNameEpg: string; // Name of font we are using
  FontSizeEpg: Integer; // Font size
  //  StreamScrambled: Boolean;
    // Flag indicating scrambled state of stream (audio or video)
  VideoScrambled: Boolean; // Flag indicating scrambled state of video stream
  AudioScrambled: Boolean; // Flag indicating scrambled state of audio stream
  VideoCheckScrambled: Boolean;
  // Flag indicating scrambled state of video stream (checking)
  AudioCheckScrambled: Boolean;
  // Flag indicating scrambled state of audio stream (checking)
  VideoIsDescrambled: Boolean;
  // Flag indicating scrambled video stream has been descrambled
  AudioIsDescrambled: Boolean;
  // Flag indicating scrambled audio stream has been descrambled
// DirectShow
{$IFDEF DSBUFFER}
  DsBuffer: array[0..63] of TDvbTransportPacket; // Data buffer for DirectShow
  DsBufferIndex: Integer; // Index in DsBuffer
{$ENDIF}
  DsGraphFile: string; // Graph file to use for DirectShow
  DsSendAll: Boolean; // True if all data to be send to DirectShow
  DsOptions: Dword; // Options
  DsOff: Boolean; // Flag which disables DirectShow
  DsFunctional: Boolean; // Flag indicating DirectShow is functional
  DsAPid: Word; // Last set audio PID
  DsVPid: Word; // Last set video PID
  VideoWidth: Integer; // Native video width
  VideoHeight: Integer; // Native video height
  FullScreenInit: Integer; // Timer for 'lare' fullscreen mode
  FullScreenTimeOut: TDateTime; // Last time full screen mode manually activated

  TimeoutNumericalKeys: Integer; // Timeout in ms for numerical keys
  TimeoutNumericalKeysRemote: Integer; // Timeout in ms for numerical keys remote
  AutoContinueOnException: Boolean; // Exception setting
  FreezeTimeout: Integer; // Exception setting
  // True if to continue on exception (otherwise exception box)
  KeySwapUpDown: Boolean; // Flag which swaps up/down button actions
  KeyData: Word; // Accumulated keys
  PrevKeyData: Word; // Previous accumulated keys
  //  MdPluginDoNotFreeLibrary : string;             // Identifiers of plugins which should not be FreeLibrary-ied
  MdPluginPassFullPacket: string;
  // Identifiers of plugins which will get 188 bytes from packet
  MdPluginAllowSetPids: Boolean; // True allows plugin to set program PIDs

  // Command line parameters
  ParameterSetup: string;
  ParameterDsGraphFile: string;
  ParameterProgram: string;
  ParameterFavourite: string;
  ParameterStartRecording: string;
  ParameterStartRecordingIfExpired: string;
  ParameterStopRecording: string;
  ParameterShutdown: string;
  ParameterExit: string;
  ParameterExitAfterRecording: string;
  ParameterShutdownAfterRecording: string;
  ParameterFullScreen: string;

  InitializationSuccess: Boolean; // True if initialization succeeded

  UseFlexCop: Boolean;

  {------------------------------------------------------------------------------
                                   MultiDec API Start
   ------------------------------------------------------------------------------}
  MdPlugins: Word;
  MdPlugin: array[0..99] of TMdPlugin;

  AppFilters: TFilters; // Pid filters
  FilterLock: TCriticalSection;
  // Prevents changing filters while they are being in use
  FilterCount: Word; // Counts filter procedures called
  {------------------------------------------------------------------------------
                                   MultiDec API End
   ------------------------------------------------------------------------------}

   {------------------------------------------------------------------------------
                                   Soft CSA Start
   ------------------------------------------------------------------------------}
type
  TCsaMethod = (cmNone, cmInternal, cmCsa, cmFfCsa);
var
  CsaMethod: TCsaMethod; // CSA method
  CsaName: string; // Current CSA (empty for internal)
  CsaDLLIdentifier: Integer;
  SetKeyProc: TSetKeyProc;
  CSADecryptProc: TCSADecryptProc;
  KeyStruct: array[0..800] of Byte;
  Key: array[0..15] of Byte;
  KeysOdd: TBlock;
  KeysEven: TBlock;
  KeysPreviousOdd: TBlock;
  KeysPreviousEven: TBlock;
  OddKeyFound: Boolean = False;
  EvenKeyFound: Boolean = False;
  KeyFound: Boolean = False;
  SAA_COMMAND: array[0..13] of Byte = ($10, 4, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0);

  // FFDeCsa
  FFSetKeyProc: TFFSetKeyProc;
  FFDecryptProc: TFFDecryptProc;
  FFKeySizeProc: TFFKeySizeProc;
  FFParallelismProc: TFFParallelismProc;

  FFCsaKeys: PByteArray;
  FFCsaKeySize: Integer;
  FFCsaClusters: TFFDeCsaClusters;

  {------------------------------------------------------------------------------
                                   Soft CSA End
   ------------------------------------------------------------------------------}

  {------------------------------------------------------------------------------
    Params  : <Index>  Bitmap to fill
              <Color>  Color to fill with
    Returns : -

    Descript: Fill bitmap with specified color (typically to clear it)
    Notes   :
   ------------------------------------------------------------------------------}

procedure OsdFillColor(Index: Byte; Color: TRGBQuad);
var
  Width: Integer;
  height: Integer;
begin
  if (Index > High(OsdBitmaps)) then
    Exit;
  for Width := 0 to COsdWidth - 1 do
    for Height := 0 to COsdHeight - 1 do
      OsdBitmaps[Index].Data[Width * COsdWidth + Height] := Color;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Clear OSD
  Notes   : Can use ANY bitmap here, but the main which is clear anyway is
            obviously the best
 ------------------------------------------------------------------------------}

procedure OsdClear;
begin
  if (DsOptions and CDirectShowMethodAlternative) <> 0 then
    DvbDirectShow2.DirectShowBlendImage(OsdBitmaps[0].DC, Rect(0, 0, COsdWidth,
      COsdHeight), 0.0, COsdTransparentColor)
  else
    DvbDirectShow.DirectShowGraph.DirectShowBlendImage(OsdBitmaps[0].DC, Rect(0,
      0, COsdWidth,
      COsdHeight), 0.0, COsdTransparentColor);
end;

{------------------------------------------------------------------------------
  Params  : <Index>  Bitmap to show
  Returns : -

  Descript: Show OSD
  Notes   :
 ------------------------------------------------------------------------------}

procedure OsdShow(Index: Byte);
begin
  if (Index > High(OsdBitmaps)) then
    Exit;
  if (DsOptions and CDirectShowMethodAlternative) <> 0 then
    DvbDirectShow2.DirectShowBlendImage(OsdBitmaps[Index].DC, Rect(0, 0,
      COsdWidth, COsdHeight), 1.0, COsdTransparentColor)
  else
    DvbDirectShow.DirectShowGraph.DirectShowBlendImage(OsdBitmaps[Index].DC,
      Rect(0, 0,
      COsdWidth, COsdHeight), 1.0, COsdTransparentColor);
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Show program info
  Notes   :
 ------------------------------------------------------------------------------}

procedure OsdShowInfo;
var
  DisplayStr: string;
begin
  SetBkColor(OsdBitmaps[1].DC, clWhite); // Pure white background
  SetTextColor(OsdBitmaps[1].DC, clBlack); // Write text with requested color

  OsdFillColor(1, COsdTransparentColorRGB);
  DisplayStr := format(' %4.4d - %s ', [Favourite + 1, ProgramName]);
  TextOut(OsdBitmaps[1].DC, 200, 250, @DisplayStr[1], Length(DisplayStr));
  if (DsOptions and CDirectShowMethodAlternative) <> 0 then
    DvbDirectShow2.DirectShowBlendImage(OsdBitmaps[1].DC, Rect(0, 0, COsdWidth,
      COsdHeight), 1.0, COsdTransparentColor)
  else
    DvbDirectShow.DirectShowGraph.DirectShowBlendImage(OsdBitmaps[1].DC, Rect(0,
      0, COsdWidth,
      COsdHeight), 1.0, COsdTransparentColor);
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>  True if success

  Descript: Give process the rights to do the action we require.
  Notes   :
 ------------------------------------------------------------------------------}

function EnableShutdownPrivileges: Boolean;
var
  ProcessHandle: THandle;
  TokenHandle: THandle;
  Token: TTokenPrivileges;
  Luid: TLargeInteger;
  PreviousState: TTokenPrivileges;
  ReturnLength: Dword;
  VersionInfo: TOSVersionInfo;
begin
  Result := False;
  // No need to set privileges for opetrating systems which don't support it
  VersionInfo.dwOSVersionInfoSize := SizeOf(TOSVersionInfo);
  if not GetVersionEx(VersionInfo) then
    Exit;
  if not ((VersionInfo.dwPlatformId = VER_PLATFORM_WIN32_NT) and
    (VersionInfo.dwMajorVersion >= 4)) then
  begin
    Result := True;
    Exit;
  end;
  ProcessHandle := GetCurrentProcess;
  if ProcessHandle <> 0 then
  begin
    if OpenProcessToken(ProcessHandle, TOKEN_ADJUST_PRIVILEGES or TOKEN_QUERY,
      TokenHandle) then
    begin
      if LookupPrivilegeValue('', 'SeShutdownPrivilege', Luid) then
      begin
        Token.PrivilegeCount := 1;
        Token.Privileges[0].Luid := Luid;
        Token.Privileges[0].Attributes := SE_PRIVILEGE_ENABLED;
        if AdjustTokenPrivileges(TokenHandle, False, Token,
          SizeOf(PreviousState), PreviousState, ReturnLength) then
          Result := True
      end;
    end;
  end;
end;

{------------------------------------------------------------------------------
  Params  : <ToChange>  Time string to change
  Returns : <Result>    Changes time string

  Descript: Convert ':' format into local time separator format
  Notes   :
 ------------------------------------------------------------------------------}

function ChangeTimeSeparator(ToChange: string): string;
var
  ThePos: Integer;
begin
  if TimeSeparator <> ':' then
  begin
    ThePos := Pos(':', ToChange);
    while ThePos <> 0 do
    begin
      ToChange[ThePos] := TimeSeparator;
      ThePos := Pos(':', ToChange);
    end;
  end;
  Result := ToChange;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Shutdown
  Notes   :
 ------------------------------------------------------------------------------}

procedure Shutdown;
var
  Flags: Integer;
begin
  Flags := EWX_POWEROFF or EWX_FORCE or EWX_FORCEIFHUNG;
  // Make sure we have the privilege to do the action we require
  if EnableShutdownPrivileges then
    ExitWindowsEx(Flags, 0);
end;

{------------------------------------------------------------------------------
  Params  : <LogString>  Data to log
            <Level>      Log level: if this number if <= <LogLevel> then
                         it is logged
                         $8x indicates that the string is intended for
                             displaying on form too.
  Returns : -

  Descript: Write data to log. A timestamp is added.
  Notes   :
 ------------------------------------------------------------------------------}

procedure ToLog(LogString: string; Level: Byte);
var
  NewLog: string;
begin
  if ((Level and $80) <> 0) and
    Assigned(frmMain) and
    Assigned(frmMain.mmoDriver) then
    frmMain.mmoDriver.Lines.Add(LogString);
  // Only log if the level is high enough
  if (Level and $0F) > LogLevel then
    Exit;
  // The check on <LogStream> is necessary because the application might
  // call this prior to completing initialization
  if not Assigned(LogStream) then
    Exit;
  NewLog := FormatDateTime('YYYYMMDD"T"HHMMSS"  "', Now) + LogString + #13#10;
  LogStream.Write(NewLog[1], Length(NewLog));
end;

{------------------------------------------------------------------------------
  Params  : <Section>    Section ta access in INI file
            <Paremeter>  Paremeter in INI file
            <Default>    Default value (eg. if not present in INI file)
  Returns : <Result>     String value for parameter

  Descript: Get parameter from INI file.
  Notes   : Either the local INI file is used or the global INI file.
            Comments (;) are stripped out (' and " indicates strings and are also
            removed from the result -> either ' or " is used as string
            indentifier, meaning the other one is handled as a normal character)
            If in the local ini no reference is found the application ini
            file is tried too.
            When using <TFastIniFile> then we actually don't need this
            function to behave as it does, eg. removing comments, since
            the <TFastIniFile> already has this behaviour included.
 ------------------------------------------------------------------------------}

function GetParameter(Section: string; Parameter: string; Default: string):
  string;
var
  FromIni: string;
  Position: Integer;
  TempStr: string;
begin
  // If we don't have a local INI file
  if not Assigned(IniFile) then
  begin
    Result := '';
    Exit;
  end;
  // Try to find it locally (no default so we get an empty string if nothing is found)
  FromIni := IniFile.ReadString(Section, Parameter, '');
  ToLog('GetParameter [local]: [' + Section + '][' + Parameter + '][' + Default
    +
    ']', $04);
  // Nothing found at all then use default
  if FromIni = '' then
    FromIni := Default;
  // Strip out leading/trailing spaces
  FromIni := Trim(FromIni);
  // Check for starting string parameter
  Position := Pos('''', FromIni);
  if Position = 1 then
  begin
    TempStr := Copy(FromIni, Position + 1, 255);
    // Find ending of string
    Position := Pos('''', TempStr);
    if Position <> 0 then
    begin
      // End of string found, which will be the result
      Result := Copy(TempStr, 1, Position - 1);
      ToLog('GetParameter result: [' + Result + ']', $05);
      Exit;
    end;
  end
  else
  begin
    Position := Pos('"', FromIni);
    if Position = 1 then
    begin
      TempStr := Copy(FromIni, Position + 1, 255);
      // Find ending of string
      Position := Pos('"', TempStr);
      if Position <> 0 then
      begin
        // End of string found, which will be the result
        Result := Copy(TempStr, 1, Position - 1);
        ToLog('GetParameter result: [' + Result + ']', $05);
        Exit;
      end;
    end;
  end;
  // We know we don't have a string type so handle the whole string as
  // normal text. We could have a comment in it so check this too
  Position := Pos(';', FromIni);
  if Position <> 0 then
  begin
    TempStr := Copy(FromIni, 1, Position - 1);
    // Strip out leading/trailing spaces
    Result := Trim(TempStr);
  end
  else
    Result := FromIni;
  ToLog('GetParameter result: [' + Result + ']', $05);
end;

{------------------------------------------------------------------------------
  Params  : <Filter>  Pointer to filter data
  Returns : -

  Descript: Update cross reference table for filters.
  Notes   :
------------------------------------------------------------------------------}

procedure FilterUpdateCrossReference(Filter: PTFilters);
var
  FilterIndex: Integer;
begin
  // Clear cross references
  Filter.Active := 0;
  Filter.ActiveText := '';
  for FilterIndex := Low(Filter.CrossReference) to High(Filter.CrossReference)
    do
    Filter.CrossReference[FilterIndex] := 0;
  // Renew cross reference
  for FilterIndex := Low(Filter.Filters) to High(Filter.Filters) do
    if Filter.Filters[FilterIndex].Active then
    begin
      Filter.CrossReference[Filter.Filters[FilterIndex].Pid] := FilterIndex;
      Inc(Filter.Active);
      if Filter.ActiveText = '' then
        Filter.ActiveText := format('%d', [Filter.Filters[FilterIndex].Pid])
      else
        Filter.ActiveText := Filter.ActiveText + ' ' + format('%d',
          [Filter.Filters[FilterIndex].Pid]);
    end;
end;

{------------------------------------------------------------------------------
  Params  : <Filter>  Pointer to filters
            <Name>    Name to search for
  Returns : -

  Descript: Remove filters which have the indicated name
  Notes   :
------------------------------------------------------------------------------}

procedure FilterRemoveByName(Filter: PTFilters; Name: string);
var
  FilterIndex: Integer;
begin
  ToLog('FilterRemoveByName: [' + Name + ']', $5);
  FilterLock.Acquire;
  try
    for FilterIndex := Low(Filter.Filters) to High(Filter.Filters) do
    begin
      Name := LowerCase(Name);
      if Name = 'video' then
        PidVideo := 0;
      if Name = 'audio' then
        PidAudio := 0;
      if Name = 'pmt' then
        PidPmt := 0;
      if Name = 'pcr' then
        PidPcr := 0;
      if Name = 'ecm' then
        PidEcm := 0;
      if Name = 'teletext' then
        PidTeletext := 0;
      if Name = 'subtitle' then
        PidSubtitle := 0;
      if LowerCase(Filter.Filters[FilterIndex].Name) = Name then
      begin
        Filter.Filters[FilterIndex].Active := False;
        FilterUpdateCrossReference(Filter);
      end;
    end;
  finally
    FilterLock.Release;
  end;
end;

{------------------------------------------------------------------------------
  Params  : <Filter>      Filter to use
            <Pid>         Pid for filter to set
            <FilterId>    Filter identifier (plugin)
            <FilterProc>  Callback function for Pid
            <Name>        Name for filter
  Returns : <Result>      Filter index in low part

  Descript: Set filter data
  Notes   :
------------------------------------------------------------------------------}

function DvbSetFilter(Filter: PTFilters; Pid: Word; FilterId: Word; FilterProc:
  Pointer; Name: PChar): Dword; stdcall;
var
  FilterIndex: Integer;
  Valid: Boolean;
  PString: string;
begin
  ToLog(format('DvbSetFilter %d (%s).', [Pid, Name]), $04);
  // Must be put into string otherwise check on <> '' will be wrong...
  PString := Name;
  if PString <> '' then
    FilterRemoveByName(Filter, PString);

  Result := 0;
  if Pid > High(Filter.CrossReference) then
    Exit;
  FilterLock.Acquire;
  try
    Valid := False;
    // First try to find existing active filter
    if Filter.CrossReference[Pid] <> 0 then
    begin
      FilterIndex := Filter.CrossReference[Pid];
      Valid := True;
    end
    else
    begin
      // No existing filter found for Pid, find first available one
      FilterIndex := Low(Filter.Filters);
      repeat
        if Filter.Filters[FilterIndex].Active then
          Inc(FilterIndex)
        else
          Valid := True;
      until Valid or (FilterIndex > High(Filter.Filters));
    end;
    if Valid then
    begin
      // Now set filter data and
      Filter.Filters[FilterIndex].Pid := Pid;
      Filter.Filters[FilterIndex].FilterId := FilterId;
      Filter.Filters[FilterIndex].CallBackFunction := FilterProc;
      Filter.Filters[FilterIndex].Name := Name;
      if LowerCase(Name) = 'video' then
        PidVideo := Pid;
      if LowerCase(Name) = 'audio' then
        PidAudio := Pid;
      if LowerCase(Name) = 'pmt' then
        PidPmt := Pid;
      if LowerCase(Name) = 'pcr' then
        PidPcr := Pid;
      if LowerCase(Name) = 'ecm' then
        PidEcm := Pid;
      if LowerCase(Name) = 'teletext' then
        PidTeletext := Pid;
      if LowerCase(Name) = 'subtitle' then
        PidSubtitle := Pid;
      Filter.Filters[FilterIndex].Active := True;
      FilterUpdateCrossReference(Filter);
      Result := FilterIndex;
    end;
  finally
    FilterLock.Release;
  end;
end;

{------------------------------------------------------------------------------
  Params  : <Filter>      Filter to use
            <FilterIndex> Filter index to clear
  Returns : <Result>      0 if no error

  Descript: Clear filter data
  Notes   :
------------------------------------------------------------------------------}

function DvbStopFilter(Filter: PTFilters; FilterIndex: Dword): Dword; stdcall;
begin
  ToLog(format('DvbStopFilter: [%d]', [FilterIndex]), $5);
  FilterLock.Acquire;
  try
    Result := 0;
    if FilterIndex < Low(Filter.Filters) then
      Exit;
    if FilterIndex > High(Filter.Filters) then
      Exit;
    Filter.Filters[FilterIndex].Active := False;
    FilterUpdateCrossReference(Filter);
  finally
    FilterLock.Release;
  end;
end;

{------------------------------------------------------------------------------
                                 MultiDec API
                                   Soft CSA
 ------------------------------------------------------------------------------}
{------------------------------------------------------------------------------
  Params  : <Plugin>  Plugin identifier
  Returns : -

  Descript: Start plugin (init).
            The plugin uses the handle to send MDAPI messages.
  Notes   : MDAPI requirement
------------------------------------------------------------------------------}

procedure MdPluginInit(Plugin: Word);
var
  Result: Integer;
  WriteLog: Boolean;
  Index: Integer;
begin
  ToLog(format('MdPlugInit: [%d]', [Plugin]), $5);
  try
    WriteLog := True;
    Result := 1;
    if MdPlugin[Plugin].DllIdentifier <> 0 then
      if Assigned(@MdPlugin[Plugin].InitPlugin) then
      begin
        FilterLock.Acquire;
        try
          // Initialize all filters
          for Index := Low(AppFilters.Filters) to High(AppFilters.Filters) do
            MdPlugin[Plugin].Filters.Filters[Index].Active := False;
          FilterUpdateCrossReference(@MdPlugin[Plugin].Filters);
        finally
          FilterLock.Release;
        end;
        MdPlugin[Plugin].InitPlugin(HInstance, frmMain.Handle, WriteLog, Plugin,
          @MdPlugin[Plugin].HotKey, 'MD-API Version 01.02', Result);
      end;
  except
  end;
end;

{------------------------------------------------------------------------------
  Params  : <Plugin>  Plugin identifier
  Returns : -

  Descript: Stop plugin (exit).
  Notes   : MDAPI requirement
------------------------------------------------------------------------------}

procedure MdPluginExit(Plugin: Word);
var
  WriteLog: Boolean;
  Index: Integer;
begin
  ToLog(format('MdPlugExit: [%d]', [Plugin]), $5);
  try
    WriteLog := True;
    if MdPlugin[Plugin].DllIdentifier <> 0 then
      if Assigned(@MdPlugin[Plugin].ExitMdPlugin) then
      begin
        FilterLock.Acquire;
        try
          // Remove all filters
          for Index := Low(AppFilters.Filters) to High(AppFilters.Filters) do
            MdPlugin[Plugin].Filters.Filters[Index].Active := False;
          FilterUpdateCrossReference(@MdPlugin[Plugin].Filters);
        finally
          FilterLock.Release;
        end;
        MdPlugin[Plugin].ExitMdPlugin(HInstance, frmMain.Handle, WriteLog);
      end;
  except
  end;
end;

{------------------------------------------------------------------------------
  Params  : <PluginIndex>  Index in plugin array
            <PluginName>   Fully qualified filename
  Returns : <Result>       True if success

  Descript: Add plugin to application
  Notes   :
------------------------------------------------------------------------------}

function CreatePlugin(PlugInIndex: Integer; PluginName: string): Boolean;
//var
//  MenuItemInfo: TMenuItemInfo;
//  Index       : Integer;
//  Index2      : Integer;
//  Index3      : Integer;
//  InUse       : Boolean;
begin
  Result := False;
  if PluginIndex > High(MdPlugin) then
    Exit;
  try
    MdPlugin[PlugInIndex].DllIdentifier := LoadLibrary(PChar(PluginName));
    // If it was a library
    if MdPlugin[PlugInIndex].DllIdentifier <> 0 then
    begin
      // Check for the entry of getting the name of the DLL: this also informs us that we might have a correct type of DLL ....
      MdPlugin[PlugInIndex].GetPluginName :=
        GetProcAddress(MdPlugin[PlugInIndex].DllIdentifier,
        'On_Send_Dll_ID_Name');
      if Assigned(@MdPlugin[PlugInIndex].GetPluginName) then
      begin
        // Get name of DLL: make sure we have the room for placing the result into
        // Make sure our destination string has enough room
        MdPlugin[PlugInIndex].Name := '                                ';
        MdPlugin[PlugInIndex].GetPluginName(@MdPlugin[PlugInIndex].Name[1]);
        // Add other entries for DLL
        MdPlugin[PlugInIndex].ProcessPluginMenuCommand :=
          GetProcAddress(MdPlugin[PlugInIndex].DllIdentifier, 'On_Menu_Select');
        MdPlugin[PlugInIndex].ProcessChannelChange :=
          GetProcAddress(MdPlugin[PlugInIndex].DllIdentifier,
          'On_Channel_Change');
        MdPlugin[PlugInIndex].ProcessFilterClose :=
          GetProcAddress(MdPlugin[PlugInIndex].DllIdentifier,
          'On_Filter_Close');
        MdPlugin[PlugInIndex].InitPlugin :=
          GetProcAddress(MdPlugin[PlugInIndex].DllIdentifier, 'On_Start');
        MdPlugin[PlugInIndex].ExitMDPlugin :=
          GetProcAddress(MdPlugin[PlugInIndex].DllIdentifier, 'On_Exit');
        MdPlugin[PlugInIndex].ProcessHotKey :=
          GetProcAddress(MdPlugin[PlugInIndex].DllIdentifier, 'On_Hot_Key');
        MdPlugin[PlugInIndex].ProcessRecPlay :=
          GetProcAddress(MdPlugin[PlugInIndex].DllIdentifier, 'On_Rec_Play');
        // Add the plugin menu to our own menu.
        // After this the plugin can be selected, with it's own submenu's
        // and such, but note that none of these (sub)menu's will generate
        // any action by itself. For this we have to pass the action manually
        // through to the <ProcessPluginMenuCommand>. See <WMCommand> on how
        // this is done.
        // Note: If this item is to be added to a submenu then you typically
        //       have to include a dummy menu item to make it work (this dummy
        //       menu item can be left invisible and disabled).
        MdPlugin[PlugInIndex].PluginMenu :=
          LoadMenu(MdPlugin[PlugInIndex].DllIdentifier, 'EXTERN');
        if AppendMenu(frmMain.mnuPlugins.Handle, MF_ENABLED or MF_POPUP,
          MdPlugin[PlugInIndex].PluginMenu, @MdPlugin[PlugInIndex].Name[1]) then
        begin
          (*          // We exchange the origianl menu identifier with our application
                    // identifier so multiple instances of a plugin can be individually
                    // addressed.
                    FillChar(MenuItemInfo,SizeOf(TMenuItemInfo), #0);
                    MenuItemInfo.cbSize     := SizeOf(TMenuItemInfo);
                    MenuItemInfo.fMask      := MIIM_ID;
                    Index := 0;
                    while GetMenuItemInfo(MdPlugin[PlugInIndex].PluginMenu, Index, True, MenuItemInfo) do
                    begin
                      // By default keep using original identifer
                      MdPlugin[PlugInIndex].PluginMenuItemId[Index].OriginalId    := MenuItemInfo.wID;
                      MdPlugin[PlugInIndex].PluginMenuItemId[Index].ApplicationId := MenuItemInfo.wID;
                      // Search for used identifiers ...
                      InUse := False;
                      if PlugInIndex > Low(MdPlugin) then
                        for Index2 := Low(MdPlugin) to PlugInIndex-1 do
                        begin
                          for Index3 := Low(MdPlugin[Index2].PluginMenuItemId) to High(MdPlugin[Index2].PluginMenuItemId) do
                            if MdPlugin[Index2].PluginMenuItemId[Index3].OriginalId = MenuItemInfo.wID then
                              InUse := True;
                          if InUse then
                          begin
                            // In use, replace by new identifier
                            MdPlugin[PlugInIndex].PluginMenuItemId[Index].ApplicationId := 55000 + (PlugInIndex * 100) + Index;
                            MenuItemInfo.wID := MdPlugin[PlugInIndex].PluginMenuItemId[Index].ApplicationId;
                            SetMenuItemInfo(MdPlugin[PlugInIndex].PluginMenu, Index, True, MenuItemInfo);
                          end;
                        end;
                      Inc(Index);
                    end;
          *)
          frmMain.mnuPlugins.Enabled := True;
          frmMain.mnuPlugins.Visible := True;
        end;
        // Set correct length for the name (without trailing #0)
        // Not really necessary but ...
        if Pos(#0, MdPlugin[PlugInIndex].Name) <> 0 then
          SetLength(MdPlugin[PlugInIndex].Name, Pos(#0,
            MdPlugin[PlugInIndex].Name) - 1);

        MdPlugin[PlugInIndex].PacketSize188 := False;
        if Pos(LowerCase(MdPlugin[PlugInIndex].Name), MdPluginPassFullPacket) <>
          0 then
          MdPlugin[PlugInIndex].PacketSize188 := True;
        Result := True;
      end
      else
      begin
        // Incorrect type of DLL, so free it
        FreeLibrary(MdPlugin[PlugInIndex].DllIdentifier);
        MdPlugin[PlugInIndex].DllIdentifier := 0;
      end;
    end;
  except
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Detect plugins
  Notes   : MDAPI requirement
------------------------------------------------------------------------------}

procedure FindMdPlugins;
var
  FindResult: Integer;
  SearchRec: TSearchRec;
  DirList: TStringList;
  PluginList: TStringList;
  Dir: Integer;
  Plugin: Integer;
  Index: Integer;
  Success: Integer;
begin
  ToLog('FindMdPlugins', $5);
  try
    // In case we call this when the have already been loaded ...
    for Index := Low(MdPlugin) to High(MdPlugin) do
      if MdPlugin[Index].DllIdentifier <> 0 then
        //        if Pos(LowerCase(MdPlugin[Index].Name), MdPluginDoNotFreeLibrary) = 0 then
        FreeLibrary(MdPlugin[Index].DllIdentifier);
    MdPlugins := 0;
    DirList := TStringList.Create;
    try
      DirList.Clear;
      DirList.Sorted := False;
      DirList.Add('.'); // V0.068 Also use application directory
      // We search in ALL the MDPLUGINSxxxx directories
      Success := FindFirst(ExeDirectory + 'MDPLUGINS*', faDirectory, SearchRec);
      if Success = 0 then
      try
        repeat
          DirList.Add(SearchRec.Name);
          FindResult := FindNext(SearchRec);
        until FindResult <> 0;
      finally
        SysUtils.FindClose(SearchRec);
      end;
      // We now have all the directories, now order them alphabetically
      DirList.Sort;
      if DirList.Count > 0 then
      begin
        PluginList := TStringList.Create;
        try
          for Dir := 0 to DirList.Count - 1 do
          begin
            PluginList.Clear;
            PluginList.Sorted := False;
            Success := FindFirst(ExeDirectory + DirList.Strings[Dir] + '\*.DLL',
              faAnyFile, SearchRec);
            if Success = 0 then
              repeat
                PluginList.Add(SearchRec.Name);
                FindResult := FindNext(SearchRec);
              until FindResult <> 0;
            // We now have all plugins in a directories, now order them alphabetically
            PluginList.Sort;
            if PluginList.Count > 0 then
            begin
              for Plugin := 0 to PluginList.Count - 1 do
                if CreatePlugin(MdPlugins, ExeDirectory + DirList.Strings[Dir] +
                  '\' + PluginList.Strings[Plugin]) then
                  Inc(MdPlugins);
            end;
          end;
        finally
          PluginList.Free;
        end;
      end;
    finally
      DirList.Free;
    end;
    // Now initialize the plugins
    // By default they are all started/initialized
    for Index := Low(MdPlugin) to High(MdPlugin) do
      MdPluginInit(Index);
  except
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Cleanup things assigned by plugins
  Notes   :
------------------------------------------------------------------------------}

procedure CleanupMdPlugins;
var
  Index: Word;
begin
  ToLog('CleanupMdPlugins', $5);
  try
    try
      if MdPlugins > 0 then
        for Index := 0 to MdPlugins - 1 do
          MdPluginExit(Index);
      if MdPlugins > 0 then
        for Index := 0 to MdPlugins - 1 do
          DestroyMenu(MdPlugin[Index].PluginMenu);
      // NOTE: THE FOLLOWING CODE CAN GIVE PROBLEMS WHEN DEBUGGING -> SPURIOUS RUNTIME ERROR
      //       THIS IS BECAUSE OF SPECIFIC PLUGINS WHICH DO NOT BEHAVE CORRECTLY (EG. PROBLEM
      //       RELEASING MEMORY AND SUCH)
      //       THEREFORE THE 'MdPluginDoNotFreeLibrary' OPTION ...
  //      if MdPlugins > 0 then
  //        for Index := 0 to MdPlugins-1 do
  //          if MdPlugin[Index].DllIdentifier <> 0 then
  //            if Pos(LowerCase(MdPlugin[Index].Name), MdPluginDoNotFreeLibrary) = 0 then
  //              FreeLibrary(MdPlugin[Index].DllIdentifier);
    finally
      MdPlugins := 0;
    end;
  except
  end;
end;

{------------------------------------------------------------------------------
  Params  : <Prg>  Program information
  Returns : -

  Descript: Let plugins know that a filter has been closed
  Notes   : MDAPI requirement
------------------------------------------------------------------------------}

procedure MdApiOnCloseFilters;
var
  Index: Word;
begin
  ToLog('MdApiOnCloseFilters', $5);
  try
    if MdPlugins > 0 then
      for Index := 0 to MdPlugins - 1 do
        if MdPlugin[Index].DllIdentifier <> 0 then
          if Assigned(@MdPlugin[Index].ProcessFilterClose) then
            MdPlugin[Index].ProcessFilterClose(HInstance);
  except
  end;
end;

{------------------------------------------------------------------------------
  Params  : <Prg>  Program information
  Returns : -

  Descript: Let plugins know that a channel change has occured.
  Notes   : MDAPI requirement
------------------------------------------------------------------------------}

procedure MdApiOnChannelChange(Prg: TProgram82);
var
  Index: Word;
begin
  ToLog('MdApiOnChannelChange', $5);
  try
    if MdPlugins > 0 then
      for Index := 0 to MdPlugins - 1 do
        if MdPlugin[Index].DllIdentifier <> 0 then
          if Assigned(@MdPlugin[Index].ProcessChannelChange) then
            MdPlugin[Index].ProcessChannelChange(Prg);
  except
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Sets keys for SoftCSA decoding
  Notes   : Command is layout as follows
             0 1 2 3 4 5 6 7 8 9 10 11 12 13
                     x                          0 = even keys in [6..13]
                     x                          1 = odd  keys in [6..13]
                         1 2 3 4 5  6  7  8     Typically the keys need endian swapping!
 ------------------------------------------------------------------------------}

procedure SetCSAKeys(Command: array of Byte);
var
  i: Integer;
  j: Integer;
  Change: Boolean;
begin
  // Sanity check
  if CsaMethod = cmNone then
    Exit;
  if Command[4] = 1 then
    OddKeyFound := True
  else
    EvenKeyFound := True;
  for i := 0 to 3 do
  begin
    // Do endian swapping
    Key[(Command[4]) * 8 + i * 2 + 0] := Command[6 + i * 2 + 1];
    Key[(Command[4]) * 8 + i * 2 + 1] := Command[6 + i * 2 + 0];
    // If we are using the internal decrytor then prepare keys
    if CsaMethod in [cmInternal, cmFfCsa] then
    begin
      if Command[4] = 0 then
        for j := 0 to 3 do
        begin
          KeysEven[j * 2 + 0] := Command[6 + j * 2 + 1];
          KeysEven[j * 2 + 1] := Command[6 + j * 2 + 0];
        end
      else
        for j := 0 to 3 do
        begin
          KeysOdd[j * 2 + 0] := Command[6 + j * 2 + 1];
          KeysOdd[j * 2 + 1] := Command[6 + j * 2 + 0];
        end;
    end;
  end;
  if OddKeyFound and EvenKeyFound then
  begin
    KeyFound := True;
    // Internal handling checks for a change here
    if CsaMethod = cmInternal then
    begin
      Change := False;
      for j := 0 to 7 do
      begin
        if KeysOdd[j] <> KeysPreviousOdd[j] then
          Change := True;
        if KeysEven[j] <> KeysPreviousEven[j] then
          Change := True;
      end;
      if Change then
      begin
        CSASetKeys(KeysOdd, KeysEven);
        for j := 0 to 7 do
        begin
          KeysPreviousOdd[j] := KeysOdd[j];
          KeysPreviousEven[j] := KeysEven[j];
        end;
      end;
    end
    else
    begin
      if CsaMethod = cmCsa then
        SetKeyProc(@Key[0], @KeyStruct[0]);
      if CsaMethod = cmFfCsa then
        FFSetKeyProc(@KeysEven[0], @KeysOdd[0], FFCsaKeys);
    end;
  end;
end;

{------------------------------------------------------------------------------
  Params  : <Msg>  Windows command
  Returns : -

  Descript: Handle commands (eg. menu items). Since we might have a plugin
            'connected' to a menu item we need to pass it on to there.
  Notes   : MDAPI requirement
------------------------------------------------------------------------------}

procedure TfrmMain.WMCommand(var Msg: TWMCommand);
var
  Index: Word;
begin
  ToLog(format('WMCommand: %d', [Msg.ItemId]), $5);
  try
    if MdPlugins > 0 then
      for Index := 0 to MdPlugins - 1 do
        if MdPlugin[Index].DllIdentifier <> 0 then
          if Assigned(@MdPlugin[Index].ProcessPluginMenuCommand) then
            //            if InitMenuPopup = MdPlugin[Index].PluginMenu then
            //            begin
            MdPlugin[Index].ProcessPluginMenuCommand(Msg.ItemId);
    //            end;
  except;
  end;
  inherited;
end;

{------------------------------------------------------------------------------
  Params  : <Msg>  Windows command
  Returns : -

  Descript: Handle selection of a (popup) menu.
  Notes   : Used for detecting which plugin should receive the WM_COMMAND
            message. Only of interest for multiple instances of a plugin.
------------------------------------------------------------------------------}
(*procedure TfrmMain.WMInitMenuPopup(var Msg: TWMInitMenuPopup);
begin
  ToLog('WMInitMenuPopup', $5);
  try
    // Make a note of the 'plugin' menu selection, so that only that plugin
    // receives the WM_COMMAND next
    InitMenuPopup := Msg.MenuPopup;
  except;
  end;
  inherited;
end;
*)

{------------------------------------------------------------------------------
  Params  : <Msg>  Windows command
  Returns : -

  Descript: Handle deselection of a (popup) menu.
  Notes   :
------------------------------------------------------------------------------}
(*procedure TfrmMain.WMUnInitMenuPopup(var Msg: TWMInitMenuPopup);
begin
  ToLog('WMUnInitMenuPopup', $5);
  try
  except;
  end;
  inherited;
end;
*)

{------------------------------------------------------------------------------
  Params  : <Program82>  Pointer to program information
  Returns : -

  Descript: Update MultiDec plugin program information
------------------------------------------------------------------------------}

procedure UpdateProgram82(Program82: PProgram82);
var
  Index: Integer;
  EmmCaSystemId: Word;
  EmmCaPid: Word;
  EmmIndex: Word;
  DummyP: TDvbPids;
  DummyW: Word;
  Language: TDvbLanguages;
  PidsEcm: TDvbPids;
  CasId: TDvbPids;
  ValidCount: Integer;
  Nothing: Boolean;
  LogString: string;
  PrgName: string;
  Error: Integer;
  ProcessString: string;
begin
  StrPCopy(Program82.Name, Copy(ProgramName, 1, SizeOf(Program82.Name)));
  Program82.Freq := Frequency;
  Program82.Video_pid := PidVideo;
  Program82.Audio_pid := PidAudio;
  Program82.Teletext_pid := PidTeletext;
  Program82.PCR_pid := PidPcr;
  Program82.PMT_pid := PidPmt;
  Program82.ECM_pid := PidEcm;
  Program82.CA_ID := 0;
  Program82.SID_pid := ServiceNumber;

  Program82.CA_NR := 0;
  // Do not read realtime data just after a transponder change if no update
  // is received yet
  if TransponderHasChanged = $0000 then
  begin
    ToLog('UpdateProgram82 (not using realtime data yet)', $3);
    Exit;
  end;

  LogString := 'UpdateProgram82 (' + ProgramName + '): ECM: ';
  // Get realtime info: Do it with a retry.
  ValidCount := 5;
  Nothing := True;
  repeat
    if DvbGetProgramInfo($FF, ServiceNumber, DummyW, DummyW, DummyP, DummyP,
      DummyP, DummyP, Language, Language, PidsEcm, CasId, PrgName) then
    begin
      // The name is most likely not yet received so only use that one if it is available
      if PrgName <> '' then
        ProgramName := PrgName;
      // Update name
      StrPCopy(Program82.Name, Copy(ProgramName, 1, SizeOf(Program82.Name)));
      // Fill in available ECM's
      Index := 0;
      while ((PidsEcm[Index] <> 0) and (Index <= High(Program82.CA_System82)))
        do
      begin
        Program82.CA_System82[Index].CA_Type := CasId[Index];
        Program82.CA_System82[Index].ECM := PidsEcm[Index];
        Program82.CA_System82[Index].EMM := 0;
        Program82.CA_System82[Index].Provider_Id := ServiceNumber;
        LogString := Logstring + format('%d ', [PidsEcm[Index]]);
        Inc(Index);
      end;
      Program82.CA_NR := Index;
      ValidCount := 1;
      Nothing := False;
    end
    else
      Sleep(10);
    Dec(ValidCount);
  until ValidCount = 0;
  if Nothing then
    LogString := LogString + 'none  ';
  LogString := LogString + '  EMM: ';
  Nothing := True;
  if frmMain.chkEmmManual.Checked then
  begin
    // Only add EMM if there are ECM's (otherwise it might 'upset' some plugins)
    if Program82.CA_NR > 0 then
    begin
      Nothing := False;
      ProcessString := frmMain.edtEmmPids.Text;
      ProcessString := Trim(ProcessString);
      while ProcessString <> '' do
      begin
        ProcessString := Trim(ProcessString);
        Val(ProcessString, EmmCaPid, Error);
        if Error <> 1 then
        begin
          if Error = 0 then
            ProcessString := ''
          else
            Delete(ProcessString, 1, Error - 1);
          Index := Program82.CA_NR;
          Program82.CA_System82[Index].ECM := 0;
          Program82.CA_System82[Index].Provider_Id := 0;
          Program82.CA_NR := Index + 1;

          Program82.CA_System82[Index].EMM := EmmCaPid;
          LogString := Logstring + format('%d ', [EmmCaPid]);
        end
        else
          Delete(ProcessString, 1, 1);
      end;
    end;
  end
  else
  begin
    frmMain.edtEmmPids.Text := '';
    // Only add EMM if there are ECM's (otherwise it might 'upset' some plugins)
    if Program82.CA_NR > 0 then
    begin
      Nothing := False;
      // Get through EMM's one at the time
      // Note that EMM's are system wide (not program related)
      EmmIndex := 0;
      while (DvbFilterGetEmm(EmmIndex, EmmCaSystemId, EmmCaPid) and
        (Program82.CA_NR <= High(Program82.CA_System82))) do
      begin
        Index := Program82.CA_NR;
        Program82.CA_System82[Index].ECM := 0;
        Program82.CA_System82[Index].Provider_Id := 0;
        Program82.CA_NR := Index + 1;

        Program82.CA_System82[Index].CA_Type := EmmCaSystemId;
        Program82.CA_System82[Index].EMM := EmmCaPid;
        LogString := Logstring + format('%d ', [EmmCaPid]);
        frmMain.edtEmmPids.Text := frmMain.edtEmmPids.Text + format('%d ',
          [EmmCaPid]);
        Inc(EmmIndex);
      end;
    end;
  end;
  if Nothing then
    LogString := LogString + 'none  ';
  ToLog(LogString, $3);
end;

procedure TfrmMain.edtEmmPidsExit(Sender: TObject);
var
  Program82: TProgram82;
begin
  if edtEmmPids.Modified then
  begin
    chkEmmManual.Checked := True;
    UpdateProgram82(@Program82);
    MdApiOnChannelChange(Program82);
  end;
end;

procedure TfrmMain.edtEmmPidsKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    edtEmmPidsExit(nil);
end;

{------------------------------------------------------------------------------
  Params  : <Msg>  Windows message
                   WParam has the MDAPI call
                   LParam has the pointer to the data or contains the data itself
  Returns : -

  Descript: Handle messages from plugins and such
  Notes   : MDAPI requirement
------------------------------------------------------------------------------}

procedure TfrmMain.WMUser(var Msg: TMessage);
var
  StartFilterParam: PStartFilterParam;
  Index: Byte;
  DebugString: string;
  Change: Boolean;
  Plugin: Integer;
begin
  // Do not handle it if no plugins (or terminated)
  if MdPlugins = 0 then
    Exit;
  case Msg.WParam of
    MDAPI_GET_TRANSPONDER: DebugString := 'MDAPI_GET_TRANSPONDER   ';
    MDAPI_SET_TRANSPONDER: DebugString := 'MDAPI_SET_TRANSPONDER   ';
    MDAPI_GET_PROGRAM: DebugString := 'MDAPI_GET_PROGRAM       ';
    MDAPI_SET_PROGRAM: DebugString := 'MDAPI_SET_PROGRAM       ';
    MDAPI_RESCAN_PROGRAM: DebugString := 'MDAPI_RESCAN_PROGRAM    ';
    MDAPI_SAVE_PROGRAM: DebugString := 'MDAPI_SAVE_PROGRAM      ';
    MDAPI_GET_PROGRAM_NUMBER: DebugString := 'MDAPI_GET_PROGRAM_NUMBER';
    MDAPI_SET_PROGRAM_NUMBER: DebugString := 'MDAPI_SET_PROGRAM_NUMBER';
    MDAPI_START_FILTER: DebugString := 'MDAPI_START_FILTER      ';
    MDAPI_STOP_FILTER: DebugString := 'MDAPI_STOP_FILTER       ';
    MDAPI_SCAN_CURRENT_TP: DebugString := 'MDAPI_SCAN_CURRENT_TP   ';
    MDAPI_SCAN_CURRENT_CAT: DebugString := 'MDAPI_SCAN_CURRENT_CAT  ';
    MDAPI_START_OSD: DebugString := 'MDAPI_START_OSD         ';
    MDAPI_OSD_DRAWBLOCK: DebugString := 'MDAPI_OSD_DRAWBLOCK     ';
    MDAPI_OSD_SETFONT: DebugString := 'MDAPI_OSD_SETFONT       ';
    MDAPI_OSD_TEXT: DebugString := 'MDAPI_OSD_TEXT          ';
    MDAPI_SEND_OSD_KEY: DebugString := 'MDAPI_SEND_OSD_KEY      ';
    MDAPI_STOP_OSD: DebugString := 'MDAPI_STOP_OSD          ';
    MDAPI_DVB_COMMAND: DebugString := 'MDAPI_DVB_COMMAND       ';
    MDAPI_GET_VERSION: DebugString := 'MDAPI_GET_VERSION       ';
  else
    DebugString := 'Unknown MD-API command';
  end;
  ToLog(format('MDAPI command %s %d %d.', [DebugString, Msg.LParam,
    Msg.WParam]), $05);

  case Msg.WParam of
    //    MDAPI_GET_TRANSPONDER: ;
    //    MDAPI_SET_TRANSPONDER: ;
    MDAPI_GET_PROGRAM:
      UpdateProgram82(PProgram82(Msg.LParam));
    MDAPI_SET_PROGRAM:
      begin
        if MdPluginAllowSetPids then
        begin
          Change := False;
          if PidVideo <> PProgram82(Msg.LParam)^.Video_pid then
          begin
            PidVideo := PProgram82(Msg.LParam)^.Video_pid;
            frmMain.cmbVideoPids.Text := format('%4.4d', [PidVideo]);
            Change := True;
          end;
          if PidAudio <> PProgram82(Msg.LParam)^.Audio_pid then
          begin
            PidAudio := PProgram82(Msg.LParam)^.Audio_pid;
            frmMain.cmbAudioPids.Text := format('%4.4d', [PidAudio]);
            Change := True;
          end;
          if PidTeletext <> PProgram82(Msg.LParam)^.Teletext_pid then
          begin
            PidTeletext := PProgram82(Msg.LParam)^.Teletext_pid;
            frmMain.cmbTeletextPids.Text := format('%4.4d', [PidTeletext]);
            Change := True;
          end;
          if PidPCR <> PProgram82(Msg.LParam)^.PCR_pid then
          begin
            PidPCR := PProgram82(Msg.LParam)^.PCR_pid;
            frmMain.mskPcr.Text := format('%4.4d', [PidPCR]);
            Change := True;
          end;
          if PidPMT <> PProgram82(Msg.LParam)^.PMT_pid then
          begin
            PidPMT := PProgram82(Msg.LParam)^.PMT_pid;
            frmMain.mskPmt.Text := format('%4.4d', [PidPMT]);
            Change := True;
          end;
          if PidEcm <> PProgram82(Msg.LParam)^.ECM_pid then
          begin
            PidEcm := PProgram82(Msg.LParam)^.ECM_pid;
            frmMain.cmbEcmPids.Text := format('%4.4d', [PidEcm]);
            Change := True;
          end;
          if Change then
            SendMessage(frmMain.Handle, WM_REMOTE,
              Integer(CRemoteMessageSettings), 0);
        end;
      end;
    //    MDAPI_RESCAN_PROGRAM: ;
    //    MDAPI_SAVE_PROGRAM  : ;
    MDAPI_GET_PROGRAM_NUMBER:
      begin
        PProgramNumberParam(Msg.LParam)^.RealNumber := ServiceNumber;
        PProgramNumberParam(Msg.LParam)^.VirtNumber := ServiceNumber;
      end;
    //    MDAPI_SET_PROGRAM_NUMBER: ;
    MDAPI_START_FILTER:
      begin
        StartFilterParam := PStartFilterParam(Msg.LParam);
        // First find plugin in our list. Since the plugin ID is the same as the index
        // this is very easy ...
        if (StartFilterParam^.DLLIdentifier >= MdPlugins) then
          Exit;
        // Add the filter and create an identifier which will be used by ..STOP_FILTER
        StartFilterParam^.Running_ID := ((StartFilterParam^.DLLIdentifier and
          $FF) shl 8)
          or DvbSetFilter(@MdPlugin[StartFilterParam^.DLLIdentifier].Filters,
          StartFilterParam^.Pid, StartFilterParam^.Filter_ID,
          Pointer(StartFilterParam^.CallAddress),
          PChar(@(StartFilterParam^.Name[0])));
      end;
    MDAPI_STOP_FILTER:
      begin
        // The identifier has the plugin identifier in the high byte and the filter in the low byte (see .._START_FILTER)
        Plugin := (Msg.LParam and $FF00) shr 8;
        if Plugin >= MdPlugins then
          Exit;
        DvbStopFilter(@MdPlugin[Plugin].Filters, Msg.LParam and $FF);
      end;
    //    MDAPI_SCAN_CURRENT_TP : ;
    //    MDAPI_SCAN_CURRENT_CAT: ;
    //    MDAPI_START_OSD       : ;
    //    MDAPI_OSD_DRAWBLOCK   : ;
    //    MDAPI_OSD_SETFONT     : ;
    //    MDAPI_OSD_TEXT        : ;
    //    MDAPI_SEND_OSD_KEY    : ;
    //    MDAPI_STOP_OSD        : ;
    //    MDAPI_DVB_COMMAND     : ;
    MDAPI_GET_VERSION:
      begin
        StrPCopy(PChar(Msg.LParam), 'MD-API Version 01.02 Root 254376');
      end;
    MDAPI_DVB_COMMAND:
      begin
        // SoftCSA
        if PDVB_COMMAND(msg.LParam)^.CmdLength = 7 then
          for Index := 4 to 13 do
            SAA_COMMAND[Index] := PDVB_COMMAND(Msg.LParam)^.CmdBuffer[Index];
        SetCSAKeys(SAA_COMMAND);
      end;
  end;
end;
{------------------------------------------------------------------------------
                                 MultiDec API
                                   Soft CSA
 ------------------------------------------------------------------------------}

{------------------------------------------------------------------------------
  Params  : <FullScreen>  True to set full screen mode
                          False to restore original mode
  Returns : -

  Descript: Set full screen mode
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.FullScreenMode(FullScreen: Boolean);
begin
  if not Assigned(FFullScreenForm) then
    Exit;
  if FullScreen <> FFullScreenMode then
  begin
    if (DsOptions and CDirectShowMethodAlternative) <> 0 then
    begin
      if DvbDirectShow2.DirectShowWindowless then
      begin
        if FullScreen then
        begin
          DvbDirectShow2.DirectShowSetVideo(FFullScreenForm.Handle);
          Self.Hide;
          FFullScreenForm.Show;
        end
        else
        begin
          DvbDirectShow2.DirectShowSetVideo(pnlVideo.Handle);
          FFullScreenForm.Hide;
          Self.Show;
        end;
      end;
      DvbDirectShow2.DirectShowFullScreenMode(FullScreen);
      DvbDirectShow2.DirectShowResize;
      FFullScreenMode := FullScreen;
    end
    else
    begin
      if DvbDirectShow.DirectShowGraph.DirectShowWindowless then
      begin
        if FullScreen then
        begin
          DvbDirectShow.DirectShowGraph.DirectShowSetVideo(FFullScreenForm.Handle);
          Self.Hide;
          FFullScreenForm.Show;
        end
        else
        begin
          DvbDirectShow.DirectShowGraph.DirectShowSetVideo(pnlVideo.Handle);
          FFullScreenForm.Hide;
          Self.Show;
        end;
      end;
      DvbDirectShow.DirectShowGraph.DirectShowFullScreenMode(FullScreen);
      DvbDirectShow.DirectShowGraph.DirectShowResize;
      FFullScreenMode := FullScreen;
    end;
  end;
end;

{------------------------------------------------------------------------------
  Params  : <Msg>  Windows message
                   WParam has component index
  Returns : -

  Descript: Handle messages from remote control
  Notes   :
------------------------------------------------------------------------------}

procedure TfrmMain.WMRemote(var Msg: TMessage);
var
  Key: Char;
begin
  ToLog('WMRemote', $5);
  if Msg.WParam = Integer(CRemoteMessageUp) then
    imgUpClick(nil);
  if Msg.WParam = Integer(CRemoteMessageDown) then
    imgDownClick(nil);
  if Msg.WParam = Integer(CRemoteMessageLeft) then
    imgLeftClick(nil);
  if Msg.WParam = Integer(CRemoteMessageRight) then
    imgRightClick(nil);
  if Msg.WParam = Integer(CRemoteMessageRecord) then
    imgRecordClick(nil);
  if Msg.WParam = Integer(CRemoteMessageReInit) then
    btnReInitClick(nil);
  if Msg.WParam = Integer(CRemoteMessageUpdate) then
    btnUpdateClick(nil);

  if Msg.WParam = Integer(CRemoteMessageRecordOn) then
  begin
    if Recording = rtIdle then
      imgRecordClick(nil);
  end;
  if Msg.WParam = Integer(CRemoteMessageRecordOff) then
  begin
    if not (Recording = rtIdle) then
      imgRecordClick(nil);
  end;

  // Handle EPG commands only when visible
  if chkEpg.Visible then
  begin
    if Msg.WParam = Integer(CRemoteMessageEPG) then
    begin
      chkEpg.Checked := not chkEpg.Checked;
      chkEpg.OnClick(nil);
    end;
    if Msg.WParam = Integer(CRemoteMessageEPGShort) then
    begin
      chkEpgShortNameOnly.Checked := not chkEpgShortNameOnly.Checked;
      chkEpgShortNameOnly.OnClick(nil);
    end;
    if Msg.WParam = Integer(CRemoteMessageEPGCurrent) then
    begin
      chkEpgPresentInfoOnly.Checked := not chkEpgPresentInfoOnly.Checked;
      chkEpgPresentInfoOnly.OnClick(nil);
    end;
  end;

  if Msg.WParam = Integer(CRemoteMessageVideo) then
  begin
    chkVideo.Checked := not chkVideo.Checked;
    chkVideo.OnClick(nil);
  end;
  if Msg.WParam = Integer(CRemoteMessageAudio) then
  begin
    chkAudio.Checked := not chkAudio.Checked;
    chkAudio.OnClick(nil);
  end;
  if Msg.WParam = Integer(CRemoteMessagePids) then
  begin
    chkPids.Checked := not chkPids.Checked;
    chkPids.OnClick(nil);
  end;
  if Msg.WParam = Integer(CRemoteMessageDirectShow) then
  begin
    chkDirectShow.Checked := not chkDirectShow.Checked;
    chkDirectShow.OnClick(nil);
  end;
  if Msg.WParam = Integer(CRemoteMessageTransponder) then
  begin
    chkTransponderDisplay.Checked := not chkTransponderDisplay.Checked;
    chkTransponderDisplay.OnClick(nil);
  end;
  if Msg.WParam = Integer(CRemoteMessageShutDown) then
  begin
    ShutdownOnExit := True;
    Application.Terminate;
  end;
  if Msg.WParam = Integer(CRemoteMessageExit) then
  begin
    ShutdownOnExit := False;
    Application.Terminate;
  end;
  if Msg.WParam = Integer(CRemoteMessageFullScreen) then
  begin
    // For some reason we can get here multiple time at a key press
    // so suppress those
    if (Now - FullScreenTimeOut) < EncodeTime(0, 0, 0, 250) then
      Exit;
    FullScreenTimeout := Now;
    FullScreenMode(not FFullScreenMode);
  end;
  if Msg.WParam = Integer(CRemoteMessageFullScreenOn) then
  begin
    FullScreenMode(True);
  end;
  if Msg.WParam = Integer(CRemoteMessageFullScreenOff) then
  begin
    FullScreenMode(False);
  end;
  if Msg.WParam = Integer(CRemoteMessageSettings) then
    UpdateSettings(nil);

  // Mute / Volume
  if Msg.WParam = Integer(CRemoteMessageMute) then
    Mixer.VolumeMute := not Mixer.VolumeMute;
  if Msg.WParam = Integer(CRemoteMessageMuteOn) then
    Mixer.VolumeMute := True;
  if Msg.WParam = Integer(CRemoteMessageMuteOff) then
    Mixer.VolumeMute := False;
  if Msg.WParam = Integer(CRemoteMessageVolumeUp) then
  begin
    Mixer.VolumeUp;
    Mixer.VolumeMute := False;
  end;
  if Msg.WParam = Integer(CRemoteMessageVolumeDown) then
  begin
    Mixer.VolumeDown;
    Mixer.VolumeMute := False;
  end;

  if Msg.WParam = Integer(CRemoteMessageLanguage) then
  begin
    if cmbAudioPids.ItemIndex < (cmbAudioPids.Items.Count - 1) then
      cmbAudioPids.ItemIndex := cmbAudioPids.ItemIndex + 1
    else
      cmbAudioPids.ItemIndex := 0;
    UpdateSettings(cmbAudioPids);
  end;
  if Msg.WParam = Integer(CRemoteMessageDisable) then
    btnDisableEnableClick(nil);
  if Msg.WParam = Integer(CRemoteMessageScramble) then
    btnScrambleClick(nil);

  Key := #0;
  if Msg.WParam = Integer(CRemoteMessage0) then
    Key := '0';
  if Msg.WParam = Integer(CRemoteMessage1) then
    Key := '1';
  if Msg.WParam = Integer(CRemoteMessage2) then
    Key := '2';
  if Msg.WParam = Integer(CRemoteMessage3) then
    Key := '3';
  if Msg.WParam = Integer(CRemoteMessage4) then
    Key := '4';
  if Msg.WParam = Integer(CRemoteMessage5) then
    Key := '5';
  if Msg.WParam = Integer(CRemoteMessage6) then
    Key := '6';
  if Msg.WParam = Integer(CRemoteMessage7) then
    Key := '7';
  if Msg.WParam = Integer(CRemoteMessage8) then
    Key := '8';
  if Msg.WParam = Integer(CRemoteMessage9) then
    Key := '9';
  if Key <> #0 then
  begin
    if (FStateMachineKeys = -1) then
    begin
      PrevKeyData := KeyData;
      KeyData := 0;
    end;
    if KeyData > 1000 then
      KeyData := 0;
    KeyData := (KeyData * 10) + (Ord(Key) - Ord('0'));
    FStateMachineKeys := 0;
    if not tmrStateMachineKeys.Enabled then
    begin
      // Note the different delay with respect to normal keyboard keys
      tmrStateMachineKeys.Interval := TimeoutNumericalKeysRemote;
      tmrStateMachineKeys.Enabled := True;
    end;
  end;
  if Msg.WParam = Integer(CRemoteMessagePp) then
  begin
    if not TransponderDisplay then
      cmbFavourites.ItemIndex := FavouriteOld
    else
      cmbTransponders.ItemIndex := TransponderOld;
    UpdateSettings(cmbTransponders);
  end;
end;

{------------------------------------------------------------------------------
  Params  : <Msg>  Windows message
                   WParam has type of signalling index
                   LParam has additional signalling data (eg. PID if CSignalPid)
  Returns : -

  Descript: Handle messages from PID filter signalling
  Notes   :
------------------------------------------------------------------------------}

procedure TfrmMain.WMSignalling(var Msg: TMessage);
begin
  case Msg.WParam of
    CSignalEvent:
      begin
        if (Msg.LParam = ServiceNumber) or (ServiceNumber = 0) then
        begin
          ToLog(format('WMSignalling - Event (Id: %d)', [Msg.LParam]), $5);
          UpdateEvent := True;
        end
        else
          ToLog(format('WMSignalling - Event (Id: %d) - not handled',
            [Msg.LParam]), $5);
      end;
    CSignalPat:
      begin
        ToLog(format('WMSignalling - PAT (Version: %d)', [Msg.LParam]), $5);
        UpdatePAT := True;
      end;
    CSignalCat:
      begin
        ToLog(format('WMSignalling - CAT (Version: %d)', [Msg.LParam]), $5);
        UpdateCAT := True;
      end;
    CSignalPmt:
      begin
        if (Msg.LParam = ServiceNumber) or (ServiceNumber = 0) then
        begin
          ToLog(format('WMSignalling - PMT (Id: %d)', [Msg.LParam]), $5);
          UpdatePmt := True;
          UpdatePat := True;
        end
        else
          ToLog(format('WMSignalling - PMT (Id: %d) - not handled',
            [Msg.LParam]), $5);
      end;
    CSignalPid: case Msg.LParam of
        CPidNIT:
          begin
            ToLog('WMSignalling - NIT', $5);
            UpdateProgram := True;
          end;
      else
        ToLog(format('WMSignalling - PID: %d', [Msg.LParam]), $5);
      end;
  else
    ToLog(format('WMSignalling - [%d / %d]', [Msg.WParam, Msg.LParam]), $5);
  end;
end;

{------------------------------------------------------------------------------
  Params  : <StreamData>  Stream packets (multiple packets of 188 bytes)
  Returns : -

  Descript: Decode transport stream. We simply call the filter procedures
            which have been set.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TDataThread.DescrambleFfDeCsa;
var
  StreamPacket: Word;
  Pid: Word;
  Plugin: Word;
  Processed: Integer;
  ProcessIndex: Integer;
  ProcessIt: Boolean;
begin
  // The FFDeCsa mechanism works with multiple packets. Because of this
  // these are handled before any other handling takes place. Since this is
  // always processed, even with a non-scrambled signal, some minor
  // performance degradation takes place for non-scrambled signals. Also
  // we can no longer use the original check on a scrambled signal, which
  // was packet based.
  if (not FilteringOff) and
    (not FiltersOff) then
  begin
    if (CsaMethod = cmFfCsa) then
    begin
      // First setup the array with pointers to the data. We set each individual
      // packet here which should optimize the whole.
      // Note: If we don't do a check on the 'used' PIDs then we would be
      //       descrambling the whole stream
      ProcessIndex := 0;
      for StreamPacket := 0 to CDvbPacketVSync - 1 do
      begin
        if DvbGetPid(@FStreamData[StreamPacket], Pid) then
        begin
          ProcessIt := False;
          if MdPlugins > 0 then
            for Plugin := 0 to MdPlugins - 1 do
              if MdPlugin[Plugin].Filters.CrossReference[Pid] <> 0 then
              begin
                ProcessIt := True;
                Break;
              end;
          if not ProcessIt then
            if AppFilters.CrossReference[Pid] <> 0 then
              ProcessIt := True;
          // Only if scrambled ...
          if Processit and ((FStreamData[StreamPacket][3] and $80) <> 0) then
          begin
            // Record if scrambled or not
            if Pid <> 0 then
            begin
              if Pid = PidVideo then
                VideoCheckScrambled := True;
              if Pid = PidAudio then
                AudioCheckScrambled := True;
            end;
          end
          else
            ProcessIt := False;
          if ProcessIt then
          begin
            FFCsaClusters[ProcessIndex].StartBuffer :=
              @FStreamData[StreamPacket][0];
            FFCsaClusters[ProcessIndex].EndBuffer :=
              @FStreamData[StreamPacket][187];
            Inc(ProcessIndex);
          end;
        end;
      end;
      // Mark end of table
      FFCsaClusters[ProcessIndex].StartBuffer := nil;
      FFCsaClusters[ProcessIndex].EndBuffer := nil;
      if KeyFound then
        repeat
          try
            try
              Processed := FFDecryptProc(@FFCsaClusters, FFCsaKeys);
            finally
              // Restore floating point stuff which is upset by FfDeCsa
              Set8087CW(Default8087CW);
            end;
          except
            Processed := 0;
          end;
        until Processed = 0;
    end;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Decode transport stream. We simply call the filter procedures
            which have been set.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TDataThread.DecodeTransportStreamData;
var
  StreamPacket: Word;
  Pid: Word;
  Filter: TDvbPacketFilter;
  ToSend: Boolean;
  CrossReference: Word;
  Plugin: Integer;
  VideoStillScrambled: Boolean;
  AudioStillScrambled: Boolean;
  {------------------------------------------------------------------------------
    Params  : -
    Returns : -

    Descript: Handle recording. This is either called before filtering
              or after it (depending if raw data is to be recorded)
    Notes   :
   ------------------------------------------------------------------------------}
  procedure HandleRecording;
  var
    Loop: Byte;
  begin
    // Depending on the recording state do different stuff
    case Recording of
      rtIdle:
        begin
          if ProcessPids then
          begin
            // Internal filtering
            // Get function for PID for processing
            Filter := DvbGetPidFilter(Pid);
            if Assigned(@Filter) then
            begin
              Filter(@FStreamData[StreamPacket]);
            end;
          end;
        end;
      rtStartRecording:
        begin
          Recording := rtRecording
        end;
      rtRecording:
        begin
          if RecordingAllData then
          begin
            RecordingAllFile.Write(FStreamData[StreamPacket], CDvbPacketSize);
            if RecordingSplitted then
            begin
              if LongWord(RecordingAllFile.Position) > RecordingSplitSize then
              begin
                RecordingAllSplitSize := RecordingAllSplitSize +
                  LongWord(RecordingAllFile.Position);
                FreeAndNil(RecordingAllFile);
                Inc(RecordingAllFilePart);
                RecordingAllFile := TFileStream.Create(format('%s_%3.3d.TS',
                  [RecordingAllFileFileName, RecordingAllFilePart]), fmCreate);
              end;
            end;
          end
          else
            // Write packet to file if requested
            for Loop := Low(RecordingPids) to High(RecordingPids) do
              if RecordingPids[Loop].Pid = Pid then
              begin
                RecordingPids[RecordingPids[Loop].RecordingLink].RecordingFile.Write(FStreamData[StreamPacket], CDvbPacketSize);
                if RecordingSplitted then
                begin
                  if
                    LongWord(RecordingPids[RecordingPids[Loop].RecordingLink].RecordingFile.Position) > RecordingSplitSize then
                  begin
                    RecordingPids[RecordingPids[Loop].RecordingLink].SplitSize
                      :=
                      RecordingPids[RecordingPids[Loop].RecordingLink].SplitSize
                        +
                      LongWord(RecordingPids[RecordingPids[Loop].RecordingLink].RecordingFile.Position);
                    FreeAndNil(RecordingPids[RecordingPids[Loop].RecordingLink].RecordingFile);
                    Inc(RecordingPids[RecordingPids[Loop].RecordingLink].SplitIndex);
                    RecordingPids[RecordingPids[Loop].RecordingLink].RecordingFile := TFileStream.Create(format('%s_%3.3d.TS',
                      [RecordingPids[RecordingPids[Loop].RecordingLink].RecordingFileFileName,
                      RecordingPids[RecordingPids[Loop].RecordingLink].SplitIndex]), fmCreate);
                  end;
                end;
              end;
        end;
      rtStopRecording:
        begin
          Recording := rtIdle;
        end;
    end;
  end;

  procedure Descramble;
  begin
    // SoftCSA, check for scrambled data (not if FFDeCSA because this has already
    // processed the data)
    if (CsaMethod <> cmFfCsa) and
      ((FStreamData[StreamPacket][3] and $80) <> 0) then
    begin
      if Pid <> 0 then
      begin
        if Pid = PidVideo then
          VideoCheckScrambled := True;
        if Pid = PidAudio then
          AudioCheckScrambled := True;
      end;
      try
        if KeyFound then
          if CsaMethod = cmInternal then
            CSADecrypt(@FStreamData[StreamPacket])
          else if CsaMethod = cmCsa then
            CSADecryptProc(@KeyStruct[0], @FStreamData[StreamPacket]);
      except
      end;
    end;
  end;

begin
  // Special case while scanning - only do internal filtering
  if Scanning then
  begin
    for StreamPacket := 0 to CDvbPacketVSync - 1 do
    begin
      if DvbGetPid(@FStreamData[StreamPacket], Pid) then
      begin
        Filter := DvbGetPidFilter(Pid);
        if Assigned(@Filter) then
          Filter(@FStreamData[StreamPacket]);
      end;
    end;
    Exit;
  end;
  // If not scanning
  VideoCheckScrambled := False;
  AudioCheckScrambled := False;
  VideoStillScrambled := False;
  AudioStillScrambled := False;
  // Because of possible floating point errors from uxtheme.dll we have to
  // make <DecrambleFfDeCsa> threadsafe .....
  Synchronize(DescrambleFfDeCsa);
  for StreamPacket := 0 to CDvbPacketVSync - 1 do
  begin
    // The Pid is the identifier of what type of information we are dealing with
    if DvbGetPid(@FStreamData[StreamPacket], Pid) then
    begin
      // if recording raw data do it before further processing
      if RecordingRawData then
        HandleRecording;

      if (not FilteringOff) and (not FiltersOff) then
      begin
        // Plugin filtering (they can use the same filter as the internal filter if they like)
        if MdPlugins > 0 then
          for Plugin := 0 to MdPlugins - 1 do
          begin
            CrossReference := MdPlugin[Plugin].Filters.CrossReference[Pid];
            if CrossReference <> 0 then
            begin
              DeScramble;
              // If 'external' filter exists, call it
              if
                Assigned(@MdPlugin[Plugin].Filters.Filters[CrossReference].CallBackFunction) then
              begin
                try
                  if MdPlugin[Plugin].PacketSize188 then
                    MdPlugin[Plugin].Filters.Filters[CrossReference].CallBackFunction(MdPlugin[Plugin].Filters.Filters[CrossReference].FilterId, 188,
                      @FStreamData[StreamPacket])
                  else
                    MdPlugin[Plugin].Filters.Filters[CrossReference].CallBackFunction(MdPlugin[Plugin].Filters.Filters[CrossReference].FilterId, 184,
                      @FStreamData[StreamPacket][4]);
                except
                end;
                if FilterCount = $FFFF then
                  FilterCount := 0
                else
                  Inc(FilterCount);
              end;
            end;
          end;
        // Internal filtering (done after plugins so they might change data ...)
        // DO NOT USE FILTERLOCK because plugins are known to change filter
        // while there callback procedure is called ....
        CrossReference := AppFilters.CrossReference[Pid];
        if CrossReference <> 0 then
          DeScramble;
      end;

      if not RecordingRawData then
        HandleRecording;

      // Increase video counter for a video rate indication
      if (Pid <> 0) and (Pid = PidVideo) then
      begin
        if VideoPacketCount = $FFFF then
          VideoPacketCount := 0
        else
          Inc(VideoPacketCount);
        // Check descrambling
        if ((FStreamData[StreamPacket][3] and $80) <> 0) then
          VideoStillScrambled := True;
      end;
      // Check audio scrambling
      if (Pid <> 0) and (Pid = PidAudio) then
      begin
        // Check descrambling
        if ((FStreamData[StreamPacket][3] and $80) <> 0) then
          AudioStillScrambled := True;
      end;

      // There is no need to send individual packets to DirectShow if we are
      // sending it anyway....
      // Really required PIDs are PAT, PMT, Video, Audio, PCR (see next line)
      // Note: PCR is NOT absolutely necessary ...
      ToSend := False;
      if Pid <> 0 then
      begin
        // Because a PID can be shared (eg. PCR is taken from video or audio channel),
        // we must make sure we only send a packet once.
        // Unfortunately we always need the PCR so this means that a shared
        // PID won't allow disabling of video/audio....
        // Note: PCR is NOT absolutely necessary ...
        if (Pid = PidPmt) then
          ToSend := True
        else if (Pid = PidPcr) then
          ToSend := True
        else if (Pid = PidVideo) {and not VideoScrambled} then
          ToSend := ShowVideo
        else if (Pid = PidAudio) {and not AudioScrambled} then
          ToSend := ShowAudio;
      end
      else
        ToSend := True;
      if DsFunctional and (not DsSendAll) then
      begin
        // Send to DirectShow (if enabled)
        if ShowAudioVideo and (ShowVideo or ShowAudio) then
        begin
          if (Recording = rtIdle) or ((Recording = rtRecording) and DisplayDuringRecording) then
          begin
            if ToSend then
            begin
{$IFDEF DSBUFFER}
              // Copy packet to intermediate buffer
              CopyMemory(@DsBuffer[DsBufferIndex], @StreamData[StreamPacket],
                CDvbPacketSize);
              Inc(DsBufferIndex);
              // If intermediate buffer full then transport it
              if DsBufferIndex > High(DsBuffer) then
              begin
                try
                  if (DsOptions and CDirectShowMethodAlternative) <> 0 then
                    DvbDirectShow2.DirectShowUniversalSourceSendData(@DsBuffer,
                      SizeOf(DsBuffer))
                  else
                    DvbDirectShow.DirectShowUniversalSourceSendData(@DsBuffer,
                      SizeOf(DsBuffer));
                except
                end;
                DsBufferIndex := Low(DsBuffer);
              end;
{$ELSE}
              try
                if (DsOptions and CDirectShowMethodAlternative) <> 0 then
                  DvbDirectShow2.DirectShowUniversalSourceSendData(@FStreamData[StreamPacket], CDvbPacketSize)
                else
                  DvbDirectShow.DirectShowGraph.DirectShowUniversalSourceSendData(@FStreamData[StreamPacket], CDvbPacketSize);
              except
              end;
{$ENDIF}
            end;
          end;
        end;
      end;
      if ToSend and not(DsSendAll) then
      try
        if GUDPClient.Connected then
        begin
          CopyMemory(GUDPPointer, @FStreamData[StreamPacket], CDvbPacketSize);
          Inc(GUDPPointer, CDvbPacketSize);
          Dec(GUDPIndex);
          if GUDPIndex = 0 then
          begin
            GUDPIndex   := GUDPLastIndex;
            GUDPPointer := @GUDPBuffer[0];
            GUDPClient.SendBuffer(GUDPBuffer);
          end;
        end;
      except
      end;
    end;
  end;
  // When using the MajorDvbPsi DirectShow filter we must pass on all data
  // Sending individual packets decreases performance considerably!
  // We send this AFTER processing!
  // We can not send it in one go unfortunately
  if DsSendAll then
  begin
    if GUDPClient.Connected then
    begin
      try
        for StreamPacket := 0 to CDvbPacketVSync - 1 do
        begin
          CopyMemory(GUDPPointer, @FStreamData[StreamPacket], CDvbPacketSize);
          Inc(GUDPPointer, CDvbPacketSize);
          Dec(GUDPIndex);
          if GUDPIndex = 0 then
          begin
            GUDPIndex   := GUDPLastIndex;
            GUDPPointer := @GUDPBuffer[0];
            GUDPClient.SendBuffer(GUDPBuffer);
          end;
        end;
      except
      end;
    end;  
    for StreamPacket := 0 to 7 do
      if DsFunctional then
      begin
        try
          if (DsOptions and CDirectShowMethodAlternative) <> 0 then
            DvbDirectShow2.DirectShowUniversalSourceSendData(@FStreamData[StreamPacket * 64], CDvbPacketSize * 64)
          else
            DvbDirectShow.DirectShowGraph.DirectShowUniversalSourceSendData(@FStreamData[StreamPacket * 64], CDvbPacketSize * 64);
        except
        end;
      end;
  end;
  // Set global descramble status
  VideoScrambled := VideoCheckScrambled;
  AudioScrambled := AudioCheckScrambled;
  if VideoCheckScrambled and not VideoStillScrambled then
    VideoIsDescrambled := True
  else
    VideoIsDescrambled := False;
  if AudioCheckScrambled and not AudioStillScrambled then
    AudioIsDescrambled := True
  else
    AudioIsDescrambled := False;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Execution of thread. This thread handles reception of data.
  Notes   : We get an interrupt at both edges of the field indicator,
            meaning that we get notified when a switch is made from
            'odd' -> 'even' and from 'even' -> 'odd'
            The rate is about 25 interrupts a second
 ------------------------------------------------------------------------------}

procedure TDataThread.Execute;
var
  Data: Dword;
  LastBuffer: Dword;
  Buffer: TSaa7146aTransferBuffer;
  LastTime: Dword; // Last time buffer accessed
  CurrentTime: Dword; // Current time
  BytesRead: LongInt;
  HasData: Boolean;
  Escape: Integer;
  StartTiming: TLargeInteger;
  EndTiming: TLargeInteger;
  FlexCopBuffer: TFlexCopFifoTransferBuffer;
  FlexCopLastRead: Dword;
  FlexCopIrqHandling: TFlexCopIrqTransferBuffer; // Subbuffer 0 interrupts

  SyncRequired: Integer; // Counts invalid sync at start buffer
  SyncOffset: Integer; // Offset for correction
  SyncData: TDvbTransportPacket; // Remainder data previous data block
begin
  // Debug
  PacketBufferCount := 0;
  FOperation := otNoOp;
  if (CardHandle = INVALID_HANDLE_VALUE) then
    FOperation := otNoOp
  else
    FOperation := otNormal;

  FHasStopped := False;
  FProgrammedStop := False;
  FFileStream := nil;
  FFileStreamStop := False;
  FFileStreamDelay := 20;
  LastTime := GetTickCount;

  if UseFlexCop then
  begin
    try
      // We MUST use a new file handle. If we don't then only one call per handle is
      // allowed and when this happens to be the 'wait for notification'
      // we can not send any other calls eg. 'generate manual notification'
      // which might be needed in a deadlock situation.
      ThreadHandle := FlexCopCreateFile(CardInUse);
      // Dma 1, subbuffer 0 interrrupts are used
      FlexCopIrqHandling.Identifier := FBufferId;
      FlexCopReadFromIrqHandling(ThreadHandle, FlexCopIrqHandling);
      if not FlexCopIrqHandling.Information.IrqBufferingIsActive then
        Terminate;
      FlexCopLastRead := $FFFF;
      LastBuffer := 0;
      SyncRequired := 0;
      SyncOffset := 0;
      FlexCopBuffer.TransferAddress[0] := @StreamDataBuffer[0][SyncOffset];
      Data := $FFFF;
      try
        while not Terminated do
        begin
          // Some special handling required when a new channel has been set
          if NewChannelSet or NewTransponderSet then
          begin
            DvbResetErrors;
            Overtaken := 0;
            if NewTransponderSet then
            begin
              DvbCreateTables;
              // Make sure we will read new data
              if FOPeration in [otNormal] then
              begin
              end;
              NewTransponderSet := False;
            end;
            NewChannelSet := False;
          end;
          if PacketBufferCount = $FFFF then
            PacketBufferCount := 0
          else
            Inc(PacketBufferCount);

          // Depending on the operating mode data can get from different source
          // 1. A file is used as input (works in all operating modes)
          // 2. Source is the DVB-S hardware
          HasData := False;
          if Assigned(FFileStream) then
          begin
            if FFileStreamDelay <> 0 then
            begin
              CurrentTime := GetTickCount;
              if (CurrentTime - LastTime) < FFileStreamDelay then
                Sleep(FFileStreamDelay - (CurrentTime - LastTime));
              LastTime := CurrentTime;
            end;
            StreamLock.Acquire;
            try
              BytesRead := FFileStream.Read(StreamDataBuffer,
                StreamDataBufferSize);
              // End of file ends file stream mode
              if (BytesRead = 0) or FFileStreamStop then
              begin
                FreeAndNil(FFileStream);
                // Also stop recording if it was activated
                if Recording = rtRecording then
                  SendMessage(frmMain.Handle, WM_REMOTE,
                    Integer(CRemoteMessageRecord), 0);
                // Update settings
                NewTransponderSet := True;
                FFileStreamStop := False;
                TSProcessingDone := True;
              end
              else
                HasData := True;
            finally
              StreamLock.Release;
            end;
          end
          else
          begin
            // Without hardware only keep alive for file handling
            if FOperation in [otNoOp] then
              Sleep(50);
            // With hardware
            if FOperation in [otNormal] then
            begin
              // Get information of buffer being filled by driver
              FlexCopReadFromIrqHandling(ThreadHandle, FlexCopIrqHandling);
              Overtaken := FlexCopIrqHandling.Information.FifoOverflows;
              if (not IsSlave) and
                (FlexCopIrqHandling.Information.FifoBufferPreviousIndex =
                FlexCopLastRead) then
              begin
                FlexCopWaitForNotification(ThreadHandle);
              end
              else
              begin
                while (not Terminated) and
                  (FlexCopIrqHandling.Information.FifoBufferPreviousIndex =
                    FlexCopLastRead) do
                begin
                  Sleep(1);
                  FlexCopReadFromIrqHandling(ThreadHandle, FlexCopIrqHandling);
                end;
              end;
              Inc(FlexCopLastRead);
              if FlexCopLastRead > FlexCopIrqHandling.Information.FifoBufferLastIndex then
                FlexCopLastRead := FlexCopIrqHandling.Information.FifoBufferFirstIndex;
              // Read buffer
              FlexCopBuffer.TransferLength := StreamDataBufferSize;
              FlexCopBuffer.Identifier := FlexCopLastRead;
              FlexCopReadFromFifo(ThreadHandle, FlexCopBuffer);
              // Check first packet (the offset should have made the second packet correct)
              if (StreamDataBuffer[1][0] <> $47)  then
                Inc(SyncRequired)
              else
                if SyncRequired > 0 then
                  Dec(SyncRequired);
              HasData := True;
              if SyncRequired > 50 then
              begin
                // Search for sync
                SyncOffset := 0;
                while (SyncOffset < CDvbPacketSize) and (StreamDataBuffer[0][SyncOffset] <> $47) do
                  Inc(SyncOffset);
                // Not found, default to start
                // Otherwise the correction is related to the packet size because
                // the correct data is to be placed in the second packet of
                // StreamDataBuffer
                if (SyncOffset = 0) or (SyncOffset = CDvbPacketSize) then
                  SyncOffset := 0
                else
                  SyncOffset := CDvbPacketSize - SyncOffset;
                FlexCopBuffer.TransferAddress[0] := @StreamDataBuffer[0][SyncOffset];
                SyncRequired := 0;
                HasData := False;
              end
              else
              begin
                // We have to store the data at the end and use it for the
                // next block of data
                if SyncOffset <> 0 then
                begin
                  // Copy remainder of previous block
                  CopyMemory(@StreamDataBuffer, @SyncData, SyncOffset);
                  // Copy leftover of current block ('one too many' packet)
                  CopyMemory(@SyncData, @StreamDataBuffer[High(TDvbTransportPackets2)], SyncOffset);
                end;
              end;
            end;
          end;
          if HasData then
          begin
            // Process packet data
            if TransponderValid or Assigned(FFileStream) then
            begin
              FStreamData := @StreamDataBuffer;
              QueryPerformanceCounter(StartTiming);
              DecodeTransportStreamData;
              QueryPerformanceCounter(EndTiming);
              if EndTiming > StartTiming then
                PacketTiming := PacketTiming + (EndTiming - StartTiming)
              else
                PacketTiming := PacketTiming + (StartTiming - EndTiming);
              Inc(PacketTimingCount, CDvbPacketVSync);
            end;
          end;
        end;
      finally
        if Assigned(FFileStream) then
          FreeAndNil(FFileStream);
        FHasStopped := True;
        if not FProgrammedStop then
        begin
          ToLog('Unexpected termination of packets handler.', $81);
          ShowMessage('Unexpected termination of packets handler.');
        end;
        FlexCopCloseHandle(ThreadHandle);
      end;
    except
      ToLog('Data thread exception occured.', $81);
    end;
  end
  else
  begin
    try
      // We MUST use a new file handle. If we don't then only one call per handle is
      // allowed and when this happens to be the 'wait for notification'
      // we can not send any other calls eg. 'generate manual notification'
      // which might be needed in a deadlock situation.
      ThreadHandle := Saa7146aCreateFile(CardInUse);
      Buffer.Identifier := FBufferId;
      Buffer.TransferAddress := @StreamDataBuffer;
      Buffer.TargetIndex := 0;
      Buffer.TransferLength := StreamDataBufferSize;

      // Wait for application to have started and such
      LastBuffer := 0;
      Data := $FFFF;
      try
        while not Terminated do
        begin
          // Some special handling required when a new channel has been set
          if NewChannelSet or NewTransponderSet then
          begin
            DvbResetErrors;
            Overtaken := 0;
            if NewTransponderSet then
            begin
              DvbCreateTables;
              // Make sure we will read new data
              if FOPeration in [otNormal] then
              begin
                Saa7146aReadFromSaa7146aRegister(ThreadHandle, CSaa7146aEcT1R,
                  LastBuffer);
                // Only wait max 0.1 second
                Escape := 100;
                repeat
                  Sleep(1);
                  Saa7146aReadFromSaa7146aRegister(ThreadHandle, CSaa7146aEcT1R,
                    Data);
                  Dec(Escape);
                until (Escape = 0) or Terminated or (Data <> LastBuffer);
                if Terminated then
                  Exit;
                // Security measure if we are forced out and <Data> is invalid
                if Escape = 0 then
                  Data := 0;
                LastBuffer := Data;
                if (Escape <> 0) then
                begin
                  Escape := 100;
                  repeat
                    Sleep(1);
                    Saa7146aReadFromSaa7146aRegister(ThreadHandle,
                      CSaa7146aEcT1R,
                      Data);
                    Dec(Escape);
                  until (Escape = 0) or Terminated or (Data <> LastBuffer);
                end;
                if Terminated then
                  Exit;
                // Security measure if we are forced out and <Data> is invalid
                if Escape = 0 then
                  Data := 0;
              end;
              LastBuffer := Data;
              NewTransponderSet := False;
            end;
            NewChannelSet := False;
          end;
          if PacketBufferCount = $FFFF then
            PacketBufferCount := 0
          else
            Inc(PacketBufferCount);

          // Depending on the operating mode data can get from different source
          // 1. A file is used as input (works in all operating modes)
          // 2. Source is the DVB-S hardware
          HasData := False;
          if Assigned(FFileStream) then
          begin
            if FFileStreamDelay <> 0 then
            begin
              CurrentTime := GetTickCount;
              if (CurrentTime - LastTime) < FFileStreamDelay then
                Sleep(FFileStreamDelay - (CurrentTime - LastTime));
              LastTime := CurrentTime;
            end;
            StreamLock.Acquire;
            try
              BytesRead := FFileStream.Read(StreamDataBuffer,
                StreamDataBufferSize);
              // End of file ends file stream mode
              if (BytesRead = 0) or FFileStreamStop then
              begin
                FreeAndNil(FFileStream);
                // Also stop recording if it was activated
                if Recording = rtRecording then
                  SendMessage(frmMain.Handle, WM_REMOTE,
                    Integer(CRemoteMessageRecord), 0);
                // Update settings
                NewTransponderSet := True;
                FFileStreamStop := False;
                TSProcessingDone := True;
              end
              else
                HasData := True;
            finally
              StreamLock.Release;
            end;
          end
          else
          begin
            // Without hardware only keep alive for file handling
            if FOperation in [otNoOp] then
              Sleep(50);
            // With hardware
            if FOperation in [otNormal] then
            begin
              // First check if there are already buffers filled
              Saa7146aReadFromSaa7146aRegister(ThreadHandle, CSaa7146aEcT1R,
                Data);
              // If we get an incorrect packet identification then the SAA7146
              // program has not received any data yet.
              if Data >= (FPacketBuffers * 2) then
              begin
                Data := 0;
                // Since we don't have any data no need to be fast
                Sleep(100);
              end;
              // If no new data, wait (or if first time)
              if Data = LastBuffer then
              begin
                if IsSlave then
                  repeat
                    Sleep(1);
                    Saa7146aReadFromSaa7146aRegister(ThreadHandle,
                      CSaa7146aEcT1R,
                      Data);
                  until Terminated or (Data <> LastBuffer)
                else
                  Saa7146aWaitForNotification(ThreadHandle);
                if Terminated then
                  Exit;
              end
              else
              begin
                if OverTaken = $FFFF then
                  OverTaken := 0
                else
                  Inc(Overtaken);
              end;
              Buffer.SourceIndex := CDvbPacketBufferSize * LastBuffer;
              // Next buffer to wait for
              Inc(LastBuffer);
              // Circular buffer
              if LastBuffer = (FPacketBuffers * 2) then
                LastBuffer := 0;
              // Get data in local buffer
              if Terminated then
                Exit;
              Saa7146aReadFromDma(ThreadHandle, Buffer);
              HasData := True;
            end;

          end;
          if HasData then
          begin
            // Process packet data
            if TransponderValid or Assigned(FFileStream) then
            begin
              FStreamData := @StreamDataBuffer;
              QueryPerformanceCounter(StartTiming);
              DecodeTransportStreamData;
              QueryPerformanceCounter(EndTiming);
              if EndTiming > StartTiming then
                PacketTiming := PacketTiming + (EndTiming - StartTiming)
              else
                PacketTiming := PacketTiming + (StartTiming - EndTiming);
              Inc(PacketTimingCount, CDvbPacketVSync);
            end;
          end;
        end;
      finally
        if Assigned(FFileStream) then
          FreeAndNil(FFileStream);
        FHasStopped := True;
        if not FProgrammedStop then
        begin
          ToLog('Unexpected termination of packets handler.', $81);
          ShowMessage('Unexpected termination of packets handler.');
        end;
        Saa7146aCloseHandle(ThreadHandle);
      end;
    except
      ToLog('Data thread exception occured.', $81);
    end;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Execution of thread. This thread handles the remote control.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TRcThread.Execute;
var
  Device: Byte;
  Command: Byte;
  Handled: Boolean;
  Parameter: string;
  FirstPar: Integer;
  SecondPar: Integer;
  ThirdPar: Integer;
  FourthPar: Integer;
  FourPars: Boolean;
  Error: Integer;
  Index: Integer;
begin
  try
    HasStopped := False;
    ProgrammedStop := False;
    try
      repeat
        // Check remote control
        if DvbGetRemoteControl(CardHandle, @Device, @Command) then
        begin
          ToLog(format('Remote control: device %d, command %d.', [Device,
            Command]), $85);
          // Try to find setting in INI file
          Parameter := IniFile.ReadString('Remote', format('Key%2.2d%2.2d',
            [Device, Command]), '');
          frmMain.txtRemoteControl.Caption := format('RC5 %2.2d %2.2d -> %s',
            [Device, Command, Parameter]);
          if Parameter <> '' then
          begin
            Handled := False;
            if LowerCase(Parameter) = 'record' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageRecord), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'recordon' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageRecordOn), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'recordoff' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageRecordOff), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'up' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessageUp),
                0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'down' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageDown), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'left' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageLeft), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'right' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageRight), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'reinit' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageReInit), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'update' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageUpdate), 0);
              Handled := True;
            end;

            if LowerCase(Parameter) = 'epg' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessageEPG),
                0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'epgshort' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageEPGShort), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'epgcurrent' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageEPGCurrent), 0);
              Handled := True;
            end;

            if LowerCase(Parameter) = 'video' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageVideo), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'audio' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageAudio), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'pid' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessagePids), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'directshow' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageDirectShow), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'transponder' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageTransponder), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'shutdown' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageShutDown), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'exit' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageExit), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'fullscreen' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageFullScreen), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'fullscreenon' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageFullScreenOn), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'fullscreenoff' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageFullScreenOff), 0);
              Handled := True;
            end;
            // Mute / Volume
            if LowerCase(Parameter) = 'mute' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageMute), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'muteon' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageMuteOn), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'muteoff' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageMuteOff), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'volumeup' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageVolumeUp), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'volumedown' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageVolumeDown), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'language' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageLanguage), 0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'disable' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE,
                Integer(CRemoteMessageDisable), 0);
              Handled := True;
            end;
            if Parameter = '0' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessage0),
                0);
              Handled := True;
            end;
            if Parameter = '1' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessage1),
                0);
              Handled := True;
            end;
            if Parameter = '2' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessage2),
                0);
              Handled := True;
            end;
            if Parameter = '3' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessage3),
                0);
              Handled := True;
            end;
            if Parameter = '4' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessage4),
                0);
              Handled := True;
            end;
            if Parameter = '5' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessage5),
                0);
              Handled := True;
            end;
            if Parameter = '6' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessage6),
                0);
              Handled := True;
            end;
            if Parameter = '7' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessage7),
                0);
              Handled := True;
            end;
            if Parameter = '8' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessage8),
                0);
              Handled := True;
            end;
            if Parameter = '9' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessage9),
                0);
              Handled := True;
            end;
            if LowerCase(Parameter) = 'pp' then
            begin
              SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessagePp),
                0);
              Handled := True;
            end;

            // Unhandled codes are passed through as specialties
            if not Handled then
            begin
              repeat
                // The parameter must include
                // 1. The handle
                // 2. The message
                // 3. First parameter
                // 4. Fourth parameter
                SecondPar := 0;
                ThirdPar := 0;
                FourthPar := 0;
                FourPars := False;
                Val(Parameter, FirstPar, Error);
                if Error <> 0 then
                begin
                  Delete(Parameter, 1, Error);
                  Val(Parameter, SecondPar, Error);
                  if Error <> 0 then
                  begin
                    Delete(Parameter, 1, Error);
                    Val(Parameter, ThirdPar, Error);
                    if Error <> 0 then
                    begin
                      Delete(Parameter, 1, Error);
                      Val(Parameter, FourthPar, Error);
                      if Error <> 0 then
                        Delete(Parameter, 1, Error)
                      else
                        Parameter := '';
                      FourPars := True;
                    end;
                  end;
                end;
                if FourPars then
                begin
                  // All parameters detected
                  case FirstPar of
                    0: SendMessage(frmMain.ActiveControl.Handle, SecondPar,
                        ThirdPar, FourthPar);
                    1: SendMessage(Application.Handle, SecondPar, ThirdPar,
                        FourthPar);
                    2: SendMessage(frmMain.Handle, SecondPar, ThirdPar,
                        FourthPar);
                    3: KeyBd_Event(SecondPar, MapVirtualKey(SecondPar, 0),
                        ThirdPar, FourthPar);
                  else
                    SendMessage(FirstPar, SecondPar, ThirdPar, FourthPar);
                  end;
                end
                else
                begin
                  // Invalid parameters (or too few), treat as string
                  for Index := 1 to Length(Parameter) do
                    SendMessage(frmMain.ActiveControl.Handle, WM_CHAR,
                      Ord(Parameter[Index]), 0);
                  Parameter := '';
                end;
              until Parameter = '';
            end;
          end;
        end;
        Index := 20;
        while (Index > 0) and not Terminated do
        begin
          Dec(Index);
          Sleep(5);
        end;
      until Terminated;
    finally
      HasStopped := True;
      if not ProgrammedStop then
      begin
        ToLog('Unexpected termination of remote control handler.', $81);
        ShowMessage('Unexpected termination of remote control handler.');
      end;
    end;
  except
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Read INI file settings
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.ReadSettings;
var
  Default: string;
  Value: Integer;
  Error: Integer;
  Hour: Word;
  Minute: Word;
  Second: Word;
  Msec: Word;
  TheTime: TDateTime;
  DeltaTime: TDateTime;
  CheckTime: TDateTime;
begin
  ToLog('ReadSettings', $5);
  // Get variable settings
  Default := GetParameter('Settings', 'FormTop', '-4');
  Val(Default, Value, Error);
  if Error = 0 then
    Self.Top := Value;
  Default := GetParameter('Settings', 'FormLeft', '-4');
  Val(Default, Value, Error);
  if Error = 0 then
    Self.Left := Value;
  Default := GetParameter('Settings', 'FormWidth', '1032');
  Val(Default, Value, Error);
  if Error = 0 then
    Self.Width := Value;
  Default := GetParameter('Settings', 'FormHeight', '748');
  Val(Default, Value, Error);
  if Error = 0 then
    Self.Height := Value;

  Default := GetParameter('Settings', 'Transponder', '0');
  Val(Default, Transponder, Error);
  Error := -1;
  if ParameterFavourite <> '' then
  begin
    // Command line parameter overrules and is NOT 0-based as we are
    // However, since the first favourite is always the transponderlist ...
    Val(ParameterFavourite, Value, Error);
    cmbLists.ItemIndex := Value;
    // Only overrule the very first time
    ParameterFavourite := '';
  end;
  // If some error or no parameter
  if Error <> 0 then
  begin
    Default := GetParameter('Settings', 'FavouriteList', '0');
    Val(Default, Value, Error);
    cmbLists.ItemIndex := Value;
  end;
  Default := GetParameter('Settings', 'Service', '0');
  cmbServices.Text := Default;

  if chkEPG.Visible then
  begin
    Default := Lowercase(GetParameter('Settings', 'EPGEnabled', 'No'));
    if Default = 'yes' then
      chkEpg.Checked := True
    else
      chkEpg.Checked := False;
    Default := LowerCase(GetParameter('Settings', 'EPGPresentOnly', 'Yes'));
    if Default = 'yes' then
      chkEPGPresentInfoOnly.Checked := True
    else
      chkEPGPresentInfoOnly.Checked := False;
    Default := LowerCase(GetParameter('Settings', 'EPGShortNameOnly', 'No'));
    if Default = 'yes' then
      chkEPGShortNameOnly.Checked := True
    else
      chkEPGShortNameOnly.Checked := False;
  end;
  Default := LowerCase(GetParameter('Settings', 'TransponderDisplay', 'No'));
  if Default = 'yes' then
    chkTransponderDisplay.Checked := True
  else
    chkTransponderDisplay.Checked := False;
  chkTransponderDisplayClick(nil);

  Default := LowerCase(GetParameter('Settings', 'AutoECM', 'Yes'));
  if Default = 'yes' then
    chkAutoECM.Checked := True
  else
    chkAutoECM.Checked := False;

  Default := LowerCase(GetParameter('Settings', 'EventsWhileRecording', 'No'));
  if Default = 'yes' then
    chkEventsWhileRecording.Checked := True
  else
    chkEventsWhileRecording.Checked := False;

  // Recording settings
  edtFileNamePrefix.Text := GetParameter('Settings', 'RecordFilenamePrefix',
    '');
  Default := LowerCase(GetParameter('Settings', 'RecordPat', 'Yes'));
  if Default = 'yes' then
    chkRecordPat.Checked := True
  else
    chkRecordPat.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordMandatory', 'No'));
  if Default = 'yes' then
    chkRecordMandatory.Checked := True
  else
    chkRecordMandatory.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordCat', 'No'));
  if Default = 'yes' then
    chkRecordCat.Checked := True
  else
    chkRecordCat.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordEmm', 'No'));
  if Default = 'yes' then
    chkRecordEmm.Checked := True
  else
    chkRecordEmm.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordVideo', 'Yes'));
  if Default = 'yes' then
    chkRecordVideo.Checked := True
  else
    chkRecordVideo.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordAllVideo', 'No'));
  if Default = 'yes' then
    chkRecordVideoAll.Checked := True
  else
    chkRecordVideoAll.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordAudio', 'Yes'));
  if Default = 'yes' then
    chkRecordAudio.Checked := True
  else
    chkRecordAudio.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordAllAudio', 'Yes'));
  if Default = 'yes' then
    chkRecordAudioAll.Checked := True
  else
    chkRecordAudioAll.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordTeletext', 'No'));
  if Default = 'yes' then
    chkRecordTeletext.Checked := True
  else
    chkRecordTeletext.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordAllTeletext', 'No'));
  if Default = 'yes' then
    chkRecordTeletextAll.Checked := True
  else
    chkRecordTeletextAll.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordSubtitle', 'No'));
  if Default = 'yes' then
    chkRecordSubtitle.Checked := True
  else
    chkRecordSubtitle.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordAllSubtitle', 'No'));
  if Default = 'yes' then
    chkRecordSubtitleAll.Checked := True
  else
    chkRecordSubtitleAll.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordPMT', 'Yes'));
  if Default = 'yes' then
    chkRecordPMT.Checked := True
  else
    chkRecordPMT.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordAllPMT', 'No'));
  if Default = 'yes' then
    chkRecordPMTAll.Checked := True
  else
    chkRecordPMTAll.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordPCR', 'No'));
  if Default = 'yes' then
    chkRecordPCR.Checked := True
  else
    chkRecordPCR.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordAllPCR', 'No'));
  if Default = 'yes' then
    chkRecordPCRAll.Checked := True
  else
    chkRecordPCRAll.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordECM', 'No'));
  if Default = 'yes' then
    chkRecordECM.Checked := True
  else
    chkRecordECM.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordAllECM', 'No'));
  if Default = 'yes' then
    chkRecordECMAll.Checked := True
  else
    chkRecordECMAll.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordIndividualStreams',
    'No'));
  if Default = 'yes' then
    chkRecordIndividualStreams.Checked := True
  else
    chkRecordIndividualStreams.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordRawData', 'No'));
  if Default = 'yes' then
    chkRecordRawData.Checked := True
  else
    chkRecordRawData.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordNoFiltering', 'No'));
  if Default = 'yes' then
    chkRecordNoFiltering.Checked := True
  else
    chkRecordNoFiltering.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'RecordTransponder', 'No'));
  if Default = 'yes' then
    chkRecordTransponder.Checked := True
  else
    chkRecordTransponder.Checked := False;
  RecordDefault := LowerCase(GetParameter('Settings', 'RecordDefault',
    '1011000010000000001000'));

  Default := LowerCase(GetParameter('Settings', 'MenuSettingsTv', 'Yes'));
  if Default = 'yes' then
    mnuTv.Checked := True
  else
    mnuTv.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'MenuSettingsRadio', 'Yes'));
  if Default = 'yes' then
    mnuRadio.Checked := True
  else
    mnuRadio.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'MenuSettingsData', 'No'));
  if Default = 'yes' then
    mnuData.Checked := True
  else
    mnuData.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'MenuSettingsScrambled', 'No'));
  if Default = 'yes' then
    mnuScrambled.Checked := True
  else
    mnuScrambled.Checked := False;
  Default := LowerCase(GetParameter('Settings', 'MenuSettingsDisabled', 'No'));
  if Default = 'yes' then
    mnuDisabled.Checked := True
  else
    mnuDisabled.Checked := False;

  // Get time settings
  DecodeTime(Time, Hour, Minute, Second, Msec);
  Error := -1;
  if ParameterStartRecording <> '' then
  begin
    try
      ParameterStartRecording := ChangeTimeSeparator(ParameterStartRecording);
      TheTime := StrToTime(ParameterStartRecording) + TimeCorrectionParameters;
      dtStartRecording.Time := TheTime;

      // Check if starting time already expired (22 hours ago or within the next 10 seconds)
      // If so start recording after 10 seconds
      CheckTime := Now + EncodeTime(0, 0, 10, 0);
      DeltaTime := TheTime - CheckTime;
      if (DeltaTime < 0) or (DeltaTime > EncodeTime(22, 0, 0, 0)) then
      begin
        TheTime := CheckTime;
        dtStartRecording.Time := TheTime;
      end;

      ParameterStartRecording := '';
      chkStartRecording.Checked := True;
      Error := 0;
    except
    end;
  end;
  if Error <> 0 then
  begin
    Default := GetParameter('Settings', 'StartRecordingTime', '00' +
      TimeSeparator + '00' + TimeSeparator + '00');
    try
      Default := ChangeTimeSeparator(Default);
      TheTime := StrToTime(Default);
      dtStartRecording.Time := TheTime;
    except
      dtStartRecording.Time := EncodeTime(Hour, Minute, 0, 0) + EncodeTime(0,
        10, 0, 0);
    end;
  end;

  Error := -1;
  if ParameterStopRecording <> '' then
  begin
    try
      ParameterStopRecording := ChangeTimeSeparator(ParameterStopRecording);
      TheTime := StrToTime(ParameterStopRecording) + TimeCorrectionParameters;
      dtStopRecording.Time := TheTime;
      ParameterStopRecording := '';
      chkStopRecording.Checked := True;
      Error := 0;
    except
    end;
  end;
  if Error <> 0 then
  begin
    Default := GetParameter('Settings', 'StopRecordingTime', '00' + TimeSeparator
      + '00' + TimeSeparator + '00');
    try
      Default := ChangeTimeSeparator(Default);
      TheTime := StrToTime(Default);
      dtStopRecording.Time := TheTime;
    except
      dtStopRecording.Time := dtStartRecording.Time + EncodeTime(2, 0, 0, 0);
    end;
  end;

  Error := -1;
  if ParameterShutdown <> '' then
  begin
    try
      ParameterShutdown := ChangeTimeSeparator(ParameterShutdown);
      TheTime := StrToTime(ParameterShutdown) + TimeCorrectionParameters;
      dtShutdown.Time := TheTime;
      ParameterShutdown := '';
      chkShutdown.Checked := True;
      Error := 0;
    except
    end;
  end;
  if Error <> 0 then
  begin
    Default := GetParameter('Settings', 'ShutdownTime', '00' + TimeSeparator +
      '00' + TimeSeparator + '00');
    try
      Default := ChangeTimeSeparator(Default);
      TheTime := StrToTime(Default);
      dtShutdown.Time := TheTime;
    except
      dtShutdown.Time := dtStopRecording.Time + EncodeTime(0, 1, 0, 0);
    end;
  end;

  if ParameterExit <> '' then
  begin
    try
      ParameterExit := ChangeTimeSeparator(ParameterExit);
      TheTime := StrToTime(ParameterExit) + TimeCorrectionParameters;
      dtExit.Time := TheTime;
      dtExit.Enabled := True;
      ParameterExit := '';
    except
    end;
  end;
  ReadRecordings;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Mute click
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.VolumeUpdate(Sender: TObject);
begin
  if not Mixer.VolumeAvailable then
  begin
    imgVolumeUp.Visible := False;
    imgVolumeDown.Visible := False;
    imgVolumeOn.Visible := False;
    imgVolumeOff.Visible := False;
  end
  else
  begin
    if Mixer.VolumeMute then
    begin
      imgVolumeOn.Visible := True;
      imgVolumeOff.Visible := False;
    end
    else
    begin
      imgVolumeOn.Visible := False;
      imgVolumeOff.Visible := True;
    end;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Volume change
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.sbVolumeScroll(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Mute click
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.imgVolumeOffClick(Sender: TObject);
var
  Mute: Boolean;
begin
  if not Mixer.VolumeAvailable then
    Exit;
  Mute := False;
  if Sender = nil then
    Mute := Mixer.VolumeMute;
  if Sender = imgVolumeOff then
    Mute := True;
  if Sender = imgVolumeOn then
    Mute := False;
  Mixer.VolumeMute := Mute;
  VolumeUpdate(imgVolumeOff);
end;

procedure TfrmMain.imgVolumeUpClick(Sender: TObject);
begin
  imgVolumeOffClick(imgVolumeOn);
  Mixer.VolumeUp;
end;

procedure TfrmMain.imgVolumeDownClick(Sender: TObject);
begin
  imgVolumeOffClick(imgVolumeOn);
  Mixer.VolumeDown;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: DiSEqC manual commands
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.btnPositionerStopClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0; // Will be written over
  DiSEqCData[1] := $30; // Any positioner
  DiSEqCData[2] := $60; // Stop positioner movement
  if UseFlexCop then
    FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 3,
      DiSEqCData)
  else
    Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 3,
      DiSEqCData);
end;

procedure TfrmMain.btnPositionerResetClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0; // Will be written over
  DiSEqCData[1] := $30; // Any positioner
  DiSEqCData[2] := $00; // Reset
  if UseFlexCop then
    FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 3,
      DiSEqCData)
  else
    Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 3,
      DiSEqCData);
end;

procedure TfrmMain.btnPositionerGotoClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0; // Will be written over
  DiSEqCData[1] := $30; // Any positioner
  DiSEqCData[2] := $6B; // Goto position xx
  DiSEqCData[3] := spnSatellitePosition.Value; // Position xx
  if UseFlexCop then
    FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
      DiSEqCData)
  else
    Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
      DiSEqCData);
end;

procedure TfrmMain.btnPositionerStoreClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0; // Will be written over
  DiSEqCData[1] := $30; // Any positioner
  DiSEqCData[2] := $6A; // Store position xx
  DiSEqCData[3] := spnSatellitePosition.Value; // Position xx
  if UseFlexCop then
    FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
      DiSEqCData)
  else
    Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
      DiSEqCData);
  if spnSatellitePosition.Value < spnSatellitePosition.MaxValue then
    spnSatellitePosition.Value := spnSatellitePosition.Value + 1;
end;

procedure TfrmMain.btnPositionerGoEastClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0; // Will be written over
  DiSEqCData[1] := $30; // Any positioner
  DiSEqCData[2] := $68; // Drive East
  DiSEqCData[3] := $00; // Timeout (no timeout)
  if UseFlexCop then
    FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
      DiSEqCData)
  else
    Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
      DiSEqCData);
end;

procedure TfrmMain.btnPositionerStepEastClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0; // Will be written over
  DiSEqCData[1] := $30; // Any positioner
  DiSEqCData[2] := $68; // Drive East
  DiSEqCData[3] := $FF; // $00 - steps, $FF = smallest
  if UseFlexCop then
    FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
      DiSEqCData)
  else
    Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
      DiSEqCData);
end;

procedure TfrmMain.btnPositionerSetEastLimitClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0; // Will be written over
  DiSEqCData[1] := $30; // Any positioner
  DiSEqCData[2] := $66; // Set East limit
  if UseFlexCop then
    FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 3,
      DiSEqCData)
  else
    Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 3,
      DiSEqCData);
end;

procedure TfrmMain.btnPositionerGoWestClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0; // Will be written over
  DiSEqCData[1] := $30; // Any positioner
  DiSEqCData[2] := $69; // Drive West
  DiSEqCData[3] := $00; // Timeout (no timeout)
  if UseFlexCop then
    FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
      DiSEqCData)
  else
    Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
      DiSEqCData);
end;

procedure TfrmMain.btnPositionerStepWestClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0; // Will be written over
  DiSEqCData[1] := $30; // Any positioner
  DiSEqCData[2] := $69; // Drive West
  DiSEqCData[3] := $FF; // $00 - steps, $FF = smallest
  if UseFlexCop then
    FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
      DiSEqCData)
  else
    Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
      DiSEqCData);
end;

procedure TfrmMain.btnPositionerSetWestLimitClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0; // Will be written over
  DiSEqCData[1] := $30; // Any positioner
  DiSEqCData[2] := $67; // Set West limit
  if UseFlexCop then
    FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 3,
      DiSEqCData)
  else
    Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 3,
      DiSEqCData);
end;

procedure TfrmMain.btnPositionerDisableLimitsClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
begin
  DiSEqCData[0] := 0; // Will be written over
  DiSEqCData[1] := $30; // Any positioner
  DiSEqCData[2] := $63; // Disable limits
  if UseFlexCop then
    FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 3,
      DiSEqCData)
  else
    Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 3,
      DiSEqCData);
end;

procedure TfrmMain.mnuScrambledClick(Sender: TObject);
begin
  mnuScrambled.Checked := not mnuScrambled.Checked;
  ReadFavourites;
  UpdateSettings(nil);
end;

procedure TfrmMain.mnuDataClick(Sender: TObject);
begin
  mnuData.Checked := not mnuData.Checked;
  ReadFavourites;
  UpdateSettings(nil);
end;

procedure TfrmMain.mnuRadioClick(Sender: TObject);
begin
  mnuRadio.Checked := not mnuRadio.Checked;
  ReadFavourites;
  UpdateSettings(nil);
end;

procedure TfrmMain.mnuTVClick(Sender: TObject);
begin
  mnuTV.Checked := not mnuTV.Checked;
  ReadFavourites;
  UpdateSettings(nil);
end;

procedure TfrmMain.mnuDisabledClick(Sender: TObject);
begin
  mnuDisabled.Checked := not mnuDisabled.Checked;
  ReadFavourites;
  UpdateSettings(nil);
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Place DirectSHow filters in menu
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.DirectShowFiltersAddToMenu;
var
  Index: Integer;
  FilterName: string;
  AMenuItem: TMenuItem;
begin
  Index := 0;
  mnuDirectShowFilters.Clear;
  repeat
    if (DsOptions and CDirectShowMethodAlternative) <> 0 then
      FilterName := DvbDirectShow2.DirectShowGetFilterName(Index)
    else
      FilterName :=
        DvbDirectShow.DirectShowGraph.DirectShowGetFilterName(Index);
    if FilterName <> '' then
    begin
      AMenuItem := TMenuItem.Create(Self);
      AMenuItem.Caption := FilterName; // Note: This adds an ampersand!!
      AMenuItem.OnClick := mnuDirectShowClick;
      AMenuItem.Hint :=
        'Click on the filter to show the property page (if available)';
      if (DsOptions and CDirectShowMethodAlternative) <> 0 then
        AMenuItem.Enabled :=
          DvbDirectShow2.DirectShowShowPropertyPage(Self.Handle, FilterName,
          True)
      else
        AMenuItem.Enabled :=
          DvbDirectShow.DirectShowGraph.DirectShowShowPropertyPage(Self.Handle,
          FilterName,
          True);
      mnuDirectShowFilters.Add(AMenuItem);
      mnuDirectShowFilters.Enabled := True;
      mnuDirectShowFilters.Visible := True;
    end;
    Inc(Index);
  until FilterName = '';
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Place DirectShow graphs in menu
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.DirectShowGraphsAddToMenu;
var
  AMenuItem: TMenuItem;
  SearchRec: TSearchRec;
  Success: Integer;
  NewName: string;
begin
  mnuDirectShowGraphs.Clear;
  Success := FindFirst(ExeDirectory + '*.GRF', faAnyFile, SearchRec);
  if Success = 0 then
  try
    repeat
      AMenuItem := TMenuItem.Create(Self);
      NewName := SearchRec.Name;
      Delete(Newname, Pos('.GRF', UpperCase(NewName)), 255);
      AMenuItem.Caption := ExtractFileName(NewName);
      AMenuItem.OnClick := mnuDirectShowGraphClick;
      AMenuItem.Enabled := True;
      mnuDirectShowGraphs.Add(AMenuItem);
      mnuDirectShowGraphs.Enabled := True;
      mnuDirectShowGraphs.Visible := True;
      Success := FindNext(SearchRec);
    until Success <> 0;
  finally
    SysUtils.FindClose(SearchRec);
  end;
end;

procedure TfrmMain.mnuDirectShowClick(Sender: TObject);
var
  NewName: string;
  Ampersand: Integer;
begin
  // Since te caption might include ampersands we have to remove them
  NewName := (Sender as TMenuItem).Caption;
  repeat
    Ampersand := Pos('&', NewName);
    if Ampersand <> 0 then
      Delete(NewName, Ampersand, 1);
  until (Ampersand = 0) or (NewName = '');
  // Show property page, if it fails make it unavailable
  if (DsOptions and CDirectShowMethodAlternative) <> 0 then
  begin
    if not DvbDirectShow2.DirectShowShowPropertyPage(Self.Handle, NewName, False)
      then
      (Sender as TMenuItem).Enabled := False;
  end
  else if not
    DvbDirectShow.DirectShowGraph.DirectShowShowPropertyPage(Self.Handle,
    NewName,
    False) then
    (Sender as TMenuItem).Enabled := False;
end;

procedure TfrmMain.mnuDirectShowGraphClick(Sender: TObject);
var
  NewName: string;
  Ampersand: Integer;
begin
  // Since te caption might include ampersands we have to remove them
  NewName := (Sender as TMenuItem).Caption;
  repeat
    Ampersand := Pos('&', NewName);
    if Ampersand <> 0 then
      Delete(NewName, Ampersand, 1);
  until (Ampersand = 0) or (NewName = '');
  // Load graph file
  DsGraphFile := NewName + '.GRF';
  btnReinitClick(nil);
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Write INI file settings
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.WriteSettings;
begin
  ToLog('WriteSettings', $5);
  // Save variable settings
  IniFile.WriteString('Settings', 'FormTop', format('%d', [Self.Top]));
  IniFile.WriteString('Settings', 'FormLeft', format('%d', [Self.Left]));
  IniFile.WriteString('Settings', 'FormWidth', format('%d', [Self.Width]));
  IniFile.WriteString('Settings', 'FormHeight', format('%d', [Self.Height]));
  IniFile.WriteString('Settings', 'Service', cmbServices.Text);
  IniFile.WriteString('Settings', 'Transponder', format('%d',
    [cmbTransponders.ItemIndex]));
  IniFile.WriteString('Settings', 'FavouriteList', format('%d',
    [cmbLists.ItemIndex]));
  //  IniFile.WriteString('Settings', 'Decoder', format('%d', [cmbCaPrefered.ItemIndex]));
  if chkEpg.Checked then
    IniFile.WriteString('Settings', 'EPGEnabled', 'Yes')
  else
    IniFile.WriteString('Settings', 'EPGEnabled', 'No');
  if chkEPGPresentInfoOnly.Checked then
    IniFile.WriteString('Settings', 'EPGPresentOnly', 'Yes')
  else
    IniFile.WriteString('Settings', 'EPGPresentOnly', 'No');
  if chkEPGShortNameOnly.Checked then
    IniFile.WriteString('Settings', 'EPGShortNameOnly', 'Yes')
  else
    IniFile.WriteString('Settings', 'EPGShortNameOnly', 'No');
  if chkTransponderDisplay.Checked then
    IniFile.WriteString('Settings', 'TransponderDisplay', 'Yes')
  else
    IniFile.WriteString('Settings', 'TransponderDisplay', 'No');

  if chkAutoECM.Checked then
    IniFile.WriteString('Settings', 'AutoECM', 'Yes')
  else
    IniFile.WriteString('Settings', 'AutoECM', 'No');
  if chkEventsWhileRecording.Checked then
    IniFile.WriteString('Settings', 'EventsWhileRecording', 'Yes')
  else
    IniFile.WriteString('Settings', 'EventsWhileRecording', 'No');

  IniFile.WriteString('Settings', 'RecordFilenamePrefix',
    edtFileNamePrefix.Text);
  if chkRecordPat.Checked then
    IniFile.WriteString('Settings', 'RecordPat', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordPat', 'No');
  if chkRecordMandatory.Checked then
    IniFile.WriteString('Settings', 'RecordMandatory', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordMandatory', 'No');
  if chkRecordCat.Checked then
    IniFile.WriteString('Settings', 'RecordCat', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordCat', 'No');
  if chkRecordEmm.Checked then
    IniFile.WriteString('Settings', 'RecordEmm', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordEmm', 'No');
  if chkRecordVideo.Checked then
    IniFile.WriteString('Settings', 'RecordVideo', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordVideo', 'No');
  if chkRecordVideoAll.Checked then
    IniFile.WriteString('Settings', 'RecordAllVideo', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordAllVideo', 'No');
  if chkRecordAudio.Checked then
    IniFile.WriteString('Settings', 'RecordAudio', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordAudio', 'No');
  if chkRecordAudioAll.Checked then
    IniFile.WriteString('Settings', 'RecordAllAudio', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordAllAudio', 'No');
  if chkRecordTeletext.Checked then
    IniFile.WriteString('Settings', 'RecordTeletext', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordTeletext', 'No');
  if chkRecordTeletextAll.Checked then
    IniFile.WriteString('Settings', 'RecordAllTeletext', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordAllTeletext', 'No');
  if chkRecordSubtitle.Checked then
    IniFile.WriteString('Settings', 'RecordSubtitle', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordSubtitle', 'No');
  if chkRecordSubtitleAll.Checked then
    IniFile.WriteString('Settings', 'RecordAllSubtitle', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordAllSubtitle', 'No');
  if chkRecordPMT.Checked then
    IniFile.WriteString('Settings', 'RecordPMT', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordPMT', 'No');
  if chkRecordPMTAll.Checked then
    IniFile.WriteString('Settings', 'RecordAllPMT', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordAllPMT', 'No');
  if chkRecordPCR.Checked then
    IniFile.WriteString('Settings', 'RecordPCR', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordPCR', 'No');
  if chkRecordPCRAll.Checked then
    IniFile.WriteString('Settings', 'RecordAllPCR', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordAllPCR', 'No');
  if chkRecordECM.Checked then
    IniFile.WriteString('Settings', 'RecordECM', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordECM', 'No');
  if chkRecordECMAll.Checked then
    IniFile.WriteString('Settings', 'RecordAllECM', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordAllECM', 'No');
  if chkRecordIndividualStreams.Checked then
    IniFile.WriteString('Settings', 'RecordIndividualStreams', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordIndividualStreams', 'No');
  if chkRecordRawData.Checked then
    IniFile.WriteString('Settings', 'RecordRawData', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordRawData', 'No');
  if chkRecordNoFiltering.Checked then
    IniFile.WriteString('Settings', 'RecordNoFiltering', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordNoFiltering', 'No');
  if chkRecordTransponder.Checked then
    IniFile.WriteString('Settings', 'RecordTransponder', 'Yes')
  else
    IniFile.WriteString('Settings', 'RecordTransponder', 'No');
  IniFile.WriteString('Settings', 'RecordDefault', RecordDefault);

  IniFile.WriteString('Settings', 'StartRecordingTime',
    FormatDateTime('HH":"MM":"SS', dtStartRecording.Time));
  IniFile.WriteString('Settings', 'StopRecordingTime',
    FormatDateTime('HH":"MM":"SS', dtStopRecording.Time));
  IniFile.WriteString('Settings', 'ShutdownTime', FormatDateTime('HH":"MM":"SS',
    dtShutdown.Time));
  IniFile.UpdateFile;

  if mnuTV.Checked then
    IniFile.WriteString('Settings', 'MenuSettingsTv', 'Yes')
  else
    IniFile.WriteString('Settings', 'MenuSettingsTv', 'No');
  if mnuRadio.Checked then
    IniFile.WriteString('Settings', 'MenuSettingsRadio', 'Yes')
  else
    IniFile.WriteString('Settings', 'MenuSettingsRadio', 'No');
  if mnuData.Checked then
    IniFile.WriteString('Settings', 'MenuSettingsData', 'Yes')
  else
    IniFile.WriteString('Settings', 'MenuSettingsData', 'No');
  if mnuScrambled.Checked then
    IniFile.WriteString('Settings', 'MenuSettingsScrambled', 'Yes')
  else
    IniFile.WriteString('Settings', 'MenuSettingsScrambled', 'No');
  if mnuDisabled.Checked then
    IniFile.WriteString('Settings', 'MenuSettingsDisabled', 'Yes')
  else
    IniFile.WriteString('Settings', 'MenuSettingsDisabled', 'No');

  if Assigned(FavouritesIniFile) then
  begin
    if FavouritesIniFile <> TransponderListIniFile then
    begin
      FavouritesIniFile.WriteString('Settings', 'LastUsed', format('%d',
        [Favourite]));
      FavouritesIniFile.UpdateFile;
    end;
  end;
  WriteRecordings;
end;

procedure TfrmMain.tmrInitStartTimer(Sender: TObject);
begin
  tmrInitStart.Enabled := False;
  PidChanged;
end;

{------------------------------------------------------------------------------
  Params  : ....
  Returns : -

  Descript: Check for resize.
  Notes   : Basic design is for 1024x768 resolution (+8 larger because of -4 offsets)
 ------------------------------------------------------------------------------}

procedure TfrmMain.FormCanResize(Sender: TObject; var NewWidth,
  NewHeight: Integer; var Resize: Boolean);
var
  RectSize: TRect;
begin
  Resize := True;
  if NewWidth < LowestLeft then
    NewWidth := LowestLeft;
  SystemParametersInfo(SPI_GETWORKAREA, 0, @RectSize, 0);
  // Correction if maximized
  if NewHeight < (LowestTop + MenuAndCaption) then
    NewHeight := (LowestTop + MenuAndCaption);
  if NewHeight > RectSize.Bottom then
    NewHeight := RectSize.Bottom;
end;

procedure TfrmMain.FormResize(Sender: TObject);
var
  LeftCalc: Integer;
  Loop: Integer;
  NewHeight: Integer;
  RefHeight: Integer;
  PanelLeft: array[0..9] of Integer;
begin
  if FFullScreenMode then
    Exit;

  NewHeight := EpgHeight;
  RefHeight := Self.Height;

  if (RefHeight - MenuAndCaption - NewHeight) < LowestTop then
    NewHeight := RefHeight - MenuAndCaption - LowestTop;

  reEvents.Height := NewHeight;
  reEvents.Top := RefHeight - reEvents.Height - MenuAndCaption;
  reEvents.Width := Self.Width - 8;
  if Assigned(FRichView) then
    with FRichView do
    begin
      Height := reEvents.Height;
      Width := reEvents.Width;
      Left := reEvents.Left;
      Top := reEvents.Top;
    end;

  stbStatus2.Top := reEvents.Top - stbStatus2.Height - 2;
  stbStatus1.Top := stbStatus2.Top - stbStatus1.Height;
  stbStatus1.Width := reEvents.Width;
  stbStatus2.Width := stbStatus1.Width;

  pgInfo.Left := Self.Width - pgInfo.Width - 8;
  pgInfo.Top  := 0;

  // Depending on available height place control part in main screen or in
  // info tabs
  if stbStatus1.Top < (pgInfo.Height + pnlControl.Height) then
  begin
    pnlControl.Parent := tsControl;
    tsControl.TabVisible := True;
    pnlControl.Top  := 0;
    pnlControl.Left := 0;
    pnlControl.Width := tsControl.Width;
  end
  else
  begin
    pnlControl.Parent := frmMain;
    if pgInfo.ActivePage = tsControl then
      pgInfo.ActivePage := tsProgram;
    tsControl.TabVisible := False;
    pnlControl.Top   := pgInfo.Height;
    pnlControl.Left  := pgInfo.Left;
    pnlControl.Width := pgInfo.Width;
  end;

  pnlBorder.Width := pgInfo.Left;
  pnlBorder.Height := stbStatus1.Top;
  if (DsOptions and CDirectShowMethodNativeVideoSize) <> 0 then
  begin
    if pnlBorder.Width > VideoWidth then
      pnlBorder.Width := VideoWidth + 6;
    if pnlBorder.Height > VideoHeight then
      pnlBorder.Height := VideoHeight + 6;
  end;
  pnlVideo.Width  := pnlBorder.Width - 6;
  pnlVideo.Height := pnlBorder.Height - 6;

  txtVideoSize.Caption := Format('%d x %d', [pnlVideo.Width, pnlVideo.Height]);

  LeftCalc := 0;
  for Loop := 0 to 9 do
  begin
    PanelLeft[Loop] := LeftCalc;
    LeftCalc := LeftCalc + stbStatus1.Panels[Loop].Width;
  end;
  stbStatus1.Panels[8].Width := reEvents.Width - PanelLeft[8] - 104;
  stbStatus2.Panels[8].Width := stbStatus1.Panels[8].Width;
  // Recalculate positions due to change
  LeftCalc := 0;
  for Loop := 0 to 9 do
  begin
    PanelLeft[Loop] := LeftCalc;
    LeftCalc := LeftCalc + stbStatus1.Panels[Loop].Width;
  end;

  chkEpg.Top := stbStatus1.Top + 4;
  chkEpg.Left := PanelLeft[9] + 4;
  chkEPGPresentInfoOnly.Top := chkEpg.Top;
  chkEPGPresentInfoOnly.Left := chkEpg.Left + 40;
  chkEPGShortNameOnly.Top := stbStatus2.Top + 4;
  chkEPGShortNameOnly.Left := chkEpg.Left;

  // Place file positioner
  tbFile.Left := PanelLeft[8] + 3;
  tbFile.Top := stbStatus1.Top + 4;
  tbFile.Width := stbStatus1.Panels[8].Width - 5;
  tbFile.Height := stbStatus1.Height - 5;
  // Place current event bar positioner
  pbCurrentEvent.Left := PanelLeft[8] + 3;
  pbCurrentEvent.Top := stbStatus1.Top + 4;
  pbCurrentEvent.Width := stbStatus1.Panels[8].Width - 10 -
    txtMinutesToGo.Width;
  pbCurrentEvent.Height := stbStatus1.Height - 5;
  txtMinutesToGo.Top := pbCurrentEvent.Top;
  txtMinutesToGo.Left := pbCurrentEvent.Left + pbCurrentEvent.Width + 4;

  if (txtMinutesToGo.Width) >= stbStatus1.Panels[8].Width then
    txtMinutesToGo.Enabled := False
  else
    txtMinutesToGo.Enabled := True;
  if (pbCurrentEvent.Width) >= stbStatus1.Panels[8].Width then
    pbCurrentEvent.Enabled := False
  else
    pbCurrentEvent.Enabled := True;

  if (DsOptions and CDirectShowMethodAlternative) <> 0 then
    DvbDirectShow2.DirectShowResize
  else
    DvbDirectShow.DirectShowGraph.DirectShowResize;
end;

procedure TfrmMain.pnlVideoDblClick(Sender: TObject);
begin
  FullScreenMode(not FFullScreenMode);
end;

procedure TfrmMain.mnuDirectShowOptionsClick(Sender: TObject);
begin
  if not Assigned(FSetupDirectShow) then
  begin
    FSetupDirectShow := TfrmSetupDirectShow.Create(Application);
    SetDirectShowSetup(FSetupDirectShow);
  end;
  FSetupDirectShow.ExitNotify := SetupDirectShowExit;
  FSetupDirectShow.Show;
end;

procedure TfrmMain.SetupDirectShowExit(Sender: TObject);
begin
  GetAndWriteDirectShowSetup(FSetupDirectShow, False);
  if FSetupDirectShow.SettingChanged then
    btnReinitClick(nil);
  // Since the form closes itself make sure we know it too
  FSetupDirectShow := nil;
end;

procedure TfrmMain.mnuSetupCardClick(Sender: TObject);
begin
  if not Assigned(FSetupCard) then
  begin
    FSetupCard := TfrmSetupCard.Create(Application);
    // Set all settings
    SetCardSetup(FSetupCard);
  end;
  FSetupCard.ExitNotify := SetupCardExit;
  FSetupCard.Show;
end;

procedure TfrmMain.SetupCardExit(Sender: TObject);
begin
  GetAndWriteCardSetup(FSetupCard, False);
  if FSetupCard.SettingChanged then
  begin
    ShowMessage('For settings to have effect you have to restart the application.'#10#10'The apllication will now terminate.');
    Application.Terminate;
  end;
  // Since the form closes itself make sure we know it too
  FSetupCard := nil;
end;

procedure TfrmMain.mnuSetupFilesClick(Sender: TObject);
begin
  if not Assigned(FSetupFiles) then
  begin
    FSetupFiles := TfrmSetupFiles.Create(Application);
    // Set all settings
    SetFilesSetup(FSetupFiles);
  end;
  FSetupFiles.ExitNotify := SetupFilesExit;
  FSetupFiles.Show;
end;

procedure TfrmMain.SetupFilesExit(Sender: TObject);
begin
  GetAndWriteFilesSetup(FSetupFiles, False);
  if FSetupFiles.SettingChanged then
  begin
    ReadLists;
    ReadFavourites;
  end;
  // Since the form closes itself make sure we know it too
  FSetupFiles := nil;
end;

procedure TfrmMain.mnuSetupDiSEqCClick(Sender: TObject);
begin
  if not Assigned(FSetupDiSEqC) then
  begin
    FSetupDiSEqC := TfrmSetupDiSEqC.Create(Application);
    // Set all settings
    SetDiSEqCSetup(FSetupDiSEqC);
  end;
  FSetupDiSEqC.ExitNotify := SetupDiSEqCExit;
  FSetupDiSEqC.Show;
end;

procedure TfrmMain.SetupDiSEqCExit(Sender: TObject);
begin
  GetAndWriteDiSEqCSetup(FSetupDiSEqC, False);
  // Since the form closes itself make sure we know it too
  FSetupDiSEqC := nil;
end;

procedure TfrmMain.mnuSetupMiscellaneousClick(Sender: TObject);
begin
  if not Assigned(FSetupMiscellaneous) then
  begin
    FSetupMiscellaneous := TfrmSetupMiscellaneous.Create(Application);
    // Set all settings
    SetMiscellaneousSetup(FSetupMiscellaneous);
  end;
  FSetupMiscellaneous.ExitNotify := SetupMiscellaneousExit;
  FSetupMiscellaneous.Show;
end;

procedure TfrmMain.SetupMiscellaneousExit(Sender: TObject);
begin
  GetAndWriteMiscellaneousSetup(FSetupMiscellaneous, False);
  // Since the form closes itself make sure we know it too
  FSetupMiscellaneous := nil;
end;

procedure TfrmMain.mnuSetupRemoteClick(Sender: TObject);
begin
  if not Assigned(FSetupRemote) then
  begin
    FSetupRemote := TfrmSetupRemote.Create(Application);
    // Set all settings
    SetRemoteSetup(FSetupRemote);
  end;
  FSetupRemote.ExitNotify := SetupRemoteExit;
  FSetupRemote.Show;
end;

procedure TfrmMain.SetupRemoteExit(Sender: TObject);
begin
  GetAndWriteRemoteSetup(FSetupRemote, False);
  // Since the form closes itself make sure we know it too
  FSetupRemote := nil;
end;

procedure TfrmMain.imgRecordListClick(Sender: TObject);
var
  ItemsAvailable: Boolean;
begin
  if not Assigned(FRecordings) then
  begin
    FRecordings := TfrmRecording.Create(Application);
    // Set all settings
    ItemsAvailable := SetRecordings(FRecordings);
  end
  else
    ItemsAvailable := True;
  if not ItemsAvailable then
  begin
    if Assigned(FRecordings) then
      FreeAndNil(FRecordings);
    Exit;
  end;
  FRecordings.ExitNotify := RecordingsExit;
  FRecordings.Show;
end;

procedure TfrmMain.RecordingsExit(Sender: TObject);
begin
  GetAndWriteRecordings(FRecordings, False);
  // Since the form closes itself make sure we know it too
  FRecordings := nil;
end;

{------------------------------------------------------------------------------
  Params  : <ToSort>  Recordings to sort
  Returns : -

  Descript: Sort recording items
  Notes   : They are temporarily disabled
 ------------------------------------------------------------------------------}

procedure SortRecordItems(var ToSort: TRecordItems);
var
  Loop: Integer;
  Index1: Integer;
  Index2: Integer;
  TempRecord: TRecordItem;
  OrgRecords: TRecordItems;
  SortOrder: TRecordItems;
begin
  OrgRecords := ToSort;
  // Disabled recording items (this does not stop any current recording ....,
  // just makes sure it is not used temporarily)
  for Loop := Low(ToSort) to High(ToSort) do
    ToSort[Loop].Active := False;
  // Keep a record of the sorting
  for Loop := Low(SortOrder) to High(SortOrder) do
    SortOrder[Loop].RecordId := Loop;

  // Now sort list in ascending order (we can only do this because they are
  // currently not active!)
  for Index1 := Low(ToSort) to High(ToSort) do
    for Index2 := Low(ToSort) to High(ToSort) - Index1 - 1 do
      if ToSort[Index2 + 1].StartTime < ToSort[Index2].StartTime then
      begin
        TempRecord := ToSort[Index2];
        ToSort[Index2] := ToSort[Index2 + 1];
        ToSort[Index2 + 1] := TempRecord;
        // Also keep sorting order for restoring items later
        TempRecord := SortOrder[Index2];
        SortOrder[Index2] := SortOrder[Index2 + 1];
        SortOrder[Index2 + 1] := TempRecord;
      end;
  // Restore active states. Problem is that we have changed the order .....
  for Loop := Low(OrgRecords) to High(OrgRecords) do
    ToSort[Loop].Active := OrgRecords[SortOrder[Loop].RecordId].Active;
end;

{------------------------------------------------------------------------------
  Params  : <ToSort>  Recordings to check
  Returns : -

  Descript: Remove duplicate recording items
  Notes   :
 ------------------------------------------------------------------------------}

procedure RemoveDuplicateRecordItems(var ToCheck: TRecordItems);
var
  Index1: Integer;
  Index2: Integer;
begin
  for Index1 := Low(ToCheck) to High(ToCheck) - 1 do
    if ToCheck[Index1].Active then
      for Index2 := Index1 + 1 to High(ToCheck) do
        if ToCheck[Index2].Active then
        begin
          if (ToCheck[Index1].RecordId = ToCheck[Index2].RecordId) and
            (ToCheck[Index1].StartTime = ToCheck[Index2].StartTime) and
            (ToCheck[Index1].StopTime = ToCheck[Index2].StopTime) and
            (ToCheck[Index1].ListIndex = ToCheck[Index2].ListIndex) and
            (ToCheck[Index1].FavouriteIndex = ToCheck[Index2].FavouriteIndex)
            and
            (ToCheck[Index1].Tuning = ToCheck[Index2].Tuning) then
            ToCheck[Index2].Active := False
        end;
end;

{------------------------------------------------------------------------------
  Params  : <ToSort>  Recordings to check
  Returns : -

  Descript: Remove expired recording items
  Notes   :
 ------------------------------------------------------------------------------}

procedure RemoveExpiredRecordItems(var ToCheck: TRecordItems);
var
  Index1: Integer;
begin
  for Index1 := Low(ToCheck) to High(ToCheck) do
    if ToCheck[Index1].Active and (ToCheck[Index1].RecordId = $FF) then
    begin
      if (ToCheck[Index1].StartTime < Now) and
        (ToCheck[Index1].StopTime < Now) then
        ToCheck[Index1].Active := False;
    end;
end;

{------------------------------------------------------------------------------
  Params  : <ToCheck>  Recordings to check
  Returns : <Result>   True if overlapping

  Descript: Check if overlapping recordings on different transponders
  Notes   :
 ------------------------------------------------------------------------------}

function OverlappedRecordings(ToCheck: TRecordItems): Boolean;
var
  Index: Integer;
  Index2: Integer;
begin
  Result := False;
  for Index := Low(ToCheck) to High(ToCheck) - 1 do
    for Index2 := Index + 1 to High(ToCheck) do
      if ToCheck[Index].Active and (ToCheck[Index].RecordId = $FF) and
        ToCheck[Index2].Active and (ToCheck[Index2].RecordId = $FF) then
      begin
        if ToCheck[Index].Tuning <> ToCheck[Index2].Tuning then
        begin
          if (ToCheck[Index].StartTime < ToCheck[Index2].StartTime) then
          begin
            // First time starts first
            if ToCheck[Index].StopTime >= (ToCheck[Index2].StartTime -
              ChannelSwitchPreTime) then
            begin
              Result := True;
              Exit;
            end;
          end
          else
          begin
            // Second time starts first
            if ToCheck[Index2].StopTime >= (ToCheck[Index].StartTime -
              ChannelSwitchPreTime) then
            begin
              Result := True;
              Exit;
            end;
          end;
        end;
      end;
end;

procedure TfrmMain.imgAddRecordingClick(Sender: TObject);
var
  Index: Integer;
  RecordPids: TPidLists;
  ProgName: ShortString;
  Tuning: ShortString;
  Hour: Word;
  Min: Word;
  Sec: Word;
  Msec: Word;
begin
  // Find first available in list
  Index := Low(RecordItems);
  while (Index <= High(RecordItems)) and RecordItems[Index].Active do
    Inc(Index);
  if Index <= High(RecordItems) then
  begin
    GetRecordingPids(RecordPids);
    RecordItems[Index].Active := True;
    RecordItems[Index].RecordId := $FF;
    RecordItems[Index].Miscellaneous := 0;
    // Unfortunately the 'Time' is not always ONLY the time. Sometimes part
    // of the date is also included
    DecodeTime(dtStartRecording.Time, Hour, Min, Sec, Msec);
    RecordItems[Index].StartTime := Date + EncodeTime(Hour, Min, Sec, 0);
    DecodeTime(dtStopRecording.Time, Hour, Min, Sec, Msec);
    RecordItems[Index].StopTime := Date + EncodeTime(Hour, Min, Sec, 0);
    // Correct for a single day if passed 24 hour
    if RecordItems[Index].StopTime < RecordItems[Index].StartTime then
      RecordItems[Index].StopTime := Date + EncodeTime(Hour, Min, Sec, 0) + 1;
    RecordItems[Index].Pids := RecordPids;

    RecordItems[Index].ListIndex := cmbLists.ItemIndex;
    RecordItems[Index].FavouriteIndex := cmbFavourites.ItemIndex;
    ;
    Tuning := Copy(cmbFavourites.Items[cmbFavourites.ItemIndex], 64, 255);
    // We have to remove the service identifier from the actual tuning info
    Tuning := Trim(Tuning);
    Delete(Tuning, Length(Tuning) - 5, 255);
    RecordItems[Index].Tuning := Tuning;
    ProgName := Copy(cmbFavourites.Items[cmbFavourites.ItemIndex], 1, 63);
    Delete(ProgName, 1, 6);
    ProgName := Trim(ProgName);
    RecordItems[Index].ProgramName := Progname;
    RemoveDuplicateRecordItems(RecordItems);
    RemoveExpiredRecordItems(RecordItems);
    SortRecordItems(RecordItems);
    if OverlappedRecordings(RecordItems) then
      ShowMessage('Overlapped recordings on different transponders detected');
  end
  else
    ShowMessage('No room for additional recording available');
end;

{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Creation of form.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.FormCreate(Sender: TObject);
var
  ErrorMessage: string;
  FontN: array[0..31] of Char;
  ReturnedByte: Byte;
  MajorError: Boolean;
  Loop: Integer;
  DsSuccess: Boolean;
begin
  ResetDiSEqC;
  FSetupDirectShow := nil;
  FSetupCard := nil;
  FSetupFiles := nil;
  FSetupDiSEqC := nil;
  FSetupMiscellaneous := nil;
  FSetupRemote := nil;
  FRecordings := nil;

  // A value <= 0 disables EPG completely
  if EpgHeight <= 0 then
  begin
    reEvents.Visible := False;
    chkEpg.Checked := False;
    chkEpg.Visible := False;
    chkEpgPresentInfoOnly.Visible := False;
    chkEpgShortNameOnly.Visible := False;
  end;

  LowestTop  := pgInfo.Height + stbStatus1.Height + stbStatus2.Height + 2;
  LowestLeft := pgInfo.Width  + 64;

  MenuAndCaption := GetSystemMetrics(SM_CYCAPTION) + 5;
  MenuAndCaption := MenuAndCaption + GetSystemMetrics(SM_CYMENU) + 5;

  for Loop := Low(OsdBitmaps) to High(OsdBitmaps) do
  begin
    OsdBitmaps[Loop].Info := @OsdBitmaps[Loop].Header[0];
    ZeroMemory(OsdBitmaps[Loop].Info, sizeof(OsdBitmaps[Loop].Header));
    OsdBitmaps[Loop].Info.bmiHeader.biSize := sizeof(BITMAPINFOHEADER);
    OsdBitmaps[Loop].Info.bmiHeader.biWidth := COsdWidth;
    OsdBitmaps[Loop].Info.bmiHeader.biHeight := -COsdHeight;
    OsdBitmaps[Loop].Info.bmiHeader.biPlanes := 1;
    OsdBitmaps[Loop].Info.bmiHeader.biBitCount := 32;
    OsdBitmaps[Loop].Info.bmiHeader.biCompression := BI_RGB;
    OsdBitmaps[Loop].Info.bmiHeader.biSizeImage := 0;
    OsdBitmaps[Loop].Info.bmiHeader.biXPelsPerMeter := 0;
    OsdBitmaps[Loop].Info.bmiHeader.biYPelsPerMeter := 0;
    OsdBitmaps[Loop].Info.bmiHeader.biClrUsed := 0;
    OsdBitmaps[Loop].Info.bmiHeader.biClrImportant := 0;
    OsdBitmaps[Loop].DC := CreateCompatibleDC(0);
    OsdBitmaps[Loop].Handle := CreateDIBSection(OsdBitmaps[Loop].DC,
      BITMAPINFO(OsdBitmaps[Loop].Info^),
      DIB_RGB_COLORS, Pointer(OsdBitmaps[Loop].Data), 0, 0);
    SelectObject(OsdBitmaps[Loop].DC, OsdBitmaps[Loop].Handle);
    OsdFillColor(Loop, COsdTransparentColorRGB);
  end;

  FFullScreenForm := TForm.CreateNew(nil);
  with FFullScreenForm do
  begin
    BorderIcons := [];
    BorderStyle := bsNone;
    KeyPreview := True;
    OnKeyDown := Self.OnKeyDown;
    OnKeyPress := Self.OnKeyPress;
    OnKeyUp := Self.OnKeyUp;
    OnDblClick := imgEnterClick;
    SetBounds(0, 0, Screen.Width, Screen.Height);
  end;

  FStateMachineKeys := -1;
  FFullScreenMode := False;
  // Rich text for event viewing
  FRichView := TRichView.Create(Self);
  FRichView.Parent := Self;
  FRichViewStyle := TRVStyle.Create(FRichView);
  with FRichView do
  begin
    Style := FRichViewStyle;
    Height := reEvents.Height;
    Width := reEvents.Width;
    Left := reEvents.Left;
    Top := reEvents.Top;
    FirstJumpNo := 0;
    OnJump := RichViewJump;
  end;
  with FRichViewStyle do
  begin
    Color := reEvents.Color;
    with TextStyles[rvsJump1] do
    begin
      if FontNameEpg = '' then
        FontName := 'MS Sans Serif'
      else
        FontName := FontNameEpg;
      Color := clYellow;
      Style := [fsBold];
      Size := FontSizeEpg;
    end;
    FRichViewStyle1 := AddTextStyle;
    with TextStyles[FRichViewStyle1] do
    begin
      if FontNameEpg = '' then
        FontName := 'MS Sans Serif'
      else
        FontName := FontNameEpg;
      Color := clWhite;
      Style := [fsBold];
      Size := FontSizeEpg;
    end;
    FRichViewStyle2 := AddTextStyle;
    with TextStyles[FRichViewStyle2] do
    begin
      if FontNameEpg = '' then
        FontName := 'MS Sans Serif'
      else
        FontName := FontNameEpg;
      Color := clLime;
      Style := [fsBold];
      Size := FontSizeEpg;
    end;
    FRichViewStyle3 := AddTextStyle;
    with TextStyles[FRichViewStyle3] do
    begin
      if FontNameEpg = '' then
        FontName := 'MS Sans Serif'
      else
        FontName := FontNameEpg;
      Color := clAqua;
      Style := [fsBold];
      Size := FontSizeEpg;
    end;
    FRichViewStyle4 := AddTextStyle;
    with TextStyles[FRichViewStyle4] do
    begin
      if FontNameEpg = '' then
        FontName := 'MS Sans Serif'
      else
        FontName := FontNameEpg;
      Color := clWhite;
      Style := [];
      Size := FontSizeEpg;
    end;
  end;
  FRichView.Refresh;

  MajorError := False;
  if FontName <> '' then
  begin
    StrpCopy(FontN, FontName + '.TTF');
    AddFontResource(FontN);
    SendMessage(HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
    Self.Font.Name := FontName;
    Self.Font.Size := FontSize;
  end;

  Application.ShowHint := True;
  Caption := AppName + format('V%1.1x.%2.2x%s, build %x', [Version div $100,
    Version mod $100, SubVersion, Build]);
  stbStatus1.Panels[0].Text := 'MajorDVB';
  stbStatus2.Panels[0].Text := format('V%1.1x.%2.2x%s, build %x', [Version div
    $100, Version mod $100, SubVersion, Build]);
  mmoDriver.Lines.Add(Caption);
  // Check if the driver is present and/or multiple cards are present
  if UpperCase(DvbCard) <> 'NONE' then
  begin
    case Saa7146aGetNumberOfCards of
      0:
        begin
          if UseFlexCop then
            ToLog('No FLEXCOP driver and/or card detected.', $81)
          else
            ToLog('No SAA7146A driver and/or card detected.', $81);
          //         Exit;
        end;
    else
      begin
        if (CardHandle <> INVALID_HANDLE_VALUE) then
        begin
          if IsSlave then
            ToLog('Set to operate as slave.', $81)
          else
            ToLog('Set to operate as master.', $81);

          if UseFlexCop then
          begin
            ToLog('--FLEXCOP--', $81);
            ToLog(format('Synthesizer address: %d', [SynthesizerAddress]), $81);
          end
          else
          begin
            ToLog('--SAA7146A--', $81);
            // Inform about settings
            if DvbCardPreset then
              ToLog('Using presets for ''' + DvbCard + ''' card.', $81);
            case TunerType of
              CTunerBSRU6: ToLog('Tuner: BSRU6', $81);
              CTunerSU1278: ToLog('Tuner: SU1278', $81);
              CTunerBSBE1: ToLog('Tuner: BSBE1', $81);
            else
              ToLog('Tuner: Unknown', $81);
            end;
            if TunerReset = 255 then
              ToLog('Reset: -', $81)
            else
              ToLog(format('Reset: GPIO%d', [TunerReset]), $81);
            if LnbPolarity = 255 then
              ToLog('Polarity: -', $81)
            else
              ToLog(format('Polarity: OP%d', [LnbPolarity]), $81);
            if LnbOnOff = 255 then
              ToLog('LNB on/off: -', $81)
            else
              ToLog(format('LNB on/off: OP%d', [LnbOnOff]), $81);
            ToLog(format('Synthesizer address: %d', [SynthesizerAddress]), $81);
          end;
          if Assigned(PacketThread) then
            ToLog(format('Using %d buffers (appr. %d ms).',
              [PacketThread.FPacketBuffers, PacketThread.FPacketBuffers * 20]),
              $81);
        end;
        case CsaMethod of
          cmNone: ToLog('Using no CSA mechanism.', $81);
          cmInternal: ToLog('Using internal CSA mechanism.', $81);
          cmCsa: ToLog(format('Using external CSA mechanism: %s.', [CsaName]),
              $81);
          cmFfCsa: ToLog(format('Using external FFDeCSA mechanism: %s.',
              [CsaName]), $81)
        end;
        // There is only one reason why the handle would not be correct, and that
        // is when a requested card number has been used which is not present
        if CardHandle <> INVALID_HANDLE_VALUE then
        begin
          if UseFlexCop then
          begin
            if not FlexCopReadFromSynthesizer(CardHandle, SynthesizerAddress,
              ReturnedByte) then
            begin
              ToLog('Error accessing synthesizer. Synthesizer address might be incorrect or setup parameters.', $81);
              ShowMessage('Error accessing synthesizer.'#13#10'Synthesizer address might be incorrect or setup parameters.');
              SynthesizerAddress := 255;
              MajorError := True;
            end;
          end
          else if not Saa7146aReadFromSynthesizer(CardHandle,
            SynthesizerAddress,
            ReturnedByte) then
          begin
            ToLog('Error accessing synthesizer. Synthesizer address might be incorrect or setup parameters.', $81);
            ShowMessage('Error accessing synthesizer.'#13#10'Synthesizer address might be incorrect or setup parameters.');
            SynthesizerAddress := 255;
            MajorError := True;
          end;
        end
        else
        begin
          LNBPolarity := 255;
          SynthesizerAddress := 255;
          ToLog('Invalid ''Device='', no card at indicated index detected.',
            $81);
        end;
      end;
    end;
  end
  else
    ToLog('Working in no hardware mode.', $81);
  if FileExists(DsGraphFile) then
    ToLog(format('Using "%s" graph file for DirectShow.', [DsGraphFile]), $81)
  else
    ToLog('Manual graph building used for DirectShow.', $81);
  if DsSendAll then
    ToLog('Sending all DVB-S packets to DirectShow.', $81);

  if not DsOff then
  begin
    ShowAudioVideo := False;
    DsFunctional := False;
    Caption := AppName + 'Initializing DirectShow ...';
    Refresh;
    if (DsOptions and CDirectShowMethodAlternative) <> 0 then
      DsSuccess := DvbDirectShow2.DirectShowStart(pnlVideo.Handle, DsGraphFile,
        (DsOptions and CDirectShowMethodDoNotRender) <> 0,
        (DsOptions and CDirectShowMethodDoNotAddToRot) = 0,
        (DsOptions and CDirectShowMethodVideoRendererWindowless) <> 0,
        ErrorMessage, INVALID_HANDLE_VALUE)
    else
      DsSuccess :=
        DvbDirectShow.DirectShowGraph.DirectShowStart(pnlVideo.Handle,
        DsGraphFile,
        DsOptions, ErrorMessage);
    if not DsSuccess then
    begin
      ToLog('DirectShow error: ' + ErrorMessage, $81);
      ShowMessage('DirectShow error: ' + ErrorMessage);
    end
    else
    begin
{$IFDEF DSBUFFER}
      DsBufferIndex := Low(DsBuffer);
{$ENDIF}
      DsFunctional := True;
      ShowAudioVideo := True;
      if (DsOptions and CDirectShowMethodAlternative) <> 0 then
        DvbDirectShow2.DirectShowResize
      else
        DvbDirectShow.DirectShowGraph.DirectShowResize;
      DirectShowFiltersAddToMenu;
    end;
    DirectShowGraphsAddToMenu;
    chkDirectShow.Checked := ShowAudioVideo;
  end
  else
  begin
    mnuReinit.Visible := False;
    chkDirectShow.Checked := False;
    chkDirectShow.Visible := False;
    chkVideo.Visible := False;
    chkAudio.Visible := False;
    ShowAudioVideo := False;
  end;

  Caption := AppName + 'Select List/Transponder';
  if not MajorError then
  begin
    if Assigned(PacketThread) then
      PacketThread.Resume;
    if Assigned(RemoteThread) then
      RemoteThread.Resume;
  end
  else if Assigned(PacketThread) then
    PacketThread.FOperation := otError;

  FindMdPlugins;
  // Update some debug info according to plugins
  if MdPlugins > 0 then
  begin
    txtFiltersPlugin1.Caption := 'Filters plugin ' + MdPlugin[0].Name + ':';
    txtFiltersPlugin1.Visible := True;
    txtFiltersDefinedPlugin1.Visible := True;
  end;
  if MdPlugins > 1 then
  begin
    txtFiltersPlugin2.Caption := 'Filters plugin ' + MdPlugin[1].Name + ':';
    txtFiltersPlugin2.Visible := True;
    txtFiltersDefinedPlugin2.Visible := True;
  end;
  if MdPlugins > 2 then
  begin
    txtFiltersPlugin3.Caption := 'Filters plugin ' + MdPlugin[2].Name + ':';
    txtFiltersPlugin3.Visible := True;
    txtFiltersDefinedPlugin3.Visible := True;
  end;
  if MdPlugins > 3 then
  begin
    txtFiltersPlugin4.Caption := 'Filters plugin ' + MdPlugin[3].Name + ':';
    txtFiltersPlugin4.Visible := True;
    txtFiltersDefinedPlugin4.Visible := True;
  end;

  // Set callbacks
  DvbSetSignallingCallback(CPidNIT, frmMain.Handle, WM_SIGNALLING);
  DvbSetSignallingCallbackPat(frmMain.Handle, WM_SIGNALLING);
  DvbSetSignallingCallbackCat(frmMain.Handle, WM_SIGNALLING);
  DvbSetSignallingCallbackPmt(frmMain.Handle, WM_SIGNALLING);
  DvbSetSignallingCallbackEvent(frmMain.Handle, WM_SIGNALLING);

  ReadLists;
  ReadFavourites;
  ReadSettings;
  chkEpgClick(nil);

  // Load list of favourites and transponders
  Favourite := $FFFF;
  Transponder := $FFFF;
  ServiceNumber := $FFFF;
  UpdateSettings(nil);
  if not InitializationSuccess then
  begin
    ToLog('Initialization failed.', $81);
    ShowMessage('Initialization failed.');
  end;
  // Start timer which updates plugin data after delay
  tmrInitStart.Enabled := True;
  // Set mixer callbacks and update indication
  Mixer.OnMuteChange := VolumeUpdate;
  Mixer.OnVolumeChange := VolumeUpdate;
  VolumeUpdate(nil);

  if UseFlexCop then
    lblOvertaken.Caption := 'Lost buffers:';
  if Rps0Program <> -1 then
  begin
    txtRemoteControl.Caption := 'Task not running';
    mnuRemoteControl.Enabled := False;
  end;
end;

{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Form destruction.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.FormDestroy(Sender: TObject);
var
  FontN: array[0..31] of Char;
  Index: Integer;
begin
  FilteringOff := True;
  btnScanAll.Tag := 0;
  btnScrambleScan.Tag := 0;
  tmrUpdate.Enabled := False;
  // Stop all filtering
  FilterLock.Acquire;
  try
    for Index := Low(AppFilters.Filters) to High(AppFilters.Filters) do
      AppFilters.Filters[Index].Active := False;
    FilterUpdateCrossReference(@AppFilters);
  finally
    FilterLock.Release;
  end;

  // Note: We MUST make sure that <DirectShowUniversalSourceSendData> is never called when DirectShow
  //       has stopped, therefore we inform the thread
  ProcessPids := False;
  ShowAudioVideo := False;
  DsFunctional := False;
  Sleep(50);
  if (DsOptions and CDirectShowMethodAlternative) <> 0 then
    DvbDirectShow2.DirectShowStop
  else
    DvbDirectShow.DirectShowGraph.DirectShowStop;

  WriteSettings;
  if Assigned(FavouritesIniFile) then
    if FavouritesIniFile <> TransponderListIniFile then
      FavouritesIniFile.Free;
  if FontName <> '' then
  begin
    StrpCopy(FontN, FontName + '.TTF');
    RemoveFontResource(FontN);
    SendMessage(HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
  end;

  for Index := Low(OsdBitmaps) to High(OsdBitmaps) do
  begin
    DeleteDC(OsdBitmaps[Index].DC);
    DeleteObject(OsdBitmaps[Index].Handle);
  end;
  FreeAndNil(FFullScreenForm);

  // Next MUST be after broadcasting ...
  CleanupMdPlugins;
end;

{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Exit application.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TfrmMain.chkDirectShowClick(Sender: TObject);
begin
  ShowAudioVideo := chkDirectShow.Checked;
end;

procedure TfrmMain.chkVideoClick(Sender: TObject);
begin
  ShowVideo := chkVideo.Checked;
  if (DsOptions and CDirectShowMethodAlternative) <> 0 then
  begin
    if chkVideo.Checked then
      DvbDirectShow2.DirectShowMpeg2DemultiplexerSetNewPids(PidVideo, PidAudio)
    else
      DvbDirectShow2.DirectShowMpeg2DemultiplexerSetNewPids(-1, PidAudio);
  end
  else
  begin
    if chkVideo.Checked then
      DvbDirectShow.DirectShowGraph.DirectShowMpeg2DemultiplexerSetNewPids(PidVideo, PidAudio, PidAudioIsAc3)
    else
      DvbDirectShow.DirectShowGraph.DirectShowMpeg2DemultiplexerSetNewPids(-1,
        PidAudio, PidAudioIsAc3);
  end;
end;

procedure TfrmMain.chkAudioClick(Sender: TObject);
begin
  ShowAudio := chkAudio.Checked;
  if (DsOptions and CDirectShowMethodAlternative) <> 0 then
  begin
    if chkAudio.Checked then
      DvbDirectShow2.DirectShowMpeg2DemultiplexerSetNewPids(PidVideo, PidAudio)
    else
      DvbDirectShow2.DirectShowMpeg2DemultiplexerSetNewPids(PidVideo, -1);
  end
  else
  begin
    if chkAudio.Checked then
      DvbDirectShow.DirectShowGraph.DirectShowMpeg2DemultiplexerSetNewPids(PidVideo, PidAudio, PidAudioIsAc3)
    else
      DvbDirectShow.DirectShowGraph.DirectShowMpeg2DemultiplexerSetNewPids(PidVideo, -1, False);
  end;
end;

procedure TfrmMain.chkPidsClick(Sender: TObject);
begin
  ProcessPids := chkPids.Checked;
end;

procedure TfrmMain.SetPolarity(PolarityVertical: Boolean);
begin
  if LNBPolarity = 255 then
    Exit;
  if not PolarityVertical then
  begin
    if UseFlexCop then
    begin
      if not FlexCopHorizontalPolarityLNB(CardHandle) then
        ToLog('Could not set horizontal polarity.', $82);
    end
    else if not Saa7146aHorizontalPolarityLNB(CardHandle, (LNBPolarity = 0))
      then
      ToLog('Could not set horizontal polarity.', $82);
    stbStatus2.Panels[5].Text := 'H';
  end
  else
  begin
    if UseFlexCop then
    begin
      if not FlexCopVerticalPolarityLNB(CardHandle) then
        ToLog('Could not set vertical polarity.', $82);
    end
    else if not Saa7146aVerticalPolarityLNB(CardHandle, (LNBPolarity = 0)) then
      ToLog('Could not set vertical polarity.', $82);
    stbStatus2.Panels[5].Text := 'V';
  end;
end;

procedure TfrmMain.SetSymbolrate(Symbolrate: Dword);
begin
  stbStatus2.Panels[6].Text := format('%d', [SymbolRate]);
  if UseFlexCop then
    FlexCopQpskSetSymbolRate(CardHandle, SymbolRate)
  else
    Saa7146aQpskSetSymbolRate(CardHandle, SymbolRate);
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>  True if transponder display

  Descript: Return if transponder is displaying or a favourite.
            When a transponder is displaying runtime information is used
            instead of scanned data.
  Notes   :
 ------------------------------------------------------------------------------}

function TfrmMain.TransponderDisplay: Boolean;
begin
  if chkTransponderDisplay.Checked or
    (cmbLists.ItemIndex < 1) then
    Result := True
  else
    Result := False;
end;

procedure TfrmMain.tmrStateMachineAutoECMTimer(Sender: TObject);
begin
  case FStateMachineAutoEcm of
    // Initially wait somewhat longer
    0: FStateMachineAutoECM := 1;
    1: FStateMachineAutoECM := 2;
    2:
      begin
        UpdateProgramInfo(False, False, True);
        FStateMachineAutoEcm := 5;
        NewChannelSet := True;
      end;
    4: FStateMachineAutoEcm := 5;
    5:
      begin
        FStateMachineAutoEcm := 4;
        if (AudioScrambled and not AudioIsDescrambled) or
          (VideoScrambled and not VideoIsDescrambled) then
        begin
          // No need to 'rotate' if less than 2
          if cmbEcmPids.Items.Count < 2 then
          begin
            FStateMachineAutoECM := -1;
            Exit;
          end;
          // Only step while we are not at the end of the list
          if cmbEcmPids.ItemIndex < (cmbEcmPids.Items.Count - 1) then
            cmbEcmPids.ItemIndex := cmbEcmPids.ItemIndex + 1
          else
            FStateMachineAutoECM := -1;
          UpdateSettings(cmbEcmPids);
        end
        else
          FStateMachineAutoECM := -1;
      end;
  else
    tmrStateMachineAutoEcm.Enabled := False;
  end;
end;

procedure TfrmMain.tmrUpdateTimer(Sender: TObject);
var
  LockState: Byte;
  Noise: Double;
  Noise2: Extended;
  StatusStr: string;
  NewStr: string;
  StrengthDecibel: Double;
  StrengthPercentage: Double;
  DeltaTime: Dword;
  DeltaTimeSecond: Dword;
  DeltaCount: Dword;
  Ticks: Dword;
  Programs: Byte;
  Second: Boolean;
  HalfSecond: Boolean;
  Count: Word;
  DummyW: Word;
  Dummy: TDvbPids;
  Language: TDvbLanguages;
  Hour1: Word;
  Hour2: Word;
  Minute1: Word;
  Minute2: Word;
  Second1: Word;
  Second2: Word;
  Msec: Word;
  TimeDifference: Double;
  PositionInFile: Real;
  SizeLow: Dword;
  SizeHigh: Dword;
  SizeHuge: Int64;
  Rect: TRect;

  VWidth: Integer;
  VHeight: Integer;

  VPid: Word;
  APid: Word;
  Loop: Integer;
  Size: Int64;

  Index: Integer;
  Chk: Integer;
  Service: Word;
  ServiceName: string;
  Found: Integer;
  Level: Integer;
  LevelPercentage: Byte;
  CurrentTime: TDateTime;
  Calc: Extended;
  SomethingInList: Boolean;

  RecList: Integer;
  Success: Boolean;
  //  CodeTable : Byte;
begin
  try
    // 'Second' elapsed
    Ticks := GetTickCount;
    DeltaTime := Abs(Ticks - HalfSecondUpdatePrevTimer);
    if DeltaTime >= 500 then
    begin
      HalfSecond := True;
      HalfSecondUpdatePrevTimer := Ticks;
    end
    else
      HalfSecond := False;

    DeltaTimeSecond := Abs(Ticks - SecondUpdatePreviousTimer);
    if DeltaTimeSecond >= 1000 then
    begin
      Second := True;
      SecondUpdatePreviousTimer := Ticks;
    end
    else
      Second := False;

    if OsdTimeOut > 0 then
    begin
      Dec(OsdTimeOut);
      if OsdTimeOut = 0 then
        OsdClear;
    end;

    // Handle PAT event
    if UpdatePat then
    begin
      cmbServices.Clear;
      Index := 0;
      Found := -1;
      while DvbGetProgramInfo(Index, Service, DummyW, DummyW, Dummy, Dummy,
        Dummy, Dummy, Language, Language, Dummy, Dummy, ServiceName) do
      begin
        cmbServices.Items.Add(format('%5.5d', [Service]));
        if (ServiceNumber = Service) then
        begin
          Found := cmbServices.Items.Count - 1;
          if (ProgramName = '') and (ServiceName <> '') then
          begin
            NewStr := '';
            for Chk := 1 to Length(ServiceName) do
              if not (Ord(ServiceName[Chk]) in [$80..$9F]) then
                NewStr := NewStr + ServiceName[Chk];
            //          Caption := AppName + NewStr;
            stbStatus2.Panels[8].Text := format('%s [%d]', [NewStr,
              ServiceNumber]);
            ProgramName := NewStr;
          end;
        end;
        Inc(Index);
      end;
      if Found >= 0 then
        cmbServices.ItemIndex := Found
      else
      begin
        // No match, add it the end of the list
        cmbServices.Items.Add(format('%5.5d', [ServiceNumber]));
        cmbServices.ItemIndex := cmbServices.Items.Count - 1;
      end;
      UpdatePat := False;
    end;

    if Second then
    begin
      // Current event progress bar
      try
        if TimeStartTime = 0 then
        begin
          pbCurrentEvent.Visible := False;
          txtMinutesToGo.Visible := False;
        end
        else
        begin
          CurrentTime := Now;
          if CurrentTime > TimeEndTime then
            pbCurrentEvent.Position := 100
          else if CurrentTime < TimeStartTime then
            pbCurrentEvent.Position := 0
          else
          begin
            pbCurrentEvent.Position := Trunc(((CurrentTime - TimeStartTime) *
              100) / TimeDeltaTime);
            DecodeTime(TimeEndTime - CurrentTime, Hour1, Minute1, Second1,
              Msec);
            txtMinutesToGo.Caption := Format('+%d', [Hour1 * 60 + Minute1]);
          end;
          if pbCurrentEvent.Enabled then
            pbCurrentEvent.Visible := True
          else
            pbCurrentEvent.Visible := False;
          if txtMinutesToGo.Enabled then
            txtMinutesToGo.Visible := True
          else
            txtMinutesToGo.Visible := False;
        end;
      except
      end;

      if FullScreenInit > 0 then
      begin
        Dec(FullScreenInit);
        if FullScreenInit = 0 then
        begin
          if (ParameterFullScreen = 'yes') or (ParameterFullScreen = '1') then
            FullScreenMode(True);
        end;
      end;
      // Force full screen mode (in case it was 'lost')
  //    if Application.Active and FullScreenMode then
  //      FullScreenMode(FullScreenMode);
      // CPU usage
      if CollectCPUData then
      begin
        // We only get data for the first CPU here
        stbStatus2.Panels[2].Text := format('%3.3d %%', [Round(GetCPUUsage(0) *
            100)]);
      end
      else
      begin
        stbStatus1.Panels[2].Text := '';
        stbStatus2.Panels[2].Text := '';
      end;

      // Update program name from stream
      if DvbGetProgramInfo($FF, ServiceNumber, DummyW, DummyW, Dummy, Dummy,
        Dummy, Dummy, Language, Language, Dummy, Dummy, ServiceName) then
      begin
        if (ServiceName <> '') then
        begin
          NewStr := '';
          for Chk := 1 to Length(ServiceName) do
            if not (Ord(ServiceName[Chk]) in [$80..$9F]) then
              NewStr := NewStr + ServiceName[Chk];
          stbStatus2.Panels[8].Text := format('%s [%d]', [NewStr,
            ServiceNumber]);
          ProgramName := NewStr;
        end;
      end;

      // Packet performance
      if (pgInfo.ActivePage = tsDebug) and (PacketTimingCount <> 0) then
      begin
        Calc := ((PacketTiming * 1000000) / HighPerformanceFrequency) /
          PacketTimingCount;
        txtPacketTime.Caption := Format('%.2f us', [Calc]);
      end;
      PacketTiming := 0;
      PacketTimingCount := 0;

      // Video rate
      Count := VideoPacketCount;
      if pgInfo.ActivePage = tsDebug then
        txtVideoPackets.Caption := Format('%d', [Count]);
      if Count <> VideoPacketPreviousCount then
      begin
        if Count > VideoPacketPreviousCount then
        begin
          DeltaCount := Count - VideoPacketPreviousCount;
          // Only for a valid difference (eg. buffer restart at 0)
          // Note: A value of 10000 can be reached with HDTV broadcasts ....
          if DeltaCount < 20000 then
          begin
            // Note: We use <CDvbPacketSize> but the actual data contents
            //       is less...  Since the rate varies this 'error' does not matter.
            DeltaCount := DeltaCount * CDvbPacketSize * 8;
            DeltaCount := DeltaCount div DeltaTimeSecond;
            if DeltaCount < 10 then
            begin
              stbStatus2.Panels[1].Text := '-';
            end
            else
            begin
              stbStatus2.Panels[1].Text := Format('%d kbps', [DeltaCount]);
            end;
          end;
        end;
        VideoPacketPreviousCount := Count;
      end;
    end;

    // Correct menu text if processing TS
    if TSProcessingDone then
    begin
      ProcessRecordedTSFile.Caption := 'Process recorded data TS file';
      tbFile.Visible := False;
      TSProcessingDone := False;
    end;
    if Second and Assigned(PacketThread) and Assigned(PacketThread.FFileStream)
      then
    begin
      StreamLock.Acquire;
      try
        // The position might have changed manually. If so change the position in the
        // file accordingly.
        // Since we will be operating possibly with very large files (>4G) we can
        // not use the Position property. Instead we have to use the handle and use
        // <GetFileSize>, <SetFilePointer> instead.
        if PrevSliderPosition <> tbFile.Position then
        begin
          // 0.01% of file size
          SizeHuge := PacketThread.FFileStreamSize div 10000;
          SizeHuge := SizeHuge * Int64(tbFile.Position);
          // Now multiple of chunk size
  //        SizeHuge := SizeHuge div Int64(SizeOf(TDvbTransportPacket));
  //        SizeHuge := SizeHuge * Int64(SizeOf(TDvbTransportPacket));
          SizeHuge := SizeHuge div Int64(StreamDataBufferSize);
          SizeHuge := SizeHuge * Int64(StreamDataBufferSize);
          SizeLow := SizeHuge and $FFFFFFFF;
          SizeHigh := SizeHuge shr 32;
          SetFilePointer(PacketThread.FFileStream.Handle, LongInt(SizeLow),
            @SizeHigh, FILE_BEGIN);
          // Next will force 'fast' update of DirectShow
          VPid := PidVideo;
          APid := PidAudio;
          if not chkVideo.Checked then
            VPid := 0;
          if not chkAudio.Checked then
            APid := 0;
          if (DsOptions and CDirectShowMethodAlternative) <> 0 then
            DvbDirectShow2.DirectShowMpeg2DemultiplexerSetNewPids(VPid, APid)
          else
            DvbDirectShow.DirectShowGraph.DirectShowMpeg2DemultiplexerSetNewPids(VPid, APid, PidAudioIsAc3);
        end
        else
        begin
          // 'Positioning' to the current position returns the current position ...
          SizeHigh := 0;
          SizeLow := SetFilePointer(PacketThread.FFileStream.Handle, 0,
            @SizeHigh, FILE_CURRENT);
          LARGE_INTEGER(SizeHuge).HighPart := SizeHigh;
          LARGE_INTEGER(SizeHuge).LowPart := SizeLow;
          PositionInFile := SizeHuge / PacketThread.FFileStreamSize;
          PositionInFile := PositionInFile * 10000;
          tbFile.Position := Round(PositionInFile);
        end;
        PrevSliderPosition := tbFile.Position;
        pbCurrentEvent.Visible := False;
        txtMinutesToGo.Visible := False;
        tbFile.Visible := True;
        ProcessRecordedTSFile.Caption := 'Cancel processing ...';
        chkTransponderDisplay.Checked := True;
      finally
        StreamLock.Release;
      end;
    end;

    // Check for start/stop recording
    if HalfSecond then
    begin
      DecodeTime(Time, Hour1, Minute1, Second1, Msec);
      SomethingInList := False;
      // Check in recording list
      for RecList := Low(RecordItems) to High(RecordItems) do
      begin
        // Check for starting of recording
        if RecordItems[RecList].Active and (RecordItems[RecList].RecordId = $FF)
          then
        begin
          SomethingInList := True;
          // First check if end time already passed
          TimeDifference := RecordItems[RecList].StopTime - Now;
          if TimeDifference > 0 then
          begin
            // End time not passed ...
            TimeDifference := RecordItems[RecList].StartTime - Now;
            // Check for switching channels
            if (TimeDifference >= 0) and (TimeDifference < ChannelSwitchPreTime)
              then
            begin
              // We could switch channels here, but we only do this if the
              // channel is different.
              // Since we might be getting here multiple times, we use a
              // marker to detect this ..
              if (RecordItems[RecList].ListIndex <> cmbLists.ItemIndex) or
                ((RecordItems[RecList].FavouriteIndex <>
                cmbFavourites.ItemIndex)) then
              begin
                if (RecordItems[RecList].Miscellaneous and $0001) = 0 then
                begin
                  cmbLists.ItemIndex := RecordItems[RecList].ListIndex;
                  cmbFavourites.ItemIndex :=
                    RecordItems[RecList].FavouriteIndex;
                  // Note: next is only handled if not recording ...
                  UpdateSettings(nil);
                  RecordItems[RecList].Miscellaneous :=
                    RecordItems[RecList].Miscellaneous or $0001;
                end;
              end;
              // Special case when start=stop time which is used when only
              // switching channels. Remove from list then.
              if RecordItems[RecList].StartTime = RecordItems[RecList].StopTime
                then
                RecordItems[RecList].Active := False;
            end;
            if TimeDifference < 0 then
            begin
              // Start recording
              RecordItems[RecList].RecordId :=
                StartRecording(RecordItems[RecList].Pids);
              if RecordItems[RecList].RecordId <> $FF then
                if Recording <> rtRecording then
                  Recording := rtStartRecording;
            end;
          end;
        end;
        // Check for ending of recording
        if RecordItems[RecList].Active and (RecordItems[RecList].RecordId <> $FF)
          then
        begin
          SomethingInList := True;
          DecodeTime(RecordItems[RecList].StopTime, Hour2, Minute2, Second2,
            Msec);
          if (Hour1 = Hour2) and (Minute1 = Minute2) and (Second1 = Second2)
            then
          begin
            // End recording
            StopRecording(RecordItems[RecList].RecordId);
            RecordItems[RecList].RecordId := $FF;
            RecordItems[RecList].Active := False;
            // Check if other recordings active ....
            if not RecordingIsActive then
            begin
              Recording := rtStopRecording;
              imgRecord3.Visible := False;
              imgRecord2.Visible := False;
              imgRecord.Visible := True;
            end;
          end;
        end;
      end;
      if imgRecordList.Visible <> SomethingInList then
        imgRecordList.Visible := SomethingInList;
      // Start recording (current program)
      if chkStartRecording.Checked and
        (Recording = rtIdle) then
      begin
        DecodeTime(dtStartRecording.Time, Hour2, Minute2, Second2, Msec);
        if (Hour1 = Hour2) and (Minute1 = Minute2) and (Second1 = Second2) then
        begin
          chkStartRecording.Checked := False;
          RecordingTimerIndex := StartRecordingProgram;
          if RecordingTimerIndex <> $FF then
          begin
            NewStr := 'Started recording [';
            Programs := Low(RecordingPids);
            while ((Programs <= High(RecordingPids)) and
              (RecordingPids[Programs].Pid <> $FFFF)) do
            begin
              NewStr := NewStr + format('%d, ', [RecordingPids[Programs].Pid]);
              Inc(Programs);
            end;
            NewStr[Length(NewStr) - 1] := ']';
            ToLog(NewStr + '.', $81);
            Recording := rtStartRecording;
            edtTime.Visible := True;
            // Handled elsewhere            edtFilePos.Visible := True;
            TimeRecordStarted := Now;
            edtTime.Text := FormatDateTime('HH":"MM":"SS', Now -
              TimeRecordStarted);
            edtFilePos.text := '0000  MB';
          end
          else
            ToLog('Error starting recording.', $81);
        end;
      end;
      // Stop recording (current program)
      if chkStopRecording.Checked and
        (Recording = rtRecording) then
      begin
        DecodeTime(dtStopRecording.Time, Hour2, Minute2, Second2, Msec);
        if (Hour1 = Hour2) and (Minute1 = Minute2) and (Second1 = Second2) then
        begin
          chkStopRecording.Checked := False;
          edtTime.Visible := False;
          // Handled elsewhere          edtFilePos.Visible := False;
          ToLog('Recording stopped.', $81);
          StopRecording(RecordingTimerIndex);
          RecordingTimerIndex := $FF;
          // Check if other recordings active ....
          if not RecordingIsActive then
          begin
            Recording := rtStopRecording;
            imgRecord3.Visible := False;
            imgRecord2.Visible := False;
            imgRecord.Visible := True;
          end;
          // Check parameters if we have to exit or shutdown now we have stopped
          if (ParameterExitAfterRecording = 'yes') or
            (ParameterExitAfterRecording = '1') then
          begin
            ShutdownOnExit := False;
            Application.Terminate;
          end;
          if (ParameterShutdownAfterRecording = 'yes') or
            (ParameterShutdownAfterRecording = '1') then
          begin
            ShutdownOnExit := True;
            Application.Terminate;
          end;
        end;
      end;
      // Shutdown
      if chkShutdown.Checked then
      begin
        DecodeTime(dtShutdown.Time, Hour2, Minute2, Second2, Msec);
        if (Hour1 = Hour2) and (Minute1 = Minute2) and (Second1 = Second2) then
        begin
          ShutdownOnExit := True;
          Application.Terminate;
        end;
      end;
      // Exit
      if dtExit.Enabled then
      begin
        DecodeTime(dtExit.Time, Hour2, Minute2, Second2, Msec);
        if (Hour1 = Hour2) and (Minute1 = Minute2) and (Second1 = Second2) then
        begin
          ShutdownOnExit := False;
          Application.Terminate;
        end;
      end;
    end;

    // Only handle specific 'events' when not recording
    if chkEventsWhileRecording.Checked or (Recording = rtIdle) then
    begin
      if Second then
      begin
        if (DsOptions and CDirectShowMethodAlternative) <> 0 then
          DvbDirectShow2.DirectShowGetSize(VWidth, VHeight)
        else
          DvbDirectShow.DirectShowGraph.DirectShowGetSize(VWidth, VHeight);
        if (VWidth <> VideoWidth) or (VHeight <> VideoHeight) then
        begin
          VideoWidth := VWidth;
          VideoHeight := VHeight;
          txtNativeVideoSize.Caption := Format('%d x %d', [VideoWidth,
            VideoHeight]);
          FormResize(nil);
        end;
      end;
      // Handle PMT event
      if UpdatePmt then
      begin
        // Update plugin with realtime data now it is available
        if ((TransponderHasChanged and $0001) = 0) and not TransponderDisplay
          then
          PidChanged;
        // Indicate PMT received
        TransponderHasChanged := TransponderHasChanged or $0001;
        if TransponderDisplay then
          UpdateSettings(nil);
        if UpdatePmtCount = $FFFF then
          UpdatePmtCount := 0
        else
          Inc(UpdatePmtCount);
        UpdatePmt := False;
      end;

      if UpdateCat then
      begin
        if ((TransponderHasChanged and $0002) = 0) then
        begin
          PidChanged;
          if UpdateCatCount = $FFFF then
            UpdateCatCount := 0
          else
            Inc(UpdateCatCount);
          // Indicate CAT received
          TransponderHasChanged := TransponderHasChanged or $0002;
        end;
        UpdateCat := False;
      end;

      // Handle EPG update
      if UpdateEvent then
      begin
        EventUpdate;
        UpdateEvent := False;
      end;

      // Handle update
      if UpdateProgram and
        TransponderDisplay then
      begin
        // We are only interested in the program name
        if DvbGetProgramInfo($FF, ServiceNumber, DummyW, DummyW, Dummy, Dummy,
          Dummy, Dummy, Language, Language, Dummy, Dummy, StatusStr) then
        begin
          if StatusStr <> '' then
          begin
            // Since the text may contain special control codes ($80..$9F) we remove them explicitly
            // Other specialties: $01..$0F indicates character coding table
            NewStr := '';
            if Ord(StatusStr[1]) in [$01..$0F] then
            begin
              //          CodeTable := Ord(StatusStr[1]);
              Delete(StatusStr, 1, 1);
              // Just to be sure an empty string does not generate an error ...
              if StatusStr = '' then
                StatusStr := #80;
            end;
            //        else
            //          CodeTable := 0;
            for Count := 1 to Length(StatusStr) do
              if not (Ord(StatusStr[Count]) in [$80..$9F]) then
                NewStr := NewStr + StatusStr[Count];
            //            Caption := AppName + NewStr;
            stbStatus2.Panels[8].Text := format('%s [%d]', [NewStr,
              ServiceNumber]);
            ProgramName := NewStr;
          end
            //          else
            //            Caption := AppName;
        end;
        if UpdateProgramCount = $FFFF then
          UpdateProgramCount := 0
        else
          Inc(UpdateProgramCount);
        UpdateProgram := False;
      end;
    end;

    // Blinking recording LED
    if Second and (Recording = rtRecording) then
    begin
      if imgRecord.Visible then
      begin
        imgRecord.Visible := False;
        if RecordingTimerIndex <> $FF then
        begin
          imgRecord3.Visible := False;
          imgRecord2.Visible := True;
        end
        else
        begin
          imgRecord2.Visible := False;
          imgRecord3.Visible := True;
        end;
      end
      else
      begin
        imgRecord2.Visible := False;
        imgRecord3.Visible := False;
        imgRecord.Visible := True;
      end;
      // Update recorded time
      edtTime.Text := FormatDateTime('HH":"MM":"SS', Now - TimeRecordStarted);
      // Add sizes of individual files
      // We need to use a different approach for getting the size just to support sizes > 2G
      Size := 0;
      if Assigned(RecordingAllFile) then
      begin
        SizeLow := SetFilePointer(RecordingAllFile.Handle, 0,
          @SizeHigh, FILE_CURRENT);
        LARGE_INTEGER(SizeHuge).HighPart := SizeHigh;
        LARGE_INTEGER(SizeHuge).LowPart := SizeLow;
        Size := Size + SizeHuge;
        Size := Size + RecordingAllSplitSize;
      end
      else
      begin
        for Loop := Low(RecordingPids) to High(RecordingPids) do
          if Assigned(RecordingPids[Loop].RecordingFile) then
          begin
            SizeLow := SetFilePointer(RecordingPids[Loop].RecordingFile.Handle,
              0,
              @SizeHigh, FILE_CURRENT);
            LARGE_INTEGER(SizeHuge).HighPart := SizeHigh;
            LARGE_INTEGER(SizeHuge).LowPart := SizeLow;
            Size := Size + SizeHuge;
            Size := Size + RecordingPids[Loop].SplitSize;
          end;
      end;
      // To MB
      Size := Size div 1000000;
      edtFilePos.Text := Format('%4.4d  MB', [Size]);
      if not edtFilePos.Visible then
        edtFilePos.Visible := True;
    end;
    if Second and (not (Recording = rtRecording)) then
      if edtFilePos.Visible then
        edtFilePos.Visible := False;

    // Debug screen
    if pgInfo.ActivePage = tsDebug then
    begin
      // Only update every second
      if Second then
      begin
        if Assigned(PacketThread) then
          case PacketThread.FOperation of
            otNoOp: rgOperation.ItemIndex := 0;
            otNormal: rgOperation.ItemIndex := 1;
            otError: rgOperation.ItemIndex := 2;
          end;
        txtPacketErrors.Caption := format('%d', [DvbGetErrors]);
        txtPacketSyncErrors.Caption := format('%d', [DvbGetPacketSyncErrors]);
        if PacketBufferCount <> PacketPreviousCount then
        begin
          // Additional check because of circular buffer
          if PacketBufferCount > PacketPreviousCount then
          begin
            DeltaCount := PacketBufferCount - PacketPreviousCount;
            txtMs.Caption := format('%d', [DeltaTimeSecond div DeltaCount]);
          end;
          PacketPreviousCount := PacketBufferCount;
        end;
      end;
      txtPacketCount.Caption := format('%d', [PacketBufferCount]);
      txtOvertaken.Caption := format('%d', [Overtaken]);
      txtFiltersDefinedApp.Caption := format('%d (%s)', [AppFilters.Active,
        AppFilters.ActiveText]);
      if MdPlugins > 0 then
        txtFiltersDefinedPlugin1.Caption := format('%d (%s)',
          [MdPlugin[0].Filters.Active, mdPlugin[0].Filters.ActiveText]);
      if MdPlugins > 1 then
        txtFiltersDefinedPlugin2.Caption := format('%d (%s)',
          [MdPlugin[1].Filters.Active, mdPlugin[1].Filters.ActiveText]);
      if MdPlugins > 2 then
        txtFiltersDefinedPlugin3.Caption := format('%d (%s)',
          [MdPlugin[2].Filters.Active, mdPlugin[2].Filters.ActiveText]);
      if MdPlugins > 3 then
        txtFiltersDefinedPlugin4.Caption := format('%d (%s)',
          [MdPlugin[3].Filters.Active, mdPlugin[3].Filters.ActiveText]);
    end;

    // Don't handle updating other information if we are not the master
    if IsSlave then
      Exit;

    // Update status if visible and not recording (just to be sure)
    if Second and Showing and (Recording = rtIdle) then
    begin
      if UseFlexCop then
        Success := FlexCopQpskGetInputLevel(CardHandle, Level, LevelPercentage)
      else
        Success := Saa7146aQpskGetInputLevel(CardHandle, Level,
          LevelPercentage);
      if Success then
      begin
        txtSignalLevel.Caption := format('%d dBm', [Level]);
        ggSignalLevel.Progress := LevelPercentage;
      end;
      if UseFlexCop then
        Success := FlexCopQpskGetSignalPower(CardHandle, StrengthPercentage,
          StrengthDecibel)
      else
        Success := Saa7146aQpskGetSignalPower(CardHandle, StrengthPercentage,
          StrengthDecibel);
      if Success then
      begin
        if pgInfo.ActivePage = tsTuning then
        begin
          txtSignalPower.Caption := format('%f dB', [StrengthDecibel]);
          ggSignalPower.Progress := Round(StrengthPercentage);
        end;
      end;
      if UseFlexCop then
        Success := FlexCopQpskGetNoiseIndicator(CardHandle, Noise)
      else
        Success := Saa7146aQpskGetNoiseIndicator(CardHandle, Noise);
      if Success then
      begin
        // We displaya noise indication from 0..12 dB as 0..100%
        Noise2 := (Noise / 12) * 100;
        if Noise2 < 0 then
          Noise2 := 0;
        if pgInfo.ActivePage = tsTuning then
        begin
          txtNoiseIndicator.Caption := format('%f dB', [Noise]);
          ggNoiseIndicator.Progress := Round(Noise2);
        end;
      end;
      StatusStr := '';
      NewStr := '';
      if VideoScrambled or AudioScrambled then
        stbStatus1.Panels[7].Text := 'Scrambled'
      else
        stbStatus1.Panels[7].Text := '';
      if VideoScrambled then
      begin
        if VideoIsDescrambled then
          StatusStr := 'video'
        else
          StatusStr := 'VIDEO';
      end;
      if AudioScrambled then
      begin
        if AudioIsDescrambled then
          NewStr := 'audio'
        else
          NewStr := 'AUDIO';
      end;
      if StatusStr = '' then
      begin
        StatusStr := NewStr;
        NewStr := '';
      end;
      if NewStr <> '' then
        StatusStr := StatusStr + '+' + NewStr;
      stbStatus2.Panels[7].Text := StatusStr;
    end;

    // Lock state is checked every second for re-tune
    if Second then
    begin
      if UseFlexCop then
        Success := FlexCopReadFromQpsk(CardHandle, CStv0299bVStatus, LockState)
      else
        Success := Saa7146aReadFromQpsk(CardHandle, CStv0299bVStatus,
          LockState);
      if Success then
      begin
        // Only update some stuff if showing and not recording
        if Showing and (Recording = rtIdle) then
        begin
          chkCarrier.Checked := ((LockState and $80) <> 0);
          chkViterbi.Checked := ((LockState and $10) <> 0);
          chkSync.Checked := ((LockState and $08) <> 0);
          chkLock.Checked := ((LockState and $98) = $98);
        end;

        // Manually place color and text in status bar
        // Not really good practice ....
        if (LockState and $98) = $98 then
        begin
          TransponderValid := True;
          chkTransponderValid.Checked := True;
          stbStatus2.Canvas.Brush.Color := clLime;
          if NoSignal > 0 then
            NoSignal := 0;
        end
        else
        begin
          TransponderValid := False;
          chkTransponderValid.Checked := False;
          // No re-tune if disabled
          if chkRetuneDisable.Checked then
            NoSignal := 0;
          // No re-tune if processing file
          if Assigned(PacketThread) and Assigned(PacketThread.FFileStream) then
            NoSignal := 0;
          // No re-tune if scanning
          if Scanning then
            NoSignal := 0;
          stbStatus2.Canvas.Brush.Color := clRed;
          if NoSignal < 3 then
            Inc(NoSignal)
          else
          begin
            if DiSEqCList.Count = 0 then
              TransponderChanged
            else
              TransponderChangedTuner;
            NoSignal := 0;
          end;
        end;
        Rect.Bottom := stbStatus2.Height - 1;
        Rect.Top := 3;
        Rect.Left := stbStatus2.Panels[0].Width +
          stbStatus2.Panels[1].Width +
          stbStatus2.Panels[2].Width +
          stbStatus2.Panels[3].Width + 3;
        Rect.Right := Rect.Left + stbStatus2.Panels[4].Width - 4;
        stbStatus2.Canvas.FillRect(Rect);
        stbStatus2.Canvas.Font := Font;
        stbStatus2.Canvas.TextOut(Rect.Left, Rect.Top + 1, '   ' +
          stbStatus2.Panels[4].Text);
      end;
    end;
  except
    // Capture any exception at runtime
  end;
end;

procedure TfrmMain.SetFrequency(Freq: LongWord);
begin
  // Make sure status updated
  if SynthesizerAddress <> 255 then
  begin
    if UseFlexCop then
    begin
      if FlexCopFrequencyLNB(CardHandle, Freq, LNBLofLowBand, LNBLofHighBand,
        TunerType, SynthesizerAddress) then
      begin
        Frequency := Freq;
        stbStatus2.Panels[4].Text := format('%d', [Frequency]);
      end;
    end
    else if Saa7146aFrequencyLNB(CardHandle, Freq, LNBLofLowBand,
      LNBLofHighBand,
      TunerType, SynthesizerAddress) then
    begin
      Frequency := Freq;
      stbStatus2.Panels[4].Text := format('%d', [Frequency]);
    end;
  end
  else
    stbStatus2.Panels[4].Text := 'ADDRESS';
end;

procedure TfrmMain.SetFrequencyTuner(Freq: LongWord; Lof: LongWord);
begin
  // Make sure status updated
  if SynthesizerAddress <> 255 then
  begin
    if UseFlexCop then
    begin
      if FlexCopFrequencyTunerLNB(CardHandle, Freq, TunerType,
        SynthesizerAddress) then
      begin
        Frequency := Freq + Lof;
        stbStatus2.Panels[4].Text := format('%d', [Frequency]);
      end;
    end
    else if Saa7146aFrequencyTunerLNB(CardHandle, Freq, TunerType,
      SynthesizerAddress) then
    begin
      Frequency := Freq + Lof;
      stbStatus2.Panels[4].Text := format('%d', [Frequency]);
    end;
  end
  else
    stbStatus2.Panels[4].Text := 'ADDRESS';
end;

procedure TfrmMain.imgUpClick(Sender: TObject);
begin
  if KeySwapUpDown and (Sender <> imgDown) then
  begin
    imgDownClick(imgUp);
    Exit;
  end;
  if not TransponderDisplay then
  begin
    if cmbFavourites.ItemIndex < (cmbFavourites.Items.Count - 1) then
      cmbFavourites.ItemIndex := cmbFavourites.ItemIndex + 1
    else
      cmbFavourites.ItemIndex := 0;
  end
  else
  begin
    if cmbServices.ItemIndex < (cmbServices.Items.Count - 1) then
      cmbServices.ItemIndex := cmbServices.ItemIndex + 1
    else
      cmbServices.ItemIndex := 0;
  end;
  UpdateSettings(nil);
end;

procedure TfrmMain.imgDownClick(Sender: TObject);
begin
  if KeySwapUpDown and (Sender <> imgUp) then
  begin
    imgUpClick(imgDown);
    Exit;
  end;
  if not TransponderDisplay then
  begin
    if cmbFavourites.ItemIndex > 0 then
      cmbFavourites.ItemIndex := cmbFavourites.ItemIndex - 1
    else
      cmbFavourites.ItemIndex := cmbFavourites.Items.Count - 1;
  end
  else
  begin
    if cmbServices.ItemIndex > 0 then
      cmbServices.ItemIndex := cmbServices.ItemIndex - 1
    else
      cmbServices.ItemIndex := cmbServices.Items.Count - 1;
    if cmbServices.ItemIndex = -1 then
      cmbServices.ItemIndex := 0;
  end;
  UpdateSettings(nil);
end;

procedure TfrmMain.imgLeftClick(Sender: TObject);
begin
  if not chkTransponderDisplay.Checked then
  begin
    if cmbLists.ItemIndex > 0 then
      cmbLists.ItemIndex := cmbLists.ItemIndex - 1
    else
      cmbLists.ItemIndex := cmbLists.Items.Count - 1;
  end
  else
  begin
    if cmbTransponders.ItemIndex > 0 then
      cmbTransponders.ItemIndex := cmbTransponders.ItemIndex - 1
    else
      cmbTransponders.ItemIndex := cmbTransponders.Items.Count - 1;
  end;
  UpdateSettings(nil);
end;

procedure TfrmMain.imgRightClick(Sender: TObject);
begin
  if not chkTransponderDisplay.Checked then
  begin
    if cmbLists.ItemIndex < (cmbLists.Items.Count - 1) then
      cmbLists.ItemIndex := cmbLists.ItemIndex + 1
    else
      cmbLists.ItemIndex := 0;
  end
  else
  begin
    if cmbTransponders.ItemIndex < (cmbTransponders.Items.Count - 1) then
      cmbTransponders.ItemIndex := cmbTransponders.ItemIndex + 1
    else
      cmbTransponders.ItemIndex := 0;
  end;
  UpdateSettings(nil);
end;

procedure TfrmMain.imgRecordClick(Sender: TObject);
var
  NewStr: string;
  Programs: Byte;
begin
  if (Recording <> rtIdle) and (RecordingTimerIndex <> $FF) then
  begin
    StopRecording(RecordingTimerIndex);
    RecordingTimerIndex := $FF;
    if not RecordingIsActive then
    begin
      Recording := rtStopRecording;
      imgRecord3.Visible := False;
      imgRecord2.Visible := False;
      imgRecord.Visible := True;
    end;
    edtTime.Visible := False;
    // Handled elsewhere    edtFilePos.Visible := False;
    ToLog('Recording stopped.', $81);
  end
  else
  begin
    RecordingTimerIndex := StartRecordingProgram;
    if RecordingTimerIndex <> $FF then
    begin
      NewStr := 'Started recording [';
      Programs := Low(RecordingPids);
      while ((Programs <= High(RecordingPids)) and (RecordingPids[Programs].Pid
        <> $FFFF)) do
      begin
        NewStr := NewStr + format('%d, ', [RecordingPids[Programs].Pid]);
        Inc(Programs);
      end;
      NewStr[Length(NewStr) - 1] := ']';
      ToLog(NewStr + '.', $81);
      Recording := rtStartRecording;
      edtTime.Visible := True;
      // Handled elsewhere      edtFilePos.Visible := True;
      TimeRecordStarted := Now;
      edtTime.Text := FormatDateTime('HH":"MM":"SS', Now - TimeRecordStarted);
      edtFilePos.Text := '0000  MB';
    end
    else
    begin
      ToLog('Error starting recording.', $81);
      Exit;
    end;
  end;
end;

procedure TfrmMain.mskPmtKeyPress(Sender: TObject; var Key: Char);
var
  Error: Integer;
begin
  if Key = #13 then
  begin
    Val(mskPmt.EditText, PidPmt, Error);
    UpdateSettings(nil);
  end;
end;

procedure TfrmMain.mskPcrKeyPress(Sender: TObject; var Key: Char);
var
  Error: Integer;
begin
  if Key = #13 then
  begin
    Val(mskPcr.EditText, PidPcr, Error);
    UpdateSettings(nil);
  end;
end;

procedure TfrmMain.cmbServicesKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    UpdateSettings(cmbServices);
end;

procedure TfrmMain.cmbVideoPidsKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    UpdateSettings(cmbVideoPids);
end;

procedure TfrmMain.cmbAudioPidsKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    UpdateSettings(cmbAudioPids);
end;

procedure TfrmMain.cmbSubtitlePidsKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    UpdateSettings(cmbSubtitlePids);
end;

procedure TfrmMain.cmbEcmPidsKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    UpdateSettings(cmbEcmPids);
end;

procedure TfrmMain.chkEpgClick(Sender: TObject);
begin
  chkEPGPresentInfoOnly.Visible := chkEpg.Checked;
  chkEPGShortNameOnly.Visible := chkEpg.Checked;
  EventUpdate;
end;

procedure TfrmMain.btnRecordDefaultClick(Sender: TObject);
var
  Loop: Word;
  Flag: Boolean;
begin
  while Length(RecordDefault) < 22 do
    RecordDefault := RecordDefault + '0';
  if Length(RecordDefault) < 1 then
    Exit;
  for Loop := 1 to Length(RecordDefault) do
  begin
    Flag := False;
    if RecordDefault[Loop] = '1' then
      Flag := True;
    case Loop of
      1: chkRecordVideo.Checked := Flag;
      2: chkRecordVideoAll.Checked := Flag;
      3: chkRecordAudio.Checked := Flag;
      4: chkRecordAudioAll.Checked := Flag;
      5: chkRecordTeletext.Checked := Flag;
      6: chkRecordTeletextAll.Checked := Flag;
      7: chkRecordSubtitle.Checked := Flag;
      8: chkRecordSubtitleAll.Checked := Flag;
      9: chkRecordPMT.Checked := Flag;
      10: chkRecordPMTAll.Checked := Flag;
      11: chkRecordPCR.Checked := Flag;
      12: chkRecordPCRAll.Checked := Flag;
      13: chkRecordECM.Checked := Flag;
      14: chkRecordECMAll.Checked := Flag;
      15: chkRecordIndividualStreams.Checked := Flag;
      16: chkRecordRawData.Checked := Flag;
      17: chkRecordNoFiltering.Checked := Flag;
      18: chkRecordTransponder.Checked := Flag;
      19: chkRecordPat.Checked := Flag;
      20: chkRecordMandatory.Checked := Flag;
      21: chkRecordCat.Checked := Flag;
      22: chkRecordEmm.Checked := Flag;
    end;
  end;
end;

procedure TfrmMain.btnReinitClick(Sender: TObject);
var
  ErrorMessage: string;
  OrgText: string;
  DsSuccess: Boolean;
begin
  OrgText := Caption;
  Caption := AppName + 'Re-initializing DirectShow ...';
  Refresh;
  ShowAudioVideo := False;
  DsFunctional := False;
  Sleep(50);
  if (DsOptions and CDirectShowMethodAlternative) <> 0 then
  begin
    DvbDirectShow2.DirectShowStop;
    DsSuccess := DvbDirectShow2.DirectShowStart(pnlVideo.Handle, DsGraphFile,
      (DsOptions and CDirectShowMethodDoNotRender) <> 0,
      (DsOptions and CDirectShowMethodDoNotAddToRot) = 0,
      (DsOptions and CDirectShowMethodVideoRendererWindowless) <> 0,
      ErrorMessage, INVALID_HANDLE_VALUE)
  end
  else
  begin
    DvbDirectShow.DirectShowGraph.DirectShowStop;
    DsSuccess := DvbDirectShow.DirectShowGraph.DirectShowStart(pnlVideo.Handle,
      DsGraphFile,
      DsOptions, ErrorMessage);
  end;
  if not DsSuccess then
  begin
    ToLog('DirectShow error: ' + ErrorMessage, $81);
    ShowMessage('DirectShow error: ' + ErrorMessage);
  end
  else
  begin
{$IFDEF DSBUFFER}
    DsBufferIndex := Low(DsBuffer);
{$ENDIF}
    ShowAudioVideo := True;
    DsFunctional := True;
    if (DsOptions and CDirectShowMethodAlternative) <> 0 then
      DvbDirectShow2.DirectShowResize
    else
      DvbDirectShow.DirectShowGraph.DirectShowResize;
    DirectShowFiltersAddToMenu;
  end;
  chkDirectShow.Checked := ShowAudioVideo;
  PidVideo := $FFFF;
  DsAPid := $FFFF;
  DsVPid := $FFFF;
  Caption := OrgText;
  UpdateSettings(nil);
end;

procedure TfrmMain.SetProcessDelayToMsClick(Sender: TObject);
begin
  if Assigned(PacketThread) then
  begin
    PacketThread.FFileStreamDelay := (Sender as TMenuItem).Tag;
    (Sender as TMenuItem).Checked := True;
  end;
end;

procedure TfrmMain.tmrStateMachineKeysTimer(Sender: TObject);
begin
  case FStateMachineKeys of
    -1: tmrStateMachineKeys.Enabled := False;
    10:
      begin
        FStateMachineKeys := -1;
        if not TransponderDisplay then
        begin
          if KeyData = 0 then
            KeyData := 1;
          if KeyData > cmbFavourites.Items.Count then
            KeyData := cmbFavourites.Items.Count;
          cmbFavourites.ItemIndex := KeyData - 1;
        end
        else
        begin
          if KeyData = 0 then
            KeyData := 1;
          if KeyData > cmbTransponders.Items.Count then
            KeyData := cmbTransponders.Items.Count;
          cmbTransponders.ItemIndex := KeyData - 1;
        end;
        SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessageSettings),
          0);
      end
  else
    Inc(FStateMachineKeys);
  end;
end;

function TfrmMain.HandleKeys(Sender: TObject; Key: Word; Accepted: Boolean):
  Boolean;
var
  UseAnyway: Boolean;
begin
  Result := False;
  UseAnyway := False;
  // Depending on what kind of control we intercept or not
  if not FFullScreenMode then
  begin
    if ActiveControl is TDateTimePicker then
      Exit;
    if ActiveControl is TSpinEdit then
      Exit;
    if ActiveControl is TEdit then
      Exit;
    if ActiveControl is TMaskEdit then
      Exit;
    if ActiveControl = cmbTransponders then
      UseAnyway := True;
    if ActiveControl = cmbLists then
      UseAnyway := True;
    if ActiveControl = cmbFavourites then
      UseAnyway := True;
    if ActiveControl = cmbTransponders then
      UseAnyway := True;
    if ActiveControl is TComboBox and not UseAnyway then
      Exit;
  end;
  Result := True;
  case Key of
    Ord('0')..Ord('9'):
      if Accepted then
      begin
        if (FStateMachineKeys = -1) then
        begin
          PrevKeyData := KeyData;
          KeyData := 0;
        end;
        if KeyData > 1000 then
          KeyData := 0;
        KeyData := (KeyData * 10) + (Ord(Key) - Ord('0'));
        FStateMachineKeys := 0;
        if not tmrStateMachineKeys.Enabled then
        begin
          tmrStateMachineKeys.Interval := TimeoutNumericalKeys;
          tmrStateMachineKeys.Enabled := True;
        end;
      end;
    VK_SPACE: if (ActiveControl is TCheckBox) or
      (ActiveControl is TButton) then
      begin
        Result := False;
        Exit;
      end
      else if Accepted then
      begin
        if not TransponderDisplay then
          cmbFavourites.ItemIndex := FavouriteOld
        else
          cmbTransponders.ItemIndex := TransponderOld;
        SendMessage(frmMain.Handle, WM_REMOTE, Integer(CRemoteMessageSettings),
          0);
      end;
    Ord('l'),
      Ord('L'): if Accepted then
        imgLeft.OnClick(Sender);
    Ord('r'),
      Ord('R'): if Accepted then
        imgRight.OnClick(nil);
    Ord('d'),
      Ord('D'): if Accepted then
        imgDown.OnClick(nil);
    Ord('u'),
      Ord('U'): if Accepted then
        imgUp.OnClick(nil);
    Ord('m'),
      Ord('M'): if Accepted then
        Mixer.VolumeMute := not Mixer.VolumeMute;
    Ord('+'): if Accepted then
      begin
        Mixer.VolumeUp;
        Mixer.VolumeMute := False;
      end;
    Ord('-'): if Accepted then
      begin
        Mixer.VolumeDown;
        Mixer.VolumeMute := False;
      end;
    Ord('a'),
      Ord('A'): if Accepted then
      begin
        if cmbAudioPids.ItemIndex < (cmbAudioPids.Items.Count - 1) then
          cmbAudioPids.ItemIndex := cmbAudioPids.ItemIndex + 1
        else
          cmbAudioPids.ItemIndex := 0;
        UpdateSettings(cmbAudioPids);
      end;
    Ord('o'),
      Ord('O'): if Accepted then
        btnDisableEnableClick(nil);
    Ord('s'),
      Ord('S'): if Accepted then
        btnScrambleClick(nil);

    //    VK_RETURN:
    Ord('x'), Ord('X'),
      VK_ESCAPE: if Accepted then
      begin
        // For some reason we can get here multiple time at a key press
        // so suppress those
        if (Now - FullScreenTimeOut) < EncodeTime(0, 0, 0, 250) then
          Exit;
        FullScreenTimeout := Now;
        FullScreenMode(not FFullScreenMode);
      end;
  else
    Result := False;
  end;
end;

procedure TfrmMain.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if HandleKeys(Sender, Key, True) then
    Key := 0;
end;

procedure TfrmMain.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if HandleKeys(Sender, Ord(Key), False) then
    Key := #0;
end;

procedure TfrmMain.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if HandleKeys(Sender, Key, False) then
    Key := 0;
end;

procedure TfrmMain.btnDisableEnableClick(Sender: TObject);
begin
  ProgramOptions := ProgramOptions xor $0001;
  btnAddToFavouritesClick(nil);
  if (ProgramOptions and $0001) = 0 then
    btnDisableEnable.Caption := 'Disable'
  else
    btnDisableEnable.Caption := 'Enable'
end;

procedure TfrmMain.btnScrambleClick(Sender: TObject);
begin
  ProgramOptions := ProgramOptions xor $0002;
  btnAddToFavouritesClick(nil);
  if (ProgramOptions and $0002) = 0 then
    btnScrambled.Caption := 'Scram'
  else
    btnScrambled.Caption := 'Unscr'
end;

procedure TfrmMain.btnAddToFavouritesClick(Sender: TObject);
var
  Name: string;
  Position: Word;
  KeyData: string;
  OldCount: Word;
  ProgName: string;
  OldKey: string;
begin
  // If no list selected then skip it
  if not Assigned(FavouritesIniFile) then
    Exit;
  // If favourites is active then the favourite name is used
  if not TransponderDisplay then
  begin
    Name := Copy(cmbFavourites.Text, 64, 255);
    if Name = '' then
      Exit;
  end
  else
  begin
    // Part of the key is the transponder name
    Name := cmbTransponders.Text;
    // First remove whitespaces
    repeat
      Position := Pos(' ', Name);
      if Position <> 0 then
        Delete(Name, Position, 1);
    until Position = 0;
    // Replace comma's by underscore
    repeat
      Position := Pos(',', Name);
      if Position <> 0 then
        Name[Position] := '_';
    until Position = 0;
    // Part of the name is the program number
    Name := Name + format('_%5.5d', [ServiceNumber]);
  end;
  // The data are the PIDs and the program name
  // Video, Audio, Teletext, PMT, PCR, ECM, program name
  // We only use the current program name if we don't already have a
  // program name
  OldKey := FavouritesIniFile.ReadString('Favourites', Name, '');
  if OldKey <> '' then
  begin
    // We did have an existing key, so use the program name
    // Now get the program name, which follows the last comma
    repeat
      Position := Pos(',', OldKey);
      if Position <> 0 then
        Delete(OldKey, 1, Position);
    until (Position = 0);
    OldKey := Trim(OldKey);
    if OldKey = '' then
      ProgName := ProgramName
    else
      ProgName := OldKey;
  end
  else
    ProgName := ProgramName;
  KeyData := cmbVideoPids.Text + ', ' + cmbAudioPids.Text + ', ' +
    cmbTeletextPids.Text + ', ' + mskPmt.EditText + ', ' +
    mskPcr.EditText + ', ' + cmbEcmPids.Text + ', ' +
    cmbSubtitlePids.Text + ', ' + format('%d', [ProgramOptions]) + ', ' +
    ProgName;
  // The key is the program number
  FavouritesIniFile.WriteString('Favourites', Name, KeyData);
  FavouritesIniFile.UpdateFile;
  // Only do the update if not manually called
  if Sender <> nil then
  begin
    // Now re-read the favourites list otherwise the indexes might be incorrect
    OldCount := cmbFavourites.Items.Count;
    ReadFavourites;
    // Take new item into account
    if cmbFavourites.Items.Count <> OldCount then
      cmbFavourites.ItemIndex := cmbFavourites.Items.Count - 1;
  end;
end;

procedure TfrmMain.Scan;
var
  Programs: Word;
  Loop: Word;
  StartTime: Dword;
  TotalTime: Dword;
  OrgScanning: Boolean;
begin
  OrgScanning := Scanning;
  Scanning := True;
  Programs := DvbGetNumberOfPrograms;
  StartTime := GetTickCount;
  if Programs <> 0 then
  begin
    Caption := Caption + format(' - %d programs detected - ', [Programs]);
    for Loop := 0 to Programs - 1 do
    begin
      cmbServices.ItemIndex := Loop;
      Caption := Caption + '.';
      UpdateSettings(nil);
      // Next is to make sure prefered language is used
      ProgramChanged(False);
      if (cmbVideoPids.Text <> '') or (cmbAudioPids.Text <> '') then
      begin
        if Abs(GetTickCount - StartTime) < 5000 then
        begin
          // Check if valid program name. If not try again.
          if ProgramName = '' then
            repeat
              // Make sure the program index is still correct
              cmbServices.ItemIndex := Loop;
              ProgramChanged(False);
              TotalTime := Abs(GetTickCount - StartTime);
            until (ProgramName <> '') or (TotalTime > 5000);
        end;
        if (cmbVideoPids.Text <> '') or (cmbAudioPids.Text <> '') then
          btnAddToFavouritesClick(nil);
      end;
    end;
  end;
  Scanning := OrgScanning;
end;

{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
                      If <Sender> is the 'Scan' button then only the current
                      transponder is scanned
  Returns : -

  Descript: Scan all transponders (or a single one)
  Notes   : The Tag is used to detect pressing 'STOP'
 ------------------------------------------------------------------------------}

procedure TfrmMain.btnScanAllClick(Sender: TObject);
var
  Loop: Word;
  PmtCount: Word;
  NetCount: Word;
  Waiting: Word;
  Single: Boolean;
  LockState: Byte;
  Failed: Integer;
  StartTime: Integer;
  Timing: Integer;
begin
  // By default a full scan
  Single := False;
  if cmbTransponders.Items.Count = 0 then
    Exit;
  if btnScanAll.Tag = 0 then
    btnScanAll.Tag := 1
  else
    btnScanAll.Tag := 0;
  if btnScanAll.Tag = 0 then
    Exit;
  if Sender = btnScan then
    Single := True;

  pnlSettings.Visible := False;
  btnAddToFavourites.Visible := False;
  btnDisableEnable.Visible := False;
  btnScrambleScan.Visible := False;
  btnScrambled.Visible := False;
  btnDeleteFavourite.Visible := False;
  ProgramOptions := $0000;
  ProgramName := '';

  Scanning := True;
  btnScan.Visible := False;
  btnScanAll.Caption := 'STOP';
  btnScanAll.Refresh;
  FRichView.Clear;
  FRichView.Refresh;
  Refresh;
  cmbServices.ItemIndex := 0;
  Loop := 0;
  Failed := 0;
  StartTime := GetTickCount;
  // Make sure we get at least a first update of the PMT (V0.064 moved)
  NewTransponderSet := True;
  UpdateSettings(nil);
  repeat
    PmtCount := UpdatePmtCount;
    if not Single then
    begin
      Timing := Abs(Integer(GetTickCount) - StartTime);
      Timing := Timing div 1000;
      cmbTransponders.ItemIndex := Loop;
      Caption := AppName +
        format('Scanning all transponders, %2.2d%% completed after %d seconds [%d failed]', [(Loop * 100)
        div cmbTransponders.Items.Count, Timing, Failed]);
    end
    else
      Caption := AppName + 'Scanning current transponder';
    Application.ProcessMessages; // V0.0063 added
    UpdateSettings(nil);
    // Check for lock
    Waiting := 0;
    repeat
      Sleep(10);
      Inc(Waiting);
      if UseFlexCop then
        FlexCopReadFromQpsk(CardHandle, CStv0299bVStatus, LockState)
      else
        Saa7146aReadFromQpsk(CardHandle, CStv0299bVStatus, LockState);
    until (Waiting > 100) or ((LockState and $98) = $98);
    if ((LockState and $98) = $98) then
    begin
      Waiting := 0;
      repeat
        Application.ProcessMessages;
        Sleep(10);
        Inc(Waiting);
      until (btnScanAll.Tag = 0) or (PmtCount <> UpdatePmtCount) or (Waiting >
        50);
      Waiting := 0;
      repeat
        Application.ProcessMessages;
        Sleep(10);
        Inc(Waiting);
      until (btnScanAll.Tag = 0) or (DvbGetNumberOfPrograms <> 0) or (Waiting >
        50);
      // Wait for information update(s)
      NetCount := UpdateProgramCount;
      Waiting := 0;
      repeat
        Application.ProcessMessages;
        Sleep(10);
        Inc(Waiting);
      until (btnScanAll.Tag = 0) or (NetCount <> UpdateProgramCount) or (Waiting
        > 150);
      // Wait for another update (the previous might be incomplete)
      if Waiting <= 150 then
      begin
        NetCount := UpdateProgramCount;
        Waiting := 0;
        repeat
          Application.ProcessMessages;
          Sleep(10);
          Inc(Waiting);
        until (btnScanAll.Tag = 0) or (NetCount <> UpdateProgramCount) or
          (Waiting > 150);
      end;
      if not (btnScanAll.Tag = 0) then
        Scan;
    end
    else
      Inc(Failed);
    Inc(Loop);
  until (btnScanAll.Tag = 0) or (Loop = cmbTransponders.Items.Count) or Single;
  Timing := Abs(Integer(GetTickCount) - StartTime);
  Timing := Timing div 1000;
  Caption := AppName + format('Scanning done in %d seconds [%d failed]',
    [Timing, Failed]);
  ReadFavourites;
  // Take new item into account
  cmbFavourites.ItemIndex := 0;
  // Dont' update, otherwise caption message disappears!
  //   NewTransponderSet := True;
  //   UpdateSettings(nil);

  btnScan.Visible := True;
  pnlSettings.Visible := True;
  btnAddToFavourites.Visible := True;
  btnDisableEnable.Visible := True;
  btnScrambleScan.Visible := True;
  btnScrambled.Visible := True;
  btnDeleteFavourite.Visible := True;

  btnScanAll.Caption := 'Scan all';
  btnScanAll.Tag := 0;
  Scanning := False;
end;

{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Scan all favourites for scrambled status (V0.0064 added)
  Notes   : The Tag is used to detect pressing 'STOP'
 ------------------------------------------------------------------------------}

procedure TfrmMain.btnScrambleScanClick(Sender: TObject);
var
  Loop: Word;
  Waiting: Integer;
  //  OrgIndex: Integer;
  StartTime: Integer;
  Timing: Integer;
  Scrambled: Integer;
  Unscrambled: Integer;
begin
  if cmbFavourites.Items.Count = 0 then
    Exit;
  if btnScrambleScan.Tag = 0 then
    btnScrambleScan.Tag := 1
  else
    btnScrambleScan.Tag := 0;
  if btnScrambleScan.Tag = 0 then
    Exit;

  pnlSettings.Visible := False;
  btnScanAll.Visible := False;
  btnScan.Visible := False;
  btnAddToFavourites.Visible := False;
  btnDisableEnable.Visible := False;
  btnScrambled.Visible := False;
  btnDeleteFavourite.Visible := False;

  StartTime := GetTickCount;
  Scrambled := 0;
  Unscrambled := 0;
  //  OrgIndex := cmbFavourites.ItemIndex;
  btnScrambleScan.Caption := 'STOP';
  Loop := cmbFavourites.ItemIndex;
  repeat
    Timing := Abs(Integer(GetTickCount) - StartTime);
    Timing := Timing div 1000;
    cmbFavourites.ItemIndex := Loop;
    UpdateSettings(nil);
    // Update AFTER settings
    Caption := AppName +
      format('Scanning favourite list, %2.2d%% of full list after %d seconds [%d unscrambled, %d scrambled]', [(Loop * 100)
      div cmbFavourites.Items.Count, Timing, Unscrambled, Scrambled]);
    // Wait for a fixed time (to get scrambled status updated and for tuning)
    Waiting := GetTickCount;
    repeat
      Application.ProcessMessages;
    until (Abs(Integer(GetTickCount) - Waiting) > 4000);
    if VideoScrambled or AudioScrambled then
    begin
      if (VideoScrambled and not VideoIsDescrambled) or
        (AudioScrambled and not AudioIsDescrambled) then
      begin
        ProgramOptions := ProgramOptions or $0002;
        Inc(Scrambled);
      end
      else
      begin
        ProgramOptions := ProgramOptions and (not $0002);
        Inc(Unscrambled);
      end;
    end
    else
    begin
      ProgramOptions := ProgramOptions and (not $0002);
      Inc(Unscrambled);
    end;
    btnAddToFavouritesClick(nil);
    Inc(Loop);
  until (btnScrambleScan.Tag = 0) or (Loop = cmbFavourites.Items.Count);
  Timing := Abs(Integer(GetTickCount) - StartTime);
  Timing := Timing div 1000;
  Caption := AppName + format('Scanning favourite list done in %d seconds',
    [Timing]);

  //  cmbFavourites.ItemIndex := OrgIndex;
  UpdateSettings(nil);

  btnScanAll.Visible := True;
  btnScan.Visible := True;
  pnlSettings.Visible := True;
  btnAddToFavourites.Visible := True;
  btnDisableEnable.Visible := True;
  btnScrambled.Visible := True;
  btnDeleteFavourite.Visible := True;

  btnScrambleScan.Caption := 'ScrScan';
  btnScrambleScan.Tag := 0;
end;

procedure TfrmMain.ReadFavourites;
var
  Loop: Word;
  Parameters: string;
  Error: Integer;
  Video: Word;
  Audio: Word;
  Teletext: Word;
  Pmt: Word;
  Pcr: Word;
  Ecm: Word;
  Subtitle: Word;
  Options: Word;
  Name: string;
  Valid: Boolean;
  TempList: TStringList;
  Index: Integer;
  AudioIsAc3: Boolean;
  TheFile: ShortString;
begin
  ToLog('ReadFavourites', $5);
  // Save current state of favourites
  if Assigned(FavouritesIniFile) and (FavouritesIniFile <>
    TransponderListIniFile) then
  begin
    FavouritesIniFile.WriteString('Settings', 'LastUsed', format('%d',
      [cmbFavourites.ItemIndex]));
    FavouritesIniFile.UpdateFile;
    FreeAndNil(FavouritesIniFile);
  end;
  if cmbLists.Text = '' then
    Exit;
  // First in list is reserved for 'transponder' selection
  // We use the at startup create target file for this so we can still scan when we
  // select the transponder list
  if cmbLists.ItemIndex < 1 then
  begin
    FavouritesIniFile := TransponderListIniFile;
    Exit;
  end;
  // Select the selected favourite file from the list
  // Make it relative from application directory if possible
  TheFile := Copy(cmbLists.Text, 64, 255);
  if Pos('\', TheFile) = 0 then
    TheFile := ExeDirectory + TheFile;
  FavouritesIniFile := TFastIniFile.Create(TheFile);
  //  pnlSettings.Visible := False;
  //  btnAddToFavourites.Visible := False;
  //  btnDisableEnable.Visible   := False;
  //  btnDeleteFavourite.Visible := False;
  //  Refresh;
  cmbFavourites.Clear;
  TempList := TStringList.Create;
  try
    FavouritesIniFile.ReadSection('Favourites', TempList);
    if TempList.Count > 0 then
      for Loop := 0 to TempList.Count - 1 do
      begin
        Parameters := FavouritesIniFile.ReadString('Favourites', TempList[Loop],
          '0000, 0000, 0000, 0000, 0000, 0000, 0000, Program name');
        // Since we need some basic information process the line
        if ProcessProgramLine(Parameters, Video, Audio, Teletext, Pmt, Pcr, Ecm,
          Subtitle, Options, Name, AudioIsAc3) then
        begin
          // Since we might have only TV or radio strip out unwanted channels
          Valid := False;
          if mnuTv.Checked then
          begin
            if (Video <> 0) and (Audio <> 0) then
              Valid := True;
          end;
          if mnuRadio.Checked then
          begin
            if (Video = 0) and (Audio <> 0) then
              Valid := True;
          end;
          if mnuData.Checked then
          begin
            if (Video = 0) and (Audio = 0) then
              Valid := True;
          end;
          if not mnuScrambled.Checked then
          begin
            if (Options and $0002) <> 0 then
              Valid := False;
          end;
          if not mnuDisabled.Checked then
          begin
            if (Options and $0001) <> 0 then
              Valid := False;
          end;
          if Valid then
          begin
            if Name = '' then
              Name := format('#%3.3d', [Loop + 1]);
            // First 64 characters for displayed name, then the identifier
            while Length(Name) < (63 - 7) do
              Name := Name + ' ';
            Name := Name + TempList[Loop];
            cmbFavourites.Items.Add(format('%4.4d - %s',
              [cmbFavourites.Items.Count + 1, Name]));
          end;
        end;
      end;
  finally
    TempList.Free;
  end;
  //  btnAddToFavourites.Visible := True;
  //  btnDisableEnable.Visible   := True;
  //  btnDeleteFavourite.Visible := True;
  //  pnlSettings.Visible := True;

    // Read last used index of the favourite file
  Index := 0;
  Error := -1;
  if ParameterProgram <> '' then
  begin
    // Command line parameter overrules. Internally we are 0-based but
    // the parameter itself starts at 1
    Val(ParameterProgram, Index, Error);
    if (Error = 0) and (Index > 0) then
      Index := Index - 1;
    // Only allow parameter to overrule very first time
    ParameterProgram := '';
  end;
  // If some error or no parameter
  if Error <> 0 then
  begin
    Parameters := FavouritesIniFile.ReadString('Settings', 'LastUsed', '0');
    Val(Parameters, Index, Error);
  end;
  Favourite := -1; // Make sure updated
  if Index < cmbFavourites.Items.Count then
    cmbFavourites.ItemIndex := Index;
  if cmbFavourites.ItemIndex >= cmbFavourites.Items.Count then
    cmbFavourites.ItemIndex := cmbFavourites.Items.Count - 1;
  // A value of -1 is set if no valid index was present ..
  if cmbFavourites.ItemIndex < 0 then
    cmbFavourites.ItemIndex := cmbFavourites.Items.Count - 1;
end;

{------------------------------------------------------------------------------
  Params  : ...
  Returns : <Result>  True if no error

  Descript: Extract information from program line
 ------------------------------------------------------------------------------}

function TfrmMain.ProcessProgramLine(ProcessLine: string;
  var Video: Word; var Audio: Word;
  var Teletext: Word; var Pmt: Word;
  var Pcr: Word; var Ecm: Word;
  var Subtitle: Word; var Options: Word;
  var Name: string;
  var AudioIsAc3: Boolean): Boolean;
var
  Position: Integer;
  Error: Integer;
  Parameters: string;
  Part: string;
  Count: Integer;
  Commas: Integer;
begin
  Result := False;
  Video := 0;
  Audio := 0;
  Teletext := 0;
  Pmt := 0;
  Pcr := 0;
  Ecm := 0;
  Subtitle := 0;
  Options := 0;
  Name := '';
  AudioIsAc3 := False;
  Parameters := ProcessLine;
  Part := Parameters;
  Commas := 0;
  repeat
    Position := Pos(',', Part);
    if Position > 0 then
    begin
      Delete(Part, 1, Position);
      Inc(Commas);
    end
    else
      Part := '';
  until Part = '';
  Count := 0;
  repeat
    Position := Pos(',', Parameters);
    if Position > 0 then
      Part := Copy(Parameters, 1, Position - 1)
    else
      Part := Parameters;
    Delete(Parameters, 1, Position);
    Parameters := Trim(Parameters);
    Part := Trim(Part);
    // Last part is program name
    if Count = Commas then
      Name := Part
    else
    begin
      if Part = '' then
        Part := '0';
      case Count of
        0:
          begin
            Val(Part, Video, Error);
            if Error <> 0 then
              Exit;
          end;
        1:
          begin
            Val(Part, Audio, Error);
            if Error <> 0 then
            begin
              if Pos('*', Part) <> 0 then
              begin
                Val(Copy(Part, 1, Pos('*', Part) - 1), Audio, Error);
                if Error = 0 then
                  AudioIsAc3 := True;
              end;
              if Error <> 0 then
                Exit;
            end;
          end;
        2:
          begin
            Val(Part, Teletext, Error);
            if Error <> 0 then
              Exit;
          end;
        3:
          begin
            Val(Part, Pmt, Error);
            if Error <> 0 then
              Exit;
          end;
        4:
          begin
            Val(Part, Pcr, Error);
            if Error <> 0 then
              Exit;
          end;
        5:
          begin
            Val(Part, Ecm, Error);
            if Error <> 0 then
              Exit;
          end;
        6:
          begin
            Val(Part, Subtitle, Error);
            if Error <> 0 then
              Exit;
          end;
        7:
          begin
            Val(Part, Options, Error);
            if Error <> 0 then
              Exit;
          end;
      else
        ;
      end;
    end;
    Inc(Count);
  until (Position = 0);
  Result := True;
end;

{------------------------------------------------------------------------------
  Params  : <SatelliteNumber>  Number of satellite to put transponder info into
            <StringToAdd>      String to add
                               Frequency, Polarity, Symbolrate
  Returns : -

  Descript: Add string to transponder (if checks out correctly).
  Notes   : Also takes TV/Radio/data nto account
 ------------------------------------------------------------------------------}

function TfrmMain.AddStringToTransponderList(SatelliteNumber: Integer;
  StringToAdd: string): Boolean;
var
  ProcessError: Boolean;
  ProcessLine: string;
  Part: string;
  ScannedLine: string;
  Error: Integer;
  Value: Integer;
  Position: Integer;
  Count: Integer;
begin
  ProcessError := False;
  ProcessLine := StringToAdd;
  // First remove any comments from line
  Position := Pos(';', ProcessLine);
  if Position <> 0 then
    Delete(ProcessLine, Position, 255);
  ProcessLine := Trim(ProcessLine);
  Count := 0;
  // Initial 'result'
  ScannedLine := format('%d', [SatelliteNumber]);
  repeat
    Position := Pos(',', ProcessLine);
    if Position <> 0 then
    begin
      Part := Copy(ProcessLine, 1, Position - 1);
      Delete(ProcessLine, 1, Position);
    end
    else
    begin
      Part := ProcessLine;
      ProcessLine := '';
    end;
    // Empty entry is error
    if Part = '' then
      ProcessError := True
    else
    begin
      Part := Trim(Part);
      Part := UpperCase(Part);
      // Some basic checks
      case Count of
        0:
          begin
            // Frequency - must be numerical
            Val(Part, Value, Error);
            if Error <> 0 then
              ProcessError := True
            else
              Error := Value; // Make compiler happy
          end;
        1:
          begin
            // Polarity, must be starting with 'V'/'H'
            if (Part[1] <> 'H') and (Part[1] <> 'V') then
              ProcessError := True;
          end;
        2:
          begin
            // Symbolrate - must be numerical
            Val(Part, Value, Error);
            if Error <> 0 then
              ProcessError := True
            else
              Error := Value; // Make compiler happy
          end;
      end;
      ScannedLine := ScannedLine + ', ' + Part;
      Inc(Count);
    end;
  until (ProcessError) or (Count = 3);
  if not ProcessError then
    cmbTransponders.Items.Add(ScannedLine);
  Result := not ProcessError;
end;

{------------------------------------------------------------------------------
  Params  : <SatelliteNumber>  Number of satellite to put transponder info into
            <ProcessFile>      File to process
  Returns : -

  Descript: Read all transponders (recursively!)
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.ProcessTransponderFile(SatelliteNumber: Integer; ProcessFile:
  string);
var
  SourceFile: TFastIniFile;
  SourceList: TStrings;
  ProcessLine: string;
  Part: string;
  Position: Integer;
  Loop: Integer;
  Value: Integer;
  Error: Integer;
  ProcessError: Boolean;
  NextFile: string;
begin
  SourceFile := TFastIniFile.Create(ProcessFile);
  try
    SourceList := TStringList.Create;
    try
      // Basic layout of a line is
      //     Sat,  Freq, Pol, Symbolrate
      //      1 , 10877,   V, 22000         -> transponder included (sets satellite to '1')
      // or
      //      Freq, Pol, Symbolrate
      //     10877,   V, 22000              -> transponder included (current satellite)
      // or
      //     Sat, File
      //      1 , 0030.INI                  -> file included (sets satellite to '1')
      //                                    -> satellite is increased after file 'inclusion'
      // or
      //     File
      //     0030.INI                       -> file included (current satellite)
      //                                    -> satellite is increased after file 'inclusion'
      //
      // When a (INI) file is included we first have to look for a [DVB] section
      // If a [DVB] section exists then the format is:
      //     Index=  Freq, Pol, Symbolrate, FEC
      //         1= 12509,   V,       6284, 78
      //
      // First check for a [DVB] section
      SourceFile.ReadSectionValues('DVB', SourceList);
      if SourceList.Count > 0 then
      begin
        // We are dealing with an INI file type
        //     Index=  Freq, Pol, Symbolrate, FEC
        //         1= 12509,   V,       6284, 78
        for Loop := 0 to SourceList.Count - 1 do
        begin
          // Strip out excessive material
          ProcessLine := SourceList.Strings[Loop];
          Position := Pos('=', ProcessLine);
          if Position <> 0 then
            Delete(ProcessLine, 1, Position);
          AddStringToTransponderList(SatelliteNumber, ProcessLine);
        end;
      end
      else
      begin
        // Not an 'INI' file. Possible line layouts are
        //     Sat,  Freq, Pol, Symbolrate
        //      1 , 10877,   V, 22000         -> transponder included (sets satellite to '1')
        // or
        //      Freq, Pol, Symbolrate
        //     10877,   V, 22000              -> transponder included (current satellite)
        // or
        //     Sat, File
        //      1 , 0030.INI                  -> file included (sets satellite to '1')
        //                                    -> satellite number is increased after file 'inclusion'
        // or
        //     File
        //     0030.INI                       -> file included (current satellite)
        //                                    -> satellite number is increased after file 'inclusion'
        SourceFile.GetStrings(SourceList);
        if SourceList.Count > 0 then
          for Loop := 0 to SourceList.Count - 1 do
          begin
            ProcessError := False;
            ProcessLine := SourceList.Strings[Loop];
            // First remove any comments from line
            Position := Pos(';', ProcessLine);
            if Position <> 0 then
              Delete(ProcessLine, Position, 255);
            // Check for a comma (possible satellite number)
            Position := Pos(',', ProcessLine);
            if Position <> 0 then
            begin
              // Process possible satellite number
              // Other possibility is Sat, Freq, ..... so we have to check for this too
              Part := Copy(ProcessLine, 1, Position - 1);
              Part := Trim(Part);
              if Part = '' then
                ProcessError := True
              else
              begin
                Val(Part, Value, Error);
                if Error <> 0 then
                  ProcessError := True
                else
                begin
                  // A small number indicates a satellite (otherwise frequency ..)
                  if Value < 256 then
                  begin
                    SatelliteNumber := Value;
                    Delete(ProcessLine, 1, Position);
                  end;
                end;
              end;
            end;
            if not ProcessError then
            begin
              // Now we either have a filename or Freq,Pol,Symbolrate
              ProcessLine := Trim(ProcessLine);
              Position := Pos(',', ProcessLine);
              if Position <> 0 then
              begin
                // Frequency ...
                AddStringToTransponderList(SatelliteNumber, ProcessLine);
              end
              else
              begin
                // Included files always from TRANSPONDERS directory if nothing
                // specific set
                if Pos('\', ProcessLine) <> 0 then
                  NextFile := ProcessLine
                else
                  NextFile := ExeDirectory + 'TRANSPONDERS\' + ProcessLine;
                if FileExists(NextFile) then
                begin
                  ProcessTransponderFile(SatelliteNumber, NextFile);
                  // Always use next satellite (typically included in files itself!)
                  // so will be overwritten in most cases
                  Inc(SatelliteNumber);
                end;
              end;
            end;
          end;
      end;
    finally
      SourceList.Free;
    end;
  finally
    SourceFile.Free;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Read all transponders from initial transponder file (migth have
            references to other transponder files which will be included too).
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.ReadTransponders(TransponderFile: string);
begin
  cmbTransponders.Clear;
  ProcessTransponderFile(1, TransponderFile);
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Read lists of files which contain the favourites
  Notes   : Also reads the transponders
 ------------------------------------------------------------------------------}

procedure TfrmMain.ReadLists;
var
  Loop: Word;
  Parameters: string;
  TransponderFile: string;
  ListStrings: TStringList;
begin
  ToLog('ReadLists', $5);
  FavouritesIniFile := nil;
  cmbLists.Clear;
  ListStrings := TStringList.Create;
  try
    // Transponder list file at very first position
    TransponderFile := GetParameter('Transponder', 'TransponderFile', '');
    TransponderFile := Trim(TransponderFile);
    if TransponderFile = '' then
      Exit;
    Parameters := 'Transponder list';
    while Length(Parameters) < 63 do
      Parameters := Parameters + ' ';
    Parameters := Parameters + TransponderFile;
    cmbLists.Items.Add(Parameters);

    IniFile.ReadSection('FavouriteFiles', ListStrings);
    if ListStrings.Count > 0 then
      for Loop := 0 to ListStrings.Count - 1 do
      begin
        Parameters := GetParameter('FavouriteFiles', ListStrings[Loop],
          'Undefined');
        Parameters := Trim(Parameters);
        while Length(Parameters) < 63 do
          Parameters := Parameters + ' ';
        Parameters := Parameters + ListStrings[Loop];
        cmbLists.Items.Add(Parameters);
      end;
    cmbLists.ItemIndex := 0;
    // Use applications directory if possible
    if (Pos('\', TransponderFile) <> 0) then
      ReadTransponders(TransponderFile)
    else
      ReadTransponders(ExeDirectory + TransponderFile);
  finally
    ListStrings.Free;
  end;
end;

procedure TfrmMain.btnDeleteFavouriteClick(Sender: TObject);
var
  Name: string;
  Position: Word;
begin
  // If no favourite from the list selected then skip it
  if not Assigned(FavouritesIniFile) then
    Exit;
  if cmbFavourites.Items.Count = 0 then
    Exit;
  // Part of the key is the transponder name
  Name := cmbTransponders.Text;
  // First remove whitespaces
  repeat
    Position := Pos(' ', Name);
    if Position <> 0 then
      Delete(Name, Position, 1);
  until Position = 0;
  // Replace comma's by underscore
  repeat
    Position := Pos(',', Name);
    if Position <> 0 then
      Name[Position] := '_';
  until Position = 0;
  // Part of the name is the service number
  Name := Name + '_' + cmbServices.Text;
  FavouritesIniFile.DeleteKey('Favourites', Name);
  FavouritesIniFile.UpdateFile;
  // Now re-read the favourites list otherwise the indexes might be incorrect
  ReadFavourites;
  if cmbFavourites.Items.Count = 0 then
    Exit;
  UpdateSettings(nil);
end;

procedure TfrmMain.chkTransponderDisplayClick(Sender: TObject);
begin
  if not TransponderDisplay then
  begin
    txtTransponder.Caption := 'Program:';
    txtService.Visible := False;
    cmbServices.Visible := False;
    cmbTransponders.Visible := False;
    cmbFavourites.Visible := True;
    btnScanAll.Visible := False;
    btnScan.Visible := False;
  end
  else
  begin
    txtTransponder.Caption := 'Transponder:';
    txtService.Visible := True;
    cmbServices.Visible := True;
    cmbFavourites.Visible := False;
    cmbTransponders.Visible := True;
    btnScanAll.Visible := True;
    btnScan.Visible := True;
  end;
end;

procedure TfrmMain.btnUpdateClick(Sender: TObject);
begin
  // Do not handle while recording
  if Recording = rtRecording then
    Exit;
  ProgramChanged(True);
end;

procedure TfrmMain.imgEnterClick(Sender: TObject);
begin
  // For some reason we can get here multiple time at a key press
  // so suppress those
  if (Now - FullScreenTimeOut) < EncodeTime(0, 0, 0, 250) then
    Exit;
  FullScreenTimeout := Now;
  FullScreenMode(not FFullScreenMode);
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Update favourite list changed items.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.ListChanged;
begin
  ToLog('ListChanged', $5);
  ReadFavourites;
  chkTransponderDisplayClick(nil);
  if cmbLists.ItemIndex > 0 then
  begin
    btnAddToFavourites.Visible := True;
    btnDisableEnable.Visible := True;
    btnScrambled.Visible := True;
    btnScrambleScan.Visible := True;
    btnDeleteFavourite.Visible := True;
  end
  else
  begin
    btnAddToFavourites.Visible := False;
    btnDisableEnable.Visible := False;
    btnScrambled.Visible := False;
    btnScrambleScan.Visible := False;
    btnDeleteFavourite.Visible := False;
  end;
end;

{------------------------------------------------------------------------------
  Params  : <ServiceToSyncWith>  Service number to synchronize with
  Returns : -

  Descript: Synchronize service number
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.SyncService(ServiceToSyncWith: Word);
var
  Found: Boolean;
  Loop: Integer;
  Error: Integer;
  Service: Integer;
begin
  // Try finding service identifier in list. If it is not in the list add it to the list
  // so it can still be used (might be obsolete because services are not displayed
  // when favourites are used)
  Found := False;
  Loop := 0;
  if cmbServices.Items.Count > 0 then
    repeat
      Val(cmbServices.Items[Loop], Service, Error);
      if Service = ServiceToSyncWith then
        Found := True;
      if not Found then
        Inc(Loop);
    until (Loop >= cmbServices.Items.Count) or Found;
  if Found then
    cmbServices.ItemIndex := Loop
  else
  begin
    cmbServices.Items.Add(format('%5.5d', [ServiceToSyncWith]));
    cmbServices.ItemIndex := cmbServices.Items.Count - 1;
  end;
end;

{------------------------------------------------------------------------------
  Params  : <FavouriteToSyncWith>  Favourite to synchronize with
  Returns : -

  Descript: Synchronize service number to favourite
  Notes   :
 ------------------------------------------------------------------------------}
(*procedure TfrmMain.SyncServiceToFavourite(FavouriteToSyncWith: string);
var
  ServiceName: string;
  Error      : Integer;
  Service    : Word;
begin
  ServiceName := Copy(FavouriteToSyncWith, Length(FavouriteToSyncWith)-4, 255);
  Val(ServiceName, Service, Error);
  if Error <> 0 then
    SyncService(Service);
end;
*)

{------------------------------------------------------------------------------
  Params  : <ServiceToSyncWith>  Service to synchronize with
  Returns : -

  Descript: Synchronize favourite with service
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.SyncFavouriteToService(ServiceToSyncWith: Word);
var
  Found: Boolean;
  Loop: Integer;
  Error: Integer;
  ServiceName: string;
  Service: Integer;
begin
  Found := False;
  Loop := 0;
  if cmbFavourites.Items.Count > 0 then
    repeat
      ServiceName := Copy(cmbFavourites.Items[Loop],
        Length(cmbFavourites.Items[Loop]) - 4, 255);
      Val(ServiceName, Service, Error);
      if Error = 0 then
      begin
        if Service = ServiceToSyncWith then
          Found := True;
      end;
      if not Found then
        Inc(Loop);
    until (Loop >= cmbFavourites.Items.Count) or Found;
  if Found then
    cmbFavourites.ItemIndex := Loop;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Update favourite changed items.
  Notes   : We want to be synchronized with the transponder as well, so when we
            switch back to transponder 'view' we have the correct transponder.
 ------------------------------------------------------------------------------}

procedure TfrmMain.FavouriteChanged;
var
  Name: string;
  Position: Word;
  Found: Boolean;
  Count: Byte;
  UseService: string;
  Error: Integer;
  Parameters: string;
  Transponder: Word;
  Video: Word;
  Audio: Word;
  Teletext: Word;
  Pmt: Word;
  Pcr: Word;
  Ecm: Word;
  Subtitle: Word;
  Options: Word;
  Sat: string;
  SatNumber: Word;
  AudioIsAc3: Boolean;
begin
  ToLog('FavouriteChanged', $5);
  // Synchronize with transponder index
  // First create the correct transponder name so we can search for it

  // Part of the key is the transponder name
  Name := Copy(cmbFavourites.Text, 64, 255);
  // Exchange underscore for comma and whitespace
  // Also remove program information and remember service number
  Count := 0;
  UseService := '';
  repeat
    Position := Pos('_', Name);
    if Position <> 0 then
    begin
      Inc(Count);
      if Count > 3 then
      begin
        UseService := Copy(Name, Position + 1, 255);
        Delete(Name, Position, 255);
      end
      else
      begin
        Delete(Name, Position, 1);
        Insert(', ', Name, Position);
      end;
    end;
  until Position = 0;
  Val(UseService, ServiceNumber, Error);
  if Error <> 0 then
    Exit;
  // Now we have the correct name we can search for it
  Transponder := 0;
  Found := False;
  repeat
    if cmbTransponders.Items[Transponder] = Name then
      Found := True;
    if not Found then
      Inc(Transponder);
  until (Transponder >= cmbTransponders.Items.Count) or Found;
  // If we found a transponder set the master index to it
  // If it is not found then add an entry to the list so we
  // are still able to use it
  if Found then
    cmbTransponders.ItemIndex := Transponder
  else
  begin
    // To add our unknown entry we have to extract the satellite
    // number from the rest.
    Position := Pos(',', Name);
    if Position > 1 then
    begin
      Sat := Copy(Name, 0, Position - 1);
      Val(Sat, SatNumber, Error);
      if Error = 0 then
      begin
        Delete(Name, 1, Position);
        Name := Trim(Name);
        AddStringToTransponderList(SatNumber, Name);
        cmbTransponders.ItemIndex := cmbTransponders.Items.Count - 1;
      end;
    end;
  end;
  // Now update the favourite information items
  cmbAudioLanguages.Clear;
  // Get PIDs to use
  // Video, Audio, Teletext, PMT, PCR, ECM
  if cmbLists.ItemIndex > 0 then
    Parameters := FavouritesIniFile.ReadString('Favourites',
      Copy(cmbFavourites.Text, 64, 255),
      '0000, 0000, 0000, 0000, 0000, 0000, Program name')
  else
    Parameters := '0000, 0000, 0000, 0000, 0000, 0000, Program name';
  // Extract info from it
  if ProcessProgramLine(Parameters, Video, Audio, Teletext, Pmt, Pcr, Ecm,
    Subtitle, Options, Name, AudioIsAc3) then
  begin
    Caption := AppName + Name;
    if ServiceNumber <> 0 then
      stbStatus2.Panels[8].Text := format('%s [%d]', [Name, ServiceNumber])
    else
      stbStatus2.Panels[8].Text := Name;
    ProgramName := Name;
    OsdShowInfo;
    OsdTimeOut := 12;
  end;

  ProgramOptions := Options;
  if (ProgramOptions and $0001) = 0 then
    btnDisableEnable.Caption := 'Disable'
  else
    btnDisableEnable.Caption := 'Enable';
  if (ProgramOptions and $0002) = 0 then
    btnScrambled.Caption := 'Scram'
  else
    btnScrambled.Caption := 'Unscr';

  // Try finding service identifier in list
  SyncService(ServiceNumber);

  cmbVideoPids.Clear;
  if Video <> 0 then
  begin
    cmbVideoPids.Items.Add(format('%4.4d', [Video]));
    cmbVideoPids.ItemIndex := 0;
  end;
  cmbAudioPids.Clear;
  if Audio <> 0 then
  begin
    if AudioIsAc3 then
      cmbAudioPids.Items.Add(format('%4.4d*', [Audio]))
    else
      cmbAudioPids.Items.Add(format('%4.4d', [Audio]));
    cmbAudioPids.ItemIndex := 0;
  end;
  cmbTeletextPids.Clear;
  if Teletext <> 0 then
  begin
    cmbTeletextPids.Items.Add(format('%4.4d', [Teletext]));
    cmbTeletextPids.ItemIndex := 0;
  end;
  if Pmt <> 0 then
    mskPmt.EditText := format('%4.4d', [Pmt])
  else
    mskPmt.EditText := '';
  if Pcr <> 0 then
    mskPcr.EditText := format('%4.4d', [Pcr])
  else
    mskPcr.EditText := '';
  cmbEcmPids.Clear;
  if Ecm <> 0 then
  begin
    cmbEcmPids.Items.Add(format('%4.4d', [Ecm]));
    cmbEcmPids.ItemIndex := 0;
  end;
  cmbSubtitlePids.Clear;
  cmbSubtitleLanguages.Clear;
  if SubTitle <> 0 then
  begin
    cmbSubtitlePids.Items.Add(format('%4.4d', [Subtitle]));
    cmbSubtitlePids.ItemIndex := 0;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Update transponder changed items.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.TransponderChanged;
var
  Translate: string;
  Position: Integer;
  PartStr: string;
  Error: Integer;
  DiSEqcData: TDiSEqCData;
  Wait: Word;
  LockState: Byte;
  //  Program82 : TProgram82;
  Command: Byte;
  Sat: Integer;
  Freq: Integer;
  Polarity: Char;
  SymbolRate: Integer;
  MaxWait: Integer;
  LowBand: Boolean;
  IniSetting: string;
  CheckString: string;
  PartString: string;
  Comma: integer;
  HexData: string;
  Index: Integer;
  HexValue: Byte;
  DataLength: Integer;
begin
  ToLog('TransponderChanged', $5);
  try
    // Disable filtering
    FiltersOff := True;
    Translate := cmbTransponders.Text;
    // First part is satellite
    Position := Pos(',', Translate);
    // Get value and set satellite (level 1.0)
    PartStr := Trim(Copy(Translate, 1, Position - 1));
    Delete(Translate, 1, Position);
    Val(PartStr, Sat, Error);
    if Error <> 0 then
      Exit;
    // Second part is frequency
    Position := Pos(',', Translate);
    PartStr := Trim(Copy(Translate, 1, Position - 1));
    Delete(Translate, 1, Position);
    Val(PartStr, Freq, Error);
    if Error <> 0 then
      Exit;
    // Third part is polarity
    Position := Pos(',', Translate);
    PartStr := Trim(Copy(Translate, 1, Position - 1));
    Delete(Translate, 1, Position);
    if PartStr = '' then
      Exit;
    PartStr := LowerCase(PartStr);
    Polarity := PartStr[1];
    if (Polarity <> 'h') and (Polarity <> 'v') then
      Exit;
    // Fourth part is symbolrate
    PartStr := Trim(Translate);
    Delete(Translate, 1, Position);
    Val(PartStr, SymbolRate, Error);
    if Error <> 0 then
      Exit;

    // Now set it
    // First DiSEqC
    stbStatus2.Panels[3].Text := format('%d', [Sat]);
    if not DiSEqCUsePositioner then
    begin
      if DiSEqCMini then
      begin
        // Mini-DiSEqC only
        case Sat of
          1, 3: Command := CDiSEqCBurstA;
          2, 4: Command := CDiSEqCBurstB;
        else
          Command := CDiSEqCBurstA;
        end;
        if UseFlexCop then
          FlexCopDiSEqCCommand(CardHandle, 0, Command, 0, DiSEqCData)
        else
          Saa7146aDiSEqCCommand(CardHandle, 0, Command, 0, DiSEqCData);
      end
      else
      begin
        // The default behaviour is selected. Now first try to find a setting
        // the user wants to use instead.
        if UseFlexCop then
          LowBand := FlexCopUseLowBand(CardHandle, Freq, LNBLofLowBand,
            LNBLofHighBand, TunerType)
        else
          LowBand := Saa7146aUseLowBand(CardHandle, Freq, LNBLofLowBand,
            LNBLofHighBand, TunerType);
        // Construct the identifier for the INI setting
        IniSetting := format('DiSEqCSat%d%s', [Sat, UpperCase(Polarity)]);
        if LowBand then
          IniSetting := IniSetting + 'L'
        else
          IniSetting := IniSetting + 'H';
        CheckString := UpperCase(GetParameter('Hardware', IniSetting, ''));
        if CheckString <> '' then
        begin
          // User defined setting
          // Format is parts separated by comma's. This part is either 'A'/'B'
          // for a burst, or a DiSEqC command sequence
          while CheckString <> '' do
          begin
            Comma := Pos(',', CheckString);
            if Comma = 0 then
            begin
              PartString := CheckString;
              CheckString := '';
            end
            else
            begin
              PartString := Copy(CheckString, 1, Comma - 1);
              Delete(CheckString, 1, Comma);
            end;
            if PartString <> '' then
            begin
              if (PartString = 'A') or
                (PartString = 'B') then
              begin
                // Burst part
                if PartString = 'A' then
                  Command := CDiSEqCBurstA
                else
                  Command := CDiSEqCBurstB;
                if UseFlexCop then
                  FlexCopDiSEqCCommand(CardHandle, 0, Command, 0, DiSEqCData)
                else
                  Saa7146aDiSEqCCommand(CardHandle, 0, Command, 0, DiSEqCData);
              end
              else
              begin
                // DiSEqC part
                DataLength := 0;
                for Index := low(DiSEqCData) to High(DiSEqCData) do
                begin
                  HexData := Copy(PartString, 1, 2);
                  Delete(PartString, 1, 2);
                  if Length(HexData) = 2 then
                  begin
                    HexData := '$' + HexData;
                    Val(HexData, HexValue, Error);
                    if Error <> 0 then
                    begin
                      ToLog('DiSEqCSatXYZ error (not hex value)', $81);
                      Exit;
                    end;
                    DiSEqCData[DataLength] := HexValue;
                    Inc(DataLength);
                  end
                  else if Length(HexData) = 1 then
                  begin
                    ToLog('DiSEqCSatXYZ error (2 bytes per hex value expected)',
                      $81);
                    Exit;
                  end;
                end;
                if PartString <> '' then
                begin
                  ToLog('DiSEqCSatXYZ error (too much hex data)', $81);
                  Exit;
                end;
                if UseFlexCop then
                  FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats,
                    CDiSEqCCommand,
                    DataLength, DiSEqCData)
                else
                  Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats,
                    CDiSEqCCommand,
                    DataLength, DiSEqCData);
              end;
            end;
          end;
        end
        else
        begin
          // Default behaviour
          case Sat of
            1: DiSEqCData[3] := $F0; // 1xxx = SWITCH POS B 0xxx = SWITCH POS A
            2: DiSEqCData[3] := $F4; // x1xx = SAT POS B    x0xx = SAT POS A
            3: DiSEqCData[3] := $F8; // xx1x = H POLARITY   xx0x = V POLARITY
            4: DiSEqCData[3] := $FC; // xxx1 = HIGH FREQ    xxx0 = LOW FREQ
          else
            DiSEqCData[3] := $F0;
          end;
          if Polarity = 'h' then
            DiSEqCData[3] := DiSEqCData[3] or $02;
          if not LowBand then
            DiSEqCData[3] := DiSEqCData[3] or $01;
          DiSEqCData[0] := 0; // Will be written over
          DiSEqCData[1] := $10; // Any LNB/switcher
          DiSEqCData[2] := $38; // Committed sitches (DiSEqc level 1.0)
          case Sat of
            1, 3: Command := CDiSEqCCommand or CDiSEqCBurstA;
            2, 4: Command := CDiSEqCCommand or CDiSEqCBurstB;
          else
            Command := CDiSEqCCommand;
          end;
          if UseFlexCop then
            FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats, Command, 4,
              DiSEqCData)
          else
            Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats, Command, 4,
              DiSEqCData);
        end;
      end;
    end
    else
    begin
      // Positioner command
      DiSEqCData[0] := 0; // Will be written over
      DiSEqCData[1] := $30; // Any positioner
      DiSEqCData[2] := $6B; // Goto position xx
      DiSEqCData[3] := Sat - 1; // Position xx
      if UseFlexCop then
        FlexCopDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
          DiSEqCData)
      else
        Saa7146aDiSEqCCommand(CardHandle, DiSEqCRepeats, CDiSEqCCommand, 4,
          DiSEqCData);
    end;
    // Set frequency (force it if already set)
    SetFrequency(Freq * 1000);
    if Polarity = 'v' then
      SetPolarity(True)
    else
      SetPolarity(False);
    SetSymbolrate(Symbolrate);
    // Wait for lock on transponder (with max timeout)
    if Sat <> Satellite then
      MaxWait := 500
    else
      MaxWait := 50;
    Satellite := Sat;
    Wait := 0;
    repeat
      Sleep(10);
      Inc(Wait);
      if UseFlexCop then
        FlexCopReadFromQpsk(CardHandle, CStv0299bVStatus, LockState)
      else
        Saa7146aReadFromQpsk(CardHandle, CStv0299bVStatus, LockState);
    until (Wait > MaxWait) or ((LockState and $98) = $98);
  finally
    NewTransponderSet := True; // Initiate new PMT
    TransponderHasChanged := $0000;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Update transponder changed items.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.TransponderChangedTuner;
var
  Translate: string;
  Position: Integer;
  PartStr: string;
  Error: Integer;
  Wait: Word;
  LockState: Byte;
  Sat: Integer;
  Freq: Integer;
  Polarity: Char;
  SymbolRate: Integer;
  MaxWait: Integer;
  Loop: Integer;
  DSatellite: ShortString;
  DSlof: Integer;
  DPolarity: Char;
  DLof: Integer;
  DDiSEqC: ShortString;
  SatId: Integer;
  Found: Boolean;
begin
  ToLog('TransponderChangedTuner', $5);
  try
    // Disable filtering
    FiltersOff := True;
    Translate := cmbTransponders.Text;
    // First part is satellite
    Position := Pos(',', Translate);
    // Get value and set satellite (level 1.0)
    PartStr := Trim(Copy(Translate, 1, Position - 1));
    Delete(Translate, 1, Position);
    Val(PartStr, Sat, Error);
    if Error <> 0 then
      Exit;
    // Second part is frequency
    Position := Pos(',', Translate);
    PartStr := Trim(Copy(Translate, 1, Position - 1));
    Delete(Translate, 1, Position);
    Val(PartStr, Freq, Error);
    if Error <> 0 then
      Exit;
    // Third part is polarity
    Position := Pos(',', Translate);
    PartStr := Trim(Copy(Translate, 1, Position - 1));
    Delete(Translate, 1, Position);
    if PartStr = '' then
      Exit;
    PartStr := UpperCase(PartStr);
    Polarity := PartStr[1];
    if (Polarity <> 'H') and (Polarity <> 'V') then
      Exit;
    // Fourth part is symbolrate
    PartStr := Trim(Translate);
    Delete(Translate, 1, Position);
    Val(PartStr, SymbolRate, Error);
    if Error <> 0 then
      Exit;

    // Now set it
    stbStatus2.Panels[3].Text := format('%d', [Sat]);

    // Find satellite 0 definitions in DiSEqCList
    Found := False;
    if DiSEqCList.Count > 0 then
      for Loop := 0 to DiSEqCList.Count - 1 do
      begin
        if ExtractFromDiSEqCSetting(DiSEqCList.Strings[Loop], DSatellite, DSlof,
          DPolarity, DLof, DDiSEqC) then
        begin
          PartStr := DPolarity;
          PartStr := UpperCase(PartStr);
          DPolarity := PartStr[1];
          Val(DSatellite, SatId, Error);
          // Check for matching items
          if (Error = 0) and (SatId = Sat) and (DPolarity = Polarity) then
            if DSlof > Freq then
            begin
              if UseFlexCop then
                FlexCopDiSEqCCommandVdr(CardHandle, DiSEqCList.Strings[Loop])
              else
                Saa7146aDiSEqCCommandVdr(CardHandle, DiSEqCList.Strings[Loop]);
              edtManualDiSEqC.Text := DDiSEqC;
              Found := True;
              stbStatus2.Panels[5].Text := Polarity;
              Break;
            end;
        end;
      end;
    if not Found then
    begin
      ToLog('No corresponding DiSEqC setting found in INI file under [DiSEqC].',
        $81);
      Exit;
    end;
    DiSEqCCurrentLof := DLof;
    Freq := Freq - DiSEqCCurrentLof;

    // Set frequency (force it if already set)
    SetFrequencyTuner(Freq * 1000, DiSEqCCurrentLof * 1000);
    SetSymbolrate(Symbolrate);
    // Wait for lock on transponder (with max timeout)
    if Sat <> Satellite then
      MaxWait := 500
    else
      MaxWait := 50;
    Satellite := Sat;
    Wait := 0;
    repeat
      Sleep(10);
      Inc(Wait);
      if UseFlexCop then
        FlexCopReadFromQpsk(CardHandle, CStv0299bVStatus, LockState)
      else
        Saa7146aReadFromQpsk(CardHandle, CStv0299bVStatus, LockState)
    until (Wait > MaxWait) or ((LockState and $98) = $98);
  finally
    NewTransponderSet := True; // Initiate new PMT
    TransponderHasChanged := $0000;
  end;
end;

{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Issue manual DiSEqC command
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.btnManualSendClick(Sender: TObject);
var
  Success: Boolean;
begin
  if UseFlexCop then
    Success := FlexCopDiSEqCCommandVdr(CardHandle, '0 0 V 0 ' +
      edtManualDiSEqC.Text)
  else
    Success := Saa7146aDiSEqCCommandVdr(CardHandle, '0 0 V 0 ' +
      edtManualDiSEqC.Text);
  if not Success then
  begin
    if edtManualDiSEqC.Color = clRed then
      edtManualDiSEqC.Color := $000000E0
    else
      edtManualDiSEqC.Color := clRed;
  end
  else
  begin
    if edtManualDiSEqC.Color = clWhite then
      edtManualDiSEqC.Color := $00E0E0E0
    else
      edtManualDiSEqC.Color := clWhite;
  end;
end;

procedure TfrmMain.edtManualDiSEqCKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
  begin
    btnManualSendClick(Sender);
    Key := #0;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Send reset commands for DiSEqC.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.ResetDiSEqC;
var
  Loop: Integer;
  Satellite: ShortString;
  Slof: Integer;
  Polarity: Char;
  Lof: Integer;
  DiSEqC: ShortString;
  Sat: Integer;
  Error: Integer;
begin
  ToLog('ResetDiSEqC', $5);
  // Find satellite 0 definitions in DiSEqCList
  if DiSEqCList.Count > 0 then
    for Loop := 0 to DiSEqCList.Count - 1 do
    begin
      if ExtractFromDiSEqCSetting(DiSEqCList.Strings[Loop], Satellite, Slof,
        Polarity, Lof, DiSEqC) then
      begin
        Val(Satellite, Sat, Error);
        if (Error = 0) and (Sat = 0) then
          if UseFlexCop then
            FlexCopDiSEqCCommandVdr(CardHandle, DiSEqCList.Strings[Loop])
          else
            Saa7146aDiSEqCCommandVdr(CardHandle, DiSEqCList.Strings[Loop]);
      end;
    end;
end;

{------------------------------------------------------------------------------
  Params  : <RetainEcmFavourite>   True will try to retain ECM favourite
            <UsePreferredLanguage> True will use preferred language
            <UseCurrentLanguage>   True will use current languages (overrules preferred)
  Returns : -

  Descript: Update program info as received from stream
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.UpdateProgramInfo(RetainEcmFavourite: Boolean;
  UsePreferredlanguage: Boolean; UseCurrentLanguage: Boolean);
var
  NewStr: string;
  Index: Word;
  PidsVideo: TDvbPids;
  PidsAudio: TDvbPids;
  PidsTeletext: TDvbPids;
  PidsSubtitle: TDvbPids;
  AudioLanguages: TDvbLanguages;
  SubtitleLanguages: TDvbLanguages;
  PidsEcm: TDvbPids;
  CasId: TDvbPids;
  FavPid: string;
  MatchList: array[0..31] of Integer;
  CurrentLanguage: string;
  CurrentLanguage2: string;
  Loop: Integer;
  Smallest: Integer;
  SmallestIndex: Integer;
begin
  ToLog('UpdateProgramInfo', $5);
  // Mark current languages
  CurrentLanguage := Trim(LowerCase(cmbAudioLanguages.Text));
  CurrentLanguage2 := Trim(LowerCase(cmbSubtitleLanguages.Text));
  // Retrieve PID information
  if DvbGetProgramInfo($FF, ServiceNumber, PidPmt, PidPcr, PidsVideo, PidsAudio,
    PidsTeletext, PidsSubtitle, AudioLanguages, SubtitleLanguages, PidsEcm,
    CasId,
    ProgramName) then
  begin
    // Since the text may contain special control codes ($80..$9F) we remove them explicitly
    // Other specialties: First character equal to $01..$0F indicates character coding table
    if ProgramName <> '' then
    begin
      NewStr := '';
      if Ord(ProgramName[1]) in [$01..$0F] then
      begin
        Delete(ProgramName, 1, 1);
        // Just to be sure an empty string does not generate an error ...
        if ProgramName = '' then
          ProgramName := #80;
      end;
      for Index := 1 to Length(ProgramName) do
        if not (Ord(ProgramName[Index]) in [$80..$9F]) then
          NewStr := NewStr + ProgramName[Index];
      ProgramName := NewStr;
    end;

    mskPmt.EditText := format('%4.4d', [PidPmt]);
    mskPcr.EditText := format('%4.4d', [PidPcr]);
    Index := 0;
    FavPid := cmbVideoPids.Text;
    cmbVideoPids.Clear;
    while PidsVideo[Index] <> 0 do
    begin
      cmbVideoPids.Items.Add(format('%4.4d', [PidsVideo[Index]]));
      if (cmbLists.ItemIndex > 0) and (FavPid = cmbVideoPids.Items[Index]) then
        cmbVideoPids.ItemIndex := Index;
      Inc(Index);
    end;
    // If nothing selected, select first one
    if cmbVideoPids.ItemIndex < 0 then
      cmbVideoPids.ItemIndex := 0;

    Index := 0;
    FavPid := cmbAudioPids.Text;
    // Remove any reference to AC3 if we are to compare it
    if Pos('*', FavPid) <> 0 then
      Delete(FavPid, Pos('*', FavPid), 1);
    cmbAudioPids.Clear;
    while PidsAudio[Index] <> 0 do
    begin
      cmbAudioPids.Items.Add(format('%4.4d', [PidsAudio[Index]]));
      if (cmbLists.ItemIndex > 0) and (FavPid = cmbAudioPids.Items[Index]) then
        cmbAudioPids.ItemIndex := Index;
      Inc(Index);
    end;
    // If nothing selected, select first one
    if cmbAudioPids.ItemIndex < 0 then
      cmbAudioPids.ItemIndex := 0;

    Index := 0;
    FavPid := cmbTeletextPids.Text;
    cmbTeletextPids.Clear;
    while PidsTeletext[Index] <> 0 do
    begin
      cmbTeletextPids.Items.Add(format('%4.4d', [PidsTeletext[Index]]));
      if (cmbLists.ItemIndex > 0) and (FavPid = cmbTeletextPids.Items[Index])
        then
        cmbTeletextPids.ItemIndex := Index;
      Inc(Index);
    end;
    // If nothing selected, select first one
    if cmbTeletextPids.ItemIndex < 0 then
      cmbTeletextPids.ItemIndex := 0;

    Index := 0;
    FavPid := cmbSubtitlePids.Text;
    cmbSubtitlePids.Clear;
    while PidsSubtitle[Index] <> 0 do
    begin
      cmbSubtitlePids.Items.Add(format('%4.4d', [PidsSubtitle[Index]]));
      if (cmbLists.ItemIndex > 0) and (FavPid = cmbSubtitlePids.Items[Index])
        then
        cmbSubtitlePids.ItemIndex := Index;
      Inc(Index);
    end;
    // If nothing selected, select first one
    if cmbSubtitlePids.ItemIndex < 0 then
      cmbSubtitlePids.ItemIndex := 0;

    Index := 0;
    cmbAudioLanguages.Clear;
    while AudioLanguages[Index] <> '   ' do
    begin
      NewStr := LowerCase(AudioLanguages[Index]);
      if UseCurrentLanguage then
        if (CurrentLanguage = NewStr) then
          cmbAudioPids.ItemIndex := Index;
      MatchList[Index] := Pos(LowerCase(NewStr), PreferredLanguage);
      if NewStr = '***' then
      begin
        NewStr := '(AC3)';
        // Mark as AC3
        cmbAudioPids.Items[Index] := format('%4.4d*', [PidsAudio[Index]]);
      end
      else if NewStr[1] in ['A'..'Z'] then
      begin
        NewStr := NewStr + '(AC3)';
        // Mark as AC3
        cmbAudioPids.Items[Index] := format('%4.4d*', [PidsAudio[Index]]);
      end;
      cmbAudioLanguages.Items.Add(NewStr);
      Inc(Index);
    end;
    if not UseCurrentLanguage then
      if UsePreferredLanguage and (Index > 0) then
      begin
        Smallest := 99;
        SmallestIndex := -1;
        for Loop := 0 to Index - 1 do
        begin
          if (MatchList[Loop] <> 0) and (MatchList[Loop] < Smallest) then
          begin
            SmallestIndex := Loop;
            Smallest := MatchList[Loop];
          end;
        end;
        if SmallestIndex >= 0 then
          cmbAudioPids.ItemIndex := SmallestIndex;
      end;

    Index := 0;
    cmbSubtitleLanguages.Clear;
    while SubtitleLanguages[Index] <> '   ' do
    begin
      cmbSubtitleLanguages.Items.Add(SubtitleLanguages[Index]);
      Inc(Index);
    end;
    cmbSubtitleLanguages.ItemIndex := cmbSubtitlePids.ItemIndex;

    Index := 0;
    FavPid := cmbEcmPids.Text;
    cmbEcmPids.Clear;
    while PidsEcm[Index] <> 0 do
    begin
      cmbEcmPids.Items.Add(format('%4.4d', [PidsEcm[Index]]));
      if RetainEcmFavourite then
        if (cmbLists.ItemIndex > 0) and (FavPid = cmbEcmPids.Items[Index]) then
          cmbEcmPids.ItemIndex := Index;
      Inc(Index);
    end;
    // If nothing selected, select first one
    if cmbEcmPids.ItemIndex < 0 then
      cmbEcmPids.ItemIndex := 0;

    //    if not Scanning then
    //      Caption := AppName + ProgramName;
    stbStatus2.Panels[8].Text := format('%s [%d]', [ProgramName,
      ServiceNumber]);
  end;
end;

{------------------------------------------------------------------------------
  Params  : <UseCurrentSettings>  True will try to keep current selection
  Returns : -

  Descript: Update program changed items.
  Notes   : Takes previous selection into account (typically 'favourite').
 ------------------------------------------------------------------------------}

procedure TfrmMain.ProgramChanged(UseCurrentSettings: Boolean);
begin
  ToLog('ProgramChanged', $5);
  if UseCurrentSettings then
    UpdateProgramInfo(True, False, False)
  else
    UpdateProgramInfo(True, True, False);
  // Update event information
  EventUpdate;
  UpdateEvent := False;
  NewChannelSet := True;
  //  PidChanged;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Update event information.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.EventUpdate;
var
  Events: TDvbEventSections;
  Index: Word;
  Index2: Word;
  StatusStr: string;
  NewStr: string;
  ARecord: PAnsiString;
  EventType: Byte;
  StartTime: TDateTime;
  EndTime: TDateTime;
  Jump: Integer;
  NewLine: Boolean;
  NextLine: Boolean;
  NoTimeInfo: Boolean;
  ManyMinutes: Boolean;
  CurrentEvent: Boolean;
  Hours: Word;
  Minutes: Word;
  Seconds: Word;
  MSec: Word;
begin
  ToLog('EventUpdate', $5);
  // Do nothing with event information while scanning
  if Scanning then
  begin
    TimeStartTime := 0;
    TimeEndTime := 0;
    Exit;
  end;
  if not chkEpg.Visible then
  begin
    TimeStartTime := 0;
    TimeEndTime := 0;
    Exit;
  end;
  CurrentEvent := False;
  Events := TDvbEventSections.Create;
  try
    DvbGetEventInfo($FF, ServiceNumber, chkEPGPresentInfoOnly.Checked, Events);
    FRichView.Clear;
    FRichViewEventStart := nil;
    FRichViewEventEnd := nil;
    Jump := 0;
    if not chkEpg.Checked then
      Exit;
    Index := 0;
    while Events.EventText[Index].Count <> 0 do
    begin
      NoTimeInfo := False;
      if (Index <> 0) and not chkEPGShortNameOnly.Checked then
        FRichView.AddBreak;
      // First part of an event is the time
      ManyMinutes := False;
      if (Events.StartTime[Index] <> 0) and (Events.Duration[Index] <> 0) then
      begin
        DecodeTime(Events.Duration[Index], Hours, Minutes, Seconds, MSec);
        Minutes := Minutes + Hours * 60;
        if TimeCorrectionGmt then
        begin
          StartTime := Events.StartTime[Index] + TimeCorrection -
            TimeCorrectionBias;
          EndTime := Events.StartTime[Index] + TimeCorrection -
            TimeCorrectionBias + Events.Duration[Index];
        end
        else
        begin
          StartTime := Events.StartTime[Index] + TimeCorrection;
          EndTime := Events.StartTime[Index] + TimeCorrection +
            Events.Duration[Index];
        end;
        if (StartTime <= Now) and (EndTime >= Now) then
        begin
          TimeStartTime := StartTime;
          TimeEndTime := EndTime;
          TimeDeltaTime := EndTime - StartTime;
          CurrentEvent := True;
        end;
        SetLength(FRichViewEventStart, Jump + 1);
        SetLength(FRichViewEventEnd, Jump + 1);
        FRichViewEventStart[Jump] := StartTime;
        FRichViewEventEnd[Jump] := EndTime;
        Inc(Jump);
        if DateToStr(StartTime) <> DateToStr(Now) then
        begin
          FRichView.AddFromNewLine(FormatDateTime('YYYY-MM-DD   ', StartTime),
            FRichViewStyle2);
          FRichView.AddText(FormatDateTime('HH":"MM":"SS', StartTime) +
            FormatDateTime(' - HH":"MM":"SS', EndTime) + Format('   [%d min]',
            [Minutes]), rvsJump1);
        end
        else
          FRichView.AddFromNewLine(FormatDateTime('HH":"MM":"SS', StartTime) +
            FormatDateTime(' - HH":"MM":"SS', EndTime) + Format('   [%d min]',
            [Minutes]), rvsJump1);
        if Minutes > 99 then
          ManyMinutes := True;
      end
      else
        NoTimeInfo := True;

      NewLine := False;
      for Index2 := 0 to Events.EventText[Index].Count - 1 do
      begin
        ARecord := Events.EventText[Index].Items[Index2];
        // The first character indicates the type of event
        // eg. CDvbEventTypeUndefined        = $00;
        //     CDvbEventTypeShortName        = $01;
        //     CDvbEventTypeShortText        = $02;
        //     CDvbEventTypeExtendedItemName = $03;
        //     CDvbEventTypeExtendedItemText = $04;
        //     CDvbEventTypeExtendedText     = $05;
        EventType := Ord(ARecord^[1]);
        // Also, the text may contain special control codes ($80..$9F) so we remove them explicitly
        // Other specialties: $01..$0F indicates character coding table
        // First get the string without the type identifier
        StatusStr := Copy(ARecord^, 2, 255);
        if StatusStr <> '' then
        begin
          repeat
            NewStr := '';
            if StatusStr <> '' then
            begin
              repeat
                // Next line checks for invalid codes
                NextLine := False;
                case Ord(StatusStr[1]) of
                  $0A: NextLine := True;
                  $00..$09,
                    $0B..$1F,
                    $80..$9F: ;
                else
                  NewStr := NewStr + StatusStr[1];
                end;
                Delete(StatusStr, 1, 1);
              until (StatusStr = '') or NextLine;
              if NewStr <> '' then
              begin
                case EventType of
                  CDvbEventTypeShortName:
                    begin
                      if NoTimeInfo then
                      begin
                        FRichView.AddFromNewLine(NewStr, FRichViewStyle3);
                      end
                      else
                      begin
                        if ManyMinutes then
                          NewStr := ' -  ' + NewStr
                        else
                          NewStr := '   -  ' + NewStr;
                        FRichView.AddText(NewStr, FRichViewStyle3);
                      end;
                      NewLine := True;
                    end;
                else
                  begin
                    if not chkEPGShortNameOnly.Checked then
                    begin
                      if NewLine then
                        FRichView.AddTextFromNewLine(NewStr, FRichViewStyle4)
                      else
                        FRichView.AddText(NewStr, FRichViewStyle4);
                      NewLine := False;
                      if NextLine then
                        NewLine := True;
                    end;
                  end;
                end;
              end;
            end;
          until StatusStr = '';
        end
        else
          NewLine := True;
      end;
      Inc(Index);
    end;
  finally
    FRichView.Format;
    FRichView.Refresh;
    FreeAndNil(Events);
  end;
  // If no current event reset start/end time indications
  if not CurrentEvent then
  begin
    TimeStartTime := 0;
    TimeEndTime := 0;
  end;
end;

{------------------------------------------------------------------------------
  Params  : <Sender>
            <Id>      Jump identification (= index in FRichViewEventStart/End)
  Returns : -

  Descript: Uses clicked hyperlink
  Notes   : Possibility that event is removed while we are handling it here ..
 ------------------------------------------------------------------------------}

procedure TfrmMain.RichViewJump(Sender: TObject; Id: Integer);
var
  Index: Integer;
  RecordPids: TPidLists;
  ProgName: ShortString;
  Tuning: ShortString;
begin
  if Id > High(FRichViewEventStart) then
    Exit;
  if Id > High(FRichViewEventEnd) then
    Exit;

  // Find first available in list
  Index := Low(RecordItems);
  while (Index <= High(RecordItems)) and RecordItems[Index].Active do
    Inc(Index);
  if Index <= High(RecordItems) then
  begin
    GetRecordingPids(RecordPids);
    RecordItems[Index].Active := True;
    RecordItems[Index].RecordId := $FF;
    RecordItems[Index].Miscellaneous := 0;
    RecordItems[Index].StartTime := FRichViewEventStart[Id] -
      TimeCorrectionPreRecord;
    RecordItems[Index].StopTime := FRichViewEventEnd[Id] +
      TimeCorrectionPostRecord;
    RecordItems[Index].Pids := RecordPids;
    RecordItems[Index].ListIndex := cmbLists.ItemIndex;
    RecordItems[Index].FavouriteIndex := cmbFavourites.ItemIndex;
    Tuning := Copy(cmbFavourites.Items[cmbFavourites.ItemIndex], 64, 255);
    // We have to remove the service identifier from the actual tuning info
    Tuning := Trim(Tuning);
    Delete(Tuning, Length(Tuning) - 5, 255);
    RecordItems[Index].Tuning := Tuning;
    ProgName := Copy(cmbFavourites.Items[cmbFavourites.ItemIndex], 1, 63);
    Delete(ProgName, 1, 6);
    ProgName := Trim(ProgName);
    RecordItems[Index].ProgramName := Progname;
    RemoveDuplicateRecordItems(RecordItems);
    RemoveExpiredRecordItems(RecordItems);
    SortRecordItems(RecordItems);
    if OverlappedRecordings(RecordItems) then
      ShowMessage('Overlapped recordings on different transponders detected');
  end
  else
    ShowMessage('No room for additional recording available');

  //  dtStartRecording.Time := FRichViewEventStart[Id] - TimeCorrectionPreRecord;
  //  chkStartRecording.Checked := True;
  //  dtStopRecording.Time := FRichViewEventEnd[Id] + TimeCorrectionPostRecord;
  //  chkStopRecording.Checked := True;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Update PID changed items.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.PidChanged;
var
  Index: Word;
  APid: Word;
  VPid: Word;
  Program82: TProgram82;
begin
  ToLog('PidChanged', $5);
  if Scanning then
    Exit;
  if (PidVideo = 0) and (PidAudio = 0) then
    Exit;
  try
    UpdateProgram82(@Program82);

    // Here we only activate the ACTIVE PIDS and not the whole program stream PIDS
    // We DONT remove the current indications, since these might include
    // alternative PIDs. If we were to remove all old settings then we basically
    // only send the current active PID for the ECM and such

    // Remove all filters
    for Index := Low(AppFilters.Filters) to High(AppFilters.Filters) do
      AppFilters.Filters[Index].Active := False;

    if Program82.Video_pid <> 0 then
      DVBSetFilter(@AppFilters, Program82.Video_pid, 0, nil, 'Video');
    if Program82.Audio_pid <> 0 then
      DVBSetFilter(@AppFilters, Program82.Audio_pid, 0, nil, 'Audio');
    if Program82.PMT_Pid <> 0 then
      DVBSetFilter(@AppFilters, Program82.PMT_pid, 0, nil, 'PMT');
    if Program82.PCR_Pid <> 0 then
      DVBSetFilter(@AppFilters, Program82.PCR_pid, 0, nil, 'PCR');

    // Note: The occasion hangup when switching is because of some plugins ...
    //       especially when those plugins are (still) receiving 'old' data
    MdApiOnChannelChange(Program82);
    // Enable filtering
    FiltersOff := False;

    // SoftCSA
    OddKeyFound := False;
    EvenKeyFound := False;
    KeyFound := False;

    Overtaken := 0;

    // DirectShow
    VPid := PidVideo;
    APid := PidAudio;
    if not chkVideo.Checked then
      VPid := 0;
    if not chkAudio.Checked then
      APid := 0;

    // Only change if actually changed
    if (APid <> DsAPid) or (VPid <> DsVPid) then
    begin
      if (DsOptions and CDirectShowMethodAlternative) <> 0 then
        DvbDirectShow2.DirectShowMpeg2DemultiplexerSetNewPids(VPid, APid)
      else
        DvbDirectShow.DirectShowGraph.DirectShowMpeg2DemultiplexerSetNewPids(VPid, APid, PidAudioIsAc3);
      DsAPid := APid;
      DsVPid := VPid;
    end;
  finally
  end;
end;

{------------------------------------------------------------------------------
  Params  : <Msg>  WParam: Pointer of object which initiated the message
                           nil if none
  Returns : -

  Descript: Update all settings
  Notes   : This is the generic update procedure. We get here because of a
            list index has changed OR because a new PMT has been received
            (new PIDs).
            The master references (eg. EcmPidIndex) are the indexes which
            indicate which item of the associated lists are to be used. The
            following strategy is used:
            1. Update master index according to <Sender>
            2. Update all indexes according to the master indexes
            3. If 'Favourite' changed (if active)
               . read Favourite info
               . set PIDs
               . restart update
            4. If 'Transponder' changed
               . set new frequency and such
               . exit (we wait for a new PMT which will reinitiate an update)
            5. If program/service changed
               . read PIDs
               . restart update
            6. If new PID
               . set PID info (DirectShow/Plugins)
 ------------------------------------------------------------------------------}

procedure TfrmMain.UpdateSettings(Sender: TObject);
var
  TransponderChange: Boolean;
  TransponderPmtCount: Word;
  Error: Integer;
  Changed: Boolean;
  Wait: Word;
  DeadlockCount: Byte;
  CheckValue: Integer;
begin
  // Do not update anything if recording
  if Recording = rtRecording then
    Exit;
  if UpdateLocked then
  begin
    UpdateAgain := True;
    Exit;
  end;
  ToLog('UpdateSettings', $5);
  UpdateLock.Acquire;
  try
    if Sender = cmbAudioLanguages then
      cmbAudioPids.ItemIndex := cmbAudioLanguages.ItemIndex;
    if Sender = cmbSubtitleLanguages then
      cmbSubtitlePids.ItemIndex := cmbSubtitleLanguages.ItemIndex;
    if Sender = cmbAudioPids then
      cmbAudioLanguages.ItemIndex := cmbAudioPids.ItemIndex;
    if Sender = cmbSubtitlePids then
      cmbSubtitleLanguages.ItemIndex := cmbSubtitlePids.ItemIndex;
    UpdateLocked := True;
    TransponderChange := False;
    TransponderPmtCount := UpdatePmtCount;
    UpdateAgain := True;
    DeadlockCount := 10;
    while UpdateAgain and (DeadlockCount <> 0) do
    begin
      UpdateAgain := False;
      // If new transponder set, wait for PMT update up we use realtime data
      // Also escape when external update is requested (<UpdateAgain>)
      if TransponderChange and AlwaysUpdateProgram then
      begin
        TransponderChange := False;
        Wait := 0;
        repeat
          Sleep(10);
          Inc(Wait);
        until (UpdatePmtCount <> TransponderPmtCount) or (Wait > 200) or
          UpdateAgain;
      end;

      // Synchronize and check for change
      if (not UpdateAgain) and
        (List <> cmbLists.ItemIndex) then
      begin
        List := cmbLists.ItemIndex;
        ListChanged;
        // Force favourite update
        Favourite := $FFFF;
        UpdateAgain := True;
      end;

      // Synchronize and check for change
      if (not UpdateAgain) and
        (Favourite <> cmbFavourites.ItemIndex) then
      begin
        FavouriteOld := Favourite;
        Favourite := cmbFavourites.ItemIndex;
        FavouriteChanged;
        // Force program update
        ServiceNumber := $FFFF;
        UpdateAgain := True;
      end;

      // Synchronize and check for change
      if (not UpdateAgain) and
        (Transponder <> cmbTransponders.ItemIndex) then
      begin
        TransponderOld := Transponder;
        Transponder := cmbTransponders.ItemIndex;
        TransponderPmtCount := UpdatePmtCount; // Record PMT counter
        if DiSEqCList.Count = 0 then
          TransponderChanged
        else
          TransponderChangedTuner;
        if not TransponderDisplay then
          TransponderChange := True;
        // Force program update
        ServiceNumber := $FFFF;
        UpdateAgain := True;
      end;

      // Check for change
      Val(cmbServices.Text, CheckValue, Error);
      if (Error = 0) and
        (not UpdateAgain) and
        (ServiceNumber <> CheckValue) then
      begin
        ServiceNumber := CheckValue;
        // Only update if not 'favourite'
        if TransponderDisplay then
        begin
          SyncFavouriteToService(ServiceNumber);
          // Synchronize with favourite: NOTE -> will generate a 'FavouriteChanged' etc so will use favourite settings ...
          ProgramChanged(True);
        end
        else
        begin
          // Update event information
          if AlwaysUpdateProgram then
            ProgramChanged(True);
          EventUpdate;
          UpdateEvent := False;
        end;
        UpdateAgain := True;
      end;

      if not UpdateAgain then
      begin // Now check if any of the PIDs has changed so we have to inform
        // DirectShow and the plugins
        Changed := False;
        Val(mskPmt.EditText, CheckValue, Error);
        if (Error = 0) and (CheckValue <> PidPmt) then
        begin
          Changed := True;
          PidPmt := CheckValue;
        end;
        Val(mskPcr.EditText, CheckValue, Error);
        if (Error = 0) and (CheckValue <> PidPcr) then
        begin
          Changed := True;
          PidPcr := Checkvalue;
        end;
        Val(cmbVideoPids.Text, CheckValue, Error);
        if (Error = 0) and (CheckValue <> PidVideo) then
        begin
          Changed := True;
          PidVideo := CheckValue;
        end;
        PidAudioIsAc3 := False;
        if Pos('*', cmbAudioPids.Text) <> 0 then
        begin
          // If AC3 audio
          Val(Copy(cmbAudioPids.Text, 1, Pos('*', cmbAudioPids.Text) - 1),
            CheckValue, Error);
          PidAudioIsAc3 := True;
        end
        else
          Val(cmbAudioPids.Text, CheckValue, Error);
        if (Error = 0) and (CheckValue <> PidAudio) then
        begin
          Changed := True;
          PidAudio := CheckValue;
        end;
        Val(cmbEcmPids.Text, CheckValue, Error);
        if (Error = 0) and (CheckValue <> PidEcm) then
        begin
          Changed := True;
          PidEcm := CheckValue;
        end;
        Val(cmbTeletextPids.Text, CheckValue, Error);
        if (Error = 0) and (CheckValue <> PidTeletext) then
        begin
          Changed := True;
          PidTeletext := CheckValue;
        end;
        Val(cmbSubtitlePids.Text, CheckValue, Error);
        if (Error = 0) and (CheckValue <> PidSubtitle) then
        begin
          Changed := True;
          PidSubtitle := CheckValue;
        end;
        if Changed then
        begin
          // Only do a PID change when scanning is off
          if not Scanning then
            PidChanged;
        end;
      end;
      Dec(DeadLockCount);
    end;
  finally
    UpdateLocked := False;
    UpdateLock.Release;
  end;
  WriteSettings;
  if chkAutoECM.Checked and not tmrStateMachineAutoEcm.Enabled then
  begin
    FStateMachineAutoEcm := 0;
    tmrStateMachineAutoEcm.Interval := 100;
    tmrStateMachineAutoEcm.Enabled := True;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>      True if current info could be used
            <PidsRecord>  Array of PIDs

  Descript: Get recording PIDs of current program.
  Notes   : Last item in lists has .Pid=$FFFF
 ------------------------------------------------------------------------------}

function TfrmMain.GetRecordingPids(var PidsRecord: TPidLists): Boolean;
var
  PidsPmt: Word;
  PidsPcr: Word;
  PidsAudio: TDvbPids;
  PidsVideo: TDvbPids;
  PidsTeletext: TDvbPids;
  PidsSubtitle: TDvbPids;
  PidsEcm: TDvbPids;
  Dummy: TDvbPids;
  Language: TDvbLanguages;
  StatusStr: string;
  RecordIndex: Byte;
  Index: Byte;
  EmmCaSystemId: Word;
  EmmCaPid: Word;
begin
  ToLog('GetRecordingPids', $5);
  // Each item (PID) can be individually enabled. Also all PIDs of a specific
  // type can be selected.
  RecordIndex := 0;
  if chkRecordPat.Checked and (not chkRecordMandatory.Checked) then
  begin
    PidsRecord[RecordIndex].Pid := CPidPAT;
    PidsRecord[RecordIndex].PidName := 'pat';
    Inc(RecordIndex);
  end;
  // CAT
  if chkRecordCat.Checked and (not chkRecordMandatory.Checked) then
  begin
    PidsRecord[RecordIndex].Pid := CPidCAT;
    PidsRecord[RecordIndex].PidName := 'cat';
    Inc(RecordIndex);
  end;
  // Mandatory
  if chkRecordMandatory.Checked then
  begin
    PidsRecord[RecordIndex].Pid := CPidPAT;
    PidsRecord[RecordIndex].PidName := 'pat';
    Inc(RecordIndex);
    PidsRecord[RecordIndex].Pid := CPidCAT;
    PidsRecord[RecordIndex].PidName := 'cat';
    Inc(RecordIndex);
    PidsRecord[RecordIndex].Pid := CPidNIT;
    PidsRecord[RecordIndex].PidName := 'nit';
    Inc(RecordIndex);
    PidsRecord[RecordIndex].Pid := CPidSDT;
    PidsRecord[RecordIndex].PidName := 'sdt';
    Inc(RecordIndex);
    PidsRecord[RecordIndex].Pid := CPidEIT;
    PidsRecord[RecordIndex].PidName := 'eit';
    Inc(RecordIndex);
    PidsRecord[RecordIndex].Pid := CPidRST;
    PidsRecord[RecordIndex].PidName := 'rst';
    Inc(RecordIndex);
    PidsRecord[RecordIndex].Pid := CPidTDT;
    PidsRecord[RecordIndex].PidName := 'tdt';
    Inc(RecordIndex);
  end;

  // The EMM is system wide data and is read from the stream
  Index := 0;
  if chkRecordEmm.Checked then
  begin
    while DvbFilterGetEmm(Index, EmmCaSystemId, EmmCaPid) do
    begin
      PidsRecord[RecordIndex].Pid := EmmCaPid;
      PidsRecord[RecordIndex].PidName := format('emm%d', [Index]);
      Inc(RecordIndex);
      Inc(Index);
    end;
  end;

  // Read current information
  if DvbGetProgramInfo($FF, ServiceNumber, PidsPmt, PidsPcr, PidsVideo,
    PidsAudio, PidsTeletext, PidsSubtitle, Language, Language, PidsEcm, Dummy,
    StatusStr) then
  begin
    Index := 0;
    if chkRecordVideo.Checked and chkRecordVideoAll.Checked then
    begin
      while PidsVideo[Index] <> 0 do
      begin
        PidsRecord[RecordIndex].Pid := PidsVideo[Index];
        PidsRecord[RecordIndex].PidName := format('video%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
        DVBSetFilter(@AppFilters, PidsRecord[RecordIndex].Pid, 0, nil, '');
        Inc(RecordIndex);
        Inc(Index);
      end;
    end;
    // Use the default PID if we did not update correctly or did not update at all
    if Index = 0 then
      if chkRecordVideo.Checked and (PidVideo <> 0) then
      begin
        PidsRecord[RecordIndex].Pid := PidVideo;
        PidsRecord[RecordIndex].PidName := format('video%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
        DVBSetFilter(@AppFilters, PidsRecord[RecordIndex].Pid, 0, nil, '');
        Inc(RecordIndex);
      end;

    Index := 0;
    if chkRecordAudio.Checked and chkRecordAudioAll.Checked then
    begin
      while PidsAudio[Index] <> 0 do
      begin
        PidsRecord[RecordIndex].Pid := PidsAudio[Index];
        PidsRecord[RecordIndex].PidName := format('audio%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
        DVBSetFilter(@AppFilters, PidsRecord[RecordIndex].Pid, 0, nil, '');
        Inc(RecordIndex);
        Inc(Index);
      end;
    end;
    // Use the default PID if we did not update correctly or did not update at all
    if Index = 0 then
      if chkRecordAudio.Checked and (PidAudio <> 0) then
      begin
        PidsRecord[RecordIndex].Pid := PidAudio;
        PidsRecord[RecordIndex].PidName := format('audio%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
        DVBSetFilter(@AppFilters, PidsRecord[RecordIndex].Pid, 0, nil, '');
        Inc(RecordIndex);
      end;

    Index := 0;
    if chkRecordTeletext.Checked and chkRecordTeletextAll.Checked then
    begin
      while PidsTeletext[Index] <> 0 do
      begin
        PidsRecord[RecordIndex].Pid := PidsTeletext[Index];
        PidsRecord[RecordIndex].PidName := format('teletext%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
        DVBSetFilter(@AppFilters, PidsRecord[RecordIndex].Pid, 0, nil, '');
        Inc(RecordIndex);
        Inc(Index);
      end;
    end;
    // Use the default PID if we did not update correctly or did not update at all
    if Index = 0 then
      if chkRecordTeletext.Checked and (PidTeletext <> 0) then
      begin
        PidsRecord[RecordIndex].Pid := PidTeletext;
        PidsRecord[RecordIndex].PidName := format('teletext%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
        DVBSetFilter(@AppFilters, PidsRecord[RecordIndex].Pid, 0, nil, '');
        Inc(RecordIndex);
      end;

    Index := 0;
    if chkRecordSubtitle.Checked and chkRecordSubtitleAll.Checked then
    begin
      while PidsSubtitle[Index] <> 0 do
      begin
        PidsRecord[RecordIndex].Pid := PidsSubtitle[Index];
        PidsRecord[RecordIndex].PidName := format('subtitle%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
        DVBSetFilter(@AppFilters, PidsRecord[RecordIndex].Pid, 0, nil, '');
        Inc(RecordIndex);
        Inc(Index);
      end;
    end;
    // Use the default PID if we did not update correctly or did not update at all
    if Index = 0 then
      if chkRecordSubtitle.Checked and (PidSubtitle <> 0) then
      begin
        PidsRecord[RecordIndex].Pid := PidSubtitle;
        PidsRecord[RecordIndex].PidName := format('subtitle%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
//        DVBSetFilter(PidsRecord[RecordIndex].Pid, nil, '');
        Inc(RecordIndex);
      end;

    Index := 0;
    if chkRecordPMT.Checked and chkRecordPMTAll.Checked then
    begin
      if PidsPmt <> 0 then
      begin
        PidsRecord[RecordIndex].Pid := PidsPmt;
        PidsRecord[RecordIndex].PidName := format('pmt%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
//        DVBSetFilter(PidsRecord[RecordIndex].Pid, nil, '');
        Inc(RecordIndex);
        Inc(Index);
      end;
    end;
    // Use the default PID if we did not update correctly or did not update at all
    if Index = 0 then
      if chkRecordPMT.Checked and (PidPmt <> 0) then
      begin
        PidsRecord[RecordIndex].Pid := PidPmt;
        PidsRecord[RecordIndex].PidName := format('pmt%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
//        DVBSetFilter(PidsRecord[RecordIndex].Pid, nil, '');
        Inc(RecordIndex);
      end;

    Index := 0;
    if chkRecordPCR.Checked and chkRecordPCRAll.Checked then
    begin
      if PidsPcr <> 0 then
      begin
        PidsRecord[RecordIndex].Pid := PidsPcr;
        PidsRecord[RecordIndex].PidName := format('pcr%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
//        DVBSetFilter(PidsRecord[RecordIndex].Pid, nil, '');
        Inc(RecordIndex);
        Inc(Index);
      end;
    end;
    // Use the default PID if we did not update correctly or did not update at all
    if Index = 0 then
      if chkRecordPCR.Checked and (PidPcr <> 0) then
      begin
        PidsRecord[RecordIndex].Pid := PidPcr;
        PidsRecord[RecordIndex].PidName := format('pcr%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
//        DVBSetFilter(PidsRecord[RecordIndex].Pid, nil, '');
        Inc(RecordIndex);
      end;

    Index := 0;
    if chkRecordECM.Checked and chkRecordECMAll.Checked then
    begin
      while PidsECM[Index] <> 0 do
      begin
        PidsRecord[RecordIndex].Pid := PidsECM[Index];
        PidsRecord[RecordIndex].PidName := format('ecm%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
        DVBSetFilter(@AppFilters, PidsRecord[RecordIndex].Pid, 0, nil, '');
        Inc(RecordIndex);
        Inc(Index);
      end;
    end;
    // Use the default PID if we did not update correctly or did not update at all
    if Index = 0 then
      if chkRecordECM.Checked and (PidEcm <> 0) then
      begin
        PidsRecord[RecordIndex].Pid := PidEcm;
        PidsRecord[RecordIndex].PidName := format('ecm%d', [Index]);
        // We must place them in the filters otherwise they might not be decoded
//        DVBSetFilter(PidsRecord[RecordIndex].Pid, nil, '');
        Inc(RecordIndex);
      end;

    Result := True;
  end
  else
  begin
    PidsRecord[0].Pid := PidVideo;
    PidsRecord[0].PidName := 'video';
    PidsRecord[1].Pid := PidAudio;
    PidsRecord[1].PidName := 'audio';
    PidsRecord[2].Pid := PidPmt;
    PidsRecord[2].PidName := 'pmt';
    RecordIndex := 3;
    Result := False;
  end;
  for Index := RecordIndex to High(PidsRecord) do
  begin
    PidsRecord[RecordIndex].Pid := $FFFF;
    PidsRecord[RecordIndex].PidName := '';
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>   Returns the index which needs to be used to remove
                       all PIDs created.
                       $FF indicates an error

  Descript: Start recording current program.
  Notes   :
 ------------------------------------------------------------------------------}

function TfrmMain.StartRecordingProgram: Byte;
var
  PidsRecord: TPidLists;
begin
  ToLog('StartRecordingProgram', $5);
  GetRecordingPids(PidsRecord);
  Result := StartRecording(PidsRecord);
end;

{------------------------------------------------------------------------------
  Params  : <Pids>     Pids to use for recording
  Returns : <Result>   Returns the index which needs to be used to remove
                       all PIDs created.
                       $FF indicates an error

  Descript: Start recording (add PIDs to recording array).
  Notes   : A recording is started by adding the PIDs in the list of
            PIDs to record.
 ------------------------------------------------------------------------------}

function TfrmMain.StartRecording(Pids: array of TPidList): Byte;
var
  Count: Byte;
  Index: Byte;
  Index2: Byte;
  Master: Byte;
  FileName: string;
  NrPids: Byte;
  Duplicate: Boolean;
  InUse: Boolean;
  InfoFile: TFileStream;
  InfoString: string;
begin
  ToLog('StartRecording', $5);
  Result := $FF;
  if High(Pids) < 0 then
    Exit;
  // Assume we start a recording, set basics
  if chkRecordTransponder.Checked then
  begin
    FilteringOff := True;
    RecordingRawData := True;
    ShowAudioVideo := False;
  end
  else
  begin
    FilteringOff := chkRecordNoFiltering.Checked;
    RecordingRawData := chkRecordRawData.Checked;
  end;

  // Find number of Pids: a PID of '0' will always end the list
  NrPids := Low(Pids);
  repeat
    if Pids[NrPids].Pid <> $FFFF then
      Inc(NrPids);
  until (NrPids > High(Pids)) or (Pids[NrPids].Pid = $FFFF);

  // First try if there is room for all the PIDs
  Count := 0;
  for Index := Low(RecordingPids) to High(RecordingPids) do
  begin
    if RecordingPids[Index].Pid = $FFFF then
      Inc(Count);
  end;
  if NrPids > Count then
    Exit;
  // Create the filename
  FileName := RecordingDirectory;
  if (Length(FileName) > 0) and
    (FileName[Length(FileName)] <> '\') then
    FileName := FileName + '\';
  // Use the provided filename prefix if possible
  if edtFileNamePrefix.Text <> '' then
    FileName := FileName + edtFileNamePrefix.Text +
      FormatDateTime('"T"HHMMSSZZZ', Now)
  else
    FileName := FileName + FormatDateTime('YYYYMMDD"T"HHMMSSZZZ', Now);

  if RecordingInfoFile then
  begin
    // Make a record of the current settings in a file so we will be able
    // to backtrace the settings (eg. when processing the file data later)
    InfoFile := TFileStream.Create(FileName + '.info', fmCreate);
    if chkRecordTransponder.Checked then
    begin
      Infostring := '; **** Whole transponder raw data recording ****' + #13#10;
      InfoFile.Write(InfoString[1], Length(InfoString));
      Infostring := '0, transponder' + #13#10;
      InfoFile.Write(InfoString[1], Length(InfoString));
    end
    else
    begin
      Infostring := '; **** Recording settings ****' + #13#10;
      InfoFile.Write(InfoString[1], Length(InfoString));
      for Index := Low(Pids) to (Low(Pids) + NrPids - 1) do
      begin
        Infostring := format('%d, %s', [Pids[Index].Pid, Pids[Index].PidName]) +
          #13#10;
        InfoFile.Write(InfoString[1], Length(InfoString));
      end;
    end;
    Infostring := '; **** Active settings ****' + #13#10;
    InfoFile.Write(InfoString[1], Length(InfoString));
    Infostring := format('%d, PidVideo', [PidVideo]) + #13#10;
    InfoFile.Write(InfoString[1], Length(InfoString));
    Infostring := format('%d, PidAudio', [PidAudio]) + #13#10;
    InfoFile.Write(InfoString[1], Length(InfoString));
    Infostring := format('%d, PidTeletext', [PidTeletext]) + #13#10;
    InfoFile.Write(InfoString[1], Length(InfoString));
    Infostring := format('%d, PidPcr', [PidPCr]) + #13#10;
    InfoFile.Write(InfoString[1], Length(InfoString));
    Infostring := format('%d, PidPmt', [PidPmt]) + #13#10;
    InfoFile.Write(InfoString[1], Length(InfoString));
    Infostring := format('%d, PidEcm', [PidEcm]) + #13#10;
    InfoFile.Write(InfoString[1], Length(InfoString));
    InfoFile.Free;
  end;

  if chkRecordTransponder.Checked then
  begin
    Master := 0;
    RecordingAllFile := TFileStream.Create(FileName + '.TS', fmCreate);
    RecordingAllFilePart := 0;
    RecordingAllFileFileName := FileName;
    RecordingAllSplitSize := 0;
  end
  else
  begin
    // Setup starting conditions
    Master := $FF;
    Count := Low(RecordingPids);
    // Go through all PIDs in the list
    for Index := Low(Pids) to (Low(Pids) + NrPids - 1) do
    begin
      // Find first available room in recording list, we assume we always have room ...
      // (we did check it).
      repeat
        if RecordingPids[Count].Pid <> $FFFF then
          Inc(Count);
      until RecordingPids[Count].Pid = $FFFF;

      // Very first found is the master
      if Master = $FF then
        Master := Count;

      // Find duplicate references to current PID. Only those who references
      // the master are checked
      Duplicate := False;
      if Count > Low(RecordingPids) then
        for Index2 := Low(RecordingPids) to Count - 1 do
          if RecordingPids[Index2].MasterLink = Master then
            if RecordingPids[Index2].Pid = Pids[Index].Pid then
              Duplicate := True;
      // Only if no duplicate was found we add the new PID
      if not Duplicate then
      begin
        // If we are currently handling the master we create a file stream if
        // a single file stream is used.
        if (Count = Master) and
          (not chkRecordIndividualStreams.Checked) then
        begin
          RecordingPids[Count].RecordingFileFileName := FileName;
          RecordingPids[Count].SplitIndex := 0;
          RecordingPids[Count].SplitSize := 0;
          RecordingPids[Count].RecordingFile := TFileStream.Create(
            RecordingPids[Count].RecordingFileFileName + '.TS', fmCreate);
        end;
        // If individual file streams are used then create individual file streams
        if chkRecordIndividualStreams.Checked then
        begin
          RecordingPids[Count].RecordingFileFileName := FileName + '_'
            + Format('%4.4d', [Pids[Index].Pid]) + '_' + Pids[Index].PidName;
          RecordingPids[Count].SplitIndex := 0;
          RecordingPids[Count].SplitSize := 0;
          RecordingPids[Count].RecordingFile := TFileStream.Create(
            RecordingPids[Count].RecordingFileFileName + '.TS', fmCreate);
        end;
        // Set links
        RecordingPids[Count].MasterLink := Master;
        if chkRecordIndividualStreams.Checked then
          RecordingPids[Count].RecordingLink := Count
        else
          RecordingPids[Count].RecordingLink := Master;
        RecordingPids[Count].Pid := Pids[Index].Pid;
      end;
    end;
  end;
  // If recording did not start we might need to correct some things we set
  // at the beginning
  if Master = $FF then
  begin
    InUse := False;
    for Index := Low(RecordingPids) to High(RecordingPids) do
      if RecordingPids[Index].Pid <> $FFFF then
        InUse := True;
    if not InUse then
    begin
      // Defaults
      RecordingAllData := False;
      FilteringOff := False;
      RecordingRawData := False;
      ShowAudioVideo := chkDirectShow.Checked;
    end;
  end
  else if
    chkRecordTransponder.Checked then
    RecordingAllData := True;
  Result := Master;
end;

{------------------------------------------------------------------------------
  Params  : <Index>     Index of PID to remove
  Returns : -

  Descript: Stop recording.
  Notes   : A recording is stopped by removing the PIDs from the list of
            PIDs currently recording.
            If the 'master' PID is removed then all associated PIDs are also
            removed, otherwise only the individual PIDs are removed from
            recording.
 ------------------------------------------------------------------------------}

procedure TfrmMain.StopRecording(Index: Byte);
var
  Loop: Byte;
  InUse: Boolean;
begin
  ToLog('StopRecording', $5);
  if Index > High(RecordingPids) then
    Exit;
  if RecordingAllData then
  begin
    RecordingAllData := False;
    Sleep(50);
    FreeAndNil(RecordingAllFile);
    FilteringOff := False;
    RecordingRawData := False;
    ShowAudioVideo := chkDirectShow.Checked;
    Exit;
  end;
  // If we are a master PID then remove all associated PIDs too and close
  // all file streams.
  if RecordingPids[Index].MasterLink = Index then
  begin
    // First stop recordings
    for Loop := Low(RecordingPids) to High(RecordingPids) do
      if (RecordingPids[Loop].MasterLink = Index) then
        RecordingPids[Loop].Pid := $FFFF;
    // Then close file streams
    for Loop := Low(RecordingPids) to High(RecordingPids) do
      if (RecordingPids[Loop].MasterLink = Index) then
        if Assigned(RecordingPids[Loop].RecordingFile) then
          FreeAndNil(RecordingPids[Loop].RecordingFile);
  end
  else
  begin
    // We did not request a master PID to be removed
    // Remove individual from list
    RecordingPids[Index].Pid := $FFFF;
    // If we are using a file stream here we can not just remove it
    // since it might be in use by another too.
    if Assigned(RecordingPids[Index].RecordingFile) then
    begin
      // The removed one has its own file stream. Now find if others
      // are using it too. If not then close the file stream.
      InUse := False;
      for Loop := Low(RecordingPids) to High(RecordingPids) do
        if (RecordingPids[Loop].Pid <> $FFFF) and
          (RecordingPids[Loop].RecordingLink = Index) then
          InUse := True;
      if not InUse then
        FreeAndNil(RecordingPids[Index].RecordingFile);
    end;
  end;
  // Now check if anything is still active for recording. If not then set
  // some stuff.
  InUse := False;
  for Loop := Low(RecordingPids) to High(RecordingPids) do
    if RecordingPids[Loop].Pid <> $FFFF then
      InUse := True;
  if not InUse then
  begin
    // Defaults
    RecordingAllData := False;
    FilteringOff := False;
    RecordingRawData := False;
    ShowAudioVideo := chkDirectShow.Checked;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Process a recorded TS file as if it is currently received
            from the satellite.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.ProcessRecordedTSFileClick(Sender: TObject);
var
  dlgOpen: TOpenDialog;
  OpenName: string;
  SizeHigh: Dword;
  SizeLow: Dword;
  SizeHuge: Int64;
  DoExit: Boolean;
begin
  if not Assigned(PacketThread) then
    Exit;
  // Using DoExit is no requirement but makes things look more sequential
  // instead of using an exit within the try..finally
  DoExit := False;
  StreamLock.Acquire;
  try
    if Assigned(PacketThread.FFileStream) and
      (not PacketThread.FHasStopped) then // If already running
    begin
      PacketThread.FFileStreamStop := True;
      // Make sure packet thread continues if it is waiting for some reason
      if UseFlexCop then
        FlexCopGenerateManualNotification(CardHandle)
      else
        Saa7146aGenerateManualNotification(CardHandle);
      DoExit := True;
    end;
  finally
    StreamLock.Release;
  end;
  if DoExit then
    Exit;
  if Recording <> rtIdle then
    Exit;

  // For some reason the open dialog interferes with the directory behaviour
  // op the application and when terminating the application an error is
  // generated. For instance the log file of DirectX will be placed
  // in the directory of the opened file.
  // This happens for all files which are used without having a specific
  // path.
  // Note: Just 'canceling' the open dialog will still generate the error
  //       when terminating the application.
  // Note: This behaviour is typically only during the run-time environment
  //       of Delphi...
  OpenName := '';
  dlgOpen := TOpenDialog.Create(nil);
  try
    dlgOpen.Filter := 'Transport stream files (*.TS)|*.TS|All files (*.*)|*.*';
    dlgOpen.Options := [ofFileMustExist, ofHideReadOnly];
    dlgOpen.InitialDir := RecordingDirectory;
    if dlgOpen.Execute then
      OpenName := dlgOpen.FileName;
  finally
    dlgOpen.Free;
  end;

  if OpenName <> '' then
  begin
    // Force transponder mode
    chkTransponderDisplay.Checked := True;
    // Update settings

    // Place packet thread in file stream mode
    StreamLock.Acquire;
    try
      PacketThread.FFileStreamDelay := 20;
      PacketThread.FFileStreamStop := False;
      PacketThread.FFileStream := TFileStream.Create(OpenName, fmOpenRead);
      // Get file size (>4G supported)
      SizeLow := GetFileSize(PacketThread.FFileStream.Handle, @SizeHigh);
      LARGE_INTEGER(SizeHuge).HighPart := SizeHigh;
      LARGE_INTEGER(SizeHuge).LowPart := SizeLow;
      PacketThread.FFileStreamSize := SizeHuge;
      // Make sure packet thread continues if it is waiting for some reason
      if UseFlexCop then
        FlexCopGenerateManualNotification(CardHandle)
      else
        Saa7146aGenerateManualNotification(CardHandle);
    finally
      StreamLock.release;
    end;
    Sleep(100);
    SendMessage(frmMain.Handle, WM_REMOTE, frmMain.btnUpdate.ComponentIndex, 0);
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Search in transponder list for text.
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.SearchFavouriteClick(Sender: TObject);
const
  InputString: string = '';
var
  StartSearch: Integer;
  Loop       : Integer;
  Found      : Boolean;
begin
  StartSearch := cmbFavourites.ItemIndex+1;
  if StartSearch >= cmbFavourites.Items.Count then
    StartSearch := 0;
  // If not 'repeat search' ask for input text
  InputString := InputBox('Search in favourite list', 'Text:', InputString);
  if InputString <> '' then
  begin
    InputString := LowerCase(InputString);
    Found := False;
    for Loop := StartSearch to cmbFavourites.Items.Count-1 do
      if Pos(InputString, LowerCase(cmbFavourites.Items[Loop])) <> 0 then
      begin
        cmbFavourites.ItemIndex := Loop;
        UpdateSettings(nil);
        Found := True;
        Break;
      end;
    // Try finding from begin
    if not Found and (StartSearch > 0) then
      for Loop := 0 to StartSearch do
      if Pos(InputString, LowerCase(cmbFavourites.Items[Loop])) <> 0 then
      begin
        cmbFavourites.ItemIndex := Loop;
        UpdateSettings(nil);
//        Found := True;
        Break;
      end;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Stop recording of all data.
  Notes   :
 ------------------------------------------------------------------------------}
(*procedure TfrmMain.StopAllRecordings;
var
  Index: Byte;
begin
  if RecordingAllData then
  begin
    RecordingAllData := False;
    Sleep(50);
    FreeAndNil(RecordingAllFile);
  end;
  // First set all PIDs available
  for Index := Low(RecordingPids) to High(RecordingPids) do
    RecordingPids[Index].Pid := $FFFF;
  // Now close any file
  for Index := Low(RecordingPids) to High(RecordingPids) do
    if Assigned(RecordingPids[Index].RecordingFile) then
      FreeAndNil(RecordingPids[Index].RecordingFile);
  // Defaults
  RecordingAllData := False;
  FilteringOff     := False;
  RecordingRawData := False;
  ShowAudioVideo   := chkDirectShow.Checked;
end;
*)

{------------------------------------------------------------------------------
  Params  : -
  Returns : <result>  True if still some active

  Descript: Check if recordings active
  Notes   :
 ------------------------------------------------------------------------------}

function TfrmMain.RecordingIsActive: Boolean;
var
  Index: Byte;
begin
  Result := False;
  // First set all PIDs available
  for Index := Low(RecordingPids) to High(RecordingPids) do
    if RecordingPids[Index].Pid <> $FFFF then
      Result := True;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : <result>  True if still some active

  Descript: Show all PIDs
  Notes   :
 ------------------------------------------------------------------------------}

procedure TfrmMain.btnPidsClick(Sender: TObject);
var
  Pids      : array[0..127] of Word;
  ProgramNr : Byte;
  DisplayStr: string;
  Loop      : Integer;
begin
  ProgramNr := $FF;
  DvbFilterGetProgramPids(ProgramNr, ServiceNumber, Pids);
  DisplayStr := '';
  for Loop := Low(Pids) to High(Pids) do
    if Pids[Loop] <> $FFFF then
      DisplayStr := DisplayStr + format(' %d', [Pids[Loop]]);
  if DisplayStr <> '' then
    ShowMessage('PID''s PMT refers to:  ' + DisplayStr);
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Handle command line parameters
  Notes   :
 ------------------------------------------------------------------------------}

procedure CommandLineParameters;
var
  Parameter: string;
  Value: string;
  Separator: Integer;
  Loop: Integer;
begin
  // Reset parameters
  ParameterSetup := '';
  ParameterDsGraphFile := '';
  ParameterProgram := '';
  ParameterFavourite := '';
  ParameterStartRecording := '';
  ParameterStartRecordingIfExpired := '';
  ParameterStopRecording := '';
  ParameterShutdown := '';
  ParameterExit := '';
  ParameterExitAfterRecording := '';
  ParameterShutdownAfterRecording := '';
  ParameterFullScreen := '';

  if ParamCount = 0 then
    Exit;
  for Loop := 1 to ParamCount do
  begin
    Value := ParamStr(Loop);
    Parameter := '';
    Separator := Pos('=', Value);
    if Separator <> 0 then
    begin
      Parameter := LowerCase(Copy(Value, 1, Separator - 1));
      Delete(Value, 1, Separator);
      ToLog('Parameter: ' + Parameter + '=' + Value, $00);

      if Parameter = 'directshowgraph' then
        ParameterDsGraphFile := Value;
      if Parameter = 'program' then
        ParameterProgram := Value;
      if Parameter = 'favourite' then
        ParameterFavourite := Value;
      if Parameter = 'startrecording' then
        ParameterStartRecording := Value;
      if Parameter = 'startrecordingifexpired' then
        ParameterStartRecordingIfExpired := LowerCase(Value);
      if Parameter = 'stoprecording' then
        ParameterStopRecording := Value;
      if Parameter = 'shutdown' then
        ParameterShutdown := Value;
      if Parameter = 'exit' then
        ParameterExit := Value;
      if Parameter = 'exitafterrecording' then
        ParameterExitAfterRecording := LowerCase(Value);
      if Parameter = 'shutdownafterrecording' then
        ParameterShutdownAfterRecording := LowerCase(Value);
      if Parameter = 'fullscreen' then
        ParameterFullScreen := LowerCase(Value);
    end
    else
    begin
      Value := LowerCase(Value);
      if Value = 'setup' then
        ParameterSetup := '1';
    end;
  end;
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>  Form with setup parameters
  Returns : -

  Descript: Set DirectShow parameters from global settings
  Notes   :
 ------------------------------------------------------------------------------}

procedure SetDirectShowSetup(SetupForm: TfrmSetupDirectShow);
begin
  if not Assigned(SetupForm) then
    Exit;
  SetupForm.Options := DsOptions;
  SetupForm.Graph := GetParameter('Interface', 'DirectShowGraph', '');
  SetupForm.DirectShowOff := DsOff;
  setupForm.DirectShowSendAll := DsSendAll;
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>   Form with setup parameters
            <ForceWrite>  True forces update
  Returns : -

  Descript: Write DirectShow setup parameters (only if they have changed)
  Notes   : Also updates global settings
 ------------------------------------------------------------------------------}

procedure GetAndWriteDirectShowSetup(SetupForm: TfrmSetupDirectShow; ForceWrite:
  Boolean);
begin
  if not Assigned(SetupForm) then
    Exit;
  if SetupForm.SettingChanged or ForceWrite then
  begin
    DsOptions := SetupForm.Options;
    DsGraphFile := SetupForm.Graph;
    if ExtractFileExt(DsGraphFile) = '' then
      DsGraphFile := DsGraphFile + '.GRF';
    if ExtractFilePath(DsGraphFile) = '' then
      DsGraphFile := ExeDirectory + DsGraphFile;
    DsOff := SetupForm.DirectShowOff;
    DsSendAll := SetupForm.DirectShowSendAll;
    // Save setting
    IniFile.WriteString('Interface', 'DirectShowOptions', format('$%8.8x',
      [DsOptions]));
    IniFile.WriteString('Interface', 'DirectShowGraph', SetupForm.Graph);
    if DsOff then
      IniFile.WriteString('Interface', 'DirectShowOff', 'Yes')
    else
      IniFile.WriteString('Interface', 'DirectShowOff', 'No');
    if DsSendAll then
      IniFile.WriteString('Interface', 'DirectShowSendAll', 'Yes')
    else
      IniFile.WriteString('Interface', 'DirectShowSendAll', 'No');
    IniFile.UpdateFile;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Read DirectShow setup parameters
  Notes   :
 ------------------------------------------------------------------------------}

procedure ReadDirectShowSetup;
var
  Parameter: string;
  Error: Integer;
begin
  Parameter := LowerCase(GetParameter('Interface', 'DirectShowOptions', '0'));
  Val(Parameter, DsOptions, Error);
  if Error <> 0 then
    DsOptions := 0;

  if ParameterDsGraphFile = '' then
    DsGraphFile := LowerCase(GetParameter('Interface', 'DirectShowGraph', ''))
  else
    DsGraphFile := ParameterDsGraphFile;
  if ExtractFileExt(DsGraphFile) = '' then
    DsGraphFile := DsGraphFile + '.GRF';
  if ExtractFilePath(DsGraphFile) = '' then
    DsGraphFile := ExeDirectory + DsGraphFile;

  Parameter := LowerCase(GetParameter('Interface', 'DirectShowOff', 'No'));
  if Parameter = 'yes' then
    DsOff := True
  else
    DsOff := False;
  Parameter := LowerCase(GetParameter('Interface', 'DirectShowSendAll', 'No'));
  if Parameter = 'yes' then
    DsSendAll := True
  else
    DsSendAll := False;
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>  Form with setup parameters
  Returns : -

  Descript: Set hardware setup parameters from global settings
  Notes   :
 ------------------------------------------------------------------------------}

procedure SetCardSetup(SetupForm: TfrmSetupCard);
begin
  if not Assigned(SetupForm) then
    Exit;
  // Set all settings
  SetupForm.CardNumber := CardNumber;
  SetupForm.PriorityName := Priority;
  SetupForm.RpsProgram := Rps0Program;
  SetupForm.BufferSize := BufferTime;
  if IsSlave then
    SetupForm.MasterMode := 1
  else
    SetupForm.MasterMode := 0;
  if DvbCard = '' then
    SetupForm.Card := -1
  else
    SetupForm.CardName := DvbCard;
  SetupForm.Tuner := TunerType;
  SetupForm.SynthesizerAddress := SynthesizerAddress;
  SetupForm.Polarity := LnbPolarity;
  SetupForm.TunerReset := TunerReset;
  SetupForm.LNBPower := LnbOnOff;
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>   Form with setup parameters
            <ForceWrite>  True forces update
  Returns : -

  Descript: Write hardware setup parameters (only if they have changed)
  Notes   : Also updates global settings
 ------------------------------------------------------------------------------}

procedure GetAndWriteCardSetup(SetupForm: TfrmSetupCard; ForceWrite: Boolean);
begin
  if not Assigned(SetupForm) then
    Exit;
  if SetupForm.SettingChanged or ForceWrite then
  begin
    CardNumber := SetupForm.CardNumber;
    IniFile.WriteString('Hardware', 'Device', format('%d', [CardNumber]));
    Priority := SetupForm.PriorityName;
    IniFile.WriteString('Hardware', 'ThreadPriority', Priority);
    Rps0Program := SetupForm.RpsProgram;
    IniFile.WriteString('Hardware', 'RPS0Program', format('%d', [Rps0Program]));
    BufferTime := SetupForm.BufferSize;
    IniFile.WriteString('Interface', 'TSBufferSize', format('%d',
      [BufferTime]));
    IsSlave := (SetupForm.MasterMode <> 0);
    if IsSlave then
      IniFile.WriteString('Debug', 'AllowSlave', 'Yes')
    else
      IniFile.WriteString('Debug', 'AllowSlave', 'No');

    DvbCard := SetupForm.CardName;
    IniFile.WriteString('Hardware', 'Card', DvbCard);
    if DvbCard = '' then
    begin
      // Only update these if 'User defined' selected
      TunerType := SetupForm.Tuner;
      SynthesizerAddress := SetupForm.SynthesizerAddress;
      LnbPolarity := SetupForm.Polarity;
      TunerReset := SetupForm.TunerReset;
      LnbOnOff := SetupForm.LNBPower;
      IniFile.WriteString('Hardware', 'Tuner', SetupForm.TunerName);
      IniFile.WriteString('Hardware', 'SynthesizerAddress', format('%d',
        [SynthesizerAddress]));
      IniFile.WriteString('Hardware', 'LNBPolarity', format('%d',
        [LnbPolarity]));
      IniFile.WriteString('Hardware', 'TunerReset', format('%d', [TunerReset]));
      IniFile.WriteString('Hardware', 'LNBOnOff', format('%d', [LnbOnOff]));
    end;
    IniFile.UpdateFile;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Read hardware setup parameters
  Notes   :
 ------------------------------------------------------------------------------}

procedure ReadCardSetup;
var
  CheckString: string;
  Parameter: string;
  Error: Integer;
begin
  // Device (card number) to use
  Parameter := GetParameter('Hardware', 'Device', '-1');
  Val(Parameter, CardNumber, Error);
  if Error <> 0 then
    CardNumber := -1;

  // Thread priority
  Priority := GetParameter('Hardware', 'ThreadPriority', 'Default');

  // Rps program
  Parameter := GetParameter('Hardware', 'RPS0Program', '-1');
  Val(Parameter, Rps0Program, Error);
  if Error <> 0 then
    Rps0Program := -1;

  // Buffer time/size
  Parameter := GetParameter('Interface', 'TSBufferSize', '400');
  Val(Parameter, BufferTime, Error);
  if Error <> 0 then
    BufferTime := 400;

  // Get slave setting
  CheckString := LowerCase(GetParameter('Debug', 'AllowSlave', 'No'));
  if CheckString = 'yes' then
    IsSlave := True
  else
    IsSlave := False;

  // Get card type (overrules other settings)
  DvbCard := GetParameter('Hardware', 'Card', '');

  // Get tuner type
  CheckString := LowerCase(GetParameter('Hardware', 'Tuner', 'BSRU6'));
  if LowerCase(CheckString) = 'su1278' then
    TunerType := CTunerSU1278
  else if LowerCase(CheckString) = 'bsbe1' then
    TunerType := CTunerBSBE1
  else
    TunerType := CTunerBSRU6;

  // Get synthesizer address
  Parameter := LowerCase(GetParameter('Hardware', 'SynthesizerAddress', '1'));
  Val(Parameter, SynthesizerAddress, Error);
  if Error <> 0 then
    SynthesizerAddress := 1;
  if SynthesizerAddress > 3 then
    SynthesizerAddress := 255;

  // Get tuner reset line
  Parameter := LowerCase(GetParameter('Hardware', 'TunerReset', '2'));
  Val(Parameter, TunerReset, Error);
  if Error <> 0 then
    TunerReset := 2;
  if TunerReset > 3 then
    TunerReset := 255;

  // Get LNB polarity line
  Parameter := LowerCase(GetParameter('Hardware', 'LNBPolarity', '0'));
  Val(Parameter, LNBPolarity, Error);
  if Error <> 0 then
    LNBPolarity := 0;
  if LNBPolarity > 1 then
    LNBPolarity := 255;

  // Get LNB on/off line
  Parameter := LowerCase(GetParameter('Hardware', 'LNBOnOff', '1'));
  Val(Parameter, LNBOnOff, Error);
  if Error <> 0 then
    LNBOnOff := 0;
  if LNBOnOff > 1 then
    LNBOnOff := 255;
  if LNBOnOff = LNBPolarity then
    LNBOnOff := 255;
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>  Form with setup parameters
  Returns : -

  Descript: Set files setup parameters from global settings
  Notes   :
 ------------------------------------------------------------------------------}

procedure SetFilesSetup(SetupForm: TfrmSetupFiles);
var
  ListStrings: TStringList;
  Loop: Integer;
  Parameters: string;
begin
  if not Assigned(SetupForm) then
    Exit;
  // Set all settings
  SetupForm.ExeDirectory := ExeDirectory;
  SetupForm.TransponderFile := Trim(GetParameter('Transponder',
    'TransponderFile', ''));
  ListStrings := TStringList.Create;
  try
    IniFile.ReadSection('FavouriteFiles', ListStrings);
    if ListStrings.Count > 0 then
      for Loop := 0 to ListStrings.Count - 1 do
      begin
        Parameters := GetParameter('FavouriteFiles', ListStrings[Loop], '');
        Parameters := Trim(Parameters);
        SetupForm.FavouriteFile[Loop] := ListStrings[Loop];
        SetupForm.FavouriteDescription[Loop] := Parameters;
      end;
  finally
    ListStrings.Free;
  end;
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>   Form with setup parameters
            <ForceWrite>  True forces update
  Returns : -

  Descript: Write files setup parameters (only if they have changed)
  Notes   : Also updates global settings
 ------------------------------------------------------------------------------}

procedure GetAndWriteFilesSetup(SetupForm: TfrmSetupFiles; ForceWrite: Boolean);
var
  ListStrings: TStringList;
  FileName: string;
  Description: string;
  Loop: Integer;
  Loop2: Integer;
begin
  if not Assigned(SetupForm) then
    Exit;
  if SetupForm.SettingChanged or ForceWrite then
  begin
    FileName := LowerCase(SetupForm.TransponderFile);
    IniFile.WriteString('Transponder', 'TransponderFile', FileName);
    Loop := 0;
    //    IniFile.EraseSection('FavouriteFiles');
    // Note: Think about using 'ReadStrings/WrteStrings' for INI file
        // Make a record of old information (we have to remove obsolete entries)
        // EraseSection is to crude. Also goes wrong at times. However, without
        // EraseSection we do not get the correct order of the keys.
    ListStrings := TStringList.Create;
    try
      IniFile.ReadSection('FavouriteFiles', ListStrings);
      // Remove ALL entries. We use this instead of erasing the section since this
      // is not always handled correctly. We also retain any single line comments
      // this way, although the position may change
      if ListStrings.Count > 0 then
        for Loop2 := 0 to ListStrings.Count - 1 do
          IniFile.DeleteKey('FavouriteFiles', ListStrings[Loop2]);
      // Just in case
      IniFile.UpdateFile;
      repeat
        FileName := LowerCase(SetupForm.FavouriteFile[Loop]);
        if FileName <> '' then
        begin
          // Starts with application directory, so extract it
          Description := SetupForm.FavouriteDescription[Loop];
          IniFile.WriteString('FavouriteFiles', FileName, '"' + Description +
            '"');
          // Try finding it in our old list (remove it if we found it)
//          if ListStrings.Count > 0 then
//            for Loop2 := 0 to ListStrings.Count-1 do
//              if LowerCase(ListStrings[Loop2]) = LowerCase(FileName) then
//              begin
//                ListStrings.Delete(Loop2);
//                Break;
//              end;
        end;
        Inc(Loop);
      until FileName = '';
      // All we have to do is to remove obsolete entries
//      if ListStrings.Count > 0 then
//        for Loop2 := 0 to ListStrings.Count-1 do
//          IniFile.DeleteKey('FavouriteFiles', ListStrings[Loop2]);
    finally
      ListStrings.Free;
    end;
    IniFile.UpdateFile;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Read files setup parameters
  Notes   : Nothing to do here. Handled runtime by ReadLists/ReadFavourites
 ------------------------------------------------------------------------------}

procedure ReadFilesSetup;
begin
  //
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>  Form with setup parameters
  Returns : -

  Descript: Set DiSEqC setup parameters from global settings
  Notes   :
 ------------------------------------------------------------------------------}

procedure SetDiSEqCSetup(SetupForm: TfrmSetupDiSEqC);
var
  Loop: Integer;
begin
  if not Assigned(SetupForm) then
    Exit;
  if DiSEqCList.Count > 0 then
    for Loop := 0 to DiSEqCList.Count - 1 do
      SetupForm.Setting[Loop] := DiSEqCList[Loop];
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>   Form with setup parameters
            <ForceWrite>  True forces update
  Returns : -

  Descript: Write DiSEqC setup parameters (only if they have changed)
  Notes   : Also updates global settings
 ------------------------------------------------------------------------------}

procedure GetAndWriteDiSEqCSetup(SetupForm: TfrmSetupDiSEqC; ForceWrite:
  Boolean);
var
  Loop: Integer;
  Setting: ShortString;
begin
  if not Assigned(SetupForm) then
    Exit;
  if SetupForm.SettingChanged or ForceWrite then
  begin
    DiSEqCList.Clear;
    Loop := 0;
    repeat
      Setting := SetupForm.Setting[Loop];
      Inc(Loop);
      if Setting <> '' then
        DiSEqCList.Add(Setting);
    until Setting = '';
    IniFile.WriteStrings('DiSEqC', 'DiSEqC', DiSEqCList);
    IniFile.UpdateFile;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Read DiSEqC setup parameters
  Notes   :
 ------------------------------------------------------------------------------}

procedure ReadDiSEqCSetup;
var
  CheckString: string;
  Parameter: string;
  Error: Integer;
begin
  // Read all DISEqC settings
  IniFile.ReadStrings('DiSEqC', 'DiSEqC', DiSEqCList);

  // This below is for compatability only with older versions.
  // LNB settings
  Parameter := GetParameter('Hardware', 'LNBLOFLowBand', '9750000');
  Val(Parameter, LNBLofLowBand, Error);
  if Error <> 0 then
    LNBLofLowBand := 9750000;
  Parameter := GetParameter('Hardware', 'LNBLOFHighBand', '10600000');
  Val(Parameter, LNBLofHighBand, Error);
  if Error <> 0 then
    LNBLofLowBand := 10600000;

  // DiSEqC settings
  Parameter := GetParameter('Hardware', 'DiSEqCRepeats', '0');
  Val(Parameter, DiSEqCRepeats, Error);
  if Error <> 0 then
    DiSEqCRepeats := 0;
  CheckString := LowerCase(GetParameter('Hardware', 'DiSEqCUsePositioner',
    'No'));
  if CheckString = 'yes' then
    DiSEqCUsePositioner := True
  else
    DiSEqCUsePositioner := False;
  CheckString := LowerCase(GetParameter('Hardware', 'DiSEqCMini', 'No'));
  if CheckString = 'yes' then
    DiSEqCMini := True
  else
    DiSEqCMini := False;
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>  Form with setup parameters
  Returns : -

  Descript: Set miscellaneous setup parameters from global settings
  Notes   :
 ------------------------------------------------------------------------------}

procedure SetMiscellaneousSetup(SetupForm: TfrmSetupMiscellaneous);
begin
  if not Assigned(SetupForm) then
    Exit;
  // CSA
  case CsaMethod of
    cmNone: SetupForm.Csa := 'Disable';
    cmInternal: SetupForm.Csa := 'Internal (slow)';
    cmCsa,
      cmFfCsa: SetupForm.Csa := CsaName;
  end;
  SetupForm.LogLevel := LogLevel;
  SetupForm.LogClear := LogClear;
  SetupForm.PreferredLanguage := PreferredLanguage;
  SetupForm.AlwaysUpdateProgram := AlwaysUpdateProgram;
  SetupForm.KeySwapUpDown := KeySwapUpDown;
  SetupForm.FontName := FontName;
  SetupForm.FontSize := FontSize;
  SetupForm.FontNameEpg := FontNameEpg;
  SetupForm.FontSizeEpg := FontSizeEpg;
  SetupForm.EpgHeight := EpgHeight;
  SetupForm.TimeCorrectionGmt := TimeCorrectionGmt;
  SetupForm.TimeCorrection := TimeCorrection;
  SetupForm.TimeCorrectionPreRecord := TimeCorrectionPreRecord;
  SetupForm.TimeCorrectionPostRecord := TimeCorrectionPostRecord;
  SetupForm.MdPluginPassFullPacket := MdPluginPassFullpacket;
  SetupForm.MdPluginAllowSetPids := MdPluginAllowSetPids;
  SetupForm.DisplayDuringRecording := DisplayDuringRecording;
  SetupForm.RecordingDirectory := RecordingDirectory;
  SetupForm.RecordingInfoFile := RecordingInfoFile;
  if not RecordingSplitted then
    SetupForm.RecordingSplitSize := 9999
  else
    SetupForm.RecordingSplitSize := RecordingSplitSize div 1000000;
  // Actual timeout is about 10 times smaller (because of state machine)
  SetupForm.TimeoutNumericalKeys := TimeoutNumericalKeys * 10;
  SetupForm.TimeoutNumericalKeysRemote := TimeoutNumericalKeysRemote * 10;
  SetupForm.AutoContinueOnException := AutoContinueOnException;
  SetupForm.FreezeTimeout := FreezeTimeout;
end;

{------------------------------------------------------------------------------
  Params  : <DllName>  DLL name
  Returns : -

  Descript: Setup CSA mechanism according to DLL
  Notes   : Updates global <CsaName>
 ------------------------------------------------------------------------------}

procedure SetupCsaMechanism(DllName: string);
var
  OrgMethod: TCsaMethod;
begin
  // Remove any old DLL
  if CsaDllIdentifier <> 0 then
  begin
    // First switch to internal descrambling otherwise the descrambling
    // might use the library we are removing here
    OrgMethod := CsaMethod;
    CsaMethod := cmInternal;
    Sleep(10);
    FreeLibrary(CsaDLLIdentifier);
    if OrgMethod = cmFfCsa then
      FreeMem(FFCsaKeys, FFCsaKeySize);
    CsaDllIdentifier := 0;
  end;
  CsaMethod := cmNone;
  if Dllname = '' then
  begin
    CsaMethod := cmInternal;
    CsaName := '';
    Exit;
  end;
  if LowerCase(DllName) <> 'disable' then
  begin
    CsaDLLIdentifier := LoadLibrary(PChar(DllName));
    // If we failed using the library use the internal mechanism
    if CsaDLLIdentifier <> 0 then
    begin
      // 'Normal' CSA
      SetKeyProc := GetProcAddress(CsaDLLIdentifier, 'set_cws');
      CSADecryptProc := GetProcAddress(CsaDLLIdentifier, 'decrypt');
      // FFDeCSA
      FFSetKeyProc := GetProcAddress(CsaDLLIdentifier, 'set_control_words');
      FFDecryptProc := GetProcAddress(CsaDLLIdentifier, 'decrypt_packets');
      FFKeySizeProc := GetProcAddress(CsaDLLIdentifier, 'get_keyset_size');
      FFParallelismProc := GetProcAddress(CsaDLLIdentifier, 'get_parallelism');
      if Assigned(@FFSetKeyProc) and Assigned(@FFDecryptProc) and
        Assigned(@FFKeySizeProc) and Assigned(@FFParallelismProc) then
      begin
        CsaMethod := cmFfCsa;
        FFCsaKeySize := FFKeySizeProc;
        GetMem(FFCsaKeys, FFCsaKeySize);
      end
      else if Assigned(@SetKeyProc) and Assigned(@CSADecryptProc) then
        CsaMethod := cmCsa
      else
      begin
        // Invalid DLL, use internal
        FreeLibrary(CsaDLLIdentifier);
        CsaMethod := cmInternal;
        DllName := '';
      end;
    end
    else
    begin
      // Invalid DLL, use internal
      CsaMethod := cmInternal;
      DllName := '';
    end;
  end;
  CsaName := DllName;
  case CsaMethod of
    cmNone: ToLog('Using no CSA mechanism.', $81);
    cmInternal: ToLog('Using internal CSA mechanism.', $81);
    cmCsa: ToLog(format('Using external CSA mechanism: %s.', [CsaName]), $81);
    cmFfCsa: ToLog(format('Using external FFDeCSA mechanism: %s.', [CsaName]),
        $81)
  end;
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>   Form with setup parameters
            <ForceWrite>  True forces update
  Returns : -

  Descript: Write miscellaneous setup parameters (only if they have changed)
  Notes   : Also updates global settings
 ------------------------------------------------------------------------------}

procedure GetAndWriteMiscellaneousSetup(SetupForm: TfrmSetupMiscellaneous;
  ForceWrite: Boolean);
var
  FontN: array[0..31] of Char;
begin
  if not Assigned(SetupForm) then
    Exit;
  if SetupForm.SettingChanged or ForceWrite then
  begin
    IniFile.WriteString('Interface', 'CSA', SetupForm.Csa);
    if LowerCase(CsaName) <> LowerCase(SetupForm.Csa) then
      SetupCsaMechanism(SetupForm.Csa);
    LogLevel := SetupForm.LogLevel;
    IniFile.WriteString('Debug', 'LogLevel', format('%d', [LogLevel]));
    LogClear := SetupForm.LogClear;
    if LogClear then
      IniFIle.WriteString('Debug', 'LogClear', 'Yes')
    else
      IniFIle.WriteString('Debug', 'LogClear', 'No');
    PreferredLanguage := SetupForm.PreferredLanguage;
    IniFile.WriteString('Interface', 'PreferredLanguage', PreferredLanguage);
    AlwaysUpdateProgram := SetupForm.AlwaysUpdateProgram;
    if AlwaysUpdateProgram then
      IniFile.WriteString('Interface', 'AlwaysUpdateProgram', 'Yes')
    else
      IniFile.WriteString('Interface', 'AlwaysUpdateProgram', 'No');
    KeySwapUpDown := SetupForm.KeySwapUpDown;
    if KeySwapUpDown then
      IniFile.WriteString('Interface', 'KeySwapUpDown', 'Yes')
    else
      IniFile.WriteString('Interface', 'KeySwapUpDown', 'No');
    // Check for changing font parameters
    if (SetupForm.FontName <> FontName) or (SetupForm.FontSize <> FontSize) then
    begin
      // If there was a special font assigned, remove it
      if FontName <> '' then
      begin
        StrpCopy(FontN, FontName + '.TTF');
        RemoveFontResource(FontN);
        SendMessage(HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
      end;
      FontName := SetupForm.FontName;
      IniFile.WriteString('Interface', 'FontName', FontName);
      FontSize := SetupForm.FontSize;
      IniFile.WriteString('Interface', 'FontSize', format('%d', [FontSize]));
      if FontName <> '' then
      begin
        StrpCopy(FontN, FontName + '.TTF');
        AddFontResource(FontN);
        SendMessage(HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
      end;
    end;
    FontNameEpg := SetupForm.FontNameEpg;
    IniFile.WriteString('Interface', 'FontNameEpg', FontNameEpg);
    FontSizeEpg := SetupForm.FontSizeEpg;
    IniFile.WriteString('Interface', 'FontSizeEpg', format('%d',
      [FontSizeEpg]));
    EpgHeight := SetupForm.EpgHeight;
    IniFile.WriteString('Interface', 'EPGHeight', format('%d', [EpgHeight]));
    // Time correction
    TimeCorrectionGmt := SetupForm.TimeCorrectionGmt;
    if TimeCorrectionGmt then
      IniFile.WriteString('Interface', 'TimeCorrectionGmt', 'Yes')
    else
      IniFile.WriteString('Interface', 'TimeCorrectionGmt', 'No');
    TimeCorrection := SetupForm.TimeCorrection;
    if TimeCorrection < 0 then
      IniFile.WriteString('Interface', 'TimeCorrection',
        FormatDateTime('"-"HH":"MM":"SS', -TimeCorrection))
    else
      IniFile.WriteString('Interface', 'TimeCorrection',
        FormatDateTime('HH":"MM":"SS', TimeCorrection));
    TimeCorrectionPreRecord := SetupForm.TimeCorrectionPreRecord;
    if TimeCorrectionPreRecord < 0 then
      IniFile.WriteString('Interface', 'TimeCorrectionPreRecord',
        FormatDateTime('"-"HH":"MM":"SS', -TimeCorrectionPreRecord))
    else
      IniFile.WriteString('Interface', 'TimeCorrectionPreRecord',
        FormatDateTime('HH":"MM":"SS', TimeCorrectionPreRecord));
    TimeCorrectionPostRecord := SetupForm.TimeCorrectionPostRecord;
    if TimeCorrectionPostRecord < 0 then
      IniFile.WriteString('Interface', 'TimeCorrectionPostRecord',
        FormatDateTime('"-"HH":"MM":"SS', -TimeCorrectionPostRecord))
    else
      IniFile.WriteString('Interface', 'TimeCorrectionPostRecord',
        FormatDateTime('HH":"MM":"SS', TimeCorrectionPostRecord));
    MdPluginPassFullPacket := SetupForm.MdPluginPassFullPacket;
    IniFile.WriteString('Interface', 'MdPluginPassFullPacket',
      MdPluginPassFullPacket);
    MdPluginAllowSetPids := SetupForm.MdPluginAllowSetPids;
    if MdPluginAllowSetPids then
      IniFile.WriteString('Interface', 'MdPluginAllowSetPids', 'Yes')
    else
      IniFile.WriteString('Interface', 'MdPluginAllowSetPids', 'No');
    DisplayDuringRecording := SetupForm.DisplayDuringRecording;
    if DisplayDuringRecording then
      IniFile.WriteString('Interface', 'DisplayDuringRecording', 'Yes')
    else
      IniFile.WriteString('Interface', 'DisplayDuringRecording', 'No');
    RecordingDirectory := SetupForm.RecordingDirectory;
    IniFile.WriteString('Interface', 'RecordingDirectory', RecordingDirectory);
    RecordingInfoFile := SetupForm.RecordingInfoFile;
    if RecordingInfoFile then
      IniFile.WriteString('Interface', 'RecordingInfoFile', 'Yes')
    else
      IniFile.WriteString('Interface', 'RecordingInfoFile', 'No');
    if SetupForm.RecordingSplitSize > 4000 then
    begin
      RecordingSplitted := False;
      IniFile.WriteString('Interface', 'RecordingSplitSize', '9999');
    end
    else
    begin
      RecordingSplitted := True;
      RecordingSplitSize := SetupForm.RecordingSplitSize;
      RecordingSplitSize := RecordingSplitSize * 1000000;
      IniFile.WriteString('Interface', 'RecordingSplitSize', format('%d',
        [SetupForm.RecordingSplitSize]));
    end;
    TimeCorrectionParameters := SetupForm.TimeCorrectionParameters;
    if TimeCorrectionParameters < 0 then
      IniFile.WriteString('Interface', 'TimeCorrectionParameters',
        FormatDateTime('"-"HH":"MM":"SS', -TimeCorrectionParameters))
    else
      IniFile.WriteString('Interface', 'TimeCorrectionParameters',
        FormatDateTime('HH":"MM":"SS', TimeCorrectionParameters));
    TimeoutNumericalKeys := SetupForm.TimeoutNumericalKeys;
    IniFile.WriteString('Interface', 'TimeoutNumericalKeys', format('%d',
      [TimeoutNumericalKeys]));
    TimeoutNumericalKeysRemote := SetupForm.TimeoutNumericalKeysRemote;
    IniFile.WriteString('Interface', 'TimeoutNumericalKeysRemote', format('%d',
      [TimeoutNumericalKeysRemote]));
    // Actual timeout is about 10 times smaller (because of state machine)
    TimeoutNumericalKeys := TimeoutNumericalKeys div 10;
    TimeoutNumericalKeysRemote := TimeoutNumericalKeysRemote div 10;
    AutoContinueOnException := SetupForm.AutoContinueOnException;
    if AutoContinueOnException then
      IniFile.WriteString('Debug', 'AutoContinueOnException', 'Yes')
    else
      IniFile.WriteString('Debug', 'AutoContinueOnException', 'No');
    if AutoContinueOnException then
    begin
      MESettings.AutoContinue     := True;
//      MESettings.ShowExceptionBox := False;
    end
    else
    begin
      MESettings.AutoContinue     := False;
//      MESettings.ShowExceptionBox := True;
    end;
    FreezeTimeout := SetupForm.FreezeTimeout;
    IniFile.WriteString('Debug', 'FreezeTimeout', format('%d',
      [FreezeTimeout]));
    MadExcept.SetFreezeTimeout(FreezeTimeout);
    IniFile.UpdateFile;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Read miscellaneous setup parameters
  Notes   :
 ------------------------------------------------------------------------------}

procedure ReadMiscellaneousSetup;
var
  Parameter: string;
  CheckString: string;
  Error: Integer;
  Negative: Boolean;
begin
  // SoftCSA
  CsaName := LowerCase(GetParameter('Interface', 'CSA', ''));
  SetupCsaMechanism(CsaName);
  // Log level
  Parameter := GetParameter('Debug', 'LogLevel', '0');
  Val(Parameter, LogLevel, Error);
  if Error <> 0 then
    LogLevel := 0;
  Parameter := GetParameter('Debug', 'LogClear', 'Yes');
  if LowerCase(Parameter) = 'no' then
    LogClear := False
  else
    LogClear := True;
  PreferredLanguage := LowerCase(GetParameter('Interface', 'PreferredLanguage',
    ''));
  CheckString := LowerCase(GetParameter('Interface', 'AlwaysUpdateProgram',
    'No'));
  if CheckString = 'yes' then
    AlwaysUpdateProgram := True
  else
    AlwaysUpdateProgram := False;
  CheckString := LowerCase(GetParameter('Interface', 'KeySwapUpDown', 'No'));
  if CheckString = 'yes' then
    KeySwapUpDown := True
  else
    KeySwapUpDown := False;
  // Font
  FontName := GetParameter('Interface', 'FontName', '');
  Parameter := GetParameter('Interface', 'FontSize', '8');
  if Parameter <> '' then
  begin
    Val(Parameter, FontSize, Error);
    if Error <> 0 then
      FontSize := 8;
  end;
  FontNameEpg := GetParameter('Interface', 'FontNameEpg', '');
  Parameter := GetParameter('Interface', 'FontSizeEpg', '8');
  if Parameter <> '' then
  begin
    Val(Parameter, FontSizeEpg, Error);
    if Error <> 0 then
      FontSizeEpg := 8;
  end;
  CheckString := LowerCase(GetParameter('Interface', 'EPGHeight', '72'));
  Val(CheckString, EpgHeight, Error);
  if Error <> 0 then
    EpgHeight := 72;

  // Time correction
  CheckString := LowerCase(GetParameter('Interface', 'TimeCorrectionGmt',
    'Yes'));
  if CheckString = 'yes' then
    TimeCorrectionGmt := True
  else
    TimeCorrectionGmt := False;
  CheckString := LowerCase(GetParameter('Interface', 'TimeCorrection', '00' +
    TimeSeparator + '00' + TimeSeparator + '00'));
  // First check for any negative values we need to remove
  Negative := False;
  CheckString := Trim(CheckString);
  if CheckString <> '' then
  begin
    case Ord(CheckString[1]) of
      Ord('-'):
        begin
          CheckString := Copy(CheckString, 2, 255);
          Negative := True;
        end;
      Ord('+'): CheckString := Copy(CheckString, 2, 255);
    end;
  end;
  try
    CheckString := ChangeTimeSeparator(CheckString);
    TimeCorrection := StrToTime(CheckString);
  except
    TimeCorrection := StrToTime('00' + TimeSeparator + '00' + TimeSeparator +
      '00');
  end;
  if Negative then
    TimeCorrection := -TimeCorrection;

  CheckString := LowerCase(GetParameter('Interface', 'TimeCorrectionPreRecord',
    '00' + TimeSeparator + '00' + TimeSeparator + '00'));
  // First check for any negative values we need to remove
  Negative := False;
  CheckString := Trim(CheckString);
  if CheckString <> '' then
  begin
    case Ord(CheckString[1]) of
      Ord('-'):
        begin
          CheckString := Copy(CheckString, 2, 255);
          Negative := True;
        end;
      Ord('+'): CheckString := Copy(CheckString, 2, 255);
    end;
  end;
  try
    CheckString := ChangeTimeSeparator(CheckString);
    TimeCorrectionPreRecord := StrToTime(CheckString);
  except
    TimeCorrectionPreRecord := StrToTime('00' + TimeSeparator + '00' +
      TimeSeparator + '00');
  end;
  if Negative then
    TimeCorrectionPreRecord := -TimeCorrectionPreRecord;

  CheckString := LowerCase(GetParameter('Interface', 'TimeCorrectionPostRecord',
    '00' + TimeSeparator + '00' + TimeSeparator + '00'));
  // First check for any negative values we need to remove
  Negative := False;
  CheckString := Trim(CheckString);
  if CheckString <> '' then
  begin
    case Ord(CheckString[1]) of
      Ord('-'):
        begin
          CheckString := Copy(CheckString, 2, 255);
          Negative := True;
        end;
      Ord('+'): CheckString := Copy(CheckString, 2, 255);
    end;
  end;
  try
    CheckString := ChangeTimeSeparator(CheckString);
    TimeCorrectionPostRecord := StrToTime(CheckString);
  except
    TimeCorrectionPostRecord := StrToTime('00' + TimeSeparator + '00' +
      TimeSeparator + '00');
  end;
  if Negative then
    TimeCorrectionPostRecord := -TimeCorrectionPostRecord;

  CheckString := LowerCase(GetParameter('Interface', 'TimeCorrectionParameters',
    '00' + TimeSeparator + '00' + TimeSeparator + '00'));
  // First check for any negative values we need to remove
  Negative := False;
  CheckString := Trim(CheckString);
  if CheckString <> '' then
  begin
    case Ord(CheckString[1]) of
      Ord('-'):
        begin
          CheckString := Copy(CheckString, 2, 255);
          Negative := True;
        end;
      Ord('+'): CheckString := Copy(CheckString, 2, 255);
    end;
  end;
  try
    CheckString := ChangeTimeSeparator(CheckString);
    TimeCorrectionParameters := StrToTime(CheckString);
  except
    TimeCorrectionParameters := StrToTime('00' + TimeSeparator + '00' +
      TimeSeparator + '00');
  end;
  if Negative then
    TimeCorrectionParameters := -TimeCorrectionParameters;

  //  MdPluginDoNotFreeLibrary := LowerCase(GetParameter('Interface', 'MdPluginDoNotFreeLibrary', ''));
  MdPluginPassFullPacket := LowerCase(GetParameter('Interface',
    'MdPluginPassFullPacket', ''));
  CheckString := LowerCase(GetParameter('Interface', 'MdPluginAllowSetPids',
    'No'));
  if CheckString = 'yes' then
    MdPluginAllowSetPids := True
  else
    MdPluginAllowSetPids := False;
  // DisplayDuringRecording setting
  CheckString := LowerCase(GetParameter('Interface', 'DisplayDuringRecording',
    'Yes'));
  if CheckString = 'yes' then
    DisplayDuringRecording := True
  else
    DisplayDuringRecording := False;
  // Recording settings
  RecordingDirectory := LowerCase(GetParameter('Interface',
    'RecordingDirectory',
    ''));
  CheckString := LowerCase(GetParameter('Interface', 'RecordingInfoFile',
    'Yes'));
  if CheckString = 'yes' then
    RecordingInfoFile := True
  else
    RecordingInfoFile := False;
  // Split size recordings
  Parameter := GetParameter('Interface', 'RecordingSplitSize', '9999');
  Val(Parameter, RecordingSplitSize, Error);
  if Error <> 0 then
  begin
    RecordingSplitted := False;
    RecordingSplitSize := 4000000000;
  end
  else
  begin
    if RecordingSplitSize > 4000 then
    begin
      RecordingSplitted := False;
      RecordingSplitSize := 4000000000;
    end
    else
    begin
      RecordingSplitted := True;
      RecordingSplitSize := RecordingSplitSize * 1000000;
    end
  end;

  // Timeout values
  Parameter := GetParameter('Interface', 'TimeoutNumericalKeys', '500');
  Val(Parameter, TimeoutNumericalKeys, Error);
  if Error <> 0 then
    TimeoutNumericalKeys := 500;
  Parameter := GetParameter('Interface', 'TimeoutNumericalKeysRemote', '1000');
  Val(Parameter, TimeoutNumericalKeysRemote, Error);
  if Error <> 0 then
    TimeoutNumericalKeysRemote := 1000;
  // Actual timeout is about 10 times smaller (because of state machine)
  TimeoutNumericalKeys := TimeoutNumericalKeys div 10;
  TimeoutNumericalKeysRemote := TimeoutNumericalKeysRemote div 10;
  Parameter := GetParameter('Debug', 'AutoContinueOnException', 'No');
  if LowerCase(Parameter) = 'no' then
    AutoContinueOnException := False
  else
    AutoContinueOnException := True;
  if AutoContinueOnException then
  begin
      MESettings.AutoContinue     := True;
//      MESettings.ShowExceptionBox := False;
  end
  else
  begin
      MESettings.AutoContinue     := False;
//      MESettings.ShowExceptionBox := True;
  end;
  Parameter := GetParameter('Debug', 'FreezeTimeout', '30');
  Val(Parameter, FreezeTimeout, Error);
  if Error <> 0 then
    FreezeTimeout := 30;
  MadExcept.SetFreezeTimeout(FreezeTimeout);
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>  Form with setup parameters
  Returns : -

  Descript: Set remote setup parameters from global settings
  Notes   :
 ------------------------------------------------------------------------------}

procedure SetRemoteSetup(SetupForm: TfrmSetupRemote);
var
  RemoteList: TStringList;
  Parameter: string;
  Loop: Integer;
begin
  if not Assigned(SetupForm) then
    Exit;
  RemoteList := TStringList.Create;
  try
    IniFile.ReadSection('Remote', RemoteList);
    if RemoteList.Count > 0 then
      for Loop := 0 to RemoteList.Count - 1 do
      begin
        Parameter := IniFile.ReadString('Remote', RemoteList[Loop], '');
        SetupForm.Setting[Loop] := RemoteList[Loop] + '=' + Parameter;
      end;
  finally
    RemoteList.Free;
  end;
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>   Form with setup parameters
            <ForceWrite>  True forces update
  Returns : -

  Descript: Write remote setup parameters (only if they have changed)
  Notes   : Also updates global settings
 ------------------------------------------------------------------------------}

procedure GetAndWriteRemoteSetup(SetupForm: TfrmSetupRemote; ForceWrite:
  Boolean);
var
  RemoteList: TStringList;
  Loop: Integer;
  Setting: ShortString;
begin
  if not Assigned(SetupForm) then
    Exit;
  if SetupForm.SettingChanged or ForceWrite then
  begin
    RemoteList := TStringList.Create;
    try
      IniFile.ReadSection('Remote', RemoteList);
      // Remove ALL entries. We use this instead of erasing the section since this
      // is not always handled correctly. We also retain any single line comments
      // this way, although the position may change
      if RemoteList.Count > 0 then
        for Loop := 0 to RemoteList.Count - 1 do
          IniFile.DeleteKey('Remote', RemoteList[Loop]);
      // Just in case
      IniFile.UpdateFile;
    finally
      RemoteList.Free;
    end;
    Loop := 0;
    repeat
      Setting := SetupForm.Setting[Loop];
      Inc(Loop);
      if Setting <> '' then
        IniFile.WriteString('Remote', Copy(Setting, 1, 7), Copy(Setting, 9,
          255));
    until Setting = '';
    IniFile.UpdateFile;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Read remote setup parameters
  Notes   :
 ------------------------------------------------------------------------------}

procedure ReadRemoteSetup;
begin
  // Runtime read from INI so not necessary
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>  Form with setup parameters
  Returns : <Result>     True if parameters available

  Descript: Set recording setup parameters from global settings
  Notes   :
 ------------------------------------------------------------------------------}

function SetRecordings(SetupForm: TfrmRecording): Boolean;
var
  Loop: Integer;
  Index: Integer;
  Setting: ShortString;
begin
  Result := False;
  if not Assigned(SetupForm) then
    Exit;
  Index := 0;
  for Loop := Low(RecordItems) to High(RecordItems) do
    if RecordItems[Loop].Active then
    begin
      // Sanity check on RecordId - if we were recording it might have been stopped
      // while we were not 'looking'. Just check if it is still in use ...
      if RecordItems[Loop].RecordId <= High(RecordingPids) then
        if RecordingPids[RecordItems[Loop].RecordId].Pid = $FFFF then
          RecordItems[Loop].RecordId := $FF;
      Setting := ConstructRecordingDefinition(RecordItems[Loop]);
      if Setting <> '' then
      begin
        SetupForm.Setting[Index] := Setting;
        Inc(Index);
      end;
    end;
  Result := (Index <> 0);
end;

{------------------------------------------------------------------------------
  Params  : <SetupForm>   Form with setup parameters
            <ForceWrite>  True forces update
  Returns : -

  Descript: 'Write' recording parameters (only if they have changed)
  Notes   :
 ------------------------------------------------------------------------------}

procedure GetAndWriteRecordings(SetupForm: TfrmRecording; ForceWrite: Boolean);
var
  Loop: Integer;
  Index: Integer;
  Index2: Integer;
  Setting: ShortString;
  OrgRecord: TRecordItems;
  StillActive: Boolean;
begin
  if not Assigned(SetupForm) then
    Exit;
  if SetupForm.SettingChanged or ForceWrite then
  begin
    OrgRecord := RecordItems;
    // Remove old recording items (this does not stop any current recording ....,
    // just makes sure it is not used temporarily)
    for Loop := Low(RecordItems) to High(RecordItems) do
      RecordItems[Loop].Active := False;
    Loop := 0;
    Index := Low(RecordItems);
    repeat
      Setting := SetupForm.Setting[Loop];
      Inc(Loop);
      if Setting <> '' then
      begin
        RecordItems[Index] := ExtractFromRecordingDefinition(Setting);
        // If valid, increase index
        if RecordItems[Index].Active then
          Inc(Index);
        if Index > High(RecordItems) then
          Dec(Index);
      end;
    until Setting = '';
    RemoveDuplicateRecordItems(RecordItems);
    RemoveExpiredRecordItems(RecordItems);
    SortRecordItems(RecordItems);
    // Check for any active recordings which are no longer in use (and must be stopped)
    for Index := Low(OrgRecord) to High(OrgRecord) do
      if OrgRecord[Index].Active and (OrgRecord[Index].RecordId <> $FF) then
      begin
        StillActive := False;
        // Recording was active, find if still in list ...
        for Index2 := Low(RecordItems) to High(RecordItems) do
          if RecordItems[Index2].Active and (RecordItems[Index2].RecordId =
            OrgRecord[Index].RecordId) then
            StillActive := True;
        // If removed, stop recording
        if not StillActive then
          frmMain.StopRecording(OrgRecord[Index].RecordId);
      end;
    // Update status
    if not frmMain.RecordingIsActive and (Recording = rtRecording) then
    begin
      Recording := rtStopRecording;
      frmMain.imgRecord3.Visible := False;
      frmMain.imgRecord2.Visible := False;
      frmMain.imgRecord.Visible := True;
    end;
    if OverlappedRecordings(RecordItems) then
      ShowMessage('Overlapped recordings on different transponders detected');
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Read recordings list
  Notes   :
 ------------------------------------------------------------------------------}

procedure ReadRecordings;
var
  RecordingList: TStringList;
  Index: Integer;
  TargetIndex: Integer;
begin
  RecordingList := TStringList.Create;
  try
    TargetIndex := Low(RecordItems);
    IniFile.ReadStrings('Recordings', 'Recordings', RecordingList);
    if RecordingList.Count > 0 then
      for Index := 0 to RecordingList.Count - 1 do
      begin
        RecordItems[TargetIndex] :=
          ExtractFromRecordingDefinition(RecordingList[Index]);
        // If valid set 'not recording' and increase index
        if RecordItems[TargetIndex].Active then
        begin
          RecordItems[TargetIndex].RecordId := $FF;
          RecordItems[TargetIndex].Miscellaneous := 0;
          Inc(TargetIndex);
          if TargetIndex > High(RecordItems) then
            Dec(TargetIndex);
        end;
      end;
    RemoveDuplicateRecordItems(RecordItems);
    RemoveExpiredRecordItems(RecordItems);
    SortRecordItems(RecordItems);
  finally
    RecordingList.Free;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Write recordings list
  Notes   :
 ------------------------------------------------------------------------------}

procedure WriteRecordings;
var
  RecordingList: TStringList;
  Setting: ShortString;
  Loop: Integer;
begin
  RecordingList := TStringList.Create;
  try
    for Loop := Low(RecordItems) to High(RecordItems) do
      if RecordItems[Loop].Active then
      begin
        Setting := ConstructRecordingDefinition(RecordItems[Loop]);
        if Setting <> '' then
          RecordingList.Add(Setting);
      end;
    IniFile.WriteStrings('Recordings', 'Recordings', RecordingList);
  finally
    RecordingList.Free;
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Initialize
  Notes   :
 ------------------------------------------------------------------------------}

procedure Initialize;
var
  BufferId: Dword;
  Index: Integer;
  Parameter: string;
  SetupCard: TfrmSetupCard;
  SetupFiles: TfrmSetupFiles;
  SetupMiscellaneous: TfrmSetupMiscellaneous;
  SetupDirectShow: TfrmSetupDirectShow;
  SetupDiSEqC: TfrmSetupDiSEqC;
  Registry: TRegistry;
  TimeBias: Integer;
  Hours: Integer;
  Minutes: Integer;
  Error  : Integer;
begin
  // Get GMT difference
  TimeCorrectionBias := 0;
  DiSEqCList := TStringList.Create;
  UseFlexCop := False;

  Registry := TRegistry.Create;
  try
    Registry.RootKey := HKEY_LOCAL_MACHINE;
    try
      // Reading might fail if the user does not have sufficient rights
      if
        Registry.OpenKeyReadOnly('SYSTEM\CurrentControlSet\Control\TimeZoneInformation') then
      begin
        // Get time bias in minutes
        TimeBias := Registry.ReadInteger('ActiveTimeBias');
        Hours := TimeBias div 60;
        Minutes := TimeBias mod 60;
        // Convert to TDateTime
        TimeCorrectionBias := EncodeTime(Abs(Hours), Abs(Minutes), 0, 0);
        if TimeBias < 0 then
          TimeCorrectionBias := -TimeCorrectionBias;
      end;
    except
      TimeCorrectionBias := 0;
    end;
  finally
    Registry.Free;
  end;
  if (FindWindow('TAppBuilder', nil) > 0) then // Checks if IDE is opened
    ShowMessage('To do/checkout/thoughts:'#13#13 +
      //Indien 'Transponder' aan staat en individuele recording geselekteerd worden
      //dan gaat 'het' fout -> geen FreeAndNil en 'rec' indikatie verkeerd ....
      //Wel worden individuelel files aangemaakt, waarvan alleen maar een geupdate
      //wordt (andere zijn niet FreeAndNilled

      'TUA6100 support (SU1278 and SU1278/SH2) -> see STV0299.c  -> unable to test'#13 +
      'CU1216 (TDA10021/VES1820) support - DVB-C'#13 +
      'Store event information in info file  -> only for active program possible'#13 +
      'Matroska GStreamer support'#13 +
      'Set of keys for each program, instead globally  -> also needs plugin for each program'#13 +
      'Using INamedBuffer so another app/process can pass on information - or using messages'#13 +
      'Time related bugs - TDateTimePicker.GetTime in WriteSettings?? due to FFCSA'#13 +
      'Testing time with other separator'#13 +
      'Adding messages to start a recording of a specific program (even if already recording)'#13 +
      'Search for program name in list (select by inputting name)'#13 +
      'Runtime debugging window'#13 +
      'Checkout why number of DLLs is restricted - can not use LoadLibrary/FreeLibrary continuously'#13 +
      'Up/down with transponder list as favourite reverts to previous transponder with MOUSE -> looks like PP -> others same problem'#13 +
      'OSD - bitmap with VMR too'#13 +
      'Snapshot'#13 +
      'Client/server'#13 +
      'Specific keys for transponder change'#13 +
      'Sorting of lists'#13 +
      'Volume setting (offset) per channel'#13 +
      'Time correction (offset) per channel'#13 +
      'Disable plugin update of channel so same data is used for next channel'#13 +
      'Tree structure'#13 +
      'Checking retaining transponder list selection and others ...');
  InitializationSuccess := False;
  AppName := '   MajorDVB   -   ';
  ExeDirectory := LowerCase(ExtractFilePath(Application.ExeName));
  UpdateLock := TCriticalSection.Create;
  FilterLock := TCriticalSection.Create;
  StreamLock := TCriticalSection.Create;

  // Because some DirectShow filters don't like being run from within a debugging
  // environment we have to trick them in making them believe we are not debugging.
  // Note that this is only done so we can debug the -application-, not the DirectShow
  // filter .....
  // Only do this if we are started from within the IDE ....
  if (FindWindow('TAppBuilder', nil) > 0) and // Checks if IDE is opened
  (DebugHook <> 0) then // Check integrated debugger active
  begin
    AppName := '  *MajorDVB*  -   ';
    // Make it somewhow visible that we use the trick
    asm
      MOV  EAX, FS:[$00000018]                             // FS:[$00000018] == TIB / TEB  Thread Information Block / Thread Environment Block
      MOV  EAX, DWORD PTR [EAX+$30]                        // Offset $30 has pointer to 'debugger attached' boolean
      MOV  DWORD PTR [EAX], $00000000                      // Set boolean: $00010000 (True) or $00000000 (False)
    end;
  end;

  // Open INI file
  if FileExists(ExeDirectory + 'MajorDvb.ini') then
    IniFile := TFastIniFile.Create(ExeDirectory + 'MajorDvb.ini')
  else
  begin
    IniFile := TFastIniFile.Create(ExeDirectory + 'MajorDvb.ini');
    SetupCard := TfrmSetupCard.Create(Application);
    SetupCard.ShowModal;
    if SetupCard.SettingChanged then
      GetAndWriteCardSetup(SetupCard, True)
    else
    begin
      GetAndWriteCardSetup(SetupCard, True);
      // Force asking for card again later
      IniFile.WriteString('Hardware', 'Card', '');
    end;
    SetupCard.Free;
    SetupDiSEqC := TfrmSetupDiSEqC.Create(Application);
    SetupDiSEqC.ShowModal;
    GetAndWriteDiSEqCSetup(SetupDiSEqC, True);
    SetupDiSEqC.Free;
    SetupFiles := TfrmSetupFiles.Create(Application);
    SetupFiles.ShowModal;
    GetAndWriteFilesSetup(SetupFiles, True);
    SetupFiles.Free;
    SetupMiscellaneous := TfrmSetupMiscellaneous.Create(Application);
    SetupMiscellaneous.ShowModal;
    GetAndWriteMiscellaneousSetup(SetupMiscellaneous, True);
    SetupMiscellaneous.Free;
    SetupDirectShow := TfrmSetupDirectShow.Create(Application);
    SetupDirectShow.ShowModal;
    GetAndWriteDirectShowSetup(SetupDirectShow, True);
    SetupDirectShow.Free;
  end;

  // Default <ItemIndex>
  ServiceNumber := $FFFF;
  Transponder := $FFFF;
  List := $FFFF;
  PidVideo := $FFFF;
  PidAudio := $FFFF;
  PidTeletext := $FFFF;
  PidSubtitle := $FFFF;
  PidEcm := $FFFF;
  NoSignal := 0;
  ChannelSwitchPreTime := EncodeTime(0, 0, 30, 0);

  FiltersOff := True;

  ShutdownOnExit := False;

  // Initialize filters
  for Index := Low(AppFilters.Filters) to High(AppFilters.Filters) do
    AppFilters.Filters[Index].Active := False;
  FilterUpdateCrossReference(@AppFilters);
  MDPlugins := 0;
  for Index := Low(MdPlugin) to High(MdPlugin) do
    MdPlugin[Index].DllIdentifier := 0;
  MdPluginAllowSetPids := False;
  FilterCount := 0;

  // Initialize recording PIDs (all available)
  for Index := Low(RecordingPids) to High(RecordingPids) do
    RecordingPids[Index].Pid := $FFFF;

  TransponderValid := False;
  UpdateProgram := False;
  UpdatePmt := False;
  UpdatePmtCount := 0;
  UpdatePat := False;
  UpdateCat := False;
  UpdateCatCount := 0;
  UpdateEvent := False;
  Scanning := False;
  Recording := rtIdle;
  VideoPacketCount := 0;
  NewChannelSet := False;
  NewTransponderSet := False;
  ShowVideo := True;
  ShowAudio := True;
  ShowAudioVideo := False;
  RecordingRawData := False;
  FilteringOff := False;
  ProcessPids := True;
  IsSlave := False;
  PacketThread := nil;
  RemoteThread := nil;
  CardHandle := INVALID_HANDLE_VALUE;
  CardNoError := False;
  CardInUse := -1;
  CardNumber := -1;
  TSProcessingDone := True;
  FullScreenTimeOut := Now;
  FullScreenInit := 5;
  KeyData := 0;
  VideoScrambled := False;
  VideoIsDescrambled := False;
  AudioScrambled := False;
  AudioIsDescrambled := False;
  EpgHeight := 72;
  TransponderHasChanged := $0000;
  DsAPid := $FFFF;
  DsVPid := $FFFF;
  DsOptions := 0;
  ProgramOptions := $0000;
  Satellite := 0;
  AlwaysUpdateProgram := False;
  OsdTimeout := 0;
  VideoWidth := 0;
  VideoHeight := 0;
  PreferredLanguage := '';
  DiSEqCMini := False;
  TimeStartTime := 0;
  TimeEndTime := 0;
  AutoContinueOnException := False;
  FreezeTimeout := 30;
  RecordingSplitSize := 4000000000;
  RecordingSplitted := False;

  SetKeyProc := nil;
  CSADecryptProc := nil;
  FFSetKeyProc := nil;
  FFDecryptProc := nil;
  FFKeySizeProc := nil;
  FFParallelismProc := nil;
  CsaDllIdentifier := 0;
  RecordingTimerIndex := $FF;

  for Index := Low(RecordItems) to High(RecordItems) do
    RecordItems[Index].Active := False;

  QueryPerformanceFrequency(HighPerformanceFrequency);

{$IFDEF DSBUFFER}
  DsBufferIndex := Low(DsBuffer);
{$ENDIF}
  LogStream := nil;
  RecordingAllFile := nil;
  LogClear := True;

  ReadMiscellaneousSetup;

  if LogLevel in [1..5] then
  begin
    try
      if (not LogClear) and
        FileExists(ExeDirectory + 'Messages.log') then
      begin
        LogStream := TFileStream.Create(ExeDirectory + 'Messages.log',
          fmOpenReadWrite);
        // Go to end of file (we will be appending)
        LogStream.Seek(0, soFromEnd);
      end
      else
        LogStream := TFileStream.Create(ExeDirectory + 'Messages.log',
          fmCreate);
      ToLog('-------------------------------------------------------------',
        $00);
      ToLog(format('MajorDVB V%1.1x.%2.2x, build %x, using log level %d',
        [Version div $100, Version mod $100, Build, LogLevel]), $00);
    except
      FreeAndNil(LogStream);
    end;
  end;

  // Command line after log file so we add the parameters to the debug log
  CommandLineParameters;

  // Check if 'setup' as parameter
  ReadCardSetup;
  if (ParameterSetup <> '') or (DvbCard = '') then
  begin
    // Default to the Nova setting for the dialog
    SetupCard := TfrmSetupCard.Create(Application);
    try
      // Set all settings
      SetCardSetup(SetupCard);
      SetupCard.ShowModal;
      if SetupCard.Accepted and (SetupCard.Card <> 255) then
        GetAndWriteCardSetup(Setupcard, False)
      else
      begin
        if SetupCard.Card = 255 then
        begin
          ShowMessage('You did not set any hardware settings.'#10'Defaulting to no hardware mode.');
          DvbCard := 'None';
        end;
      end;
    finally
      SetupCard.Free;
    end;
  end;

  ReadDiSEqCSetup;

  ReadDirectShowSetup;

  // Get card type (overrules other settings)
  DvbCardPreset := False;
  if (UpperCase(DvbCard) = 'TTPCLINEBUDGET') or
    (UpperCase(DvbCard) = 'NOVA') or
    (UpperCase(DvbCard) = 'SATELCO') then
  begin
    DvbCardPreset := True;
    TunerType := CTunerBSRU6;
    SynthesizerAddress := 1;
    TunerReset := 2;
    LNBPolarity := 0;
    LNBOnOff := 1;
  end;
  if (UpperCase(DvbCard) = 'TTPCLINEBUDGET2') or
    (UpperCase(DvbCard) = 'NOVA2') then
  begin
    DvbCardPreset := True;
    TunerType := CTunerSU1278;
    SynthesizerAddress := 0;
    TunerReset := 2;
    LNBPolarity := 0;
    LNBOnOff := 1;
  end;
  if (UpperCase(DvbCard) = 'TERRATEC') or
    (UpperCase(DvbCard) = 'KNC') or
    (UpperCase(DvbCard) = 'TYPHOON') or
    (UpperCase(DvbCard) = 'ANUBIS') then
  begin
    DvbCardPreset := True;
    TunerType := CTunerSU1278;
    SynthesizerAddress := 1;
    TunerReset := 255;
    LNBPolarity := 1;
    LNBOnOff := 255;
  end;

  if (UpperCase(DvbCard) = 'FLEXCOP') then
  begin
    DvbCardPreset := True;
    SynthesizerAddress := 1;
    UseFlexCop := True;
  end
  else
    UseFlexCop := False;

  if UpperCase(DvbCard) <> 'NONE' then
  begin
    if UseFlexCop then
    begin
      if FlexCopGetNumberOfCards <> 0 then
      begin
        CardHandle := FlexCopCreateFile(CardNumber);
        CardInUse := CardNumber;
        if CardHandle <> INVALID_HANDLE_VALUE then
          CardInUse := FlexCopGetCardOfHandle(CardHandle);
      end;
    end
    else
    begin
      if Saa7146aGetNumberOfCards <> 0 then
      begin
        CardHandle := Saa7146aCreateFile(CardNumber);
        CardInUse := CardNumber;
        if CardHandle <> INVALID_HANDLE_VALUE then
          CardInUse := Saa7146aGetCardOfHandle(CardHandle);
      end;
    end;
  end;

  if CardHandle <> INVALID_HANDLE_VALUE then
  begin
    // Setup data transfer from tuner to memory and initialize tuner
    Buffers := BufferTime;
    if UseFlexCop then
    begin
      if not FlexCopDvbSetupBuffering(CardHandle, True, 0, 0, @IsSlave,
        @Buffers, @BufferId, 0) then
      begin
        ToLog('Buffering setup failed.', $81);
        Exit;
      end;
    end
    else
    begin
      if not DvbSetupBuffering(CardHandle, True, TunerType, TunerReset,
        @IsSlave,
        @Buffers, @BufferId, Rps0Program) then
      begin
        ToLog('Buffering setup failed.', $81);
        Exit;
      end;
    end;
  end;

  // Call these functions so we are sure the tuner specific settings are correct
  if UseFlexCop then
  begin
  end
  else
  begin
    if LNBPolarity <> 255 then
      Saa7146aVerticalPolarityLNB(CardHandle, (LNBPolarity = 0));
    if LNBOnOff <> 255 then
      Saa7146aEnableLNB(CardHandle, (LNBOnOff = 1));
  end;

  // Start the thread which receives notifications
  // Note: The packet and remote thread are resumed in the form create
  PacketThread := TDataThread.Create(True);
  PacketThread.FBufferId := BufferId;
  PacketThread.FPacketBuffers := Buffers;

  if LowerCase(Priority) = 'lowest' then
    PacketThread.Priority := tpLowest;
  if LowerCase(Priority) = 'low' then
    PacketThread.Priority := tpLower;
  if LowerCase(Priority) = 'normal' then
    PacketThread.Priority := tpNormal;
  if LowerCase(Priority) = 'default' then
    PacketThread.Priority := tpHigher;
  if LowerCase(Priority) = 'high' then
    PacketThread.Priority := tpHigher;
  if LowerCase(Priority) = 'highest' then
    PacketThread.Priority := tpHighest;
  if LowerCase(Priority) = 'realtime' then
    PacketThread.Priority := tpTimeCritical;

  // Start the remote control thread (only if master)
  if (not IsSlave) and (not UseFlexCop) then
    RemoteThread := TRcThread.Create(True);

  ReadMiscellaneousSetup;

  // A unique file is created
  Parameter := FormatDateTime('YYYYMMDD"T"HHMMSS', Now) + '.LST';
  TransponderListIniFile := TFastIniFile.Create(ExeDirectory + Parameter);
  InitializationSuccess := True;


  GUDPClient := TIdUDPClient.Create();
  Parameter := GetParameter('UDP', 'Address', '');
  if Parameter <> '' then
  begin
    GUDPClient.Host := Parameter;
    Parameter := GetParameter('UDP', 'Port', '1234');
    Val(Parameter, Index, Error);
    GUDPClient.Port := Index;
    GUDPClient.Connect;
    Parameter := GetParameter('UDP', 'Packets', '50');
    Val(Parameter, Index, Error);
    GUDPLastIndex := Index;
    GUDPIndex := GUDPLastIndex;
    SetLength(GUDPBuffer, CDvbPacketSize * GUDPLastIndex);
    GUDPPointer := @GUDPBuffer[0];
  end;
end;

{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Finalize
  Notes   :
 ------------------------------------------------------------------------------}

procedure Finalize;
var
  Index: Dword;
  Retry: Byte;
  FifoBuffer: TFlexCopFifoTransferBuffer;
begin
  try
    ToLog('Finalizing.', $85);

    if Assigned(DiSEqCList) then
      FreeAndNil(DiSEqCList);

    if Assigned(TransponderListIniFile) then
    begin
      TransponderListIniFile.UpdateFile;
      TransponderListIniFile.Free;
    end;

    // Indicate end of recording
    if Recording <> rtIdle then
    begin
      Recording := rtStopRecording;
      // Allow some time to stop recording
      Index := 0;
      repeat
        Sleep(5);
        Inc(Index);
      until (Index > 100) or (Recording = rtIdle);
    end;

    for Index := Low(RecordingPids) to High(RecordingPids) do
      if Assigned(RecordingPids[Index].RecordingFile) then
        FreeAndNil(RecordingPids[Index].RecordingFile);
    if Assigned(RecordingAllFile) then
      FreeAndNil(RecordingAllFile);

    DvbSetSignallingCallback($0010, INVALID_HANDLE_VALUE, WM_SIGNALLING);

    // Stop remote control thread
    if Assigned(RemoteThread) and
      (not RemoteThread.HasStopped) then // If still running
    begin
      RemoteThread.ProgrammedStop := True;
      RemoteThread.Terminate; // Mark it for termination
      Sleep(20);
      if RemoteThread.Suspended then
        RemoteThread.Resume;
      RemoteThread.WaitFor;
      RemoteThread.Free;
    end;

    // Stop data receiving thread
    try
      if Assigned(PacketThread) and
        (not PacketThread.FHasStopped) then // If still running
      begin
        PacketThread.FProgrammedStop := True;
        PacketThread.Terminate; // Mark it for termination
        if PacketThread.Suspended then
          PacketThread.Resume;
        // If we are waiting for a notification then generate (end) it manually.
        // Note the use of <CardHandle> and NOT <ThreadHandle>. This is because
        // <ThreadHandle> might be 'busy' with a <....WaitForNotification>!
        // Because the thread might not react directly or requires multiple
        // notification we allow for that.
        Retry := 20;
        repeat
          if CardHandle <> INVALID_HANDLE_VALUE then
            if UseFlexCop then
              FlexCopGenerateManualNotification(CardHandle)
            else
              Saa7146aGenerateManualNotification(CardHandle);
          Index := 100;
          repeat
            Sleep(1);
            Dec(Index);
          until PacketThread.FHasStopped or (Index = 0);
          Dec(Retry);
        until PacketThread.FHasStopped or (Retry = 0);
        // If we get here after without successfully terminating then
        // the user must terminate it himselve
        if PacketThread.FHasStopped then
        begin
          PacketThread.WaitFor;
          PacketThread.Free;
        end
        else
          ShowMessage('Could not terminate application for some reason. Please use TaskManager to terminate the application manually.');
      end;
    except
    end;

    // Since the thread is no longer executing we can also remove the plugins
    if CsaDLLIdentifier <> 0 then
    begin
      FreeLibrary(CsaDLLIdentifier);
      if CsaMethod = cmFfCsa then
        FreeMem(FFCsaKeys, FFCsaKeySize);
    end;

    if CardHandle <> INVALID_HANDLE_VALUE then
    begin
      // Software reset. We migth be capturing data, so stop ALL
      if not IsSlave then
      begin
        if UseFlexCop then
        begin
          FlexCopWriteToFlexCopRegister(CardHandle, CFlexCopEnable, 0);
          // Clear pending interrupt(s)
          FlexCopReadFromFlexCopRegister(CardHandle, CFlexCopEnable, Index);
          // Disable power to LNB
          FlexCopDisableLNB(CardHandle);
          // Pseudo reset
          FlexCopWriteToFlexCopRegister(CardHandle, CFlexCopSpecials,
            CFlexCopSpecialReset);
          // Release FIFO allocated memory
          FifoBuffer.Identifier := -1;
          FlexCopReleaseFifo(CardHandle, FifoBuffer);
          // Release DMA allocated memory
          Index := 0;
          while FlexCopReleaseDma(CardHandle, Index) do
            Inc(Index);
          FlexCopCloseHandle(CardHandle);
        end
        else
        begin
          Saa7146aWriteToSaa7146aRegister(CardHandle,
            CSaa7146aMc1, CSaa7146aMc1SoftReset);
          // Release all allocated memory by the driver
          Index := 0;
          while Saa7146aReleaseDma(CardHandle, Index) do
            Inc(Index);
          if LNBOnOff <> 255 then
            Saa7146aDisableLNB(CardHandle, (LNBOnOff = 1));
          Saa7146aCloseHandle(CardHandle);
        end;
      end;
    end;
    CardHandle := INVALID_HANDLE_VALUE;
    FilterLock.Free;
    UpdateLock.Free;
    StreamLock.Free;
    if Assigned(LogStream) then
      FreeAndNil(LogStream);
    if Assigned(IniFile) then
    begin
      // We MUST use <UpdateFile> otherwise it is never written
      IniFile.UpdateFile;
      FreeAndNil(IniFile);
    end;
    if ShutdownOnExit then
      Shutdown;
    // Remove DirectX log file (from 'usrc.ax' that is)
    SysUtils.DeleteFile(ExeDirectory + 'log.log'#0);

    GUDPClient.Free;
    GUDPBuffer := nil;
  except
  end;
end;

initialization
  Initialize;

finalization
  Finalize;
end.

